/* bazquxAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from bazquxAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "bazqux.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <json-glib/json-glib.h>
#include <gee.h>
#include <gio/gio.h>

enum  {
	FEED_READER_BAZQUX_API_0_PROPERTY,
	FEED_READER_BAZQUX_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_bazqux_api_properties[FEED_READER_BAZQUX_API_NUM_PROPERTIES];
#define _feed_reader_bazqux_connection_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_bazqux_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _feed_reader_bazqux_message_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_bazqux_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FeedReaderbazquxAPIPrivate {
	FeedReaderbazquxConnection* m_connection;
	FeedReaderbazquxUtils* m_utils;
	gchar* m_userID;
};

static gint FeedReaderbazquxAPI_private_offset;
static gpointer feed_reader_bazqux_api_parent_class = NULL;
static GType feed_reader_bazqux_api_type_id = 0;

static gboolean feed_reader_bazqux_api_getUserID (FeedReaderbazquxAPI* self);
static void feed_reader_bazqux_api_finalize (GObject * obj);

static inline gpointer
feed_reader_bazqux_api_get_instance_private (FeedReaderbazquxAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderbazquxAPI_private_offset);
}

static GType
feed_reader_bazqux_api_bazqux_subscription_action_get_type_once (void)
{
	static const GEnumValue values[] = {{FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_EDIT, "FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_EDIT", "edit"}, {FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_SUBSCRIBE, "FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_SUBSCRIBE", "subscribe"}, {FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_UNSUBSCRIBE, "FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_UNSUBSCRIBE", "unsubscribe"}, {0, NULL, NULL}};
	GType feed_reader_bazqux_api_bazqux_subscription_action_type_id;
	feed_reader_bazqux_api_bazqux_subscription_action_type_id = g_enum_register_static ("FeedReaderbazquxAPIbazquxSubscriptionAction", values);
	return feed_reader_bazqux_api_bazqux_subscription_action_type_id;
}

GType
feed_reader_bazqux_api_bazqux_subscription_action_get_type (void)
{
	static volatile gsize feed_reader_bazqux_api_bazqux_subscription_action_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_bazqux_api_bazqux_subscription_action_type_id__once)) {
		GType feed_reader_bazqux_api_bazqux_subscription_action_type_id;
		feed_reader_bazqux_api_bazqux_subscription_action_type_id = feed_reader_bazqux_api_bazqux_subscription_action_get_type_once ();
		g_once_init_leave (&feed_reader_bazqux_api_bazqux_subscription_action_type_id__once, feed_reader_bazqux_api_bazqux_subscription_action_type_id);
	}
	return feed_reader_bazqux_api_bazqux_subscription_action_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderbazquxAPI*
feed_reader_bazqux_api_construct (GType object_type,
                                  FeedReaderbazquxUtils* utils)
{
	FeedReaderbazquxAPI * self = NULL;
	FeedReaderbazquxUtils* _tmp0_;
	FeedReaderbazquxConnection* _tmp1_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderbazquxAPI*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = feed_reader_bazqux_connection_new (utils);
	_feed_reader_bazqux_connection_unref0 (self->priv->m_connection);
	self->priv->m_connection = _tmp1_;
	return self;
}

FeedReaderbazquxAPI*
feed_reader_bazqux_api_new (FeedReaderbazquxUtils* utils)
{
	return feed_reader_bazqux_api_construct (FEED_READER_TYPE_BAZQUX_API, utils);
}

FeedReaderLoginResponse
feed_reader_bazqux_api_login (FeedReaderbazquxAPI* self)
{
	FeedReaderbazquxUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_bazqux_utils_getAccessToken (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		FeedReaderLoginResponse _result_ = 0;
		FeedReaderbazquxConnection* _tmp4_;
		_tmp4_ = self->priv->m_connection;
		_result_ = feed_reader_bazqux_connection_getToken (_tmp4_);
		if (feed_reader_bazqux_api_getUserID (self)) {
			result = _result_;
			return result;
		}
	} else {
		if (feed_reader_bazqux_api_getUserID (self)) {
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			return result;
		}
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	return result;
}

gboolean
feed_reader_bazqux_api_ping (FeedReaderbazquxAPI* self)
{
	FeedReaderbazquxConnection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	result = feed_reader_bazqux_connection_ping (_tmp0_);
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
feed_reader_bazqux_api_getUserID (FeedReaderbazquxAPI* self)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderResponse response = {0};
	FeedReaderbazquxConnection* _tmp2_;
	FeedReaderbazquxMessage* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse _tmp6_ = {0};
	FeedReaderResponse _tmp7_;
	FeedReaderResponse _tmp8_;
	JsonParser* parser = NULL;
	JsonParser* _tmp9_;
	JsonObject* root = NULL;
	JsonParser* _tmp16_;
	JsonNode* _tmp17_;
	JsonObject* _tmp18_;
	JsonObject* _tmp19_;
	JsonObject* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	feed_reader_logger_debug ("getUserID: getting user info");
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = msg;
	_tmp4_ = feed_reader_bazqux_message_get (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_bazqux_connection_send_get_request (_tmp2_, "user-info", _tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	response = _tmp7_;
	_tmp8_ = response;
	if (_tmp8_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	_tmp9_ = json_parser_new ();
	parser = _tmp9_;
	{
		JsonParser* _tmp10_;
		FeedReaderResponse _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = parser;
		_tmp11_ = response;
		_tmp12_ = _tmp11_.data;
		json_parser_load_from_data (_tmp10_, _tmp12_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getUserID: Could not load message response");
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		feed_reader_logger_error (_tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = parser;
	_tmp17_ = json_parser_get_root (_tmp16_);
	_tmp18_ = json_node_get_object (_tmp17_);
	_tmp19_ = _json_object_ref0 (_tmp18_);
	root = _tmp19_;
	_tmp20_ = root;
	if (json_object_has_member (_tmp20_, "userId")) {
		JsonObject* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		FeedReaderbazquxUtils* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp21_ = root;
		_tmp22_ = json_object_get_string_member (_tmp21_, "userId");
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (self->priv->m_userID);
		self->priv->m_userID = _tmp23_;
		_tmp24_ = self->priv->m_utils;
		_tmp25_ = self->priv->m_userID;
		feed_reader_bazqux_utils_setUserID (_tmp24_, _tmp25_);
		_tmp26_ = self->priv->m_userID;
		_tmp27_ = g_strconcat ("bazqux: userID = ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		feed_reader_logger_info (_tmp28_);
		_g_free0 (_tmp28_);
		result = TRUE;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	result = FALSE;
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_bazqux_message_unref0 (msg);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

gboolean
feed_reader_bazqux_api_getFeeds (FeedReaderbazquxAPI* self,
                                 GeeList* feeds)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderResponse response = {0};
	FeedReaderbazquxConnection* _tmp2_;
	FeedReaderbazquxMessage* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse _tmp6_ = {0};
	FeedReaderResponse _tmp7_;
	FeedReaderResponse _tmp8_;
	FeedReaderResponse _tmp9_;
	const gchar* _tmp10_;
	JsonParser* parser = NULL;
	JsonParser* _tmp11_;
	JsonObject* root = NULL;
	JsonParser* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	JsonArray* array = NULL;
	JsonObject* _tmp22_;
	JsonArray* _tmp23_;
	JsonArray* _tmp24_;
	guint length = 0U;
	JsonArray* _tmp25_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = msg;
	_tmp4_ = feed_reader_bazqux_message_get (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_bazqux_connection_send_get_request (_tmp2_, "subscription/list", _tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	response = _tmp7_;
	_tmp8_ = response;
	if (_tmp8_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	_tmp9_ = response;
	_tmp10_ = _tmp9_.data;
	feed_reader_logger_debug (_tmp10_);
	_tmp11_ = json_parser_new ();
	parser = _tmp11_;
	{
		JsonParser* _tmp12_;
		FeedReaderResponse _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = parser;
		_tmp13_ = response;
		_tmp14_ = _tmp13_.data;
		json_parser_load_from_data (_tmp12_, _tmp14_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getFeeds: Could not load message response");
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		feed_reader_logger_error (_tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	_tmp18_ = parser;
	_tmp19_ = json_parser_get_root (_tmp18_);
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = _json_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp22_ = root;
	_tmp23_ = json_object_get_array_member (_tmp22_, "subscriptions");
	_tmp24_ = _json_array_ref0 (_tmp23_);
	array = _tmp24_;
	_tmp25_ = array;
	length = json_array_get_length (_tmp25_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp28_;
				JsonObject* _tmp29_;
				JsonObject* _tmp30_;
				gchar* feedID = NULL;
				JsonObject* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				const gchar* _tmp34_ = NULL;
				JsonObject* _tmp35_;
				gchar* url = NULL;
				gchar* _tmp40_;
				gchar* icon_url = NULL;
				JsonObject* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				guint catCount = 0U;
				JsonObject* _tmp44_;
				JsonArray* _tmp45_;
				GeeArrayList* categories = NULL;
				GeeArrayList* _tmp46_;
				const gchar* _tmp54_;
				JsonObject* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				GeeArrayList* _tmp58_;
				const gchar* _tmp59_;
				JsonObject* _tmp60_;
				const gchar* _tmp61_;
				FeedReaderFeed* _tmp62_;
				FeedReaderFeed* _tmp63_;
				if (!_tmp26_) {
					guint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp28_ = array;
				_tmp29_ = json_array_get_object_element (_tmp28_, i);
				_tmp30_ = _json_object_ref0 (_tmp29_);
				object = _tmp30_;
				_tmp31_ = object;
				_tmp32_ = json_object_get_string_member (_tmp31_, "id");
				_tmp33_ = g_strdup (_tmp32_);
				feedID = _tmp33_;
				_tmp35_ = object;
				if (json_object_has_member (_tmp35_, "htmlUrl")) {
					JsonObject* _tmp36_;
					const gchar* _tmp37_;
					_tmp36_ = object;
					_tmp37_ = json_object_get_string_member (_tmp36_, "htmlUrl");
					_tmp34_ = _tmp37_;
				} else {
					JsonObject* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = object;
					_tmp39_ = json_object_get_string_member (_tmp38_, "url");
					_tmp34_ = _tmp39_;
				}
				_tmp40_ = g_strdup (_tmp34_);
				url = _tmp40_;
				_tmp41_ = object;
				_tmp42_ = json_object_get_string_member (_tmp41_, "iconUrl");
				_tmp43_ = g_strdup (_tmp42_);
				icon_url = _tmp43_;
				_tmp44_ = object;
				_tmp45_ = json_object_get_array_member (_tmp44_, "categories");
				catCount = json_array_get_length (_tmp45_);
				_tmp46_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				categories = _tmp46_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp47_ = FALSE;
						_tmp47_ = TRUE;
						while (TRUE) {
							GeeArrayList* _tmp49_;
							JsonObject* _tmp50_;
							JsonArray* _tmp51_;
							JsonObject* _tmp52_;
							const gchar* _tmp53_;
							if (!_tmp47_) {
								guint _tmp48_;
								j = j + 1;
								_tmp48_ = j;
							}
							_tmp47_ = FALSE;
							if (!(j < catCount)) {
								break;
							}
							_tmp49_ = categories;
							_tmp50_ = object;
							_tmp51_ = json_object_get_array_member (_tmp50_, "categories");
							_tmp52_ = json_array_get_object_element (_tmp51_, j);
							_tmp53_ = json_object_get_string_member (_tmp52_, "id");
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp53_);
						}
					}
				}
				_tmp54_ = feedID;
				_tmp55_ = object;
				_tmp56_ = json_object_get_string_member (_tmp55_, "title");
				_tmp57_ = url;
				_tmp58_ = categories;
				_tmp59_ = icon_url;
				_tmp60_ = object;
				_tmp61_ = json_object_get_string_member (_tmp60_, "url");
				_tmp62_ = feed_reader_feed_new (_tmp54_, _tmp56_, _tmp57_, (guint) 0, (GeeList*) _tmp58_, _tmp59_, _tmp61_);
				_tmp63_ = _tmp62_;
				gee_collection_add ((GeeCollection*) feeds, _tmp63_);
				_g_object_unref0 (_tmp63_);
				_g_object_unref0 (categories);
				_g_free0 (icon_url);
				_g_free0 (url);
				_g_free0 (feedID);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_bazqux_message_unref0 (msg);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
feed_reader_bazqux_api_getCategoriesAndTags (FeedReaderbazquxAPI* self,
                                             GeeList* feeds,
                                             GeeList* categories,
                                             GeeList* tags)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderResponse response = {0};
	FeedReaderbazquxConnection* _tmp2_;
	FeedReaderbazquxMessage* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse _tmp6_ = {0};
	FeedReaderResponse _tmp7_;
	FeedReaderResponse _tmp8_;
	JsonParser* parser = NULL;
	JsonParser* _tmp9_;
	JsonObject* root = NULL;
	JsonParser* _tmp16_;
	JsonNode* _tmp17_;
	JsonObject* _tmp18_;
	JsonObject* _tmp19_;
	JsonArray* array = NULL;
	JsonObject* _tmp20_;
	JsonArray* _tmp21_;
	JsonArray* _tmp22_;
	guint length = 0U;
	JsonArray* _tmp23_;
	gint orderID = 0;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp24_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = msg;
	_tmp4_ = feed_reader_bazqux_message_get (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_bazqux_connection_send_get_request (_tmp2_, "tag/list", _tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	response = _tmp7_;
	_tmp8_ = response;
	if (_tmp8_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	_tmp9_ = json_parser_new ();
	parser = _tmp9_;
	{
		JsonParser* _tmp10_;
		FeedReaderResponse _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = parser;
		_tmp11_ = response;
		_tmp12_ = _tmp11_.data;
		json_parser_load_from_data (_tmp10_, _tmp12_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getCategoriesAndTags: Could not load message response");
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		feed_reader_logger_error (_tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = parser;
	_tmp17_ = json_parser_get_root (_tmp16_);
	_tmp18_ = json_node_get_object (_tmp17_);
	_tmp19_ = _json_object_ref0 (_tmp18_);
	root = _tmp19_;
	_tmp20_ = root;
	_tmp21_ = json_object_get_array_member (_tmp20_, "tags");
	_tmp22_ = _json_array_ref0 (_tmp21_);
	array = _tmp22_;
	_tmp23_ = array;
	length = json_array_get_length (_tmp23_);
	orderID = 0;
	_tmp24_ = feed_reader_data_base_readOnly ();
	db = _tmp24_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp27_;
				JsonObject* _tmp28_;
				JsonObject* _tmp29_;
				gchar* id = NULL;
				JsonObject* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gint start = 0;
				const gchar* _tmp33_;
				gchar* title = NULL;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				const gchar* _tmp36_;
				if (!_tmp25_) {
					guint _tmp26_;
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp27_ = array;
				_tmp28_ = json_array_get_object_element (_tmp27_, i);
				_tmp29_ = _json_object_ref0 (_tmp28_);
				object = _tmp29_;
				_tmp30_ = object;
				_tmp31_ = json_object_get_string_member (_tmp30_, "id");
				_tmp32_ = g_strdup (_tmp31_);
				id = _tmp32_;
				_tmp33_ = id;
				start = string_last_index_of_char (_tmp33_, (gunichar) '/', 0) + 1;
				_tmp34_ = id;
				_tmp35_ = string_substring (_tmp34_, (glong) start, (glong) -1);
				title = _tmp35_;
				_tmp36_ = id;
				if (string_contains (_tmp36_, "/label/")) {
					FeedReaderbazquxUtils* _tmp37_;
					const gchar* _tmp38_;
					_tmp37_ = self->priv->m_utils;
					_tmp38_ = id;
					if (feed_reader_bazqux_utils_tagIsCat (_tmp37_, _tmp38_, feeds)) {
						const gchar* _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						FeedReaderCategory* _tmp43_;
						FeedReaderCategory* _tmp44_;
						gint _tmp45_;
						_tmp39_ = id;
						_tmp40_ = title;
						_tmp41_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
						_tmp42_ = _tmp41_;
						_tmp43_ = feed_reader_category_new (_tmp39_, _tmp40_, (guint) 0, orderID, _tmp42_, 1);
						_tmp44_ = _tmp43_;
						gee_collection_add ((GeeCollection*) categories, _tmp44_);
						_g_object_unref0 (_tmp44_);
						_g_free0 (_tmp42_);
						orderID = orderID + 1;
						_tmp45_ = orderID;
					} else {
						const gchar* _tmp46_;
						const gchar* _tmp47_;
						FeedReaderDataBaseReadOnly* _tmp48_;
						FeedReaderTag* _tmp49_;
						FeedReaderTag* _tmp50_;
						_tmp46_ = id;
						_tmp47_ = title;
						_tmp48_ = db;
						_tmp49_ = feed_reader_tag_new (_tmp46_, _tmp47_, feed_reader_data_base_read_only_getTagColor (_tmp48_));
						_tmp50_ = _tmp49_;
						gee_collection_add ((GeeCollection*) tags, _tmp50_);
						_g_object_unref0 (_tmp50_);
					}
				}
				_g_free0 (title);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (db);
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_bazqux_message_unref0 (msg);
	return result;
}

gint
feed_reader_bazqux_api_getTotalUnread (FeedReaderbazquxAPI* self)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderResponse response = {0};
	FeedReaderbazquxConnection* _tmp2_;
	FeedReaderbazquxMessage* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse _tmp6_ = {0};
	FeedReaderResponse _tmp7_;
	FeedReaderResponse _tmp8_;
	JsonParser* parser = NULL;
	JsonParser* _tmp9_;
	JsonObject* root = NULL;
	JsonParser* _tmp16_;
	JsonNode* _tmp17_;
	JsonObject* _tmp18_;
	JsonObject* _tmp19_;
	JsonArray* array = NULL;
	JsonObject* _tmp20_;
	JsonArray* _tmp21_;
	JsonArray* _tmp22_;
	guint length = 0U;
	JsonArray* _tmp23_;
	gint count = 0;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = msg;
	_tmp4_ = feed_reader_bazqux_message_get (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_bazqux_connection_send_get_request (_tmp2_, "unread-count", _tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	response = _tmp7_;
	_tmp8_ = response;
	if (_tmp8_.status != ((guint) 200)) {
		result = 0;
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	_tmp9_ = json_parser_new ();
	parser = _tmp9_;
	{
		JsonParser* _tmp10_;
		FeedReaderResponse _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = parser;
		_tmp11_ = response;
		_tmp12_ = _tmp11_.data;
		json_parser_load_from_data (_tmp10_, _tmp12_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTotalUnread: Could not load message response");
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		feed_reader_logger_error (_tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp15_ = -1;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = parser;
	_tmp17_ = json_parser_get_root (_tmp16_);
	_tmp18_ = json_node_get_object (_tmp17_);
	_tmp19_ = _json_object_ref0 (_tmp18_);
	root = _tmp19_;
	_tmp20_ = root;
	_tmp21_ = json_object_get_array_member (_tmp20_, "unreadcounts");
	_tmp22_ = _json_array_ref0 (_tmp21_);
	array = _tmp22_;
	_tmp23_ = array;
	length = json_array_get_length (_tmp23_);
	count = 0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp26_;
				JsonObject* _tmp27_;
				JsonObject* _tmp28_;
				JsonObject* _tmp29_;
				const gchar* _tmp30_;
				if (!_tmp24_) {
					guint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp26_ = array;
				_tmp27_ = json_array_get_object_element (_tmp26_, i);
				_tmp28_ = _json_object_ref0 (_tmp27_);
				object = _tmp28_;
				_tmp29_ = object;
				_tmp30_ = json_object_get_string_member (_tmp29_, "id");
				if (g_str_has_prefix (_tmp30_, "feed/")) {
					JsonObject* _tmp31_;
					_tmp31_ = object;
					count += (gint) json_object_get_int_member (_tmp31_, "count");
				}
				_json_object_unref0 (object);
			}
		}
	}
	_tmp32_ = g_strdup_printf ("getTotalUnread %i", count);
	_tmp33_ = _tmp32_;
	feed_reader_logger_debug (_tmp33_);
	_g_free0 (_tmp33_);
	result = count;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_bazqux_message_unref0 (msg);
	return result;
}

gchar*
feed_reader_bazqux_api_updateArticles (FeedReaderbazquxAPI* self,
                                       GeeList* ids,
                                       gint count,
                                       const gchar* continuation)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderbazquxMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FeedReaderbazquxMessage* _tmp5_;
	FeedReaderResponse response = {0};
	FeedReaderbazquxConnection* _tmp7_;
	FeedReaderbazquxMessage* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FeedReaderResponse _tmp11_ = {0};
	FeedReaderResponse _tmp12_;
	FeedReaderResponse _tmp13_;
	JsonParser* parser = NULL;
	JsonParser* _tmp14_;
	JsonObject* root = NULL;
	JsonParser* _tmp20_;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	JsonArray* array = NULL;
	JsonObject* _tmp24_;
	JsonArray* _tmp25_;
	JsonArray* _tmp26_;
	guint length = 0U;
	JsonArray* _tmp27_;
	gboolean _tmp35_ = FALSE;
	JsonObject* _tmp36_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ids != NULL, NULL);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	_tmp2_ = msg;
	_tmp3_ = g_strdup_printf ("%i", count);
	_tmp4_ = _tmp3_;
	feed_reader_bazqux_message_add (_tmp2_, "n", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = msg;
	feed_reader_bazqux_message_add (_tmp5_, "xt", "user/-/state/com.google/read");
	if (continuation != NULL) {
		FeedReaderbazquxMessage* _tmp6_;
		_tmp6_ = msg;
		feed_reader_bazqux_message_add (_tmp6_, "c", continuation);
	}
	_tmp7_ = self->priv->m_connection;
	_tmp8_ = msg;
	_tmp9_ = feed_reader_bazqux_message_get (_tmp8_);
	_tmp10_ = _tmp9_;
	feed_reader_bazqux_connection_send_get_request (_tmp7_, "stream/items/ids", _tmp10_, &_tmp11_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	response = _tmp12_;
	_tmp13_ = response;
	if (_tmp13_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	_tmp14_ = json_parser_new ();
	parser = _tmp14_;
	{
		JsonParser* _tmp15_;
		FeedReaderResponse _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = parser;
		_tmp16_ = response;
		_tmp17_ = _tmp16_.data;
		json_parser_load_from_data (_tmp15_, _tmp17_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("updateArticles: Could not load message response");
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		feed_reader_logger_error (_tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = parser;
	_tmp21_ = json_parser_get_root (_tmp20_);
	_tmp22_ = json_node_get_object (_tmp21_);
	_tmp23_ = _json_object_ref0 (_tmp22_);
	root = _tmp23_;
	_tmp24_ = root;
	_tmp25_ = json_object_get_array_member (_tmp24_, "itemRefs");
	_tmp26_ = _json_array_ref0 (_tmp25_);
	array = _tmp26_;
	_tmp27_ = array;
	length = json_array_get_length (_tmp27_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp30_;
				JsonObject* _tmp31_;
				JsonObject* _tmp32_;
				JsonObject* _tmp33_;
				const gchar* _tmp34_;
				if (!_tmp28_) {
					guint _tmp29_;
					_tmp29_ = i;
					i = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp30_ = array;
				_tmp31_ = json_array_get_object_element (_tmp30_, i);
				_tmp32_ = _json_object_ref0 (_tmp31_);
				object = _tmp32_;
				_tmp33_ = object;
				_tmp34_ = json_object_get_string_member (_tmp33_, "id");
				gee_collection_add ((GeeCollection*) ids, _tmp34_);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp36_ = root;
	if (json_object_has_member (_tmp36_, "continuation")) {
		JsonObject* _tmp37_;
		const gchar* _tmp38_;
		_tmp37_ = root;
		_tmp38_ = json_object_get_string_member (_tmp37_, "continuation");
		_tmp35_ = g_strcmp0 (_tmp38_, "") != 0;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		JsonObject* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp39_ = root;
		_tmp40_ = json_object_get_string_member (_tmp39_, "continuation");
		_tmp41_ = g_strdup (_tmp40_);
		result = _tmp41_;
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	result = NULL;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_bazqux_message_unref0 (msg);
	return result;
}

gchar*
feed_reader_bazqux_api_getArticles (FeedReaderbazquxAPI* self,
                                    GeeList* articles,
                                    gint count,
                                    FeedReaderArticleStatus whatToGet,
                                    const gchar* continuation,
                                    const gchar* tagID,
                                    const gchar* feed_id)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderbazquxMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* api_endpoint = NULL;
	gchar* _tmp9_;
	FeedReaderResponse response = {0};
	FeedReaderbazquxConnection* _tmp18_;
	const gchar* _tmp19_;
	FeedReaderbazquxMessage* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	FeedReaderResponse _tmp23_ = {0};
	FeedReaderResponse _tmp24_;
	FeedReaderResponse _tmp25_;
	JsonParser* parser = NULL;
	JsonParser* _tmp26_;
	JsonObject* root = NULL;
	JsonParser* _tmp32_;
	JsonNode* _tmp33_;
	JsonObject* _tmp34_;
	JsonObject* _tmp35_;
	JsonArray* array = NULL;
	JsonObject* _tmp36_;
	JsonArray* _tmp37_;
	JsonArray* _tmp38_;
	guint length = 0U;
	JsonArray* _tmp39_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp40_;
	gboolean _tmp116_ = FALSE;
	JsonObject* _tmp117_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articles != NULL, NULL);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	_tmp2_ = msg;
	_tmp3_ = g_strdup_printf ("%i", count);
	_tmp4_ = _tmp3_;
	feed_reader_bazqux_message_add (_tmp2_, "n", _tmp4_);
	_g_free0 (_tmp4_);
	if (whatToGet == FEED_READER_ARTICLE_STATUS_UNREAD) {
		FeedReaderbazquxMessage* _tmp5_;
		_tmp5_ = msg;
		feed_reader_bazqux_message_add (_tmp5_, "xt", "user/-/state/com.google/read");
	}
	if (whatToGet == FEED_READER_ARTICLE_STATUS_READ) {
		FeedReaderbazquxMessage* _tmp6_;
		_tmp6_ = msg;
		feed_reader_bazqux_message_add (_tmp6_, "s", "user/-/state/com.google/read");
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_MARKED) {
			FeedReaderbazquxMessage* _tmp7_;
			_tmp7_ = msg;
			feed_reader_bazqux_message_add (_tmp7_, "s", "user/-/state/com.google/starred");
		}
	}
	if (continuation != NULL) {
		FeedReaderbazquxMessage* _tmp8_;
		_tmp8_ = msg;
		feed_reader_bazqux_message_add (_tmp8_, "c", continuation);
	}
	_tmp9_ = g_strdup ("stream/contents");
	api_endpoint = _tmp9_;
	if (feed_id != NULL) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = api_endpoint;
		_tmp11_ = g_strconcat ("/", feed_id, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
		_g_free0 (api_endpoint);
		api_endpoint = _tmp13_;
		_g_free0 (_tmp12_);
	} else {
		if (tagID != NULL) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = api_endpoint;
			_tmp15_ = g_strconcat ("/", tagID, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
			_g_free0 (api_endpoint);
			api_endpoint = _tmp17_;
			_g_free0 (_tmp16_);
		}
	}
	_tmp18_ = self->priv->m_connection;
	_tmp19_ = api_endpoint;
	_tmp20_ = msg;
	_tmp21_ = feed_reader_bazqux_message_get (_tmp20_);
	_tmp22_ = _tmp21_;
	feed_reader_bazqux_connection_send_get_request (_tmp18_, _tmp19_, _tmp22_, &_tmp23_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	response = _tmp24_;
	_tmp25_ = response;
	if (_tmp25_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	_tmp26_ = json_parser_new ();
	parser = _tmp26_;
	{
		JsonParser* _tmp27_;
		FeedReaderResponse _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = parser;
		_tmp28_ = response;
		_tmp29_ = _tmp28_.data;
		json_parser_load_from_data (_tmp27_, _tmp29_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getArticles: Could not load message response");
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		feed_reader_logger_error (_tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_feed_reader_bazqux_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp32_ = parser;
	_tmp33_ = json_parser_get_root (_tmp32_);
	_tmp34_ = json_node_get_object (_tmp33_);
	_tmp35_ = _json_object_ref0 (_tmp34_);
	root = _tmp35_;
	_tmp36_ = root;
	_tmp37_ = json_object_get_array_member (_tmp36_, "items");
	_tmp38_ = _json_array_ref0 (_tmp37_);
	array = _tmp38_;
	_tmp39_ = array;
	length = json_array_get_length (_tmp39_);
	_tmp40_ = feed_reader_data_base_readOnly ();
	db = _tmp40_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp43_;
				JsonObject* _tmp44_;
				JsonObject* _tmp45_;
				gchar* id = NULL;
				JsonObject* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				gboolean marked = FALSE;
				gboolean read = FALSE;
				JsonArray* cats = NULL;
				JsonObject* _tmp52_;
				JsonArray* _tmp53_;
				JsonArray* _tmp54_;
				guint cat_length = 0U;
				JsonArray* _tmp55_;
				GeeArrayList* tags = NULL;
				GeeArrayList* _tmp56_;
				GeeArrayList* enclosures = NULL;
				GeeArrayList* _tmp72_;
				JsonObject* _tmp73_;
				FeedReaderArticleStatus _tmp92_ = 0;
				FeedReaderArticleStatus _tmp93_ = 0;
				const gchar* _tmp94_;
				JsonObject* _tmp95_;
				const gchar* _tmp96_;
				JsonObject* _tmp97_;
				JsonArray* _tmp98_;
				JsonObject* _tmp99_;
				const gchar* _tmp100_;
				JsonObject* _tmp101_;
				JsonObject* _tmp102_;
				const gchar* _tmp103_;
				JsonObject* _tmp104_;
				JsonObject* _tmp105_;
				const gchar* _tmp106_;
				JsonObject* _tmp107_;
				const gchar* _tmp108_;
				JsonObject* _tmp109_;
				GDateTime* _tmp110_;
				GDateTime* _tmp111_;
				GeeArrayList* _tmp112_;
				GeeArrayList* _tmp113_;
				FeedReaderArticle* _tmp114_;
				FeedReaderArticle* _tmp115_;
				if (!_tmp41_) {
					guint _tmp42_;
					_tmp42_ = i;
					i = _tmp42_ + 1;
				}
				_tmp41_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp43_ = array;
				_tmp44_ = json_array_get_object_element (_tmp43_, i);
				_tmp45_ = _json_object_ref0 (_tmp44_);
				object = _tmp45_;
				_tmp46_ = object;
				_tmp47_ = json_object_get_string_member (_tmp46_, "id");
				_tmp48_ = g_strdup (_tmp47_);
				id = _tmp48_;
				_tmp49_ = id;
				_tmp50_ = id;
				_tmp51_ = string_substring (_tmp49_, (glong) (string_last_index_of_char (_tmp50_, (gunichar) '/', 0) + 1), (glong) -1);
				_g_free0 (id);
				id = _tmp51_;
				marked = FALSE;
				read = FALSE;
				_tmp52_ = object;
				_tmp53_ = json_object_get_array_member (_tmp52_, "categories");
				_tmp54_ = _json_array_ref0 (_tmp53_);
				cats = _tmp54_;
				_tmp55_ = cats;
				cat_length = json_array_get_length (_tmp55_);
				_tmp56_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				tags = _tmp56_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp57_ = FALSE;
						_tmp57_ = TRUE;
						while (TRUE) {
							gchar* cat = NULL;
							JsonArray* _tmp59_;
							const gchar* _tmp60_;
							gchar* _tmp61_;
							const gchar* _tmp62_;
							if (!_tmp57_) {
								guint _tmp58_;
								_tmp58_ = j;
								j = _tmp58_ + 1;
							}
							_tmp57_ = FALSE;
							if (!(j < cat_length)) {
								break;
							}
							_tmp59_ = cats;
							_tmp60_ = json_array_get_string_element (_tmp59_, j);
							_tmp61_ = g_strdup (_tmp60_);
							cat = _tmp61_;
							_tmp62_ = cat;
							if (g_str_has_suffix (_tmp62_, "com.google/starred")) {
								marked = TRUE;
							} else {
								const gchar* _tmp63_;
								_tmp63_ = cat;
								if (g_str_has_suffix (_tmp63_, "com.google/read")) {
									read = TRUE;
								} else {
									gboolean _tmp64_ = FALSE;
									const gchar* _tmp65_;
									_tmp65_ = cat;
									if (string_contains (_tmp65_, "/label/")) {
										FeedReaderDataBaseReadOnly* _tmp66_;
										const gchar* _tmp67_;
										gchar* _tmp68_;
										gchar* _tmp69_;
										_tmp66_ = db;
										_tmp67_ = cat;
										_tmp68_ = feed_reader_data_base_read_only_getTagName (_tmp66_, _tmp67_);
										_tmp69_ = _tmp68_;
										_tmp64_ = _tmp69_ != NULL;
										_g_free0 (_tmp69_);
									} else {
										_tmp64_ = FALSE;
									}
									if (_tmp64_) {
										GeeArrayList* _tmp70_;
										const gchar* _tmp71_;
										_tmp70_ = tags;
										_tmp71_ = cat;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, _tmp71_);
									}
								}
							}
							_g_free0 (cat);
						}
					}
				}
				_tmp72_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				enclosures = _tmp72_;
				_tmp73_ = object;
				if (json_object_has_member (_tmp73_, "enclosure")) {
					JsonArray* attachments = NULL;
					JsonObject* _tmp74_;
					JsonArray* _tmp75_;
					JsonArray* _tmp76_;
					guint mediaCount = 0U;
					JsonArray* _tmp77_;
					_tmp74_ = object;
					_tmp75_ = json_object_get_array_member (_tmp74_, "enclosure");
					_tmp76_ = _json_array_ref0 (_tmp75_);
					attachments = _tmp76_;
					mediaCount = (guint) 0;
					_tmp77_ = attachments;
					if (_tmp77_ != NULL) {
						JsonArray* _tmp78_;
						_tmp78_ = attachments;
						mediaCount = json_array_get_length (_tmp78_);
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp79_ = FALSE;
							_tmp79_ = TRUE;
							while (TRUE) {
								JsonObject* attachment = NULL;
								JsonArray* _tmp81_;
								JsonObject* _tmp82_;
								JsonObject* _tmp83_;
								GeeArrayList* _tmp84_;
								const gchar* _tmp85_;
								JsonObject* _tmp86_;
								const gchar* _tmp87_;
								JsonObject* _tmp88_;
								const gchar* _tmp89_;
								FeedReaderEnclosure* _tmp90_;
								FeedReaderEnclosure* _tmp91_;
								if (!_tmp79_) {
									gint _tmp80_;
									j = j + 1;
									_tmp80_ = j;
								}
								_tmp79_ = FALSE;
								if (!(((guint) j) < mediaCount)) {
									break;
								}
								_tmp81_ = attachments;
								_tmp82_ = json_array_get_object_element (_tmp81_, (guint) j);
								_tmp83_ = _json_object_ref0 (_tmp82_);
								attachment = _tmp83_;
								_tmp84_ = enclosures;
								_tmp85_ = id;
								_tmp86_ = attachment;
								_tmp87_ = json_object_get_string_member (_tmp86_, "href");
								_tmp88_ = attachment;
								_tmp89_ = json_object_get_string_member (_tmp88_, "type");
								_tmp90_ = feed_reader_enclosure_new (_tmp85_, _tmp87_, feed_reader_enclosure_type_from_string (_tmp89_));
								_tmp91_ = _tmp90_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp84_, _tmp91_);
								_g_object_unref0 (_tmp91_);
								_json_object_unref0 (attachment);
							}
						}
					}
					_json_array_unref0 (attachments);
				}
				if (read) {
					_tmp92_ = FEED_READER_ARTICLE_STATUS_READ;
				} else {
					_tmp92_ = FEED_READER_ARTICLE_STATUS_UNREAD;
				}
				if (marked) {
					_tmp93_ = FEED_READER_ARTICLE_STATUS_MARKED;
				} else {
					_tmp93_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
				}
				_tmp94_ = id;
				_tmp95_ = object;
				_tmp96_ = json_object_get_string_member (_tmp95_, "title");
				_tmp97_ = object;
				_tmp98_ = json_object_get_array_member (_tmp97_, "alternate");
				_tmp99_ = json_array_get_object_element (_tmp98_, (guint) 0);
				_tmp100_ = json_object_get_string_member (_tmp99_, "href");
				_tmp101_ = object;
				_tmp102_ = json_object_get_object_member (_tmp101_, "origin");
				_tmp103_ = json_object_get_string_member (_tmp102_, "streamId");
				_tmp104_ = object;
				_tmp105_ = json_object_get_object_member (_tmp104_, "summary");
				_tmp106_ = json_object_get_string_member (_tmp105_, "content");
				_tmp107_ = object;
				_tmp108_ = json_object_get_string_member (_tmp107_, "author");
				_tmp109_ = object;
				_tmp110_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp109_, "published"));
				_tmp111_ = _tmp110_;
				_tmp112_ = tags;
				_tmp113_ = enclosures;
				_tmp114_ = feed_reader_article_new (_tmp94_, _tmp96_, _tmp100_, _tmp103_, _tmp92_, _tmp93_, _tmp106_, "", _tmp108_, _tmp111_, -1, (GeeList*) _tmp112_, (GeeList*) _tmp113_, "", 0);
				_tmp115_ = _tmp114_;
				gee_collection_add ((GeeCollection*) articles, _tmp115_);
				_g_object_unref0 (_tmp115_);
				_g_date_time_unref0 (_tmp111_);
				_g_object_unref0 (enclosures);
				_g_object_unref0 (tags);
				_json_array_unref0 (cats);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp117_ = root;
	if (json_object_has_member (_tmp117_, "continuation")) {
		JsonObject* _tmp118_;
		const gchar* _tmp119_;
		_tmp118_ = root;
		_tmp119_ = json_object_get_string_member (_tmp118_, "continuation");
		_tmp116_ = g_strcmp0 (_tmp119_, "") != 0;
	} else {
		_tmp116_ = FALSE;
	}
	if (_tmp116_) {
		JsonObject* _tmp120_;
		const gchar* _tmp121_;
		gchar* _tmp122_;
		_tmp120_ = root;
		_tmp121_ = json_object_get_string_member (_tmp120_, "continuation");
		_tmp122_ = g_strdup (_tmp121_);
		result = _tmp122_;
		_g_object_unref0 (db);
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_feed_reader_bazqux_message_unref0 (msg);
		return result;
	}
	result = NULL;
	_g_object_unref0 (db);
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_g_free0 (api_endpoint);
	_feed_reader_bazqux_message_unref0 (msg);
	return result;
}

void
feed_reader_bazqux_api_edidTag (FeedReaderbazquxAPI* self,
                                const gchar* articleID,
                                const gchar* tagID,
                                gboolean add)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderbazquxMessage* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderbazquxConnection* _tmp7_;
	FeedReaderbazquxMessage* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FeedReaderResponse _tmp11_ = {0};
	FeedReaderResponse _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	if (add) {
		FeedReaderbazquxMessage* _tmp2_;
		_tmp2_ = msg;
		feed_reader_bazqux_message_add (_tmp2_, "a", tagID);
	} else {
		FeedReaderbazquxMessage* _tmp3_;
		_tmp3_ = msg;
		feed_reader_bazqux_message_add (_tmp3_, "r", tagID);
	}
	_tmp4_ = msg;
	_tmp5_ = g_strconcat ("tag:google.com,2005:reader/item/", articleID, NULL);
	_tmp6_ = _tmp5_;
	feed_reader_bazqux_message_add (_tmp4_, "i", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->m_connection;
	_tmp8_ = msg;
	_tmp9_ = feed_reader_bazqux_message_get (_tmp8_);
	_tmp10_ = _tmp9_;
	feed_reader_bazqux_connection_send_post_request (_tmp7_, "edit-tag", _tmp10_, &_tmp11_);
	_tmp12_ = _tmp11_;
	feed_reader_response_destroy (&_tmp12_);
	_g_free0 (_tmp10_);
	_feed_reader_bazqux_message_unref0 (msg);
}

void
feed_reader_bazqux_api_markAsRead (FeedReaderbazquxAPI* self,
                                   const gchar* streamID)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FeedReaderbazquxConnection* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderResponse _tmp8_ = {0};
	FeedReaderResponse _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	feed_reader_bazqux_message_add (msg, "output", "json");
	feed_reader_bazqux_message_add (msg, "s", streamID);
	_tmp1_ = feed_reader_settings_state ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i000000", g_settings_get_int (_tmp2_, "last-sync"));
	_tmp4_ = _tmp3_;
	feed_reader_bazqux_message_add (msg, "ts", _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp5_ = self->priv->m_connection;
	_tmp6_ = feed_reader_bazqux_message_get (msg);
	_tmp7_ = _tmp6_;
	feed_reader_bazqux_connection_send_post_request (_tmp5_, "mark-all-as-read", _tmp7_, &_tmp8_);
	_tmp9_ = _tmp8_;
	feed_reader_response_destroy (&_tmp9_);
	_g_free0 (_tmp7_);
	_feed_reader_bazqux_message_unref0 (msg);
}

gchar*
feed_reader_bazqux_api_composeTagID (FeedReaderbazquxAPI* self,
                                     const gchar* tagName)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagName != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strdup_printf ("user/%s/label/%s", _tmp0_, tagName);
	result = _tmp1_;
	return result;
}

void
feed_reader_bazqux_api_deleteTag (FeedReaderbazquxAPI* self,
                                  const gchar* tagID)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxConnection* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FeedReaderResponse _tmp4_ = {0};
	FeedReaderResponse _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	feed_reader_bazqux_message_add (msg, "output", "json");
	feed_reader_bazqux_message_add (msg, "s", tagID);
	_tmp1_ = self->priv->m_connection;
	_tmp2_ = feed_reader_bazqux_message_get (msg);
	_tmp3_ = _tmp2_;
	feed_reader_bazqux_connection_send_post_request (_tmp1_, "disable-tag", _tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	feed_reader_response_destroy (&_tmp5_);
	_g_free0 (_tmp3_);
	_feed_reader_bazqux_message_unref0 (msg);
}

void
feed_reader_bazqux_api_renameTag (FeedReaderbazquxAPI* self,
                                  const gchar* tagID,
                                  const gchar* title)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FeedReaderbazquxConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse _tmp6_ = {0};
	FeedReaderResponse _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	feed_reader_bazqux_message_add (msg, "output", "json");
	feed_reader_bazqux_message_add (msg, "s", tagID);
	_tmp1_ = feed_reader_bazqux_api_composeTagID (self, title);
	_tmp2_ = _tmp1_;
	feed_reader_bazqux_message_add (msg, "dest", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->m_connection;
	_tmp4_ = feed_reader_bazqux_message_get (msg);
	_tmp5_ = _tmp4_;
	feed_reader_bazqux_connection_send_post_request (_tmp3_, "rename-tag", _tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	feed_reader_response_destroy (&_tmp7_);
	_g_free0 (_tmp5_);
	_feed_reader_bazqux_message_unref0 (msg);
}

gboolean
feed_reader_bazqux_api_editSubscription (FeedReaderbazquxAPI* self,
                                         FeedReaderbazquxAPIbazquxSubscriptionAction action,
                                         const gchar* feedID,
                                         const gchar* title,
                                         const gchar* add,
                                         const gchar* remove)
{
	FeedReaderbazquxMessage* msg = NULL;
	FeedReaderbazquxMessage* _tmp0_;
	FeedReaderbazquxMessage* _tmp1_;
	FeedReaderbazquxMessage* _tmp5_;
	FeedReaderResponse response = {0};
	FeedReaderbazquxConnection* _tmp9_;
	FeedReaderbazquxMessage* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	FeedReaderResponse _tmp13_ = {0};
	FeedReaderResponse _tmp14_;
	FeedReaderResponse _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feedID != NULL, FALSE);
	_tmp0_ = feed_reader_bazqux_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_bazqux_message_add (_tmp1_, "output", "json");
	switch (action) {
		case FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_EDIT:
		{
			FeedReaderbazquxMessage* _tmp2_;
			_tmp2_ = msg;
			feed_reader_bazqux_message_add (_tmp2_, "ac", "edit");
			break;
		}
		case FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_SUBSCRIBE:
		{
			FeedReaderbazquxMessage* _tmp3_;
			_tmp3_ = msg;
			feed_reader_bazqux_message_add (_tmp3_, "ac", "subscribe");
			break;
		}
		case FEED_READER_BAZQUX_API_BAZQUX_SUBSCRIPTION_ACTION_UNSUBSCRIBE:
		{
			FeedReaderbazquxMessage* _tmp4_;
			_tmp4_ = msg;
			feed_reader_bazqux_message_add (_tmp4_, "ac", "unsubscribe");
			break;
		}
		default:
		break;
	}
	_tmp5_ = msg;
	feed_reader_bazqux_message_add (_tmp5_, "s", feedID);
	if (title != NULL) {
		FeedReaderbazquxMessage* _tmp6_;
		_tmp6_ = msg;
		feed_reader_bazqux_message_add (_tmp6_, "t", title);
	}
	if (add != NULL) {
		FeedReaderbazquxMessage* _tmp7_;
		_tmp7_ = msg;
		feed_reader_bazqux_message_add (_tmp7_, "a", add);
	}
	if (remove != NULL) {
		FeedReaderbazquxMessage* _tmp8_;
		_tmp8_ = msg;
		feed_reader_bazqux_message_add (_tmp8_, "r", remove);
	}
	_tmp9_ = self->priv->m_connection;
	_tmp10_ = msg;
	_tmp11_ = feed_reader_bazqux_message_get (_tmp10_);
	_tmp12_ = _tmp11_;
	feed_reader_bazqux_connection_send_post_request (_tmp9_, "subscription/edit", _tmp12_, &_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	response = _tmp14_;
	_tmp15_ = response;
	result = _tmp15_.status == ((guint) 200);
	feed_reader_response_destroy (&response);
	_feed_reader_bazqux_message_unref0 (msg);
	return result;
}

static void
feed_reader_bazqux_api_class_init (FeedReaderbazquxAPIClass * klass,
                                   gpointer klass_data)
{
	feed_reader_bazqux_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderbazquxAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_bazqux_api_finalize;
}

static void
feed_reader_bazqux_api_instance_init (FeedReaderbazquxAPI * self,
                                      gpointer klass)
{
	self->priv = feed_reader_bazqux_api_get_instance_private (self);
}

static void
feed_reader_bazqux_api_finalize (GObject * obj)
{
	FeedReaderbazquxAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_BAZQUX_API, FeedReaderbazquxAPI);
	_feed_reader_bazqux_connection_unref0 (self->priv->m_connection);
	_g_object_unref0 (self->priv->m_utils);
	_g_free0 (self->priv->m_userID);
	G_OBJECT_CLASS (feed_reader_bazqux_api_parent_class)->finalize (obj);
}

GType
feed_reader_bazqux_api_get_type (void)
{
	return feed_reader_bazqux_api_type_id;
}

GType
feed_reader_bazqux_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderbazquxAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_bazqux_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderbazquxAPI), 0, (GInstanceInitFunc) feed_reader_bazqux_api_instance_init, NULL };
	feed_reader_bazqux_api_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderbazquxAPI", &g_define_type_info, 0);
	FeedReaderbazquxAPI_private_offset = sizeof (FeedReaderbazquxAPIPrivate);
	return feed_reader_bazqux_api_type_id;
}

