/* bazquxConnection.c generated by valac 0.56.3, the Vala compiler
 * generated from bazquxConnection.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "bazqux.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include "FeedReader.h"
#include <gobject/gvaluecollector.h>

#define FEED_READER_BAZQUX_SECRET_base_uri "https://www.bazqux.com/reader/api/0/"

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FeedReaderParamSpecbazquxConnection FeedReaderParamSpecbazquxConnection;
typedef struct _FeedReaderParamSpecbazquxMessage FeedReaderParamSpecbazquxMessage;

struct _FeedReaderbazquxConnectionPrivate {
	gchar* m_username;
	gchar* m_api_code;
	gchar* m_passwd;
	FeedReaderbazquxUtils* m_utils;
	SoupSession* m_session;
};

struct _FeedReaderParamSpecbazquxConnection {
	GParamSpec parent_instance;
};

struct _FeedReaderbazquxMessagePrivate {
	gchar* request;
};

struct _FeedReaderParamSpecbazquxMessage {
	GParamSpec parent_instance;
};

static gint FeedReaderbazquxConnection_private_offset;
static gpointer feed_reader_bazqux_connection_parent_class = NULL;
static GType feed_reader_bazqux_connection_type_id = 0;
static gint FeedReaderbazquxMessage_private_offset;
static gpointer feed_reader_bazqux_message_parent_class = NULL;
static GType feed_reader_bazqux_message_type_id = 0;

static void _vala_SoupBuffer_free (SoupBuffer* self);
static void feed_reader_bazqux_connection_send_request (FeedReaderbazquxConnection* self,
                                                 const gchar* path,
                                                 const gchar* type,
                                                 const gchar* message_string,
                                                 FeedReaderResponse* result);
static void feed_reader_bazqux_connection_finalize (FeedReaderbazquxConnection * obj);
static void feed_reader_bazqux_message_finalize (FeedReaderbazquxMessage * obj);

static inline gpointer
feed_reader_bazqux_connection_get_instance_private (FeedReaderbazquxConnection* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderbazquxConnection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderbazquxConnection*
feed_reader_bazqux_connection_construct (GType object_type,
                                         FeedReaderbazquxUtils* utils)
{
	FeedReaderbazquxConnection* self = NULL;
	FeedReaderbazquxUtils* _tmp0_;
	FeedReaderbazquxUtils* _tmp1_;
	gchar* _tmp2_;
	FeedReaderbazquxUtils* _tmp3_;
	gchar* _tmp4_;
	FeedReaderbazquxUtils* _tmp5_;
	gchar* _tmp6_;
	SoupSession* _tmp7_;
	SoupSession* _tmp8_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderbazquxConnection*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_bazqux_utils_getUser (_tmp1_);
	_g_free0 (self->priv->m_username);
	self->priv->m_username = _tmp2_;
	_tmp3_ = self->priv->m_utils;
	_tmp4_ = feed_reader_bazqux_utils_getAccessToken (_tmp3_);
	_g_free0 (self->priv->m_api_code);
	self->priv->m_api_code = _tmp4_;
	_tmp5_ = self->priv->m_utils;
	_tmp6_ = feed_reader_bazqux_utils_getPasswd (_tmp5_);
	_g_free0 (self->priv->m_passwd);
	self->priv->m_passwd = _tmp6_;
	_tmp7_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp7_;
	_tmp8_ = self->priv->m_session;
	g_object_set (_tmp8_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	return self;
}

FeedReaderbazquxConnection*
feed_reader_bazqux_connection_new (FeedReaderbazquxUtils* utils)
{
	return feed_reader_bazqux_connection_construct (FEED_READER_TYPE_BAZQUX_CONNECTION, utils);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

FeedReaderLoginResponse
feed_reader_bazqux_connection_getToken (FeedReaderbazquxConnection* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp5_;
	gchar* message_string = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	SoupMessage* _tmp14_;
	const gchar* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_ = 0;
	guint8* _tmp18_;
	gint _tmp18__length1;
	SoupSession* _tmp19_;
	SoupMessage* _tmp20_;
	gchar* response = NULL;
	SoupMessage* _tmp21_;
	SoupMessageBody* _tmp22_;
	SoupBuffer* _tmp23_;
	SoupBuffer* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_logger_debug ("bazqux Connection: getToken()");
	_tmp1_ = self->priv->m_username;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->m_passwd;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FEED_READER_LOGIN_RESPONSE_ALL_EMPTY;
		return result;
	}
	_tmp3_ = self->priv->m_username;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_USER;
		return result;
	}
	_tmp4_ = self->priv->m_passwd;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_PASSWD;
		return result;
	}
	_tmp5_ = soup_message_new ("POST", "https://bazqux.com/accounts/ClientLogin/");
	message = _tmp5_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = g_strconcat ("Email=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "&Passwd=", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->m_passwd;
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	message_string = _tmp13_;
	_tmp14_ = message;
	_tmp15_ = message_string;
	_tmp16_ = string_get_data (_tmp15_, &_tmp17_);
	_tmp16__length1 = _tmp17_;
	_tmp18_ = _tmp16_;
	_tmp18__length1 = _tmp16__length1;
	soup_message_set_request (_tmp14_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp18_, (gsize) _tmp18__length1);
	_tmp19_ = self->priv->m_session;
	_tmp20_ = message;
	soup_session_send_message (_tmp19_, _tmp20_);
	_tmp21_ = message;
	_tmp22_ = _tmp21_->response_body;
	_tmp23_ = soup_message_body_flatten (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->data;
	_tmp25__length1 = _tmp24_->length;
	_tmp26_ = g_strdup ((const gchar*) _tmp25_);
	_tmp27_ = _tmp26_;
	__vala_SoupBuffer_free0 (_tmp24_);
	response = _tmp27_;
	{
		GRegex* regex = NULL;
		GRegex* _tmp28_;
		GRegex* _tmp29_;
		const gchar* _tmp30_;
		_tmp28_ = g_regex_new (".*\\w\\s.*\\w\\sAuth=", 0, 0, &_inner_error0_);
		regex = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp29_ = regex;
		_tmp30_ = response;
		if (g_regex_match (_tmp29_, _tmp30_, 0, NULL)) {
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* split = NULL;
			GRegex* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			FeedReaderbazquxUtils* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp31_ = response;
			_tmp32_ = g_strdup_printf ("Regex bazqux - %s", _tmp31_);
			_tmp33_ = _tmp32_;
			feed_reader_logger_error (_tmp33_);
			_g_free0 (_tmp33_);
			_tmp34_ = regex;
			_tmp35_ = response;
			_tmp36_ = g_regex_replace (_tmp34_, _tmp35_, (gssize) -1, 0, "", 0, &_inner_error0_);
			split = _tmp36_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_regex_unref0 (regex);
				goto __catch0_g_error;
			}
			_tmp37_ = split;
			_tmp38_ = g_strconcat ("authcode", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			feed_reader_logger_error (_tmp39_);
			_g_free0 (_tmp39_);
			_tmp40_ = self->priv->m_utils;
			_tmp41_ = split;
			_tmp42_ = string_strip (_tmp41_);
			_tmp43_ = _tmp42_;
			feed_reader_bazqux_utils_setAccessToken (_tmp40_, _tmp43_);
			_g_free0 (_tmp43_);
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			_g_free0 (split);
			_g_regex_unref0 (regex);
			_g_free0 (response);
			_g_free0 (message_string);
			_g_object_unref0 (message);
			return result;
		} else {
			const gchar* _tmp44_;
			_tmp44_ = response;
			feed_reader_logger_debug (_tmp44_);
			result = FEED_READER_LOGIN_RESPONSE_WRONG_LOGIN;
			_g_regex_unref0 (regex);
			_g_free0 (response);
			_g_free0 (message_string);
			_g_object_unref0 (message);
			return result;
		}
		_g_regex_unref0 (regex);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp45_;
		const gchar* _tmp46_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("bazquxConnection - getToken: Could not load message response");
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		feed_reader_logger_error (_tmp46_);
		result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
		_g_error_free0 (e);
		_g_free0 (response);
		_g_free0 (message_string);
		_g_object_unref0 (message);
		return result;
	}
	__finally0:
	_g_free0 (response);
	_g_free0 (message_string);
	_g_object_unref0 (message);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

void
feed_reader_bazqux_connection_send_get_request (FeedReaderbazquxConnection* self,
                                                const gchar* path,
                                                const gchar* message_string,
                                                FeedReaderResponse* result)
{
	FeedReaderResponse _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	feed_reader_bazqux_connection_send_request (self, path, "GET", message_string, &_tmp0_);
	*result = _tmp0_;
	return;
}

void
feed_reader_bazqux_connection_send_post_request (FeedReaderbazquxConnection* self,
                                                 const gchar* path,
                                                 const gchar* message_string,
                                                 FeedReaderResponse* result)
{
	FeedReaderResponse _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	feed_reader_bazqux_connection_send_request (self, path, "POST", message_string, &_tmp0_);
	*result = _tmp0_;
	return;
}

static void
feed_reader_bazqux_connection_send_request (FeedReaderbazquxConnection* self,
                                            const gchar* path,
                                            const gchar* type,
                                            const gchar* message_string,
                                            FeedReaderResponse* result)
{
	SoupMessage* message = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	gchar* oldauth = NULL;
	FeedReaderbazquxUtils* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	SoupMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	const gchar* _tmp11_;
	SoupSession* _tmp16_;
	SoupMessage* _tmp17_;
	SoupMessage* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	SoupMessage* _tmp21_;
	SoupMessageBody* _tmp22_;
	SoupBuffer* _tmp23_;
	SoupBuffer* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	FeedReaderResponse _tmp27_ = {0};
	FeedReaderResponse _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = g_strconcat (FEED_READER_BAZQUX_SECRET_base_uri, path, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new (type, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message = _tmp3_;
	_tmp4_ = self->priv->m_utils;
	_tmp5_ = feed_reader_bazqux_utils_getAccessToken (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("GoogleLogin auth=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	oldauth = _tmp8_;
	_tmp9_ = message;
	_tmp10_ = _tmp9_->request_headers;
	_tmp11_ = oldauth;
	soup_message_headers_append (_tmp10_, "Authorization", _tmp11_);
	if (message_string != NULL) {
		SoupMessage* _tmp12_;
		guint8* _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_ = 0;
		guint8* _tmp15_;
		gint _tmp15__length1;
		_tmp12_ = message;
		_tmp13_ = string_get_data (message_string, &_tmp14_);
		_tmp13__length1 = _tmp14_;
		_tmp15_ = _tmp13_;
		_tmp15__length1 = _tmp13__length1;
		soup_message_set_request (_tmp12_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp15_, (gsize) _tmp15__length1);
	}
	_tmp16_ = self->priv->m_session;
	_tmp17_ = message;
	soup_session_send_message (_tmp16_, _tmp17_);
	_tmp18_ = message;
	g_object_get (_tmp18_, "status-code", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = message;
	_tmp22_ = _tmp21_->response_body;
	_tmp23_ = soup_message_body_flatten (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->data;
	_tmp25__length1 = _tmp24_->length;
	_tmp26_ = g_strdup ((const gchar*) _tmp25_);
	memset (&_tmp27_, 0, sizeof (FeedReaderResponse));
	_tmp27_.status = _tmp20_;
	_g_free0 (_tmp27_.data);
	_tmp27_.data = _tmp26_;
	_tmp28_ = _tmp27_;
	__vala_SoupBuffer_free0 (_tmp24_);
	*result = _tmp28_;
	_g_free0 (oldauth);
	_g_object_unref0 (message);
	return;
}

gboolean
feed_reader_bazqux_connection_ping (FeedReaderbazquxConnection* self)
{
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	gchar* oldauth = NULL;
	FeedReaderbazquxUtils* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessageHeaders* _tmp7_;
	const gchar* _tmp8_;
	SoupSession* _tmp9_;
	SoupMessage* _tmp10_;
	SoupMessage* _tmp11_;
	SoupMessageBody* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = soup_message_new ("GET", "https://www.bazqux.com/reader/ping");
	message = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_bazqux_utils_getAccessToken (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("GoogleLogin auth=", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	oldauth = _tmp5_;
	_tmp6_ = message;
	_tmp7_ = _tmp6_->request_headers;
	_tmp8_ = oldauth;
	soup_message_headers_append (_tmp7_, "Authorization", _tmp8_);
	_tmp9_ = self->priv->m_session;
	_tmp10_ = message;
	soup_session_send_message (_tmp9_, _tmp10_);
	_tmp11_ = message;
	_tmp12_ = _tmp11_->response_body;
	_tmp13_ = _tmp12_->data;
	_tmp13__length1 = _tmp12_->length;
	if (g_strcmp0 ((const gchar*) _tmp13_, "OK") == 0) {
		result = TRUE;
		_g_free0 (oldauth);
		_g_object_unref0 (message);
		return result;
	}
	result = FALSE;
	_g_free0 (oldauth);
	_g_object_unref0 (message);
	return result;
}

static void
feed_reader_value_bazqux_connection_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
feed_reader_value_bazqux_connection_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		feed_reader_bazqux_connection_unref (value->data[0].v_pointer);
	}
}

static void
feed_reader_value_bazqux_connection_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = feed_reader_bazqux_connection_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
feed_reader_value_bazqux_connection_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
feed_reader_value_bazqux_connection_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FeedReaderbazquxConnection * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = feed_reader_bazqux_connection_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
feed_reader_value_bazqux_connection_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	FeedReaderbazquxConnection ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = feed_reader_bazqux_connection_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
feed_reader_param_spec_bazqux_connection (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	FeedReaderParamSpecbazquxConnection* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FEED_READER_TYPE_BAZQUX_CONNECTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
feed_reader_value_get_bazqux_connection (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_BAZQUX_CONNECTION), NULL);
	return value->data[0].v_pointer;
}

void
feed_reader_value_set_bazqux_connection (GValue* value,
                                         gpointer v_object)
{
	FeedReaderbazquxConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_BAZQUX_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_BAZQUX_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		feed_reader_bazqux_connection_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_bazqux_connection_unref (old);
	}
}

void
feed_reader_value_take_bazqux_connection (GValue* value,
                                          gpointer v_object)
{
	FeedReaderbazquxConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_BAZQUX_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_BAZQUX_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_bazqux_connection_unref (old);
	}
}

static void
feed_reader_bazqux_connection_class_init (FeedReaderbazquxConnectionClass * klass,
                                          gpointer klass_data)
{
	feed_reader_bazqux_connection_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderbazquxConnectionClass *) klass)->finalize = feed_reader_bazqux_connection_finalize;
	g_type_class_adjust_private_offset (klass, &FeedReaderbazquxConnection_private_offset);
}

static void
feed_reader_bazqux_connection_instance_init (FeedReaderbazquxConnection * self,
                                             gpointer klass)
{
	self->priv = feed_reader_bazqux_connection_get_instance_private (self);
	self->ref_count = 1;
}

static void
feed_reader_bazqux_connection_finalize (FeedReaderbazquxConnection * obj)
{
	FeedReaderbazquxConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_BAZQUX_CONNECTION, FeedReaderbazquxConnection);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->m_username);
	_g_free0 (self->priv->m_api_code);
	_g_free0 (self->priv->m_passwd);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_session);
}

GType
feed_reader_bazqux_connection_get_type (void)
{
	return feed_reader_bazqux_connection_type_id;
}

GType
feed_reader_bazqux_connection_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { feed_reader_value_bazqux_connection_init, feed_reader_value_bazqux_connection_free_value, feed_reader_value_bazqux_connection_copy_value, feed_reader_value_bazqux_connection_peek_pointer, "p", feed_reader_value_bazqux_connection_collect_value, "p", feed_reader_value_bazqux_connection_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderbazquxConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_bazqux_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderbazquxConnection), 0, (GInstanceInitFunc) feed_reader_bazqux_connection_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	feed_reader_bazqux_connection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FeedReaderbazquxConnection", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FeedReaderbazquxConnection_private_offset = sizeof (FeedReaderbazquxConnectionPrivate);
	return feed_reader_bazqux_connection_type_id;
}

gpointer
feed_reader_bazqux_connection_ref (gpointer instance)
{
	FeedReaderbazquxConnection * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
feed_reader_bazqux_connection_unref (gpointer instance)
{
	FeedReaderbazquxConnection * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FEED_READER_BAZQUX_CONNECTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
feed_reader_bazqux_message_get_instance_private (FeedReaderbazquxMessage* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderbazquxMessage_private_offset);
}

FeedReaderbazquxMessage*
feed_reader_bazqux_message_construct (GType object_type)
{
	FeedReaderbazquxMessage* self = NULL;
	self = (FeedReaderbazquxMessage*) g_type_create_instance (object_type);
	return self;
}

FeedReaderbazquxMessage*
feed_reader_bazqux_message_new (void)
{
	return feed_reader_bazqux_message_construct (FEED_READER_TYPE_BAZQUX_MESSAGE);
}

void
feed_reader_bazqux_message_add (FeedReaderbazquxMessage* self,
                                const gchar* parameter,
                                const gchar* val)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->request;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->request;
		_tmp2_ = g_strconcat (_tmp1_, "&", NULL);
		_g_free0 (self->priv->request);
		self->priv->request = _tmp2_;
	}
	_tmp3_ = self->priv->request;
	_tmp4_ = g_strconcat (_tmp3_, parameter, NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp4_;
	_tmp5_ = self->priv->request;
	_tmp6_ = g_strconcat (_tmp5_, "=", NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp6_;
	_tmp7_ = self->priv->request;
	_tmp8_ = g_uri_escape_string (val, NULL, TRUE);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp10_;
	_g_free0 (_tmp9_);
}

gchar*
feed_reader_bazqux_message_get (FeedReaderbazquxMessage* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->request;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
feed_reader_value_bazqux_message_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
feed_reader_value_bazqux_message_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		feed_reader_bazqux_message_unref (value->data[0].v_pointer);
	}
}

static void
feed_reader_value_bazqux_message_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = feed_reader_bazqux_message_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
feed_reader_value_bazqux_message_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
feed_reader_value_bazqux_message_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FeedReaderbazquxMessage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = feed_reader_bazqux_message_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
feed_reader_value_bazqux_message_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	FeedReaderbazquxMessage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = feed_reader_bazqux_message_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
feed_reader_param_spec_bazqux_message (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	FeedReaderParamSpecbazquxMessage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FEED_READER_TYPE_BAZQUX_MESSAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
feed_reader_value_get_bazqux_message (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_BAZQUX_MESSAGE), NULL);
	return value->data[0].v_pointer;
}

void
feed_reader_value_set_bazqux_message (GValue* value,
                                      gpointer v_object)
{
	FeedReaderbazquxMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_BAZQUX_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_BAZQUX_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		feed_reader_bazqux_message_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_bazqux_message_unref (old);
	}
}

void
feed_reader_value_take_bazqux_message (GValue* value,
                                       gpointer v_object)
{
	FeedReaderbazquxMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_BAZQUX_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_BAZQUX_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_bazqux_message_unref (old);
	}
}

static void
feed_reader_bazqux_message_class_init (FeedReaderbazquxMessageClass * klass,
                                       gpointer klass_data)
{
	feed_reader_bazqux_message_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderbazquxMessageClass *) klass)->finalize = feed_reader_bazqux_message_finalize;
	g_type_class_adjust_private_offset (klass, &FeedReaderbazquxMessage_private_offset);
}

static void
feed_reader_bazqux_message_instance_init (FeedReaderbazquxMessage * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = feed_reader_bazqux_message_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->request = _tmp0_;
	self->ref_count = 1;
}

static void
feed_reader_bazqux_message_finalize (FeedReaderbazquxMessage * obj)
{
	FeedReaderbazquxMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_BAZQUX_MESSAGE, FeedReaderbazquxMessage);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->request);
}

GType
feed_reader_bazqux_message_get_type (void)
{
	return feed_reader_bazqux_message_type_id;
}

GType
feed_reader_bazqux_message_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { feed_reader_value_bazqux_message_init, feed_reader_value_bazqux_message_free_value, feed_reader_value_bazqux_message_copy_value, feed_reader_value_bazqux_message_peek_pointer, "p", feed_reader_value_bazqux_message_collect_value, "p", feed_reader_value_bazqux_message_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderbazquxMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_bazqux_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderbazquxMessage), 0, (GInstanceInitFunc) feed_reader_bazqux_message_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	feed_reader_bazqux_message_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FeedReaderbazquxMessage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FeedReaderbazquxMessage_private_offset = sizeof (FeedReaderbazquxMessagePrivate);
	return feed_reader_bazqux_message_type_id;
}

gpointer
feed_reader_bazqux_message_ref (gpointer instance)
{
	FeedReaderbazquxMessage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
feed_reader_bazqux_message_unref (gpointer instance)
{
	FeedReaderbazquxMessage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FEED_READER_BAZQUX_MESSAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

