/* Decsync.c generated by valac 0.56.3, the Vala compiler
 * generated from Decsync.vala, do not modify */

#include "libdecsync.h"
#include <gobject/gvaluecollector.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>

typedef struct _ParamSpecUnit ParamSpecUnit;
enum  {
	DECSYNC_0_PROPERTY,
	DECSYNC_T_TYPE,
	DECSYNC_T_DUP_FUNC,
	DECSYNC_T_DESTROY_FUNC,
	DECSYNC_NUM_PROPERTIES
};
static GParamSpec* decsync_properties[DECSYNC_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _decsync_entry_unref0(var) ((var == NULL) ? NULL : (var = (decsync_entry_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _decsync_entry_with_path_unref0(var) ((var == NULL) ? NULL : (var = (decsync_entry_with_path_unref (var), NULL)))

#define DECSYNC_TYPE_ENTRIES_LOCATION (decsync_entries_location_get_type ())
#define DECSYNC_ENTRIES_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DECSYNC_TYPE_ENTRIES_LOCATION, DecsyncEntriesLocation))
#define DECSYNC_ENTRIES_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DECSYNC_TYPE_ENTRIES_LOCATION, DecsyncEntriesLocationClass))
#define DECSYNC_IS_ENTRIES_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DECSYNC_TYPE_ENTRIES_LOCATION))
#define DECSYNC_IS_ENTRIES_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DECSYNC_TYPE_ENTRIES_LOCATION))
#define DECSYNC_ENTRIES_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DECSYNC_TYPE_ENTRIES_LOCATION, DecsyncEntriesLocationClass))

typedef struct _DecsyncEntriesLocation DecsyncEntriesLocation;
typedef struct _DecsyncEntriesLocationClass DecsyncEntriesLocationClass;
typedef struct _DecsyncEntriesLocationPrivate DecsyncEntriesLocationPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _decsync_entries_location_unref0(var) ((var == NULL) ? NULL : (var = (decsync_entries_location_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _DecsyncParamSpecEntryWithPath DecsyncParamSpecEntryWithPath;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _DecsyncParamSpecEntry DecsyncParamSpecEntry;
typedef struct _DecsyncParamSpecEntriesLocation DecsyncParamSpecEntriesLocation;
enum  {
	DECSYNC_SYNC_COMPLETE_SIGNAL,
	DECSYNC_NUM_SIGNALS
};
static guint decsync_signals[DECSYNC_NUM_SIGNALS] = {0};
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

struct _ParamSpecUnit {
	GParamSpec parent_instance;
};

struct _DecsyncPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gchar* dir;
	gchar* ownAppId;
	gchar* ownAppIdEncoded;
	GeeIterable* listeners;
	DirectoryMonitor* monitor;
};

struct _Block1Data {
	int _ref_count_;
	Decsync* self;
	GeeMultiMap* multiMap;
};

struct _DecsyncEntriesLocation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DecsyncEntriesLocationPrivate * priv;
	GeeList* path;
	GFile* newEntriesFile;
	GFile* storedEntriesFile;
	GFile* readBytesFile;
};

struct _DecsyncEntriesLocationClass {
	GTypeClass parent_class;
	void (*finalize) (DecsyncEntriesLocation *self);
};

struct _Block2Data {
	int _ref_count_;
	Decsync* self;
	gpointer extra;
};

struct _Block3Data {
	int _ref_count_;
	Decsync* self;
	gpointer extra;
};

struct _Block4Data {
	int _ref_count_;
	Decsync* self;
	GeeCollection* entries;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GString* builder;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	DecsyncEntry* entryLine;
};

struct _Block7Data {
	int _ref_count_;
	Decsync* self;
	GeeList* executePath;
	gpointer extra;
	GeePredicate keyPred;
	gpointer keyPred_target;
	GeePredicate valuePred;
	gpointer valuePred_target;
};

struct _Block8Data {
	int _ref_count_;
	Decsync* self;
	gchar* appIdEncoded;
};

struct _DecsyncParamSpecEntryWithPath {
	GParamSpec parent_instance;
};

struct _DecsyncParamSpecEntry {
	GParamSpec parent_instance;
};

struct _DecsyncParamSpecEntriesLocation {
	GParamSpec parent_instance;
};

static gpointer unit_parent_class = NULL;
static gint Decsync_private_offset;
static gpointer decsync_parent_class = NULL;
static gpointer decsync_entry_with_path_parent_class = NULL;
static gpointer decsync_entry_parent_class = NULL;
static gpointer decsync_entries_location_parent_class = NULL;

static void unit_finalize (Unit * obj);
static GType unit_get_type_once (void);
VALA_EXTERN void checkDecsyncSubdirInfo (const gchar* decsyncSubdir,
                             GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GeeList* __lambda13_ (Decsync* self,
                      DecsyncEntryWithPath* entryWithPath);
static gpointer ___lambda13__gee_map_func (gpointer g,
                                    gpointer self);
static DecsyncEntry* __lambda14_ (Decsync* self,
                           DecsyncEntryWithPath* entryWithPath);
static gpointer ___lambda14__gee_map_func (gpointer g,
                                    gpointer self);
static gboolean __lambda15_ (Block1Data* _data1_,
                      GeeList* path);
static gboolean ___lambda15__gee_forall_func (gpointer g,
                                       gpointer self);
static gpointer decsync_entries_location_ref (gpointer instance);
static void decsync_entries_location_unref (gpointer instance);
static GParamSpec* decsync_param_spec_entries_location (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED ;
static void decsync_value_set_entries_location (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static void decsync_value_take_entries_location (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static gpointer decsync_value_get_entries_location (const GValue* value) G_GNUC_UNUSED ;
static GType decsync_entries_location_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static DecsyncEntriesLocation* decsync_entries_location_new_getNewEntriesLocation (Decsync* decsync,
                                                                            GeeList* path,
                                                                            const gchar* appId);
static DecsyncEntriesLocation* decsync_entries_location_construct_getNewEntriesLocation (GType object_type,
                                                                                  Decsync* decsync,
                                                                                  GeeList* path,
                                                                                  const gchar* appId);
VALA_EXTERN gchar* decsync_entry_toLine (DecsyncEntry* self);
static void decsync_updateStoredEntries (Decsync* self,
                                  DecsyncEntriesLocation* entriesLocation,
                                  GeeCollection* entries);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda16_ (Block2Data* _data2_,
                   const gchar* pathString);
static gchar* __lambda17_ (Decsync* self,
                    gchar* part);
static gpointer ___lambda17__gee_map_func (gpointer g,
                                    gpointer self);
static gboolean __lambda18_ (Decsync* self,
                      gchar* part,
                      gboolean seed);
static gpointer ___lambda18__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static void decsync_executeEntriesLocation (Decsync* self,
                                     DecsyncEntriesLocation* entriesLocation,
                                     gconstpointer extra,
                                     GeePredicate keyPred,
                                     gpointer keyPred_target,
                                     GeePredicate valuePred,
                                     gpointer valuePred_target);
static void ____lambda16__directory_monitor_changed (DirectoryMonitor* _sender,
                                              const gchar* path,
                                              gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda21_ (Decsync* self,
                      GeeList* path);
static gboolean ___lambda21__gee_predicate (gconstpointer g,
                                     gpointer self);
static DecsyncEntriesLocation* __lambda22_ (Decsync* self,
                                     GeeArrayList* path);
static gpointer ___lambda22__gee_map_func (gpointer g,
                                    gpointer self);
static gboolean __lambda23_ (Block3Data* _data3_,
                      DecsyncEntriesLocation* entriesLocation);
static gboolean ___lambda23__gee_forall_func (gpointer g,
                                       gpointer self);
static guint __lambda19_ (Decsync* self,
                   JsonNode* a);
static guint ___lambda19__gee_hash_data_func (gconstpointer v,
                                       gpointer self);
static gboolean __lambda20_ (Decsync* self,
                      JsonNode* a,
                      JsonNode* b);
static gboolean ___lambda20__gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN DecsyncEntry* decsync_entry_fromLine (const gchar* line);
static void decsync_executeEntries (Decsync* self,
                             DecsyncEntriesLocation* entriesLocation,
                             GeeCollection* entries,
                             gconstpointer extra);
static OnEntryUpdateListener* decsync_getListener (Decsync* self,
                                            GeeList* path);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean ____lambda9_ (Block5Data* _data5_,
                       const gchar* line);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean __lambda10_ (Block6Data* _data6_,
                      DecsyncEntry* entry,
                      gboolean seed);
static gpointer ___lambda10__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gboolean _____lambda9__gee_predicate (gconstpointer g,
                                      gpointer self);
static gboolean ___lambda11_ (Block5Data* _data5_,
                       DecsyncEntry* entry);
static gboolean ____lambda11__gee_forall_func (gpointer g,
                                        gpointer self);
static gchar* ___lambda12_ (Decsync* self,
                     DecsyncEntry* entry,
                     gchar* seed);
static gpointer ____lambda12__gee_fold_func (gpointer g,
                                      gpointer a,
                                      gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda24_ (Block7Data* _data7_,
                      GeeArrayList* path);
static DecsyncEntriesLocation* decsync_entries_location_new_getStoredEntriesLocation (Decsync* decsync,
                                                                               GeeList* path);
static DecsyncEntriesLocation* decsync_entries_location_construct_getStoredEntriesLocation (GType object_type,
                                                                                     Decsync* decsync,
                                                                                     GeeList* path);
static gboolean ___lambda24__gee_forall_func (gpointer g,
                                       gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean ___lambda25_ (Block8Data* _data8_,
                       GeeArrayList* path);
static gboolean ____lambda25__gee_forall_func (gpointer g,
                                        gpointer self);
static void decsync_entry_with_path_finalize (DecsyncEntryWithPath * obj);
static GType decsync_entry_with_path_get_type_once (void);
static void decsync_entry_finalize (DecsyncEntry * obj);
static GType decsync_entry_get_type_once (void);
static DecsyncEntriesLocation* decsync_entries_location_new (void);
static DecsyncEntriesLocation* decsync_entries_location_construct (GType object_type);
static void decsync_entries_location_finalize (DecsyncEntriesLocation * obj);
static GType decsync_entries_location_get_type_once (void);
static void decsync_finalize (GObject * obj);
static GType decsync_get_type_once (void);
static void _vala_decsync_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_decsync_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

Unit*
unit_construct (GType object_type)
{
	Unit* self = NULL;
	self = (Unit*) g_type_create_instance (object_type);
	return self;
}

Unit*
unit_new (void)
{
	return unit_construct (TYPE_UNIT);
}

static void
value_unit_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_unit_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		unit_unref (value->data[0].v_pointer);
	}
}

static void
value_unit_copy_value (const GValue* src_value,
                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unit_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_unit_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_unit_collect_value (GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Unit * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unit_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_unit_lcopy_value (const GValue* value,
                        guint n_collect_values,
                        GTypeCValue* collect_values,
                        guint collect_flags)
{
	Unit ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unit_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_unit (const gchar* name,
                 const gchar* nick,
                 const gchar* blurb,
                 GType object_type,
                 GParamFlags flags)
{
	ParamSpecUnit* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNIT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_unit (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNIT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_unit (GValue* value,
                gpointer v_object)
{
	Unit * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNIT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNIT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unit_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unit_unref (old);
	}
}

void
value_take_unit (GValue* value,
                 gpointer v_object)
{
	Unit * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNIT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNIT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unit_unref (old);
	}
}

static void
unit_class_init (UnitClass * klass,
                 gpointer klass_data)
{
	unit_parent_class = g_type_class_peek_parent (klass);
	((UnitClass *) klass)->finalize = unit_finalize;
}

static void
unit_instance_init (Unit * self,
                    gpointer klass)
{
	self->ref_count = 1;
}

static void
unit_finalize (Unit * obj)
{
	Unit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT, Unit);
	g_signal_handlers_destroy (self);
}

/**
 * libdecsync-vala - Decsync.vala
 *
 * Copyright (C) 2018 Aldo Gunsing
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
static GType
unit_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_unit_init, value_unit_free_value, value_unit_copy_value, value_unit_peek_pointer, "p", value_unit_collect_value, "p", value_unit_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UnitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Unit), 0, (GInstanceInitFunc) unit_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType unit_type_id;
	unit_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Unit", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return unit_type_id;
}

GType
unit_get_type (void)
{
	static volatile gsize unit_type_id__once = 0;
	if (g_once_init_enter (&unit_type_id__once)) {
		GType unit_type_id;
		unit_type_id = unit_get_type_once ();
		g_once_init_leave (&unit_type_id__once, unit_type_id);
	}
	return unit_type_id__once;
}

gpointer
unit_ref (gpointer instance)
{
	Unit * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
unit_unref (gpointer instance)
{
	Unit * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNIT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GQuark
decsync_error_quark (void)
{
	return g_quark_from_static_string ("decsync-error-quark");
}

static GType
decsync_error_get_type_once (void)
{
	static const GEnumValue values[] = {{DECSYNC_ERROR_INVALID_INFO, "DECSYNC_ERROR_INVALID_INFO", "invalid-info"}, {DECSYNC_ERROR_UNSUPPORTED_VERSION, "DECSYNC_ERROR_UNSUPPORTED_VERSION", "unsupported-version"}, {0, NULL, NULL}};
	GType decsync_error_type_id;
	decsync_error_type_id = g_enum_register_static ("DecsyncError", values);
	return decsync_error_type_id;
}

GType
decsync_error_get_type (void)
{
	static volatile gsize decsync_error_type_id__once = 0;
	if (g_once_init_enter (&decsync_error_type_id__once)) {
		GType decsync_error_type_id;
		decsync_error_type_id = decsync_error_get_type_once ();
		g_once_init_leave (&decsync_error_type_id__once, decsync_error_type_id);
	}
	return decsync_error_type_id__once;
}

static inline gpointer
decsync_get_instance_private (Decsync* self)
{
	return G_STRUCT_MEMBER_P (self, Decsync_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Decsync*
decsync_construct (GType object_type,
                   GType t_type,
                   GBoxedCopyFunc t_dup_func,
                   GDestroyNotify t_destroy_func,
                   const gchar* dir,
                   const gchar* ownAppId,
                   GeeIterable* listeners,
                   GError** error)
{
	Decsync * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeIterable* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (dir != NULL, NULL);
	g_return_val_if_fail (ownAppId != NULL, NULL);
	g_return_val_if_fail (listeners != NULL, NULL);
	self = (Decsync*) g_object_new (object_type, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = g_strdup (dir);
	_g_free0 (self->priv->dir);
	self->priv->dir = _tmp0_;
	_tmp1_ = g_strdup (ownAppId);
	_g_free0 (self->priv->ownAppId);
	self->priv->ownAppId = _tmp1_;
	_tmp2_ = file_utils_urlencode (ownAppId);
	_g_free0 (self->priv->ownAppIdEncoded);
	self->priv->ownAppIdEncoded = _tmp2_;
	_tmp3_ = _g_object_ref0 (listeners);
	_g_object_unref0 (self->priv->listeners);
	self->priv->listeners = _tmp3_;
	checkDecsyncSubdirInfo (dir, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DECSYNC_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

Decsync*
decsync_new (GType t_type,
             GBoxedCopyFunc t_dup_func,
             GDestroyNotify t_destroy_func,
             const gchar* dir,
             const gchar* ownAppId,
             GeeIterable* listeners,
             GError** error)
{
	return decsync_construct (TYPE_DECSYNC, t_type, t_dup_func, t_destroy_func, dir, ownAppId, listeners, error);
}

/**
 * Associates the given [value] with the given [key] in the map corresponding to the given
 * [path]. This update is sent to synchronized devices.
 */
void
decsync_setEntry (Decsync* self,
                  gchar** pathArray,
                  gint pathArray_length1,
                  JsonNode* key,
                  JsonNode* value)
{
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp0_;
	DecsyncEntry* _tmp1_;
	DecsyncEntry* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = gee_array_list_new (DECSYNC_TYPE_ENTRY, (GBoxedCopyFunc) decsync_entry_ref, (GDestroyNotify) decsync_entry_unref, NULL, NULL, NULL);
	entries = _tmp0_;
	_tmp1_ = decsync_entry_new_now (key, value);
	_tmp2_ = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) entries, _tmp2_);
	_decsync_entry_unref0 (_tmp2_);
	_tmp3_ = toList (pathArray, (gint) pathArray_length1);
	_tmp4_ = _tmp3_;
	decsync_setEntriesForPath (self, _tmp4_, (GeeCollection*) entries);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (entries);
}

/**
 * Like [setEntry], but allows multiple entries to be set. This is more efficient if multiple
 * entries share the same path.
 *
 * @param entriesWithPath entries with path which are inserted.
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Decsync* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->multiMap);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static GeeList*
__lambda13_ (Decsync* self,
             DecsyncEntryWithPath* entryWithPath)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (entryWithPath != NULL, NULL);
	_tmp0_ = entryWithPath->path;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	_decsync_entry_with_path_unref0 (entryWithPath);
	return result;
}

static gpointer
___lambda13__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda13_ ((Decsync*) self, (DecsyncEntryWithPath*) g);
	return result;
}

static gpointer
_decsync_entry_ref0 (gpointer self)
{
	return self ? decsync_entry_ref (self) : NULL;
}

static DecsyncEntry*
__lambda14_ (Decsync* self,
             DecsyncEntryWithPath* entryWithPath)
{
	DecsyncEntry* _tmp0_;
	DecsyncEntry* _tmp1_;
	DecsyncEntry* result;
	g_return_val_if_fail (entryWithPath != NULL, NULL);
	_tmp0_ = entryWithPath->entry;
	_tmp1_ = _decsync_entry_ref0 (_tmp0_);
	result = _tmp1_;
	_decsync_entry_with_path_unref0 (entryWithPath);
	return result;
}

static gpointer
___lambda14__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda14_ ((Decsync*) self, (DecsyncEntryWithPath*) g);
	return result;
}

static gboolean
__lambda15_ (Block1Data* _data1_,
             GeeList* path)
{
	Decsync* self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = gee_multi_map_get (_data1_->multiMap, path);
	_tmp1_ = _tmp0_;
	decsync_setEntriesForPath (self, path, _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	_g_object_unref0 (path);
	return result;
}

static gboolean
___lambda15__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda15_ (self, (GeeList*) g);
	return result;
}

void
decsync_setEntries (Decsync* self,
                    GeeCollection* entriesWithPath)
{
	Block1Data* _data1_;
	GeeMultiMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entriesWithPath != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = groupByPath (DECSYNC_TYPE_ENTRY_WITH_PATH, (GBoxedCopyFunc) decsync_entry_with_path_ref, (GDestroyNotify) decsync_entry_with_path_unref, DECSYNC_TYPE_ENTRY, (GBoxedCopyFunc) decsync_entry_ref, (GDestroyNotify) decsync_entry_unref, entriesWithPath, ___lambda13__gee_map_func, self, ___lambda14__gee_map_func, self);
	_data1_->multiMap = _tmp0_;
	_tmp1_ = gee_multi_map_get_keys (_data1_->multiMap);
	_tmp2_ = _tmp1_;
	gee_traversable_foreach ((GeeTraversable*) _tmp2_, ___lambda15__gee_forall_func, _data1_);
	_g_object_unref0 (_tmp2_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
 * Like [setEntries], but only allows the entries to have the same path. Consequently, it can
 * be slightly more convenient since the path has to be specified just once.
 *
 * @param path path to the map in which the entries are inserted.
 * @param entries entries which are inserted.
 */
static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

void
decsync_setEntriesForPath (Decsync* self,
                           GeeList* path,
                           GeeCollection* entries)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	DecsyncEntriesLocation* entriesLocation = NULL;
	const gchar* _tmp4_;
	DecsyncEntriesLocation* _tmp5_;
	GString* builder = NULL;
	GString* _tmp6_;
	DecsyncEntriesLocation* _tmp52_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = file_utils_pathToString (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Write to path ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	log_d (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->ownAppId;
	_tmp5_ = decsync_entries_location_new_getNewEntriesLocation (self, path, _tmp4_);
	entriesLocation = _tmp5_;
	_tmp6_ = g_string_new ("");
	builder = _tmp6_;
	{
		GeeIterator* _entry_it = NULL;
		GeeIterator* _tmp7_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) entries);
		_entry_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			DecsyncEntry* entry = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GString* _tmp11_;
			DecsyncEntry* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp8_ = _entry_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _entry_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			entry = (DecsyncEntry*) _tmp10_;
			_tmp11_ = builder;
			_tmp12_ = entry;
			_tmp13_ = decsync_entry_toLine (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
			_tmp16_ = _tmp15_;
			g_string_append (_tmp11_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_decsync_entry_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	{
		DecsyncEntriesLocation* _tmp17_;
		GFile* _tmp18_;
		GString* _tmp19_;
		const gchar* _tmp20_;
		_tmp17_ = entriesLocation;
		_tmp18_ = _tmp17_->newEntriesFile;
		_tmp19_ = builder;
		_tmp20_ = _tmp19_->str;
		file_utils_writeFile (_tmp18_, _tmp20_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		log_w (_tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (builder);
		_decsync_entries_location_unref0 (entriesLocation);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	while (TRUE) {
		gboolean _tmp23_;
		gboolean _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gpointer _tmp27_;
		gchar* _tmp28_;
		GFile* dir = NULL;
		const gchar* _tmp29_;
		DecsyncEntriesLocation* _tmp30_;
		DecsyncEntriesLocation* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
		GFile* file = NULL;
		GFile* _tmp35_;
		GFile* _tmp36_;
		gint64 version = 0LL;
		GFile* _tmp37_;
		_tmp23_ = gee_collection_get_is_empty ((GeeCollection*) path);
		_tmp24_ = _tmp23_;
		if (!(!_tmp24_)) {
			break;
		}
		_tmp25_ = gee_collection_get_size ((GeeCollection*) path);
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_list_remove_at (path, _tmp26_ - 1);
		_tmp28_ = (gchar*) _tmp27_;
		_g_free0 (_tmp28_);
		_tmp29_ = self->priv->ownAppId;
		_tmp30_ = decsync_entries_location_new_getNewEntriesLocation (self, path, _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_->newEntriesFile;
		_tmp33_ = _g_object_ref0 (_tmp32_);
		_tmp34_ = _tmp33_;
		_decsync_entries_location_unref0 (_tmp31_);
		dir = _tmp34_;
		_tmp35_ = dir;
		_tmp36_ = g_file_get_child (_tmp35_, ".decsync-sequence");
		file = _tmp36_;
		version = (gint64) 0;
		_tmp37_ = file;
		if (g_file_query_exists (_tmp37_, NULL)) {
			{
				GFileInputStream* _tmp38_ = NULL;
				GFile* _tmp39_;
				GFileInputStream* _tmp40_;
				GDataInputStream* stream = NULL;
				GDataInputStream* _tmp41_;
				gchar* _tmp42_ = NULL;
				GDataInputStream* _tmp43_;
				gchar* _tmp44_;
				_tmp39_ = file;
				_tmp40_ = g_file_read (_tmp39_, NULL, &_inner_error0_);
				_tmp38_ = _tmp40_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp41_ = g_data_input_stream_new ((GInputStream*) _tmp38_);
				stream = _tmp41_;
				_tmp43_ = stream;
				_tmp44_ = g_data_input_stream_read_line (_tmp43_, NULL, NULL, &_inner_error0_);
				_tmp42_ = _tmp44_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (stream);
					_g_object_unref0 (_tmp38_);
					goto __catch1_g_error;
				}
				version = int64_parse (_tmp42_, (guint) 0);
				_g_free0 (_tmp42_);
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp38_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp45_;
				const gchar* _tmp46_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp45_ = e;
				_tmp46_ = _tmp45_->message;
				log_w (_tmp46_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (dir);
				_g_string_free0 (builder);
				_decsync_entries_location_unref0 (entriesLocation);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		{
			GFile* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp47_ = file;
			_tmp48_ = g_strdup_printf ("%" G_GINT64_FORMAT, version + 1);
			_tmp49_ = _tmp48_;
			file_utils_writeFile (_tmp47_, _tmp49_, FALSE, &_inner_error0_);
			_g_free0 (_tmp49_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp50_;
			const gchar* _tmp51_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp50_ = e;
			_tmp51_ = _tmp50_->message;
			log_w (_tmp51_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_object_unref0 (dir);
			_g_string_free0 (builder);
			_decsync_entries_location_unref0 (entriesLocation);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (file);
		_g_object_unref0 (dir);
	}
	_tmp52_ = entriesLocation;
	decsync_updateStoredEntries (self, _tmp52_, entries);
	_g_string_free0 (builder);
	_decsync_entries_location_unref0 (entriesLocation);
}

/**
 * Initializes the monitor which watches the filesystem for updated entries and executes the
 * corresponding actions.
 *
 * @param extra extra data passed to the [listeners].
 */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Decsync* self;
		self = _data2_->self;
		((_data2_->extra == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_data2_->extra = (self->priv->t_destroy_func (_data2_->extra), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
__lambda17_ (Decsync* self,
             gchar* part)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (part != NULL, NULL);
	_tmp0_ = file_utils_urldecode (part);
	result = _tmp0_;
	_g_free0 (part);
	return result;
}

static gpointer
___lambda17__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda17_ ((Decsync*) self, (gchar*) g);
	return result;
}

static gboolean
__lambda18_ (Decsync* self,
             gchar* part,
             gboolean seed)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (part != NULL, FALSE);
	if (part == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = seed;
	}
	result = _tmp0_;
	_g_free0 (part);
	return result;
}

static gpointer
___lambda18__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda18_ ((Decsync*) self, (gchar*) g, (gboolean) ((gintptr) a)));
	return result;
}

static void
___lambda16_ (Block2Data* _data2_,
              const gchar* pathString)
{
	Decsync* self;
	GeeArrayList* pathEncoded = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeArrayList* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GeeArrayList* path = NULL;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	GeeArrayList* _tmp16_;
	gpointer _tmp17_;
	gchar* appId = NULL;
	GeeArrayList* _tmp20_;
	gpointer _tmp21_;
	GeeArrayList* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	DecsyncEntriesLocation* entriesLocation = NULL;
	GeeArrayList* _tmp25_;
	const gchar* _tmp26_;
	DecsyncEntriesLocation* _tmp27_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	self = _data2_->self;
	g_return_if_fail (pathString != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (pathString, "/", 0);
	_tmp2_ = gee_array_list_new_wrap (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_, _vala_array_length (_tmp0_), NULL, NULL, NULL);
	pathEncoded = _tmp2_;
	_tmp3_ = pathEncoded;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, "");
	_tmp5_ = pathEncoded;
	_tmp6_ = gee_collection_get_is_empty ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp4_ = TRUE;
	} else {
		GeeArrayList* _tmp8_;
		gpointer _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = pathEncoded;
		_tmp9_ = gee_list_last ((GeeList*) _tmp8_);
		_tmp10_ = (gchar*) _tmp9_;
		_tmp4_ = string_get (_tmp10_, (glong) 0) == '.';
		_g_free0 (_tmp10_);
	}
	if (_tmp4_) {
		_g_object_unref0 (pathEncoded);
		return;
	}
	_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	path = _tmp11_;
	_tmp12_ = path;
	_tmp13_ = pathEncoded;
	_tmp14_ = gee_traversable_map ((GeeTraversable*) _tmp13_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ___lambda17__gee_map_func, self);
	_tmp15_ = _tmp14_;
	gee_collection_add_all_iterator ((GeeCollection*) _tmp12_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = path;
	_tmp17_ = gee_traversable_fold ((GeeTraversable*) _tmp16_, G_TYPE_BOOLEAN, NULL, NULL, ___lambda18__gee_fold_func, self, (gpointer) ((gintptr) FALSE));
	if ((gboolean) ((gintptr) _tmp17_)) {
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = g_strconcat ("Cannot decode path ", pathString, NULL);
		_tmp19_ = _tmp18_;
		log_w (_tmp19_);
		_g_free0 (_tmp19_);
		_g_object_unref0 (path);
		_g_object_unref0 (pathEncoded);
		return;
	}
	_tmp20_ = path;
	_tmp21_ = gee_list_first ((GeeList*) _tmp20_);
	appId = (gchar*) _tmp21_;
	_tmp22_ = path;
	_tmp23_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp22_, 0);
	_tmp24_ = (gchar*) _tmp23_;
	_g_free0 (_tmp24_);
	_tmp25_ = path;
	_tmp26_ = appId;
	_tmp27_ = decsync_entries_location_new_getNewEntriesLocation (self, (GeeList*) _tmp25_, _tmp26_);
	entriesLocation = _tmp27_;
	_tmp29_ = appId;
	_tmp30_ = self->priv->ownAppId;
	if (g_strcmp0 (_tmp29_, _tmp30_) != 0) {
		DecsyncEntriesLocation* _tmp31_;
		GFile* _tmp32_;
		_tmp31_ = entriesLocation;
		_tmp32_ = _tmp31_->newEntriesFile;
		_tmp28_ = g_file_query_file_type (_tmp32_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_REGULAR;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		DecsyncEntriesLocation* _tmp33_;
		_tmp33_ = entriesLocation;
		decsync_executeEntriesLocation (self, _tmp33_, _data2_->extra, NULL, NULL, NULL, NULL);
		log_d ("Sync complete");
		g_signal_emit (self, decsync_signals[DECSYNC_SYNC_COMPLETE_SIGNAL], 0, _data2_->extra);
	}
	_decsync_entries_location_unref0 (entriesLocation);
	_g_free0 (appId);
	_g_object_unref0 (path);
	_g_object_unref0 (pathEncoded);
}

static void
____lambda16__directory_monitor_changed (DirectoryMonitor* _sender,
                                         const gchar* path,
                                         gpointer self)
{
	___lambda16_ (self, path);
}

void
decsync_initMonitor (Decsync* self,
                     gconstpointer extra)
{
	Block2Data* _data2_;
	gpointer _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = ((extra != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) extra) : ((gpointer) extra);
	((_data2_->extra == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_data2_->extra = (self->priv->t_destroy_func (_data2_->extra), NULL));
	_data2_->extra = _tmp0_;
	{
		GFile* newEntriesDir = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* parent = NULL;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		DirectoryMonitor* _tmp10_ = NULL;
		GFile* _tmp11_;
		DirectoryMonitor* _tmp12_;
		DirectoryMonitor* _tmp13_;
		DirectoryMonitor* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp1_ = self->priv->dir;
		_tmp2_ = g_strconcat (_tmp1_, "/new-entries", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		newEntriesDir = _tmp5_;
		_tmp6_ = newEntriesDir;
		_tmp7_ = g_file_get_parent (_tmp6_);
		parent = _tmp7_;
		_tmp8_ = parent;
		if (!g_file_query_exists (_tmp8_, NULL)) {
			GFile* _tmp9_;
			_tmp9_ = parent;
			g_file_make_directory_with_parents (_tmp9_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parent);
				_g_object_unref0 (newEntriesDir);
				goto __catch0_g_error;
			}
		}
		_tmp11_ = newEntriesDir;
		_tmp12_ = directory_monitor_new (_tmp11_, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parent);
			_g_object_unref0 (newEntriesDir);
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp13_;
		_tmp14_ = self->priv->monitor;
		g_signal_connect_data (_tmp14_, "changed", (GCallback) ____lambda16__directory_monitor_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp15_ = self->priv->dir;
		_tmp16_ = g_strconcat ("Initialized folder monitor for ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, "/new-entries", NULL);
		_tmp19_ = _tmp18_;
		log_d (_tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (parent);
		_g_object_unref0 (newEntriesDir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		log_w (_tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

/**
 * Gets all updated entries and executes the corresponding actions.
 *
 * @param extra extra data passed to the [listeners].
 */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Decsync* self;
		self = _data3_->self;
		((_data3_->extra == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_data3_->extra = (self->priv->t_destroy_func (_data3_->extra), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda21_ (Decsync* self,
             GeeList* path)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) path);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gpointer _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = gee_list_first (path);
		_tmp4_ = (gchar*) _tmp3_;
		_tmp5_ = self->priv->ownAppId;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
		_g_free0 (_tmp4_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
___lambda21__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda21_ ((Decsync*) self, (GeeList*) g);
	return result;
}

static DecsyncEntriesLocation*
__lambda22_ (Decsync* self,
             GeeArrayList* path)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	DecsyncEntriesLocation* _tmp6_;
	DecsyncEntriesLocation* _tmp7_;
	DecsyncEntriesLocation* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_list_slice ((GeeAbstractList*) path, 1, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_list_first ((GeeList*) path);
	_tmp5_ = (gchar*) _tmp4_;
	_tmp6_ = decsync_entries_location_new_getNewEntriesLocation (self, _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	result = _tmp7_;
	_g_object_unref0 (path);
	return result;
}

static gpointer
___lambda22__gee_map_func (gpointer g,
                           gpointer self)
{
	gpointer result;
	result = __lambda22_ ((Decsync*) self, (GeeArrayList*) g);
	return result;
}

static gboolean
__lambda23_ (Block3Data* _data3_,
             DecsyncEntriesLocation* entriesLocation)
{
	Decsync* self;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (entriesLocation != NULL, FALSE);
	decsync_executeEntriesLocation (self, entriesLocation, _data3_->extra, NULL, NULL, NULL, NULL);
	result = TRUE;
	_decsync_entries_location_unref0 (entriesLocation);
	return result;
}

static gboolean
___lambda23__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda23_ (self, (DecsyncEntriesLocation*) g);
	return result;
}

void
decsync_executeAllNewEntries (Decsync* self,
                              gconstpointer extra)
{
	Block3Data* _data3_;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* newEntriesDir = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* readBytesDir = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GeePredicate pathPred = NULL;
	gpointer pathPred_target;
	GDestroyNotify pathPred_target_destroy_notify;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = ((extra != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) extra) : ((gpointer) extra);
	((_data3_->extra == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_data3_->extra = (self->priv->t_destroy_func (_data3_->extra), NULL));
	_data3_->extra = _tmp0_;
	_tmp1_ = self->priv->dir;
	_tmp2_ = g_strconcat ("Execute all new entries in ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	log_d (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->dir;
	_tmp5_ = g_strconcat (_tmp4_, "/new-entries", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	newEntriesDir = _tmp8_;
	_tmp9_ = self->priv->dir;
	_tmp10_ = g_strconcat (_tmp9_, "/read-bytes/", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->ownAppIdEncoded;
	_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_new_for_path (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	readBytesDir = _tmp16_;
	pathPred = ___lambda21__gee_predicate;
	pathPred_target = g_object_ref (self);
	pathPred_target_destroy_notify = g_object_unref;
	_tmp17_ = file_utils_listFilesRecursiveRelative (newEntriesDir, readBytesDir, pathPred, pathPred_target);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_traversable_map ((GeeTraversable*) _tmp18_, DECSYNC_TYPE_ENTRIES_LOCATION, (GBoxedCopyFunc) decsync_entries_location_ref, (GDestroyNotify) decsync_entries_location_unref, ___lambda22__gee_map_func, self);
	_tmp20_ = _tmp19_;
	gee_traversable_foreach ((GeeTraversable*) _tmp20_, ___lambda23__gee_forall_func, _data3_);
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (_tmp18_);
	log_d ("Sync complete");
	g_signal_emit (self, decsync_signals[DECSYNC_SYNC_COMPLETE_SIGNAL], 0, _data3_->extra);
	(pathPred_target_destroy_notify == NULL) ? NULL : (pathPred_target_destroy_notify (pathPred_target), NULL);
	pathPred = NULL;
	pathPred_target = NULL;
	pathPred_target_destroy_notify = NULL;
	_g_object_unref0 (readBytesDir);
	_g_object_unref0 (newEntriesDir);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static guint
__lambda19_ (Decsync* self,
             JsonNode* a)
{
	guint result;
	g_return_val_if_fail (a != NULL, 0U);
	result = json_node_hash (a);
	return result;
}

static guint
___lambda19__gee_hash_data_func (gconstpointer v,
                                 gpointer self)
{
	guint result;
	result = __lambda19_ ((Decsync*) self, (JsonNode*) v);
	return result;
}

static gboolean
__lambda20_ (Decsync* self,
             JsonNode* a,
             JsonNode* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = json_node_equal (a, b);
	return result;
}

static gboolean
___lambda20__gee_equal_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gboolean result;
	result = __lambda20_ ((Decsync*) self, (JsonNode*) a, (JsonNode*) b);
	return result;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
decsync_executeEntriesLocation (Decsync* self,
                                DecsyncEntriesLocation* entriesLocation,
                                gconstpointer extra,
                                GeePredicate keyPred,
                                gpointer keyPred_target,
                                GeePredicate valuePred,
                                gpointer valuePred_target)
{
	gint64 readBytes = 0LL;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GFile* _tmp12_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GeeHashMap* entriesMap = NULL;
	GeeHashMap* _tmp26_;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp64_;
	GeeArrayList* _tmp65_;
	GeeHashMap* _tmp66_;
	GeeCollection* _tmp67_;
	GeeCollection* _tmp68_;
	GeeCollection* _tmp69_;
	GeeArrayList* _tmp70_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entriesLocation != NULL);
	readBytes = (gint64) 0;
	_tmp1_ = entriesLocation->readBytesFile;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		_tmp2_ = entriesLocation->readBytesFile;
		_tmp0_ = g_file_query_exists (_tmp2_, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			GFileInputStream* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileInputStream* _tmp5_;
			GDataInputStream* stream = NULL;
			GDataInputStream* _tmp6_;
			gchar* _tmp7_ = NULL;
			GDataInputStream* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = entriesLocation->readBytesFile;
			_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
			stream = _tmp6_;
			_tmp8_ = stream;
			_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp3_);
				goto __catch0_g_error;
			}
			readBytes = int64_parse (_tmp7_, (guint) 0);
			_g_free0 (_tmp7_);
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			log_w (_tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = entriesLocation->readBytesFile;
	if (_tmp12_ != NULL) {
		{
			GFileInfo* _tmp13_ = NULL;
			GFile* _tmp14_;
			GFileInfo* _tmp15_;
			gint64 size = 0LL;
			GFile* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = entriesLocation->newEntriesFile;
			_tmp15_ = g_file_query_info (_tmp14_, "standard::size", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			_tmp13_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			size = g_file_info_get_size (_tmp13_);
			if (readBytes >= size) {
				_g_object_unref0 (_tmp13_);
				return;
			}
			_tmp16_ = entriesLocation->readBytesFile;
			_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, size);
			_tmp18_ = _tmp17_;
			file_utils_writeFile (_tmp16_, _tmp18_, FALSE, &_inner_error0_);
			_g_free0 (_tmp18_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp13_);
				goto __catch1_g_error;
			}
			_g_object_unref0 (_tmp13_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			log_w (_tmp20_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp21_ = entriesLocation->newEntriesFile;
	_tmp22_ = g_file_get_path (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat ("Execute entries of ", _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	log_d (_tmp25_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_tmp26_ = gee_hash_map_new (json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, (GDestroyNotify) _vala_JsonNode_free, DECSYNC_TYPE_ENTRY, (GBoxedCopyFunc) decsync_entry_ref, (GDestroyNotify) decsync_entry_unref, ___lambda19__gee_hash_data_func, g_object_ref (self), g_object_unref, ___lambda20__gee_equal_data_func, g_object_ref (self), g_object_unref, NULL, NULL, NULL);
	entriesMap = _tmp26_;
	{
		GFileInputStream* _tmp27_ = NULL;
		GFile* _tmp28_;
		GFileInputStream* _tmp29_;
		GDataInputStream* stream = NULL;
		GDataInputStream* _tmp30_;
		GDataInputStream* _tmp31_;
		gchar* line = NULL;
		_tmp28_ = entriesLocation->newEntriesFile;
		_tmp29_ = g_file_read (_tmp28_, NULL, &_inner_error0_);
		_tmp27_ = _tmp29_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp30_ = g_data_input_stream_new ((GInputStream*) _tmp27_);
		stream = _tmp30_;
		_tmp31_ = stream;
		g_seekable_seek ((GSeekable*) _tmp31_, readBytes, G_SEEK_SET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp27_);
			goto __catch2_g_error;
		}
		while (TRUE) {
			gchar* _tmp32_ = NULL;
			GDataInputStream* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			const gchar* _tmp36_;
			DecsyncEntry* entryLine = NULL;
			const gchar* _tmp37_;
			DecsyncEntry* _tmp38_;
			DecsyncEntry* _tmp39_;
			gboolean _tmp40_ = FALSE;
			gboolean _tmp41_ = FALSE;
			_tmp33_ = stream;
			_tmp34_ = g_data_input_stream_read_line (_tmp33_, NULL, NULL, &_inner_error0_);
			_tmp32_ = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp27_);
				goto __catch2_g_error;
			}
			_tmp35_ = _tmp32_;
			_tmp32_ = NULL;
			_g_free0 (line);
			line = _tmp35_;
			_tmp36_ = line;
			if (!(_tmp36_ != NULL)) {
				_g_free0 (_tmp32_);
				break;
			}
			_tmp37_ = line;
			_tmp38_ = decsync_entry_fromLine (_tmp37_);
			entryLine = _tmp38_;
			_tmp39_ = entryLine;
			if (_tmp39_ == NULL) {
				_decsync_entry_unref0 (entryLine);
				_g_free0 (_tmp32_);
				continue;
			}
			if (keyPred == NULL) {
				_tmp41_ = TRUE;
			} else {
				DecsyncEntry* _tmp42_;
				JsonNode* _tmp43_;
				_tmp42_ = entryLine;
				_tmp43_ = _tmp42_->key;
				_tmp41_ = keyPred (_tmp43_, keyPred_target);
			}
			if (_tmp41_) {
				gboolean _tmp44_ = FALSE;
				if (valuePred == NULL) {
					_tmp44_ = TRUE;
				} else {
					DecsyncEntry* _tmp45_;
					JsonNode* _tmp46_;
					_tmp45_ = entryLine;
					_tmp46_ = _tmp45_->value;
					_tmp44_ = valuePred (_tmp46_, valuePred_target);
				}
				_tmp40_ = _tmp44_;
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				JsonNode* key = NULL;
				DecsyncEntry* _tmp47_;
				JsonNode* _tmp48_;
				JsonNode* _tmp49_;
				DecsyncEntry* entry = NULL;
				GeeHashMap* _tmp50_;
				JsonNode* _tmp51_;
				gpointer _tmp52_;
				gboolean _tmp53_ = FALSE;
				DecsyncEntry* _tmp54_;
				_tmp47_ = entryLine;
				_tmp48_ = _tmp47_->key;
				_tmp49_ = __vala_JsonNode_copy0 (_tmp48_);
				key = _tmp49_;
				_tmp50_ = entriesMap;
				_tmp51_ = key;
				_tmp52_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp50_, _tmp51_);
				entry = (DecsyncEntry*) _tmp52_;
				_tmp54_ = entry;
				if (_tmp54_ == NULL) {
					_tmp53_ = TRUE;
				} else {
					DecsyncEntry* _tmp55_;
					const gchar* _tmp56_;
					DecsyncEntry* _tmp57_;
					const gchar* _tmp58_;
					_tmp55_ = entryLine;
					_tmp56_ = _tmp55_->datetime;
					_tmp57_ = entry;
					_tmp58_ = _tmp57_->datetime;
					_tmp53_ = g_strcmp0 (_tmp56_, _tmp58_) > 0;
				}
				if (_tmp53_) {
					GeeHashMap* _tmp59_;
					JsonNode* _tmp60_;
					DecsyncEntry* _tmp61_;
					_tmp59_ = entriesMap;
					_tmp60_ = key;
					_tmp61_ = entryLine;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp59_, _tmp60_, _tmp61_);
				}
				_decsync_entry_unref0 (entry);
				__vala_JsonNode_free0 (key);
			}
			_decsync_entry_unref0 (entryLine);
			_g_free0 (_tmp32_);
		}
		_g_free0 (line);
		_g_object_unref0 (stream);
		_g_object_unref0 (_tmp27_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp62_;
		const gchar* _tmp63_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp62_ = e;
		_tmp63_ = _tmp62_->message;
		log_w (_tmp63_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (entriesMap);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp64_ = gee_array_list_new (DECSYNC_TYPE_ENTRY, (GBoxedCopyFunc) decsync_entry_ref, (GDestroyNotify) decsync_entry_unref, NULL, NULL, NULL);
	entries = _tmp64_;
	_tmp65_ = entries;
	_tmp66_ = entriesMap;
	_tmp67_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = _tmp68_;
	gee_array_list_add_all (_tmp65_, _tmp69_);
	_g_object_unref0 (_tmp69_);
	_tmp70_ = entries;
	decsync_executeEntries (self, entriesLocation, (GeeCollection*) _tmp70_, extra);
	_g_object_unref0 (entries);
	_g_object_unref0 (entriesMap);
}

static void
decsync_executeEntries (Decsync* self,
                        DecsyncEntriesLocation* entriesLocation,
                        GeeCollection* entries,
                        gconstpointer extra)
{
	OnEntryUpdateListener* listener = NULL;
	GeeList* _tmp0_;
	OnEntryUpdateListener* _tmp1_;
	OnEntryUpdateListener* _tmp2_;
	OnEntryUpdateListener* _tmp8_;
	GeeList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entriesLocation != NULL);
	g_return_if_fail (entries != NULL);
	decsync_updateStoredEntries (self, entriesLocation, entries);
	_tmp0_ = entriesLocation->path;
	_tmp1_ = decsync_getListener (self, _tmp0_);
	listener = _tmp1_;
	_tmp2_ = listener;
	if (_tmp2_ == NULL) {
		GeeList* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = entriesLocation->path;
		_tmp4_ = file_utils_pathToString (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("Unknown action for path ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		log_e (_tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_object_unref0 (listener);
		return;
	}
	_tmp8_ = listener;
	_tmp9_ = entriesLocation->path;
	on_entry_update_listener_onEntriesUpdate (_tmp8_, _tmp9_, entries, extra);
	_g_object_unref0 (listener);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Decsync* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->entries);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Decsync* self;
		self = _data5_->_data4_->self;
		_g_string_free0 (_data5_->builder);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		Decsync* self;
		self = _data6_->_data5_->_data4_->self;
		_decsync_entry_unref0 (_data6_->entryLine);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
__lambda10_ (Block6Data* _data6_,
             DecsyncEntry* entry,
             gboolean seed)
{
	Block5Data* _data5_;
	Block4Data* _data4_;
	Decsync* self;
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	DecsyncEntry* _tmp2_;
	JsonNode* _tmp3_;
	gboolean result;
	_data5_ = _data6_->_data5_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp1_ = entry->key;
	_tmp2_ = _data6_->entryLine;
	_tmp3_ = _tmp2_->key;
	if (!json_node_equal (_tmp1_, _tmp3_)) {
		_tmp0_ = seed;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	_decsync_entry_unref0 (entry);
	return result;
}

static gpointer
___lambda10__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda10_ (self, (DecsyncEntry*) g, (gboolean) ((gintptr) a)));
	return result;
}

static gboolean
____lambda9_ (Block5Data* _data5_,
              const gchar* line)
{
	Block4Data* _data4_;
	Decsync* self;
	Block6Data* _data6_;
	DecsyncEntry* _tmp0_;
	DecsyncEntry* _tmp1_;
	gpointer _tmp2_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_val_if_fail (line != NULL, FALSE);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->_data5_ = block5_data_ref (_data5_);
	_tmp0_ = decsync_entry_fromLine (line);
	_data6_->entryLine = _tmp0_;
	_tmp1_ = _data6_->entryLine;
	if (_tmp1_ == NULL) {
		result = FALSE;
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return result;
	}
	_tmp2_ = gee_traversable_fold ((GeeTraversable*) _data4_->entries, G_TYPE_BOOLEAN, NULL, NULL, ___lambda10__gee_fold_func, _data6_, (gpointer) ((gintptr) TRUE));
	result = (gboolean) ((gintptr) _tmp2_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

static gboolean
_____lambda9__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = ____lambda9_ (self, (const gchar*) g);
	return result;
}

static gboolean
___lambda11_ (Block5Data* _data5_,
              DecsyncEntry* entry)
{
	Block4Data* _data4_;
	Decsync* self;
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = _data5_->builder;
	_tmp1_ = decsync_entry_toLine (entry);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	g_string_append (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = TRUE;
	_decsync_entry_unref0 (entry);
	return result;
}

static gboolean
____lambda11__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda11_ (self, (DecsyncEntry*) g);
	return result;
}

static gchar*
___lambda12_ (Decsync* self,
              DecsyncEntry* entry,
              gchar* seed)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (entry != NULL, NULL);
	if (seed == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = entry->datetime;
		_tmp0_ = g_strcmp0 (_tmp1_, seed) > 0;
	}
	if (_tmp0_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = entry->datetime;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		_decsync_entry_unref0 (entry);
		_g_free0 (seed);
		return result;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (seed);
		result = _tmp4_;
		_decsync_entry_unref0 (entry);
		_g_free0 (seed);
		return result;
	}
}

static gpointer
____lambda12__gee_fold_func (gpointer g,
                             gpointer a,
                             gpointer self)
{
	gpointer result;
	result = ___lambda12_ ((Decsync*) self, (DecsyncEntry*) g, (gchar*) a);
	return result;
}

static void
decsync_updateStoredEntries (Decsync* self,
                             DecsyncEntriesLocation* entriesLocation,
                             GeeCollection* entries)
{
	Block4Data* _data4_;
	GeeCollection* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entriesLocation != NULL);
	g_return_if_fail (entries != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (entries);
	_g_object_unref0 (_data4_->entries);
	_data4_->entries = _tmp0_;
	_tmp1_ = entriesLocation->storedEntriesFile;
	if (_tmp1_ == NULL) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	{
		Block5Data* _data5_;
		gboolean haveToFilterFile = FALSE;
		GFile* _tmp2_;
		GString* _tmp30_;
		GFile* _tmp31_;
		GString* _tmp32_;
		const gchar* _tmp33_;
		gchar* maxDatetime = NULL;
		gpointer _tmp34_;
		const gchar* _tmp35_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		haveToFilterFile = FALSE;
		_tmp2_ = entriesLocation->storedEntriesFile;
		if (g_file_query_exists (_tmp2_, NULL)) {
			GFileInputStream* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileInputStream* _tmp5_;
			GDataInputStream* stream = NULL;
			GDataInputStream* _tmp6_;
			gchar* line = NULL;
			_tmp4_ = entriesLocation->storedEntriesFile;
			_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block5_data_unref (_data5_);
				_data5_ = NULL;
				goto __catch0_g_error;
			}
			_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
			stream = _tmp6_;
			while (TRUE) {
				gchar* _tmp7_ = NULL;
				GDataInputStream* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				DecsyncEntry* entryLine = NULL;
				const gchar* _tmp12_;
				DecsyncEntry* _tmp13_;
				DecsyncEntry* _tmp14_;
				GeeIterator* entriesIterator = NULL;
				GeeIterator* _tmp15_;
				_tmp8_ = stream;
				_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error0_);
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (stream);
					_g_object_unref0 (_tmp3_);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					goto __catch0_g_error;
				}
				_tmp10_ = _tmp7_;
				_tmp7_ = NULL;
				_g_free0 (line);
				line = _tmp10_;
				_tmp11_ = line;
				if (!(_tmp11_ != NULL)) {
					_g_free0 (_tmp7_);
					break;
				}
				_tmp12_ = line;
				_tmp13_ = decsync_entry_fromLine (_tmp12_);
				entryLine = _tmp13_;
				_tmp14_ = entryLine;
				if (_tmp14_ == NULL) {
					_decsync_entry_unref0 (entryLine);
					_g_free0 (_tmp7_);
					continue;
				}
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _data4_->entries);
				entriesIterator = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					GeeIterator* _tmp17_;
					DecsyncEntry* entry = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					DecsyncEntry* _tmp20_;
					JsonNode* _tmp21_;
					DecsyncEntry* _tmp22_;
					JsonNode* _tmp23_;
					_tmp16_ = entriesIterator;
					if (!gee_iterator_has_next (_tmp16_)) {
						break;
					}
					_tmp17_ = entriesIterator;
					gee_iterator_next (_tmp17_);
					_tmp18_ = entriesIterator;
					_tmp19_ = gee_iterator_get (_tmp18_);
					entry = (DecsyncEntry*) _tmp19_;
					_tmp20_ = entry;
					_tmp21_ = _tmp20_->key;
					_tmp22_ = entryLine;
					_tmp23_ = _tmp22_->key;
					if (json_node_equal (_tmp21_, _tmp23_)) {
						DecsyncEntry* _tmp24_;
						const gchar* _tmp25_;
						DecsyncEntry* _tmp26_;
						const gchar* _tmp27_;
						_tmp24_ = entry;
						_tmp25_ = _tmp24_->datetime;
						_tmp26_ = entryLine;
						_tmp27_ = _tmp26_->datetime;
						if (g_strcmp0 (_tmp25_, _tmp27_) > 0) {
							haveToFilterFile = TRUE;
						} else {
							GeeIterator* _tmp28_;
							_tmp28_ = entriesIterator;
							gee_iterator_remove (_tmp28_);
						}
					}
					_decsync_entry_unref0 (entry);
				}
				_g_object_unref0 (entriesIterator);
				_decsync_entry_unref0 (entryLine);
				_g_free0 (_tmp7_);
			}
			_g_free0 (line);
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp3_);
		}
		if (haveToFilterFile) {
			GFile* _tmp29_;
			_tmp29_ = entriesLocation->storedEntriesFile;
			file_utils_filterFile (_tmp29_, _____lambda9__gee_predicate, _data5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block5_data_unref (_data5_);
				_data5_ = NULL;
				goto __catch0_g_error;
			}
		}
		_tmp30_ = g_string_new ("");
		_data5_->builder = _tmp30_;
		gee_traversable_foreach ((GeeTraversable*) _data4_->entries, ____lambda11__gee_forall_func, _data5_);
		_tmp31_ = entriesLocation->storedEntriesFile;
		_tmp32_ = _data5_->builder;
		_tmp33_ = _tmp32_->str;
		file_utils_writeFile (_tmp31_, _tmp33_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block5_data_unref (_data5_);
			_data5_ = NULL;
			goto __catch0_g_error;
		}
		_tmp34_ = gee_traversable_fold ((GeeTraversable*) _data4_->entries, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ____lambda12__gee_fold_func, self, NULL);
		maxDatetime = (gchar*) _tmp34_;
		_tmp35_ = maxDatetime;
		if (_tmp35_ != NULL) {
			GFile* latestStoredEntryFile = NULL;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			GFile* _tmp44_;
			GFile* _tmp45_;
			gchar* latestDatetime = NULL;
			gboolean _tmp56_ = FALSE;
			const gchar* _tmp57_;
			_tmp36_ = self->priv->dir;
			_tmp37_ = g_strconcat (_tmp36_, "/info/", NULL);
			_tmp38_ = _tmp37_;
			_tmp39_ = self->priv->ownAppIdEncoded;
			_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, "/latest-stored-entry", NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_file_new_for_path (_tmp43_);
			_tmp45_ = _tmp44_;
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp38_);
			latestStoredEntryFile = _tmp45_;
			latestDatetime = NULL;
			{
				GFileInputStream* _tmp46_ = NULL;
				GFile* _tmp47_;
				GFileInputStream* _tmp48_;
				GDataInputStream* stream = NULL;
				GDataInputStream* _tmp49_;
				gchar* _tmp50_ = NULL;
				GDataInputStream* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp47_ = latestStoredEntryFile;
				_tmp48_ = g_file_read (_tmp47_, NULL, &_inner_error0_);
				_tmp46_ = _tmp48_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp49_ = g_data_input_stream_new ((GInputStream*) _tmp46_);
				stream = _tmp49_;
				_tmp51_ = stream;
				_tmp52_ = g_data_input_stream_read_line (_tmp51_, NULL, NULL, &_inner_error0_);
				_tmp50_ = _tmp52_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (stream);
					_g_object_unref0 (_tmp46_);
					goto __catch1_g_error;
				}
				_tmp53_ = _tmp50_;
				_tmp50_ = NULL;
				_g_free0 (latestDatetime);
				latestDatetime = _tmp53_;
				_g_free0 (_tmp50_);
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp46_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp54_;
				const gchar* _tmp55_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp54_ = e;
				_tmp55_ = _tmp54_->message;
				log_w (_tmp55_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (latestDatetime);
				_g_object_unref0 (latestStoredEntryFile);
				_g_free0 (maxDatetime);
				block5_data_unref (_data5_);
				_data5_ = NULL;
				goto __catch0_g_error;
			}
			_tmp57_ = latestDatetime;
			if (_tmp57_ == NULL) {
				_tmp56_ = TRUE;
			} else {
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				_tmp58_ = maxDatetime;
				_tmp59_ = latestDatetime;
				_tmp56_ = g_strcmp0 (_tmp58_, _tmp59_) > 0;
			}
			if (_tmp56_) {
				GFile* _tmp60_;
				const gchar* _tmp61_;
				_tmp60_ = latestStoredEntryFile;
				_tmp61_ = maxDatetime;
				file_utils_writeFile (_tmp60_, _tmp61_, FALSE, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (latestDatetime);
					_g_object_unref0 (latestStoredEntryFile);
					_g_free0 (maxDatetime);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					goto __catch0_g_error;
				}
			}
			_g_free0 (latestDatetime);
			_g_object_unref0 (latestStoredEntryFile);
		}
		_g_free0 (maxDatetime);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp62_;
		const gchar* _tmp63_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp62_ = e;
		_tmp63_ = _tmp62_->message;
		log_w (_tmp63_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

/**
 * Gets all stored entries satisfying the predicates and executes the corresponding actions.
 *
 * @param executePath path to the entries to executes. This can be either a file or a directory.
 * If it specifies a file, the entries in that file are executed. If it specifies a directory,
 * all entries in all subfiles are executed.
 * @param extra extra data passed to the [listeners].
 * @param keyPred optional predicate on the keys. The key has to satisfy this predicate to be
 * executed.
 * @param valuePred optional predicate on the values. The value has to satisfy this predicate to
 * be executed.
 * @param pathPred optional predicate on the subpaths. Each subpath has to satisfy this
 * predicate to be executed. This holds for directories as well. Furthermore, the path of
 * specified in [executePath] is not part of the argument.
 */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		Decsync* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->executePath);
		((_data7_->extra == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_data7_->extra = (self->priv->t_destroy_func (_data7_->extra), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
__lambda24_ (Block7Data* _data7_,
             GeeArrayList* path)
{
	Decsync* self;
	DecsyncEntriesLocation* entriesLocation = NULL;
	DecsyncEntriesLocation* _tmp0_;
	gboolean result;
	self = _data7_->self;
	g_return_val_if_fail (path != NULL, FALSE);
	gee_list_insert_all ((GeeList*) path, 0, (GeeCollection*) _data7_->executePath);
	_tmp0_ = decsync_entries_location_new_getStoredEntriesLocation (self, (GeeList*) path);
	entriesLocation = _tmp0_;
	decsync_executeEntriesLocation (self, entriesLocation, _data7_->extra, _data7_->keyPred, _data7_->keyPred_target, _data7_->valuePred, _data7_->valuePred_target);
	result = TRUE;
	_decsync_entries_location_unref0 (entriesLocation);
	_g_object_unref0 (path);
	return result;
}

static gboolean
___lambda24__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda24_ (self, (GeeArrayList*) g);
	return result;
}

void
decsync_executeStoredEntries (Decsync* self,
                              gchar** executePathArray,
                              gint executePathArray_length1,
                              gconstpointer extra,
                              GeePredicate keyPred,
                              gpointer keyPred_target,
                              GeePredicate valuePred,
                              gpointer valuePred_target,
                              GeePredicate pathPred,
                              gpointer pathPred_target)
{
	Block7Data* _data7_;
	gpointer _tmp0_;
	GeeList* _tmp1_;
	gchar* executePathString = NULL;
	gchar* _tmp2_;
	GFile* executeDir = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = ((extra != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) extra) : ((gpointer) extra);
	((_data7_->extra == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_data7_->extra = (self->priv->t_destroy_func (_data7_->extra), NULL));
	_data7_->extra = _tmp0_;
	_data7_->keyPred = keyPred;
	_data7_->keyPred_target = keyPred_target;
	_data7_->valuePred = valuePred;
	_data7_->valuePred_target = valuePred_target;
	_tmp1_ = toList (executePathArray, (gint) executePathArray_length1);
	_data7_->executePath = _tmp1_;
	_tmp2_ = file_utils_pathToString (_data7_->executePath);
	executePathString = _tmp2_;
	_tmp3_ = self->priv->dir;
	_tmp4_ = g_strconcat (_tmp3_, "/stored-entries/", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->ownAppIdEncoded;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "/", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, executePathString, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_file_new_for_path (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	executeDir = _tmp14_;
	_tmp15_ = file_utils_listFilesRecursiveRelative (executeDir, NULL, pathPred, pathPred_target);
	_tmp16_ = _tmp15_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp16_, ___lambda24__gee_forall_func, _data7_);
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (executeDir);
	_g_free0 (executePathString);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

/**
 * Initializes the stored entries. This method does not execute any actions. This is often
 * followed with a call to [executeStoredEntries].
 */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		Decsync* self;
		self = _data8_->self;
		_g_free0 (_data8_->appIdEncoded);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
___lambda25_ (Block8Data* _data8_,
              GeeArrayList* path)
{
	Decsync* self;
	gchar* pathString = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data8_->self;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = file_utils_pathToString ((GeeList*) path);
	pathString = _tmp0_;
	{
		GFile* newEntriesFile = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFileInfo* _tmp14_ = NULL;
		GFile* _tmp15_;
		GFileInfo* _tmp16_;
		gint64 size = 0LL;
		GFile* readBytesFile = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
		GFile* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp1_ = self->priv->dir;
		_tmp2_ = g_strconcat (_tmp1_, "/new-entries/", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _data8_->appIdEncoded;
		_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, "/", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = pathString;
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_new_for_path (_tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
		newEntriesFile = _tmp13_;
		_tmp15_ = newEntriesFile;
		_tmp16_ = g_file_query_info (_tmp15_, "standard::size", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp14_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (newEntriesFile);
			goto __catch0_g_error;
		}
		size = g_file_info_get_size (_tmp14_);
		_tmp17_ = self->priv->dir;
		_tmp18_ = g_strconcat (_tmp17_, "/read-bytes/", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->ownAppIdEncoded;
		_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = _data8_->appIdEncoded;
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, "/", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = pathString;
		_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_file_new_for_path (_tmp32_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		readBytesFile = _tmp34_;
		_tmp35_ = readBytesFile;
		_tmp36_ = g_strdup_printf ("%" G_GINT64_FORMAT, size);
		_tmp37_ = _tmp36_;
		file_utils_writeFile (_tmp35_, _tmp37_, FALSE, &_inner_error0_);
		_g_free0 (_tmp37_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (readBytesFile);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (newEntriesFile);
			goto __catch0_g_error;
		}
		_g_object_unref0 (readBytesFile);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (newEntriesFile);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		log_w (_tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp40_ = FALSE;
		_g_free0 (pathString);
		_g_object_unref0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp40_;
	}
	result = TRUE;
	_g_free0 (pathString);
	_g_object_unref0 (path);
	return result;
}

static gboolean
____lambda25__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda25_ (self, (GeeArrayList*) g);
	return result;
}

void
decsync_initStoredEntries (Decsync* self)
{
	gchar* appId = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = decsync_latestAppId (self);
	appId = _tmp0_;
	_tmp1_ = appId;
	_tmp2_ = self->priv->ownAppId;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		Block8Data* _data8_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* newEntriesDir = NULL;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		GFile* _tmp63_;
		GFile* _tmp64_;
		GFile* ownReadBytesDir = NULL;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		const gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		const gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		GFile* _tmp76_;
		GFile* _tmp77_;
		GFile* _tmp78_;
		GFile* _tmp79_;
		GeeArrayList* _tmp80_;
		GeeArrayList* _tmp81_;
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->self = g_object_ref (self);
		_tmp3_ = appId;
		_tmp4_ = file_utils_urlencode (_tmp3_);
		_data8_->appIdEncoded = _tmp4_;
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			_tmp5_ = self->priv->dir;
			_tmp6_ = g_strconcat (_tmp5_, "/stored-entries/", NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->ownAppIdEncoded;
			_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_file_new_for_path (_tmp10_);
			_tmp12_ = _tmp11_;
			file_utils_delete (_tmp12_, &_inner_error0_);
			_g_object_unref0 (_tmp12_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp7_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp13_ = self->priv->dir;
			_tmp14_ = g_strconcat (_tmp13_, "/stored-entries/", NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = _data8_->appIdEncoded;
			_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_file_new_for_path (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->dir;
			_tmp22_ = g_strconcat (_tmp21_, "/stored-entries/", NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->ownAppIdEncoded;
			_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_file_new_for_path (_tmp26_);
			_tmp28_ = _tmp27_;
			file_utils_copy (_tmp20_, _tmp28_, FALSE, &_inner_error0_);
			_g_object_unref0 (_tmp28_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp23_);
			_g_object_unref0 (_tmp20_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			log_w (_tmp30_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block8_data_unref (_data8_);
			_data8_ = NULL;
			_g_free0 (appId);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			GFile* _tmp37_;
			GFile* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			GFile* _tmp45_;
			GFile* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			GFile* _tmp53_;
			GFile* _tmp54_;
			_tmp31_ = self->priv->dir;
			_tmp32_ = g_strconcat (_tmp31_, "/read-bytes/", NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->ownAppIdEncoded;
			_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_file_new_for_path (_tmp36_);
			_tmp38_ = _tmp37_;
			file_utils_delete (_tmp38_, &_inner_error0_);
			_g_object_unref0 (_tmp38_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp33_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp39_ = self->priv->dir;
			_tmp40_ = g_strconcat (_tmp39_, "/read-bytes/", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = _data8_->appIdEncoded;
			_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_file_new_for_path (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = self->priv->dir;
			_tmp48_ = g_strconcat (_tmp47_, "/read-bytes/", NULL);
			_tmp49_ = _tmp48_;
			_tmp50_ = self->priv->ownAppIdEncoded;
			_tmp51_ = g_strconcat (_tmp49_, _tmp50_, NULL);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_file_new_for_path (_tmp52_);
			_tmp54_ = _tmp53_;
			file_utils_copy (_tmp46_, _tmp54_, FALSE, &_inner_error0_);
			_g_object_unref0 (_tmp54_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp49_);
			_g_object_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp41_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp55_;
			const gchar* _tmp56_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp55_ = e;
			_tmp56_ = _tmp55_->message;
			log_w (_tmp56_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block8_data_unref (_data8_);
			_data8_ = NULL;
			_g_free0 (appId);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp57_ = self->priv->dir;
		_tmp58_ = g_strconcat (_tmp57_, "/new-entries/", NULL);
		_tmp59_ = _tmp58_;
		_tmp60_ = _data8_->appIdEncoded;
		_tmp61_ = g_strconcat (_tmp59_, _tmp60_, NULL);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_file_new_for_path (_tmp62_);
		_tmp64_ = _tmp63_;
		_g_free0 (_tmp62_);
		_g_free0 (_tmp59_);
		newEntriesDir = _tmp64_;
		_tmp65_ = self->priv->dir;
		_tmp66_ = g_strconcat (_tmp65_, "/read-bytes/", NULL);
		_tmp67_ = _tmp66_;
		_tmp68_ = self->priv->ownAppIdEncoded;
		_tmp69_ = g_strconcat (_tmp67_, _tmp68_, NULL);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strconcat (_tmp70_, "/", NULL);
		_tmp72_ = _tmp71_;
		_tmp73_ = _data8_->appIdEncoded;
		_tmp74_ = g_strconcat (_tmp72_, _tmp73_, NULL);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_file_new_for_path (_tmp75_);
		_tmp77_ = _tmp76_;
		_g_free0 (_tmp75_);
		_g_free0 (_tmp72_);
		_g_free0 (_tmp70_);
		_g_free0 (_tmp67_);
		ownReadBytesDir = _tmp77_;
		_tmp78_ = newEntriesDir;
		_tmp79_ = ownReadBytesDir;
		_tmp80_ = file_utils_listFilesRecursiveRelative (_tmp78_, _tmp79_, NULL, NULL);
		_tmp81_ = _tmp80_;
		gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp81_, ____lambda25__gee_forall_func, _data8_);
		_g_object_unref0 (_tmp81_);
		_g_object_unref0 (ownReadBytesDir);
		_g_object_unref0 (newEntriesDir);
		block8_data_unref (_data8_);
		_data8_ = NULL;
	}
	_g_free0 (appId);
}

/**
 * Returns the most up-to-date appId. This is the appId which has stored the most recent entry.
 * In case of a tie, the appId corresponding to the current application is used, if possible.
 */
gchar*
decsync_latestAppId (Decsync* self)
{
	gchar* latestAppId = NULL;
	gchar* latestDatetime = NULL;
	GFile* infoDir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	const gchar* _tmp57_ = NULL;
	const gchar* _tmp58_;
	gchar* _tmp60_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	latestAppId = NULL;
	latestDatetime = NULL;
	_tmp0_ = self->priv->dir;
	_tmp1_ = g_strconcat (_tmp0_, "/info", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	infoDir = _tmp4_;
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp5_;
		GFileEnumerator* _tmp6_;
		GFileInfo* info = NULL;
		_tmp5_ = infoDir;
		_tmp6_ = g_file_enumerate_children (_tmp5_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp7_ = NULL;
			GFileEnumerator* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_;
			gchar* appId = NULL;
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			GFile* file = NULL;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GFileInfo* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			const gchar* _tmp30_;
			gchar* datetime = NULL;
			gboolean _tmp43_ = FALSE;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			_tmp8_ = enumerator;
			_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (info);
			info = _tmp10_;
			_tmp11_ = info;
			if (!(_tmp11_ != NULL)) {
				_g_object_unref0 (_tmp7_);
				break;
			}
			_tmp12_ = info;
			_tmp13_ = g_file_info_get_name (_tmp12_);
			if (string_get (_tmp13_, (glong) 0) == '.') {
				_g_object_unref0 (_tmp7_);
				continue;
			}
			_tmp14_ = info;
			_tmp15_ = g_file_info_get_name (_tmp14_);
			_tmp16_ = file_utils_urldecode (_tmp15_);
			appId = _tmp16_;
			_tmp17_ = self->priv->dir;
			_tmp18_ = g_strconcat (_tmp17_, "/info/", NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = info;
			_tmp21_ = g_file_info_get_name (_tmp20_);
			_tmp22_ = g_strconcat (_tmp19_, _tmp21_, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat (_tmp23_, "/latest-stored-entry", NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_file_new_for_path (_tmp25_);
			_tmp27_ = _tmp26_;
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp19_);
			file = _tmp27_;
			_tmp30_ = appId;
			if (_tmp30_ == NULL) {
				_tmp29_ = TRUE;
			} else {
				GFile* _tmp31_;
				_tmp31_ = file;
				_tmp29_ = !g_file_query_exists (_tmp31_, NULL);
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				GFile* _tmp32_;
				_tmp32_ = file;
				_tmp28_ = g_file_query_file_type (_tmp32_, G_FILE_QUERY_INFO_NONE, NULL) != G_FILE_TYPE_REGULAR;
			}
			if (_tmp28_) {
				_g_object_unref0 (file);
				_g_free0 (appId);
				_g_object_unref0 (_tmp7_);
				continue;
			}
			datetime = NULL;
			{
				GFileInputStream* _tmp33_ = NULL;
				GFile* _tmp34_;
				GFileInputStream* _tmp35_;
				GDataInputStream* stream = NULL;
				GDataInputStream* _tmp36_;
				gchar* _tmp37_ = NULL;
				GDataInputStream* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp34_ = file;
				_tmp35_ = g_file_read (_tmp34_, NULL, &_inner_error0_);
				_tmp33_ = _tmp35_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp36_ = g_data_input_stream_new ((GInputStream*) _tmp33_);
				stream = _tmp36_;
				_tmp38_ = stream;
				_tmp39_ = g_data_input_stream_read_line (_tmp38_, NULL, NULL, &_inner_error0_);
				_tmp37_ = _tmp39_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (stream);
					_g_object_unref0 (_tmp33_);
					goto __catch1_g_error;
				}
				_tmp40_ = _tmp37_;
				_tmp37_ = NULL;
				_g_free0 (datetime);
				datetime = _tmp40_;
				_g_free0 (_tmp37_);
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp33_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp41_;
				const gchar* _tmp42_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp41_ = e;
				_tmp42_ = _tmp41_->message;
				log_w (_tmp42_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (datetime);
				_g_object_unref0 (file);
				_g_free0 (appId);
				_g_object_unref0 (_tmp7_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp44_ = datetime;
			_tmp45_ = latestDatetime;
			if (g_strcmp0 (_tmp44_, _tmp45_) > 0) {
				_tmp43_ = TRUE;
			} else {
				gboolean _tmp46_ = FALSE;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				_tmp47_ = appId;
				_tmp48_ = self->priv->ownAppId;
				if (g_strcmp0 (_tmp47_, _tmp48_) == 0) {
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					_tmp49_ = datetime;
					_tmp50_ = latestDatetime;
					_tmp46_ = g_strcmp0 (_tmp49_, _tmp50_) == 0;
				} else {
					_tmp46_ = FALSE;
				}
				_tmp43_ = _tmp46_;
			}
			if (_tmp43_) {
				const gchar* _tmp51_;
				gchar* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp51_ = datetime;
				_tmp52_ = g_strdup (_tmp51_);
				_g_free0 (latestDatetime);
				latestDatetime = _tmp52_;
				_tmp53_ = appId;
				_tmp54_ = g_strdup (_tmp53_);
				_g_free0 (latestAppId);
				latestAppId = _tmp54_;
			}
			_g_free0 (datetime);
			_g_object_unref0 (file);
			_g_free0 (appId);
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		log_w (_tmp56_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (infoDir);
		_g_free0 (latestDatetime);
		_g_free0 (latestAppId);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp58_ = latestAppId;
	_tmp57_ = _tmp58_;
	if (_tmp57_ == NULL) {
		const gchar* _tmp59_;
		_tmp59_ = self->priv->ownAppId;
		_tmp57_ = _tmp59_;
	}
	_tmp60_ = g_strdup (_tmp57_);
	result = _tmp60_;
	_g_object_unref0 (infoDir);
	_g_free0 (latestDatetime);
	_g_free0 (latestAppId);
	return result;
}

/**
 * Returns the value of the given [key] in the map of the given [path], and in the given
 * [DecSync directory][decsyncDir] without specifying an appId, or `null` if there is no
 * such value. The use of this method is discouraged. It is recommended to use the method
 * [executeStoredEntries] when possible.
 *
 * @throws DecsyncException if a DecSync configuration error occurred.
 */
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

JsonNode*
decsync_getStoredStaticValue (const gchar* decsyncDir,
                              gchar** pathArray,
                              gint pathArray_length1,
                              JsonNode* key,
                              GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GeeList* path = NULL;
	GeeList* _tmp14_;
	gchar* pathString = NULL;
	GeeList* _tmp15_;
	gchar* _tmp16_;
	JsonNode* _result_ = NULL;
	gchar* maxDatetime = NULL;
	GFile* storedEntriesDir = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GError* _inner_error0_ = NULL;
	JsonNode* result;
	g_return_val_if_fail (decsyncDir != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = json_to_string (key, FALSE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Get value for key ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, " for path ", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_g_strjoinv ("/", pathArray, (gint) pathArray_length1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, " in ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, decsyncDir, NULL);
	_tmp13_ = _tmp12_;
	log_d (_tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	checkDecsyncSubdirInfo (decsyncDir, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DECSYNC_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = toList (pathArray, (gint) pathArray_length1);
	path = _tmp14_;
	_tmp15_ = path;
	_tmp16_ = file_utils_pathToString (_tmp15_);
	pathString = _tmp16_;
	_result_ = NULL;
	maxDatetime = NULL;
	_tmp17_ = g_strconcat (decsyncDir, "/stored-entries", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_file_new_for_path (_tmp18_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	storedEntriesDir = _tmp20_;
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp21_;
		GFileEnumerator* _tmp22_;
		GFileInfo* info = NULL;
		_tmp21_ = storedEntriesDir;
		_tmp22_ = g_file_enumerate_children (_tmp21_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp23_ = NULL;
			GFileEnumerator* _tmp24_;
			GFileInfo* _tmp25_;
			GFileInfo* _tmp26_;
			GFileInfo* _tmp27_;
			GFileInfo* _tmp28_;
			const gchar* _tmp29_;
			gchar* appIdEncoded = NULL;
			GFileInfo* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			GFile* file = NULL;
			gchar* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			GFile* _tmp43_;
			GFile* _tmp44_;
			gboolean _tmp45_ = FALSE;
			GFile* _tmp46_;
			GFileInputStream* _tmp48_ = NULL;
			GFile* _tmp49_;
			GFileInputStream* _tmp50_;
			GDataInputStream* stream = NULL;
			GDataInputStream* _tmp51_;
			gchar* line = NULL;
			_tmp24_ = enumerator;
			_tmp25_ = g_file_enumerator_next_file (_tmp24_, NULL, &_inner_error0_);
			_tmp23_ = _tmp25_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp26_ = _tmp23_;
			_tmp23_ = NULL;
			_g_object_unref0 (info);
			info = _tmp26_;
			_tmp27_ = info;
			if (!(_tmp27_ != NULL)) {
				_g_object_unref0 (_tmp23_);
				break;
			}
			_tmp28_ = info;
			_tmp29_ = g_file_info_get_name (_tmp28_);
			if (string_get (_tmp29_, (glong) 0) == '.') {
				_g_object_unref0 (_tmp23_);
				continue;
			}
			_tmp30_ = info;
			_tmp31_ = g_file_info_get_name (_tmp30_);
			_tmp32_ = g_strdup (_tmp31_);
			appIdEncoded = _tmp32_;
			_tmp33_ = g_strconcat (decsyncDir, "/stored-entries/", NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = appIdEncoded;
			_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (_tmp37_, "/", NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = pathString;
			_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_file_new_for_path (_tmp42_);
			_tmp44_ = _tmp43_;
			_g_free0 (_tmp42_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp34_);
			file = _tmp44_;
			_tmp46_ = file;
			if (!g_file_query_exists (_tmp46_, NULL)) {
				_tmp45_ = TRUE;
			} else {
				GFile* _tmp47_;
				_tmp47_ = file;
				_tmp45_ = g_file_query_file_type (_tmp47_, G_FILE_QUERY_INFO_NONE, NULL) != G_FILE_TYPE_REGULAR;
			}
			if (_tmp45_) {
				_g_object_unref0 (file);
				_g_free0 (appIdEncoded);
				_g_object_unref0 (_tmp23_);
				continue;
			}
			_tmp49_ = file;
			_tmp50_ = g_file_read (_tmp49_, NULL, &_inner_error0_);
			_tmp48_ = _tmp50_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (appIdEncoded);
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp51_ = g_data_input_stream_new ((GInputStream*) _tmp48_);
			stream = _tmp51_;
			while (TRUE) {
				gchar* _tmp52_ = NULL;
				GDataInputStream* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				const gchar* _tmp56_;
				DecsyncEntry* entry = NULL;
				const gchar* _tmp57_;
				DecsyncEntry* _tmp58_;
				DecsyncEntry* _tmp59_;
				gboolean _tmp60_ = FALSE;
				DecsyncEntry* _tmp61_;
				JsonNode* _tmp62_;
				_tmp53_ = stream;
				_tmp54_ = g_data_input_stream_read_line (_tmp53_, NULL, NULL, &_inner_error0_);
				_tmp52_ = _tmp54_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (stream);
					_g_object_unref0 (_tmp48_);
					_g_object_unref0 (file);
					_g_free0 (appIdEncoded);
					_g_object_unref0 (_tmp23_);
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					goto __catch0_g_error;
				}
				_tmp55_ = _tmp52_;
				_tmp52_ = NULL;
				_g_free0 (line);
				line = _tmp55_;
				_tmp56_ = line;
				if (!(_tmp56_ != NULL)) {
					_g_free0 (_tmp52_);
					break;
				}
				_tmp57_ = line;
				_tmp58_ = decsync_entry_fromLine (_tmp57_);
				entry = _tmp58_;
				_tmp59_ = entry;
				if (_tmp59_ == NULL) {
					_decsync_entry_unref0 (entry);
					_g_free0 (_tmp52_);
					continue;
				}
				_tmp61_ = entry;
				_tmp62_ = _tmp61_->key;
				if (json_node_equal (_tmp62_, key)) {
					gboolean _tmp63_ = FALSE;
					const gchar* _tmp64_;
					_tmp64_ = maxDatetime;
					if (_tmp64_ == NULL) {
						_tmp63_ = TRUE;
					} else {
						DecsyncEntry* _tmp65_;
						const gchar* _tmp66_;
						const gchar* _tmp67_;
						_tmp65_ = entry;
						_tmp66_ = _tmp65_->datetime;
						_tmp67_ = maxDatetime;
						_tmp63_ = g_strcmp0 (_tmp66_, _tmp67_) > 0;
					}
					_tmp60_ = _tmp63_;
				} else {
					_tmp60_ = FALSE;
				}
				if (_tmp60_) {
					DecsyncEntry* _tmp68_;
					const gchar* _tmp69_;
					gchar* _tmp70_;
					DecsyncEntry* _tmp71_;
					JsonNode* _tmp72_;
					JsonNode* _tmp73_;
					_tmp68_ = entry;
					_tmp69_ = _tmp68_->datetime;
					_tmp70_ = g_strdup (_tmp69_);
					_g_free0 (maxDatetime);
					maxDatetime = _tmp70_;
					_tmp71_ = entry;
					_tmp72_ = _tmp71_->value;
					_tmp73_ = __vala_JsonNode_copy0 (_tmp72_);
					__vala_JsonNode_free0 (_result_);
					_result_ = _tmp73_;
				}
				_decsync_entry_unref0 (entry);
				_g_free0 (_tmp52_);
			}
			_g_free0 (line);
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp48_);
			_g_object_unref0 (file);
			_g_free0 (appIdEncoded);
			_g_object_unref0 (_tmp23_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp74_;
		const gchar* _tmp75_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp74_ = e;
		_tmp75_ = _tmp74_->message;
		log_w (_tmp75_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DECSYNC_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (storedEntriesDir);
			_g_free0 (maxDatetime);
			__vala_JsonNode_free0 (_result_);
			_g_free0 (pathString);
			_g_object_unref0 (path);
			return NULL;
		} else {
			_g_object_unref0 (storedEntriesDir);
			_g_free0 (maxDatetime);
			__vala_JsonNode_free0 (_result_);
			_g_free0 (pathString);
			_g_object_unref0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = _result_;
	_g_object_unref0 (storedEntriesDir);
	_g_free0 (maxDatetime);
	_g_free0 (pathString);
	_g_object_unref0 (path);
	return result;
}

static OnEntryUpdateListener*
decsync_getListener (Decsync* self,
                     GeeList* path)
{
	OnEntryUpdateListener* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	{
		GeeIterator* _listener_it = NULL;
		GeeIterable* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->listeners;
		_tmp1_ = gee_iterable_iterator (_tmp0_);
		_listener_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			OnEntryUpdateListener* listener = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			OnEntryUpdateListener* _tmp5_;
			_tmp2_ = _listener_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _listener_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			listener = (OnEntryUpdateListener*) _tmp4_;
			_tmp5_ = listener;
			if (on_entry_update_listener_matchesPath (_tmp5_, path)) {
				result = listener;
				_g_object_unref0 (_listener_it);
				return result;
			}
			_g_object_unref0 (listener);
		}
		_g_object_unref0 (_listener_it);
	}
	result = NULL;
	return result;
}

DecsyncEntryWithPath*
decsync_entry_with_path_construct (GType object_type,
                                   gchar** path,
                                   gint path_length1,
                                   DecsyncEntry* entry)
{
	DecsyncEntryWithPath* self = NULL;
	GeeList* _tmp0_;
	DecsyncEntry* _tmp1_;
	g_return_val_if_fail (entry != NULL, NULL);
	self = (DecsyncEntryWithPath*) g_type_create_instance (object_type);
	_tmp0_ = toList (path, (gint) path_length1);
	_g_object_unref0 (self->path);
	self->path = _tmp0_;
	_tmp1_ = _decsync_entry_ref0 (entry);
	_decsync_entry_unref0 (self->entry);
	self->entry = _tmp1_;
	return self;
}

DecsyncEntryWithPath*
decsync_entry_with_path_new (gchar** path,
                             gint path_length1,
                             DecsyncEntry* entry)
{
	return decsync_entry_with_path_construct (DECSYNC_TYPE_ENTRY_WITH_PATH, path, path_length1, entry);
}

DecsyncEntryWithPath*
decsync_entry_with_path_construct_now (GType object_type,
                                       gchar** path,
                                       gint path_length1,
                                       JsonNode* key,
                                       JsonNode* value)
{
	DecsyncEntryWithPath* self = NULL;
	GeeList* _tmp0_;
	DecsyncEntry* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (DecsyncEntryWithPath*) g_type_create_instance (object_type);
	_tmp0_ = toList (path, (gint) path_length1);
	_g_object_unref0 (self->path);
	self->path = _tmp0_;
	_tmp1_ = decsync_entry_new_now (key, value);
	_decsync_entry_unref0 (self->entry);
	self->entry = _tmp1_;
	return self;
}

DecsyncEntryWithPath*
decsync_entry_with_path_new_now (gchar** path,
                                 gint path_length1,
                                 JsonNode* key,
                                 JsonNode* value)
{
	return decsync_entry_with_path_construct_now (DECSYNC_TYPE_ENTRY_WITH_PATH, path, path_length1, key, value);
}

static void
decsync_value_entry_with_path_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
decsync_value_entry_with_path_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		decsync_entry_with_path_unref (value->data[0].v_pointer);
	}
}

static void
decsync_value_entry_with_path_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = decsync_entry_with_path_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
decsync_value_entry_with_path_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
decsync_value_entry_with_path_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DecsyncEntryWithPath * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = decsync_entry_with_path_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
decsync_value_entry_with_path_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	DecsyncEntryWithPath ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = decsync_entry_with_path_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
decsync_param_spec_entry_with_path (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	DecsyncParamSpecEntryWithPath* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DECSYNC_TYPE_ENTRY_WITH_PATH), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
decsync_value_get_entry_with_path (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRY_WITH_PATH), NULL);
	return value->data[0].v_pointer;
}

void
decsync_value_set_entry_with_path (GValue* value,
                                   gpointer v_object)
{
	DecsyncEntryWithPath * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRY_WITH_PATH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DECSYNC_TYPE_ENTRY_WITH_PATH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		decsync_entry_with_path_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decsync_entry_with_path_unref (old);
	}
}

void
decsync_value_take_entry_with_path (GValue* value,
                                    gpointer v_object)
{
	DecsyncEntryWithPath * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRY_WITH_PATH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DECSYNC_TYPE_ENTRY_WITH_PATH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decsync_entry_with_path_unref (old);
	}
}

static void
decsync_entry_with_path_class_init (DecsyncEntryWithPathClass * klass,
                                    gpointer klass_data)
{
	decsync_entry_with_path_parent_class = g_type_class_peek_parent (klass);
	((DecsyncEntryWithPathClass *) klass)->finalize = decsync_entry_with_path_finalize;
}

static void
decsync_entry_with_path_instance_init (DecsyncEntryWithPath * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
decsync_entry_with_path_finalize (DecsyncEntryWithPath * obj)
{
	DecsyncEntryWithPath * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DECSYNC_TYPE_ENTRY_WITH_PATH, DecsyncEntryWithPath);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->path);
	_decsync_entry_unref0 (self->entry);
}

/**
 * Represents an [Entry] with its path.
 */
static GType
decsync_entry_with_path_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { decsync_value_entry_with_path_init, decsync_value_entry_with_path_free_value, decsync_value_entry_with_path_copy_value, decsync_value_entry_with_path_peek_pointer, "p", decsync_value_entry_with_path_collect_value, "p", decsync_value_entry_with_path_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DecsyncEntryWithPathClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decsync_entry_with_path_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecsyncEntryWithPath), 0, (GInstanceInitFunc) decsync_entry_with_path_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType decsync_entry_with_path_type_id;
	decsync_entry_with_path_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecsyncEntryWithPath", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return decsync_entry_with_path_type_id;
}

GType
decsync_entry_with_path_get_type (void)
{
	static volatile gsize decsync_entry_with_path_type_id__once = 0;
	if (g_once_init_enter (&decsync_entry_with_path_type_id__once)) {
		GType decsync_entry_with_path_type_id;
		decsync_entry_with_path_type_id = decsync_entry_with_path_get_type_once ();
		g_once_init_leave (&decsync_entry_with_path_type_id__once, decsync_entry_with_path_type_id);
	}
	return decsync_entry_with_path_type_id__once;
}

gpointer
decsync_entry_with_path_ref (gpointer instance)
{
	DecsyncEntryWithPath * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
decsync_entry_with_path_unref (gpointer instance)
{
	DecsyncEntryWithPath * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DECSYNC_ENTRY_WITH_PATH_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

DecsyncEntry*
decsync_entry_construct (GType object_type,
                         const gchar* datetime,
                         JsonNode* key,
                         JsonNode* value)
{
	DecsyncEntry* self = NULL;
	gchar* _tmp0_;
	JsonNode* _tmp1_;
	JsonNode* _tmp2_;
	g_return_val_if_fail (datetime != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (DecsyncEntry*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (datetime);
	_g_free0 (self->datetime);
	self->datetime = _tmp0_;
	_tmp1_ = __vala_JsonNode_copy0 (key);
	__vala_JsonNode_free0 (self->key);
	self->key = _tmp1_;
	_tmp2_ = __vala_JsonNode_copy0 (value);
	__vala_JsonNode_free0 (self->value);
	self->value = _tmp2_;
	return self;
}

DecsyncEntry*
decsync_entry_new (const gchar* datetime,
                   JsonNode* key,
                   JsonNode* value)
{
	return decsync_entry_construct (DECSYNC_TYPE_ENTRY, datetime, key, value);
}

DecsyncEntry*
decsync_entry_construct_now (GType object_type,
                             JsonNode* key,
                             JsonNode* value)
{
	DecsyncEntry* self = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (DecsyncEntry*) g_type_create_instance (object_type);
	_tmp0_ = g_date_time_new_now_utc ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, "%FT%T");
	_g_free0 (self->datetime);
	self->datetime = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	_tmp3_ = __vala_JsonNode_copy0 (key);
	__vala_JsonNode_free0 (self->key);
	self->key = _tmp3_;
	_tmp4_ = __vala_JsonNode_copy0 (value);
	__vala_JsonNode_free0 (self->value);
	self->value = _tmp4_;
	return self;
}

DecsyncEntry*
decsync_entry_new_now (JsonNode* key,
                       JsonNode* value)
{
	return decsync_entry_construct_now (DECSYNC_TYPE_ENTRY, key, value);
}

gchar*
decsync_entry_toLine (DecsyncEntry* self)
{
	JsonNode* json = NULL;
	JsonNode* _tmp0_;
	JsonArray* array = NULL;
	JsonArray* _tmp1_;
	const gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* _tmp5_;
	JsonNode* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_node_new (JSON_NODE_ARRAY);
	json = _tmp0_;
	_tmp1_ = json_array_new ();
	array = _tmp1_;
	_tmp2_ = self->datetime;
	json_array_add_string_element (array, _tmp2_);
	_tmp3_ = self->key;
	_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
	json_array_add_element (array, _tmp4_);
	_tmp5_ = self->value;
	_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
	json_array_add_element (array, _tmp6_);
	json_node_set_array (json, array);
	_tmp7_ = json_to_string (json, FALSE);
	result = _tmp7_;
	_json_array_unref0 (array);
	__vala_JsonNode_free0 (json);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

DecsyncEntry*
decsync_entry_fromLine (const gchar* line)
{
	GError* _inner_error0_ = NULL;
	DecsyncEntry* result;
	g_return_val_if_fail (line != NULL, NULL);
	{
		JsonNode* json = NULL;
		JsonNode* _tmp0_;
		JsonArray* array = NULL;
		JsonNode* _tmp1_;
		JsonArray* _tmp2_;
		JsonArray* _tmp3_;
		gboolean _tmp4_ = FALSE;
		JsonArray* _tmp5_;
		gchar* datetime = NULL;
		JsonArray* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		JsonNode* key = NULL;
		JsonArray* _tmp15_;
		JsonNode* _tmp16_;
		JsonNode* _tmp17_;
		JsonNode* value = NULL;
		JsonArray* _tmp18_;
		JsonNode* _tmp19_;
		JsonNode* _tmp20_;
		const gchar* _tmp21_;
		JsonNode* _tmp22_;
		JsonNode* _tmp23_;
		DecsyncEntry* _tmp24_;
		_tmp0_ = json_from_string (line, &_inner_error0_);
		json = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = json;
		_tmp2_ = json_node_get_array (_tmp1_);
		_tmp3_ = _json_array_ref0 (_tmp2_);
		array = _tmp3_;
		_tmp5_ = array;
		if (_tmp5_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			JsonArray* _tmp6_;
			_tmp6_ = array;
			_tmp4_ = json_array_get_length (_tmp6_) != ((guint) 3);
		}
		if (_tmp4_) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = g_strconcat ("Invalid entry ", line, NULL);
			_tmp8_ = _tmp7_;
			log_w (_tmp8_);
			_g_free0 (_tmp8_);
			result = NULL;
			_json_array_unref0 (array);
			__vala_JsonNode_free0 (json);
			return result;
		}
		_tmp9_ = array;
		_tmp10_ = json_array_get_string_element (_tmp9_, (guint) 0);
		_tmp11_ = g_strdup (_tmp10_);
		datetime = _tmp11_;
		_tmp12_ = datetime;
		if (_tmp12_ == NULL) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = g_strconcat ("Invalid entry ", line, NULL);
			_tmp14_ = _tmp13_;
			log_w (_tmp14_);
			_g_free0 (_tmp14_);
			result = NULL;
			_g_free0 (datetime);
			_json_array_unref0 (array);
			__vala_JsonNode_free0 (json);
			return result;
		}
		_tmp15_ = array;
		_tmp16_ = json_array_get_element (_tmp15_, (guint) 1);
		_tmp17_ = __vala_JsonNode_copy0 (_tmp16_);
		key = _tmp17_;
		_tmp18_ = array;
		_tmp19_ = json_array_get_element (_tmp18_, (guint) 2);
		_tmp20_ = __vala_JsonNode_copy0 (_tmp19_);
		value = _tmp20_;
		_tmp21_ = datetime;
		_tmp22_ = key;
		_tmp23_ = value;
		_tmp24_ = decsync_entry_new (_tmp21_, _tmp22_, _tmp23_);
		result = _tmp24_;
		__vala_JsonNode_free0 (value);
		__vala_JsonNode_free0 (key);
		_g_free0 (datetime);
		_json_array_unref0 (array);
		__vala_JsonNode_free0 (json);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = g_strconcat ("Invalid JSON: ", line, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp26_, "\n", NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		log_w (_tmp32_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
decsync_value_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
decsync_value_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		decsync_entry_unref (value->data[0].v_pointer);
	}
}

static void
decsync_value_entry_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = decsync_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
decsync_value_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
decsync_value_entry_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DecsyncEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = decsync_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
decsync_value_entry_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	DecsyncEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = decsync_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
decsync_param_spec_entry (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	DecsyncParamSpecEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DECSYNC_TYPE_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
decsync_value_get_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRY), NULL);
	return value->data[0].v_pointer;
}

void
decsync_value_set_entry (GValue* value,
                         gpointer v_object)
{
	DecsyncEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DECSYNC_TYPE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		decsync_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decsync_entry_unref (old);
	}
}

void
decsync_value_take_entry (GValue* value,
                          gpointer v_object)
{
	DecsyncEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DECSYNC_TYPE_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decsync_entry_unref (old);
	}
}

static void
decsync_entry_class_init (DecsyncEntryClass * klass,
                          gpointer klass_data)
{
	decsync_entry_parent_class = g_type_class_peek_parent (klass);
	((DecsyncEntryClass *) klass)->finalize = decsync_entry_finalize;
}

static void
decsync_entry_instance_init (DecsyncEntry * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
decsync_entry_finalize (DecsyncEntry * obj)
{
	DecsyncEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DECSYNC_TYPE_ENTRY, DecsyncEntry);
	g_signal_handlers_destroy (self);
	_g_free0 (self->datetime);
	__vala_JsonNode_free0 (self->key);
	__vala_JsonNode_free0 (self->value);
}

/**
 * Represents a key/value pair stored by DecSync. Additionally, it has a datetime property
 * indicating the most recent update. It does not store its path, see [EntryWithPath].
 */
static GType
decsync_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { decsync_value_entry_init, decsync_value_entry_free_value, decsync_value_entry_copy_value, decsync_value_entry_peek_pointer, "p", decsync_value_entry_collect_value, "p", decsync_value_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DecsyncEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decsync_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecsyncEntry), 0, (GInstanceInitFunc) decsync_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType decsync_entry_type_id;
	decsync_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecsyncEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return decsync_entry_type_id;
}

GType
decsync_entry_get_type (void)
{
	static volatile gsize decsync_entry_type_id__once = 0;
	if (g_once_init_enter (&decsync_entry_type_id__once)) {
		GType decsync_entry_type_id;
		decsync_entry_type_id = decsync_entry_get_type_once ();
		g_once_init_leave (&decsync_entry_type_id__once, decsync_entry_type_id);
	}
	return decsync_entry_type_id__once;
}

gpointer
decsync_entry_ref (gpointer instance)
{
	DecsyncEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
decsync_entry_unref (gpointer instance)
{
	DecsyncEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DECSYNC_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static DecsyncEntriesLocation*
decsync_entries_location_construct_getNewEntriesLocation (GType object_type,
                                                          Decsync* decsync,
                                                          GeeList* path,
                                                          const gchar* appId)
{
	DecsyncEntriesLocation* self = NULL;
	gchar* pathString = NULL;
	gchar* _tmp0_;
	gchar* appIdEncoded = NULL;
	gchar* _tmp1_;
	GeeList* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GFile* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GFile* _tmp38_;
	g_return_val_if_fail (decsync != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (appId != NULL, NULL);
	self = (DecsyncEntriesLocation*) g_type_create_instance (object_type);
	_tmp0_ = file_utils_pathToString (path);
	pathString = _tmp0_;
	_tmp1_ = file_utils_urlencode (appId);
	appIdEncoded = _tmp1_;
	_tmp2_ = _g_object_ref0 (path);
	_g_object_unref0 (self->path);
	self->path = _tmp2_;
	_tmp3_ = decsync->priv->dir;
	_tmp4_ = g_strconcat (_tmp3_, "/new-entries/", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, appIdEncoded, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, pathString, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_g_object_unref0 (self->newEntriesFile);
	self->newEntriesFile = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = decsync->priv->dir;
	_tmp14_ = g_strconcat (_tmp13_, "/stored-entries/", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = decsync->priv->ownAppIdEncoded;
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, pathString, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_file_new_for_path (_tmp22_);
	_g_object_unref0 (self->storedEntriesFile);
	self->storedEntriesFile = _tmp23_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_tmp24_ = decsync->priv->dir;
	_tmp25_ = g_strconcat (_tmp24_, "/read-bytes/", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = decsync->priv->ownAppIdEncoded;
	_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, "/", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, appIdEncoded, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "/", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_tmp35_, pathString, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_file_new_for_path (_tmp37_);
	_g_object_unref0 (self->readBytesFile);
	self->readBytesFile = _tmp38_;
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	_g_free0 (appIdEncoded);
	_g_free0 (pathString);
	return self;
}

static DecsyncEntriesLocation*
decsync_entries_location_new_getNewEntriesLocation (Decsync* decsync,
                                                    GeeList* path,
                                                    const gchar* appId)
{
	return decsync_entries_location_construct_getNewEntriesLocation (DECSYNC_TYPE_ENTRIES_LOCATION, decsync, path, appId);
}

static DecsyncEntriesLocation*
decsync_entries_location_construct_getStoredEntriesLocation (GType object_type,
                                                             Decsync* decsync,
                                                             GeeList* path)
{
	DecsyncEntriesLocation* self = NULL;
	gchar* pathString = NULL;
	gchar* _tmp0_;
	GeeList* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	g_return_val_if_fail (decsync != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	self = (DecsyncEntriesLocation*) g_type_create_instance (object_type);
	_tmp0_ = file_utils_pathToString (path);
	pathString = _tmp0_;
	_tmp1_ = _g_object_ref0 (path);
	_g_object_unref0 (self->path);
	self->path = _tmp1_;
	_tmp2_ = decsync->priv->dir;
	_tmp3_ = g_strconcat (_tmp2_, "/stored-entries/", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = decsync->priv->ownAppIdEncoded;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, pathString, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_g_object_unref0 (self->newEntriesFile);
	self->newEntriesFile = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (self->storedEntriesFile);
	self->storedEntriesFile = NULL;
	_g_object_unref0 (self->readBytesFile);
	self->readBytesFile = NULL;
	_g_free0 (pathString);
	return self;
}

static DecsyncEntriesLocation*
decsync_entries_location_new_getStoredEntriesLocation (Decsync* decsync,
                                                       GeeList* path)
{
	return decsync_entries_location_construct_getStoredEntriesLocation (DECSYNC_TYPE_ENTRIES_LOCATION, decsync, path);
}

static DecsyncEntriesLocation*
decsync_entries_location_construct (GType object_type)
{
	DecsyncEntriesLocation* self = NULL;
	self = (DecsyncEntriesLocation*) g_type_create_instance (object_type);
	return self;
}

static DecsyncEntriesLocation*
decsync_entries_location_new (void)
{
	return decsync_entries_location_construct (DECSYNC_TYPE_ENTRIES_LOCATION);
}

static void
decsync_value_entries_location_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
decsync_value_entries_location_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		decsync_entries_location_unref (value->data[0].v_pointer);
	}
}

static void
decsync_value_entries_location_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = decsync_entries_location_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
decsync_value_entries_location_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
decsync_value_entries_location_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DecsyncEntriesLocation * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = decsync_entries_location_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
decsync_value_entries_location_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	DecsyncEntriesLocation ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = decsync_entries_location_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
decsync_param_spec_entries_location (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	DecsyncParamSpecEntriesLocation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DECSYNC_TYPE_ENTRIES_LOCATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
decsync_value_get_entries_location (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRIES_LOCATION), NULL);
	return value->data[0].v_pointer;
}

static void
decsync_value_set_entries_location (GValue* value,
                                    gpointer v_object)
{
	DecsyncEntriesLocation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRIES_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DECSYNC_TYPE_ENTRIES_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		decsync_entries_location_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decsync_entries_location_unref (old);
	}
}

static void
decsync_value_take_entries_location (GValue* value,
                                     gpointer v_object)
{
	DecsyncEntriesLocation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DECSYNC_TYPE_ENTRIES_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DECSYNC_TYPE_ENTRIES_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		decsync_entries_location_unref (old);
	}
}

static void
decsync_entries_location_class_init (DecsyncEntriesLocationClass * klass,
                                     gpointer klass_data)
{
	decsync_entries_location_parent_class = g_type_class_peek_parent (klass);
	((DecsyncEntriesLocationClass *) klass)->finalize = decsync_entries_location_finalize;
}

static void
decsync_entries_location_instance_init (DecsyncEntriesLocation * self,
                                        gpointer klass)
{
	self->ref_count = 1;
}

static void
decsync_entries_location_finalize (DecsyncEntriesLocation * obj)
{
	DecsyncEntriesLocation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DECSYNC_TYPE_ENTRIES_LOCATION, DecsyncEntriesLocation);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->path);
	_g_object_unref0 (self->newEntriesFile);
	_g_object_unref0 (self->storedEntriesFile);
	_g_object_unref0 (self->readBytesFile);
}

static GType
decsync_entries_location_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { decsync_value_entries_location_init, decsync_value_entries_location_free_value, decsync_value_entries_location_copy_value, decsync_value_entries_location_peek_pointer, "p", decsync_value_entries_location_collect_value, "p", decsync_value_entries_location_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DecsyncEntriesLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decsync_entries_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecsyncEntriesLocation), 0, (GInstanceInitFunc) decsync_entries_location_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType decsync_entries_location_type_id;
	decsync_entries_location_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecsyncEntriesLocation", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return decsync_entries_location_type_id;
}

static GType
decsync_entries_location_get_type (void)
{
	static volatile gsize decsync_entries_location_type_id__once = 0;
	if (g_once_init_enter (&decsync_entries_location_type_id__once)) {
		GType decsync_entries_location_type_id;
		decsync_entries_location_type_id = decsync_entries_location_get_type_once ();
		g_once_init_leave (&decsync_entries_location_type_id__once, decsync_entries_location_type_id);
	}
	return decsync_entries_location_type_id__once;
}

static gpointer
decsync_entries_location_ref (gpointer instance)
{
	DecsyncEntriesLocation * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
decsync_entries_location_unref (gpointer instance)
{
	DecsyncEntriesLocation * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DECSYNC_ENTRIES_LOCATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
decsync_class_init (DecsyncClass * klass,
                    gpointer klass_data)
{
	decsync_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Decsync_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_decsync_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_decsync_set_property;
	G_OBJECT_CLASS (klass)->finalize = decsync_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DECSYNC_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DECSYNC_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DECSYNC_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * Signal which is called when a sync is complete. For example, it can be used to update the UI.
	 */
	decsync_signals[DECSYNC_SYNC_COMPLETE_SIGNAL] = g_signal_new ("sync-complete", TYPE_DECSYNC, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}

static void
decsync_instance_init (Decsync * self,
                       gpointer klass)
{
	self->priv = decsync_get_instance_private (self);
	self->priv->monitor = NULL;
}

static void
decsync_finalize (GObject * obj)
{
	Decsync * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DECSYNC, Decsync);
	_g_free0 (self->priv->dir);
	_g_free0 (self->priv->ownAppId);
	_g_free0 (self->priv->ownAppIdEncoded);
	_g_object_unref0 (self->priv->listeners);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (decsync_parent_class)->finalize (obj);
}

/**
 * The `DecSync` class represents an interface to synchronized key-value mappings stored on the file
 * system.
 *
 * The mappings can be synchronized by synchronizing the directory [dir]. The stored mappings are
 * stored in a conflict-free way. When the same keys are updated independently, the most recent
 * value is taken. This should not cause problems when the individual values contain as little
 * information as possible.
 *
 * Every entry consists of a path, a key and a value. The path is a list of strings which contains
 * the location to the used mapping. This can make interacting with the data easier. It is also used
 * to construct a path in the file system. All characters are allowed in the path. However, other
 * limitations of the file system may apply. For example, there may be a maximum length or the file
 * system may be case insensitive.
 *
 * To update an entry, use the method [setEntry]. When multiple keys in the same path are updated
 * simultaneous, it is encouraged to use the more efficient methods [setEntriesForPath] and
 * [setEntries].
 *
 * To get notified about updated entries, use the method [executeAllNewEntries] to get all updated
 * entries and execute the corresponding actions. The method [initObserver] creates a file observer
 * which is notified about the updated entries immediately.
 *
 * Sometimes, updates cannot be execute immediately. For example, if the name of a category is
 * updated when the category does not exist yet, the name cannot be changed. In such cases, the
 * updates have to be executed retroactively. In the example, the update can be executed when the
 * category is created. For such cases, use the method [executeStoredEntries].
 *
 * Finally, to initialize the stored entries to the most recent values, use the method
 * [initStoredEntries]. This method is almost exclusively used when the application is installed. It
 * is almost always followed by a call to [executeStoredEntries].
 *
 * @param T the type of the extra data passed to the [listeners] and [syncComplete].
 * @property dir the directory in which the synchronized DecSync files are stored.
 * For the default location, use [getDecsyncSubdir].
 * @property ownAppId the unique appId corresponding to the stored data by the application. There
 * must not be two simultaneous instances with the same appId. However, if an application is
 * reinstalled, it may reuse its old appId. In that case, it has to call [initStoredEntries] and
 * [executeStoredEntries]. Even if the old appId is not reused, it is still recommended call these.
 * For the default appId, use [getAppId].
 * @property listeners a list of listeners describing the actions to execute on every updated entry.
 * When an entry is updated, the method [OnEntryUpdateListener.onEntriesUpdate] is called on the
 * listener whose method [OnEntryUpdateListener.matchesPath] returns true.
 * @property syncComplete an optional function which is called when a sync is complete. For example,
 * it can be used to update the UI.
 * @throws DecsyncException if a DecSync configuration error occurred.
 */
static GType
decsync_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DecsyncClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decsync_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Decsync), 0, (GInstanceInitFunc) decsync_instance_init, NULL };
	GType decsync_type_id;
	decsync_type_id = g_type_register_static (G_TYPE_OBJECT, "Decsync", &g_define_type_info, 0);
	Decsync_private_offset = g_type_add_instance_private (decsync_type_id, sizeof (DecsyncPrivate));
	return decsync_type_id;
}

GType
decsync_get_type (void)
{
	static volatile gsize decsync_type_id__once = 0;
	if (g_once_init_enter (&decsync_type_id__once)) {
		GType decsync_type_id;
		decsync_type_id = decsync_get_type_once ();
		g_once_init_leave (&decsync_type_id__once, decsync_type_id);
	}
	return decsync_type_id__once;
}

static void
_vala_decsync_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Decsync * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DECSYNC, Decsync);
	switch (property_id) {
		case DECSYNC_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case DECSYNC_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case DECSYNC_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_decsync_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Decsync * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DECSYNC, Decsync);
	switch (property_id) {
		case DECSYNC_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case DECSYNC_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case DECSYNC_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
checkDecsyncSubdirInfo (const gchar* decsyncSubdir,
                        GError** error)
{
	GeeArrayList* syncTypes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	GeeArrayList* _tmp4_;
	GFile* file = NULL;
	GFile* _tmp5_;
	GFile* decsyncDir = NULL;
	GeeArrayList* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	GFile* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (decsyncSubdir != NULL);
	_tmp0_ = g_strdup ("rss");
	_tmp1_ = g_strdup ("contacts");
	_tmp2_ = g_strdup ("calendars");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	_tmp4_ = gee_array_list_new_wrap (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp3_, 3, NULL, NULL, NULL);
	syncTypes = _tmp4_;
	_tmp5_ = g_file_new_for_path (decsyncSubdir);
	file = _tmp5_;
	decsyncDir = NULL;
	_tmp6_ = syncTypes;
	_tmp7_ = file;
	_tmp8_ = g_file_get_basename (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	if (_tmp10_) {
		GFile* _tmp11_;
		GFile* _tmp12_;
		_tmp11_ = file;
		_tmp12_ = g_file_get_parent (_tmp11_);
		_g_object_unref0 (decsyncDir);
		decsyncDir = _tmp12_;
	} else {
		GeeArrayList* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gboolean _tmp19_;
		_tmp13_ = syncTypes;
		_tmp14_ = file;
		_tmp15_ = g_file_get_parent (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_file_get_basename (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp13_, _tmp18_);
		_g_free0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		if (_tmp19_) {
			GFile* _tmp20_;
			GFile* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			_tmp20_ = file;
			_tmp21_ = g_file_get_parent (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_file_get_parent (_tmp22_);
			_g_object_unref0 (decsyncDir);
			decsyncDir = _tmp23_;
			_g_object_unref0 (_tmp22_);
		}
	}
	_tmp24_ = decsyncDir;
	if (_tmp24_ != NULL) {
		GFile* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = decsyncDir;
		_tmp26_ = g_file_get_path (_tmp25_);
		_tmp27_ = _tmp26_;
		checkDecsyncInfo (_tmp27_, &_inner_error0_);
		_g_free0 (_tmp27_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DECSYNC_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (decsyncDir);
				_g_object_unref0 (file);
				_g_object_unref0 (syncTypes);
				return;
			} else {
				_g_object_unref0 (decsyncDir);
				_g_object_unref0 (file);
				_g_object_unref0 (syncTypes);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_object_unref0 (decsyncDir);
	_g_object_unref0 (file);
	_g_object_unref0 (syncTypes);
}

/**
 * Checks whether the .decsync-info file in [decsyncDir] is of the right format and contains a
 * supported version. If it does not exist, a new one with version 1 is created.
 *
 * @throws DecsyncException if a DecSync configuration error occurred.
 */
static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

void
checkDecsyncInfo (const gchar* decsyncDir,
                  GError** error)
{
	GFile* infoFile = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (decsyncDir != NULL);
	_tmp0_ = g_file_new_for_path (decsyncDir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, ".decsync-info");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	infoFile = _tmp3_;
	_tmp4_ = infoFile;
	if (g_file_query_exists (_tmp4_, NULL)) {
		gint64 version = 0LL;
		{
			GFileInputStream* _tmp5_ = NULL;
			GFile* _tmp6_;
			GFileInputStream* _tmp7_;
			GDataInputStream* stream = NULL;
			GDataInputStream* _tmp8_;
			gchar* text = NULL;
			GDataInputStream* _tmp9_;
			gchar* _tmp10_;
			JsonNode* _tmp11_ = NULL;
			const gchar* _tmp12_;
			JsonNode* _tmp13_;
			JsonObject* obj = NULL;
			JsonObject* _tmp14_;
			JsonObject* _tmp15_;
			JsonObject* _tmp16_;
			_tmp6_ = infoFile;
			_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error0_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
			stream = _tmp8_;
			_tmp9_ = stream;
			_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error0_);
			text = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp5_);
				goto __catch0_g_error;
			}
			_tmp12_ = text;
			_tmp13_ = json_from_string (_tmp12_, &_inner_error0_);
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (text);
				_g_object_unref0 (stream);
				_g_object_unref0 (_tmp5_);
				goto __catch0_g_error;
			}
			_tmp14_ = json_node_get_object (_tmp11_);
			_tmp15_ = _json_object_ref0 (_tmp14_);
			obj = _tmp15_;
			_tmp16_ = obj;
			version = json_object_get_int_member (_tmp16_, "version");
			_json_object_unref0 (obj);
			__vala_JsonNode_free0 (_tmp11_);
			_g_free0 (text);
			_g_object_unref0 (stream);
			_g_object_unref0 (_tmp5_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GError* _tmp21_;
			GError* _tmp22_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			_tmp19_ = g_strconcat ("Invalid .decsync-info.\n", _tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_error_new_literal (DECSYNC_ERROR, DECSYNC_ERROR_INVALID_INFO, _tmp20_);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp20_);
			_inner_error0_ = _tmp22_;
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DECSYNC_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (infoFile);
				return;
			} else {
				_g_object_unref0 (infoFile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (version != ((gint64) 1)) {
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GError* _tmp31_;
			GError* _tmp32_;
			_tmp23_ = g_strdup_printf ("%" G_GINT64_FORMAT, version);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat ("Unsupported DecSync version.\n" "Required version: ", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp26_, ".\n", NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp28_, "Supported version: 1.", NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_error_new_literal (DECSYNC_ERROR, DECSYNC_ERROR_UNSUPPORTED_VERSION, _tmp30_);
			_tmp32_ = _tmp31_;
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_inner_error0_ = _tmp32_;
			if (_inner_error0_->domain == DECSYNC_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (infoFile);
				return;
			} else {
				_g_object_unref0 (infoFile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	} else {
		JsonObject* obj = NULL;
		JsonObject* _tmp33_;
		JsonObject* _tmp34_;
		JsonNode* json = NULL;
		JsonNode* _tmp35_;
		JsonNode* _tmp36_;
		JsonObject* _tmp37_;
		gchar* text = NULL;
		JsonNode* _tmp38_;
		gchar* _tmp39_;
		_tmp33_ = json_object_new ();
		obj = _tmp33_;
		_tmp34_ = obj;
		json_object_set_int_member (_tmp34_, "version", (gint64) 1);
		_tmp35_ = json_node_new (JSON_NODE_OBJECT);
		json = _tmp35_;
		_tmp36_ = json;
		_tmp37_ = obj;
		json_node_set_object (_tmp36_, _tmp37_);
		_tmp38_ = json;
		_tmp39_ = json_to_string (_tmp38_, FALSE);
		text = _tmp39_;
		{
			GFile* _tmp40_;
			const gchar* _tmp41_;
			_tmp40_ = infoFile;
			_tmp41_ = text;
			file_utils_writeFile (_tmp40_, _tmp41_, FALSE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			GError* _tmp46_;
			GError* _tmp47_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp42_ = e;
			_tmp43_ = _tmp42_->message;
			_tmp44_ = g_strconcat ("Could not write .decsync-info.\n", _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_error_new_literal (DECSYNC_ERROR, DECSYNC_ERROR_INVALID_INFO, _tmp45_);
			_tmp47_ = _tmp46_;
			_g_free0 (_tmp45_);
			_inner_error0_ = _tmp47_;
			_g_error_free0 (e);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DECSYNC_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (text);
				__vala_JsonNode_free0 (json);
				_json_object_unref0 (obj);
				_g_object_unref0 (infoFile);
				return;
			} else {
				_g_free0 (text);
				__vala_JsonNode_free0 (json);
				_json_object_unref0 (obj);
				_g_object_unref0 (infoFile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (text);
		__vala_JsonNode_free0 (json);
		_json_object_unref0 (obj);
	}
	_g_object_unref0 (infoFile);
}

/**
 * Returns the path to the DecSync subdirectory in a [decsyncBaseDir] for a [syncType] and
 * optionally with a [collection].
 *
 * @param decsyncBaseDir the path to the main DecSync directory, or null for the default one.
 * @param syncType the type of data to sync. For example, "rss", "contacts" or "calendars".
 * @param collection an optional collection identifier when multiple instances of the [syncType] are
 * supported. For example, this is the case for "contacts" and "calendars", but not for "rss".
 */
gchar*
getDecsyncSubdir (const gchar* decsyncBaseDir,
                  const gchar* syncType,
                  const gchar* collection)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* dir = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (syncType != NULL, NULL);
	_tmp1_ = g_strdup (decsyncBaseDir);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = getDefaultDecsyncBaseDir ();
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	dir = _tmp3_;
	_tmp4_ = dir;
	_tmp5_ = file_utils_urlencode (syncType);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("/", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
	_g_free0 (dir);
	dir = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	if (collection != NULL) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp10_ = dir;
		_tmp11_ = file_utils_urlencode (collection);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp10_, _tmp14_, NULL);
		_g_free0 (dir);
		dir = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
	}
	result = dir;
	_g_free0 (_tmp0_);
	return result;
}

/**
 * Returns the default DecSync directory. This is the "decsync" subdirectory on the user data dir
 * ("~/.local/share" by default).
 */
gchar*
getDefaultDecsyncBaseDir (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strconcat (_tmp0_, "/decsync", NULL);
	result = _tmp1_;
	return result;
}

/**
 * Returns a list of DecSync collections inside a [decsyncBaseDir] for a [syncType]. This function
 * does not apply for sync types with single instances.
 *
 * @param decsyncBaseDir the path to the main DecSync directory, or null for the default one.
 * @param syncType the type of data to sync. For example, "contacts" or "calendars".
 * @param ignoreDeleted `true` to ignore deleted collections. A collection is considered deleted if
 * the most recent value of the key "deleted" with the path ["info"] is set to `true`.
 * @throws DecsyncException if a DecSync configuration error occurred.
 */
GeeArrayList*
listDecsyncCollections (const gchar* decsyncBaseDir,
                        const gchar* syncType,
                        gboolean ignoreDeleted,
                        GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GFile* decsyncSubdir = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp7_;
	GFileEnumerator* _tmp8_;
	GFileInfo* info = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp9_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (syncType != NULL, NULL);
	_tmp1_ = g_strdup (decsyncBaseDir);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = getDefaultDecsyncBaseDir ();
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	checkDecsyncInfo (_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return NULL;
	}
	_tmp3_ = getDecsyncSubdir (decsyncBaseDir, syncType, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	decsyncSubdir = _tmp6_;
	_tmp7_ = decsyncSubdir;
	_tmp8_ = g_file_enumerate_children (_tmp7_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	enumerator = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (decsyncSubdir);
		_g_free0 (_tmp0_);
		return NULL;
	}
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = _tmp9_;
	while (TRUE) {
		GFileInfo* _tmp10_ = NULL;
		GFileEnumerator* _tmp11_;
		GFileInfo* _tmp12_;
		GFileInfo* _tmp13_;
		GFileInfo* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GFileInfo* _tmp16_;
		gchar* collection = NULL;
		GFileInfo* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp11_ = enumerator;
		_tmp12_ = g_file_enumerator_next_file (_tmp11_, NULL, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (decsyncSubdir);
			_g_free0 (_tmp0_);
			return NULL;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (info);
		info = _tmp13_;
		_tmp14_ = info;
		if (!(_tmp14_ != NULL)) {
			_g_object_unref0 (_tmp10_);
			break;
		}
		_tmp16_ = info;
		if (g_file_info_get_file_type (_tmp16_) != G_FILE_TYPE_DIRECTORY) {
			_tmp15_ = TRUE;
		} else {
			GFileInfo* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = info;
			_tmp18_ = g_file_info_get_name (_tmp17_);
			_tmp15_ = string_get (_tmp18_, (glong) 0) == '.';
		}
		if (_tmp15_) {
			_g_object_unref0 (_tmp10_);
			continue;
		}
		if (ignoreDeleted) {
			JsonNode* deleted = NULL;
			GFile* _tmp19_;
			GFileInfo* _tmp20_;
			const gchar* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			JsonNode* _tmp29_;
			JsonNode* _tmp30_;
			JsonNode* _tmp31_;
			JsonNode* _tmp32_;
			gboolean _tmp33_ = FALSE;
			JsonNode* _tmp34_;
			_tmp19_ = decsyncSubdir;
			_tmp20_ = info;
			_tmp21_ = g_file_info_get_name (_tmp20_);
			_tmp22_ = g_file_get_child (_tmp19_, _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_file_get_path (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup ("info");
			_tmp27_ = g_new0 (gchar*, 1 + 1);
			_tmp27_[0] = _tmp26_;
			_tmp28_ = _tmp27_;
			_tmp28__length1 = 1;
			_tmp29_ = stringToNode ("deleted");
			_tmp30_ = _tmp29_;
			_tmp31_ = decsync_getStoredStaticValue (_tmp25_, _tmp28_, (gint) 1, _tmp30_, &_inner_error0_);
			_tmp32_ = _tmp31_;
			__vala_JsonNode_free0 (_tmp30_);
			_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp25_);
			_g_object_unref0 (_tmp23_);
			deleted = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp10_);
				_g_object_unref0 (_result_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (decsyncSubdir);
				_g_free0 (_tmp0_);
				return NULL;
			}
			_tmp34_ = deleted;
			if (_tmp34_ != NULL) {
				JsonNode* _tmp35_;
				_tmp35_ = deleted;
				_tmp33_ = json_node_get_boolean (_tmp35_);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				__vala_JsonNode_free0 (deleted);
				_g_object_unref0 (_tmp10_);
				continue;
			}
			__vala_JsonNode_free0 (deleted);
		}
		_tmp36_ = info;
		_tmp37_ = g_file_info_get_name (_tmp36_);
		_tmp38_ = file_utils_urldecode (_tmp37_);
		collection = _tmp38_;
		_tmp39_ = collection;
		if (_tmp39_ != NULL) {
			GeeArrayList* _tmp40_;
			const gchar* _tmp41_;
			_tmp40_ = _result_;
			_tmp41_ = collection;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp41_);
		}
		_g_free0 (collection);
		_g_object_unref0 (_tmp10_);
	}
	result = _result_;
	_g_object_unref0 (info);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (decsyncSubdir);
	_g_free0 (_tmp0_);
	return result;
}

/**
 * Returns the appId of the current device and application combination.
 *
 * @param appName the name of the application.
 * @param id an optional integer (between 0 and 100000 exclusive) to distinguish different instances
 * on the same device and application.
 */
gchar*
getAppId (const gchar* appName,
          gint* id)
{
	gchar* appId = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (appName != NULL, NULL);
	_tmp0_ = g_get_host_name ();
	_tmp1_ = g_strconcat (_tmp0_, "-", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, appName, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	appId = _tmp4_;
	if (id == NULL) {
		result = appId;
		return result;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = appId;
		_tmp6_ = g_strconcat (_tmp5_, "-", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%05d", *id);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		result = _tmp11_;
		_g_free0 (appId);
		return result;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

