/* DirectoryMonitor.c generated by valac 0.56.3, the Vala compiler
 * generated from DirectoryMonitor.vala, do not modify */

#include "libdecsync.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	DIRECTORY_MONITOR_0_PROPERTY,
	DIRECTORY_MONITOR_NUM_PROPERTIES
};
static GParamSpec* directory_monitor_properties[DIRECTORY_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block9Data Block9Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	DIRECTORY_MONITOR_CHANGED_SIGNAL,
	DIRECTORY_MONITOR_NUM_SIGNALS
};
static guint directory_monitor_signals[DIRECTORY_MONITOR_NUM_SIGNALS] = {0};

struct _DirectoryMonitorPrivate {
	GFile* mDir;
	gchar* mPath;
	GFileMonitor* mMonitor;
	GeeArrayList* mChilds;
};

struct _Block9Data {
	int _ref_count_;
	DirectoryMonitor* self;
	gchar* path;
};

static gint DirectoryMonitor_private_offset;
static gpointer directory_monitor_parent_class = NULL;

static DirectoryMonitor* directory_monitor_new_withPath (GFile* dir,
                                                  const gchar* path,
                                                  GError** error);
static DirectoryMonitor* directory_monitor_construct_withPath (GType object_type,
                                                        GFile* dir,
                                                        const gchar* path,
                                                        GError** error);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda4_ (Block9Data* _data9_,
                 GFile* file,
                 GFile* otherFile,
                 GFileMonitorEvent event);
static void directory_monitor_onEvent (DirectoryMonitor* self,
                                const gchar* path,
                                GFileMonitorEvent event);
static void ___lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                         GFile* file,
                                         GFile* other_file,
                                         GFileMonitorEvent event_type,
                                         gpointer self);
static void ____lambda6_ (DirectoryMonitor* self,
                   const gchar* path);
static void _____lambda6__directory_monitor_changed (DirectoryMonitor* _sender,
                                              const gchar* path,
                                              gpointer self);
static void _____lambda5_ (DirectoryMonitor* self,
                    const gchar* path);
static void ______lambda5__directory_monitor_changed (DirectoryMonitor* _sender,
                                               const gchar* path,
                                               gpointer self);
static void directory_monitor_finalize (GObject * obj);
static GType directory_monitor_get_type_once (void);

static inline gpointer
directory_monitor_get_instance_private (DirectoryMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, DirectoryMonitor_private_offset);
}

DirectoryMonitor*
directory_monitor_construct (GType object_type,
                             GFile* dir,
                             GError** error)
{
	DirectoryMonitor * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (dir != NULL, NULL);
	self = (DirectoryMonitor*) directory_monitor_construct_withPath (object_type, dir, "", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

DirectoryMonitor*
directory_monitor_new (GFile* dir,
                       GError** error)
{
	return directory_monitor_construct (TYPE_DIRECTORY_MONITOR, dir, error);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		DirectoryMonitor* self;
		self = _data9_->self;
		_g_free0 (_data9_->path);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (Block9Data* _data9_,
            GFile* file,
            GFile* otherFile,
            GFileMonitorEvent event)
{
	DirectoryMonitor* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	self = _data9_->self;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->mDir;
	_tmp3_ = g_file_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, _data9_->path, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp1_, _tmp6_) != 0;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = g_strconcat (_data9_->path, "/", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_basename (file);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		directory_monitor_onEvent (self, _tmp13_, event);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
}

static void
___lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                    GFile* file,
                                    GFile* other_file,
                                    GFileMonitorEvent event_type,
                                    gpointer self)
{
	__lambda4_ (self, file, other_file, event_type);
}

static void
____lambda6_ (DirectoryMonitor* self,
              const gchar* path)
{
	g_return_if_fail (path != NULL);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_CHANGED_SIGNAL], 0, path);
}

static void
_____lambda6__directory_monitor_changed (DirectoryMonitor* _sender,
                                         const gchar* path,
                                         gpointer self)
{
	____lambda6_ ((DirectoryMonitor*) self, path);
}

static DirectoryMonitor*
directory_monitor_construct_withPath (GType object_type,
                                      GFile* dir,
                                      const gchar* path,
                                      GError** error)
{
	DirectoryMonitor * self = NULL;
	Block9Data* _data9_;
	gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	GFile* currentDir = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFileMonitor* _tmp9_ = NULL;
	GFile* _tmp10_;
	GFileMonitor* _tmp11_;
	GFileMonitor* _tmp12_;
	GFileMonitor* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp27_;
	GFileEnumerator* _tmp28_;
	GFileInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (dir != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_tmp0_ = g_strdup (path);
	_g_free0 (_data9_->path);
	_data9_->path = _tmp0_;
	self = (DirectoryMonitor*) g_object_new (object_type, NULL);
	_data9_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (dir);
	_g_object_unref0 (self->priv->mDir);
	self->priv->mDir = _tmp1_;
	_tmp2_ = g_strdup (_data9_->path);
	_g_free0 (self->priv->mPath);
	self->priv->mPath = _tmp2_;
	_tmp3_ = g_file_get_path (dir);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, _data9_->path, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	currentDir = _tmp8_;
	_tmp10_ = currentDir;
	_tmp11_ = g_file_monitor_directory (_tmp10_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
	_tmp9_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (currentDir);
		block9_data_unref (_data9_);
		_data9_ = NULL;
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp12_ = _tmp9_;
	_tmp9_ = NULL;
	_g_object_unref0 (self->priv->mMonitor);
	self->priv->mMonitor = _tmp12_;
	_tmp13_ = self->priv->mMonitor;
	g_signal_connect_data (_tmp13_, "changed", (GCallback) ___lambda4__g_file_monitor_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp14_ = currentDir;
	_tmp15_ = g_file_get_path (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("Monitor created for ", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, " (folder ", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_file_get_path (dir);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, ")", NULL);
	_tmp26_ = _tmp25_;
	log_d (_tmp26_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_tmp27_ = currentDir;
	_tmp28_ = g_file_enumerate_children (_tmp27_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	enumerator = _tmp28_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (currentDir);
		block9_data_unref (_data9_);
		_data9_ = NULL;
		_g_object_unref0 (self);
		return NULL;
	}
	info = NULL;
	while (TRUE) {
		GFileInfo* _tmp29_ = NULL;
		GFileEnumerator* _tmp30_;
		GFileInfo* _tmp31_;
		GFileInfo* _tmp32_;
		GFileInfo* _tmp33_;
		GFileInfo* _tmp34_;
		_tmp30_ = enumerator;
		_tmp31_ = g_file_enumerator_next_file (_tmp30_, NULL, &_inner_error0_);
		_tmp29_ = _tmp31_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (currentDir);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		}
		_tmp32_ = _tmp29_;
		_tmp29_ = NULL;
		_g_object_unref0 (info);
		info = _tmp32_;
		_tmp33_ = info;
		if (!(_tmp33_ != NULL)) {
			_g_object_unref0 (_tmp29_);
			break;
		}
		_tmp34_ = info;
		if (g_file_info_get_file_type (_tmp34_) == G_FILE_TYPE_DIRECTORY) {
			DirectoryMonitor* childMonitor = NULL;
			GFile* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			GFileInfo* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			DirectoryMonitor* _tmp42_;
			DirectoryMonitor* _tmp43_;
			DirectoryMonitor* _tmp44_;
			GeeArrayList* _tmp45_;
			DirectoryMonitor* _tmp46_;
			_tmp35_ = self->priv->mDir;
			_tmp36_ = g_strconcat (_data9_->path, "/", NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = info;
			_tmp39_ = g_file_info_get_name (_tmp38_);
			_tmp40_ = g_strconcat (_tmp37_, _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = directory_monitor_new_withPath (_tmp35_, _tmp41_, &_inner_error0_);
			_tmp43_ = _tmp42_;
			_g_free0 (_tmp41_);
			_g_free0 (_tmp37_);
			childMonitor = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp29_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (_tmp9_);
				_g_object_unref0 (currentDir);
				block9_data_unref (_data9_);
				_data9_ = NULL;
				_g_object_unref0 (self);
				return NULL;
			}
			_tmp44_ = childMonitor;
			g_signal_connect_object (_tmp44_, "changed", (GCallback) _____lambda6__directory_monitor_changed, self, 0);
			_tmp45_ = self->priv->mChilds;
			_tmp46_ = childMonitor;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
			_g_object_unref0 (childMonitor);
		}
		_g_object_unref0 (_tmp29_);
	}
	_g_object_unref0 (info);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (currentDir);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return self;
}

static DirectoryMonitor*
directory_monitor_new_withPath (GFile* dir,
                                const gchar* path,
                                GError** error)
{
	return directory_monitor_construct_withPath (TYPE_DIRECTORY_MONITOR, dir, path, error);
}

static void
_____lambda5_ (DirectoryMonitor* self,
               const gchar* path)
{
	g_return_if_fail (path != NULL);
	g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_CHANGED_SIGNAL], 0, path);
}

static void
______lambda5__directory_monitor_changed (DirectoryMonitor* _sender,
                                          const gchar* path,
                                          gpointer self)
{
	_____lambda5_ ((DirectoryMonitor*) self, path);
}

static void
directory_monitor_onEvent (DirectoryMonitor* self,
                           const gchar* path,
                           GFileMonitorEvent event)
{
	GEnumValue* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), event);
	_tmp1_ = g_strconcat ("Received inotify event ", (_tmp0_ != NULL) ? _tmp0_->value_name : NULL, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " at ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->mDir;
	_tmp6_ = g_file_get_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "/", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, path, NULL);
	_tmp13_ = _tmp12_;
	log_d (_tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	switch (event) {
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			{
				GeeArrayList* _c_list = NULL;
				GeeArrayList* _tmp14_;
				gint _c_size = 0;
				GeeArrayList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _c_index = 0;
				_tmp14_ = self->priv->mChilds;
				_c_list = _tmp14_;
				_tmp15_ = _c_list;
				_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
				_tmp17_ = _tmp16_;
				_c_size = _tmp17_;
				_c_index = -1;
				while (TRUE) {
					gint _tmp18_;
					gint _tmp19_;
					DirectoryMonitor* c = NULL;
					GeeArrayList* _tmp20_;
					gpointer _tmp21_;
					DirectoryMonitor* _tmp22_;
					const gchar* _tmp23_;
					_c_index = _c_index + 1;
					_tmp18_ = _c_index;
					_tmp19_ = _c_size;
					if (!(_tmp18_ < _tmp19_)) {
						break;
					}
					_tmp20_ = _c_list;
					_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _c_index);
					c = (DirectoryMonitor*) _tmp21_;
					_tmp22_ = c;
					_tmp23_ = _tmp22_->priv->mPath;
					if (g_strcmp0 (_tmp23_, path) == 0) {
						GeeArrayList* _tmp24_;
						DirectoryMonitor* _tmp25_;
						_tmp24_ = self->priv->mChilds;
						_tmp25_ = c;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp24_, _tmp25_);
						_g_object_unref0 (c);
						break;
					}
					_g_object_unref0 (c);
				}
			}
			break;
		}
		case G_FILE_MONITOR_EVENT_CREATED:
		case G_FILE_MONITOR_EVENT_CHANGED:
		{
			GFile* file = NULL;
			GFile* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GFile* _tmp31_;
			GFile* _tmp32_;
			GFile* _tmp33_;
			_tmp26_ = self->priv->mDir;
			_tmp27_ = g_file_get_path (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp28_, path, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_file_new_for_path (_tmp30_);
			_tmp32_ = _tmp31_;
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			file = _tmp32_;
			_tmp33_ = file;
			if (g_file_query_file_type (_tmp33_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY) {
				{
					DirectoryMonitor* childMonitor = NULL;
					GFile* _tmp34_;
					DirectoryMonitor* _tmp35_;
					DirectoryMonitor* _tmp36_;
					GeeArrayList* _tmp37_;
					DirectoryMonitor* _tmp38_;
					_tmp34_ = self->priv->mDir;
					_tmp35_ = directory_monitor_new_withPath (_tmp34_, path, &_inner_error0_);
					childMonitor = _tmp35_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp36_ = childMonitor;
					g_signal_connect_object (_tmp36_, "changed", (GCallback) ______lambda5__directory_monitor_changed, self, 0);
					_tmp37_ = self->priv->mChilds;
					_tmp38_ = childMonitor;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
					_g_object_unref0 (childMonitor);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp39_;
					const gchar* _tmp40_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp39_ = e;
					_tmp40_ = _tmp39_->message;
					log_w (_tmp40_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			} else {
				g_signal_emit (self, directory_monitor_signals[DIRECTORY_MONITOR_CHANGED_SIGNAL], 0, path);
			}
			_g_object_unref0 (file);
			break;
		}
		default:
		break;
	}
}

static void
directory_monitor_class_init (DirectoryMonitorClass * klass,
                              gpointer klass_data)
{
	directory_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DirectoryMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = directory_monitor_finalize;
	directory_monitor_signals[DIRECTORY_MONITOR_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
directory_monitor_instance_init (DirectoryMonitor * self,
                                 gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = directory_monitor_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_DIRECTORY_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->mChilds = _tmp0_;
}

static void
directory_monitor_finalize (GObject * obj)
{
	DirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECTORY_MONITOR, DirectoryMonitor);
	_g_object_unref0 (self->priv->mDir);
	_g_free0 (self->priv->mPath);
	_g_object_unref0 (self->priv->mMonitor);
	_g_object_unref0 (self->priv->mChilds);
	G_OBJECT_CLASS (directory_monitor_parent_class)->finalize (obj);
}

/**
 * libdecsync-vala - DirectoryMonitor.vala
 *
 * Copyright (C) 2018 Aldo Gunsing
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
static GType
directory_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitor), 0, (GInstanceInitFunc) directory_monitor_instance_init, NULL };
	GType directory_monitor_type_id;
	directory_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "DirectoryMonitor", &g_define_type_info, 0);
	DirectoryMonitor_private_offset = g_type_add_instance_private (directory_monitor_type_id, sizeof (DirectoryMonitorPrivate));
	return directory_monitor_type_id;
}

GType
directory_monitor_get_type (void)
{
	static volatile gsize directory_monitor_type_id__once = 0;
	if (g_once_init_enter (&directory_monitor_type_id__once)) {
		GType directory_monitor_type_id;
		directory_monitor_type_id = directory_monitor_get_type_once ();
		g_once_init_leave (&directory_monitor_type_id__once, directory_monitor_type_id);
	}
	return directory_monitor_type_id__once;
}

