/* FileUtils.c generated by valac 0.56.3, the Vala compiler
 * generated from FileUtils.vala, do not modify */

#include "libdecsync.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	FILE_UTILS_0_PROPERTY,
	FILE_UTILS_NUM_PROPERTIES
};
static GParamSpec* file_utils_properties[FILE_UTILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block10Data Block10Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _Block10Data {
	int _ref_count_;
	GeePredicate pathPred;
	gpointer pathPred_target;
};

struct _Block11Data {
	int _ref_count_;
	Block10Data * _data10_;
	gchar* nameDecoded;
};

static gpointer file_utils_parent_class = NULL;

static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean ______lambda7_ (Block11Data* _data11_,
                         GeeList* path);
static gboolean _______lambda7__gee_predicate (gconstpointer g,
                                        gpointer self);
static gchar* __lambda8_ (gchar* part);
static gpointer ___lambda8__gee_map_func (gpointer g,
                                   gpointer self);
static GType file_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
file_utils_writeFile (GFile* file,
                      const gchar* content,
                      gboolean append,
                      GError** error)
{
	GFile* parent = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileOutputStream* stream = NULL;
	GFileOutputStream* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	guint8* _tmp12_;
	gint _tmp12__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = g_file_get_parent (file);
	parent = _tmp0_;
	_tmp1_ = parent;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		GFile* _tmp2_;
		_tmp2_ = parent;
		g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (parent);
			return;
		}
	}
	if (append) {
		GFileOutputStream* _tmp3_ = NULL;
		GFileOutputStream* _tmp4_;
		GFileOutputStream* _tmp5_;
		_tmp4_ = g_file_append_to (file, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream);
			_g_object_unref0 (parent);
			return;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (stream);
		stream = _tmp5_;
		_g_object_unref0 (_tmp3_);
	} else {
		GFileOutputStream* _tmp6_ = NULL;
		GFileOutputStream* _tmp7_;
		GFileOutputStream* _tmp8_;
		if (g_file_query_exists (file, NULL)) {
			g_file_delete (file, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (stream);
				_g_object_unref0 (parent);
				return;
			}
		}
		_tmp7_ = g_file_create (file, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream);
			_g_object_unref0 (parent);
			return;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (stream);
		stream = _tmp8_;
		_g_object_unref0 (_tmp6_);
	}
	_tmp9_ = stream;
	_tmp10_ = string_get_data (content, &_tmp11_);
	_tmp10__length1 = _tmp11_;
	_tmp12_ = _tmp10_;
	_tmp12__length1 = _tmp10__length1;
	g_output_stream_write ((GOutputStream*) _tmp9_, _tmp12_, (gsize) _tmp12__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		_g_object_unref0 (parent);
		return;
	}
	_g_object_unref0 (stream);
	_g_object_unref0 (parent);
}

void
file_utils_delete (GFile* src,
                   GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (src != NULL);
	if (!g_file_query_exists (src, NULL)) {
		return;
	}
	if (g_file_query_file_type (src, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY) {
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		GFileInfo* info = NULL;
		_tmp0_ = g_file_enumerate_children (src, "standard::name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			gchar* name = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				return;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (info);
			info = _tmp4_;
			_tmp5_ = info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = info;
			_tmp7_ = g_file_info_get_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			name = _tmp8_;
			_tmp9_ = name;
			_tmp10_ = g_file_get_child (src, _tmp9_);
			_tmp11_ = _tmp10_;
			file_utils_delete (_tmp11_, &_inner_error0_);
			_g_object_unref0 (_tmp11_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (name);
				_g_object_unref0 (_tmp1_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				return;
			}
			_g_free0 (name);
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	g_file_delete (src, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
file_utils_copy (GFile* src,
                 GFile* dst,
                 gboolean overwrite,
                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (src != NULL);
	g_return_if_fail (dst != NULL);
	switch (g_file_query_file_type (src, G_FILE_QUERY_INFO_NONE, NULL)) {
		case G_FILE_TYPE_REGULAR:
		{
			GFile* parent = NULL;
			GFile* _tmp0_;
			GFile* _tmp1_;
			GFileCopyFlags _tmp3_ = 0U;
			_tmp0_ = g_file_get_parent (dst);
			parent = _tmp0_;
			_tmp1_ = parent;
			if (!g_file_query_exists (_tmp1_, NULL)) {
				GFile* _tmp2_;
				_tmp2_ = parent;
				g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (parent);
					return;
				}
			}
			if (overwrite) {
				_tmp3_ = G_FILE_COPY_OVERWRITE;
			} else {
				_tmp3_ = G_FILE_COPY_NONE;
			}
			g_file_copy (src, dst, _tmp3_, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (parent);
				return;
			}
			_g_object_unref0 (parent);
			return;
		}
		case G_FILE_TYPE_DIRECTORY:
		{
			GFileEnumerator* enumerator = NULL;
			GFileEnumerator* _tmp4_;
			GFileInfo* info = NULL;
			g_file_make_directory_with_parents (dst, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			_tmp4_ = g_file_enumerate_children (src, "standard::name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			enumerator = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			while (TRUE) {
				GFileInfo* _tmp5_ = NULL;
				GFileEnumerator* _tmp6_;
				GFileInfo* _tmp7_;
				GFileInfo* _tmp8_;
				GFileInfo* _tmp9_;
				gchar* name = NULL;
				GFileInfo* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				const gchar* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				_tmp6_ = enumerator;
				_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error0_);
				_tmp5_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					return;
				}
				_tmp8_ = _tmp5_;
				_tmp5_ = NULL;
				_g_object_unref0 (info);
				info = _tmp8_;
				_tmp9_ = info;
				if (!(_tmp9_ != NULL)) {
					_g_object_unref0 (_tmp5_);
					break;
				}
				_tmp10_ = info;
				_tmp11_ = g_file_info_get_name (_tmp10_);
				_tmp12_ = g_strdup (_tmp11_);
				name = _tmp12_;
				_tmp13_ = name;
				_tmp14_ = g_file_get_child (src, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = name;
				_tmp17_ = g_file_get_child (dst, _tmp16_);
				_tmp18_ = _tmp17_;
				file_utils_copy (_tmp15_, _tmp18_, overwrite, &_inner_error0_);
				_g_object_unref0 (_tmp18_);
				_g_object_unref0 (_tmp15_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (name);
					_g_object_unref0 (_tmp5_);
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					return;
				}
				_g_free0 (name);
				_g_object_unref0 (_tmp5_);
			}
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			return;
		}
		default:
		break;
	}
}

void
file_utils_filterFile (GFile* file,
                       GeePredicate linePred,
                       gpointer linePred_target,
                       GError** error)
{
	GFile* tempFile = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFileInputStream* _tmp14_ = NULL;
	GFileInputStream* _tmp15_;
	GDataInputStream* instream = NULL;
	GDataInputStream* _tmp16_;
	GFileOutputStream* _tmp17_ = NULL;
	GFile* _tmp18_;
	GFileOutputStream* _tmp19_;
	GDataOutputStream* outstream = NULL;
	GDataOutputStream* _tmp20_;
	gchar* line = NULL;
	GFile* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_parent (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_basename (file);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ".tmp", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	tempFile = _tmp13_;
	_tmp15_ = g_file_read (file, NULL, &_inner_error0_);
	_tmp14_ = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (tempFile);
		return;
	}
	_tmp16_ = g_data_input_stream_new ((GInputStream*) _tmp14_);
	instream = _tmp16_;
	_tmp18_ = tempFile;
	_tmp19_ = g_file_create (_tmp18_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
	_tmp17_ = _tmp19_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (instream);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (tempFile);
		return;
	}
	_tmp20_ = g_data_output_stream_new ((GOutputStream*) _tmp17_);
	outstream = _tmp20_;
	while (TRUE) {
		gchar* _tmp21_ = NULL;
		GDataInputStream* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp22_ = instream;
		_tmp23_ = g_data_input_stream_read_line (_tmp22_, NULL, NULL, &_inner_error0_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (line);
			_g_object_unref0 (outstream);
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (instream);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (tempFile);
			return;
		}
		_tmp24_ = _tmp21_;
		_tmp21_ = NULL;
		_g_free0 (line);
		line = _tmp24_;
		_tmp25_ = line;
		if (!(_tmp25_ != NULL)) {
			_g_free0 (_tmp21_);
			break;
		}
		_tmp26_ = line;
		if (linePred (_tmp26_, linePred_target)) {
			GDataOutputStream* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp27_ = outstream;
			_tmp28_ = line;
			_tmp29_ = g_strconcat (_tmp28_, "\n", NULL);
			_tmp30_ = _tmp29_;
			g_data_output_stream_put_string (_tmp27_, _tmp30_, NULL, &_inner_error0_);
			_g_free0 (_tmp30_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp21_);
				_g_free0 (line);
				_g_object_unref0 (outstream);
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (instream);
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (tempFile);
				return;
			}
		}
		_g_free0 (_tmp21_);
	}
	_tmp31_ = tempFile;
	g_file_move (_tmp31_, file, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (line);
		_g_object_unref0 (outstream);
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (instream);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (tempFile);
		return;
	}
	_g_free0 (line);
	_g_object_unref0 (outstream);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (instream);
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (tempFile);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		g_slice_free (Block10Data, _data10_);
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_free0 (_data11_->nameDecoded);
		block10_data_unref (_data11_->_data10_);
		_data11_->_data10_ = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
______lambda7_ (Block11Data* _data11_,
                GeeList* path)
{
	Block10Data* _data10_;
	const gchar* _tmp0_;
	gboolean result;
	_data10_ = _data11_->_data10_;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = _data11_->nameDecoded;
	gee_list_insert (path, 0, _tmp0_);
	result = _data10_->pathPred (path, _data10_->pathPred_target);
	return result;
}

static gboolean
_______lambda7__gee_predicate (gconstpointer g,
                               gpointer self)
{
	gboolean result;
	result = ______lambda7_ (self, (GeeList*) g);
	return result;
}

GeeArrayList*
file_utils_listFilesRecursiveRelative (GFile* src,
                                       GFile* readBytesSrc,
                                       GeePredicate pathPred,
                                       gpointer pathPred_target)
{
	Block10Data* _data10_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (src != NULL, NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->pathPred = pathPred;
	_data10_->pathPred_target = pathPred_target;
	_tmp0_ = g_file_get_basename (src);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_get (_tmp1_, (glong) 0) == '.';
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GeeArrayList* _tmp3_;
		_tmp3_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		result = _tmp3_;
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return result;
	}
	if (_data10_->pathPred != NULL) {
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_tmp6_ = _tmp5_;
		_tmp4_ = !_data10_->pathPred ((GeeList*) _tmp6_, _data10_->pathPred_target);
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GeeArrayList* _tmp7_;
		_tmp7_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		result = _tmp7_;
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return result;
	}
	switch (g_file_query_file_type (src, G_FILE_QUERY_INFO_NONE, NULL)) {
		case G_FILE_TYPE_REGULAR:
		{
			GeeArrayList* _result_ = NULL;
			GeeArrayList* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			GeeArrayList* _tmp11_;
			_tmp8_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
			_tmp11_ = _tmp10_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp11_);
			_g_object_unref0 (_tmp11_);
			result = _result_;
			block10_data_unref (_data10_);
			_data10_ = NULL;
			return result;
		}
		case G_FILE_TYPE_DIRECTORY:
		{
			GeeArrayList* _result_ = NULL;
			GeeArrayList* _tmp46_;
			if (readBytesSrc != NULL) {
				GFile* file = NULL;
				GFile* _tmp12_;
				gchar* version = NULL;
				GFile* _tmp13_;
				GFile* readBytesFile = NULL;
				GFile* _tmp25_;
				gchar* readBytesVersion = NULL;
				GFile* _tmp26_;
				const gchar* _tmp38_;
				_tmp12_ = g_file_get_child (src, ".decsync-sequence");
				file = _tmp12_;
				version = NULL;
				_tmp13_ = file;
				if (g_file_query_exists (_tmp13_, NULL)) {
					{
						GFileInputStream* _tmp14_ = NULL;
						GFile* _tmp15_;
						GFileInputStream* _tmp16_;
						gchar* _tmp17_ = NULL;
						GDataInputStream* _tmp18_;
						GDataInputStream* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						_tmp15_ = file;
						_tmp16_ = g_file_read (_tmp15_, NULL, &_inner_error0_);
						_tmp14_ = _tmp16_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp18_ = g_data_input_stream_new ((GInputStream*) _tmp14_);
						_tmp19_ = _tmp18_;
						_tmp20_ = g_data_input_stream_read_line (_tmp19_, NULL, NULL, &_inner_error0_);
						_tmp21_ = _tmp20_;
						_g_object_unref0 (_tmp19_);
						_tmp17_ = _tmp21_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (_tmp14_);
							goto __catch0_g_error;
						}
						_tmp22_ = _tmp17_;
						_tmp17_ = NULL;
						_g_free0 (version);
						version = _tmp22_;
						_g_free0 (_tmp17_);
						_g_object_unref0 (_tmp14_);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp23_;
						const gchar* _tmp24_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp23_ = e;
						_tmp24_ = _tmp23_->message;
						log_w (_tmp24_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (version);
						_g_object_unref0 (file);
						block10_data_unref (_data10_);
						_data10_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp25_ = g_file_get_child (readBytesSrc, ".decsync-sequence");
				readBytesFile = _tmp25_;
				readBytesVersion = NULL;
				_tmp26_ = readBytesFile;
				if (g_file_query_exists (_tmp26_, NULL)) {
					{
						GFileInputStream* _tmp27_ = NULL;
						GFile* _tmp28_;
						GFileInputStream* _tmp29_;
						gchar* _tmp30_ = NULL;
						GDataInputStream* _tmp31_;
						GDataInputStream* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp28_ = readBytesFile;
						_tmp29_ = g_file_read (_tmp28_, NULL, &_inner_error0_);
						_tmp27_ = _tmp29_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp31_ = g_data_input_stream_new ((GInputStream*) _tmp27_);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_data_input_stream_read_line (_tmp32_, NULL, NULL, &_inner_error0_);
						_tmp34_ = _tmp33_;
						_g_object_unref0 (_tmp32_);
						_tmp30_ = _tmp34_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (_tmp27_);
							goto __catch1_g_error;
						}
						_tmp35_ = _tmp30_;
						_tmp30_ = NULL;
						_g_free0 (readBytesVersion);
						readBytesVersion = _tmp35_;
						_g_free0 (_tmp30_);
						_g_object_unref0 (_tmp27_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						GError* _tmp36_;
						const gchar* _tmp37_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp36_ = e;
						_tmp37_ = _tmp36_->message;
						log_w (_tmp37_);
						_g_error_free0 (e);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (readBytesVersion);
						_g_object_unref0 (readBytesFile);
						_g_free0 (version);
						_g_object_unref0 (file);
						block10_data_unref (_data10_);
						_data10_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp38_ = version;
				if (_tmp38_ != NULL) {
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp39_ = version;
					_tmp40_ = readBytesVersion;
					if (g_strcmp0 (_tmp39_, _tmp40_) == 0) {
						GeeArrayList* _tmp41_;
						_tmp41_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						result = _tmp41_;
						_g_free0 (readBytesVersion);
						_g_object_unref0 (readBytesFile);
						_g_free0 (version);
						_g_object_unref0 (file);
						block10_data_unref (_data10_);
						_data10_ = NULL;
						return result;
					} else {
						{
							GFile* _tmp42_;
							GFile* _tmp43_;
							_tmp42_ = file;
							_tmp43_ = readBytesFile;
							file_utils_copy (_tmp42_, _tmp43_, TRUE, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
						}
						goto __finally2;
						__catch2_g_error:
						{
							GError* e = NULL;
							GError* _tmp44_;
							const gchar* _tmp45_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp44_ = e;
							_tmp45_ = _tmp44_->message;
							log_w (_tmp45_);
							_g_error_free0 (e);
						}
						__finally2:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (readBytesVersion);
							_g_object_unref0 (readBytesFile);
							_g_free0 (version);
							_g_object_unref0 (file);
							block10_data_unref (_data10_);
							_data10_ = NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
				_g_free0 (readBytesVersion);
				_g_object_unref0 (readBytesFile);
				_g_free0 (version);
				_g_object_unref0 (file);
			}
			_tmp46_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			_result_ = _tmp46_;
			{
				GFileEnumerator* enumerator = NULL;
				GFileEnumerator* _tmp47_;
				GFileInfo* info = NULL;
				_tmp47_ = g_file_enumerate_children (src, "standard::name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				enumerator = _tmp47_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch3_g_error;
				}
				while (TRUE) {
					Block11Data* _data11_;
					GFileInfo* _tmp48_ = NULL;
					GFileEnumerator* _tmp49_;
					GFileInfo* _tmp50_;
					GFileInfo* _tmp51_;
					GFileInfo* _tmp52_;
					gchar* name = NULL;
					GFileInfo* _tmp53_;
					const gchar* _tmp54_;
					gchar* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					const gchar* _tmp58_;
					GFile* _tmp62_ = NULL;
					GFile* newReadBytesSrc = NULL;
					GFile* _tmp65_;
					GeePredicate newPathPred = NULL;
					gpointer newPathPred_target;
					GDestroyNotify newPathPred_target_destroy_notify;
					GeeArrayList* paths = NULL;
					const gchar* _tmp66_;
					GFile* _tmp67_;
					GFile* _tmp68_;
					GFile* _tmp69_;
					GeePredicate _tmp70_;
					gpointer _tmp70__target;
					GeeArrayList* _tmp71_;
					GeeArrayList* _tmp72_;
					GeeArrayList* _tmp83_;
					GeeArrayList* _tmp84_;
					_data11_ = g_slice_new0 (Block11Data);
					_data11_->_ref_count_ = 1;
					_data11_->_data10_ = block10_data_ref (_data10_);
					_tmp49_ = enumerator;
					_tmp50_ = g_file_enumerator_next_file (_tmp49_, NULL, &_inner_error0_);
					_tmp48_ = _tmp50_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						block11_data_unref (_data11_);
						_data11_ = NULL;
						_g_object_unref0 (info);
						_g_object_unref0 (enumerator);
						goto __catch3_g_error;
					}
					_tmp51_ = _tmp48_;
					_tmp48_ = NULL;
					_g_object_unref0 (info);
					info = _tmp51_;
					_tmp52_ = info;
					if (!(_tmp52_ != NULL)) {
						_g_object_unref0 (_tmp48_);
						block11_data_unref (_data11_);
						_data11_ = NULL;
						break;
					}
					_tmp53_ = info;
					_tmp54_ = g_file_info_get_name (_tmp53_);
					_tmp55_ = g_strdup (_tmp54_);
					name = _tmp55_;
					_tmp56_ = name;
					_tmp57_ = file_utils_urldecode (_tmp56_);
					_data11_->nameDecoded = _tmp57_;
					_tmp58_ = _data11_->nameDecoded;
					if (_tmp58_ == NULL) {
						const gchar* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp59_ = name;
						_tmp60_ = g_strconcat ("Cannot decode name ", _tmp59_, NULL);
						_tmp61_ = _tmp60_;
						log_w (_tmp61_);
						_g_free0 (_tmp61_);
						_g_free0 (name);
						_g_object_unref0 (_tmp48_);
						block11_data_unref (_data11_);
						_data11_ = NULL;
						continue;
					}
					if (readBytesSrc == NULL) {
						_g_object_unref0 (_tmp62_);
						_tmp62_ = NULL;
					} else {
						const gchar* _tmp63_;
						GFile* _tmp64_;
						_tmp63_ = name;
						_tmp64_ = g_file_get_child (readBytesSrc, _tmp63_);
						_g_object_unref0 (_tmp62_);
						_tmp62_ = _tmp64_;
					}
					_tmp65_ = _g_object_ref0 (_tmp62_);
					newReadBytesSrc = _tmp65_;
					newPathPred = NULL;
					newPathPred_target = NULL;
					newPathPred_target_destroy_notify = NULL;
					if (_data10_->pathPred != NULL) {
						(newPathPred_target_destroy_notify == NULL) ? NULL : (newPathPred_target_destroy_notify (newPathPred_target), NULL);
						newPathPred = NULL;
						newPathPred_target = NULL;
						newPathPred_target_destroy_notify = NULL;
						newPathPred = _______lambda7__gee_predicate;
						newPathPred_target = block11_data_ref (_data11_);
						newPathPred_target_destroy_notify = block11_data_unref;
					}
					_tmp66_ = name;
					_tmp67_ = g_file_get_child (src, _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = newReadBytesSrc;
					_tmp70_ = newPathPred;
					_tmp70__target = newPathPred_target;
					_tmp71_ = file_utils_listFilesRecursiveRelative (_tmp68_, _tmp69_, _tmp70_, _tmp70__target);
					_tmp72_ = _tmp71_;
					_g_object_unref0 (_tmp68_);
					paths = _tmp72_;
					{
						GeeArrayList* _path_list = NULL;
						GeeArrayList* _tmp73_;
						gint _path_size = 0;
						GeeArrayList* _tmp74_;
						gint _tmp75_;
						gint _tmp76_;
						gint _path_index = 0;
						_tmp73_ = paths;
						_path_list = _tmp73_;
						_tmp74_ = _path_list;
						_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
						_tmp76_ = _tmp75_;
						_path_size = _tmp76_;
						_path_index = -1;
						while (TRUE) {
							gint _tmp77_;
							gint _tmp78_;
							GeeArrayList* path = NULL;
							GeeArrayList* _tmp79_;
							gpointer _tmp80_;
							GeeArrayList* _tmp81_;
							const gchar* _tmp82_;
							_path_index = _path_index + 1;
							_tmp77_ = _path_index;
							_tmp78_ = _path_size;
							if (!(_tmp77_ < _tmp78_)) {
								break;
							}
							_tmp79_ = _path_list;
							_tmp80_ = gee_abstract_list_get ((GeeAbstractList*) _tmp79_, _path_index);
							path = (GeeArrayList*) _tmp80_;
							_tmp81_ = path;
							_tmp82_ = _data11_->nameDecoded;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp81_, 0, _tmp82_);
							_g_object_unref0 (path);
						}
					}
					_tmp83_ = _result_;
					_tmp84_ = paths;
					gee_array_list_add_all (_tmp83_, (GeeCollection*) _tmp84_);
					_g_object_unref0 (paths);
					(newPathPred_target_destroy_notify == NULL) ? NULL : (newPathPred_target_destroy_notify (newPathPred_target), NULL);
					newPathPred = NULL;
					newPathPred_target = NULL;
					newPathPred_target_destroy_notify = NULL;
					_g_object_unref0 (newReadBytesSrc);
					_g_object_unref0 (_tmp62_);
					_g_free0 (name);
					_g_object_unref0 (_tmp48_);
					block11_data_unref (_data11_);
					_data11_ = NULL;
				}
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError* e = NULL;
				GError* _tmp85_;
				const gchar* _tmp86_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp85_ = e;
				_tmp86_ = _tmp85_->message;
				log_w (_tmp86_);
				_g_error_free0 (e);
			}
			__finally3:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_result_);
				block10_data_unref (_data10_);
				_data10_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			result = _result_;
			block10_data_unref (_data10_);
			_data10_ = NULL;
			return result;
		}
		default:
		{
			GeeArrayList* _tmp87_;
			_tmp87_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			result = _tmp87_;
			block10_data_unref (_data10_);
			_data10_ = NULL;
			return result;
		}
	}
}

static gchar*
__lambda8_ (gchar* part)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (part != NULL, NULL);
	_tmp0_ = file_utils_urlencode (part);
	result = _tmp0_;
	_g_free0 (part);
	return result;
}

static gpointer
___lambda8__gee_map_func (gpointer g,
                          gpointer self)
{
	gpointer result;
	result = __lambda8_ ((gchar*) g);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
file_utils_pathToString (GeeList* path)
{
	GeeArrayList* encodedPath = NULL;
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	gint _tmp3_ = 0;
	gpointer* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	encodedPath = _tmp0_;
	_tmp1_ = gee_traversable_map ((GeeTraversable*) path, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ___lambda8__gee_map_func, NULL);
	_tmp2_ = _tmp1_;
	gee_collection_add_all_iterator ((GeeCollection*) encodedPath, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = gee_collection_to_array ((GeeCollection*) encodedPath, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp6_ = _vala_g_strjoinv ("/", _tmp5_, (gint) _tmp3_);
	_tmp7_ = _tmp6_;
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp7_;
	_g_object_unref0 (encodedPath);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
file_utils_urlencode (const gchar* input)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* output = NULL;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gchar byte = '\0';
				gboolean _tmp5_ = FALSE;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = strlen (input);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				byte = string_get (input, (glong) i);
				if (g_ascii_isalnum (byte)) {
					_tmp5_ = TRUE;
				} else {
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = g_strdup_printf ("%c", byte);
					_tmp7_ = _tmp6_;
					_tmp5_ = string_contains ("-_.~", _tmp7_);
					_g_free0 (_tmp7_);
				}
				if (_tmp5_) {
					GString* _tmp8_;
					_tmp8_ = builder;
					g_string_append_c (_tmp8_, byte);
				} else {
					GString* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = builder;
					_tmp10_ = g_strdup_printf ("%%%2X", (guint) byte);
					_tmp11_ = _tmp10_;
					g_string_append (_tmp9_, _tmp11_);
					_g_free0 (_tmp11_);
				}
			}
		}
	}
	_tmp12_ = builder;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	output = _tmp14_;
	_tmp16_ = output;
	if (g_strcmp0 (_tmp16_, "") != 0) {
		const gchar* _tmp17_;
		_tmp17_ = output;
		_tmp15_ = string_get (_tmp17_, (glong) 0) == '.';
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = output;
		_tmp19_ = string_substring (_tmp18_, (glong) 1, (glong) -1);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("%2E", _tmp20_, NULL);
		_g_free0 (output);
		output = _tmp21_;
		_g_free0 (_tmp20_);
	}
	result = output;
	_g_string_free0 (builder);
	return result;
}

gchar*
file_utils_urldecode (const gchar* input)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gchar byte = '\0';
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = strlen (input);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				byte = string_get (input, (glong) i);
				if (byte != '%') {
					GString* _tmp5_;
					_tmp5_ = builder;
					g_string_append_c (_tmp5_, byte);
				} else {
					gint _tmp6_;
					gint _tmp7_;
					gboolean _tmp8_ = FALSE;
					gchar value1 = '\0';
					gchar value2 = '\0';
					GString* _tmp9_;
					_tmp6_ = strlen (input);
					_tmp7_ = _tmp6_;
					if ((i + 2) >= _tmp7_) {
						result = NULL;
						_g_string_free0 (builder);
						return result;
					}
					if (!g_ascii_isxdigit (string_get (input, (glong) (i + 1)))) {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = !g_ascii_isxdigit (string_get (input, (glong) (i + 2)));
					}
					if (_tmp8_) {
						result = NULL;
						_g_string_free0 (builder);
						return result;
					}
					value1 = (gchar) g_ascii_xdigit_value (string_get (input, (glong) (i + 1)));
					value2 = (gchar) g_ascii_xdigit_value (string_get (input, (glong) (i + 2)));
					_tmp9_ = builder;
					g_string_append_c (_tmp9_, (gchar) ((16 * value1) + value2));
					i += 2;
				}
			}
		}
	}
	_tmp10_ = builder;
	_tmp11_ = _tmp10_->str;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_string_free0 (builder);
	return result;
}

FileUtils*
file_utils_construct (GType object_type)
{
	FileUtils * self = NULL;
	self = (FileUtils*) g_object_new (object_type, NULL);
	return self;
}

FileUtils*
file_utils_new (void)
{
	return file_utils_construct (TYPE_FILE_UTILS);
}

static void
file_utils_class_init (FileUtilsClass * klass,
                       gpointer klass_data)
{
	file_utils_parent_class = g_type_class_peek_parent (klass);
}

static void
file_utils_instance_init (FileUtils * self,
                          gpointer klass)
{
}

/**
 * libdecsync-vala - FileUtils.vala
 *
 * Copyright (C) 2018 Aldo Gunsing
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
static GType
file_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileUtils), 0, (GInstanceInitFunc) file_utils_instance_init, NULL };
	GType file_utils_type_id;
	file_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "FileUtils", &g_define_type_info, 0);
	return file_utils_type_id;
}

GType
file_utils_get_type (void)
{
	static volatile gsize file_utils_type_id__once = 0;
	if (g_once_init_enter (&file_utils_type_id__once)) {
		GType file_utils_type_id;
		file_utils_type_id = file_utils_get_type_once ();
		g_once_init_leave (&file_utils_type_id__once, file_utils_type_id);
	}
	return file_utils_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

