/* feedbin_static.h generated by valac 0.56.3, the Vala compiler, do not modify */

#ifndef __PLUGINS_BACKEND_FEEDBIN_FEEDBIN_STATIC_H__
#define __PLUGINS_BACKEND_FEEDBIN_FEEDBIN_STATIC_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <libsecret/secret.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FEEDBIN_ERROR (feedbin_error_get_type ())

#define TYPE_FEEDBIN_API (feedbin_api_get_type ())
#define FEEDBIN_API(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FEEDBIN_API, FeedbinAPI))
#define FEEDBIN_API_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FEEDBIN_API, FeedbinAPIClass))
#define IS_FEEDBIN_API(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FEEDBIN_API))
#define IS_FEEDBIN_API_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FEEDBIN_API))
#define FEEDBIN_API_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FEEDBIN_API, FeedbinAPIClass))

typedef struct _FeedbinAPI FeedbinAPI;
typedef struct _FeedbinAPIClass FeedbinAPIClass;
typedef struct _FeedbinAPIPrivate FeedbinAPIPrivate;

#define FEEDBIN_API_TYPE_SUBSCRIPTION (feedbin_api_subscription_get_type ())
typedef struct _FeedbinAPISubscription FeedbinAPISubscription;

#define FEEDBIN_API_TYPE_TAGGING (feedbin_api_tagging_get_type ())
typedef struct _FeedbinAPITagging FeedbinAPITagging;

#define FEEDBIN_API_TYPE_ENTRY (feedbin_api_entry_get_type ())
typedef struct _FeedbinAPIEntry FeedbinAPIEntry;

#define FEED_READER_TYPE_FEEDBIN_UTILS (feed_reader_feedbin_utils_get_type ())
#define FEED_READER_FEEDBIN_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FEED_READER_TYPE_FEEDBIN_UTILS, FeedReaderFeedbinUtils))
#define FEED_READER_FEEDBIN_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FEED_READER_TYPE_FEEDBIN_UTILS, FeedReaderFeedbinUtilsClass))
#define FEED_READER_IS_FEEDBIN_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FEED_READER_TYPE_FEEDBIN_UTILS))
#define FEED_READER_IS_FEEDBIN_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FEED_READER_TYPE_FEEDBIN_UTILS))
#define FEED_READER_FEEDBIN_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FEED_READER_TYPE_FEEDBIN_UTILS, FeedReaderFeedbinUtilsClass))

typedef struct _FeedReaderFeedbinUtils FeedReaderFeedbinUtils;
typedef struct _FeedReaderFeedbinUtilsClass FeedReaderFeedbinUtilsClass;
typedef struct _FeedReaderFeedbinUtilsPrivate FeedReaderFeedbinUtilsPrivate;

typedef enum  {
	FEEDBIN_ERROR_INVALID_FORMAT,
	FEEDBIN_ERROR_MULTIPLE_CHOICES,
	FEEDBIN_ERROR_NO_CONNECTION,
	FEEDBIN_ERROR_NOT_AUTHORIZED,
	FEEDBIN_ERROR_NOT_FOUND,
	FEEDBIN_ERROR_UNKNOWN_ERROR
} FeedbinError;
#define FEEDBIN_ERROR feedbin_error_quark ()

struct _FeedbinAPI {
	GObject parent_instance;
	FeedbinAPIPrivate * priv;
};

struct _FeedbinAPIClass {
	GObjectClass parent_class;
};

struct _FeedbinAPISubscription {
	gint64 id;
	GDateTime* created_at;
	gint64 feed_id;
	gchar* title;
	gchar* feed_url;
	gchar* site_url;
};

struct _FeedbinAPITagging {
	gint64 id;
	gint64 feed_id;
	gchar* name;
};

struct _FeedbinAPIEntry {
	gint64 id;
	gint64 feed_id;
	gchar* title;
	gchar* url;
	gchar* author;
	gchar* content;
	gchar* summary;
	GDateTime* published;
	GDateTime* created_at;
};

struct _FeedReaderFeedbinUtils {
	GObject parent_instance;
	FeedReaderFeedbinUtilsPrivate * priv;
};

struct _FeedReaderFeedbinUtilsClass {
	GObjectClass parent_class;
};

VALA_EXTERN GQuark feedbin_error_quark (void);
GType feedbin_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType feedbin_api_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FeedbinAPI, g_object_unref)
VALA_EXTERN FeedbinAPI* feedbin_api_new (const gchar* username,
                             const gchar* password,
                             const gchar* user_agent,
                             const gchar* host);
VALA_EXTERN FeedbinAPI* feedbin_api_construct (GType object_type,
                                   const gchar* username,
                                   const gchar* password,
                                   const gchar* user_agent,
                                   const gchar* host);
VALA_EXTERN gboolean feedbin_api_login (FeedbinAPI* self,
                            GError** error);
VALA_EXTERN GType feedbin_api_subscription_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FeedbinAPISubscription* feedbin_api_subscription_dup (const FeedbinAPISubscription* self);
VALA_EXTERN void feedbin_api_subscription_free (FeedbinAPISubscription* self);
VALA_EXTERN void feedbin_api_subscription_copy (const FeedbinAPISubscription* self,
                                    FeedbinAPISubscription* dest);
VALA_EXTERN void feedbin_api_subscription_destroy (FeedbinAPISubscription* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FeedbinAPISubscription, feedbin_api_subscription_destroy)
VALA_EXTERN void feedbin_api_get_subscription (FeedbinAPI* self,
                                   gint64 subscription_id,
                                   FeedbinAPISubscription* result,
                                   GError** error);
VALA_EXTERN GeeList* feedbin_api_get_subscriptions (FeedbinAPI* self,
                                        GError** error);
VALA_EXTERN void feedbin_api_delete_subscription (FeedbinAPI* self,
                                      gint64 subscription_id,
                                      GError** error);
VALA_EXTERN FeedbinAPISubscription* feedbin_api_add_subscription (FeedbinAPI* self,
                                                      const gchar* url,
                                                      GError** error);
VALA_EXTERN void feedbin_api_rename_subscription (FeedbinAPI* self,
                                      gint64 subscription_id,
                                      const gchar* title,
                                      GError** error);
VALA_EXTERN void feedbin_api_add_tagging (FeedbinAPI* self,
                              gint64 feed_id,
                              const gchar* tag_name,
                              GError** error);
VALA_EXTERN void feedbin_api_delete_tagging (FeedbinAPI* self,
                                 gint64 tagging_id,
                                 GError** error);
VALA_EXTERN GType feedbin_api_tagging_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FeedbinAPITagging* feedbin_api_tagging_dup (const FeedbinAPITagging* self);
VALA_EXTERN void feedbin_api_tagging_free (FeedbinAPITagging* self);
VALA_EXTERN void feedbin_api_tagging_copy (const FeedbinAPITagging* self,
                               FeedbinAPITagging* dest);
VALA_EXTERN void feedbin_api_tagging_destroy (FeedbinAPITagging* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FeedbinAPITagging, feedbin_api_tagging_destroy)
VALA_EXTERN GeeList* feedbin_api_get_taggings (FeedbinAPI* self,
                                   GError** error);
VALA_EXTERN GType feedbin_api_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FeedbinAPIEntry* feedbin_api_entry_dup (const FeedbinAPIEntry* self);
VALA_EXTERN void feedbin_api_entry_free (FeedbinAPIEntry* self);
VALA_EXTERN void feedbin_api_entry_copy (const FeedbinAPIEntry* self,
                             FeedbinAPIEntry* dest);
VALA_EXTERN void feedbin_api_entry_destroy (FeedbinAPIEntry* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FeedbinAPIEntry, feedbin_api_entry_destroy)
VALA_EXTERN GeeList* feedbin_api_get_entries (FeedbinAPI* self,
                                  gint page,
                                  gboolean only_starred,
                                  GDateTime* since,
                                  gint64* feed_id,
                                  GError** error);
VALA_EXTERN GeeSet* feedbin_api_get_unread_entries (FeedbinAPI* self,
                                        GError** error);
VALA_EXTERN GeeSet* feedbin_api_get_starred_entries (FeedbinAPI* self,
                                         GError** error);
VALA_EXTERN void feedbin_api_set_entries_read (FeedbinAPI* self,
                                   GeeCollection* entry_ids,
                                   gboolean read,
                                   GError** error);
VALA_EXTERN void feedbin_api_set_entries_starred (FeedbinAPI* self,
                                      GeeCollection* entry_ids,
                                      gboolean starred,
                                      GError** error);
VALA_EXTERN GeeMap* feedbin_api_get_favicons (FeedbinAPI* self,
                                  GError** error);
VALA_EXTERN const gchar* feedbin_api_get_username (FeedbinAPI* self);
VALA_EXTERN void feedbin_api_set_username (FeedbinAPI* self,
                               const gchar* value);
VALA_EXTERN const gchar* feedbin_api_get_password (FeedbinAPI* self);
VALA_EXTERN void feedbin_api_set_password (FeedbinAPI* self,
                               const gchar* value);
VALA_EXTERN void feedbin_api_subscription_init_from_json (FeedbinAPISubscription *self,
                                              JsonObject* object,
                                              GError** error);
VALA_EXTERN void feedbin_api_tagging_init_from_json (FeedbinAPITagging *self,
                                         JsonObject* object);
VALA_EXTERN void feedbin_api_entry_init_from_json (FeedbinAPIEntry *self,
                                       JsonObject* object,
                                       GError** error);
VALA_EXTERN GType feed_reader_feedbin_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FeedReaderFeedbinUtils, g_object_unref)
VALA_EXTERN FeedReaderFeedbinUtils* feed_reader_feedbin_utils_new (GSettingsBackend* settings_backend,
                                                       SecretCollection* secrets);
VALA_EXTERN FeedReaderFeedbinUtils* feed_reader_feedbin_utils_construct (GType object_type,
                                                             GSettingsBackend* settings_backend,
                                                             SecretCollection* secrets);
VALA_EXTERN gchar* feed_reader_feedbin_utils_getUser (FeedReaderFeedbinUtils* self);
VALA_EXTERN void feed_reader_feedbin_utils_setUser (FeedReaderFeedbinUtils* self,
                                        const gchar* user);
VALA_EXTERN gchar* feed_reader_feedbin_utils_getPassword (FeedReaderFeedbinUtils* self,
                                              GCancellable* cancellable);
VALA_EXTERN void feed_reader_feedbin_utils_setPassword (FeedReaderFeedbinUtils* self,
                                            const gchar* password,
                                            GCancellable* cancellable);
VALA_EXTERN void feed_reader_feedbin_utils_resetAccount (FeedReaderFeedbinUtils* self,
                                             GCancellable* cancellable);

G_END_DECLS

#endif
