/* feedbinInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from feedbinInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "feedbin.h"
#include "feedbin_static.h"
#include <gtk/gtk.h>
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <libpeas/peas.h>

enum  {
	FEED_READER_FEEDBIN_INTERFACE_0_PROPERTY,
	FEED_READER_FEEDBIN_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feedbin_interface_properties[FEED_READER_FEEDBIN_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_FeedbinAPISubscription_free0(var) ((var == NULL) ? NULL : (var = (_vala_FeedbinAPISubscription_free (var), NULL)))
#define __vala_FeedbinAPITagging_free0(var) ((var == NULL) ? NULL : (var = (_vala_FeedbinAPITagging_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define __vala_FeedbinAPIEntry_free0(var) ((var == NULL) ? NULL : (var = (_vala_FeedbinAPIEntry_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FeedReaderFeedbinInterfacePrivate {
	FeedbinAPI* m_api;
	FeedReaderFeedbinUtils* m_utils;
	GtkEntry* m_userEntry;
	GtkEntry* m_passwordEntry;
};

struct _Block1Data {
	int _ref_count_;
	FeedReaderFeedbinInterface* self;
	GtkButton* loginButton;
};

static gint FeedReaderFeedbinInterface_private_offset;
static gpointer feed_reader_feedbin_interface_parent_class = NULL;
static GType feed_reader_feedbin_interface_type_id = 0;

static void feed_reader_feedbin_interface_real_init (FeedReaderFeedServerInterface* base,
                                              GSettingsBackend* settings_backend,
                                              SecretCollection* secrets);
static gchar* feed_reader_feedbin_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_feedbin_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedbin_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedbin_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedbin_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static GtkBox* feed_reader_feedbin_interface_real_getWidget (FeedReaderFeedServerInterface* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda5_ (Block1Data* _data1_);
static void ___lambda5__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda6_ (FeedReaderFeedbinInterface* self);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void feed_reader_feedbin_interface_real_writeData (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedbin_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedbin_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedbin_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedbin_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                   const gchar* catID);
static gboolean feed_reader_feedbin_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_feedbin_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_feedbin_interface_real_login (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedbin_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static void feed_reader_feedbin_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                          const gchar* article_id,
                                                          FeedReaderArticleStatus status);
static gint64* _int64_dup (gint64* self);
static void feed_reader_feedbin_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                            const gchar* article_id,
                                                            FeedReaderArticleStatus status);
static void feed_reader_feedbin_interface_setRead (FeedReaderFeedbinInterface* self,
                                            const gchar* id,
                                            FeedReaderFeedListType type);
static gboolean feed_reader_feedbin_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_feedbin_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                     const gchar* feed_id);
static void feed_reader_feedbin_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                         const gchar* category_id);
static void feed_reader_feedbin_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_feedbin_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                    const gchar* article_id,
                                                    const gchar* tag_id);
static void feed_reader_feedbin_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                          const gchar* article_id,
                                                          const gchar* tag_id);
static gchar* feed_reader_feedbin_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                     const gchar* caption);
static void feed_reader_feedbin_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* tag_id);
static void feed_reader_feedbin_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* tagID,
                                                   const gchar* title);
static gboolean feed_reader_feedbin_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                     const gchar* feed_url,
                                                     const gchar* cat_id,
                                                     const gchar* category_name,
                                                     gchar** feed_id,
                                                     gchar** errmsg);
static void _vala_FeedbinAPISubscription_free (FeedbinAPISubscription* self);
static void feed_reader_feedbin_interface_subscription_for_feed (FeedReaderFeedbinInterface* self,
                                                          const gchar* feed_id_str,
                                                          FeedbinAPISubscription* result,
                                                          GError** error);
static void feed_reader_feedbin_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feed_id_str);
static void feed_reader_feedbin_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feed_id_str,
                                                    const gchar* title);
static void feed_reader_feedbin_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feed_id_str,
                                                  const gchar* new_category,
                                                  const gchar* old_category);
static void _vala_FeedbinAPITagging_free (FeedbinAPITagging* self);
static void feed_reader_feedbin_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                        const gchar* old_category,
                                                        const gchar* new_category);
static void feed_reader_feedbin_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* category_id,
                                                      const gchar* new_parent_id);
static gchar* feed_reader_feedbin_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                          const gchar* title,
                                                          const gchar* parent_id);
static void feed_reader_feedbin_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                        const gchar* category);
static void feed_reader_feedbin_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                           const gchar* feed_id_str,
                                                           const gchar* category);
static gboolean feed_reader_feedbin_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                             GeeList* feeds,
                                                             GeeList* categories,
                                                             GeeList* tags,
                                                             GCancellable* cancellable);
static void _vala_SoupURI_free (SoupURI* self);
static gint feed_reader_feedbin_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_feedbin_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                     gint count,
                                                     FeedReaderArticleStatus what_to_get,
                                                     GDateTime* since,
                                                     const gchar* feed_id_str,
                                                     gboolean is_tag_id,
                                                     GCancellable* cancellable);
static void _vala_FeedbinAPIEntry_free (FeedbinAPIEntry* self);
static void feed_reader_feedbin_interface_finalize (GObject * obj);

static inline gpointer
feed_reader_feedbin_interface_get_instance_private (FeedReaderFeedbinInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeedbinInterface_private_offset);
}

static void
feed_reader_feedbin_interface_real_init (FeedReaderFeedServerInterface* base,
                                         GSettingsBackend* settings_backend,
                                         SecretCollection* secrets)
{
	FeedReaderFeedbinInterface * self;
	FeedReaderFeedbinUtils* _tmp0_;
	FeedReaderFeedbinUtils* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FeedReaderFeedbinUtils* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedbinAPI* _tmp7_;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_feedbin_utils_new (settings_backend, secrets);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feedbin_utils_getUser (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->m_utils;
	_tmp5_ = feed_reader_feedbin_utils_getPassword (_tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = feedbin_api_new (_tmp3_, _tmp6_, FEED_READER_CONSTANTS_USER_AGENT, "https://api.feedbin.com");
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
}

static gchar*
feed_reader_feedbin_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = g_strdup ("https://feedbin.com/");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_feedbin_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderFeedbinInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_HOSTED | FEED_READER_BACKEND_FLAGS_FREE_SOFTWARE) | FEED_READER_BACKEND_FLAGS_PAID;
	return result;
}

static gchar*
feed_reader_feedbin_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = g_strdup ("feedbin");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedbin_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = g_strdup ("feed-service-feedbin");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedbin_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = g_strdup ("Feedbin");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = FALSE;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FeedReaderFeedbinInterface* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->loginButton);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_)
{
	FeedReaderFeedbinInterface* self;
	self = _data1_->self;
	g_signal_emit_by_name (_data1_->loginButton, "activate");
}

static void
___lambda4__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda4_ (self);
}

static void
__lambda5_ (Block1Data* _data1_)
{
	FeedReaderFeedbinInterface* self;
	self = _data1_->self;
	g_signal_emit_by_name (_data1_->loginButton, "activate");
}

static void
___lambda5__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda5_ (self);
}

static void
__lambda6_ (FeedReaderFeedbinInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda6__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda6_ ((FeedReaderFeedbinInterface*) self);
}

static GtkBox*
feed_reader_feedbin_interface_real_getWidget (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	Block1Data* _data1_;
	GtkLabel* user_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* password_label = NULL;
	GtkLabel* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkButton* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkImage* logo = NULL;
	GtkImage* _tmp12_;
	GtkLabel* loginLabel = NULL;
	GtkLabel* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkBox* box = NULL;
	GtkBox* _tmp16_;
	GtkEntry* _tmp17_;
	FeedReaderFeedbinUtils* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkEntry* _tmp21_;
	FeedReaderFeedbinUtils* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkBox* result;
	self = (FeedReaderFeedbinInterface*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp0_);
	user_label = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp1_);
	password_label = _tmp1_;
	gtk_misc_set_alignment ((GtkMisc*) user_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) password_label, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) user_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) password_label, TRUE);
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->m_userEntry);
	self->priv->m_userEntry = _tmp2_;
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->m_passwordEntry);
	self->priv->m_passwordEntry = _tmp3_;
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (_ ("Login"));
	g_object_ref_sink (_tmp4_);
	_data1_->loginButton = _tmp4_;
	_tmp5_ = self->priv->m_userEntry;
	g_signal_connect_data (_tmp5_, "activate", (GCallback) ___lambda4__gtk_entry_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp6_ = self->priv->m_passwordEntry;
	g_signal_connect_data (_tmp6_, "activate", (GCallback) ___lambda5__gtk_entry_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp7_ = self->priv->m_passwordEntry;
	gtk_entry_set_input_purpose (_tmp7_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp8_ = self->priv->m_passwordEntry;
	gtk_entry_set_visibility (_tmp8_, FALSE);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	grid = _tmp9_;
	gtk_grid_set_column_spacing (grid, (guint) 10);
	gtk_grid_set_row_spacing (grid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_grid_attach (grid, (GtkWidget*) user_label, 0, 0, 1, 1);
	_tmp10_ = self->priv->m_userEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp10_, 1, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) password_label, 0, 1, 1, 1);
	_tmp11_ = self->priv->m_passwordEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp11_, 1, 1, 1, 1);
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("feed-service-feedbin", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp12_);
	logo = _tmp12_;
	_tmp13_ = (GtkLabel*) gtk_label_new (_ ("Please log in to Feedbin to enjoy using FeedReader"));
	g_object_ref_sink (_tmp13_);
	loginLabel = _tmp13_;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) loginLabel);
	gtk_style_context_add_class (_tmp14_, "h2");
	gtk_label_set_justify (loginLabel, GTK_JUSTIFY_CENTER);
	gtk_label_set_lines (loginLabel, 3);
	gtk_widget_set_halign ((GtkWidget*) _data1_->loginButton, GTK_ALIGN_END);
	gtk_widget_set_size_request ((GtkWidget*) _data1_->loginButton, 80, 30);
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _data1_->loginButton);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_object (_data1_->loginButton, "clicked", (GCallback) ___lambda6__gtk_button_clicked, self, 0);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp16_);
	box = _tmp16_;
	gtk_widget_set_valign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_box_pack_start (box, (GtkWidget*) loginLabel, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) logo, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) grid, TRUE, TRUE, (guint) 10);
	gtk_box_pack_end (box, (GtkWidget*) _data1_->loginButton, FALSE, FALSE, (guint) 20);
	_tmp17_ = self->priv->m_userEntry;
	_tmp18_ = self->priv->m_utils;
	_tmp19_ = feed_reader_feedbin_utils_getUser (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_entry_set_text (_tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->m_passwordEntry;
	_tmp22_ = self->priv->m_utils;
	_tmp23_ = feed_reader_feedbin_utils_getPassword (_tmp22_, NULL);
	_tmp24_ = _tmp23_;
	gtk_entry_set_text (_tmp21_, _tmp24_);
	_g_free0 (_tmp24_);
	result = box;
	_vala_warn_if_fail (result != NULL, "result != null");
	_g_object_unref0 (loginLabel);
	_g_object_unref0 (logo);
	_g_object_unref0 (grid);
	_g_object_unref0 (password_label);
	_g_object_unref0 (user_label);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
feed_reader_feedbin_interface_real_writeData (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	FeedbinAPI* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FeedReaderFeedbinUtils* _tmp5_;
	FeedbinAPI* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	FeedbinAPI* _tmp9_;
	GtkEntry* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FeedReaderFeedbinUtils* _tmp14_;
	FeedbinAPI* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = self->priv->m_api;
	_tmp1_ = self->priv->m_userEntry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	feedbin_api_set_username (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->m_utils;
	_tmp6_ = self->priv->m_api;
	_tmp7_ = feedbin_api_get_username (_tmp6_);
	_tmp8_ = _tmp7_;
	feed_reader_feedbin_utils_setUser (_tmp5_, _tmp8_);
	_tmp9_ = self->priv->m_api;
	_tmp10_ = self->priv->m_passwordEntry;
	_tmp11_ = gtk_entry_get_text (_tmp10_);
	_tmp12_ = string_strip (_tmp11_);
	_tmp13_ = _tmp12_;
	feedbin_api_set_password (_tmp9_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->m_utils;
	_tmp15_ = self->priv->m_api;
	_tmp16_ = feedbin_api_get_password (_tmp15_);
	_tmp17_ = _tmp16_;
	feed_reader_feedbin_utils_setPassword (_tmp14_, _tmp17_, NULL);
}

static gboolean
feed_reader_feedbin_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = TRUE;
	return result;
}

static gchar*
feed_reader_feedbin_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = g_strdup ("feed-service-feedbin-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedbin_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	FeedReaderFeedbinUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_feedbin_utils_getUser (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_feedbin_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = g_strdup ("https://feedbin.com/");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedbin_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = g_strdup ("0");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                          const gchar* catID)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_val_if_fail (catID != NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedbin_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = TRUE;
	return result;
}

static void
feed_reader_feedbin_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	FeedReaderFeedbinUtils* _tmp0_;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = self->priv->m_utils;
	feed_reader_feedbin_utils_resetAccount (_tmp0_, NULL);
}

static gboolean
feed_reader_feedbin_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = TRUE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_feedbin_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	GError* _inner_error0_ = NULL;
	FeedReaderLoginResponse result;
	self = (FeedReaderFeedbinInterface*) base;
	{
		gboolean _tmp0_ = FALSE;
		FeedbinAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		_tmp0_ = feedbin_api_login (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, FEEDBIN_ERROR, FEEDBIN_ERROR_NO_CONNECTION)) {
				goto __catch0_feedbin_error_no_connection;
			}
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			return result;
		} else {
			result = FEED_READER_LOGIN_RESPONSE_WRONG_LOGIN;
			return result;
		}
	}
	goto __finally0;
	__catch0_feedbin_error_no_connection:
	{
		g_clear_error (&_inner_error0_);
		result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = g_strconcat ("Feedbin login: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		feed_reader_logger_error (_tmp5_);
		_g_free0 (_tmp5_);
		result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

static gboolean
feed_reader_feedbin_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = feed_reader_feed_server_interface_login ((FeedReaderFeedServerInterface*) self) != FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static void
feed_reader_feedbin_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                     const gchar* article_id,
                                                     FeedReaderArticleStatus status)
{
	FeedReaderFeedbinInterface * self;
	gint64 entry_id = 0LL;
	GeeList* entry_ids = NULL;
	GeeList* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (article_id != NULL);
	entry_id = int64_parse (article_id, (guint) 0);
	_tmp0_ = feed_reader_list_utils_single (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, &entry_id);
	entry_ids = _tmp0_;
	{
		FeedbinAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feedbin_api_set_entries_read (_tmp1_, (GeeCollection*) entry_ids, status == FEED_READER_ARTICLE_STATUS_READ, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = g_strconcat ("FeedbinInterface.setArticleIsRead: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		feed_reader_logger_error (_tmp5_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (entry_ids);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (entry_ids);
}

static void
feed_reader_feedbin_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                       const gchar* article_id,
                                                       FeedReaderArticleStatus status)
{
	FeedReaderFeedbinInterface * self;
	gint64 entry_id = 0LL;
	GeeList* entry_ids = NULL;
	GeeList* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (article_id != NULL);
	entry_id = int64_parse (article_id, (guint) 0);
	_tmp0_ = feed_reader_list_utils_single (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, &entry_id);
	entry_ids = _tmp0_;
	{
		FeedbinAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feedbin_api_set_entries_starred (_tmp1_, (GeeCollection*) entry_ids, status == FEED_READER_ARTICLE_STATUS_MARKED, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = g_strconcat ("FeedbinInterface.setArticleIsMarked: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		feed_reader_logger_error (_tmp5_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (entry_ids);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (entry_ids);
}

static void
feed_reader_feedbin_interface_setRead (FeedReaderFeedbinInterface* self,
                                       const gchar* id,
                                       FeedReaderFeedListType type)
{
	static const gint count = 1000;
	gint num_articles = 0;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	num_articles = 1;
	_tmp0_ = feed_reader_data_base_readOnly ();
	db = _tmp0_;
	{
		gint offset = 0;
		offset = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeList* articles = NULL;
				FeedReaderDataBaseReadOnly* _tmp2_;
				GeeList* _tmp3_;
				GeeArrayList* entry_ids = NULL;
				GeeArrayList* _tmp4_;
				if (!_tmp1_) {
					offset += count;
				}
				_tmp1_ = FALSE;
				if (!(num_articles > 0)) {
					break;
				}
				_tmp2_ = db;
				_tmp3_ = feed_reader_data_base_read_only_read_articles (_tmp2_, id, type, FEED_READER_ARTICLE_LIST_STATE_ALL, "", (guint) count, (guint) offset, 0);
				articles = _tmp3_;
				_tmp4_ = gee_array_list_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				entry_ids = _tmp4_;
				{
					GeeList* _article_list = NULL;
					GeeList* _tmp5_;
					gint _article_size = 0;
					GeeList* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					gint _article_index = 0;
					_tmp5_ = articles;
					_article_list = _tmp5_;
					_tmp6_ = _article_list;
					_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
					_tmp8_ = _tmp7_;
					_article_size = _tmp8_;
					_article_index = -1;
					while (TRUE) {
						gint _tmp9_;
						gint _tmp10_;
						FeedReaderArticle* article = NULL;
						GeeList* _tmp11_;
						gpointer _tmp12_;
						GeeArrayList* _tmp13_;
						FeedReaderArticle* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						gint64 _tmp17_;
						_article_index = _article_index + 1;
						_tmp9_ = _article_index;
						_tmp10_ = _article_size;
						if (!(_tmp9_ < _tmp10_)) {
							break;
						}
						_tmp11_ = _article_list;
						_tmp12_ = gee_list_get (_tmp11_, _article_index);
						article = (FeedReaderArticle*) _tmp12_;
						_tmp13_ = entry_ids;
						_tmp14_ = article;
						_tmp15_ = feed_reader_article_getArticleID (_tmp14_);
						_tmp16_ = _tmp15_;
						_tmp17_ = int64_parse (_tmp16_, (guint) 0);
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, &_tmp17_);
						_g_free0 (_tmp16_);
						_g_object_unref0 (article);
					}
				}
				{
					FeedbinAPI* _tmp18_;
					GeeArrayList* _tmp19_;
					_tmp18_ = self->priv->m_api;
					_tmp19_ = entry_ids;
					feedbin_api_set_entries_read (_tmp18_, (GeeCollection*) _tmp19_, TRUE, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					_tmp22_ = g_strconcat ("FeedbinInterface.setRead: ", _tmp21_, NULL);
					_tmp23_ = _tmp22_;
					feed_reader_logger_error (_tmp23_);
					_g_free0 (_tmp23_);
					_g_error_free0 (e);
					_g_object_unref0 (entry_ids);
					_g_object_unref0 (articles);
					break;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (entry_ids);
					_g_object_unref0 (articles);
					_g_object_unref0 (db);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_object_unref0 (entry_ids);
				_g_object_unref0 (articles);
			}
		}
	}
	_g_object_unref0 (db);
}

static gboolean
feed_reader_feedbin_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_feedbin_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                const gchar* feed_id)
{
	FeedReaderFeedbinInterface * self;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (feed_id != NULL);
	feed_reader_feedbin_interface_setRead (self, feed_id, FEED_READER_FEED_LIST_TYPE_FEED);
}

static void
feed_reader_feedbin_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                    const gchar* category_id)
{
	FeedReaderFeedbinInterface * self;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (category_id != NULL);
	feed_reader_feedbin_interface_setRead (self, category_id, FEED_READER_FEED_LIST_TYPE_CATEGORY);
}

static void
feed_reader_feedbin_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (FeedReaderFeedbinInterface*) base;
	_tmp0_ = feed_reader_feed_id_to_string (FEED_READER_FEED_ID_ALL);
	_tmp1_ = _tmp0_;
	feed_reader_feedbin_interface_setRead (self, _tmp1_, FEED_READER_FEED_LIST_TYPE_FEED);
	_g_free0 (_tmp1_);
}

static void
feed_reader_feedbin_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                               const gchar* article_id,
                                               const gchar* tag_id)
{
	FeedReaderFeedbinInterface * self;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (article_id != NULL);
	g_return_if_fail (tag_id != NULL);
	return;
}

static void
feed_reader_feedbin_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                     const gchar* article_id,
                                                     const gchar* tag_id)
{
	FeedReaderFeedbinInterface * self;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (article_id != NULL);
	g_return_if_fail (tag_id != NULL);
	return;
}

static gchar*
feed_reader_feedbin_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                              const gchar* caption)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static void
feed_reader_feedbin_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                              const gchar* tag_id)
{
	FeedReaderFeedbinInterface * self;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (tag_id != NULL);
	return;
}

static void
feed_reader_feedbin_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                              const gchar* tagID,
                                              const gchar* title)
{
	FeedReaderFeedbinInterface * self;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	return;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_vala_FeedbinAPISubscription_free (FeedbinAPISubscription* self)
{
	feedbin_api_subscription_destroy (self);
	g_free (self);
}

static gboolean
feed_reader_feedbin_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                            const gchar* feed_url,
                                            const gchar* cat_id,
                                            const gchar* category_name,
                                            gchar** feed_id,
                                            gchar** errmsg)
{
	FeedReaderFeedbinInterface * self;
	gchar* _vala_feed_id = NULL;
	gchar* _vala_errmsg = NULL;
	gchar* _tmp0_;
	gboolean _tmp18_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_val_if_fail (feed_url != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_feed_id);
	_vala_feed_id = _tmp0_;
	{
		FeedbinAPISubscription* subscription = NULL;
		FeedbinAPI* _tmp1_;
		FeedbinAPISubscription* _tmp2_;
		FeedbinAPISubscription* _tmp3_;
		FeedbinAPISubscription* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp10_;
		_tmp1_ = self->priv->m_api;
		_tmp2_ = feedbin_api_add_subscription (_tmp1_, feed_url, &_inner_error0_);
		subscription = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = subscription;
		if (_tmp3_ == NULL) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = string_to_string (feed_url);
			_tmp5_ = g_strconcat ("Feedbin could not find a feed at ", _tmp4_, NULL);
			_g_free0 (_vala_errmsg);
			_vala_errmsg = _tmp5_;
			result = FALSE;
			__vala_FeedbinAPISubscription_free0 (subscription);
			if (feed_id) {
				*feed_id = _vala_feed_id;
			} else {
				_g_free0 (_vala_feed_id);
			}
			if (errmsg) {
				*errmsg = _vala_errmsg;
			} else {
				_g_free0 (_vala_errmsg);
			}
			return result;
		}
		_tmp6_ = subscription;
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, (*_tmp6_).feed_id);
		_g_free0 (_vala_feed_id);
		_vala_feed_id = _tmp7_;
		if (category_name != NULL) {
			FeedbinAPI* _tmp8_;
			FeedbinAPISubscription* _tmp9_;
			_tmp8_ = self->priv->m_api;
			_tmp9_ = subscription;
			feedbin_api_add_tagging (_tmp8_, (*_tmp9_).feed_id, category_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				__vala_FeedbinAPISubscription_free0 (subscription);
				goto __catch0_g_error;
			}
		}
		_tmp10_ = g_strdup ("");
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp10_;
		result = TRUE;
		__vala_FeedbinAPISubscription_free0 (subscription);
		if (feed_id) {
			*feed_id = _vala_feed_id;
		} else {
			_g_free0 (_vala_feed_id);
		}
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp13_;
		_tmp14_ = _vala_errmsg;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("FeedbinInterface.addFeed: ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		feed_reader_logger_error (_tmp17_);
		_g_free0 (_tmp17_);
		result = FALSE;
		_g_error_free0 (e);
		if (feed_id) {
			*feed_id = _vala_feed_id;
		} else {
			_g_free0 (_vala_feed_id);
		}
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	__finally0:
	_g_free0 (_vala_feed_id);
	_g_free0 (_vala_errmsg);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp18_;
}

static void
feed_reader_feedbin_interface_subscription_for_feed (FeedReaderFeedbinInterface* self,
                                                     const gchar* feed_id_str,
                                                     FeedbinAPISubscription* result,
                                                     GError** error)
{
	gint64 feed_id = 0LL;
	GeeList* subscriptions = NULL;
	FeedbinAPI* _tmp0_;
	GeeList* _tmp1_;
	GError* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feed_id_str != NULL);
	feed_id = int64_parse (feed_id_str, (guint) 0);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = feedbin_api_get_subscriptions (_tmp0_, &_inner_error0_);
	subscriptions = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GeeList* _subscription_list = NULL;
		GeeList* _tmp2_;
		gint _subscription_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _subscription_index = 0;
		_tmp2_ = subscriptions;
		_subscription_list = _tmp2_;
		_tmp3_ = _subscription_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_subscription_size = _tmp5_;
		_subscription_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			FeedbinAPISubscription* subscription = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			FeedbinAPISubscription* _tmp10_;
			_subscription_index = _subscription_index + 1;
			_tmp6_ = _subscription_index;
			_tmp7_ = _subscription_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _subscription_list;
			_tmp9_ = gee_list_get (_tmp8_, _subscription_index);
			subscription = (FeedbinAPISubscription*) _tmp9_;
			_tmp10_ = subscription;
			if ((*_tmp10_).feed_id == feed_id) {
				FeedbinAPISubscription* _tmp11_;
				FeedbinAPISubscription _tmp12_;
				FeedbinAPISubscription _tmp13_ = {0};
				FeedbinAPISubscription _tmp14_;
				_tmp11_ = subscription;
				_tmp12_ = *_tmp11_;
				feedbin_api_subscription_copy (&_tmp12_, &_tmp13_);
				_tmp14_ = _tmp13_;
				__vala_FeedbinAPISubscription_free0 (_tmp11_);
				*result = _tmp14_;
				_g_object_unref0 (subscriptions);
				return;
			}
			__vala_FeedbinAPISubscription_free0 (subscription);
		}
	}
	_tmp15_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_FOUND, "No subscription found for feed $feed_id");
	_inner_error0_ = _tmp15_;
	if (_inner_error0_->domain == FEEDBIN_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (subscriptions);
		return;
	} else {
		_g_object_unref0 (subscriptions);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
feed_reader_feedbin_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                               const gchar* feed_id_str)
{
	FeedReaderFeedbinInterface * self;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (feed_id_str != NULL);
	{
		FeedbinAPISubscription subscription = {0};
		FeedbinAPISubscription _tmp0_ = {0};
		FeedbinAPI* _tmp1_;
		FeedbinAPISubscription _tmp2_;
		feed_reader_feedbin_interface_subscription_for_feed (self, feed_id_str, &_tmp0_, &_inner_error0_);
		subscription = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->m_api;
		_tmp2_ = subscription;
		feedbin_api_delete_subscription (_tmp1_, _tmp2_.id, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			feedbin_api_subscription_destroy (&subscription);
			goto __catch0_g_error;
		}
		feedbin_api_subscription_destroy (&subscription);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_strconcat ("FeedbinInterface.removeFeed: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		feed_reader_logger_error (_tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
feed_reader_feedbin_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                               const gchar* feed_id_str,
                                               const gchar* title)
{
	FeedReaderFeedbinInterface * self;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (feed_id_str != NULL);
	g_return_if_fail (title != NULL);
	{
		FeedbinAPISubscription subscription = {0};
		FeedbinAPISubscription _tmp0_ = {0};
		FeedbinAPI* _tmp1_;
		FeedbinAPISubscription _tmp2_;
		feed_reader_feedbin_interface_subscription_for_feed (self, feed_id_str, &_tmp0_, &_inner_error0_);
		subscription = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->m_api;
		_tmp2_ = subscription;
		feedbin_api_rename_subscription (_tmp1_, _tmp2_.id, title, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			feedbin_api_subscription_destroy (&subscription);
			goto __catch0_g_error;
		}
		feedbin_api_subscription_destroy (&subscription);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_strconcat ("FeedbinInterface.renameFeed: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		feed_reader_logger_error (_tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_vala_FeedbinAPITagging_free (FeedbinAPITagging* self)
{
	feedbin_api_tagging_destroy (self);
	g_free (self);
}

static void
feed_reader_feedbin_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feed_id_str,
                                             const gchar* new_category,
                                             const gchar* old_category)
{
	FeedReaderFeedbinInterface * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (feed_id_str != NULL);
	g_return_if_fail (new_category != NULL);
	_tmp0_ = string_to_string (feed_id_str);
	_tmp1_ = string_to_string (old_category);
	_tmp2_ = string_to_string (new_category);
	_tmp3_ = g_strconcat ("moveFeed: ", _tmp0_, " from ", _tmp1_, " to ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	feed_reader_logger_debug (_tmp4_);
	_g_free0 (_tmp4_);
	{
		FeedbinAPISubscription subscription = {0};
		FeedbinAPISubscription _tmp5_ = {0};
		gint64 feed_id = 0LL;
		FeedbinAPISubscription _tmp6_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		FeedbinAPI* _tmp33_;
		feed_reader_feedbin_interface_subscription_for_feed (self, feed_id_str, &_tmp5_, &_inner_error0_);
		subscription = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = subscription;
		feed_id = _tmp6_.feed_id;
		if (old_category != NULL) {
			GeeList* taggings = NULL;
			FeedbinAPI* _tmp7_;
			GeeList* _tmp8_;
			_tmp7_ = self->priv->m_api;
			_tmp8_ = feedbin_api_get_taggings (_tmp7_, &_inner_error0_);
			taggings = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				feedbin_api_subscription_destroy (&subscription);
				goto __catch0_g_error;
			}
			{
				GeeList* _tagging_list = NULL;
				GeeList* _tmp9_;
				gint _tagging_size = 0;
				GeeList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tagging_index = 0;
				_tmp9_ = taggings;
				_tagging_list = _tmp9_;
				_tmp10_ = _tagging_list;
				_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tagging_size = _tmp12_;
				_tagging_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					FeedbinAPITagging* tagging = NULL;
					GeeList* _tmp15_;
					gpointer _tmp16_;
					gboolean _tmp17_ = FALSE;
					FeedbinAPITagging* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					FeedbinAPI* _tmp26_;
					FeedbinAPITagging* _tmp27_;
					_tagging_index = _tagging_index + 1;
					_tmp13_ = _tagging_index;
					_tmp14_ = _tagging_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _tagging_list;
					_tmp16_ = gee_list_get (_tmp15_, _tagging_index);
					tagging = (FeedbinAPITagging*) _tmp16_;
					_tmp18_ = tagging;
					_tmp19_ = (*_tmp18_).name;
					if (g_strcmp0 (_tmp19_, old_category) != 0) {
						_tmp17_ = TRUE;
					} else {
						FeedbinAPITagging* _tmp20_;
						_tmp20_ = tagging;
						_tmp17_ = (*_tmp20_).feed_id != feed_id;
					}
					if (_tmp17_) {
						__vala_FeedbinAPITagging_free0 (tagging);
						continue;
					}
					_tmp21_ = string_to_string (old_category);
					_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_id);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat ("moveFeed: Deleting tag ", _tmp21_, " from ", _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					feed_reader_logger_debug (_tmp25_);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp23_);
					_tmp26_ = self->priv->m_api;
					_tmp27_ = tagging;
					feedbin_api_delete_tagging (_tmp26_, (*_tmp27_).id, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						__vala_FeedbinAPITagging_free0 (tagging);
						_g_object_unref0 (taggings);
						feedbin_api_subscription_destroy (&subscription);
						goto __catch0_g_error;
					}
					__vala_FeedbinAPITagging_free0 (tagging);
					break;
				}
			}
			_g_object_unref0 (taggings);
		}
		_tmp28_ = string_to_string (new_category);
		_tmp29_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_id);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat ("moveFeed: Adding tag ", _tmp28_, " to ", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		feed_reader_logger_debug (_tmp32_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		_tmp33_ = self->priv->m_api;
		feedbin_api_add_tagging (_tmp33_, feed_id, new_category, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			feedbin_api_subscription_destroy (&subscription);
			goto __catch0_g_error;
		}
		feedbin_api_subscription_destroy (&subscription);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		_tmp36_ = g_strconcat ("FeedbinInterface.moveFeed: ", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		feed_reader_logger_error (_tmp37_);
		_g_free0 (_tmp37_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
feed_reader_feedbin_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                   const gchar* old_category,
                                                   const gchar* new_category)
{
	FeedReaderFeedbinInterface * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (old_category != NULL);
	g_return_if_fail (new_category != NULL);
	_tmp0_ = string_to_string (old_category);
	_tmp1_ = string_to_string (new_category);
	_tmp2_ = g_strconcat ("renameCategory: From ", _tmp0_, " to ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	feed_reader_logger_debug (_tmp3_);
	_g_free0 (_tmp3_);
	{
		GeeList* taggings = NULL;
		FeedbinAPI* _tmp4_;
		GeeList* _tmp5_;
		_tmp4_ = self->priv->m_api;
		_tmp5_ = feedbin_api_get_taggings (_tmp4_, &_inner_error0_);
		taggings = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeList* _tagging_list = NULL;
			GeeList* _tmp6_;
			gint _tagging_size = 0;
			GeeList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tagging_index = 0;
			_tmp6_ = taggings;
			_tagging_list = _tmp6_;
			_tmp7_ = _tagging_list;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tagging_size = _tmp9_;
			_tagging_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				FeedbinAPITagging* tagging = NULL;
				GeeList* _tmp12_;
				gpointer _tmp13_;
				FeedbinAPITagging* _tmp14_;
				const gchar* _tmp15_;
				gint64 feed_id = 0LL;
				FeedbinAPITagging* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				FeedbinAPI* _tmp22_;
				FeedbinAPITagging* _tmp23_;
				FeedbinAPI* _tmp24_;
				_tagging_index = _tagging_index + 1;
				_tmp10_ = _tagging_index;
				_tmp11_ = _tagging_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _tagging_list;
				_tmp13_ = gee_list_get (_tmp12_, _tagging_index);
				tagging = (FeedbinAPITagging*) _tmp13_;
				_tmp14_ = tagging;
				_tmp15_ = (*_tmp14_).name;
				if (g_strcmp0 (_tmp15_, old_category) != 0) {
					__vala_FeedbinAPITagging_free0 (tagging);
					continue;
				}
				_tmp16_ = tagging;
				feed_id = (*_tmp16_).feed_id;
				_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_id);
				_tmp18_ = _tmp17_;
				_tmp19_ = string_to_string (new_category);
				_tmp20_ = g_strconcat ("renameCategory: Tagging ", _tmp18_, " with ", _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				feed_reader_logger_debug (_tmp21_);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp18_);
				_tmp22_ = self->priv->m_api;
				_tmp23_ = tagging;
				feedbin_api_delete_tagging (_tmp22_, (*_tmp23_).id, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_FeedbinAPITagging_free0 (tagging);
					_g_object_unref0 (taggings);
					goto __catch0_g_error;
				}
				_tmp24_ = self->priv->m_api;
				feedbin_api_add_tagging (_tmp24_, feed_id, new_category, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_FeedbinAPITagging_free0 (tagging);
					_g_object_unref0 (taggings);
					goto __catch0_g_error;
				}
				__vala_FeedbinAPITagging_free0 (tagging);
			}
		}
		_g_object_unref0 (taggings);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_strconcat ("FeedbinInterface.renameCategory: ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		feed_reader_logger_error (_tmp28_);
		_g_free0 (_tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
feed_reader_feedbin_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* category_id,
                                                 const gchar* new_parent_id)
{
	FeedReaderFeedbinInterface * self;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (category_id != NULL);
	g_return_if_fail (new_parent_id != NULL);
}

static gchar*
feed_reader_feedbin_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                   const gchar* title,
                                                   const gchar* parent_id)
{
	FeedReaderFeedbinInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = g_strdup (title);
	result = _tmp0_;
	_vala_warn_if_fail (g_strcmp0 (result, title) == 0, "result == title");
	return result;
}

static void
feed_reader_feedbin_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                   const gchar* category)
{
	FeedReaderFeedbinInterface * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (category != NULL);
	_tmp0_ = string_to_string (category);
	_tmp1_ = g_strconcat ("deleteCategory: ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	{
		GeeList* taggings = NULL;
		FeedbinAPI* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = self->priv->m_api;
		_tmp4_ = feedbin_api_get_taggings (_tmp3_, &_inner_error0_);
		taggings = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeList* _tagging_list = NULL;
			GeeList* _tmp5_;
			gint _tagging_size = 0;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tagging_index = 0;
			_tmp5_ = taggings;
			_tagging_list = _tmp5_;
			_tmp6_ = _tagging_list;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tagging_size = _tmp8_;
			_tagging_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				FeedbinAPITagging* tagging = NULL;
				GeeList* _tmp11_;
				gpointer _tmp12_;
				FeedbinAPITagging* _tmp13_;
				const gchar* _tmp14_;
				gint64 feed_id = 0LL;
				FeedbinAPITagging* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				FeedbinAPI* _tmp21_;
				FeedbinAPITagging* _tmp22_;
				_tagging_index = _tagging_index + 1;
				_tmp9_ = _tagging_index;
				_tmp10_ = _tagging_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _tagging_list;
				_tmp12_ = gee_list_get (_tmp11_, _tagging_index);
				tagging = (FeedbinAPITagging*) _tmp12_;
				_tmp13_ = tagging;
				_tmp14_ = (*_tmp13_).name;
				if (g_strcmp0 (_tmp14_, category) != 0) {
					__vala_FeedbinAPITagging_free0 (tagging);
					continue;
				}
				_tmp15_ = tagging;
				feed_id = (*_tmp15_).feed_id;
				_tmp16_ = string_to_string (category);
				_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_id);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat ("deleteCategory: Deleting category ", _tmp16_, " from feed ", _tmp18_, NULL);
				_tmp20_ = _tmp19_;
				feed_reader_logger_debug (_tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_tmp21_ = self->priv->m_api;
				_tmp22_ = tagging;
				feedbin_api_delete_tagging (_tmp21_, (*_tmp22_).id, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_FeedbinAPITagging_free0 (tagging);
					_g_object_unref0 (taggings);
					goto __catch0_g_error;
				}
				__vala_FeedbinAPITagging_free0 (tagging);
			}
		}
		_g_object_unref0 (taggings);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = g_strconcat ("FeedbinInterface.deleteCategory: ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		feed_reader_logger_error (_tmp26_);
		_g_free0 (_tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
feed_reader_feedbin_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                      const gchar* feed_id_str,
                                                      const gchar* category)
{
	FeedReaderFeedbinInterface * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_if_fail (feed_id_str != NULL);
	g_return_if_fail (category != NULL);
	_tmp0_ = string_to_string (feed_id_str);
	_tmp1_ = string_to_string (category);
	_tmp2_ = g_strconcat ("removeCatFromFeed: Feed ", _tmp0_, ", category ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	feed_reader_logger_debug (_tmp3_);
	_g_free0 (_tmp3_);
	{
		gint64 feed_id = 0LL;
		GeeList* taggings = NULL;
		FeedbinAPI* _tmp4_;
		GeeList* _tmp5_;
		feed_id = int64_parse (feed_id_str, (guint) 0);
		_tmp4_ = self->priv->m_api;
		_tmp5_ = feedbin_api_get_taggings (_tmp4_, &_inner_error0_);
		taggings = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeList* _tagging_list = NULL;
			GeeList* _tmp6_;
			gint _tagging_size = 0;
			GeeList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tagging_index = 0;
			_tmp6_ = taggings;
			_tagging_list = _tmp6_;
			_tmp7_ = _tagging_list;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tagging_size = _tmp9_;
			_tagging_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				FeedbinAPITagging* tagging = NULL;
				GeeList* _tmp12_;
				gpointer _tmp13_;
				gboolean _tmp14_ = FALSE;
				FeedbinAPITagging* _tmp15_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				FeedbinAPI* _tmp23_;
				FeedbinAPITagging* _tmp24_;
				_tagging_index = _tagging_index + 1;
				_tmp10_ = _tagging_index;
				_tmp11_ = _tagging_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _tagging_list;
				_tmp13_ = gee_list_get (_tmp12_, _tagging_index);
				tagging = (FeedbinAPITagging*) _tmp13_;
				_tmp15_ = tagging;
				if ((*_tmp15_).feed_id != feed_id) {
					_tmp14_ = TRUE;
				} else {
					FeedbinAPITagging* _tmp16_;
					const gchar* _tmp17_;
					_tmp16_ = tagging;
					_tmp17_ = (*_tmp16_).name;
					_tmp14_ = g_strcmp0 (_tmp17_, category) != 0;
				}
				if (_tmp14_) {
					__vala_FeedbinAPITagging_free0 (tagging);
					continue;
				}
				_tmp18_ = string_to_string (category);
				_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_id);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat ("removeCatFromFeed: Deleting category ", _tmp18_, " from feed ", _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				feed_reader_logger_debug (_tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_tmp23_ = self->priv->m_api;
				_tmp24_ = tagging;
				feedbin_api_delete_tagging (_tmp23_, (*_tmp24_).id, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					__vala_FeedbinAPITagging_free0 (tagging);
					_g_object_unref0 (taggings);
					goto __catch0_g_error;
				}
				__vala_FeedbinAPITagging_free0 (tagging);
				break;
			}
		}
		_g_object_unref0 (taggings);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_strconcat ("FeedbinInterface.removeCatFromFeed: ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		feed_reader_logger_error (_tmp28_);
		_g_free0 (_tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_vala_SoupURI_free (SoupURI* self)
{
	g_boxed_free (soup_uri_get_type (), self);
}

static gboolean
feed_reader_feedbin_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                    GeeList* feeds,
                                                    GeeList* categories,
                                                    GeeList* tags,
                                                    GCancellable* cancellable)
{
	FeedReaderFeedbinInterface * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (FeedReaderFeedbinInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	{
		GeeList* taggings = NULL;
		FeedbinAPI* _tmp0_;
		GeeList* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GeeMap* favicons = NULL;
		FeedbinAPI* _tmp3_;
		GeeMap* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GeeHashSet* category_names = NULL;
		GeeHashSet* _tmp6_;
		GeeHashSet* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		GeeHashSet* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* top_category = NULL;
		gchar* _tmp26_;
		GeeHashMultiMap* tag_map = NULL;
		GeeHashMultiMap* _tmp37_;
		GeeList* subscriptions = NULL;
		FeedbinAPI* _tmp52_;
		GeeList* _tmp53_;
		_tmp0_ = self->priv->m_api;
		_tmp1_ = feedbin_api_get_taggings (_tmp0_, &_inner_error0_);
		taggings = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp2_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			result = FALSE;
			_g_object_unref0 (taggings);
			return result;
		}
		_tmp3_ = self->priv->m_api;
		_tmp4_ = feedbin_api_get_favicons (_tmp3_, &_inner_error0_);
		favicons = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (taggings);
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp5_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = FALSE;
			_g_object_unref0 (favicons);
			_g_object_unref0 (taggings);
			return result;
		}
		_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
		category_names = _tmp6_;
		{
			GeeList* _tagging_list = NULL;
			GeeList* _tmp7_;
			gint _tagging_size = 0;
			GeeList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tagging_index = 0;
			_tmp7_ = taggings;
			_tagging_list = _tmp7_;
			_tmp8_ = _tagging_list;
			_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tagging_size = _tmp10_;
			_tagging_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				FeedbinAPITagging* tagging = NULL;
				GeeList* _tmp13_;
				gpointer _tmp14_;
				GeeHashSet* _tmp15_;
				FeedbinAPITagging* _tmp16_;
				const gchar* _tmp17_;
				_tagging_index = _tagging_index + 1;
				_tmp11_ = _tagging_index;
				_tmp12_ = _tagging_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _tagging_list;
				_tmp14_ = gee_list_get (_tmp13_, _tagging_index);
				tagging = (FeedbinAPITagging*) _tmp14_;
				_tmp15_ = category_names;
				_tmp16_ = tagging;
				_tmp17_ = (*_tmp16_).name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
				__vala_FeedbinAPITagging_free0 (tagging);
			}
		}
		_tmp18_ = category_names;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = category_names;
		_tmp22_ = feed_reader_string_utils_join ((GeeCollection*) _tmp21_, ", ");
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("getFeedsAndCats: Got %d categories: %s", _tmp20_, _tmp23_);
		_tmp25_ = _tmp24_;
		feed_reader_logger_debug (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		gee_collection_clear ((GeeCollection*) categories);
		_tmp26_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
		top_category = _tmp26_;
		{
			GeeIterator* _name_it = NULL;
			GeeHashSet* _tmp27_;
			GeeIterator* _tmp28_;
			_tmp27_ = category_names;
			_tmp28_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp27_);
			_name_it = _tmp28_;
			while (TRUE) {
				GeeIterator* _tmp29_;
				gchar* name = NULL;
				GeeIterator* _tmp30_;
				gpointer _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				FeedReaderCategory* _tmp35_;
				FeedReaderCategory* _tmp36_;
				_tmp29_ = _name_it;
				if (!gee_iterator_next (_tmp29_)) {
					break;
				}
				_tmp30_ = _name_it;
				_tmp31_ = gee_iterator_get (_tmp30_);
				name = (gchar*) _tmp31_;
				_tmp32_ = name;
				_tmp33_ = name;
				_tmp34_ = top_category;
				_tmp35_ = feed_reader_category_new (_tmp32_, _tmp33_, (guint) 0, 0, _tmp34_, 1);
				_tmp36_ = _tmp35_;
				gee_collection_add ((GeeCollection*) categories, _tmp36_);
				_g_object_unref0 (_tmp36_);
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		_tmp37_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		tag_map = _tmp37_;
		{
			GeeList* _tagging_list = NULL;
			GeeList* _tmp38_;
			gint _tagging_size = 0;
			GeeList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _tagging_index = 0;
			_tmp38_ = taggings;
			_tagging_list = _tmp38_;
			_tmp39_ = _tagging_list;
			_tmp40_ = gee_collection_get_size ((GeeCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tagging_size = _tmp41_;
			_tagging_index = -1;
			while (TRUE) {
				gint _tmp42_;
				gint _tmp43_;
				FeedbinAPITagging* tagging = NULL;
				GeeList* _tmp44_;
				gpointer _tmp45_;
				GeeHashMultiMap* _tmp46_;
				FeedbinAPITagging* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				FeedbinAPITagging* _tmp50_;
				const gchar* _tmp51_;
				_tagging_index = _tagging_index + 1;
				_tmp42_ = _tagging_index;
				_tmp43_ = _tagging_size;
				if (!(_tmp42_ < _tmp43_)) {
					break;
				}
				_tmp44_ = _tagging_list;
				_tmp45_ = gee_list_get (_tmp44_, _tagging_index);
				tagging = (FeedbinAPITagging*) _tmp45_;
				_tmp46_ = tag_map;
				_tmp47_ = tagging;
				_tmp48_ = g_strdup_printf ("%" G_GINT64_FORMAT, (*_tmp47_).feed_id);
				_tmp49_ = _tmp48_;
				_tmp50_ = tagging;
				_tmp51_ = (*_tmp50_).name;
				gee_multi_map_set ((GeeMultiMap*) _tmp46_, _tmp49_, _tmp51_);
				_g_free0 (_tmp49_);
				__vala_FeedbinAPITagging_free0 (tagging);
			}
		}
		_tmp52_ = self->priv->m_api;
		_tmp53_ = feedbin_api_get_subscriptions (_tmp52_, &_inner_error0_);
		subscriptions = _tmp53_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (tag_map);
			_g_free0 (top_category);
			_g_object_unref0 (category_names);
			_g_object_unref0 (favicons);
			_g_object_unref0 (taggings);
			goto __catch0_g_error;
		}
		gee_collection_clear ((GeeCollection*) feeds);
		{
			GeeList* _subscription_list = NULL;
			GeeList* _tmp54_;
			gint _subscription_size = 0;
			GeeList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint _subscription_index = 0;
			_tmp54_ = subscriptions;
			_subscription_list = _tmp54_;
			_tmp55_ = _subscription_list;
			_tmp56_ = gee_collection_get_size ((GeeCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			_subscription_size = _tmp57_;
			_subscription_index = -1;
			while (TRUE) {
				gint _tmp58_;
				gint _tmp59_;
				FeedbinAPISubscription* subscription = NULL;
				GeeList* _tmp60_;
				gpointer _tmp61_;
				gchar* feed_id = NULL;
				FeedbinAPISubscription* _tmp62_;
				gchar* _tmp63_;
				GeeList* feed_categories = NULL;
				GeeArrayList* _tmp64_;
				GeeHashMultiMap* _tmp65_;
				const gchar* _tmp66_;
				gchar* favicon_uri = NULL;
				FeedbinAPISubscription* _tmp75_;
				const gchar* _tmp76_;
				const gchar* _tmp93_;
				FeedbinAPISubscription* _tmp94_;
				const gchar* _tmp95_;
				FeedbinAPISubscription* _tmp96_;
				const gchar* _tmp97_;
				GeeList* _tmp98_;
				const gchar* _tmp99_;
				FeedbinAPISubscription* _tmp100_;
				const gchar* _tmp101_;
				FeedReaderFeed* _tmp102_;
				FeedReaderFeed* _tmp103_;
				_subscription_index = _subscription_index + 1;
				_tmp58_ = _subscription_index;
				_tmp59_ = _subscription_size;
				if (!(_tmp58_ < _tmp59_)) {
					break;
				}
				_tmp60_ = _subscription_list;
				_tmp61_ = gee_list_get (_tmp60_, _subscription_index);
				subscription = (FeedbinAPISubscription*) _tmp61_;
				_tmp62_ = subscription;
				_tmp63_ = g_strdup_printf ("%" G_GINT64_FORMAT, (*_tmp62_).feed_id);
				feed_id = _tmp63_;
				_tmp64_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				feed_categories = (GeeList*) _tmp64_;
				_tmp65_ = tag_map;
				_tmp66_ = feed_id;
				if (gee_multi_map_contains ((GeeMultiMap*) _tmp65_, _tmp66_)) {
					GeeList* _tmp67_;
					GeeHashMultiMap* _tmp68_;
					const gchar* _tmp69_;
					GeeCollection* _tmp70_;
					GeeCollection* _tmp71_;
					_tmp67_ = feed_categories;
					_tmp68_ = tag_map;
					_tmp69_ = feed_id;
					_tmp70_ = gee_multi_map_get ((GeeMultiMap*) _tmp68_, _tmp69_);
					_tmp71_ = _tmp70_;
					gee_collection_add_all ((GeeCollection*) _tmp67_, _tmp71_);
					_g_object_unref0 (_tmp71_);
				} else {
					GeeList* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					_tmp72_ = feed_categories;
					_tmp73_ = feed_reader_feed_server_interface_uncategorizedID ((FeedReaderFeedServerInterface*) self);
					_tmp74_ = _tmp73_;
					gee_collection_add ((GeeCollection*) _tmp72_, _tmp74_);
					_g_free0 (_tmp74_);
				}
				favicon_uri = NULL;
				_tmp75_ = subscription;
				_tmp76_ = (*_tmp75_).site_url;
				if (_tmp76_ != NULL) {
					SoupURI* uri = NULL;
					FeedbinAPISubscription* _tmp77_;
					const gchar* _tmp78_;
					SoupURI* _tmp79_;
					SoupURI* _tmp80_;
					_tmp77_ = subscription;
					_tmp78_ = (*_tmp77_).site_url;
					_tmp79_ = soup_uri_new (_tmp78_);
					uri = _tmp79_;
					_tmp80_ = uri;
					if (_tmp80_ != NULL) {
						GBytes* favicon = NULL;
						GeeMap* _tmp81_;
						SoupURI* _tmp82_;
						const gchar* _tmp83_;
						gpointer _tmp84_;
						GBytes* _tmp85_;
						_tmp81_ = favicons;
						_tmp82_ = uri;
						_tmp83_ = _tmp82_->host;
						_tmp84_ = gee_map_get (_tmp81_, _tmp83_);
						favicon = (GBytes*) _tmp84_;
						_tmp85_ = favicon;
						if (_tmp85_ != NULL) {
							gchar* base64 = NULL;
							GBytes* _tmp86_;
							gsize _tmp87_ = 0;
							guint8* _tmp88_;
							gchar* _tmp89_;
							const gchar* _tmp90_;
							const gchar* _tmp91_;
							gchar* _tmp92_;
							_tmp86_ = favicon;
							_tmp88_ = g_bytes_get_data (_tmp86_, &_tmp87_);
							_tmp89_ = g_base64_encode (_tmp88_, (gint) _tmp87_);
							base64 = _tmp89_;
							_tmp90_ = base64;
							_tmp91_ = string_to_string (_tmp90_);
							_tmp92_ = g_strconcat ("data:application/octet-stream;base64,", _tmp91_, NULL);
							_g_free0 (favicon_uri);
							favicon_uri = _tmp92_;
							_g_free0 (base64);
						}
						_g_bytes_unref0 (favicon);
					}
					__vala_SoupURI_free0 (uri);
				}
				_tmp93_ = feed_id;
				_tmp94_ = subscription;
				_tmp95_ = (*_tmp94_).title;
				_tmp96_ = subscription;
				_tmp97_ = (*_tmp96_).site_url;
				_tmp98_ = feed_categories;
				_tmp99_ = favicon_uri;
				_tmp100_ = subscription;
				_tmp101_ = (*_tmp100_).feed_url;
				_tmp102_ = feed_reader_feed_new (_tmp93_, _tmp95_, _tmp97_, (guint) 0, _tmp98_, _tmp99_, _tmp101_);
				_tmp103_ = _tmp102_;
				gee_collection_add ((GeeCollection*) feeds, _tmp103_);
				_g_object_unref0 (_tmp103_);
				_g_free0 (favicon_uri);
				_g_object_unref0 (feed_categories);
				_g_free0 (feed_id);
				__vala_FeedbinAPISubscription_free0 (subscription);
			}
		}
		_g_object_unref0 (subscriptions);
		_g_object_unref0 (tag_map);
		_g_free0 (top_category);
		_g_object_unref0 (category_names);
		_g_object_unref0 (favicons);
		_g_object_unref0 (taggings);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp104_ = e;
		_tmp105_ = _tmp104_->message;
		_tmp106_ = g_strconcat ("FeedbinInterface.getFeedsAndCats: ", _tmp105_, NULL);
		_tmp107_ = _tmp106_;
		feed_reader_logger_error (_tmp107_);
		_g_free0 (_tmp107_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp108_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp108_;
	}
	result = TRUE;
	return result;
}

static gint
feed_reader_feedbin_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedbinInterface * self;
	gint _tmp9_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (FeedReaderFeedbinInterface*) base;
	{
		GeeSet* _tmp0_ = NULL;
		FeedbinAPI* _tmp1_;
		GeeSet* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp1_ = self->priv->m_api;
		_tmp2_ = feedbin_api_get_unread_entries (_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp4_ = _tmp3_;
		result = _tmp4_;
		_vala_warn_if_fail (result >= 0, "result >= 0");
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = g_strconcat ("FeedbinInterface.getUnreadCount: ", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		feed_reader_logger_error (_tmp8_);
		_g_free0 (_tmp8_);
		result = 0;
		_vala_warn_if_fail (result >= 0, "result >= 0");
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp9_;
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static void
_vala_FeedbinAPIEntry_free (FeedbinAPIEntry* self)
{
	feedbin_api_entry_destroy (self);
	g_free (self);
}

static void
feed_reader_feedbin_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                gint count,
                                                FeedReaderArticleStatus what_to_get,
                                                GDateTime* since,
                                                const gchar* feed_id_str,
                                                gboolean is_tag_id,
                                                GCancellable* cancellable)
{
	FeedReaderFeedbinInterface * self;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderFeedbinInterface*) base;
	_vala_return_if_fail (count >= 0, "count >= 0");
	{
		FeedReaderDataBaseReadOnly* db = NULL;
		FeedReaderDataBaseReadOnly* _tmp0_;
		gint64* feed_id = NULL;
		gboolean _tmp1_ = FALSE;
		gboolean only_starred = FALSE;
		gboolean _tmp4_ = FALSE;
		GeeSet* unread_ids = NULL;
		FeedbinAPI* _tmp5_;
		GeeSet* _tmp6_;
		gboolean _tmp7_ = FALSE;
		GeeSet* starred_ids = NULL;
		FeedbinAPI* _tmp8_;
		GeeSet* _tmp9_;
		_tmp0_ = feed_reader_data_base_readOnly ();
		db = _tmp0_;
		feed_id = NULL;
		if (!is_tag_id) {
			_tmp1_ = feed_id_str != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gint64 _tmp2_;
			gint64* _tmp3_;
			_tmp2_ = int64_parse (feed_id_str, (guint) 0);
			_tmp3_ = __int64_dup0 (&_tmp2_);
			_g_free0 (feed_id);
			feed_id = _tmp3_;
		}
		only_starred = what_to_get == FEED_READER_ARTICLE_STATUS_MARKED;
		if (cancellable != NULL) {
			_tmp4_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_g_free0 (feed_id);
			_g_object_unref0 (db);
			return;
		}
		_tmp5_ = self->priv->m_api;
		_tmp6_ = feedbin_api_get_unread_entries (_tmp5_, &_inner_error0_);
		unread_ids = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (feed_id);
			_g_object_unref0 (db);
			goto __catch0_g_error;
		}
		if (cancellable != NULL) {
			_tmp7_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_g_object_unref0 (unread_ids);
			_g_free0 (feed_id);
			_g_object_unref0 (db);
			return;
		}
		_tmp8_ = self->priv->m_api;
		_tmp9_ = feedbin_api_get_starred_entries (_tmp8_, &_inner_error0_);
		starred_ids = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (unread_ids);
			_g_free0 (feed_id);
			_g_object_unref0 (db);
			goto __catch0_g_error;
		}
		{
			gchar* search_feed_id = NULL;
			FeedReaderFeedListType search_type = 0;
			gint64* _tmp10_;
			GEnumValue* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp10_ = feed_id;
			if (_tmp10_ == NULL) {
				gchar* _tmp11_;
				_tmp11_ = feed_reader_feed_id_to_string (FEED_READER_FEED_ID_ALL);
				_g_free0 (search_feed_id);
				search_feed_id = _tmp11_;
				search_type = FEED_READER_FEED_LIST_TYPE_ALL_FEEDS;
			} else {
				if (is_tag_id) {
					gchar* _tmp12_;
					_tmp12_ = g_strdup (feed_id_str);
					_g_free0 (search_feed_id);
					search_feed_id = _tmp12_;
					search_type = FEED_READER_FEED_LIST_TYPE_TAG;
				} else {
					gchar* _tmp13_;
					_tmp13_ = g_strdup (feed_id_str);
					_g_free0 (search_feed_id);
					search_feed_id = _tmp13_;
					search_type = FEED_READER_FEED_LIST_TYPE_FEED;
				}
			}
			_tmp14_ = g_enum_get_value (g_type_class_ref (FEED_READER_TYPE_FEED_LIST_TYPE), search_type);
			_tmp15_ = search_feed_id;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = g_strconcat ("Checking if any articles in ", (_tmp14_ != NULL) ? _tmp14_->value_name : NULL, " ", _tmp16_, " changed state", NULL);
			_tmp18_ = _tmp17_;
			feed_reader_logger_debug (_tmp18_);
			_g_free0 (_tmp18_);
			{
				gint offset = 0;
				gint c = 0;
				offset = 0;
				c = 1000;
				{
					gboolean _tmp19_ = FALSE;
					_tmp19_ = TRUE;
					while (TRUE) {
						GeeArrayList* articles = NULL;
						GeeArrayList* _tmp20_;
						GeeList* existing_articles = NULL;
						FeedReaderDataBaseReadOnly* _tmp21_;
						const gchar* _tmp22_;
						GeeList* _tmp23_;
						GeeList* _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						GeeArrayList* _tmp49_;
						if (!_tmp19_) {
							offset += c;
						}
						_tmp19_ = FALSE;
						_tmp20_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						articles = _tmp20_;
						_tmp21_ = db;
						_tmp22_ = search_feed_id;
						_tmp23_ = feed_reader_data_base_read_only_read_articles (_tmp21_, _tmp22_, search_type, FEED_READER_ARTICLE_LIST_STATE_ALL, "", (guint) c, (guint) offset, 0);
						existing_articles = _tmp23_;
						_tmp24_ = existing_articles;
						_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
						_tmp26_ = _tmp25_;
						if (_tmp26_ == 0) {
							_g_object_unref0 (existing_articles);
							_g_object_unref0 (articles);
							break;
						}
						{
							GeeList* _article_list = NULL;
							GeeList* _tmp27_;
							gint _article_size = 0;
							GeeList* _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
							gint _article_index = 0;
							_tmp27_ = existing_articles;
							_article_list = _tmp27_;
							_tmp28_ = _article_list;
							_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
							_tmp30_ = _tmp29_;
							_article_size = _tmp30_;
							_article_index = -1;
							while (TRUE) {
								gint _tmp31_;
								gint _tmp32_;
								FeedReaderArticle* article = NULL;
								GeeList* _tmp33_;
								gpointer _tmp34_;
								gint64 id = 0LL;
								FeedReaderArticle* _tmp35_;
								gchar* _tmp36_;
								gchar* _tmp37_;
								gint64 _tmp38_;
								FeedReaderArticleStatus _tmp39_ = 0;
								GeeSet* _tmp40_;
								FeedReaderArticleStatus marked = 0;
								FeedReaderArticleStatus _tmp41_ = 0;
								GeeSet* _tmp42_;
								FeedReaderArticleStatus unread = 0;
								gboolean changed = FALSE;
								FeedReaderArticle* _tmp43_;
								FeedReaderArticle* _tmp45_;
								GeeArrayList* _tmp47_;
								FeedReaderArticle* _tmp48_;
								_article_index = _article_index + 1;
								_tmp31_ = _article_index;
								_tmp32_ = _article_size;
								if (!(_tmp31_ < _tmp32_)) {
									break;
								}
								_tmp33_ = _article_list;
								_tmp34_ = gee_list_get (_tmp33_, _article_index);
								article = (FeedReaderArticle*) _tmp34_;
								_tmp35_ = article;
								_tmp36_ = feed_reader_article_getArticleID (_tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = int64_parse (_tmp37_, (guint) 0);
								_g_free0 (_tmp37_);
								id = _tmp38_;
								_tmp40_ = starred_ids;
								if (gee_collection_contains ((GeeCollection*) _tmp40_, &id)) {
									_tmp39_ = FEED_READER_ARTICLE_STATUS_MARKED;
								} else {
									_tmp39_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
								}
								marked = _tmp39_;
								_tmp42_ = unread_ids;
								if (gee_collection_contains ((GeeCollection*) _tmp42_, &id)) {
									_tmp41_ = FEED_READER_ARTICLE_STATUS_UNREAD;
								} else {
									_tmp41_ = FEED_READER_ARTICLE_STATUS_READ;
								}
								unread = _tmp41_;
								changed = FALSE;
								_tmp43_ = article;
								if (feed_reader_article_getMarked (_tmp43_) != marked) {
									FeedReaderArticle* _tmp44_;
									_tmp44_ = article;
									feed_reader_article_setMarked (_tmp44_, marked);
									changed = TRUE;
								}
								_tmp45_ = article;
								if (feed_reader_article_getUnread (_tmp45_) != unread) {
									FeedReaderArticle* _tmp46_;
									_tmp46_ = article;
									feed_reader_article_setUnread (_tmp46_, unread);
									changed = TRUE;
								}
								_tmp47_ = articles;
								_tmp48_ = article;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, _tmp48_);
								_g_object_unref0 (article);
							}
						}
						_tmp49_ = articles;
						g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "write-articles", (GeeList*) _tmp49_);
						_g_object_unref0 (existing_articles);
						_g_object_unref0 (articles);
					}
				}
			}
			_g_free0 (search_feed_id);
		}
		{
			gint page = 0;
			page = 1;
			{
				gboolean _tmp50_ = FALSE;
				_tmp50_ = TRUE;
				while (TRUE) {
					gboolean _tmp52_ = FALSE;
					GeeList* entries = NULL;
					FeedbinAPI* _tmp53_;
					gint64* _tmp54_;
					GeeList* _tmp55_;
					GeeList* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					GeeArrayList* articles = NULL;
					GeeArrayList* _tmp59_;
					GeeArrayList* _tmp100_;
					if (!_tmp50_) {
						gint _tmp51_;
						page = page + 1;
						_tmp51_ = page;
					}
					_tmp50_ = FALSE;
					if (cancellable != NULL) {
						_tmp52_ = g_cancellable_is_cancelled (cancellable);
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						_g_object_unref0 (starred_ids);
						_g_object_unref0 (unread_ids);
						_g_free0 (feed_id);
						_g_object_unref0 (db);
						return;
					}
					_tmp53_ = self->priv->m_api;
					_tmp54_ = feed_id;
					_tmp55_ = feedbin_api_get_entries (_tmp53_, page, only_starred, since, _tmp54_, &_inner_error0_);
					entries = _tmp55_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (starred_ids);
						_g_object_unref0 (unread_ids);
						_g_free0 (feed_id);
						_g_object_unref0 (db);
						goto __catch0_g_error;
					}
					_tmp56_ = entries;
					_tmp57_ = gee_collection_get_size ((GeeCollection*) _tmp56_);
					_tmp58_ = _tmp57_;
					if (_tmp58_ == 0) {
						_g_object_unref0 (entries);
						break;
					}
					_tmp59_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					articles = _tmp59_;
					{
						GeeList* _entry_list = NULL;
						GeeList* _tmp60_;
						gint _entry_size = 0;
						GeeList* _tmp61_;
						gint _tmp62_;
						gint _tmp63_;
						gint _entry_index = 0;
						_tmp60_ = entries;
						_entry_list = _tmp60_;
						_tmp61_ = _entry_list;
						_tmp62_ = gee_collection_get_size ((GeeCollection*) _tmp61_);
						_tmp63_ = _tmp62_;
						_entry_size = _tmp63_;
						_entry_index = -1;
						while (TRUE) {
							gint _tmp64_;
							gint _tmp65_;
							FeedbinAPIEntry* entry = NULL;
							GeeList* _tmp66_;
							gpointer _tmp67_;
							FeedReaderArticleStatus _tmp68_ = 0;
							GeeSet* _tmp69_;
							FeedbinAPIEntry* _tmp70_;
							FeedReaderArticleStatus _tmp71_ = 0;
							GeeSet* _tmp72_;
							FeedbinAPIEntry* _tmp73_;
							GDateTime* _tmp74_ = NULL;
							FeedbinAPIEntry* _tmp75_;
							GDateTime* _tmp76_;
							GeeArrayList* _tmp81_;
							FeedbinAPIEntry* _tmp82_;
							gchar* _tmp83_;
							gchar* _tmp84_;
							FeedbinAPIEntry* _tmp85_;
							const gchar* _tmp86_;
							FeedbinAPIEntry* _tmp87_;
							const gchar* _tmp88_;
							FeedbinAPIEntry* _tmp89_;
							gchar* _tmp90_;
							gchar* _tmp91_;
							FeedbinAPIEntry* _tmp92_;
							const gchar* _tmp93_;
							FeedbinAPIEntry* _tmp94_;
							const gchar* _tmp95_;
							FeedbinAPIEntry* _tmp96_;
							const gchar* _tmp97_;
							FeedReaderArticle* _tmp98_;
							FeedReaderArticle* _tmp99_;
							_entry_index = _entry_index + 1;
							_tmp64_ = _entry_index;
							_tmp65_ = _entry_size;
							if (!(_tmp64_ < _tmp65_)) {
								break;
							}
							_tmp66_ = _entry_list;
							_tmp67_ = gee_list_get (_tmp66_, _entry_index);
							entry = (FeedbinAPIEntry*) _tmp67_;
							_tmp69_ = unread_ids;
							_tmp70_ = entry;
							if (gee_collection_contains ((GeeCollection*) _tmp69_, &(*_tmp70_).id)) {
								_tmp68_ = FEED_READER_ARTICLE_STATUS_UNREAD;
							} else {
								_tmp68_ = FEED_READER_ARTICLE_STATUS_READ;
							}
							_tmp72_ = starred_ids;
							_tmp73_ = entry;
							if (gee_collection_contains ((GeeCollection*) _tmp72_, &(*_tmp73_).id)) {
								_tmp71_ = FEED_READER_ARTICLE_STATUS_MARKED;
							} else {
								_tmp71_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
							}
							_tmp75_ = entry;
							_tmp76_ = (*_tmp75_).published;
							if (_tmp76_ != NULL) {
								FeedbinAPIEntry* _tmp77_;
								GDateTime* _tmp78_;
								_tmp77_ = entry;
								_tmp78_ = (*_tmp77_).published;
								_tmp74_ = _tmp78_;
							} else {
								FeedbinAPIEntry* _tmp79_;
								GDateTime* _tmp80_;
								_tmp79_ = entry;
								_tmp80_ = (*_tmp79_).created_at;
								_tmp74_ = _tmp80_;
							}
							_tmp81_ = articles;
							_tmp82_ = entry;
							_tmp83_ = g_strdup_printf ("%" G_GINT64_FORMAT, (*_tmp82_).id);
							_tmp84_ = _tmp83_;
							_tmp85_ = entry;
							_tmp86_ = (*_tmp85_).title;
							_tmp87_ = entry;
							_tmp88_ = (*_tmp87_).url;
							_tmp89_ = entry;
							_tmp90_ = g_strdup_printf ("%" G_GINT64_FORMAT, (*_tmp89_).feed_id);
							_tmp91_ = _tmp90_;
							_tmp92_ = entry;
							_tmp93_ = (*_tmp92_).content;
							_tmp94_ = entry;
							_tmp95_ = (*_tmp94_).summary;
							_tmp96_ = entry;
							_tmp97_ = (*_tmp96_).author;
							_tmp98_ = feed_reader_article_new (_tmp84_, _tmp86_, _tmp88_, _tmp91_, _tmp68_, _tmp71_, _tmp93_, _tmp95_, _tmp97_, _tmp74_, 0, NULL, NULL, "", 0);
							_tmp99_ = _tmp98_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp81_, _tmp99_);
							_g_object_unref0 (_tmp99_);
							_g_free0 (_tmp91_);
							_g_free0 (_tmp84_);
							__vala_FeedbinAPIEntry_free0 (entry);
						}
					}
					_tmp100_ = articles;
					g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "write-articles", (GeeList*) _tmp100_);
					_g_object_unref0 (articles);
					_g_object_unref0 (entries);
				}
			}
		}
		_g_object_unref0 (starred_ids);
		_g_object_unref0 (unread_ids);
		_g_free0 (feed_id);
		_g_object_unref0 (db);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp101_;
		const gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp101_ = e;
		_tmp102_ = _tmp101_->message;
		_tmp103_ = g_strconcat ("FeedbinInterface.getArticles: ", _tmp102_, NULL);
		_tmp104_ = _tmp103_;
		feed_reader_logger_error (_tmp104_);
		_g_free0 (_tmp104_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

FeedReaderFeedbinInterface*
feed_reader_feedbin_interface_construct (GType object_type)
{
	FeedReaderFeedbinInterface * self = NULL;
	self = (FeedReaderFeedbinInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderFeedbinInterface*
feed_reader_feedbin_interface_new (void)
{
	return feed_reader_feedbin_interface_construct (FEED_READER_TYPE_FEEDBIN_INTERFACE);
}

static void
feed_reader_feedbin_interface_class_init (FeedReaderFeedbinInterfaceClass * klass,
                                          gpointer klass_data)
{
	feed_reader_feedbin_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderFeedbinInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_feedbin_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWidget = (GtkBox* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_getWidget;
	((FeedReaderFeedServerInterfaceClass *) klass)->writeData = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_writeData;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedbin_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feedbin_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feedbin_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedbin_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedbin_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedbin_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedbin_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_feedbin_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedbin_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedbin_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedbin_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_feedbin_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_feedbin_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_feedbin_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_feedbin_interface_finalize;
}

static void
feed_reader_feedbin_interface_instance_init (FeedReaderFeedbinInterface * self,
                                             gpointer klass)
{
	self->priv = feed_reader_feedbin_interface_get_instance_private (self);
}

static void
feed_reader_feedbin_interface_finalize (GObject * obj)
{
	FeedReaderFeedbinInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEEDBIN_INTERFACE, FeedReaderFeedbinInterface);
	_g_object_unref0 (self->priv->m_api);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_userEntry);
	_g_object_unref0 (self->priv->m_passwordEntry);
	G_OBJECT_CLASS (feed_reader_feedbin_interface_parent_class)->finalize (obj);
}

GType
feed_reader_feedbin_interface_get_type (void)
{
	return feed_reader_feedbin_interface_type_id;
}

GType
feed_reader_feedbin_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedbinInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feedbin_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedbinInterface), 0, (GInstanceInitFunc) feed_reader_feedbin_interface_instance_init, NULL };
	feed_reader_feedbin_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderFeedbinInterface", &g_define_type_info, 0);
	FeedReaderFeedbinInterface_private_offset = sizeof (FeedReaderFeedbinInterfacePrivate);
	return feed_reader_feedbin_interface_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_feedbin_interface_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_FEEDBIN_INTERFACE);
	_g_object_unref0 (objmodule);
}

