/* feedbinAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from feedbinAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/
/* TODO: Make a general-purpose HttpClient module with these errors*/

#include "feedbin_static.h"
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <gee.h>

#define FEEDBIN_API_BASE_URI_FORMAT "%s/v2/"

enum  {
	FEEDBIN_API_0_PROPERTY,
	FEEDBIN_API_USERNAME_PROPERTY,
	FEEDBIN_API_PASSWORD_PROPERTY,
	FEEDBIN_API_NUM_PROPERTIES
};
static GParamSpec* feedbin_api_properties[FEEDBIN_API_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FeedbinAPIPrivate {
	SoupSession* m_session;
	gchar* m_base_uri;
	gchar* _username;
	gchar* _password;
};

static gint FeedbinAPI_private_offset;
static gpointer feedbin_api_parent_class = NULL;

static void feedbin_api_authenticate (FeedbinAPI* self,
                               SoupMessage* msg,
                               SoupAuth* auth,
                               gboolean retrying);
static void _feedbin_api_authenticate_soup_session_authenticate (SoupSession* _sender,
                                                          SoupMessage* msg,
                                                          SoupAuth* auth,
                                                          gboolean retrying,
                                                          gpointer self);
static SoupMessage* feedbin_api_request (FeedbinAPI* self,
                                  const gchar* method,
                                  const gchar* last_part,
                                  const gchar* input,
                                  GError** error);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static GDateTime* feedbin_api_string_to_datetime (const gchar* s,
                                           GError** error);
static GDateTime* feedbin_api_get_datetime_member (JsonObject* obj,
                                            const gchar* name,
                                            GError** error);
static SoupMessage* feedbin_api_post_request (FeedbinAPI* self,
                                       const gchar* path,
                                       const gchar* input,
                                       GError** error);
static SoupMessage* feedbin_api_delete_request (FeedbinAPI* self,
                                         const gchar* path,
                                         GError** error);
static SoupMessage* feedbin_api_get_request (FeedbinAPI* self,
                                      const gchar* path,
                                      GError** error);
static JsonNode* feedbin_api_parse_json (SoupMessage* response,
                                  GError** error);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static JsonNode* feedbin_api_get_json (FeedbinAPI* self,
                                const gchar* path,
                                GError** error);
static void _vala_JsonNode_free (JsonNode* self);
static SoupMessage* feedbin_api_post_json_object (FeedbinAPI* self,
                                           const gchar* path,
                                           JsonObject* obj,
                                           GError** error);
static GeeSet* feedbin_api_get_x_entries (FeedbinAPI* self,
                                   const gchar* path,
                                   GError** error);
static guint __lambda4_ (FeedbinAPI* self,
                  gint64* n);
static guint ___lambda4__gee_hash_data_func (gconstpointer v,
                                      gpointer self);
static gboolean __lambda5_ (FeedbinAPI* self,
                     gint64* a,
                     gint64* b);
static gboolean ___lambda5__gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static gint64* _int64_dup (gint64* self);
static void feedbin_api_set_entries_status (FeedbinAPI* self,
                                     const gchar* type,
                                     GeeCollection* entry_ids,
                                     gboolean create,
                                     GError** error);
static void feedbin_api_finalize (GObject * obj);
static GType feedbin_api_get_type_once (void);
static void _vala_feedbin_api_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_feedbin_api_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
feedbin_error_quark (void)
{
	return g_quark_from_static_string ("feedbin-error-quark");
}

static GType
feedbin_error_get_type_once (void)
{
	static const GEnumValue values[] = {{FEEDBIN_ERROR_INVALID_FORMAT, "FEEDBIN_ERROR_INVALID_FORMAT", "invalid-format"}, {FEEDBIN_ERROR_MULTIPLE_CHOICES, "FEEDBIN_ERROR_MULTIPLE_CHOICES", "multiple-choices"}, {FEEDBIN_ERROR_NO_CONNECTION, "FEEDBIN_ERROR_NO_CONNECTION", "no-connection"}, {FEEDBIN_ERROR_NOT_AUTHORIZED, "FEEDBIN_ERROR_NOT_AUTHORIZED", "not-authorized"}, {FEEDBIN_ERROR_NOT_FOUND, "FEEDBIN_ERROR_NOT_FOUND", "not-found"}, {FEEDBIN_ERROR_UNKNOWN_ERROR, "FEEDBIN_ERROR_UNKNOWN_ERROR", "unknown-error"}, {0, NULL, NULL}};
	GType feedbin_error_type_id;
	feedbin_error_type_id = g_enum_register_static ("FeedbinError", values);
	return feedbin_error_type_id;
}

GType
feedbin_error_get_type (void)
{
	static volatile gsize feedbin_error_type_id__once = 0;
	if (g_once_init_enter (&feedbin_error_type_id__once)) {
		GType feedbin_error_type_id;
		feedbin_error_type_id = feedbin_error_get_type_once ();
		g_once_init_leave (&feedbin_error_type_id__once, feedbin_error_type_id);
	}
	return feedbin_error_type_id__once;
}

static inline gpointer
feedbin_api_get_instance_private (FeedbinAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedbinAPI_private_offset);
}

static void
_feedbin_api_authenticate_soup_session_authenticate (SoupSession* _sender,
                                                     SoupMessage* msg,
                                                     SoupAuth* auth,
                                                     gboolean retrying,
                                                     gpointer self)
{
	feedbin_api_authenticate ((FeedbinAPI*) self, msg, auth, retrying);
}

FeedbinAPI*
feedbin_api_construct (GType object_type,
                       const gchar* username,
                       const gchar* password,
                       const gchar* user_agent,
                       const gchar* host)
{
	FeedbinAPI * self = NULL;
	gchar* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp3_;
	g_return_val_if_fail (username != NULL, NULL);
	g_return_val_if_fail (password != NULL, NULL);
	self = (FeedbinAPI*) g_object_new (object_type, NULL);
	feedbin_api_set_username (self, username);
	feedbin_api_set_password (self, password);
	_tmp0_ = g_strdup_printf (FEEDBIN_API_BASE_URI_FORMAT, host);
	_g_free0 (self->priv->m_base_uri);
	self->priv->m_base_uri = _tmp0_;
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp1_;
	if (user_agent != NULL) {
		SoupSession* _tmp2_;
		_tmp2_ = self->priv->m_session;
		g_object_set (_tmp2_, "user-agent", user_agent, NULL);
	}
	_tmp3_ = self->priv->m_session;
	g_signal_connect_object (_tmp3_, "authenticate", (GCallback) _feedbin_api_authenticate_soup_session_authenticate, self, 0);
	return self;
}

FeedbinAPI*
feedbin_api_new (const gchar* username,
                 const gchar* password,
                 const gchar* user_agent,
                 const gchar* host)
{
	return feedbin_api_construct (TYPE_FEEDBIN_API, username, password, user_agent, host);
}

static void
feedbin_api_authenticate (FeedbinAPI* self,
                          SoupMessage* msg,
                          SoupAuth* auth,
                          gboolean retrying)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (auth != NULL);
	if (!retrying) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->_username;
		_tmp1_ = self->priv->_password;
		soup_auth_authenticate (auth, _tmp0_, _tmp1_);
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static SoupMessage*
feedbin_api_request (FeedbinAPI* self,
                     const gchar* method,
                     const gchar* last_part,
                     const gchar* input,
                     GError** error)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SoupMessage* message = NULL;
	const gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupSession* _tmp12_;
	SoupMessage* _tmp13_;
	guint status = 0U;
	SoupMessage* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	gboolean _tmp17_ = FALSE;
	SoupMessage* _tmp51_;
	guint _tmp52_;
	guint _tmp53_;
	SoupMessage* _tmp54_;
	guint _tmp55_;
	guint _tmp56_;
	GError* _inner_error0_ = NULL;
	SoupMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method != NULL, NULL);
	g_return_val_if_fail (last_part != NULL, NULL);
	_vala_return_val_if_fail (((g_strcmp0 (method, "DELETE") == 0) || (g_strcmp0 (method, "GET") == 0)) || (g_strcmp0 (method, "POST") == 0), "method == \"DELETE\" || method == \"GET\" || method == \"POST\"", NULL);
	_vala_return_val_if_fail ((input == NULL) || (g_strcmp0 (method, "GET") != 0), "input == null || method != \"GET\"", NULL);
	_tmp0_ = self->priv->m_base_uri;
	_tmp1_ = g_strconcat (_tmp0_, last_part, NULL);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = soup_message_new (method, _tmp2_);
	message = _tmp3_;
	if (g_strcmp0 (method, "POST") == 0) {
		SoupMessage* _tmp4_;
		SoupMessageHeaders* _tmp5_;
		_tmp4_ = message;
		_tmp5_ = _tmp4_->request_headers;
		soup_message_headers_append (_tmp5_, "Content-Type", "application/json; charset=utf-8");
	}
	if (input != NULL) {
		SoupMessage* _tmp6_;
		SoupMessageBody* _tmp7_;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_ = 0;
		guint8* _tmp10_;
		gint _tmp10__length1;
		guint8* _tmp11_;
		gint _tmp11__length1;
		_tmp6_ = message;
		_tmp7_ = _tmp6_->request_body;
		_tmp8_ = string_get_data (input, &_tmp9_);
		_tmp8__length1 = _tmp9_;
		_tmp10_ = _tmp8_;
		_tmp10__length1 = _tmp8__length1;
		_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup1 (_tmp10_, _tmp10__length1) : _tmp10_;
		_tmp11__length1 = _tmp10__length1;
		soup_message_body_append_take (_tmp7_, _tmp11_, (gsize) _tmp11__length1);
	}
	_tmp12_ = self->priv->m_session;
	_tmp13_ = message;
	soup_session_send_message (_tmp12_, _tmp13_);
	_tmp14_ = message;
	g_object_get (_tmp14_, "status-code", &_tmp15_, NULL);
	_tmp16_ = _tmp15_;
	status = _tmp16_;
	if (status < ((guint) 200)) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = status >= ((guint) 400);
	}
	if (_tmp17_) {
		gchar* phrase = NULL;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		GError* _tmp49_;
		GError* _tmp50_;
		switch (status) {
			case SOUP_STATUS_CANT_RESOLVE:
			case SOUP_STATUS_CANT_RESOLVE_PROXY:
			case SOUP_STATUS_CANT_CONNECT:
			case SOUP_STATUS_CANT_CONNECT_PROXY:
			{
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				GError* _tmp22_;
				GError* _tmp23_;
				_tmp18_ = self->priv->m_base_uri;
				_tmp19_ = string_to_string (_tmp18_);
				_tmp20_ = g_strconcat ("Connection to ", _tmp19_, " failed", NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_NO_CONNECTION, _tmp21_);
				_tmp23_ = _tmp22_;
				_g_free0 (_tmp21_);
				_inner_error0_ = _tmp23_;
				if (_inner_error0_->domain == FEEDBIN_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (message);
					_g_free0 (path);
					return NULL;
				} else {
					_g_object_unref0 (message);
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			case SOUP_STATUS_UNAUTHORIZED:
			{
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				GError* _tmp29_;
				GError* _tmp30_;
				_tmp24_ = string_to_string (method);
				_tmp25_ = path;
				_tmp26_ = string_to_string (_tmp25_);
				_tmp27_ = g_strconcat ("Not authorized to ", _tmp24_, " ", _tmp26_, NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_AUTHORIZED, _tmp28_);
				_tmp30_ = _tmp29_;
				_g_free0 (_tmp28_);
				_inner_error0_ = _tmp30_;
				if (_inner_error0_->domain == FEEDBIN_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (message);
					_g_free0 (path);
					return NULL;
				} else {
					_g_object_unref0 (message);
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			case SOUP_STATUS_NOT_FOUND:
			{
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				GError* _tmp36_;
				GError* _tmp37_;
				_tmp31_ = string_to_string (method);
				_tmp32_ = path;
				_tmp33_ = string_to_string (_tmp32_);
				_tmp34_ = g_strconcat (_tmp31_, " ", _tmp33_, " not found", NULL);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_FOUND, _tmp35_);
				_tmp37_ = _tmp36_;
				_g_free0 (_tmp35_);
				_inner_error0_ = _tmp37_;
				if (_inner_error0_->domain == FEEDBIN_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (message);
					_g_free0 (path);
					return NULL;
				} else {
					_g_object_unref0 (message);
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			default:
			break;
		}
		_tmp38_ = soup_status_get_phrase (status);
		_tmp39_ = g_strdup (_tmp38_);
		phrase = _tmp39_;
		_tmp40_ = g_strdup_printf ("%u", status);
		_tmp41_ = _tmp40_;
		_tmp42_ = phrase;
		_tmp43_ = string_to_string (_tmp42_);
		_tmp44_ = string_to_string (method);
		_tmp45_ = path;
		_tmp46_ = string_to_string (_tmp45_);
		_tmp47_ = g_strconcat ("Unexpected status ", _tmp41_, " (", _tmp43_, ") for ", _tmp44_, " ", _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_UNKNOWN_ERROR, _tmp48_);
		_tmp50_ = _tmp49_;
		_g_free0 (_tmp48_);
		_g_free0 (_tmp41_);
		_inner_error0_ = _tmp50_;
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (phrase);
			_g_object_unref0 (message);
			_g_free0 (path);
			return NULL;
		} else {
			_g_free0 (phrase);
			_g_object_unref0 (message);
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (phrase);
	}
	result = message;
	_tmp51_ = result;
	g_object_get (_tmp51_, "status-code", &_tmp52_, NULL);
	_tmp53_ = _tmp52_;
	_vala_warn_if_fail (_tmp53_ >= ((guint) 200), "result.status_code >= 200");
	_tmp54_ = result;
	g_object_get (_tmp54_, "status-code", &_tmp55_, NULL);
	_tmp56_ = _tmp55_;
	_vala_warn_if_fail (_tmp56_ < ((guint) 400), "result.status_code < 400");
	_g_free0 (path);
	return result;
}

static GDateTime*
feedbin_api_string_to_datetime (const gchar* s,
                                GError** error)
{
	GTimeVal time = {0};
	GTimeVal _tmp5_;
	GDateTime* _tmp6_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (s != NULL, NULL);
	g_get_current_time (&time);
	if (!g_time_val_from_iso8601 (s, &time)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp0_ = string_to_string (s);
		_tmp1_ = g_strconcat ("Expected date but got ", _tmp0_, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_INVALID_FORMAT, _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = time;
	_tmp6_ = g_date_time_new_from_timeval_utc (&_tmp5_);
	result = _tmp6_;
	return result;
}

static GDateTime*
feedbin_api_get_datetime_member (JsonObject* obj,
                                 const gchar* name,
                                 GError** error)
{
	gchar* s = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (obj != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_vala_return_val_if_fail (g_strcmp0 (name, "") != 0, "name != \"\"", NULL);
	_tmp0_ = json_object_get_string_member (obj, name);
	_tmp1_ = g_strdup (_tmp0_);
	s = _tmp1_;
	_tmp3_ = feedbin_api_string_to_datetime (s, &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (s);
			return NULL;
		} else {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp4_;
	_g_date_time_unref0 (_tmp2_);
	_g_free0 (s);
	return result;
}

static SoupMessage*
feedbin_api_post_request (FeedbinAPI* self,
                          const gchar* path,
                          const gchar* input,
                          GError** error)
{
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	GError* _inner_error0_ = NULL;
	SoupMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_vala_return_val_if_fail (g_strcmp0 (input, "") != 0, "input != \"\"", NULL);
	_tmp1_ = feedbin_api_request (self, "POST", path, input, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static SoupMessage*
feedbin_api_delete_request (FeedbinAPI* self,
                            const gchar* path,
                            GError** error)
{
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	GError* _inner_error0_ = NULL;
	SoupMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp1_ = feedbin_api_request (self, "DELETE", path, NULL, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static SoupMessage*
feedbin_api_get_request (FeedbinAPI* self,
                         const gchar* path,
                         GError** error)
{
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	GError* _inner_error0_ = NULL;
	SoupMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp1_ = feedbin_api_request (self, "GET", path, NULL, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static JsonNode*
feedbin_api_parse_json (SoupMessage* response,
                        GError** error)
{
	gchar* method = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* uri = NULL;
	SoupURI* _tmp2_;
	SoupURI* _tmp3_;
	gchar* _tmp4_;
	gchar* content = NULL;
	SoupMessageBody* _tmp5_;
	SoupBuffer* _tmp6_;
	SoupBuffer* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	JsonParser* parser = NULL;
	JsonParser* _tmp20_;
	JsonParser* _tmp37_;
	JsonNode* _tmp38_;
	JsonNode* _tmp39_;
	GError* _inner_error0_ = NULL;
	JsonNode* result;
	g_return_val_if_fail (response != NULL, NULL);
	g_object_get (response, "method", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	method = _tmp1_;
	_tmp2_ = soup_message_get_uri (response);
	_tmp3_ = _tmp2_;
	_tmp4_ = soup_uri_to_string (_tmp3_, FALSE);
	uri = _tmp4_;
	_tmp5_ = response->response_body;
	_tmp6_ = soup_message_body_flatten (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->data;
	_tmp8__length1 = _tmp7_->length;
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	_tmp10_ = _tmp9_;
	__vala_SoupBuffer_free0 (_tmp7_);
	content = _tmp10_;
	_tmp11_ = content;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GError* _tmp18_;
		GError* _tmp19_;
		_tmp12_ = method;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = uri;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat (_tmp13_, " ", _tmp15_, " returned no content but expected JSON", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_INVALID_FORMAT, _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_inner_error0_ = _tmp19_;
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (content);
			_g_free0 (uri);
			_g_free0 (method);
			return NULL;
		} else {
			_g_free0 (content);
			_g_free0 (uri);
			_g_free0 (method);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = json_parser_new ();
	parser = _tmp20_;
	{
		JsonParser* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = parser;
		_tmp22_ = content;
		json_parser_load_from_data (_tmp21_, _tmp22_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GError* _tmp35_;
		GError* _tmp36_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = method;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = uri;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = g_strconcat (_tmp24_, " ", _tmp26_, " returned invalid JSON: ", NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "\nContent is: $content", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_INVALID_FORMAT, _tmp34_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp28_);
		_inner_error0_ = _tmp36_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (parser);
			_g_free0 (content);
			_g_free0 (uri);
			_g_free0 (method);
			return NULL;
		} else {
			_g_object_unref0 (parser);
			_g_free0 (content);
			_g_free0 (uri);
			_g_free0 (method);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp37_ = parser;
	_tmp38_ = json_parser_get_root (_tmp37_);
	_tmp39_ = __vala_JsonNode_copy0 (_tmp38_);
	result = _tmp39_;
	_g_object_unref0 (parser);
	_g_free0 (content);
	_g_free0 (uri);
	_g_free0 (method);
	return result;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static JsonNode*
feedbin_api_get_json (FeedbinAPI* self,
                      const gchar* path,
                      GError** error)
{
	SoupMessage* response = NULL;
	SoupMessage* _tmp0_;
	JsonNode* _tmp1_ = NULL;
	SoupMessage* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	GError* _inner_error0_ = NULL;
	JsonNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_vala_return_val_if_fail (g_strcmp0 (path, "") != 0, "path != \"\"", NULL);
	_tmp0_ = feedbin_api_get_request (self, path, &_inner_error0_);
	response = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = response;
	_tmp3_ = feedbin_api_parse_json (_tmp2_, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (response);
			return NULL;
		} else {
			_g_object_unref0 (response);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp4_;
	__vala_JsonNode_free0 (_tmp1_);
	_g_object_unref0 (response);
	return result;
}

static SoupMessage*
feedbin_api_post_json_object (FeedbinAPI* self,
                              const gchar* path,
                              JsonObject* obj,
                              GError** error)
{
	JsonNode* root = NULL;
	JsonNode* _tmp0_;
	JsonGenerator* gen = NULL;
	JsonGenerator* _tmp1_;
	gchar* data = NULL;
	gchar* _tmp2_;
	SoupMessage* _tmp3_ = NULL;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	GError* _inner_error0_ = NULL;
	SoupMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (obj != NULL, NULL);
	_tmp0_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp0_;
	json_node_set_object (root, obj);
	_tmp1_ = json_generator_new ();
	gen = _tmp1_;
	json_generator_set_root (gen, root);
	_tmp2_ = json_generator_to_data (gen, NULL);
	data = _tmp2_;
	_tmp4_ = feedbin_api_post_request (self, path, data, &_inner_error0_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (data);
			_g_object_unref0 (gen);
			__vala_JsonNode_free0 (root);
			return NULL;
		} else {
			_g_free0 (data);
			_g_object_unref0 (gen);
			__vala_JsonNode_free0 (root);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_g_free0 (data);
	_g_object_unref0 (gen);
	__vala_JsonNode_free0 (root);
	return result;
}

gboolean
feedbin_api_login (FeedbinAPI* self,
                   GError** error)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		SoupMessage* res = NULL;
		SoupMessage* _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		_tmp0_ = feedbin_api_get_request (self, "authentication.json", &_inner_error0_);
		res = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_AUTHORIZED)) {
				goto __catch0_feedbin_error_not_authorized;
			}
			goto __finally0;
		}
		g_object_get (res, "status-code", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		result = _tmp2_ == ((guint) SOUP_STATUS_OK);
		_g_object_unref0 (res);
		return result;
	}
	goto __finally0;
	__catch0_feedbin_error_not_authorized:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (_inner_error0_->domain == FEEDBIN_ERROR) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	} else {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

void
feedbin_api_get_subscription (FeedbinAPI* self,
                              gint64 subscription_id,
                              FeedbinAPISubscription* result,
                              GError** error)
{
	JsonNode* root = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* _tmp5_;
	FeedbinAPISubscription _tmp6_ = {0};
	JsonNode* _tmp7_;
	JsonObject* _tmp8_;
	FeedbinAPISubscription _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, subscription_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("subscriptions/", _tmp1_, ".json", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = feedbin_api_get_json (self, _tmp3_, &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	root = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = root;
	_tmp8_ = json_node_get_object (_tmp7_);
	feedbin_api_subscription_init_from_json (&_tmp6_, _tmp8_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			__vala_JsonNode_free0 (root);
			return;
		} else {
			__vala_JsonNode_free0 (root);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = _tmp6_;
	memset (&_tmp6_, 0, sizeof (FeedbinAPISubscription));
	*result = _tmp9_;
	feedbin_api_subscription_destroy (&_tmp6_);
	__vala_JsonNode_free0 (root);
	return;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

GeeList*
feedbin_api_get_subscriptions (FeedbinAPI* self,
                               GError** error)
{
	JsonNode* root = NULL;
	JsonNode* _tmp0_;
	GeeArrayList* subscriptions = NULL;
	GeeArrayList* _tmp1_;
	JsonArray* array = NULL;
	JsonNode* _tmp2_;
	JsonArray* _tmp3_;
	JsonArray* _tmp4_;
	GeeList* _tmp14_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = feedbin_api_get_json (self, "subscriptions.json", &_inner_error0_);
	root = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = gee_array_list_new (FEEDBIN_API_TYPE_SUBSCRIPTION, (GBoxedCopyFunc) feedbin_api_subscription_dup, (GDestroyNotify) feedbin_api_subscription_free, NULL, NULL, NULL);
	subscriptions = _tmp1_;
	_tmp2_ = root;
	_tmp3_ = json_node_get_array (_tmp2_);
	_tmp4_ = _json_array_ref0 (_tmp3_);
	array = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp7_;
				JsonObject* node = NULL;
				JsonArray* _tmp8_;
				JsonObject* _tmp9_;
				JsonObject* _tmp10_;
				FeedbinAPISubscription _tmp11_ = {0};
				JsonObject* _tmp12_;
				GeeArrayList* _tmp13_;
				if (!_tmp5_) {
					gint _tmp6_;
					i = i + 1;
					_tmp6_ = i;
				}
				_tmp5_ = FALSE;
				_tmp7_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp7_))) {
					break;
				}
				_tmp8_ = array;
				_tmp9_ = json_array_get_object_element (_tmp8_, (guint) i);
				_tmp10_ = _json_object_ref0 (_tmp9_);
				node = _tmp10_;
				_tmp12_ = node;
				feedbin_api_subscription_init_from_json (&_tmp11_, _tmp12_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == FEEDBIN_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_json_object_unref0 (node);
						_json_array_unref0 (array);
						_g_object_unref0 (subscriptions);
						__vala_JsonNode_free0 (root);
						return NULL;
					} else {
						_json_object_unref0 (node);
						_json_array_unref0 (array);
						_g_object_unref0 (subscriptions);
						__vala_JsonNode_free0 (root);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp13_ = subscriptions;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, &_tmp11_);
				feedbin_api_subscription_destroy (&_tmp11_);
				_json_object_unref0 (node);
			}
		}
	}
	result = (GeeList*) subscriptions;
	_tmp14_ = result;
	_vala_warn_if_fail (!gee_collection_contains ((GeeCollection*) _tmp14_, NULL), "!result.contains(null)");
	_json_array_unref0 (array);
	__vala_JsonNode_free0 (root);
	return result;
}

void
feedbin_api_delete_subscription (FeedbinAPI* self,
                                 gint64 subscription_id,
                                 GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, subscription_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("subscriptions/", _tmp1_, ".json", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = feedbin_api_delete_request (self, _tmp3_, &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gpointer
_feedbin_api_subscription_dup0 (gpointer self)
{
	return self ? feedbin_api_subscription_dup (self) : NULL;
}

FeedbinAPISubscription*
feedbin_api_add_subscription (FeedbinAPI* self,
                              const gchar* url,
                              GError** error)
{
	JsonObject* object = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	GError* _inner_error0_ = NULL;
	FeedbinAPISubscription* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = json_object_new ();
	object = _tmp0_;
	_tmp1_ = object;
	json_object_set_string_member (_tmp1_, "feed_url", url);
	{
		SoupMessage* response = NULL;
		JsonObject* _tmp2_;
		SoupMessage* _tmp3_;
		SoupMessage* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		JsonNode* root = NULL;
		SoupMessage* _tmp8_;
		JsonNode* _tmp9_;
		FeedbinAPISubscription _tmp10_ = {0};
		JsonNode* _tmp11_;
		JsonObject* _tmp12_;
		FeedbinAPISubscription _tmp13_;
		FeedbinAPISubscription _tmp14_;
		FeedbinAPISubscription* _tmp15_;
		FeedbinAPISubscription* _tmp16_;
		_tmp2_ = object;
		_tmp3_ = feedbin_api_post_json_object (self, "subscriptions.json", _tmp2_, &_inner_error0_);
		response = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_FOUND)) {
				goto __catch0_feedbin_error_not_found;
			}
			goto __finally0;
		}
		_tmp4_ = response;
		g_object_get (_tmp4_, "status-code", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == ((guint) 300)) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (FEEDBIN_ERROR, FEEDBIN_ERROR_MULTIPLE_CHOICES, "Site $url has multiple feeds to subscribe to");
			_inner_error0_ = _tmp7_;
			_g_object_unref0 (response);
			if (g_error_matches (_inner_error0_, FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_FOUND)) {
				goto __catch0_feedbin_error_not_found;
			}
			goto __finally0;
		}
		_tmp8_ = response;
		_tmp9_ = feedbin_api_parse_json (_tmp8_, &_inner_error0_);
		root = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (response);
			if (g_error_matches (_inner_error0_, FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_FOUND)) {
				goto __catch0_feedbin_error_not_found;
			}
			goto __finally0;
		}
		_tmp11_ = root;
		_tmp12_ = json_node_get_object (_tmp11_);
		feedbin_api_subscription_init_from_json (&_tmp10_, _tmp12_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (response);
			if (g_error_matches (_inner_error0_, FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_FOUND)) {
				goto __catch0_feedbin_error_not_found;
			}
			goto __finally0;
		}
		_tmp13_ = _tmp10_;
		memset (&_tmp10_, 0, sizeof (FeedbinAPISubscription));
		_tmp14_ = _tmp13_;
		_tmp15_ = _feedbin_api_subscription_dup0 (&_tmp14_);
		_tmp16_ = _tmp15_;
		feedbin_api_subscription_destroy (&_tmp14_);
		result = _tmp16_;
		feedbin_api_subscription_destroy (&_tmp10_);
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (response);
		_json_object_unref0 (object);
		return result;
	}
	goto __finally0;
	__catch0_feedbin_error_not_found:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_json_object_unref0 (object);
		return result;
	}
	__finally0:
	if (_inner_error0_->domain == FEEDBIN_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_json_object_unref0 (object);
		return NULL;
	} else {
		_json_object_unref0 (object);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

void
feedbin_api_rename_subscription (FeedbinAPI* self,
                                 gint64 subscription_id,
                                 const gchar* title,
                                 GError** error)
{
	JsonObject* object = NULL;
	JsonObject* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = json_object_new ();
	object = _tmp0_;
	json_object_set_string_member (object, "title", title);
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, subscription_id);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("subscriptions/", _tmp2_, "/update.json", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = feedbin_api_post_json_object (self, _tmp4_, object, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_json_object_unref0 (object);
			return;
		} else {
			_json_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_json_object_unref0 (object);
}

void
feedbin_api_add_tagging (FeedbinAPI* self,
                         gint64 feed_id,
                         const gchar* tag_name,
                         GError** error)
{
	JsonObject* object = NULL;
	JsonObject* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = json_object_new ();
	object = _tmp0_;
	json_object_set_int_member (object, "feed_id", feed_id);
	json_object_set_string_member (object, "name", tag_name);
	_tmp1_ = feedbin_api_post_json_object (self, "taggings.json", object, &_inner_error0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_json_object_unref0 (object);
			return;
		} else {
			_json_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_json_object_unref0 (object);
}

void
feedbin_api_delete_tagging (FeedbinAPI* self,
                            gint64 tagging_id,
                            GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, tagging_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("taggings/", _tmp1_, ".json", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = feedbin_api_delete_request (self, _tmp3_, &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

GeeList*
feedbin_api_get_taggings (FeedbinAPI* self,
                          GError** error)
{
	JsonNode* root = NULL;
	JsonNode* _tmp0_;
	GeeArrayList* taggings = NULL;
	GeeArrayList* _tmp1_;
	JsonArray* array = NULL;
	JsonArray* _tmp2_;
	JsonArray* _tmp3_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = feedbin_api_get_json (self, "taggings.json", &_inner_error0_);
	root = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = gee_array_list_new (FEEDBIN_API_TYPE_TAGGING, (GBoxedCopyFunc) feedbin_api_tagging_dup, (GDestroyNotify) feedbin_api_tagging_free, NULL, NULL, NULL);
	taggings = _tmp1_;
	_tmp2_ = json_node_get_array (root);
	_tmp3_ = _json_array_ref0 (_tmp2_);
	array = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp6_;
				JsonObject* object = NULL;
				JsonArray* _tmp7_;
				JsonObject* _tmp8_;
				JsonObject* _tmp9_;
				GeeArrayList* _tmp10_;
				JsonObject* _tmp11_;
				FeedbinAPITagging _tmp12_ = {0};
				FeedbinAPITagging _tmp13_;
				FeedbinAPITagging _tmp14_;
				if (!_tmp4_) {
					gint _tmp5_;
					i = i + 1;
					_tmp5_ = i;
				}
				_tmp4_ = FALSE;
				_tmp6_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp6_))) {
					break;
				}
				_tmp7_ = array;
				_tmp8_ = json_array_get_object_element (_tmp7_, (guint) i);
				_tmp9_ = _json_object_ref0 (_tmp8_);
				object = _tmp9_;
				_tmp10_ = taggings;
				_tmp11_ = object;
				feedbin_api_tagging_init_from_json (&_tmp12_, _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, &_tmp14_);
				feedbin_api_tagging_destroy (&_tmp13_);
				_json_object_unref0 (object);
			}
		}
	}
	result = (GeeList*) taggings;
	_vala_warn_if_fail (!gee_collection_contains ((GeeCollection*) result, NULL), "!result.contains(null)");
	_json_array_unref0 (array);
	__vala_JsonNode_free0 (root);
	return result;
}

GeeList*
feedbin_api_get_entries (FeedbinAPI* self,
                         gint page,
                         gboolean only_starred,
                         GDateTime* since,
                         gint64* feed_id,
                         GError** error)
{
	const gchar* _tmp0_ = NULL;
	gchar* starred = NULL;
	gchar* _tmp1_;
	gchar* path = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	JsonNode* root = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp27_;
	JsonArray* array = NULL;
	JsonNode* _tmp28_;
	JsonArray* _tmp29_;
	JsonArray* _tmp30_;
	GeeList* _tmp40_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (page >= 0, "page >= 0", NULL);
	if (only_starred) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp1_ = g_strdup (_tmp0_);
	starred = _tmp1_;
	_tmp2_ = g_strdup_printf ("%i", page);
	_tmp3_ = _tmp2_;
	_tmp4_ = starred;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("entries.json?per_page=100&page=", _tmp3_, "&starred=", _tmp5_, "&include_enclosure=true", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	path = _tmp7_;
	if (since != NULL) {
		GTimeVal t = {0};
		GTimeVal _tmp8_ = {0};
		gboolean _tmp9_;
		g_get_current_time (&t);
		_tmp9_ = g_date_time_to_timeval (since, &_tmp8_);
		t = _tmp8_;
		if (_tmp9_) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = path;
			_tmp11_ = g_time_val_to_iso8601 (&t);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("&since=", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp10_, _tmp14_, NULL);
			_g_free0 (path);
			path = _tmp15_;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
		}
	}
	if (feed_id != NULL) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, *feed_id);
		_tmp17_ = _tmp16_;
		_tmp18_ = path;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("feeds/", _tmp17_, "/", _tmp19_, NULL);
		_g_free0 (path);
		path = _tmp20_;
		_g_free0 (_tmp17_);
	}
	{
		JsonNode* _tmp21_ = NULL;
		const gchar* _tmp22_;
		JsonNode* _tmp23_;
		JsonNode* _tmp24_;
		_tmp22_ = path;
		_tmp23_ = feedbin_api_get_json (self, _tmp22_, &_inner_error0_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, FEEDBIN_ERROR, FEEDBIN_ERROR_NOT_FOUND)) {
				goto __catch0_feedbin_error_not_found;
			}
			goto __finally0;
		}
		_tmp24_ = _tmp21_;
		_tmp21_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp24_;
		__vala_JsonNode_free0 (_tmp21_);
	}
	goto __finally0;
	__catch0_feedbin_error_not_found:
	{
		GeeList* _tmp25_;
		GeeList* _tmp26_;
		g_clear_error (&_inner_error0_);
		_tmp25_ = gee_list_empty (FEEDBIN_API_TYPE_ENTRY, (GBoxedCopyFunc) feedbin_api_entry_dup, (GDestroyNotify) feedbin_api_entry_free);
		result = _tmp25_;
		_tmp26_ = result;
		_vala_warn_if_fail (!gee_collection_contains ((GeeCollection*) _tmp26_, NULL), "!result.contains(null)");
		__vala_JsonNode_free0 (root);
		_g_free0 (path);
		_g_free0 (starred);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			__vala_JsonNode_free0 (root);
			_g_free0 (path);
			_g_free0 (starred);
			return NULL;
		} else {
			__vala_JsonNode_free0 (root);
			_g_free0 (path);
			_g_free0 (starred);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp27_ = gee_array_list_new (FEEDBIN_API_TYPE_ENTRY, (GBoxedCopyFunc) feedbin_api_entry_dup, (GDestroyNotify) feedbin_api_entry_free, NULL, NULL, NULL);
	entries = _tmp27_;
	_tmp28_ = root;
	_tmp29_ = json_node_get_array (_tmp28_);
	_tmp30_ = _json_array_ref0 (_tmp29_);
	array = _tmp30_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp33_;
				JsonObject* object = NULL;
				JsonArray* _tmp34_;
				JsonObject* _tmp35_;
				JsonObject* _tmp36_;
				FeedbinAPIEntry _tmp37_ = {0};
				JsonObject* _tmp38_;
				GeeArrayList* _tmp39_;
				if (!_tmp31_) {
					gint _tmp32_;
					i = i + 1;
					_tmp32_ = i;
				}
				_tmp31_ = FALSE;
				_tmp33_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp33_))) {
					break;
				}
				_tmp34_ = array;
				_tmp35_ = json_array_get_object_element (_tmp34_, (guint) i);
				_tmp36_ = _json_object_ref0 (_tmp35_);
				object = _tmp36_;
				_tmp38_ = object;
				feedbin_api_entry_init_from_json (&_tmp37_, _tmp38_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == FEEDBIN_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_json_object_unref0 (object);
						_json_array_unref0 (array);
						_g_object_unref0 (entries);
						__vala_JsonNode_free0 (root);
						_g_free0 (path);
						_g_free0 (starred);
						return NULL;
					} else {
						_json_object_unref0 (object);
						_json_array_unref0 (array);
						_g_object_unref0 (entries);
						__vala_JsonNode_free0 (root);
						_g_free0 (path);
						_g_free0 (starred);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp39_ = entries;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, &_tmp37_);
				feedbin_api_entry_destroy (&_tmp37_);
				_json_object_unref0 (object);
			}
		}
	}
	result = (GeeList*) entries;
	_tmp40_ = result;
	_vala_warn_if_fail (!gee_collection_contains ((GeeCollection*) _tmp40_, NULL), "!result.contains(null)");
	_json_array_unref0 (array);
	__vala_JsonNode_free0 (root);
	_g_free0 (path);
	_g_free0 (starred);
	return result;
}

static guint
__lambda4_ (FeedbinAPI* self,
            gint64* n)
{
	GHashFunc _tmp0_;
	guint result;
	_tmp0_ = g_int64_hash;
	result = _tmp0_ (n);
	return result;
}

static guint
___lambda4__gee_hash_data_func (gconstpointer v,
                                gpointer self)
{
	guint result;
	result = __lambda4_ ((FeedbinAPI*) self, (gint64*) v);
	return result;
}

static gboolean
__lambda5_ (FeedbinAPI* self,
            gint64* a,
            gint64* b)
{
	GEqualFunc _tmp0_;
	gboolean result;
	_tmp0_ = g_int64_equal;
	result = _tmp0_ (a, b);
	return result;
}

static gboolean
___lambda5__gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = __lambda5_ ((FeedbinAPI*) self, (gint64*) a, (gint64*) b);
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static GeeSet*
feedbin_api_get_x_entries (FeedbinAPI* self,
                           const gchar* path,
                           GError** error)
{
	JsonNode* root = NULL;
	JsonNode* _tmp0_;
	JsonArray* array = NULL;
	JsonArray* _tmp1_;
	JsonArray* _tmp2_;
	GeeHashSet* ids = NULL;
	GeeHashSet* _tmp3_;
	GError* _inner_error0_ = NULL;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = feedbin_api_get_json (self, path, &_inner_error0_);
	root = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = json_node_get_array (root);
	_tmp2_ = _json_array_ref0 (_tmp1_);
	array = _tmp2_;
	_tmp3_ = gee_hash_set_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, ___lambda4__gee_hash_data_func, g_object_ref (self), g_object_unref, ___lambda5__gee_equal_data_func, g_object_ref (self), g_object_unref);
	ids = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp6_;
				GeeHashSet* _tmp7_;
				JsonArray* _tmp8_;
				gint64 _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					i = i + 1;
					_tmp5_ = i;
				}
				_tmp4_ = FALSE;
				_tmp6_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp6_))) {
					break;
				}
				_tmp7_ = ids;
				_tmp8_ = array;
				_tmp9_ = json_array_get_int_element (_tmp8_, (guint) i);
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, &_tmp9_);
			}
		}
	}
	result = (GeeSet*) ids;
	_json_array_unref0 (array);
	__vala_JsonNode_free0 (root);
	return result;
}

GeeSet*
feedbin_api_get_unread_entries (FeedbinAPI* self,
                                GError** error)
{
	GeeSet* _tmp0_ = NULL;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GError* _inner_error0_ = NULL;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = feedbin_api_get_x_entries (self, "unread_entries.json", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GeeSet*
feedbin_api_get_starred_entries (FeedbinAPI* self,
                                 GError** error)
{
	GeeSet* _tmp0_ = NULL;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GError* _inner_error0_ = NULL;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = feedbin_api_get_x_entries (self, "starred_entries.json", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
feedbin_api_set_entries_status (FeedbinAPI* self,
                                const gchar* type,
                                GeeCollection* entry_ids,
                                gboolean create,
                                GError** error)
{
	JsonArray* array = NULL;
	JsonArray* _tmp0_;
	JsonObject* object = NULL;
	JsonObject* _tmp7_;
	JsonObject* _tmp8_;
	JsonArray* _tmp9_;
	JsonArray* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* path = NULL;
	gchar* _tmp16_;
	JsonObject* _tmp17_;
	SoupMessage* _tmp18_;
	SoupMessage* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (entry_ids != NULL);
	_vala_return_if_fail (!gee_collection_contains (entry_ids, NULL), "!entry_ids.contains(null)");
	_tmp0_ = json_array_new ();
	array = _tmp0_;
	{
		GeeIterator* _id_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) entry_ids);
		_id_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gint64* id = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			JsonArray* _tmp5_;
			gint64* _tmp6_;
			_tmp2_ = _id_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _id_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			id = (gint64*) _tmp4_;
			_tmp5_ = array;
			_tmp6_ = id;
			json_array_add_int_element (_tmp5_, *_tmp6_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp7_ = json_object_new ();
	object = _tmp7_;
	_tmp8_ = object;
	_tmp9_ = array;
	_tmp10_ = _json_array_ref0 (_tmp9_);
	json_object_set_array_member (_tmp8_, type, _tmp10_);
	if (create) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = string_to_string (type);
		_tmp13_ = g_strconcat (_tmp12_, ".json", NULL);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp13_;
	} else {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = string_to_string (type);
		_tmp15_ = g_strconcat (_tmp14_, "/delete.json", NULL);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp15_;
	}
	_tmp16_ = g_strdup (_tmp11_);
	path = _tmp16_;
	_tmp17_ = object;
	_tmp18_ = feedbin_api_post_json_object (self, path, _tmp17_, &_inner_error0_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp19_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (path);
			_g_free0 (_tmp11_);
			_json_object_unref0 (object);
			_json_array_unref0 (array);
			return;
		} else {
			_g_free0 (path);
			_g_free0 (_tmp11_);
			_json_object_unref0 (object);
			_json_array_unref0 (array);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (path);
	_g_free0 (_tmp11_);
	_json_object_unref0 (object);
	_json_array_unref0 (array);
}

void
feedbin_api_set_entries_read (FeedbinAPI* self,
                              GeeCollection* entry_ids,
                              gboolean read,
                              GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_ids != NULL);
	_vala_return_if_fail (!gee_collection_contains (entry_ids, NULL), "!entry_ids.contains(null)");
	feedbin_api_set_entries_status (self, "unread_entries", entry_ids, !read, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
feedbin_api_set_entries_starred (FeedbinAPI* self,
                                 GeeCollection* entry_ids,
                                 gboolean starred,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_ids != NULL);
	_vala_return_if_fail (!gee_collection_contains (entry_ids, NULL), "!entry_ids.contains(null)");
	feedbin_api_set_entries_status (self, "starred_entries", entry_ids, starred, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

GeeMap*
feedbin_api_get_favicons (FeedbinAPI* self,
                          GError** error)
{
	GError* _inner_error0_ = NULL;
	GeeMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		JsonNode* root = NULL;
		JsonNode* _tmp0_;
		JsonNode* _tmp1_;
		JsonArray* array = NULL;
		JsonNode* _tmp3_;
		JsonArray* _tmp4_;
		JsonArray* _tmp5_;
		JsonArray* _tmp6_;
		GeeHashMap* favicons = NULL;
		GeeHashMap* _tmp8_;
		_tmp0_ = feedbin_api_get_json (self, "favicons.json", &_inner_error0_);
		root = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = root;
		if (_tmp1_ == NULL) {
			GeeMap* _tmp2_;
			_tmp2_ = gee_map_empty (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_BYTES, (GBoxedCopyFunc) g_bytes_ref, (GDestroyNotify) g_bytes_unref);
			result = _tmp2_;
			__vala_JsonNode_free0 (root);
			return result;
		}
		_tmp3_ = root;
		_tmp4_ = json_node_get_array (_tmp3_);
		_tmp5_ = _json_array_ref0 (_tmp4_);
		array = _tmp5_;
		_tmp6_ = array;
		if (_tmp6_ == NULL) {
			GeeMap* _tmp7_;
			_tmp7_ = gee_map_empty (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_BYTES, (GBoxedCopyFunc) g_bytes_ref, (GDestroyNotify) g_bytes_unref);
			result = _tmp7_;
			_json_array_unref0 (array);
			__vala_JsonNode_free0 (root);
			return result;
		}
		_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_BYTES, (GBoxedCopyFunc) g_bytes_ref, (GDestroyNotify) g_bytes_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		favicons = _tmp8_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					JsonArray* _tmp11_;
					JsonObject* obj = NULL;
					JsonArray* _tmp12_;
					JsonObject* _tmp13_;
					JsonObject* _tmp14_;
					gchar* host = NULL;
					JsonObject* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					const gchar* _tmp18_;
					gchar* favicon_encoded = NULL;
					JsonObject* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					const gchar* _tmp22_;
					GBytes* favicon = NULL;
					const gchar* _tmp23_;
					gsize _tmp24_ = 0;
					guchar* _tmp25_;
					GBytes* _tmp26_;
					GeeHashMap* _tmp27_;
					const gchar* _tmp28_;
					GBytes* _tmp29_;
					if (!_tmp9_) {
						gint _tmp10_;
						i = i + 1;
						_tmp10_ = i;
					}
					_tmp9_ = FALSE;
					_tmp11_ = array;
					if (!(((guint) i) < json_array_get_length (_tmp11_))) {
						break;
					}
					_tmp12_ = array;
					_tmp13_ = json_array_get_object_element (_tmp12_, (guint) i);
					_tmp14_ = _json_object_ref0 (_tmp13_);
					obj = _tmp14_;
					_tmp15_ = obj;
					_tmp16_ = json_object_get_string_member (_tmp15_, "host");
					_tmp17_ = g_strdup (_tmp16_);
					host = _tmp17_;
					_tmp18_ = host;
					if (_tmp18_ == NULL) {
						_g_free0 (host);
						_json_object_unref0 (obj);
						continue;
					}
					_tmp19_ = obj;
					_tmp20_ = json_object_get_string_member (_tmp19_, "favicon");
					_tmp21_ = g_strdup (_tmp20_);
					favicon_encoded = _tmp21_;
					_tmp22_ = favicon_encoded;
					if (_tmp22_ == NULL) {
						_g_free0 (favicon_encoded);
						_g_free0 (host);
						_json_object_unref0 (obj);
						continue;
					}
					_tmp23_ = favicon_encoded;
					_tmp25_ = g_base64_decode (_tmp23_, &_tmp24_);
					_tmp26_ = g_bytes_new_take (_tmp25_, _tmp24_);
					favicon = _tmp26_;
					_tmp27_ = favicons;
					_tmp28_ = host;
					_tmp29_ = favicon;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp29_);
					_g_bytes_unref0 (favicon);
					_g_free0 (favicon_encoded);
					_g_free0 (host);
					_json_object_unref0 (obj);
				}
			}
		}
		result = (GeeMap*) favicons;
		_json_array_unref0 (array);
		__vala_JsonNode_free0 (root);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GeeMap* _tmp30_;
		g_clear_error (&_inner_error0_);
		_tmp30_ = gee_map_empty (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_BYTES, (GBoxedCopyFunc) g_bytes_ref, (GDestroyNotify) g_bytes_unref);
		result = _tmp30_;
		return result;
	}
	__finally0:
	if (_inner_error0_->domain == FEEDBIN_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

const gchar*
feedbin_api_get_username (FeedbinAPI* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_username;
	result = _tmp0_;
	return result;
}

void
feedbin_api_set_username (FeedbinAPI* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = feedbin_api_get_username (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_username);
		self->priv->_username = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, feedbin_api_properties[FEEDBIN_API_USERNAME_PROPERTY]);
	}
}

const gchar*
feedbin_api_get_password (FeedbinAPI* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_password;
	result = _tmp0_;
	return result;
}

void
feedbin_api_set_password (FeedbinAPI* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = feedbin_api_get_password (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_password);
		self->priv->_password = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, feedbin_api_properties[FEEDBIN_API_PASSWORD_PROPERTY]);
	}
}

void
feedbin_api_subscription_init_from_json (FeedbinAPISubscription *self,
                                         JsonObject* object,
                                         GError** error)
{
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (object != NULL);
	memset (self, 0, sizeof (FeedbinAPISubscription));
	(*self).id = json_object_get_int_member (object, "id");
	_tmp1_ = feedbin_api_get_datetime_member (object, "created_at", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_date_time_unref0 ((*self).created_at);
	(*self).created_at = _tmp2_;
	(*self).feed_id = json_object_get_int_member (object, "feed_id");
	_tmp3_ = json_object_get_string_member (object, "title");
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*self).title);
	(*self).title = _tmp4_;
	_tmp5_ = json_object_get_string_member (object, "feed_url");
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*self).feed_url);
	(*self).feed_url = _tmp6_;
	_tmp7_ = json_object_get_string_member (object, "site_url");
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*self).site_url);
	(*self).site_url = _tmp8_;
	_g_date_time_unref0 (_tmp0_);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
feedbin_api_subscription_copy (const FeedbinAPISubscription* self,
                               FeedbinAPISubscription* dest)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	(*dest).id = (*self).id;
	_tmp0_ = (*self).created_at;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	_g_date_time_unref0 ((*dest).created_at);
	(*dest).created_at = _tmp1_;
	(*dest).feed_id = (*self).feed_id;
	_tmp2_ = (*self).title;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp3_;
	_tmp4_ = (*self).feed_url;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).feed_url);
	(*dest).feed_url = _tmp5_;
	_tmp6_ = (*self).site_url;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).site_url);
	(*dest).site_url = _tmp7_;
}

void
feedbin_api_subscription_destroy (FeedbinAPISubscription* self)
{
	_g_date_time_unref0 ((*self).created_at);
	_g_free0 ((*self).title);
	_g_free0 ((*self).feed_url);
	_g_free0 ((*self).site_url);
}

FeedbinAPISubscription*
feedbin_api_subscription_dup (const FeedbinAPISubscription* self)
{
	FeedbinAPISubscription* dup;
	dup = g_new0 (FeedbinAPISubscription, 1);
	feedbin_api_subscription_copy (self, dup);
	return dup;
}

void
feedbin_api_subscription_free (FeedbinAPISubscription* self)
{
	feedbin_api_subscription_destroy (self);
	g_free (self);
}

static GType
feedbin_api_subscription_get_type_once (void)
{
	GType feedbin_api_subscription_type_id;
	feedbin_api_subscription_type_id = g_boxed_type_register_static ("FeedbinAPISubscription", (GBoxedCopyFunc) feedbin_api_subscription_dup, (GBoxedFreeFunc) feedbin_api_subscription_free);
	return feedbin_api_subscription_type_id;
}

GType
feedbin_api_subscription_get_type (void)
{
	static volatile gsize feedbin_api_subscription_type_id__once = 0;
	if (g_once_init_enter (&feedbin_api_subscription_type_id__once)) {
		GType feedbin_api_subscription_type_id;
		feedbin_api_subscription_type_id = feedbin_api_subscription_get_type_once ();
		g_once_init_leave (&feedbin_api_subscription_type_id__once, feedbin_api_subscription_type_id);
	}
	return feedbin_api_subscription_type_id__once;
}

void
feedbin_api_tagging_init_from_json (FeedbinAPITagging *self,
                                    JsonObject* object)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (object != NULL);
	memset (self, 0, sizeof (FeedbinAPITagging));
	(*self).id = json_object_get_int_member (object, "id");
	(*self).feed_id = json_object_get_int_member (object, "feed_id");
	_tmp0_ = json_object_get_string_member (object, "name");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).name);
	(*self).name = _tmp1_;
}

void
feedbin_api_tagging_copy (const FeedbinAPITagging* self,
                          FeedbinAPITagging* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	(*dest).id = (*self).id;
	(*dest).feed_id = (*self).feed_id;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
}

void
feedbin_api_tagging_destroy (FeedbinAPITagging* self)
{
	_g_free0 ((*self).name);
}

FeedbinAPITagging*
feedbin_api_tagging_dup (const FeedbinAPITagging* self)
{
	FeedbinAPITagging* dup;
	dup = g_new0 (FeedbinAPITagging, 1);
	feedbin_api_tagging_copy (self, dup);
	return dup;
}

void
feedbin_api_tagging_free (FeedbinAPITagging* self)
{
	feedbin_api_tagging_destroy (self);
	g_free (self);
}

static GType
feedbin_api_tagging_get_type_once (void)
{
	GType feedbin_api_tagging_type_id;
	feedbin_api_tagging_type_id = g_boxed_type_register_static ("FeedbinAPITagging", (GBoxedCopyFunc) feedbin_api_tagging_dup, (GBoxedFreeFunc) feedbin_api_tagging_free);
	return feedbin_api_tagging_type_id;
}

GType
feedbin_api_tagging_get_type (void)
{
	static volatile gsize feedbin_api_tagging_type_id__once = 0;
	if (g_once_init_enter (&feedbin_api_tagging_type_id__once)) {
		GType feedbin_api_tagging_type_id;
		feedbin_api_tagging_type_id = feedbin_api_tagging_get_type_once ();
		g_once_init_leave (&feedbin_api_tagging_type_id__once, feedbin_api_tagging_type_id);
	}
	return feedbin_api_tagging_type_id__once;
}

void
feedbin_api_entry_init_from_json (FeedbinAPIEntry *self,
                                  JsonObject* object,
                                  GError** error)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GDateTime* _tmp10_ = NULL;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_ = NULL;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (object != NULL);
	memset (self, 0, sizeof (FeedbinAPIEntry));
	(*self).id = json_object_get_int_member (object, "id");
	(*self).feed_id = json_object_get_int_member (object, "feed_id");
	_tmp0_ = json_object_get_string_member (object, "title");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).title);
	(*self).title = _tmp1_;
	_tmp2_ = json_object_get_string_member (object, "url");
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*self).url);
	(*self).url = _tmp3_;
	_tmp4_ = json_object_get_string_member (object, "author");
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*self).author);
	(*self).author = _tmp5_;
	_tmp6_ = json_object_get_string_member (object, "content");
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*self).content);
	(*self).content = _tmp7_;
	_tmp8_ = json_object_get_string_member (object, "summary");
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*self).summary);
	(*self).summary = _tmp9_;
	_tmp11_ = feedbin_api_get_datetime_member (object, "published", &_inner_error0_);
	_tmp10_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = _tmp10_;
	_tmp10_ = NULL;
	_g_date_time_unref0 ((*self).published);
	(*self).published = _tmp12_;
	_tmp14_ = feedbin_api_get_datetime_member (object, "created_at", &_inner_error0_);
	_tmp13_ = _tmp14_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == FEEDBIN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_date_time_unref0 (_tmp10_);
			return;
		} else {
			_g_date_time_unref0 (_tmp10_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp15_ = _tmp13_;
	_tmp13_ = NULL;
	_g_date_time_unref0 ((*self).created_at);
	(*self).created_at = _tmp15_;
	_g_date_time_unref0 (_tmp13_);
	_g_date_time_unref0 (_tmp10_);
}

void
feedbin_api_entry_copy (const FeedbinAPIEntry* self,
                        FeedbinAPIEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	(*dest).id = (*self).id;
	(*dest).feed_id = (*self).feed_id;
	_tmp0_ = (*self).title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp1_;
	_tmp2_ = (*self).url;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).url);
	(*dest).url = _tmp3_;
	_tmp4_ = (*self).author;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).author);
	(*dest).author = _tmp5_;
	_tmp6_ = (*self).content;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).content);
	(*dest).content = _tmp7_;
	_tmp8_ = (*self).summary;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).summary);
	(*dest).summary = _tmp9_;
	_tmp10_ = (*self).published;
	_tmp11_ = _g_date_time_ref0 (_tmp10_);
	_g_date_time_unref0 ((*dest).published);
	(*dest).published = _tmp11_;
	_tmp12_ = (*self).created_at;
	_tmp13_ = _g_date_time_ref0 (_tmp12_);
	_g_date_time_unref0 ((*dest).created_at);
	(*dest).created_at = _tmp13_;
}

void
feedbin_api_entry_destroy (FeedbinAPIEntry* self)
{
	_g_free0 ((*self).title);
	_g_free0 ((*self).url);
	_g_free0 ((*self).author);
	_g_free0 ((*self).content);
	_g_free0 ((*self).summary);
	_g_date_time_unref0 ((*self).published);
	_g_date_time_unref0 ((*self).created_at);
}

FeedbinAPIEntry*
feedbin_api_entry_dup (const FeedbinAPIEntry* self)
{
	FeedbinAPIEntry* dup;
	dup = g_new0 (FeedbinAPIEntry, 1);
	feedbin_api_entry_copy (self, dup);
	return dup;
}

void
feedbin_api_entry_free (FeedbinAPIEntry* self)
{
	feedbin_api_entry_destroy (self);
	g_free (self);
}

static GType
feedbin_api_entry_get_type_once (void)
{
	GType feedbin_api_entry_type_id;
	feedbin_api_entry_type_id = g_boxed_type_register_static ("FeedbinAPIEntry", (GBoxedCopyFunc) feedbin_api_entry_dup, (GBoxedFreeFunc) feedbin_api_entry_free);
	return feedbin_api_entry_type_id;
}

GType
feedbin_api_entry_get_type (void)
{
	static volatile gsize feedbin_api_entry_type_id__once = 0;
	if (g_once_init_enter (&feedbin_api_entry_type_id__once)) {
		GType feedbin_api_entry_type_id;
		feedbin_api_entry_type_id = feedbin_api_entry_get_type_once ();
		g_once_init_leave (&feedbin_api_entry_type_id__once, feedbin_api_entry_type_id);
	}
	return feedbin_api_entry_type_id__once;
}

static void
feedbin_api_class_init (FeedbinAPIClass * klass,
                        gpointer klass_data)
{
	feedbin_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedbinAPI_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_feedbin_api_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_feedbin_api_set_property;
	G_OBJECT_CLASS (klass)->finalize = feedbin_api_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FEEDBIN_API_USERNAME_PROPERTY, feedbin_api_properties[FEEDBIN_API_USERNAME_PROPERTY] = g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FEEDBIN_API_PASSWORD_PROPERTY, feedbin_api_properties[FEEDBIN_API_PASSWORD_PROPERTY] = g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
feedbin_api_instance_init (FeedbinAPI * self,
                           gpointer klass)
{
	self->priv = feedbin_api_get_instance_private (self);
}

static void
feedbin_api_finalize (GObject * obj)
{
	FeedbinAPI * self;
	SoupSession* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FEEDBIN_API, FeedbinAPI);
	_tmp0_ = self->priv->m_session;
	g_signal_parse_name ("authenticate", soup_session_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _feedbin_api_authenticate_soup_session_authenticate, self);
	_g_object_unref0 (self->priv->m_session);
	_g_free0 (self->priv->m_base_uri);
	_g_free0 (self->priv->_username);
	_g_free0 (self->priv->_password);
	G_OBJECT_CLASS (feedbin_api_parent_class)->finalize (obj);
}

static GType
feedbin_api_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedbinAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feedbin_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedbinAPI), 0, (GInstanceInitFunc) feedbin_api_instance_init, NULL };
	GType feedbin_api_type_id;
	feedbin_api_type_id = g_type_register_static (G_TYPE_OBJECT, "FeedbinAPI", &g_define_type_info, 0);
	FeedbinAPI_private_offset = g_type_add_instance_private (feedbin_api_type_id, sizeof (FeedbinAPIPrivate));
	return feedbin_api_type_id;
}

GType
feedbin_api_get_type (void)
{
	static volatile gsize feedbin_api_type_id__once = 0;
	if (g_once_init_enter (&feedbin_api_type_id__once)) {
		GType feedbin_api_type_id;
		feedbin_api_type_id = feedbin_api_get_type_once ();
		g_once_init_leave (&feedbin_api_type_id__once, feedbin_api_type_id);
	}
	return feedbin_api_type_id__once;
}

static void
_vala_feedbin_api_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	FeedbinAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FEEDBIN_API, FeedbinAPI);
	switch (property_id) {
		case FEEDBIN_API_USERNAME_PROPERTY:
		g_value_set_string (value, feedbin_api_get_username (self));
		break;
		case FEEDBIN_API_PASSWORD_PROPERTY:
		g_value_set_string (value, feedbin_api_get_password (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_feedbin_api_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	FeedbinAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FEEDBIN_API, FeedbinAPI);
	switch (property_id) {
		case FEEDBIN_API_USERNAME_PROPERTY:
		feedbin_api_set_username (self, g_value_get_string (value));
		break;
		case FEEDBIN_API_PASSWORD_PROPERTY:
		feedbin_api_set_password (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

