/* feedhqAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from feedhqAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "feedhq.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <json-glib/json-glib.h>
#include <gee.h>
#include <gio/gio.h>

enum  {
	FEED_READER_FEED_HQAPI_0_PROPERTY,
	FEED_READER_FEED_HQAPI_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feed_hqapi_properties[FEED_READER_FEED_HQAPI_NUM_PROPERTIES];
#define _feed_reader_feed_hq_connection_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_feed_hq_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _feed_reader_feedhq_message_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_feedhq_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FeedReaderFeedHQAPIPrivate {
	FeedReaderFeedHQConnection* m_connection;
	FeedReaderFeedHQUtils* m_utils;
	gchar* m_userID;
};

static gint FeedReaderFeedHQAPI_private_offset;
static gpointer feed_reader_feed_hqapi_parent_class = NULL;
static GType feed_reader_feed_hqapi_type_id = 0;

static gboolean feed_reader_feed_hqapi_getUserID (FeedReaderFeedHQAPI* self);
static void feed_reader_feed_hqapi_finalize (GObject * obj);

static inline gpointer
feed_reader_feed_hqapi_get_instance_private (FeedReaderFeedHQAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeedHQAPI_private_offset);
}

static GType
feed_reader_feed_hqapi_feed_hq_subscription_action_get_type_once (void)
{
	static const GEnumValue values[] = {{FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_EDIT, "FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_EDIT", "edit"}, {FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_SUBSCRIBE, "FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_SUBSCRIBE", "subscribe"}, {FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_UNSUBSCRIBE, "FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_UNSUBSCRIBE", "unsubscribe"}, {0, NULL, NULL}};
	GType feed_reader_feed_hqapi_feed_hq_subscription_action_type_id;
	feed_reader_feed_hqapi_feed_hq_subscription_action_type_id = g_enum_register_static ("FeedReaderFeedHQAPIFeedHQSubscriptionAction", values);
	return feed_reader_feed_hqapi_feed_hq_subscription_action_type_id;
}

GType
feed_reader_feed_hqapi_feed_hq_subscription_action_get_type (void)
{
	static volatile gsize feed_reader_feed_hqapi_feed_hq_subscription_action_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_feed_hqapi_feed_hq_subscription_action_type_id__once)) {
		GType feed_reader_feed_hqapi_feed_hq_subscription_action_type_id;
		feed_reader_feed_hqapi_feed_hq_subscription_action_type_id = feed_reader_feed_hqapi_feed_hq_subscription_action_get_type_once ();
		g_once_init_leave (&feed_reader_feed_hqapi_feed_hq_subscription_action_type_id__once, feed_reader_feed_hqapi_feed_hq_subscription_action_type_id);
	}
	return feed_reader_feed_hqapi_feed_hq_subscription_action_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderFeedHQAPI*
feed_reader_feed_hqapi_construct (GType object_type,
                                  FeedReaderFeedHQUtils* utils)
{
	FeedReaderFeedHQAPI * self = NULL;
	FeedReaderFeedHQUtils* _tmp0_;
	FeedReaderFeedHQUtils* _tmp1_;
	FeedReaderFeedHQConnection* _tmp2_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderFeedHQAPI*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feed_hq_connection_new (_tmp1_);
	_feed_reader_feed_hq_connection_unref0 (self->priv->m_connection);
	self->priv->m_connection = _tmp2_;
	return self;
}

FeedReaderFeedHQAPI*
feed_reader_feed_hqapi_new (FeedReaderFeedHQUtils* utils)
{
	return feed_reader_feed_hqapi_construct (FEED_READER_TYPE_FEED_HQAPI, utils);
}

FeedReaderLoginResponse
feed_reader_feed_hqapi_login (FeedReaderFeedHQAPI* self)
{
	FeedReaderFeedHQUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_logger_debug ("FeedHQ Login");
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_feed_hq_utils_getAccessToken (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		FeedReaderLoginResponse _result_ = 0;
		FeedReaderFeedHQConnection* _tmp4_;
		gboolean _tmp5_ = FALSE;
		FeedReaderFeedHQConnection* _tmp6_;
		_tmp4_ = self->priv->m_connection;
		_result_ = feed_reader_feed_hq_connection_getToken (_tmp4_);
		_tmp6_ = self->priv->m_connection;
		if (feed_reader_feed_hq_connection_postToken (_tmp6_)) {
			_tmp5_ = feed_reader_feed_hqapi_getUserID (self);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = _result_;
			return result;
		}
	} else {
		if (feed_reader_feed_hqapi_getUserID (self)) {
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			return result;
		}
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	return result;
}

gboolean
feed_reader_feed_hqapi_ping (FeedReaderFeedHQAPI* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = feed_reader_utils_ping ("https://feedhq.org");
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
feed_reader_feed_hqapi_getUserID (FeedReaderFeedHQAPI* self)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderfeedhqMessage* _tmp1_;
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp2_;
	FeedReaderfeedhqMessage* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderResponse _tmp8_ = {0};
	FeedReaderResponse _tmp9_;
	FeedReaderResponse _tmp10_;
	JsonParser* parser = NULL;
	JsonParser* _tmp11_;
	JsonObject* root = NULL;
	JsonParser* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	JsonObject* _tmp22_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_feedhq_message_add (_tmp1_, "output", "json");
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = msg;
	_tmp4_ = feed_reader_feedhq_message_get (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("user-info?", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	feed_reader_feed_hq_connection_send_get_request (_tmp2_, _tmp7_, NULL, &_tmp8_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	response = _tmp9_;
	_tmp10_ = response;
	if (_tmp10_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	_tmp11_ = json_parser_new ();
	parser = _tmp11_;
	{
		JsonParser* _tmp12_;
		FeedReaderResponse _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = parser;
		_tmp13_ = response;
		_tmp14_ = _tmp13_.data;
		json_parser_load_from_data (_tmp12_, _tmp14_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getUserID: Could not load message response");
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		feed_reader_logger_error (_tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	_tmp18_ = parser;
	_tmp19_ = json_parser_get_root (_tmp18_);
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = _json_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp22_ = root;
	if (json_object_has_member (_tmp22_, "userId")) {
		JsonObject* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		FeedReaderFeedHQUtils* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		JsonObject* _tmp31_;
		_tmp23_ = root;
		_tmp24_ = json_object_get_string_member (_tmp23_, "userId");
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (self->priv->m_userID);
		self->priv->m_userID = _tmp25_;
		_tmp26_ = self->priv->m_utils;
		_tmp27_ = self->priv->m_userID;
		feed_reader_feed_hq_utils_setUserID (_tmp26_, _tmp27_);
		_tmp28_ = self->priv->m_userID;
		_tmp29_ = g_strconcat ("FeedHQ: userID = ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		feed_reader_logger_info (_tmp30_);
		_g_free0 (_tmp30_);
		_tmp31_ = root;
		if (json_object_has_member (_tmp31_, "userName")) {
			FeedReaderFeedHQUtils* _tmp32_;
			JsonObject* _tmp33_;
			const gchar* _tmp34_;
			_tmp32_ = self->priv->m_utils;
			_tmp33_ = root;
			_tmp34_ = json_object_get_string_member (_tmp33_, "userName");
			feed_reader_feed_hq_utils_setUser (_tmp32_, _tmp34_);
		}
		result = TRUE;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	result = FALSE;
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_feedhq_message_unref0 (msg);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

gboolean
feed_reader_feed_hqapi_getFeeds (FeedReaderFeedHQAPI* self,
                                 GeeList* feeds)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderfeedhqMessage* _tmp1_;
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp2_;
	FeedReaderfeedhqMessage* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderResponse _tmp8_ = {0};
	FeedReaderResponse _tmp9_;
	FeedReaderResponse _tmp10_;
	JsonParser* parser = NULL;
	JsonParser* _tmp11_;
	JsonObject* root = NULL;
	JsonParser* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	JsonArray* array = NULL;
	JsonObject* _tmp22_;
	JsonArray* _tmp23_;
	JsonArray* _tmp24_;
	guint length = 0U;
	JsonArray* _tmp25_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_feedhq_message_add (_tmp1_, "output", "json");
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = msg;
	_tmp4_ = feed_reader_feedhq_message_get (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("subscription/list?", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	feed_reader_feed_hq_connection_send_get_request (_tmp2_, _tmp7_, NULL, &_tmp8_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	response = _tmp9_;
	_tmp10_ = response;
	if (_tmp10_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	_tmp11_ = json_parser_new ();
	parser = _tmp11_;
	{
		JsonParser* _tmp12_;
		FeedReaderResponse _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = parser;
		_tmp13_ = response;
		_tmp14_ = _tmp13_.data;
		json_parser_load_from_data (_tmp12_, _tmp14_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getFeeds: Could not load message response");
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		feed_reader_logger_error (_tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	_tmp18_ = parser;
	_tmp19_ = json_parser_get_root (_tmp18_);
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = _json_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp22_ = root;
	_tmp23_ = json_object_get_array_member (_tmp22_, "subscriptions");
	_tmp24_ = _json_array_ref0 (_tmp23_);
	array = _tmp24_;
	_tmp25_ = array;
	length = json_array_get_length (_tmp25_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp28_;
				JsonObject* _tmp29_;
				JsonObject* _tmp30_;
				gchar* feedID = NULL;
				JsonObject* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				const gchar* _tmp34_ = NULL;
				JsonObject* _tmp35_;
				gchar* url = NULL;
				gchar* _tmp40_;
				gchar* _tmp41_ = NULL;
				JsonObject* _tmp42_;
				gchar* icon_url = NULL;
				gchar* _tmp46_;
				guint catCount = 0U;
				JsonObject* _tmp47_;
				JsonArray* _tmp48_;
				GeeArrayList* categories = NULL;
				GeeArrayList* _tmp49_;
				const gchar* _tmp57_;
				JsonObject* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				GeeArrayList* _tmp61_;
				const gchar* _tmp62_;
				JsonObject* _tmp63_;
				const gchar* _tmp64_;
				FeedReaderFeed* _tmp65_;
				FeedReaderFeed* _tmp66_;
				if (!_tmp26_) {
					guint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp28_ = array;
				_tmp29_ = json_array_get_object_element (_tmp28_, i);
				_tmp30_ = _json_object_ref0 (_tmp29_);
				object = _tmp30_;
				_tmp31_ = object;
				_tmp32_ = json_object_get_string_member (_tmp31_, "id");
				_tmp33_ = g_strdup (_tmp32_);
				feedID = _tmp33_;
				_tmp35_ = object;
				if (json_object_has_member (_tmp35_, "htmlUrl")) {
					JsonObject* _tmp36_;
					const gchar* _tmp37_;
					_tmp36_ = object;
					_tmp37_ = json_object_get_string_member (_tmp36_, "htmlUrl");
					_tmp34_ = _tmp37_;
				} else {
					JsonObject* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = object;
					_tmp39_ = json_object_get_string_member (_tmp38_, "url");
					_tmp34_ = _tmp39_;
				}
				_tmp40_ = g_strdup (_tmp34_);
				url = _tmp40_;
				_tmp42_ = object;
				if (json_object_has_member (_tmp42_, "iconUrl")) {
					JsonObject* _tmp43_;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					_tmp43_ = object;
					_tmp44_ = json_object_get_string_member (_tmp43_, "iconUrl");
					_tmp45_ = g_strconcat ("https:", _tmp44_, NULL);
					_g_free0 (_tmp41_);
					_tmp41_ = _tmp45_;
				} else {
					_g_free0 (_tmp41_);
					_tmp41_ = NULL;
				}
				_tmp46_ = g_strdup (_tmp41_);
				icon_url = _tmp46_;
				_tmp47_ = object;
				_tmp48_ = json_object_get_array_member (_tmp47_, "categories");
				catCount = json_array_get_length (_tmp48_);
				_tmp49_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				categories = _tmp49_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp50_ = FALSE;
						_tmp50_ = TRUE;
						while (TRUE) {
							GeeArrayList* _tmp52_;
							JsonObject* _tmp53_;
							JsonArray* _tmp54_;
							JsonObject* _tmp55_;
							const gchar* _tmp56_;
							if (!_tmp50_) {
								guint _tmp51_;
								j = j + 1;
								_tmp51_ = j;
							}
							_tmp50_ = FALSE;
							if (!(j < catCount)) {
								break;
							}
							_tmp52_ = categories;
							_tmp53_ = object;
							_tmp54_ = json_object_get_array_member (_tmp53_, "categories");
							_tmp55_ = json_array_get_object_element (_tmp54_, j);
							_tmp56_ = json_object_get_string_member (_tmp55_, "id");
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp56_);
						}
					}
				}
				_tmp57_ = feedID;
				_tmp58_ = object;
				_tmp59_ = json_object_get_string_member (_tmp58_, "title");
				_tmp60_ = url;
				_tmp61_ = categories;
				_tmp62_ = icon_url;
				_tmp63_ = object;
				_tmp64_ = json_object_get_string_member (_tmp63_, "url");
				_tmp65_ = feed_reader_feed_new (_tmp57_, _tmp59_, _tmp60_, (guint) 0, (GeeList*) _tmp61_, _tmp62_, _tmp64_);
				_tmp66_ = _tmp65_;
				gee_collection_add ((GeeCollection*) feeds, _tmp66_);
				_g_object_unref0 (_tmp66_);
				_g_object_unref0 (categories);
				_g_free0 (icon_url);
				_g_free0 (_tmp41_);
				_g_free0 (url);
				_g_free0 (feedID);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_feedhq_message_unref0 (msg);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
feed_reader_feed_hqapi_getCategoriesAndTags (FeedReaderFeedHQAPI* self,
                                             GeeList* feeds,
                                             GeeList* categories,
                                             GeeList* tags)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderfeedhqMessage* _tmp1_;
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp2_;
	FeedReaderfeedhqMessage* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderResponse _tmp8_ = {0};
	FeedReaderResponse _tmp9_;
	FeedReaderResponse _tmp10_;
	JsonParser* parser = NULL;
	JsonParser* _tmp11_;
	JsonObject* root = NULL;
	JsonParser* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	JsonArray* array = NULL;
	JsonObject* _tmp22_;
	JsonArray* _tmp23_;
	JsonArray* _tmp24_;
	guint length = 0U;
	JsonArray* _tmp25_;
	gint orderID = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_feedhq_message_add (_tmp1_, "output", "json");
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = msg;
	_tmp4_ = feed_reader_feedhq_message_get (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("tag/list?", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	feed_reader_feed_hq_connection_send_get_request (_tmp2_, _tmp7_, NULL, &_tmp8_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	response = _tmp9_;
	_tmp10_ = response;
	if (_tmp10_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	_tmp11_ = json_parser_new ();
	parser = _tmp11_;
	{
		JsonParser* _tmp12_;
		FeedReaderResponse _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = parser;
		_tmp13_ = response;
		_tmp14_ = _tmp13_.data;
		json_parser_load_from_data (_tmp12_, _tmp14_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getCategoriesAndTags: Could not load message response");
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		feed_reader_logger_error (_tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	_tmp18_ = parser;
	_tmp19_ = json_parser_get_root (_tmp18_);
	_tmp20_ = json_node_get_object (_tmp19_);
	_tmp21_ = _json_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp22_ = root;
	_tmp23_ = json_object_get_array_member (_tmp22_, "tags");
	_tmp24_ = _json_array_ref0 (_tmp23_);
	array = _tmp24_;
	_tmp25_ = array;
	length = json_array_get_length (_tmp25_);
	orderID = 0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp28_;
				JsonObject* _tmp29_;
				JsonObject* _tmp30_;
				gchar* id = NULL;
				JsonObject* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gint start = 0;
				const gchar* _tmp34_;
				gchar* title = NULL;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				const gchar* _tmp37_;
				if (!_tmp26_) {
					guint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp28_ = array;
				_tmp29_ = json_array_get_object_element (_tmp28_, i);
				_tmp30_ = _json_object_ref0 (_tmp29_);
				object = _tmp30_;
				_tmp31_ = object;
				_tmp32_ = json_object_get_string_member (_tmp31_, "id");
				_tmp33_ = g_strdup (_tmp32_);
				id = _tmp33_;
				_tmp34_ = id;
				start = string_last_index_of_char (_tmp34_, (gunichar) '/', 0) + 1;
				_tmp35_ = id;
				_tmp36_ = string_substring (_tmp35_, (glong) start, (glong) -1);
				title = _tmp36_;
				_tmp37_ = id;
				if (string_contains (_tmp37_, "/label/")) {
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					FeedReaderCategory* _tmp42_;
					FeedReaderCategory* _tmp43_;
					gint _tmp44_;
					_tmp38_ = id;
					_tmp39_ = title;
					_tmp40_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
					_tmp41_ = _tmp40_;
					_tmp42_ = feed_reader_category_new (_tmp38_, _tmp39_, (guint) 0, orderID, _tmp41_, 1);
					_tmp43_ = _tmp42_;
					gee_collection_add ((GeeCollection*) categories, _tmp43_);
					_g_object_unref0 (_tmp43_);
					_g_free0 (_tmp41_);
					orderID = orderID + 1;
					_tmp44_ = orderID;
				}
				_g_free0 (title);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_feedhq_message_unref0 (msg);
	return result;
}

gint
feed_reader_feed_hqapi_getTotalUnread (FeedReaderFeedHQAPI* self)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse _tmp6_ = {0};
	FeedReaderResponse _tmp7_;
	JsonParser* parser = NULL;
	JsonParser* _tmp8_;
	JsonObject* root = NULL;
	JsonNode* _tmp14_;
	JsonObject* _tmp15_;
	JsonObject* _tmp16_;
	JsonArray* array = NULL;
	JsonObject* _tmp17_;
	JsonArray* _tmp18_;
	JsonArray* _tmp19_;
	guint length = 0U;
	JsonArray* _tmp20_;
	gint count = 0;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	feed_reader_feedhq_message_add (msg, "output", "json");
	_tmp1_ = self->priv->m_connection;
	_tmp2_ = feed_reader_feedhq_message_get (msg);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("unread-count?", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	feed_reader_feed_hq_connection_send_get_request (_tmp1_, _tmp5_, NULL, &_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	response = _tmp7_;
	_tmp8_ = json_parser_new ();
	parser = _tmp8_;
	{
		FeedReaderResponse _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = response;
		_tmp10_ = _tmp9_.data;
		json_parser_load_from_data (parser, _tmp10_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTotalUnread: Could not load message response");
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		feed_reader_logger_error (_tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp13_ = -1;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	_tmp14_ = json_parser_get_root (parser);
	_tmp15_ = json_node_get_object (_tmp14_);
	_tmp16_ = _json_object_ref0 (_tmp15_);
	root = _tmp16_;
	_tmp17_ = root;
	_tmp18_ = json_object_get_array_member (_tmp17_, "unreadcounts");
	_tmp19_ = _json_array_ref0 (_tmp18_);
	array = _tmp19_;
	_tmp20_ = array;
	length = json_array_get_length (_tmp20_);
	count = 0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp23_;
				JsonObject* _tmp24_;
				JsonObject* _tmp25_;
				JsonObject* _tmp26_;
				const gchar* _tmp27_;
				if (!_tmp21_) {
					guint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp23_ = array;
				_tmp24_ = json_array_get_object_element (_tmp23_, i);
				_tmp25_ = _json_object_ref0 (_tmp24_);
				object = _tmp25_;
				_tmp26_ = object;
				_tmp27_ = json_object_get_string_member (_tmp26_, "id");
				if (g_str_has_prefix (_tmp27_, "feed/")) {
					JsonObject* _tmp28_;
					_tmp28_ = object;
					count += (gint) json_object_get_int_member (_tmp28_, "count");
				}
				_json_object_unref0 (object);
			}
		}
	}
	_tmp29_ = g_strdup_printf ("getTotalUnread %i", count);
	_tmp30_ = _tmp29_;
	feed_reader_logger_debug (_tmp30_);
	_g_free0 (_tmp30_);
	result = count;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_feedhq_message_unref0 (msg);
	return result;
}

gchar*
feed_reader_feed_hqapi_updateArticles (FeedReaderFeedHQAPI* self,
                                       GeeList* ids,
                                       gint count,
                                       const gchar* continuation)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderfeedhqMessage* _tmp1_;
	FeedReaderfeedhqMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FeedReaderfeedhqMessage* _tmp5_;
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp7_;
	FeedReaderfeedhqMessage* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	FeedReaderResponse _tmp13_ = {0};
	FeedReaderResponse _tmp14_;
	FeedReaderResponse _tmp15_;
	JsonParser* parser = NULL;
	JsonParser* _tmp16_;
	JsonObject* root = NULL;
	JsonParser* _tmp22_;
	JsonNode* _tmp23_;
	JsonObject* _tmp24_;
	JsonObject* _tmp25_;
	JsonObject* _tmp26_;
	JsonArray* array = NULL;
	JsonObject* _tmp27_;
	JsonArray* _tmp28_;
	JsonArray* _tmp29_;
	guint length = 0U;
	JsonArray* _tmp30_;
	gboolean _tmp38_ = FALSE;
	JsonObject* _tmp39_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ids != NULL, NULL);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_feedhq_message_add (_tmp1_, "output", "json");
	_tmp2_ = msg;
	_tmp3_ = g_strdup_printf ("%i", count);
	_tmp4_ = _tmp3_;
	feed_reader_feedhq_message_add (_tmp2_, "n", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = msg;
	feed_reader_feedhq_message_add (_tmp5_, "s", "user/-/state/com.google/read");
	if (continuation != NULL) {
		FeedReaderfeedhqMessage* _tmp6_;
		_tmp6_ = msg;
		feed_reader_feedhq_message_add (_tmp6_, "c", continuation);
	}
	_tmp7_ = self->priv->m_connection;
	_tmp8_ = msg;
	_tmp9_ = feed_reader_feedhq_message_get (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("stream/items/ids?", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	feed_reader_feed_hq_connection_send_get_request (_tmp7_, _tmp12_, NULL, &_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	response = _tmp14_;
	_tmp15_ = response;
	if (_tmp15_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	_tmp16_ = json_parser_new ();
	parser = _tmp16_;
	{
		JsonParser* _tmp17_;
		FeedReaderResponse _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = parser;
		_tmp18_ = response;
		_tmp19_ = _tmp18_.data;
		json_parser_load_from_data (_tmp17_, _tmp19_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("updateArticles: Could not load message response");
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		feed_reader_logger_error (_tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp22_ = parser;
	_tmp23_ = json_parser_get_root (_tmp22_);
	_tmp24_ = json_node_get_object (_tmp23_);
	_tmp25_ = _json_object_ref0 (_tmp24_);
	root = _tmp25_;
	_tmp26_ = root;
	if (!json_object_has_member (_tmp26_, "itemRefs")) {
		feed_reader_logger_error ("updateArticles: wrong response?");
		result = NULL;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	_tmp27_ = root;
	_tmp28_ = json_object_get_array_member (_tmp27_, "itemRefs");
	_tmp29_ = _json_array_ref0 (_tmp28_);
	array = _tmp29_;
	_tmp30_ = array;
	length = json_array_get_length (_tmp30_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp33_;
				JsonObject* _tmp34_;
				JsonObject* _tmp35_;
				JsonObject* _tmp36_;
				const gchar* _tmp37_;
				if (!_tmp31_) {
					guint _tmp32_;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp33_ = array;
				_tmp34_ = json_array_get_object_element (_tmp33_, i);
				_tmp35_ = _json_object_ref0 (_tmp34_);
				object = _tmp35_;
				_tmp36_ = object;
				_tmp37_ = json_object_get_string_member (_tmp36_, "id");
				gee_collection_add ((GeeCollection*) ids, _tmp37_);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp39_ = root;
	if (json_object_has_member (_tmp39_, "continuation")) {
		JsonObject* _tmp40_;
		const gchar* _tmp41_;
		_tmp40_ = root;
		_tmp41_ = json_object_get_string_member (_tmp40_, "continuation");
		_tmp38_ = g_strcmp0 (_tmp41_, "") != 0;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		JsonObject* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp42_ = root;
		_tmp43_ = json_object_get_string_member (_tmp42_, "continuation");
		_tmp44_ = g_strdup (_tmp43_);
		result = _tmp44_;
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	result = NULL;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_feedhq_message_unref0 (msg);
	return result;
}

gchar*
feed_reader_feed_hqapi_getArticles (FeedReaderFeedHQAPI* self,
                                    GeeList* articles,
                                    gint count,
                                    FeedReaderArticleStatus whatToGet,
                                    const gchar* continuation,
                                    const gchar* tagID,
                                    const gchar* feed_id)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderfeedhqMessage* _tmp1_;
	FeedReaderfeedhqMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* api_endpoint = NULL;
	gchar* _tmp9_;
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	FeedReaderfeedhqMessage* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	FeedReaderResponse _tmp27_ = {0};
	FeedReaderResponse _tmp28_;
	FeedReaderResponse _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	FeedReaderfeedhqMessage* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	JsonParser* parser = NULL;
	JsonParser* _tmp38_;
	JsonObject* root = NULL;
	JsonParser* _tmp44_;
	JsonNode* _tmp45_;
	JsonObject* _tmp46_;
	JsonObject* _tmp47_;
	JsonArray* array = NULL;
	JsonObject* _tmp48_;
	JsonArray* _tmp49_;
	JsonArray* _tmp50_;
	guint length = 0U;
	JsonArray* _tmp51_;
	gboolean _tmp114_ = FALSE;
	JsonObject* _tmp115_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articles != NULL, NULL);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_feedhq_message_add (_tmp1_, "output", "json");
	_tmp2_ = msg;
	_tmp3_ = g_strdup_printf ("%i", count);
	_tmp4_ = _tmp3_;
	feed_reader_feedhq_message_add (_tmp2_, "n", _tmp4_);
	_g_free0 (_tmp4_);
	if (whatToGet == FEED_READER_ARTICLE_STATUS_UNREAD) {
		FeedReaderfeedhqMessage* _tmp5_;
		_tmp5_ = msg;
		feed_reader_feedhq_message_add (_tmp5_, "xt", "user/-/state/com.google/read");
	}
	if (whatToGet == FEED_READER_ARTICLE_STATUS_READ) {
		FeedReaderfeedhqMessage* _tmp6_;
		_tmp6_ = msg;
		feed_reader_feedhq_message_add (_tmp6_, "s", "user/-/state/com.google/read");
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_MARKED) {
			FeedReaderfeedhqMessage* _tmp7_;
			_tmp7_ = msg;
			feed_reader_feedhq_message_add (_tmp7_, "s", "user/-/state/com.google/starred");
		}
	}
	if (continuation != NULL) {
		FeedReaderfeedhqMessage* _tmp8_;
		_tmp8_ = msg;
		feed_reader_feedhq_message_add (_tmp8_, "c", continuation);
	}
	_tmp9_ = g_strdup ("stream/contents");
	api_endpoint = _tmp9_;
	if (feed_id != NULL) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = api_endpoint;
		_tmp11_ = g_strconcat ("/", feed_id, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
		_g_free0 (api_endpoint);
		api_endpoint = _tmp13_;
		_g_free0 (_tmp12_);
	} else {
		if (tagID != NULL) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = api_endpoint;
			_tmp15_ = g_strconcat ("/", tagID, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
			_g_free0 (api_endpoint);
			api_endpoint = _tmp17_;
			_g_free0 (_tmp16_);
		}
	}
	_tmp18_ = self->priv->m_connection;
	_tmp19_ = api_endpoint;
	_tmp20_ = g_strconcat (_tmp19_, "?", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = msg;
	_tmp23_ = feed_reader_feedhq_message_get (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp21_, _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	feed_reader_feed_hq_connection_send_get_request (_tmp18_, _tmp26_, NULL, &_tmp27_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	response = _tmp28_;
	_tmp29_ = response;
	if (_tmp29_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	_tmp30_ = api_endpoint;
	_tmp31_ = g_strconcat (_tmp30_, "?", NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = msg;
	_tmp34_ = feed_reader_feedhq_message_get (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_tmp32_, _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	feed_reader_logger_debug (_tmp37_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp32_);
	_tmp38_ = json_parser_new ();
	parser = _tmp38_;
	{
		JsonParser* _tmp39_;
		FeedReaderResponse _tmp40_;
		const gchar* _tmp41_;
		_tmp39_ = parser;
		_tmp40_ = response;
		_tmp41_ = _tmp40_.data;
		json_parser_load_from_data (_tmp39_, _tmp41_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getCategoriesAndTags: Could not load message response");
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		feed_reader_logger_error (_tmp43_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_feed_reader_feedhq_message_unref0 (msg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp44_ = parser;
	_tmp45_ = json_parser_get_root (_tmp44_);
	_tmp46_ = json_node_get_object (_tmp45_);
	_tmp47_ = _json_object_ref0 (_tmp46_);
	root = _tmp47_;
	_tmp48_ = root;
	_tmp49_ = json_object_get_array_member (_tmp48_, "items");
	_tmp50_ = _json_array_ref0 (_tmp49_);
	array = _tmp50_;
	_tmp51_ = array;
	length = json_array_get_length (_tmp51_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp52_ = FALSE;
			_tmp52_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp54_;
				JsonObject* _tmp55_;
				JsonObject* _tmp56_;
				gchar* id = NULL;
				JsonObject* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gboolean marked = FALSE;
				gboolean read = FALSE;
				JsonArray* cats = NULL;
				JsonObject* _tmp60_;
				JsonArray* _tmp61_;
				JsonArray* _tmp62_;
				guint cat_length = 0U;
				JsonArray* _tmp63_;
				GeeArrayList* tags = NULL;
				GeeArrayList* _tmp64_;
				GeeArrayList* enclosures = NULL;
				GeeArrayList* _tmp75_;
				JsonObject* _tmp76_;
				FeedReaderArticleStatus _tmp95_ = 0;
				FeedReaderArticleStatus _tmp96_ = 0;
				const gchar* _tmp97_;
				JsonObject* _tmp98_;
				const gchar* _tmp99_;
				JsonObject* _tmp100_;
				JsonArray* _tmp101_;
				JsonObject* _tmp102_;
				const gchar* _tmp103_;
				JsonObject* _tmp104_;
				JsonObject* _tmp105_;
				const gchar* _tmp106_;
				JsonObject* _tmp107_;
				GDateTime* _tmp108_;
				GDateTime* _tmp109_;
				GeeArrayList* _tmp110_;
				GeeArrayList* _tmp111_;
				FeedReaderArticle* _tmp112_;
				FeedReaderArticle* _tmp113_;
				if (!_tmp52_) {
					guint _tmp53_;
					_tmp53_ = i;
					i = _tmp53_ + 1;
				}
				_tmp52_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp54_ = array;
				_tmp55_ = json_array_get_object_element (_tmp54_, i);
				_tmp56_ = _json_object_ref0 (_tmp55_);
				object = _tmp56_;
				_tmp57_ = object;
				_tmp58_ = json_object_get_string_member (_tmp57_, "id");
				_tmp59_ = g_strdup (_tmp58_);
				id = _tmp59_;
				marked = FALSE;
				read = FALSE;
				_tmp60_ = object;
				_tmp61_ = json_object_get_array_member (_tmp60_, "categories");
				_tmp62_ = _json_array_ref0 (_tmp61_);
				cats = _tmp62_;
				_tmp63_ = cats;
				cat_length = json_array_get_length (_tmp63_);
				_tmp64_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				tags = _tmp64_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp65_ = FALSE;
						_tmp65_ = TRUE;
						while (TRUE) {
							gchar* cat = NULL;
							JsonArray* _tmp67_;
							const gchar* _tmp68_;
							gchar* _tmp69_;
							const gchar* _tmp70_;
							if (!_tmp65_) {
								guint _tmp66_;
								_tmp66_ = j;
								j = _tmp66_ + 1;
							}
							_tmp65_ = FALSE;
							if (!(j < cat_length)) {
								break;
							}
							_tmp67_ = cats;
							_tmp68_ = json_array_get_string_element (_tmp67_, j);
							_tmp69_ = g_strdup (_tmp68_);
							cat = _tmp69_;
							_tmp70_ = cat;
							if (g_str_has_suffix (_tmp70_, "com.google/starred")) {
								marked = TRUE;
							} else {
								const gchar* _tmp71_;
								_tmp71_ = cat;
								if (g_str_has_suffix (_tmp71_, "com.google/read")) {
									read = TRUE;
								} else {
									const gchar* _tmp72_;
									_tmp72_ = cat;
									if (string_contains (_tmp72_, "/label/")) {
										GeeArrayList* _tmp73_;
										const gchar* _tmp74_;
										_tmp73_ = tags;
										_tmp74_ = cat;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, _tmp74_);
									}
								}
							}
							_g_free0 (cat);
						}
					}
				}
				_tmp75_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				enclosures = _tmp75_;
				_tmp76_ = object;
				if (json_object_has_member (_tmp76_, "enclosure")) {
					JsonArray* attachments = NULL;
					JsonObject* _tmp77_;
					JsonArray* _tmp78_;
					JsonArray* _tmp79_;
					guint mediaCount = 0U;
					JsonArray* _tmp80_;
					_tmp77_ = object;
					_tmp78_ = json_object_get_array_member (_tmp77_, "enclosure");
					_tmp79_ = _json_array_ref0 (_tmp78_);
					attachments = _tmp79_;
					mediaCount = (guint) 0;
					_tmp80_ = attachments;
					if (_tmp80_ != NULL) {
						JsonArray* _tmp81_;
						_tmp81_ = attachments;
						mediaCount = json_array_get_length (_tmp81_);
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp82_ = FALSE;
							_tmp82_ = TRUE;
							while (TRUE) {
								JsonObject* attachment = NULL;
								JsonArray* _tmp84_;
								JsonObject* _tmp85_;
								JsonObject* _tmp86_;
								GeeArrayList* _tmp87_;
								const gchar* _tmp88_;
								JsonObject* _tmp89_;
								const gchar* _tmp90_;
								JsonObject* _tmp91_;
								const gchar* _tmp92_;
								FeedReaderEnclosure* _tmp93_;
								FeedReaderEnclosure* _tmp94_;
								if (!_tmp82_) {
									gint _tmp83_;
									j = j + 1;
									_tmp83_ = j;
								}
								_tmp82_ = FALSE;
								if (!(((guint) j) < mediaCount)) {
									break;
								}
								_tmp84_ = attachments;
								_tmp85_ = json_array_get_object_element (_tmp84_, (guint) j);
								_tmp86_ = _json_object_ref0 (_tmp85_);
								attachment = _tmp86_;
								_tmp87_ = enclosures;
								_tmp88_ = id;
								_tmp89_ = attachment;
								_tmp90_ = json_object_get_string_member (_tmp89_, "href");
								_tmp91_ = attachment;
								_tmp92_ = json_object_get_string_member (_tmp91_, "type");
								_tmp93_ = feed_reader_enclosure_new (_tmp88_, _tmp90_, feed_reader_enclosure_type_from_string (_tmp92_));
								_tmp94_ = _tmp93_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp87_, _tmp94_);
								_g_object_unref0 (_tmp94_);
								_json_object_unref0 (attachment);
							}
						}
					}
					_json_array_unref0 (attachments);
				}
				if (read) {
					_tmp95_ = FEED_READER_ARTICLE_STATUS_READ;
				} else {
					_tmp95_ = FEED_READER_ARTICLE_STATUS_UNREAD;
				}
				if (marked) {
					_tmp96_ = FEED_READER_ARTICLE_STATUS_MARKED;
				} else {
					_tmp96_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
				}
				_tmp97_ = id;
				_tmp98_ = object;
				_tmp99_ = json_object_get_string_member (_tmp98_, "title");
				_tmp100_ = object;
				_tmp101_ = json_object_get_array_member (_tmp100_, "alternate");
				_tmp102_ = json_array_get_object_element (_tmp101_, (guint) 0);
				_tmp103_ = json_object_get_string_member (_tmp102_, "href");
				_tmp104_ = object;
				_tmp105_ = json_object_get_object_member (_tmp104_, "origin");
				_tmp106_ = json_object_get_string_member (_tmp105_, "streamId");
				_tmp107_ = object;
				_tmp108_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp107_, "published"));
				_tmp109_ = _tmp108_;
				_tmp110_ = tags;
				_tmp111_ = enclosures;
				_tmp112_ = feed_reader_article_new (_tmp97_, _tmp99_, _tmp103_, _tmp106_, _tmp95_, _tmp96_, NULL, NULL, NULL, _tmp109_, -1, (GeeList*) _tmp110_, (GeeList*) _tmp111_, "", 0);
				_tmp113_ = _tmp112_;
				gee_collection_add ((GeeCollection*) articles, _tmp113_);
				_g_object_unref0 (_tmp113_);
				_g_date_time_unref0 (_tmp109_);
				_g_object_unref0 (enclosures);
				_g_object_unref0 (tags);
				_json_array_unref0 (cats);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp115_ = root;
	if (json_object_has_member (_tmp115_, "continuation")) {
		JsonObject* _tmp116_;
		const gchar* _tmp117_;
		_tmp116_ = root;
		_tmp117_ = json_object_get_string_member (_tmp116_, "continuation");
		_tmp114_ = g_strcmp0 (_tmp117_, "") != 0;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		JsonObject* _tmp118_;
		const gchar* _tmp119_;
		gchar* _tmp120_;
		_tmp118_ = root;
		_tmp119_ = json_object_get_string_member (_tmp118_, "continuation");
		_tmp120_ = g_strdup (_tmp119_);
		result = _tmp120_;
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_feed_reader_feedhq_message_unref0 (msg);
		return result;
	}
	result = NULL;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_g_free0 (api_endpoint);
	_feed_reader_feedhq_message_unref0 (msg);
	return result;
}

void
feed_reader_feed_hqapi_edidTag (FeedReaderFeedHQAPI* self,
                                const gchar* articleID,
                                const gchar* tagID,
                                gboolean add)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderfeedhqMessage* _tmp1_;
	FeedReaderfeedhqMessage* _tmp4_;
	FeedReaderFeedHQConnection* _tmp5_;
	FeedReaderfeedhqMessage* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	FeedReaderResponse _tmp9_ = {0};
	FeedReaderResponse _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_feedhq_message_add (_tmp1_, "output", "json");
	if (add) {
		FeedReaderfeedhqMessage* _tmp2_;
		_tmp2_ = msg;
		feed_reader_feedhq_message_add (_tmp2_, "a", tagID);
	} else {
		FeedReaderfeedhqMessage* _tmp3_;
		_tmp3_ = msg;
		feed_reader_feedhq_message_add (_tmp3_, "r", tagID);
	}
	_tmp4_ = msg;
	feed_reader_feedhq_message_add (_tmp4_, "i", articleID);
	_tmp5_ = self->priv->m_connection;
	_tmp6_ = msg;
	_tmp7_ = feed_reader_feedhq_message_get (_tmp6_);
	_tmp8_ = _tmp7_;
	feed_reader_feed_hq_connection_send_post_request (_tmp5_, "edit-tag", _tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	feed_reader_response_destroy (&_tmp10_);
	_g_free0 (_tmp8_);
	_feed_reader_feedhq_message_unref0 (msg);
}

void
feed_reader_feed_hqapi_markAsRead (FeedReaderFeedHQAPI* self,
                                   const gchar* streamID)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderFeedHQConnection* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	FeedReaderResponse _tmp10_ = {0};
	FeedReaderResponse _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (streamID != NULL);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	feed_reader_feedhq_message_add (msg, "output", "json");
	feed_reader_feedhq_message_add (msg, "s", streamID);
	_tmp1_ = feed_reader_settings_state ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i000000", g_settings_get_int (_tmp2_, "last-sync"));
	_tmp4_ = _tmp3_;
	feed_reader_feedhq_message_add (msg, "ts", _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp5_ = feed_reader_feedhq_message_get (msg);
	_tmp6_ = _tmp5_;
	feed_reader_logger_debug (_tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->m_connection;
	_tmp8_ = feed_reader_feedhq_message_get (msg);
	_tmp9_ = _tmp8_;
	feed_reader_feed_hq_connection_send_post_request (_tmp7_, "mark-all-as-read", _tmp9_, &_tmp10_);
	_tmp11_ = _tmp10_;
	feed_reader_response_destroy (&_tmp11_);
	_g_free0 (_tmp9_);
	_feed_reader_feedhq_message_unref0 (msg);
}

gchar*
feed_reader_feed_hqapi_composeTagID (FeedReaderFeedHQAPI* self,
                                     const gchar* tagName)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagName != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strdup_printf ("user/%s/label/%s", _tmp0_, tagName);
	result = _tmp1_;
	return result;
}

void
feed_reader_feed_hqapi_deleteTag (FeedReaderFeedHQAPI* self,
                                  const gchar* tagID)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderFeedHQConnection* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FeedReaderResponse _tmp4_ = {0};
	FeedReaderResponse _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	feed_reader_feedhq_message_add (msg, "output", "json");
	feed_reader_feedhq_message_add (msg, "s", tagID);
	_tmp1_ = self->priv->m_connection;
	_tmp2_ = feed_reader_feedhq_message_get (msg);
	_tmp3_ = _tmp2_;
	feed_reader_feed_hq_connection_send_post_request (_tmp1_, "disable-tag", _tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	feed_reader_response_destroy (&_tmp5_);
	_g_free0 (_tmp3_);
	_feed_reader_feedhq_message_unref0 (msg);
}

void
feed_reader_feed_hqapi_renameTag (FeedReaderFeedHQAPI* self,
                                  const gchar* tagID,
                                  const gchar* title)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FeedReaderFeedHQConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse _tmp6_ = {0};
	FeedReaderResponse _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	feed_reader_feedhq_message_add (msg, "output", "json");
	feed_reader_feedhq_message_add (msg, "s", tagID);
	_tmp1_ = feed_reader_feed_hqapi_composeTagID (self, title);
	_tmp2_ = _tmp1_;
	feed_reader_feedhq_message_add (msg, "dest", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->m_connection;
	_tmp4_ = feed_reader_feedhq_message_get (msg);
	_tmp5_ = _tmp4_;
	feed_reader_feed_hq_connection_send_post_request (_tmp3_, "rename-tag", _tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	feed_reader_response_destroy (&_tmp7_);
	_g_free0 (_tmp5_);
	_feed_reader_feedhq_message_unref0 (msg);
}

gboolean
feed_reader_feed_hqapi_editSubscription (FeedReaderFeedHQAPI* self,
                                         FeedReaderFeedHQAPIFeedHQSubscriptionAction action,
                                         gchar** feedID,
                                         gint feedID_length1,
                                         const gchar* title,
                                         const gchar* add,
                                         const gchar* remove)
{
	FeedReaderfeedhqMessage* msg = NULL;
	FeedReaderfeedhqMessage* _tmp0_;
	FeedReaderfeedhqMessage* _tmp1_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	FeedReaderfeedhqMessage* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp16_;
	FeedReaderfeedhqMessage* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	FeedReaderResponse _tmp20_ = {0};
	FeedReaderResponse _tmp21_;
	FeedReaderResponse _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = feed_reader_feedhq_message_new ();
	msg = _tmp0_;
	_tmp1_ = msg;
	feed_reader_feedhq_message_add (_tmp1_, "output", "json");
	switch (action) {
		case FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_EDIT:
		{
			FeedReaderfeedhqMessage* _tmp2_;
			_tmp2_ = msg;
			feed_reader_feedhq_message_add (_tmp2_, "ac", "edit");
			break;
		}
		case FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_SUBSCRIBE:
		{
			FeedReaderfeedhqMessage* _tmp3_;
			_tmp3_ = msg;
			feed_reader_feedhq_message_add (_tmp3_, "ac", "subscribe");
			break;
		}
		case FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_UNSUBSCRIBE:
		{
			FeedReaderfeedhqMessage* _tmp4_;
			_tmp4_ = msg;
			feed_reader_feedhq_message_add (_tmp4_, "ac", "unsubscribe");
			break;
		}
		default:
		break;
	}
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = feedID;
		s_collection_length1 = feedID_length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp5_;
			gchar* s = NULL;
			_tmp5_ = g_strdup (s_collection[s_it]);
			s = _tmp5_;
			{
				FeedReaderfeedhqMessage* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = msg;
				_tmp7_ = s;
				feed_reader_feedhq_message_add (_tmp6_, "s", _tmp7_);
				_g_free0 (s);
			}
		}
	}
	if (title != NULL) {
		FeedReaderfeedhqMessage* _tmp8_;
		_tmp8_ = msg;
		feed_reader_feedhq_message_add (_tmp8_, "t", title);
	}
	if (add != NULL) {
		_tmp9_ = g_strcmp0 (add, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		FeedReaderfeedhqMessage* _tmp10_;
		_tmp10_ = msg;
		feed_reader_feedhq_message_add (_tmp10_, "a", add);
	}
	if (remove != NULL) {
		_tmp11_ = g_strcmp0 (remove, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		FeedReaderfeedhqMessage* _tmp12_;
		_tmp12_ = msg;
		feed_reader_feedhq_message_add (_tmp12_, "r", remove);
	}
	_tmp13_ = msg;
	_tmp14_ = feed_reader_feedhq_message_get (_tmp13_);
	_tmp15_ = _tmp14_;
	feed_reader_logger_debug (_tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = self->priv->m_connection;
	_tmp17_ = msg;
	_tmp18_ = feed_reader_feedhq_message_get (_tmp17_);
	_tmp19_ = _tmp18_;
	feed_reader_feed_hq_connection_send_post_request (_tmp16_, "subscription/edit", _tmp19_, &_tmp20_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	response = _tmp21_;
	_tmp22_ = response;
	result = _tmp22_.status == ((guint) 200);
	feed_reader_response_destroy (&response);
	_feed_reader_feedhq_message_unref0 (msg);
	return result;
}

void
feed_reader_feed_hqapi_import (FeedReaderFeedHQAPI* self,
                               const gchar* opml)
{
	FeedReaderResponse response = {0};
	FeedReaderFeedHQConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (opml != NULL);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feed_hq_connection_send_post_request (_tmp0_, "subscription/import", opml, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	_tmp3_ = _tmp2_.data;
	_tmp4_ = g_strconcat ("feedhq.import: ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	feed_reader_logger_debug (_tmp5_);
	_g_free0 (_tmp5_);
	feed_reader_response_destroy (&response);
}

static void
feed_reader_feed_hqapi_class_init (FeedReaderFeedHQAPIClass * klass,
                                   gpointer klass_data)
{
	feed_reader_feed_hqapi_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderFeedHQAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_feed_hqapi_finalize;
}

static void
feed_reader_feed_hqapi_instance_init (FeedReaderFeedHQAPI * self,
                                      gpointer klass)
{
	self->priv = feed_reader_feed_hqapi_get_instance_private (self);
}

static void
feed_reader_feed_hqapi_finalize (GObject * obj)
{
	FeedReaderFeedHQAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEED_HQAPI, FeedReaderFeedHQAPI);
	_feed_reader_feed_hq_connection_unref0 (self->priv->m_connection);
	_g_object_unref0 (self->priv->m_utils);
	_g_free0 (self->priv->m_userID);
	G_OBJECT_CLASS (feed_reader_feed_hqapi_parent_class)->finalize (obj);
}

GType
feed_reader_feed_hqapi_get_type (void)
{
	return feed_reader_feed_hqapi_type_id;
}

GType
feed_reader_feed_hqapi_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedHQAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feed_hqapi_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedHQAPI), 0, (GInstanceInitFunc) feed_reader_feed_hqapi_instance_init, NULL };
	feed_reader_feed_hqapi_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderFeedHQAPI", &g_define_type_info, 0);
	FeedReaderFeedHQAPI_private_offset = sizeof (FeedReaderFeedHQAPIPrivate);
	return feed_reader_feed_hqapi_type_id;
}

