/* feedhqConnection.c generated by valac 0.56.3, the Vala compiler
 * generated from feedhqConnection.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "feedhq.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include "FeedReader.h"
#include <gobject/gvaluecollector.h>

#define FEED_READER_FEED_HQ_SECRET_base_uri "https://feedhq.org/reader/api/0/"

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FeedReaderParamSpecFeedHQConnection FeedReaderParamSpecFeedHQConnection;
typedef struct _FeedReaderParamSpecfeedhqMessage FeedReaderParamSpecfeedhqMessage;

struct _FeedReaderFeedHQConnectionPrivate {
	gchar* m_username;
	gchar* m_api_code;
	gchar* m_passwd;
	FeedReaderFeedHQUtils* m_utils;
	SoupSession* m_session;
};

struct _FeedReaderParamSpecFeedHQConnection {
	GParamSpec parent_instance;
};

struct _FeedReaderfeedhqMessagePrivate {
	gchar* request;
};

struct _FeedReaderParamSpecfeedhqMessage {
	GParamSpec parent_instance;
};

static gint FeedReaderFeedHQConnection_private_offset;
static gpointer feed_reader_feed_hq_connection_parent_class = NULL;
static GType feed_reader_feed_hq_connection_type_id = 0;
static gint FeedReaderfeedhqMessage_private_offset;
static gpointer feed_reader_feedhq_message_parent_class = NULL;
static GType feed_reader_feedhq_message_type_id = 0;

static void _vala_SoupBuffer_free (SoupBuffer* self);
static void feed_reader_feed_hq_connection_send_request (FeedReaderFeedHQConnection* self,
                                                  const gchar* path,
                                                  const gchar* type,
                                                  const gchar* message_string,
                                                  FeedReaderResponse* result);
static void feed_reader_feed_hq_connection_finalize (FeedReaderFeedHQConnection * obj);
static void feed_reader_feedhq_message_finalize (FeedReaderfeedhqMessage * obj);

static inline gpointer
feed_reader_feed_hq_connection_get_instance_private (FeedReaderFeedHQConnection* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeedHQConnection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderFeedHQConnection*
feed_reader_feed_hq_connection_construct (GType object_type,
                                          FeedReaderFeedHQUtils* utils)
{
	FeedReaderFeedHQConnection* self = NULL;
	FeedReaderFeedHQUtils* _tmp0_;
	FeedReaderFeedHQUtils* _tmp1_;
	gchar* _tmp2_;
	FeedReaderFeedHQUtils* _tmp3_;
	gchar* _tmp4_;
	FeedReaderFeedHQUtils* _tmp5_;
	gchar* _tmp6_;
	SoupSession* _tmp7_;
	SoupSession* _tmp8_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderFeedHQConnection*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feed_hq_utils_getUser (_tmp1_);
	_g_free0 (self->priv->m_username);
	self->priv->m_username = _tmp2_;
	_tmp3_ = self->priv->m_utils;
	_tmp4_ = feed_reader_feed_hq_utils_getAccessToken (_tmp3_);
	_g_free0 (self->priv->m_api_code);
	self->priv->m_api_code = _tmp4_;
	_tmp5_ = self->priv->m_utils;
	_tmp6_ = feed_reader_feed_hq_utils_getPasswd (_tmp5_);
	_g_free0 (self->priv->m_passwd);
	self->priv->m_passwd = _tmp6_;
	_tmp7_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp7_;
	_tmp8_ = self->priv->m_session;
	g_object_set (_tmp8_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	return self;
}

FeedReaderFeedHQConnection*
feed_reader_feed_hq_connection_new (FeedReaderFeedHQUtils* utils)
{
	return feed_reader_feed_hq_connection_construct (FEED_READER_TYPE_FEED_HQ_CONNECTION, utils);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

FeedReaderLoginResponse
feed_reader_feed_hq_connection_getToken (FeedReaderFeedHQConnection* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp5_;
	gchar* message_string = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	SoupMessage* _tmp14_;
	const gchar* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_ = 0;
	guint8* _tmp18_;
	gint _tmp18__length1;
	SoupSession* _tmp19_;
	SoupMessage* _tmp20_;
	gchar* response = NULL;
	SoupMessage* _tmp21_;
	SoupMessageBody* _tmp22_;
	SoupBuffer* _tmp23_;
	SoupBuffer* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_logger_debug ("FeedHQ Connection: getToken()");
	_tmp1_ = self->priv->m_username;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->m_passwd;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FEED_READER_LOGIN_RESPONSE_ALL_EMPTY;
		return result;
	}
	_tmp3_ = self->priv->m_username;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_USER;
		return result;
	}
	_tmp4_ = self->priv->m_passwd;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_PASSWD;
		return result;
	}
	_tmp5_ = soup_message_new ("POST", "https://feedhq.org/accounts/ClientLogin");
	message = _tmp5_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = g_strconcat ("Email=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "&Passwd=", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->m_passwd;
	_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	message_string = _tmp13_;
	_tmp14_ = message;
	_tmp15_ = message_string;
	_tmp16_ = string_get_data (_tmp15_, &_tmp17_);
	_tmp16__length1 = _tmp17_;
	_tmp18_ = _tmp16_;
	_tmp18__length1 = _tmp16__length1;
	soup_message_set_request (_tmp14_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp18_, (gsize) _tmp18__length1);
	_tmp19_ = self->priv->m_session;
	_tmp20_ = message;
	soup_session_send_message (_tmp19_, _tmp20_);
	_tmp21_ = message;
	_tmp22_ = _tmp21_->response_body;
	_tmp23_ = soup_message_body_flatten (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->data;
	_tmp25__length1 = _tmp24_->length;
	_tmp26_ = g_strdup ((const gchar*) _tmp25_);
	_tmp27_ = _tmp26_;
	__vala_SoupBuffer_free0 (_tmp24_);
	response = _tmp27_;
	{
		GRegex* regex = NULL;
		GRegex* _tmp28_;
		GRegex* _tmp29_;
		const gchar* _tmp30_;
		_tmp28_ = g_regex_new (".*\\w\\s.*\\w\\sAuth=", 0, 0, &_inner_error0_);
		regex = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp29_ = regex;
		_tmp30_ = response;
		if (g_regex_match (_tmp29_, _tmp30_, 0, NULL)) {
			gchar* split = NULL;
			GRegex* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			FeedReaderFeedHQUtils* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp31_ = regex;
			_tmp32_ = response;
			_tmp33_ = g_regex_replace (_tmp31_, _tmp32_, (gssize) -1, 0, "", 0, &_inner_error0_);
			split = _tmp33_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_regex_unref0 (regex);
				goto __catch0_g_error;
			}
			_tmp34_ = split;
			_tmp35_ = g_strconcat ("FeedHQ Authcode : ", _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			feed_reader_logger_debug (_tmp36_);
			_g_free0 (_tmp36_);
			_tmp37_ = self->priv->m_utils;
			_tmp38_ = split;
			_tmp39_ = string_strip (_tmp38_);
			_tmp40_ = _tmp39_;
			feed_reader_feed_hq_utils_setAccessToken (_tmp37_, _tmp40_);
			_g_free0 (_tmp40_);
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			_g_free0 (split);
			_g_regex_unref0 (regex);
			_g_free0 (response);
			_g_free0 (message_string);
			_g_object_unref0 (message);
			return result;
		} else {
			const gchar* _tmp41_;
			_tmp41_ = response;
			feed_reader_logger_debug (_tmp41_);
			result = FEED_READER_LOGIN_RESPONSE_WRONG_LOGIN;
			_g_regex_unref0 (regex);
			_g_free0 (response);
			_g_free0 (message_string);
			_g_object_unref0 (message);
			return result;
		}
		_g_regex_unref0 (regex);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("FeedHQConnection - getToken: Could not load message response");
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		feed_reader_logger_error (_tmp43_);
		result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
		_g_error_free0 (e);
		_g_free0 (response);
		_g_free0 (message_string);
		_g_object_unref0 (message);
		return result;
	}
	__finally0:
	_g_free0 (response);
	_g_free0 (message_string);
	_g_object_unref0 (message);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return 0;
}

gboolean
feed_reader_feed_hq_connection_postToken (FeedReaderFeedHQConnection* self)
{
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	gchar* oldauth = NULL;
	FeedReaderFeedHQUtils* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessageHeaders* _tmp7_;
	const gchar* _tmp8_;
	SoupSession* _tmp9_;
	SoupMessage* _tmp10_;
	SoupMessage* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gchar* response = NULL;
	SoupMessage* _tmp14_;
	SoupMessageBody* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	FeedReaderFeedHQUtils* _tmp21_;
	const gchar* _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	feed_reader_logger_debug ("FeedHQ Connection: postToken()");
	_tmp0_ = soup_message_new ("GET", FEED_READER_FEED_HQ_SECRET_base_uri "token?output=json");
	message = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feed_hq_utils_getAccessToken (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("GoogleLogin auth=", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	oldauth = _tmp5_;
	_tmp6_ = message;
	_tmp7_ = _tmp6_->request_headers;
	_tmp8_ = oldauth;
	soup_message_headers_append (_tmp7_, "Authorization", _tmp8_);
	_tmp9_ = self->priv->m_session;
	_tmp10_ = message;
	soup_session_send_message (_tmp9_, _tmp10_);
	_tmp11_ = message;
	g_object_get (_tmp11_, "status-code", &_tmp12_, NULL);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != ((guint) 200)) {
		feed_reader_logger_debug ("FeedHQ post token failed");
		result = FALSE;
		_g_free0 (oldauth);
		_g_object_unref0 (message);
		return result;
	}
	_tmp14_ = message;
	_tmp15_ = _tmp14_->response_body;
	_tmp16_ = _tmp15_->data;
	_tmp16__length1 = _tmp15_->length;
	_tmp17_ = g_strdup ((const gchar*) _tmp16_);
	response = _tmp17_;
	_tmp18_ = response;
	_tmp19_ = g_strconcat ("FeedHQ post token : ", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	feed_reader_logger_debug (_tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->m_utils;
	_tmp22_ = response;
	feed_reader_feed_hq_utils_setPostToken (_tmp21_, _tmp22_);
	result = TRUE;
	_g_free0 (response);
	_g_free0 (oldauth);
	_g_object_unref0 (message);
	return result;
}

void
feed_reader_feed_hq_connection_send_get_request (FeedReaderFeedHQConnection* self,
                                                 const gchar* path,
                                                 const gchar* message_string,
                                                 FeedReaderResponse* result)
{
	FeedReaderResponse _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	feed_reader_feed_hq_connection_send_request (self, path, "GET", message_string, &_tmp0_);
	*result = _tmp0_;
	return;
}

void
feed_reader_feed_hq_connection_send_post_request (FeedReaderFeedHQConnection* self,
                                                  const gchar* path,
                                                  const gchar* message_string,
                                                  FeedReaderResponse* result)
{
	FeedReaderResponse _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	feed_reader_feed_hq_connection_send_request (self, path, "POST", message_string, &_tmp0_);
	*result = _tmp0_;
	return;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
feed_reader_feed_hq_connection_send_request (FeedReaderFeedHQConnection* self,
                                             const gchar* path,
                                             const gchar* type,
                                             const gchar* message_string,
                                             FeedReaderResponse* result)
{
	SoupMessage* message = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	gchar* oldauth = NULL;
	FeedReaderFeedHQUtils* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	SoupMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	const gchar* _tmp11_;
	gchar* message_string_post = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FeedReaderFeedHQUtils* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	SoupSession* _tmp24_;
	SoupMessage* _tmp25_;
	SoupMessage* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	SoupMessage* _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	SoupMessage* _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	SoupMessage* _tmp39_;
	SoupMessageBody* _tmp40_;
	SoupBuffer* _tmp41_;
	SoupBuffer* _tmp42_;
	guint8* _tmp43_;
	gint _tmp43__length1;
	gchar* _tmp44_;
	FeedReaderResponse _tmp45_ = {0};
	FeedReaderResponse _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = g_strconcat (FEED_READER_FEED_HQ_SECRET_base_uri, path, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new (type, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message = _tmp3_;
	_tmp4_ = self->priv->m_utils;
	_tmp5_ = feed_reader_feed_hq_utils_getAccessToken (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("GoogleLogin auth=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	oldauth = _tmp8_;
	_tmp9_ = message;
	_tmp10_ = _tmp9_->request_headers;
	_tmp11_ = oldauth;
	soup_message_headers_append (_tmp10_, "Authorization", _tmp11_);
	_tmp12_ = g_strconcat (message_string, "&T=", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->m_utils;
	_tmp15_ = feed_reader_feed_hq_utils_getPostToken (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	message_string_post = _tmp18_;
	if (message_string != NULL) {
		SoupMessage* _tmp19_;
		const gchar* _tmp20_;
		guint8* _tmp21_;
		gint _tmp21__length1;
		gint _tmp22_ = 0;
		guint8* _tmp23_;
		gint _tmp23__length1;
		_tmp19_ = message;
		_tmp20_ = message_string_post;
		_tmp21_ = string_get_data (_tmp20_, &_tmp22_);
		_tmp21__length1 = _tmp22_;
		_tmp23_ = _tmp21_;
		_tmp23__length1 = _tmp21__length1;
		soup_message_set_request (_tmp19_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp23_, (gsize) _tmp23__length1);
	}
	_tmp24_ = self->priv->m_session;
	_tmp25_ = message;
	soup_session_send_message (_tmp24_, _tmp25_);
	_tmp26_ = message;
	g_object_get (_tmp26_, "status-code", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != ((guint) 200)) {
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp29_ = string_to_string (message_string);
		_tmp30_ = g_strconcat ("feedHQConnection: message unexpected response - ", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		feed_reader_logger_warning (_tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = message;
	g_object_get (_tmp32_, "status-code", &_tmp33_, NULL);
	_tmp34_ = _tmp33_;
	if (((guint) _tmp34_) == ((guint) 401)) {
		FeedReaderResponse _tmp35_ = {0};
		feed_reader_logger_debug ("FeedHQ Post Token Expired");
		feed_reader_feed_hq_connection_postToken (self);
		feed_reader_feed_hq_connection_send_request (self, path, type, message_string, &_tmp35_);
		*result = _tmp35_;
		_g_free0 (message_string_post);
		_g_free0 (oldauth);
		_g_object_unref0 (message);
		return;
	}
	_tmp36_ = message;
	g_object_get (_tmp36_, "status-code", &_tmp37_, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = message;
	_tmp40_ = _tmp39_->response_body;
	_tmp41_ = soup_message_body_flatten (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_->data;
	_tmp43__length1 = _tmp42_->length;
	_tmp44_ = g_strdup ((const gchar*) _tmp43_);
	memset (&_tmp45_, 0, sizeof (FeedReaderResponse));
	_tmp45_.status = _tmp38_;
	_g_free0 (_tmp45_.data);
	_tmp45_.data = _tmp44_;
	_tmp46_ = _tmp45_;
	__vala_SoupBuffer_free0 (_tmp42_);
	*result = _tmp46_;
	_g_free0 (message_string_post);
	_g_free0 (oldauth);
	_g_object_unref0 (message);
	return;
}

static void
feed_reader_value_feed_hq_connection_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
feed_reader_value_feed_hq_connection_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		feed_reader_feed_hq_connection_unref (value->data[0].v_pointer);
	}
}

static void
feed_reader_value_feed_hq_connection_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = feed_reader_feed_hq_connection_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
feed_reader_value_feed_hq_connection_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
feed_reader_value_feed_hq_connection_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FeedReaderFeedHQConnection * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = feed_reader_feed_hq_connection_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
feed_reader_value_feed_hq_connection_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	FeedReaderFeedHQConnection ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = feed_reader_feed_hq_connection_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
feed_reader_param_spec_feed_hq_connection (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	FeedReaderParamSpecFeedHQConnection* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FEED_READER_TYPE_FEED_HQ_CONNECTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
feed_reader_value_get_feed_hq_connection (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEED_HQ_CONNECTION), NULL);
	return value->data[0].v_pointer;
}

void
feed_reader_value_set_feed_hq_connection (GValue* value,
                                          gpointer v_object)
{
	FeedReaderFeedHQConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEED_HQ_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FEED_HQ_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		feed_reader_feed_hq_connection_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_feed_hq_connection_unref (old);
	}
}

void
feed_reader_value_take_feed_hq_connection (GValue* value,
                                           gpointer v_object)
{
	FeedReaderFeedHQConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEED_HQ_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FEED_HQ_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_feed_hq_connection_unref (old);
	}
}

static void
feed_reader_feed_hq_connection_class_init (FeedReaderFeedHQConnectionClass * klass,
                                           gpointer klass_data)
{
	feed_reader_feed_hq_connection_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderFeedHQConnectionClass *) klass)->finalize = feed_reader_feed_hq_connection_finalize;
	g_type_class_adjust_private_offset (klass, &FeedReaderFeedHQConnection_private_offset);
}

static void
feed_reader_feed_hq_connection_instance_init (FeedReaderFeedHQConnection * self,
                                              gpointer klass)
{
	self->priv = feed_reader_feed_hq_connection_get_instance_private (self);
	self->ref_count = 1;
}

static void
feed_reader_feed_hq_connection_finalize (FeedReaderFeedHQConnection * obj)
{
	FeedReaderFeedHQConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEED_HQ_CONNECTION, FeedReaderFeedHQConnection);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->m_username);
	_g_free0 (self->priv->m_api_code);
	_g_free0 (self->priv->m_passwd);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_session);
}

GType
feed_reader_feed_hq_connection_get_type (void)
{
	return feed_reader_feed_hq_connection_type_id;
}

GType
feed_reader_feed_hq_connection_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { feed_reader_value_feed_hq_connection_init, feed_reader_value_feed_hq_connection_free_value, feed_reader_value_feed_hq_connection_copy_value, feed_reader_value_feed_hq_connection_peek_pointer, "p", feed_reader_value_feed_hq_connection_collect_value, "p", feed_reader_value_feed_hq_connection_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedHQConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feed_hq_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedHQConnection), 0, (GInstanceInitFunc) feed_reader_feed_hq_connection_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	feed_reader_feed_hq_connection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FeedReaderFeedHQConnection", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FeedReaderFeedHQConnection_private_offset = sizeof (FeedReaderFeedHQConnectionPrivate);
	return feed_reader_feed_hq_connection_type_id;
}

gpointer
feed_reader_feed_hq_connection_ref (gpointer instance)
{
	FeedReaderFeedHQConnection * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
feed_reader_feed_hq_connection_unref (gpointer instance)
{
	FeedReaderFeedHQConnection * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FEED_READER_FEED_HQ_CONNECTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
feed_reader_feedhq_message_get_instance_private (FeedReaderfeedhqMessage* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderfeedhqMessage_private_offset);
}

FeedReaderfeedhqMessage*
feed_reader_feedhq_message_construct (GType object_type)
{
	FeedReaderfeedhqMessage* self = NULL;
	self = (FeedReaderfeedhqMessage*) g_type_create_instance (object_type);
	return self;
}

FeedReaderfeedhqMessage*
feed_reader_feedhq_message_new (void)
{
	return feed_reader_feedhq_message_construct (FEED_READER_TYPE_FEEDHQ_MESSAGE);
}

void
feed_reader_feedhq_message_add (FeedReaderfeedhqMessage* self,
                                const gchar* parameter,
                                const gchar* val)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->request;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->request;
		_tmp2_ = g_strconcat (_tmp1_, "&", NULL);
		_g_free0 (self->priv->request);
		self->priv->request = _tmp2_;
	}
	_tmp3_ = self->priv->request;
	_tmp4_ = g_strconcat (_tmp3_, parameter, NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp4_;
	_tmp5_ = self->priv->request;
	_tmp6_ = g_strconcat (_tmp5_, "=", NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp6_;
	_tmp7_ = self->priv->request;
	_tmp8_ = g_uri_escape_string (val, NULL, TRUE);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp10_;
	_g_free0 (_tmp9_);
}

gchar*
feed_reader_feedhq_message_get (FeedReaderfeedhqMessage* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->request;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
feed_reader_value_feedhq_message_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
feed_reader_value_feedhq_message_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		feed_reader_feedhq_message_unref (value->data[0].v_pointer);
	}
}

static void
feed_reader_value_feedhq_message_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = feed_reader_feedhq_message_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
feed_reader_value_feedhq_message_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
feed_reader_value_feedhq_message_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FeedReaderfeedhqMessage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = feed_reader_feedhq_message_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
feed_reader_value_feedhq_message_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	FeedReaderfeedhqMessage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = feed_reader_feedhq_message_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
feed_reader_param_spec_feedhq_message (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	FeedReaderParamSpecfeedhqMessage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FEED_READER_TYPE_FEEDHQ_MESSAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
feed_reader_value_get_feedhq_message (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEEDHQ_MESSAGE), NULL);
	return value->data[0].v_pointer;
}

void
feed_reader_value_set_feedhq_message (GValue* value,
                                      gpointer v_object)
{
	FeedReaderfeedhqMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEEDHQ_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FEEDHQ_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		feed_reader_feedhq_message_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_feedhq_message_unref (old);
	}
}

void
feed_reader_value_take_feedhq_message (GValue* value,
                                       gpointer v_object)
{
	FeedReaderfeedhqMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEEDHQ_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FEEDHQ_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_feedhq_message_unref (old);
	}
}

static void
feed_reader_feedhq_message_class_init (FeedReaderfeedhqMessageClass * klass,
                                       gpointer klass_data)
{
	feed_reader_feedhq_message_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderfeedhqMessageClass *) klass)->finalize = feed_reader_feedhq_message_finalize;
	g_type_class_adjust_private_offset (klass, &FeedReaderfeedhqMessage_private_offset);
}

static void
feed_reader_feedhq_message_instance_init (FeedReaderfeedhqMessage * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = feed_reader_feedhq_message_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->request = _tmp0_;
	self->ref_count = 1;
}

static void
feed_reader_feedhq_message_finalize (FeedReaderfeedhqMessage * obj)
{
	FeedReaderfeedhqMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEEDHQ_MESSAGE, FeedReaderfeedhqMessage);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->request);
}

GType
feed_reader_feedhq_message_get_type (void)
{
	return feed_reader_feedhq_message_type_id;
}

GType
feed_reader_feedhq_message_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { feed_reader_value_feedhq_message_init, feed_reader_value_feedhq_message_free_value, feed_reader_value_feedhq_message_copy_value, feed_reader_value_feedhq_message_peek_pointer, "p", feed_reader_value_feedhq_message_collect_value, "p", feed_reader_value_feedhq_message_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderfeedhqMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feedhq_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderfeedhqMessage), 0, (GInstanceInitFunc) feed_reader_feedhq_message_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	feed_reader_feedhq_message_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FeedReaderfeedhqMessage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FeedReaderfeedhqMessage_private_offset = sizeof (FeedReaderfeedhqMessagePrivate);
	return feed_reader_feedhq_message_type_id;
}

gpointer
feed_reader_feedhq_message_ref (gpointer instance)
{
	FeedReaderfeedhqMessage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
feed_reader_feedhq_message_unref (gpointer instance)
{
	FeedReaderfeedhqMessage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FEED_READER_FEEDHQ_MESSAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

