/* feedhqInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from feedhqInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "feedhq.h"
#include <gtk/gtk.h>
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

enum  {
	FEED_READER_FEED_HQ_INTERFACE_0_PROPERTY,
	FEED_READER_FEED_HQ_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feed_hq_interface_properties[FEED_READER_FEED_HQ_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderFeedHQInterfacePrivate {
	FeedReaderFeedHQAPI* m_api;
	FeedReaderFeedHQUtils* m_utils;
	GtkEntry* m_userEntry;
	GtkEntry* m_passwordEntry;
};

static gint FeedReaderFeedHQInterface_private_offset;
static gpointer feed_reader_feed_hq_interface_parent_class = NULL;
static GType feed_reader_feed_hq_interface_type_id = 0;

static void feed_reader_feed_hq_interface_real_init (FeedReaderFeedServerInterface* base,
                                              GSettingsBackend* settings_backend,
                                              SecretCollection* secrets);
static gchar* feed_reader_feed_hq_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_feed_hq_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feed_hq_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feed_hq_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feed_hq_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static GtkBox* feed_reader_feed_hq_interface_real_getWidget (FeedReaderFeedServerInterface* base);
static void __lambda5_ (FeedReaderFeedHQInterface* self);
static void ___lambda5__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda6_ (FeedReaderFeedHQInterface* self);
static void ___lambda6__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda7_ (FeedReaderFeedHQInterface* self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void feed_reader_feed_hq_interface_real_writeData (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feed_hq_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feed_hq_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feed_hq_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feed_hq_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                   const gchar* cadID);
static gboolean feed_reader_feed_hq_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_feed_hq_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_feed_hq_interface_real_login (FeedReaderFeedServerInterface* base);
static void feed_reader_feed_hq_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                          const gchar* articleIDs,
                                                          FeedReaderArticleStatus read);
static void feed_reader_feed_hq_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                            const gchar* articleID,
                                                            FeedReaderArticleStatus marked);
static gboolean feed_reader_feed_hq_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_feed_hq_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                     const gchar* feedID);
static void feed_reader_feed_hq_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                         const gchar* catID);
static void feed_reader_feed_hq_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_feed_hq_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                    const gchar* articleID,
                                                    const gchar* tagID);
static void feed_reader_feed_hq_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                          const gchar* articleID,
                                                          const gchar* tagID);
static gchar* feed_reader_feed_hq_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                     const gchar* caption);
static void feed_reader_feed_hq_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* tagID);
static void feed_reader_feed_hq_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* tagID,
                                                   const gchar* title);
static gboolean feed_reader_feed_hq_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feed_hq_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                     const gchar* feedURL,
                                                     const gchar* catID,
                                                     const gchar* newCatName,
                                                     gchar** feedID,
                                                     gchar** errmsg);
static void feed_reader_feed_hq_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feedID);
static void feed_reader_feed_hq_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feedID,
                                                    const gchar* title);
static void feed_reader_feed_hq_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID,
                                                  const gchar* newCatID,
                                                  const gchar* currentCatID);
static gchar* feed_reader_feed_hq_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                          const gchar* title,
                                                          const gchar* parentID);
static void feed_reader_feed_hq_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                        const gchar* catID,
                                                        const gchar* title);
static void feed_reader_feed_hq_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID,
                                                      const gchar* newParentID);
static void feed_reader_feed_hq_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                        const gchar* catID);
static void feed_reader_feed_hq_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                           const gchar* feedID,
                                                           const gchar* catID);
static void feed_reader_feed_hq_interface_real_importOPML (FeedReaderFeedServerInterface* base,
                                                    const gchar* opml);
static gboolean feed_reader_feed_hq_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                             GeeList* feeds,
                                                             GeeList* categories,
                                                             GeeList* tags,
                                                             GCancellable* cancellable);
static gint feed_reader_feed_hq_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_feed_hq_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                     gint count,
                                                     FeedReaderArticleStatus whatToGet,
                                                     GDateTime* since,
                                                     const gchar* feedID,
                                                     gboolean isTagID,
                                                     GCancellable* cancellable);
static void feed_reader_feed_hq_interface_finalize (GObject * obj);
GType feed_reader_feed_hqapi_register_type (GTypeModule * module);
GType feed_reader_feed_hq_utils_register_type (GTypeModule * module);
GType feed_reader_feed_hq_connection_register_type (GTypeModule * module);
GType feed_reader_feedhq_message_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
feed_reader_feed_hq_interface_get_instance_private (FeedReaderFeedHQInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeedHQInterface_private_offset);
}

static void
feed_reader_feed_hq_interface_real_init (FeedReaderFeedServerInterface* base,
                                         GSettingsBackend* settings_backend,
                                         SecretCollection* secrets)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQUtils* _tmp0_;
	FeedReaderFeedHQUtils* _tmp1_;
	FeedReaderFeedHQAPI* _tmp2_;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_feed_hq_utils_new (settings_backend, secrets);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feed_hqapi_new (_tmp1_);
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp2_;
}

static gchar*
feed_reader_feed_hq_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = g_strdup ("https://feedhq.org/");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_feed_hq_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderFeedHQInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_HOSTED | FEED_READER_BACKEND_FLAGS_FREE_SOFTWARE) | FEED_READER_BACKEND_FLAGS_PAID;
	return result;
}

static gchar*
feed_reader_feed_hq_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = g_strdup ("feedhq");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feed_hq_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = g_strdup ("feed-service-feedhq");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feed_hq_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = g_strdup ("FeedHQ");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = FALSE;
	return result;
}

static void
__lambda5_ (FeedReaderFeedHQInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda5__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda5_ ((FeedReaderFeedHQInterface*) self);
}

static void
__lambda6_ (FeedReaderFeedHQInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda6__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda6_ ((FeedReaderFeedHQInterface*) self);
}

static void
__lambda7_ (FeedReaderFeedHQInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ ((FeedReaderFeedHQInterface*) self);
}

static GtkBox*
feed_reader_feed_hq_interface_real_getWidget (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	GtkLabel* user_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* password_label = NULL;
	GtkLabel* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkImage* logo = NULL;
	GtkImage* _tmp11_;
	GtkLabel* loginLabel = NULL;
	GtkLabel* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkButton* loginButton = NULL;
	GtkButton* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkBox* box = NULL;
	GtkBox* _tmp16_;
	GtkEntry* _tmp17_;
	FeedReaderFeedHQUtils* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkEntry* _tmp21_;
	FeedReaderFeedHQUtils* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkBox* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp0_);
	user_label = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp1_);
	password_label = _tmp1_;
	gtk_misc_set_alignment ((GtkMisc*) user_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) password_label, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) user_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) password_label, TRUE);
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->m_userEntry);
	self->priv->m_userEntry = _tmp2_;
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->m_passwordEntry);
	self->priv->m_passwordEntry = _tmp3_;
	_tmp4_ = self->priv->m_userEntry;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda5__gtk_entry_activate, self, 0);
	_tmp5_ = self->priv->m_passwordEntry;
	g_signal_connect_object (_tmp5_, "activate", (GCallback) ___lambda6__gtk_entry_activate, self, 0);
	_tmp6_ = self->priv->m_passwordEntry;
	gtk_entry_set_invisible_char (_tmp6_, (gunichar) '*');
	_tmp7_ = self->priv->m_passwordEntry;
	gtk_entry_set_visibility (_tmp7_, FALSE);
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp8_);
	grid = _tmp8_;
	gtk_grid_set_column_spacing (grid, (guint) 10);
	gtk_grid_set_row_spacing (grid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_grid_attach (grid, (GtkWidget*) user_label, 0, 0, 1, 1);
	_tmp9_ = self->priv->m_userEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp9_, 1, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) password_label, 0, 1, 1, 1);
	_tmp10_ = self->priv->m_passwordEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp10_, 1, 1, 1, 1);
	_tmp11_ = (GtkImage*) gtk_image_new_from_icon_name ("feed-service-feedhq", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp11_);
	logo = _tmp11_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_ ("Please log in to FeedHQ and enjoy using FeedReader"));
	g_object_ref_sink (_tmp12_);
	loginLabel = _tmp12_;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) loginLabel);
	gtk_style_context_add_class (_tmp13_, "h2");
	gtk_label_set_justify (loginLabel, GTK_JUSTIFY_CENTER);
	gtk_label_set_lines (loginLabel, 3);
	_tmp14_ = (GtkButton*) gtk_button_new_with_label (_ ("Login"));
	g_object_ref_sink (_tmp14_);
	loginButton = _tmp14_;
	gtk_widget_set_halign ((GtkWidget*) loginButton, GTK_ALIGN_END);
	gtk_widget_set_size_request ((GtkWidget*) loginButton, 80, 30);
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) loginButton);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_object (loginButton, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp16_);
	box = _tmp16_;
	gtk_widget_set_valign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_box_pack_start (box, (GtkWidget*) loginLabel, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) logo, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) grid, TRUE, TRUE, (guint) 10);
	gtk_box_pack_end (box, (GtkWidget*) loginButton, FALSE, FALSE, (guint) 20);
	_tmp17_ = self->priv->m_userEntry;
	_tmp18_ = self->priv->m_utils;
	_tmp19_ = feed_reader_feed_hq_utils_getUser (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_entry_set_text (_tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->m_passwordEntry;
	_tmp22_ = self->priv->m_utils;
	_tmp23_ = feed_reader_feed_hq_utils_getPasswd (_tmp22_);
	_tmp24_ = _tmp23_;
	gtk_entry_set_text (_tmp21_, _tmp24_);
	_g_free0 (_tmp24_);
	result = box;
	_g_object_unref0 (loginButton);
	_g_object_unref0 (loginLabel);
	_g_object_unref0 (logo);
	_g_object_unref0 (grid);
	_g_object_unref0 (password_label);
	_g_object_unref0 (user_label);
	return result;
}

static void
feed_reader_feed_hq_interface_real_writeData (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQUtils* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	FeedReaderFeedHQUtils* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = self->priv->m_userEntry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	feed_reader_feed_hq_utils_setUser (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->m_utils;
	_tmp4_ = self->priv->m_passwordEntry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	feed_reader_feed_hq_utils_setPassword (_tmp3_, _tmp5_);
}

static gboolean
feed_reader_feed_hq_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = TRUE;
	return result;
}

static gchar*
feed_reader_feed_hq_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = g_strdup ("feed-service-feedhq-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feed_hq_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_feed_hq_utils_getUser (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_feed_hq_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = g_strdup ("FeedHQ.org");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feed_hq_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                          const gchar* cadID)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_val_if_fail (cadID != NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = TRUE;
	return result;
}

static void
feed_reader_feed_hq_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQUtils* _tmp0_;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = self->priv->m_utils;
	feed_reader_feed_hq_utils_resetAccount (_tmp0_);
}

static gboolean
feed_reader_feed_hq_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = TRUE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_feed_hq_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	FeedReaderLoginResponse result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_feed_hqapi_login (_tmp0_);
	return result;
}

static void
feed_reader_feed_hq_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                     const gchar* articleIDs,
                                                     FeedReaderArticleStatus read)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (articleIDs != NULL);
	if (read == FEED_READER_ARTICLE_STATUS_READ) {
		FeedReaderFeedHQAPI* _tmp0_;
		_tmp0_ = self->priv->m_api;
		feed_reader_feed_hqapi_edidTag (_tmp0_, articleIDs, "user/-/state/com.google/read", TRUE);
	} else {
		FeedReaderFeedHQAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feed_reader_feed_hqapi_edidTag (_tmp1_, articleIDs, "user/-/state/com.google/read", FALSE);
	}
}

static void
feed_reader_feed_hq_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                       const gchar* articleID,
                                                       FeedReaderArticleStatus marked)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (articleID != NULL);
	if (marked == FEED_READER_ARTICLE_STATUS_MARKED) {
		FeedReaderFeedHQAPI* _tmp0_;
		_tmp0_ = self->priv->m_api;
		feed_reader_feed_hqapi_edidTag (_tmp0_, articleID, "user/-/state/com.google/starred", TRUE);
	} else {
		FeedReaderFeedHQAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feed_reader_feed_hqapi_edidTag (_tmp1_, articleID, "user/-/state/com.google/starred", FALSE);
	}
}

static gboolean
feed_reader_feed_hq_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_feed_hq_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                const gchar* feedID)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feed_hqapi_markAsRead (_tmp0_, feedID);
}

static void
feed_reader_feed_hq_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                    const gchar* catID)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feed_hqapi_markAsRead (_tmp0_, catID);
}

static void
feed_reader_feed_hq_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	GeeList* categories = NULL;
	FeedReaderDataBaseReadOnly* _tmp1_;
	GeeList* _tmp2_;
	GeeList* feeds = NULL;
	FeedReaderDataBaseReadOnly* _tmp15_;
	GeeList* _tmp16_;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = feed_reader_data_base_readOnly ();
	db = _tmp0_;
	_tmp1_ = db;
	_tmp2_ = feed_reader_data_base_read_only_read_categories (_tmp1_, NULL);
	categories = _tmp2_;
	{
		GeeList* _cat_list = NULL;
		GeeList* _tmp3_;
		gint _cat_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _cat_index = 0;
		_tmp3_ = categories;
		_cat_list = _tmp3_;
		_tmp4_ = _cat_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_cat_size = _tmp6_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			FeedReaderCategory* cat = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			FeedReaderFeedHQAPI* _tmp11_;
			FeedReaderCategory* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_cat_index = _cat_index + 1;
			_tmp7_ = _cat_index;
			_tmp8_ = _cat_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _cat_list;
			_tmp10_ = gee_list_get (_tmp9_, _cat_index);
			cat = (FeedReaderCategory*) _tmp10_;
			_tmp11_ = self->priv->m_api;
			_tmp12_ = cat;
			_tmp13_ = feed_reader_category_getCatID (_tmp12_);
			_tmp14_ = _tmp13_;
			feed_reader_feed_hqapi_markAsRead (_tmp11_, _tmp14_);
			_g_free0 (_tmp14_);
			_g_object_unref0 (cat);
		}
	}
	_tmp15_ = db;
	_tmp16_ = feed_reader_data_base_read_only_read_feeds_without_cat (_tmp15_);
	feeds = _tmp16_;
	{
		GeeList* _feed_list = NULL;
		GeeList* _tmp17_;
		gint _feed_size = 0;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _feed_index = 0;
		_tmp17_ = feeds;
		_feed_list = _tmp17_;
		_tmp18_ = _feed_list;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_feed_size = _tmp20_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			FeedReaderFeed* feed = NULL;
			GeeList* _tmp23_;
			gpointer _tmp24_;
			FeedReaderFeedHQAPI* _tmp25_;
			FeedReaderFeed* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_feed_index = _feed_index + 1;
			_tmp21_ = _feed_index;
			_tmp22_ = _feed_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _feed_list;
			_tmp24_ = gee_list_get (_tmp23_, _feed_index);
			feed = (FeedReaderFeed*) _tmp24_;
			_tmp25_ = self->priv->m_api;
			_tmp26_ = feed;
			_tmp27_ = feed_reader_feed_getFeedID (_tmp26_);
			_tmp28_ = _tmp27_;
			feed_reader_feed_hqapi_markAsRead (_tmp25_, _tmp28_);
			_g_free0 (_tmp28_);
			_g_object_unref0 (feed);
		}
	}
	_g_object_unref0 (feeds);
	_g_object_unref0 (categories);
	_g_object_unref0 (db);
}

static void
feed_reader_feed_hq_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                               const gchar* articleID,
                                               const gchar* tagID)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static void
feed_reader_feed_hq_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                     const gchar* articleID,
                                                     const gchar* tagID)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static gchar*
feed_reader_feed_hq_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                              const gchar* caption)
{
	FeedReaderFeedHQInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = g_strdup (":(");
	result = _tmp0_;
	return result;
}

static void
feed_reader_feed_hq_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                              const gchar* tagID)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (tagID != NULL);
	return;
}

static void
feed_reader_feed_hq_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                              const gchar* tagID,
                                              const gchar* title)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	return;
}

static gboolean
feed_reader_feed_hq_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_feed_hqapi_ping (_tmp0_);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
feed_reader_feed_hq_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                            const gchar* feedURL,
                                            const gchar* catID,
                                            const gchar* newCatName,
                                            gchar** feedID,
                                            gchar** errmsg)
{
	FeedReaderFeedHQInterface * self;
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	gchar* _tmp0_;
	gboolean success = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_val_if_fail (feedURL != NULL, FALSE);
	_tmp0_ = g_strconcat ("feed/", feedURL, NULL);
	_g_free0 (_vala_feedID);
	_vala_feedID = _tmp0_;
	success = FALSE;
	if (catID == NULL) {
		_tmp1_ = newCatName != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* newCatID = NULL;
		FeedReaderFeedHQAPI* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		FeedReaderFeedHQAPI* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp2_ = self->priv->m_api;
		_tmp3_ = feed_reader_feed_hqapi_composeTagID (_tmp2_, newCatName);
		newCatID = _tmp3_;
		_tmp4_ = newCatID;
		feed_reader_logger_debug (_tmp4_);
		_tmp5_ = self->priv->m_api;
		_tmp6_ = g_strconcat ("feed/", feedURL, NULL);
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		_tmp7_[0] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 1;
		_tmp9_ = newCatID;
		success = feed_reader_feed_hqapi_editSubscription (_tmp5_, FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_SUBSCRIBE, _tmp8_, (gint) 1, NULL, _tmp9_, NULL);
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (newCatID);
	} else {
		FeedReaderFeedHQAPI* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp10_ = self->priv->m_api;
		_tmp11_ = g_strconcat ("feed/", feedURL, NULL);
		_tmp12_ = g_new0 (gchar*, 1 + 1);
		_tmp12_[0] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 1;
		success = feed_reader_feed_hqapi_editSubscription (_tmp10_, FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_SUBSCRIBE, _tmp13_, (gint) 1, NULL, catID, NULL);
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	}
	if (!success) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = string_to_string (feedURL);
		_tmp15_ = g_strconcat ("feedHQ could not subscribe to ", _tmp14_, NULL);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp15_;
	} else {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("");
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp16_;
	}
	result = success;
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
feed_reader_feed_hq_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                               const gchar* feedID)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_feed_hqapi_editSubscription (_tmp0_, FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_UNSUBSCRIBE, _tmp3_, (gint) 1, NULL, NULL, NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
feed_reader_feed_hq_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                               const gchar* feedID,
                                               const gchar* title)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_feed_hqapi_editSubscription (_tmp0_, FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_EDIT, _tmp3_, (gint) 1, title, NULL, NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
feed_reader_feed_hq_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feedID,
                                             const gchar* newCatID,
                                             const gchar* currentCatID)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_feed_hqapi_editSubscription (_tmp0_, FEED_READER_FEED_HQAPI_FEED_HQ_SUBSCRIPTION_ACTION_EDIT, _tmp3_, (gint) 1, NULL, newCatID, currentCatID);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
feed_reader_feed_hq_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                   const gchar* title,
                                                   const gchar* parentID)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = feed_reader_feed_hqapi_composeTagID (_tmp0_, title);
	result = _tmp1_;
	return result;
}

static void
feed_reader_feed_hq_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                   const gchar* catID,
                                                   const gchar* title)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feed_hqapi_renameTag (_tmp0_, catID, title);
}

static void
feed_reader_feed_hq_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* catID,
                                                 const gchar* newParentID)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	return;
}

static void
feed_reader_feed_hq_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                   const gchar* catID)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feed_hqapi_deleteTag (_tmp0_, catID);
}

static void
feed_reader_feed_hq_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                      const gchar* feedID,
                                                      const gchar* catID)
{
	FeedReaderFeedHQInterface * self;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	return;
}

static void
feed_reader_feed_hq_interface_real_importOPML (FeedReaderFeedServerInterface* base,
                                               const gchar* opml)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_if_fail (opml != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feed_hqapi_import (_tmp0_, opml);
}

static gboolean
feed_reader_feed_hq_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                    GeeList* feeds,
                                                    GeeList* categories,
                                                    GeeList* tags,
                                                    GCancellable* cancellable)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderFeedHQInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_api;
	if (feed_reader_feed_hqapi_getFeeds (_tmp0_, feeds)) {
		gboolean _tmp1_ = FALSE;
		FeedReaderFeedHQAPI* _tmp2_;
		if (cancellable != NULL) {
			_tmp1_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = self->priv->m_api;
		if (feed_reader_feed_hqapi_getCategoriesAndTags (_tmp2_, feeds, categories, tags)) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gint
feed_reader_feed_hq_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderFeedHQInterface * self;
	FeedReaderFeedHQAPI* _tmp0_;
	gint result;
	self = (FeedReaderFeedHQInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_feed_hqapi_getTotalUnread (_tmp0_);
	return result;
}

static void
feed_reader_feed_hq_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                gint count,
                                                FeedReaderArticleStatus whatToGet,
                                                GDateTime* since,
                                                const gchar* feedID,
                                                gboolean isTagID,
                                                GCancellable* cancellable)
{
	FeedReaderFeedHQInterface * self;
	GeeLinkedList* articles = NULL;
	GeeLinkedList* _tmp11_;
	gchar* continuation = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* FeedHQ_feedID = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* FeedHQ_tagID = NULL;
	gchar* _tmp15_;
	GeeLinkedList* _tmp25_;
	self = (FeedReaderFeedHQInterface*) base;
	if (whatToGet == FEED_READER_ARTICLE_STATUS_READ) {
		return;
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_ALL) {
			GeeLinkedList* unreadIDs = NULL;
			GeeLinkedList* _tmp0_;
			gchar* continuation = NULL;
			FeedReaderDataBase* _tmp8_;
			FeedReaderDataBase* _tmp9_;
			GeeLinkedList* _tmp10_;
			_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
			unreadIDs = _tmp0_;
			continuation = NULL;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp3_ = FALSE;
					FeedReaderFeedHQAPI* _tmp4_;
					GeeLinkedList* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					if (!_tmp1_) {
						const gchar* _tmp2_;
						_tmp2_ = continuation;
						if (!(_tmp2_ != NULL)) {
							break;
						}
					}
					_tmp1_ = FALSE;
					if (cancellable != NULL) {
						_tmp3_ = g_cancellable_is_cancelled (cancellable);
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						_g_free0 (continuation);
						_g_object_unref0 (unreadIDs);
						return;
					}
					_tmp4_ = self->priv->m_api;
					_tmp5_ = unreadIDs;
					_tmp6_ = continuation;
					_tmp7_ = feed_reader_feed_hqapi_updateArticles (_tmp4_, (GeeList*) _tmp5_, 1000, _tmp6_);
					_g_free0 (continuation);
					continuation = _tmp7_;
				}
			}
			_tmp8_ = feed_reader_data_base_writeAccess ();
			_tmp9_ = _tmp8_;
			_tmp10_ = unreadIDs;
			feed_reader_data_base_updateArticlesByID (_tmp9_, (GeeList*) _tmp10_, "unread");
			_g_object_unref0 (_tmp9_);
			_g_free0 (continuation);
			_g_object_unref0 (unreadIDs);
		}
	}
	_tmp11_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp11_;
	continuation = NULL;
	if (isTagID) {
		_tmp12_ = NULL;
	} else {
		_tmp12_ = feedID;
	}
	_tmp13_ = g_strdup (_tmp12_);
	FeedHQ_feedID = _tmp13_;
	if (isTagID) {
		_tmp14_ = feedID;
	} else {
		_tmp14_ = NULL;
	}
	_tmp15_ = g_strdup (_tmp14_);
	FeedHQ_tagID = _tmp15_;
	{
		gboolean _tmp16_ = FALSE;
		_tmp16_ = TRUE;
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			FeedReaderFeedHQAPI* _tmp19_;
			GeeLinkedList* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			if (!_tmp16_) {
				const gchar* _tmp17_;
				_tmp17_ = continuation;
				if (!(_tmp17_ != NULL)) {
					break;
				}
			}
			_tmp16_ = FALSE;
			if (cancellable != NULL) {
				_tmp18_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				_g_free0 (FeedHQ_tagID);
				_g_free0 (FeedHQ_feedID);
				_g_free0 (continuation);
				_g_object_unref0 (articles);
				return;
			}
			_tmp19_ = self->priv->m_api;
			_tmp20_ = articles;
			_tmp21_ = continuation;
			_tmp22_ = FeedHQ_tagID;
			_tmp23_ = FeedHQ_feedID;
			_tmp24_ = feed_reader_feed_hqapi_getArticles (_tmp19_, (GeeList*) _tmp20_, count, whatToGet, _tmp21_, _tmp22_, _tmp23_);
			_g_free0 (continuation);
			continuation = _tmp24_;
		}
	}
	_tmp25_ = articles;
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "write-articles", (GeeList*) _tmp25_);
	_g_free0 (FeedHQ_tagID);
	_g_free0 (FeedHQ_feedID);
	_g_free0 (continuation);
	_g_object_unref0 (articles);
}

FeedReaderFeedHQInterface*
feed_reader_feed_hq_interface_construct (GType object_type)
{
	FeedReaderFeedHQInterface * self = NULL;
	self = (FeedReaderFeedHQInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderFeedHQInterface*
feed_reader_feed_hq_interface_new (void)
{
	return feed_reader_feed_hq_interface_construct (FEED_READER_TYPE_FEED_HQ_INTERFACE);
}

static void
feed_reader_feed_hq_interface_class_init (FeedReaderFeedHQInterfaceClass * klass,
                                          gpointer klass_data)
{
	feed_reader_feed_hq_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderFeedHQInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_feed_hq_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWidget = (GtkBox* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_getWidget;
	((FeedReaderFeedServerInterfaceClass *) klass)->writeData = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_writeData;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feed_hq_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feed_hq_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_feed_hq_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feed_hq_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->importOPML = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feed_hq_interface_real_importOPML;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_feed_hq_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_feed_hq_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_feed_hq_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_feed_hq_interface_finalize;
}

static void
feed_reader_feed_hq_interface_instance_init (FeedReaderFeedHQInterface * self,
                                             gpointer klass)
{
	self->priv = feed_reader_feed_hq_interface_get_instance_private (self);
}

static void
feed_reader_feed_hq_interface_finalize (GObject * obj)
{
	FeedReaderFeedHQInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEED_HQ_INTERFACE, FeedReaderFeedHQInterface);
	_g_object_unref0 (self->priv->m_api);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_userEntry);
	_g_object_unref0 (self->priv->m_passwordEntry);
	G_OBJECT_CLASS (feed_reader_feed_hq_interface_parent_class)->finalize (obj);
}

GType
feed_reader_feed_hq_interface_get_type (void)
{
	return feed_reader_feed_hq_interface_type_id;
}

GType
feed_reader_feed_hq_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedHQInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feed_hq_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedHQInterface), 0, (GInstanceInitFunc) feed_reader_feed_hq_interface_instance_init, NULL };
	feed_reader_feed_hq_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderFeedHQInterface", &g_define_type_info, 0);
	FeedReaderFeedHQInterface_private_offset = sizeof (FeedReaderFeedHQInterfacePrivate);
	return feed_reader_feed_hq_interface_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_feed_hqapi_register_type (module);
	feed_reader_feed_hq_interface_register_type (module);
	feed_reader_feed_hq_utils_register_type (module);
	feed_reader_feed_hq_connection_register_type (module);
	feed_reader_feedhq_message_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_FEED_HQ_INTERFACE);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

