/* feedlyAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from feedlyAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "feedly.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <json-glib/json-glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <gee.h>

enum  {
	FEED_READER_FEEDLY_API_0_PROPERTY,
	FEED_READER_FEEDLY_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feedly_api_properties[FEED_READER_FEEDLY_API_NUM_PROPERTIES];
#define _feed_reader_feedly_connection_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_feedly_connection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

struct _FeedReaderFeedlyAPIPrivate {
	FeedReaderFeedlyConnection* m_connection;
	gchar* m_userID;
	JsonArray* m_unreadcounts;
	FeedReaderFeedlyUtils* m_utils;
};

static gint FeedReaderFeedlyAPI_private_offset;
static gpointer feed_reader_feedly_api_parent_class = NULL;
static GType feed_reader_feedly_api_type_id = 0;

static FeedReaderConnectionError feed_reader_feedly_api_tokenStillValid (FeedReaderFeedlyAPI* self);
static gboolean feed_reader_feedly_api_getUserID (FeedReaderFeedlyAPI* self);
static gint feed_reader_feedly_api_getUnreadCountforID (FeedReaderFeedlyAPI* self,
                                                 const gchar* id);
static void _vala_JsonNode_free (JsonNode* self);
static void feed_reader_feedly_api_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
feed_reader_feedly_api_get_instance_private (FeedReaderFeedlyAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeedlyAPI_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderFeedlyAPI*
feed_reader_feedly_api_construct (GType object_type,
                                  FeedReaderFeedlyUtils* utils)
{
	FeedReaderFeedlyAPI * self = NULL;
	FeedReaderFeedlyUtils* _tmp0_;
	FeedReaderFeedlyUtils* _tmp1_;
	FeedReaderFeedlyConnection* _tmp2_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderFeedlyAPI*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feedly_connection_new (_tmp1_);
	_feed_reader_feedly_connection_unref0 (self->priv->m_connection);
	self->priv->m_connection = _tmp2_;
	return self;
}

FeedReaderFeedlyAPI*
feed_reader_feedly_api_new (FeedReaderFeedlyUtils* utils)
{
	return feed_reader_feedly_api_construct (FEED_READER_TYPE_FEEDLY_API, utils);
}

gchar*
feed_reader_feedly_api_createCatID (FeedReaderFeedlyAPI* self,
                                    const gchar* title)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strdup_printf ("user/%s/category/%s", _tmp0_, title);
	result = _tmp1_;
	return result;
}

gchar*
feed_reader_feedly_api_getMarkedID (FeedReaderFeedlyAPI* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strconcat ("user/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/tag/global.saved", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

FeedReaderLoginResponse
feed_reader_feedly_api_login (FeedReaderFeedlyAPI* self)
{
	FeedReaderFeedlyUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	FeedReaderFeedlyUtils* _tmp6_;
	FeedReaderFeedlyUtils* _tmp7_;
	FeedReaderFeedlyUtils* _tmp8_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_logger_debug ("feedly backend: login");
	if (!feed_reader_utils_ping ("http://feedly.com/")) {
		result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
		return result;
	}
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_feedly_utils_getRefreshToken (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		FeedReaderFeedlyConnection* _tmp4_;
		_tmp4_ = self->priv->m_connection;
		feed_reader_feedly_connection_getToken (_tmp4_);
	}
	if (feed_reader_feedly_api_tokenStillValid (self) == FEED_READER_CONNECTION_ERROR_INVALID_SESSIONID) {
		FeedReaderFeedlyConnection* _tmp5_;
		feed_reader_logger_debug ("refresh token");
		_tmp5_ = self->priv->m_connection;
		feed_reader_feedly_connection_refreshToken (_tmp5_);
	}
	if (feed_reader_feedly_api_getUserID (self)) {
		feed_reader_logger_debug ("feedly: login success");
		result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
		return result;
	}
	_tmp6_ = self->priv->m_utils;
	feed_reader_feedly_utils_setAccessToken (_tmp6_, "");
	_tmp7_ = self->priv->m_utils;
	feed_reader_feedly_utils_setRefreshToken (_tmp7_, "");
	_tmp8_ = self->priv->m_utils;
	feed_reader_feedly_utils_setApiCode (_tmp8_, "");
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
feed_reader_feedly_api_getUserID (FeedReaderFeedlyAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonObject* _tmp14_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_get_request_to_feedly (_tmp0_, "/v3/profile/", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getUserID: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	if (json_object_has_member (_tmp14_, "id")) {
		JsonObject* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		JsonObject* _tmp21_;
		_tmp15_ = root;
		_tmp16_ = json_object_get_string_member (_tmp15_, "id");
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (self->priv->m_userID);
		self->priv->m_userID = _tmp17_;
		_tmp18_ = self->priv->m_userID;
		_tmp19_ = g_strconcat ("feedly: userID = ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		feed_reader_logger_info (_tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = root;
		if (json_object_has_member (_tmp21_, "email")) {
			FeedReaderFeedlyUtils* _tmp22_;
			JsonObject* _tmp23_;
			const gchar* _tmp24_;
			_tmp22_ = self->priv->m_utils;
			_tmp23_ = root;
			_tmp24_ = json_object_get_string_member (_tmp23_, "email");
			feed_reader_feedly_utils_setEmail (_tmp22_, _tmp24_);
		} else {
			JsonObject* _tmp25_;
			_tmp25_ = root;
			if (json_object_has_member (_tmp25_, "givenName")) {
				FeedReaderFeedlyUtils* _tmp26_;
				JsonObject* _tmp27_;
				const gchar* _tmp28_;
				_tmp26_ = self->priv->m_utils;
				_tmp27_ = root;
				_tmp28_ = json_object_get_string_member (_tmp27_, "givenName");
				feed_reader_feedly_utils_setEmail (_tmp26_, _tmp28_);
			} else {
				JsonObject* _tmp29_;
				_tmp29_ = root;
				if (json_object_has_member (_tmp29_, "fullName")) {
					FeedReaderFeedlyUtils* _tmp30_;
					JsonObject* _tmp31_;
					const gchar* _tmp32_;
					_tmp30_ = self->priv->m_utils;
					_tmp31_ = root;
					_tmp32_ = json_object_get_string_member (_tmp31_, "fullName");
					feed_reader_feedly_utils_setEmail (_tmp30_, _tmp32_);
				} else {
					JsonObject* _tmp33_;
					_tmp33_ = root;
					if (json_object_has_member (_tmp33_, "google")) {
						FeedReaderFeedlyUtils* _tmp34_;
						JsonObject* _tmp35_;
						const gchar* _tmp36_;
						_tmp34_ = self->priv->m_utils;
						_tmp35_ = root;
						_tmp36_ = json_object_get_string_member (_tmp35_, "google");
						feed_reader_feedly_utils_setEmail (_tmp34_, _tmp36_);
					} else {
						JsonObject* _tmp37_;
						_tmp37_ = root;
						if (json_object_has_member (_tmp37_, "reader")) {
							FeedReaderFeedlyUtils* _tmp38_;
							JsonObject* _tmp39_;
							const gchar* _tmp40_;
							_tmp38_ = self->priv->m_utils;
							_tmp39_ = root;
							_tmp40_ = json_object_get_string_member (_tmp39_, "reader");
							feed_reader_feedly_utils_setEmail (_tmp38_, _tmp40_);
						} else {
							JsonObject* _tmp41_;
							_tmp41_ = root;
							if (json_object_has_member (_tmp41_, "twitterUserId")) {
								FeedReaderFeedlyUtils* _tmp42_;
								JsonObject* _tmp43_;
								const gchar* _tmp44_;
								_tmp42_ = self->priv->m_utils;
								_tmp43_ = root;
								_tmp44_ = json_object_get_string_member (_tmp43_, "twitterUserId");
								feed_reader_feedly_utils_setEmail (_tmp42_, _tmp44_);
							} else {
								JsonObject* _tmp45_;
								_tmp45_ = root;
								if (json_object_has_member (_tmp45_, "facebookUserId")) {
									FeedReaderFeedlyUtils* _tmp46_;
									JsonObject* _tmp47_;
									const gchar* _tmp48_;
									_tmp46_ = self->priv->m_utils;
									_tmp47_ = root;
									_tmp48_ = json_object_get_string_member (_tmp47_, "facebookUserId");
									feed_reader_feedly_utils_setEmail (_tmp46_, _tmp48_);
								} else {
									JsonObject* _tmp49_;
									_tmp49_ = root;
									if (json_object_has_member (_tmp49_, "wordPressId")) {
										FeedReaderFeedlyUtils* _tmp50_;
										JsonObject* _tmp51_;
										const gchar* _tmp52_;
										_tmp50_ = self->priv->m_utils;
										_tmp51_ = root;
										_tmp52_ = json_object_get_string_member (_tmp51_, "wordPressId");
										feed_reader_feedly_utils_setEmail (_tmp50_, _tmp52_);
									} else {
										JsonObject* _tmp53_;
										_tmp53_ = root;
										if (json_object_has_member (_tmp53_, "windowsLiveId")) {
											FeedReaderFeedlyUtils* _tmp54_;
											JsonObject* _tmp55_;
											const gchar* _tmp56_;
											_tmp54_ = self->priv->m_utils;
											_tmp55_ = root;
											_tmp56_ = json_object_get_string_member (_tmp55_, "windowsLiveId");
											feed_reader_feedly_utils_setEmail (_tmp54_, _tmp56_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		result = TRUE;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	result = FALSE;
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static FeedReaderConnectionError
feed_reader_feedly_api_tokenStillValid (FeedReaderFeedlyAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp9_;
	JsonNode* _tmp10_;
	JsonObject* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	GError* _inner_error0_ = NULL;
	FeedReaderConnectionError result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_get_request_to_feedly (_tmp0_, "/v3/profile/", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FEED_READER_CONNECTION_ERROR_NO_RESPONSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("tokenStillValid: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FEED_READER_CONNECTION_ERROR_NO_RESPONSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp9_ = parser;
	_tmp10_ = json_parser_get_root (_tmp9_);
	_tmp11_ = json_node_get_object (_tmp10_);
	_tmp12_ = _json_object_ref0 (_tmp11_);
	root = _tmp12_;
	_tmp13_ = root;
	if (json_object_has_member (_tmp13_, "errorId")) {
		result = FEED_READER_CONNECTION_ERROR_INVALID_SESSIONID;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	result = FEED_READER_CONNECTION_ERROR_SUCCESS;
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

gboolean
feed_reader_feedly_api_getCategories (FeedReaderFeedlyAPI* self,
                                      GeeList* categories)
{
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonArray* array = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_get_request_to_feedly (_tmp0_, "/v3/categories/", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getCategories: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_array (_tmp11_);
	_tmp13_ = _json_array_ref0 (_tmp12_);
	array = _tmp13_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp16_;
				JsonObject* object = NULL;
				JsonArray* _tmp17_;
				JsonObject* _tmp18_;
				JsonObject* _tmp19_;
				gchar* categorieID = NULL;
				JsonObject* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				const gchar* _tmp26_;
				JsonObject* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				FeedReaderCategory* _tmp32_;
				FeedReaderCategory* _tmp33_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp16_))) {
					break;
				}
				_tmp17_ = array;
				_tmp18_ = json_array_get_object_element (_tmp17_, (guint) i);
				_tmp19_ = _json_object_ref0 (_tmp18_);
				object = _tmp19_;
				_tmp20_ = object;
				_tmp21_ = json_object_get_string_member (_tmp20_, "id");
				_tmp22_ = g_strdup (_tmp21_);
				categorieID = _tmp22_;
				_tmp24_ = categorieID;
				if (g_str_has_suffix (_tmp24_, "global.all")) {
					_tmp23_ = TRUE;
				} else {
					const gchar* _tmp25_;
					_tmp25_ = categorieID;
					_tmp23_ = g_str_has_suffix (_tmp25_, "global.uncategorized");
				}
				if (_tmp23_) {
					_g_free0 (categorieID);
					_json_object_unref0 (object);
					continue;
				}
				_tmp26_ = categorieID;
				_tmp27_ = object;
				_tmp28_ = json_object_get_string_member (_tmp27_, "label");
				_tmp29_ = categorieID;
				_tmp30_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
				_tmp31_ = _tmp30_;
				_tmp32_ = feed_reader_category_new (_tmp26_, _tmp28_, (guint) feed_reader_feedly_api_getUnreadCountforID (self, _tmp29_), i + 1, _tmp31_, 1);
				_tmp33_ = _tmp32_;
				gee_collection_add ((GeeCollection*) categories, _tmp33_);
				_g_object_unref0 (_tmp33_);
				_g_free0 (_tmp31_);
				_g_free0 (categorieID);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

gboolean
feed_reader_feedly_api_getFeeds (FeedReaderFeedlyAPI* self,
                                 GeeList* feeds)
{
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonArray* array = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	guint length = 0U;
	JsonArray* _tmp14_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_get_request_to_feedly (_tmp0_, "/v3/subscriptions/", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getFeeds: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_array (_tmp11_);
	_tmp13_ = _json_array_ref0 (_tmp12_);
	array = _tmp13_;
	_tmp14_ = array;
	length = json_array_get_length (_tmp14_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp17_;
				JsonObject* _tmp18_;
				JsonObject* _tmp19_;
				gchar* feedID = NULL;
				JsonObject* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* icon_url = NULL;
				JsonObject* _tmp23_;
				guint catCount = 0U;
				JsonObject* _tmp31_;
				JsonArray* _tmp32_;
				GeeArrayList* categories = NULL;
				GeeArrayList* _tmp33_;
				const gchar* _tmp46_;
				JsonObject* _tmp47_;
				const gchar* _tmp48_;
				JsonObject* _tmp49_;
				const gchar* _tmp50_;
				JsonObject* _tmp51_;
				const gchar* _tmp52_;
				GeeArrayList* _tmp53_;
				const gchar* _tmp54_;
				FeedReaderFeed* _tmp55_;
				FeedReaderFeed* _tmp56_;
				if (!_tmp15_) {
					guint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp17_ = array;
				_tmp18_ = json_array_get_object_element (_tmp17_, i);
				_tmp19_ = _json_object_ref0 (_tmp18_);
				object = _tmp19_;
				_tmp20_ = object;
				_tmp21_ = json_object_get_string_member (_tmp20_, "id");
				_tmp22_ = g_strdup (_tmp21_);
				feedID = _tmp22_;
				icon_url = NULL;
				_tmp23_ = object;
				if (json_object_has_member (_tmp23_, "iconUrl")) {
					JsonObject* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp24_ = object;
					_tmp25_ = json_object_get_string_member (_tmp24_, "iconUrl");
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (icon_url);
					icon_url = _tmp26_;
				} else {
					JsonObject* _tmp27_;
					_tmp27_ = object;
					if (json_object_has_member (_tmp27_, "visualUrl")) {
						JsonObject* _tmp28_;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						_tmp28_ = object;
						_tmp29_ = json_object_get_string_member (_tmp28_, "visualUrl");
						_tmp30_ = g_strdup (_tmp29_);
						_g_free0 (icon_url);
						icon_url = _tmp30_;
					}
				}
				_tmp31_ = object;
				_tmp32_ = json_object_get_array_member (_tmp31_, "categories");
				catCount = json_array_get_length (_tmp32_);
				_tmp33_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				categories = _tmp33_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp34_ = FALSE;
						_tmp34_ = TRUE;
						while (TRUE) {
							gchar* categoryID = NULL;
							JsonObject* _tmp36_;
							JsonArray* _tmp37_;
							JsonObject* _tmp38_;
							const gchar* _tmp39_;
							gchar* _tmp40_;
							gboolean _tmp41_ = FALSE;
							const gchar* _tmp42_;
							GeeArrayList* _tmp44_;
							const gchar* _tmp45_;
							if (!_tmp34_) {
								guint _tmp35_;
								j = j + 1;
								_tmp35_ = j;
							}
							_tmp34_ = FALSE;
							if (!(j < catCount)) {
								break;
							}
							_tmp36_ = object;
							_tmp37_ = json_object_get_array_member (_tmp36_, "categories");
							_tmp38_ = json_array_get_object_element (_tmp37_, j);
							_tmp39_ = json_object_get_string_member (_tmp38_, "id");
							_tmp40_ = g_strdup (_tmp39_);
							categoryID = _tmp40_;
							_tmp42_ = categoryID;
							if (g_str_has_suffix (_tmp42_, "global.all")) {
								_tmp41_ = TRUE;
							} else {
								const gchar* _tmp43_;
								_tmp43_ = categoryID;
								_tmp41_ = g_str_has_suffix (_tmp43_, "global.uncategorized");
							}
							if (_tmp41_) {
								_g_free0 (categoryID);
								continue;
							}
							_tmp44_ = categories;
							_tmp45_ = categoryID;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
							_g_free0 (categoryID);
						}
					}
				}
				_tmp46_ = feedID;
				_tmp47_ = object;
				_tmp48_ = json_object_get_string_member (_tmp47_, "title");
				_tmp49_ = object;
				_tmp50_ = json_object_get_string_member (_tmp49_, "website");
				_tmp51_ = object;
				_tmp52_ = json_object_get_string_member (_tmp51_, "id");
				_tmp53_ = categories;
				_tmp54_ = icon_url;
				_tmp55_ = feed_reader_feed_new (_tmp46_, _tmp48_, _tmp50_, (guint) feed_reader_feedly_api_getUnreadCountforID (self, _tmp52_), (GeeList*) _tmp53_, _tmp54_, NULL);
				_tmp56_ = _tmp55_;
				gee_collection_add ((GeeCollection*) feeds, _tmp56_);
				_g_object_unref0 (_tmp56_);
				_g_object_unref0 (categories);
				_g_free0 (icon_url);
				_g_free0 (feedID);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

gboolean
feed_reader_feedly_api_getTags (FeedReaderFeedlyAPI* self,
                                GeeList* tags)
{
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonArray* array = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	guint length = 0U;
	JsonArray* _tmp14_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp15_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_get_request_to_feedly (_tmp0_, "/v3/tags/", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTags: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_array (_tmp11_);
	_tmp13_ = _json_array_ref0 (_tmp12_);
	array = _tmp13_;
	_tmp14_ = array;
	length = json_array_get_length (_tmp14_);
	_tmp15_ = feed_reader_data_base_readOnly ();
	db = _tmp15_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp18_;
				JsonObject* _tmp19_;
				JsonObject* _tmp20_;
				const gchar* _tmp21_ = NULL;
				JsonObject* _tmp22_;
				JsonObject* _tmp25_;
				const gchar* _tmp26_;
				FeedReaderDataBaseReadOnly* _tmp27_;
				FeedReaderTag* _tmp28_;
				FeedReaderTag* _tmp29_;
				if (!_tmp16_) {
					guint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp18_ = array;
				_tmp19_ = json_array_get_object_element (_tmp18_, i);
				_tmp20_ = _json_object_ref0 (_tmp19_);
				object = _tmp20_;
				_tmp22_ = object;
				if (json_object_has_member (_tmp22_, "label")) {
					JsonObject* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = object;
					_tmp24_ = json_object_get_string_member (_tmp23_, "label");
					_tmp21_ = _tmp24_;
				} else {
					_tmp21_ = "";
				}
				_tmp25_ = object;
				_tmp26_ = json_object_get_string_member (_tmp25_, "id");
				_tmp27_ = db;
				_tmp28_ = feed_reader_tag_new (_tmp26_, _tmp21_, feed_reader_data_base_read_only_getTagColor (_tmp27_));
				_tmp29_ = _tmp28_;
				gee_collection_add ((GeeCollection*) tags, _tmp29_);
				_g_object_unref0 (_tmp29_);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (db);
	_json_array_unref0 (array);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
feed_reader_feedly_api_getArticles (FeedReaderFeedlyAPI* self,
                                    GeeList* articles,
                                    gint count,
                                    const gchar* continuation,
                                    FeedReaderArticleStatus whatToGet,
                                    const gchar* tagID,
                                    const gchar* feed_id)
{
	gchar* steamID = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* onlyUnread = NULL;
	gchar* _tmp5_;
	gchar* marked_tag = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp16_ = FALSE;
	JsonParser* parser = NULL;
	JsonParser* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* streamCall = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	FeedReaderResponse entry_id_response = {0};
	FeedReaderFeedlyConnection* _tmp23_;
	const gchar* _tmp24_;
	FeedReaderResponse _tmp25_ = {0};
	FeedReaderResponse _tmp26_;
	JsonObject* root = NULL;
	JsonParser* _tmp32_;
	JsonNode* _tmp33_;
	JsonObject* _tmp34_;
	JsonObject* _tmp35_;
	JsonObject* _tmp36_;
	gchar* cont = NULL;
	JsonObject* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp40_;
	FeedReaderResponse _tmp41_;
	const gchar* _tmp42_;
	FeedReaderResponse _tmp43_ = {0};
	FeedReaderResponse _tmp44_;
	JsonArray* array = NULL;
	JsonParser* _tmp50_;
	JsonNode* _tmp51_;
	JsonArray* _tmp52_;
	JsonArray* _tmp53_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articles != NULL, NULL);
	g_return_val_if_fail (tagID != NULL, NULL);
	g_return_val_if_fail (feed_id != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strconcat ("user/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/category/global.all", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	steamID = _tmp4_;
	_tmp5_ = g_strdup ("false");
	onlyUnread = _tmp5_;
	_tmp6_ = self->priv->m_userID;
	_tmp7_ = g_strconcat ("user/", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "/tag/global.saved", NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	marked_tag = _tmp10_;
	if (whatToGet == FEED_READER_ARTICLE_STATUS_MARKED) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = marked_tag;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (steamID);
		steamID = _tmp12_;
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_UNREAD) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("true");
			_g_free0 (onlyUnread);
			onlyUnread = _tmp13_;
		}
	}
	if (g_strcmp0 (tagID, "") != 0) {
		_tmp14_ = whatToGet == FEED_READER_ARTICLE_STATUS_ALL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (tagID);
		_g_free0 (steamID);
		steamID = _tmp15_;
	}
	if (g_strcmp0 (feed_id, "") != 0) {
		_tmp16_ = whatToGet == FEED_READER_ARTICLE_STATUS_ALL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gchar* _tmp17_;
		_tmp17_ = g_strdup (feed_id);
		_g_free0 (steamID);
		steamID = _tmp17_;
	}
	_tmp18_ = json_parser_new ();
	parser = _tmp18_;
	if (continuation == NULL) {
		_tmp19_ = "";
	} else {
		_tmp19_ = continuation;
	}
	_tmp20_ = steamID;
	_tmp21_ = onlyUnread;
	_tmp22_ = g_strdup_printf ("/v3/streams/ids?streamId=%s&unreadOnly=%s&count=%i&ranked=newest&conti" \
"nuation=%s", _tmp20_, _tmp21_, count, _tmp19_);
	streamCall = _tmp22_;
	_tmp23_ = self->priv->m_connection;
	_tmp24_ = streamCall;
	feed_reader_feedly_connection_send_get_request_to_feedly (_tmp23_, _tmp24_, &_tmp25_);
	entry_id_response = _tmp25_;
	_tmp26_ = entry_id_response;
	if (_tmp26_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&entry_id_response);
		_g_free0 (streamCall);
		_g_object_unref0 (parser);
		_g_free0 (marked_tag);
		_g_free0 (onlyUnread);
		_g_free0 (steamID);
		return result;
	}
	{
		JsonParser* _tmp27_;
		FeedReaderResponse _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = parser;
		_tmp28_ = entry_id_response;
		_tmp29_ = _tmp28_.data;
		json_parser_load_from_data (_tmp27_, _tmp29_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getArticles: Could not load message response");
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		feed_reader_logger_error (_tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		feed_reader_response_destroy (&entry_id_response);
		_g_free0 (streamCall);
		_g_object_unref0 (parser);
		_g_free0 (marked_tag);
		_g_free0 (onlyUnread);
		_g_free0 (steamID);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp32_ = parser;
	_tmp33_ = json_parser_get_root (_tmp32_);
	_tmp34_ = json_node_get_object (_tmp33_);
	_tmp35_ = _json_object_ref0 (_tmp34_);
	root = _tmp35_;
	_tmp36_ = root;
	if (!json_object_has_member (_tmp36_, "continuation")) {
		result = NULL;
		_json_object_unref0 (root);
		feed_reader_response_destroy (&entry_id_response);
		_g_free0 (streamCall);
		_g_object_unref0 (parser);
		_g_free0 (marked_tag);
		_g_free0 (onlyUnread);
		_g_free0 (steamID);
		return result;
	}
	_tmp37_ = root;
	_tmp38_ = json_object_get_string_member (_tmp37_, "continuation");
	_tmp39_ = g_strdup (_tmp38_);
	cont = _tmp39_;
	_tmp40_ = self->priv->m_connection;
	_tmp41_ = entry_id_response;
	_tmp42_ = _tmp41_.data;
	feed_reader_feedly_connection_send_post_string_request_to_feedly (_tmp40_, "/v3/entries/.mget", _tmp42_, "application/json", &_tmp43_);
	response = _tmp43_;
	_tmp44_ = response;
	if (_tmp44_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_g_free0 (cont);
		_json_object_unref0 (root);
		feed_reader_response_destroy (&entry_id_response);
		_g_free0 (streamCall);
		_g_object_unref0 (parser);
		_g_free0 (marked_tag);
		_g_free0 (onlyUnread);
		_g_free0 (steamID);
		return result;
	}
	{
		JsonParser* _tmp45_;
		FeedReaderResponse _tmp46_;
		const gchar* _tmp47_;
		_tmp45_ = parser;
		_tmp46_ = response;
		_tmp47_ = _tmp46_.data;
		json_parser_load_from_data (_tmp45_, _tmp47_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp48_;
		const gchar* _tmp49_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getArticles: Could not load message response");
		_tmp48_ = e;
		_tmp49_ = _tmp48_->message;
		feed_reader_logger_error (_tmp49_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		feed_reader_response_destroy (&response);
		_g_free0 (cont);
		_json_object_unref0 (root);
		feed_reader_response_destroy (&entry_id_response);
		_g_free0 (streamCall);
		_g_object_unref0 (parser);
		_g_free0 (marked_tag);
		_g_free0 (onlyUnread);
		_g_free0 (steamID);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp50_ = parser;
	_tmp51_ = json_parser_get_root (_tmp50_);
	_tmp52_ = json_node_get_array (_tmp51_);
	_tmp53_ = _json_array_ref0 (_tmp52_);
	array = _tmp53_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp54_ = FALSE;
			_tmp54_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp56_;
				JsonObject* object = NULL;
				JsonArray* _tmp57_;
				JsonObject* _tmp58_;
				JsonObject* _tmp59_;
				gchar* id = NULL;
				JsonObject* _tmp60_;
				const gchar* _tmp61_;
				gchar* _tmp62_;
				const gchar* _tmp63_ = NULL;
				JsonObject* _tmp64_;
				gchar* title = NULL;
				gchar* _tmp67_;
				const gchar* _tmp68_ = NULL;
				JsonObject* _tmp69_;
				gchar* author = NULL;
				gchar* _tmp72_;
				JsonObject* _tmp73_ = NULL;
				JsonObject* _tmp74_;
				JsonObject* summary = NULL;
				JsonObject* _tmp77_;
				const gchar* _tmp78_ = NULL;
				gboolean _tmp79_ = FALSE;
				JsonObject* _tmp80_;
				gchar* summaryContent = NULL;
				gchar* _tmp84_;
				JsonObject* _tmp85_ = NULL;
				JsonObject* _tmp86_;
				JsonObject* content_obj = NULL;
				JsonObject* _tmp89_;
				const gchar* _tmp90_ = NULL;
				gboolean _tmp91_ = FALSE;
				JsonObject* _tmp92_;
				gchar* content = NULL;
				gchar* _tmp97_;
				gboolean _tmp98_ = FALSE;
				JsonObject* _tmp99_;
				gboolean unread = FALSE;
				JsonArray* _tmp101_ = NULL;
				JsonObject* _tmp102_;
				JsonArray* alternate = NULL;
				JsonArray* _tmp105_;
				JsonObject* _tmp106_ = NULL;
				gboolean _tmp107_ = FALSE;
				JsonArray* _tmp108_;
				JsonObject* first_alternate = NULL;
				JsonObject* _tmp112_;
				const gchar* _tmp113_ = NULL;
				gboolean _tmp114_ = FALSE;
				JsonObject* _tmp115_;
				gchar* url = NULL;
				gchar* _tmp119_;
				const gchar* _tmp120_ = NULL;
				JsonObject* _tmp121_;
				gchar* feedID = NULL;
				gchar* _tmp125_;
				GDateTime* date = NULL;
				GDateTime* _tmp126_;
				gboolean _tmp127_ = FALSE;
				JsonObject* _tmp128_;
				FeedReaderArticleStatus marked = 0;
				GeeArrayList* tags = NULL;
				GeeArrayList* _tmp142_;
				JsonObject* _tmp143_;
				GeeArrayList* enclosures = NULL;
				GeeArrayList* _tmp159_;
				JsonObject* _tmp160_;
				FeedReaderArticleStatus _tmp179_ = 0;
				FeedReaderArticle* Article = NULL;
				const gchar* _tmp180_;
				const gchar* _tmp181_;
				const gchar* _tmp182_;
				const gchar* _tmp183_;
				const gchar* _tmp184_;
				const gchar* _tmp185_;
				GDateTime* _tmp186_;
				GeeArrayList* _tmp187_;
				GeeArrayList* _tmp188_;
				FeedReaderArticle* _tmp189_;
				FeedReaderArticle* _tmp190_;
				if (!_tmp54_) {
					gint _tmp55_;
					_tmp55_ = i;
					i = _tmp55_ + 1;
				}
				_tmp54_ = FALSE;
				_tmp56_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp56_))) {
					break;
				}
				_tmp57_ = array;
				_tmp58_ = json_array_get_object_element (_tmp57_, (guint) i);
				_tmp59_ = _json_object_ref0 (_tmp58_);
				object = _tmp59_;
				_tmp60_ = object;
				_tmp61_ = json_object_get_string_member (_tmp60_, "id");
				_tmp62_ = g_strdup (_tmp61_);
				id = _tmp62_;
				_tmp64_ = object;
				if (json_object_has_member (_tmp64_, "title")) {
					JsonObject* _tmp65_;
					const gchar* _tmp66_;
					_tmp65_ = object;
					_tmp66_ = json_object_get_string_member (_tmp65_, "title");
					_tmp63_ = _tmp66_;
				} else {
					_tmp63_ = NULL;
				}
				_tmp67_ = g_strdup (_tmp63_);
				title = _tmp67_;
				_tmp69_ = object;
				if (json_object_has_member (_tmp69_, "author")) {
					JsonObject* _tmp70_;
					const gchar* _tmp71_;
					_tmp70_ = object;
					_tmp71_ = json_object_get_string_member (_tmp70_, "author");
					_tmp68_ = _tmp71_;
				} else {
					_tmp68_ = NULL;
				}
				_tmp72_ = g_strdup (_tmp68_);
				author = _tmp72_;
				_tmp74_ = object;
				if (json_object_has_member (_tmp74_, "summary")) {
					JsonObject* _tmp75_;
					JsonObject* _tmp76_;
					_tmp75_ = object;
					_tmp76_ = json_object_get_object_member (_tmp75_, "summary");
					_tmp73_ = _tmp76_;
				} else {
					_tmp73_ = NULL;
				}
				_tmp77_ = _json_object_ref0 (_tmp73_);
				summary = _tmp77_;
				_tmp80_ = summary;
				if (_tmp80_ != NULL) {
					JsonObject* _tmp81_;
					_tmp81_ = summary;
					_tmp79_ = json_object_has_member (_tmp81_, "content");
				} else {
					_tmp79_ = FALSE;
				}
				if (_tmp79_) {
					JsonObject* _tmp82_;
					const gchar* _tmp83_;
					_tmp82_ = summary;
					_tmp83_ = json_object_get_string_member (_tmp82_, "content");
					_tmp78_ = _tmp83_;
				} else {
					_tmp78_ = NULL;
				}
				_tmp84_ = g_strdup (_tmp78_);
				summaryContent = _tmp84_;
				_tmp86_ = object;
				if (json_object_has_member (_tmp86_, "content")) {
					JsonObject* _tmp87_;
					JsonObject* _tmp88_;
					_tmp87_ = object;
					_tmp88_ = json_object_get_object_member (_tmp87_, "content");
					_tmp85_ = _tmp88_;
				} else {
					_tmp85_ = NULL;
				}
				_tmp89_ = _json_object_ref0 (_tmp85_);
				content_obj = _tmp89_;
				_tmp92_ = content_obj;
				if (_tmp92_ != NULL) {
					JsonObject* _tmp93_;
					_tmp93_ = content_obj;
					_tmp91_ = json_object_has_member (_tmp93_, "content");
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					JsonObject* _tmp94_;
					const gchar* _tmp95_;
					_tmp94_ = content_obj;
					_tmp95_ = json_object_get_string_member (_tmp94_, "content");
					_tmp90_ = _tmp95_;
				} else {
					const gchar* _tmp96_;
					_tmp96_ = summaryContent;
					_tmp90_ = _tmp96_;
				}
				_tmp97_ = g_strdup (_tmp90_);
				content = _tmp97_;
				_tmp99_ = object;
				if (json_object_has_member (_tmp99_, "unread")) {
					JsonObject* _tmp100_;
					_tmp100_ = object;
					_tmp98_ = json_object_get_boolean_member (_tmp100_, "unread");
				} else {
					_tmp98_ = FALSE;
				}
				unread = _tmp98_;
				_tmp102_ = object;
				if (json_object_has_member (_tmp102_, "alternate")) {
					JsonObject* _tmp103_;
					JsonArray* _tmp104_;
					_tmp103_ = object;
					_tmp104_ = json_object_get_array_member (_tmp103_, "alternate");
					_tmp101_ = _tmp104_;
				} else {
					_tmp101_ = NULL;
				}
				_tmp105_ = _json_array_ref0 (_tmp101_);
				alternate = _tmp105_;
				_tmp108_ = alternate;
				if (_tmp108_ != NULL) {
					JsonArray* _tmp109_;
					_tmp109_ = alternate;
					_tmp107_ = json_array_get_length (_tmp109_) >= ((guint) 1);
				} else {
					_tmp107_ = FALSE;
				}
				if (_tmp107_) {
					JsonArray* _tmp110_;
					JsonObject* _tmp111_;
					_tmp110_ = alternate;
					_tmp111_ = json_array_get_object_element (_tmp110_, (guint) 0);
					_tmp106_ = _tmp111_;
				} else {
					_tmp106_ = NULL;
				}
				_tmp112_ = _json_object_ref0 (_tmp106_);
				first_alternate = _tmp112_;
				_tmp115_ = first_alternate;
				if (_tmp115_ != NULL) {
					JsonObject* _tmp116_;
					_tmp116_ = first_alternate;
					_tmp114_ = json_object_has_member (_tmp116_, "href");
				} else {
					_tmp114_ = FALSE;
				}
				if (_tmp114_) {
					JsonObject* _tmp117_;
					const gchar* _tmp118_;
					_tmp117_ = first_alternate;
					_tmp118_ = json_object_get_string_member (_tmp117_, "href");
					_tmp113_ = _tmp118_;
				} else {
					_tmp113_ = NULL;
				}
				_tmp119_ = g_strdup (_tmp113_);
				url = _tmp119_;
				_tmp121_ = object;
				if (json_object_has_member (_tmp121_, "origin")) {
					JsonObject* _tmp122_;
					JsonObject* _tmp123_;
					const gchar* _tmp124_;
					_tmp122_ = object;
					_tmp123_ = json_object_get_object_member (_tmp122_, "origin");
					_tmp124_ = json_object_get_string_member (_tmp123_, "streamId");
					_tmp120_ = _tmp124_;
				} else {
					_tmp120_ = NULL;
				}
				_tmp125_ = g_strdup (_tmp120_);
				feedID = _tmp125_;
				_tmp126_ = g_date_time_new_now_local ();
				date = _tmp126_;
				_tmp128_ = object;
				if (json_object_has_member (_tmp128_, "updated")) {
					JsonObject* _tmp129_;
					_tmp129_ = object;
					_tmp127_ = json_object_get_int_member (_tmp129_, "updated") > ((gint64) 0);
				} else {
					_tmp127_ = FALSE;
				}
				if (_tmp127_) {
					JsonObject* _tmp130_;
					GDateTime* _tmp131_;
					_tmp130_ = object;
					_tmp131_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp130_, "updated") / 1000);
					_g_date_time_unref0 (date);
					date = _tmp131_;
				} else {
					gboolean _tmp132_ = FALSE;
					JsonObject* _tmp133_;
					_tmp133_ = object;
					if (json_object_has_member (_tmp133_, "published")) {
						JsonObject* _tmp134_;
						_tmp134_ = object;
						_tmp132_ = json_object_get_int_member (_tmp134_, "published") > ((gint64) 0);
					} else {
						_tmp132_ = FALSE;
					}
					if (_tmp132_) {
						JsonObject* _tmp135_;
						GDateTime* _tmp136_;
						_tmp135_ = object;
						_tmp136_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp135_, "published") / 1000);
						_g_date_time_unref0 (date);
						date = _tmp136_;
					} else {
						gboolean _tmp137_ = FALSE;
						JsonObject* _tmp138_;
						_tmp138_ = object;
						if (json_object_has_member (_tmp138_, "crawled")) {
							JsonObject* _tmp139_;
							_tmp139_ = object;
							_tmp137_ = json_object_get_int_member (_tmp139_, "crawled") > ((gint64) 0);
						} else {
							_tmp137_ = FALSE;
						}
						if (_tmp137_) {
							JsonObject* _tmp140_;
							GDateTime* _tmp141_;
							_tmp140_ = object;
							_tmp141_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp140_, "crawled") / 1000);
							_g_date_time_unref0 (date);
							date = _tmp141_;
						}
					}
				}
				marked = FEED_READER_ARTICLE_STATUS_UNMARKED;
				_tmp142_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				tags = _tmp142_;
				_tmp143_ = object;
				if (json_object_has_member (_tmp143_, "tags")) {
					JsonArray* tag_array = NULL;
					JsonObject* _tmp144_;
					JsonArray* _tmp145_;
					JsonArray* _tmp146_;
					guint tagCount = 0U;
					JsonArray* _tmp147_;
					_tmp144_ = object;
					_tmp145_ = json_object_get_array_member (_tmp144_, "tags");
					_tmp146_ = _json_array_ref0 (_tmp145_);
					tag_array = _tmp146_;
					_tmp147_ = tag_array;
					tagCount = json_array_get_length (_tmp147_);
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp148_ = FALSE;
							_tmp148_ = TRUE;
							while (TRUE) {
								gchar* tag = NULL;
								JsonArray* _tmp150_;
								JsonObject* _tmp151_;
								const gchar* _tmp152_;
								gchar* _tmp153_;
								const gchar* _tmp154_;
								const gchar* _tmp155_;
								if (!_tmp148_) {
									gint _tmp149_;
									j = j + 1;
									_tmp149_ = j;
								}
								_tmp148_ = FALSE;
								if (!(((guint) j) < tagCount)) {
									break;
								}
								_tmp150_ = tag_array;
								_tmp151_ = json_array_get_object_element (_tmp150_, (guint) j);
								_tmp152_ = json_object_get_string_member (_tmp151_, "id");
								_tmp153_ = g_strdup (_tmp152_);
								tag = _tmp153_;
								_tmp154_ = tag;
								_tmp155_ = marked_tag;
								if (g_strcmp0 (_tmp154_, _tmp155_) == 0) {
									marked = FEED_READER_ARTICLE_STATUS_MARKED;
								} else {
									const gchar* _tmp156_;
									_tmp156_ = tag;
									if (string_contains (_tmp156_, "global.")) {
										_g_free0 (tag);
										continue;
									} else {
										GeeArrayList* _tmp157_;
										const gchar* _tmp158_;
										_tmp157_ = tags;
										_tmp158_ = tag;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp157_, _tmp158_);
									}
								}
								_g_free0 (tag);
							}
						}
					}
					_json_array_unref0 (tag_array);
				}
				_tmp159_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				enclosures = _tmp159_;
				_tmp160_ = object;
				if (json_object_has_member (_tmp160_, "enclosure")) {
					JsonArray* attachments = NULL;
					JsonObject* _tmp161_;
					JsonArray* _tmp162_;
					JsonArray* _tmp163_;
					guint mediaCount = 0U;
					JsonArray* _tmp164_;
					_tmp161_ = object;
					_tmp162_ = json_object_get_array_member (_tmp161_, "enclosure");
					_tmp163_ = _json_array_ref0 (_tmp162_);
					attachments = _tmp163_;
					mediaCount = (guint) 0;
					_tmp164_ = attachments;
					if (_tmp164_ != NULL) {
						JsonArray* _tmp165_;
						_tmp165_ = attachments;
						mediaCount = json_array_get_length (_tmp165_);
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp166_ = FALSE;
							_tmp166_ = TRUE;
							while (TRUE) {
								JsonObject* attachment = NULL;
								JsonArray* _tmp168_;
								JsonObject* _tmp169_;
								JsonObject* _tmp170_;
								GeeArrayList* _tmp171_;
								const gchar* _tmp172_;
								JsonObject* _tmp173_;
								const gchar* _tmp174_;
								JsonObject* _tmp175_;
								const gchar* _tmp176_;
								FeedReaderEnclosure* _tmp177_;
								FeedReaderEnclosure* _tmp178_;
								if (!_tmp166_) {
									gint _tmp167_;
									j = j + 1;
									_tmp167_ = j;
								}
								_tmp166_ = FALSE;
								if (!(((guint) j) < mediaCount)) {
									break;
								}
								_tmp168_ = attachments;
								_tmp169_ = json_array_get_object_element (_tmp168_, (guint) j);
								_tmp170_ = _json_object_ref0 (_tmp169_);
								attachment = _tmp170_;
								_tmp171_ = enclosures;
								_tmp172_ = id;
								_tmp173_ = attachment;
								_tmp174_ = json_object_get_string_member (_tmp173_, "href");
								_tmp175_ = attachment;
								_tmp176_ = json_object_get_string_member (_tmp175_, "type");
								_tmp177_ = feed_reader_enclosure_new (_tmp172_, _tmp174_, feed_reader_enclosure_type_from_string (_tmp176_));
								_tmp178_ = _tmp177_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp171_, _tmp178_);
								_g_object_unref0 (_tmp178_);
								_json_object_unref0 (attachment);
							}
						}
					}
					_json_array_unref0 (attachments);
				}
				if (unread) {
					_tmp179_ = FEED_READER_ARTICLE_STATUS_UNREAD;
				} else {
					_tmp179_ = FEED_READER_ARTICLE_STATUS_READ;
				}
				_tmp180_ = id;
				_tmp181_ = title;
				_tmp182_ = url;
				_tmp183_ = feedID;
				_tmp184_ = content;
				_tmp185_ = author;
				_tmp186_ = date;
				_tmp187_ = tags;
				_tmp188_ = enclosures;
				_tmp189_ = feed_reader_article_new (_tmp180_, _tmp181_, _tmp182_, _tmp183_, _tmp179_, marked, _tmp184_, NULL, _tmp185_, _tmp186_, -1, (GeeList*) _tmp187_, (GeeList*) _tmp188_, "", 0);
				Article = _tmp189_;
				_tmp190_ = Article;
				gee_collection_add ((GeeCollection*) articles, _tmp190_);
				_g_object_unref0 (Article);
				_g_object_unref0 (enclosures);
				_g_object_unref0 (tags);
				_g_date_time_unref0 (date);
				_g_free0 (feedID);
				_g_free0 (url);
				_json_object_unref0 (first_alternate);
				_json_array_unref0 (alternate);
				_g_free0 (content);
				_json_object_unref0 (content_obj);
				_g_free0 (summaryContent);
				_json_object_unref0 (summary);
				_g_free0 (author);
				_g_free0 (title);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	result = cont;
	_json_array_unref0 (array);
	feed_reader_response_destroy (&response);
	_json_object_unref0 (root);
	feed_reader_response_destroy (&entry_id_response);
	_g_free0 (streamCall);
	_g_object_unref0 (parser);
	_g_free0 (marked_tag);
	_g_free0 (onlyUnread);
	_g_free0 (steamID);
	return result;
}

/** Returns the number of unread articles for an ID (may be a feed, subscription, category or tag */
void
feed_reader_feedly_api_getUnreadCounts (FeedReaderFeedlyAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* object = NULL;
	JsonParser* _tmp9_;
	JsonNode* _tmp10_;
	JsonObject* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* _tmp14_;
	JsonArray* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_get_request_to_feedly (_tmp0_, "/v3/markers/counts", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		feed_reader_response_destroy (&response);
		return;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getUnreadCounts: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = parser;
	_tmp10_ = json_parser_get_root (_tmp9_);
	_tmp11_ = json_node_get_object (_tmp10_);
	_tmp12_ = _json_object_ref0 (_tmp11_);
	object = _tmp12_;
	_tmp13_ = object;
	_tmp14_ = json_object_get_array_member (_tmp13_, "unreadcounts");
	_tmp15_ = _json_array_ref0 (_tmp14_);
	_json_array_unref0 (self->priv->m_unreadcounts);
	self->priv->m_unreadcounts = _tmp15_;
	_json_object_unref0 (object);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
}

static gint
feed_reader_feedly_api_getUnreadCountforID (FeedReaderFeedlyAPI* self,
                                            const gchar* id)
{
	gint unread_count = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (id != NULL, 0);
	unread_count = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp2_;
				JsonObject* unread = NULL;
				JsonArray* _tmp3_;
				JsonObject* _tmp4_;
				JsonObject* _tmp5_;
				gchar* unread_id = NULL;
				JsonObject* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->m_unreadcounts;
				if (!(((guint) i) < json_array_get_length (_tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->m_unreadcounts;
				_tmp4_ = json_array_get_object_element (_tmp3_, (guint) i);
				_tmp5_ = _json_object_ref0 (_tmp4_);
				unread = _tmp5_;
				_tmp6_ = unread;
				_tmp7_ = json_object_get_string_member (_tmp6_, "id");
				_tmp8_ = g_strdup (_tmp7_);
				unread_id = _tmp8_;
				_tmp9_ = unread_id;
				if (g_strcmp0 (id, _tmp9_) == 0) {
					JsonObject* _tmp10_;
					_tmp10_ = unread;
					unread_count = (gint) json_object_get_int_member (_tmp10_, "count");
					_g_free0 (unread_id);
					_json_object_unref0 (unread);
					break;
				}
				_g_free0 (unread_id);
				_json_object_unref0 (unread);
			}
		}
	}
	if (unread_count == -1) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = g_strdup_printf ("Unknown id: %s", id);
		_tmp12_ = _tmp11_;
		feed_reader_logger_error (_tmp12_);
		_g_free0 (_tmp12_);
	}
	result = unread_count;
	return result;
}

gint
feed_reader_feedly_api_getTotalUnread (FeedReaderFeedlyAPI* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strconcat ("user/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/category/global.all", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = feed_reader_feedly_api_getUnreadCountforID (self, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

void
feed_reader_feedly_api_mark_as_read (FeedReaderFeedlyAPI* self,
                                     const gchar* ids_string,
                                     const gchar* type,
                                     FeedReaderArticleStatus read)
{
	gchar** id_array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint id_array_length1;
	gint _id_array_size_;
	JsonObject* object = NULL;
	JsonObject* _tmp2_;
	JsonObject* _tmp5_;
	JsonArray* ids = NULL;
	JsonArray* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* type_id_identificator = NULL;
	JsonObject* _tmp15_;
	const gchar* _tmp16_;
	JsonArray* _tmp17_;
	JsonArray* _tmp18_;
	gboolean _tmp19_ = FALSE;
	JsonNode* root = NULL;
	JsonNode* _tmp23_;
	JsonObject* _tmp24_;
	FeedReaderFeedlyConnection* _tmp25_;
	FeedReaderResponse _tmp26_ = {0};
	FeedReaderResponse _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ids_string != NULL);
	g_return_if_fail (type != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (ids_string, ",", 0);
	id_array = _tmp1_;
	id_array_length1 = _vala_array_length (_tmp0_);
	_id_array_size_ = id_array_length1;
	_tmp2_ = json_object_new ();
	object = _tmp2_;
	if (read == FEED_READER_ARTICLE_STATUS_READ) {
		JsonObject* _tmp3_;
		_tmp3_ = object;
		json_object_set_string_member (_tmp3_, "action", "markAsRead");
	} else {
		if (read == FEED_READER_ARTICLE_STATUS_UNREAD) {
			JsonObject* _tmp4_;
			_tmp4_ = object;
			json_object_set_string_member (_tmp4_, "action", "keepUnread");
		}
	}
	_tmp5_ = object;
	json_object_set_string_member (_tmp5_, "type", type);
	_tmp6_ = json_array_new ();
	ids = _tmp6_;
	_tmp7_ = id_array;
	_tmp7__length1 = id_array_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp7_;
		id_collection_length1 = _tmp7__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			gchar* _tmp8_;
			gchar* id = NULL;
			_tmp8_ = g_strdup (id_collection[id_it]);
			id = _tmp8_;
			{
				JsonArray* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = ids;
				_tmp10_ = id;
				json_array_add_string_element (_tmp9_, _tmp10_);
				_g_free0 (id);
			}
		}
	}
	type_id_identificator = NULL;
	if (g_strcmp0 (type, "entries") == 0) {
		type_id_identificator = "entryIds";
	} else {
		if (g_strcmp0 (type, "feeds") == 0) {
			type_id_identificator = "feedIds";
		} else {
			if (g_strcmp0 (type, "categories") == 0) {
				type_id_identificator = "categoryIds";
			} else {
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp11_ = g_strconcat ("Unknown type: ", type, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp12_, " don't know what to do with this.", NULL);
				_tmp14_ = _tmp13_;
				g_error ("feedlyAPI.vala:594: %s", _tmp14_);
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
			}
		}
	}
	_tmp15_ = object;
	_tmp16_ = type_id_identificator;
	_tmp17_ = ids;
	_tmp18_ = _json_array_ref0 (_tmp17_);
	json_object_set_array_member (_tmp15_, _tmp16_, _tmp18_);
	if (g_strcmp0 (type, "feeds") == 0) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = g_strcmp0 (type, "categories") == 0;
	}
	if (_tmp19_) {
		GDateTime* now = NULL;
		GDateTime* _tmp20_;
		JsonObject* _tmp21_;
		GDateTime* _tmp22_;
		_tmp20_ = g_date_time_new_now_local ();
		now = _tmp20_;
		_tmp21_ = object;
		_tmp22_ = now;
		json_object_set_int_member (_tmp21_, "asOf", g_date_time_to_unix (_tmp22_) * 1000);
		_g_date_time_unref0 (now);
	}
	_tmp23_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp23_;
	_tmp24_ = object;
	json_node_set_object (root, _tmp24_);
	_tmp25_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_post_request_to_feedly (_tmp25_, "/v3/markers", root, &_tmp26_);
	_tmp27_ = _tmp26_;
	feed_reader_response_destroy (&_tmp27_);
	__vala_JsonNode_free0 (root);
	_json_array_unref0 (ids);
	_json_object_unref0 (object);
	id_array = (_vala_array_free (id_array, id_array_length1, (GDestroyNotify) g_free), NULL);
}

void
feed_reader_feedly_api_addArticleTag (FeedReaderFeedlyAPI* self,
                                      const gchar* ids_string,
                                      const gchar* tagID)
{
	gchar** id_array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint id_array_length1;
	gint _id_array_size_;
	JsonObject* object = NULL;
	JsonObject* _tmp2_;
	JsonArray* ids = NULL;
	JsonArray* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	JsonObject* _tmp8_;
	JsonArray* _tmp9_;
	JsonArray* _tmp10_;
	JsonNode* root = NULL;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	FeedReaderFeedlyConnection* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	FeedReaderResponse _tmp18_ = {0};
	FeedReaderResponse _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ids_string != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (ids_string, ",", 0);
	id_array = _tmp1_;
	id_array_length1 = _vala_array_length (_tmp0_);
	_id_array_size_ = id_array_length1;
	_tmp2_ = json_object_new ();
	object = _tmp2_;
	_tmp3_ = json_array_new ();
	ids = _tmp3_;
	_tmp4_ = id_array;
	_tmp4__length1 = id_array_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp4_;
		id_collection_length1 = _tmp4__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			gchar* _tmp5_;
			gchar* id = NULL;
			_tmp5_ = g_strdup (id_collection[id_it]);
			id = _tmp5_;
			{
				JsonArray* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = ids;
				_tmp7_ = id;
				json_array_add_string_element (_tmp6_, _tmp7_);
				_g_free0 (id);
			}
		}
	}
	_tmp8_ = object;
	_tmp9_ = ids;
	_tmp10_ = _json_array_ref0 (_tmp9_);
	json_object_set_array_member (_tmp8_, "entryIds", _tmp10_);
	_tmp11_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp11_;
	_tmp12_ = object;
	json_node_set_object (root, _tmp12_);
	_tmp13_ = self->priv->m_connection;
	_tmp14_ = g_uri_escape_string (tagID, NULL, TRUE);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("/v3/tags/", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	feed_reader_feedly_connection_send_put_request_to_feedly (_tmp13_, _tmp17_, root, &_tmp18_);
	_tmp19_ = _tmp18_;
	feed_reader_response_destroy (&_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	__vala_JsonNode_free0 (root);
	_json_array_unref0 (ids);
	_json_object_unref0 (object);
	id_array = (_vala_array_free (id_array, id_array_length1, (GDestroyNotify) g_free), NULL);
}

void
feed_reader_feedly_api_deleteArticleTag (FeedReaderFeedlyAPI* self,
                                         const gchar* ids_string,
                                         const gchar* tagID)
{
	gchar* command = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderFeedlyConnection* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FeedReaderResponse _tmp11_ = {0};
	FeedReaderResponse _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ids_string != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = g_uri_escape_string (tagID, NULL, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "/", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_uri_escape_string (ids_string, NULL, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	command = _tmp7_;
	_tmp8_ = self->priv->m_connection;
	_tmp9_ = g_strconcat ("/v3/tags/", command, NULL);
	_tmp10_ = _tmp9_;
	feed_reader_feedly_connection_send_delete_request_to_feedly (_tmp8_, _tmp10_, &_tmp11_);
	_tmp12_ = _tmp11_;
	feed_reader_response_destroy (&_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (command);
}

gchar*
feed_reader_feedly_api_createTag (FeedReaderFeedlyAPI* self,
                                  const gchar* caption)
{
	gchar* tagID = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	JsonObject* object = NULL;
	JsonObject* _tmp7_;
	JsonNode* root = NULL;
	JsonNode* _tmp8_;
	FeedReaderFeedlyConnection* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FeedReaderResponse _tmp14_ = {0};
	FeedReaderResponse _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strconcat ("user/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/tag/", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, caption, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	tagID = _tmp6_;
	_tmp7_ = json_object_new ();
	object = _tmp7_;
	json_object_set_string_member (object, "entryId", "");
	_tmp8_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp8_;
	json_node_set_object (root, object);
	_tmp9_ = self->priv->m_connection;
	_tmp10_ = g_uri_escape_string (tagID, NULL, TRUE);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("/v3/tags/", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	feed_reader_feedly_connection_send_put_request_to_feedly (_tmp9_, _tmp13_, root, &_tmp14_);
	_tmp15_ = _tmp14_;
	feed_reader_response_destroy (&_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = tagID;
	__vala_JsonNode_free0 (root);
	_json_object_unref0 (object);
	return result;
}

void
feed_reader_feedly_api_deleteTag (FeedReaderFeedlyAPI* self,
                                  const gchar* tagID)
{
	FeedReaderFeedlyConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FeedReaderResponse _tmp5_ = {0};
	FeedReaderResponse _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_connection;
	_tmp1_ = g_uri_escape_string (tagID, NULL, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("/v3/tags/", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	feed_reader_feedly_connection_send_delete_request_to_feedly (_tmp0_, _tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	feed_reader_response_destroy (&_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

gboolean
feed_reader_feedly_api_addSubscription (FeedReaderFeedlyAPI* self,
                                        const gchar* feedURL,
                                        const gchar* title,
                                        const gchar* catIDs)
{
	JsonObject* object = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	JsonNode* root = NULL;
	JsonNode* _tmp25_;
	JsonObject* _tmp26_;
	FeedReaderResponse response = {0};
	FeedReaderFeedlyConnection* _tmp27_;
	FeedReaderResponse _tmp28_ = {0};
	FeedReaderResponse _tmp29_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feedURL != NULL, FALSE);
	_tmp0_ = json_object_new ();
	object = _tmp0_;
	_tmp1_ = object;
	_tmp2_ = g_strconcat ("feed/", feedURL, NULL);
	_tmp3_ = _tmp2_;
	json_object_set_string_member (_tmp1_, "id", _tmp3_);
	_g_free0 (_tmp3_);
	if (title != NULL) {
		JsonObject* _tmp4_;
		_tmp4_ = object;
		json_object_set_string_member (_tmp4_, "title", title);
	}
	if (catIDs != NULL) {
		gchar** catArray = NULL;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint catArray_length1;
		gint _catArray_size_;
		JsonArray* cats = NULL;
		JsonArray* _tmp7_;
		FeedReaderDataBaseReadOnly* db = NULL;
		FeedReaderDataBaseReadOnly* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		JsonObject* _tmp22_;
		JsonArray* _tmp23_;
		JsonArray* _tmp24_;
		_tmp6_ = _tmp5_ = g_strsplit (catIDs, ",", 0);
		catArray = _tmp6_;
		catArray_length1 = _vala_array_length (_tmp5_);
		_catArray_size_ = catArray_length1;
		_tmp7_ = json_array_new ();
		cats = _tmp7_;
		_tmp8_ = feed_reader_data_base_readOnly ();
		db = _tmp8_;
		_tmp9_ = catArray;
		_tmp9__length1 = catArray_length1;
		{
			gchar** catID_collection = NULL;
			gint catID_collection_length1 = 0;
			gint _catID_collection_size_ = 0;
			gint catID_it = 0;
			catID_collection = _tmp9_;
			catID_collection_length1 = _tmp9__length1;
			for (catID_it = 0; catID_it < catID_collection_length1; catID_it = catID_it + 1) {
				gchar* _tmp10_;
				gchar* catID = NULL;
				_tmp10_ = g_strdup (catID_collection[catID_it]);
				catID = _tmp10_;
				{
					gchar* catName = NULL;
					FeedReaderDataBaseReadOnly* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					JsonObject* catObject = NULL;
					JsonObject* _tmp14_;
					JsonObject* _tmp15_;
					const gchar* _tmp16_;
					JsonObject* _tmp17_;
					const gchar* _tmp18_;
					JsonArray* _tmp19_;
					JsonObject* _tmp20_;
					JsonObject* _tmp21_;
					_tmp11_ = db;
					_tmp12_ = catID;
					_tmp13_ = feed_reader_data_base_read_only_getCategoryName (_tmp11_, _tmp12_);
					catName = _tmp13_;
					_tmp14_ = json_object_new ();
					catObject = _tmp14_;
					_tmp15_ = catObject;
					_tmp16_ = catID;
					json_object_set_string_member (_tmp15_, "id", _tmp16_);
					_tmp17_ = catObject;
					_tmp18_ = catName;
					json_object_set_string_member (_tmp17_, "label", _tmp18_);
					_tmp19_ = cats;
					_tmp20_ = catObject;
					_tmp21_ = _json_object_ref0 (_tmp20_);
					json_array_add_object_element (_tmp19_, _tmp21_);
					_json_object_unref0 (catObject);
					_g_free0 (catName);
					_g_free0 (catID);
				}
			}
		}
		_tmp22_ = object;
		_tmp23_ = cats;
		_tmp24_ = _json_array_ref0 (_tmp23_);
		json_object_set_array_member (_tmp22_, "categories", _tmp24_);
		_g_object_unref0 (db);
		_json_array_unref0 (cats);
		catArray = (_vala_array_free (catArray, catArray_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp25_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp25_;
	_tmp26_ = object;
	json_node_set_object (root, _tmp26_);
	_tmp27_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_post_request_to_feedly (_tmp27_, "/v3/subscriptions", root, &_tmp28_);
	response = _tmp28_;
	_tmp29_ = response;
	result = _tmp29_.status == ((guint) 200);
	feed_reader_response_destroy (&response);
	__vala_JsonNode_free0 (root);
	_json_object_unref0 (object);
	return result;
}

void
feed_reader_feedly_api_moveSubscription (FeedReaderFeedlyAPI* self,
                                         const gchar* feedID,
                                         const gchar* newCatID,
                                         const gchar* oldCatID)
{
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderFeed* Feed = NULL;
	FeedReaderDataBaseReadOnly* _tmp1_;
	FeedReaderFeed* _tmp2_;
	JsonObject* object = NULL;
	JsonObject* _tmp3_;
	JsonObject* _tmp4_;
	JsonObject* _tmp5_;
	FeedReaderFeed* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GeeList* catArray = NULL;
	FeedReaderFeed* _tmp9_;
	GeeList* _tmp10_;
	JsonArray* cats = NULL;
	JsonArray* _tmp11_;
	gchar* newCatName = NULL;
	FeedReaderDataBaseReadOnly* _tmp32_;
	gchar* _tmp33_;
	JsonObject* catObject = NULL;
	JsonObject* _tmp34_;
	JsonArray* _tmp35_;
	JsonObject* _tmp36_;
	JsonObject* _tmp37_;
	JsonArray* _tmp38_;
	JsonArray* _tmp39_;
	JsonNode* root = NULL;
	JsonNode* _tmp40_;
	JsonObject* _tmp41_;
	FeedReaderFeedlyConnection* _tmp42_;
	FeedReaderResponse _tmp43_ = {0};
	FeedReaderResponse _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	_tmp0_ = feed_reader_data_base_readOnly ();
	db = _tmp0_;
	_tmp1_ = db;
	_tmp2_ = feed_reader_data_base_read_only_read_feed (_tmp1_, feedID);
	Feed = _tmp2_;
	_tmp3_ = json_object_new ();
	object = _tmp3_;
	_tmp4_ = object;
	json_object_set_string_member (_tmp4_, "id", feedID);
	_tmp5_ = object;
	_tmp6_ = Feed;
	_tmp7_ = feed_reader_feed_getTitle (_tmp6_);
	_tmp8_ = _tmp7_;
	json_object_set_string_member (_tmp5_, "title", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = Feed;
	_tmp10_ = feed_reader_feed_getCatIDs (_tmp9_);
	catArray = _tmp10_;
	_tmp11_ = json_array_new ();
	cats = _tmp11_;
	{
		GeeList* _catID_list = NULL;
		GeeList* _tmp12_;
		gint _catID_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _catID_index = 0;
		_tmp12_ = catArray;
		_catID_list = _tmp12_;
		_tmp13_ = _catID_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_catID_size = _tmp15_;
		_catID_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gchar* catID = NULL;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			const gchar* _tmp20_;
			_catID_index = _catID_index + 1;
			_tmp16_ = _catID_index;
			_tmp17_ = _catID_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _catID_list;
			_tmp19_ = gee_list_get (_tmp18_, _catID_index);
			catID = (gchar*) _tmp19_;
			_tmp20_ = catID;
			if (g_strcmp0 (_tmp20_, oldCatID) != 0) {
				gchar* catName = NULL;
				FeedReaderDataBaseReadOnly* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				JsonObject* catObject = NULL;
				JsonObject* _tmp24_;
				JsonObject* _tmp25_;
				const gchar* _tmp26_;
				JsonObject* _tmp27_;
				const gchar* _tmp28_;
				JsonArray* _tmp29_;
				JsonObject* _tmp30_;
				JsonObject* _tmp31_;
				_tmp21_ = db;
				_tmp22_ = catID;
				_tmp23_ = feed_reader_data_base_read_only_getCategoryName (_tmp21_, _tmp22_);
				catName = _tmp23_;
				_tmp24_ = json_object_new ();
				catObject = _tmp24_;
				_tmp25_ = catObject;
				_tmp26_ = catID;
				json_object_set_string_member (_tmp25_, "id", _tmp26_);
				_tmp27_ = catObject;
				_tmp28_ = catName;
				json_object_set_string_member (_tmp27_, "label", _tmp28_);
				_tmp29_ = cats;
				_tmp30_ = catObject;
				_tmp31_ = _json_object_ref0 (_tmp30_);
				json_array_add_object_element (_tmp29_, _tmp31_);
				_json_object_unref0 (catObject);
				_g_free0 (catName);
			}
			_g_free0 (catID);
		}
	}
	_tmp32_ = db;
	_tmp33_ = feed_reader_data_base_read_only_getCategoryName (_tmp32_, newCatID);
	newCatName = _tmp33_;
	_tmp34_ = json_object_new ();
	catObject = _tmp34_;
	json_object_set_string_member (catObject, "id", newCatID);
	json_object_set_string_member (catObject, "label", newCatName);
	_tmp35_ = cats;
	_tmp36_ = _json_object_ref0 (catObject);
	json_array_add_object_element (_tmp35_, _tmp36_);
	_tmp37_ = object;
	_tmp38_ = cats;
	_tmp39_ = _json_array_ref0 (_tmp38_);
	json_object_set_array_member (_tmp37_, "categories", _tmp39_);
	_tmp40_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp40_;
	_tmp41_ = object;
	json_node_set_object (root, _tmp41_);
	_tmp42_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_post_request_to_feedly (_tmp42_, "/v3/subscriptions", root, &_tmp43_);
	_tmp44_ = _tmp43_;
	feed_reader_response_destroy (&_tmp44_);
	__vala_JsonNode_free0 (root);
	_json_object_unref0 (catObject);
	_g_free0 (newCatName);
	_json_array_unref0 (cats);
	_g_object_unref0 (catArray);
	_json_object_unref0 (object);
	_g_object_unref0 (Feed);
	_g_object_unref0 (db);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
feed_reader_feedly_api_removeSubscription (FeedReaderFeedlyAPI* self,
                                           const gchar* feedID)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FeedReaderFeedlyConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderResponse _tmp8_ = {0};
	FeedReaderResponse _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = string_to_string (feedID);
	_tmp1_ = g_strconcat ("Deleting ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_info (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->m_connection;
	_tmp4_ = g_uri_escape_string (feedID, NULL, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("/v3/subscriptions/", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	feed_reader_feedly_connection_send_delete_request_to_feedly (_tmp3_, _tmp7_, &_tmp8_);
	_tmp9_ = _tmp8_;
	feed_reader_response_destroy (&_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}

void
feed_reader_feedly_api_renameCategory (FeedReaderFeedlyAPI* self,
                                       const gchar* catID,
                                       const gchar* title)
{
	JsonObject* object = NULL;
	JsonObject* _tmp0_;
	JsonNode* root = NULL;
	JsonNode* _tmp1_;
	FeedReaderFeedlyConnection* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderResponse _tmp7_ = {0};
	FeedReaderResponse _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = json_object_new ();
	object = _tmp0_;
	json_object_set_string_member (object, "label", title);
	_tmp1_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp1_;
	json_node_set_object (root, object);
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = g_uri_escape_string (catID, NULL, TRUE);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("/v3/categories/", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	feed_reader_feedly_connection_send_post_request_to_feedly (_tmp2_, _tmp6_, root, &_tmp7_);
	_tmp8_ = _tmp7_;
	feed_reader_response_destroy (&_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	__vala_JsonNode_free0 (root);
	_json_object_unref0 (object);
}

void
feed_reader_feedly_api_renameTag (FeedReaderFeedlyAPI* self,
                                  const gchar* tagID,
                                  const gchar* title)
{
	JsonObject* object = NULL;
	JsonObject* _tmp0_;
	JsonNode* root = NULL;
	JsonNode* _tmp1_;
	FeedReaderFeedlyConnection* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderResponse _tmp7_ = {0};
	FeedReaderResponse _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = json_object_new ();
	object = _tmp0_;
	json_object_set_string_member (object, "label", title);
	_tmp1_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp1_;
	json_node_set_object (root, object);
	_tmp2_ = self->priv->m_connection;
	_tmp3_ = g_uri_escape_string (tagID, NULL, TRUE);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("/v3/tags/", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	feed_reader_feedly_connection_send_post_request_to_feedly (_tmp2_, _tmp6_, root, &_tmp7_);
	_tmp8_ = _tmp7_;
	feed_reader_response_destroy (&_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	__vala_JsonNode_free0 (root);
	_json_object_unref0 (object);
}

void
feed_reader_feedly_api_removeCategory (FeedReaderFeedlyAPI* self,
                                       const gchar* catID)
{
	FeedReaderFeedlyConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FeedReaderResponse _tmp5_ = {0};
	FeedReaderResponse _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_connection;
	_tmp1_ = g_uri_escape_string (catID, NULL, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("/v3/categories/", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	feed_reader_feedly_connection_send_delete_request_to_feedly (_tmp0_, _tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	feed_reader_response_destroy (&_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

void
feed_reader_feedly_api_importOPML (FeedReaderFeedlyAPI* self,
                                   const gchar* opml)
{
	FeedReaderFeedlyConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (opml != NULL);
	_tmp0_ = self->priv->m_connection;
	feed_reader_feedly_connection_send_post_string_request_to_feedly (_tmp0_, "/v3/opml", opml, "text/xml", &_tmp1_);
	_tmp2_ = _tmp1_;
	feed_reader_response_destroy (&_tmp2_);
}

static void
feed_reader_feedly_api_class_init (FeedReaderFeedlyAPIClass * klass,
                                   gpointer klass_data)
{
	feed_reader_feedly_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderFeedlyAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_feedly_api_finalize;
}

static void
feed_reader_feedly_api_instance_init (FeedReaderFeedlyAPI * self,
                                      gpointer klass)
{
	self->priv = feed_reader_feedly_api_get_instance_private (self);
}

static void
feed_reader_feedly_api_finalize (GObject * obj)
{
	FeedReaderFeedlyAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEEDLY_API, FeedReaderFeedlyAPI);
	_feed_reader_feedly_connection_unref0 (self->priv->m_connection);
	_g_free0 (self->priv->m_userID);
	_json_array_unref0 (self->priv->m_unreadcounts);
	_g_object_unref0 (self->priv->m_utils);
	G_OBJECT_CLASS (feed_reader_feedly_api_parent_class)->finalize (obj);
}

GType
feed_reader_feedly_api_get_type (void)
{
	return feed_reader_feedly_api_type_id;
}

GType
feed_reader_feedly_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedlyAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feedly_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedlyAPI), 0, (GInstanceInitFunc) feed_reader_feedly_api_instance_init, NULL };
	feed_reader_feedly_api_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderFeedlyAPI", &g_define_type_info, 0);
	FeedReaderFeedlyAPI_private_offset = sizeof (FeedReaderFeedlyAPIPrivate);
	return feed_reader_feedly_api_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

