/* feedlyConnection.c generated by valac 0.56.3, the Vala compiler
 * generated from feedlyConnection.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "feedly.h"
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib.h>
#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gobject/gvaluecollector.h>

#define FEED_READER_FEEDLY_SECRET_base_uri "http://cloud.feedly.com"
#define FEED_READER_FEEDLY_SECRET_apiClientId "boutroue"
#define FEED_READER_FEEDLY_SECRET_apiClientSecret "FE012EGICU4ZOBDRBEOVAJA1JZYH"
#define FEED_READER_FEEDLY_SECRET_apiRedirectUri "http://localhost"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FeedReaderParamSpecFeedlyConnection FeedReaderParamSpecFeedlyConnection;

struct _FeedReaderFeedlyConnectionPrivate {
	FeedReaderFeedlyUtils* m_utils;
	GSettings* m_settingsTweaks;
	SoupSession* m_session;
};

struct _FeedReaderParamSpecFeedlyConnection {
	GParamSpec parent_instance;
};

static gint FeedReaderFeedlyConnection_private_offset;
static gpointer feed_reader_feedly_connection_parent_class = NULL;
static GType feed_reader_feedly_connection_type_id = 0;

static void _vala_SoupBuffer_free (SoupBuffer* self);
static void feed_reader_feedly_connection_send_request (FeedReaderFeedlyConnection* self,
                                                 const gchar* path,
                                                 const gchar* type,
                                                 FeedReaderResponse* result);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void feed_reader_feedly_connection_finalize (FeedReaderFeedlyConnection * obj);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_feedly_connection_get_instance_private (FeedReaderFeedlyConnection* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderFeedlyConnection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderFeedlyConnection*
feed_reader_feedly_connection_construct (GType object_type,
                                         FeedReaderFeedlyUtils* utils)
{
	FeedReaderFeedlyConnection* self = NULL;
	FeedReaderFeedlyUtils* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	GSettings* _tmp3_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderFeedlyConnection*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp1_;
	_tmp2_ = self->priv->m_session;
	g_object_set (_tmp2_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp3_ = g_settings_new ("org.gnome.feedreader.tweaks");
	_g_object_unref0 (self->priv->m_settingsTweaks);
	self->priv->m_settingsTweaks = _tmp3_;
	return self;
}

FeedReaderFeedlyConnection*
feed_reader_feedly_connection_new (FeedReaderFeedlyUtils* utils)
{
	return feed_reader_feedly_connection_construct (FEED_READER_TYPE_FEEDLY_CONNECTION, utils);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

FeedReaderLoginResponse
feed_reader_feedly_connection_getToken (FeedReaderFeedlyConnection* self)
{
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	gchar* message_string = NULL;
	FeedReaderFeedlyUtils* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	SoupMessage* _tmp22_;
	const gchar* _tmp23_;
	guint8* _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_ = 0;
	guint8* _tmp26_;
	gint _tmp26__length1;
	SoupSession* _tmp27_;
	SoupMessage* _tmp28_;
	SoupMessage* _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	GError* _inner_error0_ = NULL;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = soup_message_new ("POST", FEED_READER_FEEDLY_SECRET_base_uri "/v3/auth/token");
	message = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feedly_utils_getApiCode (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("code=", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "&client_id=", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, FEED_READER_FEEDLY_SECRET_apiClientId, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "&client_secret=", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, FEED_READER_FEEDLY_SECRET_apiClientSecret, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "&redirect_uri=", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, FEED_READER_FEEDLY_SECRET_apiRedirectUri, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, "&grant_type=authorization_code", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "&state=getting_token", NULL);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	message_string = _tmp21_;
	_tmp22_ = message;
	_tmp23_ = message_string;
	_tmp24_ = string_get_data (_tmp23_, &_tmp25_);
	_tmp24__length1 = _tmp25_;
	_tmp26_ = _tmp24_;
	_tmp26__length1 = _tmp24__length1;
	soup_message_set_request (_tmp22_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp26_, (gsize) _tmp26__length1);
	_tmp27_ = self->priv->m_session;
	_tmp28_ = message;
	soup_session_send_message (_tmp27_, _tmp28_);
	_tmp29_ = message;
	g_object_get (_tmp29_, "status-code", &_tmp30_, NULL);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != ((guint) 200)) {
		result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
		_g_free0 (message_string);
		_g_object_unref0 (message);
		return result;
	}
	{
		JsonParser* parser = NULL;
		JsonParser* _tmp32_;
		JsonParser* _tmp33_;
		SoupMessage* _tmp34_;
		SoupMessageBody* _tmp35_;
		SoupBuffer* _tmp36_;
		SoupBuffer* _tmp37_;
		guint8* _tmp38_;
		gint _tmp38__length1;
		JsonObject* root = NULL;
		JsonParser* _tmp39_;
		JsonNode* _tmp40_;
		JsonObject* _tmp41_;
		JsonObject* _tmp42_;
		JsonObject* _tmp43_;
		_tmp32_ = json_parser_new ();
		parser = _tmp32_;
		_tmp33_ = parser;
		_tmp34_ = message;
		_tmp35_ = _tmp34_->response_body;
		_tmp36_ = soup_message_body_flatten (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_->data;
		_tmp38__length1 = _tmp37_->length;
		json_parser_load_from_data (_tmp33_, (const gchar*) _tmp38_, (gssize) -1, &_inner_error0_);
		__vala_SoupBuffer_free0 (_tmp37_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			goto __catch0_g_error;
		}
		_tmp39_ = parser;
		_tmp40_ = json_parser_get_root (_tmp39_);
		_tmp41_ = json_node_get_object (_tmp40_);
		_tmp42_ = _json_object_ref0 (_tmp41_);
		root = _tmp42_;
		_tmp43_ = root;
		if (json_object_has_member (_tmp43_, "access_token")) {
			gchar* accessToken = NULL;
			JsonObject* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			gint64 expires = 0LL;
			JsonObject* _tmp47_;
			gchar* refreshToken = NULL;
			JsonObject* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gint64 now = 0LL;
			GDateTime* _tmp51_;
			GDateTime* _tmp52_;
			gint64 _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			const gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			FeedReaderFeedlyUtils* _tmp68_;
			const gchar* _tmp69_;
			FeedReaderFeedlyUtils* _tmp70_;
			FeedReaderFeedlyUtils* _tmp71_;
			const gchar* _tmp72_;
			_tmp44_ = root;
			_tmp45_ = json_object_get_string_member (_tmp44_, "access_token");
			_tmp46_ = g_strdup (_tmp45_);
			accessToken = _tmp46_;
			_tmp47_ = root;
			expires = (gint64) ((gint) json_object_get_int_member (_tmp47_, "expires_in"));
			_tmp48_ = root;
			_tmp49_ = json_object_get_string_member (_tmp48_, "refresh_token");
			_tmp50_ = g_strdup (_tmp49_);
			refreshToken = _tmp50_;
			_tmp51_ = g_date_time_new_now_local ();
			_tmp52_ = _tmp51_;
			_tmp53_ = g_date_time_to_unix (_tmp52_);
			_g_date_time_unref0 (_tmp52_);
			now = _tmp53_;
			_tmp54_ = accessToken;
			_tmp55_ = g_strconcat ("access-token: ", _tmp54_, NULL);
			_tmp56_ = _tmp55_;
			feed_reader_logger_debug (_tmp56_);
			_g_free0 (_tmp56_);
			_tmp57_ = g_strdup_printf ("%" G_GINT64_FORMAT, expires);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat ("expires in: ", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			feed_reader_logger_debug (_tmp60_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			_tmp61_ = refreshToken;
			_tmp62_ = g_strconcat ("refresh-token: ", _tmp61_, NULL);
			_tmp63_ = _tmp62_;
			feed_reader_logger_debug (_tmp63_);
			_g_free0 (_tmp63_);
			_tmp64_ = g_strdup_printf ("%" G_GINT64_FORMAT, now);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strconcat ("now: ", _tmp65_, NULL);
			_tmp67_ = _tmp66_;
			feed_reader_logger_debug (_tmp67_);
			_g_free0 (_tmp67_);
			_g_free0 (_tmp65_);
			_tmp68_ = self->priv->m_utils;
			_tmp69_ = accessToken;
			feed_reader_feedly_utils_setAccessToken (_tmp68_, _tmp69_);
			_tmp70_ = self->priv->m_utils;
			feed_reader_feedly_utils_setExpiration (_tmp70_, (gint) (now + expires));
			_tmp71_ = self->priv->m_utils;
			_tmp72_ = refreshToken;
			feed_reader_feedly_utils_setRefreshToken (_tmp71_, _tmp72_);
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			_g_free0 (refreshToken);
			_g_free0 (accessToken);
			_json_object_unref0 (root);
			_g_object_unref0 (parser);
			_g_free0 (message_string);
			_g_object_unref0 (message);
			return result;
		} else {
			JsonObject* _tmp73_;
			_tmp73_ = root;
			if (json_object_has_member (_tmp73_, "errorCode")) {
				JsonObject* _tmp74_;
				const gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp74_ = root;
				_tmp75_ = json_object_get_string_member (_tmp74_, "errorMessage");
				_tmp76_ = g_strconcat ("Feedly: getToken response - ", _tmp75_, NULL);
				_tmp77_ = _tmp76_;
				feed_reader_logger_error (_tmp77_);
				_g_free0 (_tmp77_);
				result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
				_json_object_unref0 (root);
				_g_object_unref0 (parser);
				_g_free0 (message_string);
				_g_object_unref0 (message);
				return result;
			}
		}
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp78_;
		const gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp78_ = e;
		_tmp79_ = _tmp78_->message;
		_tmp80_ = g_strdup_printf ("Could not load response to Message from feedly - %s", _tmp79_);
		_tmp81_ = _tmp80_;
		feed_reader_logger_error (_tmp81_);
		_g_free0 (_tmp81_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (message_string);
		_g_object_unref0 (message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	_g_free0 (message_string);
	_g_object_unref0 (message);
	return result;
}

FeedReaderLoginResponse
feed_reader_feedly_connection_refreshToken (FeedReaderFeedlyConnection* self)
{
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	GSettings* _tmp1_;
	gchar* message_string = NULL;
	FeedReaderFeedlyUtils* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	SoupMessage* _tmp19_;
	const gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gint _tmp22_ = 0;
	guint8* _tmp23_;
	gint _tmp23__length1;
	SoupSession* _tmp24_;
	SoupMessage* _tmp25_;
	SoupMessage* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	GError* _inner_error0_ = NULL;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = soup_message_new ("POST", FEED_READER_FEEDLY_SECRET_base_uri "/v3/auth/token");
	message = _tmp0_;
	_tmp1_ = self->priv->m_settingsTweaks;
	if (g_settings_get_boolean (_tmp1_, "do-not-track")) {
		SoupMessage* _tmp2_;
		SoupMessageHeaders* _tmp3_;
		_tmp2_ = message;
		_tmp3_ = _tmp2_->request_headers;
		soup_message_headers_append (_tmp3_, "DNT", "1");
	}
	_tmp4_ = self->priv->m_utils;
	_tmp5_ = feed_reader_feedly_utils_getRefreshToken (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("refresh_token=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "&client_id=", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, FEED_READER_FEEDLY_SECRET_apiClientId, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "&client_secret=", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, FEED_READER_FEEDLY_SECRET_apiClientSecret, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "&grant_type=refresh_token", NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	message_string = _tmp18_;
	_tmp19_ = message;
	_tmp20_ = message_string;
	_tmp21_ = string_get_data (_tmp20_, &_tmp22_);
	_tmp21__length1 = _tmp22_;
	_tmp23_ = _tmp21_;
	_tmp23__length1 = _tmp21__length1;
	soup_message_set_request (_tmp19_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp23_, (gsize) _tmp23__length1);
	_tmp24_ = self->priv->m_session;
	_tmp25_ = message;
	soup_session_send_message (_tmp24_, _tmp25_);
	_tmp26_ = message;
	g_object_get (_tmp26_, "status-code", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != ((guint) 200)) {
		result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
		_g_free0 (message_string);
		_g_object_unref0 (message);
		return result;
	}
	{
		JsonParser* parser = NULL;
		JsonParser* _tmp29_;
		JsonParser* _tmp30_;
		SoupMessage* _tmp31_;
		SoupMessageBody* _tmp32_;
		SoupBuffer* _tmp33_;
		SoupBuffer* _tmp34_;
		guint8* _tmp35_;
		gint _tmp35__length1;
		JsonObject* root = NULL;
		JsonParser* _tmp36_;
		JsonNode* _tmp37_;
		JsonObject* _tmp38_;
		JsonObject* _tmp39_;
		JsonObject* _tmp40_;
		_tmp29_ = json_parser_new ();
		parser = _tmp29_;
		_tmp30_ = parser;
		_tmp31_ = message;
		_tmp32_ = _tmp31_->response_body;
		_tmp33_ = soup_message_body_flatten (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_->data;
		_tmp35__length1 = _tmp34_->length;
		json_parser_load_from_data (_tmp30_, (const gchar*) _tmp35_, (gssize) -1, &_inner_error0_);
		__vala_SoupBuffer_free0 (_tmp34_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			goto __catch0_g_error;
		}
		_tmp36_ = parser;
		_tmp37_ = json_parser_get_root (_tmp36_);
		_tmp38_ = json_node_get_object (_tmp37_);
		_tmp39_ = _json_object_ref0 (_tmp38_);
		root = _tmp39_;
		_tmp40_ = root;
		if (json_object_has_member (_tmp40_, "access_token")) {
			gchar* accessToken = NULL;
			JsonObject* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gint64 expires = 0LL;
			JsonObject* _tmp44_;
			gchar* refreshToken = NULL;
			JsonObject* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gint64 now = 0LL;
			GDateTime* _tmp48_;
			GDateTime* _tmp49_;
			gint64 _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			FeedReaderFeedlyUtils* _tmp65_;
			const gchar* _tmp66_;
			FeedReaderFeedlyUtils* _tmp67_;
			FeedReaderFeedlyUtils* _tmp68_;
			const gchar* _tmp69_;
			_tmp41_ = root;
			_tmp42_ = json_object_get_string_member (_tmp41_, "access_token");
			_tmp43_ = g_strdup (_tmp42_);
			accessToken = _tmp43_;
			_tmp44_ = root;
			expires = (gint64) ((gint) json_object_get_int_member (_tmp44_, "expires_in"));
			_tmp45_ = root;
			_tmp46_ = json_object_get_string_member (_tmp45_, "refresh_token");
			_tmp47_ = g_strdup (_tmp46_);
			refreshToken = _tmp47_;
			_tmp48_ = g_date_time_new_now_local ();
			_tmp49_ = _tmp48_;
			_tmp50_ = g_date_time_to_unix (_tmp49_);
			_g_date_time_unref0 (_tmp49_);
			now = _tmp50_;
			_tmp51_ = accessToken;
			_tmp52_ = g_strconcat ("access-token: ", _tmp51_, NULL);
			_tmp53_ = _tmp52_;
			feed_reader_logger_debug (_tmp53_);
			_g_free0 (_tmp53_);
			_tmp54_ = g_strdup_printf ("%" G_GINT64_FORMAT, expires);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat ("expires in: ", _tmp55_, NULL);
			_tmp57_ = _tmp56_;
			feed_reader_logger_debug (_tmp57_);
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
			_tmp58_ = refreshToken;
			_tmp59_ = g_strconcat ("refresh-token: ", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			feed_reader_logger_debug (_tmp60_);
			_g_free0 (_tmp60_);
			_tmp61_ = g_strdup_printf ("%" G_GINT64_FORMAT, now);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strconcat ("now: ", _tmp62_, NULL);
			_tmp64_ = _tmp63_;
			feed_reader_logger_debug (_tmp64_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
			_tmp65_ = self->priv->m_utils;
			_tmp66_ = accessToken;
			feed_reader_feedly_utils_setAccessToken (_tmp65_, _tmp66_);
			_tmp67_ = self->priv->m_utils;
			feed_reader_feedly_utils_setExpiration (_tmp67_, (gint) (now + expires));
			_tmp68_ = self->priv->m_utils;
			_tmp69_ = refreshToken;
			feed_reader_feedly_utils_setRefreshToken (_tmp68_, _tmp69_);
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			_g_free0 (refreshToken);
			_g_free0 (accessToken);
			_json_object_unref0 (root);
			_g_object_unref0 (parser);
			_g_free0 (message_string);
			_g_object_unref0 (message);
			return result;
		} else {
			JsonObject* _tmp70_;
			_tmp70_ = root;
			if (json_object_has_member (_tmp70_, "errorCode")) {
				JsonObject* _tmp71_;
				const gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				_tmp71_ = root;
				_tmp72_ = json_object_get_string_member (_tmp71_, "errorMessage");
				_tmp73_ = g_strconcat ("Feedly: refreshToken response - ", _tmp72_, NULL);
				_tmp74_ = _tmp73_;
				feed_reader_logger_error (_tmp74_);
				_g_free0 (_tmp74_);
				result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
				_json_object_unref0 (root);
				_g_object_unref0 (parser);
				_g_free0 (message_string);
				_g_object_unref0 (message);
				return result;
			}
		}
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp75_;
		const gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp75_ = e;
		_tmp76_ = _tmp75_->message;
		_tmp77_ = g_strdup_printf ("Could not load response to Message from feedly - %s", _tmp76_);
		_tmp78_ = _tmp77_;
		feed_reader_logger_error (_tmp78_);
		_g_free0 (_tmp78_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (message_string);
		_g_object_unref0 (message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	_g_free0 (message_string);
	_g_object_unref0 (message);
	return result;
}

void
feed_reader_feedly_connection_send_get_request_to_feedly (FeedReaderFeedlyConnection* self,
                                                          const gchar* path,
                                                          FeedReaderResponse* result)
{
	FeedReaderResponse _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	feed_reader_feedly_connection_send_request (self, path, "GET", &_tmp0_);
	*result = _tmp0_;
	return;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
feed_reader_feedly_connection_send_put_request_to_feedly (FeedReaderFeedlyConnection* self,
                                                          const gchar* path,
                                                          JsonNode* root,
                                                          FeedReaderResponse* result)
{
	FeedReaderFeedlyUtils* _tmp0_;
	SoupMessage* message = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	GSettings* _tmp5_;
	JsonGenerator* gen = NULL;
	JsonGenerator* _tmp8_;
	JsonGenerator* _tmp9_;
	SoupMessage* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	FeedReaderFeedlyUtils* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gsize length = 0UL;
	gchar* json = NULL;
	JsonGenerator* _tmp17_;
	gsize _tmp18_ = 0UL;
	gchar* _tmp19_;
	SoupMessage* _tmp20_;
	SoupMessageBody* _tmp21_;
	const gchar* _tmp22_;
	guint8* _tmp23_;
	gint _tmp23__length1;
	gint _tmp24_ = 0;
	guint8* _tmp25_;
	gint _tmp25__length1;
	guint8* _tmp26_;
	gint _tmp26__length1;
	SoupSession* _tmp27_;
	SoupMessage* _tmp28_;
	SoupMessage* _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	SoupMessage* _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	SoupMessage* _tmp35_;
	SoupMessageBody* _tmp36_;
	SoupBuffer* _tmp37_;
	SoupBuffer* _tmp38_;
	guint8* _tmp39_;
	gint _tmp39__length1;
	gchar* _tmp40_;
	FeedReaderResponse _tmp41_ = {0};
	FeedReaderResponse _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = self->priv->m_utils;
	if (!feed_reader_feedly_utils_accessTokenValid (_tmp0_)) {
		feed_reader_feedly_connection_refreshToken (self);
	}
	_tmp1_ = g_strconcat (FEED_READER_FEEDLY_SECRET_base_uri, path, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new ("PUT", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	message = _tmp4_;
	_tmp5_ = self->priv->m_settingsTweaks;
	if (g_settings_get_boolean (_tmp5_, "do-not-track")) {
		SoupMessage* _tmp6_;
		SoupMessageHeaders* _tmp7_;
		_tmp6_ = message;
		_tmp7_ = _tmp6_->request_headers;
		soup_message_headers_append (_tmp7_, "DNT", "1");
	}
	_tmp8_ = json_generator_new ();
	gen = _tmp8_;
	_tmp9_ = gen;
	json_generator_set_root (_tmp9_, root);
	_tmp10_ = message;
	_tmp11_ = _tmp10_->request_headers;
	_tmp12_ = self->priv->m_utils;
	_tmp13_ = feed_reader_feedly_utils_getAccessToken (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("OAuth %s", _tmp14_);
	_tmp16_ = _tmp15_;
	soup_message_headers_append (_tmp11_, "Authorization", _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = gen;
	_tmp19_ = json_generator_to_data (_tmp17_, &_tmp18_);
	length = _tmp18_;
	_g_free0 (json);
	json = _tmp19_;
	_tmp20_ = message;
	_tmp21_ = _tmp20_->request_body;
	_tmp22_ = json;
	_tmp23_ = string_get_data (_tmp22_, &_tmp24_);
	_tmp23__length1 = _tmp24_;
	_tmp25_ = _tmp23_;
	_tmp25__length1 = _tmp23__length1;
	_tmp26_ = (_tmp25_ != NULL) ? _vala_array_dup1 (_tmp25_, _tmp25__length1) : _tmp25_;
	_tmp26__length1 = _tmp25__length1;
	soup_message_body_append_take (_tmp21_, _tmp26_, (gsize) _tmp26__length1);
	_tmp27_ = self->priv->m_session;
	_tmp28_ = message;
	soup_session_send_message (_tmp27_, _tmp28_);
	_tmp29_ = message;
	g_object_get (_tmp29_, "status-code", &_tmp30_, NULL);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != ((guint) 200)) {
		feed_reader_logger_warning ("FeedlyConnection: message unexpected response");
	}
	_tmp32_ = message;
	g_object_get (_tmp32_, "status-code", &_tmp33_, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = message;
	_tmp36_ = _tmp35_->response_body;
	_tmp37_ = soup_message_body_flatten (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _tmp38_->data;
	_tmp39__length1 = _tmp38_->length;
	_tmp40_ = g_strdup ((const gchar*) _tmp39_);
	memset (&_tmp41_, 0, sizeof (FeedReaderResponse));
	_tmp41_.status = _tmp34_;
	_g_free0 (_tmp41_.data);
	_tmp41_.data = _tmp40_;
	_tmp42_ = _tmp41_;
	__vala_SoupBuffer_free0 (_tmp38_);
	*result = _tmp42_;
	_g_free0 (json);
	_g_object_unref0 (gen);
	_g_object_unref0 (message);
	return;
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
feed_reader_feedly_connection_send_post_request_to_feedly (FeedReaderFeedlyConnection* self,
                                                           const gchar* path,
                                                           JsonNode* root,
                                                           FeedReaderResponse* result)
{
	FeedReaderFeedlyUtils* _tmp0_;
	SoupMessage* message = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	GSettings* _tmp5_;
	JsonGenerator* gen = NULL;
	JsonGenerator* _tmp8_;
	JsonGenerator* _tmp9_;
	SoupMessage* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	FeedReaderFeedlyUtils* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gsize length = 0UL;
	gchar* json = NULL;
	JsonGenerator* _tmp17_;
	gsize _tmp18_ = 0UL;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	SoupMessage* _tmp21_;
	SoupMessageBody* _tmp22_;
	const gchar* _tmp23_;
	guint8* _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_ = 0;
	guint8* _tmp26_;
	gint _tmp26__length1;
	guint8* _tmp27_;
	gint _tmp27__length1;
	SoupSession* _tmp28_;
	SoupMessage* _tmp29_;
	SoupMessage* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	SoupMessage* _tmp40_;
	guint _tmp41_;
	guint _tmp42_;
	SoupMessage* _tmp43_;
	SoupMessageBody* _tmp44_;
	SoupBuffer* _tmp45_;
	SoupBuffer* _tmp46_;
	guint8* _tmp47_;
	gint _tmp47__length1;
	gchar* _tmp48_;
	FeedReaderResponse _tmp49_ = {0};
	FeedReaderResponse _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (root != NULL);
	_tmp0_ = self->priv->m_utils;
	if (!feed_reader_feedly_utils_accessTokenValid (_tmp0_)) {
		feed_reader_feedly_connection_refreshToken (self);
	}
	_tmp1_ = g_strconcat (FEED_READER_FEEDLY_SECRET_base_uri, path, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new ("POST", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	message = _tmp4_;
	_tmp5_ = self->priv->m_settingsTweaks;
	if (g_settings_get_boolean (_tmp5_, "do-not-track")) {
		SoupMessage* _tmp6_;
		SoupMessageHeaders* _tmp7_;
		_tmp6_ = message;
		_tmp7_ = _tmp6_->request_headers;
		soup_message_headers_append (_tmp7_, "DNT", "1");
	}
	_tmp8_ = json_generator_new ();
	gen = _tmp8_;
	_tmp9_ = gen;
	json_generator_set_root (_tmp9_, root);
	_tmp10_ = message;
	_tmp11_ = _tmp10_->request_headers;
	_tmp12_ = self->priv->m_utils;
	_tmp13_ = feed_reader_feedly_utils_getAccessToken (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("OAuth %s", _tmp14_);
	_tmp16_ = _tmp15_;
	soup_message_headers_append (_tmp11_, "Authorization", _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = gen;
	_tmp19_ = json_generator_to_data (_tmp17_, &_tmp18_);
	length = _tmp18_;
	_g_free0 (json);
	json = _tmp19_;
	_tmp20_ = json;
	feed_reader_logger_debug (_tmp20_);
	_tmp21_ = message;
	_tmp22_ = _tmp21_->request_body;
	_tmp23_ = json;
	_tmp24_ = string_get_data (_tmp23_, &_tmp25_);
	_tmp24__length1 = _tmp25_;
	_tmp26_ = _tmp24_;
	_tmp26__length1 = _tmp24__length1;
	_tmp27_ = (_tmp26_ != NULL) ? _vala_array_dup2 (_tmp26_, _tmp26__length1) : _tmp26_;
	_tmp27__length1 = _tmp26__length1;
	soup_message_body_append_take (_tmp22_, _tmp27_, (gsize) _tmp27__length1);
	_tmp28_ = self->priv->m_session;
	_tmp29_ = message;
	soup_session_send_message (_tmp28_, _tmp29_);
	_tmp30_ = message;
	g_object_get (_tmp30_, "status-code", &_tmp31_, NULL);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != ((guint) 200)) {
		SoupMessage* _tmp33_;
		guint _tmp34_;
		guint _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		feed_reader_logger_warning ("FeedlyConnection: message unexpected response");
		_tmp33_ = message;
		g_object_get (_tmp33_, "status-code", &_tmp34_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("%u", _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat ("Status Code: ", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		feed_reader_logger_debug (_tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
	}
	_tmp40_ = message;
	g_object_get (_tmp40_, "status-code", &_tmp41_, NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = message;
	_tmp44_ = _tmp43_->response_body;
	_tmp45_ = soup_message_body_flatten (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_->data;
	_tmp47__length1 = _tmp46_->length;
	_tmp48_ = g_strdup ((const gchar*) _tmp47_);
	memset (&_tmp49_, 0, sizeof (FeedReaderResponse));
	_tmp49_.status = _tmp42_;
	_g_free0 (_tmp49_.data);
	_tmp49_.data = _tmp48_;
	_tmp50_ = _tmp49_;
	__vala_SoupBuffer_free0 (_tmp46_);
	*result = _tmp50_;
	_g_free0 (json);
	_g_object_unref0 (gen);
	_g_object_unref0 (message);
	return;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
feed_reader_feedly_connection_send_post_string_request_to_feedly (FeedReaderFeedlyConnection* self,
                                                                  const gchar* path,
                                                                  const gchar* input,
                                                                  const gchar* type,
                                                                  FeedReaderResponse* result)
{
	FeedReaderFeedlyUtils* _tmp0_;
	SoupMessage* message = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	GSettings* _tmp5_;
	SoupMessage* _tmp8_;
	SoupMessageHeaders* _tmp9_;
	FeedReaderFeedlyUtils* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	SoupMessage* _tmp15_;
	SoupMessageHeaders* _tmp16_;
	SoupMessage* _tmp17_;
	SoupMessageBody* _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	gint _tmp20_ = 0;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* _tmp22_;
	gint _tmp22__length1;
	SoupSession* _tmp23_;
	SoupMessage* _tmp24_;
	SoupMessage* _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	SoupMessage* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	SoupMessage* _tmp34_;
	SoupMessageBody* _tmp35_;
	SoupBuffer* _tmp36_;
	SoupBuffer* _tmp37_;
	guint8* _tmp38_;
	gint _tmp38__length1;
	gchar* _tmp39_;
	FeedReaderResponse _tmp40_ = {0};
	FeedReaderResponse _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (input != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->m_utils;
	if (!feed_reader_feedly_utils_accessTokenValid (_tmp0_)) {
		feed_reader_feedly_connection_refreshToken (self);
	}
	_tmp1_ = g_strconcat (FEED_READER_FEEDLY_SECRET_base_uri, path, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new ("POST", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	message = _tmp4_;
	_tmp5_ = self->priv->m_settingsTweaks;
	if (g_settings_get_boolean (_tmp5_, "do-not-track")) {
		SoupMessage* _tmp6_;
		SoupMessageHeaders* _tmp7_;
		_tmp6_ = message;
		_tmp7_ = _tmp6_->request_headers;
		soup_message_headers_append (_tmp7_, "DNT", "1");
	}
	_tmp8_ = message;
	_tmp9_ = _tmp8_->request_headers;
	_tmp10_ = self->priv->m_utils;
	_tmp11_ = feed_reader_feedly_utils_getAccessToken (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("OAuth %s", _tmp12_);
	_tmp14_ = _tmp13_;
	soup_message_headers_append (_tmp9_, "Authorization", _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp15_ = message;
	_tmp16_ = _tmp15_->request_headers;
	soup_message_headers_append (_tmp16_, "Content-Type", type);
	_tmp17_ = message;
	_tmp18_ = _tmp17_->request_body;
	_tmp19_ = string_get_data (input, &_tmp20_);
	_tmp19__length1 = _tmp20_;
	_tmp21_ = _tmp19_;
	_tmp21__length1 = _tmp19__length1;
	_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup3 (_tmp21_, _tmp21__length1) : _tmp21_;
	_tmp22__length1 = _tmp21__length1;
	soup_message_body_append_take (_tmp18_, _tmp22_, (gsize) _tmp22__length1);
	_tmp23_ = self->priv->m_session;
	_tmp24_ = message;
	soup_session_send_message (_tmp23_, _tmp24_);
	_tmp25_ = message;
	g_object_get (_tmp25_, "status-code", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != ((guint) 200)) {
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp28_ = string_to_string (input);
		_tmp29_ = g_strconcat ("FeedlyConnection: message unexpected response - ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		feed_reader_logger_warning (_tmp30_);
		_g_free0 (_tmp30_);
	}
	_tmp31_ = message;
	g_object_get (_tmp31_, "status-code", &_tmp32_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = message;
	_tmp35_ = _tmp34_->response_body;
	_tmp36_ = soup_message_body_flatten (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp37_->data;
	_tmp38__length1 = _tmp37_->length;
	_tmp39_ = g_strdup ((const gchar*) _tmp38_);
	memset (&_tmp40_, 0, sizeof (FeedReaderResponse));
	_tmp40_.status = _tmp33_;
	_g_free0 (_tmp40_.data);
	_tmp40_.data = _tmp39_;
	_tmp41_ = _tmp40_;
	__vala_SoupBuffer_free0 (_tmp37_);
	*result = _tmp41_;
	_g_object_unref0 (message);
	return;
}

void
feed_reader_feedly_connection_send_delete_request_to_feedly (FeedReaderFeedlyConnection* self,
                                                             const gchar* path,
                                                             FeedReaderResponse* result)
{
	FeedReaderResponse _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	feed_reader_feedly_connection_send_request (self, path, "DELETE", &_tmp0_);
	*result = _tmp0_;
	return;
}

static void
feed_reader_feedly_connection_send_request (FeedReaderFeedlyConnection* self,
                                            const gchar* path,
                                            const gchar* type,
                                            FeedReaderResponse* result)
{
	FeedReaderFeedlyUtils* _tmp0_;
	SoupMessage* message = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageHeaders* _tmp6_;
	FeedReaderFeedlyUtils* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GSettings* _tmp13_;
	SoupSession* _tmp16_;
	SoupMessage* _tmp17_;
	SoupMessage* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	SoupMessage* _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	SoupMessage* _tmp24_;
	SoupMessageBody* _tmp25_;
	SoupBuffer* _tmp26_;
	SoupBuffer* _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	FeedReaderResponse _tmp30_ = {0};
	FeedReaderResponse _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->m_utils;
	if (!feed_reader_feedly_utils_accessTokenValid (_tmp0_)) {
		feed_reader_feedly_connection_refreshToken (self);
	}
	_tmp1_ = g_strconcat (FEED_READER_FEEDLY_SECRET_base_uri, path, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = soup_message_new (type, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	message = _tmp4_;
	_tmp5_ = message;
	_tmp6_ = _tmp5_->request_headers;
	_tmp7_ = self->priv->m_utils;
	_tmp8_ = feed_reader_feedly_utils_getAccessToken (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("OAuth ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	soup_message_headers_append (_tmp6_, "Authorization", _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_tmp13_ = self->priv->m_settingsTweaks;
	if (g_settings_get_boolean (_tmp13_, "do-not-track")) {
		SoupMessage* _tmp14_;
		SoupMessageHeaders* _tmp15_;
		_tmp14_ = message;
		_tmp15_ = _tmp14_->request_headers;
		soup_message_headers_append (_tmp15_, "DNT", "1");
	}
	_tmp16_ = self->priv->m_session;
	_tmp17_ = message;
	soup_session_send_message (_tmp16_, _tmp17_);
	_tmp18_ = message;
	g_object_get (_tmp18_, "status-code", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	if (_tmp20_ != ((guint) 200)) {
		feed_reader_logger_warning ("FeedlyConnection: message unexpected response");
	}
	_tmp21_ = message;
	g_object_get (_tmp21_, "status-code", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = message;
	_tmp25_ = _tmp24_->response_body;
	_tmp26_ = soup_message_body_flatten (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_->data;
	_tmp28__length1 = _tmp27_->length;
	_tmp29_ = g_strdup ((const gchar*) _tmp28_);
	memset (&_tmp30_, 0, sizeof (FeedReaderResponse));
	_tmp30_.status = _tmp23_;
	_g_free0 (_tmp30_.data);
	_tmp30_.data = _tmp29_;
	_tmp31_ = _tmp30_;
	__vala_SoupBuffer_free0 (_tmp27_);
	*result = _tmp31_;
	_g_object_unref0 (message);
	return;
}

static void
feed_reader_value_feedly_connection_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
feed_reader_value_feedly_connection_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		feed_reader_feedly_connection_unref (value->data[0].v_pointer);
	}
}

static void
feed_reader_value_feedly_connection_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = feed_reader_feedly_connection_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
feed_reader_value_feedly_connection_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
feed_reader_value_feedly_connection_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FeedReaderFeedlyConnection * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = feed_reader_feedly_connection_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
feed_reader_value_feedly_connection_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	FeedReaderFeedlyConnection ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = feed_reader_feedly_connection_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
feed_reader_param_spec_feedly_connection (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	FeedReaderParamSpecFeedlyConnection* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FEED_READER_TYPE_FEEDLY_CONNECTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
feed_reader_value_get_feedly_connection (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEEDLY_CONNECTION), NULL);
	return value->data[0].v_pointer;
}

void
feed_reader_value_set_feedly_connection (GValue* value,
                                         gpointer v_object)
{
	FeedReaderFeedlyConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEEDLY_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FEEDLY_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		feed_reader_feedly_connection_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_feedly_connection_unref (old);
	}
}

void
feed_reader_value_take_feedly_connection (GValue* value,
                                          gpointer v_object)
{
	FeedReaderFeedlyConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FEEDLY_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FEEDLY_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_feedly_connection_unref (old);
	}
}

static void
feed_reader_feedly_connection_class_init (FeedReaderFeedlyConnectionClass * klass,
                                          gpointer klass_data)
{
	feed_reader_feedly_connection_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderFeedlyConnectionClass *) klass)->finalize = feed_reader_feedly_connection_finalize;
	g_type_class_adjust_private_offset (klass, &FeedReaderFeedlyConnection_private_offset);
}

static void
feed_reader_feedly_connection_instance_init (FeedReaderFeedlyConnection * self,
                                             gpointer klass)
{
	self->priv = feed_reader_feedly_connection_get_instance_private (self);
	self->ref_count = 1;
}

static void
feed_reader_feedly_connection_finalize (FeedReaderFeedlyConnection * obj)
{
	FeedReaderFeedlyConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEEDLY_CONNECTION, FeedReaderFeedlyConnection);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_settingsTweaks);
	_g_object_unref0 (self->priv->m_session);
}

GType
feed_reader_feedly_connection_get_type (void)
{
	return feed_reader_feedly_connection_type_id;
}

GType
feed_reader_feedly_connection_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { feed_reader_value_feedly_connection_init, feed_reader_value_feedly_connection_free_value, feed_reader_value_feedly_connection_copy_value, feed_reader_value_feedly_connection_peek_pointer, "p", feed_reader_value_feedly_connection_collect_value, "p", feed_reader_value_feedly_connection_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderFeedlyConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feedly_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderFeedlyConnection), 0, (GInstanceInitFunc) feed_reader_feedly_connection_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	feed_reader_feedly_connection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FeedReaderFeedlyConnection", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FeedReaderFeedlyConnection_private_offset = sizeof (FeedReaderFeedlyConnectionPrivate);
	return feed_reader_feedly_connection_type_id;
}

gpointer
feed_reader_feedly_connection_ref (gpointer instance)
{
	FeedReaderFeedlyConnection * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
feed_reader_feedly_connection_unref (gpointer instance)
{
	FeedReaderFeedlyConnection * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FEED_READER_FEEDLY_CONNECTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

