/* feedlyInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from feedlyInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "feedly.h"
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <libpeas/peas.h>

#define FEED_READER_FEEDLY_SECRET_apiRedirectUri "http://localhost"
#define FEED_READER_FEEDLY_SECRET_base_uri "http://cloud.feedly.com"
#define FEED_READER_FEEDLY_SECRET_apiClientSecret "FE012EGICU4ZOBDRBEOVAJA1JZYH"
#define FEED_READER_FEEDLY_SECRET_apiClientId "boutroue"
#define FEED_READER_FEEDLY_SECRET_apiAuthScope "https://cloud.feedly.com/subscriptions"

enum  {
	FEED_READER_FEEDLY_INTERFACE_0_PROPERTY,
	FEED_READER_FEEDLY_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_feedly_interface_properties[FEED_READER_FEEDLY_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _FeedReaderfeedlyInterfacePrivate {
	FeedReaderFeedlyAPI* m_api;
	FeedReaderFeedlyUtils* m_utils;
};

static gint FeedReaderfeedlyInterface_private_offset;
static gpointer feed_reader_feedly_interface_parent_class = NULL;
static GType feed_reader_feedly_interface_type_id = 0;

static void feed_reader_feedly_interface_real_init (FeedReaderFeedServerInterface* base,
                                             GSettingsBackend* settings_backend,
                                             SecretCollection* secrets);
static gchar* feed_reader_feedly_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_feedly_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedly_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedly_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedly_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_extractCode (FeedReaderFeedServerInterface* base,
                                                        const gchar* redirectURL);
static gchar* feed_reader_feedly_interface_real_buildLoginURL (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedly_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedly_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedly_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_feedly_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                  const gchar* catID);
static gboolean feed_reader_feedly_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_feedly_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_feedly_interface_real_login (FeedReaderFeedServerInterface* base);
static void feed_reader_feedly_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                         const gchar* articleIDs,
                                                         FeedReaderArticleStatus read);
static void feed_reader_feedly_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                           const gchar* articleID,
                                                           FeedReaderArticleStatus marked);
static gboolean feed_reader_feedly_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_feedly_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                    const gchar* feedID);
static void feed_reader_feedly_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                        const gchar* catID);
static void feed_reader_feedly_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_feedly_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                   const gchar* articleID,
                                                   const gchar* tagID);
static void feed_reader_feedly_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                         const gchar* articleID,
                                                         const gchar* tagID);
static gchar* feed_reader_feedly_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                    const gchar* caption);
static void feed_reader_feedly_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                  const gchar* tagID);
static void feed_reader_feedly_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                  const gchar* tagID,
                                                  const gchar* title);
static gboolean feed_reader_feedly_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_feedly_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feedURL,
                                                    const gchar* catID,
                                                    const gchar* newCatName,
                                                    gchar** feedID,
                                                    gchar** errmsg);
static void feed_reader_feedly_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedID);
static void feed_reader_feedly_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedID,
                                                   const gchar* title);
static void feed_reader_feedly_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                 const gchar* feedID,
                                                 const gchar* newCatID,
                                                 const gchar* currentCatID);
static gchar* feed_reader_feedly_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                         const gchar* title,
                                                         const gchar* parentID);
static void feed_reader_feedly_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                       const gchar* catID,
                                                       const gchar* title);
static void feed_reader_feedly_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                     const gchar* catID,
                                                     const gchar* newParentID);
static void feed_reader_feedly_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                       const gchar* catID);
static void feed_reader_feedly_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                          const gchar* feedID,
                                                          const gchar* catID);
static void feed_reader_feedly_interface_real_importOPML (FeedReaderFeedServerInterface* base,
                                                   const gchar* opml);
static gboolean feed_reader_feedly_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                            GeeList* feeds,
                                                            GeeList* categories,
                                                            GeeList* tags,
                                                            GCancellable* cancellable);
static gint feed_reader_feedly_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_feedly_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                    gint count,
                                                    FeedReaderArticleStatus whatToGet,
                                                    GDateTime* since,
                                                    const gchar* feedID,
                                                    gboolean isTagID,
                                                    GCancellable* cancellable);
static void feed_reader_feedly_interface_finalize (GObject * obj);
GType feed_reader_feedly_api_register_type (GTypeModule * module);
GType feed_reader_feedly_utils_register_type (GTypeModule * module);
GType feed_reader_feedly_connection_register_type (GTypeModule * module);

static inline gpointer
feed_reader_feedly_interface_get_instance_private (FeedReaderfeedlyInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderfeedlyInterface_private_offset);
}

static void
feed_reader_feedly_interface_real_init (FeedReaderFeedServerInterface* base,
                                        GSettingsBackend* settings_backend,
                                        SecretCollection* secrets)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyUtils* _tmp0_;
	FeedReaderFeedlyUtils* _tmp1_;
	FeedReaderFeedlyAPI* _tmp2_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_feedly_utils_new (settings_backend);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_feedly_api_new (_tmp1_);
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp2_;
}

static gchar*
feed_reader_feedly_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("http://feedly.com/");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_feedly_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderfeedlyInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_HOSTED | FEED_READER_BACKEND_FLAGS_PROPRIETARY) | FEED_READER_BACKEND_FLAGS_PAID_PREMIUM;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("feedly");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("feed-service-feedly");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("feedly");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_extractCode (FeedReaderFeedServerInterface* base,
                                               const gchar* redirectURL)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_val_if_fail (redirectURL != NULL, FALSE);
	if (g_str_has_prefix (redirectURL, FEED_READER_FEEDLY_SECRET_apiRedirectUri)) {
		gint start = 0;
		gint end = 0;
		gchar* code = NULL;
		gchar* _tmp0_;
		FeedReaderFeedlyUtils* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		start = string_index_of (redirectURL, "=", 0) + 1;
		end = string_index_of (redirectURL, "&", 0);
		_tmp0_ = string_substring (redirectURL, (glong) start, (glong) (end - start));
		code = _tmp0_;
		_tmp1_ = self->priv->m_utils;
		_tmp2_ = code;
		feed_reader_feedly_utils_setApiCode (_tmp1_, _tmp2_);
		_tmp3_ = code;
		_tmp4_ = g_strconcat ("feedlyLoginWidget: set feedly-api-code: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		feed_reader_logger_debug (_tmp5_);
		_g_free0 (_tmp5_);
		g_usleep ((gulong) 500000);
		result = TRUE;
		_g_free0 (code);
		return result;
	}
	result = FALSE;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_buildLoginURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup (FEED_READER_FEEDLY_SECRET_base_uri "/v3/auth/auth" "?client_secret=" FEED_READER_FEEDLY_SECRET_apiClientSecret "&client_id=" FEED_READER_FEEDLY_SECRET_apiClientId "&redirect_uri=" FEED_READER_FEEDLY_SECRET_apiRedirectUri "&scope=" FEED_READER_FEEDLY_SECRET_apiAuthScope "&response_type=code&state=getting_code");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("feed-service-feedly-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_feedly_utils_getEmail (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("http://feedly.com/");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_feedly_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                         const gchar* catID)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_val_if_fail (catID != NULL, FALSE);
	result = g_str_has_suffix (catID, "global.must");
	return result;
}

static gboolean
feed_reader_feedly_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_feedly_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyUtils* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = self->priv->m_utils;
	feed_reader_feedly_utils_resetAccount (_tmp0_);
}

static gboolean
feed_reader_feedly_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = TRUE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_feedly_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	FeedReaderLoginResponse result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_feedly_api_login (_tmp0_);
	return result;
}

static void
feed_reader_feedly_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                    const gchar* articleIDs,
                                                    FeedReaderArticleStatus read)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (articleIDs != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_mark_as_read (_tmp0_, articleIDs, "entries", read);
}

static void
feed_reader_feedly_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                      const gchar* articleID,
                                                      FeedReaderArticleStatus marked)
{
	FeedReaderfeedlyInterface * self;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (articleID != NULL);
	if (marked == FEED_READER_ARTICLE_STATUS_MARKED) {
		FeedReaderFeedlyAPI* _tmp0_;
		FeedReaderFeedlyAPI* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = self->priv->m_api;
		_tmp1_ = self->priv->m_api;
		_tmp2_ = feed_reader_feedly_api_getMarkedID (_tmp1_);
		_tmp3_ = _tmp2_;
		feed_reader_feedly_api_addArticleTag (_tmp0_, articleID, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		if (marked == FEED_READER_ARTICLE_STATUS_UNMARKED) {
			FeedReaderFeedlyAPI* _tmp4_;
			FeedReaderFeedlyAPI* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = self->priv->m_api;
			_tmp5_ = self->priv->m_api;
			_tmp6_ = feed_reader_feedly_api_getMarkedID (_tmp5_);
			_tmp7_ = _tmp6_;
			feed_reader_feedly_api_deleteArticleTag (_tmp4_, articleID, _tmp7_);
			_g_free0 (_tmp7_);
		}
	}
}

static gboolean
feed_reader_feedly_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_feedly_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                               const gchar* feedID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_mark_as_read (_tmp0_, feedID, "feeds", FEED_READER_ARTICLE_STATUS_READ);
}

static void
feed_reader_feedly_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* catID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_mark_as_read (_tmp0_, catID, "categories", FEED_READER_ARTICLE_STATUS_READ);
}

static void
feed_reader_feedly_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gchar* catArray = NULL;
	gchar* _tmp0_;
	gchar* feedArray = NULL;
	gchar* _tmp1_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp2_;
	GeeList* categories = NULL;
	FeedReaderDataBaseReadOnly* _tmp3_;
	GeeList* _tmp4_;
	GeeList* feeds = NULL;
	FeedReaderDataBaseReadOnly* _tmp5_;
	GeeList* _tmp6_;
	FeedReaderFeedlyAPI* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	FeedReaderFeedlyAPI* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = g_strdup ("");
	catArray = _tmp0_;
	_tmp1_ = g_strdup ("");
	feedArray = _tmp1_;
	_tmp2_ = feed_reader_data_base_readOnly ();
	db = _tmp2_;
	_tmp3_ = db;
	_tmp4_ = feed_reader_data_base_read_only_read_categories (_tmp3_, NULL);
	categories = _tmp4_;
	_tmp5_ = db;
	_tmp6_ = feed_reader_data_base_read_only_read_feeds_without_cat (_tmp5_);
	feeds = _tmp6_;
	{
		GeeList* _cat_list = NULL;
		GeeList* _tmp7_;
		gint _cat_size = 0;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _cat_index = 0;
		_tmp7_ = categories;
		_cat_list = _tmp7_;
		_tmp8_ = _cat_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_cat_size = _tmp10_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			FeedReaderCategory* cat = NULL;
			GeeList* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			FeedReaderCategory* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_cat_index = _cat_index + 1;
			_tmp11_ = _cat_index;
			_tmp12_ = _cat_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _cat_list;
			_tmp14_ = gee_list_get (_tmp13_, _cat_index);
			cat = (FeedReaderCategory*) _tmp14_;
			_tmp15_ = catArray;
			_tmp16_ = cat;
			_tmp17_ = feed_reader_category_getCatID (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
			_g_free0 (catArray);
			catArray = _tmp21_;
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_g_object_unref0 (cat);
		}
	}
	{
		GeeList* _feed_list = NULL;
		GeeList* _tmp22_;
		gint _feed_size = 0;
		GeeList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _feed_index = 0;
		_tmp22_ = feeds;
		_feed_list = _tmp22_;
		_tmp23_ = _feed_list;
		_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_feed_size = _tmp25_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			FeedReaderFeed* feed = NULL;
			GeeList* _tmp28_;
			gpointer _tmp29_;
			const gchar* _tmp30_;
			FeedReaderFeed* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_feed_index = _feed_index + 1;
			_tmp26_ = _feed_index;
			_tmp27_ = _feed_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _feed_list;
			_tmp29_ = gee_list_get (_tmp28_, _feed_index);
			feed = (FeedReaderFeed*) _tmp29_;
			_tmp30_ = feedArray;
			_tmp31_ = feed;
			_tmp32_ = feed_reader_feed_getFeedID (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strconcat (_tmp33_, ",", NULL);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat (_tmp30_, _tmp35_, NULL);
			_g_free0 (feedArray);
			feedArray = _tmp36_;
			_g_free0 (_tmp35_);
			_g_free0 (_tmp33_);
			_g_object_unref0 (feed);
		}
	}
	_tmp37_ = self->priv->m_api;
	_tmp38_ = catArray;
	_tmp39_ = catArray;
	_tmp40_ = strlen (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = string_substring (_tmp38_, (glong) 0, (glong) (_tmp41_ - 1));
	_tmp43_ = _tmp42_;
	feed_reader_feedly_api_mark_as_read (_tmp37_, _tmp43_, "categories", FEED_READER_ARTICLE_STATUS_READ);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->m_api;
	_tmp45_ = feedArray;
	_tmp46_ = feedArray;
	_tmp47_ = strlen (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = string_substring (_tmp45_, (glong) 0, (glong) (_tmp48_ - 1));
	_tmp50_ = _tmp49_;
	feed_reader_feedly_api_mark_as_read (_tmp44_, _tmp50_, "feeds", FEED_READER_ARTICLE_STATUS_READ);
	_g_free0 (_tmp50_);
	_g_object_unref0 (feeds);
	_g_object_unref0 (categories);
	_g_object_unref0 (db);
	_g_free0 (feedArray);
	_g_free0 (catArray);
}

static void
feed_reader_feedly_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                              const gchar* articleID,
                                              const gchar* tagID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_addArticleTag (_tmp0_, articleID, tagID);
}

static void
feed_reader_feedly_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                    const gchar* articleID,
                                                    const gchar* tagID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_deleteArticleTag (_tmp0_, articleID, tagID);
}

static gchar*
feed_reader_feedly_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                             const gchar* caption)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = feed_reader_feedly_api_createTag (_tmp0_, caption);
	result = _tmp1_;
	return result;
}

static void
feed_reader_feedly_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                             const gchar* tagID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_deleteTag (_tmp0_, tagID);
}

static void
feed_reader_feedly_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                             const gchar* tagID,
                                             const gchar* title)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_renameTag (_tmp0_, tagID, title);
}

static gboolean
feed_reader_feedly_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	result = feed_reader_utils_ping ("http://feedly.com/");
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
feed_reader_feedly_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                           const gchar* feedURL,
                                           const gchar* catID,
                                           const gchar* newCatName,
                                           gchar** feedID,
                                           gchar** errmsg)
{
	FeedReaderfeedlyInterface * self;
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	gchar* _tmp0_;
	gboolean success = FALSE;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_val_if_fail (feedURL != NULL, FALSE);
	_tmp0_ = g_strconcat ("feed/", feedURL, NULL);
	_g_free0 (_vala_feedID);
	_vala_feedID = _tmp0_;
	success = FALSE;
	_tmp1_ = g_strdup ("");
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp1_;
	if (catID == NULL) {
		_tmp2_ = newCatName != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* newCatID = NULL;
		FeedReaderFeedlyAPI* _tmp3_;
		gchar* _tmp4_;
		FeedReaderFeedlyAPI* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = self->priv->m_api;
		_tmp4_ = feed_reader_feedly_api_createCatID (_tmp3_, newCatName);
		newCatID = _tmp4_;
		_tmp5_ = self->priv->m_api;
		_tmp6_ = newCatID;
		success = feed_reader_feedly_api_addSubscription (_tmp5_, feedURL, NULL, _tmp6_);
		_g_free0 (newCatID);
	} else {
		FeedReaderFeedlyAPI* _tmp7_;
		_tmp7_ = self->priv->m_api;
		success = feed_reader_feedly_api_addSubscription (_tmp7_, feedURL, NULL, catID);
	}
	if (!success) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = string_to_string (feedURL);
		_tmp9_ = g_strconcat ("feedly could not add ", _tmp8_, NULL);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp9_;
	}
	result = success;
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
feed_reader_feedly_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                              const gchar* feedID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_removeSubscription (_tmp0_, feedID);
}

static void
feed_reader_feedly_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                              const gchar* feedID,
                                              const gchar* title)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeed* feed = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	FeedReaderFeed* _tmp2_;
	FeedReaderFeed* _tmp3_;
	FeedReaderFeedlyAPI* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_read_feed (_tmp1_, feedID);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	feed = _tmp3_;
	_tmp4_ = self->priv->m_api;
	_tmp5_ = feed_reader_feed_getFeedID (feed);
	_tmp6_ = _tmp5_;
	_tmp7_ = feed_reader_feed_getCatString (feed);
	_tmp8_ = _tmp7_;
	feed_reader_feedly_api_addSubscription (_tmp4_, _tmp6_, title, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (feed);
}

static void
feed_reader_feedly_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                            const gchar* feedID,
                                            const gchar* newCatID,
                                            const gchar* currentCatID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_moveSubscription (_tmp0_, feedID, newCatID, currentCatID);
}

static gchar*
feed_reader_feedly_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                  const gchar* title,
                                                  const gchar* parentID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = feed_reader_feedly_api_createCatID (_tmp0_, title);
	result = _tmp1_;
	return result;
}

static void
feed_reader_feedly_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                  const gchar* catID,
                                                  const gchar* title)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_renameCategory (_tmp0_, catID, title);
}

static void
feed_reader_feedly_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                const gchar* catID,
                                                const gchar* newParentID)
{
	FeedReaderfeedlyInterface * self;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	return;
}

static void
feed_reader_feedly_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                  const gchar* catID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_removeCategory (_tmp0_, catID);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
feed_reader_feedly_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                     const gchar* feedID,
                                                     const gchar* catID)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeed* feed = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	FeedReaderFeed* _tmp2_;
	FeedReaderFeed* _tmp3_;
	FeedReaderFeedlyAPI* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_read_feed (_tmp1_, feedID);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	feed = _tmp3_;
	_tmp4_ = self->priv->m_api;
	_tmp5_ = feed_reader_feed_getFeedID (feed);
	_tmp6_ = _tmp5_;
	_tmp7_ = feed_reader_feed_getTitle (feed);
	_tmp8_ = _tmp7_;
	_tmp9_ = feed_reader_feed_getCatString (feed);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (catID, ",", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_replace (_tmp10_, _tmp12_, "");
	_tmp14_ = _tmp13_;
	feed_reader_feedly_api_addSubscription (_tmp4_, _tmp6_, _tmp8_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (feed);
}

static void
feed_reader_feedly_interface_real_importOPML (FeedReaderFeedServerInterface* base,
                                              const gchar* opml)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_if_fail (opml != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_importOPML (_tmp0_, opml);
}

static gboolean
feed_reader_feedly_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                   GeeList* feeds,
                                                   GeeList* categories,
                                                   GeeList* tags,
                                                   GCancellable* cancellable)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	FeedReaderFeedlyAPI* _tmp1_;
	gboolean result;
	self = (FeedReaderfeedlyInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_api;
	feed_reader_feedly_api_getUnreadCounts (_tmp0_);
	_tmp1_ = self->priv->m_api;
	if (feed_reader_feedly_api_getCategories (_tmp1_, categories)) {
		gboolean _tmp2_ = FALSE;
		FeedReaderFeedlyAPI* _tmp3_;
		if (cancellable != NULL) {
			_tmp2_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			result = FALSE;
			return result;
		}
		_tmp3_ = self->priv->m_api;
		if (feed_reader_feedly_api_getFeeds (_tmp3_, feeds)) {
			gboolean _tmp4_ = FALSE;
			FeedReaderFeedlyAPI* _tmp5_;
			if (cancellable != NULL) {
				_tmp4_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				result = FALSE;
				return result;
			}
			_tmp5_ = self->priv->m_api;
			if (feed_reader_feedly_api_getTags (_tmp5_, tags)) {
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gint
feed_reader_feedly_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderfeedlyInterface * self;
	FeedReaderFeedlyAPI* _tmp0_;
	gint result;
	self = (FeedReaderfeedlyInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_feedly_api_getTotalUnread (_tmp0_);
	return result;
}

static void
feed_reader_feedly_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                               gint count,
                                               FeedReaderArticleStatus whatToGet,
                                               GDateTime* since,
                                               const gchar* feedID,
                                               gboolean isTagID,
                                               GCancellable* cancellable)
{
	FeedReaderfeedlyInterface * self;
	gchar* continuation = NULL;
	gchar* feedly_tagID = NULL;
	gchar* _tmp0_;
	gchar* feedly_feedID = NULL;
	gchar* _tmp1_;
	gint skip = 0;
	gint amount = 0;
	GeeLinkedList* articles = NULL;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* _tmp13_;
	self = (FeedReaderfeedlyInterface*) base;
	continuation = NULL;
	_tmp0_ = g_strdup ("");
	feedly_tagID = _tmp0_;
	_tmp1_ = g_strdup ("");
	feedly_feedID = _tmp1_;
	if (feedID != NULL) {
		if (isTagID) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (feedID);
			_g_free0 (feedly_tagID);
			feedly_tagID = _tmp2_;
		} else {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (feedID);
			_g_free0 (feedly_feedID);
			feedly_feedID = _tmp3_;
		}
	}
	skip = count;
	amount = 200;
	_tmp4_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		FeedReaderFeedlyAPI* _tmp6_;
		GeeLinkedList* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		if (!(skip > 0)) {
			break;
		}
		if (cancellable != NULL) {
			_tmp5_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_g_object_unref0 (articles);
			_g_free0 (feedly_feedID);
			_g_free0 (feedly_tagID);
			_g_free0 (continuation);
			return;
		}
		if (skip >= amount) {
			skip -= amount;
		} else {
			amount = skip;
			skip = 0;
		}
		_tmp6_ = self->priv->m_api;
		_tmp7_ = articles;
		_tmp8_ = continuation;
		_tmp9_ = feedly_tagID;
		_tmp10_ = feedly_feedID;
		_tmp11_ = feed_reader_feedly_api_getArticles (_tmp6_, (GeeList*) _tmp7_, amount, _tmp8_, whatToGet, _tmp9_, _tmp10_);
		_g_free0 (continuation);
		continuation = _tmp11_;
		_tmp12_ = continuation;
		if (_tmp12_ == NULL) {
			break;
		}
	}
	_tmp13_ = articles;
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "write-articles", (GeeList*) _tmp13_);
	_g_object_unref0 (articles);
	_g_free0 (feedly_feedID);
	_g_free0 (feedly_tagID);
	_g_free0 (continuation);
}

FeedReaderfeedlyInterface*
feed_reader_feedly_interface_construct (GType object_type)
{
	FeedReaderfeedlyInterface * self = NULL;
	self = (FeedReaderfeedlyInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderfeedlyInterface*
feed_reader_feedly_interface_new (void)
{
	return feed_reader_feedly_interface_construct (FEED_READER_TYPE_FEEDLY_INTERFACE);
}

static void
feed_reader_feedly_interface_class_init (FeedReaderfeedlyInterfaceClass * klass,
                                         gpointer klass_data)
{
	feed_reader_feedly_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderfeedlyInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_feedly_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->extractCode = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_extractCode;
	((FeedReaderFeedServerInterfaceClass *) klass)->buildLoginURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_buildLoginURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feedly_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_feedly_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_feedly_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_feedly_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->importOPML = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_feedly_interface_real_importOPML;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_feedly_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_feedly_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_feedly_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_feedly_interface_finalize;
}

static void
feed_reader_feedly_interface_instance_init (FeedReaderfeedlyInterface * self,
                                            gpointer klass)
{
	self->priv = feed_reader_feedly_interface_get_instance_private (self);
}

static void
feed_reader_feedly_interface_finalize (GObject * obj)
{
	FeedReaderfeedlyInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FEEDLY_INTERFACE, FeedReaderfeedlyInterface);
	_g_object_unref0 (self->priv->m_api);
	_g_object_unref0 (self->priv->m_utils);
	G_OBJECT_CLASS (feed_reader_feedly_interface_parent_class)->finalize (obj);
}

GType
feed_reader_feedly_interface_get_type (void)
{
	return feed_reader_feedly_interface_type_id;
}

GType
feed_reader_feedly_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderfeedlyInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_feedly_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderfeedlyInterface), 0, (GInstanceInitFunc) feed_reader_feedly_interface_instance_init, NULL };
	feed_reader_feedly_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderfeedlyInterface", &g_define_type_info, 0);
	FeedReaderfeedlyInterface_private_offset = sizeof (FeedReaderfeedlyInterfacePrivate);
	return feed_reader_feedly_interface_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_feedly_api_register_type (module);
	feed_reader_feedly_interface_register_type (module);
	feed_reader_feedly_utils_register_type (module);
	feed_reader_feedly_connection_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_FEEDLY_INTERFACE);
	_g_object_unref0 (objmodule);
}

