/* freshAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from freshAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "fresh.h"
#include <glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <json-glib/json-glib.h>

enum  {
	FEED_READER_FRESH_API_0_PROPERTY,
	FEED_READER_FRESH_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_fresh_api_properties[FEED_READER_FRESH_API_NUM_PROPERTIES];
#define _feed_reader_fresh_connection_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_fresh_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _feed_reader_fresh_message_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_fresh_message_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FeedReaderfreshAPIPrivate {
	FeedReaderfreshConnection* m_connection;
	FeedReaderfreshUtils* m_utils;
};

static gint FeedReaderfreshAPI_private_offset;
static gpointer feed_reader_fresh_api_parent_class = NULL;
static GType feed_reader_fresh_api_type_id = 0;

static void feed_reader_fresh_api_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
feed_reader_fresh_api_get_instance_private (FeedReaderfreshAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderfreshAPI_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderfreshAPI*
feed_reader_fresh_api_construct (GType object_type,
                                 FeedReaderfreshUtils* utils)
{
	FeedReaderfreshAPI * self = NULL;
	FeedReaderfreshUtils* _tmp0_;
	FeedReaderfreshUtils* _tmp1_;
	FeedReaderfreshConnection* _tmp2_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderfreshAPI*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_fresh_connection_new (_tmp1_);
	_feed_reader_fresh_connection_unref0 (self->priv->m_connection);
	self->priv->m_connection = _tmp2_;
	return self;
}

FeedReaderfreshAPI*
feed_reader_fresh_api_new (FeedReaderfreshUtils* utils)
{
	return feed_reader_fresh_api_construct (FEED_READER_TYPE_FRESH_API, utils);
}

FeedReaderLoginResponse
feed_reader_fresh_api_login (FeedReaderfreshAPI* self)
{
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	FeedReaderfreshConnection* _tmp4_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_logger_debug ("fresh backend: login");
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getApiURL (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = !feed_reader_utils_ping (_tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
		return result;
	}
	_tmp4_ = self->priv->m_connection;
	result = feed_reader_fresh_connection_getSID (_tmp4_);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

gboolean
feed_reader_fresh_api_getSubscriptionList (FeedReaderfreshAPI* self,
                                           GeeList* feeds)
{
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonArray* array = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonArray* _tmp13_;
	JsonArray* _tmp14_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_fresh_connection_getRequest (_tmp0_, "reader/api/0/subscription/list?output=json", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTagList: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = json_object_get_array_member (_tmp12_, "subscriptions");
	_tmp14_ = _json_array_ref0 (_tmp13_);
	array = _tmp14_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp17_;
				JsonObject* object = NULL;
				JsonArray* _tmp18_;
				JsonObject* _tmp19_;
				JsonObject* _tmp20_;
				gchar* url = NULL;
				JsonObject* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* id = NULL;
				JsonObject* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* catID = NULL;
				JsonObject* _tmp27_;
				JsonArray* _tmp28_;
				JsonObject* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* xmlURL = NULL;
				JsonObject* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				JsonObject* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				GeeList* _tmp40_;
				GeeList* _tmp41_;
				JsonObject* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				FeedReaderFeed* _tmp45_;
				FeedReaderFeed* _tmp46_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp17_))) {
					break;
				}
				_tmp18_ = array;
				_tmp19_ = json_array_get_object_element (_tmp18_, (guint) i);
				_tmp20_ = _json_object_ref0 (_tmp19_);
				object = _tmp20_;
				_tmp21_ = object;
				_tmp22_ = json_object_get_string_member (_tmp21_, "htmlUrl");
				_tmp23_ = g_strdup (_tmp22_);
				url = _tmp23_;
				_tmp24_ = object;
				_tmp25_ = json_object_get_string_member (_tmp24_, "id");
				_tmp26_ = g_strdup (_tmp25_);
				id = _tmp26_;
				_tmp27_ = object;
				_tmp28_ = json_object_get_array_member (_tmp27_, "categories");
				_tmp29_ = json_array_get_object_element (_tmp28_, (guint) 0);
				_tmp30_ = json_object_get_string_member (_tmp29_, "id");
				_tmp31_ = g_strdup (_tmp30_);
				catID = _tmp31_;
				_tmp32_ = object;
				_tmp33_ = json_object_get_string_member (_tmp32_, "url");
				_tmp34_ = g_strdup (_tmp33_);
				xmlURL = _tmp34_;
				_tmp35_ = id;
				_tmp36_ = object;
				_tmp37_ = json_object_get_string_member (_tmp36_, "title");
				_tmp38_ = url;
				_tmp39_ = catID;
				_tmp40_ = feed_reader_list_utils_single (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = object;
				_tmp43_ = json_object_get_string_member (_tmp42_, "iconUrl");
				_tmp44_ = xmlURL;
				_tmp45_ = feed_reader_feed_new (_tmp35_, _tmp37_, _tmp38_, (guint) 0, _tmp41_, _tmp43_, _tmp44_);
				_tmp46_ = _tmp45_;
				gee_collection_add ((GeeCollection*) feeds, _tmp46_);
				_g_object_unref0 (_tmp46_);
				_g_object_unref0 (_tmp41_);
				_g_free0 (xmlURL);
				_g_free0 (catID);
				_g_free0 (id);
				_g_free0 (url);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gboolean
feed_reader_fresh_api_getTagList (FeedReaderfreshAPI* self,
                                  GeeList* categories)
{
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	gchar* prefix = NULL;
	gchar* _tmp2_;
	FeedReaderResponse _tmp3_;
	JsonParser* parser = NULL;
	JsonParser* _tmp4_;
	JsonArray* array = NULL;
	JsonParser* _tmp11_;
	JsonNode* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* _tmp14_;
	JsonArray* _tmp15_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_fresh_connection_getRequest (_tmp0_, "reader/api/0/tag/list?output=json", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = g_strdup ("user/-/label/");
	prefix = _tmp2_;
	_tmp3_ = response;
	if (_tmp3_.status != ((guint) 200)) {
		result = FALSE;
		_g_free0 (prefix);
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		JsonParser* _tmp5_;
		FeedReaderResponse _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = parser;
		_tmp6_ = response;
		_tmp7_ = _tmp6_.data;
		json_parser_load_from_data (_tmp5_, _tmp7_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTagList: Could not load message response");
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		feed_reader_logger_error (_tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		_g_free0 (prefix);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (parser);
		_g_free0 (prefix);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = parser;
	_tmp12_ = json_parser_get_root (_tmp11_);
	_tmp13_ = json_node_get_object (_tmp12_);
	_tmp14_ = json_object_get_array_member (_tmp13_, "tags");
	_tmp15_ = _json_array_ref0 (_tmp14_);
	array = _tmp15_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp18_;
				JsonObject* object = NULL;
				JsonArray* _tmp19_;
				JsonObject* _tmp20_;
				JsonObject* _tmp21_;
				gchar* categorieID = NULL;
				JsonObject* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				FeedReaderCategory* _tmp36_;
				FeedReaderCategory* _tmp37_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp18_))) {
					break;
				}
				_tmp19_ = array;
				_tmp20_ = json_array_get_object_element (_tmp19_, (guint) i);
				_tmp21_ = _json_object_ref0 (_tmp20_);
				object = _tmp21_;
				_tmp22_ = object;
				_tmp23_ = json_object_get_string_member (_tmp22_, "id");
				_tmp24_ = g_strdup (_tmp23_);
				categorieID = _tmp24_;
				_tmp25_ = categorieID;
				_tmp26_ = prefix;
				if (!g_str_has_prefix (_tmp25_, _tmp26_)) {
					_g_free0 (categorieID);
					_json_object_unref0 (object);
					continue;
				}
				_tmp27_ = categorieID;
				_tmp28_ = categorieID;
				_tmp29_ = prefix;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = string_substring (_tmp28_, (glong) _tmp31_, (glong) -1);
				_tmp33_ = _tmp32_;
				_tmp34_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
				_tmp35_ = _tmp34_;
				_tmp36_ = feed_reader_category_new (_tmp27_, _tmp33_, (guint) 0, i + 1, _tmp35_, 1);
				_tmp37_ = _tmp36_;
				gee_collection_add ((GeeCollection*) categories, _tmp37_);
				_g_object_unref0 (_tmp37_);
				_g_free0 (_tmp35_);
				_g_free0 (_tmp33_);
				_g_free0 (categorieID);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_g_object_unref0 (parser);
	_g_free0 (prefix);
	feed_reader_response_destroy (&response);
	return result;
}

gint
feed_reader_fresh_api_getUnreadCounts (FeedReaderfreshAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	gint count = 0;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonArray* array = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonArray* _tmp13_;
	JsonArray* _tmp14_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_connection;
	feed_reader_fresh_connection_getRequest (_tmp0_, "reader/api/0/unread-count?output=json", &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = 0;
		feed_reader_response_destroy (&response);
		return result;
	}
	count = 0;
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTagList: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = json_object_get_array_member (_tmp12_, "unreadcounts");
	_tmp14_ = _json_array_ref0 (_tmp13_);
	array = _tmp14_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				JsonArray* _tmp17_;
				JsonObject* object = NULL;
				JsonArray* _tmp18_;
				JsonObject* _tmp19_;
				JsonObject* _tmp20_;
				JsonObject* _tmp21_;
				const gchar* _tmp22_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = array;
				if (!(((guint) i) < json_array_get_length (_tmp17_))) {
					break;
				}
				_tmp18_ = array;
				_tmp19_ = json_array_get_object_element (_tmp18_, (guint) i);
				_tmp20_ = _json_object_ref0 (_tmp19_);
				object = _tmp20_;
				_tmp21_ = object;
				_tmp22_ = json_object_get_string_member (_tmp21_, "id");
				if (g_strcmp0 (_tmp22_, "user/-/state/com.google/reading-list") == 0) {
					JsonObject* _tmp23_;
					_tmp23_ = object;
					count = (gint) json_object_get_int_member (_tmp23_, "count");
				}
				_json_object_unref0 (object);
			}
		}
	}
	result = count;
	_json_array_unref0 (array);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

gchar*
feed_reader_fresh_api_getStreamContents (FeedReaderfreshAPI* self,
                                         GeeList* articles,
                                         const gchar* feedID,
                                         const gchar* labelID,
                                         const gchar* exclude,
                                         gint count,
                                         const gchar* order,
                                         const gchar* checkpoint)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	FeedReaderfreshMessage* msg = NULL;
	FeedReaderfreshMessage* _tmp10_;
	FeedReaderfreshMessage* _tmp11_;
	FeedReaderfreshMessage* _tmp12_;
	FeedReaderfreshMessage* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	FeedReaderfreshMessage* _tmp16_;
	FeedReaderfreshMessage* _tmp17_;
	GDateTime* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	FeedReaderfreshMessage* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	FeedReaderfreshMessage* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	FeedReaderResponse _tmp37_ = {0};
	FeedReaderResponse _tmp38_;
	FeedReaderResponse _tmp39_;
	JsonParser* parser = NULL;
	JsonParser* _tmp40_;
	JsonObject* root = NULL;
	JsonParser* _tmp46_;
	JsonNode* _tmp47_;
	JsonObject* _tmp48_;
	JsonObject* _tmp49_;
	JsonArray* array = NULL;
	JsonObject* _tmp50_;
	JsonArray* _tmp51_;
	JsonArray* _tmp52_;
	guint length = 0U;
	JsonArray* _tmp53_;
	gboolean _tmp120_ = FALSE;
	JsonObject* _tmp121_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articles != NULL, NULL);
	g_return_val_if_fail (order != NULL, NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = g_strdup ("reader/api/0/stream/contents");
	path = _tmp1_;
	if (feedID != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = path;
		_tmp3_ = g_strconcat ("/", feedID, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
		_g_free0 (path);
		path = _tmp5_;
		_g_free0 (_tmp4_);
	} else {
		if (labelID != NULL) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp6_ = path;
			_tmp7_ = g_strconcat ("/", labelID, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
			_g_free0 (path);
			path = _tmp9_;
			_g_free0 (_tmp8_);
		}
	}
	_tmp10_ = feed_reader_fresh_message_new ();
	msg = _tmp10_;
	_tmp11_ = msg;
	feed_reader_fresh_message_add (_tmp11_, "output", "json");
	_tmp12_ = msg;
	feed_reader_fresh_message_add (_tmp12_, "r", order);
	_tmp13_ = msg;
	_tmp14_ = g_strdup_printf ("%i", count);
	_tmp15_ = _tmp14_;
	feed_reader_fresh_message_add (_tmp13_, "n", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = msg;
	feed_reader_fresh_message_add (_tmp16_, "client", "FeedReader");
	_tmp17_ = msg;
	_tmp18_ = now;
	_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_date_time_to_unix (_tmp18_));
	_tmp20_ = _tmp19_;
	feed_reader_fresh_message_add (_tmp17_, "ck", _tmp20_);
	_g_free0 (_tmp20_);
	if (exclude != NULL) {
		FeedReaderfreshMessage* _tmp21_;
		_tmp21_ = msg;
		feed_reader_fresh_message_add (_tmp21_, "xt", exclude);
	}
	if (checkpoint != NULL) {
		FeedReaderfreshMessage* _tmp22_;
		_tmp22_ = msg;
		feed_reader_fresh_message_add (_tmp22_, "c", checkpoint);
	}
	_tmp23_ = msg;
	_tmp24_ = feed_reader_fresh_message_get (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup_printf ("getStreamContents: %s", _tmp25_);
	_tmp27_ = _tmp26_;
	feed_reader_logger_debug (_tmp27_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = self->priv->m_connection;
	_tmp29_ = path;
	_tmp30_ = g_strconcat (_tmp29_, "?", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = msg;
	_tmp33_ = feed_reader_fresh_message_get (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	feed_reader_fresh_connection_getRequest (_tmp28_, _tmp36_, &_tmp37_);
	_tmp38_ = _tmp37_;
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp31_);
	response = _tmp38_;
	_tmp39_ = response;
	if (_tmp39_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_feed_reader_fresh_message_unref0 (msg);
		_g_free0 (path);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp40_ = json_parser_new ();
	parser = _tmp40_;
	{
		JsonParser* _tmp41_;
		FeedReaderResponse _tmp42_;
		const gchar* _tmp43_;
		_tmp41_ = parser;
		_tmp42_ = response;
		_tmp43_ = _tmp42_.data;
		json_parser_load_from_data (_tmp41_, _tmp43_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getStreamContents: Could not load message response");
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		feed_reader_logger_error (_tmp45_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_fresh_message_unref0 (msg);
		_g_free0 (path);
		_g_date_time_unref0 (now);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp46_ = parser;
	_tmp47_ = json_parser_get_root (_tmp46_);
	_tmp48_ = json_node_get_object (_tmp47_);
	_tmp49_ = _json_object_ref0 (_tmp48_);
	root = _tmp49_;
	_tmp50_ = root;
	_tmp51_ = json_object_get_array_member (_tmp50_, "items");
	_tmp52_ = _json_array_ref0 (_tmp51_);
	array = _tmp52_;
	_tmp53_ = array;
	length = json_array_get_length (_tmp53_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp54_ = FALSE;
			_tmp54_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp56_;
				JsonObject* _tmp57_;
				JsonObject* _tmp58_;
				gchar* id = NULL;
				JsonObject* _tmp59_;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				gboolean marked = FALSE;
				gboolean read = FALSE;
				JsonArray* cats = NULL;
				JsonObject* _tmp62_;
				JsonArray* _tmp63_;
				JsonArray* _tmp64_;
				guint cat_length = 0U;
				JsonArray* _tmp65_;
				GeeArrayList* enclosures = NULL;
				GeeArrayList* _tmp73_;
				JsonObject* _tmp74_;
				FeedReaderArticleStatus _tmp97_ = 0;
				FeedReaderArticleStatus _tmp98_ = 0;
				const gchar* _tmp99_;
				JsonObject* _tmp100_;
				const gchar* _tmp101_;
				JsonObject* _tmp102_;
				JsonArray* _tmp103_;
				JsonObject* _tmp104_;
				const gchar* _tmp105_;
				JsonObject* _tmp106_;
				JsonObject* _tmp107_;
				const gchar* _tmp108_;
				JsonObject* _tmp109_;
				JsonObject* _tmp110_;
				const gchar* _tmp111_;
				JsonObject* _tmp112_;
				const gchar* _tmp113_;
				JsonObject* _tmp114_;
				GDateTime* _tmp115_;
				GDateTime* _tmp116_;
				GeeArrayList* _tmp117_;
				FeedReaderArticle* _tmp118_;
				FeedReaderArticle* _tmp119_;
				if (!_tmp54_) {
					guint _tmp55_;
					_tmp55_ = i;
					i = _tmp55_ + 1;
				}
				_tmp54_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp56_ = array;
				_tmp57_ = json_array_get_object_element (_tmp56_, i);
				_tmp58_ = _json_object_ref0 (_tmp57_);
				object = _tmp58_;
				_tmp59_ = object;
				_tmp60_ = json_object_get_string_member (_tmp59_, "id");
				_tmp61_ = g_strdup (_tmp60_);
				id = _tmp61_;
				marked = FALSE;
				read = FALSE;
				_tmp62_ = object;
				_tmp63_ = json_object_get_array_member (_tmp62_, "categories");
				_tmp64_ = _json_array_ref0 (_tmp63_);
				cats = _tmp64_;
				_tmp65_ = cats;
				cat_length = json_array_get_length (_tmp65_);
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp66_ = FALSE;
						_tmp66_ = TRUE;
						while (TRUE) {
							gchar* cat = NULL;
							JsonArray* _tmp68_;
							const gchar* _tmp69_;
							gchar* _tmp70_;
							const gchar* _tmp71_;
							if (!_tmp66_) {
								guint _tmp67_;
								_tmp67_ = j;
								j = _tmp67_ + 1;
							}
							_tmp66_ = FALSE;
							if (!(j < cat_length)) {
								break;
							}
							_tmp68_ = cats;
							_tmp69_ = json_array_get_string_element (_tmp68_, j);
							_tmp70_ = g_strdup (_tmp69_);
							cat = _tmp70_;
							_tmp71_ = cat;
							if (g_str_has_suffix (_tmp71_, "com.google/starred")) {
								marked = TRUE;
							} else {
								const gchar* _tmp72_;
								_tmp72_ = cat;
								if (g_str_has_suffix (_tmp72_, "com.google/read")) {
									read = TRUE;
								}
							}
							_g_free0 (cat);
						}
					}
				}
				_tmp73_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				enclosures = _tmp73_;
				_tmp74_ = object;
				if (json_object_has_member (_tmp74_, "enclosure")) {
					JsonArray* attachments = NULL;
					JsonObject* _tmp75_;
					JsonArray* _tmp76_;
					JsonArray* _tmp77_;
					guint mediaCount = 0U;
					JsonArray* _tmp78_;
					_tmp75_ = object;
					_tmp76_ = json_object_get_array_member (_tmp75_, "enclosure");
					_tmp77_ = _json_array_ref0 (_tmp76_);
					attachments = _tmp77_;
					mediaCount = (guint) 0;
					_tmp78_ = attachments;
					if (_tmp78_ != NULL) {
						JsonArray* _tmp79_;
						_tmp79_ = attachments;
						mediaCount = json_array_get_length (_tmp79_);
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp80_ = FALSE;
							_tmp80_ = TRUE;
							while (TRUE) {
								JsonObject* attachment = NULL;
								JsonArray* _tmp82_;
								JsonObject* _tmp83_;
								JsonObject* _tmp84_;
								const gchar* _tmp85_ = NULL;
								JsonObject* _tmp86_;
								gchar* type = NULL;
								gchar* _tmp89_;
								GeeArrayList* _tmp90_;
								const gchar* _tmp91_;
								JsonObject* _tmp92_;
								const gchar* _tmp93_;
								const gchar* _tmp94_;
								FeedReaderEnclosure* _tmp95_;
								FeedReaderEnclosure* _tmp96_;
								if (!_tmp80_) {
									gint _tmp81_;
									j = j + 1;
									_tmp81_ = j;
								}
								_tmp80_ = FALSE;
								if (!(((guint) j) < mediaCount)) {
									break;
								}
								_tmp82_ = attachments;
								_tmp83_ = json_array_get_object_element (_tmp82_, (guint) j);
								_tmp84_ = _json_object_ref0 (_tmp83_);
								attachment = _tmp84_;
								_tmp86_ = attachment;
								if (json_object_has_member (_tmp86_, "type")) {
									JsonObject* _tmp87_;
									const gchar* _tmp88_;
									_tmp87_ = attachment;
									_tmp88_ = json_object_get_string_member (_tmp87_, "type");
									_tmp85_ = _tmp88_;
								} else {
									_tmp85_ = "";
								}
								_tmp89_ = g_strdup (_tmp85_);
								type = _tmp89_;
								_tmp90_ = enclosures;
								_tmp91_ = id;
								_tmp92_ = attachment;
								_tmp93_ = json_object_get_string_member (_tmp92_, "href");
								_tmp94_ = type;
								_tmp95_ = feed_reader_enclosure_new (_tmp91_, _tmp93_, feed_reader_enclosure_type_from_string (_tmp94_));
								_tmp96_ = _tmp95_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp90_, _tmp96_);
								_g_object_unref0 (_tmp96_);
								_g_free0 (type);
								_json_object_unref0 (attachment);
							}
						}
					}
					_json_array_unref0 (attachments);
				}
				if (read) {
					_tmp97_ = FEED_READER_ARTICLE_STATUS_READ;
				} else {
					_tmp97_ = FEED_READER_ARTICLE_STATUS_UNREAD;
				}
				if (marked) {
					_tmp98_ = FEED_READER_ARTICLE_STATUS_MARKED;
				} else {
					_tmp98_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
				}
				_tmp99_ = id;
				_tmp100_ = object;
				_tmp101_ = json_object_get_string_member (_tmp100_, "title");
				_tmp102_ = object;
				_tmp103_ = json_object_get_array_member (_tmp102_, "alternate");
				_tmp104_ = json_array_get_object_element (_tmp103_, (guint) 0);
				_tmp105_ = json_object_get_string_member (_tmp104_, "href");
				_tmp106_ = object;
				_tmp107_ = json_object_get_object_member (_tmp106_, "origin");
				_tmp108_ = json_object_get_string_member (_tmp107_, "streamId");
				_tmp109_ = object;
				_tmp110_ = json_object_get_object_member (_tmp109_, "summary");
				_tmp111_ = json_object_get_string_member (_tmp110_, "content");
				_tmp112_ = object;
				_tmp113_ = json_object_get_string_member (_tmp112_, "author");
				_tmp114_ = object;
				_tmp115_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp114_, "published"));
				_tmp116_ = _tmp115_;
				_tmp117_ = enclosures;
				_tmp118_ = feed_reader_article_new (_tmp99_, _tmp101_, _tmp105_, _tmp108_, _tmp97_, _tmp98_, _tmp111_, NULL, _tmp113_, _tmp116_, -1, NULL, (GeeList*) _tmp117_, "", 0);
				_tmp119_ = _tmp118_;
				gee_collection_add ((GeeCollection*) articles, _tmp119_);
				_g_object_unref0 (_tmp119_);
				_g_date_time_unref0 (_tmp116_);
				_g_object_unref0 (enclosures);
				_json_array_unref0 (cats);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp121_ = root;
	if (json_object_has_member (_tmp121_, "continuation")) {
		JsonObject* _tmp122_;
		const gchar* _tmp123_;
		_tmp122_ = root;
		_tmp123_ = json_object_get_string_member (_tmp122_, "continuation");
		_tmp120_ = g_strcmp0 (_tmp123_, "") != 0;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		JsonObject* _tmp124_;
		const gchar* _tmp125_;
		gchar* _tmp126_;
		_tmp124_ = root;
		_tmp125_ = json_object_get_string_member (_tmp124_, "continuation");
		_tmp126_ = g_strdup (_tmp125_);
		result = _tmp126_;
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_feed_reader_fresh_message_unref0 (msg);
		_g_free0 (path);
		_g_date_time_unref0 (now);
		return result;
	}
	result = NULL;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_feed_reader_fresh_message_unref0 (msg);
	_g_free0 (path);
	_g_date_time_unref0 (now);
	return result;
}

void
feed_reader_fresh_api_editTags (FeedReaderfreshAPI* self,
                                const gchar* articleIDs,
                                const gchar* addTag,
                                const gchar* removeTag)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar** arrayID = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint arrayID_length1;
	gint _arrayID_size_;
	FeedReaderfreshMessage* msg = NULL;
	FeedReaderfreshMessage* _tmp3_;
	FeedReaderfreshMessage* _tmp4_;
	FeedReaderfreshConnection* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp16_;
	const gchar* _tmp17_;
	FeedReaderfreshMessage* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	FeedReaderResponse _tmp21_ = {0};
	FeedReaderResponse _tmp22_;
	FeedReaderResponse _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleIDs != NULL);
	_tmp0_ = g_strdup ("reader/api/0/edit-tag");
	path = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (articleIDs, ",", 0);
	arrayID = _tmp2_;
	arrayID_length1 = _vala_array_length (_tmp1_);
	_arrayID_size_ = arrayID_length1;
	_tmp3_ = feed_reader_fresh_message_new ();
	msg = _tmp3_;
	_tmp4_ = msg;
	_tmp5_ = self->priv->m_connection;
	_tmp6_ = feed_reader_fresh_connection_getToken (_tmp5_);
	_tmp7_ = _tmp6_;
	feed_reader_fresh_message_add (_tmp4_, "T", _tmp7_);
	_g_free0 (_tmp7_);
	if (addTag != NULL) {
		FeedReaderfreshMessage* _tmp8_;
		_tmp8_ = msg;
		feed_reader_fresh_message_add (_tmp8_, "a", addTag);
	}
	if (removeTag != NULL) {
		FeedReaderfreshMessage* _tmp9_;
		_tmp9_ = msg;
		feed_reader_fresh_message_add (_tmp9_, "r", removeTag);
	}
	_tmp10_ = arrayID;
	_tmp10__length1 = arrayID_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp10_;
		id_collection_length1 = _tmp10__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			gchar* _tmp11_;
			gchar* id = NULL;
			_tmp11_ = g_strdup (id_collection[id_it]);
			id = _tmp11_;
			{
				FeedReaderfreshMessage* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = msg;
				_tmp13_ = id;
				_tmp14_ = g_strconcat ("-/", _tmp13_, NULL);
				_tmp15_ = _tmp14_;
				feed_reader_fresh_message_add (_tmp12_, "i", _tmp15_);
				_g_free0 (_tmp15_);
				_g_free0 (id);
			}
		}
	}
	_tmp16_ = self->priv->m_connection;
	_tmp17_ = path;
	_tmp18_ = msg;
	_tmp19_ = feed_reader_fresh_message_get (_tmp18_);
	_tmp20_ = _tmp19_;
	feed_reader_fresh_connection_postRequest (_tmp16_, _tmp17_, _tmp20_, "application/x-www-form-urlencoded", &_tmp21_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	response = _tmp22_;
	_tmp23_ = response;
	if (_tmp23_.status != ((guint) 200)) {
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		FeedReaderfreshMessage* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		FeedReaderResponse _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp24_ = path;
		_tmp25_ = g_strconcat (_tmp24_, " ", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = msg;
		_tmp28_ = feed_reader_fresh_message_get (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp26_, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		feed_reader_logger_debug (_tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp26_);
		_tmp32_ = response;
		_tmp33_ = g_strdup_printf ("%u", _tmp32_.status);
		_tmp34_ = _tmp33_;
		feed_reader_logger_debug (_tmp34_);
		_g_free0 (_tmp34_);
	}
	feed_reader_response_destroy (&response);
	_feed_reader_fresh_message_unref0 (msg);
	arrayID = (_vala_array_free (arrayID, arrayID_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
}

void
feed_reader_fresh_api_markAllAsRead (FeedReaderfreshAPI* self,
                                     const gchar* streamID)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	FeedReaderfreshMessage* msg = NULL;
	FeedReaderfreshMessage* _tmp1_;
	FeedReaderfreshMessage* _tmp2_;
	FeedReaderfreshConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderfreshMessage* _tmp6_;
	FeedReaderfreshMessage* _tmp7_;
	FeedReaderDataBaseReadOnly* _tmp8_;
	FeedReaderDataBaseReadOnly* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp12_;
	const gchar* _tmp13_;
	FeedReaderfreshMessage* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	FeedReaderResponse _tmp17_ = {0};
	FeedReaderResponse _tmp18_;
	FeedReaderResponse _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (streamID != NULL);
	_tmp0_ = g_strdup ("reader/api/0/mark-all-as-read");
	path = _tmp0_;
	_tmp1_ = feed_reader_fresh_message_new ();
	msg = _tmp1_;
	_tmp2_ = msg;
	_tmp3_ = self->priv->m_connection;
	_tmp4_ = feed_reader_fresh_connection_getToken (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_fresh_message_add (_tmp2_, "T", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = msg;
	feed_reader_fresh_message_add (_tmp6_, "s", streamID);
	_tmp7_ = msg;
	_tmp8_ = feed_reader_data_base_readOnly ();
	_tmp9_ = _tmp8_;
	_tmp10_ = feed_reader_data_base_read_only_getNewestArticle (_tmp9_);
	_tmp11_ = _tmp10_;
	feed_reader_fresh_message_add (_tmp7_, "ts", _tmp11_);
	_g_free0 (_tmp11_);
	_g_object_unref0 (_tmp9_);
	_tmp12_ = self->priv->m_connection;
	_tmp13_ = path;
	_tmp14_ = msg;
	_tmp15_ = feed_reader_fresh_message_get (_tmp14_);
	_tmp16_ = _tmp15_;
	feed_reader_fresh_connection_postRequest (_tmp12_, _tmp13_, _tmp16_, "application/x-www-form-urlencoded", &_tmp17_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	response = _tmp18_;
	_tmp19_ = response;
	if (_tmp19_.status != ((guint) 200)) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		FeedReaderfreshMessage* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		FeedReaderResponse _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp20_ = path;
		_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = msg;
		_tmp24_ = feed_reader_fresh_message_get (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp22_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		feed_reader_logger_debug (_tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp22_);
		_tmp28_ = response;
		_tmp29_ = g_strdup_printf ("%u", _tmp28_.status);
		_tmp30_ = _tmp29_;
		feed_reader_logger_debug (_tmp30_);
		_g_free0 (_tmp30_);
	}
	feed_reader_response_destroy (&response);
	_feed_reader_fresh_message_unref0 (msg);
	_g_free0 (path);
}

void
feed_reader_fresh_api_editStream (FeedReaderfreshAPI* self,
                                  const gchar* action,
                                  gchar** streamID,
                                  gint streamID_length1,
                                  const gchar* title,
                                  const gchar* add,
                                  const gchar* remove,
                                  FeedReaderResponse* result)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	FeedReaderfreshMessage* msg = NULL;
	FeedReaderfreshMessage* _tmp1_;
	FeedReaderfreshMessage* _tmp2_;
	FeedReaderfreshConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderfreshMessage* _tmp6_;
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp13_;
	const gchar* _tmp14_;
	FeedReaderfreshMessage* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	FeedReaderResponse _tmp18_ = {0};
	FeedReaderResponse _tmp19_;
	FeedReaderResponse _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_strdup ("reader/api/0/subscription/edit");
	path = _tmp0_;
	_tmp1_ = feed_reader_fresh_message_new ();
	msg = _tmp1_;
	_tmp2_ = msg;
	_tmp3_ = self->priv->m_connection;
	_tmp4_ = feed_reader_fresh_connection_getToken (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_fresh_message_add (_tmp2_, "T", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = msg;
	feed_reader_fresh_message_add (_tmp6_, "ac", action);
	if (streamID != NULL) {
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = streamID;
			s_collection_length1 = streamID_length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				gchar* _tmp7_;
				gchar* s = NULL;
				_tmp7_ = g_strdup (s_collection[s_it]);
				s = _tmp7_;
				{
					FeedReaderfreshMessage* _tmp8_;
					const gchar* _tmp9_;
					_tmp8_ = msg;
					_tmp9_ = s;
					feed_reader_fresh_message_add (_tmp8_, "s", _tmp9_);
					_g_free0 (s);
				}
			}
		}
	}
	if (title != NULL) {
		FeedReaderfreshMessage* _tmp10_;
		_tmp10_ = msg;
		feed_reader_fresh_message_add (_tmp10_, "t", title);
	}
	if (add != NULL) {
		FeedReaderfreshMessage* _tmp11_;
		_tmp11_ = msg;
		feed_reader_fresh_message_add (_tmp11_, "a", add);
	}
	if (remove != NULL) {
		FeedReaderfreshMessage* _tmp12_;
		_tmp12_ = msg;
		feed_reader_fresh_message_add (_tmp12_, "r", remove);
	}
	_tmp13_ = self->priv->m_connection;
	_tmp14_ = path;
	_tmp15_ = msg;
	_tmp16_ = feed_reader_fresh_message_get (_tmp15_);
	_tmp17_ = _tmp16_;
	feed_reader_fresh_connection_postRequest (_tmp13_, _tmp14_, _tmp17_, "application/x-www-form-urlencoded", &_tmp18_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	response = _tmp19_;
	_tmp20_ = response;
	if (_tmp20_.status != ((guint) 200)) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		FeedReaderfreshMessage* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		FeedReaderResponse _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp21_ = path;
		_tmp22_ = g_strconcat (_tmp21_, " ", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = msg;
		_tmp25_ = feed_reader_fresh_message_get (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		feed_reader_logger_debug (_tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp23_);
		_tmp29_ = response;
		_tmp30_ = g_strdup_printf ("%u", _tmp29_.status);
		_tmp31_ = _tmp30_;
		feed_reader_logger_debug (_tmp31_);
		_g_free0 (_tmp31_);
	}
	*result = response;
	_feed_reader_fresh_message_unref0 (msg);
	_g_free0 (path);
	return;
}

gchar*
feed_reader_fresh_api_composeTagID (FeedReaderfreshAPI* self,
                                    const gchar* title)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = g_strdup_printf ("user/-/label/%s", title);
	result = _tmp0_;
	return result;
}

void
feed_reader_fresh_api_renameTag (FeedReaderfreshAPI* self,
                                 const gchar* tagID,
                                 const gchar* title)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	FeedReaderfreshMessage* msg = NULL;
	FeedReaderfreshMessage* _tmp1_;
	FeedReaderfreshMessage* _tmp2_;
	FeedReaderfreshConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderfreshMessage* _tmp6_;
	FeedReaderfreshMessage* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp10_;
	const gchar* _tmp11_;
	FeedReaderfreshMessage* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	FeedReaderResponse _tmp15_ = {0};
	FeedReaderResponse _tmp16_;
	FeedReaderResponse _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strdup ("reader/api/0/rename-tag");
	path = _tmp0_;
	_tmp1_ = feed_reader_fresh_message_new ();
	msg = _tmp1_;
	_tmp2_ = msg;
	_tmp3_ = self->priv->m_connection;
	_tmp4_ = feed_reader_fresh_connection_getToken (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_fresh_message_add (_tmp2_, "T", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = msg;
	feed_reader_fresh_message_add (_tmp6_, "s", tagID);
	_tmp7_ = msg;
	_tmp8_ = feed_reader_fresh_api_composeTagID (self, title);
	_tmp9_ = _tmp8_;
	feed_reader_fresh_message_add (_tmp7_, "dest", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->m_connection;
	_tmp11_ = path;
	_tmp12_ = msg;
	_tmp13_ = feed_reader_fresh_message_get (_tmp12_);
	_tmp14_ = _tmp13_;
	feed_reader_fresh_connection_postRequest (_tmp10_, _tmp11_, _tmp14_, "application/x-www-form-urlencoded", &_tmp15_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	response = _tmp16_;
	_tmp17_ = response;
	if (_tmp17_.status != ((guint) 200)) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		FeedReaderfreshMessage* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		FeedReaderResponse _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp18_ = path;
		_tmp19_ = g_strconcat (_tmp18_, " ", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = msg;
		_tmp22_ = feed_reader_fresh_message_get (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp20_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		feed_reader_logger_debug (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp20_);
		_tmp26_ = response;
		_tmp27_ = g_strdup_printf ("%u", _tmp26_.status);
		_tmp28_ = _tmp27_;
		feed_reader_logger_debug (_tmp28_);
		_g_free0 (_tmp28_);
	}
	feed_reader_response_destroy (&response);
	_feed_reader_fresh_message_unref0 (msg);
	_g_free0 (path);
}

void
feed_reader_fresh_api_deleteTag (FeedReaderfreshAPI* self,
                                 const gchar* tagID)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	FeedReaderfreshMessage* msg = NULL;
	FeedReaderfreshMessage* _tmp1_;
	FeedReaderfreshMessage* _tmp2_;
	FeedReaderfreshConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderfreshMessage* _tmp6_;
	FeedReaderResponse response = {0};
	FeedReaderfreshConnection* _tmp7_;
	const gchar* _tmp8_;
	FeedReaderfreshMessage* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	FeedReaderResponse _tmp12_ = {0};
	FeedReaderResponse _tmp13_;
	FeedReaderResponse _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = g_strdup ("reader/api/0/disable-tag");
	path = _tmp0_;
	_tmp1_ = feed_reader_fresh_message_new ();
	msg = _tmp1_;
	_tmp2_ = msg;
	_tmp3_ = self->priv->m_connection;
	_tmp4_ = feed_reader_fresh_connection_getToken (_tmp3_);
	_tmp5_ = _tmp4_;
	feed_reader_fresh_message_add (_tmp2_, "T", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = msg;
	feed_reader_fresh_message_add (_tmp6_, "s", tagID);
	_tmp7_ = self->priv->m_connection;
	_tmp8_ = path;
	_tmp9_ = msg;
	_tmp10_ = feed_reader_fresh_message_get (_tmp9_);
	_tmp11_ = _tmp10_;
	feed_reader_fresh_connection_postRequest (_tmp7_, _tmp8_, _tmp11_, "application/x-www-form-urlencoded", &_tmp12_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	response = _tmp13_;
	_tmp14_ = response;
	if (_tmp14_.status != ((guint) 200)) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FeedReaderfreshMessage* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		FeedReaderResponse _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp15_ = path;
		_tmp16_ = g_strconcat (_tmp15_, " ", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = msg;
		_tmp19_ = feed_reader_fresh_message_get (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		feed_reader_logger_debug (_tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_tmp23_ = response;
		_tmp24_ = g_strdup_printf ("%u", _tmp23_.status);
		_tmp25_ = _tmp24_;
		feed_reader_logger_debug (_tmp25_);
		_g_free0 (_tmp25_);
	}
	feed_reader_response_destroy (&response);
	_feed_reader_fresh_message_unref0 (msg);
	_g_free0 (path);
}

static void
feed_reader_fresh_api_class_init (FeedReaderfreshAPIClass * klass,
                                  gpointer klass_data)
{
	feed_reader_fresh_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderfreshAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_fresh_api_finalize;
}

static void
feed_reader_fresh_api_instance_init (FeedReaderfreshAPI * self,
                                     gpointer klass)
{
	self->priv = feed_reader_fresh_api_get_instance_private (self);
}

static void
feed_reader_fresh_api_finalize (GObject * obj)
{
	FeedReaderfreshAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FRESH_API, FeedReaderfreshAPI);
	_feed_reader_fresh_connection_unref0 (self->priv->m_connection);
	_g_object_unref0 (self->priv->m_utils);
	G_OBJECT_CLASS (feed_reader_fresh_api_parent_class)->finalize (obj);
}

GType
feed_reader_fresh_api_get_type (void)
{
	return feed_reader_fresh_api_type_id;
}

GType
feed_reader_fresh_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderfreshAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_fresh_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderfreshAPI), 0, (GInstanceInitFunc) feed_reader_fresh_api_instance_init, NULL };
	feed_reader_fresh_api_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderfreshAPI", &g_define_type_info, 0);
	FeedReaderfreshAPI_private_offset = sizeof (FeedReaderfreshAPIPrivate);
	return feed_reader_fresh_api_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

