/* freshConnection.c generated by valac 0.56.3, the Vala compiler
 * generated from freshConnection.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "fresh.h"
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib.h>
#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _feed_reader_fresh_message_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_fresh_message_unref (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _FeedReaderParamSpecfreshConnection FeedReaderParamSpecfreshConnection;
typedef struct _FeedReaderParamSpecfreshMessage FeedReaderParamSpecfreshMessage;

struct _FeedReaderfreshConnectionPrivate {
	FeedReaderfreshUtils* m_utils;
	GSettings* m_settingsTweaks;
	SoupSession* m_session;
};

struct _FeedReaderParamSpecfreshConnection {
	GParamSpec parent_instance;
};

struct _FeedReaderfreshMessagePrivate {
	gchar* request;
};

struct _FeedReaderParamSpecfreshMessage {
	GParamSpec parent_instance;
};

static gint FeedReaderfreshConnection_private_offset;
static gpointer feed_reader_fresh_connection_parent_class = NULL;
static GType feed_reader_fresh_connection_type_id = 0;
static gint FeedReaderfreshMessage_private_offset;
static gpointer feed_reader_fresh_message_parent_class = NULL;
static GType feed_reader_fresh_message_type_id = 0;

static void __lambda6_ (FeedReaderfreshConnection* self,
                 SoupMessage* msg,
                 SoupAuth* auth,
                 gboolean retrying);
static void ___lambda6__soup_session_authenticate (SoupSession* _sender,
                                            SoupMessage* msg,
                                            SoupAuth* auth,
                                            gboolean retrying,
                                            gpointer self);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static void feed_reader_fresh_connection_finalize (FeedReaderfreshConnection * obj);
static void feed_reader_fresh_message_finalize (FeedReaderfreshMessage * obj);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
feed_reader_fresh_connection_get_instance_private (FeedReaderfreshConnection* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderfreshConnection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (FeedReaderfreshConnection* self,
            SoupMessage* msg,
            SoupAuth* auth,
            gboolean retrying)
{
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (msg != NULL);
	g_return_if_fail (auth != NULL);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getHtaccessUser (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		feed_reader_logger_error ("fresh Session: need Authentication");
	} else {
		if (!retrying) {
			FeedReaderfreshUtils* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			FeedReaderfreshUtils* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = self->priv->m_utils;
			_tmp5_ = feed_reader_fresh_utils_getHtaccessUser (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = self->priv->m_utils;
			_tmp8_ = feed_reader_fresh_utils_getHtaccessPasswd (_tmp7_);
			_tmp9_ = _tmp8_;
			soup_auth_authenticate (auth, _tmp6_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp6_);
		}
	}
}

static void
___lambda6__soup_session_authenticate (SoupSession* _sender,
                                       SoupMessage* msg,
                                       SoupAuth* auth,
                                       gboolean retrying,
                                       gpointer self)
{
	__lambda6_ ((FeedReaderfreshConnection*) self, msg, auth, retrying);
}

FeedReaderfreshConnection*
feed_reader_fresh_connection_construct (GType object_type,
                                        FeedReaderfreshUtils* utils)
{
	FeedReaderfreshConnection* self = NULL;
	FeedReaderfreshUtils* _tmp0_;
	GSettings* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	SoupSession* _tmp4_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderfreshConnection*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.feedreader.tweaks");
	_g_object_unref0 (self->priv->m_settingsTweaks);
	self->priv->m_settingsTweaks = _tmp1_;
	_tmp2_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp2_;
	_tmp3_ = self->priv->m_session;
	g_object_set (_tmp3_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp4_ = self->priv->m_session;
	g_signal_connect (_tmp4_, "authenticate", (GCallback) ___lambda6__soup_session_authenticate, self);
	return self;
}

FeedReaderfreshConnection*
feed_reader_fresh_connection_new (FeedReaderfreshUtils* utils)
{
	return feed_reader_fresh_connection_construct (FEED_READER_TYPE_FRESH_CONNECTION, utils);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

FeedReaderLoginResponse
feed_reader_fresh_connection_getSID (FeedReaderfreshConnection* self)
{
	SoupMessage* message = NULL;
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	FeedReaderfreshMessage* msg = NULL;
	FeedReaderfreshMessage* _tmp7_;
	FeedReaderfreshMessage* _tmp8_;
	FeedReaderfreshUtils* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	FeedReaderfreshMessage* _tmp12_;
	FeedReaderfreshUtils* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	SoupMessage* _tmp16_;
	FeedReaderfreshMessage* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_ = 0;
	guint8* _tmp22_;
	gint _tmp22__length1;
	SoupSession* _tmp23_;
	SoupMessage* _tmp24_;
	SoupMessage* _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	gchar* response = NULL;
	SoupMessage* _tmp28_;
	SoupMessageBody* _tmp29_;
	SoupBuffer* _tmp30_;
	SoupBuffer* _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getURL (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "accounts/ClientLogin", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = soup_message_new ("POST", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	message = _tmp6_;
	_tmp7_ = feed_reader_fresh_message_new ();
	msg = _tmp7_;
	_tmp8_ = msg;
	_tmp9_ = self->priv->m_utils;
	_tmp10_ = feed_reader_fresh_utils_getUser (_tmp9_);
	_tmp11_ = _tmp10_;
	feed_reader_fresh_message_add (_tmp8_, "Email", _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = msg;
	_tmp13_ = self->priv->m_utils;
	_tmp14_ = feed_reader_fresh_utils_getPasswd (_tmp13_);
	_tmp15_ = _tmp14_;
	feed_reader_fresh_message_add (_tmp12_, "Passwd", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = message;
	_tmp17_ = msg;
	_tmp18_ = feed_reader_fresh_message_get (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = string_get_data (_tmp19_, &_tmp21_);
	_tmp20__length1 = _tmp21_;
	_tmp22_ = _tmp20_;
	_tmp22__length1 = _tmp20__length1;
	soup_message_set_request (_tmp16_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp22_, (gsize) _tmp22__length1);
	_g_free0 (_tmp19_);
	_tmp23_ = self->priv->m_session;
	_tmp24_ = message;
	soup_session_send_message (_tmp23_, _tmp24_);
	_tmp25_ = message;
	g_object_get (_tmp25_, "status-code", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != ((guint) 200)) {
		feed_reader_logger_error ("No response from freshRSS to message getSID()");
		result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
		_feed_reader_fresh_message_unref0 (msg);
		_g_object_unref0 (message);
		return result;
	}
	_tmp28_ = message;
	_tmp29_ = _tmp28_->response_body;
	_tmp30_ = soup_message_body_flatten (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_->data;
	_tmp32__length1 = _tmp31_->length;
	_tmp33_ = g_strdup ((const gchar*) _tmp32_);
	_tmp34_ = _tmp33_;
	__vala_SoupBuffer_free0 (_tmp31_);
	response = _tmp34_;
	_tmp35_ = response;
	if (!g_str_has_prefix (_tmp35_, "SID=")) {
		FeedReaderfreshUtils* _tmp36_;
		FeedReaderfreshUtils* _tmp37_;
		FeedReaderfreshUtils* _tmp38_;
		_tmp36_ = self->priv->m_utils;
		feed_reader_fresh_utils_setToken (_tmp36_, "");
		_tmp37_ = self->priv->m_utils;
		feed_reader_fresh_utils_setUser (_tmp37_, "");
		_tmp38_ = self->priv->m_utils;
		feed_reader_fresh_utils_setURL (_tmp38_, "");
		result = FEED_READER_LOGIN_RESPONSE_WRONG_LOGIN;
		_g_free0 (response);
		_feed_reader_fresh_message_unref0 (msg);
		_g_object_unref0 (message);
		return result;
	} else {
		gint start = 0;
		const gchar* _tmp39_;
		gint end = 0;
		const gchar* _tmp40_;
		gchar* token = NULL;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		FeedReaderfreshUtils* _tmp46_;
		const gchar* _tmp47_;
		_tmp39_ = response;
		start = string_index_of (_tmp39_, "=", 0) + 1;
		_tmp40_ = response;
		end = string_index_of (_tmp40_, "\n", 0);
		_tmp41_ = response;
		_tmp42_ = string_substring (_tmp41_, (glong) start, (glong) (end - start));
		token = _tmp42_;
		_tmp43_ = token;
		_tmp44_ = g_strconcat ("Token: ", _tmp43_, NULL);
		_tmp45_ = _tmp44_;
		feed_reader_logger_debug (_tmp45_);
		_g_free0 (_tmp45_);
		_tmp46_ = self->priv->m_utils;
		_tmp47_ = token;
		feed_reader_fresh_utils_setToken (_tmp46_, _tmp47_);
		result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
		_g_free0 (token);
		_g_free0 (response);
		_feed_reader_fresh_message_unref0 (msg);
		_g_object_unref0 (message);
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
feed_reader_fresh_connection_getToken (FeedReaderfreshConnection* self)
{
	FeedReaderResponse _tmp0_ = {0};
	FeedReaderResponse _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	feed_reader_fresh_connection_getRequest (self, "reader/api/0/token", &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.data;
	_tmp3_ = string_replace (_tmp2_, "\n", "");
	_tmp4_ = _tmp3_;
	feed_reader_response_destroy (&_tmp1_);
	result = _tmp4_;
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
feed_reader_fresh_connection_postRequest (FeedReaderfreshConnection* self,
                                          const gchar* path,
                                          const gchar* input,
                                          const gchar* type,
                                          FeedReaderResponse* result)
{
	SoupMessage* message = NULL;
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	GSettings* _tmp7_;
	SoupMessage* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	FeedReaderfreshUtils* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	SoupMessage* _tmp17_;
	SoupMessageHeaders* _tmp18_;
	SoupMessage* _tmp19_;
	SoupMessageBody* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gint _tmp22_ = 0;
	guint8* _tmp23_;
	gint _tmp23__length1;
	guint8* _tmp24_;
	gint _tmp24__length1;
	SoupSession* _tmp25_;
	SoupMessage* _tmp26_;
	SoupMessage* _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	SoupMessage* _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	SoupMessage* _tmp38_;
	SoupMessageBody* _tmp39_;
	SoupBuffer* _tmp40_;
	SoupBuffer* _tmp41_;
	guint8* _tmp42_;
	gint _tmp42__length1;
	gchar* _tmp43_;
	FeedReaderResponse _tmp44_ = {0};
	FeedReaderResponse _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (input != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getURL (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, path, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = soup_message_new ("POST", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	message = _tmp6_;
	_tmp7_ = self->priv->m_settingsTweaks;
	if (g_settings_get_boolean (_tmp7_, "do-not-track")) {
		SoupMessage* _tmp8_;
		SoupMessageHeaders* _tmp9_;
		_tmp8_ = message;
		_tmp9_ = _tmp8_->request_headers;
		soup_message_headers_append (_tmp9_, "DNT", "1");
	}
	_tmp10_ = message;
	_tmp11_ = _tmp10_->request_headers;
	_tmp12_ = self->priv->m_utils;
	_tmp13_ = feed_reader_fresh_utils_getToken (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("GoogleLogin auth=%s", _tmp14_);
	_tmp16_ = _tmp15_;
	soup_message_headers_append (_tmp11_, "Authorization", _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = message;
	_tmp18_ = _tmp17_->request_headers;
	soup_message_headers_append (_tmp18_, "Content-Type", type);
	_tmp19_ = message;
	_tmp20_ = _tmp19_->request_body;
	_tmp21_ = string_get_data (input, &_tmp22_);
	_tmp21__length1 = _tmp22_;
	_tmp23_ = _tmp21_;
	_tmp23__length1 = _tmp21__length1;
	_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup1 (_tmp23_, _tmp23__length1) : _tmp23_;
	_tmp24__length1 = _tmp23__length1;
	soup_message_body_append_take (_tmp20_, _tmp24_, (gsize) _tmp24__length1);
	_tmp25_ = self->priv->m_session;
	_tmp26_ = message;
	soup_session_send_message (_tmp25_, _tmp26_);
	_tmp27_ = message;
	g_object_get (_tmp27_, "status-code", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != ((guint) 200)) {
		SoupMessage* _tmp30_;
		guint _tmp31_;
		guint _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = message;
		g_object_get (_tmp30_, "status-code", &_tmp31_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strdup_printf ("freshConnection: message unexpected response %u", _tmp32_);
		_tmp34_ = _tmp33_;
		feed_reader_logger_warning (_tmp34_);
		_g_free0 (_tmp34_);
	}
	_tmp35_ = message;
	g_object_get (_tmp35_, "status-code", &_tmp36_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = message;
	_tmp39_ = _tmp38_->response_body;
	_tmp40_ = soup_message_body_flatten (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_->data;
	_tmp42__length1 = _tmp41_->length;
	_tmp43_ = g_strdup ((const gchar*) _tmp42_);
	memset (&_tmp44_, 0, sizeof (FeedReaderResponse));
	_tmp44_.status = _tmp37_;
	_g_free0 (_tmp44_.data);
	_tmp44_.data = _tmp43_;
	_tmp45_ = _tmp44_;
	__vala_SoupBuffer_free0 (_tmp41_);
	*result = _tmp45_;
	_g_object_unref0 (message);
	return;
}

void
feed_reader_fresh_connection_getRequest (FeedReaderfreshConnection* self,
                                         const gchar* path,
                                         FeedReaderResponse* result)
{
	SoupMessage* message = NULL;
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
	SoupMessageHeaders* _tmp8_;
	FeedReaderfreshUtils* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GSettings* _tmp14_;
	SoupSession* _tmp17_;
	SoupMessage* _tmp18_;
	SoupMessage* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	SoupMessage* _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	SoupMessage* _tmp30_;
	SoupMessageBody* _tmp31_;
	SoupBuffer* _tmp32_;
	SoupBuffer* _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	FeedReaderResponse _tmp36_ = {0};
	FeedReaderResponse _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getURL (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, path, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = soup_message_new ("GET", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	message = _tmp6_;
	_tmp7_ = message;
	_tmp8_ = _tmp7_->request_headers;
	_tmp9_ = self->priv->m_utils;
	_tmp10_ = feed_reader_fresh_utils_getToken (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("GoogleLogin auth=%s", _tmp11_);
	_tmp13_ = _tmp12_;
	soup_message_headers_append (_tmp8_, "Authorization", _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = self->priv->m_settingsTweaks;
	if (g_settings_get_boolean (_tmp14_, "do-not-track")) {
		SoupMessage* _tmp15_;
		SoupMessageHeaders* _tmp16_;
		_tmp15_ = message;
		_tmp16_ = _tmp15_->request_headers;
		soup_message_headers_append (_tmp16_, "DNT", "1");
	}
	_tmp17_ = self->priv->m_session;
	_tmp18_ = message;
	soup_session_send_message (_tmp17_, _tmp18_);
	_tmp19_ = message;
	g_object_get (_tmp19_, "status-code", &_tmp20_, NULL);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != ((guint) 200)) {
		SoupMessage* _tmp22_;
		guint _tmp23_;
		guint _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp22_ = message;
		g_object_get (_tmp22_, "status-code", &_tmp23_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf ("freshConnection: message unexpected response %u", _tmp24_);
		_tmp26_ = _tmp25_;
		feed_reader_logger_warning (_tmp26_);
		_g_free0 (_tmp26_);
	}
	_tmp27_ = message;
	g_object_get (_tmp27_, "status-code", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = message;
	_tmp31_ = _tmp30_->response_body;
	_tmp32_ = soup_message_body_flatten (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->data;
	_tmp34__length1 = _tmp33_->length;
	_tmp35_ = g_strdup ((const gchar*) _tmp34_);
	memset (&_tmp36_, 0, sizeof (FeedReaderResponse));
	_tmp36_.status = _tmp29_;
	_g_free0 (_tmp36_.data);
	_tmp36_.data = _tmp35_;
	_tmp37_ = _tmp36_;
	__vala_SoupBuffer_free0 (_tmp33_);
	*result = _tmp37_;
	_g_object_unref0 (message);
	return;
}

static void
feed_reader_value_fresh_connection_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
feed_reader_value_fresh_connection_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		feed_reader_fresh_connection_unref (value->data[0].v_pointer);
	}
}

static void
feed_reader_value_fresh_connection_copy_value (const GValue* src_value,
                                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = feed_reader_fresh_connection_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
feed_reader_value_fresh_connection_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
feed_reader_value_fresh_connection_collect_value (GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FeedReaderfreshConnection * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = feed_reader_fresh_connection_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
feed_reader_value_fresh_connection_lcopy_value (const GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	FeedReaderfreshConnection ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = feed_reader_fresh_connection_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
feed_reader_param_spec_fresh_connection (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags)
{
	FeedReaderParamSpecfreshConnection* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FEED_READER_TYPE_FRESH_CONNECTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
feed_reader_value_get_fresh_connection (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FRESH_CONNECTION), NULL);
	return value->data[0].v_pointer;
}

void
feed_reader_value_set_fresh_connection (GValue* value,
                                        gpointer v_object)
{
	FeedReaderfreshConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FRESH_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FRESH_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		feed_reader_fresh_connection_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_fresh_connection_unref (old);
	}
}

void
feed_reader_value_take_fresh_connection (GValue* value,
                                         gpointer v_object)
{
	FeedReaderfreshConnection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FRESH_CONNECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FRESH_CONNECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_fresh_connection_unref (old);
	}
}

static void
feed_reader_fresh_connection_class_init (FeedReaderfreshConnectionClass * klass,
                                         gpointer klass_data)
{
	feed_reader_fresh_connection_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderfreshConnectionClass *) klass)->finalize = feed_reader_fresh_connection_finalize;
	g_type_class_adjust_private_offset (klass, &FeedReaderfreshConnection_private_offset);
}

static void
feed_reader_fresh_connection_instance_init (FeedReaderfreshConnection * self,
                                            gpointer klass)
{
	self->priv = feed_reader_fresh_connection_get_instance_private (self);
	self->ref_count = 1;
}

static void
feed_reader_fresh_connection_finalize (FeedReaderfreshConnection * obj)
{
	FeedReaderfreshConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FRESH_CONNECTION, FeedReaderfreshConnection);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_settingsTweaks);
	_g_object_unref0 (self->priv->m_session);
}

GType
feed_reader_fresh_connection_get_type (void)
{
	return feed_reader_fresh_connection_type_id;
}

GType
feed_reader_fresh_connection_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { feed_reader_value_fresh_connection_init, feed_reader_value_fresh_connection_free_value, feed_reader_value_fresh_connection_copy_value, feed_reader_value_fresh_connection_peek_pointer, "p", feed_reader_value_fresh_connection_collect_value, "p", feed_reader_value_fresh_connection_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderfreshConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_fresh_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderfreshConnection), 0, (GInstanceInitFunc) feed_reader_fresh_connection_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	feed_reader_fresh_connection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FeedReaderfreshConnection", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FeedReaderfreshConnection_private_offset = sizeof (FeedReaderfreshConnectionPrivate);
	return feed_reader_fresh_connection_type_id;
}

gpointer
feed_reader_fresh_connection_ref (gpointer instance)
{
	FeedReaderfreshConnection * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
feed_reader_fresh_connection_unref (gpointer instance)
{
	FeedReaderfreshConnection * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FEED_READER_FRESH_CONNECTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
feed_reader_fresh_message_get_instance_private (FeedReaderfreshMessage* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderfreshMessage_private_offset);
}

FeedReaderfreshMessage*
feed_reader_fresh_message_construct (GType object_type)
{
	FeedReaderfreshMessage* self = NULL;
	self = (FeedReaderfreshMessage*) g_type_create_instance (object_type);
	return self;
}

FeedReaderfreshMessage*
feed_reader_fresh_message_new (void)
{
	return feed_reader_fresh_message_construct (FEED_READER_TYPE_FRESH_MESSAGE);
}

void
feed_reader_fresh_message_add (FeedReaderfreshMessage* self,
                               const gchar* parameter,
                               const gchar* val)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->request;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->request;
		_tmp2_ = g_strconcat (_tmp1_, "&", NULL);
		_g_free0 (self->priv->request);
		self->priv->request = _tmp2_;
	}
	_tmp3_ = self->priv->request;
	_tmp4_ = g_strconcat (_tmp3_, parameter, NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp4_;
	_tmp5_ = self->priv->request;
	_tmp6_ = g_strconcat (_tmp5_, "=", NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp6_;
	_tmp7_ = self->priv->request;
	_tmp8_ = g_uri_escape_string (val, "/", TRUE);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_g_free0 (self->priv->request);
	self->priv->request = _tmp10_;
	_g_free0 (_tmp9_);
}

gchar*
feed_reader_fresh_message_get (FeedReaderfreshMessage* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->request;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
feed_reader_value_fresh_message_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
feed_reader_value_fresh_message_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		feed_reader_fresh_message_unref (value->data[0].v_pointer);
	}
}

static void
feed_reader_value_fresh_message_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = feed_reader_fresh_message_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
feed_reader_value_fresh_message_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
feed_reader_value_fresh_message_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FeedReaderfreshMessage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = feed_reader_fresh_message_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
feed_reader_value_fresh_message_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	FeedReaderfreshMessage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = feed_reader_fresh_message_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
feed_reader_param_spec_fresh_message (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	FeedReaderParamSpecfreshMessage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FEED_READER_TYPE_FRESH_MESSAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
feed_reader_value_get_fresh_message (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FRESH_MESSAGE), NULL);
	return value->data[0].v_pointer;
}

void
feed_reader_value_set_fresh_message (GValue* value,
                                     gpointer v_object)
{
	FeedReaderfreshMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FRESH_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FRESH_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		feed_reader_fresh_message_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_fresh_message_unref (old);
	}
}

void
feed_reader_value_take_fresh_message (GValue* value,
                                      gpointer v_object)
{
	FeedReaderfreshMessage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FEED_READER_TYPE_FRESH_MESSAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FEED_READER_TYPE_FRESH_MESSAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		feed_reader_fresh_message_unref (old);
	}
}

static void
feed_reader_fresh_message_class_init (FeedReaderfreshMessageClass * klass,
                                      gpointer klass_data)
{
	feed_reader_fresh_message_parent_class = g_type_class_peek_parent (klass);
	((FeedReaderfreshMessageClass *) klass)->finalize = feed_reader_fresh_message_finalize;
	g_type_class_adjust_private_offset (klass, &FeedReaderfreshMessage_private_offset);
}

static void
feed_reader_fresh_message_instance_init (FeedReaderfreshMessage * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = feed_reader_fresh_message_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->request = _tmp0_;
	self->ref_count = 1;
}

static void
feed_reader_fresh_message_finalize (FeedReaderfreshMessage * obj)
{
	FeedReaderfreshMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FRESH_MESSAGE, FeedReaderfreshMessage);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->request);
}

GType
feed_reader_fresh_message_get_type (void)
{
	return feed_reader_fresh_message_type_id;
}

GType
feed_reader_fresh_message_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { feed_reader_value_fresh_message_init, feed_reader_value_fresh_message_free_value, feed_reader_value_fresh_message_copy_value, feed_reader_value_fresh_message_peek_pointer, "p", feed_reader_value_fresh_message_collect_value, "p", feed_reader_value_fresh_message_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderfreshMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_fresh_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderfreshMessage), 0, (GInstanceInitFunc) feed_reader_fresh_message_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	feed_reader_fresh_message_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FeedReaderfreshMessage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	FeedReaderfreshMessage_private_offset = sizeof (FeedReaderfreshMessagePrivate);
	return feed_reader_fresh_message_type_id;
}

gpointer
feed_reader_fresh_message_ref (gpointer instance)
{
	FeedReaderfreshMessage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
feed_reader_fresh_message_unref (gpointer instance)
{
	FeedReaderfreshMessage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FEED_READER_FRESH_MESSAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

