/* freshInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from freshInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "fresh.h"
#include <gtk/gtk.h>
#include <glib.h>
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

enum  {
	FEED_READER_FRESH_INTERFACE_0_PROPERTY,
	FEED_READER_FRESH_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_fresh_interface_properties[FEED_READER_FRESH_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderfreshInterfacePrivate {
	FeedReaderfreshAPI* m_api;
	FeedReaderfreshUtils* m_utils;
	GtkEntry* m_urlEntry;
	GtkEntry* m_userEntry;
	GtkEntry* m_passwordEntry;
	GtkEntry* m_authPasswordEntry;
	GtkEntry* m_authUserEntry;
	GtkRevealer* m_revealer;
	gboolean m_need_htaccess;
};

static gint FeedReaderfreshInterface_private_offset;
static gpointer feed_reader_fresh_interface_parent_class = NULL;
static GType feed_reader_fresh_interface_type_id = 0;

static void feed_reader_fresh_interface_real_init (FeedReaderFeedServerInterface* base,
                                            GSettingsBackend* settings_backend,
                                            SecretCollection* secrets);
static gchar* feed_reader_fresh_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_fresh_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_fresh_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_fresh_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_fresh_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static GtkBox* feed_reader_fresh_interface_real_getWidget (FeedReaderFeedServerInterface* base);
static void __lambda7_ (FeedReaderfreshInterface* self);
static void ___lambda7__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda8_ (FeedReaderfreshInterface* self);
static void ___lambda8__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda9_ (FeedReaderfreshInterface* self);
static void ___lambda9__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda10_ (FeedReaderfreshInterface* self);
static void ___lambda10__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda11_ (FeedReaderfreshInterface* self);
static void ___lambda11__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda12_ (FeedReaderfreshInterface* self);
static void ___lambda12__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void feed_reader_fresh_interface_real_showHtAccess (FeedReaderFeedServerInterface* base);
static void feed_reader_fresh_interface_real_writeData (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_fresh_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_fresh_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_fresh_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_fresh_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                 const gchar* catID);
static gboolean feed_reader_fresh_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_fresh_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_fresh_interface_real_login (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_fresh_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static void feed_reader_fresh_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleIDs,
                                                        FeedReaderArticleStatus read);
static void feed_reader_fresh_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                          const gchar* articleID,
                                                          FeedReaderArticleStatus marked);
static gboolean feed_reader_fresh_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_fresh_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedID);
static void feed_reader_fresh_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                       const gchar* catID);
static void feed_reader_fresh_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_fresh_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                  const gchar* articleID,
                                                  const gchar* tagID);
static void feed_reader_fresh_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleID,
                                                        const gchar* tagID);
static gchar* feed_reader_fresh_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* caption);
static void feed_reader_fresh_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID);
static void feed_reader_fresh_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID,
                                                 const gchar* title);
static gboolean feed_reader_fresh_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedURL,
                                                   const gchar* catID,
                                                   const gchar* newCatName,
                                                   gchar** feedID,
                                                   gchar** errmsg);
static void feed_reader_fresh_interface_real_addFeeds (FeedReaderFeedServerInterface* base,
                                                GeeList* feeds);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void feed_reader_fresh_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID);
static void feed_reader_fresh_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID,
                                                  const gchar* title);
static void feed_reader_fresh_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                const gchar* feedID,
                                                const gchar* newCatID,
                                                const gchar* currentCatID);
static gchar* feed_reader_fresh_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                        const gchar* title,
                                                        const gchar* parentID);
static void feed_reader_fresh_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID,
                                                      const gchar* title);
static void feed_reader_fresh_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                    const gchar* catID,
                                                    const gchar* newParentID);
static void feed_reader_fresh_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID);
static void feed_reader_fresh_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                         const gchar* feedID,
                                                         const gchar* catID);
static gboolean feed_reader_fresh_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                           GeeList* feeds,
                                                           GeeList* categories,
                                                           GeeList* tags,
                                                           GCancellable* cancellable);
static gint feed_reader_fresh_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_fresh_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                   gint count,
                                                   FeedReaderArticleStatus whatToGet,
                                                   GDateTime* since,
                                                   const gchar* feedID,
                                                   gboolean isTagID,
                                                   GCancellable* cancellable);
static void feed_reader_fresh_interface_finalize (GObject * obj);
GType feed_reader_fresh_api_register_type (GTypeModule * module);
GType feed_reader_fresh_utils_register_type (GTypeModule * module);
GType feed_reader_fresh_connection_register_type (GTypeModule * module);
GType feed_reader_fresh_message_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
feed_reader_fresh_interface_get_instance_private (FeedReaderfreshInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderfreshInterface_private_offset);
}

static void
feed_reader_fresh_interface_real_init (FeedReaderFeedServerInterface* base,
                                       GSettingsBackend* settings_backend,
                                       SecretCollection* secrets)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshUtils* _tmp0_;
	FeedReaderfreshUtils* _tmp1_;
	FeedReaderfreshAPI* _tmp2_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_fresh_utils_new (settings_backend, secrets);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_fresh_api_new (_tmp1_);
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp2_;
}

static gchar*
feed_reader_fresh_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = g_strdup ("https://freshrss.org/");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_fresh_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderfreshInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_SELF_HOSTED | FEED_READER_BACKEND_FLAGS_FREE_SOFTWARE) | FEED_READER_BACKEND_FLAGS_FREE;
	return result;
}

static gchar*
feed_reader_fresh_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = g_strdup ("fresh");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_fresh_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = g_strdup ("feed-service-fresh");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_fresh_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = g_strdup ("freshRSS");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = FALSE;
	return result;
}

static void
__lambda7_ (FeedReaderfreshInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda7__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda7_ ((FeedReaderfreshInterface*) self);
}

static void
__lambda8_ (FeedReaderfreshInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda8__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda8_ ((FeedReaderfreshInterface*) self);
}

static void
__lambda9_ (FeedReaderfreshInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda9__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda9_ ((FeedReaderfreshInterface*) self);
}

static void
__lambda10_ (FeedReaderfreshInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda10__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda10_ ((FeedReaderfreshInterface*) self);
}

static void
__lambda11_ (FeedReaderfreshInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda11__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda11_ ((FeedReaderfreshInterface*) self);
}

static void
__lambda12_ (FeedReaderfreshInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda12__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda12_ ((FeedReaderfreshInterface*) self);
}

static GtkBox*
feed_reader_fresh_interface_real_getWidget (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	GtkLabel* url_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* user_label = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* password_label = NULL;
	GtkLabel* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkLabel* auth_user_label = NULL;
	GtkLabel* _tmp15_;
	GtkLabel* auth_password_label = NULL;
	GtkLabel* _tmp16_;
	GtkEntry* _tmp17_;
	GtkEntry* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	GtkEntry* _tmp21_;
	GtkEntry* _tmp22_;
	GtkGrid* authGrid = NULL;
	GtkGrid* _tmp23_;
	GtkEntry* _tmp24_;
	GtkEntry* _tmp25_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp26_;
	GtkRevealer* _tmp27_;
	GtkRevealer* _tmp28_;
	GtkImage* logo = NULL;
	GtkImage* _tmp29_;
	GtkLabel* loginLabel = NULL;
	GtkLabel* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkButton* loginButton = NULL;
	GtkButton* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkBox* box = NULL;
	GtkBox* _tmp34_;
	GtkRevealer* _tmp35_;
	GtkEntry* _tmp36_;
	FeedReaderfreshUtils* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GtkEntry* _tmp40_;
	FeedReaderfreshUtils* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkEntry* _tmp44_;
	FeedReaderfreshUtils* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkBox* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("freshRSS URL:"));
	g_object_ref_sink (_tmp0_);
	url_label = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp1_);
	user_label = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp2_);
	password_label = _tmp2_;
	gtk_misc_set_alignment ((GtkMisc*) url_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) user_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) password_label, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) url_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) user_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) password_label, TRUE);
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->m_urlEntry);
	self->priv->m_urlEntry = _tmp3_;
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_userEntry);
	self->priv->m_userEntry = _tmp4_;
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_passwordEntry);
	self->priv->m_passwordEntry = _tmp5_;
	_tmp6_ = self->priv->m_urlEntry;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) ___lambda7__gtk_entry_activate, self, 0);
	_tmp7_ = self->priv->m_userEntry;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) ___lambda8__gtk_entry_activate, self, 0);
	_tmp8_ = self->priv->m_passwordEntry;
	g_signal_connect_object (_tmp8_, "activate", (GCallback) ___lambda9__gtk_entry_activate, self, 0);
	_tmp9_ = self->priv->m_passwordEntry;
	gtk_entry_set_input_purpose (_tmp9_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp10_ = self->priv->m_passwordEntry;
	gtk_entry_set_visibility (_tmp10_, FALSE);
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp11_);
	grid = _tmp11_;
	gtk_grid_set_column_spacing (grid, (guint) 10);
	gtk_grid_set_row_spacing (grid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_grid_attach (grid, (GtkWidget*) url_label, 0, 0, 1, 1);
	_tmp12_ = self->priv->m_urlEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp12_, 1, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) user_label, 0, 1, 1, 1);
	_tmp13_ = self->priv->m_userEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp13_, 1, 1, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) password_label, 0, 2, 1, 1);
	_tmp14_ = self->priv->m_passwordEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp14_, 1, 2, 1, 1);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp15_);
	auth_user_label = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp16_);
	auth_password_label = _tmp16_;
	gtk_misc_set_alignment ((GtkMisc*) auth_user_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) auth_password_label, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) auth_user_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) auth_password_label, TRUE);
	_tmp17_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->m_authUserEntry);
	self->priv->m_authUserEntry = _tmp17_;
	_tmp18_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->m_authPasswordEntry);
	self->priv->m_authPasswordEntry = _tmp18_;
	_tmp19_ = self->priv->m_authPasswordEntry;
	gtk_entry_set_input_purpose (_tmp19_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp20_ = self->priv->m_authPasswordEntry;
	gtk_entry_set_visibility (_tmp20_, FALSE);
	_tmp21_ = self->priv->m_authUserEntry;
	g_signal_connect_object (_tmp21_, "activate", (GCallback) ___lambda10__gtk_entry_activate, self, 0);
	_tmp22_ = self->priv->m_authPasswordEntry;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) ___lambda11__gtk_entry_activate, self, 0);
	_tmp23_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp23_);
	authGrid = _tmp23_;
	g_object_set ((GtkWidget*) authGrid, "margin", 10, NULL);
	gtk_grid_set_column_spacing (authGrid, (guint) 10);
	gtk_grid_set_row_spacing (authGrid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) authGrid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) authGrid, GTK_ALIGN_CENTER);
	gtk_grid_attach (authGrid, (GtkWidget*) auth_user_label, 0, 0, 1, 1);
	_tmp24_ = self->priv->m_authUserEntry;
	gtk_grid_attach (authGrid, (GtkWidget*) _tmp24_, 1, 0, 1, 1);
	gtk_grid_attach (authGrid, (GtkWidget*) auth_password_label, 0, 1, 1, 1);
	_tmp25_ = self->priv->m_authPasswordEntry;
	gtk_grid_attach (authGrid, (GtkWidget*) _tmp25_, 1, 1, 1, 1);
	_tmp26_ = (GtkFrame*) gtk_frame_new (_ ("HTTP Authorization"));
	g_object_ref_sink (_tmp26_);
	frame = _tmp26_;
	gtk_widget_set_halign ((GtkWidget*) frame, GTK_ALIGN_CENTER);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) authGrid);
	_tmp27_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->m_revealer);
	self->priv->m_revealer = _tmp27_;
	_tmp28_ = self->priv->m_revealer;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) frame);
	_tmp29_ = (GtkImage*) gtk_image_new_from_icon_name ("feed-service-fresh", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp29_);
	logo = _tmp29_;
	_tmp30_ = (GtkLabel*) gtk_label_new (_ ("Please log in to your freshRSS server and enjoy using FeedReader"));
	g_object_ref_sink (_tmp30_);
	loginLabel = _tmp30_;
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) loginLabel);
	gtk_style_context_add_class (_tmp31_, "h2");
	gtk_label_set_justify (loginLabel, GTK_JUSTIFY_CENTER);
	gtk_label_set_lines (loginLabel, 3);
	_tmp32_ = (GtkButton*) gtk_button_new_with_label (_ ("Login"));
	g_object_ref_sink (_tmp32_);
	loginButton = _tmp32_;
	gtk_widget_set_halign ((GtkWidget*) loginButton, GTK_ALIGN_END);
	gtk_widget_set_size_request ((GtkWidget*) loginButton, 80, 30);
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) loginButton);
	gtk_style_context_add_class (_tmp33_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_object (loginButton, "clicked", (GCallback) ___lambda12__gtk_button_clicked, self, 0);
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp34_);
	box = _tmp34_;
	gtk_widget_set_valign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_box_pack_start (box, (GtkWidget*) loginLabel, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) logo, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) grid, TRUE, TRUE, (guint) 10);
	_tmp35_ = self->priv->m_revealer;
	gtk_box_pack_start (box, (GtkWidget*) _tmp35_, TRUE, TRUE, (guint) 10);
	gtk_box_pack_end (box, (GtkWidget*) loginButton, FALSE, FALSE, (guint) 20);
	_tmp36_ = self->priv->m_urlEntry;
	_tmp37_ = self->priv->m_utils;
	_tmp38_ = feed_reader_fresh_utils_getUnmodifiedURL (_tmp37_);
	_tmp39_ = _tmp38_;
	gtk_entry_set_text (_tmp36_, _tmp39_);
	_g_free0 (_tmp39_);
	_tmp40_ = self->priv->m_userEntry;
	_tmp41_ = self->priv->m_utils;
	_tmp42_ = feed_reader_fresh_utils_getUser (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_entry_set_text (_tmp40_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->m_passwordEntry;
	_tmp45_ = self->priv->m_utils;
	_tmp46_ = feed_reader_fresh_utils_getPasswd (_tmp45_);
	_tmp47_ = _tmp46_;
	gtk_entry_set_text (_tmp44_, _tmp47_);
	_g_free0 (_tmp47_);
	result = box;
	_g_object_unref0 (loginButton);
	_g_object_unref0 (loginLabel);
	_g_object_unref0 (logo);
	_g_object_unref0 (frame);
	_g_object_unref0 (authGrid);
	_g_object_unref0 (auth_password_label);
	_g_object_unref0 (auth_user_label);
	_g_object_unref0 (grid);
	_g_object_unref0 (password_label);
	_g_object_unref0 (user_label);
	_g_object_unref0 (url_label);
	return result;
}

static void
feed_reader_fresh_interface_real_showHtAccess (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	GtkRevealer* _tmp0_;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
feed_reader_fresh_interface_real_writeData (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshUtils* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	FeedReaderfreshUtils* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderfreshUtils* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = self->priv->m_urlEntry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	feed_reader_fresh_utils_setURL (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->m_utils;
	_tmp4_ = self->priv->m_userEntry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = string_strip (_tmp5_);
	_tmp7_ = _tmp6_;
	feed_reader_fresh_utils_setUser (_tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->m_utils;
	_tmp9_ = self->priv->m_passwordEntry;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = string_strip (_tmp10_);
	_tmp12_ = _tmp11_;
	feed_reader_fresh_utils_setPassword (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	if (self->priv->m_need_htaccess) {
		FeedReaderfreshUtils* _tmp13_;
		GtkEntry* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FeedReaderfreshUtils* _tmp18_;
		GtkEntry* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = self->priv->m_utils;
		_tmp14_ = self->priv->m_authUserEntry;
		_tmp15_ = gtk_entry_get_text (_tmp14_);
		_tmp16_ = string_strip (_tmp15_);
		_tmp17_ = _tmp16_;
		feed_reader_fresh_utils_setHtaccessUser (_tmp13_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = self->priv->m_utils;
		_tmp19_ = self->priv->m_authPasswordEntry;
		_tmp20_ = gtk_entry_get_text (_tmp19_);
		_tmp21_ = string_strip (_tmp20_);
		_tmp22_ = _tmp21_;
		feed_reader_fresh_utils_setHtAccessPassword (_tmp18_, _tmp22_);
		_g_free0 (_tmp22_);
	}
}

static gboolean
feed_reader_fresh_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = TRUE;
	return result;
}

static gchar*
feed_reader_fresh_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = g_strdup ("feed-service-fresh-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_fresh_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getUser (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_fresh_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getUnmodifiedURL (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_fresh_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = g_strdup ("1");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                        const gchar* catID)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	g_return_val_if_fail (catID != NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_fresh_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = TRUE;
	return result;
}

static void
feed_reader_fresh_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshUtils* _tmp0_;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_utils;
	feed_reader_fresh_utils_resetAccount (_tmp0_);
}

static gboolean
feed_reader_fresh_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = TRUE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_fresh_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	FeedReaderLoginResponse result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_fresh_api_login (_tmp0_);
	return result;
}

static gboolean
feed_reader_fresh_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_fresh_utils_getApiURL (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = feed_reader_utils_ping (_tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
feed_reader_fresh_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* articleIDs,
                                                   FeedReaderArticleStatus read)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (articleIDs != NULL);
	if (read == FEED_READER_ARTICLE_STATUS_READ) {
		FeedReaderfreshAPI* _tmp0_;
		_tmp0_ = self->priv->m_api;
		feed_reader_fresh_api_editTags (_tmp0_, articleIDs, "user/-/state/com.google/read", NULL);
	} else {
		FeedReaderfreshAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feed_reader_fresh_api_editTags (_tmp1_, articleIDs, NULL, "user/-/state/com.google/read");
	}
}

static void
feed_reader_fresh_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                     const gchar* articleID,
                                                     FeedReaderArticleStatus marked)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (articleID != NULL);
	if (marked == FEED_READER_ARTICLE_STATUS_MARKED) {
		FeedReaderfreshAPI* _tmp0_;
		_tmp0_ = self->priv->m_api;
		feed_reader_fresh_api_editTags (_tmp0_, articleID, "user/-/state/com.google/starred", NULL);
	} else {
		FeedReaderfreshAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feed_reader_fresh_api_editTags (_tmp1_, articleID, NULL, "user/-/state/com.google/starred");
	}
}

static gboolean
feed_reader_fresh_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_fresh_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                              const gchar* feedID)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_fresh_api_markAllAsRead (_tmp0_, feedID);
}

static void
feed_reader_fresh_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                  const gchar* catID)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_fresh_api_markAllAsRead (_tmp0_, catID);
}

static void
feed_reader_fresh_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_api;
	feed_reader_fresh_api_markAllAsRead (_tmp0_, "user/-/state/com.google/reading-list");
}

static void
feed_reader_fresh_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                             const gchar* articleID,
                                             const gchar* tagID)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static void
feed_reader_fresh_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* articleID,
                                                   const gchar* tagID)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static gchar*
feed_reader_fresh_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                            const gchar* caption)
{
	FeedReaderfreshInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static void
feed_reader_fresh_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                            const gchar* tagID)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (tagID != NULL);
}

static void
feed_reader_fresh_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                            const gchar* tagID,
                                            const gchar* title)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
}

static gboolean
feed_reader_fresh_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                          const gchar* feedURL,
                                          const gchar* catID,
                                          const gchar* newCatName,
                                          gchar** feedID,
                                          gchar** errmsg)
{
	FeedReaderfreshInterface * self;
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	gchar* cat = NULL;
	FeedReaderfreshAPI* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	FeedReaderResponse response = {0};
	FeedReaderfreshAPI* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	FeedReaderResponse _tmp10_ = {0};
	FeedReaderResponse _tmp11_;
	FeedReaderResponse _tmp12_;
	gchar* _tmp17_;
	FeedReaderResponse _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	g_return_val_if_fail (feedURL != NULL, FALSE);
	cat = NULL;
	if (catID != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (catID);
		_g_free0 (cat);
		cat = _tmp0_;
	} else {
		if (newCatName != NULL) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup (newCatName);
			_g_free0 (cat);
			cat = _tmp1_;
		}
	}
	_tmp2_ = self->priv->m_api;
	_tmp3_ = cat;
	_tmp4_ = feed_reader_fresh_api_composeTagID (_tmp2_, _tmp3_);
	_g_free0 (cat);
	cat = _tmp4_;
	_tmp5_ = self->priv->m_api;
	_tmp6_ = g_strconcat ("feed/", feedURL, NULL);
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	_tmp9_ = cat;
	feed_reader_fresh_api_editStream (_tmp5_, "subscribe", _tmp8_, (gint) 1, NULL, _tmp9_, NULL, &_tmp10_);
	_tmp11_ = _tmp10_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	response = _tmp11_;
	_tmp12_ = response;
	if (_tmp12_.status != ((guint) 200)) {
		gchar* _tmp13_;
		FeedReaderResponse _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = g_strdup ("");
		_g_free0 (_vala_feedID);
		_vala_feedID = _tmp13_;
		_tmp14_ = response;
		_tmp15_ = _tmp14_.data;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp16_;
		result = FALSE;
		feed_reader_response_destroy (&response);
		_g_free0 (cat);
		if (feedID) {
			*feedID = _vala_feedID;
		} else {
			_g_free0 (_vala_feedID);
		}
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	_tmp17_ = g_strdup ("");
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp17_;
	_tmp18_ = response;
	_tmp19_ = _tmp18_.data;
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (_vala_feedID);
	_vala_feedID = _tmp20_;
	result = TRUE;
	feed_reader_response_destroy (&response);
	_g_free0 (cat);
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
feed_reader_fresh_interface_real_addFeeds (FeedReaderFeedServerInterface* base,
                                           GeeList* feeds)
{
	FeedReaderfreshInterface * self;
	gchar* cat = NULL;
	gchar* _tmp0_;
	gchar** urls = NULL;
	gchar** _tmp1_;
	gint urls_length1;
	gint _urls_size_;
	FeedReaderfreshAPI* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	const gchar* _tmp32_;
	FeedReaderResponse _tmp33_ = {0};
	FeedReaderResponse _tmp34_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (feeds != NULL);
	_tmp0_ = g_strdup ("");
	cat = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	urls = _tmp1_;
	urls_length1 = 0;
	_urls_size_ = urls_length1;
	{
		GeeList* _f_list = NULL;
		gint _f_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _f_index = 0;
		_f_list = feeds;
		_tmp2_ = _f_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_f_size = _tmp4_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			FeedReaderFeed* f = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			FeedReaderFeed* _tmp9_;
			GeeList* _tmp10_;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gboolean _tmp15_;
			FeedReaderFeed* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_f_index = _f_index + 1;
			_tmp5_ = _f_index;
			_tmp6_ = _f_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _f_list;
			_tmp8_ = gee_list_get (_tmp7_, _f_index);
			f = (FeedReaderFeed*) _tmp8_;
			_tmp9_ = f;
			_tmp10_ = feed_reader_feed_getCatIDs (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_list_get (_tmp11_, 0);
			_tmp13_ = (gchar*) _tmp12_;
			_tmp14_ = cat;
			_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
			_g_free0 (_tmp13_);
			_g_object_unref0 (_tmp11_);
			if (_tmp15_) {
				FeedReaderfreshAPI* _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				FeedReaderResponse _tmp19_ = {0};
				FeedReaderResponse _tmp20_;
				gchar** _tmp21_;
				FeedReaderFeed* _tmp22_;
				GeeList* _tmp23_;
				GeeList* _tmp24_;
				gpointer _tmp25_;
				_tmp16_ = self->priv->m_api;
				_tmp17_ = urls;
				_tmp17__length1 = urls_length1;
				_tmp18_ = cat;
				feed_reader_fresh_api_editStream (_tmp16_, "subscribe", _tmp17_, (gint) _tmp17__length1, NULL, _tmp18_, NULL, &_tmp19_);
				_tmp20_ = _tmp19_;
				feed_reader_response_destroy (&_tmp20_);
				_tmp21_ = g_new0 (gchar*, 0 + 1);
				urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
				urls = _tmp21_;
				urls_length1 = 0;
				_urls_size_ = urls_length1;
				_tmp22_ = f;
				_tmp23_ = feed_reader_feed_getCatIDs (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = gee_list_get (_tmp24_, 0);
				_g_free0 (cat);
				cat = (gchar*) _tmp25_;
				_g_object_unref0 (_tmp24_);
			}
			_tmp26_ = f;
			_tmp27_ = feed_reader_feed_getXmlUrl (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat ("feed/", _tmp28_, NULL);
			_vala_array_add1 (&urls, &urls_length1, &_urls_size_, _tmp29_);
			_g_free0 (_tmp28_);
			_g_object_unref0 (f);
		}
	}
	_tmp30_ = self->priv->m_api;
	_tmp31_ = urls;
	_tmp31__length1 = urls_length1;
	_tmp32_ = cat;
	feed_reader_fresh_api_editStream (_tmp30_, "subscribe", _tmp31_, (gint) _tmp31__length1, NULL, _tmp32_, NULL, &_tmp33_);
	_tmp34_ = _tmp33_;
	feed_reader_response_destroy (&_tmp34_);
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cat);
}

static void
feed_reader_fresh_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feedID)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	FeedReaderResponse _tmp4_ = {0};
	FeedReaderResponse _tmp5_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_fresh_api_editStream (_tmp0_, "unsubscribe", _tmp3_, (gint) 1, NULL, NULL, NULL, &_tmp4_);
	_tmp5_ = _tmp4_;
	feed_reader_response_destroy (&_tmp5_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
feed_reader_fresh_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feedID,
                                             const gchar* title)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	FeedReaderResponse _tmp4_ = {0};
	FeedReaderResponse _tmp5_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_fresh_api_editStream (_tmp0_, "edit", _tmp3_, (gint) 1, title, NULL, NULL, &_tmp4_);
	_tmp5_ = _tmp4_;
	feed_reader_response_destroy (&_tmp5_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
feed_reader_fresh_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                           const gchar* feedID,
                                           const gchar* newCatID,
                                           const gchar* currentCatID)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	FeedReaderResponse _tmp4_ = {0};
	FeedReaderResponse _tmp5_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_fresh_api_editStream (_tmp0_, "edit", _tmp3_, (gint) 1, NULL, newCatID, currentCatID, &_tmp4_);
	_tmp5_ = _tmp4_;
	feed_reader_response_destroy (&_tmp5_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
feed_reader_fresh_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* title,
                                                 const gchar* parentID)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderfreshInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = feed_reader_fresh_api_composeTagID (_tmp0_, title);
	result = _tmp1_;
	return result;
}

static void
feed_reader_fresh_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* catID,
                                                 const gchar* title)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_fresh_api_renameTag (_tmp0_, catID, title);
}

static void
feed_reader_fresh_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                               const gchar* catID,
                                               const gchar* newParentID)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	return;
}

static void
feed_reader_fresh_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* catID)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_fresh_api_deleteTag (_tmp0_, catID);
}

static void
feed_reader_fresh_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feedID,
                                                    const gchar* catID)
{
	FeedReaderfreshInterface * self;
	self = (FeedReaderfreshInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	return;
}

static gboolean
feed_reader_fresh_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                  GeeList* feeds,
                                                  GeeList* categories,
                                                  GeeList* tags,
                                                  GCancellable* cancellable)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderfreshInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_api;
	if (feed_reader_fresh_api_getSubscriptionList (_tmp0_, feeds)) {
		gboolean _tmp1_ = FALSE;
		FeedReaderfreshAPI* _tmp2_;
		if (cancellable != NULL) {
			_tmp1_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = self->priv->m_api;
		if (feed_reader_fresh_api_getTagList (_tmp2_, categories)) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gint
feed_reader_fresh_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderfreshInterface * self;
	FeedReaderfreshAPI* _tmp0_;
	gint result;
	self = (FeedReaderfreshInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_fresh_api_getUnreadCounts (_tmp0_);
	return result;
}

static void
feed_reader_fresh_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                              gint count,
                                              FeedReaderArticleStatus whatToGet,
                                              GDateTime* since,
                                              const gchar* feedID,
                                              gboolean isTagID,
                                              GCancellable* cancellable)
{
	FeedReaderfreshInterface * self;
	GeeLinkedList* articles = NULL;
	GeeLinkedList* _tmp0_;
	gchar* continuation = NULL;
	gchar* exclude = NULL;
	gchar* labelID = NULL;
	gint left = 0;
	GeeLinkedList* _tmp16_;
	self = (FeedReaderfreshInterface*) base;
	if (whatToGet == FEED_READER_ARTICLE_STATUS_READ) {
		return;
	}
	_tmp0_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp0_;
	continuation = NULL;
	exclude = NULL;
	labelID = NULL;
	left = count;
	if (whatToGet == FEED_READER_ARTICLE_STATUS_ALL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("user/-/state/com.google/reading-list");
		_g_free0 (labelID);
		labelID = _tmp1_;
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_MARKED) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("user/-/state/com.google/starred");
			_g_free0 (labelID);
			labelID = _tmp2_;
		} else {
			if (whatToGet == FEED_READER_ARTICLE_STATUS_UNREAD) {
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup ("user/-/state/com.google/reading-list");
				_g_free0 (labelID);
				labelID = _tmp3_;
				_tmp4_ = g_strdup ("user/-/state/com.google/read");
				_g_free0 (exclude);
				exclude = _tmp4_;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		if (!(left > 0)) {
			break;
		}
		if (cancellable != NULL) {
			_tmp5_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_g_free0 (labelID);
			_g_free0 (exclude);
			_g_free0 (continuation);
			_g_object_unref0 (articles);
			return;
		}
		if (left > 1000) {
			FeedReaderfreshAPI* _tmp6_;
			GeeLinkedList* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = self->priv->m_api;
			_tmp7_ = articles;
			_tmp8_ = labelID;
			_tmp9_ = exclude;
			_tmp10_ = feed_reader_fresh_api_getStreamContents (_tmp6_, (GeeList*) _tmp7_, NULL, _tmp8_, _tmp9_, 1000, "d", NULL);
			_g_free0 (continuation);
			continuation = _tmp10_;
			left -= 1000;
		} else {
			FeedReaderfreshAPI* _tmp11_;
			GeeLinkedList* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp11_ = self->priv->m_api;
			_tmp12_ = articles;
			_tmp13_ = labelID;
			_tmp14_ = exclude;
			_tmp15_ = feed_reader_fresh_api_getStreamContents (_tmp11_, (GeeList*) _tmp12_, NULL, _tmp13_, _tmp14_, left, "d", NULL);
			_g_free0 (continuation);
			continuation = _tmp15_;
			left = 0;
		}
	}
	_tmp16_ = articles;
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "write-articles", (GeeList*) _tmp16_);
	_g_free0 (labelID);
	_g_free0 (exclude);
	_g_free0 (continuation);
	_g_object_unref0 (articles);
}

FeedReaderfreshInterface*
feed_reader_fresh_interface_construct (GType object_type)
{
	FeedReaderfreshInterface * self = NULL;
	self = (FeedReaderfreshInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderfreshInterface*
feed_reader_fresh_interface_new (void)
{
	return feed_reader_fresh_interface_construct (FEED_READER_TYPE_FRESH_INTERFACE);
}

static void
feed_reader_fresh_interface_class_init (FeedReaderfreshInterfaceClass * klass,
                                        gpointer klass_data)
{
	feed_reader_fresh_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderfreshInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_fresh_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWidget = (GtkBox* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_getWidget;
	((FeedReaderFeedServerInterfaceClass *) klass)->showHtAccess = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_showHtAccess;
	((FeedReaderFeedServerInterfaceClass *) klass)->writeData = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_writeData;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_fresh_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_fresh_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_fresh_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_fresh_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_fresh_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_fresh_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_fresh_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_fresh_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeeds = (void (*) (FeedReaderFeedServerInterface*, GeeList*)) feed_reader_fresh_interface_real_addFeeds;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_fresh_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_fresh_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_fresh_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_fresh_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_fresh_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_fresh_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_fresh_interface_finalize;
}

static void
feed_reader_fresh_interface_instance_init (FeedReaderfreshInterface * self,
                                           gpointer klass)
{
	self->priv = feed_reader_fresh_interface_get_instance_private (self);
	self->priv->m_need_htaccess = FALSE;
}

static void
feed_reader_fresh_interface_finalize (GObject * obj)
{
	FeedReaderfreshInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_FRESH_INTERFACE, FeedReaderfreshInterface);
	_g_object_unref0 (self->priv->m_api);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_urlEntry);
	_g_object_unref0 (self->priv->m_userEntry);
	_g_object_unref0 (self->priv->m_passwordEntry);
	_g_object_unref0 (self->priv->m_authPasswordEntry);
	_g_object_unref0 (self->priv->m_authUserEntry);
	_g_object_unref0 (self->priv->m_revealer);
	G_OBJECT_CLASS (feed_reader_fresh_interface_parent_class)->finalize (obj);
}

GType
feed_reader_fresh_interface_get_type (void)
{
	return feed_reader_fresh_interface_type_id;
}

GType
feed_reader_fresh_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderfreshInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_fresh_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderfreshInterface), 0, (GInstanceInitFunc) feed_reader_fresh_interface_instance_init, NULL };
	feed_reader_fresh_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderfreshInterface", &g_define_type_info, 0);
	FeedReaderfreshInterface_private_offset = sizeof (FeedReaderfreshInterfacePrivate);
	return feed_reader_fresh_interface_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_fresh_api_register_type (module);
	feed_reader_fresh_interface_register_type (module);
	feed_reader_fresh_utils_register_type (module);
	feed_reader_fresh_connection_register_type (module);
	feed_reader_fresh_message_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_FRESH_INTERFACE);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

