/* InoReaderAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from InoReaderAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "inoreader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <json-glib/json-glib.h>
#include <gee.h>
#include <gio/gio.h>

enum  {
	FEED_READER_INO_READER_API_0_PROPERTY,
	FEED_READER_INO_READER_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_ino_reader_api_properties[FEED_READER_INO_READER_API_NUM_PROPERTIES];
#define _feed_reader_ino_reader_connection_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_ino_reader_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FeedReaderInoReaderAPIPrivate {
	FeedReaderInoReaderConnection* m_connection;
	FeedReaderInoReaderUtils* m_utils;
	gchar* m_userID;
};

static gint FeedReaderInoReaderAPI_private_offset;
static gpointer feed_reader_ino_reader_api_parent_class = NULL;
static GType feed_reader_ino_reader_api_type_id = 0;

static gboolean feed_reader_ino_reader_api_getUserID (FeedReaderInoReaderAPI* self);
static void feed_reader_ino_reader_api_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
feed_reader_ino_reader_api_get_instance_private (FeedReaderInoReaderAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderInoReaderAPI_private_offset);
}

static GType
feed_reader_ino_reader_api_ino_subscription_action_get_type_once (void)
{
	static const GEnumValue values[] = {{FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_EDIT, "FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_EDIT", "edit"}, {FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_SUBSCRIBE, "FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_SUBSCRIBE", "subscribe"}, {FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_UNSUBSCRIBE, "FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_UNSUBSCRIBE", "unsubscribe"}, {0, NULL, NULL}};
	GType feed_reader_ino_reader_api_ino_subscription_action_type_id;
	feed_reader_ino_reader_api_ino_subscription_action_type_id = g_enum_register_static ("FeedReaderInoReaderAPIInoSubscriptionAction", values);
	return feed_reader_ino_reader_api_ino_subscription_action_type_id;
}

GType
feed_reader_ino_reader_api_ino_subscription_action_get_type (void)
{
	static volatile gsize feed_reader_ino_reader_api_ino_subscription_action_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_ino_reader_api_ino_subscription_action_type_id__once)) {
		GType feed_reader_ino_reader_api_ino_subscription_action_type_id;
		feed_reader_ino_reader_api_ino_subscription_action_type_id = feed_reader_ino_reader_api_ino_subscription_action_get_type_once ();
		g_once_init_leave (&feed_reader_ino_reader_api_ino_subscription_action_type_id__once, feed_reader_ino_reader_api_ino_subscription_action_type_id);
	}
	return feed_reader_ino_reader_api_ino_subscription_action_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderInoReaderAPI*
feed_reader_ino_reader_api_construct (GType object_type,
                                      FeedReaderInoReaderUtils* utils)
{
	FeedReaderInoReaderAPI * self = NULL;
	FeedReaderInoReaderUtils* _tmp0_;
	FeedReaderInoReaderUtils* _tmp1_;
	FeedReaderInoReaderConnection* _tmp2_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderInoReaderAPI*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_ino_reader_connection_new (_tmp1_);
	_feed_reader_ino_reader_connection_unref0 (self->priv->m_connection);
	self->priv->m_connection = _tmp2_;
	return self;
}

FeedReaderInoReaderAPI*
feed_reader_ino_reader_api_new (FeedReaderInoReaderUtils* utils)
{
	return feed_reader_ino_reader_api_construct (FEED_READER_TYPE_INO_READER_API, utils);
}

FeedReaderLoginResponse
feed_reader_ino_reader_api_login (FeedReaderInoReaderAPI* self)
{
	FeedReaderInoReaderUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_ino_reader_utils_getAccessToken (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		FeedReaderInoReaderConnection* _tmp4_;
		_tmp4_ = self->priv->m_connection;
		feed_reader_ino_reader_connection_getToken (_tmp4_);
	}
	if (feed_reader_ino_reader_api_getUserID (self)) {
		result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
		return result;
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	return result;
}

gboolean
feed_reader_ino_reader_api_ping (FeedReaderInoReaderAPI* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = feed_reader_utils_ping ("http://www.inoreader.com/");
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
feed_reader_ino_reader_api_getUserID (FeedReaderInoReaderAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderInoReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonObject* _tmp14_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_ino_reader_connection_send_request (_tmp0_, "user-info", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getUserID: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	if (json_object_has_member (_tmp14_, "userId")) {
		JsonObject* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		FeedReaderInoReaderUtils* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		JsonObject* _tmp23_;
		JsonObject* _tmp27_;
		_tmp15_ = root;
		_tmp16_ = json_object_get_string_member (_tmp15_, "userId");
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (self->priv->m_userID);
		self->priv->m_userID = _tmp17_;
		_tmp18_ = self->priv->m_utils;
		_tmp19_ = self->priv->m_userID;
		feed_reader_ino_reader_utils_setUserID (_tmp18_, _tmp19_);
		_tmp20_ = self->priv->m_userID;
		_tmp21_ = g_strconcat ("Inoreader: userID = ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		feed_reader_logger_info (_tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = root;
		if (json_object_has_member (_tmp23_, "userEmail")) {
			FeedReaderInoReaderUtils* _tmp24_;
			JsonObject* _tmp25_;
			const gchar* _tmp26_;
			_tmp24_ = self->priv->m_utils;
			_tmp25_ = root;
			_tmp26_ = json_object_get_string_member (_tmp25_, "userEmail");
			feed_reader_ino_reader_utils_setEmail (_tmp24_, _tmp26_);
		}
		_tmp27_ = root;
		if (json_object_has_member (_tmp27_, "userName")) {
			FeedReaderInoReaderUtils* _tmp28_;
			JsonObject* _tmp29_;
			const gchar* _tmp30_;
			_tmp28_ = self->priv->m_utils;
			_tmp29_ = root;
			_tmp30_ = json_object_get_string_member (_tmp29_, "userName");
			feed_reader_ino_reader_utils_setUser (_tmp28_, _tmp30_);
		}
		result = TRUE;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	result = FALSE;
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

gboolean
feed_reader_ino_reader_api_getFeeds (FeedReaderInoReaderAPI* self,
                                     GeeList* feeds)
{
	FeedReaderResponse response = {0};
	FeedReaderInoReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* array = NULL;
	JsonObject* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	guint length = 0U;
	JsonArray* _tmp17_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_ino_reader_connection_send_request (_tmp0_, "subscription/list", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getFeeds: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	_tmp15_ = json_object_get_array_member (_tmp14_, "subscriptions");
	_tmp16_ = _json_array_ref0 (_tmp15_);
	array = _tmp16_;
	_tmp17_ = array;
	length = json_array_get_length (_tmp17_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp20_;
				JsonObject* _tmp21_;
				JsonObject* _tmp22_;
				gchar* feedID = NULL;
				JsonObject* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				const gchar* _tmp26_ = NULL;
				JsonObject* _tmp27_;
				gchar* url = NULL;
				gchar* _tmp32_;
				guint catCount = 0U;
				JsonObject* _tmp33_;
				JsonArray* _tmp34_;
				GeeArrayList* categories = NULL;
				GeeArrayList* _tmp35_;
				const gchar* _tmp43_;
				JsonObject* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				GeeArrayList* _tmp47_;
				JsonObject* _tmp48_;
				const gchar* _tmp49_;
				JsonObject* _tmp50_;
				const gchar* _tmp51_;
				FeedReaderFeed* _tmp52_;
				FeedReaderFeed* _tmp53_;
				if (!_tmp18_) {
					guint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp20_ = array;
				_tmp21_ = json_array_get_object_element (_tmp20_, i);
				_tmp22_ = _json_object_ref0 (_tmp21_);
				object = _tmp22_;
				_tmp23_ = object;
				_tmp24_ = json_object_get_string_member (_tmp23_, "id");
				_tmp25_ = g_strdup (_tmp24_);
				feedID = _tmp25_;
				_tmp27_ = object;
				if (json_object_has_member (_tmp27_, "htmlUrl")) {
					JsonObject* _tmp28_;
					const gchar* _tmp29_;
					_tmp28_ = object;
					_tmp29_ = json_object_get_string_member (_tmp28_, "htmlUrl");
					_tmp26_ = _tmp29_;
				} else {
					JsonObject* _tmp30_;
					const gchar* _tmp31_;
					_tmp30_ = object;
					_tmp31_ = json_object_get_string_member (_tmp30_, "url");
					_tmp26_ = _tmp31_;
				}
				_tmp32_ = g_strdup (_tmp26_);
				url = _tmp32_;
				_tmp33_ = object;
				_tmp34_ = json_object_get_array_member (_tmp33_, "categories");
				catCount = json_array_get_length (_tmp34_);
				_tmp35_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				categories = _tmp35_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp36_ = FALSE;
						_tmp36_ = TRUE;
						while (TRUE) {
							GeeArrayList* _tmp38_;
							JsonObject* _tmp39_;
							JsonArray* _tmp40_;
							JsonObject* _tmp41_;
							const gchar* _tmp42_;
							if (!_tmp36_) {
								guint _tmp37_;
								j = j + 1;
								_tmp37_ = j;
							}
							_tmp36_ = FALSE;
							if (!(j < catCount)) {
								break;
							}
							_tmp38_ = categories;
							_tmp39_ = object;
							_tmp40_ = json_object_get_array_member (_tmp39_, "categories");
							_tmp41_ = json_array_get_object_element (_tmp40_, j);
							_tmp42_ = json_object_get_string_member (_tmp41_, "id");
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp42_);
						}
					}
				}
				_tmp43_ = feedID;
				_tmp44_ = object;
				_tmp45_ = json_object_get_string_member (_tmp44_, "title");
				_tmp46_ = url;
				_tmp47_ = categories;
				_tmp48_ = object;
				_tmp49_ = json_object_get_string_member (_tmp48_, "iconUrl");
				_tmp50_ = object;
				_tmp51_ = json_object_get_string_member (_tmp50_, "url");
				_tmp52_ = feed_reader_feed_new (_tmp43_, _tmp45_, _tmp46_, (guint) 0, (GeeList*) _tmp47_, _tmp49_, _tmp51_);
				_tmp53_ = _tmp52_;
				gee_collection_add ((GeeCollection*) feeds, _tmp53_);
				_g_object_unref0 (_tmp53_);
				_g_object_unref0 (categories);
				_g_free0 (url);
				_g_free0 (feedID);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
feed_reader_ino_reader_api_getCategoriesAndTags (FeedReaderInoReaderAPI* self,
                                                 GeeList* feeds,
                                                 GeeList* categories,
                                                 GeeList* tags)
{
	FeedReaderResponse response = {0};
	FeedReaderInoReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* array = NULL;
	JsonObject* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	guint length = 0U;
	JsonArray* _tmp17_;
	gint orderID = 0;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_ino_reader_connection_send_request (_tmp0_, "tag/list", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getCategoriesAndTags: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	_tmp15_ = json_object_get_array_member (_tmp14_, "tags");
	_tmp16_ = _json_array_ref0 (_tmp15_);
	array = _tmp16_;
	_tmp17_ = array;
	length = json_array_get_length (_tmp17_);
	orderID = 0;
	_tmp18_ = feed_reader_data_base_readOnly ();
	db = _tmp18_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp21_;
				JsonObject* _tmp22_;
				JsonObject* _tmp23_;
				gchar* id = NULL;
				JsonObject* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gint start = 0;
				const gchar* _tmp27_;
				gchar* title = NULL;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				if (!_tmp19_) {
					guint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp21_ = array;
				_tmp22_ = json_array_get_object_element (_tmp21_, i);
				_tmp23_ = _json_object_ref0 (_tmp22_);
				object = _tmp23_;
				_tmp24_ = object;
				_tmp25_ = json_object_get_string_member (_tmp24_, "id");
				_tmp26_ = g_strdup (_tmp25_);
				id = _tmp26_;
				_tmp27_ = id;
				start = string_last_index_of_char (_tmp27_, (gunichar) '/', 0) + 1;
				_tmp28_ = id;
				_tmp29_ = string_substring (_tmp28_, (glong) start, (glong) -1);
				title = _tmp29_;
				_tmp30_ = id;
				if (string_contains (_tmp30_, "/label/")) {
					FeedReaderInoReaderUtils* _tmp31_;
					const gchar* _tmp32_;
					gint _tmp44_;
					_tmp31_ = self->priv->m_utils;
					_tmp32_ = id;
					if (feed_reader_ino_reader_utils_tagIsCat (_tmp31_, _tmp32_, feeds)) {
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						FeedReaderCategory* _tmp37_;
						FeedReaderCategory* _tmp38_;
						_tmp33_ = id;
						_tmp34_ = title;
						_tmp35_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
						_tmp36_ = _tmp35_;
						_tmp37_ = feed_reader_category_new (_tmp33_, _tmp34_, (guint) 0, orderID, _tmp36_, 1);
						_tmp38_ = _tmp37_;
						gee_collection_add ((GeeCollection*) categories, _tmp38_);
						_g_object_unref0 (_tmp38_);
						_g_free0 (_tmp36_);
					} else {
						const gchar* _tmp39_;
						const gchar* _tmp40_;
						FeedReaderDataBaseReadOnly* _tmp41_;
						FeedReaderTag* _tmp42_;
						FeedReaderTag* _tmp43_;
						_tmp39_ = id;
						_tmp40_ = title;
						_tmp41_ = db;
						_tmp42_ = feed_reader_tag_new (_tmp39_, _tmp40_, feed_reader_data_base_read_only_getTagColor (_tmp41_));
						_tmp43_ = _tmp42_;
						gee_collection_add ((GeeCollection*) tags, _tmp43_);
						_g_object_unref0 (_tmp43_);
					}
					orderID = orderID + 1;
					_tmp44_ = orderID;
				}
				_g_free0 (title);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (db);
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

gint
feed_reader_ino_reader_api_getTotalUnread (FeedReaderInoReaderAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderInoReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* array = NULL;
	JsonObject* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	guint length = 0U;
	JsonArray* _tmp17_;
	gint count = 0;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_connection;
	feed_reader_ino_reader_connection_send_request (_tmp0_, "unread-count", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = 0;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTotalUnread: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	_tmp15_ = json_object_get_array_member (_tmp14_, "unreadcounts");
	_tmp16_ = _json_array_ref0 (_tmp15_);
	array = _tmp16_;
	_tmp17_ = array;
	length = json_array_get_length (_tmp17_);
	count = 0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp20_;
				JsonObject* _tmp21_;
				JsonObject* _tmp22_;
				JsonObject* _tmp23_;
				const gchar* _tmp24_;
				if (!_tmp18_) {
					guint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp20_ = array;
				_tmp21_ = json_array_get_object_element (_tmp20_, i);
				_tmp22_ = _json_object_ref0 (_tmp21_);
				object = _tmp22_;
				_tmp23_ = object;
				_tmp24_ = json_object_get_string_member (_tmp23_, "id");
				if (g_str_has_prefix (_tmp24_, "feed/")) {
					JsonObject* _tmp25_;
					_tmp25_ = object;
					count += (gint) json_object_get_int_member (_tmp25_, "count");
				}
				_json_object_unref0 (object);
			}
		}
	}
	_tmp26_ = g_strdup_printf ("getTotalUnread %i", count);
	_tmp27_ = _tmp26_;
	feed_reader_logger_debug (_tmp27_);
	_g_free0 (_tmp27_);
	result = count;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

gchar*
feed_reader_ino_reader_api_updateArticles (FeedReaderInoReaderAPI* self,
                                           GeeList* ids,
                                           gint count,
                                           const gchar* continuation)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse response = {0};
	FeedReaderInoReaderConnection* _tmp10_;
	const gchar* _tmp11_;
	FeedReaderResponse _tmp12_ = {0};
	FeedReaderResponse _tmp13_;
	JsonParser* parser = NULL;
	JsonParser* _tmp14_;
	JsonObject* root = NULL;
	JsonParser* _tmp20_;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	JsonObject* _tmp24_;
	JsonArray* array = NULL;
	JsonObject* _tmp25_;
	JsonArray* _tmp26_;
	JsonArray* _tmp27_;
	guint length = 0U;
	JsonArray* _tmp28_;
	gboolean _tmp36_ = FALSE;
	JsonObject* _tmp37_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ids != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", count);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("n=", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message_string = _tmp3_;
	_tmp4_ = message_string;
	_tmp5_ = g_strconcat (_tmp4_, "&xt=user/-/state/com.google/read", NULL);
	_g_free0 (message_string);
	message_string = _tmp5_;
	if (continuation != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = message_string;
		_tmp7_ = g_strconcat ("&c=", continuation, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
		_g_free0 (message_string);
		message_string = _tmp9_;
		_g_free0 (_tmp8_);
	}
	_tmp10_ = self->priv->m_connection;
	_tmp11_ = message_string;
	feed_reader_ino_reader_connection_send_request (_tmp10_, "stream/items/ids", _tmp11_, &_tmp12_);
	response = _tmp12_;
	_tmp13_ = response;
	if (_tmp13_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		return result;
	}
	_tmp14_ = json_parser_new ();
	parser = _tmp14_;
	{
		JsonParser* _tmp15_;
		FeedReaderResponse _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = parser;
		_tmp16_ = response;
		_tmp17_ = _tmp16_.data;
		json_parser_load_from_data (_tmp15_, _tmp17_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("updateArticles: Could not load message response");
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		feed_reader_logger_error (_tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp20_ = parser;
	_tmp21_ = json_parser_get_root (_tmp20_);
	_tmp22_ = json_node_get_object (_tmp21_);
	_tmp23_ = _json_object_ref0 (_tmp22_);
	root = _tmp23_;
	_tmp24_ = root;
	if (!json_object_has_member (_tmp24_, "itemRefs")) {
		result = NULL;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		return result;
	}
	_tmp25_ = root;
	_tmp26_ = json_object_get_array_member (_tmp25_, "itemRefs");
	_tmp27_ = _json_array_ref0 (_tmp26_);
	array = _tmp27_;
	_tmp28_ = array;
	length = json_array_get_length (_tmp28_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp31_;
				JsonObject* _tmp32_;
				JsonObject* _tmp33_;
				JsonObject* _tmp34_;
				const gchar* _tmp35_;
				if (!_tmp29_) {
					guint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp31_ = array;
				_tmp32_ = json_array_get_object_element (_tmp31_, i);
				_tmp33_ = _json_object_ref0 (_tmp32_);
				object = _tmp33_;
				_tmp34_ = object;
				_tmp35_ = json_object_get_string_member (_tmp34_, "id");
				gee_collection_add ((GeeCollection*) ids, _tmp35_);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp37_ = root;
	if (json_object_has_member (_tmp37_, "continuation")) {
		JsonObject* _tmp38_;
		const gchar* _tmp39_;
		_tmp38_ = root;
		_tmp39_ = json_object_get_string_member (_tmp38_, "continuation");
		_tmp36_ = g_strcmp0 (_tmp39_, "") != 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		JsonObject* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp40_ = root;
		_tmp41_ = json_object_get_string_member (_tmp40_, "continuation");
		_tmp42_ = g_strdup (_tmp41_);
		result = _tmp42_;
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		return result;
	}
	result = NULL;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_g_free0 (message_string);
	return result;
}

gchar*
feed_reader_ino_reader_api_getArticles (FeedReaderInoReaderAPI* self,
                                        GeeList* articles,
                                        gint count,
                                        FeedReaderArticleStatus whatToGet,
                                        const gchar* continuation,
                                        const gchar* tagID,
                                        const gchar* feed_id)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* api_endpoint = NULL;
	gchar* _tmp14_;
	FeedReaderResponse response = {0};
	FeedReaderInoReaderConnection* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	FeedReaderResponse _tmp30_ = {0};
	FeedReaderResponse _tmp31_;
	JsonParser* parser = NULL;
	JsonParser* _tmp32_;
	JsonObject* root = NULL;
	JsonParser* _tmp38_;
	JsonNode* _tmp39_;
	JsonObject* _tmp40_;
	JsonObject* _tmp41_;
	JsonArray* array = NULL;
	JsonObject* _tmp42_;
	JsonArray* _tmp43_;
	JsonArray* _tmp44_;
	guint length = 0U;
	JsonArray* _tmp45_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp46_;
	gboolean _tmp122_ = FALSE;
	JsonObject* _tmp123_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articles != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", count);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("n=", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message_string = _tmp3_;
	if (whatToGet == FEED_READER_ARTICLE_STATUS_UNREAD) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = message_string;
		_tmp5_ = g_strconcat (_tmp4_, "&xt=user/-/state/com.google/read", NULL);
		_g_free0 (message_string);
		message_string = _tmp5_;
	}
	if (whatToGet == FEED_READER_ARTICLE_STATUS_READ) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = message_string;
		_tmp7_ = g_strconcat (_tmp6_, "&it=user/-/state/com.google/read", NULL);
		_g_free0 (message_string);
		message_string = _tmp7_;
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_MARKED) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = message_string;
			_tmp9_ = g_strconcat (_tmp8_, "&it=user/-/state/com.google/starred", NULL);
			_g_free0 (message_string);
			message_string = _tmp9_;
		}
	}
	if (continuation != NULL) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = message_string;
		_tmp11_ = g_strconcat ("&c=", continuation, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
		_g_free0 (message_string);
		message_string = _tmp13_;
		_g_free0 (_tmp12_);
	}
	_tmp14_ = g_strdup ("stream/contents");
	api_endpoint = _tmp14_;
	if (feed_id != NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp15_ = api_endpoint;
		_tmp16_ = g_uri_escape_string (feed_id, NULL, TRUE);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("/", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
		_g_free0 (api_endpoint);
		api_endpoint = _tmp20_;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
	} else {
		if (tagID != NULL) {
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = api_endpoint;
			_tmp22_ = g_uri_escape_string (tagID, NULL, TRUE);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat ("/", _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp21_, _tmp25_, NULL);
			_g_free0 (api_endpoint);
			api_endpoint = _tmp26_;
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
		}
	}
	_tmp27_ = self->priv->m_connection;
	_tmp28_ = api_endpoint;
	_tmp29_ = message_string;
	feed_reader_ino_reader_connection_send_request (_tmp27_, _tmp28_, _tmp29_, &_tmp30_);
	response = _tmp30_;
	_tmp31_ = response;
	if (_tmp31_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_g_free0 (message_string);
		return result;
	}
	_tmp32_ = json_parser_new ();
	parser = _tmp32_;
	{
		JsonParser* _tmp33_;
		FeedReaderResponse _tmp34_;
		const gchar* _tmp35_;
		_tmp33_ = parser;
		_tmp34_ = response;
		_tmp35_ = _tmp34_.data;
		json_parser_load_from_data (_tmp33_, _tmp35_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getArticles: Could not load message response");
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		feed_reader_logger_error (_tmp37_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_g_free0 (message_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp38_ = parser;
	_tmp39_ = json_parser_get_root (_tmp38_);
	_tmp40_ = json_node_get_object (_tmp39_);
	_tmp41_ = _json_object_ref0 (_tmp40_);
	root = _tmp41_;
	_tmp42_ = root;
	_tmp43_ = json_object_get_array_member (_tmp42_, "items");
	_tmp44_ = _json_array_ref0 (_tmp43_);
	array = _tmp44_;
	_tmp45_ = array;
	length = json_array_get_length (_tmp45_);
	_tmp46_ = feed_reader_data_base_readOnly ();
	db = _tmp46_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp49_;
				JsonObject* _tmp50_;
				JsonObject* _tmp51_;
				gchar* id = NULL;
				JsonObject* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				GeeArrayList* tags = NULL;
				GeeArrayList* _tmp58_;
				gboolean marked = FALSE;
				gboolean read = FALSE;
				JsonArray* cats = NULL;
				JsonObject* _tmp59_;
				JsonArray* _tmp60_;
				JsonArray* _tmp61_;
				guint cat_length = 0U;
				JsonArray* _tmp62_;
				GeeArrayList* enclosures = NULL;
				GeeArrayList* _tmp78_;
				JsonObject* _tmp79_;
				FeedReaderArticleStatus _tmp98_ = 0;
				FeedReaderArticleStatus _tmp99_ = 0;
				const gchar* _tmp100_;
				JsonObject* _tmp101_;
				const gchar* _tmp102_;
				JsonObject* _tmp103_;
				JsonArray* _tmp104_;
				JsonObject* _tmp105_;
				const gchar* _tmp106_;
				JsonObject* _tmp107_;
				JsonObject* _tmp108_;
				const gchar* _tmp109_;
				JsonObject* _tmp110_;
				JsonObject* _tmp111_;
				const gchar* _tmp112_;
				JsonObject* _tmp113_;
				const gchar* _tmp114_;
				JsonObject* _tmp115_;
				GDateTime* _tmp116_;
				GDateTime* _tmp117_;
				GeeArrayList* _tmp118_;
				GeeArrayList* _tmp119_;
				FeedReaderArticle* _tmp120_;
				FeedReaderArticle* _tmp121_;
				if (!_tmp47_) {
					guint _tmp48_;
					_tmp48_ = i;
					i = _tmp48_ + 1;
				}
				_tmp47_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp49_ = array;
				_tmp50_ = json_array_get_object_element (_tmp49_, i);
				_tmp51_ = _json_object_ref0 (_tmp50_);
				object = _tmp51_;
				_tmp52_ = object;
				_tmp53_ = json_object_get_string_member (_tmp52_, "id");
				_tmp54_ = g_strdup (_tmp53_);
				id = _tmp54_;
				_tmp55_ = id;
				_tmp56_ = id;
				_tmp57_ = string_substring (_tmp55_, (glong) (string_last_index_of_char (_tmp56_, (gunichar) '/', 0) + 1), (glong) -1);
				_g_free0 (id);
				id = _tmp57_;
				_tmp58_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				tags = _tmp58_;
				marked = FALSE;
				read = FALSE;
				_tmp59_ = object;
				_tmp60_ = json_object_get_array_member (_tmp59_, "categories");
				_tmp61_ = _json_array_ref0 (_tmp60_);
				cats = _tmp61_;
				_tmp62_ = cats;
				cat_length = json_array_get_length (_tmp62_);
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp63_ = FALSE;
						_tmp63_ = TRUE;
						while (TRUE) {
							gchar* cat = NULL;
							JsonArray* _tmp65_;
							const gchar* _tmp66_;
							gchar* _tmp67_;
							const gchar* _tmp68_;
							if (!_tmp63_) {
								guint _tmp64_;
								_tmp64_ = j;
								j = _tmp64_ + 1;
							}
							_tmp63_ = FALSE;
							if (!(j < cat_length)) {
								break;
							}
							_tmp65_ = cats;
							_tmp66_ = json_array_get_string_element (_tmp65_, j);
							_tmp67_ = g_strdup (_tmp66_);
							cat = _tmp67_;
							_tmp68_ = cat;
							if (g_str_has_suffix (_tmp68_, "com.google/starred")) {
								marked = TRUE;
							} else {
								const gchar* _tmp69_;
								_tmp69_ = cat;
								if (g_str_has_suffix (_tmp69_, "com.google/read")) {
									read = TRUE;
								} else {
									gboolean _tmp70_ = FALSE;
									const gchar* _tmp71_;
									_tmp71_ = cat;
									if (string_contains (_tmp71_, "/label/")) {
										FeedReaderDataBaseReadOnly* _tmp72_;
										const gchar* _tmp73_;
										gchar* _tmp74_;
										gchar* _tmp75_;
										_tmp72_ = db;
										_tmp73_ = cat;
										_tmp74_ = feed_reader_data_base_read_only_getTagName (_tmp72_, _tmp73_);
										_tmp75_ = _tmp74_;
										_tmp70_ = _tmp75_ != NULL;
										_g_free0 (_tmp75_);
									} else {
										_tmp70_ = FALSE;
									}
									if (_tmp70_) {
										GeeArrayList* _tmp76_;
										const gchar* _tmp77_;
										_tmp76_ = tags;
										_tmp77_ = cat;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
									}
								}
							}
							_g_free0 (cat);
						}
					}
				}
				_tmp78_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				enclosures = _tmp78_;
				_tmp79_ = object;
				if (json_object_has_member (_tmp79_, "enclosure")) {
					JsonArray* attachments = NULL;
					JsonObject* _tmp80_;
					JsonArray* _tmp81_;
					JsonArray* _tmp82_;
					guint mediaCount = 0U;
					JsonArray* _tmp83_;
					_tmp80_ = object;
					_tmp81_ = json_object_get_array_member (_tmp80_, "enclosure");
					_tmp82_ = _json_array_ref0 (_tmp81_);
					attachments = _tmp82_;
					mediaCount = (guint) 0;
					_tmp83_ = attachments;
					if (_tmp83_ != NULL) {
						JsonArray* _tmp84_;
						_tmp84_ = attachments;
						mediaCount = json_array_get_length (_tmp84_);
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp85_ = FALSE;
							_tmp85_ = TRUE;
							while (TRUE) {
								JsonObject* attachment = NULL;
								JsonArray* _tmp87_;
								JsonObject* _tmp88_;
								JsonObject* _tmp89_;
								GeeArrayList* _tmp90_;
								const gchar* _tmp91_;
								JsonObject* _tmp92_;
								const gchar* _tmp93_;
								JsonObject* _tmp94_;
								const gchar* _tmp95_;
								FeedReaderEnclosure* _tmp96_;
								FeedReaderEnclosure* _tmp97_;
								if (!_tmp85_) {
									gint _tmp86_;
									j = j + 1;
									_tmp86_ = j;
								}
								_tmp85_ = FALSE;
								if (!(((guint) j) < mediaCount)) {
									break;
								}
								_tmp87_ = attachments;
								_tmp88_ = json_array_get_object_element (_tmp87_, (guint) j);
								_tmp89_ = _json_object_ref0 (_tmp88_);
								attachment = _tmp89_;
								_tmp90_ = enclosures;
								_tmp91_ = id;
								_tmp92_ = attachment;
								_tmp93_ = json_object_get_string_member (_tmp92_, "href");
								_tmp94_ = attachment;
								_tmp95_ = json_object_get_string_member (_tmp94_, "type");
								_tmp96_ = feed_reader_enclosure_new (_tmp91_, _tmp93_, feed_reader_enclosure_type_from_string (_tmp95_));
								_tmp97_ = _tmp96_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp90_, _tmp97_);
								_g_object_unref0 (_tmp97_);
								_json_object_unref0 (attachment);
							}
						}
					}
					_json_array_unref0 (attachments);
				}
				if (read) {
					_tmp98_ = FEED_READER_ARTICLE_STATUS_READ;
				} else {
					_tmp98_ = FEED_READER_ARTICLE_STATUS_UNREAD;
				}
				if (marked) {
					_tmp99_ = FEED_READER_ARTICLE_STATUS_MARKED;
				} else {
					_tmp99_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
				}
				_tmp100_ = id;
				_tmp101_ = object;
				_tmp102_ = json_object_get_string_member (_tmp101_, "title");
				_tmp103_ = object;
				_tmp104_ = json_object_get_array_member (_tmp103_, "alternate");
				_tmp105_ = json_array_get_object_element (_tmp104_, (guint) 0);
				_tmp106_ = json_object_get_string_member (_tmp105_, "href");
				_tmp107_ = object;
				_tmp108_ = json_object_get_object_member (_tmp107_, "origin");
				_tmp109_ = json_object_get_string_member (_tmp108_, "streamId");
				_tmp110_ = object;
				_tmp111_ = json_object_get_object_member (_tmp110_, "summary");
				_tmp112_ = json_object_get_string_member (_tmp111_, "content");
				_tmp113_ = object;
				_tmp114_ = json_object_get_string_member (_tmp113_, "author");
				_tmp115_ = object;
				_tmp116_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp115_, "published"));
				_tmp117_ = _tmp116_;
				_tmp118_ = tags;
				_tmp119_ = enclosures;
				_tmp120_ = feed_reader_article_new (_tmp100_, _tmp102_, _tmp106_, _tmp109_, _tmp98_, _tmp99_, _tmp112_, NULL, _tmp114_, _tmp117_, -1, (GeeList*) _tmp118_, (GeeList*) _tmp119_, "", 0);
				_tmp121_ = _tmp120_;
				gee_collection_add ((GeeCollection*) articles, _tmp121_);
				_g_object_unref0 (_tmp121_);
				_g_date_time_unref0 (_tmp117_);
				_g_object_unref0 (enclosures);
				_json_array_unref0 (cats);
				_g_object_unref0 (tags);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp123_ = root;
	if (json_object_has_member (_tmp123_, "continuation")) {
		JsonObject* _tmp124_;
		const gchar* _tmp125_;
		_tmp124_ = root;
		_tmp125_ = json_object_get_string_member (_tmp124_, "continuation");
		_tmp122_ = g_strcmp0 (_tmp125_, "") != 0;
	} else {
		_tmp122_ = FALSE;
	}
	if (_tmp122_) {
		JsonObject* _tmp126_;
		const gchar* _tmp127_;
		gchar* _tmp128_;
		_tmp126_ = root;
		_tmp127_ = json_object_get_string_member (_tmp126_, "continuation");
		_tmp128_ = g_strdup (_tmp127_);
		result = _tmp128_;
		_g_object_unref0 (db);
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_g_free0 (message_string);
		return result;
	}
	result = NULL;
	_g_object_unref0 (db);
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_g_free0 (api_endpoint);
	_g_free0 (message_string);
	return result;
}

void
feed_reader_ino_reader_api_edidTag (FeedReaderInoReaderAPI* self,
                                    const gchar* articleIDs,
                                    const gchar* tagID,
                                    gboolean add)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** id_array = NULL;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint id_array_length1;
	gint _id_array_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	FeedReaderInoReaderConnection* _tmp16_;
	const gchar* _tmp17_;
	FeedReaderResponse _tmp18_ = {0};
	FeedReaderResponse _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleIDs != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = g_strdup ("");
	message_string = _tmp0_;
	if (add) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = message_string;
		_tmp2_ = g_strconcat (_tmp1_, "a=", NULL);
		_g_free0 (message_string);
		message_string = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = message_string;
		_tmp4_ = g_strconcat (_tmp3_, "r=", NULL);
		_g_free0 (message_string);
		message_string = _tmp4_;
	}
	_tmp5_ = message_string;
	_tmp6_ = g_strconcat (_tmp5_, tagID, NULL);
	_g_free0 (message_string);
	message_string = _tmp6_;
	_tmp8_ = _tmp7_ = g_strsplit (articleIDs, ",", 0);
	id_array = _tmp8_;
	id_array_length1 = _vala_array_length (_tmp7_);
	_id_array_size_ = id_array_length1;
	_tmp9_ = id_array;
	_tmp9__length1 = id_array_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp9_;
		id_collection_length1 = _tmp9__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			gchar* _tmp10_;
			gchar* id = NULL;
			_tmp10_ = g_strdup (id_collection[id_it]);
			id = _tmp10_;
			{
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = message_string;
				_tmp12_ = id;
				_tmp13_ = g_strconcat ("&i=", _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
				_g_free0 (message_string);
				message_string = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (id);
			}
		}
	}
	_tmp16_ = self->priv->m_connection;
	_tmp17_ = message_string;
	feed_reader_ino_reader_connection_send_request (_tmp16_, "edit-tag", _tmp17_, &_tmp18_);
	_tmp19_ = _tmp18_;
	feed_reader_response_destroy (&_tmp19_);
	id_array = (_vala_array_free (id_array, id_array_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (message_string);
}

void
feed_reader_ino_reader_api_markAsRead (FeedReaderInoReaderAPI* self,
                                       const gchar* streamID)
{
	GSettings* settingsState = NULL;
	GSettings* _tmp0_;
	gchar* message_string = NULL;
	gchar* _tmp1_;
	FeedReaderInoReaderConnection* _tmp2_;
	FeedReaderResponse _tmp3_ = {0};
	FeedReaderResponse _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.feedreader.saved-state");
	settingsState = _tmp0_;
	_tmp1_ = g_strdup_printf ("s=%s&ts=%i", streamID, g_settings_get_int (settingsState, "last-sync"));
	message_string = _tmp1_;
	feed_reader_logger_debug (message_string);
	_tmp2_ = self->priv->m_connection;
	feed_reader_ino_reader_connection_send_request (_tmp2_, "mark-all-as-read", message_string, &_tmp3_);
	_tmp4_ = _tmp3_;
	feed_reader_response_destroy (&_tmp4_);
	_g_free0 (message_string);
	_g_object_unref0 (settingsState);
}

gchar*
feed_reader_ino_reader_api_composeTagID (FeedReaderInoReaderAPI* self,
                                         const gchar* tagName)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagName != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strdup_printf ("user/%s/label/%s", _tmp0_, tagName);
	result = _tmp1_;
	return result;
}

void
feed_reader_ino_reader_api_deleteTag (FeedReaderInoReaderAPI* self,
                                      const gchar* tagID)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	FeedReaderInoReaderConnection* _tmp1_;
	FeedReaderResponse _tmp2_ = {0};
	FeedReaderResponse _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = g_strconcat ("s=", tagID, NULL);
	message_string = _tmp0_;
	_tmp1_ = self->priv->m_connection;
	feed_reader_ino_reader_connection_send_request (_tmp1_, "disable-tag", message_string, &_tmp2_);
	_tmp3_ = _tmp2_;
	feed_reader_response_destroy (&_tmp3_);
	_g_free0 (message_string);
}

void
feed_reader_ino_reader_api_renameTag (FeedReaderInoReaderAPI* self,
                                      const gchar* tagID,
                                      const gchar* title)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderInoReaderConnection* _tmp7_;
	const gchar* _tmp8_;
	FeedReaderResponse _tmp9_ = {0};
	FeedReaderResponse _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strconcat ("s=", tagID, NULL);
	message_string = _tmp0_;
	_tmp1_ = message_string;
	_tmp2_ = feed_reader_ino_reader_api_composeTagID (self, title);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("&dest=", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp1_, _tmp5_, NULL);
	_g_free0 (message_string);
	message_string = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp7_ = self->priv->m_connection;
	_tmp8_ = message_string;
	feed_reader_ino_reader_connection_send_request (_tmp7_, "rename-tag", _tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	feed_reader_response_destroy (&_tmp10_);
	_g_free0 (message_string);
}

gboolean
feed_reader_ino_reader_api_editSubscription (FeedReaderInoReaderAPI* self,
                                             FeedReaderInoReaderAPIInoSubscriptionAction action,
                                             gchar** feedID,
                                             gint feedID_length1,
                                             const gchar* title,
                                             const gchar* add,
                                             const gchar* remove)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	FeedReaderInoReaderConnection* _tmp27_;
	const gchar* _tmp28_;
	FeedReaderResponse _tmp29_ = {0};
	FeedReaderResponse _tmp30_;
	gboolean _tmp31_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("ac=");
	message_string = _tmp0_;
	switch (action) {
		case FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_EDIT:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = message_string;
			_tmp2_ = g_strconcat (_tmp1_, "edit", NULL);
			_g_free0 (message_string);
			message_string = _tmp2_;
			break;
		}
		case FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_SUBSCRIBE:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = message_string;
			_tmp4_ = g_strconcat (_tmp3_, "subscribe", NULL);
			_g_free0 (message_string);
			message_string = _tmp4_;
			break;
		}
		case FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_UNSUBSCRIBE:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = message_string;
			_tmp6_ = g_strconcat (_tmp5_, "unsubscribe", NULL);
			_g_free0 (message_string);
			message_string = _tmp6_;
			break;
		}
		default:
		break;
	}
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = feedID;
		s_collection_length1 = feedID_length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp7_;
			gchar* s = NULL;
			_tmp7_ = g_strdup (s_collection[s_it]);
			s = _tmp7_;
			{
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp8_ = message_string;
				_tmp9_ = s;
				_tmp10_ = g_uri_escape_string (_tmp9_, NULL, TRUE);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat ("&s=", _tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
				_g_free0 (message_string);
				message_string = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_g_free0 (s);
			}
		}
	}
	if (title != NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = message_string;
		_tmp16_ = g_strconcat ("&t=", title, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
		_g_free0 (message_string);
		message_string = _tmp18_;
		_g_free0 (_tmp17_);
	}
	if (add != NULL) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = message_string;
		_tmp20_ = g_strconcat ("&a=", add, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp19_, _tmp21_, NULL);
		_g_free0 (message_string);
		message_string = _tmp22_;
		_g_free0 (_tmp21_);
	}
	if (remove != NULL) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp23_ = message_string;
		_tmp24_ = g_strconcat ("&r=", remove, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
		_g_free0 (message_string);
		message_string = _tmp26_;
		_g_free0 (_tmp25_);
	}
	_tmp27_ = self->priv->m_connection;
	_tmp28_ = message_string;
	feed_reader_ino_reader_connection_send_request (_tmp27_, "subscription/edit", _tmp28_, &_tmp29_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_.status == ((guint) 200);
	feed_reader_response_destroy (&_tmp30_);
	result = _tmp31_;
	_g_free0 (message_string);
	return result;
}

static void
feed_reader_ino_reader_api_class_init (FeedReaderInoReaderAPIClass * klass,
                                       gpointer klass_data)
{
	feed_reader_ino_reader_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderInoReaderAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_ino_reader_api_finalize;
}

static void
feed_reader_ino_reader_api_instance_init (FeedReaderInoReaderAPI * self,
                                          gpointer klass)
{
	self->priv = feed_reader_ino_reader_api_get_instance_private (self);
}

static void
feed_reader_ino_reader_api_finalize (GObject * obj)
{
	FeedReaderInoReaderAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_INO_READER_API, FeedReaderInoReaderAPI);
	_feed_reader_ino_reader_connection_unref0 (self->priv->m_connection);
	_g_object_unref0 (self->priv->m_utils);
	_g_free0 (self->priv->m_userID);
	G_OBJECT_CLASS (feed_reader_ino_reader_api_parent_class)->finalize (obj);
}

GType
feed_reader_ino_reader_api_get_type (void)
{
	return feed_reader_ino_reader_api_type_id;
}

GType
feed_reader_ino_reader_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderInoReaderAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_ino_reader_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderInoReaderAPI), 0, (GInstanceInitFunc) feed_reader_ino_reader_api_instance_init, NULL };
	feed_reader_ino_reader_api_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderInoReaderAPI", &g_define_type_info, 0);
	FeedReaderInoReaderAPI_private_offset = sizeof (FeedReaderInoReaderAPIPrivate);
	return feed_reader_ino_reader_api_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

