/* InoReaderInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from InoReaderInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "inoreader.h"
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <libpeas/peas.h>

#define FEED_READER_INO_READER_SECRET_apiRedirectUri "http://localhost"
#define FEED_READER_INO_READER_SECRET_csrf_protection "123456"
#define FEED_READER_INO_READER_SECRET_apiClientId "1000001384"

enum  {
	FEED_READER_INO_READER_INTERFACE_0_PROPERTY,
	FEED_READER_INO_READER_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_ino_reader_interface_properties[FEED_READER_INO_READER_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderInoReaderInterfacePrivate {
	FeedReaderInoReaderAPI* m_api;
	FeedReaderInoReaderUtils* m_utils;
};

static gint FeedReaderInoReaderInterface_private_offset;
static gpointer feed_reader_ino_reader_interface_parent_class = NULL;
static GType feed_reader_ino_reader_interface_type_id = 0;

static void feed_reader_ino_reader_interface_real_init (FeedReaderFeedServerInterface* base,
                                                 GSettingsBackend* settings_backend,
                                                 SecretCollection* secrets);
static gchar* feed_reader_ino_reader_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_ino_reader_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ino_reader_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ino_reader_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ino_reader_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_extractCode (FeedReaderFeedServerInterface* base,
                                                            const gchar* redirectURL);
static gchar* feed_reader_ino_reader_interface_real_buildLoginURL (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ino_reader_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ino_reader_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ino_reader_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ino_reader_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                      const gchar* cadID);
static gboolean feed_reader_ino_reader_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_ino_reader_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_ino_reader_interface_real_login (FeedReaderFeedServerInterface* base);
static void feed_reader_ino_reader_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                             const gchar* articleIDs,
                                                             FeedReaderArticleStatus read);
static void feed_reader_ino_reader_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                               const gchar* articleID,
                                                               FeedReaderArticleStatus marked);
static gboolean feed_reader_ino_reader_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_ino_reader_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                        const gchar* feedID);
static void feed_reader_ino_reader_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                            const gchar* catID);
static void feed_reader_ino_reader_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_ino_reader_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                       const gchar* articleID,
                                                       const gchar* tagID);
static void feed_reader_ino_reader_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                             const gchar* articleID,
                                                             const gchar* tagID);
static gchar* feed_reader_ino_reader_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                        const gchar* caption);
static void feed_reader_ino_reader_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                      const gchar* tagID);
static void feed_reader_ino_reader_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                      const gchar* tagID,
                                                      const gchar* title);
static gboolean feed_reader_ino_reader_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ino_reader_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                        const gchar* feedURL,
                                                        const gchar* catID,
                                                        const gchar* newCatName,
                                                        gchar** feedID,
                                                        gchar** errmsg);
static void feed_reader_ino_reader_interface_real_addFeeds (FeedReaderFeedServerInterface* base,
                                                     GeeList* feeds);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void feed_reader_ino_reader_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                       const gchar* feedID);
static void feed_reader_ino_reader_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                       const gchar* feedID,
                                                       const gchar* title);
static void feed_reader_ino_reader_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                     const gchar* feedID,
                                                     const gchar* newCatID,
                                                     const gchar* currentCatID);
static gchar* feed_reader_ino_reader_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                             const gchar* title,
                                                             const gchar* parentID);
static void feed_reader_ino_reader_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                           const gchar* catID,
                                                           const gchar* title);
static void feed_reader_ino_reader_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                         const gchar* catID,
                                                         const gchar* newParentID);
static void feed_reader_ino_reader_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                           const gchar* catID);
static void feed_reader_ino_reader_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                              const gchar* feedID,
                                                              const gchar* catID);
static gboolean feed_reader_ino_reader_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                                GeeList* feeds,
                                                                GeeList* categories,
                                                                GeeList* tags,
                                                                GCancellable* cancellable);
static gint feed_reader_ino_reader_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_ino_reader_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                        gint count,
                                                        FeedReaderArticleStatus whatToGet,
                                                        GDateTime* since,
                                                        const gchar* feedID,
                                                        gboolean isTagID,
                                                        GCancellable* cancellable);
static void feed_reader_ino_reader_interface_finalize (GObject * obj);
GType feed_reader_ino_reader_api_register_type (GTypeModule * module);
GType feed_reader_ino_reader_utils_register_type (GTypeModule * module);
GType feed_reader_ino_reader_connection_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
feed_reader_ino_reader_interface_get_instance_private (FeedReaderInoReaderInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderInoReaderInterface_private_offset);
}

static void
feed_reader_ino_reader_interface_real_init (FeedReaderFeedServerInterface* base,
                                            GSettingsBackend* settings_backend,
                                            SecretCollection* secrets)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderUtils* _tmp0_;
	FeedReaderInoReaderUtils* _tmp1_;
	FeedReaderInoReaderAPI* _tmp2_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_ino_reader_utils_new (settings_backend);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_ino_reader_api_new (_tmp1_);
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp2_;
}

static gchar*
feed_reader_ino_reader_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("http://www.inoreader.com/");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_ino_reader_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderInoReaderInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_HOSTED | FEED_READER_BACKEND_FLAGS_PROPRIETARY) | FEED_READER_BACKEND_FLAGS_PAID_PREMIUM;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("inoreader");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("feed-service-inoreader");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("InoReader");
	result = _tmp0_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_extractCode (FeedReaderFeedServerInterface* base,
                                                   const gchar* redirectURL)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_val_if_fail (redirectURL != NULL, FALSE);
	if (g_str_has_prefix (redirectURL, FEED_READER_INO_READER_SECRET_apiRedirectUri)) {
		gint csrf_start = 0;
		gchar* csrf_code = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		feed_reader_logger_debug (redirectURL);
		csrf_start = string_index_of (redirectURL, "state=", 0) + 6;
		_tmp0_ = string_substring (redirectURL, (glong) csrf_start, (glong) -1);
		csrf_code = _tmp0_;
		_tmp1_ = csrf_code;
		_tmp2_ = g_strconcat ("InoReaderLoginWidget: csrf_code: ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		feed_reader_logger_debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = csrf_code;
		if (g_strcmp0 (_tmp4_, FEED_READER_INO_READER_SECRET_csrf_protection) == 0) {
			gint start = 0;
			gint end = 0;
			gchar* code = NULL;
			gchar* _tmp5_;
			FeedReaderInoReaderUtils* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			start = string_index_of (redirectURL, "code=", 0) + 5;
			end = string_index_of (redirectURL, "&", start);
			_tmp5_ = string_substring (redirectURL, (glong) start, (glong) (end - start));
			code = _tmp5_;
			_tmp6_ = self->priv->m_utils;
			_tmp7_ = code;
			feed_reader_ino_reader_utils_setApiCode (_tmp6_, _tmp7_);
			_tmp8_ = code;
			_tmp9_ = g_strconcat ("InoReaderLoginWidget: set inoreader-api-code: ", _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			feed_reader_logger_debug (_tmp10_);
			_g_free0 (_tmp10_);
			g_usleep ((gulong) 500000);
			result = TRUE;
			_g_free0 (code);
			_g_free0 (csrf_code);
			return result;
		}
		feed_reader_logger_error ("InoReaderLoginWidget: csrf_code mismatch");
		_g_free0 (csrf_code);
	} else {
		feed_reader_logger_warning ("InoReaderLoginWidget: wrong redirect_uri");
	}
	result = FALSE;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_buildLoginURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("https://www.inoreader.com/oauth2/auth" "?client_id=" FEED_READER_INO_READER_SECRET_apiClientId "&redirect_uri=" FEED_READER_INO_READER_SECRET_apiRedirectUri "&response_type=code" "&scope=read+write" "&state=" FEED_READER_INO_READER_SECRET_csrf_protection);
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("feed-service-inoreader-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_ino_reader_utils_getUser (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("http://www.inoreader.com/");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_ino_reader_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                             const gchar* cadID)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_val_if_fail (cadID != NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static void
feed_reader_ino_reader_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderUtils* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = self->priv->m_utils;
	feed_reader_ino_reader_utils_resetAccount (_tmp0_);
}

static gboolean
feed_reader_ino_reader_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = TRUE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_ino_reader_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	FeedReaderLoginResponse result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_ino_reader_api_login (_tmp0_);
	return result;
}

static void
feed_reader_ino_reader_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleIDs,
                                                        FeedReaderArticleStatus read)
{
	FeedReaderInoReaderInterface * self;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (articleIDs != NULL);
	if (read == FEED_READER_ARTICLE_STATUS_READ) {
		FeedReaderInoReaderAPI* _tmp0_;
		_tmp0_ = self->priv->m_api;
		feed_reader_ino_reader_api_edidTag (_tmp0_, articleIDs, "user/-/state/com.google/read", TRUE);
	} else {
		FeedReaderInoReaderAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feed_reader_ino_reader_api_edidTag (_tmp1_, articleIDs, "user/-/state/com.google/read", FALSE);
	}
}

static void
feed_reader_ino_reader_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                          const gchar* articleID,
                                                          FeedReaderArticleStatus marked)
{
	FeedReaderInoReaderInterface * self;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (articleID != NULL);
	if (marked == FEED_READER_ARTICLE_STATUS_MARKED) {
		FeedReaderInoReaderAPI* _tmp0_;
		_tmp0_ = self->priv->m_api;
		feed_reader_ino_reader_api_edidTag (_tmp0_, articleID, "user/-/state/com.google/starred", TRUE);
	} else {
		FeedReaderInoReaderAPI* _tmp1_;
		_tmp1_ = self->priv->m_api;
		feed_reader_ino_reader_api_edidTag (_tmp1_, articleID, "user/-/state/com.google/starred", FALSE);
	}
}

static gboolean
feed_reader_ino_reader_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_ino_reader_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_markAsRead (_tmp0_, feedID);
}

static void
feed_reader_ino_reader_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                       const gchar* catID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_markAsRead (_tmp0_, catID);
}

static void
feed_reader_ino_reader_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	GeeList* categories = NULL;
	FeedReaderDataBaseReadOnly* _tmp1_;
	GeeList* _tmp2_;
	GeeList* feeds = NULL;
	FeedReaderDataBaseReadOnly* _tmp15_;
	GeeList* _tmp16_;
	FeedReaderInoReaderAPI* _tmp29_;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = feed_reader_data_base_readOnly ();
	db = _tmp0_;
	_tmp1_ = db;
	_tmp2_ = feed_reader_data_base_read_only_read_categories (_tmp1_, NULL);
	categories = _tmp2_;
	{
		GeeList* _cat_list = NULL;
		GeeList* _tmp3_;
		gint _cat_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _cat_index = 0;
		_tmp3_ = categories;
		_cat_list = _tmp3_;
		_tmp4_ = _cat_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_cat_size = _tmp6_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			FeedReaderCategory* cat = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			FeedReaderInoReaderAPI* _tmp11_;
			FeedReaderCategory* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_cat_index = _cat_index + 1;
			_tmp7_ = _cat_index;
			_tmp8_ = _cat_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _cat_list;
			_tmp10_ = gee_list_get (_tmp9_, _cat_index);
			cat = (FeedReaderCategory*) _tmp10_;
			_tmp11_ = self->priv->m_api;
			_tmp12_ = cat;
			_tmp13_ = feed_reader_category_getCatID (_tmp12_);
			_tmp14_ = _tmp13_;
			feed_reader_ino_reader_api_markAsRead (_tmp11_, _tmp14_);
			_g_free0 (_tmp14_);
			_g_object_unref0 (cat);
		}
	}
	_tmp15_ = db;
	_tmp16_ = feed_reader_data_base_read_only_read_feeds_without_cat (_tmp15_);
	feeds = _tmp16_;
	{
		GeeList* _feed_list = NULL;
		GeeList* _tmp17_;
		gint _feed_size = 0;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _feed_index = 0;
		_tmp17_ = feeds;
		_feed_list = _tmp17_;
		_tmp18_ = _feed_list;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_feed_size = _tmp20_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			FeedReaderFeed* feed = NULL;
			GeeList* _tmp23_;
			gpointer _tmp24_;
			FeedReaderInoReaderAPI* _tmp25_;
			FeedReaderFeed* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_feed_index = _feed_index + 1;
			_tmp21_ = _feed_index;
			_tmp22_ = _feed_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _feed_list;
			_tmp24_ = gee_list_get (_tmp23_, _feed_index);
			feed = (FeedReaderFeed*) _tmp24_;
			_tmp25_ = self->priv->m_api;
			_tmp26_ = feed;
			_tmp27_ = feed_reader_feed_getFeedID (_tmp26_);
			_tmp28_ = _tmp27_;
			feed_reader_ino_reader_api_markAsRead (_tmp25_, _tmp28_);
			_g_free0 (_tmp28_);
			_g_object_unref0 (feed);
		}
	}
	_tmp29_ = self->priv->m_api;
	feed_reader_ino_reader_api_markAsRead (_tmp29_, NULL);
	_g_object_unref0 (feeds);
	_g_object_unref0 (categories);
	_g_object_unref0 (db);
}

static void
feed_reader_ino_reader_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                  const gchar* articleID,
                                                  const gchar* tagID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_edidTag (_tmp0_, articleID, tagID, TRUE);
}

static void
feed_reader_ino_reader_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleID,
                                                        const gchar* tagID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_edidTag (_tmp0_, articleID, tagID, FALSE);
}

static gchar*
feed_reader_ino_reader_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* caption)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = feed_reader_ino_reader_api_composeTagID (_tmp0_, caption);
	result = _tmp1_;
	return result;
}

static void
feed_reader_ino_reader_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_deleteTag (_tmp0_, tagID);
}

static void
feed_reader_ino_reader_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID,
                                                 const gchar* title)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_renameTag (_tmp0_, tagID, title);
}

static gboolean
feed_reader_ino_reader_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_ino_reader_api_ping (_tmp0_);
	return result;
}

static gboolean
feed_reader_ino_reader_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                               const gchar* feedURL,
                                               const gchar* catID,
                                               const gchar* newCatName,
                                               gchar** feedID,
                                               gchar** errmsg)
{
	FeedReaderInoReaderInterface * self;
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	gboolean success = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_val_if_fail (feedURL != NULL, FALSE);
	success = FALSE;
	_tmp0_ = g_strconcat ("feed/", feedURL, NULL);
	_g_free0 (_vala_feedID);
	_vala_feedID = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp1_;
	if (catID == NULL) {
		_tmp2_ = newCatName != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* newCatID = NULL;
		FeedReaderInoReaderAPI* _tmp3_;
		gchar* _tmp4_;
		FeedReaderInoReaderAPI* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp3_ = self->priv->m_api;
		_tmp4_ = feed_reader_ino_reader_api_composeTagID (_tmp3_, newCatName);
		newCatID = _tmp4_;
		_tmp5_ = self->priv->m_api;
		_tmp6_ = g_strconcat ("feed/", feedURL, NULL);
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		_tmp7_[0] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 1;
		_tmp9_ = newCatID;
		success = feed_reader_ino_reader_api_editSubscription (_tmp5_, FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_SUBSCRIBE, _tmp8_, (gint) 1, NULL, _tmp9_, NULL);
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (newCatID);
	} else {
		FeedReaderInoReaderAPI* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp10_ = self->priv->m_api;
		_tmp11_ = g_strconcat ("feed/", feedURL, NULL);
		_tmp12_ = g_new0 (gchar*, 1 + 1);
		_tmp12_[0] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 1;
		success = feed_reader_ino_reader_api_editSubscription (_tmp10_, FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_SUBSCRIBE, _tmp13_, (gint) 1, NULL, catID, NULL);
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	}
	if (!success) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("Inoreader could not add %s");
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp14_;
	}
	result = success;
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
feed_reader_ino_reader_interface_real_addFeeds (FeedReaderFeedServerInterface* base,
                                                GeeList* feeds)
{
	FeedReaderInoReaderInterface * self;
	gchar* cat = NULL;
	gchar* _tmp0_;
	gchar** urls = NULL;
	gchar** _tmp1_;
	gint urls_length1;
	gint _urls_size_;
	FeedReaderInoReaderAPI* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (feeds != NULL);
	_tmp0_ = g_strdup ("");
	cat = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	urls = _tmp1_;
	urls_length1 = 0;
	_urls_size_ = urls_length1;
	{
		GeeList* _f_list = NULL;
		gint _f_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _f_index = 0;
		_f_list = feeds;
		_tmp2_ = _f_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_f_size = _tmp4_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			FeedReaderFeed* f = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			FeedReaderFeed* _tmp9_;
			GeeList* _tmp10_;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gboolean _tmp15_;
			FeedReaderFeed* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_f_index = _f_index + 1;
			_tmp5_ = _f_index;
			_tmp6_ = _f_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _f_list;
			_tmp8_ = gee_list_get (_tmp7_, _f_index);
			f = (FeedReaderFeed*) _tmp8_;
			_tmp9_ = f;
			_tmp10_ = feed_reader_feed_getCatIDs (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_list_get (_tmp11_, 0);
			_tmp13_ = (gchar*) _tmp12_;
			_tmp14_ = cat;
			_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
			_g_free0 (_tmp13_);
			_g_object_unref0 (_tmp11_);
			if (_tmp15_) {
				FeedReaderInoReaderAPI* _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar** _tmp19_;
				FeedReaderFeed* _tmp20_;
				GeeList* _tmp21_;
				GeeList* _tmp22_;
				gpointer _tmp23_;
				_tmp16_ = self->priv->m_api;
				_tmp17_ = urls;
				_tmp17__length1 = urls_length1;
				_tmp18_ = cat;
				feed_reader_ino_reader_api_editSubscription (_tmp16_, FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_SUBSCRIBE, _tmp17_, (gint) _tmp17__length1, NULL, _tmp18_, NULL);
				_tmp19_ = g_new0 (gchar*, 0 + 1);
				urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
				urls = _tmp19_;
				urls_length1 = 0;
				_urls_size_ = urls_length1;
				_tmp20_ = f;
				_tmp21_ = feed_reader_feed_getCatIDs (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = gee_list_get (_tmp22_, 0);
				_g_free0 (cat);
				cat = (gchar*) _tmp23_;
				_g_object_unref0 (_tmp22_);
			}
			_tmp24_ = f;
			_tmp25_ = feed_reader_feed_getXmlUrl (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat ("feed/", _tmp26_, NULL);
			_vala_array_add1 (&urls, &urls_length1, &_urls_size_, _tmp27_);
			_g_free0 (_tmp26_);
			_g_object_unref0 (f);
		}
	}
	_tmp28_ = self->priv->m_api;
	_tmp29_ = urls;
	_tmp29__length1 = urls_length1;
	_tmp30_ = cat;
	feed_reader_ino_reader_api_editSubscription (_tmp28_, FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_SUBSCRIBE, _tmp29_, (gint) _tmp29__length1, NULL, _tmp30_, NULL);
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cat);
}

static void
feed_reader_ino_reader_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_ino_reader_api_editSubscription (_tmp0_, FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_UNSUBSCRIBE, _tmp3_, (gint) 1, NULL, NULL, NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
feed_reader_ino_reader_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID,
                                                  const gchar* title)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_ino_reader_api_editSubscription (_tmp0_, FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_EDIT, _tmp3_, (gint) 1, title, NULL, NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
feed_reader_ino_reader_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                const gchar* feedID,
                                                const gchar* newCatID,
                                                const gchar* currentCatID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup (feedID);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	feed_reader_ino_reader_api_editSubscription (_tmp0_, FEED_READER_INO_READER_API_INO_SUBSCRIPTION_ACTION_EDIT, _tmp3_, (gint) 1, NULL, newCatID, currentCatID);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
feed_reader_ino_reader_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* title,
                                                      const gchar* parentID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = feed_reader_ino_reader_api_composeTagID (_tmp0_, title);
	result = _tmp1_;
	return result;
}

static void
feed_reader_ino_reader_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID,
                                                      const gchar* title)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_renameTag (_tmp0_, catID, title);
}

static void
feed_reader_ino_reader_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                    const gchar* catID,
                                                    const gchar* newParentID)
{
	FeedReaderInoReaderInterface * self;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	return;
}

static void
feed_reader_ino_reader_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ino_reader_api_deleteTag (_tmp0_, catID);
}

static void
feed_reader_ino_reader_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                         const gchar* feedID,
                                                         const gchar* catID)
{
	FeedReaderInoReaderInterface * self;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	return;
}

static gboolean
feed_reader_ino_reader_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                       GeeList* feeds,
                                                       GeeList* categories,
                                                       GeeList* tags,
                                                       GCancellable* cancellable)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderInoReaderInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_api;
	if (feed_reader_ino_reader_api_getFeeds (_tmp0_, feeds)) {
		gboolean _tmp1_ = FALSE;
		FeedReaderInoReaderAPI* _tmp2_;
		if (cancellable != NULL) {
			_tmp1_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = self->priv->m_api;
		if (feed_reader_ino_reader_api_getCategoriesAndTags (_tmp2_, feeds, categories, tags)) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gint
feed_reader_ino_reader_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderInoReaderInterface * self;
	FeedReaderInoReaderAPI* _tmp0_;
	gint result;
	self = (FeedReaderInoReaderInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_ino_reader_api_getTotalUnread (_tmp0_);
	return result;
}

static void
feed_reader_ino_reader_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                   gint count,
                                                   FeedReaderArticleStatus whatToGet,
                                                   GDateTime* since,
                                                   const gchar* feedID,
                                                   gboolean isTagID,
                                                   GCancellable* cancellable)
{
	FeedReaderInoReaderInterface * self;
	GeeLinkedList* articles = NULL;
	GeeLinkedList* _tmp14_;
	gchar* continuation = NULL;
	gint left = 0;
	const gchar* _tmp15_ = NULL;
	gchar* inoreader_feedID = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* inoreader_tagID = NULL;
	gchar* _tmp18_;
	GeeLinkedList* _tmp32_;
	self = (FeedReaderInoReaderInterface*) base;
	if (whatToGet == FEED_READER_ARTICLE_STATUS_READ) {
		return;
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_ALL) {
			GeeLinkedList* unreadIDs = NULL;
			GeeLinkedList* _tmp0_;
			gchar* continuation = NULL;
			gint left = 0;
			FeedReaderDataBase* _tmp11_;
			FeedReaderDataBase* _tmp12_;
			GeeLinkedList* _tmp13_;
			_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
			unreadIDs = _tmp0_;
			continuation = NULL;
			left = 4 * count;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				if (!(left > 0)) {
					break;
				}
				if (cancellable != NULL) {
					_tmp1_ = g_cancellable_is_cancelled (cancellable);
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					_g_free0 (continuation);
					_g_object_unref0 (unreadIDs);
					return;
				}
				if (left > 1000) {
					FeedReaderInoReaderAPI* _tmp2_;
					GeeLinkedList* _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp2_ = self->priv->m_api;
					_tmp3_ = unreadIDs;
					_tmp4_ = continuation;
					_tmp5_ = feed_reader_ino_reader_api_updateArticles (_tmp2_, (GeeList*) _tmp3_, 1000, _tmp4_);
					_g_free0 (continuation);
					continuation = _tmp5_;
					left -= 1000;
				} else {
					FeedReaderInoReaderAPI* _tmp6_;
					GeeLinkedList* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp6_ = self->priv->m_api;
					_tmp7_ = unreadIDs;
					_tmp8_ = continuation;
					_tmp9_ = feed_reader_ino_reader_api_updateArticles (_tmp6_, (GeeList*) _tmp7_, left, _tmp8_);
					_tmp10_ = _tmp9_;
					_g_free0 (_tmp10_);
					left = 0;
				}
			}
			_tmp11_ = feed_reader_data_base_writeAccess ();
			_tmp12_ = _tmp11_;
			_tmp13_ = unreadIDs;
			feed_reader_data_base_updateArticlesByID (_tmp12_, (GeeList*) _tmp13_, "unread");
			_g_object_unref0 (_tmp12_);
			g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "update-article-list");
			_g_free0 (continuation);
			_g_object_unref0 (unreadIDs);
		}
	}
	_tmp14_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp14_;
	continuation = NULL;
	left = count;
	if (isTagID) {
		_tmp15_ = NULL;
	} else {
		_tmp15_ = feedID;
	}
	_tmp16_ = g_strdup (_tmp15_);
	inoreader_feedID = _tmp16_;
	if (isTagID) {
		_tmp17_ = feedID;
	} else {
		_tmp17_ = NULL;
	}
	_tmp18_ = g_strdup (_tmp17_);
	inoreader_tagID = _tmp18_;
	while (TRUE) {
		gboolean _tmp19_ = FALSE;
		if (!(left > 0)) {
			break;
		}
		if (cancellable != NULL) {
			_tmp19_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_g_free0 (inoreader_tagID);
			_g_free0 (inoreader_feedID);
			_g_free0 (continuation);
			_g_object_unref0 (articles);
			return;
		}
		if (left > 1000) {
			FeedReaderInoReaderAPI* _tmp20_;
			GeeLinkedList* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp20_ = self->priv->m_api;
			_tmp21_ = articles;
			_tmp22_ = continuation;
			_tmp23_ = inoreader_tagID;
			_tmp24_ = inoreader_feedID;
			_tmp25_ = feed_reader_ino_reader_api_getArticles (_tmp20_, (GeeList*) _tmp21_, 1000, whatToGet, _tmp22_, _tmp23_, _tmp24_);
			_g_free0 (continuation);
			continuation = _tmp25_;
			left -= 1000;
		} else {
			FeedReaderInoReaderAPI* _tmp26_;
			GeeLinkedList* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp26_ = self->priv->m_api;
			_tmp27_ = articles;
			_tmp28_ = continuation;
			_tmp29_ = inoreader_tagID;
			_tmp30_ = inoreader_feedID;
			_tmp31_ = feed_reader_ino_reader_api_getArticles (_tmp26_, (GeeList*) _tmp27_, left, whatToGet, _tmp28_, _tmp29_, _tmp30_);
			_g_free0 (continuation);
			continuation = _tmp31_;
			left = 0;
		}
	}
	_tmp32_ = articles;
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "write-articles", (GeeList*) _tmp32_);
	_g_free0 (inoreader_tagID);
	_g_free0 (inoreader_feedID);
	_g_free0 (continuation);
	_g_object_unref0 (articles);
}

FeedReaderInoReaderInterface*
feed_reader_ino_reader_interface_construct (GType object_type)
{
	FeedReaderInoReaderInterface * self = NULL;
	self = (FeedReaderInoReaderInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderInoReaderInterface*
feed_reader_ino_reader_interface_new (void)
{
	return feed_reader_ino_reader_interface_construct (FEED_READER_TYPE_INO_READER_INTERFACE);
}

static void
feed_reader_ino_reader_interface_class_init (FeedReaderInoReaderInterfaceClass * klass,
                                             gpointer klass_data)
{
	feed_reader_ino_reader_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderInoReaderInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_ino_reader_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->extractCode = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_extractCode;
	((FeedReaderFeedServerInterfaceClass *) klass)->buildLoginURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_buildLoginURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_ino_reader_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_ino_reader_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_ino_reader_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeeds = (void (*) (FeedReaderFeedServerInterface*, GeeList*)) feed_reader_ino_reader_interface_real_addFeeds;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ino_reader_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ino_reader_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_ino_reader_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_ino_reader_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_ino_reader_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_ino_reader_interface_finalize;
}

static void
feed_reader_ino_reader_interface_instance_init (FeedReaderInoReaderInterface * self,
                                                gpointer klass)
{
	self->priv = feed_reader_ino_reader_interface_get_instance_private (self);
}

static void
feed_reader_ino_reader_interface_finalize (GObject * obj)
{
	FeedReaderInoReaderInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_INO_READER_INTERFACE, FeedReaderInoReaderInterface);
	_g_object_unref0 (self->priv->m_api);
	_g_object_unref0 (self->priv->m_utils);
	G_OBJECT_CLASS (feed_reader_ino_reader_interface_parent_class)->finalize (obj);
}

GType
feed_reader_ino_reader_interface_get_type (void)
{
	return feed_reader_ino_reader_interface_type_id;
}

GType
feed_reader_ino_reader_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderInoReaderInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_ino_reader_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderInoReaderInterface), 0, (GInstanceInitFunc) feed_reader_ino_reader_interface_instance_init, NULL };
	feed_reader_ino_reader_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderInoReaderInterface", &g_define_type_info, 0);
	FeedReaderInoReaderInterface_private_offset = sizeof (FeedReaderInoReaderInterfacePrivate);
	return feed_reader_ino_reader_interface_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_ino_reader_api_register_type (module);
	feed_reader_ino_reader_interface_register_type (module);
	feed_reader_ino_reader_utils_register_type (module);
	feed_reader_ino_reader_connection_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_INO_READER_INTERFACE);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

