/* localInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from localInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "local.h"
#include <libsoup/soup.h>
#include <gtk/gtk.h>
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>
#include "rss-glib.h"
#include <libpeas/peas.h>

enum  {
	FEED_READER_LOCAL_INTERFACE_0_PROPERTY,
	FEED_READER_LOCAL_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_local_interface_properties[FEED_READER_LOCAL_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _feed_reader_local_interface_postLoginActionData feed_reader_local_interface_postLoginActionData;
typedef struct _Block3Data Block3Data;
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))

struct _FeedReaderlocalInterfacePrivate {
	FeedReaderlocalUtils* m_utils;
	SoupSession* m_session;
	GtkListBox* m_feedlist;
};

struct _Block1Data {
	int _ref_count_;
	FeedReaderlocalInterface* self;
	GtkSpinner* waitingSpinner;
	GtkStack* loginStack;
	GtkButton* loginButton;
};

struct _Block2Data {
	int _ref_count_;
	FeedReaderlocalInterface* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _feed_reader_local_interface_postLoginActionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FeedReaderlocalInterface* self;
	Block2Data* _data2_;
	GThread* _tmp0_;
	GThread* _tmp1_;
};

struct _Block3Data {
	int _ref_count_;
	FeedReaderlocalInterface* self;
	GeeArrayList* articles;
	GMutex mutex;
	GCancellable* cancellable;
};

static gint FeedReaderlocalInterface_private_offset;
static gpointer feed_reader_local_interface_parent_class = NULL;
static GType feed_reader_local_interface_type_id = 0;

static void feed_reader_local_interface_real_init (FeedReaderFeedServerInterface* base,
                                            GSettingsBackend* settings_backend,
                                            SecretCollection* secrets);
static gchar* feed_reader_local_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_local_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_local_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_local_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_local_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static GtkBox* feed_reader_local_interface_real_getWidget (FeedReaderFeedServerInterface* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static gint feed_reader_local_interface_sortFunc (FeedReaderlocalInterface* self,
                                           GtkListBoxRow* row1,
                                           GtkListBoxRow* row2);
static gint _feed_reader_local_interface_sortFunc_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                   GtkListBoxRow* row2,
                                                                   gpointer self);
static void feed_reader_local_interface_headerFunc (FeedReaderlocalInterface* self,
                                             GtkListBoxRow* row,
                                             GtkListBoxRow* before);
static void _feed_reader_local_interface_headerFunc_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                              GtkListBoxRow* before,
                                                                              gpointer self);
static void feed_reader_local_interface_real_postLoginAction_data_free (gpointer _data);
static void feed_reader_local_interface_real_postLoginAction (FeedReaderFeedServerInterface* base,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean feed_reader_local_interface_real_postLoginAction_co (feed_reader_local_interface_postLoginActionData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _feed_reader_local_interface_real_postLoginAction_co_gsource_func (gpointer self);
static void* __lambda6_ (Block2Data* _data2_);
static gpointer ___lambda6__gthread_func (gpointer self);
static gboolean feed_reader_local_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_local_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_local_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_local_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_local_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                 const gchar* catID);
static gboolean feed_reader_local_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_local_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_local_interface_real_login (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_local_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static void feed_reader_local_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleIDs,
                                                        FeedReaderArticleStatus read);
static void feed_reader_local_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                          const gchar* articleID,
                                                          FeedReaderArticleStatus marked);
static gboolean feed_reader_local_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_local_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedID);
static void feed_reader_local_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                       const gchar* catID);
static void feed_reader_local_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_local_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                  const gchar* articleID,
                                                  const gchar* tagID);
static void feed_reader_local_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleID,
                                                        const gchar* tagID);
static gchar* feed_reader_local_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* caption);
static void feed_reader_local_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID);
static void feed_reader_local_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID,
                                                 const gchar* title);
static gboolean feed_reader_local_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedURL,
                                                   const gchar* catID,
                                                   const gchar* newCatName,
                                                   gchar** feedID,
                                                   gchar** errmsg);
static void feed_reader_local_interface_real_addFeeds (FeedReaderFeedServerInterface* base,
                                                GeeList* feeds);
static void feed_reader_local_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID);
static void feed_reader_local_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID,
                                                  const gchar* title);
static void feed_reader_local_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                const gchar* feedID,
                                                const gchar* newCatID,
                                                const gchar* currentCatID);
static gchar* feed_reader_local_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                        const gchar* title,
                                                        const gchar* parentID);
static void feed_reader_local_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID,
                                                      const gchar* title);
static void feed_reader_local_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                    const gchar* catID,
                                                    const gchar* newParentID);
static void feed_reader_local_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID);
static void feed_reader_local_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                         const gchar* feedID,
                                                         const gchar* catID);
static gboolean feed_reader_local_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                           GeeList* feeds,
                                                           GeeList* categories,
                                                           GeeList* tags,
                                                           GCancellable* cancellable);
static gint feed_reader_local_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_local_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                   gint count,
                                                   FeedReaderArticleStatus whatToGet,
                                                   GDateTime* since,
                                                   const gchar* feedID,
                                                   gboolean isTagID,
                                                   GCancellable* cancellable);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda7_ (Block3Data* _data3_,
                  FeedReaderFeed* feed);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static void ____lambda7__gfunc (gpointer data,
                         gpointer self);
static gint __lambda8_ (FeedReaderlocalInterface* self,
                 FeedReaderArticle* a,
                 FeedReaderArticle* b);
static gint ___lambda8__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void feed_reader_local_interface_finalize (GObject * obj);
GType feed_reader_local_utils_register_type (GTypeModule * module);
GType feed_reader_suggested_feed_row_register_type (GTypeModule * module);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
feed_reader_local_interface_get_instance_private (FeedReaderlocalInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderlocalInterface_private_offset);
}

static void
feed_reader_local_interface_real_init (FeedReaderFeedServerInterface* base,
                                       GSettingsBackend* settings_backend,
                                       SecretCollection* secrets)
{
	FeedReaderlocalInterface * self;
	FeedReaderlocalUtils* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_local_utils_new ();
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp1_;
	_tmp2_ = self->priv->m_session;
	g_object_set (_tmp2_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp3_ = self->priv->m_session;
	g_object_set (_tmp3_, "timeout", (guint) 5, NULL);
}

static gchar*
feed_reader_local_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("http://jangernert.github.io/FeedReader/");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_local_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderlocalInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_LOCAL | FEED_READER_BACKEND_FLAGS_FREE_SOFTWARE) | FEED_READER_BACKEND_FLAGS_FREE;
	return result;
}

static gchar*
feed_reader_local_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("local");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_local_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("feed-service-local");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_local_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("Local RSS");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_local_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = FALSE;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FeedReaderlocalInterface* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->loginButton);
		_g_object_unref0 (_data1_->loginStack);
		_g_object_unref0 (_data1_->waitingSpinner);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_)
{
	FeedReaderlocalInterface* self;
	GtkButton* _tmp0_;
	GtkSpinner* _tmp1_;
	GtkButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStack* _tmp4_;
	self = _data1_->self;
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
	_tmp0_ = _data1_->loginButton;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = _data1_->waitingSpinner;
	gtk_spinner_start (_tmp1_);
	_tmp2_ = _data1_->loginButton;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp4_ = _data1_->loginStack;
	gtk_stack_set_visible_child_name (_tmp4_, "waiting");
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ (self);
}

static gint
_feed_reader_local_interface_sortFunc_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                              GtkListBoxRow* row2,
                                                              gpointer self)
{
	gint result;
	result = feed_reader_local_interface_sortFunc ((FeedReaderlocalInterface*) self, row1, row2);
	return result;
}

static void
_feed_reader_local_interface_headerFunc_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                         GtkListBoxRow* before,
                                                                         gpointer self)
{
	feed_reader_local_interface_headerFunc ((FeedReaderlocalInterface*) self, row, before);
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static GtkBox*
feed_reader_local_interface_real_getWidget (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	Block1Data* _data1_;
	GtkLabel* doneLabel = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* waitingLabel = NULL;
	GtkLabel* _tmp1_;
	GtkSpinner* _tmp2_;
	GtkBox* waitingBox = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkSpinner* _tmp5_;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GtkLabel* _tmp10_;
	GtkStack* _tmp11_;
	GtkBox* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkStack* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkLabel* headlineLabel = NULL;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* loginLabel = NULL;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkListBox* _tmp31_;
	GtkListBox* _tmp32_;
	GtkListBox* _tmp33_;
	GtkListBox* _tmp34_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp69_;
	GtkStyleContext* _tmp70_;
	GtkListBox* _tmp71_;
	GtkBox* box = NULL;
	GtkBox* _tmp72_;
	GtkLabel* _tmp73_;
	GtkLabel* _tmp74_;
	GtkButton* _tmp75_;
	GError* _inner_error0_ = NULL;
	GtkBox* result;
	self = (FeedReaderlocalInterface*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Done"));
	g_object_ref_sink (_tmp0_);
	doneLabel = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Adding Feeds"));
	g_object_ref_sink (_tmp1_);
	waitingLabel = _tmp1_;
	_tmp2_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp2_);
	_data1_->waitingSpinner = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp3_);
	waitingBox = _tmp3_;
	_tmp4_ = waitingBox;
	_tmp5_ = _data1_->waitingSpinner;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = waitingBox;
	_tmp7_ = waitingLabel;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, TRUE, FALSE, (guint) 0);
	_tmp8_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp8_);
	_data1_->loginStack = _tmp8_;
	_tmp9_ = _data1_->loginStack;
	_tmp10_ = doneLabel;
	gtk_stack_add_named (_tmp9_, (GtkWidget*) _tmp10_, "label");
	_tmp11_ = _data1_->loginStack;
	_tmp12_ = waitingBox;
	gtk_stack_add_named (_tmp11_, (GtkWidget*) _tmp12_, "waiting");
	_tmp13_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp13_);
	_data1_->loginButton = _tmp13_;
	_tmp14_ = _data1_->loginButton;
	_tmp15_ = _data1_->loginStack;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = _data1_->loginButton;
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_END);
	_tmp17_ = _data1_->loginButton;
	gtk_widget_set_size_request ((GtkWidget*) _tmp17_, 80, 30);
	_tmp18_ = _data1_->loginButton;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp20_ = _data1_->loginButton;
	g_signal_connect_data (_tmp20_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp21_ = _data1_->loginButton;
	gtk_widget_show_all ((GtkWidget*) _tmp21_);
	_tmp22_ = (GtkLabel*) gtk_label_new ("Recommended Feeds:");
	g_object_ref_sink (_tmp22_);
	headlineLabel = _tmp22_;
	_tmp23_ = headlineLabel;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, "h1");
	_tmp25_ = headlineLabel;
	gtk_label_set_justify (_tmp25_, GTK_JUSTIFY_CENTER);
	_tmp26_ = (GtkLabel*) gtk_label_new ("Fill your library with feeds. Here are some recommendations.");
	g_object_ref_sink (_tmp26_);
	loginLabel = _tmp26_;
	_tmp27_ = loginLabel;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "h2");
	_tmp29_ = loginLabel;
	gtk_label_set_justify (_tmp29_, GTK_JUSTIFY_CENTER);
	_tmp30_ = loginLabel;
	gtk_label_set_lines (_tmp30_, 3);
	_tmp31_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->m_feedlist);
	self->priv->m_feedlist = _tmp31_;
	_tmp32_ = self->priv->m_feedlist;
	gtk_list_box_set_selection_mode (_tmp32_, GTK_SELECTION_NONE);
	_tmp33_ = self->priv->m_feedlist;
	gtk_list_box_set_sort_func (_tmp33_, _feed_reader_local_interface_sortFunc_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp34_ = self->priv->m_feedlist;
	gtk_list_box_set_header_func (_tmp34_, _feed_reader_local_interface_headerFunc_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		GFile* file = NULL;
		GFile* _tmp35_;
		GFile* _tmp36_;
		guint8* _tmp37_ = NULL;
		gsize _tmp38_ = 0;
		JsonParser* parser = NULL;
		JsonParser* _tmp39_;
		JsonParser* _tmp40_;
		guint8* _tmp41_;
		gint _tmp41__length1;
		JsonArray* array = NULL;
		JsonParser* _tmp42_;
		JsonNode* _tmp43_;
		JsonArray* _tmp44_;
		JsonArray* _tmp45_;
		_tmp35_ = g_file_new_for_uri ("resource:///org/gnome/FeedReader/recommendedFeeds.json");
		file = _tmp35_;
		_tmp36_ = file;
		g_file_load_contents (_tmp36_, NULL, &_tmp37_, &_tmp38_, NULL, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp37_;
		contents_length1 = _tmp38_;
		_contents_size_ = contents_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			contents = (g_free (contents), NULL);
			goto __catch0_g_error;
		}
		_tmp39_ = json_parser_new ();
		parser = _tmp39_;
		_tmp40_ = parser;
		_tmp41_ = contents;
		_tmp41__length1 = contents_length1;
		json_parser_load_from_data (_tmp40_, (const gchar*) _tmp41_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			_g_object_unref0 (file);
			contents = (g_free (contents), NULL);
			goto __catch0_g_error;
		}
		_tmp42_ = parser;
		_tmp43_ = json_parser_get_root (_tmp42_);
		_tmp44_ = json_node_get_array (_tmp43_);
		_tmp45_ = _json_array_ref0 (_tmp44_);
		array = _tmp45_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp46_ = FALSE;
				_tmp46_ = TRUE;
				while (TRUE) {
					JsonArray* _tmp48_;
					JsonObject* object = NULL;
					JsonArray* _tmp49_;
					JsonObject* _tmp50_;
					JsonObject* _tmp51_;
					GtkListBox* _tmp52_;
					JsonObject* _tmp53_;
					const gchar* _tmp54_;
					JsonObject* _tmp55_;
					const gchar* _tmp56_;
					JsonObject* _tmp57_;
					const gchar* _tmp58_;
					JsonObject* _tmp59_;
					const gchar* _tmp60_;
					JsonObject* _tmp61_;
					const gchar* _tmp62_;
					JsonObject* _tmp63_;
					const gchar* _tmp64_;
					FeedReaderSuggestedFeedRow* _tmp65_;
					FeedReaderSuggestedFeedRow* _tmp66_;
					if (!_tmp46_) {
						gint _tmp47_;
						_tmp47_ = i;
						i = _tmp47_ + 1;
					}
					_tmp46_ = FALSE;
					_tmp48_ = array;
					if (!(((guint) i) < json_array_get_length (_tmp48_))) {
						break;
					}
					_tmp49_ = array;
					_tmp50_ = json_array_get_object_element (_tmp49_, (guint) i);
					_tmp51_ = _json_object_ref0 (_tmp50_);
					object = _tmp51_;
					_tmp52_ = self->priv->m_feedlist;
					_tmp53_ = object;
					_tmp54_ = json_object_get_string_member (_tmp53_, "url");
					_tmp55_ = object;
					_tmp56_ = json_object_get_string_member (_tmp55_, "icon");
					_tmp57_ = object;
					_tmp58_ = json_object_get_string_member (_tmp57_, "category");
					_tmp59_ = object;
					_tmp60_ = json_object_get_string_member (_tmp59_, "name");
					_tmp61_ = object;
					_tmp62_ = json_object_get_string_member (_tmp61_, "description");
					_tmp63_ = object;
					_tmp64_ = json_object_get_string_member (_tmp63_, "language");
					_tmp65_ = feed_reader_suggested_feed_row_new (_tmp54_, _tmp56_, _tmp58_, _tmp60_, _tmp62_, _tmp64_);
					g_object_ref_sink (_tmp65_);
					_tmp66_ = _tmp65_;
					gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp66_);
					_g_object_unref0 (_tmp66_);
					_json_object_unref0 (object);
				}
			}
		}
		_json_array_unref0 (array);
		_g_object_unref0 (parser);
		_g_object_unref0 (file);
		contents = (g_free (contents), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp67_;
		const gchar* _tmp68_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("localLoginWidget: loading json filed");
		_tmp67_ = e;
		_tmp68_ = _tmp67_->message;
		feed_reader_logger_error (_tmp68_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (loginLabel);
		_g_object_unref0 (headlineLabel);
		_g_object_unref0 (waitingBox);
		_g_object_unref0 (waitingLabel);
		_g_object_unref0 (doneLabel);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp69_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp69_);
	scroll = _tmp69_;
	gtk_widget_set_size_request ((GtkWidget*) scroll, 450, 0);
	gtk_widget_set_halign ((GtkWidget*) scroll, GTK_ALIGN_CENTER);
	_tmp70_ = gtk_widget_get_style_context ((GtkWidget*) scroll);
	gtk_style_context_add_class (_tmp70_, GTK_STYLE_CLASS_FRAME);
	_tmp71_ = self->priv->m_feedlist;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp71_);
	_tmp72_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp72_);
	box = _tmp72_;
	g_object_set ((GtkWidget*) box, "margin", 50, NULL);
	gtk_widget_set_valign ((GtkWidget*) box, GTK_ALIGN_FILL);
	gtk_widget_set_halign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	_tmp73_ = headlineLabel;
	gtk_box_pack_start (box, (GtkWidget*) _tmp73_, FALSE, FALSE, (guint) 0);
	_tmp74_ = loginLabel;
	gtk_box_pack_start (box, (GtkWidget*) _tmp74_, FALSE, FALSE, (guint) 2);
	gtk_box_pack_start (box, (GtkWidget*) scroll, TRUE, TRUE, (guint) 20);
	_tmp75_ = _data1_->loginButton;
	gtk_box_pack_end (box, (GtkWidget*) _tmp75_, FALSE, FALSE, (guint) 0);
	result = box;
	_g_object_unref0 (scroll);
	_g_object_unref0 (loginLabel);
	_g_object_unref0 (headlineLabel);
	_g_object_unref0 (waitingBox);
	_g_object_unref0 (waitingLabel);
	_g_object_unref0 (doneLabel);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
feed_reader_local_interface_real_postLoginAction_data_free (gpointer _data)
{
	feed_reader_local_interface_postLoginActionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (feed_reader_local_interface_postLoginActionData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
feed_reader_local_interface_real_postLoginAction (FeedReaderFeedServerInterface* base,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FeedReaderlocalInterface * self;
	feed_reader_local_interface_postLoginActionData* _data_;
	FeedReaderlocalInterface* _tmp0_;
	self = (FeedReaderlocalInterface*) base;
	_data_ = g_slice_new0 (feed_reader_local_interface_postLoginActionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, feed_reader_local_interface_real_postLoginAction_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	feed_reader_local_interface_real_postLoginAction_co (_data_);
}

static void
feed_reader_local_interface_postLoginAction_finish (FeedReaderFeedServerInterface* base,
                                                    GAsyncResult* _res_)
{
	feed_reader_local_interface_postLoginActionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FeedReaderlocalInterface* self;
		self = _data2_->self;
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_feed_reader_local_interface_real_postLoginAction_co_gsource_func (gpointer self)
{
	gboolean result;
	result = feed_reader_local_interface_real_postLoginAction_co (self);
	return result;
}

static void*
__lambda6_ (Block2Data* _data2_)
{
	FeedReaderlocalInterface* self;
	GList* children = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GSourceFunc _tmp14_;
	gpointer _tmp14__target;
	GDestroyNotify _tmp14__target_destroy_notify;
	void* result;
	self = _data2_->self;
	_tmp0_ = self->priv->m_feedlist;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	children = _tmp1_;
	_tmp2_ = children;
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp2_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			GtkWidget* r = NULL;
			r = (GtkWidget*) r_it->data;
			{
				FeedReaderSuggestedFeedRow* row = NULL;
				GtkWidget* _tmp3_;
				FeedReaderSuggestedFeedRow* _tmp4_;
				FeedReaderSuggestedFeedRow* _tmp5_;
				_tmp3_ = r;
				_tmp4_ = _g_object_ref0 (FEED_READER_IS_SUGGESTED_FEED_ROW (_tmp3_) ? ((FeedReaderSuggestedFeedRow*) _tmp3_) : NULL);
				row = _tmp4_;
				_tmp5_ = row;
				if (feed_reader_suggested_feed_row_checked (_tmp5_)) {
					FeedReaderFeedReaderBackend* _tmp6_;
					FeedReaderFeedReaderBackend* _tmp7_;
					FeedReaderSuggestedFeedRow* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					FeedReaderSuggestedFeedRow* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp6_ = feed_reader_feed_reader_backend_get_default ();
					_tmp7_ = _tmp6_;
					_tmp8_ = row;
					_tmp9_ = feed_reader_suggested_feed_row_getURL (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = row;
					_tmp12_ = feed_reader_suggested_feed_row_getCategory (_tmp11_);
					_tmp13_ = _tmp12_;
					feed_reader_feed_reader_backend_addFeed (_tmp7_, _tmp10_, _tmp13_, FALSE);
					_g_free0 (_tmp13_);
					_g_free0 (_tmp10_);
					_g_object_unref0 (_tmp7_);
				}
				_g_object_unref0 (row);
			}
		}
	}
	_tmp14_ = _data2_->callback;
	_tmp14__target = _data2_->callback_target;
	_tmp14__target_destroy_notify = _data2_->callback_target_destroy_notify;
	_data2_->callback = NULL;
	_data2_->callback_target = NULL;
	_data2_->callback_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp14_, _tmp14__target, _tmp14__target_destroy_notify);
	result = NULL;
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

static gpointer
___lambda6__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda6_ (self);
	block2_data_unref (self);
	return result;
}

static gboolean
feed_reader_local_interface_real_postLoginAction_co (feed_reader_local_interface_postLoginActionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_data2_->callback = _feed_reader_local_interface_real_postLoginAction_co_gsource_func;
	_data_->_data2_->callback_target = _data_;
	_data_->_data2_->callback_target_destroy_notify = NULL;
	_data_->_tmp0_ = g_thread_new (NULL, ___lambda6__gthread_func, block2_data_ref (_data_->_data2_));
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_thread_unref0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
feed_reader_local_interface_sortFunc (FeedReaderlocalInterface* self,
                                      GtkListBoxRow* row1,
                                      GtkListBoxRow* row2)
{
	FeedReaderSuggestedFeedRow* r1 = NULL;
	FeedReaderSuggestedFeedRow* _tmp0_;
	FeedReaderSuggestedFeedRow* r2 = NULL;
	FeedReaderSuggestedFeedRow* _tmp1_;
	gchar* cat1 = NULL;
	FeedReaderSuggestedFeedRow* _tmp2_;
	gchar* _tmp3_;
	gchar* cat2 = NULL;
	FeedReaderSuggestedFeedRow* _tmp4_;
	gchar* _tmp5_;
	gchar* name1 = NULL;
	FeedReaderSuggestedFeedRow* _tmp6_;
	gchar* _tmp7_;
	gchar* name2 = NULL;
	FeedReaderSuggestedFeedRow* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (FEED_READER_IS_SUGGESTED_FEED_ROW (row1) ? ((FeedReaderSuggestedFeedRow*) row1) : NULL);
	r1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (FEED_READER_IS_SUGGESTED_FEED_ROW (row2) ? ((FeedReaderSuggestedFeedRow*) row2) : NULL);
	r2 = _tmp1_;
	_tmp2_ = r1;
	_tmp3_ = feed_reader_suggested_feed_row_getCategory (_tmp2_);
	cat1 = _tmp3_;
	_tmp4_ = r2;
	_tmp5_ = feed_reader_suggested_feed_row_getCategory (_tmp4_);
	cat2 = _tmp5_;
	_tmp6_ = r1;
	_tmp7_ = feed_reader_suggested_feed_row_getName (_tmp6_);
	name1 = _tmp7_;
	_tmp8_ = r2;
	_tmp9_ = feed_reader_suggested_feed_row_getName (_tmp8_);
	name2 = _tmp9_;
	_tmp10_ = cat1;
	_tmp11_ = cat2;
	if (g_strcmp0 (_tmp10_, _tmp11_) != 0) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = cat1;
		_tmp13_ = cat2;
		result = g_utf8_collate (_tmp12_, _tmp13_);
		_g_free0 (name2);
		_g_free0 (name1);
		_g_free0 (cat2);
		_g_free0 (cat1);
		_g_object_unref0 (r2);
		_g_object_unref0 (r1);
		return result;
	}
	_tmp14_ = name1;
	_tmp15_ = name2;
	result = g_utf8_collate (_tmp14_, _tmp15_);
	_g_free0 (name2);
	_g_free0 (name1);
	_g_free0 (cat2);
	_g_free0 (cat1);
	_g_object_unref0 (r2);
	_g_object_unref0 (r1);
	return result;
}

static void
feed_reader_local_interface_headerFunc (FeedReaderlocalInterface* self,
                                        GtkListBoxRow* row,
                                        GtkListBoxRow* before)
{
	FeedReaderSuggestedFeedRow* r1 = NULL;
	FeedReaderSuggestedFeedRow* _tmp0_;
	gchar* cat1 = NULL;
	FeedReaderSuggestedFeedRow* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* label = NULL;
	const gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* box = NULL;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* _tmp12_;
	GtkSeparator* _tmp13_;
	GtkSeparator* _tmp14_;
	GtkBox* _tmp15_;
	FeedReaderSuggestedFeedRow* r2 = NULL;
	FeedReaderSuggestedFeedRow* _tmp17_;
	gchar* cat2 = NULL;
	FeedReaderSuggestedFeedRow* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (FEED_READER_IS_SUGGESTED_FEED_ROW (row) ? ((FeedReaderSuggestedFeedRow*) row) : NULL);
	r1 = _tmp0_;
	_tmp1_ = r1;
	_tmp2_ = feed_reader_suggested_feed_row_getCategory (_tmp1_);
	cat1 = _tmp2_;
	_tmp3_ = cat1;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	label = _tmp4_;
	_tmp5_ = label;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "bold");
	_tmp7_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp7_, 20);
	_tmp8_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp8_, 5);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp9_);
	box = _tmp9_;
	_tmp10_ = box;
	_tmp11_ = label;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	_tmp12_ = box;
	_tmp13_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	gtk_box_pack_end (_tmp12_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = box;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	if (before == NULL) {
		GtkBox* _tmp16_;
		_tmp16_ = box;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp16_);
		_g_object_unref0 (box);
		_g_object_unref0 (label);
		_g_free0 (cat1);
		_g_object_unref0 (r1);
		return;
	}
	_tmp17_ = _g_object_ref0 (FEED_READER_IS_SUGGESTED_FEED_ROW (before) ? ((FeedReaderSuggestedFeedRow*) before) : NULL);
	r2 = _tmp17_;
	_tmp18_ = r2;
	_tmp19_ = feed_reader_suggested_feed_row_getCategory (_tmp18_);
	cat2 = _tmp19_;
	_tmp20_ = cat1;
	_tmp21_ = cat2;
	if (g_strcmp0 (_tmp20_, _tmp21_) != 0) {
		GtkBox* _tmp22_;
		_tmp22_ = box;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp22_);
	}
	_g_free0 (cat2);
	_g_object_unref0 (r2);
	_g_object_unref0 (box);
	_g_object_unref0 (label);
	_g_free0 (cat1);
	_g_object_unref0 (r1);
}

static gboolean
feed_reader_local_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_local_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = FALSE;
	return result;
}

static gchar*
feed_reader_local_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("feed-service-local-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_local_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("Local RSS");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_local_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("http://localhost/");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_local_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	_tmp0_ = g_strdup ("0");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_local_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                        const gchar* catID)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	g_return_val_if_fail (catID != NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
feed_reader_local_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_local_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_local_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_local_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_local_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_local_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_local_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	return;
}

static gboolean
feed_reader_local_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = TRUE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_local_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	FeedReaderLoginResponse result;
	self = (FeedReaderlocalInterface*) base;
	result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
	return result;
}

static gboolean
feed_reader_local_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = feed_reader_utils_ping ("https://duckduckgo.com/");
	return result;
}

static void
feed_reader_local_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* articleIDs,
                                                   FeedReaderArticleStatus read)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (articleIDs != NULL);
	return;
}

static void
feed_reader_local_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                     const gchar* articleID,
                                                     FeedReaderArticleStatus marked)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (articleID != NULL);
	return;
}

static gboolean
feed_reader_local_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_local_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                              const gchar* feedID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (feedID != NULL);
	return;
}

static void
feed_reader_local_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                  const gchar* catID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (catID != NULL);
	return;
}

static void
feed_reader_local_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	return;
}

static void
feed_reader_local_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                             const gchar* articleID,
                                             const gchar* tagID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static void
feed_reader_local_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* articleID,
                                                   const gchar* tagID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static gchar*
feed_reader_local_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                            const gchar* caption)
{
	FeedReaderlocalInterface * self;
	gchar* tagID = NULL;
	gchar* _tmp0_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp1_;
	FeedReaderDataBaseReadOnly* _tmp2_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = g_strdup ("1");
	tagID = _tmp0_;
	_tmp1_ = feed_reader_data_base_readOnly ();
	db = _tmp1_;
	_tmp2_ = db;
	if (!feed_reader_data_base_read_only_isTableEmpty (_tmp2_, "tags")) {
		FeedReaderDataBaseReadOnly* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = db;
		_tmp4_ = feed_reader_data_base_read_only_getMaxID (_tmp3_, "tags", "tagID");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%i", atoi (_tmp5_) + 1);
		_g_free0 (tagID);
		tagID = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = tagID;
	_tmp8_ = g_strconcat ("createTag: ID = ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	feed_reader_logger_info (_tmp9_);
	_g_free0 (_tmp9_);
	result = tagID;
	_g_object_unref0 (db);
	return result;
}

static void
feed_reader_local_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                            const gchar* tagID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (tagID != NULL);
	return;
}

static void
feed_reader_local_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                            const gchar* tagID,
                                            const gchar* title)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	return;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
feed_reader_local_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                          const gchar* feedURL,
                                          const gchar* catID,
                                          const gchar* newCatName,
                                          gchar** feedID,
                                          gchar** errmsg)
{
	FeedReaderlocalInterface * self;
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	GeeArrayList* catIDs = NULL;
	GeeArrayList* _tmp0_;
	FeedReaderDataBase* db = NULL;
	FeedReaderDataBase* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	FeedReaderFeed* feed = NULL;
	FeedReaderlocalUtils* _tmp23_;
	SoupSession* _tmp24_;
	const gchar* _tmp25_;
	GeeArrayList* _tmp26_;
	gchar* _tmp27_ = NULL;
	FeedReaderFeed* _tmp28_;
	FeedReaderFeed* _tmp29_;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	g_return_val_if_fail (feedURL != NULL, FALSE);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	catIDs = _tmp0_;
	_tmp1_ = feed_reader_data_base_writeAccess ();
	db = _tmp1_;
	if (catID == NULL) {
		_tmp2_ = newCatName != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* cID = NULL;
		gchar* _tmp3_;
		FeedReaderCategory* cat = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		FeedReaderCategory* _tmp7_;
		FeedReaderCategory* _tmp8_;
		FeedReaderDataBase* _tmp9_;
		FeedReaderCategory* _tmp10_;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		GeeArrayList* _tmp13_;
		const gchar* _tmp14_;
		_tmp3_ = feed_reader_feed_server_interface_createCategory ((FeedReaderFeedServerInterface*) self, newCatName, NULL);
		cID = _tmp3_;
		_tmp4_ = cID;
		_tmp5_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
		_tmp6_ = _tmp5_;
		_tmp7_ = feed_reader_category_new (_tmp4_, newCatName, (guint) 0, 99, _tmp6_, 1);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		cat = _tmp8_;
		_tmp9_ = db;
		_tmp10_ = cat;
		_tmp11_ = feed_reader_list_utils_single (FEED_READER_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp10_);
		_tmp12_ = _tmp11_;
		feed_reader_data_base_write_categories (_tmp9_, _tmp12_);
		_g_object_unref0 (_tmp12_);
		_tmp13_ = catIDs;
		_tmp14_ = cID;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
		_g_object_unref0 (cat);
		_g_free0 (cID);
	} else {
		gboolean _tmp15_ = FALSE;
		if (catID != NULL) {
			_tmp15_ = newCatName == NULL;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GeeArrayList* _tmp16_;
			_tmp16_ = catIDs;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, catID);
		} else {
			GeeArrayList* _tmp17_;
			_tmp17_ = catIDs;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, "0");
		}
	}
	_tmp18_ = g_uuid_string_random ();
	_g_free0 (_vala_feedID);
	_vala_feedID = _tmp18_;
	_tmp19_ = _vala_feedID;
	_tmp20_ = string_to_string (_tmp19_);
	_tmp21_ = g_strconcat ("addFeed: ID = ", _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	feed_reader_logger_info (_tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->m_utils;
	_tmp24_ = self->priv->m_session;
	_tmp25_ = _vala_feedID;
	_tmp26_ = catIDs;
	_tmp28_ = feed_reader_local_utils_downloadFeed (_tmp23_, _tmp24_, feedURL, _tmp25_, (GeeList*) _tmp26_, &_tmp27_);
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp27_;
	feed = _tmp28_;
	_tmp29_ = feed;
	if (_tmp29_ != NULL) {
		FeedReaderDataBase* _tmp30_;
		FeedReaderFeed* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gboolean _tmp34_;
		gchar* _tmp39_;
		_tmp30_ = db;
		_tmp31_ = feed;
		_tmp32_ = feed_reader_feed_getXmlUrl (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = !feed_reader_data_base_read_only_feed_exists ((FeedReaderDataBaseReadOnly*) _tmp30_, _tmp33_);
		_g_free0 (_tmp33_);
		if (_tmp34_) {
			FeedReaderDataBase* _tmp35_;
			FeedReaderFeed* _tmp36_;
			GeeList* _tmp37_;
			GeeList* _tmp38_;
			_tmp35_ = db;
			_tmp36_ = feed;
			_tmp37_ = feed_reader_list_utils_single (FEED_READER_TYPE_FEED, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp36_);
			_tmp38_ = _tmp37_;
			feed_reader_data_base_write_feeds (_tmp35_, (GeeCollection*) _tmp38_);
			_g_object_unref0 (_tmp38_);
			result = TRUE;
			_g_object_unref0 (feed);
			_g_object_unref0 (db);
			_g_object_unref0 (catIDs);
			if (feedID) {
				*feedID = _vala_feedID;
			} else {
				_g_free0 (_vala_feedID);
			}
			if (errmsg) {
				*errmsg = _vala_errmsg;
			} else {
				_g_free0 (_vala_errmsg);
			}
			return result;
		}
		_tmp39_ = g_strconcat (_ ("Can't add feed because it already exists: "), feedURL, NULL);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp39_;
	}
	result = FALSE;
	_g_object_unref0 (feed);
	_g_object_unref0 (db);
	_g_object_unref0 (catIDs);
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
feed_reader_local_interface_real_addFeeds (FeedReaderFeedServerInterface* base,
                                           GeeList* feeds)
{
	FeedReaderlocalInterface * self;
	GeeArrayList* finishedFeeds = NULL;
	GeeArrayList* _tmp0_;
	FeedReaderDataBase* _tmp57_;
	FeedReaderDataBase* _tmp58_;
	GeeArrayList* _tmp59_;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (feeds != NULL);
	_tmp0_ = gee_array_list_new (FEED_READER_TYPE_FEED, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	finishedFeeds = _tmp0_;
	{
		GeeList* _f_list = NULL;
		gint _f_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _f_index = 0;
		_f_list = feeds;
		_tmp1_ = _f_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_f_size = _tmp3_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FeedReaderFeed* f = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gchar* feedID = NULL;
			gchar* _tmp8_;
			gchar* url = NULL;
			FeedReaderFeed* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* errmsg = NULL;
			gchar* _tmp17_;
			FeedReaderFeed* feed = NULL;
			FeedReaderlocalUtils* _tmp18_;
			SoupSession* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			FeedReaderFeed* _tmp22_;
			GeeList* _tmp23_;
			GeeList* _tmp24_;
			gchar* _tmp25_ = NULL;
			FeedReaderFeed* _tmp26_;
			FeedReaderFeed* _tmp27_;
			FeedReaderFeed* _tmp28_;
			_f_index = _f_index + 1;
			_tmp4_ = _f_index;
			_tmp5_ = _f_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _f_list;
			_tmp7_ = gee_list_get (_tmp6_, _f_index);
			f = (FeedReaderFeed*) _tmp7_;
			_tmp8_ = g_uuid_string_random ();
			feedID = _tmp8_;
			_tmp9_ = f;
			_tmp10_ = feed_reader_feed_getXmlUrl (_tmp9_);
			url = _tmp10_;
			_tmp11_ = url;
			_tmp12_ = string_to_string (_tmp11_);
			_tmp13_ = feedID;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("addFeed: url = ", _tmp12_, ", ID = ", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			feed_reader_logger_info (_tmp16_);
			_g_free0 (_tmp16_);
			_tmp17_ = g_strdup ("");
			errmsg = _tmp17_;
			_tmp18_ = self->priv->m_utils;
			_tmp19_ = self->priv->m_session;
			_tmp20_ = url;
			_tmp21_ = feedID;
			_tmp22_ = f;
			_tmp23_ = feed_reader_feed_getCatIDs (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp26_ = feed_reader_local_utils_downloadFeed (_tmp18_, _tmp19_, _tmp20_, _tmp21_, _tmp24_, &_tmp25_);
			_g_free0 (errmsg);
			errmsg = _tmp25_;
			_tmp27_ = _tmp26_;
			_g_object_unref0 (_tmp24_);
			feed = _tmp27_;
			_tmp28_ = feed;
			if (_tmp28_ != NULL) {
				FeedReaderFeed* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gboolean _tmp32_;
				GeeArrayList* _tmp37_;
				FeedReaderFeed* _tmp38_;
				_tmp29_ = feed;
				_tmp30_ = feed_reader_feed_getTitle (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strcmp0 (_tmp31_, "No Title") != 0;
				_g_free0 (_tmp31_);
				if (_tmp32_) {
					FeedReaderFeed* _tmp33_;
					FeedReaderFeed* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp33_ = feed;
					_tmp34_ = f;
					_tmp35_ = feed_reader_feed_getTitle (_tmp34_);
					_tmp36_ = _tmp35_;
					feed_reader_feed_setTitle (_tmp33_, _tmp36_);
					_g_free0 (_tmp36_);
				}
				_tmp37_ = finishedFeeds;
				_tmp38_ = feed;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
			} else {
				FeedReaderFeed* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp39_ = f;
				_tmp40_ = feed_reader_feed_getXmlUrl (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strconcat ("Couldn't add Feed: ", _tmp41_, NULL);
				_tmp43_ = _tmp42_;
				feed_reader_logger_error (_tmp43_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
			}
			_g_object_unref0 (feed);
			_g_free0 (errmsg);
			_g_free0 (url);
			_g_free0 (feedID);
			_g_object_unref0 (f);
		}
	}
	{
		GeeArrayList* _feed_list = NULL;
		GeeArrayList* _tmp44_;
		gint _feed_size = 0;
		GeeArrayList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _feed_index = 0;
		_tmp44_ = finishedFeeds;
		_feed_list = _tmp44_;
		_tmp45_ = _feed_list;
		_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_feed_size = _tmp47_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			FeedReaderFeed* feed = NULL;
			GeeArrayList* _tmp50_;
			gpointer _tmp51_;
			FeedReaderFeed* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_feed_index = _feed_index + 1;
			_tmp48_ = _feed_index;
			_tmp49_ = _feed_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _feed_list;
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _feed_index);
			feed = (FeedReaderFeed*) _tmp51_;
			_tmp52_ = feed;
			_tmp53_ = feed_reader_feed_getTitle (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strconcat ("finishedFeed: ", _tmp54_, NULL);
			_tmp56_ = _tmp55_;
			feed_reader_logger_debug (_tmp56_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp54_);
			_g_object_unref0 (feed);
		}
	}
	_tmp57_ = feed_reader_data_base_writeAccess ();
	_tmp58_ = _tmp57_;
	_tmp59_ = finishedFeeds;
	feed_reader_data_base_write_feeds (_tmp58_, (GeeCollection*) _tmp59_);
	_g_object_unref0 (_tmp58_);
	_g_object_unref0 (finishedFeeds);
}

static void
feed_reader_local_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feedID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (feedID != NULL);
	return;
}

static void
feed_reader_local_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feedID,
                                             const gchar* title)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	return;
}

static void
feed_reader_local_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                           const gchar* feedID,
                                           const gchar* newCatID,
                                           const gchar* currentCatID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	return;
}

static gchar*
feed_reader_local_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* title,
                                                 const gchar* parentID)
{
	FeedReaderlocalInterface * self;
	gchar* catID = NULL;
	gchar* id = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	self = (FeedReaderlocalInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_getCategoryID (_tmp1_, title);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	id = _tmp3_;
	_tmp4_ = id;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_uuid_string_random ();
		_g_free0 (catID);
		catID = _tmp5_;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = id;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (catID);
		catID = _tmp7_;
	}
	_tmp8_ = string_to_string (title);
	_tmp9_ = catID;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("createCategory: title= ", _tmp8_, " ID = ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	feed_reader_logger_info (_tmp12_);
	_g_free0 (_tmp12_);
	result = catID;
	_g_free0 (id);
	return result;
}

static void
feed_reader_local_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* catID,
                                                 const gchar* title)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	return;
}

static void
feed_reader_local_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                               const gchar* catID,
                                               const gchar* newParentID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	return;
}

static void
feed_reader_local_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* catID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (catID != NULL);
	return;
}

static void
feed_reader_local_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feedID,
                                                    const gchar* catID)
{
	FeedReaderlocalInterface * self;
	self = (FeedReaderlocalInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	return;
}

static gboolean
feed_reader_local_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                  GeeList* feeds,
                                                  GeeList* categories,
                                                  GeeList* tags,
                                                  GCancellable* cancellable)
{
	FeedReaderlocalInterface * self;
	gboolean result;
	self = (FeedReaderlocalInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	result = TRUE;
	return result;
}

static gint
feed_reader_local_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderlocalInterface * self;
	gint result;
	self = (FeedReaderlocalInterface*) base;
	result = 0;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FeedReaderlocalInterface* self;
		self = _data3_->self;
		_vala_clear_GMutex (&_data3_->mutex);
		_g_object_unref0 (_data3_->articles);
		_g_object_unref0 (_data3_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
___lambda7_ (Block3Data* _data3_,
             FeedReaderFeed* feed)
{
	FeedReaderlocalInterface* self;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* url = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	SoupMessage* msg = NULL;
	const gchar* _tmp16_;
	SoupMessage* _tmp17_;
	SoupSession* session = NULL;
	SoupSession* _tmp18_;
	SoupSession* _tmp19_;
	SoupSession* _tmp20_;
	SoupSession* _tmp21_;
	SoupMessage* _tmp22_;
	gchar* xml = NULL;
	SoupMessage* _tmp23_;
	SoupMessageBody* _tmp24_;
	SoupBuffer* _tmp25_;
	SoupBuffer* _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar* _tmp29_;
	RssParser* parser = NULL;
	RssParser* _tmp30_;
	RssDocument* doc = NULL;
	RssParser* _tmp40_;
	RssDocument* _tmp41_;
	gchar* locale = NULL;
	gboolean _tmp42_ = FALSE;
	RssDocument* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	RssDocument* _tmp55_;
	GList* _tmp56_;
	GList* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GeeArrayList* newArticles = NULL;
	GeeArrayList* _tmp60_;
	RssDocument* _tmp61_;
	GList* _tmp62_;
	GeeArrayList* _tmp179_;
	GeeArrayList* _tmp180_;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (feed != NULL);
	if (_data3_->cancellable != NULL) {
		_tmp0_ = g_cancellable_is_cancelled (_data3_->cancellable);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_g_object_unref0 (feed);
		return;
	}
	_tmp1_ = feed_reader_feed_getTitle (feed);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("getArticles for feed: ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	feed_reader_logger_debug (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = feed_reader_feed_getXmlUrl (feed);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strescape (_tmp6_, "");
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	url = _tmp8_;
	_tmp11_ = url;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = url;
		_tmp10_ = g_strcmp0 (_tmp12_, "") == 0;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = url;
		_tmp14_ = g_uri_parse_scheme (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = _tmp15_ == NULL;
		_g_free0 (_tmp15_);
	}
	if (_tmp9_) {
		feed_reader_logger_error ("no valid URL");
		_g_free0 (url);
		_g_object_unref0 (feed);
		return;
	}
	_tmp16_ = url;
	_tmp17_ = soup_message_new ("GET", _tmp16_);
	msg = _tmp17_;
	_tmp18_ = soup_session_new ();
	session = _tmp18_;
	_tmp19_ = session;
	g_object_set (_tmp19_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp20_ = session;
	g_object_set (_tmp20_, "timeout", (guint) 5, NULL);
	_tmp21_ = session;
	_tmp22_ = msg;
	soup_session_send_message (_tmp21_, _tmp22_);
	_tmp23_ = msg;
	_tmp24_ = _tmp23_->response_body;
	_tmp25_ = soup_message_body_flatten (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_->data;
	_tmp27__length1 = _tmp26_->length;
	_tmp28_ = g_strdup ((const gchar*) _tmp27_);
	_tmp29_ = _tmp28_;
	__vala_SoupBuffer_free0 (_tmp26_);
	xml = _tmp29_;
	_tmp30_ = rss_parser_new ();
	parser = _tmp30_;
	{
		RssParser* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp31_ = parser;
		_tmp32_ = xml;
		_tmp33_ = xml;
		_tmp34_ = strlen (_tmp33_);
		_tmp35_ = _tmp34_;
		rss_parser_load_from_data (_tmp31_, _tmp32_, (gulong) _tmp35_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		_tmp38_ = g_strdup_printf ("localInterface.getArticles: %s", _tmp37_);
		_tmp39_ = _tmp38_;
		feed_reader_logger_error (_tmp39_);
		_g_free0 (_tmp39_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		_g_free0 (xml);
		_g_object_unref0 (session);
		_g_object_unref0 (msg);
		_g_free0 (url);
		_g_object_unref0 (feed);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (xml);
		_g_object_unref0 (session);
		_g_object_unref0 (msg);
		_g_free0 (url);
		_g_object_unref0 (feed);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp40_ = parser;
	_tmp41_ = rss_parser_get_document (_tmp40_);
	doc = _tmp41_;
	locale = NULL;
	_tmp43_ = doc;
	g_object_get (_tmp43_, "encoding", &_tmp44_, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_ != NULL;
	_g_free0 (_tmp46_);
	if (_tmp47_) {
		RssDocument* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp48_ = doc;
		g_object_get (_tmp48_, "encoding", &_tmp49_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_;
		_tmp42_ = g_strcmp0 (_tmp51_, "") != 0;
		_g_free0 (_tmp51_);
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		RssDocument* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp52_ = doc;
		g_object_get (_tmp52_, "encoding", &_tmp53_, NULL);
		_tmp54_ = _tmp53_;
		_g_free0 (locale);
		locale = _tmp54_;
	}
	_tmp55_ = doc;
	_tmp56_ = rss_document_get_items (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strdup_printf ("Got %u articles", g_list_length (_tmp57_));
	_tmp59_ = _tmp58_;
	feed_reader_logger_debug (_tmp59_);
	_g_free0 (_tmp59_);
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (g_list_free (_tmp57_), NULL));
	_tmp60_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	newArticles = _tmp60_;
	_tmp61_ = doc;
	_tmp62_ = rss_document_get_items (_tmp61_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp62_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			RssItem* _tmp63_;
			RssItem* item = NULL;
			_tmp63_ = _g_object_ref0 ((RssItem*) item_it->data);
			item = _tmp63_;
			{
				gchar* articleID = NULL;
				RssItem* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				const gchar* _tmp67_;
				GDateTime* date = NULL;
				RssItem* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				GDateTime* _tmp80_;
				GDateTime* _tmp81_;
				GDateTime* _tmp82_;
				gchar* content = NULL;
				FeedReaderlocalUtils* _tmp107_;
				RssItem* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				const gchar* _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				const gchar* _tmp115_;
				GeeArrayList* enclosures = NULL;
				GeeArrayList* _tmp117_;
				RssItem* _tmp118_;
				gchar* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_;
				gboolean _tmp122_;
				gchar* articleURL = NULL;
				RssItem* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				const gchar* _tmp134_;
				gchar* _tmp141_ = NULL;
				RssItem* _tmp142_;
				gchar* _tmp143_;
				gchar* _tmp144_;
				gchar* _tmp145_;
				gboolean _tmp146_;
				FeedReaderArticle* article = NULL;
				const gchar* _tmp154_;
				const gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				const gchar* _tmp158_;
				const gchar* _tmp159_;
				FeedReaderlocalUtils* _tmp160_;
				RssItem* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				const gchar* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				GDateTime* _tmp168_;
				GeeArrayList* _tmp169_;
				FeedReaderArticle* _tmp170_;
				FeedReaderArticle* _tmp171_;
				FeedReaderArticle* _tmp172_;
				gchar* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				GeeArrayList* _tmp177_;
				FeedReaderArticle* _tmp178_;
				_tmp64_ = item;
				g_object_get (_tmp64_, "guid", &_tmp65_, NULL);
				_tmp66_ = _tmp65_;
				articleID = _tmp66_;
				_tmp67_ = articleID;
				if (_tmp67_ == NULL) {
					RssItem* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gboolean _tmp72_;
					RssItem* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					_tmp68_ = item;
					g_object_get (_tmp68_, "link", &_tmp69_, NULL);
					_tmp70_ = _tmp69_;
					_tmp71_ = _tmp70_;
					_tmp72_ = _tmp71_ == NULL;
					_g_free0 (_tmp71_);
					if (_tmp72_) {
						feed_reader_logger_warning ("no valid id and no valid URL as well? what the hell man? I'm giving up");
						_g_free0 (articleID);
						_g_object_unref0 (item);
						continue;
					}
					_tmp73_ = item;
					g_object_get (_tmp73_, "link", &_tmp74_, NULL);
					_tmp75_ = _tmp74_;
					_g_free0 (articleID);
					articleID = _tmp75_;
				}
				_tmp76_ = item;
				g_object_get (_tmp76_, "pub-date", &_tmp77_, NULL);
				_tmp78_ = _tmp77_;
				_tmp79_ = _tmp78_;
				_tmp80_ = feed_reader_rfc822_parseDate (_tmp79_);
				_tmp81_ = _tmp80_;
				_g_free0 (_tmp79_);
				date = _tmp81_;
				_tmp82_ = date;
				if (_tmp82_ != NULL) {
					RssItem* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					const gchar* _tmp87_;
					GDateTime* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					const gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					_tmp83_ = item;
					g_object_get (_tmp83_, "pub-date", &_tmp84_, NULL);
					_tmp85_ = _tmp84_;
					_tmp86_ = _tmp85_;
					_tmp87_ = string_to_string (_tmp86_);
					_tmp88_ = date;
					_tmp89_ = g_date_time_to_string (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = string_to_string (_tmp90_);
					_tmp92_ = g_strconcat ("Parsed ", _tmp87_, " as ", _tmp91_, NULL);
					_tmp93_ = _tmp92_;
					feed_reader_logger_info (_tmp93_);
					_g_free0 (_tmp93_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp86_);
				} else {
					RssItem* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					gboolean _tmp98_;
					GDateTime* _tmp106_;
					_tmp94_ = item;
					g_object_get (_tmp94_, "pub-date", &_tmp95_, NULL);
					_tmp96_ = _tmp95_;
					_tmp97_ = _tmp96_;
					_tmp98_ = _tmp97_ != NULL;
					_g_free0 (_tmp97_);
					if (_tmp98_) {
						RssItem* _tmp99_;
						gchar* _tmp100_;
						gchar* _tmp101_;
						gchar* _tmp102_;
						const gchar* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						_tmp99_ = item;
						g_object_get (_tmp99_, "pub-date", &_tmp100_, NULL);
						_tmp101_ = _tmp100_;
						_tmp102_ = _tmp101_;
						_tmp103_ = string_to_string (_tmp102_);
						_tmp104_ = g_strconcat ("RFC 822 date parser failed to parse ", _tmp103_, ". Falling back to DateTime.now()", NULL);
						_tmp105_ = _tmp104_;
						feed_reader_logger_warning (_tmp105_);
						_g_free0 (_tmp105_);
						_g_free0 (_tmp102_);
					}
					_tmp106_ = g_date_time_new_now_local ();
					_g_date_time_unref0 (date);
					date = _tmp106_;
				}
				_tmp107_ = self->priv->m_utils;
				_tmp108_ = item;
				g_object_get (_tmp108_, "description", &_tmp109_, NULL);
				_tmp110_ = _tmp109_;
				_tmp111_ = _tmp110_;
				_tmp112_ = locale;
				_tmp113_ = feed_reader_local_utils_convert (_tmp107_, _tmp111_, _tmp112_);
				_tmp114_ = _tmp113_;
				_g_free0 (_tmp111_);
				content = _tmp114_;
				_tmp115_ = content;
				if (_tmp115_ == NULL) {
					gchar* _tmp116_;
					_tmp116_ = g_strdup (_ ("Nothing to read here."));
					_g_free0 (content);
					content = _tmp116_;
				}
				_tmp117_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				enclosures = _tmp117_;
				_tmp118_ = item;
				g_object_get (_tmp118_, "enclosure-url", &_tmp119_, NULL);
				_tmp120_ = _tmp119_;
				_tmp121_ = _tmp120_;
				_tmp122_ = _tmp121_ != NULL;
				_g_free0 (_tmp121_);
				if (_tmp122_) {
					GeeArrayList* _tmp123_;
					const gchar* _tmp124_;
					RssItem* _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
					gchar* _tmp128_;
					FeedReaderEnclosure* _tmp129_;
					FeedReaderEnclosure* _tmp130_;
					_tmp123_ = enclosures;
					_tmp124_ = articleID;
					_tmp125_ = item;
					g_object_get (_tmp125_, "enclosure-url", &_tmp126_, NULL);
					_tmp127_ = _tmp126_;
					_tmp128_ = _tmp127_;
					_tmp129_ = feed_reader_enclosure_new (_tmp124_, _tmp128_, FEED_READER_ENCLOSURE_TYPE_FILE);
					_tmp130_ = _tmp129_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp123_, _tmp130_);
					_g_object_unref0 (_tmp130_);
					_g_free0 (_tmp128_);
				}
				_tmp131_ = item;
				g_object_get (_tmp131_, "link", &_tmp132_, NULL);
				_tmp133_ = _tmp132_;
				articleURL = _tmp133_;
				_tmp134_ = articleURL;
				if (g_str_has_prefix (_tmp134_, "/")) {
					gchar* _tmp135_;
					gchar* _tmp136_;
					const gchar* _tmp137_;
					gchar* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					_tmp135_ = feed_reader_feed_getURL (feed);
					_tmp136_ = _tmp135_;
					_tmp137_ = articleURL;
					_tmp138_ = string_substring (_tmp137_, (glong) 1, (glong) -1);
					_tmp139_ = _tmp138_;
					_tmp140_ = g_strconcat (_tmp136_, _tmp139_, NULL);
					_g_free0 (articleURL);
					articleURL = _tmp140_;
					_g_free0 (_tmp139_);
					_g_free0 (_tmp136_);
				}
				_tmp142_ = item;
				g_object_get (_tmp142_, "title", &_tmp143_, NULL);
				_tmp144_ = _tmp143_;
				_tmp145_ = _tmp144_;
				_tmp146_ = _tmp145_ != NULL;
				_g_free0 (_tmp145_);
				if (_tmp146_) {
					FeedReaderlocalUtils* _tmp147_;
					RssItem* _tmp148_;
					gchar* _tmp149_;
					gchar* _tmp150_;
					gchar* _tmp151_;
					const gchar* _tmp152_;
					gchar* _tmp153_;
					_tmp147_ = self->priv->m_utils;
					_tmp148_ = item;
					g_object_get (_tmp148_, "title", &_tmp149_, NULL);
					_tmp150_ = _tmp149_;
					_tmp151_ = _tmp150_;
					_tmp152_ = locale;
					_tmp153_ = feed_reader_local_utils_convert (_tmp147_, _tmp151_, _tmp152_);
					_g_free0 (_tmp141_);
					_tmp141_ = _tmp153_;
					_g_free0 (_tmp151_);
				} else {
					_g_free0 (_tmp141_);
					_tmp141_ = NULL;
				}
				_tmp154_ = articleID;
				_tmp155_ = articleURL;
				_tmp156_ = feed_reader_feed_getFeedID (feed);
				_tmp157_ = _tmp156_;
				_tmp158_ = content;
				_tmp159_ = content;
				_tmp160_ = self->priv->m_utils;
				_tmp161_ = item;
				g_object_get (_tmp161_, "author", &_tmp162_, NULL);
				_tmp163_ = _tmp162_;
				_tmp164_ = _tmp163_;
				_tmp165_ = locale;
				_tmp166_ = feed_reader_local_utils_convert (_tmp160_, _tmp164_, _tmp165_);
				_tmp167_ = _tmp166_;
				_tmp168_ = date;
				_tmp169_ = enclosures;
				_tmp170_ = feed_reader_article_new (_tmp154_, _tmp141_, _tmp155_, _tmp157_, FEED_READER_ARTICLE_STATUS_UNREAD, FEED_READER_ARTICLE_STATUS_UNMARKED, _tmp158_, _tmp159_, _tmp167_, _tmp168_, 0, NULL, (GeeList*) _tmp169_, "", 0);
				_tmp171_ = _tmp170_;
				_g_free0 (_tmp167_);
				_g_free0 (_tmp164_);
				_g_free0 (_tmp157_);
				article = _tmp171_;
				_tmp172_ = article;
				_tmp173_ = feed_reader_article_getTitle (_tmp172_);
				_tmp174_ = _tmp173_;
				_tmp175_ = g_strconcat ("Got new article: ", _tmp174_, NULL);
				_tmp176_ = _tmp175_;
				feed_reader_logger_debug (_tmp176_);
				_g_free0 (_tmp176_);
				_g_free0 (_tmp174_);
				_tmp177_ = newArticles;
				_tmp178_ = article;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp177_, _tmp178_);
				_g_object_unref0 (article);
				_g_free0 (_tmp141_);
				_g_free0 (articleURL);
				_g_object_unref0 (enclosures);
				_g_free0 (content);
				_g_date_time_unref0 (date);
				_g_free0 (articleID);
				_g_object_unref0 (item);
			}
		}
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
	}
	g_mutex_lock (&_data3_->mutex);
	_tmp179_ = _data3_->articles;
	_tmp180_ = newArticles;
	gee_array_list_add_all (_tmp179_, (GeeCollection*) _tmp180_);
	g_mutex_unlock (&_data3_->mutex);
	_g_object_unref0 (newArticles);
	_g_free0 (locale);
	_g_object_unref0 (doc);
	_g_object_unref0 (parser);
	_g_free0 (xml);
	_g_object_unref0 (session);
	_g_object_unref0 (msg);
	_g_free0 (url);
	_g_object_unref0 (feed);
}

static void
____lambda7__gfunc (gpointer data,
                    gpointer self)
{
	___lambda7_ (self, (FeedReaderFeed*) data);
}

static void
vala__g_thread_pool_free_wrapper (GThreadPool* pool,
                                  gboolean immediate,
                                  gboolean wait)
{
	GThreadPool* ptr = NULL;
	GThreadPool* _tmp0_;
	GThreadPool* _tmp1_;
	_tmp0_ = pool;
	pool = NULL;
	ptr = _tmp0_;
	_tmp1_ = ptr;
	if (_tmp1_ != NULL) {
		GThreadPool* _tmp2_;
		_tmp2_ = ptr;
		g_thread_pool_free ((GThreadPool*) _tmp2_, immediate, wait);
	}
	_g_thread_pool_free0 (pool);
}

static gint
__lambda8_ (FeedReaderlocalInterface* self,
            FeedReaderArticle* a,
            FeedReaderArticle* b)
{
	GCompareFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = feed_reader_article_getArticleID (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = feed_reader_article_getArticleID (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

static gint
___lambda8__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda8_ ((FeedReaderlocalInterface*) self, (FeedReaderArticle*) a, (FeedReaderArticle*) b);
	return result;
}

static void
feed_reader_local_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                              gint count,
                                              FeedReaderArticleStatus whatToGet,
                                              GDateTime* since,
                                              const gchar* feedID,
                                              gboolean isTagID,
                                              GCancellable* cancellable)
{
	FeedReaderlocalInterface * self;
	Block3Data* _data3_;
	GCancellable* _tmp0_;
	FeedReaderDataBase* db = NULL;
	FeedReaderDataBase* _tmp1_;
	GeeList* feeds = NULL;
	FeedReaderDataBase* _tmp2_;
	GeeList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp29_;
	GeeArrayList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderlocalInterface*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data3_->cancellable);
	_data3_->cancellable = _tmp0_;
	_tmp1_ = feed_reader_data_base_writeAccess ();
	db = _tmp1_;
	_tmp2_ = db;
	_tmp3_ = feed_reader_data_base_read_only_read_feeds ((FeedReaderDataBaseReadOnly*) _tmp2_, FALSE);
	feeds = _tmp3_;
	_tmp4_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data3_->articles = _tmp4_;
	g_mutex_init (&_data3_->mutex);
	{
		GThreadPool* threads = NULL;
		GThreadPool* _tmp5_;
		gboolean immediate = FALSE;
		gboolean wait = FALSE;
		GThreadPool* _tmp24_;
		_tmp5_ = g_thread_pool_new (____lambda7__gfunc, _data3_, (gint) g_get_num_processors (), TRUE, &_inner_error0_);
		threads = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeList* _feed_list = NULL;
			GeeList* _tmp6_;
			gint _feed_size = 0;
			GeeList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _feed_index = 0;
			_tmp6_ = feeds;
			_feed_list = _tmp6_;
			_tmp7_ = _feed_list;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_feed_size = _tmp9_;
			_feed_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				FeedReaderFeed* feed = NULL;
				GeeList* _tmp12_;
				gpointer _tmp13_;
				_feed_index = _feed_index + 1;
				_tmp10_ = _feed_index;
				_tmp11_ = _feed_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _feed_list;
				_tmp13_ = gee_list_get (_tmp12_, _feed_index);
				feed = (FeedReaderFeed*) _tmp13_;
				{
					GThreadPool* _tmp14_;
					FeedReaderFeed* _tmp15_;
					FeedReaderFeed* _tmp16_;
					_tmp14_ = threads;
					_tmp15_ = feed;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					g_thread_pool_push (_tmp14_, _tmp16_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					FeedReaderFeed* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					GError* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp17_ = feed;
					_tmp18_ = feed_reader_feed_getTitle (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					_tmp22_ = g_strdup_printf ("Error creating thread to download Feed %s: %s", _tmp19_, _tmp21_);
					_tmp23_ = _tmp22_;
					feed_reader_logger_error (_tmp23_);
					_g_free0 (_tmp23_);
					_g_free0 (_tmp19_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (feed);
					_g_thread_pool_free0 (threads);
					goto __catch0_g_error;
				}
				_g_object_unref0 (feed);
			}
		}
		immediate = FALSE;
		wait = TRUE;
		_tmp24_ = threads;
		threads = NULL;
		vala__g_thread_pool_free_wrapper (_tmp24_, immediate, wait);
		_g_thread_pool_free0 (threads);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_strconcat ("Error creating threads to download Feeds: ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		feed_reader_logger_error (_tmp28_);
		_g_free0 (_tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (feeds);
		_g_object_unref0 (db);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp29_ = _data3_->articles;
	gee_list_sort ((GeeList*) _tmp29_, ___lambda8__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp30_ = _data3_->articles;
	_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 0) {
		FeedReaderDataBase* _tmp33_;
		GeeArrayList* _tmp34_;
		GeeArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp33_ = db;
		_tmp34_ = _data3_->articles;
		feed_reader_data_base_write_articles (_tmp33_, (GeeList*) _tmp34_);
		_tmp35_ = _data3_->articles;
		_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strdup_printf ("localInterface: %i articles written", _tmp37_);
		_tmp39_ = _tmp38_;
		feed_reader_logger_debug (_tmp39_);
		_g_free0 (_tmp39_);
		g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "refresh-feed-list-counter");
		g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "update-article-list");
	}
	_g_object_unref0 (feeds);
	_g_object_unref0 (db);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

FeedReaderlocalInterface*
feed_reader_local_interface_construct (GType object_type)
{
	FeedReaderlocalInterface * self = NULL;
	self = (FeedReaderlocalInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderlocalInterface*
feed_reader_local_interface_new (void)
{
	return feed_reader_local_interface_construct (FEED_READER_TYPE_LOCAL_INTERFACE);
}

static void
feed_reader_local_interface_class_init (FeedReaderlocalInterfaceClass * klass,
                                        gpointer klass_data)
{
	feed_reader_local_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderlocalInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_local_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWidget = (GtkBox* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_getWidget;
	((FeedReaderFeedServerInterfaceClass *) klass)->postLoginAction = (void (*) (FeedReaderFeedServerInterface*, GAsyncReadyCallback, gpointer)) feed_reader_local_interface_real_postLoginAction;
	((FeedReaderFeedServerInterfaceClass *) klass)->postLoginAction_finish = (void (*) (FeedReaderFeedServerInterface*, GAsyncResult*)) feed_reader_local_interface_postLoginAction_finish;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_local_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_local_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_local_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_local_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_local_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_local_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_local_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_local_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeeds = (void (*) (FeedReaderFeedServerInterface*, GeeList*)) feed_reader_local_interface_real_addFeeds;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_local_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_local_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_local_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_local_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_local_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_local_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_local_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_local_interface_finalize;
}

static void
feed_reader_local_interface_instance_init (FeedReaderlocalInterface * self,
                                           gpointer klass)
{
	self->priv = feed_reader_local_interface_get_instance_private (self);
}

static void
feed_reader_local_interface_finalize (GObject * obj)
{
	FeedReaderlocalInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_LOCAL_INTERFACE, FeedReaderlocalInterface);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_session);
	_g_object_unref0 (self->priv->m_feedlist);
	G_OBJECT_CLASS (feed_reader_local_interface_parent_class)->finalize (obj);
}

GType
feed_reader_local_interface_get_type (void)
{
	return feed_reader_local_interface_type_id;
}

GType
feed_reader_local_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderlocalInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_local_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderlocalInterface), 0, (GInstanceInitFunc) feed_reader_local_interface_instance_init, NULL };
	feed_reader_local_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderlocalInterface", &g_define_type_info, 0);
	FeedReaderlocalInterface_private_offset = sizeof (FeedReaderlocalInterfacePrivate);
	return feed_reader_local_interface_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_local_interface_register_type (module);
	feed_reader_local_utils_register_type (module);
	feed_reader_suggested_feed_row_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_LOCAL_INTERFACE);
	_g_object_unref0 (objmodule);
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

