/* localUtils.c generated by valac 0.56.3, the Vala compiler
 * generated from localUtils.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "local.h"
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include "FeedReader.h"
#include <glib/gi18n-lib.h>
#include "rss-glib.h"

enum  {
	FEED_READER_LOCAL_UTILS_0_PROPERTY,
	FEED_READER_LOCAL_UTILS_NUM_PROPERTIES
};
static GParamSpec* feed_reader_local_utils_properties[FEED_READER_LOCAL_UTILS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static gpointer feed_reader_local_utils_parent_class = NULL;
static GType feed_reader_local_utils_type_id = 0;

static void _vala_SoupBuffer_free (SoupBuffer* self);

FeedReaderlocalUtils*
feed_reader_local_utils_construct (GType object_type)
{
	FeedReaderlocalUtils * self = NULL;
	self = (FeedReaderlocalUtils*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderlocalUtils*
feed_reader_local_utils_new (void)
{
	return feed_reader_local_utils_construct (FEED_READER_TYPE_LOCAL_UTILS);
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

FeedReaderFeed*
feed_reader_local_utils_downloadFeed (FeedReaderlocalUtils* self,
                                      SoupSession* session,
                                      const gchar* feed_url,
                                      const gchar* feedID,
                                      GeeList* catIDs,
                                      gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	GString* _error_ = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	SoupMessage* msg = NULL;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	guint status = 0U;
	SoupMessage* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gchar* xml = NULL;
	SoupMessage* _tmp19_;
	SoupMessageBody* _tmp20_;
	SoupBuffer* _tmp21_;
	SoupBuffer* _tmp22_;
	guint8* _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* url = NULL;
	RssParser* parser = NULL;
	RssParser* _tmp26_;
	RssDocument* doc = NULL;
	RssParser* _tmp37_;
	RssDocument* _tmp38_;
	gboolean _tmp39_ = FALSE;
	RssDocument* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_;
	gchar* _tmp52_;
	RssDocument* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	RssDocument* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	FeedReaderFeed* _tmp62_;
	FeedReaderFeed* _tmp63_;
	GError* _inner_error0_ = NULL;
	FeedReaderFeed* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (session != NULL, NULL);
	g_return_val_if_fail (feed_url != NULL, NULL);
	g_return_val_if_fail (feedID != NULL, NULL);
	g_return_val_if_fail (catIDs != NULL, NULL);
	_tmp0_ = g_string_new (_ ("Failed to add feed"));
	_error_ = _tmp0_;
	_tmp1_ = _error_;
	g_string_append_printf (_tmp1_, " %s\n", feed_url);
	_tmp2_ = soup_message_new ("GET", feed_url);
	msg = _tmp2_;
	_tmp3_ = msg;
	if (_tmp3_ == NULL) {
		GString* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = _error_;
		g_string_append (_tmp4_, _ ("Failed to parse URL."));
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp7_;
		_tmp8_ = _vala_errmsg;
		feed_reader_logger_warning (_tmp8_);
		result = NULL;
		_g_object_unref0 (msg);
		_g_string_free0 (_error_);
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	_tmp9_ = msg;
	status = soup_session_send_message (session, _tmp9_);
	if (status < ((guint) 100)) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = status >= ((guint) 400);
	}
	if (_tmp10_) {
		GString* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		if (status < ((guint) 100)) {
			GString* _tmp11_;
			_tmp11_ = _error_;
			g_string_append (_tmp11_, _ ("Network error connecting to the server."));
		} else {
			GString* _tmp12_;
			GString* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = _error_;
			g_string_append (_tmp12_, _ ("Got HTTP error code"));
			_tmp13_ = _error_;
			_tmp14_ = soup_status_get_phrase (status);
			g_string_append_printf (_tmp13_, " %u %s", status, _tmp14_);
		}
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->str;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp17_;
		_tmp18_ = _vala_errmsg;
		feed_reader_logger_warning (_tmp18_);
		result = NULL;
		_g_object_unref0 (msg);
		_g_string_free0 (_error_);
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	_tmp19_ = msg;
	_tmp20_ = _tmp19_->response_body;
	_tmp21_ = soup_message_body_flatten (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_->data;
	_tmp23__length1 = _tmp22_->length;
	_tmp24_ = g_strdup ((const gchar*) _tmp23_);
	_tmp25_ = _tmp24_;
	__vala_SoupBuffer_free0 (_tmp22_);
	xml = _tmp25_;
	url = NULL;
	_tmp26_ = rss_parser_new ();
	parser = _tmp26_;
	{
		RssParser* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp27_ = parser;
		_tmp28_ = xml;
		_tmp29_ = xml;
		_tmp30_ = strlen (_tmp29_);
		_tmp31_ = _tmp30_;
		rss_parser_load_from_data (_tmp27_, _tmp28_, (gulong) _tmp31_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GString* _tmp32_;
		GString* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		g_clear_error (&_inner_error0_);
		_tmp32_ = _error_;
		g_string_append (_tmp32_, _ ("Could not parse feed as RSS or ATOM."));
		_tmp33_ = _error_;
		_tmp34_ = _tmp33_->str;
		_tmp35_ = g_strdup (_tmp34_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp35_;
		_tmp36_ = _vala_errmsg;
		feed_reader_logger_warning (_tmp36_);
		result = NULL;
		_g_object_unref0 (parser);
		_g_free0 (url);
		_g_free0 (xml);
		_g_object_unref0 (msg);
		_g_string_free0 (_error_);
		if (errmsg) {
			*errmsg = _vala_errmsg;
		} else {
			_g_free0 (_vala_errmsg);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (url);
		_g_free0 (xml);
		_g_object_unref0 (msg);
		_g_string_free0 (_error_);
		_g_free0 (_vala_errmsg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp37_ = parser;
	_tmp38_ = rss_parser_get_document (_tmp37_);
	doc = _tmp38_;
	_tmp40_ = doc;
	g_object_get (_tmp40_, "link", &_tmp41_, NULL);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_ != NULL;
	_g_free0 (_tmp43_);
	if (_tmp44_) {
		RssDocument* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		_tmp45_ = doc;
		g_object_get (_tmp45_, "link", &_tmp46_, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_;
		_tmp39_ = g_strcmp0 (_tmp48_, "") != 0;
		_g_free0 (_tmp48_);
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		RssDocument* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp49_ = doc;
		g_object_get (_tmp49_, "link", &_tmp50_, NULL);
		_tmp51_ = _tmp50_;
		_g_free0 (url);
		url = _tmp51_;
	}
	_tmp52_ = g_strdup ("");
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp52_;
	_tmp53_ = doc;
	g_object_get (_tmp53_, "title", &_tmp54_, NULL);
	_tmp55_ = _tmp54_;
	_tmp56_ = _tmp55_;
	_tmp57_ = url;
	_tmp58_ = doc;
	g_object_get (_tmp58_, "image-url", &_tmp59_, NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp62_ = feed_reader_feed_new (feedID, _tmp56_, _tmp57_, (guint) 0, catIDs, _tmp61_, feed_url);
	_tmp63_ = _tmp62_;
	_g_free0 (_tmp61_);
	_g_free0 (_tmp56_);
	result = _tmp63_;
	_g_object_unref0 (doc);
	_g_object_unref0 (parser);
	_g_free0 (url);
	_g_free0 (xml);
	_g_object_unref0 (msg);
	_g_string_free0 (_error_);
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

gchar*
feed_reader_local_utils_convert (FeedReaderlocalUtils* self,
                                 const gchar* text,
                                 const gchar* locale)
{
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (text == NULL) {
		result = NULL;
		return result;
	}
	if (locale == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (text);
		result = _tmp0_;
		return result;
	}
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_convert (text, (gssize) -1, "utf-8", locale, NULL, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp1_);
		return result;
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		feed_reader_logger_error (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = g_strdup ("");
	result = _tmp6_;
	return result;
}

static void
feed_reader_local_utils_class_init (FeedReaderlocalUtilsClass * klass,
                                    gpointer klass_data)
{
	feed_reader_local_utils_parent_class = g_type_class_peek_parent (klass);
}

static void
feed_reader_local_utils_instance_init (FeedReaderlocalUtils * self,
                                       gpointer klass)
{
}

GType
feed_reader_local_utils_get_type (void)
{
	return feed_reader_local_utils_type_id;
}

GType
feed_reader_local_utils_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderlocalUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_local_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderlocalUtils), 0, (GInstanceInitFunc) feed_reader_local_utils_instance_init, NULL };
	feed_reader_local_utils_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderlocalUtils", &g_define_type_info, 0);
	return feed_reader_local_utils_type_id;
}

