/* oldreaderAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from oldreaderAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "oldreader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <json-glib/json-glib.h>
#include <gee.h>
#include <gio/gio.h>

enum  {
	FEED_READER_OLD_READER_API_0_PROPERTY,
	FEED_READER_OLD_READER_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_old_reader_api_properties[FEED_READER_OLD_READER_API_NUM_PROPERTIES];
#define _feed_reader_old_reader_connection_unref0(var) ((var == NULL) ? NULL : (var = (feed_reader_old_reader_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FeedReaderOldReaderAPIPrivate {
	FeedReaderOldReaderConnection* m_connection;
	FeedReaderOldReaderUtils* m_utils;
	gchar* m_userID;
};

static gint FeedReaderOldReaderAPI_private_offset;
static gpointer feed_reader_old_reader_api_parent_class = NULL;
static GType feed_reader_old_reader_api_type_id = 0;

static gboolean feed_reader_old_reader_api_getUserID (FeedReaderOldReaderAPI* self);
static void feed_reader_old_reader_api_finalize (GObject * obj);

static inline gpointer
feed_reader_old_reader_api_get_instance_private (FeedReaderOldReaderAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderOldReaderAPI_private_offset);
}

static GType
feed_reader_old_reader_api_oldreader_subscription_action_get_type_once (void)
{
	static const GEnumValue values[] = {{FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_EDIT, "FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_EDIT", "edit"}, {FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_SUBSCRIBE, "FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_SUBSCRIBE", "subscribe"}, {FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_UNSUBSCRIBE, "FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_UNSUBSCRIBE", "unsubscribe"}, {0, NULL, NULL}};
	GType feed_reader_old_reader_api_oldreader_subscription_action_type_id;
	feed_reader_old_reader_api_oldreader_subscription_action_type_id = g_enum_register_static ("FeedReaderOldReaderAPIOldreaderSubscriptionAction", values);
	return feed_reader_old_reader_api_oldreader_subscription_action_type_id;
}

GType
feed_reader_old_reader_api_oldreader_subscription_action_get_type (void)
{
	static volatile gsize feed_reader_old_reader_api_oldreader_subscription_action_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_old_reader_api_oldreader_subscription_action_type_id__once)) {
		GType feed_reader_old_reader_api_oldreader_subscription_action_type_id;
		feed_reader_old_reader_api_oldreader_subscription_action_type_id = feed_reader_old_reader_api_oldreader_subscription_action_get_type_once ();
		g_once_init_leave (&feed_reader_old_reader_api_oldreader_subscription_action_type_id__once, feed_reader_old_reader_api_oldreader_subscription_action_type_id);
	}
	return feed_reader_old_reader_api_oldreader_subscription_action_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderOldReaderAPI*
feed_reader_old_reader_api_construct (GType object_type,
                                      FeedReaderOldReaderUtils* utils)
{
	FeedReaderOldReaderAPI * self = NULL;
	FeedReaderOldReaderUtils* _tmp0_;
	FeedReaderOldReaderUtils* _tmp1_;
	FeedReaderOldReaderConnection* _tmp2_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderOldReaderAPI*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_old_reader_connection_new (_tmp1_);
	_feed_reader_old_reader_connection_unref0 (self->priv->m_connection);
	self->priv->m_connection = _tmp2_;
	return self;
}

FeedReaderOldReaderAPI*
feed_reader_old_reader_api_new (FeedReaderOldReaderUtils* utils)
{
	return feed_reader_old_reader_api_construct (FEED_READER_TYPE_OLD_READER_API, utils);
}

FeedReaderLoginResponse
feed_reader_old_reader_api_login (FeedReaderOldReaderAPI* self)
{
	FeedReaderOldReaderUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_old_reader_utils_getAccessToken (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		FeedReaderLoginResponse response = 0;
		FeedReaderOldReaderConnection* _tmp4_;
		_tmp4_ = self->priv->m_connection;
		response = feed_reader_old_reader_connection_getToken (_tmp4_);
		if (response != FEED_READER_LOGIN_RESPONSE_SUCCESS) {
			result = response;
			return result;
		}
	}
	if (feed_reader_old_reader_api_getUserID (self)) {
		result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
		return result;
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	return result;
}

gboolean
feed_reader_old_reader_api_ping (FeedReaderOldReaderAPI* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = feed_reader_utils_ping ("https://theoldreader.com/");
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
feed_reader_old_reader_api_getUserID (FeedReaderOldReaderAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderOldReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonObject* _tmp14_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	feed_reader_logger_debug ("getUserID: getting user info");
	_tmp0_ = self->priv->m_connection;
	feed_reader_old_reader_connection_send_get_request (_tmp0_, "user-info?output=json", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getUserID: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	if (json_object_has_member (_tmp14_, "userId")) {
		JsonObject* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		FeedReaderOldReaderUtils* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp15_ = root;
		_tmp16_ = json_object_get_string_member (_tmp15_, "userId");
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (self->priv->m_userID);
		self->priv->m_userID = _tmp17_;
		_tmp18_ = self->priv->m_utils;
		_tmp19_ = self->priv->m_userID;
		feed_reader_old_reader_utils_setUserID (_tmp18_, _tmp19_);
		_tmp20_ = self->priv->m_userID;
		_tmp21_ = g_strconcat ("Oldreader: userID = ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		feed_reader_logger_info (_tmp22_);
		_g_free0 (_tmp22_);
		result = TRUE;
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	result = FALSE;
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

gboolean
feed_reader_old_reader_api_getFeeds (FeedReaderOldReaderAPI* self,
                                     GeeList* feeds)
{
	FeedReaderResponse response = {0};
	FeedReaderOldReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* array = NULL;
	JsonObject* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	guint length = 0U;
	JsonArray* _tmp17_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_old_reader_connection_send_get_request (_tmp0_, "subscription/list?output=json", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getFeeds: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	_tmp15_ = json_object_get_array_member (_tmp14_, "subscriptions");
	_tmp16_ = _json_array_ref0 (_tmp15_);
	array = _tmp16_;
	_tmp17_ = array;
	length = json_array_get_length (_tmp17_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp20_;
				JsonObject* _tmp21_;
				JsonObject* _tmp22_;
				gchar* feedID = NULL;
				JsonObject* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				const gchar* _tmp26_ = NULL;
				JsonObject* _tmp27_;
				gchar* url = NULL;
				gchar* _tmp32_;
				guint catCount = 0U;
				JsonObject* _tmp33_;
				JsonArray* _tmp34_;
				GeeArrayList* categories = NULL;
				GeeArrayList* _tmp35_;
				const gchar* _tmp43_;
				JsonObject* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				GeeArrayList* _tmp47_;
				JsonObject* _tmp48_;
				const gchar* _tmp49_;
				FeedReaderFeed* _tmp50_;
				FeedReaderFeed* _tmp51_;
				if (!_tmp18_) {
					guint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp20_ = array;
				_tmp21_ = json_array_get_object_element (_tmp20_, i);
				_tmp22_ = _json_object_ref0 (_tmp21_);
				object = _tmp22_;
				_tmp23_ = object;
				_tmp24_ = json_object_get_string_member (_tmp23_, "id");
				_tmp25_ = g_strdup (_tmp24_);
				feedID = _tmp25_;
				_tmp27_ = object;
				if (json_object_has_member (_tmp27_, "htmlUrl")) {
					JsonObject* _tmp28_;
					const gchar* _tmp29_;
					_tmp28_ = object;
					_tmp29_ = json_object_get_string_member (_tmp28_, "htmlUrl");
					_tmp26_ = _tmp29_;
				} else {
					JsonObject* _tmp30_;
					const gchar* _tmp31_;
					_tmp30_ = object;
					_tmp31_ = json_object_get_string_member (_tmp30_, "url");
					_tmp26_ = _tmp31_;
				}
				_tmp32_ = g_strdup (_tmp26_);
				url = _tmp32_;
				_tmp33_ = object;
				_tmp34_ = json_object_get_array_member (_tmp33_, "categories");
				catCount = json_array_get_length (_tmp34_);
				_tmp35_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				categories = _tmp35_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp36_ = FALSE;
						_tmp36_ = TRUE;
						while (TRUE) {
							GeeArrayList* _tmp38_;
							JsonObject* _tmp39_;
							JsonArray* _tmp40_;
							JsonObject* _tmp41_;
							const gchar* _tmp42_;
							if (!_tmp36_) {
								guint _tmp37_;
								j = j + 1;
								_tmp37_ = j;
							}
							_tmp36_ = FALSE;
							if (!(j < catCount)) {
								break;
							}
							_tmp38_ = categories;
							_tmp39_ = object;
							_tmp40_ = json_object_get_array_member (_tmp39_, "categories");
							_tmp41_ = json_array_get_object_element (_tmp40_, j);
							_tmp42_ = json_object_get_string_member (_tmp41_, "id");
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp42_);
						}
					}
				}
				_tmp43_ = feedID;
				_tmp44_ = object;
				_tmp45_ = json_object_get_string_member (_tmp44_, "title");
				_tmp46_ = url;
				_tmp47_ = categories;
				_tmp48_ = object;
				_tmp49_ = json_object_get_string_member (_tmp48_, "iconUrl");
				_tmp50_ = feed_reader_feed_new (_tmp43_, _tmp45_, _tmp46_, (guint) 0, (GeeList*) _tmp47_, _tmp49_, NULL);
				_tmp51_ = _tmp50_;
				gee_collection_add ((GeeCollection*) feeds, _tmp51_);
				_g_object_unref0 (_tmp51_);
				_g_object_unref0 (categories);
				_g_free0 (url);
				_g_free0 (feedID);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
feed_reader_old_reader_api_getCategoriesAndTags (FeedReaderOldReaderAPI* self,
                                                 GeeList* feeds,
                                                 GeeList* categories,
                                                 GeeList* tags)
{
	FeedReaderResponse response = {0};
	FeedReaderOldReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* array = NULL;
	JsonObject* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	guint length = 0U;
	JsonArray* _tmp17_;
	gint orderID = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_connection;
	feed_reader_old_reader_connection_send_get_request (_tmp0_, "tag/list?output=json", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = FALSE;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getCategoriesAndTags: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	_tmp15_ = json_object_get_array_member (_tmp14_, "tags");
	_tmp16_ = _json_array_ref0 (_tmp15_);
	array = _tmp16_;
	_tmp17_ = array;
	length = json_array_get_length (_tmp17_);
	orderID = 0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp20_;
				JsonObject* _tmp21_;
				JsonObject* _tmp22_;
				gchar* id = NULL;
				JsonObject* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gint start = 0;
				const gchar* _tmp26_;
				gchar* title = NULL;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				if (!_tmp18_) {
					guint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp20_ = array;
				_tmp21_ = json_array_get_object_element (_tmp20_, i);
				_tmp22_ = _json_object_ref0 (_tmp21_);
				object = _tmp22_;
				_tmp23_ = object;
				_tmp24_ = json_object_get_string_member (_tmp23_, "id");
				_tmp25_ = g_strdup (_tmp24_);
				id = _tmp25_;
				_tmp26_ = id;
				start = string_last_index_of_char (_tmp26_, (gunichar) '/', 0) + 1;
				_tmp27_ = id;
				_tmp28_ = string_substring (_tmp27_, (glong) start, (glong) -1);
				title = _tmp28_;
				_tmp29_ = id;
				if (string_contains (_tmp29_, "/label/")) {
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					FeedReaderCategory* _tmp34_;
					FeedReaderCategory* _tmp35_;
					gint _tmp36_;
					_tmp30_ = id;
					_tmp31_ = title;
					_tmp32_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
					_tmp33_ = _tmp32_;
					_tmp34_ = feed_reader_category_new (_tmp30_, _tmp31_, (guint) 0, orderID, _tmp33_, 1);
					_tmp35_ = _tmp34_;
					gee_collection_add ((GeeCollection*) categories, _tmp35_);
					_g_object_unref0 (_tmp35_);
					_g_free0 (_tmp33_);
					orderID = orderID + 1;
					_tmp36_ = orderID;
				}
				_g_free0 (title);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	result = TRUE;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

gint
feed_reader_old_reader_api_getTotalUnread (FeedReaderOldReaderAPI* self)
{
	FeedReaderResponse response = {0};
	FeedReaderOldReaderConnection* _tmp0_;
	FeedReaderResponse _tmp1_ = {0};
	FeedReaderResponse _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonObject* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	JsonArray* array = NULL;
	JsonObject* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	guint length = 0U;
	JsonArray* _tmp17_;
	gint count = 0;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_connection;
	feed_reader_old_reader_connection_send_get_request (_tmp0_, "unread-count?output=json", NULL, &_tmp1_);
	response = _tmp1_;
	_tmp2_ = response;
	if (_tmp2_.status != ((guint) 200)) {
		result = 0;
		feed_reader_response_destroy (&response);
		return result;
	}
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	{
		JsonParser* _tmp4_;
		FeedReaderResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = parser;
		_tmp5_ = response;
		_tmp6_ = _tmp5_.data;
		json_parser_load_from_data (_tmp4_, _tmp6_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getTotalUnread: Could not load message response");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		feed_reader_logger_error (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = json_node_get_object (_tmp11_);
	_tmp13_ = _json_object_ref0 (_tmp12_);
	root = _tmp13_;
	_tmp14_ = root;
	_tmp15_ = json_object_get_array_member (_tmp14_, "unreadcounts");
	_tmp16_ = _json_array_ref0 (_tmp15_);
	array = _tmp16_;
	_tmp17_ = array;
	length = json_array_get_length (_tmp17_);
	count = 0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp20_;
				JsonObject* _tmp21_;
				JsonObject* _tmp22_;
				JsonObject* _tmp23_;
				const gchar* _tmp24_;
				if (!_tmp18_) {
					guint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp20_ = array;
				_tmp21_ = json_array_get_object_element (_tmp20_, i);
				_tmp22_ = _json_object_ref0 (_tmp21_);
				object = _tmp22_;
				_tmp23_ = object;
				_tmp24_ = json_object_get_string_member (_tmp23_, "id");
				if (g_str_has_prefix (_tmp24_, "feed/")) {
					JsonObject* _tmp25_;
					_tmp25_ = object;
					count += (gint) json_object_get_int_member (_tmp25_, "count");
				}
				_json_object_unref0 (object);
			}
		}
	}
	_tmp26_ = g_strdup_printf ("getTotalUnread %i", count);
	_tmp27_ = _tmp26_;
	feed_reader_logger_debug (_tmp27_);
	_g_free0 (_tmp27_);
	result = count;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	return result;
}

gchar*
feed_reader_old_reader_api_updateArticles (FeedReaderOldReaderAPI* self,
                                           GeeList* ids,
                                           gint count,
                                           const gchar* continuation)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	FeedReaderResponse response = {0};
	FeedReaderOldReaderConnection* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FeedReaderResponse _tmp14_ = {0};
	FeedReaderResponse _tmp15_;
	FeedReaderResponse _tmp16_;
	JsonParser* parser = NULL;
	JsonParser* _tmp17_;
	JsonObject* root = NULL;
	JsonParser* _tmp23_;
	JsonNode* _tmp24_;
	JsonObject* _tmp25_;
	JsonObject* _tmp26_;
	JsonArray* array = NULL;
	JsonObject* _tmp27_;
	JsonArray* _tmp28_;
	JsonArray* _tmp29_;
	guint length = 0U;
	JsonArray* _tmp30_;
	gboolean _tmp38_ = FALSE;
	JsonObject* _tmp39_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ids != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", count);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("n=", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message_string = _tmp3_;
	_tmp4_ = message_string;
	_tmp5_ = g_strconcat (_tmp4_, "&xt=user/-/state/com.google/read", NULL);
	_g_free0 (message_string);
	message_string = _tmp5_;
	if (continuation != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = message_string;
		_tmp7_ = g_strconcat ("&c=", continuation, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
		_g_free0 (message_string);
		message_string = _tmp9_;
		_g_free0 (_tmp8_);
	}
	_tmp10_ = self->priv->m_connection;
	_tmp11_ = message_string;
	_tmp12_ = g_strconcat ("stream/items/ids?output=json&", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	feed_reader_old_reader_connection_send_get_request (_tmp10_, _tmp13_, NULL, &_tmp14_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	response = _tmp15_;
	_tmp16_ = response;
	if (_tmp16_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		return result;
	}
	_tmp17_ = json_parser_new ();
	parser = _tmp17_;
	{
		JsonParser* _tmp18_;
		FeedReaderResponse _tmp19_;
		const gchar* _tmp20_;
		_tmp18_ = parser;
		_tmp19_ = response;
		_tmp20_ = _tmp19_.data;
		json_parser_load_from_data (_tmp18_, _tmp20_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("updateArticles: Could not load message response");
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		feed_reader_logger_error (_tmp22_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp23_ = parser;
	_tmp24_ = json_parser_get_root (_tmp23_);
	_tmp25_ = json_node_get_object (_tmp24_);
	_tmp26_ = _json_object_ref0 (_tmp25_);
	root = _tmp26_;
	_tmp27_ = root;
	_tmp28_ = json_object_get_array_member (_tmp27_, "itemRefs");
	_tmp29_ = _json_array_ref0 (_tmp28_);
	array = _tmp29_;
	_tmp30_ = array;
	length = json_array_get_length (_tmp30_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp33_;
				JsonObject* _tmp34_;
				JsonObject* _tmp35_;
				JsonObject* _tmp36_;
				const gchar* _tmp37_;
				if (!_tmp31_) {
					guint _tmp32_;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp33_ = array;
				_tmp34_ = json_array_get_object_element (_tmp33_, i);
				_tmp35_ = _json_object_ref0 (_tmp34_);
				object = _tmp35_;
				_tmp36_ = object;
				_tmp37_ = json_object_get_string_member (_tmp36_, "id");
				gee_collection_add ((GeeCollection*) ids, _tmp37_);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp39_ = root;
	if (json_object_has_member (_tmp39_, "continuation")) {
		JsonObject* _tmp40_;
		const gchar* _tmp41_;
		_tmp40_ = root;
		_tmp41_ = json_object_get_string_member (_tmp40_, "continuation");
		_tmp38_ = g_strcmp0 (_tmp41_, "") != 0;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		JsonObject* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp42_ = root;
		_tmp43_ = json_object_get_string_member (_tmp42_, "continuation");
		_tmp44_ = g_strdup (_tmp43_);
		result = _tmp44_;
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (message_string);
		return result;
	}
	result = NULL;
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_g_free0 (message_string);
	return result;
}

gchar*
feed_reader_old_reader_api_getArticles (FeedReaderOldReaderAPI* self,
                                        GeeList* articles,
                                        gint count,
                                        FeedReaderArticleStatus whatToGet,
                                        const gchar* continuation,
                                        const gchar* tagID,
                                        const gchar* feed_id)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* api_endpoint = NULL;
	gchar* _tmp14_;
	FeedReaderResponse response = {0};
	FeedReaderOldReaderConnection* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	FeedReaderResponse _tmp34_ = {0};
	FeedReaderResponse _tmp35_;
	FeedReaderResponse _tmp36_;
	JsonParser* parser = NULL;
	JsonParser* _tmp37_;
	JsonObject* root = NULL;
	JsonParser* _tmp43_;
	JsonNode* _tmp44_;
	JsonObject* _tmp45_;
	JsonObject* _tmp46_;
	JsonArray* array = NULL;
	JsonObject* _tmp47_;
	JsonArray* _tmp48_;
	JsonArray* _tmp49_;
	guint length = 0U;
	JsonArray* _tmp50_;
	FeedReaderDataBaseReadOnly* db = NULL;
	FeedReaderDataBaseReadOnly* _tmp51_;
	gboolean _tmp127_ = FALSE;
	JsonObject* _tmp128_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articles != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", count);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("n=", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	message_string = _tmp3_;
	if (whatToGet == FEED_READER_ARTICLE_STATUS_UNREAD) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = message_string;
		_tmp5_ = g_strconcat (_tmp4_, "&xt=user/-/state/com.google/read", NULL);
		_g_free0 (message_string);
		message_string = _tmp5_;
	}
	if (whatToGet == FEED_READER_ARTICLE_STATUS_READ) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = message_string;
		_tmp7_ = g_strconcat (_tmp6_, "&s=user/-/state/com.google/read", NULL);
		_g_free0 (message_string);
		message_string = _tmp7_;
	} else {
		if (whatToGet == FEED_READER_ARTICLE_STATUS_MARKED) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = message_string;
			_tmp9_ = g_strconcat (_tmp8_, "&s=user/-/state/com.google/starred", NULL);
			_g_free0 (message_string);
			message_string = _tmp9_;
		}
	}
	_tmp10_ = message_string;
	_tmp11_ = g_strconcat ("&c=", continuation, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
	_g_free0 (message_string);
	message_string = _tmp13_;
	_g_free0 (_tmp12_);
	_tmp14_ = g_strdup ("stream/contents");
	api_endpoint = _tmp14_;
	if (feed_id != NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp15_ = api_endpoint;
		_tmp16_ = g_uri_escape_string (feed_id, NULL, TRUE);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("/", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
		_g_free0 (api_endpoint);
		api_endpoint = _tmp20_;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
	} else {
		if (tagID != NULL) {
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = api_endpoint;
			_tmp22_ = g_uri_escape_string (tagID, NULL, TRUE);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat ("/", _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp21_, _tmp25_, NULL);
			_g_free0 (api_endpoint);
			api_endpoint = _tmp26_;
			_g_free0 (_tmp25_);
			_g_free0 (_tmp23_);
		}
	}
	_tmp27_ = self->priv->m_connection;
	_tmp28_ = api_endpoint;
	_tmp29_ = g_strconcat (_tmp28_, "?output=json&", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = message_string;
	_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	feed_reader_old_reader_connection_send_get_request (_tmp27_, _tmp33_, NULL, &_tmp34_);
	_tmp35_ = _tmp34_;
	_g_free0 (_tmp33_);
	_g_free0 (_tmp30_);
	response = _tmp35_;
	_tmp36_ = response;
	if (_tmp36_.status != ((guint) 200)) {
		result = NULL;
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_g_free0 (message_string);
		return result;
	}
	_tmp37_ = json_parser_new ();
	parser = _tmp37_;
	{
		JsonParser* _tmp38_;
		FeedReaderResponse _tmp39_;
		const gchar* _tmp40_;
		_tmp38_ = parser;
		_tmp39_ = response;
		_tmp40_ = _tmp39_.data;
		json_parser_load_from_data (_tmp38_, _tmp40_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("getCategoriesAndTags: Could not load message response");
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		feed_reader_logger_error (_tmp42_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_g_free0 (message_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp43_ = parser;
	_tmp44_ = json_parser_get_root (_tmp43_);
	_tmp45_ = json_node_get_object (_tmp44_);
	_tmp46_ = _json_object_ref0 (_tmp45_);
	root = _tmp46_;
	_tmp47_ = root;
	_tmp48_ = json_object_get_array_member (_tmp47_, "items");
	_tmp49_ = _json_array_ref0 (_tmp48_);
	array = _tmp49_;
	_tmp50_ = array;
	length = json_array_get_length (_tmp50_);
	_tmp51_ = feed_reader_data_base_readOnly ();
	db = _tmp51_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp52_ = FALSE;
			_tmp52_ = TRUE;
			while (TRUE) {
				JsonObject* object = NULL;
				JsonArray* _tmp54_;
				JsonObject* _tmp55_;
				JsonObject* _tmp56_;
				gchar* id = NULL;
				JsonObject* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				gchar* _tmp62_;
				gboolean marked = FALSE;
				gboolean read = FALSE;
				JsonArray* cats = NULL;
				JsonObject* _tmp63_;
				JsonArray* _tmp64_;
				JsonArray* _tmp65_;
				guint cat_length = 0U;
				JsonArray* _tmp66_;
				GeeArrayList* tags = NULL;
				GeeArrayList* _tmp67_;
				GeeArrayList* enclosures = NULL;
				GeeArrayList* _tmp83_;
				JsonObject* _tmp84_;
				FeedReaderArticleStatus _tmp103_ = 0;
				FeedReaderArticleStatus _tmp104_ = 0;
				const gchar* _tmp105_;
				JsonObject* _tmp106_;
				const gchar* _tmp107_;
				JsonObject* _tmp108_;
				JsonArray* _tmp109_;
				JsonObject* _tmp110_;
				const gchar* _tmp111_;
				JsonObject* _tmp112_;
				JsonObject* _tmp113_;
				const gchar* _tmp114_;
				JsonObject* _tmp115_;
				JsonObject* _tmp116_;
				const gchar* _tmp117_;
				JsonObject* _tmp118_;
				const gchar* _tmp119_;
				JsonObject* _tmp120_;
				GDateTime* _tmp121_;
				GDateTime* _tmp122_;
				GeeArrayList* _tmp123_;
				GeeArrayList* _tmp124_;
				FeedReaderArticle* _tmp125_;
				FeedReaderArticle* _tmp126_;
				if (!_tmp52_) {
					guint _tmp53_;
					_tmp53_ = i;
					i = _tmp53_ + 1;
				}
				_tmp52_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp54_ = array;
				_tmp55_ = json_array_get_object_element (_tmp54_, i);
				_tmp56_ = _json_object_ref0 (_tmp55_);
				object = _tmp56_;
				_tmp57_ = object;
				_tmp58_ = json_object_get_string_member (_tmp57_, "id");
				_tmp59_ = g_strdup (_tmp58_);
				id = _tmp59_;
				_tmp60_ = id;
				_tmp61_ = id;
				_tmp62_ = string_substring (_tmp60_, (glong) (string_last_index_of_char (_tmp61_, (gunichar) '/', 0) + 1), (glong) -1);
				_g_free0 (id);
				id = _tmp62_;
				marked = FALSE;
				read = FALSE;
				_tmp63_ = object;
				_tmp64_ = json_object_get_array_member (_tmp63_, "categories");
				_tmp65_ = _json_array_ref0 (_tmp64_);
				cats = _tmp65_;
				_tmp66_ = cats;
				cat_length = json_array_get_length (_tmp66_);
				_tmp67_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
				tags = _tmp67_;
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp68_ = FALSE;
						_tmp68_ = TRUE;
						while (TRUE) {
							gchar* cat = NULL;
							JsonArray* _tmp70_;
							const gchar* _tmp71_;
							gchar* _tmp72_;
							const gchar* _tmp73_;
							if (!_tmp68_) {
								guint _tmp69_;
								_tmp69_ = j;
								j = _tmp69_ + 1;
							}
							_tmp68_ = FALSE;
							if (!(j < cat_length)) {
								break;
							}
							_tmp70_ = cats;
							_tmp71_ = json_array_get_string_element (_tmp70_, j);
							_tmp72_ = g_strdup (_tmp71_);
							cat = _tmp72_;
							_tmp73_ = cat;
							if (g_str_has_suffix (_tmp73_, "com.google/starred")) {
								marked = TRUE;
							} else {
								const gchar* _tmp74_;
								_tmp74_ = cat;
								if (g_str_has_suffix (_tmp74_, "com.google/read")) {
									read = TRUE;
								} else {
									gboolean _tmp75_ = FALSE;
									const gchar* _tmp76_;
									_tmp76_ = cat;
									if (string_contains (_tmp76_, "/label/")) {
										FeedReaderDataBaseReadOnly* _tmp77_;
										const gchar* _tmp78_;
										gchar* _tmp79_;
										gchar* _tmp80_;
										_tmp77_ = db;
										_tmp78_ = cat;
										_tmp79_ = feed_reader_data_base_read_only_getTagName (_tmp77_, _tmp78_);
										_tmp80_ = _tmp79_;
										_tmp75_ = _tmp80_ != NULL;
										_g_free0 (_tmp80_);
									} else {
										_tmp75_ = FALSE;
									}
									if (_tmp75_) {
										GeeArrayList* _tmp81_;
										const gchar* _tmp82_;
										_tmp81_ = tags;
										_tmp82_ = cat;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp81_, _tmp82_);
									}
								}
							}
							_g_free0 (cat);
						}
					}
				}
				_tmp83_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				enclosures = _tmp83_;
				_tmp84_ = object;
				if (json_object_has_member (_tmp84_, "enclosure")) {
					JsonArray* attachments = NULL;
					JsonObject* _tmp85_;
					JsonArray* _tmp86_;
					JsonArray* _tmp87_;
					guint mediaCount = 0U;
					JsonArray* _tmp88_;
					_tmp85_ = object;
					_tmp86_ = json_object_get_array_member (_tmp85_, "enclosure");
					_tmp87_ = _json_array_ref0 (_tmp86_);
					attachments = _tmp87_;
					mediaCount = (guint) 0;
					_tmp88_ = attachments;
					if (_tmp88_ != NULL) {
						JsonArray* _tmp89_;
						_tmp89_ = attachments;
						mediaCount = json_array_get_length (_tmp89_);
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp90_ = FALSE;
							_tmp90_ = TRUE;
							while (TRUE) {
								JsonObject* attachment = NULL;
								JsonArray* _tmp92_;
								JsonObject* _tmp93_;
								JsonObject* _tmp94_;
								GeeArrayList* _tmp95_;
								const gchar* _tmp96_;
								JsonObject* _tmp97_;
								const gchar* _tmp98_;
								JsonObject* _tmp99_;
								const gchar* _tmp100_;
								FeedReaderEnclosure* _tmp101_;
								FeedReaderEnclosure* _tmp102_;
								if (!_tmp90_) {
									gint _tmp91_;
									j = j + 1;
									_tmp91_ = j;
								}
								_tmp90_ = FALSE;
								if (!(((guint) j) < mediaCount)) {
									break;
								}
								_tmp92_ = attachments;
								_tmp93_ = json_array_get_object_element (_tmp92_, (guint) j);
								_tmp94_ = _json_object_ref0 (_tmp93_);
								attachment = _tmp94_;
								_tmp95_ = enclosures;
								_tmp96_ = id;
								_tmp97_ = attachment;
								_tmp98_ = json_object_get_string_member (_tmp97_, "href");
								_tmp99_ = attachment;
								_tmp100_ = json_object_get_string_member (_tmp99_, "type");
								_tmp101_ = feed_reader_enclosure_new (_tmp96_, _tmp98_, feed_reader_enclosure_type_from_string (_tmp100_));
								_tmp102_ = _tmp101_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp95_, _tmp102_);
								_g_object_unref0 (_tmp102_);
								_json_object_unref0 (attachment);
							}
						}
					}
					_json_array_unref0 (attachments);
				}
				if (read) {
					_tmp103_ = FEED_READER_ARTICLE_STATUS_READ;
				} else {
					_tmp103_ = FEED_READER_ARTICLE_STATUS_UNREAD;
				}
				if (marked) {
					_tmp104_ = FEED_READER_ARTICLE_STATUS_MARKED;
				} else {
					_tmp104_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
				}
				_tmp105_ = id;
				_tmp106_ = object;
				_tmp107_ = json_object_get_string_member (_tmp106_, "title");
				_tmp108_ = object;
				_tmp109_ = json_object_get_array_member (_tmp108_, "alternate");
				_tmp110_ = json_array_get_object_element (_tmp109_, (guint) 0);
				_tmp111_ = json_object_get_string_member (_tmp110_, "href");
				_tmp112_ = object;
				_tmp113_ = json_object_get_object_member (_tmp112_, "origin");
				_tmp114_ = json_object_get_string_member (_tmp113_, "streamId");
				_tmp115_ = object;
				_tmp116_ = json_object_get_object_member (_tmp115_, "summary");
				_tmp117_ = json_object_get_string_member (_tmp116_, "content");
				_tmp118_ = object;
				_tmp119_ = json_object_get_string_member (_tmp118_, "author");
				_tmp120_ = object;
				_tmp121_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp120_, "published"));
				_tmp122_ = _tmp121_;
				_tmp123_ = tags;
				_tmp124_ = enclosures;
				_tmp125_ = feed_reader_article_new (_tmp105_, _tmp107_, _tmp111_, _tmp114_, _tmp103_, _tmp104_, _tmp117_, NULL, _tmp119_, _tmp122_, -1, (GeeList*) _tmp123_, (GeeList*) _tmp124_, "", 0);
				_tmp126_ = _tmp125_;
				gee_collection_add ((GeeCollection*) articles, _tmp126_);
				_g_object_unref0 (_tmp126_);
				_g_date_time_unref0 (_tmp122_);
				_g_object_unref0 (enclosures);
				_g_object_unref0 (tags);
				_json_array_unref0 (cats);
				_g_free0 (id);
				_json_object_unref0 (object);
			}
		}
	}
	_tmp128_ = root;
	if (json_object_has_member (_tmp128_, "continuation")) {
		JsonObject* _tmp129_;
		const gchar* _tmp130_;
		_tmp129_ = root;
		_tmp130_ = json_object_get_string_member (_tmp129_, "continuation");
		_tmp127_ = g_strcmp0 (_tmp130_, "") != 0;
	} else {
		_tmp127_ = FALSE;
	}
	if (_tmp127_) {
		JsonObject* _tmp131_;
		const gchar* _tmp132_;
		gchar* _tmp133_;
		_tmp131_ = root;
		_tmp132_ = json_object_get_string_member (_tmp131_, "continuation");
		_tmp133_ = g_strdup (_tmp132_);
		result = _tmp133_;
		_g_object_unref0 (db);
		_json_array_unref0 (array);
		_json_object_unref0 (root);
		_g_object_unref0 (parser);
		feed_reader_response_destroy (&response);
		_g_free0 (api_endpoint);
		_g_free0 (message_string);
		return result;
	}
	result = NULL;
	_g_object_unref0 (db);
	_json_array_unref0 (array);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	feed_reader_response_destroy (&response);
	_g_free0 (api_endpoint);
	_g_free0 (message_string);
	return result;
}

void
feed_reader_old_reader_api_edidTag (FeedReaderOldReaderAPI* self,
                                    const gchar* articleID,
                                    const gchar* tagID,
                                    gboolean add)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FeedReaderOldReaderConnection* _tmp11_;
	const gchar* _tmp12_;
	FeedReaderResponse _tmp13_ = {0};
	FeedReaderResponse _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = g_strdup ("");
	message_string = _tmp0_;
	if (add) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = message_string;
		_tmp2_ = g_strconcat (_tmp1_, "a=", NULL);
		_g_free0 (message_string);
		message_string = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = message_string;
		_tmp4_ = g_strconcat (_tmp3_, "r=", NULL);
		_g_free0 (message_string);
		message_string = _tmp4_;
	}
	_tmp5_ = message_string;
	_tmp6_ = g_strconcat (_tmp5_, tagID, NULL);
	_g_free0 (message_string);
	message_string = _tmp6_;
	_tmp7_ = message_string;
	_tmp8_ = g_strconcat ("&i=", articleID, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_g_free0 (message_string);
	message_string = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = self->priv->m_connection;
	_tmp12_ = message_string;
	feed_reader_old_reader_connection_send_post_request (_tmp11_, "edit-tag?output=json", _tmp12_, &_tmp13_);
	_tmp14_ = _tmp13_;
	feed_reader_response_destroy (&_tmp14_);
	_g_free0 (message_string);
}

void
feed_reader_old_reader_api_markAsRead (FeedReaderOldReaderAPI* self,
                                       const gchar* streamID)
{
	GSettings* settingsState = NULL;
	GSettings* _tmp0_;
	gchar* message_string = NULL;
	gchar* _tmp1_;
	FeedReaderOldReaderConnection* _tmp2_;
	FeedReaderResponse _tmp3_ = {0};
	FeedReaderResponse _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.feedreader.saved-state");
	settingsState = _tmp0_;
	_tmp1_ = g_strdup_printf ("s=%s&ts=%i000000", streamID, g_settings_get_int (settingsState, "last-sync"));
	message_string = _tmp1_;
	_tmp2_ = self->priv->m_connection;
	feed_reader_old_reader_connection_send_post_request (_tmp2_, "mark-all-as-read?output=json", message_string, &_tmp3_);
	_tmp4_ = _tmp3_;
	feed_reader_response_destroy (&_tmp4_);
	_g_free0 (message_string);
	_g_object_unref0 (settingsState);
}

gchar*
feed_reader_old_reader_api_composeTagID (FeedReaderOldReaderAPI* self,
                                         const gchar* tagName)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tagName != NULL, NULL);
	_tmp0_ = self->priv->m_userID;
	_tmp1_ = g_strdup_printf ("user/%s/label/%s", _tmp0_, tagName);
	result = _tmp1_;
	return result;
}

void
feed_reader_old_reader_api_deleteTag (FeedReaderOldReaderAPI* self,
                                      const gchar* tagID)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	FeedReaderOldReaderConnection* _tmp1_;
	FeedReaderResponse _tmp2_ = {0};
	FeedReaderResponse _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = g_strconcat ("s=", tagID, NULL);
	message_string = _tmp0_;
	_tmp1_ = self->priv->m_connection;
	feed_reader_old_reader_connection_send_post_request (_tmp1_, "disable-tag?output=json", message_string, &_tmp2_);
	_tmp3_ = _tmp2_;
	feed_reader_response_destroy (&_tmp3_);
	_g_free0 (message_string);
}

void
feed_reader_old_reader_api_renameTag (FeedReaderOldReaderAPI* self,
                                      const gchar* tagID,
                                      const gchar* title)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderOldReaderConnection* _tmp7_;
	const gchar* _tmp8_;
	FeedReaderResponse _tmp9_ = {0};
	FeedReaderResponse _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strconcat ("s=", tagID, NULL);
	message_string = _tmp0_;
	_tmp1_ = message_string;
	_tmp2_ = feed_reader_old_reader_api_composeTagID (self, title);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("&dest=", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp1_, _tmp5_, NULL);
	_g_free0 (message_string);
	message_string = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp7_ = self->priv->m_connection;
	_tmp8_ = message_string;
	feed_reader_old_reader_connection_send_post_request (_tmp7_, "rename-tag?output=json", _tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	feed_reader_response_destroy (&_tmp10_);
	_g_free0 (message_string);
}

gboolean
feed_reader_old_reader_api_editSubscription (FeedReaderOldReaderAPI* self,
                                             FeedReaderOldReaderAPIOldreaderSubscriptionAction action,
                                             gchar** feedID,
                                             gint feedID_length1,
                                             const gchar* title,
                                             const gchar* add,
                                             const gchar* remove)
{
	gchar* message_string = NULL;
	gchar* _tmp0_;
	FeedReaderResponse response = {0};
	FeedReaderOldReaderConnection* _tmp25_;
	const gchar* _tmp26_;
	FeedReaderResponse _tmp27_ = {0};
	FeedReaderResponse _tmp28_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("ac=");
	message_string = _tmp0_;
	switch (action) {
		case FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_EDIT:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = message_string;
			_tmp2_ = g_strconcat (_tmp1_, "edit", NULL);
			_g_free0 (message_string);
			message_string = _tmp2_;
			break;
		}
		case FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_SUBSCRIBE:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = message_string;
			_tmp4_ = g_strconcat (_tmp3_, "subscribe", NULL);
			_g_free0 (message_string);
			message_string = _tmp4_;
			break;
		}
		case FEED_READER_OLD_READER_API_OLDREADER_SUBSCRIPTION_ACTION_UNSUBSCRIBE:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = message_string;
			_tmp6_ = g_strconcat (_tmp5_, "unsubscribe", NULL);
			_g_free0 (message_string);
			message_string = _tmp6_;
			break;
		}
		default:
		break;
	}
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = feedID;
		s_collection_length1 = feedID_length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp7_;
			gchar* s = NULL;
			_tmp7_ = g_strdup (s_collection[s_it]);
			s = _tmp7_;
			{
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = message_string;
				_tmp9_ = s;
				_tmp10_ = g_strconcat ("&s=", _tmp9_, NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp8_, _tmp11_, NULL);
				_g_free0 (message_string);
				message_string = _tmp12_;
				_g_free0 (_tmp11_);
				_g_free0 (s);
			}
		}
	}
	if (title != NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = message_string;
		_tmp14_ = g_strconcat ("&t=", title, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
		_g_free0 (message_string);
		message_string = _tmp16_;
		_g_free0 (_tmp15_);
	}
	if (add != NULL) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp17_ = message_string;
		_tmp18_ = g_strconcat ("&a=", add, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
		_g_free0 (message_string);
		message_string = _tmp20_;
		_g_free0 (_tmp19_);
	}
	if (remove != NULL) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = message_string;
		_tmp22_ = g_strconcat ("&r=", remove, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_g_free0 (message_string);
		message_string = _tmp24_;
		_g_free0 (_tmp23_);
	}
	_tmp25_ = self->priv->m_connection;
	_tmp26_ = message_string;
	feed_reader_old_reader_connection_send_post_request (_tmp25_, "subscription/edit?output=json", _tmp26_, &_tmp27_);
	response = _tmp27_;
	_tmp28_ = response;
	result = _tmp28_.status == ((guint) 200);
	feed_reader_response_destroy (&response);
	_g_free0 (message_string);
	return result;
}

static void
feed_reader_old_reader_api_class_init (FeedReaderOldReaderAPIClass * klass,
                                       gpointer klass_data)
{
	feed_reader_old_reader_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderOldReaderAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_old_reader_api_finalize;
}

static void
feed_reader_old_reader_api_instance_init (FeedReaderOldReaderAPI * self,
                                          gpointer klass)
{
	self->priv = feed_reader_old_reader_api_get_instance_private (self);
}

static void
feed_reader_old_reader_api_finalize (GObject * obj)
{
	FeedReaderOldReaderAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_OLD_READER_API, FeedReaderOldReaderAPI);
	_feed_reader_old_reader_connection_unref0 (self->priv->m_connection);
	_g_object_unref0 (self->priv->m_utils);
	_g_free0 (self->priv->m_userID);
	G_OBJECT_CLASS (feed_reader_old_reader_api_parent_class)->finalize (obj);
}

GType
feed_reader_old_reader_api_get_type (void)
{
	return feed_reader_old_reader_api_type_id;
}

GType
feed_reader_old_reader_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderOldReaderAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_old_reader_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderOldReaderAPI), 0, (GInstanceInitFunc) feed_reader_old_reader_api_instance_init, NULL };
	feed_reader_old_reader_api_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderOldReaderAPI", &g_define_type_info, 0);
	FeedReaderOldReaderAPI_private_offset = sizeof (FeedReaderOldReaderAPIPrivate);
	return feed_reader_old_reader_api_type_id;
}

