/* OwncloudNewsAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from OwncloudNewsAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "owncloud.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <json-glib/json-glib.h>
#include <libsoup/soup.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <gee.h>

enum  {
	FEED_READER_OWNCLOUD_NEWS_API_0_PROPERTY,
	FEED_READER_OWNCLOUD_NEWS_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_owncloud_news_api_properties[FEED_READER_OWNCLOUD_NEWS_API_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FeedReaderOwncloudNewsAPIPrivate {
	gchar* m_OwnCloudURL;
	gchar* m_OwnCloudVersion;
	JsonParser* m_parser;
	gchar* m_username;
	gchar* m_password;
	FeedReaderOwncloudNewsUtils* m_utils;
	SoupSession* m_session;
};

static gint FeedReaderOwncloudNewsAPI_private_offset;
static gpointer feed_reader_owncloud_news_api_parent_class = NULL;
static GType feed_reader_owncloud_news_api_type_id = 0;

static void __lambda6_ (FeedReaderOwncloudNewsAPI* self,
                 SoupMessage* msg,
                 SoupAuth* auth,
                 gboolean retrying);
static void ___lambda6__soup_session_authenticate (SoupSession* _sender,
                                            SoupMessage* msg,
                                            SoupAuth* auth,
                                            gboolean retrying,
                                            gpointer self);
static void feed_reader_owncloud_news_api_finalize (GObject * obj);

static inline gpointer
feed_reader_owncloud_news_api_get_instance_private (FeedReaderOwncloudNewsAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderOwncloudNewsAPI_private_offset);
}

static GType
feed_reader_owncloud_news_api_own_cloud_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_FEED, "FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_FEED", "feed"}, {FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_FOLDER, "FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_FOLDER", "folder"}, {FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_STARRED, "FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_STARRED", "starred"}, {FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_ALL, "FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_ALL", "all"}, {0, NULL, NULL}};
	GType feed_reader_owncloud_news_api_own_cloud_type_type_id;
	feed_reader_owncloud_news_api_own_cloud_type_type_id = g_enum_register_static ("FeedReaderOwncloudNewsAPIOwnCloudType", values);
	return feed_reader_owncloud_news_api_own_cloud_type_type_id;
}

GType
feed_reader_owncloud_news_api_own_cloud_type_get_type (void)
{
	static volatile gsize feed_reader_owncloud_news_api_own_cloud_type_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_owncloud_news_api_own_cloud_type_type_id__once)) {
		GType feed_reader_owncloud_news_api_own_cloud_type_type_id;
		feed_reader_owncloud_news_api_own_cloud_type_type_id = feed_reader_owncloud_news_api_own_cloud_type_get_type_once ();
		g_once_init_leave (&feed_reader_owncloud_news_api_own_cloud_type_type_id__once, feed_reader_owncloud_news_api_own_cloud_type_type_id);
	}
	return feed_reader_owncloud_news_api_own_cloud_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (FeedReaderOwncloudNewsAPI* self,
            SoupMessage* msg,
            SoupAuth* auth,
            gboolean retrying)
{
	FeedReaderOwncloudNewsUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (msg != NULL);
	g_return_if_fail (auth != NULL);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_owncloud_news_utils_getHtaccessUser (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		feed_reader_logger_error ("Nextcloud Session: need Authentication");
	} else {
		if (!retrying) {
			FeedReaderOwncloudNewsUtils* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			FeedReaderOwncloudNewsUtils* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = self->priv->m_utils;
			_tmp5_ = feed_reader_owncloud_news_utils_getHtaccessUser (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = self->priv->m_utils;
			_tmp8_ = feed_reader_owncloud_news_utils_getHtaccessPasswd (_tmp7_);
			_tmp9_ = _tmp8_;
			soup_auth_authenticate (auth, _tmp6_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp6_);
		}
	}
}

static void
___lambda6__soup_session_authenticate (SoupSession* _sender,
                                       SoupMessage* msg,
                                       SoupAuth* auth,
                                       gboolean retrying,
                                       gpointer self)
{
	__lambda6_ ((FeedReaderOwncloudNewsAPI*) self, msg, auth, retrying);
}

FeedReaderOwncloudNewsAPI*
feed_reader_owncloud_news_api_construct (GType object_type,
                                         FeedReaderOwncloudNewsUtils* utils)
{
	FeedReaderOwncloudNewsAPI * self = NULL;
	JsonParser* _tmp0_;
	FeedReaderOwncloudNewsUtils* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	SoupSession* _tmp4_;
	SoupSession* _tmp5_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderOwncloudNewsAPI*) g_object_new (object_type, NULL);
	_tmp0_ = json_parser_new ();
	_g_object_unref0 (self->priv->m_parser);
	self->priv->m_parser = _tmp0_;
	_tmp1_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp1_;
	_tmp2_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp2_;
	_tmp3_ = self->priv->m_session;
	g_object_set (_tmp3_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp4_ = self->priv->m_session;
	g_object_set (_tmp4_, "ssl-strict", FALSE, NULL);
	_tmp5_ = self->priv->m_session;
	g_signal_connect_object (_tmp5_, "authenticate", (GCallback) ___lambda6__soup_session_authenticate, self, 0);
	return self;
}

FeedReaderOwncloudNewsAPI*
feed_reader_owncloud_news_api_new (FeedReaderOwncloudNewsUtils* utils)
{
	return feed_reader_owncloud_news_api_construct (FEED_READER_TYPE_OWNCLOUD_NEWS_API, utils);
}

FeedReaderLoginResponse
feed_reader_owncloud_news_api_login (FeedReaderOwncloudNewsAPI* self)
{
	FeedReaderOwncloudNewsUtils* _tmp0_;
	gchar* _tmp1_;
	FeedReaderOwncloudNewsUtils* _tmp2_;
	gchar* _tmp3_;
	FeedReaderOwncloudNewsUtils* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	FeedReaderOwnCloudNewsMessage* _tmp25_;
	FeedReaderOwnCloudNewsMessage* _tmp26_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp27_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_logger_debug ("Nextcloud: login");
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_owncloud_news_utils_getUser (_tmp0_);
	_g_free0 (self->priv->m_username);
	self->priv->m_username = _tmp1_;
	_tmp2_ = self->priv->m_utils;
	_tmp3_ = feed_reader_owncloud_news_utils_getPasswd (_tmp2_);
	_g_free0 (self->priv->m_password);
	self->priv->m_password = _tmp3_;
	_tmp4_ = self->priv->m_utils;
	_tmp5_ = feed_reader_owncloud_news_utils_getURL (_tmp4_);
	_g_free0 (self->priv->m_OwnCloudURL);
	self->priv->m_OwnCloudURL = _tmp5_;
	_tmp8_ = self->priv->m_OwnCloudURL;
	if (g_strcmp0 (_tmp8_, "") == 0) {
		const gchar* _tmp9_;
		_tmp9_ = self->priv->m_username;
		_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->m_password;
		_tmp6_ = g_strcmp0 (_tmp10_, "") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("example-host/nextcloud");
		_g_free0 (self->priv->m_OwnCloudURL);
		self->priv->m_OwnCloudURL = _tmp11_;
		result = FEED_READER_LOGIN_RESPONSE_ALL_EMPTY;
		return result;
	}
	_tmp12_ = self->priv->m_OwnCloudURL;
	if (g_strcmp0 (_tmp12_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_URL;
		return result;
	}
	_tmp13_ = self->priv->m_OwnCloudURL;
	_tmp14_ = g_uri_parse_scheme (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_ == NULL;
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		result = FEED_READER_LOGIN_RESPONSE_INVALID_URL;
		return result;
	}
	_tmp17_ = self->priv->m_username;
	if (g_strcmp0 (_tmp17_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_USER;
		return result;
	}
	_tmp18_ = self->priv->m_password;
	if (g_strcmp0 (_tmp18_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_PASSWD;
		return result;
	}
	_tmp19_ = self->priv->m_session;
	_tmp20_ = self->priv->m_OwnCloudURL;
	_tmp21_ = g_strconcat (_tmp20_, "status", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->m_username;
	_tmp24_ = self->priv->m_password;
	_tmp25_ = feed_reader_own_cloud_news_message_new (_tmp19_, _tmp22_, _tmp23_, _tmp24_, "GET");
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp22_);
	message = _tmp26_;
	_tmp27_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp27_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderOwnCloudNewsMessage* _tmp28_;
		JsonObject* _tmp29_;
		JsonObject* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp28_ = message;
		_tmp29_ = feed_reader_own_cloud_news_message_get_response_object (_tmp28_);
		response = _tmp29_;
		_tmp30_ = response;
		_tmp31_ = json_object_get_string_member (_tmp30_, "version");
		_tmp32_ = g_strdup (_tmp31_);
		_g_free0 (self->priv->m_OwnCloudVersion);
		self->priv->m_OwnCloudVersion = _tmp32_;
		_tmp33_ = self->priv->m_OwnCloudVersion;
		_tmp34_ = g_strdup_printf ("Nextcloud version: %s", _tmp33_);
		_tmp35_ = _tmp34_;
		feed_reader_logger_info (_tmp35_);
		_g_free0 (_tmp35_);
		result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
		_json_object_unref0 (response);
		_g_object_unref0 (message);
		return result;
	} else {
		if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_API_ERROR)) {
			result = FEED_READER_LOGIN_RESPONSE_WRONG_LOGIN;
			_g_object_unref0 (message);
			return result;
		} else {
			if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_NO_RESPONSE)) {
				result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
				_g_object_unref0 (message);
				return result;
			} else {
				if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_CA_ERROR)) {
					result = FEED_READER_LOGIN_RESPONSE_CA_ERROR;
					_g_object_unref0 (message);
					return result;
				} else {
					if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_UNAUTHORIZED)) {
						result = FEED_READER_LOGIN_RESPONSE_UNAUTHORIZED;
						_g_object_unref0 (message);
						return result;
					}
				}
			}
		}
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_owncloud_news_api_isloggedin (FeedReaderOwncloudNewsAPI* self)
{
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FeedReaderOwnCloudNewsMessage* _tmp6_;
	FeedReaderOwnCloudNewsMessage* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->m_OwnCloudURL;
	_tmp2_ = g_strconcat (_tmp1_, "version", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->m_username;
	_tmp5_ = self->priv->m_password;
	_tmp6_ = feed_reader_own_cloud_news_message_new (_tmp0_, _tmp3_, _tmp4_, _tmp5_, "GET");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	message = _tmp7_;
	_tmp8_ = message;
	if (feed_reader_own_cloud_news_message_send (_tmp8_, FALSE) == FEED_READER_CONNECTION_ERROR_SUCCESS) {
		result = TRUE;
		_g_object_unref0 (message);
		return result;
	}
	feed_reader_logger_error ("OwncloudNewsAPI.isloggedin: not logged in");
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

gboolean
feed_reader_owncloud_news_api_getFeeds (FeedReaderOwncloudNewsAPI* self,
                                        GeeList* feeds)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	if (feed_reader_owncloud_news_api_isloggedin (self)) {
		FeedReaderOwnCloudNewsMessage* message = NULL;
		SoupSession* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		FeedReaderOwnCloudNewsMessage* _tmp6_;
		FeedReaderOwnCloudNewsMessage* _tmp7_;
		gint _error_ = 0;
		FeedReaderOwnCloudNewsMessage* _tmp8_;
		_tmp0_ = self->priv->m_session;
		_tmp1_ = self->priv->m_OwnCloudURL;
		_tmp2_ = g_strconcat (_tmp1_, "feeds", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->m_username;
		_tmp5_ = self->priv->m_password;
		_tmp6_ = feed_reader_own_cloud_news_message_new (_tmp0_, _tmp3_, _tmp4_, _tmp5_, "GET");
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp3_);
		message = _tmp7_;
		_tmp8_ = message;
		_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp8_, FALSE);
		if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
			JsonObject* response = NULL;
			FeedReaderOwnCloudNewsMessage* _tmp9_;
			JsonObject* _tmp10_;
			JsonObject* _tmp11_;
			_tmp9_ = message;
			_tmp10_ = feed_reader_own_cloud_news_message_get_response_object (_tmp9_);
			response = _tmp10_;
			_tmp11_ = response;
			if (json_object_has_member (_tmp11_, "feeds")) {
				JsonArray* feed_array = NULL;
				JsonObject* _tmp12_;
				JsonArray* _tmp13_;
				JsonArray* _tmp14_;
				guint feed_count = 0U;
				JsonArray* _tmp15_;
				_tmp12_ = response;
				_tmp13_ = json_object_get_array_member (_tmp12_, "feeds");
				_tmp14_ = _json_array_ref0 (_tmp13_);
				feed_array = _tmp14_;
				_tmp15_ = feed_array;
				feed_count = json_array_get_length (_tmp15_);
				{
					guint i = 0U;
					i = (guint) 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							JsonObject* feed_node = NULL;
							JsonArray* _tmp18_;
							JsonObject* _tmp19_;
							JsonObject* _tmp20_;
							JsonObject* _tmp21_;
							gchar* _tmp22_;
							gchar* _tmp23_;
							JsonObject* _tmp24_;
							const gchar* _tmp25_;
							JsonObject* _tmp26_;
							const gchar* _tmp27_;
							JsonObject* _tmp28_;
							JsonObject* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							GeeList* _tmp32_;
							GeeList* _tmp33_;
							JsonObject* _tmp34_;
							const gchar* _tmp35_;
							FeedReaderFeed* _tmp36_;
							FeedReaderFeed* _tmp37_;
							if (!_tmp16_) {
								guint _tmp17_;
								_tmp17_ = i;
								i = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							if (!(i < feed_count)) {
								break;
							}
							_tmp18_ = feed_array;
							_tmp19_ = json_array_get_object_element (_tmp18_, i);
							_tmp20_ = _json_object_ref0 (_tmp19_);
							feed_node = _tmp20_;
							_tmp21_ = feed_node;
							_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp21_, "id"));
							_tmp23_ = _tmp22_;
							_tmp24_ = feed_node;
							_tmp25_ = json_object_get_string_member (_tmp24_, "title");
							_tmp26_ = feed_node;
							_tmp27_ = json_object_get_string_member (_tmp26_, "link");
							_tmp28_ = feed_node;
							_tmp29_ = feed_node;
							_tmp30_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp29_, "folderId"));
							_tmp31_ = _tmp30_;
							_tmp32_ = feed_reader_list_utils_single (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = feed_node;
							_tmp35_ = json_object_get_string_member (_tmp34_, "faviconLink");
							_tmp36_ = feed_reader_feed_new (_tmp23_, _tmp25_, _tmp27_, (guint) ((gint) json_object_get_int_member (_tmp28_, "unreadCount")), _tmp33_, _tmp35_, NULL);
							_tmp37_ = _tmp36_;
							gee_collection_add ((GeeCollection*) feeds, _tmp37_);
							_g_object_unref0 (_tmp37_);
							_g_object_unref0 (_tmp33_);
							_g_free0 (_tmp31_);
							_g_free0 (_tmp23_);
							_json_object_unref0 (feed_node);
						}
					}
				}
				result = TRUE;
				_json_array_unref0 (feed_array);
				_json_object_unref0 (response);
				_g_object_unref0 (message);
				return result;
			} else {
				feed_reader_logger_error ("OwncloudNewsAPI.getFeeds: no member \"feeds\"");
			}
			_json_object_unref0 (response);
		} else {
			feed_reader_logger_error ("OwncloudNewsAPI.getFeeds");
		}
		_g_object_unref0 (message);
	}
	result = FALSE;
	return result;
}

gboolean
feed_reader_owncloud_news_api_getCategories (FeedReaderOwncloudNewsAPI* self,
                                             GeeList* categories,
                                             GeeList* feeds)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	if (feed_reader_owncloud_news_api_isloggedin (self)) {
		FeedReaderOwnCloudNewsMessage* message = NULL;
		SoupSession* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		FeedReaderOwnCloudNewsMessage* _tmp6_;
		FeedReaderOwnCloudNewsMessage* _tmp7_;
		gint _error_ = 0;
		FeedReaderOwnCloudNewsMessage* _tmp8_;
		gint orderID = 0;
		_tmp0_ = self->priv->m_session;
		_tmp1_ = self->priv->m_OwnCloudURL;
		_tmp2_ = g_strconcat (_tmp1_, "folders", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->m_username;
		_tmp5_ = self->priv->m_password;
		_tmp6_ = feed_reader_own_cloud_news_message_new (_tmp0_, _tmp3_, _tmp4_, _tmp5_, "GET");
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp3_);
		message = _tmp7_;
		_tmp8_ = message;
		_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp8_, FALSE);
		orderID = 0;
		if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
			JsonObject* response = NULL;
			FeedReaderOwnCloudNewsMessage* _tmp9_;
			JsonObject* _tmp10_;
			JsonObject* _tmp11_;
			_tmp9_ = message;
			_tmp10_ = feed_reader_own_cloud_news_message_get_response_object (_tmp9_);
			response = _tmp10_;
			_tmp11_ = response;
			if (json_object_has_member (_tmp11_, "folders")) {
				JsonArray* folder_array = NULL;
				JsonObject* _tmp12_;
				JsonArray* _tmp13_;
				JsonArray* _tmp14_;
				guint folder_count = 0U;
				JsonArray* _tmp15_;
				_tmp12_ = response;
				_tmp13_ = json_object_get_array_member (_tmp12_, "folders");
				_tmp14_ = _json_array_ref0 (_tmp13_);
				folder_array = _tmp14_;
				_tmp15_ = folder_array;
				folder_count = json_array_get_length (_tmp15_);
				{
					guint i = 0U;
					i = (guint) 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp18_;
							JsonObject* folder_node = NULL;
							JsonArray* _tmp19_;
							JsonObject* _tmp20_;
							JsonObject* _tmp21_;
							gchar* id = NULL;
							JsonObject* _tmp22_;
							gchar* _tmp23_;
							const gchar* _tmp24_;
							JsonObject* _tmp25_;
							const gchar* _tmp26_;
							FeedReaderOwncloudNewsUtils* _tmp27_;
							const gchar* _tmp28_;
							gchar* _tmp29_;
							gchar* _tmp30_;
							FeedReaderCategory* _tmp31_;
							FeedReaderCategory* _tmp32_;
							if (!_tmp16_) {
								guint _tmp17_;
								_tmp17_ = i;
								i = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							if (!(i < folder_count)) {
								break;
							}
							orderID = orderID + 1;
							_tmp18_ = orderID;
							_tmp19_ = folder_array;
							_tmp20_ = json_array_get_object_element (_tmp19_, i);
							_tmp21_ = _json_object_ref0 (_tmp20_);
							folder_node = _tmp21_;
							_tmp22_ = folder_node;
							_tmp23_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp22_, "id"));
							id = _tmp23_;
							_tmp24_ = id;
							_tmp25_ = folder_node;
							_tmp26_ = json_object_get_string_member (_tmp25_, "name");
							_tmp27_ = self->priv->m_utils;
							_tmp28_ = id;
							_tmp29_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
							_tmp30_ = _tmp29_;
							_tmp31_ = feed_reader_category_new (_tmp24_, _tmp26_, (guint) feed_reader_owncloud_news_utils_countUnread (_tmp27_, feeds, _tmp28_), orderID, _tmp30_, 1);
							_tmp32_ = _tmp31_;
							gee_collection_add ((GeeCollection*) categories, _tmp32_);
							_g_object_unref0 (_tmp32_);
							_g_free0 (_tmp30_);
							_g_free0 (id);
							_json_object_unref0 (folder_node);
						}
					}
				}
				result = TRUE;
				_json_array_unref0 (folder_array);
				_json_object_unref0 (response);
				_g_object_unref0 (message);
				return result;
			} else {
				feed_reader_logger_error ("OwncloudNewsAPI.getCategories: no member \"folders\"");
			}
			_json_object_unref0 (response);
		} else {
			feed_reader_logger_error ("OwncloudNewsAPI.getCategories");
		}
		_g_object_unref0 (message);
	}
	result = FALSE;
	return result;
}

void
feed_reader_owncloud_news_api_getNewArticles (FeedReaderOwncloudNewsAPI* self,
                                              GeeList* articles,
                                              gint lastModified,
                                              FeedReaderOwncloudNewsAPIOwnCloudType type,
                                              gint id)
{
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FeedReaderOwnCloudNewsMessage* _tmp6_;
	FeedReaderOwnCloudNewsMessage* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->m_OwnCloudURL;
	_tmp2_ = g_strconcat (_tmp1_, "items/updated", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->m_username;
	_tmp5_ = self->priv->m_password;
	_tmp6_ = feed_reader_own_cloud_news_message_new (_tmp0_, _tmp3_, _tmp4_, _tmp5_, "GET");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	message = _tmp7_;
	_tmp8_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp8_, "lastModified", lastModified);
	_tmp9_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp9_, "type", (gint) type);
	_tmp10_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp10_, "id", id);
	_tmp11_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp11_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderOwnCloudNewsMessage* _tmp12_;
		JsonObject* _tmp13_;
		JsonObject* _tmp14_;
		_tmp12_ = message;
		_tmp13_ = feed_reader_own_cloud_news_message_get_response_object (_tmp12_);
		response = _tmp13_;
		_tmp14_ = response;
		if (json_object_has_member (_tmp14_, "items")) {
			JsonArray* article_array = NULL;
			JsonObject* _tmp15_;
			JsonArray* _tmp16_;
			JsonArray* _tmp17_;
			guint article_count = 0U;
			JsonArray* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = response;
			_tmp16_ = json_object_get_array_member (_tmp15_, "items");
			_tmp17_ = _json_array_ref0 (_tmp16_);
			article_array = _tmp17_;
			_tmp18_ = article_array;
			article_count = json_array_get_length (_tmp18_);
			_tmp19_ = g_strdup_printf ("getNewArticles: %u articles returned", article_count);
			_tmp20_ = _tmp19_;
			feed_reader_logger_debug (_tmp20_);
			_g_free0 (_tmp20_);
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp21_ = FALSE;
					_tmp21_ = TRUE;
					while (TRUE) {
						JsonObject* article_node = NULL;
						JsonArray* _tmp23_;
						JsonObject* _tmp24_;
						JsonObject* _tmp25_;
						FeedReaderArticleStatus _tmp26_ = 0;
						JsonObject* _tmp27_;
						FeedReaderArticleStatus unread = 0;
						FeedReaderArticleStatus _tmp28_ = 0;
						JsonObject* _tmp29_;
						FeedReaderArticleStatus marked = 0;
						GeeArrayList* enclosures = NULL;
						GeeArrayList* _tmp30_;
						gboolean _tmp31_ = FALSE;
						JsonObject* _tmp32_;
						FeedReaderArticle* Article = NULL;
						JsonObject* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						JsonObject* _tmp52_;
						const gchar* _tmp53_;
						JsonObject* _tmp54_;
						const gchar* _tmp55_;
						JsonObject* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						JsonObject* _tmp59_;
						const gchar* _tmp60_;
						JsonObject* _tmp61_;
						const gchar* _tmp62_;
						JsonObject* _tmp63_;
						GDateTime* _tmp64_;
						GDateTime* _tmp65_;
						GeeArrayList* _tmp66_;
						JsonObject* _tmp67_;
						const gchar* _tmp68_;
						JsonObject* _tmp69_;
						FeedReaderArticle* _tmp70_;
						FeedReaderArticle* _tmp71_;
						FeedReaderArticle* _tmp72_;
						if (!_tmp21_) {
							guint _tmp22_;
							_tmp22_ = i;
							i = _tmp22_ + 1;
						}
						_tmp21_ = FALSE;
						if (!(i < article_count)) {
							break;
						}
						_tmp23_ = article_array;
						_tmp24_ = json_array_get_object_element (_tmp23_, i);
						_tmp25_ = _json_object_ref0 (_tmp24_);
						article_node = _tmp25_;
						_tmp27_ = article_node;
						if (json_object_get_boolean_member (_tmp27_, "unread")) {
							_tmp26_ = FEED_READER_ARTICLE_STATUS_UNREAD;
						} else {
							_tmp26_ = FEED_READER_ARTICLE_STATUS_READ;
						}
						unread = _tmp26_;
						_tmp29_ = article_node;
						if (json_object_get_boolean_member (_tmp29_, "starred")) {
							_tmp28_ = FEED_READER_ARTICLE_STATUS_MARKED;
						} else {
							_tmp28_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
						}
						marked = _tmp28_;
						_tmp30_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						enclosures = _tmp30_;
						_tmp32_ = article_node;
						if (json_object_has_member (_tmp32_, "enclosureLink")) {
							JsonObject* _tmp33_;
							const gchar* _tmp34_;
							_tmp33_ = article_node;
							_tmp34_ = json_object_get_string_member (_tmp33_, "enclosureLink");
							_tmp31_ = _tmp34_ != NULL;
						} else {
							_tmp31_ = FALSE;
						}
						if (_tmp31_) {
							gboolean _tmp35_ = FALSE;
							JsonObject* _tmp36_;
							_tmp36_ = article_node;
							if (json_object_has_member (_tmp36_, "enclosureMime")) {
								JsonObject* _tmp37_;
								const gchar* _tmp38_;
								_tmp37_ = article_node;
								_tmp38_ = json_object_get_string_member (_tmp37_, "enclosureMime");
								_tmp35_ = _tmp38_ != NULL;
							} else {
								_tmp35_ = FALSE;
							}
							if (_tmp35_) {
								GeeArrayList* _tmp39_;
								JsonObject* _tmp40_;
								gchar* _tmp41_;
								gchar* _tmp42_;
								JsonObject* _tmp43_;
								const gchar* _tmp44_;
								JsonObject* _tmp45_;
								const gchar* _tmp46_;
								FeedReaderEnclosure* _tmp47_;
								FeedReaderEnclosure* _tmp48_;
								_tmp39_ = enclosures;
								_tmp40_ = article_node;
								_tmp41_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp40_, "id"));
								_tmp42_ = _tmp41_;
								_tmp43_ = article_node;
								_tmp44_ = json_object_get_string_member (_tmp43_, "enclosureLink");
								_tmp45_ = article_node;
								_tmp46_ = json_object_get_string_member (_tmp45_, "enclosureMime");
								_tmp47_ = feed_reader_enclosure_new (_tmp42_, _tmp44_, feed_reader_enclosure_type_from_string (_tmp46_));
								_tmp48_ = _tmp47_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp48_);
								_g_object_unref0 (_tmp48_);
								_g_free0 (_tmp42_);
							}
						}
						_tmp49_ = article_node;
						_tmp50_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp49_, "id"));
						_tmp51_ = _tmp50_;
						_tmp52_ = article_node;
						_tmp53_ = json_object_get_string_member (_tmp52_, "title");
						_tmp54_ = article_node;
						_tmp55_ = json_object_get_string_member (_tmp54_, "url");
						_tmp56_ = article_node;
						_tmp57_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp56_, "feedId"));
						_tmp58_ = _tmp57_;
						_tmp59_ = article_node;
						_tmp60_ = json_object_get_string_member (_tmp59_, "body");
						_tmp61_ = article_node;
						_tmp62_ = json_object_get_string_member (_tmp61_, "author");
						_tmp63_ = article_node;
						_tmp64_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp63_, "pubDate"));
						_tmp65_ = _tmp64_;
						_tmp66_ = enclosures;
						_tmp67_ = article_node;
						_tmp68_ = json_object_get_string_member (_tmp67_, "guidHash");
						_tmp69_ = article_node;
						_tmp70_ = feed_reader_article_new (_tmp51_, _tmp53_, _tmp55_, _tmp58_, unread, marked, _tmp60_, NULL, _tmp62_, _tmp65_, -1, NULL, (GeeList*) _tmp66_, _tmp68_, (gint) json_object_get_int_member (_tmp69_, "lastModified"));
						_tmp71_ = _tmp70_;
						_g_date_time_unref0 (_tmp65_);
						_g_free0 (_tmp58_);
						_g_free0 (_tmp51_);
						Article = _tmp71_;
						_tmp72_ = Article;
						gee_collection_add ((GeeCollection*) articles, _tmp72_);
						_g_object_unref0 (Article);
						_g_object_unref0 (enclosures);
						_json_object_unref0 (article_node);
					}
				}
			}
			_json_array_unref0 (article_array);
		} else {
			feed_reader_logger_error ("OwncloudNewsAPI.getNewArticles: no member \"items\"");
		}
		_json_object_unref0 (response);
	} else {
		feed_reader_logger_error ("OwncloudNewsAPI.getNewArticles");
	}
	_g_object_unref0 (message);
}

void
feed_reader_owncloud_news_api_getArticles (FeedReaderOwncloudNewsAPI* self,
                                           GeeList* articles,
                                           gint skip,
                                           gint count,
                                           gboolean read,
                                           FeedReaderOwncloudNewsAPIOwnCloudType type,
                                           gint id)
{
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FeedReaderOwnCloudNewsMessage* _tmp6_;
	FeedReaderOwnCloudNewsMessage* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	FeedReaderOwnCloudNewsMessage* _tmp12_;
	FeedReaderOwnCloudNewsMessage* _tmp13_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->m_OwnCloudURL;
	_tmp2_ = g_strconcat (_tmp1_, "items", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->m_username;
	_tmp5_ = self->priv->m_password;
	_tmp6_ = feed_reader_own_cloud_news_message_new (_tmp0_, _tmp3_, _tmp4_, _tmp5_, "GET");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	message = _tmp7_;
	_tmp8_ = message;
	feed_reader_own_cloud_news_message_add_bool (_tmp8_, "oldestFirst", FALSE);
	_tmp9_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp9_, "type", (gint) type);
	_tmp10_ = message;
	feed_reader_own_cloud_news_message_add_bool (_tmp10_, "getRead", read);
	_tmp11_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp11_, "id", id);
	_tmp12_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp12_, "offset", skip);
	_tmp13_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp13_, "batchSize", count);
	_tmp14_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp14_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderOwnCloudNewsMessage* _tmp15_;
		JsonObject* _tmp16_;
		JsonObject* _tmp17_;
		_tmp15_ = message;
		_tmp16_ = feed_reader_own_cloud_news_message_get_response_object (_tmp15_);
		response = _tmp16_;
		_tmp17_ = response;
		if (json_object_has_member (_tmp17_, "items")) {
			JsonArray* article_array = NULL;
			JsonObject* _tmp18_;
			JsonArray* _tmp19_;
			JsonArray* _tmp20_;
			guint article_count = 0U;
			JsonArray* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = response;
			_tmp19_ = json_object_get_array_member (_tmp18_, "items");
			_tmp20_ = _json_array_ref0 (_tmp19_);
			article_array = _tmp20_;
			_tmp21_ = article_array;
			article_count = json_array_get_length (_tmp21_);
			_tmp22_ = g_strdup_printf ("getArticles: %u articles returned", article_count);
			_tmp23_ = _tmp22_;
			feed_reader_logger_debug (_tmp23_);
			_g_free0 (_tmp23_);
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp24_ = FALSE;
					_tmp24_ = TRUE;
					while (TRUE) {
						JsonObject* article_node = NULL;
						JsonArray* _tmp26_;
						JsonObject* _tmp27_;
						JsonObject* _tmp28_;
						FeedReaderArticleStatus _tmp29_ = 0;
						JsonObject* _tmp30_;
						FeedReaderArticleStatus unread = 0;
						FeedReaderArticleStatus _tmp31_ = 0;
						JsonObject* _tmp32_;
						FeedReaderArticleStatus marked = 0;
						GeeArrayList* enclosures = NULL;
						GeeArrayList* _tmp33_;
						gboolean _tmp34_ = FALSE;
						JsonObject* _tmp35_;
						FeedReaderArticle* Article = NULL;
						JsonObject* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						JsonObject* _tmp55_;
						const gchar* _tmp56_;
						JsonObject* _tmp57_;
						const gchar* _tmp58_;
						JsonObject* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						JsonObject* _tmp62_;
						const gchar* _tmp63_;
						JsonObject* _tmp64_;
						const gchar* _tmp65_;
						JsonObject* _tmp66_;
						GDateTime* _tmp67_;
						GDateTime* _tmp68_;
						GeeArrayList* _tmp69_;
						JsonObject* _tmp70_;
						const gchar* _tmp71_;
						JsonObject* _tmp72_;
						FeedReaderArticle* _tmp73_;
						FeedReaderArticle* _tmp74_;
						FeedReaderArticle* _tmp75_;
						if (!_tmp24_) {
							guint _tmp25_;
							_tmp25_ = i;
							i = _tmp25_ + 1;
						}
						_tmp24_ = FALSE;
						if (!(i < article_count)) {
							break;
						}
						_tmp26_ = article_array;
						_tmp27_ = json_array_get_object_element (_tmp26_, i);
						_tmp28_ = _json_object_ref0 (_tmp27_);
						article_node = _tmp28_;
						_tmp30_ = article_node;
						if (json_object_get_boolean_member (_tmp30_, "unread")) {
							_tmp29_ = FEED_READER_ARTICLE_STATUS_UNREAD;
						} else {
							_tmp29_ = FEED_READER_ARTICLE_STATUS_READ;
						}
						unread = _tmp29_;
						_tmp32_ = article_node;
						if (json_object_get_boolean_member (_tmp32_, "starred")) {
							_tmp31_ = FEED_READER_ARTICLE_STATUS_MARKED;
						} else {
							_tmp31_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
						}
						marked = _tmp31_;
						_tmp33_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						enclosures = _tmp33_;
						_tmp35_ = article_node;
						if (json_object_has_member (_tmp35_, "enclosureLink")) {
							JsonObject* _tmp36_;
							const gchar* _tmp37_;
							_tmp36_ = article_node;
							_tmp37_ = json_object_get_string_member (_tmp36_, "enclosureLink");
							_tmp34_ = _tmp37_ != NULL;
						} else {
							_tmp34_ = FALSE;
						}
						if (_tmp34_) {
							gboolean _tmp38_ = FALSE;
							JsonObject* _tmp39_;
							_tmp39_ = article_node;
							if (json_object_has_member (_tmp39_, "enclosureMime")) {
								JsonObject* _tmp40_;
								const gchar* _tmp41_;
								_tmp40_ = article_node;
								_tmp41_ = json_object_get_string_member (_tmp40_, "enclosureMime");
								_tmp38_ = _tmp41_ != NULL;
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								GeeArrayList* _tmp42_;
								JsonObject* _tmp43_;
								gchar* _tmp44_;
								gchar* _tmp45_;
								JsonObject* _tmp46_;
								const gchar* _tmp47_;
								JsonObject* _tmp48_;
								const gchar* _tmp49_;
								FeedReaderEnclosure* _tmp50_;
								FeedReaderEnclosure* _tmp51_;
								_tmp42_ = enclosures;
								_tmp43_ = article_node;
								_tmp44_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp43_, "id"));
								_tmp45_ = _tmp44_;
								_tmp46_ = article_node;
								_tmp47_ = json_object_get_string_member (_tmp46_, "enclosureLink");
								_tmp48_ = article_node;
								_tmp49_ = json_object_get_string_member (_tmp48_, "enclosureMime");
								_tmp50_ = feed_reader_enclosure_new (_tmp45_, _tmp47_, feed_reader_enclosure_type_from_string (_tmp49_));
								_tmp51_ = _tmp50_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp51_);
								_g_object_unref0 (_tmp51_);
								_g_free0 (_tmp45_);
							}
						}
						_tmp52_ = article_node;
						_tmp53_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp52_, "id"));
						_tmp54_ = _tmp53_;
						_tmp55_ = article_node;
						_tmp56_ = json_object_get_string_member (_tmp55_, "title");
						_tmp57_ = article_node;
						_tmp58_ = json_object_get_string_member (_tmp57_, "url");
						_tmp59_ = article_node;
						_tmp60_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp59_, "feedId"));
						_tmp61_ = _tmp60_;
						_tmp62_ = article_node;
						_tmp63_ = json_object_get_string_member (_tmp62_, "body");
						_tmp64_ = article_node;
						_tmp65_ = json_object_get_string_member (_tmp64_, "author");
						_tmp66_ = article_node;
						_tmp67_ = g_date_time_new_from_unix_local (json_object_get_int_member (_tmp66_, "pubDate"));
						_tmp68_ = _tmp67_;
						_tmp69_ = enclosures;
						_tmp70_ = article_node;
						_tmp71_ = json_object_get_string_member (_tmp70_, "guidHash");
						_tmp72_ = article_node;
						_tmp73_ = feed_reader_article_new (_tmp54_, _tmp56_, _tmp58_, _tmp61_, unread, marked, _tmp63_, NULL, _tmp65_, _tmp68_, -1, NULL, (GeeList*) _tmp69_, _tmp71_, (gint) json_object_get_int_member (_tmp72_, "lastModified"));
						_tmp74_ = _tmp73_;
						_g_date_time_unref0 (_tmp68_);
						_g_free0 (_tmp61_);
						_g_free0 (_tmp54_);
						Article = _tmp74_;
						_tmp75_ = Article;
						gee_collection_add ((GeeCollection*) articles, _tmp75_);
						_g_object_unref0 (Article);
						_g_object_unref0 (enclosures);
						_json_object_unref0 (article_node);
					}
				}
			}
			_json_array_unref0 (article_array);
		} else {
			feed_reader_logger_error ("OwncloudNewsAPI.getArticles: no member \"items\"");
		}
		_json_object_unref0 (response);
	} else {
		feed_reader_logger_error ("OwncloudNewsAPI.getArticles");
	}
	_g_object_unref0 (message);
}

gboolean
feed_reader_owncloud_news_api_markFeedRead (FeedReaderOwncloudNewsAPI* self,
                                            const gchar* feedID,
                                            gboolean isCatID)
{
	const gchar* _tmp0_ = NULL;
	gchar* url = NULL;
	gchar* _tmp1_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	FeedReaderDataBaseReadOnly* _tmp12_;
	FeedReaderDataBaseReadOnly* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feedID != NULL, FALSE);
	if (isCatID) {
		_tmp0_ = "folders";
	} else {
		_tmp0_ = "feeds";
	}
	_tmp1_ = g_strdup_printf ("%s/%s/read", _tmp0_, feedID);
	url = _tmp1_;
	_tmp2_ = self->priv->m_session;
	_tmp3_ = self->priv->m_OwnCloudURL;
	_tmp4_ = url;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->m_username;
	_tmp8_ = self->priv->m_password;
	_tmp9_ = feed_reader_own_cloud_news_message_new (_tmp2_, _tmp6_, _tmp7_, _tmp8_, "PUT");
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp6_);
	message = _tmp10_;
	_tmp11_ = message;
	_tmp12_ = feed_reader_data_base_readOnly ();
	_tmp13_ = _tmp12_;
	_tmp14_ = feed_reader_data_base_read_only_getNewestArticle (_tmp13_);
	_tmp15_ = _tmp14_;
	feed_reader_own_cloud_news_message_add_int (_tmp11_, "newestItemId", atoi (_tmp15_));
	_g_free0 (_tmp15_);
	_g_object_unref0 (_tmp13_);
	_tmp16_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp16_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		result = TRUE;
		_g_object_unref0 (message);
		_g_free0 (url);
		return result;
	}
	feed_reader_logger_error ("OwncloudNewsAPI.markFeedRead");
	result = FALSE;
	_g_object_unref0 (message);
	_g_free0 (url);
	return result;
}

gboolean
feed_reader_owncloud_news_api_markAllItemsRead (FeedReaderOwncloudNewsAPI* self)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	FeedReaderDataBaseReadOnly* _tmp11_;
	FeedReaderDataBaseReadOnly* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("items/read");
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "PUT");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	_tmp10_ = message;
	_tmp11_ = feed_reader_data_base_readOnly ();
	_tmp12_ = _tmp11_;
	_tmp13_ = feed_reader_data_base_read_only_getNewestArticle (_tmp12_);
	_tmp14_ = _tmp13_;
	feed_reader_own_cloud_news_message_add_int (_tmp10_, "newestItemId", atoi (_tmp14_));
	_g_free0 (_tmp14_);
	_g_object_unref0 (_tmp12_);
	_tmp15_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp15_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		result = TRUE;
		_g_object_unref0 (message);
		_g_free0 (url);
		return result;
	}
	feed_reader_logger_error ("OwncloudNewsAPI.markAllItemsRead");
	result = FALSE;
	_g_object_unref0 (message);
	_g_free0 (url);
	return result;
}

gboolean
feed_reader_owncloud_news_api_updateArticleUnread (FeedReaderOwncloudNewsAPI* self,
                                                   const gchar* articleIDs,
                                                   FeedReaderArticleStatus unread)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	FeedReaderOwnCloudNewsMessage* _tmp12_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (articleIDs != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	url = _tmp0_;
	if (unread == FEED_READER_ARTICLE_STATUS_UNREAD) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("items/unread/multiple");
		_g_free0 (url);
		url = _tmp1_;
	} else {
		if (unread == FEED_READER_ARTICLE_STATUS_READ) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("items/read/multiple");
			_g_free0 (url);
			url = _tmp2_;
		}
	}
	_tmp3_ = self->priv->m_session;
	_tmp4_ = self->priv->m_OwnCloudURL;
	_tmp5_ = url;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->m_username;
	_tmp9_ = self->priv->m_password;
	_tmp10_ = feed_reader_own_cloud_news_message_new (_tmp3_, _tmp7_, _tmp8_, _tmp9_, "PUT");
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp7_);
	message = _tmp11_;
	_tmp12_ = message;
	feed_reader_own_cloud_news_message_add_int_array (_tmp12_, "items", articleIDs);
	_tmp13_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp13_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		result = TRUE;
		_g_object_unref0 (message);
		_g_free0 (url);
		return result;
	}
	feed_reader_logger_error ("OwncloudNewsAPI.updateArticleUnread");
	result = FALSE;
	_g_object_unref0 (message);
	_g_free0 (url);
	return result;
}

gboolean
feed_reader_owncloud_news_api_updateArticleMarked (FeedReaderOwncloudNewsAPI* self,
                                                   const gchar* articleID,
                                                   FeedReaderArticleStatus marked)
{
	FeedReaderArticle* article = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	FeedReaderArticle* _tmp2_;
	FeedReaderArticle* _tmp3_;
	gchar* url = NULL;
	FeedReaderArticle* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FeedReaderArticle* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	FeedReaderOwnCloudNewsMessage* _tmp23_;
	FeedReaderOwnCloudNewsMessage* _tmp24_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (articleID != NULL, FALSE);
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_read_article (_tmp1_, articleID);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	article = _tmp3_;
	_tmp4_ = article;
	_tmp5_ = feed_reader_article_getFeedID (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = article;
	_tmp8_ = feed_reader_article_getHash (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("items/%s/%s/", _tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	url = _tmp11_;
	if (marked == FEED_READER_ARTICLE_STATUS_MARKED) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = url;
		_tmp13_ = g_strconcat (_tmp12_, "star", NULL);
		_g_free0 (url);
		url = _tmp13_;
	} else {
		if (marked == FEED_READER_ARTICLE_STATUS_UNMARKED) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = url;
			_tmp15_ = g_strconcat (_tmp14_, "unstar", NULL);
			_g_free0 (url);
			url = _tmp15_;
		}
	}
	_tmp16_ = self->priv->m_session;
	_tmp17_ = self->priv->m_OwnCloudURL;
	_tmp18_ = url;
	_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->m_username;
	_tmp22_ = self->priv->m_password;
	_tmp23_ = feed_reader_own_cloud_news_message_new (_tmp16_, _tmp20_, _tmp21_, _tmp22_, "PUT");
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp20_);
	message = _tmp24_;
	_tmp25_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp25_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		result = TRUE;
		_g_object_unref0 (message);
		_g_free0 (url);
		_g_object_unref0 (article);
		return result;
	}
	feed_reader_logger_error ("OwncloudNewsAPI.updateArticleMarked");
	result = FALSE;
	_g_object_unref0 (message);
	_g_free0 (url);
	_g_object_unref0 (article);
	return result;
}

gboolean
feed_reader_owncloud_news_api_addFeed (FeedReaderOwncloudNewsAPI* self,
                                       const gchar* feedURL,
                                       const gchar* catID,
                                       gint64* feedID,
                                       gchar** errmsg)
{
	gint64 _vala_feedID = 0LL;
	gchar* _vala_errmsg = NULL;
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	gint _tmp11_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp12_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp13_;
	gchar* _tmp21_;
	FeedReaderOwnCloudNewsMessage* _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feedURL != NULL, FALSE);
	_tmp0_ = g_strdup ("feeds");
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "POST");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	_tmp10_ = message;
	feed_reader_own_cloud_news_message_add_string (_tmp10_, "url", feedURL);
	if (catID != NULL) {
		_tmp11_ = atoi (catID);
	} else {
		_tmp11_ = 0;
	}
	_tmp12_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp12_, "folderId", _tmp11_);
	_tmp13_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp13_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderOwnCloudNewsMessage* _tmp14_;
		JsonObject* _tmp15_;
		JsonObject* _tmp16_;
		_tmp14_ = message;
		_tmp15_ = feed_reader_own_cloud_news_message_get_response_object (_tmp14_);
		response = _tmp15_;
		_tmp16_ = response;
		if (json_object_has_member (_tmp16_, "feeds")) {
			gchar* _tmp17_;
			JsonObject* _tmp18_;
			JsonArray* _tmp19_;
			JsonObject* _tmp20_;
			_tmp17_ = g_strdup ("");
			_g_free0 (_vala_errmsg);
			_vala_errmsg = _tmp17_;
			_tmp18_ = response;
			_tmp19_ = json_object_get_array_member (_tmp18_, "feeds");
			_tmp20_ = json_array_get_object_element (_tmp19_, (guint) 0);
			_vala_feedID = json_object_get_int_member (_tmp20_, "id");
			result = TRUE;
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			_g_free0 (url);
			if (feedID) {
				*feedID = _vala_feedID;
			}
			if (errmsg) {
				*errmsg = _vala_errmsg;
			} else {
				_g_free0 (_vala_errmsg);
			}
			return result;
		}
		_json_object_unref0 (response);
	} else {
		feed_reader_logger_error ("OwncloudNewsAPI.addFeed");
	}
	_tmp21_ = g_strdup ("Nextcloud could not add the feed");
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp21_;
	_vala_feedID = (gint64) 0;
	_tmp22_ = message;
	switch (feed_reader_own_cloud_news_message_getStatusCode (_tmp22_)) {
		case 409:
		{
			gchar* _tmp23_;
			_tmp23_ = g_strdup ("Feed already added (409)");
			_g_free0 (_vala_errmsg);
			_vala_errmsg = _tmp23_;
			result = TRUE;
			_g_object_unref0 (message);
			_g_free0 (url);
			if (feedID) {
				*feedID = _vala_feedID;
			}
			if (errmsg) {
				*errmsg = _vala_errmsg;
			} else {
				_g_free0 (_vala_errmsg);
			}
			return result;
		}
		case 422:
		{
			gchar* _tmp24_;
			_tmp24_ = g_strdup ("Nextcloud can't read the feed (422)");
			_g_free0 (_vala_errmsg);
			_vala_errmsg = _tmp24_;
			break;
		}
		default:
		break;
	}
	result = FALSE;
	_g_object_unref0 (message);
	_g_free0 (url);
	if (feedID) {
		*feedID = _vala_feedID;
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
feed_reader_owncloud_news_api_removeFeed (FeedReaderOwncloudNewsAPI* self,
                                          const gchar* feedID)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = g_strdup_printf ("feeds/%s", feedID);
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "DELETE");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	_tmp10_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp10_, FALSE);
	if (_error_ != ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		feed_reader_logger_error ("OwncloudNewsAPI.removeFeed");
	}
	_g_object_unref0 (message);
	_g_free0 (url);
}

void
feed_reader_owncloud_news_api_renameFeed (FeedReaderOwncloudNewsAPI* self,
                                          const gchar* feedID,
                                          const gchar* title)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strdup_printf ("feeds/%s/rename", feedID);
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "PUT");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	_tmp10_ = message;
	feed_reader_own_cloud_news_message_add_string (_tmp10_, "feedTitle", title);
	_tmp11_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp11_, FALSE);
	if (_error_ != ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		feed_reader_logger_error ("OwncloudNewsAPI.renameFeed");
	}
	_g_object_unref0 (message);
	_g_free0 (url);
}

void
feed_reader_owncloud_news_api_moveFeed (FeedReaderOwncloudNewsAPI* self,
                                        const gchar* feedID,
                                        const gchar* newCatID)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	gint _tmp10_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (feedID != NULL);
	_tmp0_ = g_strdup_printf ("feeds/%s/move", feedID);
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "PUT");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	if (newCatID != NULL) {
		_tmp10_ = atoi (newCatID);
	} else {
		_tmp10_ = 0;
	}
	_tmp11_ = message;
	feed_reader_own_cloud_news_message_add_int (_tmp11_, "folderId", _tmp10_);
	_tmp12_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp12_, FALSE);
	if (_error_ != ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		feed_reader_logger_error ("OwncloudNewsAPI.moveFeed");
	}
	_g_object_unref0 (message);
	_g_free0 (url);
}

gint64
feed_reader_owncloud_news_api_addFolder (FeedReaderOwncloudNewsAPI* self,
                                         const gchar* title)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (title != NULL, 0LL);
	_tmp0_ = g_strdup ("folders");
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "POST");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	_tmp10_ = message;
	feed_reader_own_cloud_news_message_add_string (_tmp10_, "name", title);
	_tmp11_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp11_, FALSE);
	if (_error_ != ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderOwnCloudNewsMessage* _tmp12_;
		JsonObject* _tmp13_;
		JsonObject* _tmp14_;
		_tmp12_ = message;
		_tmp13_ = feed_reader_own_cloud_news_message_get_response_object (_tmp12_);
		response = _tmp13_;
		_tmp14_ = response;
		if (json_object_has_member (_tmp14_, "folders")) {
			JsonObject* _tmp15_;
			JsonArray* _tmp16_;
			JsonObject* _tmp17_;
			_tmp15_ = response;
			_tmp16_ = json_object_get_array_member (_tmp15_, "folders");
			_tmp17_ = json_array_get_object_element (_tmp16_, (guint) 0);
			result = json_object_get_int_member (_tmp17_, "id");
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			_g_free0 (url);
			return result;
		}
		_json_object_unref0 (response);
	} else {
		feed_reader_logger_error ("OwncloudNewsAPI.addFolder");
	}
	result = (gint64) 0;
	_g_object_unref0 (message);
	_g_free0 (url);
	return result;
}

gboolean
feed_reader_owncloud_news_api_removeFolder (FeedReaderOwncloudNewsAPI* self,
                                            const gchar* catID)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (catID != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("folders/%s", catID);
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "DELETE");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	_tmp10_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp10_, FALSE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		result = TRUE;
		_g_object_unref0 (message);
		_g_free0 (url);
		return result;
	}
	feed_reader_logger_error ("OwncloudNewsAPI.removeFolder");
	result = FALSE;
	_g_object_unref0 (message);
	_g_free0 (url);
	return result;
}

void
feed_reader_owncloud_news_api_renameCategory (FeedReaderOwncloudNewsAPI* self,
                                              const gchar* catID,
                                              const gchar* title)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	FeedReaderOwnCloudNewsMessage* _tmp9_;
	FeedReaderOwnCloudNewsMessage* _tmp10_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = g_strdup_printf ("folders/%s", catID);
	url = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->m_OwnCloudURL;
	_tmp3_ = url;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->m_username;
	_tmp7_ = self->priv->m_password;
	_tmp8_ = feed_reader_own_cloud_news_message_new (_tmp1_, _tmp5_, _tmp6_, _tmp7_, "PUT");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp5_);
	message = _tmp9_;
	_tmp10_ = message;
	feed_reader_own_cloud_news_message_add_string (_tmp10_, "name", title);
	_tmp11_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp11_, FALSE);
	if (_error_ != ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		feed_reader_logger_error ("OwncloudNewsAPI.renameCategory");
	}
	_g_object_unref0 (message);
	_g_free0 (url);
}

gboolean
feed_reader_owncloud_news_api_ping (FeedReaderOwncloudNewsAPI* self)
{
	FeedReaderOwnCloudNewsMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FeedReaderOwnCloudNewsMessage* _tmp6_;
	FeedReaderOwnCloudNewsMessage* _tmp7_;
	gint _error_ = 0;
	FeedReaderOwnCloudNewsMessage* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->m_OwnCloudURL;
	_tmp2_ = g_strconcat (_tmp1_, "version", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->m_username;
	_tmp5_ = self->priv->m_password;
	_tmp6_ = feed_reader_own_cloud_news_message_new (_tmp0_, _tmp3_, _tmp4_, _tmp5_, "GET");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	message = _tmp7_;
	_tmp8_ = message;
	_error_ = (gint) feed_reader_own_cloud_news_message_send (_tmp8_, TRUE);
	if (_error_ == ((gint) FEED_READER_CONNECTION_ERROR_NO_RESPONSE)) {
		feed_reader_logger_error ("OwncloudNewsAPI.ping: failed");
		result = FALSE;
		_g_object_unref0 (message);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (message);
	return result;
}

static void
feed_reader_owncloud_news_api_class_init (FeedReaderOwncloudNewsAPIClass * klass,
                                          gpointer klass_data)
{
	feed_reader_owncloud_news_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderOwncloudNewsAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_owncloud_news_api_finalize;
}

static void
feed_reader_owncloud_news_api_instance_init (FeedReaderOwncloudNewsAPI * self,
                                             gpointer klass)
{
	self->priv = feed_reader_owncloud_news_api_get_instance_private (self);
}

static void
feed_reader_owncloud_news_api_finalize (GObject * obj)
{
	FeedReaderOwncloudNewsAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_OWNCLOUD_NEWS_API, FeedReaderOwncloudNewsAPI);
	_g_free0 (self->priv->m_OwnCloudURL);
	_g_free0 (self->priv->m_OwnCloudVersion);
	_g_object_unref0 (self->priv->m_parser);
	_g_free0 (self->priv->m_username);
	_g_free0 (self->priv->m_password);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_session);
	G_OBJECT_CLASS (feed_reader_owncloud_news_api_parent_class)->finalize (obj);
}

GType
feed_reader_owncloud_news_api_get_type (void)
{
	return feed_reader_owncloud_news_api_type_id;
}

GType
feed_reader_owncloud_news_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderOwncloudNewsAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_owncloud_news_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderOwncloudNewsAPI), 0, (GInstanceInitFunc) feed_reader_owncloud_news_api_instance_init, NULL };
	feed_reader_owncloud_news_api_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderOwncloudNewsAPI", &g_define_type_info, 0);
	FeedReaderOwncloudNewsAPI_private_offset = sizeof (FeedReaderOwncloudNewsAPIPrivate);
	return feed_reader_owncloud_news_api_type_id;
}

