/* OwncloudNewsInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from OwncloudNewsInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "owncloud.h"
#include <gtk/gtk.h>
#include <glib.h>
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

enum  {
	FEED_READER_OWNCLOUD_NEWS_INTERFACE_0_PROPERTY,
	FEED_READER_OWNCLOUD_NEWS_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_owncloud_news_interface_properties[FEED_READER_OWNCLOUD_NEWS_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderOwncloudNewsInterfacePrivate {
	FeedReaderOwncloudNewsAPI* m_api;
	FeedReaderOwncloudNewsUtils* m_utils;
	GtkEntry* m_urlEntry;
	GtkEntry* m_userEntry;
	GtkEntry* m_passwordEntry;
	GtkEntry* m_AuthUserEntry;
	GtkEntry* m_AuthPasswordEntry;
	GtkRevealer* m_revealer;
	gboolean m_need_htaccess;
};

static gint FeedReaderOwncloudNewsInterface_private_offset;
static gpointer feed_reader_owncloud_news_interface_parent_class = NULL;
static GType feed_reader_owncloud_news_interface_type_id = 0;

static void feed_reader_owncloud_news_interface_real_init (FeedReaderFeedServerInterface* base,
                                                    GSettingsBackend* settings_backend,
                                                    SecretCollection* secrets);
static gchar* feed_reader_owncloud_news_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_owncloud_news_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_owncloud_news_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_owncloud_news_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_owncloud_news_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static void feed_reader_owncloud_news_interface_real_writeData (FeedReaderFeedServerInterface* base);
static void feed_reader_owncloud_news_interface_real_showHtAccess (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static GtkBox* feed_reader_owncloud_news_interface_real_getWidget (FeedReaderFeedServerInterface* base);
static void _feed_reader_feed_server_interface_writeData_gtk_entry_activate (GtkEntry* _sender,
                                                                      gpointer self);
static void __lambda7_ (FeedReaderOwncloudNewsInterface* self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static gboolean feed_reader_owncloud_news_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_owncloud_news_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_owncloud_news_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_owncloud_news_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_owncloud_news_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                         const gchar* cadID);
static gboolean feed_reader_owncloud_news_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_owncloud_news_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_owncloud_news_interface_real_login (FeedReaderFeedServerInterface* base);
static void feed_reader_owncloud_news_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                                const gchar* articleIDs,
                                                                FeedReaderArticleStatus read);
static void feed_reader_owncloud_news_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                                  const gchar* articleID,
                                                                  FeedReaderArticleStatus marked);
static gboolean feed_reader_owncloud_news_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_owncloud_news_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                           const gchar* feedID);
static void feed_reader_owncloud_news_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                               const gchar* catID);
static void feed_reader_owncloud_news_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_owncloud_news_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                          const gchar* articleID,
                                                          const gchar* tagID);
static void feed_reader_owncloud_news_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                                const gchar* articleID,
                                                                const gchar* tagID);
static gchar* feed_reader_owncloud_news_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                           const gchar* caption);
static void feed_reader_owncloud_news_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                         const gchar* tagID);
static void feed_reader_owncloud_news_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                         const gchar* tagID,
                                                         const gchar* title);
static gboolean feed_reader_owncloud_news_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_owncloud_news_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                           const gchar* feedURL,
                                                           const gchar* catID,
                                                           const gchar* newCatName,
                                                           gchar** feedID,
                                                           gchar** errmsg);
static void feed_reader_owncloud_news_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                          const gchar* feedID);
static void feed_reader_owncloud_news_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                          const gchar* feedID,
                                                          const gchar* title);
static void feed_reader_owncloud_news_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                        const gchar* feedID,
                                                        const gchar* newCatID,
                                                        const gchar* currentCatID);
static gchar* feed_reader_owncloud_news_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                                const gchar* title,
                                                                const gchar* parentID);
static void feed_reader_owncloud_news_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                              const gchar* catID,
                                                              const gchar* title);
static void feed_reader_owncloud_news_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                            const gchar* catID,
                                                            const gchar* newParentID);
static void feed_reader_owncloud_news_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                              const gchar* catID);
static void feed_reader_owncloud_news_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                                 const gchar* feedID,
                                                                 const gchar* catID);
static gboolean feed_reader_owncloud_news_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                                   GeeList* feeds,
                                                                   GeeList* categories,
                                                                   GeeList* tags,
                                                                   GCancellable* cancellable);
static gint feed_reader_owncloud_news_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_owncloud_news_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                           gint count,
                                                           FeedReaderArticleStatus whatToGet,
                                                           GDateTime* since,
                                                           const gchar* feedID,
                                                           gboolean isTagID,
                                                           GCancellable* cancellable);
static void feed_reader_owncloud_news_interface_finalize (GObject * obj);
GType feed_reader_owncloud_news_api_register_type (GTypeModule * module);
GType feed_reader_owncloud_news_utils_register_type (GTypeModule * module);
GType feed_reader_own_cloud_news_message_register_type (GTypeModule * module);

static inline gpointer
feed_reader_owncloud_news_interface_get_instance_private (FeedReaderOwncloudNewsInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderOwncloudNewsInterface_private_offset);
}

static void
feed_reader_owncloud_news_interface_real_init (FeedReaderFeedServerInterface* base,
                                               GSettingsBackend* settings_backend,
                                               SecretCollection* secrets)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsUtils* _tmp0_;
	FeedReaderOwncloudNewsUtils* _tmp1_;
	FeedReaderOwncloudNewsAPI* _tmp2_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_owncloud_news_utils_new (settings_backend, secrets);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_owncloud_news_api_new (_tmp1_);
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp2_;
}

static gchar*
feed_reader_owncloud_news_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = g_strdup ("https://github.com/nextcloud/news");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_owncloud_news_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_SELF_HOSTED | FEED_READER_BACKEND_FLAGS_FREE_SOFTWARE) | FEED_READER_BACKEND_FLAGS_FREE;
	return result;
}

static gchar*
feed_reader_owncloud_news_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = g_strdup ("owncloud");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_owncloud_news_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = g_strdup ("feed-service-nextcloud");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_owncloud_news_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = g_strdup ("Nextcloud News");
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
feed_reader_owncloud_news_interface_real_writeData (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsUtils* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	FeedReaderOwncloudNewsUtils* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FeedReaderOwncloudNewsUtils* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = self->priv->m_urlEntry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	feed_reader_owncloud_news_utils_setURL (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->m_utils;
	_tmp4_ = self->priv->m_userEntry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = string_strip (_tmp5_);
	_tmp7_ = _tmp6_;
	feed_reader_owncloud_news_utils_setUser (_tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->m_utils;
	_tmp9_ = self->priv->m_passwordEntry;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = string_strip (_tmp10_);
	_tmp12_ = _tmp11_;
	feed_reader_owncloud_news_utils_setPassword (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	if (self->priv->m_need_htaccess) {
		FeedReaderOwncloudNewsUtils* _tmp13_;
		GtkEntry* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FeedReaderOwncloudNewsUtils* _tmp18_;
		GtkEntry* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = self->priv->m_utils;
		_tmp14_ = self->priv->m_AuthUserEntry;
		_tmp15_ = gtk_entry_get_text (_tmp14_);
		_tmp16_ = string_strip (_tmp15_);
		_tmp17_ = _tmp16_;
		feed_reader_owncloud_news_utils_setHtaccessUser (_tmp13_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = self->priv->m_utils;
		_tmp19_ = self->priv->m_AuthPasswordEntry;
		_tmp20_ = gtk_entry_get_text (_tmp19_);
		_tmp21_ = string_strip (_tmp20_);
		_tmp22_ = _tmp21_;
		feed_reader_owncloud_news_utils_setHtAccessPassword (_tmp18_, _tmp22_);
		_g_free0 (_tmp22_);
	}
}

static void
feed_reader_owncloud_news_interface_real_showHtAccess (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	GtkRevealer* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
}

static gboolean
feed_reader_owncloud_news_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = FALSE;
	return result;
}

static void
_feed_reader_feed_server_interface_writeData_gtk_entry_activate (GtkEntry* _sender,
                                                                 gpointer self)
{
	feed_reader_feed_server_interface_writeData ((FeedReaderFeedServerInterface*) self);
}

static void
__lambda7_ (FeedReaderOwncloudNewsInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ ((FeedReaderOwncloudNewsInterface*) self);
}

static GtkBox*
feed_reader_owncloud_news_interface_real_getWidget (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	GtkLabel* urlLabel = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* userLabel = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* passwordLabel = NULL;
	GtkLabel* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp11_;
	GtkImage* logo = NULL;
	GtkImage* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	GtkLabel* authUserLabel = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* authPasswordLabel = NULL;
	GtkLabel* _tmp17_;
	GtkEntry* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	GtkEntry* _tmp21_;
	GtkEntry* _tmp22_;
	GtkEntry* _tmp23_;
	GtkGrid* authGrid = NULL;
	GtkGrid* _tmp24_;
	GtkEntry* _tmp25_;
	GtkEntry* _tmp26_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp27_;
	GtkRevealer* _tmp28_;
	GtkRevealer* _tmp29_;
	GtkLabel* loginLabel = NULL;
	GtkLabel* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkButton* loginButton = NULL;
	GtkButton* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkBox* box = NULL;
	GtkBox* _tmp34_;
	GtkRevealer* _tmp35_;
	GtkEntry* _tmp36_;
	FeedReaderOwncloudNewsUtils* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GtkEntry* _tmp40_;
	FeedReaderOwncloudNewsUtils* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkEntry* _tmp44_;
	FeedReaderOwncloudNewsUtils* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkBox* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Nextcloud URL:"));
	g_object_ref_sink (_tmp0_);
	urlLabel = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp1_);
	userLabel = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp2_);
	passwordLabel = _tmp2_;
	gtk_misc_set_alignment ((GtkMisc*) urlLabel, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) userLabel, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) passwordLabel, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) urlLabel, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) userLabel, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) passwordLabel, TRUE);
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->m_urlEntry);
	self->priv->m_urlEntry = _tmp3_;
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_userEntry);
	self->priv->m_userEntry = _tmp4_;
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_passwordEntry);
	self->priv->m_passwordEntry = _tmp5_;
	_tmp6_ = self->priv->m_urlEntry;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) _feed_reader_feed_server_interface_writeData_gtk_entry_activate, (FeedReaderFeedServerInterface*) self, 0);
	_tmp7_ = self->priv->m_userEntry;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) _feed_reader_feed_server_interface_writeData_gtk_entry_activate, (FeedReaderFeedServerInterface*) self, 0);
	_tmp8_ = self->priv->m_passwordEntry;
	g_signal_connect_object (_tmp8_, "activate", (GCallback) _feed_reader_feed_server_interface_writeData_gtk_entry_activate, (FeedReaderFeedServerInterface*) self, 0);
	_tmp9_ = self->priv->m_passwordEntry;
	gtk_entry_set_input_purpose (_tmp9_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp10_ = self->priv->m_passwordEntry;
	gtk_entry_set_visibility (_tmp10_, FALSE);
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp11_);
	grid = _tmp11_;
	gtk_grid_set_column_spacing (grid, (guint) 10);
	gtk_grid_set_row_spacing (grid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("feed-service-nextcloud", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp12_);
	logo = _tmp12_;
	gtk_grid_attach (grid, (GtkWidget*) urlLabel, 0, 0, 1, 1);
	_tmp13_ = self->priv->m_urlEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp13_, 1, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) userLabel, 0, 1, 1, 1);
	_tmp14_ = self->priv->m_userEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp14_, 1, 1, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) passwordLabel, 0, 2, 1, 1);
	_tmp15_ = self->priv->m_passwordEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp15_, 1, 2, 1, 1);
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp16_);
	authUserLabel = _tmp16_;
	_tmp17_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp17_);
	authPasswordLabel = _tmp17_;
	gtk_misc_set_alignment ((GtkMisc*) authUserLabel, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) authPasswordLabel, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) authUserLabel, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) authPasswordLabel, TRUE);
	_tmp18_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->m_AuthUserEntry);
	self->priv->m_AuthUserEntry = _tmp18_;
	_tmp19_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->m_AuthPasswordEntry);
	self->priv->m_AuthPasswordEntry = _tmp19_;
	_tmp20_ = self->priv->m_AuthPasswordEntry;
	gtk_entry_set_input_purpose (_tmp20_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp21_ = self->priv->m_AuthPasswordEntry;
	gtk_entry_set_visibility (_tmp21_, FALSE);
	_tmp22_ = self->priv->m_AuthUserEntry;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) _feed_reader_feed_server_interface_writeData_gtk_entry_activate, (FeedReaderFeedServerInterface*) self, 0);
	_tmp23_ = self->priv->m_AuthPasswordEntry;
	g_signal_connect_object (_tmp23_, "activate", (GCallback) _feed_reader_feed_server_interface_writeData_gtk_entry_activate, (FeedReaderFeedServerInterface*) self, 0);
	_tmp24_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp24_);
	authGrid = _tmp24_;
	g_object_set ((GtkWidget*) authGrid, "margin", 10, NULL);
	gtk_grid_set_column_spacing (authGrid, (guint) 10);
	gtk_grid_set_row_spacing (authGrid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) authGrid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) authGrid, GTK_ALIGN_CENTER);
	gtk_grid_attach (authGrid, (GtkWidget*) authUserLabel, 0, 0, 1, 1);
	_tmp25_ = self->priv->m_AuthUserEntry;
	gtk_grid_attach (authGrid, (GtkWidget*) _tmp25_, 1, 0, 1, 1);
	gtk_grid_attach (authGrid, (GtkWidget*) authPasswordLabel, 0, 1, 1, 1);
	_tmp26_ = self->priv->m_AuthPasswordEntry;
	gtk_grid_attach (authGrid, (GtkWidget*) _tmp26_, 1, 1, 1, 1);
	_tmp27_ = (GtkFrame*) gtk_frame_new (_ ("HTTP Authorization"));
	g_object_ref_sink (_tmp27_);
	frame = _tmp27_;
	gtk_widget_set_halign ((GtkWidget*) frame, GTK_ALIGN_CENTER);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) authGrid);
	_tmp28_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->m_revealer);
	self->priv->m_revealer = _tmp28_;
	_tmp29_ = self->priv->m_revealer;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) frame);
	_tmp30_ = (GtkLabel*) gtk_label_new (_ ("Please log in to your Nextcloud News instance and enjoy using FeedRead" \
"er"));
	g_object_ref_sink (_tmp30_);
	loginLabel = _tmp30_;
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) loginLabel);
	gtk_style_context_add_class (_tmp31_, "h2");
	gtk_label_set_justify (loginLabel, GTK_JUSTIFY_CENTER);
	gtk_label_set_lines (loginLabel, 3);
	_tmp32_ = (GtkButton*) gtk_button_new_with_label (_ ("Login"));
	g_object_ref_sink (_tmp32_);
	loginButton = _tmp32_;
	gtk_widget_set_halign ((GtkWidget*) loginButton, GTK_ALIGN_END);
	gtk_widget_set_size_request ((GtkWidget*) loginButton, 80, 30);
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) loginButton);
	gtk_style_context_add_class (_tmp33_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_object (loginButton, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp34_);
	box = _tmp34_;
	gtk_widget_set_valign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_box_pack_start (box, (GtkWidget*) loginLabel, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) logo, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) grid, TRUE, TRUE, (guint) 10);
	_tmp35_ = self->priv->m_revealer;
	gtk_box_pack_start (box, (GtkWidget*) _tmp35_, TRUE, TRUE, (guint) 10);
	gtk_box_pack_end (box, (GtkWidget*) loginButton, FALSE, FALSE, (guint) 20);
	_tmp36_ = self->priv->m_urlEntry;
	_tmp37_ = self->priv->m_utils;
	_tmp38_ = feed_reader_owncloud_news_utils_getUnmodifiedURL (_tmp37_);
	_tmp39_ = _tmp38_;
	gtk_entry_set_text (_tmp36_, _tmp39_);
	_g_free0 (_tmp39_);
	_tmp40_ = self->priv->m_userEntry;
	_tmp41_ = self->priv->m_utils;
	_tmp42_ = feed_reader_owncloud_news_utils_getUser (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_entry_set_text (_tmp40_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->m_passwordEntry;
	_tmp45_ = self->priv->m_utils;
	_tmp46_ = feed_reader_owncloud_news_utils_getPasswd (_tmp45_);
	_tmp47_ = _tmp46_;
	gtk_entry_set_text (_tmp44_, _tmp47_);
	_g_free0 (_tmp47_);
	result = box;
	_g_object_unref0 (loginButton);
	_g_object_unref0 (loginLabel);
	_g_object_unref0 (frame);
	_g_object_unref0 (authGrid);
	_g_object_unref0 (authPasswordLabel);
	_g_object_unref0 (authUserLabel);
	_g_object_unref0 (logo);
	_g_object_unref0 (grid);
	_g_object_unref0 (passwordLabel);
	_g_object_unref0 (userLabel);
	_g_object_unref0 (urlLabel);
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = TRUE;
	return result;
}

static gchar*
feed_reader_owncloud_news_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = g_strdup ("feed-service-nextcloud-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_owncloud_news_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_owncloud_news_utils_getUser (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_owncloud_news_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_owncloud_news_utils_getURL (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_owncloud_news_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = g_strdup ("0");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                const gchar* cadID)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_val_if_fail (cadID != NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_owncloud_news_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsUtils* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_utils;
	feed_reader_owncloud_news_utils_resetAccount (_tmp0_);
}

static gboolean
feed_reader_owncloud_news_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = FALSE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_owncloud_news_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	FeedReaderLoginResponse result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_owncloud_news_api_login (_tmp0_);
	return result;
}

static void
feed_reader_owncloud_news_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                           const gchar* articleIDs,
                                                           FeedReaderArticleStatus read)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (articleIDs != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_updateArticleUnread (_tmp0_, articleIDs, read);
}

static void
feed_reader_owncloud_news_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                             const gchar* articleID,
                                                             FeedReaderArticleStatus marked)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (articleID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_updateArticleMarked (_tmp0_, articleID, marked);
}

static gboolean
feed_reader_owncloud_news_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_owncloud_news_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                      const gchar* feedID)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_markFeedRead (_tmp0_, feedID, FALSE);
}

static void
feed_reader_owncloud_news_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                          const gchar* catID)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_markFeedRead (_tmp0_, catID, TRUE);
}

static void
feed_reader_owncloud_news_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_markAllItemsRead (_tmp0_);
}

static void
feed_reader_owncloud_news_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                     const gchar* articleID,
                                                     const gchar* tagID)
{
	FeedReaderOwncloudNewsInterface * self;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static void
feed_reader_owncloud_news_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                           const gchar* articleID,
                                                           const gchar* tagID)
{
	FeedReaderOwncloudNewsInterface * self;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	return;
}

static gchar*
feed_reader_owncloud_news_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                    const gchar* caption)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = g_strdup (":(");
	result = _tmp0_;
	return result;
}

static void
feed_reader_owncloud_news_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                    const gchar* tagID)
{
	FeedReaderOwncloudNewsInterface * self;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (tagID != NULL);
	return;
}

static void
feed_reader_owncloud_news_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                    const gchar* tagID,
                                                    const gchar* title)
{
	FeedReaderOwncloudNewsInterface * self;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	return;
}

static gboolean
feed_reader_owncloud_news_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_owncloud_news_api_ping (_tmp0_);
	return result;
}

static gboolean
feed_reader_owncloud_news_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedURL,
                                                  const gchar* catID,
                                                  const gchar* newCatName,
                                                  gchar** feedID,
                                                  gchar** errmsg)
{
	FeedReaderOwncloudNewsInterface * self;
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	gboolean success = FALSE;
	gint64 id = 0LL;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp12_;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_val_if_fail (feedURL != NULL, FALSE);
	success = FALSE;
	id = (gint64) 0;
	if (catID == NULL) {
		_tmp0_ = newCatName != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* newCatID = NULL;
		FeedReaderOwncloudNewsAPI* _tmp1_;
		gchar* _tmp2_;
		FeedReaderOwncloudNewsAPI* _tmp3_;
		const gchar* _tmp4_;
		gint64 _tmp5_ = 0LL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp1_ = self->priv->m_api;
		_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_reader_owncloud_news_api_addFolder (_tmp1_, newCatName));
		newCatID = _tmp2_;
		_tmp3_ = self->priv->m_api;
		_tmp4_ = newCatID;
		_tmp7_ = feed_reader_owncloud_news_api_addFeed (_tmp3_, feedURL, _tmp4_, &_tmp5_, &_tmp6_);
		id = _tmp5_;
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp6_;
		success = _tmp7_;
		_g_free0 (newCatID);
	} else {
		FeedReaderOwncloudNewsAPI* _tmp8_;
		gint64 _tmp9_ = 0LL;
		gchar* _tmp10_ = NULL;
		gboolean _tmp11_;
		_tmp8_ = self->priv->m_api;
		_tmp11_ = feed_reader_owncloud_news_api_addFeed (_tmp8_, feedURL, catID, &_tmp9_, &_tmp10_);
		id = _tmp9_;
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp10_;
		success = _tmp11_;
	}
	_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, id);
	_g_free0 (_vala_feedID);
	_vala_feedID = _tmp12_;
	result = success;
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
feed_reader_owncloud_news_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                     const gchar* feedID)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_removeFeed (_tmp0_, feedID);
}

static void
feed_reader_owncloud_news_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                     const gchar* feedID,
                                                     const gchar* title)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_renameFeed (_tmp0_, feedID, title);
}

static void
feed_reader_owncloud_news_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedID,
                                                   const gchar* newCatID,
                                                   const gchar* currentCatID)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_moveFeed (_tmp0_, feedID, newCatID);
}

static gchar*
feed_reader_owncloud_news_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                         const gchar* title,
                                                         const gchar* parentID)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_reader_owncloud_news_api_addFolder (_tmp0_, title));
	result = _tmp1_;
	return result;
}

static void
feed_reader_owncloud_news_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                         const gchar* catID,
                                                         const gchar* title)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_renameCategory (_tmp0_, catID, title);
}

static void
feed_reader_owncloud_news_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                       const gchar* catID,
                                                       const gchar* newParentID)
{
	FeedReaderOwncloudNewsInterface * self;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	return;
}

static void
feed_reader_owncloud_news_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                         const gchar* catID)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_owncloud_news_api_removeFolder (_tmp0_, catID);
}

static void
feed_reader_owncloud_news_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                            const gchar* feedID,
                                                            const gchar* catID)
{
	FeedReaderOwncloudNewsInterface * self;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	return;
}

static gboolean
feed_reader_owncloud_news_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                          GeeList* feeds,
                                                          GeeList* categories,
                                                          GeeList* tags,
                                                          GCancellable* cancellable)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_api;
	if (feed_reader_owncloud_news_api_getFeeds (_tmp0_, feeds)) {
		gboolean _tmp1_ = FALSE;
		FeedReaderOwncloudNewsAPI* _tmp2_;
		if (cancellable != NULL) {
			_tmp1_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = self->priv->m_api;
		if (feed_reader_owncloud_news_api_getCategories (_tmp2_, categories, feeds)) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gint
feed_reader_owncloud_news_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	gint _tmp2_;
	gint result;
	self = (FeedReaderOwncloudNewsInterface*) base;
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = (gint) feed_reader_data_base_read_only_get_unread_total (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
feed_reader_owncloud_news_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                      gint count,
                                                      FeedReaderArticleStatus whatToGet,
                                                      GDateTime* since,
                                                      const gchar* feedID,
                                                      gboolean isTagID,
                                                      GCancellable* cancellable)
{
	FeedReaderOwncloudNewsInterface * self;
	FeedReaderOwncloudNewsAPIOwnCloudType type = 0;
	gboolean read = FALSE;
	gint id = 0;
	GeeLinkedList* articles = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp6_;
	self = (FeedReaderOwncloudNewsInterface*) base;
	type = FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_ALL;
	read = TRUE;
	id = 0;
	switch (whatToGet) {
		case FEED_READER_ARTICLE_STATUS_ALL:
		{
			break;
		}
		case FEED_READER_ARTICLE_STATUS_UNREAD:
		{
			read = FALSE;
			break;
		}
		case FEED_READER_ARTICLE_STATUS_MARKED:
		{
			type = FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_STARRED;
			break;
		}
		default:
		break;
	}
	if (feedID != NULL) {
		if (isTagID == TRUE) {
			return;
		}
		id = atoi (feedID);
		type = FEED_READER_OWNCLOUD_NEWS_API_OWN_CLOUD_TYPE_FEED;
	}
	_tmp0_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp0_;
	if (count == -1) {
		gint _tmp1_ = 0;
		FeedReaderOwncloudNewsAPI* _tmp2_;
		GeeLinkedList* _tmp3_;
		if (since != NULL) {
			_tmp1_ = (gint) g_date_time_to_unix (since);
		} else {
			_tmp1_ = 0;
		}
		_tmp2_ = self->priv->m_api;
		_tmp3_ = articles;
		feed_reader_owncloud_news_api_getNewArticles (_tmp2_, (GeeList*) _tmp3_, _tmp1_, type, id);
	} else {
		FeedReaderOwncloudNewsAPI* _tmp4_;
		GeeLinkedList* _tmp5_;
		_tmp4_ = self->priv->m_api;
		_tmp5_ = articles;
		feed_reader_owncloud_news_api_getArticles (_tmp4_, (GeeList*) _tmp5_, 0, -1, read, type, id);
	}
	_tmp6_ = articles;
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "write-articles", (GeeList*) _tmp6_);
	_g_object_unref0 (articles);
}

FeedReaderOwncloudNewsInterface*
feed_reader_owncloud_news_interface_construct (GType object_type)
{
	FeedReaderOwncloudNewsInterface * self = NULL;
	self = (FeedReaderOwncloudNewsInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderOwncloudNewsInterface*
feed_reader_owncloud_news_interface_new (void)
{
	return feed_reader_owncloud_news_interface_construct (FEED_READER_TYPE_OWNCLOUD_NEWS_INTERFACE);
}

static void
feed_reader_owncloud_news_interface_class_init (FeedReaderOwncloudNewsInterfaceClass * klass,
                                                gpointer klass_data)
{
	feed_reader_owncloud_news_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderOwncloudNewsInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_owncloud_news_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->writeData = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_writeData;
	((FeedReaderFeedServerInterfaceClass *) klass)->showHtAccess = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_showHtAccess;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWidget = (GtkBox* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_getWidget;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_owncloud_news_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_owncloud_news_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_owncloud_news_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_owncloud_news_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_owncloud_news_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_owncloud_news_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_owncloud_news_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_owncloud_news_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_owncloud_news_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_owncloud_news_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_owncloud_news_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_owncloud_news_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_owncloud_news_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_owncloud_news_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_owncloud_news_interface_finalize;
}

static void
feed_reader_owncloud_news_interface_instance_init (FeedReaderOwncloudNewsInterface * self,
                                                   gpointer klass)
{
	self->priv = feed_reader_owncloud_news_interface_get_instance_private (self);
	self->priv->m_need_htaccess = FALSE;
}

static void
feed_reader_owncloud_news_interface_finalize (GObject * obj)
{
	FeedReaderOwncloudNewsInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_OWNCLOUD_NEWS_INTERFACE, FeedReaderOwncloudNewsInterface);
	_g_object_unref0 (self->priv->m_api);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_urlEntry);
	_g_object_unref0 (self->priv->m_userEntry);
	_g_object_unref0 (self->priv->m_passwordEntry);
	_g_object_unref0 (self->priv->m_AuthUserEntry);
	_g_object_unref0 (self->priv->m_AuthPasswordEntry);
	_g_object_unref0 (self->priv->m_revealer);
	G_OBJECT_CLASS (feed_reader_owncloud_news_interface_parent_class)->finalize (obj);
}

GType
feed_reader_owncloud_news_interface_get_type (void)
{
	return feed_reader_owncloud_news_interface_type_id;
}

GType
feed_reader_owncloud_news_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderOwncloudNewsInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_owncloud_news_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderOwncloudNewsInterface), 0, (GInstanceInitFunc) feed_reader_owncloud_news_interface_instance_init, NULL };
	feed_reader_owncloud_news_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderOwncloudNewsInterface", &g_define_type_info, 0);
	FeedReaderOwncloudNewsInterface_private_offset = sizeof (FeedReaderOwncloudNewsInterfacePrivate);
	return feed_reader_owncloud_news_interface_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_owncloud_news_api_register_type (module);
	feed_reader_owncloud_news_interface_register_type (module);
	feed_reader_owncloud_news_utils_register_type (module);
	feed_reader_own_cloud_news_message_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_OWNCLOUD_NEWS_INTERFACE);
	_g_object_unref0 (objmodule);
}

