/* OwncloudNewsMessage.c generated by valac 0.56.3, the Vala compiler
 * generated from OwncloudNewsMessage.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "owncloud.h"
#include <libsoup/soup.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <gio/gio.h>

enum  {
	FEED_READER_OWN_CLOUD_NEWS_MESSAGE_0_PROPERTY,
	FEED_READER_OWN_CLOUD_NEWS_MESSAGE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_own_cloud_news_message_properties[FEED_READER_OWN_CLOUD_NEWS_MESSAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FeedReaderOwnCloudNewsMessagePrivate {
	SoupSession* m_session;
	SoupMessage* m_message_soup;
	GString* m_message_string;
	gchar* m_contenttype;
	JsonParser* m_parser;
	JsonObject* m_root_object;
	gchar* m_method;
	gchar* m_destination;
};

static gint FeedReaderOwnCloudNewsMessage_private_offset;
static gpointer feed_reader_own_cloud_news_message_parent_class = NULL;
static GType feed_reader_own_cloud_news_message_type_id = 0;

static void _vala_SoupURI_free (SoupURI* self);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static void feed_reader_own_cloud_news_message_finalize (GObject * obj);

static inline gpointer
feed_reader_own_cloud_news_message_get_instance_private (FeedReaderOwnCloudNewsMessage* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderOwnCloudNewsMessage_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

FeedReaderOwnCloudNewsMessage*
feed_reader_own_cloud_news_message_construct (GType object_type,
                                              SoupSession* session,
                                              const gchar* destination,
                                              const gchar* username,
                                              const gchar* password,
                                              const gchar* method)
{
	FeedReaderOwnCloudNewsMessage * self = NULL;
	GString* _tmp0_;
	gchar* _tmp1_;
	SoupSession* _tmp2_;
	gchar* _tmp3_;
	JsonParser* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	SoupMessage* _tmp9_;
	gchar* credentials = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* base64 = NULL;
	guint8* _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_ = 0;
	guint8* _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	SoupMessage* _tmp18_;
	SoupMessageHeaders* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (session != NULL, NULL);
	g_return_val_if_fail (destination != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	g_return_val_if_fail (password != NULL, NULL);
	g_return_val_if_fail (method != NULL, NULL);
	self = (FeedReaderOwnCloudNewsMessage*) g_object_new (object_type, NULL);
	_tmp0_ = g_string_new ("");
	_g_string_free0 (self->priv->m_message_string);
	self->priv->m_message_string = _tmp0_;
	_tmp1_ = g_strdup (method);
	_g_free0 (self->priv->m_method);
	self->priv->m_method = _tmp1_;
	_tmp2_ = _g_object_ref0 (session);
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp2_;
	_tmp3_ = g_strdup (destination);
	_g_free0 (self->priv->m_destination);
	self->priv->m_destination = _tmp3_;
	if (g_strcmp0 (method, "GET") == 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("application/x-www-form-urlencoded");
		_g_free0 (self->priv->m_contenttype);
		self->priv->m_contenttype = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("application/json");
		_g_free0 (self->priv->m_contenttype);
		self->priv->m_contenttype = _tmp5_;
	}
	_tmp6_ = json_parser_new ();
	_g_object_unref0 (self->priv->m_parser);
	self->priv->m_parser = _tmp6_;
	_tmp7_ = self->priv->m_method;
	_tmp8_ = self->priv->m_destination;
	_tmp9_ = soup_message_new (_tmp7_, _tmp8_);
	_g_object_unref0 (self->priv->m_message_soup);
	self->priv->m_message_soup = _tmp9_;
	_tmp10_ = g_strconcat (username, ":", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, password, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	credentials = _tmp13_;
	_tmp14_ = string_get_data (credentials, &_tmp15_);
	_tmp14__length1 = _tmp15_;
	_tmp16_ = _tmp14_;
	_tmp16__length1 = _tmp14__length1;
	_tmp17_ = g_base64_encode (_tmp16_, (gint) _tmp16__length1);
	base64 = _tmp17_;
	_tmp18_ = self->priv->m_message_soup;
	_tmp19_ = _tmp18_->request_headers;
	_tmp20_ = g_strdup_printf ("Basic %s", base64);
	_tmp21_ = _tmp20_;
	soup_message_headers_append (_tmp19_, "Authorization", _tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (base64);
	_g_free0 (credentials);
	return self;
}

FeedReaderOwnCloudNewsMessage*
feed_reader_own_cloud_news_message_new (SoupSession* session,
                                        const gchar* destination,
                                        const gchar* username,
                                        const gchar* password,
                                        const gchar* method)
{
	return feed_reader_own_cloud_news_message_construct (FEED_READER_TYPE_OWN_CLOUD_NEWS_MESSAGE, session, destination, username, password, method);
}

void
feed_reader_own_cloud_news_message_add_int (FeedReaderOwnCloudNewsMessage* self,
                                            const gchar* type,
                                            gint val)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->m_method;
	if (g_strcmp0 (_tmp0_, "GET") == 0) {
		GString* _tmp1_;
		GString* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp1_ = self->priv->m_message_string;
		if (_tmp1_->len > ((gssize) 0)) {
			GString* _tmp2_;
			_tmp2_ = self->priv->m_message_string;
			g_string_append (_tmp2_, "&");
		}
		_tmp3_ = self->priv->m_message_string;
		_tmp4_ = g_strconcat (type, "=", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%i", val);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_string_append (_tmp3_, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		GString* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp10_ = self->priv->m_message_string;
		_tmp11_ = g_strconcat (",\"", type, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, "\":", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("%i", val);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		g_string_append (_tmp10_, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
	}
}

void
feed_reader_own_cloud_news_message_add_int_array (FeedReaderOwnCloudNewsMessage* self,
                                                  const gchar* type,
                                                  const gchar* values)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (values != NULL);
	_tmp0_ = self->priv->m_method;
	if (g_strcmp0 (_tmp0_, "GET") == 0) {
		feed_reader_logger_warning ("OwnCloudNewsMessage.add_int_array: this should not happen");
	} else {
		GString* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp1_ = self->priv->m_message_string;
		_tmp2_ = g_strconcat (",\"", type, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "\":[", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, values, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "]", NULL);
		_tmp9_ = _tmp8_;
		g_string_append (_tmp1_, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
}

void
feed_reader_own_cloud_news_message_add_bool (FeedReaderOwnCloudNewsMessage* self,
                                             const gchar* type,
                                             gboolean val)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->m_method;
	if (g_strcmp0 (_tmp0_, "GET") == 0) {
		GString* _tmp1_;
		const gchar* _tmp3_ = NULL;
		GString* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->m_message_string;
		if (_tmp1_->len > ((gssize) 0)) {
			GString* _tmp2_;
			_tmp2_ = self->priv->m_message_string;
			g_string_append (_tmp2_, "&");
		}
		if (val) {
			_tmp3_ = "true";
		} else {
			_tmp3_ = "false";
		}
		_tmp4_ = self->priv->m_message_string;
		_tmp5_ = g_strconcat (type, "=", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, _tmp3_, NULL);
		_tmp8_ = _tmp7_;
		g_string_append (_tmp4_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	} else {
		const gchar* _tmp9_ = NULL;
		GString* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		if (val) {
			_tmp9_ = "true";
		} else {
			_tmp9_ = "false";
		}
		_tmp10_ = self->priv->m_message_string;
		_tmp11_ = g_strconcat (",\"", type, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, "\":", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, _tmp9_, NULL);
		_tmp16_ = _tmp15_;
		g_string_append (_tmp10_, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
	}
}

void
feed_reader_own_cloud_news_message_add_string (FeedReaderOwnCloudNewsMessage* self,
                                               const gchar* type,
                                               const gchar* val)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->m_method;
	if (g_strcmp0 (_tmp0_, "GET") == 0) {
		GString* _tmp1_;
		GString* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = self->priv->m_message_string;
		if (_tmp1_->len > ((gssize) 0)) {
			GString* _tmp2_;
			_tmp2_ = self->priv->m_message_string;
			g_string_append (_tmp2_, "&");
		}
		_tmp3_ = self->priv->m_message_string;
		_tmp4_ = g_strconcat (type, "=", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, val, NULL);
		_tmp7_ = _tmp6_;
		g_string_append (_tmp3_, _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		GString* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp8_ = self->priv->m_message_string;
		_tmp9_ = g_strconcat (",\"", type, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "\":\"", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, val, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "\"", NULL);
		_tmp16_ = _tmp15_;
		g_string_append (_tmp8_, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	}
}

static void
_vala_SoupURI_free (SoupURI* self)
{
	g_boxed_free (soup_uri_get_type (), self);
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

FeedReaderConnectionError
feed_reader_own_cloud_news_message_send (FeedReaderOwnCloudNewsMessage* self,
                                         gboolean ping)
{
	GSettings* settingsTweaks = NULL;
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	GSettings* _tmp25_;
	guint status = 0U;
	SoupSession* _tmp28_;
	SoupMessage* _tmp29_;
	gboolean _tmp30_ = FALSE;
	SoupMessage* _tmp31_;
	GTlsCertificateFlags _tmp32_;
	GTlsCertificateFlags _tmp33_;
	SoupMessage* _tmp42_;
	guint _tmp43_;
	guint _tmp44_;
	JsonParser* _tmp62_;
	JsonNode* _tmp63_;
	JsonObject* _tmp64_;
	JsonObject* _tmp65_;
	GError* _inner_error0_ = NULL;
	FeedReaderConnectionError result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_settings_new ("org.gnome.feedreader.tweaks");
	settingsTweaks = _tmp0_;
	_tmp1_ = self->priv->m_method;
	if (g_strcmp0 (_tmp1_, "GET") == 0) {
		gchar* destination = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		GString* _tmp4_;
		SoupMessage* _tmp11_;
		const gchar* _tmp12_;
		SoupURI* _tmp13_;
		SoupURI* _tmp14_;
		const gchar* _tmp15_;
		_tmp2_ = self->priv->m_destination;
		_tmp3_ = g_strdup (_tmp2_);
		destination = _tmp3_;
		_tmp4_ = self->priv->m_message_string;
		if (_tmp4_->len > ((gssize) 0)) {
			const gchar* _tmp5_;
			GString* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp5_ = destination;
			_tmp6_ = self->priv->m_message_string;
			_tmp7_ = _tmp6_->str;
			_tmp8_ = g_strconcat ("?", _tmp7_, NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
			_g_free0 (destination);
			destination = _tmp10_;
			_g_free0 (_tmp9_);
		}
		_tmp11_ = self->priv->m_message_soup;
		_tmp12_ = destination;
		_tmp13_ = soup_uri_new (_tmp12_);
		_tmp14_ = _tmp13_;
		soup_message_set_uri (_tmp11_, _tmp14_);
		__vala_SoupURI_free0 (_tmp14_);
		_tmp15_ = destination;
		feed_reader_logger_debug (_tmp15_);
		_g_free0 (destination);
	} else {
		GString* _tmp16_;
		GString* _tmp17_;
		SoupMessage* _tmp18_;
		const gchar* _tmp19_;
		GString* _tmp20_;
		const gchar* _tmp21_;
		guint8* _tmp22_;
		gint _tmp22__length1;
		gint _tmp23_ = 0;
		guint8* _tmp24_;
		gint _tmp24__length1;
		_tmp16_ = self->priv->m_message_string;
		_tmp17_ = g_string_overwrite (_tmp16_, (gsize) 0, "{");
		g_string_append (_tmp17_, "}");
		_tmp18_ = self->priv->m_message_soup;
		_tmp19_ = self->priv->m_contenttype;
		_tmp20_ = self->priv->m_message_string;
		_tmp21_ = _tmp20_->str;
		_tmp22_ = string_get_data (_tmp21_, &_tmp23_);
		_tmp22__length1 = _tmp23_;
		_tmp24_ = _tmp22_;
		_tmp24__length1 = _tmp22__length1;
		soup_message_set_request (_tmp18_, _tmp19_, SOUP_MEMORY_COPY, _tmp24_, (gsize) _tmp24__length1);
	}
	_tmp25_ = settingsTweaks;
	if (g_settings_get_boolean (_tmp25_, "do-not-track")) {
		SoupMessage* _tmp26_;
		SoupMessageHeaders* _tmp27_;
		_tmp26_ = self->priv->m_message_soup;
		_tmp27_ = _tmp26_->request_headers;
		soup_message_headers_append (_tmp27_, "DNT", "1");
	}
	_tmp28_ = self->priv->m_session;
	_tmp29_ = self->priv->m_message_soup;
	status = soup_session_send_message (_tmp28_, _tmp29_);
	if (status == ((guint) 401)) {
		result = FEED_READER_CONNECTION_ERROR_UNAUTHORIZED;
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	_tmp31_ = self->priv->m_message_soup;
	g_object_get (_tmp31_, "tls-errors", &_tmp32_, NULL);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != 0) {
		GSettings* _tmp34_;
		_tmp34_ = settingsTweaks;
		_tmp30_ = !g_settings_get_boolean (_tmp34_, "ignore-tls-errors");
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		SoupMessage* _tmp35_;
		GTlsCertificateFlags _tmp36_;
		GTlsCertificateFlags _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp35_ = self->priv->m_message_soup;
		g_object_get (_tmp35_, "tls-errors", &_tmp36_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = feed_reader_utils_printTlsCertificateFlags (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat ("TLS errors: ", _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		feed_reader_logger_info (_tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		result = FEED_READER_CONNECTION_ERROR_CA_ERROR;
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	_tmp42_ = self->priv->m_message_soup;
	g_object_get (_tmp42_, "status-code", &_tmp43_, NULL);
	_tmp44_ = _tmp43_;
	if (_tmp44_ != ((guint) 200)) {
		SoupMessage* _tmp45_;
		guint _tmp46_;
		guint _tmp47_;
		SoupMessage* _tmp48_;
		guint _tmp49_;
		guint _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp45_ = self->priv->m_message_soup;
		g_object_get (_tmp45_, "status-code", &_tmp46_, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->m_message_soup;
		g_object_get (_tmp48_, "status-code", &_tmp49_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = soup_status_get_phrase (_tmp50_);
		_tmp52_ = g_strdup_printf ("Nextcloud Message: No response - status code: %u %s", _tmp47_, _tmp51_);
		_tmp53_ = _tmp52_;
		feed_reader_logger_error (_tmp53_);
		_g_free0 (_tmp53_);
		result = FEED_READER_CONNECTION_ERROR_NO_RESPONSE;
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	if (ping) {
		feed_reader_logger_debug ("Nextcloud Message: ping successful");
		result = FEED_READER_CONNECTION_ERROR_SUCCESS;
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	{
		JsonParser* _tmp54_;
		SoupMessage* _tmp55_;
		SoupMessageBody* _tmp56_;
		SoupBuffer* _tmp57_;
		SoupBuffer* _tmp58_;
		guint8* _tmp59_;
		gint _tmp59__length1;
		_tmp54_ = self->priv->m_parser;
		_tmp55_ = self->priv->m_message_soup;
		_tmp56_ = _tmp55_->response_body;
		_tmp57_ = soup_message_body_flatten (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_->data;
		_tmp59__length1 = _tmp58_->length;
		json_parser_load_from_data (_tmp54_, (const gchar*) _tmp59_, (gssize) -1, &_inner_error0_);
		__vala_SoupBuffer_free0 (_tmp58_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp60_;
		const gchar* _tmp61_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("Could not load response from Message to Nextcloud");
		feed_reader_own_cloud_news_message_printMessage (self);
		_tmp60_ = e;
		_tmp61_ = _tmp60_->message;
		feed_reader_logger_error (_tmp61_);
		result = FEED_READER_CONNECTION_ERROR_UNKNOWN;
		_g_error_free0 (e);
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (settingsTweaks);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp62_ = self->priv->m_parser;
	_tmp63_ = json_parser_get_root (_tmp62_);
	_tmp64_ = json_node_get_object (_tmp63_);
	_tmp65_ = _json_object_ref0 (_tmp64_);
	_json_object_unref0 (self->priv->m_root_object);
	self->priv->m_root_object = _tmp65_;
	result = FEED_READER_CONNECTION_ERROR_SUCCESS;
	_g_object_unref0 (settingsTweaks);
	return result;
}

guint
feed_reader_own_cloud_news_message_getStatusCode (FeedReaderOwnCloudNewsMessage* self)
{
	SoupMessage* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->m_message_soup;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

JsonObject*
feed_reader_own_cloud_news_message_get_response_object (FeedReaderOwnCloudNewsMessage* self)
{
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_root_object;
	_tmp1_ = _json_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
feed_reader_own_cloud_news_message_getMessage (FeedReaderOwnCloudNewsMessage* self)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_message_string;
	_tmp1_ = _tmp0_->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
feed_reader_own_cloud_news_message_printMessage (FeedReaderOwnCloudNewsMessage* self)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_message_string;
	_tmp1_ = _tmp0_->str;
	feed_reader_logger_debug (_tmp1_);
}

void
feed_reader_own_cloud_news_message_printResponse (FeedReaderOwnCloudNewsMessage* self)
{
	SoupMessage* _tmp0_;
	SoupMessageBody* _tmp1_;
	SoupBuffer* _tmp2_;
	SoupBuffer* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_message_soup;
	_tmp1_ = _tmp0_->response_body;
	_tmp2_ = soup_message_body_flatten (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->data;
	_tmp4__length1 = _tmp3_->length;
	feed_reader_logger_debug ((const gchar*) _tmp4_);
	__vala_SoupBuffer_free0 (_tmp3_);
}

static void
feed_reader_own_cloud_news_message_class_init (FeedReaderOwnCloudNewsMessageClass * klass,
                                               gpointer klass_data)
{
	feed_reader_own_cloud_news_message_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderOwnCloudNewsMessage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_own_cloud_news_message_finalize;
}

static void
feed_reader_own_cloud_news_message_instance_init (FeedReaderOwnCloudNewsMessage * self,
                                                  gpointer klass)
{
	self->priv = feed_reader_own_cloud_news_message_get_instance_private (self);
}

static void
feed_reader_own_cloud_news_message_finalize (GObject * obj)
{
	FeedReaderOwnCloudNewsMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_OWN_CLOUD_NEWS_MESSAGE, FeedReaderOwnCloudNewsMessage);
	_g_object_unref0 (self->priv->m_session);
	_g_object_unref0 (self->priv->m_message_soup);
	_g_string_free0 (self->priv->m_message_string);
	_g_free0 (self->priv->m_contenttype);
	_g_object_unref0 (self->priv->m_parser);
	_json_object_unref0 (self->priv->m_root_object);
	_g_free0 (self->priv->m_method);
	_g_free0 (self->priv->m_destination);
	G_OBJECT_CLASS (feed_reader_own_cloud_news_message_parent_class)->finalize (obj);
}

GType
feed_reader_own_cloud_news_message_get_type (void)
{
	return feed_reader_own_cloud_news_message_type_id;
}

GType
feed_reader_own_cloud_news_message_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderOwnCloudNewsMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_own_cloud_news_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderOwnCloudNewsMessage), 0, (GInstanceInitFunc) feed_reader_own_cloud_news_message_instance_init, NULL };
	feed_reader_own_cloud_news_message_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderOwnCloudNewsMessage", &g_define_type_info, 0);
	FeedReaderOwnCloudNewsMessage_private_offset = sizeof (FeedReaderOwnCloudNewsMessagePrivate);
	return feed_reader_own_cloud_news_message_type_id;
}

