/* OwncloudNewsUtils.c generated by valac 0.56.3, the Vala compiler
 * generated from OwncloudNewsUtils.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "owncloud.h"
#include <gio/gio.h>
#include "FeedReader.h"
#include <libsecret/secret.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

enum  {
	FEED_READER_OWNCLOUD_NEWS_UTILS_0_PROPERTY,
	FEED_READER_OWNCLOUD_NEWS_UTILS_NUM_PROPERTIES
};
static GParamSpec* feed_reader_owncloud_news_utils_properties[FEED_READER_OWNCLOUD_NEWS_UTILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderOwncloudNewsUtilsPrivate {
	GSettings* m_settings;
	FeedReaderPassword* m_password;
	FeedReaderPassword* m_htaccess_password;
};

static gint FeedReaderOwncloudNewsUtils_private_offset;
static gpointer feed_reader_owncloud_news_utils_parent_class = NULL;
static GType feed_reader_owncloud_news_utils_type_id = 0;

static GHashTable* __lambda4_ (FeedReaderOwncloudNewsUtils* self);
static void _g_free0_ (gpointer var);
static GHashTable* ___lambda4__feed_reader_password_get_attributes_func (gpointer self);
static GHashTable* __lambda5_ (FeedReaderOwncloudNewsUtils* self);
static GHashTable* ___lambda5__feed_reader_password_get_attributes_func (gpointer self);
static void feed_reader_owncloud_news_utils_finalize (GObject * obj);

static inline gpointer
feed_reader_owncloud_news_utils_get_instance_private (FeedReaderOwncloudNewsUtils* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderOwncloudNewsUtils_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GHashTable*
__lambda4_ (FeedReaderOwncloudNewsUtils* self)
{
	GHashTable* attributes = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable* result;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attributes = _tmp2_;
	_tmp3_ = g_strdup ("URL");
	_tmp4_ = feed_reader_owncloud_news_utils_getURL (self);
	g_hash_table_insert (attributes, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("Username");
	_tmp6_ = feed_reader_owncloud_news_utils_getUser (self);
	g_hash_table_insert (attributes, _tmp5_, _tmp6_);
	result = attributes;
	return result;
}

static GHashTable*
___lambda4__feed_reader_password_get_attributes_func (gpointer self)
{
	GHashTable* result;
	result = __lambda4_ ((FeedReaderOwncloudNewsUtils*) self);
	return result;
}

static GHashTable*
__lambda5_ (FeedReaderOwncloudNewsUtils* self)
{
	GHashTable* attributes = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* result;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attributes = _tmp2_;
	_tmp3_ = g_strdup ("URL");
	_tmp4_ = feed_reader_owncloud_news_utils_getURL (self);
	g_hash_table_insert (attributes, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("Username");
	_tmp6_ = feed_reader_owncloud_news_utils_getHtaccessUser (self);
	g_hash_table_insert (attributes, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("htaccess");
	_tmp8_ = g_strdup ("true");
	g_hash_table_insert (attributes, _tmp7_, _tmp8_);
	result = attributes;
	return result;
}

static GHashTable*
___lambda5__feed_reader_password_get_attributes_func (gpointer self)
{
	GHashTable* result;
	result = __lambda5_ ((FeedReaderOwncloudNewsUtils*) self);
	return result;
}

FeedReaderOwncloudNewsUtils*
feed_reader_owncloud_news_utils_construct (GType object_type,
                                           GSettingsBackend* settings_backend,
                                           SecretCollection* secrets)
{
	FeedReaderOwncloudNewsUtils * self = NULL;
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp2_;
	FeedReaderPassword* _tmp3_;
	SecretSchema* htAccessSchema = NULL;
	SecretSchema* _tmp4_;
	FeedReaderPassword* _tmp5_;
	g_return_val_if_fail (secrets != NULL, NULL);
	self = (FeedReaderOwncloudNewsUtils*) g_object_new (object_type, NULL);
	if (settings_backend != NULL) {
		GSettings* _tmp0_;
		_tmp0_ = g_settings_new_with_backend ("org.gnome.feedreader.owncloud", settings_backend);
		_g_object_unref0 (self->priv->m_settings);
		self->priv->m_settings = _tmp0_;
	} else {
		GSettings* _tmp1_;
		_tmp1_ = g_settings_new ("org.gnome.feedreader.owncloud");
		_g_object_unref0 (self->priv->m_settings);
		self->priv->m_settings = _tmp1_;
	}
	_tmp2_ = secret_schema_new ("org.gnome.feedreader.password", SECRET_SCHEMA_NONE, "URL", SECRET_SCHEMA_ATTRIBUTE_STRING, "Username", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp2_;
	_tmp3_ = feed_reader_password_new (secrets, pwSchema, "FeedReader: Nextcloud login", ___lambda4__feed_reader_password_get_attributes_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->m_password);
	self->priv->m_password = _tmp3_;
	_tmp4_ = secret_schema_new ("org.gnome.feedreader.password", SECRET_SCHEMA_NONE, "URL", SECRET_SCHEMA_ATTRIBUTE_STRING, "Username", SECRET_SCHEMA_ATTRIBUTE_STRING, "htaccess", SECRET_SCHEMA_ATTRIBUTE_BOOLEAN, NULL);
	htAccessSchema = _tmp4_;
	_tmp5_ = feed_reader_password_new (secrets, htAccessSchema, "FeedReader: Nextcloud login", ___lambda5__feed_reader_password_get_attributes_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->m_htaccess_password);
	self->priv->m_htaccess_password = _tmp5_;
	_secret_schema_unref0 (htAccessSchema);
	_secret_schema_unref0 (pwSchema);
	return self;
}

FeedReaderOwncloudNewsUtils*
feed_reader_owncloud_news_utils_new (GSettingsBackend* settings_backend,
                                     SecretCollection* secrets)
{
	return feed_reader_owncloud_news_utils_construct (FEED_READER_TYPE_OWNCLOUD_NEWS_UTILS, settings_backend, secrets);
}

gchar*
feed_reader_owncloud_news_utils_getURL (FeedReaderOwncloudNewsUtils* self)
{
	gchar* tmp_url = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "url");
	tmp_url = _tmp1_;
	_tmp2_ = tmp_url;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		const gchar* _tmp6_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp3_ = tmp_url;
		if (!g_str_has_suffix (_tmp3_, "/")) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = tmp_url;
			_tmp5_ = g_strconcat (_tmp4_, "/", NULL);
			_g_free0 (tmp_url);
			tmp_url = _tmp5_;
		}
		_tmp6_ = tmp_url;
		if (!g_str_has_suffix (_tmp6_, "/index.php/apps/news/api/v1-2/")) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = tmp_url;
			_tmp8_ = g_strconcat (_tmp7_, "index.php/apps/news/api/v1-2/", NULL);
			_g_free0 (tmp_url);
			tmp_url = _tmp8_;
		}
		_tmp10_ = tmp_url;
		if (!g_str_has_prefix (_tmp10_, "http://")) {
			const gchar* _tmp11_;
			_tmp11_ = tmp_url;
			_tmp9_ = !g_str_has_prefix (_tmp11_, "https://");
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = tmp_url;
			_tmp13_ = g_strconcat ("https://", _tmp12_, NULL);
			_g_free0 (tmp_url);
			tmp_url = _tmp13_;
		}
	}
	_tmp14_ = tmp_url;
	_tmp15_ = g_strconcat ("Nextcloud URL: ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	feed_reader_logger_debug (_tmp16_);
	_g_free0 (_tmp16_);
	result = tmp_url;
	return result;
}

void
feed_reader_owncloud_news_utils_setURL (FeedReaderOwncloudNewsUtils* self,
                                        const gchar* url)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_gsettingWriteString (_tmp0_, "url", url);
}

gchar*
feed_reader_owncloud_news_utils_getUser (FeedReaderOwncloudNewsUtils* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "username");
	result = _tmp1_;
	return result;
}

void
feed_reader_owncloud_news_utils_setUser (FeedReaderOwncloudNewsUtils* self,
                                         const gchar* user)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_gsettingWriteString (_tmp0_, "username", user);
}

gchar*
feed_reader_owncloud_news_utils_getHtaccessUser (FeedReaderOwncloudNewsUtils* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "htaccess-username");
	result = _tmp1_;
	return result;
}

void
feed_reader_owncloud_news_utils_setHtaccessUser (FeedReaderOwncloudNewsUtils* self,
                                                 const gchar* ht_user)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ht_user != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_gsettingWriteString (_tmp0_, "htaccess-username", ht_user);
}

gchar*
feed_reader_owncloud_news_utils_getUnmodifiedURL (FeedReaderOwncloudNewsUtils* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "url");
	result = _tmp1_;
	return result;
}

gchar*
feed_reader_owncloud_news_utils_getPasswd (FeedReaderOwncloudNewsUtils* self)
{
	FeedReaderPassword* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_password;
	_tmp1_ = feed_reader_password_get_password (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}

void
feed_reader_owncloud_news_utils_setPassword (FeedReaderOwncloudNewsUtils* self,
                                             const gchar* passwd)
{
	FeedReaderPassword* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (passwd != NULL);
	_tmp0_ = self->priv->m_password;
	feed_reader_password_set_password (_tmp0_, passwd, NULL);
}

void
feed_reader_owncloud_news_utils_resetAccount (FeedReaderOwncloudNewsUtils* self)
{
	GSettings* _tmp0_;
	FeedReaderPassword* _tmp1_;
	FeedReaderPassword* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_resetSettings (_tmp0_);
	_tmp1_ = self->priv->m_password;
	feed_reader_password_delete_password (_tmp1_, NULL);
	_tmp2_ = self->priv->m_htaccess_password;
	feed_reader_password_delete_password (_tmp2_, NULL);
}

gchar*
feed_reader_owncloud_news_utils_getHtaccessPasswd (FeedReaderOwncloudNewsUtils* self)
{
	FeedReaderPassword* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_htaccess_password;
	_tmp1_ = feed_reader_password_get_password (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}

void
feed_reader_owncloud_news_utils_setHtAccessPassword (FeedReaderOwncloudNewsUtils* self,
                                                     const gchar* passwd)
{
	FeedReaderPassword* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (passwd != NULL);
	_tmp0_ = self->priv->m_htaccess_password;
	feed_reader_password_set_password (_tmp0_, passwd, NULL);
}

gint
feed_reader_owncloud_news_utils_countUnread (FeedReaderOwncloudNewsUtils* self,
                                             GeeList* feeds,
                                             const gchar* id)
{
	gint unread = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (feeds != NULL, 0);
	g_return_val_if_fail (id != NULL, 0);
	unread = 0;
	{
		GeeList* _feed_list = NULL;
		gint _feed_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _feed_index = 0;
		_feed_list = feeds;
		_tmp0_ = _feed_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_feed_size = _tmp2_;
		_feed_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			FeedReaderFeed* feed = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			GeeList* ids = NULL;
			FeedReaderFeed* _tmp7_;
			GeeList* _tmp8_;
			_feed_index = _feed_index + 1;
			_tmp3_ = _feed_index;
			_tmp4_ = _feed_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _feed_list;
			_tmp6_ = gee_list_get (_tmp5_, _feed_index);
			feed = (FeedReaderFeed*) _tmp6_;
			_tmp7_ = feed;
			_tmp8_ = feed_reader_feed_getCatIDs (_tmp7_);
			ids = _tmp8_;
			{
				GeeList* _ID_list = NULL;
				GeeList* _tmp9_;
				gint _ID_size = 0;
				GeeList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _ID_index = 0;
				_tmp9_ = ids;
				_ID_list = _tmp9_;
				_tmp10_ = _ID_list;
				_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_ID_size = _tmp12_;
				_ID_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gchar* ID = NULL;
					GeeList* _tmp15_;
					gpointer _tmp16_;
					const gchar* _tmp17_;
					_ID_index = _ID_index + 1;
					_tmp13_ = _ID_index;
					_tmp14_ = _ID_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _ID_list;
					_tmp16_ = gee_list_get (_tmp15_, _ID_index);
					ID = (gchar*) _tmp16_;
					_tmp17_ = ID;
					if (g_strcmp0 (_tmp17_, id) == 0) {
						FeedReaderFeed* _tmp18_;
						_tmp18_ = feed;
						unread += (gint) feed_reader_feed_getUnread (_tmp18_);
						_g_free0 (ID);
						break;
					}
					_g_free0 (ID);
				}
			}
			_g_object_unref0 (ids);
			_g_object_unref0 (feed);
		}
	}
	result = unread;
	return result;
}

static void
feed_reader_owncloud_news_utils_class_init (FeedReaderOwncloudNewsUtilsClass * klass,
                                            gpointer klass_data)
{
	feed_reader_owncloud_news_utils_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderOwncloudNewsUtils_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_owncloud_news_utils_finalize;
}

static void
feed_reader_owncloud_news_utils_instance_init (FeedReaderOwncloudNewsUtils * self,
                                               gpointer klass)
{
	self->priv = feed_reader_owncloud_news_utils_get_instance_private (self);
}

static void
feed_reader_owncloud_news_utils_finalize (GObject * obj)
{
	FeedReaderOwncloudNewsUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_OWNCLOUD_NEWS_UTILS, FeedReaderOwncloudNewsUtils);
	_g_object_unref0 (self->priv->m_settings);
	_g_object_unref0 (self->priv->m_password);
	_g_object_unref0 (self->priv->m_htaccess_password);
	G_OBJECT_CLASS (feed_reader_owncloud_news_utils_parent_class)->finalize (obj);
}

GType
feed_reader_owncloud_news_utils_get_type (void)
{
	return feed_reader_owncloud_news_utils_type_id;
}

GType
feed_reader_owncloud_news_utils_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderOwncloudNewsUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_owncloud_news_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderOwncloudNewsUtils), 0, (GInstanceInitFunc) feed_reader_owncloud_news_utils_instance_init, NULL };
	feed_reader_owncloud_news_utils_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderOwncloudNewsUtils", &g_define_type_info, 0);
	FeedReaderOwncloudNewsUtils_private_offset = sizeof (FeedReaderOwncloudNewsUtilsPrivate);
	return feed_reader_owncloud_news_utils_type_id;
}

