/* ttrssAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from ttrssAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "ttrss.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <json-glib/json-glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

enum  {
	FEED_READER_TTRSS_API_0_PROPERTY,
	FEED_READER_TTRSS_API_M_TTRSS_URL_PROPERTY,
	FEED_READER_TTRSS_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_ttrss_api_properties[FEED_READER_TTRSS_API_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FeedReaderttrssAPIPrivate {
	gchar* _m_ttrss_url;
	FeedReaderttrssUtils* m_utils;
	gchar* m_ttrss_sessionid;
	gchar* m_iconDir;
	SoupSession* m_session;
};

static gint FeedReaderttrssAPI_private_offset;
static gpointer feed_reader_ttrss_api_parent_class = NULL;
static GType feed_reader_ttrss_api_type_id = 0;

static void __lambda6_ (FeedReaderttrssAPI* self,
                 SoupMessage* msg,
                 SoupAuth* auth,
                 gboolean retrying);
static void ___lambda6__soup_session_authenticate (SoupSession* _sender,
                                            SoupMessage* msg,
                                            SoupAuth* auth,
                                            gboolean retrying,
                                            gpointer self);
static void feed_reader_ttrss_api_set_m_ttrss_url (FeedReaderttrssAPI* self,
                                            const gchar* value);
static gboolean feed_reader_ttrss_api_haveAPIplugin (FeedReaderttrssAPI* self);
static void feed_reader_ttrss_api_getSubCategories (FeedReaderttrssAPI* self,
                                             GeeList* categories,
                                             JsonObject* categorie,
                                             gint level,
                                             const gchar* parent);
static gint feed_reader_ttrss_api_getUncategorizedUnread (FeedReaderttrssAPI* self);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static void feed_reader_ttrss_api_finalize (GObject * obj);
static void _vala_feed_reader_ttrss_api_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_feed_reader_ttrss_api_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
feed_reader_ttrss_api_get_instance_private (FeedReaderttrssAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderttrssAPI_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (FeedReaderttrssAPI* self,
            SoupMessage* msg,
            SoupAuth* auth,
            gboolean retrying)
{
	FeedReaderttrssUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (msg != NULL);
	g_return_if_fail (auth != NULL);
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_ttrss_utils_getHtaccessUser (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		feed_reader_logger_error ("TTRSS Session: need Authentication");
	} else {
		if (!retrying) {
			FeedReaderttrssUtils* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			FeedReaderttrssUtils* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = self->priv->m_utils;
			_tmp5_ = feed_reader_ttrss_utils_getHtaccessUser (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = self->priv->m_utils;
			_tmp8_ = feed_reader_ttrss_utils_getHtaccessPasswd (_tmp7_);
			_tmp9_ = _tmp8_;
			soup_auth_authenticate (auth, _tmp6_, _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp6_);
		}
	}
}

static void
___lambda6__soup_session_authenticate (SoupSession* _sender,
                                       SoupMessage* msg,
                                       SoupAuth* auth,
                                       gboolean retrying,
                                       gpointer self)
{
	__lambda6_ ((FeedReaderttrssAPI*) self, msg, auth, retrying);
}

FeedReaderttrssAPI*
feed_reader_ttrss_api_construct (GType object_type,
                                 FeedReaderttrssUtils* utils)
{
	FeedReaderttrssAPI * self = NULL;
	FeedReaderttrssUtils* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupSession* _tmp3_;
	SoupSession* _tmp4_;
	g_return_val_if_fail (utils != NULL, NULL);
	self = (FeedReaderttrssAPI*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (utils);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = soup_session_new ();
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp1_;
	_tmp2_ = self->priv->m_session;
	g_object_set (_tmp2_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp3_ = self->priv->m_session;
	g_object_set (_tmp3_, "ssl-strict", FALSE, NULL);
	_tmp4_ = self->priv->m_session;
	g_signal_connect_object (_tmp4_, "authenticate", (GCallback) ___lambda6__soup_session_authenticate, self, 0);
	return self;
}

FeedReaderttrssAPI*
feed_reader_ttrss_api_new (FeedReaderttrssUtils* utils)
{
	return feed_reader_ttrss_api_construct (FEED_READER_TYPE_TTRSS_API, utils);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

FeedReaderLoginResponse
feed_reader_ttrss_api_login (FeedReaderttrssAPI* self)
{
	gchar* username = NULL;
	FeedReaderttrssUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* passwd = NULL;
	FeedReaderttrssUtils* _tmp2_;
	gchar* _tmp3_;
	FeedReaderttrssUtils* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp18_;
	const gchar* _tmp19_;
	FeedReaderttrssMessage* _tmp20_;
	FeedReaderttrssMessage* _tmp21_;
	const gchar* _tmp22_;
	FeedReaderttrssMessage* _tmp25_;
	const gchar* _tmp26_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp27_;
	FeedReaderLoginResponse result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_logger_debug ("TTRSS: login");
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_ttrss_utils_getUser (_tmp0_);
	username = _tmp1_;
	_tmp2_ = self->priv->m_utils;
	_tmp3_ = feed_reader_ttrss_utils_getPasswd (_tmp2_);
	passwd = _tmp3_;
	_tmp4_ = self->priv->m_utils;
	_tmp5_ = feed_reader_ttrss_utils_getURL (_tmp4_);
	_tmp6_ = _tmp5_;
	feed_reader_ttrss_api_set_m_ttrss_url (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp9_ = self->priv->_m_ttrss_url;
	if (g_strcmp0 (_tmp9_, "") == 0) {
		const gchar* _tmp10_;
		_tmp10_ = username;
		_tmp8_ = g_strcmp0 (_tmp10_, "") == 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_;
		_tmp11_ = passwd;
		_tmp7_ = g_strcmp0 (_tmp11_, "") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		feed_reader_ttrss_api_set_m_ttrss_url (self, "example-host/tt-rss");
		result = FEED_READER_LOGIN_RESPONSE_ALL_EMPTY;
		_g_free0 (passwd);
		_g_free0 (username);
		return result;
	}
	_tmp12_ = self->priv->_m_ttrss_url;
	if (g_strcmp0 (_tmp12_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_URL;
		_g_free0 (passwd);
		_g_free0 (username);
		return result;
	}
	_tmp13_ = self->priv->_m_ttrss_url;
	_tmp14_ = g_uri_parse_scheme (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_ == NULL;
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		result = FEED_READER_LOGIN_RESPONSE_INVALID_URL;
		_g_free0 (passwd);
		_g_free0 (username);
		return result;
	}
	_tmp17_ = passwd;
	if (g_strcmp0 (_tmp17_, "") == 0) {
		result = FEED_READER_LOGIN_RESPONSE_MISSING_PASSWD;
		_g_free0 (passwd);
		_g_free0 (username);
		return result;
	}
	_tmp18_ = self->priv->m_session;
	_tmp19_ = self->priv->_m_ttrss_url;
	_tmp20_ = feed_reader_ttrss_message_new (_tmp18_, _tmp19_);
	message = _tmp20_;
	_tmp21_ = message;
	feed_reader_ttrss_message_add_string (_tmp21_, "op", "login");
	_tmp22_ = username;
	if (g_strcmp0 (_tmp22_, "") != 0) {
		FeedReaderttrssMessage* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = message;
		_tmp24_ = username;
		feed_reader_ttrss_message_add_string (_tmp23_, "user", _tmp24_);
	}
	_tmp25_ = message;
	_tmp26_ = passwd;
	feed_reader_ttrss_message_add_string (_tmp25_, "password", _tmp26_);
	_tmp27_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp27_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp28_;
		JsonObject* _tmp29_;
		JsonObject* _tmp30_;
		gchar* _tmp31_;
		gint* api_level = NULL;
		JsonObject* _tmp32_;
		gint* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gint* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp28_ = message;
		_tmp29_ = feed_reader_ttrss_message_get_response_object (_tmp28_);
		response = _tmp29_;
		_tmp30_ = response;
		_tmp31_ = feed_reader_untyped_json_object_get_string_member (_tmp30_, "session_id");
		_g_free0 (self->priv->m_ttrss_sessionid);
		self->priv->m_ttrss_sessionid = _tmp31_;
		_tmp32_ = response;
		_tmp33_ = feed_reader_untyped_json_object_get_int_member (_tmp32_, "api_level");
		api_level = _tmp33_;
		_tmp34_ = self->priv->m_ttrss_sessionid;
		_tmp35_ = g_strdup_printf ("TTRSS Session ID: %s", _tmp34_);
		_tmp36_ = _tmp35_;
		feed_reader_logger_info (_tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = api_level;
		_tmp38_ = g_strdup_printf ("TTRSS API Level: %lld", _tmp37_);
		_tmp39_ = _tmp38_;
		feed_reader_logger_info (_tmp39_);
		_g_free0 (_tmp39_);
		_tmp40_ = self->priv->_m_ttrss_url;
		_tmp41_ = feed_reader_ttrss_api_getIconDir (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = string_replace (_tmp40_, "api/", _tmp42_);
		_g_free0 (self->priv->m_iconDir);
		self->priv->m_iconDir = _tmp43_;
		_g_free0 (_tmp42_);
		if (feed_reader_ttrss_api_haveAPIplugin (self)) {
			result = FEED_READER_LOGIN_RESPONSE_SUCCESS;
			_g_free0 (api_level);
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			_g_free0 (passwd);
			_g_free0 (username);
			return result;
		}
		result = FEED_READER_LOGIN_RESPONSE_PLUGIN_NEEDED;
		_g_free0 (api_level);
		_json_object_unref0 (response);
		_g_object_unref0 (message);
		_g_free0 (passwd);
		_g_free0 (username);
		return result;
	}
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_API_ERROR)) {
		result = FEED_READER_LOGIN_RESPONSE_API_ERROR;
		_g_object_unref0 (message);
		_g_free0 (passwd);
		_g_free0 (username);
		return result;
	} else {
		if (status == ((gint) FEED_READER_CONNECTION_ERROR_NO_RESPONSE)) {
			result = FEED_READER_LOGIN_RESPONSE_NO_CONNECTION;
			_g_object_unref0 (message);
			_g_free0 (passwd);
			_g_free0 (username);
			return result;
		} else {
			if (status == ((gint) FEED_READER_CONNECTION_ERROR_API_DISABLED)) {
				result = FEED_READER_LOGIN_RESPONSE_NO_API_ACCESS;
				_g_object_unref0 (message);
				_g_free0 (passwd);
				_g_free0 (username);
				return result;
			} else {
				if (status == ((gint) FEED_READER_CONNECTION_ERROR_CA_ERROR)) {
					result = FEED_READER_LOGIN_RESPONSE_CA_ERROR;
					_g_object_unref0 (message);
					_g_free0 (passwd);
					_g_free0 (username);
					return result;
				} else {
					if (status == ((gint) FEED_READER_CONNECTION_ERROR_UNAUTHORIZED)) {
						result = FEED_READER_LOGIN_RESPONSE_UNAUTHORIZED;
						_g_object_unref0 (message);
						_g_free0 (passwd);
						_g_free0 (username);
						return result;
					}
				}
			}
		}
	}
	result = FEED_READER_LOGIN_RESPONSE_UNKNOWN_ERROR;
	_g_object_unref0 (message);
	_g_free0 (passwd);
	_g_free0 (username);
	return result;
}

gboolean
feed_reader_ttrss_api_logout (FeedReaderttrssAPI* self)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "logout");
	_tmp6_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp6_, FALSE);
	feed_reader_logger_warning ("TTRSS: logout");
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp7_;
		JsonObject* _tmp8_;
		gchar* _tmp9_;
		JsonObject* _tmp10_;
		_tmp7_ = message;
		_tmp8_ = feed_reader_ttrss_message_get_response_object (_tmp7_);
		response = _tmp8_;
		_tmp9_ = g_strdup ("");
		_g_free0 (self->priv->m_ttrss_sessionid);
		self->priv->m_ttrss_sessionid = _tmp9_;
		_tmp10_ = response;
		result = json_object_get_boolean_member (_tmp10_, "status");
		_json_object_unref0 (response);
		_g_object_unref0 (message);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_isloggedin (FeedReaderttrssAPI* self)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "isLoggedIn");
	_tmp6_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp6_, FALSE);
	feed_reader_logger_debug ("TTRSS: isloggedin?");
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp7_;
		JsonObject* _tmp8_;
		JsonObject* _tmp9_;
		_tmp7_ = message;
		_tmp8_ = feed_reader_ttrss_message_get_response_object (_tmp7_);
		response = _tmp8_;
		_tmp9_ = response;
		result = json_object_get_boolean_member (_tmp9_, "status");
		_json_object_unref0 (response);
		_g_object_unref0 (message);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

static gboolean
feed_reader_ttrss_api_haveAPIplugin (FeedReaderttrssAPI* self)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "removeLabel");
	_tmp6_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp6_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_API_ERROR)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp7_;
		JsonObject* _tmp8_;
		JsonObject* _tmp9_;
		_tmp7_ = message;
		_tmp8_ = feed_reader_ttrss_message_get_response_object (_tmp7_);
		response = _tmp8_;
		_tmp9_ = response;
		if (json_object_has_member (_tmp9_, "error")) {
			JsonObject* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = response;
			_tmp11_ = json_object_get_string_member (_tmp10_, "error");
			if (g_strcmp0 (_tmp11_, "INCORRECT_USAGE") == 0) {
				result = TRUE;
				_json_object_unref0 (response);
				_g_object_unref0 (message);
				return result;
			}
		}
		_json_object_unref0 (response);
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gint
feed_reader_ttrss_api_getUnreadCount (FeedReaderttrssAPI* self)
{
	gint unread = 0;
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp6_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	unread = 0;
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getUnread");
	_tmp6_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp6_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp7_;
		JsonObject* _tmp8_;
		gint* maybe_unread = NULL;
		JsonObject* _tmp9_;
		gint* _tmp10_;
		gint* _tmp11_;
		_tmp7_ = message;
		_tmp8_ = feed_reader_ttrss_message_get_response_object (_tmp7_);
		response = _tmp8_;
		_tmp9_ = response;
		_tmp10_ = feed_reader_untyped_json_object_get_int_member (_tmp9_, "unread");
		maybe_unread = _tmp10_;
		_tmp11_ = maybe_unread;
		if (_tmp11_ != NULL) {
			gint* _tmp12_;
			_tmp12_ = maybe_unread;
			unread = *_tmp12_;
		} else {
			feed_reader_logger_warning ("Could not parse unread articles");
		}
		_g_free0 (maybe_unread);
		_json_object_unref0 (response);
	}
	_tmp13_ = g_strdup_printf ("There are %i unread articles", unread);
	_tmp14_ = _tmp13_;
	feed_reader_logger_info (_tmp14_);
	_g_free0 (_tmp14_);
	result = unread;
	_g_object_unref0 (message);
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

gboolean
feed_reader_ttrss_api_getFeeds (FeedReaderttrssAPI* self,
                                GeeList* feeds,
                                GeeList* categories)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	{
		GeeList* _item_list = NULL;
		gint _item_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _item_index = 0;
		_item_list = categories;
		_tmp0_ = _item_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_item_size = _tmp2_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			FeedReaderCategory* item = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			FeedReaderCategory* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_item_index = _item_index + 1;
			_tmp3_ = _item_index;
			_tmp4_ = _item_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _item_list;
			_tmp6_ = gee_list_get (_tmp5_, _item_index);
			item = (FeedReaderCategory*) _tmp6_;
			_tmp7_ = item;
			_tmp8_ = feed_reader_category_getCatID (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = atoi (_tmp9_) > 0;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				FeedReaderttrssMessage* message = NULL;
				SoupSession* _tmp11_;
				const gchar* _tmp12_;
				FeedReaderttrssMessage* _tmp13_;
				FeedReaderttrssMessage* _tmp14_;
				const gchar* _tmp15_;
				FeedReaderttrssMessage* _tmp16_;
				FeedReaderttrssMessage* _tmp17_;
				FeedReaderCategory* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gint status = 0;
				FeedReaderttrssMessage* _tmp21_;
				_tmp11_ = self->priv->m_session;
				_tmp12_ = self->priv->_m_ttrss_url;
				_tmp13_ = feed_reader_ttrss_message_new (_tmp11_, _tmp12_);
				message = _tmp13_;
				_tmp14_ = message;
				_tmp15_ = self->priv->m_ttrss_sessionid;
				feed_reader_ttrss_message_add_string (_tmp14_, "sid", _tmp15_);
				_tmp16_ = message;
				feed_reader_ttrss_message_add_string (_tmp16_, "op", "getFeeds");
				_tmp17_ = message;
				_tmp18_ = item;
				_tmp19_ = feed_reader_category_getCatID (_tmp18_);
				_tmp20_ = _tmp19_;
				feed_reader_ttrss_message_add_int (_tmp17_, "cat_id", atoi (_tmp20_));
				_g_free0 (_tmp20_);
				_tmp21_ = message;
				status = (gint) feed_reader_ttrss_message_send (_tmp21_, FALSE);
				if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
					JsonArray* response = NULL;
					FeedReaderttrssMessage* _tmp22_;
					JsonArray* _tmp23_;
					guint feed_count = 0U;
					JsonArray* _tmp24_;
					_tmp22_ = message;
					_tmp23_ = feed_reader_ttrss_message_get_response_array (_tmp22_);
					response = _tmp23_;
					_tmp24_ = response;
					feed_count = json_array_get_length (_tmp24_);
					{
						guint i = 0U;
						i = (guint) 0;
						{
							gboolean _tmp25_ = FALSE;
							_tmp25_ = TRUE;
							while (TRUE) {
								JsonObject* feed_node = NULL;
								JsonArray* _tmp27_;
								JsonObject* _tmp28_;
								JsonObject* _tmp29_;
								gchar* feed_id = NULL;
								JsonObject* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_ = NULL;
								JsonObject* _tmp33_;
								gchar* icon_url = NULL;
								gchar* _tmp39_;
								const gchar* _tmp40_;
								JsonObject* _tmp41_;
								const gchar* _tmp42_;
								JsonObject* _tmp43_;
								const gchar* _tmp44_;
								JsonObject* _tmp45_;
								gint* _tmp46_;
								gint* _tmp47_;
								JsonObject* _tmp48_;
								gchar* _tmp49_;
								gchar* _tmp50_;
								GeeList* _tmp51_;
								GeeList* _tmp52_;
								const gchar* _tmp53_;
								JsonObject* _tmp54_;
								const gchar* _tmp55_;
								FeedReaderFeed* _tmp56_;
								FeedReaderFeed* _tmp57_;
								if (!_tmp25_) {
									guint _tmp26_;
									_tmp26_ = i;
									i = _tmp26_ + 1;
								}
								_tmp25_ = FALSE;
								if (!(i < feed_count)) {
									break;
								}
								_tmp27_ = response;
								_tmp28_ = json_array_get_object_element (_tmp27_, (feed_count - i) - 1);
								_tmp29_ = _json_object_ref0 (_tmp28_);
								feed_node = _tmp29_;
								_tmp30_ = feed_node;
								_tmp31_ = feed_reader_untyped_json_object_get_string_member (_tmp30_, "id");
								feed_id = _tmp31_;
								_tmp33_ = feed_node;
								if (json_object_get_boolean_member (_tmp33_, "has_icon")) {
									const gchar* _tmp34_;
									const gchar* _tmp35_;
									gchar* _tmp36_;
									gchar* _tmp37_;
									gchar* _tmp38_;
									_tmp34_ = self->priv->m_iconDir;
									_tmp35_ = feed_id;
									_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
									_tmp37_ = _tmp36_;
									_tmp38_ = g_strconcat (_tmp37_, ".ico", NULL);
									_g_free0 (_tmp32_);
									_tmp32_ = _tmp38_;
									_g_free0 (_tmp37_);
								} else {
									_g_free0 (_tmp32_);
									_tmp32_ = NULL;
								}
								_tmp39_ = g_strdup (_tmp32_);
								icon_url = _tmp39_;
								_tmp40_ = feed_id;
								_tmp41_ = feed_node;
								_tmp42_ = json_object_get_string_member (_tmp41_, "title");
								_tmp43_ = feed_node;
								_tmp44_ = json_object_get_string_member (_tmp43_, "feed_url");
								_tmp45_ = feed_node;
								_tmp46_ = feed_reader_untyped_json_object_get_int_member (_tmp45_, "unread");
								_tmp47_ = _tmp46_;
								_tmp48_ = feed_node;
								_tmp49_ = feed_reader_untyped_json_object_get_string_member (_tmp48_, "cat_id");
								_tmp50_ = _tmp49_;
								_tmp51_ = feed_reader_list_utils_single (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp50_);
								_tmp52_ = _tmp51_;
								_tmp53_ = icon_url;
								_tmp54_ = feed_node;
								_tmp55_ = json_object_get_string_member (_tmp54_, "feed_url");
								_tmp56_ = feed_reader_feed_new (_tmp40_, _tmp42_, _tmp44_, *_tmp47_, _tmp52_, _tmp53_, _tmp55_);
								_tmp57_ = _tmp56_;
								gee_collection_add ((GeeCollection*) feeds, _tmp57_);
								_g_object_unref0 (_tmp57_);
								_g_object_unref0 (_tmp52_);
								_g_free0 (_tmp50_);
								_g_free0 (_tmp47_);
								_g_free0 (icon_url);
								_g_free0 (_tmp32_);
								_g_free0 (feed_id);
								_json_object_unref0 (feed_node);
							}
						}
					}
					_json_array_unref0 (response);
				} else {
					result = FALSE;
					_g_object_unref0 (message);
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (message);
			}
			_g_object_unref0 (item);
		}
	}
	result = TRUE;
	return result;
}

gboolean
feed_reader_ttrss_api_getUncategorizedFeeds (FeedReaderttrssAPI* self,
                                             GeeList* feeds)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feeds != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getFeeds");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_int (_tmp6_, "cat_id", 0);
	_tmp7_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp7_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonArray* response = NULL;
		FeedReaderttrssMessage* _tmp8_;
		JsonArray* _tmp9_;
		guint feed_count = 0U;
		JsonArray* _tmp10_;
		_tmp8_ = message;
		_tmp9_ = feed_reader_ttrss_message_get_response_array (_tmp8_);
		response = _tmp9_;
		_tmp10_ = response;
		feed_count = json_array_get_length (_tmp10_);
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					JsonObject* feed_node = NULL;
					JsonArray* _tmp13_;
					JsonObject* _tmp14_;
					JsonObject* _tmp15_;
					gchar* feed_id = NULL;
					JsonObject* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_ = NULL;
					JsonObject* _tmp19_;
					gchar* icon_url = NULL;
					gchar* _tmp25_;
					const gchar* _tmp26_;
					JsonObject* _tmp27_;
					const gchar* _tmp28_;
					JsonObject* _tmp29_;
					const gchar* _tmp30_;
					JsonObject* _tmp31_;
					gint* _tmp32_;
					gint* _tmp33_;
					JsonObject* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					GeeList* _tmp37_;
					GeeList* _tmp38_;
					const gchar* _tmp39_;
					JsonObject* _tmp40_;
					const gchar* _tmp41_;
					FeedReaderFeed* _tmp42_;
					FeedReaderFeed* _tmp43_;
					if (!_tmp11_) {
						guint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					if (!(i < feed_count)) {
						break;
					}
					_tmp13_ = response;
					_tmp14_ = json_array_get_object_element (_tmp13_, (feed_count - i) - 1);
					_tmp15_ = _json_object_ref0 (_tmp14_);
					feed_node = _tmp15_;
					_tmp16_ = feed_node;
					_tmp17_ = feed_reader_untyped_json_object_get_string_member (_tmp16_, "id");
					feed_id = _tmp17_;
					_tmp19_ = feed_node;
					if (json_object_get_boolean_member (_tmp19_, "has_icon")) {
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp20_ = self->priv->m_iconDir;
						_tmp21_ = feed_id;
						_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_strconcat (_tmp23_, ".ico", NULL);
						_g_free0 (_tmp18_);
						_tmp18_ = _tmp24_;
						_g_free0 (_tmp23_);
					} else {
						_g_free0 (_tmp18_);
						_tmp18_ = NULL;
					}
					_tmp25_ = g_strdup (_tmp18_);
					icon_url = _tmp25_;
					_tmp26_ = feed_id;
					_tmp27_ = feed_node;
					_tmp28_ = json_object_get_string_member (_tmp27_, "title");
					_tmp29_ = feed_node;
					_tmp30_ = json_object_get_string_member (_tmp29_, "feed_url");
					_tmp31_ = feed_node;
					_tmp32_ = feed_reader_untyped_json_object_get_int_member (_tmp31_, "unread");
					_tmp33_ = _tmp32_;
					_tmp34_ = feed_node;
					_tmp35_ = feed_reader_untyped_json_object_get_string_member (_tmp34_, "cat_id");
					_tmp36_ = _tmp35_;
					_tmp37_ = feed_reader_list_utils_single (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = icon_url;
					_tmp40_ = feed_node;
					_tmp41_ = json_object_get_string_member (_tmp40_, "feed_url");
					_tmp42_ = feed_reader_feed_new (_tmp26_, _tmp28_, _tmp30_, *_tmp33_, _tmp38_, _tmp39_, _tmp41_);
					_tmp43_ = _tmp42_;
					gee_collection_add ((GeeCollection*) feeds, _tmp43_);
					_g_object_unref0 (_tmp43_);
					_g_object_unref0 (_tmp38_);
					_g_free0 (_tmp36_);
					_g_free0 (_tmp33_);
					_g_free0 (icon_url);
					_g_free0 (_tmp18_);
					_g_free0 (feed_id);
					_json_object_unref0 (feed_node);
				}
			}
		}
		result = TRUE;
		_json_array_unref0 (response);
		_g_object_unref0 (message);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_getTags (FeedReaderttrssAPI* self,
                               GeeList* tags)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getLabels");
	_tmp6_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp6_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonArray* response = NULL;
		FeedReaderttrssMessage* _tmp7_;
		JsonArray* _tmp8_;
		guint tag_count = 0U;
		JsonArray* _tmp9_;
		FeedReaderDataBaseReadOnly* db = NULL;
		FeedReaderDataBaseReadOnly* _tmp10_;
		_tmp7_ = message;
		_tmp8_ = feed_reader_ttrss_message_get_response_array (_tmp7_);
		response = _tmp8_;
		_tmp9_ = response;
		tag_count = json_array_get_length (_tmp9_);
		_tmp10_ = feed_reader_data_base_readOnly ();
		db = _tmp10_;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					JsonObject* tag_node = NULL;
					JsonArray* _tmp13_;
					JsonObject* _tmp14_;
					JsonObject* _tmp15_;
					JsonObject* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					JsonObject* _tmp19_;
					const gchar* _tmp20_;
					FeedReaderDataBaseReadOnly* _tmp21_;
					FeedReaderTag* _tmp22_;
					FeedReaderTag* _tmp23_;
					if (!_tmp11_) {
						guint _tmp12_;
						i = i + 1;
						_tmp12_ = i;
					}
					_tmp11_ = FALSE;
					if (!(i < tag_count)) {
						break;
					}
					_tmp13_ = response;
					_tmp14_ = json_array_get_object_element (_tmp13_, i);
					_tmp15_ = _json_object_ref0 (_tmp14_);
					tag_node = _tmp15_;
					_tmp16_ = tag_node;
					_tmp17_ = feed_reader_untyped_json_object_get_string_member (_tmp16_, "id");
					_tmp18_ = _tmp17_;
					_tmp19_ = tag_node;
					_tmp20_ = json_object_get_string_member (_tmp19_, "caption");
					_tmp21_ = db;
					_tmp22_ = feed_reader_tag_new (_tmp18_, _tmp20_, feed_reader_data_base_read_only_getTagColor (_tmp21_));
					_tmp23_ = _tmp22_;
					gee_collection_add ((GeeCollection*) tags, _tmp23_);
					_g_object_unref0 (_tmp23_);
					_g_free0 (_tmp18_);
					_json_object_unref0 (tag_node);
				}
			}
		}
		result = TRUE;
		_g_object_unref0 (db);
		_json_array_unref0 (response);
		_g_object_unref0 (message);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gchar*
feed_reader_ttrss_api_getIconDir (FeedReaderttrssAPI* self)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getConfig");
	_tmp6_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp6_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp7_;
		JsonObject* _tmp8_;
		JsonObject* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = message;
		_tmp8_ = feed_reader_ttrss_message_get_response_object (_tmp7_);
		response = _tmp8_;
		_tmp9_ = response;
		_tmp10_ = json_object_get_string_member (_tmp9_, "icons_url");
		_tmp11_ = g_strconcat (_tmp10_, "/", NULL);
		result = _tmp11_;
		_json_object_unref0 (response);
		_g_object_unref0 (message);
		return result;
	}
	result = NULL;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_getCategories (FeedReaderttrssAPI* self,
                                     GeeList* categories)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getFeedTree");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_bool (_tmp6_, "include_empty", TRUE);
	_tmp7_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp7_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp8_;
		JsonObject* _tmp9_;
		JsonObject* _tmp10_;
		_tmp8_ = message;
		_tmp9_ = feed_reader_ttrss_message_get_response_object (_tmp8_);
		response = _tmp9_;
		_tmp10_ = response;
		if (json_object_has_member (_tmp10_, "categories")) {
			JsonObject* category_object = NULL;
			JsonObject* _tmp11_;
			JsonObject* _tmp12_;
			JsonObject* _tmp13_;
			JsonObject* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp11_ = response;
			_tmp12_ = json_object_get_object_member (_tmp11_, "categories");
			_tmp13_ = _json_object_ref0 (_tmp12_);
			category_object = _tmp13_;
			_tmp14_ = category_object;
			_tmp15_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
			_tmp16_ = _tmp15_;
			feed_reader_ttrss_api_getSubCategories (self, categories, _tmp14_, 0, _tmp16_);
			_g_free0 (_tmp16_);
			result = TRUE;
			_json_object_unref0 (category_object);
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			return result;
		}
		_json_object_unref0 (response);
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
feed_reader_ttrss_api_getSubCategories (FeedReaderttrssAPI* self,
                                        GeeList* categories,
                                        JsonObject* categorie,
                                        gint level,
                                        const gchar* parent)
{
	gint _tmp0_;
	gint orderID = 0;
	JsonArray* subcategorie = NULL;
	JsonArray* _tmp1_;
	JsonArray* _tmp2_;
	guint items_count = 0U;
	JsonArray* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (categories != NULL);
	g_return_if_fail (categorie != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = level;
	level = _tmp0_ + 1;
	orderID = 0;
	_tmp1_ = json_object_get_array_member (categorie, "items");
	_tmp2_ = _json_array_ref0 (_tmp1_);
	subcategorie = _tmp2_;
	_tmp3_ = subcategorie;
	items_count = json_array_get_length (_tmp3_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				JsonObject* categorie_node = NULL;
				JsonArray* _tmp6_;
				JsonObject* _tmp7_;
				JsonObject* _tmp8_;
				gchar* catID = NULL;
				JsonObject* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < items_count)) {
					break;
				}
				_tmp6_ = subcategorie;
				_tmp7_ = json_array_get_object_element (_tmp6_, i);
				_tmp8_ = _json_object_ref0 (_tmp7_);
				categorie_node = _tmp8_;
				_tmp9_ = categorie_node;
				_tmp10_ = feed_reader_untyped_json_object_get_string_member (_tmp9_, "id");
				catID = _tmp10_;
				_tmp11_ = catID;
				if (g_str_has_prefix (_tmp11_, "CAT:")) {
					gint _tmp12_;
					gchar* categorieID = NULL;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gchar* _tmp17_;
					const gchar* _tmp18_;
					JsonObject* _tmp31_;
					const gchar* _tmp32_;
					_tmp12_ = orderID;
					orderID = _tmp12_ + 1;
					_tmp13_ = catID;
					_tmp14_ = catID;
					_tmp15_ = strlen (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = string_slice (_tmp13_, (glong) 4, (glong) _tmp16_);
					categorieID = _tmp17_;
					_tmp18_ = categorieID;
					if (atoi (_tmp18_) > 0) {
						gchar* title = NULL;
						JsonObject* _tmp19_;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						gint unread_count = 0;
						JsonObject* _tmp22_;
						gint* _tmp23_;
						gint* _tmp24_;
						gint _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						FeedReaderCategory* _tmp29_;
						FeedReaderCategory* _tmp30_;
						_tmp19_ = categorie_node;
						_tmp20_ = json_object_get_string_member (_tmp19_, "name");
						_tmp21_ = g_strdup (_tmp20_);
						title = _tmp21_;
						_tmp22_ = categorie_node;
						_tmp23_ = feed_reader_untyped_json_object_get_int_member (_tmp22_, "unread");
						_tmp24_ = _tmp23_;
						_tmp25_ = *_tmp24_;
						_g_free0 (_tmp24_);
						unread_count = _tmp25_;
						_tmp26_ = title;
						if (g_strcmp0 (_tmp26_, "Uncategorized") == 0) {
							unread_count = feed_reader_ttrss_api_getUncategorizedUnread (self);
						}
						_tmp27_ = categorieID;
						_tmp28_ = title;
						_tmp29_ = feed_reader_category_new (_tmp27_, _tmp28_, (guint) unread_count, orderID, parent, level);
						_tmp30_ = _tmp29_;
						gee_collection_add ((GeeCollection*) categories, _tmp30_);
						_g_object_unref0 (_tmp30_);
						_g_free0 (title);
					}
					_tmp31_ = categorie_node;
					_tmp32_ = categorieID;
					feed_reader_ttrss_api_getSubCategories (self, categories, _tmp31_, level, _tmp32_);
					_g_free0 (categorieID);
				}
				_g_free0 (catID);
				_json_object_unref0 (categorie_node);
			}
		}
	}
	_json_array_unref0 (subcategorie);
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gint
feed_reader_ttrss_api_getUncategorizedUnread (FeedReaderttrssAPI* self)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getCounters");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_string (_tmp6_, "output_mode", "c");
	_tmp7_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp7_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonArray* response = NULL;
		FeedReaderttrssMessage* _tmp8_;
		JsonArray* _tmp9_;
		guint categorie_count = 0U;
		JsonArray* _tmp10_;
		_tmp8_ = message;
		_tmp9_ = feed_reader_ttrss_message_get_response_array (_tmp8_);
		response = _tmp9_;
		_tmp10_ = response;
		categorie_count = json_array_get_length (_tmp10_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					JsonObject* categorie_node = NULL;
					JsonArray* _tmp13_;
					JsonObject* _tmp14_;
					JsonObject* _tmp15_;
					JsonObject* _tmp16_;
					gint* _tmp17_;
					gint* _tmp18_;
					gint _tmp19_;
					gboolean _tmp20_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					if (!(((guint) i) < categorie_count)) {
						break;
					}
					_tmp13_ = response;
					_tmp14_ = json_array_get_object_element (_tmp13_, (guint) i);
					_tmp15_ = _json_object_ref0 (_tmp14_);
					categorie_node = _tmp15_;
					_tmp16_ = categorie_node;
					_tmp17_ = feed_reader_untyped_json_object_get_int_member (_tmp16_, "id");
					_tmp18_ = _tmp17_;
					_tmp19_ = 0;
					_tmp20_ = _int_equal (_tmp18_, &_tmp19_) == TRUE;
					_g_free0 (_tmp18_);
					if (_tmp20_) {
						JsonObject* _tmp21_;
						_tmp21_ = categorie_node;
						if (json_object_has_member (_tmp21_, "kind")) {
							JsonObject* _tmp22_;
							const gchar* _tmp23_;
							_tmp22_ = categorie_node;
							_tmp23_ = json_object_get_string_member (_tmp22_, "kind");
							if (g_strcmp0 (_tmp23_, "cat") == 0) {
								JsonObject* _tmp24_;
								gint* _tmp25_;
								gint* _tmp26_;
								gint _tmp27_;
								_tmp24_ = categorie_node;
								_tmp25_ = feed_reader_untyped_json_object_get_int_member (_tmp24_, "counter");
								_tmp26_ = _tmp25_;
								_tmp27_ = *_tmp26_;
								_g_free0 (_tmp26_);
								result = _tmp27_;
								_json_object_unref0 (categorie_node);
								_json_array_unref0 (response);
								_g_object_unref0 (message);
								return result;
							}
						}
					}
					_json_object_unref0 (categorie_node);
				}
			}
		}
		_json_array_unref0 (response);
	}
	result = 0;
	_g_object_unref0 (message);
	return result;
}

void
feed_reader_ttrss_api_getHeadlines (FeedReaderttrssAPI* self,
                                    GeeList* articles,
                                    gint skip,
                                    gint limit,
                                    FeedReaderArticleStatus whatToGet,
                                    gint feedID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	FeedReaderttrssMessage* _tmp7_;
	FeedReaderttrssMessage* _tmp8_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (articles != NULL);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getHeadlines");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_int (_tmp6_, "feed_id", feedID);
	_tmp7_ = message;
	feed_reader_ttrss_message_add_int (_tmp7_, "limit", limit);
	_tmp8_ = message;
	feed_reader_ttrss_message_add_int (_tmp8_, "skip", skip);
	switch (whatToGet) {
		case FEED_READER_ARTICLE_STATUS_ALL:
		{
			FeedReaderttrssMessage* _tmp9_;
			_tmp9_ = message;
			feed_reader_ttrss_message_add_string (_tmp9_, "view_mode", "all_articles");
			break;
		}
		case FEED_READER_ARTICLE_STATUS_UNREAD:
		{
			FeedReaderttrssMessage* _tmp10_;
			_tmp10_ = message;
			feed_reader_ttrss_message_add_string (_tmp10_, "view_mode", "unread");
			break;
		}
		case FEED_READER_ARTICLE_STATUS_MARKED:
		{
			FeedReaderttrssMessage* _tmp11_;
			_tmp11_ = message;
			feed_reader_ttrss_message_add_string (_tmp11_, "view_mode", "marked");
			break;
		}
		default:
		break;
	}
	_tmp12_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp12_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonArray* response = NULL;
		FeedReaderttrssMessage* _tmp13_;
		JsonArray* _tmp14_;
		guint headline_count = 0U;
		JsonArray* _tmp15_;
		_tmp13_ = message;
		_tmp14_ = feed_reader_ttrss_message_get_response_array (_tmp13_);
		response = _tmp14_;
		_tmp15_ = response;
		headline_count = json_array_get_length (_tmp15_);
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					JsonObject* headline_node = NULL;
					JsonArray* _tmp18_;
					JsonObject* _tmp19_;
					JsonObject* _tmp20_;
					GeeList* tags = NULL;
					JsonObject* _tmp21_;
					GeeArrayList* enclosures = NULL;
					GeeArrayList* _tmp35_;
					JsonObject* _tmp36_;
					FeedReaderArticleStatus _tmp57_ = 0;
					JsonObject* _tmp58_;
					FeedReaderArticleStatus _tmp59_ = 0;
					JsonObject* _tmp60_;
					FeedReaderArticle* Article = NULL;
					JsonObject* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					JsonObject* _tmp64_;
					const gchar* _tmp65_;
					JsonObject* _tmp66_;
					const gchar* _tmp67_;
					JsonObject* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					JsonObject* _tmp71_;
					const gchar* _tmp72_;
					JsonObject* _tmp73_;
					gint* _tmp74_;
					gint* _tmp75_;
					GDateTime* _tmp76_;
					GDateTime* _tmp77_;
					GeeList* _tmp78_;
					GeeArrayList* _tmp79_;
					FeedReaderArticle* _tmp80_;
					FeedReaderArticle* _tmp81_;
					FeedReaderArticle* _tmp82_;
					if (!_tmp16_) {
						guint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					if (!(i < headline_count)) {
						break;
					}
					_tmp18_ = response;
					_tmp19_ = json_array_get_object_element (_tmp18_, i);
					_tmp20_ = _json_object_ref0 (_tmp19_);
					headline_node = _tmp20_;
					tags = NULL;
					_tmp21_ = headline_node;
					if (json_object_has_member (_tmp21_, "labels")) {
						JsonArray* labels = NULL;
						JsonObject* _tmp22_;
						JsonArray* _tmp23_;
						JsonArray* _tmp24_;
						guint tag_count = 0U;
						JsonArray* _tmp25_;
						_tmp22_ = headline_node;
						_tmp23_ = json_object_get_array_member (_tmp22_, "labels");
						_tmp24_ = _json_array_ref0 (_tmp23_);
						labels = _tmp24_;
						tag_count = (guint) 0;
						_tmp25_ = labels;
						if (_tmp25_ != NULL) {
							JsonArray* _tmp26_;
							_tmp26_ = labels;
							tag_count = json_array_get_length (_tmp26_);
						}
						if (tag_count > ((guint) 0)) {
							GeeArrayList* _tmp27_;
							_tmp27_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
							_g_object_unref0 (tags);
							tags = (GeeList*) _tmp27_;
							{
								gint j = 0;
								j = 0;
								{
									gboolean _tmp28_ = FALSE;
									_tmp28_ = TRUE;
									while (TRUE) {
										GeeList* _tmp30_;
										JsonArray* _tmp31_;
										JsonArray* _tmp32_;
										gchar* _tmp33_;
										gchar* _tmp34_;
										if (!_tmp28_) {
											gint _tmp29_;
											j = j + 1;
											_tmp29_ = j;
										}
										_tmp28_ = FALSE;
										if (!(((guint) j) < tag_count)) {
											break;
										}
										_tmp30_ = tags;
										_tmp31_ = labels;
										_tmp32_ = json_array_get_array_element (_tmp31_, (guint) j);
										_tmp33_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_array_get_int_element (_tmp32_, (guint) 0));
										_tmp34_ = _tmp33_;
										gee_collection_add ((GeeCollection*) _tmp30_, _tmp34_);
										_g_free0 (_tmp34_);
									}
								}
							}
						}
						_json_array_unref0 (labels);
					}
					_tmp35_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					enclosures = _tmp35_;
					_tmp36_ = headline_node;
					if (json_object_has_member (_tmp36_, "attachments")) {
						JsonArray* attachments = NULL;
						JsonObject* _tmp37_;
						JsonArray* _tmp38_;
						JsonArray* _tmp39_;
						guint mediaCount = 0U;
						JsonArray* _tmp40_;
						_tmp37_ = headline_node;
						_tmp38_ = json_object_get_array_member (_tmp37_, "attachments");
						_tmp39_ = _json_array_ref0 (_tmp38_);
						attachments = _tmp39_;
						mediaCount = (guint) 0;
						_tmp40_ = attachments;
						if (_tmp40_ != NULL) {
							JsonArray* _tmp41_;
							_tmp41_ = attachments;
							mediaCount = json_array_get_length (_tmp41_);
						}
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp42_ = FALSE;
								_tmp42_ = TRUE;
								while (TRUE) {
									JsonObject* attachment = NULL;
									JsonArray* _tmp44_;
									JsonObject* _tmp45_;
									JsonObject* _tmp46_;
									GeeArrayList* _tmp47_;
									JsonObject* _tmp48_;
									gchar* _tmp49_;
									gchar* _tmp50_;
									JsonObject* _tmp51_;
									const gchar* _tmp52_;
									JsonObject* _tmp53_;
									const gchar* _tmp54_;
									FeedReaderEnclosure* _tmp55_;
									FeedReaderEnclosure* _tmp56_;
									if (!_tmp42_) {
										gint _tmp43_;
										j = j + 1;
										_tmp43_ = j;
									}
									_tmp42_ = FALSE;
									if (!(((guint) j) < mediaCount)) {
										break;
									}
									_tmp44_ = attachments;
									_tmp45_ = json_array_get_object_element (_tmp44_, (guint) j);
									_tmp46_ = _json_object_ref0 (_tmp45_);
									attachment = _tmp46_;
									_tmp47_ = enclosures;
									_tmp48_ = headline_node;
									_tmp49_ = feed_reader_untyped_json_object_get_string_member (_tmp48_, "id");
									_tmp50_ = _tmp49_;
									_tmp51_ = attachment;
									_tmp52_ = json_object_get_string_member (_tmp51_, "content_url");
									_tmp53_ = attachment;
									_tmp54_ = json_object_get_string_member (_tmp53_, "content_type");
									_tmp55_ = feed_reader_enclosure_new (_tmp50_, _tmp52_, feed_reader_enclosure_type_from_string (_tmp54_));
									_tmp56_ = _tmp55_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, _tmp56_);
									_g_object_unref0 (_tmp56_);
									_g_free0 (_tmp50_);
									_json_object_unref0 (attachment);
								}
							}
						}
						_json_array_unref0 (attachments);
					}
					_tmp58_ = headline_node;
					if (json_object_get_boolean_member (_tmp58_, "unread")) {
						_tmp57_ = FEED_READER_ARTICLE_STATUS_UNREAD;
					} else {
						_tmp57_ = FEED_READER_ARTICLE_STATUS_READ;
					}
					_tmp60_ = headline_node;
					if (json_object_get_boolean_member (_tmp60_, "marked")) {
						_tmp59_ = FEED_READER_ARTICLE_STATUS_MARKED;
					} else {
						_tmp59_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
					}
					_tmp61_ = headline_node;
					_tmp62_ = feed_reader_untyped_json_object_get_string_member (_tmp61_, "id");
					_tmp63_ = _tmp62_;
					_tmp64_ = headline_node;
					_tmp65_ = json_object_get_string_member (_tmp64_, "title");
					_tmp66_ = headline_node;
					_tmp67_ = json_object_get_string_member (_tmp66_, "link");
					_tmp68_ = headline_node;
					_tmp69_ = feed_reader_untyped_json_object_get_string_member (_tmp68_, "feed_id");
					_tmp70_ = _tmp69_;
					_tmp71_ = headline_node;
					_tmp72_ = json_object_get_string_member (_tmp71_, "author");
					_tmp73_ = headline_node;
					_tmp74_ = feed_reader_untyped_json_object_get_int_member (_tmp73_, "updated");
					_tmp75_ = _tmp74_;
					_tmp76_ = g_date_time_new_from_unix_local (*_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = tags;
					_tmp79_ = enclosures;
					_tmp80_ = feed_reader_article_new (_tmp63_, _tmp65_, _tmp67_, _tmp70_, _tmp57_, _tmp59_, NULL, NULL, _tmp72_, _tmp77_, -1, _tmp78_, (GeeList*) _tmp79_, "", 0);
					_tmp81_ = _tmp80_;
					_g_date_time_unref0 (_tmp77_);
					_g_free0 (_tmp75_);
					_g_free0 (_tmp70_);
					_g_free0 (_tmp63_);
					Article = _tmp81_;
					_tmp82_ = Article;
					gee_collection_add ((GeeCollection*) articles, _tmp82_);
					_g_object_unref0 (Article);
					_g_object_unref0 (enclosures);
					_g_object_unref0 (tags);
					_json_object_unref0 (headline_node);
				}
			}
		}
		_json_array_unref0 (response);
	}
	_g_object_unref0 (message);
}

GeeList*
feed_reader_ttrss_api_NewsPlus (FeedReaderttrssAPI* self,
                                FeedReaderArticleStatus type,
                                gint limit)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	FeedReaderttrssMessage* _tmp7_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp10_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "getCompactHeadlines");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_int (_tmp6_, "feed_id", (gint) FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_ALL);
	_tmp7_ = message;
	feed_reader_ttrss_message_add_int (_tmp7_, "limit", limit);
	if (type == FEED_READER_ARTICLE_STATUS_UNREAD) {
		FeedReaderttrssMessage* _tmp8_;
		_tmp8_ = message;
		feed_reader_ttrss_message_add_string (_tmp8_, "view_mode", "unread");
	} else {
		if (type == FEED_READER_ARTICLE_STATUS_MARKED) {
			FeedReaderttrssMessage* _tmp9_;
			_tmp9_ = message;
			feed_reader_ttrss_message_add_string (_tmp9_, "view_mode", "marked");
		} else {
			result = NULL;
			_g_object_unref0 (message);
			return result;
		}
	}
	_tmp10_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp10_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonArray* response = NULL;
		FeedReaderttrssMessage* _tmp11_;
		JsonArray* _tmp12_;
		guint headline_count = 0U;
		JsonArray* _tmp13_;
		GeeLinkedList* ids = NULL;
		GeeLinkedList* _tmp14_;
		_tmp11_ = message;
		_tmp12_ = feed_reader_ttrss_message_get_response_array (_tmp11_);
		response = _tmp12_;
		_tmp13_ = response;
		headline_count = json_array_get_length (_tmp13_);
		_tmp14_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		ids = _tmp14_;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					JsonObject* headline_node = NULL;
					JsonArray* _tmp17_;
					JsonObject* _tmp18_;
					JsonObject* _tmp19_;
					GeeLinkedList* _tmp20_;
					JsonObject* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					if (!_tmp15_) {
						guint _tmp16_;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					if (!(i < headline_count)) {
						break;
					}
					_tmp17_ = response;
					_tmp18_ = json_array_get_object_element (_tmp17_, i);
					_tmp19_ = _json_object_ref0 (_tmp18_);
					headline_node = _tmp19_;
					_tmp20_ = ids;
					_tmp21_ = headline_node;
					_tmp22_ = feed_reader_untyped_json_object_get_string_member (_tmp21_, "id");
					_tmp23_ = _tmp22_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp23_);
					_g_free0 (_tmp23_);
					_json_object_unref0 (headline_node);
				}
			}
		}
		result = (GeeList*) ids;
		_json_array_unref0 (response);
		_g_object_unref0 (message);
		return result;
	}
	result = NULL;
	_g_object_unref0 (message);
	return result;
}

GeeList*
feed_reader_ttrss_api_getArticles (FeedReaderttrssAPI* self,
                                   GeeList* articleIDs)
{
	GeeArrayList* articles = NULL;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	const gchar* _tmp7_;
	FeedReaderttrssMessage* _tmp8_;
	FeedReaderttrssMessage* _tmp9_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp10_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (articleIDs != NULL, NULL);
	_tmp0_ = gee_array_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	articles = _tmp0_;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) articleIDs);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = (GeeList*) articles;
		return result;
	}
	_tmp3_ = self->priv->m_session;
	_tmp4_ = self->priv->_m_ttrss_url;
	_tmp5_ = feed_reader_ttrss_message_new (_tmp3_, _tmp4_);
	message = _tmp5_;
	_tmp6_ = message;
	_tmp7_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp6_, "sid", _tmp7_);
	_tmp8_ = message;
	feed_reader_ttrss_message_add_string (_tmp8_, "op", "getArticle");
	_tmp9_ = message;
	feed_reader_ttrss_message_add_comma_separated_int_array (_tmp9_, "article_id", articleIDs);
	_tmp10_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp10_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonArray* response = NULL;
		FeedReaderttrssMessage* _tmp11_;
		JsonArray* _tmp12_;
		guint article_count = 0U;
		JsonArray* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = message;
		_tmp12_ = feed_reader_ttrss_message_get_response_array (_tmp11_);
		response = _tmp12_;
		_tmp13_ = response;
		article_count = json_array_get_length (_tmp13_);
		_tmp14_ = g_strdup_printf ("%u", article_count);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat ("Got ", _tmp15_, " new articles", NULL);
		_tmp17_ = _tmp16_;
		feed_reader_logger_debug (_tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					JsonObject* article_node = NULL;
					JsonArray* _tmp20_;
					JsonObject* _tmp21_;
					JsonObject* _tmp22_;
					GeeList* tags = NULL;
					JsonObject* _tmp23_;
					GeeArrayList* enclosures = NULL;
					GeeArrayList* _tmp37_;
					JsonObject* _tmp38_;
					FeedReaderArticleStatus _tmp59_ = 0;
					JsonObject* _tmp60_;
					FeedReaderArticleStatus _tmp61_ = 0;
					JsonObject* _tmp62_;
					FeedReaderArticle* Article = NULL;
					JsonObject* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					JsonObject* _tmp66_;
					const gchar* _tmp67_;
					JsonObject* _tmp68_;
					const gchar* _tmp69_;
					JsonObject* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					JsonObject* _tmp73_;
					const gchar* _tmp74_;
					JsonObject* _tmp75_;
					const gchar* _tmp76_;
					JsonObject* _tmp77_;
					gint* _tmp78_;
					gint* _tmp79_;
					GDateTime* _tmp80_;
					GDateTime* _tmp81_;
					GeeList* _tmp82_;
					GeeArrayList* _tmp83_;
					FeedReaderArticle* _tmp84_;
					FeedReaderArticle* _tmp85_;
					GeeArrayList* _tmp86_;
					FeedReaderArticle* _tmp87_;
					if (!_tmp18_) {
						guint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(i < article_count)) {
						break;
					}
					_tmp20_ = response;
					_tmp21_ = json_array_get_object_element (_tmp20_, i);
					_tmp22_ = _json_object_ref0 (_tmp21_);
					article_node = _tmp22_;
					tags = NULL;
					_tmp23_ = article_node;
					if (json_object_has_member (_tmp23_, "labels")) {
						JsonArray* labels = NULL;
						JsonObject* _tmp24_;
						JsonArray* _tmp25_;
						JsonArray* _tmp26_;
						guint tag_count = 0U;
						JsonArray* _tmp27_;
						_tmp24_ = article_node;
						_tmp25_ = json_object_get_array_member (_tmp24_, "labels");
						_tmp26_ = _json_array_ref0 (_tmp25_);
						labels = _tmp26_;
						tag_count = (guint) 0;
						_tmp27_ = labels;
						if (_tmp27_ != NULL) {
							JsonArray* _tmp28_;
							_tmp28_ = labels;
							tag_count = json_array_get_length (_tmp28_);
						}
						if (tag_count > ((guint) 0)) {
							GeeArrayList* _tmp29_;
							_tmp29_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
							_g_object_unref0 (tags);
							tags = (GeeList*) _tmp29_;
						}
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp30_ = FALSE;
								_tmp30_ = TRUE;
								while (TRUE) {
									GeeList* _tmp32_;
									JsonArray* _tmp33_;
									JsonArray* _tmp34_;
									gchar* _tmp35_;
									gchar* _tmp36_;
									if (!_tmp30_) {
										gint _tmp31_;
										j = j + 1;
										_tmp31_ = j;
									}
									_tmp30_ = FALSE;
									if (!(((guint) j) < tag_count)) {
										break;
									}
									_tmp32_ = tags;
									_tmp33_ = labels;
									_tmp34_ = json_array_get_array_element (_tmp33_, (guint) j);
									_tmp35_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_array_get_int_element (_tmp34_, (guint) 0));
									_tmp36_ = _tmp35_;
									gee_collection_add ((GeeCollection*) _tmp32_, _tmp36_);
									_g_free0 (_tmp36_);
								}
							}
						}
						_json_array_unref0 (labels);
					}
					_tmp37_ = gee_array_list_new (FEED_READER_TYPE_ENCLOSURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					enclosures = _tmp37_;
					_tmp38_ = article_node;
					if (json_object_has_member (_tmp38_, "attachments")) {
						JsonArray* attachments = NULL;
						JsonObject* _tmp39_;
						JsonArray* _tmp40_;
						JsonArray* _tmp41_;
						guint mediaCount = 0U;
						JsonArray* _tmp42_;
						_tmp39_ = article_node;
						_tmp40_ = json_object_get_array_member (_tmp39_, "attachments");
						_tmp41_ = _json_array_ref0 (_tmp40_);
						attachments = _tmp41_;
						mediaCount = (guint) 0;
						_tmp42_ = attachments;
						if (_tmp42_ != NULL) {
							JsonArray* _tmp43_;
							_tmp43_ = attachments;
							mediaCount = json_array_get_length (_tmp43_);
						}
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp44_ = FALSE;
								_tmp44_ = TRUE;
								while (TRUE) {
									JsonObject* attachment = NULL;
									JsonArray* _tmp46_;
									JsonObject* _tmp47_;
									JsonObject* _tmp48_;
									GeeArrayList* _tmp49_;
									JsonObject* _tmp50_;
									gchar* _tmp51_;
									gchar* _tmp52_;
									JsonObject* _tmp53_;
									const gchar* _tmp54_;
									JsonObject* _tmp55_;
									const gchar* _tmp56_;
									FeedReaderEnclosure* _tmp57_;
									FeedReaderEnclosure* _tmp58_;
									if (!_tmp44_) {
										gint _tmp45_;
										j = j + 1;
										_tmp45_ = j;
									}
									_tmp44_ = FALSE;
									if (!(((guint) j) < mediaCount)) {
										break;
									}
									_tmp46_ = attachments;
									_tmp47_ = json_array_get_object_element (_tmp46_, (guint) j);
									_tmp48_ = _json_object_ref0 (_tmp47_);
									attachment = _tmp48_;
									_tmp49_ = enclosures;
									_tmp50_ = article_node;
									_tmp51_ = feed_reader_untyped_json_object_get_string_member (_tmp50_, "id");
									_tmp52_ = _tmp51_;
									_tmp53_ = attachment;
									_tmp54_ = json_object_get_string_member (_tmp53_, "content_url");
									_tmp55_ = attachment;
									_tmp56_ = json_object_get_string_member (_tmp55_, "content_type");
									_tmp57_ = feed_reader_enclosure_new (_tmp52_, _tmp54_, feed_reader_enclosure_type_from_string (_tmp56_));
									_tmp58_ = _tmp57_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp58_);
									_g_object_unref0 (_tmp58_);
									_g_free0 (_tmp52_);
									_json_object_unref0 (attachment);
								}
							}
						}
						_json_array_unref0 (attachments);
					}
					_tmp60_ = article_node;
					if (json_object_get_boolean_member (_tmp60_, "unread")) {
						_tmp59_ = FEED_READER_ARTICLE_STATUS_UNREAD;
					} else {
						_tmp59_ = FEED_READER_ARTICLE_STATUS_READ;
					}
					_tmp62_ = article_node;
					if (json_object_get_boolean_member (_tmp62_, "marked")) {
						_tmp61_ = FEED_READER_ARTICLE_STATUS_MARKED;
					} else {
						_tmp61_ = FEED_READER_ARTICLE_STATUS_UNMARKED;
					}
					_tmp63_ = article_node;
					_tmp64_ = feed_reader_untyped_json_object_get_string_member (_tmp63_, "id");
					_tmp65_ = _tmp64_;
					_tmp66_ = article_node;
					_tmp67_ = json_object_get_string_member (_tmp66_, "title");
					_tmp68_ = article_node;
					_tmp69_ = json_object_get_string_member (_tmp68_, "link");
					_tmp70_ = article_node;
					_tmp71_ = feed_reader_untyped_json_object_get_string_member (_tmp70_, "feed_id");
					_tmp72_ = _tmp71_;
					_tmp73_ = article_node;
					_tmp74_ = json_object_get_string_member (_tmp73_, "content");
					_tmp75_ = article_node;
					_tmp76_ = json_object_get_string_member (_tmp75_, "author");
					_tmp77_ = article_node;
					_tmp78_ = feed_reader_untyped_json_object_get_int_member (_tmp77_, "updated");
					_tmp79_ = _tmp78_;
					_tmp80_ = g_date_time_new_from_unix_local (*_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = tags;
					_tmp83_ = enclosures;
					_tmp84_ = feed_reader_article_new (_tmp65_, _tmp67_, _tmp69_, _tmp72_, _tmp59_, _tmp61_, _tmp74_, NULL, _tmp76_, _tmp81_, -1, _tmp82_, (GeeList*) _tmp83_, "", 0);
					_tmp85_ = _tmp84_;
					_g_date_time_unref0 (_tmp81_);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp72_);
					_g_free0 (_tmp65_);
					Article = _tmp85_;
					_tmp86_ = articles;
					_tmp87_ = Article;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp87_);
					_g_object_unref0 (Article);
					_g_object_unref0 (enclosures);
					_g_object_unref0 (tags);
					_json_object_unref0 (article_node);
				}
			}
		}
		_json_array_unref0 (response);
	}
	result = (GeeList*) articles;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_catchupFeed (FeedReaderttrssAPI* self,
                                   gint feedID,
                                   gboolean isCatID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	FeedReaderttrssMessage* _tmp7_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "catchupFeed");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_int (_tmp6_, "feed_id", feedID);
	_tmp7_ = message;
	feed_reader_ttrss_message_add_bool (_tmp7_, "is_cat", isCatID);
	_tmp8_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp8_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp9_;
		JsonObject* _tmp10_;
		JsonObject* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = message;
		_tmp10_ = feed_reader_ttrss_message_get_response_object (_tmp9_);
		response = _tmp10_;
		_tmp11_ = response;
		_tmp12_ = json_object_get_string_member (_tmp11_, "status");
		if (g_strcmp0 (_tmp12_, "OK") == 0) {
			result = TRUE;
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			return result;
		}
		_json_object_unref0 (response);
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_updateArticleUnread (FeedReaderttrssAPI* self,
                                           GeeList* articleIDs,
                                           FeedReaderArticleStatus unread)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	FeedReaderttrssMessage* _tmp9_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (articleIDs != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "updateArticle");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_comma_separated_int_array (_tmp6_, "article_ids", articleIDs);
	if (unread == FEED_READER_ARTICLE_STATUS_UNREAD) {
		FeedReaderttrssMessage* _tmp7_;
		_tmp7_ = message;
		feed_reader_ttrss_message_add_int (_tmp7_, "mode", 1);
	} else {
		if (unread == FEED_READER_ARTICLE_STATUS_READ) {
			FeedReaderttrssMessage* _tmp8_;
			_tmp8_ = message;
			feed_reader_ttrss_message_add_int (_tmp8_, "mode", 0);
		}
	}
	_tmp9_ = message;
	feed_reader_ttrss_message_add_int (_tmp9_, "field", 2);
	_tmp10_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp10_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp11_;
		JsonObject* _tmp12_;
		JsonObject* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = message;
		_tmp12_ = feed_reader_ttrss_message_get_response_object (_tmp11_);
		response = _tmp12_;
		_tmp13_ = response;
		_tmp14_ = json_object_get_string_member (_tmp13_, "status");
		if (g_strcmp0 (_tmp14_, "OK") == 0) {
			result = TRUE;
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			return result;
		}
		_json_object_unref0 (response);
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_updateArticleMarked (FeedReaderttrssAPI* self,
                                           gint articleID,
                                           FeedReaderArticleStatus marked)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	FeedReaderttrssMessage* _tmp9_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "updateArticle");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_int (_tmp6_, "article_ids", articleID);
	if (marked == FEED_READER_ARTICLE_STATUS_MARKED) {
		FeedReaderttrssMessage* _tmp7_;
		_tmp7_ = message;
		feed_reader_ttrss_message_add_int (_tmp7_, "mode", 1);
	} else {
		if (marked == FEED_READER_ARTICLE_STATUS_UNMARKED) {
			FeedReaderttrssMessage* _tmp8_;
			_tmp8_ = message;
			feed_reader_ttrss_message_add_int (_tmp8_, "mode", 0);
		}
	}
	_tmp9_ = message;
	feed_reader_ttrss_message_add_int (_tmp9_, "field", 0);
	_tmp10_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp10_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp11_;
		JsonObject* _tmp12_;
		JsonObject* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = message;
		_tmp12_ = feed_reader_ttrss_message_get_response_object (_tmp11_);
		response = _tmp12_;
		_tmp13_ = response;
		_tmp14_ = json_object_get_string_member (_tmp13_, "status");
		if (g_strcmp0 (_tmp14_, "OK") == 0) {
			result = TRUE;
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			return result;
		}
		_json_object_unref0 (response);
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_setArticleLabel (FeedReaderttrssAPI* self,
                                       gint articleID,
                                       gint tagID,
                                       gboolean add)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	FeedReaderttrssMessage* _tmp7_;
	FeedReaderttrssMessage* _tmp8_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "setArticleLabel");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_int (_tmp6_, "article_ids", articleID);
	_tmp7_ = message;
	feed_reader_ttrss_message_add_int (_tmp7_, "label_id", tagID);
	_tmp8_ = message;
	feed_reader_ttrss_message_add_bool (_tmp8_, "assign", add);
	_tmp9_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp9_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp10_;
		JsonObject* _tmp11_;
		JsonObject* _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = message;
		_tmp11_ = feed_reader_ttrss_message_get_response_object (_tmp10_);
		response = _tmp11_;
		_tmp12_ = response;
		_tmp13_ = json_object_get_string_member (_tmp12_, "status");
		if (g_strcmp0 (_tmp13_, "OK") == 0) {
			result = TRUE;
			_json_object_unref0 (response);
			_g_object_unref0 (message);
			return result;
		}
		_json_object_unref0 (response);
	}
	result = FALSE;
	_g_object_unref0 (message);
	return result;
}

gint64
feed_reader_ttrss_api_addLabel (FeedReaderttrssAPI* self,
                                const gchar* caption)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp7_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (caption != NULL, 0LL);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "addLabel");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_string (_tmp6_, "caption", caption);
	_tmp7_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp7_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		FeedReaderttrssMessage* _tmp8_;
		gint64* _tmp9_;
		gint64* _tmp10_;
		gint64 _tmp11_;
		_tmp8_ = message;
		_tmp9_ = feed_reader_ttrss_message_get_response_int (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = *_tmp10_;
		_g_free0 (_tmp10_);
		result = _tmp11_;
		_g_object_unref0 (message);
		return result;
	}
	result = (gint64) 0;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_removeLabel (FeedReaderttrssAPI* self,
                                   gint tagID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (message, "sid", _tmp3_);
	feed_reader_ttrss_message_add_string (message, "op", "removeLabel");
	feed_reader_ttrss_message_add_int (message, "label_id", tagID);
	status = (gint) feed_reader_ttrss_message_send (message, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_renameLabel (FeedReaderttrssAPI* self,
                                   gint tagID,
                                   const gchar* newName)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (newName != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (message, "sid", _tmp3_);
	feed_reader_ttrss_message_add_string (message, "op", "renameLabel");
	feed_reader_ttrss_message_add_int (message, "label_id", tagID);
	feed_reader_ttrss_message_add_string (message, "caption", newName);
	status = (gint) feed_reader_ttrss_message_send (message, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_subscribeToFeed (FeedReaderttrssAPI* self,
                                       const gchar* feedURL,
                                       const gchar* catID,
                                       const gchar* username,
                                       const gchar* password,
                                       gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	gchar* _tmp0_;
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp1_;
	const gchar* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	FeedReaderttrssMessage* _tmp4_;
	const gchar* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	FeedReaderttrssMessage* _tmp7_;
	gboolean _tmp9_ = FALSE;
	gint msg_status = 0;
	FeedReaderttrssMessage* _tmp12_;
	gchar* _tmp34_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feedURL != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp0_;
	_tmp1_ = self->priv->m_session;
	_tmp2_ = self->priv->_m_ttrss_url;
	_tmp3_ = feed_reader_ttrss_message_new (_tmp1_, _tmp2_);
	message = _tmp3_;
	_tmp4_ = message;
	_tmp5_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp4_, "sid", _tmp5_);
	_tmp6_ = message;
	feed_reader_ttrss_message_add_string (_tmp6_, "op", "subscribeToFeed");
	_tmp7_ = message;
	feed_reader_ttrss_message_add_string (_tmp7_, "feed_url", feedURL);
	if (catID != NULL) {
		FeedReaderttrssMessage* _tmp8_;
		_tmp8_ = message;
		feed_reader_ttrss_message_add_int (_tmp8_, "category_id", atoi (catID));
	}
	if (username != NULL) {
		_tmp9_ = password != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		FeedReaderttrssMessage* _tmp10_;
		FeedReaderttrssMessage* _tmp11_;
		_tmp10_ = message;
		feed_reader_ttrss_message_add_string (_tmp10_, "login", username);
		_tmp11_ = message;
		feed_reader_ttrss_message_add_string (_tmp11_, "password", password);
	}
	_tmp12_ = message;
	msg_status = (gint) feed_reader_ttrss_message_send (_tmp12_, FALSE);
	if (msg_status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		JsonObject* response = NULL;
		FeedReaderttrssMessage* _tmp13_;
		JsonObject* _tmp14_;
		JsonObject* _tmp15_;
		_tmp13_ = message;
		_tmp14_ = feed_reader_ttrss_message_get_response_object (_tmp13_);
		response = _tmp14_;
		_tmp15_ = response;
		if (json_object_has_member (_tmp15_, "status")) {
			JsonObject* status = NULL;
			JsonObject* _tmp16_;
			JsonObject* _tmp17_;
			JsonObject* _tmp18_;
			JsonObject* _tmp19_;
			_tmp16_ = response;
			_tmp17_ = json_object_get_object_member (_tmp16_, "status");
			_tmp18_ = _json_object_ref0 (_tmp17_);
			status = _tmp18_;
			_tmp19_ = status;
			if (json_object_has_member (_tmp19_, "code")) {
				JsonObject* _tmp20_;
				gint* _tmp21_;
				gint* _tmp22_;
				gint _tmp23_;
				_tmp20_ = status;
				_tmp21_ = feed_reader_untyped_json_object_get_int_member (_tmp20_, "code");
				_tmp22_ = _tmp21_;
				_tmp23_ = *_tmp22_;
				_g_free0 (_tmp22_);
				switch (_tmp23_) {
					case 0:
					case 1:
					{
						result = TRUE;
						_json_object_unref0 (status);
						_json_object_unref0 (response);
						_g_object_unref0 (message);
						if (errmsg) {
							*errmsg = _vala_errmsg;
						} else {
							_g_free0 (_vala_errmsg);
						}
						return result;
					}
					case 2:
					{
						gchar* _tmp24_;
						_tmp24_ = g_strdup (_ ("Invalid URL"));
						_g_free0 (_vala_errmsg);
						_vala_errmsg = _tmp24_;
						result = FALSE;
						_json_object_unref0 (status);
						_json_object_unref0 (response);
						_g_object_unref0 (message);
						if (errmsg) {
							*errmsg = _vala_errmsg;
						} else {
							_g_free0 (_vala_errmsg);
						}
						return result;
					}
					case 3:
					{
						gchar* _tmp25_;
						_tmp25_ = g_strdup (_ ("URL content is HTML, no feeds available"));
						_g_free0 (_vala_errmsg);
						_vala_errmsg = _tmp25_;
						result = FALSE;
						_json_object_unref0 (status);
						_json_object_unref0 (response);
						_g_object_unref0 (message);
						if (errmsg) {
							*errmsg = _vala_errmsg;
						} else {
							_g_free0 (_vala_errmsg);
						}
						return result;
					}
					case 4:
					{
						gchar* _tmp26_;
						_tmp26_ = g_strdup (_ ("URL content is HTML which contains multiple feeds."));
						_g_free0 (_vala_errmsg);
						_vala_errmsg = _tmp26_;
						result = FALSE;
						_json_object_unref0 (status);
						_json_object_unref0 (response);
						_g_object_unref0 (message);
						if (errmsg) {
							*errmsg = _vala_errmsg;
						} else {
							_g_free0 (_vala_errmsg);
						}
						return result;
					}
					case 5:
					{
						gchar* _tmp27_;
						_tmp27_ = g_strdup (_ ("Couldn't download the URL content."));
						_g_free0 (_vala_errmsg);
						_vala_errmsg = _tmp27_;
						result = FALSE;
						_json_object_unref0 (status);
						_json_object_unref0 (response);
						_g_object_unref0 (message);
						if (errmsg) {
							*errmsg = _vala_errmsg;
						} else {
							_g_free0 (_vala_errmsg);
						}
						return result;
					}
					case 6:
					{
						gchar* _tmp28_;
						_tmp28_ = g_strdup (_ ("The content is invalid XML."));
						_g_free0 (_vala_errmsg);
						_vala_errmsg = _tmp28_;
						result = FALSE;
						_json_object_unref0 (status);
						_json_object_unref0 (response);
						_g_object_unref0 (message);
						if (errmsg) {
							*errmsg = _vala_errmsg;
						} else {
							_g_free0 (_vala_errmsg);
						}
						return result;
					}
					default:
					{
						JsonObject* _tmp29_;
						_tmp29_ = status;
						if (json_object_has_member (_tmp29_, "message")) {
							JsonObject* _tmp30_;
							const gchar* _tmp31_;
							gchar* _tmp32_;
							_tmp30_ = status;
							_tmp31_ = json_object_get_string_member (_tmp30_, "message");
							_tmp32_ = g_strdup (_tmp31_);
							_g_free0 (_vala_errmsg);
							_vala_errmsg = _tmp32_;
						} else {
							gchar* _tmp33_;
							_tmp33_ = g_strdup ("ttrss error");
							_g_free0 (_vala_errmsg);
							_vala_errmsg = _tmp33_;
						}
						result = FALSE;
						_json_object_unref0 (status);
						_json_object_unref0 (response);
						_g_object_unref0 (message);
						if (errmsg) {
							*errmsg = _vala_errmsg;
						} else {
							_g_free0 (_vala_errmsg);
						}
						return result;
					}
				}
			}
			_json_object_unref0 (status);
		}
		_json_object_unref0 (response);
	}
	_tmp34_ = g_strdup (_ ("Error reaching tt-rss"));
	_g_free0 (_vala_errmsg);
	_vala_errmsg = _tmp34_;
	result = FALSE;
	_g_object_unref0 (message);
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

gboolean
feed_reader_ttrss_api_unsubscribeFeed (FeedReaderttrssAPI* self,
                                       gint feedID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (message, "sid", _tmp3_);
	feed_reader_ttrss_message_add_string (message, "op", "unsubscribeFeed");
	feed_reader_ttrss_message_add_int (message, "feed_id", feedID);
	status = (gint) feed_reader_ttrss_message_send (message, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gchar*
feed_reader_ttrss_api_createCategory (FeedReaderttrssAPI* self,
                                      const gchar* title,
                                      gint* parentID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "addCategory");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_string (_tmp6_, "caption", title);
	if (parentID != NULL) {
		FeedReaderttrssMessage* _tmp7_;
		_tmp7_ = message;
		feed_reader_ttrss_message_add_int (_tmp7_, "parent_id", *parentID);
	}
	_tmp8_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp8_, FALSE);
	if (status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS)) {
		FeedReaderttrssMessage* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = message;
		_tmp10_ = feed_reader_ttrss_message_get_response_string (_tmp9_);
		result = _tmp10_;
		_g_object_unref0 (message);
		return result;
	}
	result = NULL;
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_removeCategory (FeedReaderttrssAPI* self,
                                      gint catID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (message, "sid", _tmp3_);
	feed_reader_ttrss_message_add_string (message, "op", "removeCategory");
	feed_reader_ttrss_message_add_int (message, "category_id", catID);
	status = (gint) feed_reader_ttrss_message_send (message, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_moveCategory (FeedReaderttrssAPI* self,
                                    gint catID,
                                    gint parentID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	FeedReaderttrssMessage* _tmp3_;
	const gchar* _tmp4_;
	FeedReaderttrssMessage* _tmp5_;
	FeedReaderttrssMessage* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gint status = 0;
	FeedReaderttrssMessage* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = message;
	_tmp4_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (_tmp3_, "sid", _tmp4_);
	_tmp5_ = message;
	feed_reader_ttrss_message_add_string (_tmp5_, "op", "moveCategory");
	_tmp6_ = message;
	feed_reader_ttrss_message_add_int (_tmp6_, "category_id", catID);
	_tmp7_ = feed_reader_category_id_to_string (FEED_READER_CATEGORY_ID_MASTER);
	_tmp8_ = _tmp7_;
	_tmp9_ = parentID != atoi (_tmp8_);
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		FeedReaderttrssMessage* _tmp10_;
		_tmp10_ = message;
		feed_reader_ttrss_message_add_int (_tmp10_, "parent_id", parentID);
	}
	_tmp11_ = message;
	status = (gint) feed_reader_ttrss_message_send (_tmp11_, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_renameCategory (FeedReaderttrssAPI* self,
                                      gint catID,
                                      const gchar* title)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (message, "sid", _tmp3_);
	feed_reader_ttrss_message_add_string (message, "op", "renameCategory");
	feed_reader_ttrss_message_add_int (message, "category_id", catID);
	feed_reader_ttrss_message_add_string (message, "caption", title);
	status = (gint) feed_reader_ttrss_message_send (message, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_renameFeed (FeedReaderttrssAPI* self,
                                  gint feedID,
                                  const gchar* title)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (message, "sid", _tmp3_);
	feed_reader_ttrss_message_add_string (message, "op", "renameFeed");
	feed_reader_ttrss_message_add_int (message, "feed_id", feedID);
	feed_reader_ttrss_message_add_string (message, "caption", title);
	status = (gint) feed_reader_ttrss_message_send (message, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_moveFeed (FeedReaderttrssAPI* self,
                                gint feedID,
                                gint catID)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	const gchar* _tmp3_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	_tmp3_ = self->priv->m_ttrss_sessionid;
	feed_reader_ttrss_message_add_string (message, "sid", _tmp3_);
	feed_reader_ttrss_message_add_string (message, "op", "moveFeed");
	feed_reader_ttrss_message_add_int (message, "feed_id", feedID);
	feed_reader_ttrss_message_add_int (message, "category_id", catID);
	status = (gint) feed_reader_ttrss_message_send (message, FALSE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

gboolean
feed_reader_ttrss_api_ping (FeedReaderttrssAPI* self)
{
	FeedReaderttrssMessage* message = NULL;
	SoupSession* _tmp0_;
	const gchar* _tmp1_;
	FeedReaderttrssMessage* _tmp2_;
	gint status = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	feed_reader_logger_debug ("TTRSS: ping");
	_tmp0_ = self->priv->m_session;
	_tmp1_ = self->priv->_m_ttrss_url;
	_tmp2_ = feed_reader_ttrss_message_new (_tmp0_, _tmp1_);
	message = _tmp2_;
	status = (gint) feed_reader_ttrss_message_send (message, TRUE);
	result = status == ((gint) FEED_READER_CONNECTION_ERROR_SUCCESS);
	_g_object_unref0 (message);
	return result;
}

const gchar*
feed_reader_ttrss_api_get_m_ttrss_url (FeedReaderttrssAPI* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_m_ttrss_url;
	result = _tmp0_;
	return result;
}

static void
feed_reader_ttrss_api_set_m_ttrss_url (FeedReaderttrssAPI* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = feed_reader_ttrss_api_get_m_ttrss_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_m_ttrss_url);
		self->priv->_m_ttrss_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, feed_reader_ttrss_api_properties[FEED_READER_TTRSS_API_M_TTRSS_URL_PROPERTY]);
	}
}

static void
feed_reader_ttrss_api_class_init (FeedReaderttrssAPIClass * klass,
                                  gpointer klass_data)
{
	feed_reader_ttrss_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderttrssAPI_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_feed_reader_ttrss_api_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_feed_reader_ttrss_api_set_property;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_ttrss_api_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FEED_READER_TTRSS_API_M_TTRSS_URL_PROPERTY, feed_reader_ttrss_api_properties[FEED_READER_TTRSS_API_M_TTRSS_URL_PROPERTY] = g_param_spec_string ("m-ttrss-url", "m-ttrss-url", "m-ttrss-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
feed_reader_ttrss_api_instance_init (FeedReaderttrssAPI * self,
                                     gpointer klass)
{
	self->priv = feed_reader_ttrss_api_get_instance_private (self);
	self->priv->m_iconDir = NULL;
}

static void
feed_reader_ttrss_api_finalize (GObject * obj)
{
	FeedReaderttrssAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_TTRSS_API, FeedReaderttrssAPI);
	_g_free0 (self->priv->_m_ttrss_url);
	_g_object_unref0 (self->priv->m_utils);
	_g_free0 (self->priv->m_ttrss_sessionid);
	_g_free0 (self->priv->m_iconDir);
	_g_object_unref0 (self->priv->m_session);
	G_OBJECT_CLASS (feed_reader_ttrss_api_parent_class)->finalize (obj);
}

GType
feed_reader_ttrss_api_get_type (void)
{
	return feed_reader_ttrss_api_type_id;
}

GType
feed_reader_ttrss_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderttrssAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_ttrss_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderttrssAPI), 0, (GInstanceInitFunc) feed_reader_ttrss_api_instance_init, NULL };
	feed_reader_ttrss_api_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderttrssAPI", &g_define_type_info, 0);
	FeedReaderttrssAPI_private_offset = sizeof (FeedReaderttrssAPIPrivate);
	return feed_reader_ttrss_api_type_id;
}

static void
_vala_feed_reader_ttrss_api_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	FeedReaderttrssAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FEED_READER_TYPE_TTRSS_API, FeedReaderttrssAPI);
	switch (property_id) {
		case FEED_READER_TTRSS_API_M_TTRSS_URL_PROPERTY:
		g_value_set_string (value, feed_reader_ttrss_api_get_m_ttrss_url (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_feed_reader_ttrss_api_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	FeedReaderttrssAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FEED_READER_TYPE_TTRSS_API, FeedReaderttrssAPI);
	switch (property_id) {
		case FEED_READER_TTRSS_API_M_TTRSS_URL_PROPERTY:
		feed_reader_ttrss_api_set_m_ttrss_url (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

