/* ttrssInterface.c generated by valac 0.56.3, the Vala compiler
 * generated from ttrssInterface.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "ttrss.h"
#include <gtk/gtk.h>
#include "FeedReader.h"
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

enum  {
	FEED_READER_TTRSS_INTERFACE_0_PROPERTY,
	FEED_READER_TTRSS_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_ttrss_interface_properties[FEED_READER_TTRSS_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderttrssInterfacePrivate {
	FeedReaderttrssAPI* m_api;
	FeedReaderttrssUtils* m_utils;
	GtkEntry* m_urlEntry;
	GtkEntry* m_userEntry;
	GtkEntry* m_passwordEntry;
	GtkEntry* m_authPasswordEntry;
	GtkEntry* m_authUserEntry;
	GtkRevealer* m_revealer;
};

static gint FeedReaderttrssInterface_private_offset;
static gpointer feed_reader_ttrss_interface_parent_class = NULL;
static GType feed_reader_ttrss_interface_type_id = 0;

static void feed_reader_ttrss_interface_real_init (FeedReaderFeedServerInterface* base,
                                            GSettingsBackend* settings_backend,
                                            SecretCollection* secrets);
static gchar* feed_reader_ttrss_interface_real_getWebsite (FeedReaderFeedServerInterface* base);
static FeedReaderBackendFlags feed_reader_ttrss_interface_real_getFlags (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ttrss_interface_real_getID (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ttrss_interface_real_iconName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ttrss_interface_real_serviceName (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_needWebLogin (FeedReaderFeedServerInterface* base);
static GtkBox* feed_reader_ttrss_interface_real_getWidget (FeedReaderFeedServerInterface* base);
static void __lambda8_ (FeedReaderttrssInterface* self);
static void ___lambda8__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda9_ (FeedReaderttrssInterface* self);
static void ___lambda9__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda10_ (FeedReaderttrssInterface* self);
static void ___lambda10__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda11_ (FeedReaderttrssInterface* self);
static void ___lambda11__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda12_ (FeedReaderttrssInterface* self);
static void ___lambda12__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda13_ (FeedReaderttrssInterface* self);
static void ___lambda13__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void feed_reader_ttrss_interface_real_showHtAccess (FeedReaderFeedServerInterface* base);
static void feed_reader_ttrss_interface_real_writeData (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_supportTags (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_doInitSync (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ttrss_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ttrss_interface_real_accountName (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ttrss_interface_real_getServerURL (FeedReaderFeedServerInterface* base);
static gchar* feed_reader_ttrss_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                                 const gchar* catID);
static gboolean feed_reader_ttrss_interface_real_supportCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base);
static void feed_reader_ttrss_interface_real_resetAccount (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base);
static FeedReaderLoginResponse feed_reader_ttrss_interface_real_login (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_logout (FeedReaderFeedServerInterface* base);
static gboolean feed_reader_ttrss_interface_real_serverAvailable (FeedReaderFeedServerInterface* base);
static void feed_reader_ttrss_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleIDs,
                                                        FeedReaderArticleStatus read);
static void feed_reader_ttrss_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                          const gchar* articleID,
                                                          FeedReaderArticleStatus marked);
static gboolean feed_reader_ttrss_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base);
static void feed_reader_ttrss_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedID);
static void feed_reader_ttrss_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                       const gchar* catID);
static void feed_reader_ttrss_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base);
static void feed_reader_ttrss_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                                  const gchar* articleID,
                                                  const gchar* tagID);
static void feed_reader_ttrss_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                        const gchar* articleID,
                                                        const gchar* tagID);
static gchar* feed_reader_ttrss_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* caption);
static void feed_reader_ttrss_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID);
static void feed_reader_ttrss_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                                 const gchar* tagID,
                                                 const gchar* title);
static gboolean feed_reader_ttrss_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                                   const gchar* feedURL,
                                                   const gchar* catID,
                                                   const gchar* newCatName,
                                                   gchar** feedID,
                                                   gchar** errmsg);
static void feed_reader_ttrss_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID);
static void feed_reader_ttrss_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                                  const gchar* feedID,
                                                  const gchar* title);
static void feed_reader_ttrss_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                                const gchar* feedID,
                                                const gchar* newCatID,
                                                const gchar* currentCatID);
static gchar* feed_reader_ttrss_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                        const gchar* title,
                                                        const gchar* parentID);
static void feed_reader_ttrss_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID,
                                                      const gchar* title);
static void feed_reader_ttrss_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                                    const gchar* catID,
                                                    const gchar* newParentID);
static void feed_reader_ttrss_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                      const gchar* catID);
static void feed_reader_ttrss_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                         const gchar* feedID,
                                                         const gchar* catID);
static gboolean feed_reader_ttrss_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                           GeeList* feeds,
                                                           GeeList* categories,
                                                           GeeList* tags,
                                                           GCancellable* cancellable);
static gint feed_reader_ttrss_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base);
static void feed_reader_ttrss_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                                   gint count,
                                                   FeedReaderArticleStatus whatToGet,
                                                   GDateTime* since,
                                                   const gchar* feedID,
                                                   gboolean isTagID,
                                                   GCancellable* cancellable);
static gint __lambda14_ (FeedReaderttrssInterface* self,
                  FeedReaderArticle* a,
                  FeedReaderArticle* b);
static gint ___lambda14__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void feed_reader_ttrss_interface_finalize (GObject * obj);
GType feed_reader_ttrss_api_register_type (GTypeModule * module);
GType feed_reader_ttrss_utils_register_type (GTypeModule * module);
GType feed_reader_ttrss_message_register_type (GTypeModule * module);

static inline gpointer
feed_reader_ttrss_interface_get_instance_private (FeedReaderttrssInterface* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderttrssInterface_private_offset);
}

static void
feed_reader_ttrss_interface_real_init (FeedReaderFeedServerInterface* base,
                                       GSettingsBackend* settings_backend,
                                       SecretCollection* secrets)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssUtils* _tmp0_;
	FeedReaderttrssUtils* _tmp1_;
	FeedReaderttrssAPI* _tmp2_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (secrets != NULL);
	_tmp0_ = feed_reader_ttrss_utils_new (settings_backend, secrets);
	_g_object_unref0 (self->priv->m_utils);
	self->priv->m_utils = _tmp0_;
	_tmp1_ = self->priv->m_utils;
	_tmp2_ = feed_reader_ttrss_api_new (_tmp1_);
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp2_;
}

static gchar*
feed_reader_ttrss_interface_real_getWebsite (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = g_strdup ("https://tt-rss.org/");
	result = _tmp0_;
	return result;
}

static FeedReaderBackendFlags
feed_reader_ttrss_interface_real_getFlags (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderBackendFlags result;
	self = (FeedReaderttrssInterface*) base;
	result = (FEED_READER_BACKEND_FLAGS_SELF_HOSTED | FEED_READER_BACKEND_FLAGS_FREE_SOFTWARE) | FEED_READER_BACKEND_FLAGS_FREE;
	return result;
}

static gchar*
feed_reader_ttrss_interface_real_getID (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = g_strdup ("ttrss");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_ttrss_interface_real_iconName (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = g_strdup ("feed-service-ttrss");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_ttrss_interface_real_serviceName (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = g_strdup ("Tiny Tiny RSS");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_needWebLogin (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = FALSE;
	return result;
}

static void
__lambda8_ (FeedReaderttrssInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda8__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda8_ ((FeedReaderttrssInterface*) self);
}

static void
__lambda9_ (FeedReaderttrssInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda9__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda9_ ((FeedReaderttrssInterface*) self);
}

static void
__lambda10_ (FeedReaderttrssInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda10__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda10_ ((FeedReaderttrssInterface*) self);
}

static void
__lambda11_ (FeedReaderttrssInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda11__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda11_ ((FeedReaderttrssInterface*) self);
}

static void
__lambda12_ (FeedReaderttrssInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda12__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda12_ ((FeedReaderttrssInterface*) self);
}

static void
__lambda13_ (FeedReaderttrssInterface* self)
{
	g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "try-login");
}

static void
___lambda13__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda13_ ((FeedReaderttrssInterface*) self);
}

static GtkBox*
feed_reader_ttrss_interface_real_getWidget (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	GtkLabel* url_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* user_label = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* password_label = NULL;
	GtkLabel* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkLabel* auth_user_label = NULL;
	GtkLabel* _tmp15_;
	GtkLabel* auth_password_label = NULL;
	GtkLabel* _tmp16_;
	GtkEntry* _tmp17_;
	GtkEntry* _tmp18_;
	GtkEntry* _tmp19_;
	GtkEntry* _tmp20_;
	GtkEntry* _tmp21_;
	GtkEntry* _tmp22_;
	GtkGrid* authGrid = NULL;
	GtkGrid* _tmp23_;
	GtkEntry* _tmp24_;
	GtkEntry* _tmp25_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp26_;
	GtkRevealer* _tmp27_;
	GtkRevealer* _tmp28_;
	GtkImage* logo = NULL;
	GtkImage* _tmp29_;
	GtkLabel* loginLabel = NULL;
	GtkLabel* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkButton* loginButton = NULL;
	GtkButton* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkBox* box = NULL;
	GtkBox* _tmp34_;
	GtkRevealer* _tmp35_;
	GtkEntry* _tmp36_;
	FeedReaderttrssUtils* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GtkEntry* _tmp40_;
	FeedReaderttrssUtils* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkEntry* _tmp44_;
	FeedReaderttrssUtils* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkEntry* _tmp48_;
	FeedReaderttrssUtils* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	GtkEntry* _tmp52_;
	FeedReaderttrssUtils* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GtkBox* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Tiny Tiny RSS URL:"));
	g_object_ref_sink (_tmp0_);
	url_label = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp1_);
	user_label = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp2_);
	password_label = _tmp2_;
	gtk_misc_set_alignment ((GtkMisc*) url_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) user_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) password_label, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) url_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) user_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) password_label, TRUE);
	_tmp3_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->m_urlEntry);
	self->priv->m_urlEntry = _tmp3_;
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_userEntry);
	self->priv->m_userEntry = _tmp4_;
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_passwordEntry);
	self->priv->m_passwordEntry = _tmp5_;
	_tmp6_ = self->priv->m_urlEntry;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) ___lambda8__gtk_entry_activate, self, 0);
	_tmp7_ = self->priv->m_userEntry;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) ___lambda9__gtk_entry_activate, self, 0);
	_tmp8_ = self->priv->m_passwordEntry;
	g_signal_connect_object (_tmp8_, "activate", (GCallback) ___lambda10__gtk_entry_activate, self, 0);
	_tmp9_ = self->priv->m_passwordEntry;
	gtk_entry_set_input_purpose (_tmp9_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp10_ = self->priv->m_passwordEntry;
	gtk_entry_set_visibility (_tmp10_, FALSE);
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp11_);
	grid = _tmp11_;
	gtk_grid_set_column_spacing (grid, (guint) 10);
	gtk_grid_set_row_spacing (grid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_grid_attach (grid, (GtkWidget*) url_label, 0, 0, 1, 1);
	_tmp12_ = self->priv->m_urlEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp12_, 1, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) user_label, 0, 1, 1, 1);
	_tmp13_ = self->priv->m_userEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp13_, 1, 1, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) password_label, 0, 2, 1, 1);
	_tmp14_ = self->priv->m_passwordEntry;
	gtk_grid_attach (grid, (GtkWidget*) _tmp14_, 1, 2, 1, 1);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Username:"));
	g_object_ref_sink (_tmp15_);
	auth_user_label = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Password:"));
	g_object_ref_sink (_tmp16_);
	auth_password_label = _tmp16_;
	gtk_misc_set_alignment ((GtkMisc*) auth_user_label, 1.0f, 0.5f);
	gtk_misc_set_alignment ((GtkMisc*) auth_password_label, 1.0f, 0.5f);
	gtk_widget_set_hexpand ((GtkWidget*) auth_user_label, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) auth_password_label, TRUE);
	_tmp17_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->m_authUserEntry);
	self->priv->m_authUserEntry = _tmp17_;
	_tmp18_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->m_authPasswordEntry);
	self->priv->m_authPasswordEntry = _tmp18_;
	_tmp19_ = self->priv->m_authPasswordEntry;
	gtk_entry_set_input_purpose (_tmp19_, GTK_INPUT_PURPOSE_PASSWORD);
	_tmp20_ = self->priv->m_authPasswordEntry;
	gtk_entry_set_visibility (_tmp20_, FALSE);
	_tmp21_ = self->priv->m_authUserEntry;
	g_signal_connect_object (_tmp21_, "activate", (GCallback) ___lambda11__gtk_entry_activate, self, 0);
	_tmp22_ = self->priv->m_authPasswordEntry;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) ___lambda12__gtk_entry_activate, self, 0);
	_tmp23_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp23_);
	authGrid = _tmp23_;
	g_object_set ((GtkWidget*) authGrid, "margin", 10, NULL);
	gtk_grid_set_column_spacing (authGrid, (guint) 10);
	gtk_grid_set_row_spacing (authGrid, (guint) 10);
	gtk_widget_set_valign ((GtkWidget*) authGrid, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) authGrid, GTK_ALIGN_CENTER);
	gtk_grid_attach (authGrid, (GtkWidget*) auth_user_label, 0, 0, 1, 1);
	_tmp24_ = self->priv->m_authUserEntry;
	gtk_grid_attach (authGrid, (GtkWidget*) _tmp24_, 1, 0, 1, 1);
	gtk_grid_attach (authGrid, (GtkWidget*) auth_password_label, 0, 1, 1, 1);
	_tmp25_ = self->priv->m_authPasswordEntry;
	gtk_grid_attach (authGrid, (GtkWidget*) _tmp25_, 1, 1, 1, 1);
	_tmp26_ = (GtkFrame*) gtk_frame_new (_ ("HTTP Authorization"));
	g_object_ref_sink (_tmp26_);
	frame = _tmp26_;
	gtk_widget_set_halign ((GtkWidget*) frame, GTK_ALIGN_CENTER);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) authGrid);
	_tmp27_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->m_revealer);
	self->priv->m_revealer = _tmp27_;
	_tmp28_ = self->priv->m_revealer;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) frame);
	_tmp29_ = (GtkImage*) gtk_image_new_from_icon_name ("feed-service-ttrss", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp29_);
	logo = _tmp29_;
	_tmp30_ = (GtkLabel*) gtk_label_new (_ ("Please log in to your Tiny Tiny RSS server and enjoy using FeedReader"));
	g_object_ref_sink (_tmp30_);
	loginLabel = _tmp30_;
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) loginLabel);
	gtk_style_context_add_class (_tmp31_, "h2");
	gtk_label_set_justify (loginLabel, GTK_JUSTIFY_CENTER);
	gtk_label_set_lines (loginLabel, 3);
	_tmp32_ = (GtkButton*) gtk_button_new_with_label (_ ("Login"));
	g_object_ref_sink (_tmp32_);
	loginButton = _tmp32_;
	gtk_widget_set_halign ((GtkWidget*) loginButton, GTK_ALIGN_END);
	gtk_widget_set_size_request ((GtkWidget*) loginButton, 80, 30);
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) loginButton);
	gtk_style_context_add_class (_tmp33_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_object (loginButton, "clicked", (GCallback) ___lambda13__gtk_button_clicked, self, 0);
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp34_);
	box = _tmp34_;
	gtk_widget_set_valign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) box, GTK_ALIGN_CENTER);
	gtk_box_pack_start (box, (GtkWidget*) loginLabel, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) logo, FALSE, FALSE, (guint) 10);
	gtk_box_pack_start (box, (GtkWidget*) grid, TRUE, TRUE, (guint) 10);
	_tmp35_ = self->priv->m_revealer;
	gtk_box_pack_start (box, (GtkWidget*) _tmp35_, TRUE, TRUE, (guint) 10);
	gtk_box_pack_end (box, (GtkWidget*) loginButton, FALSE, FALSE, (guint) 20);
	_tmp36_ = self->priv->m_urlEntry;
	_tmp37_ = self->priv->m_utils;
	_tmp38_ = feed_reader_ttrss_utils_getUnmodifiedURL (_tmp37_);
	_tmp39_ = _tmp38_;
	gtk_entry_set_text (_tmp36_, _tmp39_);
	_g_free0 (_tmp39_);
	_tmp40_ = self->priv->m_userEntry;
	_tmp41_ = self->priv->m_utils;
	_tmp42_ = feed_reader_ttrss_utils_getUser (_tmp41_);
	_tmp43_ = _tmp42_;
	gtk_entry_set_text (_tmp40_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->m_passwordEntry;
	_tmp45_ = self->priv->m_utils;
	_tmp46_ = feed_reader_ttrss_utils_getPasswd (_tmp45_);
	_tmp47_ = _tmp46_;
	gtk_entry_set_text (_tmp44_, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->m_authUserEntry;
	_tmp49_ = self->priv->m_utils;
	_tmp50_ = feed_reader_ttrss_utils_getHtaccessUser (_tmp49_);
	_tmp51_ = _tmp50_;
	gtk_entry_set_text (_tmp48_, _tmp51_);
	_g_free0 (_tmp51_);
	_tmp52_ = self->priv->m_authPasswordEntry;
	_tmp53_ = self->priv->m_utils;
	_tmp54_ = feed_reader_ttrss_utils_getHtaccessPasswd (_tmp53_);
	_tmp55_ = _tmp54_;
	gtk_entry_set_text (_tmp52_, _tmp55_);
	_g_free0 (_tmp55_);
	result = box;
	_g_object_unref0 (loginButton);
	_g_object_unref0 (loginLabel);
	_g_object_unref0 (logo);
	_g_object_unref0 (frame);
	_g_object_unref0 (authGrid);
	_g_object_unref0 (auth_password_label);
	_g_object_unref0 (auth_user_label);
	_g_object_unref0 (grid);
	_g_object_unref0 (password_label);
	_g_object_unref0 (user_label);
	_g_object_unref0 (url_label);
	return result;
}

static void
feed_reader_ttrss_interface_real_showHtAccess (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	GtkRevealer* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
feed_reader_ttrss_interface_real_writeData (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gchar* url = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	FeedReaderttrssUtils* _tmp11_;
	const gchar* _tmp12_;
	FeedReaderttrssUtils* _tmp13_;
	GtkEntry* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	FeedReaderttrssUtils* _tmp18_;
	GtkEntry* _tmp19_;
	const gchar* _tmp20_;
	FeedReaderttrssUtils* _tmp21_;
	GtkEntry* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	FeedReaderttrssUtils* _tmp26_;
	GtkEntry* _tmp27_;
	const gchar* _tmp28_;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_urlEntry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	url = _tmp2_;
	_tmp3_ = url;
	_tmp4_ = g_uri_parse_scheme (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == NULL;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GtkEntry* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = url;
		_tmp8_ = g_strconcat ("https://", _tmp7_, NULL);
		_g_free0 (url);
		url = _tmp8_;
		_tmp9_ = self->priv->m_urlEntry;
		_tmp10_ = url;
		gtk_entry_set_text (_tmp9_, _tmp10_);
	}
	_tmp11_ = self->priv->m_utils;
	_tmp12_ = url;
	feed_reader_ttrss_utils_setURL (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->m_utils;
	_tmp14_ = self->priv->m_userEntry;
	_tmp15_ = gtk_entry_get_text (_tmp14_);
	_tmp16_ = string_strip (_tmp15_);
	_tmp17_ = _tmp16_;
	feed_reader_ttrss_utils_setUser (_tmp13_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->m_utils;
	_tmp19_ = self->priv->m_passwordEntry;
	_tmp20_ = gtk_entry_get_text (_tmp19_);
	feed_reader_ttrss_utils_setPassword (_tmp18_, _tmp20_);
	_tmp21_ = self->priv->m_utils;
	_tmp22_ = self->priv->m_authUserEntry;
	_tmp23_ = gtk_entry_get_text (_tmp22_);
	_tmp24_ = string_strip (_tmp23_);
	_tmp25_ = _tmp24_;
	feed_reader_ttrss_utils_setHtaccessUser (_tmp21_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->m_utils;
	_tmp27_ = self->priv->m_authPasswordEntry;
	_tmp28_ = gtk_entry_get_text (_tmp27_);
	feed_reader_ttrss_utils_setHtAccessPassword (_tmp26_, _tmp28_);
	_g_free0 (url);
}

static gboolean
feed_reader_ttrss_interface_real_supportTags (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_doInitSync (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = TRUE;
	return result;
}

static gchar*
feed_reader_ttrss_interface_real_symbolicIcon (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = g_strdup ("feed-service-ttrss-symbolic");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_ttrss_interface_real_accountName (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_ttrss_utils_getUser (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_ttrss_interface_real_getServerURL (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssUtils* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_utils;
	_tmp1_ = feed_reader_ttrss_utils_getURL (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
feed_reader_ttrss_interface_real_uncategorizedID (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = g_strdup ("0");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_hideCategoryWhenEmpty (FeedReaderFeedServerInterface* base,
                                                        const gchar* catID)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	g_return_val_if_fail (catID != NULL, FALSE);
	result = g_strcmp0 (catID, "0") == 0;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_supportCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_supportFeedManipulation (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_supportMultiLevelCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_supportMultiCategoriesPerFeed (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_syncFeedsAndCategories (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_tagIDaffectedByNameChange (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_ttrss_interface_real_resetAccount (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssUtils* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_utils;
	feed_reader_ttrss_utils_resetAccount (_tmp0_);
}

static gboolean
feed_reader_ttrss_interface_real_useMaxArticles (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = TRUE;
	return result;
}

static FeedReaderLoginResponse
feed_reader_ttrss_interface_real_login (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	FeedReaderLoginResponse result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_ttrss_api_login (_tmp0_);
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_logout (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_ttrss_api_logout (_tmp0_);
	return result;
}

static gboolean
feed_reader_ttrss_interface_real_serverAvailable (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_ttrss_api_ping (_tmp0_);
	return result;
}

static void
feed_reader_ttrss_interface_real_setArticleIsRead (FeedReaderFeedServerInterface* base,
                                                   const gchar* articleIDs,
                                                   FeedReaderArticleStatus read)
{
	FeedReaderttrssInterface * self;
	GeeArrayList* ids = NULL;
	GeeArrayList* _tmp0_;
	FeedReaderttrssAPI* _tmp11_;
	GeeArrayList* _tmp12_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (articleIDs != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ids = _tmp0_;
	{
		GeeList* _id_list = NULL;
		GeeList* _tmp1_;
		gint _id_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _id_index = 0;
		_tmp1_ = feed_reader_string_utils_split (articleIDs, ",", FALSE);
		_id_list = _tmp1_;
		_tmp2_ = _id_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_id_size = _tmp4_;
		_id_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* id = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GeeArrayList* _tmp9_;
			const gchar* _tmp10_;
			_id_index = _id_index + 1;
			_tmp5_ = _id_index;
			_tmp6_ = _id_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _id_list;
			_tmp8_ = gee_list_get (_tmp7_, _id_index);
			id = (gchar*) _tmp8_;
			_tmp9_ = ids;
			_tmp10_ = id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (gpointer) ((gintptr) atoi (_tmp10_)));
			_g_free0 (id);
		}
		_g_object_unref0 (_id_list);
	}
	_tmp11_ = self->priv->m_api;
	_tmp12_ = ids;
	feed_reader_ttrss_api_updateArticleUnread (_tmp11_, (GeeList*) _tmp12_, read);
	_g_object_unref0 (ids);
}

static void
feed_reader_ttrss_interface_real_setArticleIsMarked (FeedReaderFeedServerInterface* base,
                                                     const gchar* articleID,
                                                     FeedReaderArticleStatus marked)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (articleID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_updateArticleMarked (_tmp0_, atoi (articleID), marked);
}

static gboolean
feed_reader_ttrss_interface_real_alwaysSetReadByID (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	result = FALSE;
	return result;
}

static void
feed_reader_ttrss_interface_real_setFeedRead (FeedReaderFeedServerInterface* base,
                                              const gchar* feedID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_catchupFeed (_tmp0_, atoi (feedID), FALSE);
}

static void
feed_reader_ttrss_interface_real_setCategoryRead (FeedReaderFeedServerInterface* base,
                                                  const gchar* catID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_catchupFeed (_tmp0_, atoi (catID), TRUE);
}

static void
feed_reader_ttrss_interface_real_markAllItemsRead (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	GeeList* categories = NULL;
	FeedReaderDataBaseReadOnly* _tmp0_;
	FeedReaderDataBaseReadOnly* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = feed_reader_data_base_readOnly ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_data_base_read_only_read_categories (_tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	categories = _tmp3_;
	{
		GeeList* _cat_list = NULL;
		GeeList* _tmp4_;
		gint _cat_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _cat_index = 0;
		_tmp4_ = categories;
		_cat_list = _tmp4_;
		_tmp5_ = _cat_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_cat_size = _tmp7_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			FeedReaderCategory* cat = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			FeedReaderttrssAPI* _tmp12_;
			FeedReaderCategory* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_cat_index = _cat_index + 1;
			_tmp8_ = _cat_index;
			_tmp9_ = _cat_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _cat_list;
			_tmp11_ = gee_list_get (_tmp10_, _cat_index);
			cat = (FeedReaderCategory*) _tmp11_;
			_tmp12_ = self->priv->m_api;
			_tmp13_ = cat;
			_tmp14_ = feed_reader_category_getCatID (_tmp13_);
			_tmp15_ = _tmp14_;
			feed_reader_ttrss_api_catchupFeed (_tmp12_, atoi (_tmp15_), TRUE);
			_g_free0 (_tmp15_);
			_g_object_unref0 (cat);
		}
	}
	_g_object_unref0 (categories);
}

static void
feed_reader_ttrss_interface_real_tagArticle (FeedReaderFeedServerInterface* base,
                                             const gchar* articleID,
                                             const gchar* tagID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_setArticleLabel (_tmp0_, atoi (articleID), atoi (tagID), TRUE);
}

static void
feed_reader_ttrss_interface_real_removeArticleTag (FeedReaderFeedServerInterface* base,
                                                   const gchar* articleID,
                                                   const gchar* tagID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (articleID != NULL);
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_setArticleLabel (_tmp0_, atoi (articleID), atoi (tagID), FALSE);
}

static gchar*
feed_reader_ttrss_interface_real_createTag (FeedReaderFeedServerInterface* base,
                                            const gchar* caption)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = self->priv->m_api;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, feed_reader_ttrss_api_addLabel (_tmp0_, caption));
	result = _tmp1_;
	return result;
}

static void
feed_reader_ttrss_interface_real_deleteTag (FeedReaderFeedServerInterface* base,
                                            const gchar* tagID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (tagID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_removeLabel (_tmp0_, atoi (tagID));
}

static void
feed_reader_ttrss_interface_real_renameTag (FeedReaderFeedServerInterface* base,
                                            const gchar* tagID,
                                            const gchar* title)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (tagID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_renameLabel (_tmp0_, atoi (tagID), title);
}

static gboolean
feed_reader_ttrss_interface_real_addFeed (FeedReaderFeedServerInterface* base,
                                          const gchar* feedURL,
                                          const gchar* catID,
                                          const gchar* newCatName,
                                          gchar** feedID,
                                          gchar** errmsg)
{
	FeedReaderttrssInterface * self;
	gchar* _vala_feedID = NULL;
	gchar* _vala_errmsg = NULL;
	gboolean success = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	g_return_val_if_fail (feedURL != NULL, FALSE);
	success = FALSE;
	if (catID == NULL) {
		_tmp0_ = newCatName != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* newCatID = NULL;
		FeedReaderttrssAPI* _tmp1_;
		gchar* _tmp2_;
		FeedReaderttrssAPI* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp1_ = self->priv->m_api;
		_tmp2_ = feed_reader_ttrss_api_createCategory (_tmp1_, newCatName, NULL);
		newCatID = _tmp2_;
		_tmp3_ = self->priv->m_api;
		_tmp4_ = newCatID;
		_tmp6_ = feed_reader_ttrss_api_subscribeToFeed (_tmp3_, feedURL, _tmp4_, NULL, NULL, &_tmp5_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
		success = _tmp6_;
		_g_free0 (newCatID);
	} else {
		FeedReaderttrssAPI* _tmp7_;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_;
		_tmp7_ = self->priv->m_api;
		_tmp9_ = feed_reader_ttrss_api_subscribeToFeed (_tmp7_, feedURL, catID, NULL, NULL, &_tmp8_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp8_;
		success = _tmp9_;
	}
	if (success) {
		FeedReaderDataBaseReadOnly* _tmp10_;
		FeedReaderDataBaseReadOnly* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = feed_reader_data_base_readOnly ();
		_tmp11_ = _tmp10_;
		_tmp12_ = feed_reader_data_base_read_only_getMaxID (_tmp11_, "feeds", "feed_id");
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("%i", atoi (_tmp13_) + 1);
		_g_free0 (_vala_feedID);
		_vala_feedID = _tmp14_;
		_g_free0 (_tmp13_);
		_g_object_unref0 (_tmp11_);
	} else {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("-98");
		_g_free0 (_vala_feedID);
		_vala_feedID = _tmp15_;
	}
	result = success;
	if (feedID) {
		*feedID = _vala_feedID;
	} else {
		_g_free0 (_vala_feedID);
	}
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static void
feed_reader_ttrss_interface_real_removeFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feedID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (feedID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_unsubscribeFeed (_tmp0_, atoi (feedID));
}

static void
feed_reader_ttrss_interface_real_renameFeed (FeedReaderFeedServerInterface* base,
                                             const gchar* feedID,
                                             const gchar* title)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_renameFeed (_tmp0_, atoi (feedID), title);
}

static void
feed_reader_ttrss_interface_real_moveFeed (FeedReaderFeedServerInterface* base,
                                           const gchar* feedID,
                                           const gchar* newCatID,
                                           const gchar* currentCatID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (newCatID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_moveFeed (_tmp0_, atoi (feedID), atoi (newCatID));
}

static gchar*
feed_reader_ttrss_interface_real_createCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* title,
                                                 const gchar* parentID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (FeedReaderttrssInterface*) base;
	g_return_val_if_fail (title != NULL, NULL);
	if (parentID != NULL) {
		FeedReaderttrssAPI* _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->m_api;
		_tmp1_ = atoi (parentID);
		_tmp2_ = feed_reader_ttrss_api_createCategory (_tmp0_, title, &_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->m_api;
	_tmp4_ = feed_reader_ttrss_api_createCategory (_tmp3_, title, NULL);
	result = _tmp4_;
	return result;
}

static void
feed_reader_ttrss_interface_real_renameCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* catID,
                                                 const gchar* title)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_renameCategory (_tmp0_, atoi (catID), title);
}

static void
feed_reader_ttrss_interface_real_moveCategory (FeedReaderFeedServerInterface* base,
                                               const gchar* catID,
                                               const gchar* newParentID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (catID != NULL);
	g_return_if_fail (newParentID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_moveCategory (_tmp0_, atoi (catID), atoi (newParentID));
}

static void
feed_reader_ttrss_interface_real_deleteCategory (FeedReaderFeedServerInterface* base,
                                                 const gchar* catID)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (catID != NULL);
	_tmp0_ = self->priv->m_api;
	feed_reader_ttrss_api_removeCategory (_tmp0_, atoi (catID));
}

static void
feed_reader_ttrss_interface_real_removeCatFromFeed (FeedReaderFeedServerInterface* base,
                                                    const gchar* feedID,
                                                    const gchar* catID)
{
	FeedReaderttrssInterface * self;
	self = (FeedReaderttrssInterface*) base;
	g_return_if_fail (feedID != NULL);
	g_return_if_fail (catID != NULL);
	return;
}

static gboolean
feed_reader_ttrss_interface_real_getFeedsAndCats (FeedReaderFeedServerInterface* base,
                                                  GeeList* feeds,
                                                  GeeList* categories,
                                                  GeeList* tags,
                                                  GCancellable* cancellable)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	gboolean result;
	self = (FeedReaderttrssInterface*) base;
	g_return_val_if_fail (feeds != NULL, FALSE);
	g_return_val_if_fail (categories != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	_tmp0_ = self->priv->m_api;
	if (feed_reader_ttrss_api_getCategories (_tmp0_, categories)) {
		gboolean _tmp1_ = FALSE;
		FeedReaderttrssAPI* _tmp2_;
		if (cancellable != NULL) {
			_tmp1_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = self->priv->m_api;
		if (feed_reader_ttrss_api_getFeeds (_tmp2_, feeds, categories)) {
			gboolean _tmp3_ = FALSE;
			FeedReaderttrssAPI* _tmp4_;
			if (cancellable != NULL) {
				_tmp3_ = g_cancellable_is_cancelled (cancellable);
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				result = FALSE;
				return result;
			}
			_tmp4_ = self->priv->m_api;
			if (feed_reader_ttrss_api_getUncategorizedFeeds (_tmp4_, feeds)) {
				gboolean _tmp5_ = FALSE;
				FeedReaderttrssAPI* _tmp6_;
				if (cancellable != NULL) {
					_tmp5_ = g_cancellable_is_cancelled (cancellable);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					result = FALSE;
					return result;
				}
				_tmp6_ = self->priv->m_api;
				if (feed_reader_ttrss_api_getTags (_tmp6_, tags)) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static gint
feed_reader_ttrss_interface_real_getUnreadCount (FeedReaderFeedServerInterface* base)
{
	FeedReaderttrssInterface * self;
	FeedReaderttrssAPI* _tmp0_;
	gint result;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = self->priv->m_api;
	result = feed_reader_ttrss_api_getUnreadCount (_tmp0_);
	return result;
}

static gint
__lambda14_ (FeedReaderttrssInterface* self,
             FeedReaderArticle* a,
             FeedReaderArticle* b)
{
	GCompareFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = feed_reader_article_getArticleID (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = feed_reader_article_getArticleID (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

static gint
___lambda14__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda14_ ((FeedReaderttrssInterface*) self, (FeedReaderArticle*) a, (FeedReaderArticle*) b);
	return result;
}

static void
feed_reader_ttrss_interface_real_getArticles (FeedReaderFeedServerInterface* base,
                                              gint count,
                                              FeedReaderArticleStatus whatToGet,
                                              GDateTime* since,
                                              const gchar* feedID,
                                              gboolean isTagID,
                                              GCancellable* cancellable)
{
	FeedReaderttrssInterface * self;
	GSettings* settings_general = NULL;
	GSettings* _tmp0_;
	GeeList* unreadIDs = NULL;
	FeedReaderttrssAPI* _tmp1_;
	GSettings* _tmp2_;
	GeeList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	FeedReaderDataBase* db = NULL;
	FeedReaderDataBase* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeList* _tmp7_;
	gboolean _tmp15_ = FALSE;
	GeeArrayList* articleIDs = NULL;
	GeeArrayList* _tmp16_;
	gint skip = 0;
	gint amount = 0;
	GeeList* articles = NULL;
	FeedReaderttrssAPI* _tmp40_;
	GeeArrayList* _tmp41_;
	GeeList* _tmp42_;
	GeeArrayList* article_id_strings = NULL;
	GeeArrayList* _tmp43_;
	GeeArrayList* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GeeList* _tmp60_;
	gboolean _tmp61_ = FALSE;
	GeeList* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	self = (FeedReaderttrssInterface*) base;
	_tmp0_ = g_settings_new ("org.gnome.feedreader");
	settings_general = _tmp0_;
	_tmp1_ = self->priv->m_api;
	_tmp2_ = settings_general;
	_tmp3_ = feed_reader_ttrss_api_NewsPlus (_tmp1_, FEED_READER_ARTICLE_STATUS_UNREAD, 10 * g_settings_get_int (_tmp2_, "max-articles"));
	unreadIDs = _tmp3_;
	if (cancellable != NULL) {
		_tmp4_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_g_object_unref0 (unreadIDs);
		_g_object_unref0 (settings_general);
		return;
	}
	_tmp5_ = feed_reader_data_base_writeAccess ();
	db = _tmp5_;
	_tmp7_ = unreadIDs;
	if (_tmp7_ != NULL) {
		_tmp6_ = whatToGet == FEED_READER_ARTICLE_STATUS_ALL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GeeList* markedIDs = NULL;
		FeedReaderttrssAPI* _tmp8_;
		GSettings* _tmp9_;
		GeeList* _tmp10_;
		FeedReaderDataBase* _tmp11_;
		GeeList* _tmp12_;
		FeedReaderDataBase* _tmp13_;
		GeeList* _tmp14_;
		feed_reader_logger_debug ("getArticles: newsplus plugin active");
		_tmp8_ = self->priv->m_api;
		_tmp9_ = settings_general;
		_tmp10_ = feed_reader_ttrss_api_NewsPlus (_tmp8_, FEED_READER_ARTICLE_STATUS_MARKED, g_settings_get_int (_tmp9_, "max-articles"));
		markedIDs = _tmp10_;
		_tmp11_ = db;
		_tmp12_ = unreadIDs;
		feed_reader_data_base_updateArticlesByID (_tmp11_, _tmp12_, "unread");
		_tmp13_ = db;
		_tmp14_ = markedIDs;
		feed_reader_data_base_updateArticlesByID (_tmp13_, _tmp14_, "marked");
		_g_object_unref0 (markedIDs);
	}
	if (cancellable != NULL) {
		_tmp15_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_g_object_unref0 (db);
		_g_object_unref0 (unreadIDs);
		_g_object_unref0 (settings_general);
		return;
	}
	_tmp16_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	articleIDs = _tmp16_;
	skip = count;
	amount = 200;
	while (TRUE) {
		gboolean _tmp17_ = FALSE;
		GeeLinkedList* articles = NULL;
		GeeLinkedList* _tmp18_;
		FeedReaderttrssUtilsTTRSSSpecialID _tmp19_ = 0;
		FeedReaderttrssAPI* _tmp20_;
		GeeLinkedList* _tmp21_;
		gboolean _tmp22_ = FALSE;
		GeeList* _tmp23_;
		if (!(skip > 0)) {
			break;
		}
		if (cancellable != NULL) {
			_tmp17_ = g_cancellable_is_cancelled (cancellable);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			_g_object_unref0 (articleIDs);
			_g_object_unref0 (db);
			_g_object_unref0 (unreadIDs);
			_g_object_unref0 (settings_general);
			return;
		}
		if (skip >= amount) {
			skip -= amount;
		} else {
			amount = skip;
			skip = 0;
		}
		_tmp18_ = gee_linked_list_new (FEED_READER_TYPE_ARTICLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		articles = _tmp18_;
		if (feedID == NULL) {
			_tmp19_ = FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_ALL;
		} else {
			_tmp19_ = atoi (feedID);
		}
		_tmp20_ = self->priv->m_api;
		_tmp21_ = articles;
		feed_reader_ttrss_api_getHeadlines (_tmp20_, (GeeList*) _tmp21_, skip, amount, whatToGet, (gint) _tmp19_);
		_tmp23_ = unreadIDs;
		if (_tmp23_ == NULL) {
			_tmp22_ = TRUE;
		} else {
			_tmp22_ = whatToGet != FEED_READER_ARTICLE_STATUS_ALL;
		}
		if (_tmp22_) {
			FeedReaderDataBase* _tmp24_;
			GeeLinkedList* _tmp25_;
			_tmp24_ = db;
			_tmp25_ = articles;
			feed_reader_data_base_update_articles (_tmp24_, (GeeList*) _tmp25_);
			g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "update-article-list");
		}
		{
			GeeLinkedList* _article_list = NULL;
			GeeLinkedList* _tmp26_;
			gint _article_size = 0;
			GeeLinkedList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _article_index = 0;
			_tmp26_ = articles;
			_article_list = _tmp26_;
			_tmp27_ = _article_list;
			_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_article_size = _tmp29_;
			_article_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				FeedReaderArticle* article = NULL;
				GeeLinkedList* _tmp32_;
				gpointer _tmp33_;
				gchar* id = NULL;
				FeedReaderArticle* _tmp34_;
				gchar* _tmp35_;
				FeedReaderDataBase* _tmp36_;
				const gchar* _tmp37_;
				_article_index = _article_index + 1;
				_tmp30_ = _article_index;
				_tmp31_ = _article_size;
				if (!(_tmp30_ < _tmp31_)) {
					break;
				}
				_tmp32_ = _article_list;
				_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _article_index);
				article = (FeedReaderArticle*) _tmp33_;
				_tmp34_ = article;
				_tmp35_ = feed_reader_article_getArticleID (_tmp34_);
				id = _tmp35_;
				_tmp36_ = db;
				_tmp37_ = id;
				if (!feed_reader_data_base_read_only_article_exists ((FeedReaderDataBaseReadOnly*) _tmp36_, _tmp37_)) {
					GeeArrayList* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = articleIDs;
					_tmp39_ = id;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, (gpointer) ((gintptr) atoi (_tmp39_)));
				}
				_g_free0 (id);
				_g_object_unref0 (article);
			}
		}
		_g_object_unref0 (articles);
	}
	_tmp40_ = self->priv->m_api;
	_tmp41_ = articleIDs;
	_tmp42_ = feed_reader_ttrss_api_getArticles (_tmp40_, (GeeList*) _tmp41_);
	articles = _tmp42_;
	_tmp43_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	article_id_strings = _tmp43_;
	{
		GeeArrayList* _id_list = NULL;
		GeeArrayList* _tmp44_;
		gint _id_size = 0;
		GeeArrayList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _id_index = 0;
		_tmp44_ = articleIDs;
		_id_list = _tmp44_;
		_tmp45_ = _id_list;
		_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_id_size = _tmp47_;
		_id_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			gint id = 0;
			GeeArrayList* _tmp50_;
			gpointer _tmp51_;
			GeeArrayList* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			_id_index = _id_index + 1;
			_tmp48_ = _id_index;
			_tmp49_ = _id_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _id_list;
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _id_index);
			id = (gint) ((gintptr) _tmp51_);
			_tmp52_ = article_id_strings;
			_tmp53_ = g_strdup_printf ("%i", id);
			_tmp54_ = _tmp53_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp54_);
			_g_free0 (_tmp54_);
		}
	}
	_tmp55_ = article_id_strings;
	_tmp56_ = feed_reader_string_utils_join ((GeeCollection*) _tmp55_, ",");
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strconcat ("Getting articles: ", _tmp57_, NULL);
	_tmp59_ = _tmp58_;
	feed_reader_logger_info (_tmp59_);
	_g_free0 (_tmp59_);
	_g_free0 (_tmp57_);
	_tmp60_ = articles;
	gee_list_sort (_tmp60_, ___lambda14__gcompare_data_func, g_object_ref (self), g_object_unref);
	if (cancellable != NULL) {
		_tmp61_ = g_cancellable_is_cancelled (cancellable);
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		_g_object_unref0 (article_id_strings);
		_g_object_unref0 (articles);
		_g_object_unref0 (articleIDs);
		_g_object_unref0 (db);
		_g_object_unref0 (unreadIDs);
		_g_object_unref0 (settings_general);
		return;
	}
	_tmp62_ = articles;
	_tmp63_ = gee_collection_get_size ((GeeCollection*) _tmp62_);
	_tmp64_ = _tmp63_;
	if (_tmp64_ > 0) {
		FeedReaderDataBase* _tmp65_;
		GeeList* _tmp66_;
		_tmp65_ = db;
		_tmp66_ = articles;
		feed_reader_data_base_write_articles (_tmp65_, _tmp66_);
		g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "refresh-feed-list-counter");
		g_signal_emit_by_name ((FeedReaderFeedServerInterface*) self, "update-article-list");
	}
	_g_object_unref0 (article_id_strings);
	_g_object_unref0 (articles);
	_g_object_unref0 (articleIDs);
	_g_object_unref0 (db);
	_g_object_unref0 (unreadIDs);
	_g_object_unref0 (settings_general);
}

FeedReaderttrssInterface*
feed_reader_ttrss_interface_construct (GType object_type)
{
	FeedReaderttrssInterface * self = NULL;
	self = (FeedReaderttrssInterface*) feed_reader_feed_server_interface_construct (object_type);
	return self;
}

FeedReaderttrssInterface*
feed_reader_ttrss_interface_new (void)
{
	return feed_reader_ttrss_interface_construct (FEED_READER_TYPE_TTRSS_INTERFACE);
}

static void
feed_reader_ttrss_interface_class_init (FeedReaderttrssInterfaceClass * klass,
                                        gpointer klass_data)
{
	feed_reader_ttrss_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderttrssInterface_private_offset);
	((FeedReaderFeedServerInterfaceClass *) klass)->init = (void (*) (FeedReaderFeedServerInterface*, GSettingsBackend*, SecretCollection*)) feed_reader_ttrss_interface_real_init;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWebsite = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_getWebsite;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFlags = (FeedReaderBackendFlags (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_getFlags;
	((FeedReaderFeedServerInterfaceClass *) klass)->getID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_getID;
	((FeedReaderFeedServerInterfaceClass *) klass)->iconName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_iconName;
	((FeedReaderFeedServerInterfaceClass *) klass)->serviceName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_serviceName;
	((FeedReaderFeedServerInterfaceClass *) klass)->needWebLogin = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_needWebLogin;
	((FeedReaderFeedServerInterfaceClass *) klass)->getWidget = (GtkBox* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_getWidget;
	((FeedReaderFeedServerInterfaceClass *) klass)->showHtAccess = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_showHtAccess;
	((FeedReaderFeedServerInterfaceClass *) klass)->writeData = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_writeData;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportTags = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_supportTags;
	((FeedReaderFeedServerInterfaceClass *) klass)->doInitSync = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_doInitSync;
	((FeedReaderFeedServerInterfaceClass *) klass)->symbolicIcon = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_symbolicIcon;
	((FeedReaderFeedServerInterfaceClass *) klass)->accountName = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_accountName;
	((FeedReaderFeedServerInterfaceClass *) klass)->getServerURL = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_getServerURL;
	((FeedReaderFeedServerInterfaceClass *) klass)->uncategorizedID = (gchar* (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_uncategorizedID;
	((FeedReaderFeedServerInterfaceClass *) klass)->hideCategoryWhenEmpty = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ttrss_interface_real_hideCategoryWhenEmpty;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_supportCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportFeedManipulation = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_supportFeedManipulation;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiLevelCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_supportMultiLevelCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->supportMultiCategoriesPerFeed = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_supportMultiCategoriesPerFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->syncFeedsAndCategories = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_syncFeedsAndCategories;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagIDaffectedByNameChange = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_tagIDaffectedByNameChange;
	((FeedReaderFeedServerInterfaceClass *) klass)->resetAccount = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_resetAccount;
	((FeedReaderFeedServerInterfaceClass *) klass)->useMaxArticles = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_useMaxArticles;
	((FeedReaderFeedServerInterfaceClass *) klass)->login = (FeedReaderLoginResponse (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_login;
	((FeedReaderFeedServerInterfaceClass *) klass)->logout = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_logout;
	((FeedReaderFeedServerInterfaceClass *) klass)->serverAvailable = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_serverAvailable;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_ttrss_interface_real_setArticleIsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setArticleIsMarked = (void (*) (FeedReaderFeedServerInterface*, const gchar*, FeedReaderArticleStatus)) feed_reader_ttrss_interface_real_setArticleIsMarked;
	((FeedReaderFeedServerInterfaceClass *) klass)->alwaysSetReadByID = (gboolean (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_alwaysSetReadByID;
	((FeedReaderFeedServerInterfaceClass *) klass)->setFeedRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ttrss_interface_real_setFeedRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->setCategoryRead = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ttrss_interface_real_setCategoryRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->markAllItemsRead = (void (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_markAllItemsRead;
	((FeedReaderFeedServerInterfaceClass *) klass)->tagArticle = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_tagArticle;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeArticleTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_removeArticleTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->createTag = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ttrss_interface_real_createTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ttrss_interface_real_deleteTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameTag = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_renameTag;
	((FeedReaderFeedServerInterfaceClass *) klass)->addFeed = (gboolean (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*, gchar**, gchar**)) feed_reader_ttrss_interface_real_addFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ttrss_interface_real_removeFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_renameFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_moveFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->createCategory = (gchar* (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_createCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->renameCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_renameCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->moveCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_moveCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->deleteCategory = (void (*) (FeedReaderFeedServerInterface*, const gchar*)) feed_reader_ttrss_interface_real_deleteCategory;
	((FeedReaderFeedServerInterfaceClass *) klass)->removeCatFromFeed = (void (*) (FeedReaderFeedServerInterface*, const gchar*, const gchar*)) feed_reader_ttrss_interface_real_removeCatFromFeed;
	((FeedReaderFeedServerInterfaceClass *) klass)->getFeedsAndCats = (gboolean (*) (FeedReaderFeedServerInterface*, GeeList*, GeeList*, GeeList*, GCancellable*)) feed_reader_ttrss_interface_real_getFeedsAndCats;
	((FeedReaderFeedServerInterfaceClass *) klass)->getUnreadCount = (gint (*) (FeedReaderFeedServerInterface*)) feed_reader_ttrss_interface_real_getUnreadCount;
	((FeedReaderFeedServerInterfaceClass *) klass)->getArticles = (void (*) (FeedReaderFeedServerInterface*, gint, FeedReaderArticleStatus, GDateTime*, const gchar*, gboolean, GCancellable*)) feed_reader_ttrss_interface_real_getArticles;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_ttrss_interface_finalize;
}

static void
feed_reader_ttrss_interface_instance_init (FeedReaderttrssInterface * self,
                                           gpointer klass)
{
	self->priv = feed_reader_ttrss_interface_get_instance_private (self);
}

static void
feed_reader_ttrss_interface_finalize (GObject * obj)
{
	FeedReaderttrssInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_TTRSS_INTERFACE, FeedReaderttrssInterface);
	_g_object_unref0 (self->priv->m_api);
	_g_object_unref0 (self->priv->m_utils);
	_g_object_unref0 (self->priv->m_urlEntry);
	_g_object_unref0 (self->priv->m_userEntry);
	_g_object_unref0 (self->priv->m_passwordEntry);
	_g_object_unref0 (self->priv->m_authPasswordEntry);
	_g_object_unref0 (self->priv->m_authUserEntry);
	_g_object_unref0 (self->priv->m_revealer);
	G_OBJECT_CLASS (feed_reader_ttrss_interface_parent_class)->finalize (obj);
}

GType
feed_reader_ttrss_interface_get_type (void)
{
	return feed_reader_ttrss_interface_type_id;
}

GType
feed_reader_ttrss_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderttrssInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_ttrss_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderttrssInterface), 0, (GInstanceInitFunc) feed_reader_ttrss_interface_instance_init, NULL };
	feed_reader_ttrss_interface_type_id = g_type_module_register_type (module, FEED_READER_TYPE_FEED_SERVER_INTERFACE, "FeedReaderttrssInterface", &g_define_type_info, 0);
	FeedReaderttrssInterface_private_offset = sizeof (FeedReaderttrssInterfacePrivate);
	return feed_reader_ttrss_interface_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_ttrss_api_register_type (module);
	feed_reader_ttrss_interface_register_type (module);
	feed_reader_ttrss_utils_register_type (module);
	feed_reader_ttrss_message_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_FEED_SERVER_INTERFACE, FEED_READER_TYPE_TTRSS_INTERFACE);
	_g_object_unref0 (objmodule);
}

