/* ttrssMessage.c generated by valac 0.56.3, the Vala compiler
 * generated from ttrssMessage.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "ttrss.h"
#include <libsoup/soup.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "FeedReader.h"
#include <gee.h>
#include <gio/gio.h>

#define FEED_READER_TTRSS_MESSAGE_m_contenttype "application/x-www-form-urlencoded"

enum  {
	FEED_READER_TTRSS_MESSAGE_0_PROPERTY,
	FEED_READER_TTRSS_MESSAGE_NUM_PROPERTIES
};
static GParamSpec* feed_reader_ttrss_message_properties[FEED_READER_TTRSS_MESSAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _FeedReaderttrssMessagePrivate {
	SoupSession* m_session;
	SoupMessage* m_message_soup;
	JsonObject* m_request_object;
	JsonObject* m_response_object;
};

struct _Block1Data {
	int _ref_count_;
	FeedReaderttrssMessage* self;
	JsonObject* obj;
};

static gint FeedReaderttrssMessage_private_offset;
static gpointer feed_reader_ttrss_message_parent_class = NULL;
static GType feed_reader_ttrss_message_type_id = 0;

static gchar* feed_reader_ttrss_message_object_to_string (JsonObject* obj);
static void _vala_JsonNode_free (JsonNode* self);
static void feed_reader_ttrss_message_logError (FeedReaderttrssMessage* self,
                                         const gchar* prefix);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static FeedReaderConnectionError feed_reader_ttrss_message_parseError (FeedReaderttrssMessage* self,
                                                                JsonObject* err);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static FeedReaderConnectionError feed_reader_ttrss_message_apiError (FeedReaderttrssMessage* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda7_ (Block1Data* _data1_,
                  JsonObject* _,
                  const gchar* name,
                  JsonNode* member);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void ____lambda7__json_object_foreach (JsonObject* object,
                                       const gchar* member_name,
                                       JsonNode* member_node,
                                       gpointer self);
static void feed_reader_ttrss_message_finalize (GObject * obj);

static inline gpointer
feed_reader_ttrss_message_get_instance_private (FeedReaderttrssMessage* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderttrssMessage_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

FeedReaderttrssMessage*
feed_reader_ttrss_message_construct (GType object_type,
                                     SoupSession* session,
                                     const gchar* destination)
{
	FeedReaderttrssMessage * self = NULL;
	SoupSession* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	g_return_val_if_fail (session != NULL, NULL);
	g_return_val_if_fail (destination != NULL, NULL);
	self = (FeedReaderttrssMessage*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (session);
	_g_object_unref0 (self->priv->m_session);
	self->priv->m_session = _tmp0_;
	_tmp1_ = soup_message_new ("POST", destination);
	_g_object_unref0 (self->priv->m_message_soup);
	self->priv->m_message_soup = _tmp1_;
	_tmp2_ = self->priv->m_message_soup;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = string_to_string (destination);
		_tmp4_ = g_strconcat ("ttrssMessage: can't parse URL ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		feed_reader_logger_error (_tmp5_);
		_g_free0 (_tmp5_);
	}
	return self;
}

FeedReaderttrssMessage*
feed_reader_ttrss_message_new (SoupSession* session,
                               const gchar* destination)
{
	return feed_reader_ttrss_message_construct (FEED_READER_TYPE_TTRSS_MESSAGE, session, destination);
}

void
feed_reader_ttrss_message_add_int (FeedReaderttrssMessage* self,
                                   const gchar* type,
                                   gint val)
{
	JsonObject* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->m_request_object;
	json_object_set_int_member (_tmp0_, type, (gint64) val);
}

void
feed_reader_ttrss_message_add_comma_separated_int_array (FeedReaderttrssMessage* self,
                                                         const gchar* type,
                                                         GeeList* values)
{
	GeeArrayList* strings = NULL;
	GeeArrayList* _tmp0_;
	JsonObject* _tmp11_;
	GeeArrayList* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (values != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	strings = _tmp0_;
	{
		GeeList* _value_list = NULL;
		gint _value_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _value_index = 0;
		_value_list = values;
		_tmp1_ = _value_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_value_size = _tmp3_;
		_value_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint value = 0;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			GeeArrayList* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_value_index = _value_index + 1;
			_tmp4_ = _value_index;
			_tmp5_ = _value_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _value_list;
			_tmp7_ = gee_list_get (_tmp6_, _value_index);
			value = (gint) ((gintptr) _tmp7_);
			_tmp8_ = strings;
			_tmp9_ = g_strdup_printf ("%i", value);
			_tmp10_ = _tmp9_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
			_g_free0 (_tmp10_);
		}
	}
	_tmp11_ = self->priv->m_request_object;
	_tmp12_ = strings;
	_tmp13_ = feed_reader_string_utils_join ((GeeCollection*) _tmp12_, ",");
	_tmp14_ = _tmp13_;
	json_object_set_string_member (_tmp11_, type, _tmp14_);
	_g_free0 (_tmp14_);
	_g_object_unref0 (strings);
}

void
feed_reader_ttrss_message_add_bool (FeedReaderttrssMessage* self,
                                    const gchar* type,
                                    gboolean val)
{
	JsonObject* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->m_request_object;
	json_object_set_boolean_member (_tmp0_, type, val);
}

void
feed_reader_ttrss_message_add_string (FeedReaderttrssMessage* self,
                                      const gchar* type,
                                      const gchar* val)
{
	JsonObject* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->m_request_object;
	json_object_set_string_member (_tmp0_, type, val);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gchar*
feed_reader_ttrss_message_object_to_string (JsonObject* obj)
{
	JsonNode* root = NULL;
	JsonNode* _tmp0_;
	JsonGenerator* gen = NULL;
	JsonGenerator* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (obj != NULL, NULL);
	_tmp0_ = json_node_new (JSON_NODE_OBJECT);
	root = _tmp0_;
	json_node_set_object (root, obj);
	_tmp1_ = json_generator_new ();
	gen = _tmp1_;
	json_generator_set_root (gen, root);
	_tmp2_ = json_generator_to_data (gen, NULL);
	result = _tmp2_;
	_g_object_unref0 (gen);
	__vala_JsonNode_free0 (root);
	return result;
}

FeedReaderConnectionError
feed_reader_ttrss_message_send (FeedReaderttrssMessage* self,
                                gboolean ping)
{
	FeedReaderConnectionError _error_ = 0;
	FeedReaderConnectionError result;
	g_return_val_if_fail (self != NULL, 0);
	_error_ = feed_reader_ttrss_message_send_impl (self, ping);
	if (_error_ != FEED_READER_CONNECTION_ERROR_SUCCESS) {
		feed_reader_ttrss_message_logError (self, "Error response from TT-RSS API");
	}
	result = _error_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

FeedReaderConnectionError
feed_reader_ttrss_message_send_impl (FeedReaderttrssMessage* self,
                                     gboolean ping)
{
	SoupMessage* _tmp0_;
	GSettings* settingsTweaks = NULL;
	GSettings* _tmp1_;
	gchar* data = NULL;
	JsonObject* _tmp2_;
	gchar* _tmp3_;
	SoupMessage* _tmp4_;
	const gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GSettings* _tmp9_;
	guint status_code = 0U;
	SoupSession* _tmp12_;
	SoupMessage* _tmp13_;
	gboolean _tmp14_ = FALSE;
	SoupMessage* _tmp15_;
	GTlsCertificateFlags _tmp16_;
	GTlsCertificateFlags _tmp17_;
	SoupMessage* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	JsonParser* parser = NULL;
	JsonParser* _tmp35_;
	JsonParser* _tmp44_;
	JsonNode* _tmp45_;
	JsonObject* _tmp46_;
	JsonObject* _tmp47_;
	JsonObject* _tmp48_;
	gint* status = NULL;
	JsonObject* _tmp50_;
	gint* _tmp51_;
	gint* _tmp52_;
	gint _tmp53_;
	GError* _inner_error0_ = NULL;
	FeedReaderConnectionError result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->m_message_soup;
	if (_tmp0_ == NULL) {
		feed_reader_logger_error ("ttrssMessage: can't send message");
		result = FEED_READER_CONNECTION_ERROR_UNKNOWN;
		return result;
	}
	_tmp1_ = g_settings_new ("org.gnome.feedreader.tweaks");
	settingsTweaks = _tmp1_;
	_tmp2_ = self->priv->m_request_object;
	_tmp3_ = feed_reader_ttrss_message_object_to_string (_tmp2_);
	data = _tmp3_;
	_tmp4_ = self->priv->m_message_soup;
	_tmp5_ = data;
	_tmp6_ = string_get_data (_tmp5_, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	soup_message_set_request (_tmp4_, FEED_READER_TTRSS_MESSAGE_m_contenttype, SOUP_MEMORY_COPY, _tmp8_, (gsize) _tmp8__length1);
	_tmp9_ = settingsTweaks;
	if (g_settings_get_boolean (_tmp9_, "do-not-track")) {
		SoupMessage* _tmp10_;
		SoupMessageHeaders* _tmp11_;
		_tmp10_ = self->priv->m_message_soup;
		_tmp11_ = _tmp10_->request_headers;
		soup_message_headers_append (_tmp11_, "DNT", "1");
	}
	_tmp12_ = self->priv->m_session;
	_tmp13_ = self->priv->m_message_soup;
	status_code = soup_session_send_message (_tmp12_, _tmp13_);
	if (status_code == ((guint) 401)) {
		result = FEED_READER_CONNECTION_ERROR_UNAUTHORIZED;
		_g_free0 (data);
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	_tmp15_ = self->priv->m_message_soup;
	g_object_get (_tmp15_, "tls-errors", &_tmp16_, NULL);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != 0) {
		GSettings* _tmp18_;
		_tmp18_ = settingsTweaks;
		_tmp14_ = !g_settings_get_boolean (_tmp18_, "ignore-tls-errors");
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		SoupMessage* _tmp19_;
		GTlsCertificateFlags _tmp20_;
		GTlsCertificateFlags _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp19_ = self->priv->m_message_soup;
		g_object_get (_tmp19_, "tls-errors", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = feed_reader_utils_printTlsCertificateFlags (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat ("TLS errors: ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		feed_reader_logger_info (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		result = FEED_READER_CONNECTION_ERROR_CA_ERROR;
		_g_free0 (data);
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	_tmp26_ = self->priv->m_message_soup;
	g_object_get (_tmp26_, "status-code", &_tmp27_, NULL);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != ((guint) 200)) {
		SoupMessage* _tmp29_;
		guint _tmp30_;
		guint _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp29_ = self->priv->m_message_soup;
		g_object_get (_tmp29_, "status-code", &_tmp30_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = soup_status_get_phrase (_tmp31_);
		_tmp33_ = g_strdup_printf ("TTRSS Message: No response - status code: %s", _tmp32_);
		_tmp34_ = _tmp33_;
		feed_reader_logger_error (_tmp34_);
		_g_free0 (_tmp34_);
		result = FEED_READER_CONNECTION_ERROR_NO_RESPONSE;
		_g_free0 (data);
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	if (ping) {
		feed_reader_logger_debug ("TTRSS Message: ping successful");
		result = FEED_READER_CONNECTION_ERROR_SUCCESS;
		_g_free0 (data);
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	_tmp35_ = json_parser_new ();
	parser = _tmp35_;
	{
		JsonParser* _tmp36_;
		SoupMessage* _tmp37_;
		SoupMessageBody* _tmp38_;
		SoupBuffer* _tmp39_;
		SoupBuffer* _tmp40_;
		guint8* _tmp41_;
		gint _tmp41__length1;
		_tmp36_ = parser;
		_tmp37_ = self->priv->m_message_soup;
		_tmp38_ = _tmp37_->response_body;
		_tmp39_ = soup_message_body_flatten (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_->data;
		_tmp41__length1 = _tmp40_->length;
		json_parser_load_from_data (_tmp36_, (const gchar*) _tmp41_, (gssize) -1, &_inner_error0_);
		__vala_SoupBuffer_free0 (_tmp40_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("Could not load response from Message to ttrss");
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		feed_reader_logger_error (_tmp43_);
		result = FEED_READER_CONNECTION_ERROR_NO_RESPONSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		_g_free0 (data);
		_g_object_unref0 (settingsTweaks);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (data);
		_g_object_unref0 (settingsTweaks);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp44_ = parser;
	_tmp45_ = json_parser_get_root (_tmp44_);
	_tmp46_ = json_node_get_object (_tmp45_);
	_tmp47_ = _json_object_ref0 (_tmp46_);
	_json_object_unref0 (self->priv->m_response_object);
	self->priv->m_response_object = _tmp47_;
	_tmp48_ = self->priv->m_response_object;
	if (json_object_has_member (_tmp48_, "error")) {
		JsonObject* _tmp49_;
		_tmp49_ = self->priv->m_response_object;
		feed_reader_ttrss_message_parseError (self, _tmp49_);
	}
	_tmp50_ = self->priv->m_response_object;
	_tmp51_ = feed_reader_untyped_json_object_get_int_member (_tmp50_, "status");
	status = _tmp51_;
	_tmp52_ = status;
	_tmp53_ = 0;
	if (_int_equal (_tmp52_, &_tmp53_) == TRUE) {
		result = FEED_READER_CONNECTION_ERROR_SUCCESS;
		_g_free0 (status);
		_g_object_unref0 (parser);
		_g_free0 (data);
		_g_object_unref0 (settingsTweaks);
		return result;
	} else {
		gint* _tmp54_;
		gint _tmp55_;
		_tmp54_ = status;
		_tmp55_ = 1;
		if (_int_equal (_tmp54_, &_tmp55_) == TRUE) {
			JsonObject* _tmp56_;
			_tmp56_ = self->priv->m_response_object;
			if (json_object_has_member (_tmp56_, "content")) {
				JsonObject* content = NULL;
				JsonObject* _tmp57_;
				JsonObject* _tmp58_;
				JsonObject* _tmp59_;
				JsonObject* _tmp60_;
				_tmp57_ = self->priv->m_response_object;
				_tmp58_ = json_object_get_object_member (_tmp57_, "content");
				_tmp59_ = _json_object_ref0 (_tmp58_);
				content = _tmp59_;
				_tmp60_ = content;
				if (json_object_has_member (_tmp60_, "error")) {
					JsonObject* _tmp61_;
					_tmp61_ = content;
					feed_reader_ttrss_message_parseError (self, _tmp61_);
				}
				_json_object_unref0 (content);
			}
			result = feed_reader_ttrss_message_apiError (self);
			_g_free0 (status);
			_g_object_unref0 (parser);
			_g_free0 (data);
			_g_object_unref0 (settingsTweaks);
			return result;
		}
	}
	feed_reader_ttrss_message_logError (self, "unknown error while sending ttrss message");
	result = FEED_READER_CONNECTION_ERROR_UNKNOWN;
	_g_free0 (status);
	_g_object_unref0 (parser);
	_g_free0 (data);
	_g_object_unref0 (settingsTweaks);
	return result;
}

JsonObject*
feed_reader_ttrss_message_get_response_object (FeedReaderttrssMessage* self)
{
	JsonObject* _tmp0_;
	JsonObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_response_object;
	if (json_object_has_member (_tmp0_, "content")) {
		JsonObject* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		_tmp1_ = self->priv->m_response_object;
		_tmp2_ = json_object_get_object_member (_tmp1_, "content");
		_tmp3_ = _json_object_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

gint64*
feed_reader_ttrss_message_get_response_int (FeedReaderttrssMessage* self)
{
	JsonObject* _tmp0_;
	gint* _tmp1_;
	gint64* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_response_object;
	_tmp1_ = feed_reader_untyped_json_object_get_int_member (_tmp0_, "content");
	result = (gint64*) _tmp1_;
	return result;
}

gchar*
feed_reader_ttrss_message_get_response_string (FeedReaderttrssMessage* self)
{
	JsonObject* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_response_object;
	_tmp1_ = feed_reader_untyped_json_object_get_string_member (_tmp0_, "content");
	result = _tmp1_;
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

JsonArray*
feed_reader_ttrss_message_get_response_array (FeedReaderttrssMessage* self)
{
	JsonObject* _tmp0_;
	JsonArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_response_object;
	if (json_object_has_member (_tmp0_, "content")) {
		JsonObject* _tmp1_;
		JsonArray* _tmp2_;
		JsonArray* _tmp3_;
		_tmp1_ = self->priv->m_response_object;
		_tmp2_ = json_object_get_array_member (_tmp1_, "content");
		_tmp3_ = _json_array_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

guint
feed_reader_ttrss_message_getStatusCode (FeedReaderttrssMessage* self)
{
	SoupMessage* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->m_message_soup;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FeedReaderttrssMessage* self;
		self = _data1_->self;
		_json_object_unref0 (_data1_->obj);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
___lambda7_ (Block1Data* _data1_,
             JsonObject* _,
             const gchar* name,
             JsonNode* member)
{
	FeedReaderttrssMessage* self;
	self = _data1_->self;
	g_return_if_fail (_ != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (member != NULL);
	if (g_strcmp0 (name, "password") == 0) {
		JsonObject* _tmp0_;
		_tmp0_ = _data1_->obj;
		json_object_set_string_member (_tmp0_, "password", "[redacted]");
	} else {
		JsonObject* _tmp1_;
		JsonNode* _tmp2_;
		_tmp1_ = _data1_->obj;
		_tmp2_ = __vala_JsonNode_copy0 (member);
		json_object_set_member (_tmp1_, name, _tmp2_);
	}
}

static void
____lambda7__json_object_foreach (JsonObject* object,
                                  const gchar* member_name,
                                  JsonNode* member_node,
                                  gpointer self)
{
	___lambda7_ (self, object, member_name, member_node);
}

static void
feed_reader_ttrss_message_logError (FeedReaderttrssMessage* self,
                                    const gchar* prefix)
{
	Block1Data* _data1_;
	gchar* url = NULL;
	SoupMessage* _tmp0_;
	SoupURI* _tmp1_;
	gchar* _tmp2_;
	JsonObject* _tmp3_;
	JsonObject* _tmp4_;
	JsonObject* _tmp5_;
	gchar* request = NULL;
	JsonObject* _tmp8_;
	gchar* _tmp9_;
	gchar* response = NULL;
	SoupMessage* _tmp10_;
	SoupMessageBody* _tmp11_;
	SoupBuffer* _tmp12_;
	SoupBuffer* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prefix != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->m_message_soup;
	_tmp1_ = soup_message_get_uri (_tmp0_);
	_tmp2_ = soup_uri_to_string (_tmp1_, FALSE);
	url = _tmp2_;
	_tmp3_ = self->priv->m_request_object;
	_tmp4_ = _json_object_ref0 (_tmp3_);
	_data1_->obj = _tmp4_;
	_tmp5_ = _data1_->obj;
	if (json_object_has_member (_tmp5_, "password")) {
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
		_tmp6_ = json_object_new ();
		_json_object_unref0 (_data1_->obj);
		_data1_->obj = _tmp6_;
		_tmp7_ = self->priv->m_request_object;
		json_object_foreach_member (_tmp7_, ____lambda7__json_object_foreach, _data1_);
	}
	_tmp8_ = _data1_->obj;
	_tmp9_ = feed_reader_ttrss_message_object_to_string (_tmp8_);
	request = _tmp9_;
	_tmp10_ = self->priv->m_message_soup;
	_tmp11_ = _tmp10_->response_body;
	_tmp12_ = soup_message_body_flatten (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_->data;
	_tmp14__length1 = _tmp13_->length;
	_tmp15_ = g_strdup ((const gchar*) _tmp14_);
	_tmp16_ = _tmp15_;
	__vala_SoupBuffer_free0 (_tmp13_);
	response = _tmp16_;
	_tmp17_ = string_to_string (prefix);
	_tmp18_ = url;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = string_to_string (request);
	_tmp21_ = string_to_string (response);
	_tmp22_ = g_strconcat (_tmp17_, "\nURL: ", _tmp19_, "\nRequest object: ", _tmp20_, "\nResponse: ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	feed_reader_logger_error (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (response);
	_g_free0 (request);
	_g_free0 (url);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static FeedReaderConnectionError
feed_reader_ttrss_message_parseError (FeedReaderttrssMessage* self,
                                      JsonObject* err)
{
	gchar* _error_ = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	FeedReaderConnectionError result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (err != NULL, 0);
	_tmp0_ = json_object_get_string_member (err, "error");
	_tmp1_ = g_strdup (_tmp0_);
	_error_ = _tmp1_;
	_tmp2_ = _error_;
	if (g_strcmp0 (_tmp2_, "NOT_LOGGED_IN") == 0) {
		feed_reader_logger_error ("invalid ttrss session id");
		result = FEED_READER_CONNECTION_ERROR_INVALID_SESSIONID;
		_g_free0 (_error_);
		return result;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = _error_;
		if (g_strcmp0 (_tmp3_, "API_DISABLED") == 0) {
			feed_reader_logger_error ("ttrss api is disabled: please enable it first");
			result = FEED_READER_CONNECTION_ERROR_API_DISABLED;
			_g_free0 (_error_);
			return result;
		}
	}
	result = feed_reader_ttrss_message_apiError (self);
	_g_free0 (_error_);
	return result;
}

static FeedReaderConnectionError
feed_reader_ttrss_message_apiError (FeedReaderttrssMessage* self)
{
	FeedReaderConnectionError result;
	g_return_val_if_fail (self != NULL, 0);
	feed_reader_ttrss_message_logError (self, "TT-RSS API error");
	result = FEED_READER_CONNECTION_ERROR_API_ERROR;
	return result;
}

static void
feed_reader_ttrss_message_class_init (FeedReaderttrssMessageClass * klass,
                                      gpointer klass_data)
{
	feed_reader_ttrss_message_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderttrssMessage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_ttrss_message_finalize;
}

static void
feed_reader_ttrss_message_instance_init (FeedReaderttrssMessage * self,
                                         gpointer klass)
{
	JsonObject* _tmp0_;
	self->priv = feed_reader_ttrss_message_get_instance_private (self);
	_tmp0_ = json_object_new ();
	self->priv->m_request_object = _tmp0_;
}

static void
feed_reader_ttrss_message_finalize (GObject * obj)
{
	FeedReaderttrssMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_TTRSS_MESSAGE, FeedReaderttrssMessage);
	_g_object_unref0 (self->priv->m_session);
	_g_object_unref0 (self->priv->m_message_soup);
	_json_object_unref0 (self->priv->m_request_object);
	_json_object_unref0 (self->priv->m_response_object);
	G_OBJECT_CLASS (feed_reader_ttrss_message_parent_class)->finalize (obj);
}

GType
feed_reader_ttrss_message_get_type (void)
{
	return feed_reader_ttrss_message_type_id;
}

GType
feed_reader_ttrss_message_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderttrssMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_ttrss_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderttrssMessage), 0, (GInstanceInitFunc) feed_reader_ttrss_message_instance_init, NULL };
	feed_reader_ttrss_message_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderttrssMessage", &g_define_type_info, 0);
	FeedReaderttrssMessage_private_offset = sizeof (FeedReaderttrssMessagePrivate);
	return feed_reader_ttrss_message_type_id;
}

