/* ttrssUtils.c generated by valac 0.56.3, the Vala compiler
 * generated from ttrssUtils.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "ttrss.h"
#include <gio/gio.h>
#include "FeedReader.h"
#include <libsecret/secret.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	FEED_READER_TTRSS_UTILS_0_PROPERTY,
	FEED_READER_TTRSS_UTILS_NUM_PROPERTIES
};
static GParamSpec* feed_reader_ttrss_utils_properties[FEED_READER_TTRSS_UTILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FeedReaderttrssUtilsPrivate {
	GSettings* m_settings;
	FeedReaderPassword* m_password;
	FeedReaderPassword* m_htaccess_password;
};

static gint FeedReaderttrssUtils_private_offset;
static gpointer feed_reader_ttrss_utils_parent_class = NULL;
static GType feed_reader_ttrss_utils_type_id = 0;

static GHashTable* __lambda4_ (FeedReaderttrssUtils* self);
static void _g_free0_ (gpointer var);
static GHashTable* ___lambda4__feed_reader_password_get_attributes_func (gpointer self);
static GHashTable* __lambda5_ (FeedReaderttrssUtils* self);
static GHashTable* ___lambda5__feed_reader_password_get_attributes_func (gpointer self);
static void feed_reader_ttrss_utils_finalize (GObject * obj);

static inline gpointer
feed_reader_ttrss_utils_get_instance_private (FeedReaderttrssUtils* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderttrssUtils_private_offset);
}

static GType
feed_reader_ttrss_utils_ttrss_special_id_get_type_once (void)
{
	static const GEnumValue values[] = {{FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_ARCHIVED, "FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_ARCHIVED", "archived"}, {FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_STARRED, "FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_STARRED", "starred"}, {FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_PUBLISHED, "FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_PUBLISHED", "published"}, {FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_FRESH, "FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_FRESH", "fresh"}, {FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_ALL, "FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_ALL", "all"}, {FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_RECENTLY_READ, "FEED_READER_TTRSS_UTILS_TTRSS_SPECIAL_ID_RECENTLY_READ", "recently-read"}, {0, NULL, NULL}};
	GType feed_reader_ttrss_utils_ttrss_special_id_type_id;
	feed_reader_ttrss_utils_ttrss_special_id_type_id = g_enum_register_static ("FeedReaderttrssUtilsTTRSSSpecialID", values);
	return feed_reader_ttrss_utils_ttrss_special_id_type_id;
}

GType
feed_reader_ttrss_utils_ttrss_special_id_get_type (void)
{
	static volatile gsize feed_reader_ttrss_utils_ttrss_special_id_type_id__once = 0;
	if (g_once_init_enter (&feed_reader_ttrss_utils_ttrss_special_id_type_id__once)) {
		GType feed_reader_ttrss_utils_ttrss_special_id_type_id;
		feed_reader_ttrss_utils_ttrss_special_id_type_id = feed_reader_ttrss_utils_ttrss_special_id_get_type_once ();
		g_once_init_leave (&feed_reader_ttrss_utils_ttrss_special_id_type_id__once, feed_reader_ttrss_utils_ttrss_special_id_type_id);
	}
	return feed_reader_ttrss_utils_ttrss_special_id_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GHashTable*
__lambda4_ (FeedReaderttrssUtils* self)
{
	GHashTable* attributes = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable* result;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attributes = _tmp2_;
	_tmp3_ = g_strdup ("URL");
	_tmp4_ = feed_reader_ttrss_utils_getURL (self);
	g_hash_table_insert (attributes, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("Username");
	_tmp6_ = feed_reader_ttrss_utils_getUser (self);
	g_hash_table_insert (attributes, _tmp5_, _tmp6_);
	result = attributes;
	return result;
}

static GHashTable*
___lambda4__feed_reader_password_get_attributes_func (gpointer self)
{
	GHashTable* result;
	result = __lambda4_ ((FeedReaderttrssUtils*) self);
	return result;
}

static GHashTable*
__lambda5_ (FeedReaderttrssUtils* self)
{
	GHashTable* attributes = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* result;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attributes = _tmp2_;
	_tmp3_ = g_strdup ("URL");
	_tmp4_ = feed_reader_ttrss_utils_getURL (self);
	g_hash_table_insert (attributes, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("Username");
	_tmp6_ = feed_reader_ttrss_utils_getHtaccessUser (self);
	g_hash_table_insert (attributes, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("htaccess");
	_tmp8_ = g_strdup ("true");
	g_hash_table_insert (attributes, _tmp7_, _tmp8_);
	result = attributes;
	return result;
}

static GHashTable*
___lambda5__feed_reader_password_get_attributes_func (gpointer self)
{
	GHashTable* result;
	result = __lambda5_ ((FeedReaderttrssUtils*) self);
	return result;
}

FeedReaderttrssUtils*
feed_reader_ttrss_utils_construct (GType object_type,
                                   GSettingsBackend* settings_backend,
                                   SecretCollection* secrets)
{
	FeedReaderttrssUtils * self = NULL;
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp2_;
	FeedReaderPassword* _tmp3_;
	SecretSchema* htAccessSchema = NULL;
	SecretSchema* _tmp4_;
	FeedReaderPassword* _tmp5_;
	g_return_val_if_fail (secrets != NULL, NULL);
	self = (FeedReaderttrssUtils*) g_object_new (object_type, NULL);
	if (settings_backend != NULL) {
		GSettings* _tmp0_;
		_tmp0_ = g_settings_new_with_backend ("org.gnome.feedreader.ttrss", settings_backend);
		_g_object_unref0 (self->priv->m_settings);
		self->priv->m_settings = _tmp0_;
	} else {
		GSettings* _tmp1_;
		_tmp1_ = g_settings_new ("org.gnome.feedreader.ttrss");
		_g_object_unref0 (self->priv->m_settings);
		self->priv->m_settings = _tmp1_;
	}
	_tmp2_ = secret_schema_new ("org.gnome.feedreader.password", SECRET_SCHEMA_NONE, "URL", SECRET_SCHEMA_ATTRIBUTE_STRING, "Username", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp2_;
	_tmp3_ = feed_reader_password_new (secrets, pwSchema, "FeedReader: ttrss login", ___lambda4__feed_reader_password_get_attributes_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->m_password);
	self->priv->m_password = _tmp3_;
	_tmp4_ = secret_schema_new ("org.gnome.feedreader.password", SECRET_SCHEMA_NONE, "URL", SECRET_SCHEMA_ATTRIBUTE_STRING, "Username", SECRET_SCHEMA_ATTRIBUTE_STRING, "htaccess", SECRET_SCHEMA_ATTRIBUTE_BOOLEAN, NULL);
	htAccessSchema = _tmp4_;
	_tmp5_ = feed_reader_password_new (secrets, htAccessSchema, "FeedReader: ttrss htaccess Authentication", ___lambda5__feed_reader_password_get_attributes_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->m_htaccess_password);
	self->priv->m_htaccess_password = _tmp5_;
	_secret_schema_unref0 (htAccessSchema);
	_secret_schema_unref0 (pwSchema);
	return self;
}

FeedReaderttrssUtils*
feed_reader_ttrss_utils_new (GSettingsBackend* settings_backend,
                             SecretCollection* secrets)
{
	return feed_reader_ttrss_utils_construct (FEED_READER_TYPE_TTRSS_UTILS, settings_backend, secrets);
}

gchar*
feed_reader_ttrss_utils_getURL (FeedReaderttrssUtils* self)
{
	gchar* tmp_url = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "url");
	tmp_url = _tmp1_;
	_tmp2_ = tmp_url;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		const gchar* _tmp6_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp3_ = tmp_url;
		if (!g_str_has_suffix (_tmp3_, "/")) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = tmp_url;
			_tmp5_ = g_strconcat (_tmp4_, "/", NULL);
			_g_free0 (tmp_url);
			tmp_url = _tmp5_;
		}
		_tmp6_ = tmp_url;
		if (!g_str_has_suffix (_tmp6_, "/api/")) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = tmp_url;
			_tmp8_ = g_strconcat (_tmp7_, "api/", NULL);
			_g_free0 (tmp_url);
			tmp_url = _tmp8_;
		}
		_tmp10_ = tmp_url;
		if (!g_str_has_prefix (_tmp10_, "http://")) {
			const gchar* _tmp11_;
			_tmp11_ = tmp_url;
			_tmp9_ = !g_str_has_prefix (_tmp11_, "https://");
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = tmp_url;
			_tmp13_ = g_strconcat ("https://", _tmp12_, NULL);
			_g_free0 (tmp_url);
			tmp_url = _tmp13_;
		}
	}
	_tmp14_ = tmp_url;
	_tmp15_ = g_strconcat ("ttrss URL: ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	feed_reader_logger_debug (_tmp16_);
	_g_free0 (_tmp16_);
	result = tmp_url;
	return result;
}

void
feed_reader_ttrss_utils_setURL (FeedReaderttrssUtils* self,
                                const gchar* url)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_gsettingWriteString (_tmp0_, "url", url);
}

gchar*
feed_reader_ttrss_utils_getUser (FeedReaderttrssUtils* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "username");
	result = _tmp1_;
	return result;
}

void
feed_reader_ttrss_utils_setUser (FeedReaderttrssUtils* self,
                                 const gchar* user)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_gsettingWriteString (_tmp0_, "username", user);
}

gchar*
feed_reader_ttrss_utils_getHtaccessUser (FeedReaderttrssUtils* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "htaccess-username");
	result = _tmp1_;
	return result;
}

void
feed_reader_ttrss_utils_setHtaccessUser (FeedReaderttrssUtils* self,
                                         const gchar* ht_user)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ht_user != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_gsettingWriteString (_tmp0_, "htaccess-username", ht_user);
}

gchar*
feed_reader_ttrss_utils_getUnmodifiedURL (FeedReaderttrssUtils* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_settings;
	_tmp1_ = feed_reader_utils_gsettingReadString (_tmp0_, "url");
	result = _tmp1_;
	return result;
}

gchar*
feed_reader_ttrss_utils_getPasswd (FeedReaderttrssUtils* self)
{
	FeedReaderPassword* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_password;
	_tmp1_ = feed_reader_password_get_password (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}

void
feed_reader_ttrss_utils_setPassword (FeedReaderttrssUtils* self,
                                     const gchar* passwd)
{
	FeedReaderPassword* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (passwd != NULL);
	_tmp0_ = self->priv->m_password;
	feed_reader_password_set_password (_tmp0_, passwd, NULL);
}

void
feed_reader_ttrss_utils_resetAccount (FeedReaderttrssUtils* self)
{
	GSettings* _tmp0_;
	FeedReaderPassword* _tmp1_;
	FeedReaderPassword* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings;
	feed_reader_utils_resetSettings (_tmp0_);
	_tmp1_ = self->priv->m_password;
	feed_reader_password_delete_password (_tmp1_, NULL);
	_tmp2_ = self->priv->m_htaccess_password;
	feed_reader_password_delete_password (_tmp2_, NULL);
}

gchar*
feed_reader_ttrss_utils_getHtaccessPasswd (FeedReaderttrssUtils* self)
{
	FeedReaderPassword* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_htaccess_password;
	_tmp1_ = feed_reader_password_get_password (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}

void
feed_reader_ttrss_utils_setHtAccessPassword (FeedReaderttrssUtils* self,
                                             const gchar* passwd)
{
	FeedReaderPassword* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (passwd != NULL);
	_tmp0_ = self->priv->m_htaccess_password;
	feed_reader_password_set_password (_tmp0_, passwd, NULL);
}

static void
feed_reader_ttrss_utils_class_init (FeedReaderttrssUtilsClass * klass,
                                    gpointer klass_data)
{
	feed_reader_ttrss_utils_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderttrssUtils_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_ttrss_utils_finalize;
}

static void
feed_reader_ttrss_utils_instance_init (FeedReaderttrssUtils * self,
                                       gpointer klass)
{
	self->priv = feed_reader_ttrss_utils_get_instance_private (self);
}

static void
feed_reader_ttrss_utils_finalize (GObject * obj)
{
	FeedReaderttrssUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_TTRSS_UTILS, FeedReaderttrssUtils);
	_g_object_unref0 (self->priv->m_settings);
	_g_object_unref0 (self->priv->m_password);
	_g_object_unref0 (self->priv->m_htaccess_password);
	G_OBJECT_CLASS (feed_reader_ttrss_utils_parent_class)->finalize (obj);
}

GType
feed_reader_ttrss_utils_get_type (void)
{
	return feed_reader_ttrss_utils_type_id;
}

GType
feed_reader_ttrss_utils_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderttrssUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_ttrss_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderttrssUtils), 0, (GInstanceInitFunc) feed_reader_ttrss_utils_instance_init, NULL };
	feed_reader_ttrss_utils_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "FeedReaderttrssUtils", &g_define_type_info, 0);
	FeedReaderttrssUtils_private_offset = sizeof (FeedReaderttrssUtilsPrivate);
	return feed_reader_ttrss_utils_type_id;
}

