/* Email.c generated by valac 0.56.3, the Vala compiler
 * generated from Email.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "mail.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "FeedReader.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>
#include <libpeas/peas.h>

enum  {
	FEED_READER_SHARE_MAIL_0_PROPERTY,
	FEED_READER_SHARE_MAIL_NUM_PROPERTIES
};
static GParamSpec* feed_reader_share_mail_properties[FEED_READER_SHARE_MAIL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _FeedReaderShareMailPrivate {
	gchar* m_body;
	gchar* m_to;
};

struct _Block1Data {
	int _ref_count_;
	FeedReaderShareMail* self;
	FeedReaderEmailForm* widget;
};

static gint FeedReaderShareMail_private_offset;
static gpointer feed_reader_share_mail_parent_class = NULL;
static FeedReaderShareAccountInterfaceIface * feed_reader_share_mail_feed_reader_share_account_interface_parent_iface = NULL;
static GType feed_reader_share_mail_type_id = 0;

static gboolean feed_reader_share_mail_real_addBookmark (FeedReaderShareAccountInterface* base,
                                                  const gchar* id,
                                                  const gchar* url,
                                                  gboolean system);
static void feed_reader_share_mail_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                      GeeList* accounts);
static gboolean feed_reader_share_mail_real_logout (FeedReaderShareAccountInterface* base,
                                             const gchar* id);
static gchar* feed_reader_share_mail_real_getIconName (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_share_mail_real_getUsername (FeedReaderShareAccountInterface* base,
                                                const gchar* id);
static gboolean feed_reader_share_mail_real_needSetup (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_share_mail_real_singleInstance (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_share_mail_real_useSystemAccounts (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_share_mail_real_pluginID (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_share_mail_real_pluginName (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_share_mail_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                                                     const gchar* id,
                                                                     const gchar* username);
static FeedReaderServiceSetup* feed_reader_share_mail_real_newSetup (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_share_mail_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                                                      const gchar* id,
                                                                      const gchar* username);
static FeedReaderShareForm* feed_reader_share_mail_real_shareWidget (FeedReaderShareAccountInterface* base,
                                                              const gchar* url);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda6_ (Block1Data* _data1_);
static void ___lambda6__feed_reader_share_form_share (FeedReaderShareForm* _sender,
                                               gpointer self);
static void feed_reader_share_mail_finalize (GObject * obj);
GType feed_reader_email_form_register_type (GTypeModule * module);

static inline gpointer
feed_reader_share_mail_get_instance_private (FeedReaderShareMail* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderShareMail_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
feed_reader_share_mail_real_addBookmark (FeedReaderShareAccountInterface* base,
                                         const gchar* id,
                                         const gchar* url,
                                         gboolean system)
{
	FeedReaderShareMail * self;
	gchar* subject = NULL;
	gchar* _tmp0_;
	gchar* body = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* mailto = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (FeedReaderShareMail*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	_tmp0_ = g_uri_escape_string ("Amazing article", NULL, TRUE);
	subject = _tmp0_;
	_tmp1_ = self->priv->m_body;
	_tmp2_ = string_replace (_tmp1_, "$URL", url);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_uri_escape_string (_tmp3_, NULL, TRUE);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	body = _tmp5_;
	_tmp6_ = self->priv->m_to;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = string_to_string (subject);
	_tmp9_ = string_to_string (body);
	_tmp10_ = g_strconcat ("mailto:", _tmp7_, "?subject=", _tmp8_, "&body=", _tmp9_, NULL);
	mailto = _tmp10_;
	feed_reader_logger_debug (mailto);
	{
		FeedReaderMainWindow* _tmp11_;
		FeedReaderMainWindow* _tmp12_;
		_tmp11_ = feed_reader_main_window_get_default ();
		_tmp12_ = _tmp11_;
		gtk_show_uri_on_window ((GtkWindow*) _tmp12_, mailto, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_object_unref0 (_tmp12_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = TRUE;
		_g_free0 (mailto);
		_g_free0 (body);
		_g_free0 (subject);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strdup_printf ("share via mail failed: %s", _tmp14_);
		_tmp16_ = _tmp15_;
		feed_reader_logger_error (_tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		_g_free0 (mailto);
		_g_free0 (body);
		_g_free0 (subject);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	result = FALSE;
	_g_free0 (mailto);
	_g_free0 (body);
	_g_free0 (subject);
	return result;
}

static void
feed_reader_share_mail_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                 GeeList* accounts)
{
	FeedReaderShareMail * self;
	self = (FeedReaderShareMail*) base;
	g_return_if_fail (accounts != NULL);
}

static gboolean
feed_reader_share_mail_real_logout (FeedReaderShareAccountInterface* base,
                                    const gchar* id)
{
	FeedReaderShareMail * self;
	gboolean result;
	self = (FeedReaderShareMail*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	result = FALSE;
	return result;
}

static gchar*
feed_reader_share_mail_real_getIconName (FeedReaderShareAccountInterface* base)
{
	FeedReaderShareMail * self;
	GtkIconTheme* _tmp0_;
	GtkIconInfo* _tmp1_;
	GtkIconInfo* _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp5_;
	gchar* result;
	self = (FeedReaderShareMail*) base;
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = gtk_icon_theme_lookup_icon (_tmp0_, "mail-send", 0, GTK_ICON_LOOKUP_FORCE_SVG);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("mail-send");
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup ("feed-share-mail");
	result = _tmp5_;
	return result;
}

static gchar*
feed_reader_share_mail_real_getUsername (FeedReaderShareAccountInterface* base,
                                         const gchar* id)
{
	FeedReaderShareMail * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderShareMail*) base;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup ("Email");
	result = _tmp0_;
	return result;
}

static gboolean
feed_reader_share_mail_real_needSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderShareMail * self;
	gboolean result;
	self = (FeedReaderShareMail*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_share_mail_real_singleInstance (FeedReaderShareAccountInterface* base)
{
	FeedReaderShareMail * self;
	gboolean result;
	self = (FeedReaderShareMail*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_share_mail_real_useSystemAccounts (FeedReaderShareAccountInterface* base)
{
	FeedReaderShareMail * self;
	gboolean result;
	self = (FeedReaderShareMail*) base;
	result = FALSE;
	return result;
}

static gchar*
feed_reader_share_mail_real_pluginID (FeedReaderShareAccountInterface* base)
{
	FeedReaderShareMail * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderShareMail*) base;
	_tmp0_ = g_strdup ("mail");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_share_mail_real_pluginName (FeedReaderShareAccountInterface* base)
{
	FeedReaderShareMail * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderShareMail*) base;
	_tmp0_ = g_strdup ("Email");
	result = _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_share_mail_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                             const gchar* id,
                                             const gchar* username)
{
	FeedReaderShareMail * self;
	FeedReaderServiceSetup* result;
	self = (FeedReaderShareMail*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	result = NULL;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_share_mail_real_newSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderShareMail * self;
	FeedReaderServiceSetup* result;
	self = (FeedReaderShareMail*) base;
	result = NULL;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_share_mail_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                              const gchar* id,
                                              const gchar* username)
{
	FeedReaderShareMail * self;
	FeedReaderServiceSetup* result;
	self = (FeedReaderShareMail*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FeedReaderShareMail* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda6_ (Block1Data* _data1_)
{
	FeedReaderShareMail* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = _data1_->self;
	_tmp0_ = feed_reader_email_form_getTo (_data1_->widget);
	_g_free0 (self->priv->m_to);
	self->priv->m_to = _tmp0_;
	_tmp1_ = feed_reader_email_form_getBody (_data1_->widget);
	_g_free0 (self->priv->m_body);
	self->priv->m_body = _tmp1_;
}

static void
___lambda6__feed_reader_share_form_share (FeedReaderShareForm* _sender,
                                          gpointer self)
{
	__lambda6_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static FeedReaderShareForm*
feed_reader_share_mail_real_shareWidget (FeedReaderShareAccountInterface* base,
                                         const gchar* url)
{
	FeedReaderShareMail * self;
	Block1Data* _data1_;
	FeedReaderEmailForm* _tmp0_;
	FeedReaderShareForm* _tmp1_;
	FeedReaderShareForm* result;
	self = (FeedReaderShareMail*) base;
	g_return_val_if_fail (url != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = feed_reader_email_form_new (url);
	g_object_ref_sink (_tmp0_);
	_data1_->widget = _tmp0_;
	g_signal_connect_data ((FeedReaderShareForm*) _data1_->widget, "share", (GCallback) ___lambda6__feed_reader_share_form_share, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp1_ = _g_object_ref0 ((FeedReaderShareForm*) _data1_->widget);
	result = _tmp1_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

FeedReaderShareMail*
feed_reader_share_mail_construct (GType object_type)
{
	FeedReaderShareMail * self = NULL;
	self = (FeedReaderShareMail*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderShareMail*
feed_reader_share_mail_new (void)
{
	return feed_reader_share_mail_construct (FEED_READER_TYPE_SHARE_MAIL);
}

static void
feed_reader_share_mail_class_init (FeedReaderShareMailClass * klass,
                                   gpointer klass_data)
{
	feed_reader_share_mail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderShareMail_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_share_mail_finalize;
}

static void
feed_reader_share_mail_feed_reader_share_account_interface_interface_init (FeedReaderShareAccountInterfaceIface * iface,
                                                                           gpointer iface_data)
{
	feed_reader_share_mail_feed_reader_share_account_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->addBookmark = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*, gboolean)) feed_reader_share_mail_real_addBookmark;
	iface->setupSystemAccounts = (void (*) (FeedReaderShareAccountInterface*, GeeList*)) feed_reader_share_mail_real_setupSystemAccounts;
	iface->logout = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_share_mail_real_logout;
	iface->getIconName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_share_mail_real_getIconName;
	iface->getUsername = (gchar* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_share_mail_real_getUsername;
	iface->needSetup = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_share_mail_real_needSetup;
	iface->singleInstance = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_share_mail_real_singleInstance;
	iface->useSystemAccounts = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_share_mail_real_useSystemAccounts;
	iface->pluginID = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_share_mail_real_pluginID;
	iface->pluginName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_share_mail_real_pluginName;
	iface->newSetup_withID = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_share_mail_real_newSetup_withID;
	iface->newSetup = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*)) feed_reader_share_mail_real_newSetup;
	iface->newSystemAccount = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_share_mail_real_newSystemAccount;
	iface->shareWidget = (FeedReaderShareForm* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_share_mail_real_shareWidget;
}

static void
feed_reader_share_mail_instance_init (FeedReaderShareMail * self,
                                      gpointer klass)
{
	self->priv = feed_reader_share_mail_get_instance_private (self);
}

static void
feed_reader_share_mail_finalize (GObject * obj)
{
	FeedReaderShareMail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_SHARE_MAIL, FeedReaderShareMail);
	_g_free0 (self->priv->m_body);
	_g_free0 (self->priv->m_to);
	G_OBJECT_CLASS (feed_reader_share_mail_parent_class)->finalize (obj);
}

GType
feed_reader_share_mail_get_type (void)
{
	return feed_reader_share_mail_type_id;
}

GType
feed_reader_share_mail_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderShareMailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_share_mail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderShareMail), 0, (GInstanceInitFunc) feed_reader_share_mail_instance_init, NULL };
	static const GInterfaceInfo feed_reader_share_account_interface_info = { (GInterfaceInitFunc) feed_reader_share_mail_feed_reader_share_account_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	feed_reader_share_mail_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "FeedReaderShareMail", &g_define_type_info, 0);
	g_type_module_add_interface (module, feed_reader_share_mail_type_id, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, &feed_reader_share_account_interface_info);
	FeedReaderShareMail_private_offset = sizeof (FeedReaderShareMailPrivate);
	return feed_reader_share_mail_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_share_mail_register_type (module);
	feed_reader_email_form_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, FEED_READER_TYPE_SHARE_MAIL);
	_g_object_unref0 (objmodule);
}

