/* InstapaperAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from InstapaperAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "instapaper.h"
#include <glib-object.h>
#include <gee.h>
#include "FeedReader.h"
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <libsoup/soup.h>
#include <libpeas/peas.h>

#define FEED_READER_INSTAPAPER_SECRETS_base_uri "https://www.instapaper.com/api/"
#define FEED_READER_INSTAPAPER_SECRETS_oauth_consumer_key "b7681e07bf554b15813511217054e1b2"
#define FEED_READER_INSTAPAPER_SECRETS_oauth_consumer_secret "c5307cb359d54685904f6d38aaeede6f"
#define FEED_READER_INSTAPAPER_SECRETS_oauth_callback "feedreader://instapaper"

enum  {
	FEED_READER_INSTA_API_0_PROPERTY,
	FEED_READER_INSTA_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_insta_api_properties[FEED_READER_INSTA_API_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _Block1Data {
	int _ref_count_;
	FeedReaderInstaAPI* self;
	gboolean removed;
	gchar* id;
};

static gpointer feed_reader_insta_api_parent_class = NULL;
static FeedReaderShareAccountInterfaceIface * feed_reader_insta_api_feed_reader_share_account_interface_parent_iface = NULL;
static GType feed_reader_insta_api_type_id = 0;

static void feed_reader_insta_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                     GeeList* accounts);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _g_free0_ (gpointer var);
static void _vala_JsonNode_free (JsonNode* self);
static gboolean feed_reader_insta_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                                 const gchar* id,
                                                 const gchar* url,
                                                 gboolean system);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static gboolean feed_reader_insta_api_real_logout (FeedReaderShareAccountInterface* base,
                                            const gchar* id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* async_res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* feed_reader_insta_api_real_getIconName (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_insta_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                               const gchar* id);
static gboolean feed_reader_insta_api_real_needSetup (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_insta_api_real_singleInstance (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_insta_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_insta_api_real_pluginID (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_insta_api_real_pluginName (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_insta_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                                                    const gchar* id,
                                                                    const gchar* username);
static FeedReaderServiceSetup* feed_reader_insta_api_real_newSetup (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_insta_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                                                     const gchar* id,
                                                                     const gchar* username);
static FeedReaderShareForm* feed_reader_insta_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                                             const gchar* url);
GType feed_reader_instapaper_setup_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

FeedReaderInstaAPI*
feed_reader_insta_api_construct (GType object_type)
{
	FeedReaderInstaAPI * self = NULL;
	self = (FeedReaderInstaAPI*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderInstaAPI*
feed_reader_insta_api_new (void)
{
	return feed_reader_insta_api_construct (FEED_READER_TYPE_INSTA_API);
}

static void
feed_reader_insta_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                GeeList* accounts)
{
	FeedReaderInstaAPI * self;
	self = (FeedReaderInstaAPI*) base;
	g_return_if_fail (accounts != NULL);
}

gchar*
feed_reader_insta_api_getRequestToken (FeedReaderInstaAPI* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

gboolean
feed_reader_insta_api_getAccessToken (FeedReaderInstaAPI* self,
                                      const gchar* id,
                                      const gchar* username,
                                      const gchar* password)
{
	gchar* userID = NULL;
	gchar* _tmp0_;
	OAuthProxy* oauthObject = NULL;
	OAuthProxy* _tmp1_;
	RestProxyCall* call = NULL;
	RestProxyCall* _tmp2_;
	gchar* response = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint64 status = 0LL;
	gint secretStart = 0;
	const gchar* _tmp10_;
	gint secretEnd = 0;
	const gchar* _tmp11_;
	gint tokenStart = 0;
	const gchar* _tmp12_;
	gchar* accessToken_secret = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* accessToken = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	RestProxyCall* call2 = NULL;
	RestProxyCall* _tmp19_;
	RestProxyCall* _tmp20_;
	RestProxyCall* _tmp21_;
	JsonParser* parser = NULL;
	JsonParser* _tmp28_;
	JsonNode* root_node = NULL;
	JsonParser* _tmp35_;
	JsonNode* _tmp36_;
	JsonNode* _tmp37_;
	JsonArray* userArray = NULL;
	JsonNode* _tmp38_;
	JsonArray* _tmp39_;
	JsonArray* _tmp40_;
	JsonObject* root_object = NULL;
	JsonArray* _tmp41_;
	JsonObject* _tmp42_;
	JsonObject* _tmp43_;
	JsonObject* _tmp44_;
	GSettings* settings = NULL;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GSettings* _tmp55_;
	GSettings* _tmp56_;
	GSettings* _tmp57_;
	const gchar* _tmp58_;
	GSettings* _tmp59_;
	const gchar* _tmp60_;
	GSettings* _tmp61_;
	GSettings* _tmp62_;
	const gchar* _tmp63_;
	gchar** array = NULL;
	GSettings* _tmp64_;
	GSettings* _tmp65_;
	gchar** _tmp66_;
	gchar** _tmp67_;
	gchar** _tmp68_;
	gint _tmp68__length1;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp69_;
	GSettings* _tmp70_;
	GSettings* _tmp71_;
	gchar** _tmp72_;
	gint _tmp72__length1;
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp73_;
	GHashTable* attributes = NULL;
	GHashFunc _tmp74_;
	GEqualFunc _tmp75_;
	GHashTable* _tmp76_;
	GHashTable* _tmp77_;
	gchar* _tmp78_;
	const gchar* _tmp79_;
	gchar* _tmp80_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (username != NULL, FALSE);
	g_return_val_if_fail (password != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	userID = _tmp0_;
	_tmp1_ = (OAuthProxy*) oauth_proxy_new (FEED_READER_INSTAPAPER_SECRETS_oauth_consumer_key, FEED_READER_INSTAPAPER_SECRETS_oauth_consumer_secret, "https://www.instapaper.com/api/1/", FALSE);
	oauthObject = _tmp1_;
	_tmp2_ = rest_proxy_new_call ((RestProxy*) oauthObject);
	call = _tmp2_;
	g_object_set ((RestProxy*) oauthObject, "url-format", "https://www.instapaper.com/api/1/", NULL);
	rest_proxy_call_set_function (call, "oauth/access_token");
	rest_proxy_call_set_method (call, "POST");
	rest_proxy_call_add_param (call, "x_auth_mode", "client_auth");
	rest_proxy_call_add_param (call, "x_auth_username", username);
	rest_proxy_call_add_param (call, "x_auth_password", password);
	{
		rest_proxy_call_run (call, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_strconcat ("instapaper getAccessToken: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		feed_reader_logger_error (_tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (userID);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = rest_proxy_call_get_payload (call);
	_tmp9_ = g_strdup (_tmp8_);
	response = _tmp9_;
	status = (gint64) rest_proxy_call_get_status_code (call);
	if (status != ((gint64) 200)) {
		result = FALSE;
		_g_free0 (response);
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (userID);
		return result;
	}
	_tmp10_ = response;
	secretStart = string_index_of_char (_tmp10_, (gunichar) '=', 0) + 1;
	_tmp11_ = response;
	secretEnd = string_index_of_char (_tmp11_, (gunichar) '&', secretStart);
	_tmp12_ = response;
	tokenStart = string_index_of_char (_tmp12_, (gunichar) '=', secretEnd) + 1;
	_tmp13_ = response;
	_tmp14_ = string_substring (_tmp13_, (glong) secretStart, (glong) (secretEnd - secretStart));
	accessToken_secret = _tmp14_;
	_tmp15_ = response;
	_tmp16_ = string_substring (_tmp15_, (glong) tokenStart, (glong) -1);
	accessToken = _tmp16_;
	_tmp17_ = accessToken;
	oauth_proxy_set_token (oauthObject, _tmp17_);
	_tmp18_ = accessToken_secret;
	oauth_proxy_set_token_secret (oauthObject, _tmp18_);
	_tmp19_ = rest_proxy_new_call ((RestProxy*) oauthObject);
	call2 = _tmp19_;
	g_object_set ((RestProxy*) oauthObject, "url-format", "https://www.instapaper.com/api/1/", NULL);
	_tmp20_ = call2;
	rest_proxy_call_set_function (_tmp20_, "account/verify_credentials");
	_tmp21_ = call2;
	rest_proxy_call_set_method (_tmp21_, "POST");
	{
		RestProxyCall* _tmp22_;
		_tmp22_ = call2;
		rest_proxy_call_run (_tmp22_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = g_strconcat ("getUserID: ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		feed_reader_logger_debug (_tmp26_);
		_g_free0 (_tmp26_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp27_ = FALSE;
		_g_object_unref0 (call2);
		_g_free0 (accessToken);
		_g_free0 (accessToken_secret);
		_g_free0 (response);
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (userID);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp27_;
	}
	_tmp28_ = json_parser_new ();
	parser = _tmp28_;
	{
		JsonParser* _tmp29_;
		RestProxyCall* _tmp30_;
		const gchar* _tmp31_;
		_tmp29_ = parser;
		_tmp30_ = call2;
		_tmp31_ = rest_proxy_call_get_payload (_tmp30_);
		json_parser_load_from_data (_tmp29_, _tmp31_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("Could not load response to Message from instapaper");
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		feed_reader_logger_error (_tmp33_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp34_ = FALSE;
		_g_object_unref0 (parser);
		_g_object_unref0 (call2);
		_g_free0 (accessToken);
		_g_free0 (accessToken_secret);
		_g_free0 (response);
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (userID);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp34_;
	}
	_tmp35_ = parser;
	_tmp36_ = json_parser_get_root (_tmp35_);
	_tmp37_ = __vala_JsonNode_copy0 (_tmp36_);
	root_node = _tmp37_;
	_tmp38_ = root_node;
	_tmp39_ = json_node_get_array (_tmp38_);
	_tmp40_ = _json_array_ref0 (_tmp39_);
	userArray = _tmp40_;
	_tmp41_ = userArray;
	_tmp42_ = json_array_get_object_element (_tmp41_, (guint) 0);
	_tmp43_ = _json_object_ref0 (_tmp42_);
	root_object = _tmp43_;
	_tmp44_ = root_object;
	if (json_object_has_member (_tmp44_, "user_id")) {
		JsonObject* _tmp45_;
		gchar* _tmp46_;
		_tmp45_ = root_object;
		_tmp46_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp45_, "user_id"));
		_g_free0 (userID);
		userID = _tmp46_;
	} else {
		JsonObject* _tmp47_;
		_tmp47_ = root_object;
		if (json_object_has_member (_tmp47_, "error")) {
			JsonObject* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			JsonObject* _tmp51_;
			const gchar* _tmp52_;
			_tmp48_ = root_object;
			_tmp49_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp48_, "error_code"));
			_tmp50_ = _tmp49_;
			feed_reader_logger_error (_tmp50_);
			_g_free0 (_tmp50_);
			_tmp51_ = root_object;
			_tmp52_ = json_object_get_string_member (_tmp51_, "message");
			feed_reader_logger_error (_tmp52_);
		}
	}
	_tmp53_ = g_strdup_printf ("/org/gnome/feedreader/share/instapaper/%s/", id);
	_tmp54_ = _tmp53_;
	_tmp55_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp54_);
	_tmp56_ = _tmp55_;
	_g_free0 (_tmp54_);
	settings = _tmp56_;
	_tmp57_ = settings;
	_tmp58_ = accessToken;
	g_settings_set_string (_tmp57_, "oauth-access-token", _tmp58_);
	_tmp59_ = settings;
	_tmp60_ = accessToken_secret;
	g_settings_set_string (_tmp59_, "oauth-access-token-secret", _tmp60_);
	_tmp61_ = settings;
	g_settings_set_string (_tmp61_, "username", username);
	_tmp62_ = settings;
	_tmp63_ = userID;
	g_settings_set_string (_tmp62_, "user-id", _tmp63_);
	_tmp64_ = feed_reader_settings_share ("instapaper");
	_tmp65_ = _tmp64_;
	_tmp67_ = _tmp66_ = g_settings_get_strv (_tmp65_, "account-ids");
	_tmp68_ = _tmp67_;
	_tmp68__length1 = _vala_array_length (_tmp66_);
	_g_object_unref0 (_tmp65_);
	array = _tmp68_;
	array_length1 = _tmp68__length1;
	_array_size_ = array_length1;
	_tmp69_ = g_strdup (id);
	_vala_array_add1 (&array, &array_length1, &_array_size_, _tmp69_);
	_tmp70_ = feed_reader_settings_share ("instapaper");
	_tmp71_ = _tmp70_;
	_tmp72_ = array;
	_tmp72__length1 = array_length1;
	g_settings_set_strv (_tmp71_, "account-ids", _tmp72_);
	_g_object_unref0 (_tmp71_);
	_tmp73_ = secret_schema_new ("org.gnome.feedreader.instapaper.password", SECRET_SCHEMA_NONE, "userID", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp73_;
	_tmp74_ = g_str_hash;
	_tmp75_ = g_str_equal;
	_tmp76_ = g_hash_table_new_full (_tmp74_, _tmp75_, _g_free0_, _g_free0_);
	attributes = _tmp76_;
	_tmp77_ = attributes;
	_tmp78_ = g_strdup ("userID");
	_tmp79_ = userID;
	_tmp80_ = g_strdup (_tmp79_);
	g_hash_table_insert (_tmp77_, _tmp78_, _tmp80_);
	{
		SecretSchema* _tmp81_;
		GHashTable* _tmp82_;
		_tmp81_ = pwSchema;
		_tmp82_ = attributes;
		secret_password_storev_sync (_tmp81_, _tmp82_, SECRET_COLLECTION_DEFAULT, "Feedreader: Instapaper login", password, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp83_;
		const gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp83_ = e;
		_tmp84_ = _tmp83_->message;
		_tmp85_ = g_strconcat ("InstaAPI - getAccessToken: ", _tmp84_, NULL);
		_tmp86_ = _tmp85_;
		feed_reader_logger_error (_tmp86_);
		_g_free0 (_tmp86_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp87_ = FALSE;
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (pwSchema);
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		_json_object_unref0 (root_object);
		_json_array_unref0 (userArray);
		__vala_JsonNode_free0 (root_node);
		_g_object_unref0 (parser);
		_g_object_unref0 (call2);
		_g_free0 (accessToken);
		_g_free0 (accessToken_secret);
		_g_free0 (response);
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (userID);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp87_;
	}
	result = TRUE;
	_g_hash_table_unref0 (attributes);
	_secret_schema_unref0 (pwSchema);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	_json_object_unref0 (root_object);
	_json_array_unref0 (userArray);
	__vala_JsonNode_free0 (root_node);
	_g_object_unref0 (parser);
	_g_object_unref0 (call2);
	_g_free0 (accessToken);
	_g_free0 (accessToken_secret);
	_g_free0 (response);
	_g_object_unref0 (call);
	_g_object_unref0 (oauthObject);
	_g_free0 (userID);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static gboolean
feed_reader_insta_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                        const gchar* id,
                                        const gchar* url,
                                        gboolean system)
{
	FeedReaderInstaAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp4_;
	GHashTable* attributes = NULL;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* password = NULL;
	gchar* _tmp10_;
	SoupSession* session = NULL;
	SoupSession* _tmp19_;
	SoupSession* _tmp20_;
	gchar* message = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	SoupMessage* message_soup = NULL;
	SoupMessage* _tmp45_;
	SoupMessage* _tmp46_;
	const gchar* _tmp47_;
	guint8* _tmp48_;
	gint _tmp48__length1;
	gint _tmp49_ = 0;
	guint8* _tmp50_;
	gint _tmp50__length1;
	GSettings* _tmp51_;
	GSettings* _tmp52_;
	gboolean _tmp53_;
	SoupSession* _tmp56_;
	SoupMessage* _tmp57_;
	gchar* response = NULL;
	SoupMessage* _tmp58_;
	SoupMessageBody* _tmp59_;
	SoupBuffer* _tmp60_;
	SoupBuffer* _tmp61_;
	guint8* _tmp62_;
	gint _tmp62__length1;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gboolean _tmp65_ = FALSE;
	const gchar* _tmp66_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (FeedReaderInstaAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/instapaper/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = secret_schema_new ("org.gnome.feedreader.instapaper.password", SECRET_SCHEMA_NONE, "userID", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_free0_);
	attributes = _tmp7_;
	_tmp8_ = g_strdup ("userID");
	_tmp9_ = g_settings_get_string (settings, "user-id");
	g_hash_table_insert (attributes, _tmp8_, _tmp9_);
	_tmp10_ = g_strdup ("");
	password = _tmp10_;
	{
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = secret_password_lookupv_sync (pwSchema, attributes, NULL, &_inner_error0_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp11_;
		_tmp11_ = NULL;
		_g_free0 (password);
		password = _tmp13_;
		_g_free0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		_tmp16_ = g_strconcat ("InstaAPI addBookmark: ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		feed_reader_logger_error (_tmp17_);
		_g_free0 (_tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_g_free0 (password);
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (pwSchema);
		_g_object_unref0 (settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	_tmp19_ = soup_session_new ();
	session = _tmp19_;
	_tmp20_ = session;
	g_object_set (_tmp20_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp21_ = g_settings_get_string (settings, "user-id");
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat ("user_id=", _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, "&username=", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_settings_get_string (settings, "username");
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "&password=", NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = password;
	_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_tmp35_, "&url=", NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_uri_escape_string (url, NULL, TRUE);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp37_, _tmp39_, NULL);
	_tmp41_ = _tmp40_;
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	message = _tmp41_;
	_tmp42_ = message;
	_tmp43_ = g_strconcat ("InstaAPI: ", _tmp42_, NULL);
	_tmp44_ = _tmp43_;
	feed_reader_logger_debug (_tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = soup_message_new ("POST", "https://www.instapaper.com/api/add");
	message_soup = _tmp45_;
	_tmp46_ = message_soup;
	_tmp47_ = message;
	_tmp48_ = string_get_data (_tmp47_, &_tmp49_);
	_tmp48__length1 = _tmp49_;
	_tmp50_ = _tmp48_;
	_tmp50__length1 = _tmp48__length1;
	soup_message_set_request (_tmp46_, "application/x-www-form-urlencoded", SOUP_MEMORY_COPY, _tmp50_, (gsize) _tmp50__length1);
	_tmp51_ = feed_reader_settings_tweaks ();
	_tmp52_ = _tmp51_;
	_tmp53_ = g_settings_get_boolean (_tmp52_, "do-not-track");
	_g_object_unref0 (_tmp52_);
	if (_tmp53_) {
		SoupMessage* _tmp54_;
		SoupMessageHeaders* _tmp55_;
		_tmp54_ = message_soup;
		_tmp55_ = _tmp54_->request_headers;
		soup_message_headers_append (_tmp55_, "DNT", "1");
	}
	_tmp56_ = session;
	_tmp57_ = message_soup;
	soup_session_send_message (_tmp56_, _tmp57_);
	_tmp58_ = message_soup;
	_tmp59_ = _tmp58_->response_body;
	_tmp60_ = soup_message_body_flatten (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_->data;
	_tmp62__length1 = _tmp61_->length;
	_tmp63_ = g_strdup ((const gchar*) _tmp62_);
	_tmp64_ = _tmp63_;
	__vala_SoupBuffer_free0 (_tmp61_);
	response = _tmp64_;
	_tmp66_ = response;
	if (_tmp66_ == NULL) {
		_tmp65_ = TRUE;
	} else {
		const gchar* _tmp67_;
		_tmp67_ = response;
		_tmp65_ = g_strcmp0 (_tmp67_, "") == 0;
	}
	if (_tmp65_) {
		result = FALSE;
		_g_free0 (response);
		_g_object_unref0 (message_soup);
		_g_free0 (message);
		_g_object_unref0 (session);
		_g_free0 (password);
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (pwSchema);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp68_ = response;
	_tmp69_ = g_strconcat ("InstaAPI: ", _tmp68_, NULL);
	_tmp70_ = _tmp69_;
	feed_reader_logger_debug (_tmp70_);
	_g_free0 (_tmp70_);
	result = TRUE;
	_g_free0 (response);
	_g_object_unref0 (message_soup);
	_g_free0 (message);
	_g_object_unref0 (session);
	_g_free0 (password);
	_g_hash_table_unref0 (attributes);
	_secret_schema_unref0 (pwSchema);
	_g_object_unref0 (settings);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FeedReaderInstaAPI* self;
		self = _data1_->self;
		_g_free0 (_data1_->id);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
__lambda4_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* async_res)
{
	FeedReaderInstaAPI* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (async_res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = secret_password_clear_finish (async_res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data1_->removed = _tmp0_;
		if (!_data1_->removed) {
			const gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = string_to_string (_data1_->id);
			_tmp2_ = g_strconcat ("Could not delete password of InstaAPI account ", _tmp1_, NULL);
			_tmp3_ = _tmp2_;
			feed_reader_logger_error (_tmp3_);
			_g_free0 (_tmp3_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strdup_printf ("InstaAPI.logout: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		feed_reader_logger_error (_tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
feed_reader_insta_api_real_logout (FeedReaderShareAccountInterface* base,
                                   const gchar* id)
{
	FeedReaderInstaAPI * self;
	Block1Data* _data1_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSettings* settings = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp9_;
	GHashTable* attributes = NULL;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	GSettings* _tmp15_;
	gchar* _tmp16_;
	SecretSchema* _tmp17_;
	GHashTable* _tmp18_;
	GHashTable* _tmp19_;
	gchar** keys = NULL;
	GSettings* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** array = NULL;
	GSettings* _tmp27_;
	GSettings* _tmp28_;
	gchar** _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gint array_length1;
	gint _array_size_;
	gchar** array2 = NULL;
	gchar** _tmp32_;
	gint array2_length1;
	gint _array2_size_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	GSettings* _tmp38_;
	GSettings* _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gboolean result;
	self = (FeedReaderInstaAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (id);
	_g_free0 (_data1_->id);
	_data1_->id = _tmp0_;
	_tmp1_ = string_to_string (_data1_->id);
	_tmp2_ = g_strconcat ("InstaAPI.logout(", _tmp1_, ")", NULL);
	_tmp3_ = _tmp2_;
	feed_reader_logger_debug (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = string_to_string (_data1_->id);
	_tmp5_ = g_strconcat ("/org/gnome/feedreader/share/instapaper/", _tmp4_, "/", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	settings = _tmp8_;
	_tmp9_ = secret_schema_new ("org.gnome.feedreader.instapaper.password", SECRET_SCHEMA_NONE, "userID", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _g_free0_);
	attributes = _tmp12_;
	_tmp13_ = attributes;
	_tmp14_ = g_strdup ("userID");
	_tmp15_ = settings;
	_tmp16_ = g_settings_get_string (_tmp15_, "user-id");
	g_hash_table_insert (_tmp13_, _tmp14_, _tmp16_);
	_data1_->removed = FALSE;
	_tmp17_ = pwSchema;
	_tmp18_ = attributes;
	_tmp19_ = _g_hash_table_ref0 (_tmp18_);
	secret_password_clearv (_tmp17_, _tmp19_, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp20_ = settings;
	_tmp22_ = _tmp21_ = g_settings_list_keys (_tmp20_);
	keys = _tmp22_;
	keys_length1 = _vala_array_length (_tmp21_);
	_keys_size_ = keys_length1;
	_tmp23_ = keys;
	_tmp23__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp23_;
		key_collection_length1 = _tmp23__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp24_;
			gchar* key = NULL;
			_tmp24_ = g_strdup (key_collection[key_it]);
			key = _tmp24_;
			{
				GSettings* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = settings;
				_tmp26_ = key;
				g_settings_reset (_tmp25_, _tmp26_);
				_g_free0 (key);
			}
		}
	}
	_tmp27_ = feed_reader_settings_share ("instapaper");
	_tmp28_ = _tmp27_;
	_tmp30_ = _tmp29_ = g_settings_get_strv (_tmp28_, "account-ids");
	_tmp31_ = _tmp30_;
	_tmp31__length1 = _vala_array_length (_tmp29_);
	_g_object_unref0 (_tmp28_);
	array = _tmp31_;
	array_length1 = _tmp31__length1;
	_array_size_ = array_length1;
	_tmp32_ = g_new0 (gchar*, 0 + 1);
	array2 = _tmp32_;
	array2_length1 = 0;
	_array2_size_ = array2_length1;
	_tmp33_ = array;
	_tmp33__length1 = array_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp33_;
		i_collection_length1 = _tmp33__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			gchar* _tmp34_;
			gchar* i = NULL;
			_tmp34_ = g_strdup (i_collection[i_it]);
			i = _tmp34_;
			{
				const gchar* _tmp35_;
				_tmp35_ = i;
				if (g_strcmp0 (_tmp35_, _data1_->id) != 0) {
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp36_ = i;
					_tmp37_ = g_strdup (_tmp36_);
					_vala_array_add2 (&array2, &array2_length1, &_array2_size_, _tmp37_);
				}
				_g_free0 (i);
			}
		}
	}
	_tmp38_ = feed_reader_settings_share ("instapaper");
	_tmp39_ = _tmp38_;
	_tmp40_ = array2;
	_tmp40__length1 = array2_length1;
	g_settings_set_strv (_tmp39_, "account-ids", _tmp40_);
	_g_object_unref0 (_tmp39_);
	g_signal_emit_by_name ((FeedReaderShareAccountInterface*) self, "delete-account", _data1_->id);
	result = TRUE;
	array2 = (_vala_array_free (array2, array2_length1, (GDestroyNotify) g_free), NULL);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (attributes);
	_secret_schema_unref0 (pwSchema);
	_g_object_unref0 (settings);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static gchar*
feed_reader_insta_api_real_getIconName (FeedReaderShareAccountInterface* base)
{
	FeedReaderInstaAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInstaAPI*) base;
	_tmp0_ = g_strdup ("feed-share-instapaper");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_insta_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                        const gchar* id)
{
	FeedReaderInstaAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (FeedReaderInstaAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/instapaper/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = g_settings_get_string (settings, "username");
	result = _tmp4_;
	_g_object_unref0 (settings);
	return result;
}

static gboolean
feed_reader_insta_api_real_needSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderInstaAPI * self;
	gboolean result;
	self = (FeedReaderInstaAPI*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_insta_api_real_singleInstance (FeedReaderShareAccountInterface* base)
{
	FeedReaderInstaAPI * self;
	gboolean result;
	self = (FeedReaderInstaAPI*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_insta_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base)
{
	FeedReaderInstaAPI * self;
	gboolean result;
	self = (FeedReaderInstaAPI*) base;
	result = FALSE;
	return result;
}

static gchar*
feed_reader_insta_api_real_pluginID (FeedReaderShareAccountInterface* base)
{
	FeedReaderInstaAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInstaAPI*) base;
	_tmp0_ = g_strdup ("instapaper");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_insta_api_real_pluginName (FeedReaderShareAccountInterface* base)
{
	FeedReaderInstaAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderInstaAPI*) base;
	_tmp0_ = g_strdup ("Instapaper");
	result = _tmp0_;
	return result;
}

gchar*
feed_reader_insta_api_getURL (FeedReaderInstaAPI* self,
                              const gchar* token)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (token != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_insta_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                            const gchar* id,
                                            const gchar* username)
{
	FeedReaderInstaAPI * self;
	FeedReaderInstapaperSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderInstaAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = feed_reader_instapaper_setup_new (id, self, username);
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_insta_api_real_newSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderInstaAPI * self;
	FeedReaderInstapaperSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderInstaAPI*) base;
	_tmp0_ = feed_reader_instapaper_setup_new (NULL, self, "");
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_insta_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                             const gchar* id,
                                             const gchar* username)
{
	FeedReaderInstaAPI * self;
	FeedReaderServiceSetup* result;
	self = (FeedReaderInstaAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	result = NULL;
	return result;
}

static FeedReaderShareForm*
feed_reader_insta_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                        const gchar* url)
{
	FeedReaderInstaAPI * self;
	FeedReaderShareForm* result;
	self = (FeedReaderInstaAPI*) base;
	g_return_val_if_fail (url != NULL, NULL);
	result = NULL;
	return result;
}

static void
feed_reader_insta_api_class_init (FeedReaderInstaAPIClass * klass,
                                  gpointer klass_data)
{
	feed_reader_insta_api_parent_class = g_type_class_peek_parent (klass);
}

static void
feed_reader_insta_api_feed_reader_share_account_interface_interface_init (FeedReaderShareAccountInterfaceIface * iface,
                                                                          gpointer iface_data)
{
	feed_reader_insta_api_feed_reader_share_account_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->setupSystemAccounts = (void (*) (FeedReaderShareAccountInterface*, GeeList*)) feed_reader_insta_api_real_setupSystemAccounts;
	iface->addBookmark = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*, gboolean)) feed_reader_insta_api_real_addBookmark;
	iface->logout = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_insta_api_real_logout;
	iface->getIconName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_insta_api_real_getIconName;
	iface->getUsername = (gchar* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_insta_api_real_getUsername;
	iface->needSetup = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_insta_api_real_needSetup;
	iface->singleInstance = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_insta_api_real_singleInstance;
	iface->useSystemAccounts = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_insta_api_real_useSystemAccounts;
	iface->pluginID = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_insta_api_real_pluginID;
	iface->pluginName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_insta_api_real_pluginName;
	iface->newSetup_withID = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_insta_api_real_newSetup_withID;
	iface->newSetup = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*)) feed_reader_insta_api_real_newSetup;
	iface->newSystemAccount = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_insta_api_real_newSystemAccount;
	iface->shareWidget = (FeedReaderShareForm* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_insta_api_real_shareWidget;
}

static void
feed_reader_insta_api_instance_init (FeedReaderInstaAPI * self,
                                     gpointer klass)
{
}

GType
feed_reader_insta_api_get_type (void)
{
	return feed_reader_insta_api_type_id;
}

GType
feed_reader_insta_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderInstaAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_insta_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderInstaAPI), 0, (GInstanceInitFunc) feed_reader_insta_api_instance_init, NULL };
	static const GInterfaceInfo feed_reader_share_account_interface_info = { (GInterfaceInitFunc) feed_reader_insta_api_feed_reader_share_account_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	feed_reader_insta_api_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "FeedReaderInstaAPI", &g_define_type_info, 0);
	g_type_module_add_interface (module, feed_reader_insta_api_type_id, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, &feed_reader_share_account_interface_info);
	return feed_reader_insta_api_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_insta_api_register_type (module);
	feed_reader_instapaper_setup_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, FEED_READER_TYPE_INSTA_API);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

