/* PocketAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from PocketAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "pocket.h"
#include <glib-object.h>
#include <gee.h>
#include "FeedReader.h"
#include <goa/goa.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libpeas/peas.h>

#define FEED_READER_POCKET_SECRETS_base_uri "https://getpocket.com/v3/"
#define FEED_READER_POCKET_SECRETS_oauth_consumer_key "43273-30a11c29b5eeabfa905df168"
#define FEED_READER_POCKET_SECRETS_oauth_callback "feedreader://pocket"

enum  {
	FEED_READER_POCKET_API_0_PROPERTY,
	FEED_READER_POCKET_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_pocket_api_properties[FEED_READER_POCKET_API_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))

static gpointer feed_reader_pocket_api_parent_class = NULL;
static FeedReaderShareAccountInterfaceIface * feed_reader_pocket_api_feed_reader_share_account_interface_parent_iface = NULL;
static GType feed_reader_pocket_api_type_id = 0;

static void feed_reader_pocket_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                      GeeList* accounts);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean feed_reader_pocket_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                                  const gchar* id,
                                                  const gchar* url,
                                                  gboolean system);
static gboolean feed_reader_pocket_api_real_logout (FeedReaderShareAccountInterface* base,
                                             const gchar* id);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* feed_reader_pocket_api_real_getIconName (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_pocket_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                                const gchar* id);
static gboolean feed_reader_pocket_api_real_needSetup (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_pocket_api_real_singleInstance (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_pocket_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_pocket_api_real_pluginID (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_pocket_api_real_pluginName (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_pocket_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                                                     const gchar* id,
                                                                     const gchar* username);
static FeedReaderServiceSetup* feed_reader_pocket_api_real_newSetup (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_pocket_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                                                      const gchar* id,
                                                                      const gchar* username);
static FeedReaderShareForm* feed_reader_pocket_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                                              const gchar* url);
GType feed_reader_pocket_setup_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

FeedReaderPocketAPI*
feed_reader_pocket_api_construct (GType object_type)
{
	FeedReaderPocketAPI * self = NULL;
	self = (FeedReaderPocketAPI*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderPocketAPI*
feed_reader_pocket_api_new (void)
{
	return feed_reader_pocket_api_construct (FEED_READER_TYPE_POCKET_API);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
feed_reader_pocket_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                 GeeList* accounts)
{
	FeedReaderPocketAPI * self;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderPocketAPI*) base;
	g_return_if_fail (accounts != NULL);
	{
		GoaClient* client = NULL;
		GoaClient* _tmp0_;
		_tmp0_ = goa_client_new_sync (NULL, &_inner_error0_);
		client = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (client != NULL) {
			GList* goaAccounts = NULL;
			GList* _tmp1_;
			GList* _tmp2_;
			_tmp1_ = goa_client_get_accounts (client);
			goaAccounts = _tmp1_;
			_tmp2_ = goaAccounts;
			{
				GList* object_collection = NULL;
				GList* object_it = NULL;
				object_collection = _tmp2_;
				for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
					GoaObject* _tmp3_;
					GoaObject* object = NULL;
					_tmp3_ = _g_object_ref0 ((GoaObject*) object_it->data);
					object = _tmp3_;
					{
						gboolean _tmp4_ = FALSE;
						GoaObject* _tmp5_;
						GoaAccount* _tmp6_;
						GoaAccount* _tmp7_;
						GoaAccount* _tmp8_;
						gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						gboolean _tmp12_;
						_tmp5_ = object;
						g_object_get (_tmp5_, "account", &_tmp6_, NULL);
						_tmp7_ = _tmp6_;
						_tmp8_ = _tmp7_;
						g_object_get (_tmp8_, "provider-type", &_tmp9_, NULL);
						_tmp10_ = _tmp9_;
						_tmp11_ = _tmp10_;
						_tmp12_ = g_strcmp0 (_tmp11_, "pocket") == 0;
						_g_free0 (_tmp11_);
						_g_object_unref0 (_tmp8_);
						if (_tmp12_) {
							GoaObject* _tmp13_;
							GoaAccount* _tmp14_;
							GoaAccount* _tmp15_;
							GoaAccount* _tmp16_;
							gboolean _tmp17_;
							gboolean _tmp18_;
							_tmp13_ = object;
							g_object_get (_tmp13_, "account", &_tmp14_, NULL);
							_tmp15_ = _tmp14_;
							_tmp16_ = _tmp15_;
							g_object_get (_tmp16_, "read-later-disabled", &_tmp17_, NULL);
							_tmp18_ = _tmp17_;
							_tmp4_ = !_tmp18_;
							_g_object_unref0 (_tmp16_);
						} else {
							_tmp4_ = FALSE;
						}
						if (_tmp4_) {
							GoaObject* _tmp19_;
							GoaAccount* _tmp20_;
							GoaAccount* _tmp21_;
							GoaAccount* _tmp22_;
							gchar* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							GoaObject* _tmp28_;
							GoaAccount* _tmp29_;
							GoaAccount* _tmp30_;
							GoaAccount* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							FeedReaderShareAccount* _tmp39_;
							FeedReaderShareAccount* _tmp40_;
							_tmp19_ = object;
							g_object_get (_tmp19_, "account", &_tmp20_, NULL);
							_tmp21_ = _tmp20_;
							_tmp22_ = _tmp21_;
							g_object_get (_tmp22_, "id", &_tmp23_, NULL);
							_tmp24_ = _tmp23_;
							_tmp25_ = _tmp24_;
							_tmp26_ = feed_reader_share_account_interface_pluginID ((FeedReaderShareAccountInterface*) self);
							_tmp27_ = _tmp26_;
							_tmp28_ = object;
							g_object_get (_tmp28_, "account", &_tmp29_, NULL);
							_tmp30_ = _tmp29_;
							_tmp31_ = _tmp30_;
							g_object_get (_tmp31_, "identity", &_tmp32_, NULL);
							_tmp33_ = _tmp32_;
							_tmp34_ = _tmp33_;
							_tmp35_ = feed_reader_share_account_interface_getIconName ((FeedReaderShareAccountInterface*) self);
							_tmp36_ = _tmp35_;
							_tmp37_ = feed_reader_share_account_interface_pluginName ((FeedReaderShareAccountInterface*) self);
							_tmp38_ = _tmp37_;
							_tmp39_ = feed_reader_share_account_new (_tmp25_, _tmp27_, _tmp34_, _tmp36_, _tmp38_, TRUE);
							_tmp40_ = _tmp39_;
							gee_collection_add ((GeeCollection*) accounts, _tmp40_);
							_g_object_unref0 (_tmp40_);
							_g_free0 (_tmp38_);
							_g_free0 (_tmp36_);
							_g_free0 (_tmp34_);
							_g_object_unref0 (_tmp31_);
							_g_free0 (_tmp27_);
							_g_free0 (_tmp25_);
							_g_object_unref0 (_tmp22_);
						}
						_g_object_unref0 (object);
					}
				}
			}
			(goaAccounts == NULL) ? NULL : (goaAccounts = (_g_list_free__g_object_unref0_ (goaAccounts), NULL));
		} else {
			feed_reader_logger_error ("PocketAPI: goa not available");
		}
		_g_object_unref0 (client);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		_tmp43_ = g_strdup_printf ("PocketAPI.setupSystemAccounts: %s", _tmp42_);
		_tmp44_ = _tmp43_;
		feed_reader_logger_error (_tmp44_);
		_g_free0 (_tmp44_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
feed_reader_pocket_api_getRequestToken (FeedReaderPocketAPI* self)
{
	SoupSession* session = NULL;
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	gchar* message = NULL;
	gchar* _tmp2_;
	SoupMessage* message_soup = NULL;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	const gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	gboolean _tmp11_;
	SoupSession* _tmp14_;
	SoupMessage* _tmp15_;
	gchar* response = NULL;
	SoupMessage* _tmp16_;
	SoupMessageBody* _tmp17_;
	SoupBuffer* _tmp18_;
	SoupBuffer* _tmp19_;
	guint8* _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	feed_reader_logger_debug ("PocketAPI: get request token");
	_tmp0_ = soup_session_new ();
	session = _tmp0_;
	_tmp1_ = session;
	g_object_set (_tmp1_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp2_ = g_strdup ("consumer_key=" FEED_READER_POCKET_SECRETS_oauth_consumer_key "&redirect_uri=" FEED_READER_POCKET_SECRETS_oauth_callback);
	message = _tmp2_;
	_tmp3_ = soup_message_new ("POST", "https://getpocket.com/v3/oauth/request");
	message_soup = _tmp3_;
	_tmp4_ = message_soup;
	_tmp5_ = message;
	_tmp6_ = string_get_data (_tmp5_, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	soup_message_set_request (_tmp4_, "application/x-www-form-urlencoded; charset=UTF8", SOUP_MEMORY_COPY, _tmp8_, (gsize) _tmp8__length1);
	_tmp9_ = feed_reader_settings_tweaks ();
	_tmp10_ = _tmp9_;
	_tmp11_ = g_settings_get_boolean (_tmp10_, "do-not-track");
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		SoupMessage* _tmp12_;
		SoupMessageHeaders* _tmp13_;
		_tmp12_ = message_soup;
		_tmp13_ = _tmp12_->request_headers;
		soup_message_headers_append (_tmp13_, "DNT", "1");
	}
	_tmp14_ = session;
	_tmp15_ = message_soup;
	soup_session_send_message (_tmp14_, _tmp15_);
	_tmp16_ = message_soup;
	_tmp17_ = _tmp16_->response_body;
	_tmp18_ = soup_message_body_flatten (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->data;
	_tmp20__length1 = _tmp19_->length;
	_tmp21_ = g_strdup ((const gchar*) _tmp20_);
	_tmp22_ = _tmp21_;
	__vala_SoupBuffer_free0 (_tmp19_);
	response = _tmp22_;
	_tmp23_ = string_substring (response, (glong) (string_index_of_char (response, (gunichar) '=', 0) + 1), (glong) -1);
	result = _tmp23_;
	_g_free0 (response);
	_g_object_unref0 (message_soup);
	_g_free0 (message);
	_g_object_unref0 (session);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gboolean
feed_reader_pocket_api_getAccessToken (FeedReaderPocketAPI* self,
                                       const gchar* id,
                                       const gchar* requestToken)
{
	SoupSession* session = NULL;
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	gchar* message = NULL;
	gchar* _tmp2_;
	SoupMessage* message_soup = NULL;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	const gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	gboolean _tmp11_;
	SoupSession* _tmp14_;
	SoupMessage* _tmp15_;
	gboolean _tmp16_ = FALSE;
	SoupMessage* _tmp17_;
	SoupMessageBody* _tmp18_;
	SoupBuffer* _tmp19_;
	SoupBuffer* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gboolean _tmp22_;
	gchar* response = NULL;
	SoupMessage* _tmp28_;
	SoupMessageBody* _tmp29_;
	SoupBuffer* _tmp30_;
	SoupBuffer* _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gint tokenStart = 0;
	const gchar* _tmp36_;
	gint tokenEnd = 0;
	const gchar* _tmp37_;
	gint userStart = 0;
	const gchar* _tmp38_;
	gchar* accessToken = NULL;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* user = NULL;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GSettings* settings = NULL;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GSettings* _tmp48_;
	GSettings* _tmp49_;
	GSettings* _tmp50_;
	const gchar* _tmp51_;
	GSettings* _tmp52_;
	const gchar* _tmp53_;
	gchar** array = NULL;
	GSettings* _tmp54_;
	GSettings* _tmp55_;
	gchar** _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp59_;
	GSettings* _tmp60_;
	GSettings* _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (requestToken != NULL, FALSE);
	_tmp0_ = soup_session_new ();
	session = _tmp0_;
	_tmp1_ = session;
	g_object_set (_tmp1_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp2_ = g_strconcat ("consumer_key=" FEED_READER_POCKET_SECRETS_oauth_consumer_key "&code=", requestToken, NULL);
	message = _tmp2_;
	_tmp3_ = soup_message_new ("POST", "https://getpocket.com/v3/oauth/authorize");
	message_soup = _tmp3_;
	_tmp4_ = message_soup;
	_tmp5_ = message;
	_tmp6_ = string_get_data (_tmp5_, &_tmp7_);
	_tmp6__length1 = _tmp7_;
	_tmp8_ = _tmp6_;
	_tmp8__length1 = _tmp6__length1;
	soup_message_set_request (_tmp4_, "application/x-www-form-urlencoded; charset=UTF8", SOUP_MEMORY_COPY, _tmp8_, (gsize) _tmp8__length1);
	_tmp9_ = feed_reader_settings_tweaks ();
	_tmp10_ = _tmp9_;
	_tmp11_ = g_settings_get_boolean (_tmp10_, "do-not-track");
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		SoupMessage* _tmp12_;
		SoupMessageHeaders* _tmp13_;
		_tmp12_ = message_soup;
		_tmp13_ = _tmp12_->request_headers;
		soup_message_headers_append (_tmp13_, "DNT", "1");
	}
	_tmp14_ = session;
	_tmp15_ = message_soup;
	soup_session_send_message (_tmp14_, _tmp15_);
	_tmp17_ = message_soup;
	_tmp18_ = _tmp17_->response_body;
	_tmp19_ = soup_message_body_flatten (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_->data;
	_tmp21__length1 = _tmp20_->length;
	_tmp22_ = ((const gchar*) _tmp21_) == NULL;
	__vala_SoupBuffer_free0 (_tmp20_);
	if (_tmp22_) {
		_tmp16_ = TRUE;
	} else {
		SoupMessage* _tmp23_;
		SoupMessageBody* _tmp24_;
		SoupBuffer* _tmp25_;
		SoupBuffer* _tmp26_;
		guint8* _tmp27_;
		gint _tmp27__length1;
		_tmp23_ = message_soup;
		_tmp24_ = _tmp23_->response_body;
		_tmp25_ = soup_message_body_flatten (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_->data;
		_tmp27__length1 = _tmp26_->length;
		_tmp16_ = g_strcmp0 ((const gchar*) _tmp27_, "") == 0;
		__vala_SoupBuffer_free0 (_tmp26_);
	}
	if (_tmp16_) {
		result = FALSE;
		_g_object_unref0 (message_soup);
		_g_free0 (message);
		_g_object_unref0 (session);
		return result;
	}
	_tmp28_ = message_soup;
	_tmp29_ = _tmp28_->response_body;
	_tmp30_ = soup_message_body_flatten (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_->data;
	_tmp32__length1 = _tmp31_->length;
	_tmp33_ = g_strdup ((const gchar*) _tmp32_);
	_tmp34_ = _tmp33_;
	__vala_SoupBuffer_free0 (_tmp31_);
	response = _tmp34_;
	_tmp35_ = response;
	feed_reader_logger_debug (_tmp35_);
	_tmp36_ = response;
	tokenStart = string_index_of_char (_tmp36_, (gunichar) '=', 0) + 1;
	_tmp37_ = response;
	tokenEnd = string_index_of_char (_tmp37_, (gunichar) '&', tokenStart);
	_tmp38_ = response;
	userStart = string_index_of_char (_tmp38_, (gunichar) '=', tokenEnd) + 1;
	_tmp39_ = response;
	_tmp40_ = string_substring (_tmp39_, (glong) tokenStart, (glong) (tokenEnd - tokenStart));
	accessToken = _tmp40_;
	_tmp41_ = response;
	_tmp42_ = string_substring (_tmp41_, (glong) userStart, (glong) -1);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_uri_unescape_string (_tmp43_, NULL);
	_tmp45_ = _tmp44_;
	_g_free0 (_tmp43_);
	user = _tmp45_;
	_tmp46_ = g_strdup_printf ("/org/gnome/feedreader/share/pocket/%s/", id);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp47_);
	_tmp49_ = _tmp48_;
	_g_free0 (_tmp47_);
	settings = _tmp49_;
	_tmp50_ = settings;
	_tmp51_ = accessToken;
	g_settings_set_string (_tmp50_, "oauth-access-token", _tmp51_);
	_tmp52_ = settings;
	_tmp53_ = user;
	g_settings_set_string (_tmp52_, "username", _tmp53_);
	_tmp54_ = feed_reader_settings_share ("pocket");
	_tmp55_ = _tmp54_;
	_tmp57_ = _tmp56_ = g_settings_get_strv (_tmp55_, "account-ids");
	_tmp58_ = _tmp57_;
	_tmp58__length1 = _vala_array_length (_tmp56_);
	_g_object_unref0 (_tmp55_);
	array = _tmp58_;
	array_length1 = _tmp58__length1;
	_array_size_ = array_length1;
	_tmp59_ = g_strdup (id);
	_vala_array_add1 (&array, &array_length1, &_array_size_, _tmp59_);
	_tmp60_ = feed_reader_settings_share ("pocket");
	_tmp61_ = _tmp60_;
	_tmp62_ = array;
	_tmp62__length1 = array_length1;
	g_settings_set_strv (_tmp61_, "account-ids", _tmp62_);
	_g_object_unref0 (_tmp61_);
	result = TRUE;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	_g_free0 (user);
	_g_free0 (accessToken);
	_g_free0 (response);
	_g_object_unref0 (message_soup);
	_g_free0 (message);
	_g_object_unref0 (session);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
feed_reader_pocket_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                         const gchar* id,
                                         const gchar* url,
                                         gboolean system)
{
	FeedReaderPocketAPI * self;
	gchar* oauthToken = NULL;
	gchar* _tmp0_;
	SoupSession* session = NULL;
	SoupSession* _tmp43_;
	SoupSession* _tmp44_;
	gchar* message = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	SoupMessage* message_soup = NULL;
	SoupMessage* _tmp61_;
	SoupMessage* _tmp62_;
	const gchar* _tmp63_;
	guint8* _tmp64_;
	gint _tmp64__length1;
	gint _tmp65_ = 0;
	guint8* _tmp66_;
	gint _tmp66__length1;
	GSettings* _tmp67_;
	GSettings* _tmp68_;
	gboolean _tmp69_;
	SoupSession* _tmp72_;
	SoupMessage* _tmp73_;
	gboolean _tmp74_ = FALSE;
	SoupMessage* _tmp75_;
	SoupMessageBody* _tmp76_;
	SoupBuffer* _tmp77_;
	SoupBuffer* _tmp78_;
	guint8* _tmp79_;
	gint _tmp79__length1;
	gboolean _tmp80_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (FeedReaderPocketAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	oauthToken = _tmp0_;
	if (system) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = string_to_string (id);
		_tmp2_ = g_strconcat ("PocketAPI.addBookmark: ", _tmp1_, " is system account", NULL);
		_tmp3_ = _tmp2_;
		feed_reader_logger_debug (_tmp3_);
		_g_free0 (_tmp3_);
		{
			GoaClient* client = NULL;
			GoaClient* _tmp4_;
			GoaClient* _tmp5_;
			_tmp4_ = goa_client_new_sync (NULL, &_inner_error0_);
			client = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = client;
			if (_tmp5_ != NULL) {
				GList* accounts = NULL;
				GoaClient* _tmp6_;
				GList* _tmp7_;
				GList* _tmp8_;
				_tmp6_ = client;
				_tmp7_ = goa_client_get_accounts (_tmp6_);
				accounts = _tmp7_;
				_tmp8_ = accounts;
				{
					GList* object_collection = NULL;
					GList* object_it = NULL;
					object_collection = _tmp8_;
					for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
						GoaObject* _tmp9_;
						GoaObject* object = NULL;
						_tmp9_ = _g_object_ref0 ((GoaObject*) object_it->data);
						object = _tmp9_;
						{
							gboolean _tmp10_ = FALSE;
							GoaObject* _tmp11_;
							GoaAccount* _tmp12_;
							GoaAccount* _tmp13_;
							GoaAccount* _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							gboolean _tmp18_;
							_tmp11_ = object;
							g_object_get (_tmp11_, "account", &_tmp12_, NULL);
							_tmp13_ = _tmp12_;
							_tmp14_ = _tmp13_;
							g_object_get (_tmp14_, "provider-type", &_tmp15_, NULL);
							_tmp16_ = _tmp15_;
							_tmp17_ = _tmp16_;
							_tmp18_ = g_strcmp0 (_tmp17_, "pocket") == 0;
							_g_free0 (_tmp17_);
							_g_object_unref0 (_tmp14_);
							if (_tmp18_) {
								GoaObject* _tmp19_;
								GoaAccount* _tmp20_;
								GoaAccount* _tmp21_;
								GoaAccount* _tmp22_;
								gchar* _tmp23_;
								gchar* _tmp24_;
								gchar* _tmp25_;
								_tmp19_ = object;
								g_object_get (_tmp19_, "account", &_tmp20_, NULL);
								_tmp21_ = _tmp20_;
								_tmp22_ = _tmp21_;
								g_object_get (_tmp22_, "id", &_tmp23_, NULL);
								_tmp24_ = _tmp23_;
								_tmp25_ = _tmp24_;
								_tmp10_ = g_strcmp0 (_tmp25_, id) == 0;
								_g_free0 (_tmp25_);
								_g_object_unref0 (_tmp22_);
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								gint expires = 0;
								GoaObject* _tmp26_;
								GoaOAuth2Based* _tmp27_;
								GoaOAuth2Based* _tmp28_;
								GoaOAuth2Based* _tmp29_;
								gchar* _tmp30_ = NULL;
								gint _tmp31_ = 0;
								expires = -1;
								_tmp26_ = object;
								g_object_get (_tmp26_, "oauth2-based", &_tmp27_, NULL);
								_tmp28_ = _tmp27_;
								_tmp29_ = _tmp28_;
								goa_oauth2_based_call_get_access_token_sync (_tmp29_, &_tmp30_, &_tmp31_, NULL, &_inner_error0_);
								_g_free0 (oauthToken);
								oauthToken = _tmp30_;
								expires = _tmp31_;
								_g_object_unref0 (_tmp29_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_object_unref0 (object);
									(accounts == NULL) ? NULL : (accounts = (_g_list_free__g_object_unref0_ (accounts), NULL));
									_g_object_unref0 (client);
									goto __catch0_g_error;
								}
								_g_object_unref0 (object);
								break;
							}
							_g_object_unref0 (object);
						}
					}
				}
				(accounts == NULL) ? NULL : (accounts = (_g_list_free__g_object_unref0_ (accounts), NULL));
			} else {
				feed_reader_logger_error ("PocketAPI: goa not available");
			}
			_g_object_unref0 (client);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			_tmp34_ = g_strdup_printf ("PocketAPI GOA: %s", _tmp33_);
			_tmp35_ = _tmp34_;
			feed_reader_logger_error (_tmp35_);
			_g_free0 (_tmp35_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp36_ = FALSE;
			_g_free0 (oauthToken);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp36_;
		}
	} else {
		GSettings* settings = NULL;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GSettings* _tmp39_;
		GSettings* _tmp40_;
		GSettings* _tmp41_;
		gchar* _tmp42_;
		_tmp37_ = g_strdup_printf ("/org/gnome/feedreader/share/pocket/%s/", id);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp38_);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		settings = _tmp40_;
		_tmp41_ = settings;
		_tmp42_ = g_settings_get_string (_tmp41_, "oauth-access-token");
		_g_free0 (oauthToken);
		oauthToken = _tmp42_;
		_g_object_unref0 (settings);
	}
	_tmp43_ = soup_session_new ();
	session = _tmp43_;
	_tmp44_ = session;
	g_object_set (_tmp44_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp45_ = g_uri_escape_string (url, NULL, TRUE);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strconcat ("url=", _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_strconcat (_tmp48_, "&consumer_key=", NULL);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strconcat (_tmp50_, FEED_READER_POCKET_SECRETS_oauth_consumer_key, NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strconcat (_tmp52_, "&access_token=", NULL);
	_tmp54_ = _tmp53_;
	_tmp55_ = oauthToken;
	_tmp56_ = g_strconcat (_tmp54_, _tmp55_, NULL);
	_tmp57_ = _tmp56_;
	_g_free0 (_tmp54_);
	_g_free0 (_tmp52_);
	_g_free0 (_tmp50_);
	_g_free0 (_tmp48_);
	_g_free0 (_tmp46_);
	message = _tmp57_;
	_tmp58_ = message;
	_tmp59_ = g_strconcat ("PocketAPI: ", _tmp58_, NULL);
	_tmp60_ = _tmp59_;
	feed_reader_logger_debug (_tmp60_);
	_g_free0 (_tmp60_);
	_tmp61_ = soup_message_new ("POST", "https://getpocket.com/v3/add");
	message_soup = _tmp61_;
	_tmp62_ = message_soup;
	_tmp63_ = message;
	_tmp64_ = string_get_data (_tmp63_, &_tmp65_);
	_tmp64__length1 = _tmp65_;
	_tmp66_ = _tmp64_;
	_tmp66__length1 = _tmp64__length1;
	soup_message_set_request (_tmp62_, "application/x-www-form-urlencoded; charset=UTF8", SOUP_MEMORY_COPY, _tmp66_, (gsize) _tmp66__length1);
	_tmp67_ = feed_reader_settings_tweaks ();
	_tmp68_ = _tmp67_;
	_tmp69_ = g_settings_get_boolean (_tmp68_, "do-not-track");
	_g_object_unref0 (_tmp68_);
	if (_tmp69_) {
		SoupMessage* _tmp70_;
		SoupMessageHeaders* _tmp71_;
		_tmp70_ = message_soup;
		_tmp71_ = _tmp70_->request_headers;
		soup_message_headers_append (_tmp71_, "DNT", "1");
	}
	_tmp72_ = session;
	_tmp73_ = message_soup;
	soup_session_send_message (_tmp72_, _tmp73_);
	_tmp75_ = message_soup;
	_tmp76_ = _tmp75_->response_body;
	_tmp77_ = soup_message_body_flatten (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = _tmp78_->data;
	_tmp79__length1 = _tmp78_->length;
	_tmp80_ = ((const gchar*) _tmp79_) == NULL;
	__vala_SoupBuffer_free0 (_tmp78_);
	if (_tmp80_) {
		_tmp74_ = TRUE;
	} else {
		SoupMessage* _tmp81_;
		SoupMessageBody* _tmp82_;
		SoupBuffer* _tmp83_;
		SoupBuffer* _tmp84_;
		guint8* _tmp85_;
		gint _tmp85__length1;
		_tmp81_ = message_soup;
		_tmp82_ = _tmp81_->response_body;
		_tmp83_ = soup_message_body_flatten (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = _tmp84_->data;
		_tmp85__length1 = _tmp84_->length;
		_tmp74_ = g_strcmp0 ((const gchar*) _tmp85_, "") == 0;
		__vala_SoupBuffer_free0 (_tmp84_);
	}
	if (_tmp74_) {
		result = FALSE;
		_g_object_unref0 (message_soup);
		_g_free0 (message);
		_g_object_unref0 (session);
		_g_free0 (oauthToken);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (message_soup);
	_g_free0 (message);
	_g_object_unref0 (session);
	_g_free0 (oauthToken);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
feed_reader_pocket_api_real_logout (FeedReaderShareAccountInterface* base,
                                    const gchar* id)
{
	FeedReaderPocketAPI * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GSettings* settings = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	gchar** keys = NULL;
	GSettings* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** array = NULL;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gint array_length1;
	gint _array_size_;
	gchar** array2 = NULL;
	gchar** _tmp19_;
	gint array2_length1;
	gint _array2_size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GSettings* _tmp25_;
	GSettings* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gboolean result;
	self = (FeedReaderPocketAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = string_to_string (id);
	_tmp1_ = g_strconcat ("PocketAPI: logout(", _tmp0_, ")", NULL);
	_tmp2_ = _tmp1_;
	feed_reader_logger_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_strdup_printf ("/org/gnome/feedreader/share/pocket/%s/", id);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	settings = _tmp6_;
	_tmp7_ = settings;
	_tmp9_ = _tmp8_ = g_settings_list_keys (_tmp7_);
	keys = _tmp9_;
	keys_length1 = _vala_array_length (_tmp8_);
	_keys_size_ = keys_length1;
	_tmp10_ = keys;
	_tmp10__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp10_;
		key_collection_length1 = _tmp10__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp11_;
			gchar* key = NULL;
			_tmp11_ = g_strdup (key_collection[key_it]);
			key = _tmp11_;
			{
				GSettings* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = settings;
				_tmp13_ = key;
				g_settings_reset (_tmp12_, _tmp13_);
				_g_free0 (key);
			}
		}
	}
	_tmp14_ = feed_reader_settings_share ("pocket");
	_tmp15_ = _tmp14_;
	_tmp17_ = _tmp16_ = g_settings_get_strv (_tmp15_, "account-ids");
	_tmp18_ = _tmp17_;
	_tmp18__length1 = _vala_array_length (_tmp16_);
	_g_object_unref0 (_tmp15_);
	array = _tmp18_;
	array_length1 = _tmp18__length1;
	_array_size_ = array_length1;
	_tmp19_ = g_new0 (gchar*, 0 + 1);
	array2 = _tmp19_;
	array2_length1 = 0;
	_array2_size_ = array2_length1;
	_tmp20_ = array;
	_tmp20__length1 = array_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp20_;
		i_collection_length1 = _tmp20__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			gchar* _tmp21_;
			gchar* i = NULL;
			_tmp21_ = g_strdup (i_collection[i_it]);
			i = _tmp21_;
			{
				const gchar* _tmp22_;
				_tmp22_ = i;
				if (g_strcmp0 (_tmp22_, id) != 0) {
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp23_ = i;
					_tmp24_ = g_strdup (_tmp23_);
					_vala_array_add2 (&array2, &array2_length1, &_array2_size_, _tmp24_);
				}
				_g_free0 (i);
			}
		}
	}
	_tmp25_ = feed_reader_settings_share ("pocket");
	_tmp26_ = _tmp25_;
	_tmp27_ = array2;
	_tmp27__length1 = array2_length1;
	g_settings_set_strv (_tmp26_, "account-ids", _tmp27_);
	_g_object_unref0 (_tmp26_);
	g_signal_emit_by_name ((FeedReaderShareAccountInterface*) self, "delete-account", id);
	result = TRUE;
	array2 = (_vala_array_free (array2, array2_length1, (GDestroyNotify) g_free), NULL);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return result;
}

gchar*
feed_reader_pocket_api_getURL (FeedReaderPocketAPI* self,
                               const gchar* token)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (token != NULL, NULL);
	_tmp0_ = g_strconcat ("https://getpocket.com/auth/authorize?request_token=", token, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "&redirect_uri=", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_uri_escape_string (FEED_READER_POCKET_SECRETS_oauth_callback, NULL, TRUE);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

static gchar*
feed_reader_pocket_api_real_getIconName (FeedReaderShareAccountInterface* base)
{
	FeedReaderPocketAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderPocketAPI*) base;
	_tmp0_ = g_strdup ("feed-share-pocket");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_pocket_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                         const gchar* id)
{
	FeedReaderPocketAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (FeedReaderPocketAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/pocket/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = g_settings_get_string (settings, "username");
	result = _tmp4_;
	_g_object_unref0 (settings);
	return result;
}

static gboolean
feed_reader_pocket_api_real_needSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderPocketAPI * self;
	gboolean result;
	self = (FeedReaderPocketAPI*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_pocket_api_real_singleInstance (FeedReaderShareAccountInterface* base)
{
	FeedReaderPocketAPI * self;
	gboolean result;
	self = (FeedReaderPocketAPI*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_pocket_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base)
{
	FeedReaderPocketAPI * self;
	gboolean result;
	self = (FeedReaderPocketAPI*) base;
	result = FALSE;
	return result;
}

static gchar*
feed_reader_pocket_api_real_pluginID (FeedReaderShareAccountInterface* base)
{
	FeedReaderPocketAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderPocketAPI*) base;
	_tmp0_ = g_strdup ("pocket");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_pocket_api_real_pluginName (FeedReaderShareAccountInterface* base)
{
	FeedReaderPocketAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderPocketAPI*) base;
	_tmp0_ = g_strdup ("Pocket");
	result = _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_pocket_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                             const gchar* id,
                                             const gchar* username)
{
	FeedReaderPocketAPI * self;
	FeedReaderPocketSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderPocketAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = feed_reader_pocket_setup_new (id, self, username, FALSE);
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_pocket_api_real_newSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderPocketAPI * self;
	FeedReaderPocketSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderPocketAPI*) base;
	_tmp0_ = feed_reader_pocket_setup_new (NULL, self, "", FALSE);
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_pocket_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                              const gchar* id,
                                              const gchar* username)
{
	FeedReaderPocketAPI * self;
	FeedReaderPocketSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderPocketAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = feed_reader_pocket_setup_new (id, self, username, TRUE);
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderShareForm*
feed_reader_pocket_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                         const gchar* url)
{
	FeedReaderPocketAPI * self;
	FeedReaderShareForm* result;
	self = (FeedReaderPocketAPI*) base;
	g_return_val_if_fail (url != NULL, NULL);
	result = NULL;
	return result;
}

static void
feed_reader_pocket_api_class_init (FeedReaderPocketAPIClass * klass,
                                   gpointer klass_data)
{
	feed_reader_pocket_api_parent_class = g_type_class_peek_parent (klass);
}

static void
feed_reader_pocket_api_feed_reader_share_account_interface_interface_init (FeedReaderShareAccountInterfaceIface * iface,
                                                                           gpointer iface_data)
{
	feed_reader_pocket_api_feed_reader_share_account_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->setupSystemAccounts = (void (*) (FeedReaderShareAccountInterface*, GeeList*)) feed_reader_pocket_api_real_setupSystemAccounts;
	iface->addBookmark = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*, gboolean)) feed_reader_pocket_api_real_addBookmark;
	iface->logout = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_pocket_api_real_logout;
	iface->getIconName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_pocket_api_real_getIconName;
	iface->getUsername = (gchar* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_pocket_api_real_getUsername;
	iface->needSetup = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_pocket_api_real_needSetup;
	iface->singleInstance = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_pocket_api_real_singleInstance;
	iface->useSystemAccounts = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_pocket_api_real_useSystemAccounts;
	iface->pluginID = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_pocket_api_real_pluginID;
	iface->pluginName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_pocket_api_real_pluginName;
	iface->newSetup_withID = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_pocket_api_real_newSetup_withID;
	iface->newSetup = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*)) feed_reader_pocket_api_real_newSetup;
	iface->newSystemAccount = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_pocket_api_real_newSystemAccount;
	iface->shareWidget = (FeedReaderShareForm* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_pocket_api_real_shareWidget;
}

static void
feed_reader_pocket_api_instance_init (FeedReaderPocketAPI * self,
                                      gpointer klass)
{
}

GType
feed_reader_pocket_api_get_type (void)
{
	return feed_reader_pocket_api_type_id;
}

GType
feed_reader_pocket_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderPocketAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_pocket_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderPocketAPI), 0, (GInstanceInitFunc) feed_reader_pocket_api_instance_init, NULL };
	static const GInterfaceInfo feed_reader_share_account_interface_info = { (GInterfaceInitFunc) feed_reader_pocket_api_feed_reader_share_account_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	feed_reader_pocket_api_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "FeedReaderPocketAPI", &g_define_type_info, 0);
	g_type_module_add_interface (module, feed_reader_pocket_api_type_id, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, &feed_reader_share_account_interface_info);
	return feed_reader_pocket_api_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_pocket_api_register_type (module);
	feed_reader_pocket_setup_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, FEED_READER_TYPE_POCKET_API);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

