/* TwitterAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from TwitterAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "twitter.h"
#include <rest/oauth-proxy.h>
#include <glib-object.h>
#include <gee.h>
#include "FeedReader.h"
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <libpeas/peas.h>

#define FEED_READER_TWITTER_SECRETS_base_uri "https://api.twitter.com/"
#define FEED_READER_TWITTER_SECRETS_key "hqScCfRLj5ImAtwypRKhbVpXo"
#define FEED_READER_TWITTER_SECRETS_secret "wydD2zd6mgBUnlrdbqNqS0U0dJCWBJ9X0cqtdErk8Hn7aeperP"
#define FEED_READER_TWITTER_SECRETS_callback "feedreader://twitter"

enum  {
	FEED_READER_TWITTER_API_0_PROPERTY,
	FEED_READER_TWITTER_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_twitter_api_properties[FEED_READER_TWITTER_API_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _FeedReaderTwitterAPIPrivate {
	OAuthProxy* m_oauthObject;
	gchar* m_tweet;
	gint m_urlLength;
};

struct _Block1Data {
	int _ref_count_;
	FeedReaderTwitterAPI* self;
	FeedReaderTwitterForm* widget;
};

static gint FeedReaderTwitterAPI_private_offset;
static gpointer feed_reader_twitter_api_parent_class = NULL;
static FeedReaderShareAccountInterfaceIface * feed_reader_twitter_api_feed_reader_share_account_interface_parent_iface = NULL;
static GType feed_reader_twitter_api_type_id = 0;

static void feed_reader_twitter_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                       GeeList* accounts);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean feed_reader_twitter_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                                   const gchar* id,
                                                   const gchar* url,
                                                   gboolean system);
static gboolean feed_reader_twitter_api_real_logout (FeedReaderShareAccountInterface* base,
                                              const gchar* id);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* feed_reader_twitter_api_real_getIconName (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_twitter_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                                 const gchar* id);
static gboolean feed_reader_twitter_api_real_needSetup (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_twitter_api_real_singleInstance (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_twitter_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_twitter_api_real_pluginID (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_twitter_api_real_pluginName (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_twitter_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                                                      const gchar* id,
                                                                      const gchar* username);
static FeedReaderServiceSetup* feed_reader_twitter_api_real_newSetup (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_twitter_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                                                       const gchar* id,
                                                                       const gchar* username);
static FeedReaderShareForm* feed_reader_twitter_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                                               const gchar* url);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda9_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void __lambda10_ (Block1Data* _data1_);
static void ___lambda10__feed_reader_share_form_share (FeedReaderShareForm* _sender,
                                                gpointer self);
static void feed_reader_twitter_api_finalize (GObject * obj);
GType feed_reader_twitter_form_register_type (GTypeModule * module);
GType feed_reader_twitter_setup_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
feed_reader_twitter_api_get_instance_private (FeedReaderTwitterAPI* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderTwitterAPI_private_offset);
}

FeedReaderTwitterAPI*
feed_reader_twitter_api_construct (GType object_type)
{
	FeedReaderTwitterAPI * self = NULL;
	self = (FeedReaderTwitterAPI*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderTwitterAPI*
feed_reader_twitter_api_new (void)
{
	return feed_reader_twitter_api_construct (FEED_READER_TYPE_TWITTER_API);
}

static void
feed_reader_twitter_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                  GeeList* accounts)
{
	FeedReaderTwitterAPI * self;
	self = (FeedReaderTwitterAPI*) base;
	g_return_if_fail (accounts != NULL);
}

gchar*
feed_reader_twitter_api_getRequestToken (FeedReaderTwitterAPI* self)
{
	OAuthProxy* _tmp0_;
	OAuthProxy* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	feed_reader_logger_debug ("TwitterAPI: get request token");
	_tmp0_ = (OAuthProxy*) oauth_proxy_new (FEED_READER_TWITTER_SECRETS_key, FEED_READER_TWITTER_SECRETS_secret, "https://api.twitter.com/", FALSE);
	_g_object_unref0 (self->priv->m_oauthObject);
	self->priv->m_oauthObject = _tmp0_;
	{
		OAuthProxy* _tmp1_;
		_tmp1_ = self->priv->m_oauthObject;
		oauth_proxy_request_token (_tmp1_, "oauth/request_token", FEED_READER_TWITTER_SECRETS_callback, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = g_strdup_printf ("TwitterAPI.getRequestToken: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		feed_reader_logger_error (_tmp5_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = self->priv->m_oauthObject;
	_tmp7_ = oauth_proxy_get_token (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gboolean
feed_reader_twitter_api_getAccessToken (FeedReaderTwitterAPI* self,
                                        const gchar* id,
                                        const gchar* verifier)
{
	GSettings* settings = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	gchar* token = NULL;
	OAuthProxy* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* secret = NULL;
	OAuthProxy* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	RestProxyCall* call = NULL;
	OAuthProxy* _tmp16_;
	RestProxyCall* _tmp17_;
	JsonParser* parser = NULL;
	JsonParser* _tmp21_;
	JsonObject* root_object = NULL;
	JsonNode* _tmp26_;
	JsonObject* _tmp27_;
	JsonObject* _tmp28_;
	JsonObject* _tmp29_;
	gchar** array = NULL;
	GSettings* _tmp36_;
	GSettings* _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (verifier != NULL, FALSE);
	{
		OAuthProxy* _tmp0_;
		_tmp0_ = self->priv->m_oauthObject;
		oauth_proxy_access_token (_tmp0_, "oauth/access_token", verifier, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_strdup_printf ("TwitterAPI.getAccessToken: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		feed_reader_logger_error (_tmp4_);
		_g_free0 (_tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = g_strdup_printf ("/org/gnome/feedreader/share/twitter/%s/", id);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	settings = _tmp9_;
	_tmp10_ = self->priv->m_oauthObject;
	_tmp11_ = oauth_proxy_get_token (_tmp10_);
	_tmp12_ = g_strdup (_tmp11_);
	token = _tmp12_;
	_tmp13_ = self->priv->m_oauthObject;
	_tmp14_ = oauth_proxy_get_token_secret (_tmp13_);
	_tmp15_ = g_strdup (_tmp14_);
	secret = _tmp15_;
	g_settings_set_string (settings, "oauth-access-token", token);
	g_settings_set_string (settings, "oauth-access-token-secret", secret);
	_tmp16_ = self->priv->m_oauthObject;
	_tmp17_ = rest_proxy_new_call ((RestProxy*) _tmp16_);
	call = _tmp17_;
	rest_proxy_call_set_function (call, "1.1/account/verify_credentials.json");
	rest_proxy_call_set_method (call, "GET");
	rest_proxy_call_add_param (call, "include_entities", "false");
	rest_proxy_call_add_param (call, "skip_status", "true");
	rest_proxy_call_add_param (call, "include_email", "true");
	{
		rest_proxy_call_run (call, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		feed_reader_logger_error (_tmp19_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp20_ = FALSE;
		_g_object_unref0 (call);
		_g_free0 (secret);
		_g_free0 (token);
		_g_object_unref0 (settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp20_;
	}
	_tmp21_ = json_parser_new ();
	parser = _tmp21_;
	{
		const gchar* _tmp22_;
		_tmp22_ = rest_proxy_call_get_payload (call);
		json_parser_load_from_data (parser, _tmp22_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("Could not load response to Message from twitter");
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		feed_reader_logger_error (_tmp24_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp25_ = FALSE;
		_g_object_unref0 (parser);
		_g_object_unref0 (call);
		_g_free0 (secret);
		_g_free0 (token);
		_g_object_unref0 (settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp25_;
	}
	_tmp26_ = json_parser_get_root (parser);
	_tmp27_ = json_node_get_object (_tmp26_);
	_tmp28_ = _json_object_ref0 (_tmp27_);
	root_object = _tmp28_;
	_tmp29_ = root_object;
	if (json_object_has_member (_tmp29_, "screen_name")) {
		gchar* screenName = NULL;
		JsonObject* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp30_ = root_object;
		_tmp31_ = json_object_get_string_member (_tmp30_, "screen_name");
		_tmp32_ = g_strconcat ("@", _tmp31_, NULL);
		screenName = _tmp32_;
		_tmp33_ = screenName;
		g_settings_set_string (settings, "username", _tmp33_);
		_g_free0 (screenName);
	} else {
		JsonObject* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = root_object;
		_tmp35_ = json_object_get_string_member (_tmp34_, "name");
		g_settings_set_string (settings, "username", _tmp35_);
	}
	_tmp36_ = feed_reader_settings_share ("twitter");
	_tmp37_ = _tmp36_;
	_tmp39_ = _tmp38_ = g_settings_get_strv (_tmp37_, "account-ids");
	_tmp40_ = _tmp39_;
	_tmp40__length1 = _vala_array_length (_tmp38_);
	_g_object_unref0 (_tmp37_);
	array = _tmp40_;
	array_length1 = _tmp40__length1;
	_array_size_ = array_length1;
	_tmp41_ = g_strdup (id);
	_vala_array_add1 (&array, &array_length1, &_array_size_, _tmp41_);
	_tmp42_ = feed_reader_settings_share ("twitter");
	_tmp43_ = _tmp42_;
	_tmp44_ = array;
	_tmp44__length1 = array_length1;
	g_settings_set_strv (_tmp43_, "account-ids", _tmp44_);
	_g_object_unref0 (_tmp43_);
	result = TRUE;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	_g_object_unref0 (call);
	_g_free0 (secret);
	_g_free0 (token);
	_g_object_unref0 (settings);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
feed_reader_twitter_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                          const gchar* id,
                                          const gchar* url,
                                          gboolean system)
{
	FeedReaderTwitterAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar* token = NULL;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* secret = NULL;
	GSettings* _tmp6_;
	gchar* _tmp7_;
	OAuthProxy* oauthObject = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	OAuthProxy* _tmp10_;
	RestProxyCall* call = NULL;
	OAuthProxy* _tmp11_;
	RestProxyCall* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	RestProxyCall* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (FeedReaderTwitterAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/twitter/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "oauth-access-token");
	token = _tmp5_;
	_tmp6_ = settings;
	_tmp7_ = g_settings_get_string (_tmp6_, "oauth-access-token-secret");
	secret = _tmp7_;
	_tmp8_ = token;
	_tmp9_ = secret;
	_tmp10_ = (OAuthProxy*) oauth_proxy_new_with_token (FEED_READER_TWITTER_SECRETS_key, FEED_READER_TWITTER_SECRETS_secret, _tmp8_, _tmp9_, "https://api.twitter.com/", FALSE);
	oauthObject = _tmp10_;
	_tmp11_ = oauthObject;
	_tmp12_ = rest_proxy_new_call ((RestProxy*) _tmp11_);
	call = _tmp12_;
	_tmp13_ = call;
	rest_proxy_call_set_function (_tmp13_, "1.1/statuses/update.json");
	_tmp14_ = call;
	rest_proxy_call_set_method (_tmp14_, "POST");
	_tmp15_ = call;
	_tmp16_ = self->priv->m_tweet;
	_tmp17_ = string_replace (_tmp16_, "$URL", url);
	_tmp18_ = _tmp17_;
	rest_proxy_call_add_param (_tmp15_, "status", _tmp18_);
	_g_free0 (_tmp18_);
	{
		RestProxyCall* _tmp19_;
		_tmp19_ = call;
		rest_proxy_call_run (_tmp19_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		feed_reader_logger_error (_tmp21_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (secret);
		_g_free0 (token);
		_g_object_unref0 (settings);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp22_ = FALSE;
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (secret);
		_g_free0 (token);
		_g_object_unref0 (settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp22_;
	}
	result = TRUE;
	_g_object_unref0 (call);
	_g_object_unref0 (oauthObject);
	_g_free0 (secret);
	_g_free0 (token);
	_g_object_unref0 (settings);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
feed_reader_twitter_api_real_logout (FeedReaderShareAccountInterface* base,
                                     const gchar* id)
{
	FeedReaderTwitterAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar** keys = NULL;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** array = NULL;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gint array_length1;
	gint _array_size_;
	gchar** array2 = NULL;
	gchar** _tmp16_;
	gint array2_length1;
	gint _array2_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gboolean result;
	self = (FeedReaderTwitterAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/twitter/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = settings;
	_tmp6_ = _tmp5_ = g_settings_list_keys (_tmp4_);
	keys = _tmp6_;
	keys_length1 = _vala_array_length (_tmp5_);
	_keys_size_ = keys_length1;
	_tmp7_ = keys;
	_tmp7__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp7_;
		key_collection_length1 = _tmp7__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp8_;
			gchar* key = NULL;
			_tmp8_ = g_strdup (key_collection[key_it]);
			key = _tmp8_;
			{
				GSettings* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = settings;
				_tmp10_ = key;
				g_settings_reset (_tmp9_, _tmp10_);
				_g_free0 (key);
			}
		}
	}
	_tmp11_ = feed_reader_settings_share ("twitter");
	_tmp12_ = _tmp11_;
	_tmp14_ = _tmp13_ = g_settings_get_strv (_tmp12_, "account-ids");
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _vala_array_length (_tmp13_);
	_g_object_unref0 (_tmp12_);
	array = _tmp15_;
	array_length1 = _tmp15__length1;
	_array_size_ = array_length1;
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	array2 = _tmp16_;
	array2_length1 = 0;
	_array2_size_ = array2_length1;
	_tmp17_ = array;
	_tmp17__length1 = array_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp17_;
		i_collection_length1 = _tmp17__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			gchar* _tmp18_;
			gchar* i = NULL;
			_tmp18_ = g_strdup (i_collection[i_it]);
			i = _tmp18_;
			{
				const gchar* _tmp19_;
				_tmp19_ = i;
				if (g_strcmp0 (_tmp19_, id) != 0) {
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = i;
					_tmp21_ = g_strdup (_tmp20_);
					_vala_array_add2 (&array2, &array2_length1, &_array2_size_, _tmp21_);
				}
				_g_free0 (i);
			}
		}
	}
	_tmp22_ = feed_reader_settings_share ("twitter");
	_tmp23_ = _tmp22_;
	_tmp24_ = array2;
	_tmp24__length1 = array2_length1;
	g_settings_set_strv (_tmp23_, "account-ids", _tmp24_);
	_g_object_unref0 (_tmp23_);
	g_signal_emit_by_name ((FeedReaderShareAccountInterface*) self, "delete-account", id);
	result = TRUE;
	array2 = (_vala_array_free (array2, array2_length1, (GDestroyNotify) g_free), NULL);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return result;
}

gchar*
feed_reader_twitter_api_getURL (FeedReaderTwitterAPI* self,
                                const gchar* token)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (token != NULL, NULL);
	_tmp0_ = g_strconcat (FEED_READER_TWITTER_SECRETS_base_uri "oauth/authenticate" "?oauth_token=", token, NULL);
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_twitter_api_real_getIconName (FeedReaderShareAccountInterface* base)
{
	FeedReaderTwitterAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderTwitterAPI*) base;
	_tmp0_ = g_strdup ("feed-share-twitter");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_twitter_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                          const gchar* id)
{
	FeedReaderTwitterAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (FeedReaderTwitterAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/twitter/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = g_settings_get_string (settings, "username");
	result = _tmp4_;
	_g_object_unref0 (settings);
	return result;
}

static gboolean
feed_reader_twitter_api_real_needSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderTwitterAPI * self;
	gboolean result;
	self = (FeedReaderTwitterAPI*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_twitter_api_real_singleInstance (FeedReaderShareAccountInterface* base)
{
	FeedReaderTwitterAPI * self;
	gboolean result;
	self = (FeedReaderTwitterAPI*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_twitter_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base)
{
	FeedReaderTwitterAPI * self;
	gboolean result;
	self = (FeedReaderTwitterAPI*) base;
	result = FALSE;
	return result;
}

static gchar*
feed_reader_twitter_api_real_pluginID (FeedReaderShareAccountInterface* base)
{
	FeedReaderTwitterAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderTwitterAPI*) base;
	_tmp0_ = g_strdup ("twitter");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_twitter_api_real_pluginName (FeedReaderShareAccountInterface* base)
{
	FeedReaderTwitterAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderTwitterAPI*) base;
	_tmp0_ = g_strdup ("Twitter");
	result = _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_twitter_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                              const gchar* id,
                                              const gchar* username)
{
	FeedReaderTwitterAPI * self;
	FeedReaderTwitterSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderTwitterAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = feed_reader_twitter_setup_new (id, self, username);
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_twitter_api_real_newSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderTwitterAPI * self;
	FeedReaderTwitterSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderTwitterAPI*) base;
	_tmp0_ = feed_reader_twitter_setup_new (NULL, self, "");
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_twitter_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                               const gchar* id,
                                               const gchar* username)
{
	FeedReaderTwitterAPI * self;
	FeedReaderServiceSetup* result;
	self = (FeedReaderTwitterAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FeedReaderTwitterAPI* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda9_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	FeedReaderTwitterAPI* self;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	feed_reader_twitter_form_setAPI_finish (_data1_->widget, res);
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda9_ (self, source_object, res);
	block1_data_unref (self);
}

static void
__lambda10_ (Block1Data* _data1_)
{
	FeedReaderTwitterAPI* self;
	gchar* _tmp0_;
	self = _data1_->self;
	_tmp0_ = feed_reader_twitter_form_getTweet (_data1_->widget);
	_g_free0 (self->priv->m_tweet);
	self->priv->m_tweet = _tmp0_;
}

static void
___lambda10__feed_reader_share_form_share (FeedReaderShareForm* _sender,
                                           gpointer self)
{
	__lambda10_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static FeedReaderShareForm*
feed_reader_twitter_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                          const gchar* url)
{
	FeedReaderTwitterAPI * self;
	Block1Data* _data1_;
	FeedReaderTwitterForm* _tmp0_;
	FeedReaderShareForm* _tmp1_;
	FeedReaderShareForm* result;
	self = (FeedReaderTwitterAPI*) base;
	g_return_val_if_fail (url != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = feed_reader_twitter_form_new (url);
	g_object_ref_sink (_tmp0_);
	_data1_->widget = _tmp0_;
	feed_reader_twitter_form_setAPI (_data1_->widget, self, ___lambda9__gasync_ready_callback, block1_data_ref (_data1_));
	g_signal_connect_data ((FeedReaderShareForm*) _data1_->widget, "share", (GCallback) ___lambda10__feed_reader_share_form_share, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp1_ = _g_object_ref0 ((FeedReaderShareForm*) _data1_->widget);
	result = _tmp1_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

gint
feed_reader_twitter_api_getUrlLength (FeedReaderTwitterAPI* self)
{
	gchar** array = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint array_length1;
	gint _array_size_;
	gchar* id = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GSettings* settings = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	gchar* token = NULL;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	gchar* secret = NULL;
	GSettings* _tmp15_;
	gchar* _tmp16_;
	OAuthProxy* oauthObject = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	OAuthProxy* _tmp19_;
	RestProxyCall* call = NULL;
	OAuthProxy* _tmp20_;
	RestProxyCall* _tmp21_;
	RestProxyCall* _tmp22_;
	RestProxyCall* _tmp23_;
	JsonParser* parser = NULL;
	JsonParser* _tmp26_;
	JsonObject* root_object = NULL;
	JsonParser* _tmp31_;
	JsonNode* _tmp32_;
	JsonObject* _tmp33_;
	JsonObject* _tmp34_;
	JsonObject* _tmp35_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->m_urlLength > 0) {
		result = self->priv->m_urlLength;
		return result;
	}
	_tmp0_ = feed_reader_settings_share ("twitter");
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "account-ids");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_object_unref0 (_tmp1_);
	array = _tmp4_;
	array_length1 = _tmp4__length1;
	_array_size_ = array_length1;
	_tmp5_ = array;
	_tmp5__length1 = array_length1;
	_tmp6_ = _tmp5_[0];
	_tmp7_ = g_strdup (_tmp6_);
	id = _tmp7_;
	_tmp8_ = id;
	_tmp9_ = g_strdup_printf ("/org/gnome/feedreader/share/twitter/%s/", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	settings = _tmp12_;
	_tmp13_ = settings;
	_tmp14_ = g_settings_get_string (_tmp13_, "oauth-access-token");
	token = _tmp14_;
	_tmp15_ = settings;
	_tmp16_ = g_settings_get_string (_tmp15_, "oauth-access-token-secret");
	secret = _tmp16_;
	_tmp17_ = token;
	_tmp18_ = secret;
	_tmp19_ = (OAuthProxy*) oauth_proxy_new_with_token (FEED_READER_TWITTER_SECRETS_key, FEED_READER_TWITTER_SECRETS_secret, _tmp17_, _tmp18_, "https://api.twitter.com/", FALSE);
	oauthObject = _tmp19_;
	_tmp20_ = oauthObject;
	_tmp21_ = rest_proxy_new_call ((RestProxy*) _tmp20_);
	call = _tmp21_;
	_tmp22_ = call;
	rest_proxy_call_set_function (_tmp22_, "1.1/help/configuration.json");
	_tmp23_ = call;
	rest_proxy_call_set_method (_tmp23_, "GET");
	{
		RestProxyCall* _tmp24_;
		_tmp24_ = call;
		rest_proxy_call_run (_tmp24_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp25_ = -1;
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (secret);
		_g_free0 (token);
		_g_object_unref0 (settings);
		_g_free0 (id);
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp25_;
	}
	_tmp26_ = json_parser_new ();
	parser = _tmp26_;
	{
		JsonParser* _tmp27_;
		RestProxyCall* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = parser;
		_tmp28_ = call;
		_tmp29_ = rest_proxy_call_get_payload (_tmp28_);
		json_parser_load_from_data (_tmp27_, _tmp29_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp30_ = -1;
		_g_object_unref0 (parser);
		_g_object_unref0 (call);
		_g_object_unref0 (oauthObject);
		_g_free0 (secret);
		_g_free0 (token);
		_g_object_unref0 (settings);
		_g_free0 (id);
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp30_;
	}
	_tmp31_ = parser;
	_tmp32_ = json_parser_get_root (_tmp31_);
	_tmp33_ = json_node_get_object (_tmp32_);
	_tmp34_ = _json_object_ref0 (_tmp33_);
	root_object = _tmp34_;
	_tmp35_ = root_object;
	self->priv->m_urlLength = (gint) json_object_get_int_member (_tmp35_, "short_url_length");
	result = self->priv->m_urlLength;
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	_g_object_unref0 (call);
	_g_object_unref0 (oauthObject);
	_g_free0 (secret);
	_g_free0 (token);
	_g_object_unref0 (settings);
	_g_free0 (id);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
feed_reader_twitter_api_class_init (FeedReaderTwitterAPIClass * klass,
                                    gpointer klass_data)
{
	feed_reader_twitter_api_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderTwitterAPI_private_offset);
	G_OBJECT_CLASS (klass)->finalize = feed_reader_twitter_api_finalize;
}

static void
feed_reader_twitter_api_feed_reader_share_account_interface_interface_init (FeedReaderShareAccountInterfaceIface * iface,
                                                                            gpointer iface_data)
{
	feed_reader_twitter_api_feed_reader_share_account_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->setupSystemAccounts = (void (*) (FeedReaderShareAccountInterface*, GeeList*)) feed_reader_twitter_api_real_setupSystemAccounts;
	iface->addBookmark = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*, gboolean)) feed_reader_twitter_api_real_addBookmark;
	iface->logout = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_twitter_api_real_logout;
	iface->getIconName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_twitter_api_real_getIconName;
	iface->getUsername = (gchar* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_twitter_api_real_getUsername;
	iface->needSetup = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_twitter_api_real_needSetup;
	iface->singleInstance = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_twitter_api_real_singleInstance;
	iface->useSystemAccounts = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_twitter_api_real_useSystemAccounts;
	iface->pluginID = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_twitter_api_real_pluginID;
	iface->pluginName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_twitter_api_real_pluginName;
	iface->newSetup_withID = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_twitter_api_real_newSetup_withID;
	iface->newSetup = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*)) feed_reader_twitter_api_real_newSetup;
	iface->newSystemAccount = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_twitter_api_real_newSystemAccount;
	iface->shareWidget = (FeedReaderShareForm* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_twitter_api_real_shareWidget;
}

static void
feed_reader_twitter_api_instance_init (FeedReaderTwitterAPI * self,
                                       gpointer klass)
{
	self->priv = feed_reader_twitter_api_get_instance_private (self);
	self->priv->m_urlLength = 0;
}

static void
feed_reader_twitter_api_finalize (GObject * obj)
{
	FeedReaderTwitterAPI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_TWITTER_API, FeedReaderTwitterAPI);
	_g_object_unref0 (self->priv->m_oauthObject);
	_g_free0 (self->priv->m_tweet);
	G_OBJECT_CLASS (feed_reader_twitter_api_parent_class)->finalize (obj);
}

GType
feed_reader_twitter_api_get_type (void)
{
	return feed_reader_twitter_api_type_id;
}

GType
feed_reader_twitter_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderTwitterAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_twitter_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderTwitterAPI), 0, (GInstanceInitFunc) feed_reader_twitter_api_instance_init, NULL };
	static const GInterfaceInfo feed_reader_share_account_interface_info = { (GInterfaceInitFunc) feed_reader_twitter_api_feed_reader_share_account_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	feed_reader_twitter_api_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "FeedReaderTwitterAPI", &g_define_type_info, 0);
	g_type_module_add_interface (module, feed_reader_twitter_api_type_id, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, &feed_reader_share_account_interface_info);
	FeedReaderTwitterAPI_private_offset = sizeof (FeedReaderTwitterAPIPrivate);
	return feed_reader_twitter_api_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_twitter_api_register_type (module);
	feed_reader_twitter_form_register_type (module);
	feed_reader_twitter_setup_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, FEED_READER_TYPE_TWITTER_API);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

