/* TwitterSetup.c generated by valac 0.56.3, the Vala compiler
 * generated from TwitterSetup.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "twitter.h"
#include "FeedReader.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#define FEED_READER_TWITTER_SECRETS_callback "feedreader://twitter"

enum  {
	FEED_READER_TWITTER_SETUP_0_PROPERTY,
	FEED_READER_TWITTER_SETUP_NUM_PROPERTIES
};
static GParamSpec* feed_reader_twitter_setup_properties[FEED_READER_TWITTER_SETUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;

struct _FeedReaderTwitterSetupPrivate {
	FeedReaderTwitterAPI* m_api;
};

struct _Block3Data {
	int _ref_count_;
	FeedReaderTwitterSetup* self;
	gchar* id;
	gchar* requestToken;
};

static gint FeedReaderTwitterSetup_private_offset;
static gpointer feed_reader_twitter_setup_parent_class = NULL;
static GType feed_reader_twitter_setup_type_id = 0;

static void feed_reader_twitter_setup_real_login (FeedReaderServiceSetup* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda4_ (Block3Data* _data3_,
                 const gchar* content);
static void _feed_reader_service_setup_login_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _feed_reader_service_setup_logout_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void ___lambda4__feed_reader_feed_reader_app_callback (FeedReaderFeedReaderApp* _sender,
                                                       const gchar* content,
                                                       gpointer self);
static void feed_reader_twitter_setup_real_logout (FeedReaderServiceSetup* base);
static void feed_reader_twitter_setup_finalize (GObject * obj);

static inline gpointer
feed_reader_twitter_setup_get_instance_private (FeedReaderTwitterSetup* self)
{
	return G_STRUCT_MEMBER_P (self, FeedReaderTwitterSetup_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FeedReaderTwitterSetup*
feed_reader_twitter_setup_construct (GType object_type,
                                     const gchar* id,
                                     FeedReaderTwitterAPI* api,
                                     const gchar* username)
{
	FeedReaderTwitterSetup * self = NULL;
	gboolean loggedIN = FALSE;
	FeedReaderTwitterAPI* _tmp0_;
	g_return_val_if_fail (api != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	loggedIN = FALSE;
	if (g_strcmp0 (username, "") != 0) {
		loggedIN = TRUE;
	}
	self = (FeedReaderTwitterSetup*) feed_reader_service_setup_construct (object_type, "Twitter", "feed-share-twitter", loggedIN, username, FALSE);
	_tmp0_ = _g_object_ref0 (api);
	_g_object_unref0 (self->priv->m_api);
	self->priv->m_api = _tmp0_;
	if (id != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (id);
		_g_free0 (((FeedReaderServiceSetup*) self)->m_id);
		((FeedReaderServiceSetup*) self)->m_id = _tmp1_;
	}
	return self;
}

FeedReaderTwitterSetup*
feed_reader_twitter_setup_new (const gchar* id,
                               FeedReaderTwitterAPI* api,
                               const gchar* username)
{
	return feed_reader_twitter_setup_construct (FEED_READER_TYPE_TWITTER_SETUP, id, api, username);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FeedReaderTwitterSetup* self;
		self = _data3_->self;
		_g_free0 (_data3_->requestToken);
		_g_free0 (_data3_->id);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
_feed_reader_service_setup_login_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	feed_reader_service_setup_login ((FeedReaderServiceSetup*) self);
}

static void
_feed_reader_service_setup_logout_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	feed_reader_service_setup_logout ((FeedReaderServiceSetup*) self);
}

static void
__lambda4_ (Block3Data* _data3_,
            const gchar* content)
{
	FeedReaderTwitterSetup* self;
	self = _data3_->self;
	g_return_if_fail (content != NULL);
	if (g_str_has_prefix (content, FEED_READER_TWITTER_SECRETS_callback)) {
		gint token_start = 0;
		gint token_end = 0;
		gchar* token = NULL;
		gchar* _tmp0_;
		gint verifier_start = 0;
		gchar* verifier = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		token_start = string_index_of (content, "token=", 0) + 6;
		token_end = string_index_of (content, "&", token_start);
		_tmp0_ = string_substring (content, (glong) token_start, (glong) (token_end - token_start));
		token = _tmp0_;
		verifier_start = string_index_of (content, "verifier=", 0) + 9;
		_tmp1_ = string_substring (content, (glong) verifier_start, (glong) -1);
		verifier = _tmp1_;
		_tmp2_ = token;
		if (g_strcmp0 (_tmp2_, _data3_->requestToken) == 0) {
			FeedReaderTwitterAPI* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = self->priv->m_api;
			_tmp4_ = verifier;
			if (feed_reader_twitter_api_getAccessToken (_tmp3_, _data3_->id, _tmp4_)) {
				gchar* _tmp5_;
				FeedReaderTwitterAPI* _tmp6_;
				FeedReaderTwitterAPI* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				FeedReaderTwitterAPI* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				FeedReaderTwitterAPI* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				FeedReaderTwitterAPI* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GtkStack* _tmp19_;
				GtkSpinner* _tmp20_;
				GtkLabel* _tmp21_;
				FeedReaderTwitterAPI* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				GtkStack* _tmp25_;
				GtkButton* _tmp26_;
				guint _tmp27_;
				GtkButton* _tmp28_;
				_tmp5_ = g_strdup (_data3_->id);
				_g_free0 (((FeedReaderServiceSetup*) self)->m_id);
				((FeedReaderServiceSetup*) self)->m_id = _tmp5_;
				_tmp6_ = self->priv->m_api;
				_tmp7_ = self->priv->m_api;
				_tmp8_ = feed_reader_share_account_interface_pluginID ((FeedReaderShareAccountInterface*) _tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->priv->m_api;
				_tmp11_ = feed_reader_share_account_interface_getUsername ((FeedReaderShareAccountInterface*) _tmp10_, _data3_->id);
				_tmp12_ = _tmp11_;
				_tmp13_ = self->priv->m_api;
				_tmp14_ = feed_reader_share_account_interface_getIconName ((FeedReaderShareAccountInterface*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->m_api;
				_tmp17_ = feed_reader_share_account_interface_pluginName ((FeedReaderShareAccountInterface*) _tmp16_);
				_tmp18_ = _tmp17_;
				g_signal_emit_by_name ((FeedReaderShareAccountInterface*) _tmp6_, "add-account", _data3_->id, _tmp9_, _tmp12_, _tmp15_, _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				_g_free0 (_tmp12_);
				_g_free0 (_tmp9_);
				_tmp19_ = ((FeedReaderServiceSetup*) self)->m_iconStack;
				gtk_stack_set_visible_child_full (_tmp19_, "loggedIN", GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
				((FeedReaderServiceSetup*) self)->m_isLoggedIN = TRUE;
				_tmp20_ = ((FeedReaderServiceSetup*) self)->m_spinner;
				gtk_spinner_stop (_tmp20_);
				_tmp21_ = ((FeedReaderServiceSetup*) self)->m_label;
				_tmp22_ = self->priv->m_api;
				_tmp23_ = feed_reader_share_account_interface_getUsername ((FeedReaderShareAccountInterface*) _tmp22_, _data3_->id);
				_tmp24_ = _tmp23_;
				gtk_label_set_label (_tmp21_, _tmp24_);
				_g_free0 (_tmp24_);
				_tmp25_ = ((FeedReaderServiceSetup*) self)->m_labelStack;
				gtk_stack_set_visible_child_full (_tmp25_, "loggedIN", GTK_STACK_TRANSITION_TYPE_CROSSFADE);
				_tmp26_ = ((FeedReaderServiceSetup*) self)->m_login_button;
				g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp27_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp26_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp27_, 0, NULL, (GCallback) _feed_reader_service_setup_login_gtk_button_clicked, (FeedReaderServiceSetup*) self);
				_tmp28_ = ((FeedReaderServiceSetup*) self)->m_login_button;
				g_signal_connect_object (_tmp28_, "clicked", (GCallback) _feed_reader_service_setup_logout_gtk_button_clicked, (FeedReaderServiceSetup*) self, 0);
			} else {
				GtkStack* _tmp29_;
				_tmp29_ = ((FeedReaderServiceSetup*) self)->m_iconStack;
				gtk_stack_set_visible_child_full (_tmp29_, "button", GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
			}
		}
		_g_free0 (verifier);
		_g_free0 (token);
	}
}

static void
___lambda4__feed_reader_feed_reader_app_callback (FeedReaderFeedReaderApp* _sender,
                                                  const gchar* content,
                                                  gpointer self)
{
	__lambda4_ (self, content);
}

static void
feed_reader_twitter_setup_real_login (FeedReaderServiceSetup* base)
{
	FeedReaderTwitterSetup * self;
	Block3Data* _data3_;
	FeedReaderShare* _tmp0_;
	FeedReaderShare* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FeedReaderTwitterAPI* _tmp4_;
	gchar* _tmp5_;
	gchar* url = NULL;
	FeedReaderTwitterAPI* _tmp6_;
	gchar* _tmp7_;
	GtkSpinner* _tmp8_;
	GtkStack* _tmp9_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	FeedReaderFeedReaderApp* _tmp14_;
	FeedReaderFeedReaderApp* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = (FeedReaderTwitterSetup*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = feed_reader_share_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = feed_reader_share_generateNewID (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_data3_->id = _tmp3_;
	_tmp4_ = self->priv->m_api;
	_tmp5_ = feed_reader_twitter_api_getRequestToken (_tmp4_);
	_data3_->requestToken = _tmp5_;
	_tmp6_ = self->priv->m_api;
	_tmp7_ = feed_reader_twitter_api_getURL (_tmp6_, _data3_->requestToken);
	url = _tmp7_;
	_tmp8_ = ((FeedReaderServiceSetup*) self)->m_spinner;
	gtk_spinner_start (_tmp8_);
	_tmp9_ = ((FeedReaderServiceSetup*) self)->m_iconStack;
	gtk_stack_set_visible_child_name (_tmp9_, "spinner");
	{
		FeedReaderSettingsDialog* _tmp10_;
		FeedReaderSettingsDialog* _tmp11_;
		_tmp10_ = feed_reader_settings_dialog_get_default ();
		_tmp11_ = _tmp10_;
		gtk_show_uri_on_window ((GtkWindow*) _tmp11_, url, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_object_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (url);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = ((FeedReaderServiceSetup*) self)->m_login_button;
	gtk_button_set_label (_tmp12_, _ ("waiting"));
	_tmp13_ = ((FeedReaderServiceSetup*) self)->m_login_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, FALSE);
	_tmp14_ = feed_reader_feed_reader_app_get_default ();
	_tmp15_ = _tmp14_;
	g_signal_connect_data (_tmp15_, "callback", (GCallback) ___lambda4__feed_reader_feed_reader_app_callback, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (_tmp15_);
	_g_free0 (url);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
feed_reader_twitter_setup_real_logout (FeedReaderServiceSetup* base)
{
	FeedReaderTwitterSetup * self;
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	FeedReaderTwitterAPI* _tmp2_;
	const gchar* _tmp3_;
	self = (FeedReaderTwitterSetup*) base;
	((FeedReaderServiceSetup*) self)->m_isLoggedIN = FALSE;
	_tmp0_ = ((FeedReaderServiceSetup*) self)->m_iconStack;
	gtk_stack_set_visible_child_full (_tmp0_, "button", GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp1_ = ((FeedReaderServiceSetup*) self)->m_labelStack;
	gtk_stack_set_visible_child_name (_tmp1_, "loggedOUT");
	_tmp2_ = self->priv->m_api;
	_tmp3_ = ((FeedReaderServiceSetup*) self)->m_id;
	feed_reader_share_account_interface_logout ((FeedReaderShareAccountInterface*) _tmp2_, _tmp3_);
	g_signal_emit_by_name ((FeedReaderServiceSetup*) self, "remove-row");
}

static void
feed_reader_twitter_setup_class_init (FeedReaderTwitterSetupClass * klass,
                                      gpointer klass_data)
{
	feed_reader_twitter_setup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FeedReaderTwitterSetup_private_offset);
	((FeedReaderServiceSetupClass *) klass)->login = (void (*) (FeedReaderServiceSetup*)) feed_reader_twitter_setup_real_login;
	((FeedReaderServiceSetupClass *) klass)->logout = (void (*) (FeedReaderServiceSetup*)) feed_reader_twitter_setup_real_logout;
	G_OBJECT_CLASS (klass)->finalize = feed_reader_twitter_setup_finalize;
}

static void
feed_reader_twitter_setup_instance_init (FeedReaderTwitterSetup * self,
                                         gpointer klass)
{
	self->priv = feed_reader_twitter_setup_get_instance_private (self);
}

static void
feed_reader_twitter_setup_finalize (GObject * obj)
{
	FeedReaderTwitterSetup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FEED_READER_TYPE_TWITTER_SETUP, FeedReaderTwitterSetup);
	_g_object_unref0 (self->priv->m_api);
	G_OBJECT_CLASS (feed_reader_twitter_setup_parent_class)->finalize (obj);
}

GType
feed_reader_twitter_setup_get_type (void)
{
	return feed_reader_twitter_setup_type_id;
}

GType
feed_reader_twitter_setup_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderTwitterSetupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_twitter_setup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderTwitterSetup), 0, (GInstanceInitFunc) feed_reader_twitter_setup_instance_init, NULL };
	feed_reader_twitter_setup_type_id = g_type_module_register_type (module, FEED_READER_TYPE_SERVICE_SETUP, "FeedReaderTwitterSetup", &g_define_type_info, 0);
	FeedReaderTwitterSetup_private_offset = sizeof (FeedReaderTwitterSetupPrivate);
	return feed_reader_twitter_setup_type_id;
}

