/* WallabagAPI.c generated by valac 0.56.3, the Vala compiler
 * generated from WallabagAPI.vala, do not modify */

/*This file is part of FeedReader.*/
/**/
/*FeedReader is free software: you can redistribute it and/or modify*/
/*it under the terms of the GNU General Public License as published by*/
/*the Free Software Foundation, either version 3 of the License, or*/
/*(at your option) any later version.*/
/**/
/*FeedReader is distributed in the hope that it will be useful,*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*GNU General Public License for more details.*/
/**/
/*You should have received a copy of the GNU General Public License*/
/*along with FeedReader.  If not, see <http://www.gnu.org/licenses/>.*/

#include "wallabag.h"
#include <glib-object.h>
#include <gee.h>
#include "FeedReader.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <libpeas/peas.h>

enum  {
	FEED_READER_WALLABAG_API_0_PROPERTY,
	FEED_READER_WALLABAG_API_NUM_PROPERTIES
};
static GParamSpec* feed_reader_wallabag_api_properties[FEED_READER_WALLABAG_API_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupBuffer_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupBuffer_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _Block1Data {
	int _ref_count_;
	FeedReaderWallabagAPI* self;
	gboolean removed;
	gchar* id;
};

static gpointer feed_reader_wallabag_api_parent_class = NULL;
static FeedReaderShareAccountInterfaceIface * feed_reader_wallabag_api_feed_reader_share_account_interface_parent_iface = NULL;
static GType feed_reader_wallabag_api_type_id = 0;

static void feed_reader_wallabag_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                        GeeList* accounts);
static void _vala_SoupBuffer_free (SoupBuffer* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _g_free0_ (gpointer var);
static gboolean feed_reader_wallabag_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                                    const gchar* id,
                                                    const gchar* url,
                                                    gboolean system);
static gboolean feed_reader_wallabag_api_accessTokenValid (FeedReaderWallabagAPI* self,
                                                    const gchar* id);
static gboolean feed_reader_wallabag_api_real_logout (FeedReaderShareAccountInterface* base,
                                               const gchar* id);
static void feed_reader_wallabag_api_deletePassword (FeedReaderWallabagAPI* self,
                                              const gchar* id);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* feed_reader_wallabag_api_real_getIconName (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_wallabag_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                                  const gchar* id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* async_res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static gboolean feed_reader_wallabag_api_real_needSetup (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_wallabag_api_real_singleInstance (FeedReaderShareAccountInterface* base);
static gboolean feed_reader_wallabag_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_wallabag_api_real_pluginID (FeedReaderShareAccountInterface* base);
static gchar* feed_reader_wallabag_api_real_pluginName (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_wallabag_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                                                       const gchar* id,
                                                                       const gchar* username);
static FeedReaderServiceSetup* feed_reader_wallabag_api_real_newSetup (FeedReaderShareAccountInterface* base);
static FeedReaderServiceSetup* feed_reader_wallabag_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                                                        const gchar* id,
                                                                        const gchar* username);
static FeedReaderShareForm* feed_reader_wallabag_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                                                const gchar* url);
GType feed_reader_wallabag_setup_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

FeedReaderWallabagAPI*
feed_reader_wallabag_api_construct (GType object_type)
{
	FeedReaderWallabagAPI * self = NULL;
	self = (FeedReaderWallabagAPI*) g_object_new (object_type, NULL);
	return self;
}

FeedReaderWallabagAPI*
feed_reader_wallabag_api_new (void)
{
	return feed_reader_wallabag_api_construct (FEED_READER_TYPE_WALLABAG_API);
}

static void
feed_reader_wallabag_api_real_setupSystemAccounts (FeedReaderShareAccountInterface* base,
                                                   GeeList* accounts)
{
	FeedReaderWallabagAPI * self;
	self = (FeedReaderWallabagAPI*) base;
	g_return_if_fail (accounts != NULL);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_SoupBuffer_free (SoupBuffer* self)
{
	g_boxed_free (soup_buffer_get_type (), self);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

gboolean
feed_reader_wallabag_api_getAccessToken (FeedReaderWallabagAPI* self,
                                         const gchar* id,
                                         const gchar* username,
                                         const gchar* password,
                                         const gchar* clientID,
                                         const gchar* clientSecret,
                                         const gchar* baseURL)
{
	SoupSession* session = NULL;
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	gchar* message = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* url = NULL;
	gchar* _tmp20_;
	SoupMessage* message_soup = NULL;
	const gchar* _tmp21_;
	SoupMessage* _tmp22_;
	SoupMessage* _tmp23_;
	const gchar* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gint _tmp26_ = 0;
	guint8* _tmp27_;
	gint _tmp27__length1;
	SoupSession* _tmp28_;
	SoupMessage* _tmp29_;
	gboolean _tmp30_ = FALSE;
	SoupMessage* _tmp31_;
	SoupMessageBody* _tmp32_;
	SoupBuffer* _tmp33_;
	SoupBuffer* _tmp34_;
	guint8* _tmp35_;
	gint _tmp35__length1;
	gboolean _tmp36_;
	gchar* response = NULL;
	SoupMessage* _tmp44_;
	SoupMessageBody* _tmp45_;
	SoupBuffer* _tmp46_;
	SoupBuffer* _tmp47_;
	guint8* _tmp48_;
	gint _tmp48__length1;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	JsonParser* parser = NULL;
	JsonParser* _tmp52_;
	JsonNode* root_node = NULL;
	JsonParser* _tmp58_;
	JsonNode* _tmp59_;
	JsonNode* _tmp60_;
	JsonObject* root_object = NULL;
	JsonNode* _tmp61_;
	JsonObject* _tmp62_;
	JsonObject* _tmp63_;
	JsonObject* _tmp64_;
	gchar* accessToken = NULL;
	JsonObject* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gint64 now = 0LL;
	GDateTime* _tmp68_;
	GDateTime* _tmp69_;
	gint64 _tmp70_;
	JsonObject* _tmp71_;
	gint64 expires = 0LL;
	JsonObject* _tmp72_;
	GSettings* settings = NULL;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GSettings* _tmp75_;
	GSettings* _tmp76_;
	GSettings* _tmp77_;
	const gchar* _tmp78_;
	GSettings* _tmp79_;
	GSettings* _tmp80_;
	GSettings* _tmp81_;
	GSettings* _tmp82_;
	GSettings* _tmp83_;
	gchar** array = NULL;
	GSettings* _tmp84_;
	GSettings* _tmp85_;
	gchar** _tmp86_;
	gchar** _tmp87_;
	gchar** _tmp88_;
	gint _tmp88__length1;
	gint array_length1;
	gint _array_size_;
	gchar** _tmp89_;
	gint _tmp89__length1;
	gchar* _tmp92_;
	GSettings* _tmp93_;
	GSettings* _tmp94_;
	gchar** _tmp95_;
	gint _tmp95__length1;
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp96_;
	GHashTable* attributes = NULL;
	GHashFunc _tmp97_;
	GEqualFunc _tmp98_;
	GHashTable* _tmp99_;
	GHashTable* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	GHashTable* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (username != NULL, FALSE);
	g_return_val_if_fail (password != NULL, FALSE);
	g_return_val_if_fail (clientID != NULL, FALSE);
	g_return_val_if_fail (clientSecret != NULL, FALSE);
	g_return_val_if_fail (baseURL != NULL, FALSE);
	feed_reader_logger_debug ("WallabagAPI getAccessToken");
	_tmp0_ = soup_session_new ();
	session = _tmp0_;
	_tmp1_ = session;
	g_object_set (_tmp1_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp2_ = g_strconcat ("grant_type=password" "&client_id=", clientID, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "&client_secret=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, clientSecret, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "&username=", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_uri_escape_string (username, NULL, TRUE);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "&password=", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_uri_escape_string (password, NULL, TRUE);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	message = _tmp19_;
	_tmp20_ = g_strconcat (baseURL, "oauth/v2/token", NULL);
	url = _tmp20_;
	_tmp21_ = url;
	_tmp22_ = soup_message_new ("POST", _tmp21_);
	message_soup = _tmp22_;
	_tmp23_ = message_soup;
	_tmp24_ = message;
	_tmp25_ = string_get_data (_tmp24_, &_tmp26_);
	_tmp25__length1 = _tmp26_;
	_tmp27_ = _tmp25_;
	_tmp27__length1 = _tmp25__length1;
	soup_message_set_request (_tmp23_, "application/x-www-form-urlencoded; charset=UTF8", SOUP_MEMORY_COPY, _tmp27_, (gsize) _tmp27__length1);
	_tmp28_ = session;
	_tmp29_ = message_soup;
	soup_session_send_message (_tmp28_, _tmp29_);
	_tmp31_ = message_soup;
	_tmp32_ = _tmp31_->response_body;
	_tmp33_ = soup_message_body_flatten (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_->data;
	_tmp35__length1 = _tmp34_->length;
	_tmp36_ = ((const gchar*) _tmp35_) == NULL;
	__vala_SoupBuffer_free0 (_tmp34_);
	if (_tmp36_) {
		_tmp30_ = TRUE;
	} else {
		SoupMessage* _tmp37_;
		SoupMessageBody* _tmp38_;
		SoupBuffer* _tmp39_;
		SoupBuffer* _tmp40_;
		guint8* _tmp41_;
		gint _tmp41__length1;
		_tmp37_ = message_soup;
		_tmp38_ = _tmp37_->response_body;
		_tmp39_ = soup_message_body_flatten (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_->data;
		_tmp41__length1 = _tmp40_->length;
		_tmp30_ = g_strcmp0 ((const gchar*) _tmp41_, "") == 0;
		__vala_SoupBuffer_free0 (_tmp40_);
	}
	if (_tmp30_) {
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		feed_reader_logger_error ("WallabagAPI - getAccessToken: no response");
		_tmp42_ = url;
		feed_reader_logger_error (_tmp42_);
		_tmp43_ = message;
		feed_reader_logger_error (_tmp43_);
		result = FALSE;
		_g_object_unref0 (message_soup);
		_g_free0 (url);
		_g_free0 (message);
		_g_object_unref0 (session);
		return result;
	}
	_tmp44_ = message_soup;
	_tmp45_ = _tmp44_->response_body;
	_tmp46_ = soup_message_body_flatten (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = _tmp47_->data;
	_tmp48__length1 = _tmp47_->length;
	_tmp49_ = g_strdup ((const gchar*) _tmp48_);
	_tmp50_ = _tmp49_;
	__vala_SoupBuffer_free0 (_tmp47_);
	response = _tmp50_;
	_tmp51_ = response;
	feed_reader_logger_debug (_tmp51_);
	_tmp52_ = json_parser_new ();
	parser = _tmp52_;
	{
		JsonParser* _tmp53_;
		const gchar* _tmp54_;
		_tmp53_ = parser;
		_tmp54_ = response;
		json_parser_load_from_data (_tmp53_, _tmp54_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		feed_reader_logger_error ("Could not load response to Message from Wallabag");
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		feed_reader_logger_error (_tmp56_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		_g_free0 (response);
		_g_object_unref0 (message_soup);
		_g_free0 (url);
		_g_free0 (message);
		_g_object_unref0 (session);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp57_ = FALSE;
		_g_object_unref0 (parser);
		_g_free0 (response);
		_g_object_unref0 (message_soup);
		_g_free0 (url);
		_g_free0 (message);
		_g_object_unref0 (session);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp57_;
	}
	_tmp58_ = parser;
	_tmp59_ = json_parser_get_root (_tmp58_);
	_tmp60_ = __vala_JsonNode_copy0 (_tmp59_);
	root_node = _tmp60_;
	_tmp61_ = root_node;
	_tmp62_ = json_node_get_object (_tmp61_);
	_tmp63_ = _json_object_ref0 (_tmp62_);
	root_object = _tmp63_;
	_tmp64_ = root_object;
	if (!json_object_has_member (_tmp64_, "access_token")) {
		feed_reader_logger_error ("WallabagAPI.getAccessToken: no member access_token in response");
		result = FALSE;
		_json_object_unref0 (root_object);
		__vala_JsonNode_free0 (root_node);
		_g_object_unref0 (parser);
		_g_free0 (response);
		_g_object_unref0 (message_soup);
		_g_free0 (url);
		_g_free0 (message);
		_g_object_unref0 (session);
		return result;
	}
	_tmp65_ = root_object;
	_tmp66_ = json_object_get_string_member (_tmp65_, "access_token");
	_tmp67_ = g_strdup (_tmp66_);
	accessToken = _tmp67_;
	_tmp68_ = g_date_time_new_now_local ();
	_tmp69_ = _tmp68_;
	_tmp70_ = g_date_time_to_unix (_tmp69_);
	_g_date_time_unref0 (_tmp69_);
	now = _tmp70_;
	_tmp71_ = root_object;
	if (!json_object_has_member (_tmp71_, "expires_in")) {
		feed_reader_logger_error ("WallabagAPI.getAccessToken: no member expires_in in response");
		result = FALSE;
		_g_free0 (accessToken);
		_json_object_unref0 (root_object);
		__vala_JsonNode_free0 (root_node);
		_g_object_unref0 (parser);
		_g_free0 (response);
		_g_object_unref0 (message_soup);
		_g_free0 (url);
		_g_free0 (message);
		_g_object_unref0 (session);
		return result;
	}
	_tmp72_ = root_object;
	expires = json_object_get_int_member (_tmp72_, "expires_in");
	_tmp73_ = g_strdup_printf ("/org/gnome/feedreader/share/wallabag/%s/", id);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp74_);
	_tmp76_ = _tmp75_;
	_g_free0 (_tmp74_);
	settings = _tmp76_;
	_tmp77_ = settings;
	_tmp78_ = accessToken;
	g_settings_set_string (_tmp77_, "oauth-access-token", _tmp78_);
	_tmp79_ = settings;
	g_settings_set_string (_tmp79_, "username", username);
	_tmp80_ = settings;
	g_settings_set_int (_tmp80_, "access-token-expires", (gint) (now + expires));
	_tmp81_ = settings;
	g_settings_set_string (_tmp81_, "url", baseURL);
	_tmp82_ = settings;
	g_settings_set_string (_tmp82_, "client-id", clientID);
	_tmp83_ = settings;
	g_settings_set_string (_tmp83_, "client-secret", clientSecret);
	_tmp84_ = feed_reader_settings_share ("wallabag");
	_tmp85_ = _tmp84_;
	_tmp87_ = _tmp86_ = g_settings_get_strv (_tmp85_, "account-ids");
	_tmp88_ = _tmp87_;
	_tmp88__length1 = _vala_array_length (_tmp86_);
	_g_object_unref0 (_tmp85_);
	array = _tmp88_;
	array_length1 = _tmp88__length1;
	_array_size_ = array_length1;
	_tmp89_ = array;
	_tmp89__length1 = array_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp89_;
		i_collection_length1 = _tmp89__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			gchar* _tmp90_;
			gchar* i = NULL;
			_tmp90_ = g_strdup (i_collection[i_it]);
			i = _tmp90_;
			{
				const gchar* _tmp91_;
				_tmp91_ = i;
				if (g_strcmp0 (_tmp91_, id) == 0) {
					feed_reader_logger_warning ("WallabagAPI - getAccessToken: id already part of array. Returning");
					result = TRUE;
					_g_free0 (i);
					array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (settings);
					_g_free0 (accessToken);
					_json_object_unref0 (root_object);
					__vala_JsonNode_free0 (root_node);
					_g_object_unref0 (parser);
					_g_free0 (response);
					_g_object_unref0 (message_soup);
					_g_free0 (url);
					_g_free0 (message);
					_g_object_unref0 (session);
					return result;
				}
				_g_free0 (i);
			}
		}
	}
	_tmp92_ = g_strdup (id);
	_vala_array_add1 (&array, &array_length1, &_array_size_, _tmp92_);
	_tmp93_ = feed_reader_settings_share ("wallabag");
	_tmp94_ = _tmp93_;
	_tmp95_ = array;
	_tmp95__length1 = array_length1;
	g_settings_set_strv (_tmp94_, "account-ids", _tmp95_);
	_g_object_unref0 (_tmp94_);
	_tmp96_ = secret_schema_new ("org.gnome.feedreader.wallabag.password", SECRET_SCHEMA_NONE, "username", SECRET_SCHEMA_ATTRIBUTE_STRING, "id", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp96_;
	_tmp97_ = g_str_hash;
	_tmp98_ = g_str_equal;
	_tmp99_ = g_hash_table_new_full (_tmp97_, _tmp98_, _g_free0_, _g_free0_);
	attributes = _tmp99_;
	_tmp100_ = attributes;
	_tmp101_ = g_strdup ("username");
	_tmp102_ = g_strdup (username);
	g_hash_table_insert (_tmp100_, _tmp101_, _tmp102_);
	_tmp103_ = attributes;
	_tmp104_ = g_strdup ("id");
	_tmp105_ = g_strdup (id);
	g_hash_table_insert (_tmp103_, _tmp104_, _tmp105_);
	{
		SecretSchema* _tmp106_;
		GHashTable* _tmp107_;
		_tmp106_ = pwSchema;
		_tmp107_ = attributes;
		secret_password_storev_sync (_tmp106_, _tmp107_, SECRET_COLLECTION_DEFAULT, "Feedreader: Wallabag login", password, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp108_;
		const gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp108_ = e;
		_tmp109_ = _tmp108_->message;
		_tmp110_ = g_strconcat ("WallabagAPI - getAccessToken: ", _tmp109_, NULL);
		_tmp111_ = _tmp110_;
		feed_reader_logger_error (_tmp111_);
		_g_free0 (_tmp111_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp112_ = FALSE;
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (pwSchema);
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		_g_free0 (accessToken);
		_json_object_unref0 (root_object);
		__vala_JsonNode_free0 (root_node);
		_g_object_unref0 (parser);
		_g_free0 (response);
		_g_object_unref0 (message_soup);
		_g_free0 (url);
		_g_free0 (message);
		_g_object_unref0 (session);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp112_;
	}
	result = TRUE;
	_g_hash_table_unref0 (attributes);
	_secret_schema_unref0 (pwSchema);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	_g_free0 (accessToken);
	_json_object_unref0 (root_object);
	__vala_JsonNode_free0 (root_node);
	_g_object_unref0 (parser);
	_g_free0 (response);
	_g_object_unref0 (message_soup);
	_g_free0 (url);
	_g_free0 (message);
	_g_object_unref0 (session);
	return result;
}

static gboolean
feed_reader_wallabag_api_real_addBookmark (FeedReaderShareAccountInterface* base,
                                           const gchar* id,
                                           const gchar* url,
                                           gboolean system)
{
	FeedReaderWallabagAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SoupSession* session = NULL;
	SoupSession* _tmp19_;
	SoupSession* _tmp20_;
	gchar* message = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* baseURL = NULL;
	GSettings* _tmp25_;
	gchar* _tmp26_;
	SoupMessage* message_soup = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	SoupMessage* _tmp30_;
	SoupMessage* _tmp31_;
	SoupMessage* _tmp32_;
	const gchar* _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_ = 0;
	guint8* _tmp36_;
	gint _tmp36__length1;
	SoupMessage* _tmp37_;
	SoupMessageHeaders* _tmp38_;
	GSettings* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	SoupSession* _tmp44_;
	SoupMessage* _tmp45_;
	gboolean _tmp46_ = FALSE;
	SoupMessage* _tmp47_;
	SoupMessageBody* _tmp48_;
	SoupBuffer* _tmp49_;
	SoupBuffer* _tmp50_;
	guint8* _tmp51_;
	gint _tmp51__length1;
	gboolean _tmp52_;
	gboolean result;
	self = (FeedReaderWallabagAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/wallabag/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = g_strconcat ("WallabagAPI - addBookmark: ", url, NULL);
	_tmp5_ = _tmp4_;
	feed_reader_logger_debug (_tmp5_);
	_g_free0 (_tmp5_);
	if (!feed_reader_wallabag_api_accessTokenValid (self, id)) {
		gchar* username = NULL;
		gchar* _tmp6_;
		gchar* password = NULL;
		gchar* _tmp7_;
		gchar* clientID = NULL;
		GSettings* _tmp8_;
		gchar* _tmp9_;
		gchar* clientSecret = NULL;
		GSettings* _tmp10_;
		gchar* _tmp11_;
		gchar* baseURL = NULL;
		GSettings* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp6_ = feed_reader_share_account_interface_getUsername ((FeedReaderShareAccountInterface*) self, id);
		username = _tmp6_;
		_tmp7_ = feed_reader_wallabag_api_getPasswd (self, id);
		password = _tmp7_;
		_tmp8_ = settings;
		_tmp9_ = g_settings_get_string (_tmp8_, "client-id");
		clientID = _tmp9_;
		_tmp10_ = settings;
		_tmp11_ = g_settings_get_string (_tmp10_, "client-secret");
		clientSecret = _tmp11_;
		_tmp12_ = settings;
		_tmp13_ = g_settings_get_string (_tmp12_, "url");
		baseURL = _tmp13_;
		_tmp14_ = username;
		_tmp15_ = password;
		_tmp16_ = clientID;
		_tmp17_ = clientSecret;
		_tmp18_ = baseURL;
		feed_reader_wallabag_api_getAccessToken (self, id, _tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_);
		_g_free0 (baseURL);
		_g_free0 (clientSecret);
		_g_free0 (clientID);
		_g_free0 (password);
		_g_free0 (username);
	}
	feed_reader_logger_debug ("WallabagAPI - addBookmark: token still valid");
	_tmp19_ = soup_session_new ();
	session = _tmp19_;
	_tmp20_ = session;
	g_object_set (_tmp20_, "user-agent", FEED_READER_CONSTANTS_USER_AGENT, NULL);
	_tmp21_ = g_uri_escape_string (url, NULL, TRUE);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat ("url=", _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	message = _tmp24_;
	_tmp25_ = settings;
	_tmp26_ = g_settings_get_string (_tmp25_, "url");
	baseURL = _tmp26_;
	_tmp27_ = baseURL;
	_tmp28_ = g_strconcat (_tmp27_, "api/entries.json", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = soup_message_new ("POST", _tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	message_soup = _tmp31_;
	_tmp32_ = message_soup;
	_tmp33_ = message;
	_tmp34_ = string_get_data (_tmp33_, &_tmp35_);
	_tmp34__length1 = _tmp35_;
	_tmp36_ = _tmp34_;
	_tmp36__length1 = _tmp34__length1;
	soup_message_set_request (_tmp32_, "application/x-www-form-urlencoded; charset=UTF8", SOUP_MEMORY_COPY, _tmp36_, (gsize) _tmp36__length1);
	_tmp37_ = message_soup;
	_tmp38_ = _tmp37_->request_headers;
	_tmp39_ = settings;
	_tmp40_ = g_settings_get_string (_tmp39_, "oauth-access-token");
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat ("Bearer ", _tmp41_, NULL);
	_tmp43_ = _tmp42_;
	soup_message_headers_append (_tmp38_, "Authorization", _tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_tmp44_ = session;
	_tmp45_ = message_soup;
	soup_session_send_message (_tmp44_, _tmp45_);
	_tmp47_ = message_soup;
	_tmp48_ = _tmp47_->response_body;
	_tmp49_ = soup_message_body_flatten (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = _tmp50_->data;
	_tmp51__length1 = _tmp50_->length;
	_tmp52_ = ((const gchar*) _tmp51_) == NULL;
	__vala_SoupBuffer_free0 (_tmp50_);
	if (_tmp52_) {
		_tmp46_ = TRUE;
	} else {
		SoupMessage* _tmp53_;
		SoupMessageBody* _tmp54_;
		SoupBuffer* _tmp55_;
		SoupBuffer* _tmp56_;
		guint8* _tmp57_;
		gint _tmp57__length1;
		_tmp53_ = message_soup;
		_tmp54_ = _tmp53_->response_body;
		_tmp55_ = soup_message_body_flatten (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _tmp56_->data;
		_tmp57__length1 = _tmp56_->length;
		_tmp46_ = g_strcmp0 ((const gchar*) _tmp57_, "") == 0;
		__vala_SoupBuffer_free0 (_tmp56_);
	}
	if (_tmp46_) {
		const gchar* _tmp58_;
		feed_reader_logger_error ("WallabagAPI - addBookmark: no response");
		feed_reader_logger_error (url);
		_tmp58_ = message;
		feed_reader_logger_error (_tmp58_);
		result = FALSE;
		_g_object_unref0 (message_soup);
		_g_free0 (baseURL);
		_g_free0 (message);
		_g_object_unref0 (session);
		_g_object_unref0 (settings);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (message_soup);
	_g_free0 (baseURL);
	_g_free0 (message);
	_g_object_unref0 (session);
	_g_object_unref0 (settings);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
feed_reader_wallabag_api_real_logout (FeedReaderShareAccountInterface* base,
                                      const gchar* id)
{
	FeedReaderWallabagAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar** keys = NULL;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** array = NULL;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gint array_length1;
	gint _array_size_;
	gchar** array2 = NULL;
	gchar** _tmp16_;
	gint array2_length1;
	gint _array2_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gboolean result;
	self = (FeedReaderWallabagAPI*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	feed_reader_logger_debug ("WallabagAPI - logout");
	feed_reader_wallabag_api_deletePassword (self, id);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/wallabag/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = settings;
	_tmp6_ = _tmp5_ = g_settings_list_keys (_tmp4_);
	keys = _tmp6_;
	keys_length1 = _vala_array_length (_tmp5_);
	_keys_size_ = keys_length1;
	_tmp7_ = keys;
	_tmp7__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp7_;
		key_collection_length1 = _tmp7__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp8_;
			gchar* key = NULL;
			_tmp8_ = g_strdup (key_collection[key_it]);
			key = _tmp8_;
			{
				GSettings* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = settings;
				_tmp10_ = key;
				g_settings_reset (_tmp9_, _tmp10_);
				_g_free0 (key);
			}
		}
	}
	_tmp11_ = feed_reader_settings_share ("wallabag");
	_tmp12_ = _tmp11_;
	_tmp14_ = _tmp13_ = g_settings_get_strv (_tmp12_, "account-ids");
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _vala_array_length (_tmp13_);
	_g_object_unref0 (_tmp12_);
	array = _tmp15_;
	array_length1 = _tmp15__length1;
	_array_size_ = array_length1;
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	array2 = _tmp16_;
	array2_length1 = 0;
	_array2_size_ = array2_length1;
	_tmp17_ = array;
	_tmp17__length1 = array_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp17_;
		i_collection_length1 = _tmp17__length1;
		for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
			gchar* _tmp18_;
			gchar* i = NULL;
			_tmp18_ = g_strdup (i_collection[i_it]);
			i = _tmp18_;
			{
				const gchar* _tmp19_;
				_tmp19_ = i;
				if (g_strcmp0 (_tmp19_, id) != 0) {
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = i;
					_tmp21_ = g_strdup (_tmp20_);
					_vala_array_add2 (&array2, &array2_length1, &_array2_size_, _tmp21_);
				}
				_g_free0 (i);
			}
		}
	}
	_tmp22_ = feed_reader_settings_share ("wallabag");
	_tmp23_ = _tmp22_;
	_tmp24_ = array2;
	_tmp24__length1 = array2_length1;
	g_settings_set_strv (_tmp23_, "account-ids", _tmp24_);
	_g_object_unref0 (_tmp23_);
	g_signal_emit_by_name ((FeedReaderShareAccountInterface*) self, "delete-account", id);
	result = TRUE;
	array2 = (_vala_array_free (array2, array2_length1, (GDestroyNotify) g_free), NULL);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return result;
}

static gboolean
feed_reader_wallabag_api_accessTokenValid (FeedReaderWallabagAPI* self,
                                           const gchar* id)
{
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GDateTime* now = NULL;
	GDateTime* _tmp4_;
	gint expires = 0;
	GSettings* _tmp5_;
	GDateTime* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/wallabag/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = g_date_time_new_now_local ();
	now = _tmp4_;
	_tmp5_ = settings;
	expires = g_settings_get_int (_tmp5_, "access-token-expires");
	_tmp6_ = now;
	if (((gint) g_date_time_to_unix (_tmp6_)) > expires) {
		feed_reader_logger_warning ("WallabagAPI: access token expired");
		result = FALSE;
		_g_date_time_unref0 (now);
		_g_object_unref0 (settings);
		return result;
	}
	result = TRUE;
	_g_date_time_unref0 (now);
	_g_object_unref0 (settings);
	return result;
}

static gchar*
feed_reader_wallabag_api_real_getIconName (FeedReaderShareAccountInterface* base)
{
	FeedReaderWallabagAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderWallabagAPI*) base;
	_tmp0_ = g_strdup ("feed-share-wallabag");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_wallabag_api_real_getUsername (FeedReaderShareAccountInterface* base,
                                           const gchar* id)
{
	FeedReaderWallabagAPI * self;
	GSettings* settings = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (FeedReaderWallabagAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/org/gnome/feedreader/share/wallabag/%s/", id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path ("org.gnome.feedreader.share.account", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	settings = _tmp3_;
	_tmp4_ = g_settings_get_string (settings, "username");
	result = _tmp4_;
	_g_object_unref0 (settings);
	return result;
}

gchar*
feed_reader_wallabag_api_getPasswd (FeedReaderWallabagAPI* self,
                                    const gchar* id)
{
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp0_;
	GHashTable* attributes = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* passwd = NULL;
	gchar* _tmp8_;
	const gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = secret_schema_new ("org.gnome.feedreader.wallabag.password", SECRET_SCHEMA_NONE, "username", SECRET_SCHEMA_ATTRIBUTE_STRING, "id", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
	attributes = _tmp3_;
	_tmp4_ = g_strdup ("username");
	_tmp5_ = feed_reader_share_account_interface_getUsername ((FeedReaderShareAccountInterface*) self, id);
	g_hash_table_insert (attributes, _tmp4_, _tmp5_);
	_tmp6_ = g_strdup ("id");
	_tmp7_ = g_strdup (id);
	g_hash_table_insert (attributes, _tmp6_, _tmp7_);
	_tmp8_ = g_strdup ("");
	passwd = _tmp8_;
	{
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = secret_password_lookupv_sync (pwSchema, attributes, NULL, &_inner_error0_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp9_;
		_tmp9_ = NULL;
		_g_free0 (passwd);
		passwd = _tmp11_;
		_g_free0 (_tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		feed_reader_logger_error (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (passwd);
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (pwSchema);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp14_ = passwd;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("");
		result = _tmp15_;
		_g_free0 (passwd);
		_g_hash_table_unref0 (attributes);
		_secret_schema_unref0 (pwSchema);
		return result;
	}
	result = passwd;
	_g_hash_table_unref0 (attributes);
	_secret_schema_unref0 (pwSchema);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FeedReaderWallabagAPI* self;
		self = _data1_->self;
		_g_free0 (_data1_->id);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda4_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* async_res)
{
	FeedReaderWallabagAPI* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (async_res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = secret_password_clear_finish (async_res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data1_->removed = _tmp0_;
		if (!_data1_->removed) {
			const gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = string_to_string (_data1_->id);
			_tmp2_ = g_strconcat ("WallabagAPI: could not delete password of account ", _tmp1_, NULL);
			_tmp3_ = _tmp2_;
			feed_reader_logger_error (_tmp3_);
			_g_free0 (_tmp3_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strdup_printf ("WallabagAPI.deletePassword: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		feed_reader_logger_error (_tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static void
feed_reader_wallabag_api_deletePassword (FeedReaderWallabagAPI* self,
                                         const gchar* id)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	SecretSchema* pwSchema = NULL;
	SecretSchema* _tmp1_;
	GHashTable* attributes = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GHashTable* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (id);
	_g_free0 (_data1_->id);
	_data1_->id = _tmp0_;
	_data1_->removed = FALSE;
	_tmp1_ = secret_schema_new ("org.gnome.feedreader.wallabag.password", SECRET_SCHEMA_NONE, "username", SECRET_SCHEMA_ATTRIBUTE_STRING, "id", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	pwSchema = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
	attributes = _tmp4_;
	_tmp5_ = g_strdup ("username");
	_tmp6_ = feed_reader_share_account_interface_getUsername ((FeedReaderShareAccountInterface*) self, _data1_->id);
	g_hash_table_insert (attributes, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("id");
	_tmp8_ = g_strdup (_data1_->id);
	g_hash_table_insert (attributes, _tmp7_, _tmp8_);
	_tmp9_ = feed_reader_share_account_interface_getUsername ((FeedReaderShareAccountInterface*) self, _data1_->id);
	_tmp10_ = _tmp9_;
	feed_reader_logger_debug (_tmp10_);
	_g_free0 (_tmp10_);
	feed_reader_logger_debug (_data1_->id);
	_tmp11_ = _g_hash_table_ref0 (attributes);
	secret_password_clearv (pwSchema, _tmp11_, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	_g_hash_table_unref0 (attributes);
	_secret_schema_unref0 (pwSchema);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gboolean
feed_reader_wallabag_api_real_needSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderWallabagAPI * self;
	gboolean result;
	self = (FeedReaderWallabagAPI*) base;
	result = TRUE;
	return result;
}

static gboolean
feed_reader_wallabag_api_real_singleInstance (FeedReaderShareAccountInterface* base)
{
	FeedReaderWallabagAPI * self;
	gboolean result;
	self = (FeedReaderWallabagAPI*) base;
	result = FALSE;
	return result;
}

static gboolean
feed_reader_wallabag_api_real_useSystemAccounts (FeedReaderShareAccountInterface* base)
{
	FeedReaderWallabagAPI * self;
	gboolean result;
	self = (FeedReaderWallabagAPI*) base;
	result = FALSE;
	return result;
}

static gchar*
feed_reader_wallabag_api_real_pluginID (FeedReaderShareAccountInterface* base)
{
	FeedReaderWallabagAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderWallabagAPI*) base;
	_tmp0_ = g_strdup ("wallabag");
	result = _tmp0_;
	return result;
}

static gchar*
feed_reader_wallabag_api_real_pluginName (FeedReaderShareAccountInterface* base)
{
	FeedReaderWallabagAPI * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FeedReaderWallabagAPI*) base;
	_tmp0_ = g_strdup ("wallabag");
	result = _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_wallabag_api_real_newSetup_withID (FeedReaderShareAccountInterface* base,
                                               const gchar* id,
                                               const gchar* username)
{
	FeedReaderWallabagAPI * self;
	FeedReaderWallabagSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderWallabagAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = feed_reader_wallabag_setup_new (id, self, username);
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_wallabag_api_real_newSetup (FeedReaderShareAccountInterface* base)
{
	FeedReaderWallabagAPI * self;
	FeedReaderWallabagSetup* _tmp0_;
	FeedReaderServiceSetup* result;
	self = (FeedReaderWallabagAPI*) base;
	_tmp0_ = feed_reader_wallabag_setup_new (NULL, self, "");
	g_object_ref_sink (_tmp0_);
	result = (FeedReaderServiceSetup*) _tmp0_;
	return result;
}

static FeedReaderServiceSetup*
feed_reader_wallabag_api_real_newSystemAccount (FeedReaderShareAccountInterface* base,
                                                const gchar* id,
                                                const gchar* username)
{
	FeedReaderWallabagAPI * self;
	FeedReaderServiceSetup* result;
	self = (FeedReaderWallabagAPI*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	result = NULL;
	return result;
}

static FeedReaderShareForm*
feed_reader_wallabag_api_real_shareWidget (FeedReaderShareAccountInterface* base,
                                           const gchar* url)
{
	FeedReaderWallabagAPI * self;
	FeedReaderShareForm* result;
	self = (FeedReaderWallabagAPI*) base;
	g_return_val_if_fail (url != NULL, NULL);
	result = NULL;
	return result;
}

static void
feed_reader_wallabag_api_class_init (FeedReaderWallabagAPIClass * klass,
                                     gpointer klass_data)
{
	feed_reader_wallabag_api_parent_class = g_type_class_peek_parent (klass);
}

static void
feed_reader_wallabag_api_feed_reader_share_account_interface_interface_init (FeedReaderShareAccountInterfaceIface * iface,
                                                                             gpointer iface_data)
{
	feed_reader_wallabag_api_feed_reader_share_account_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->setupSystemAccounts = (void (*) (FeedReaderShareAccountInterface*, GeeList*)) feed_reader_wallabag_api_real_setupSystemAccounts;
	iface->addBookmark = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*, gboolean)) feed_reader_wallabag_api_real_addBookmark;
	iface->logout = (gboolean (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_wallabag_api_real_logout;
	iface->getIconName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_wallabag_api_real_getIconName;
	iface->getUsername = (gchar* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_wallabag_api_real_getUsername;
	iface->needSetup = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_wallabag_api_real_needSetup;
	iface->singleInstance = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_wallabag_api_real_singleInstance;
	iface->useSystemAccounts = (gboolean (*) (FeedReaderShareAccountInterface*)) feed_reader_wallabag_api_real_useSystemAccounts;
	iface->pluginID = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_wallabag_api_real_pluginID;
	iface->pluginName = (gchar* (*) (FeedReaderShareAccountInterface*)) feed_reader_wallabag_api_real_pluginName;
	iface->newSetup_withID = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_wallabag_api_real_newSetup_withID;
	iface->newSetup = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*)) feed_reader_wallabag_api_real_newSetup;
	iface->newSystemAccount = (FeedReaderServiceSetup* (*) (FeedReaderShareAccountInterface*, const gchar*, const gchar*)) feed_reader_wallabag_api_real_newSystemAccount;
	iface->shareWidget = (FeedReaderShareForm* (*) (FeedReaderShareAccountInterface*, const gchar*)) feed_reader_wallabag_api_real_shareWidget;
}

static void
feed_reader_wallabag_api_instance_init (FeedReaderWallabagAPI * self,
                                        gpointer klass)
{
}

GType
feed_reader_wallabag_api_get_type (void)
{
	return feed_reader_wallabag_api_type_id;
}

GType
feed_reader_wallabag_api_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FeedReaderWallabagAPIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) feed_reader_wallabag_api_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FeedReaderWallabagAPI), 0, (GInstanceInitFunc) feed_reader_wallabag_api_instance_init, NULL };
	static const GInterfaceInfo feed_reader_share_account_interface_info = { (GInterfaceInitFunc) feed_reader_wallabag_api_feed_reader_share_account_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	feed_reader_wallabag_api_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "FeedReaderWallabagAPI", &g_define_type_info, 0);
	g_type_module_add_interface (module, feed_reader_wallabag_api_type_id, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, &feed_reader_share_account_interface_info);
	return feed_reader_wallabag_api_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	feed_reader_wallabag_api_register_type (module);
	feed_reader_wallabag_setup_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, FEED_READER_TYPE_SHARE_ACCOUNT_INTERFACE, FEED_READER_TYPE_WALLABAG_API);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

