// This file was automatically generated by mksyscall.awk

package syscall

import "unsafe"

// Automatically generated wrapper for pipe/pipe
//extern pipe
func c_pipe(p *[2]_C_int) _C_int
func pipe(p *[2]_C_int) (err error) {
	_r := c_pipe(p)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for utimes/utimes
//extern utimes
func c_utimes(path *byte, times *[2]Timeval) _C_int
func utimes(path string, times *[2]Timeval) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_utimes(_p1, times)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for getcwd/getcwd
//extern getcwd
func c_getcwd(buf *byte, size Size_t) *byte
func getcwd(buf *byte, size Size_t) (err error) {
	Entersyscall()
	_r := c_getcwd(buf, Size_t(size))
	var errno Errno
	setErrno := false
	if _r == nil {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for getgroups/getgroups
//extern getgroups
func c_getgroups(size _C_int, list *Gid_t) _C_int
func getgroups(size int, list *Gid_t) (nn int, err error) {
	_r := c_getgroups(_C_int(size), list)
	nn = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for setgroups/setgroups
//extern setgroups
func c_setgroups(n Size_t, list *Gid_t) _C_int
func setgroups(n int, list *Gid_t) (err error) {
	_r := c_setgroups(Size_t(n), list)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mkfifo/mkfifo
//extern mkfifo
func c_mkfifo(path *byte, mode Mode_t) _C_int
func Mkfifo(path string, mode uint32) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_mkfifo(_p1, Mode_t(mode))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Select/select
//extern select
func c_select(nfd _C_int, r *FdSet, w *FdSet, e *FdSet, timeout *Timeval) _C_int
func Select(nfd int, r *FdSet, w *FdSet, e *FdSet, timeout *Timeval) (n int, err error) {
	Entersyscall()
	_r := c_select(_C_int(nfd), r, w, e, timeout)
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Access/access
//extern access
func c_access(path *byte, mode _C_int) _C_int
func Access(path string, mode uint32) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_access(_p1, _C_int(mode))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Chdir/chdir
//extern chdir
func c_chdir(path *byte) _C_int
func Chdir(path string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_chdir(_p1)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Chmod/chmod
//extern chmod
func c_chmod(path *byte, mode Mode_t) _C_int
func Chmod(path string, mode uint32) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_chmod(_p1, Mode_t(mode))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Chown/chown
//extern chown
func c_chown(path *byte, uid Uid_t, gid Gid_t) _C_int
func Chown(path string, uid int, gid int) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_chown(_p1, Uid_t(uid), Gid_t(gid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Chroot/chroot
//extern chroot
func c_chroot(path *byte) _C_int
func Chroot(path string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_chroot(_p1)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Close/close
//extern close
func c_close(fd _C_int) _C_int
func Close(fd int) (err error) {
	Entersyscall()
	_r := c_close(_C_int(fd))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Creat/creat
//extern creat
func c_creat(path *byte, mode Mode_t) _C_int
func Creat(path string, mode uint32) (fd int, err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_creat(_p1, Mode_t(mode))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Dup/dup
//extern dup
func c_dup(oldfd _C_int) _C_int
func Dup(oldfd int) (fd int, err error) {
	_r := c_dup(_C_int(oldfd))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Dup2/dup2
//extern dup2
func c_dup2(oldfd _C_int, newfd _C_int) _C_int
func Dup2(oldfd int, newfd int) (err error) {
	_r := c_dup2(_C_int(oldfd), _C_int(newfd))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Exit/exit
//extern exit
func c_exit(code _C_int) 
func Exit(code int) {
	Entersyscall()
	c_exit(_C_int(code))
	Exitsyscall()
}

// Automatically generated wrapper for Fchdir/fchdir
//extern fchdir
func c_fchdir(fd _C_int) _C_int
func Fchdir(fd int) (err error) {
	Entersyscall()
	_r := c_fchdir(_C_int(fd))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fchmod/fchmod
//extern fchmod
func c_fchmod(fd _C_int, mode Mode_t) _C_int
func Fchmod(fd int, mode uint32) (err error) {
	Entersyscall()
	_r := c_fchmod(_C_int(fd), Mode_t(mode))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fchown/fchown
//extern fchown
func c_fchown(fd _C_int, uid Uid_t, gid Gid_t) _C_int
func Fchown(fd int, uid int, gid int) (err error) {
	Entersyscall()
	_r := c_fchown(_C_int(fd), Uid_t(uid), Gid_t(gid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for fcntl/__go_fcntl
//extern __go_fcntl
func c___go_fcntl(fd _C_int, cmd _C_int, arg _C_int) _C_int
func fcntl(fd int, cmd int, arg int) (val int, err error) {
	Entersyscall()
	_r := c___go_fcntl(_C_int(fd), _C_int(cmd), _C_int(arg))
	val = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fdatasync/fdatasync
//extern fdatasync
func c_fdatasync(fd _C_int) _C_int
func Fdatasync(fd int) (err error) {
	Entersyscall()
	_r := c_fdatasync(_C_int(fd))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fsync/fsync
//extern fsync
func c_fsync(fd _C_int) _C_int
func Fsync(fd int) (err error) {
	Entersyscall()
	_r := c_fsync(_C_int(fd))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Getegid/getegid
//extern getegid
func c_getegid() Gid_t
func Getegid() (egid int) {
	_r := c_getegid()
	egid = (int)(_r)
	return
}

// Automatically generated wrapper for Geteuid/geteuid
//extern geteuid
func c_geteuid() Uid_t
func Geteuid() (euid int) {
	_r := c_geteuid()
	euid = (int)(_r)
	return
}

// Automatically generated wrapper for Getgid/getgid
//extern getgid
func c_getgid() Gid_t
func Getgid() (gid int) {
	_r := c_getgid()
	gid = (int)(_r)
	return
}

// Automatically generated wrapper for Getpagesize/getpagesize
//extern getpagesize
func c_getpagesize() _C_int
func Getpagesize() (pagesize int) {
	_r := c_getpagesize()
	pagesize = (int)(_r)
	return
}

// Automatically generated wrapper for Getpgid/getpgid
//extern getpgid
func c_getpgid(pid Pid_t) Pid_t
func Getpgid(pid int) (pgid int, err error) {
	_r := c_getpgid(Pid_t(pid))
	pgid = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Getpgrp/getpgrp
//extern getpgrp
func c_getpgrp() Pid_t
func Getpgrp() (pid int) {
	_r := c_getpgrp()
	pid = (int)(_r)
	return
}

// Automatically generated wrapper for Getpid/getpid
//extern getpid
func c_getpid() Pid_t
func Getpid() (pid int) {
	_r := c_getpid()
	pid = (int)(_r)
	return
}

// Automatically generated wrapper for Getppid/getppid
//extern getppid
func c_getppid() Pid_t
func Getppid() (ppid int) {
	_r := c_getppid()
	ppid = (int)(_r)
	return
}

// Automatically generated wrapper for Getpriority/getpriority
//extern getpriority
func c_getpriority(which _C_int, who _C_int) _C_int
func Getpriority(which int, who int) (prio int, err error) {
	Entersyscall()
	_r := c_getpriority(_C_int(which), _C_int(who))
	prio = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Getrlimit/getrlimit
//extern getrlimit
func c_getrlimit(resource _C_int, rlim *Rlimit) _C_int
func Getrlimit(resource int, rlim *Rlimit) (err error) {
	_r := c_getrlimit(_C_int(resource), rlim)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Getrusage/getrusage
//extern getrusage
func c_getrusage(who _C_int, rusage *Rusage) _C_int
func Getrusage(who int, rusage *Rusage) (err error) {
	_r := c_getrusage(_C_int(who), rusage)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for gettimeofday/gettimeofday
//extern gettimeofday
func c_gettimeofday(tv *Timeval, tz *byte) _C_int
func gettimeofday(tv *Timeval, tz *byte) (err error) {
	_r := c_gettimeofday(tv, tz)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Getuid/getuid
//extern getuid
func c_getuid() Uid_t
func Getuid() (uid int) {
	_r := c_getuid()
	uid = (int)(_r)
	return
}

// Automatically generated wrapper for Kill/kill
//extern kill
func c_kill(pid Pid_t, sig _C_int) _C_int
func Kill(pid int, sig Signal) (err error) {
	_r := c_kill(Pid_t(pid), _C_int(sig))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Lchown/lchown
//extern lchown
func c_lchown(path *byte, uid Uid_t, gid Gid_t) _C_int
func Lchown(path string, uid int, gid int) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_lchown(_p1, Uid_t(uid), Gid_t(gid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Link/link
//extern link
func c_link(oldpath *byte, newpath *byte) _C_int
func Link(oldpath string, newpath string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(oldpath)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(newpath)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_link(_p1, _p2)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mkdir/mkdir
//extern mkdir
func c_mkdir(path *byte, mode Mode_t) _C_int
func Mkdir(path string, mode uint32) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_mkdir(_p1, Mode_t(mode))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mknod/mknod
//extern mknod
func c_mknod(path *byte, mode Mode_t, dev _dev_t) _C_int
func Mknod(path string, mode uint32, dev int) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_mknod(_p1, Mode_t(mode), _dev_t(dev))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mount/mount
//extern mount
func c_mount(source *byte, target *byte, fstype *byte, flags _C_long, data *byte) _C_int
func Mount(source string, target string, fstype string, flags uintptr, data string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(source)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(target)
	if err != nil {
		return
	}
	var _p3 *byte
	_p3, err = BytePtrFromString(fstype)
	if err != nil {
		return
	}
	var _p5 *byte
	_p5, err = BytePtrFromString(data)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_mount(_p1, _p2, _p3, _C_long(flags), _p5)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Nanosleep/nanosleep
//extern nanosleep
func c_nanosleep(time *Timespec, leftover *Timespec) _C_int
func Nanosleep(time *Timespec, leftover *Timespec) (err error) {
	Entersyscall()
	_r := c_nanosleep(time, leftover)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Pause/pause
//extern pause
func c_pause() _C_int
func Pause() (err error) {
	Entersyscall()
	_r := c_pause()
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for read/read
//extern read
func c_read(fd _C_int, buf *byte, count Size_t) Ssize_t
func read(fd int, p []byte) (n int, err error) {
	var _p2 *byte
	if len(p) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&p[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_read(_C_int(fd), _p2, Size_t(len(p)))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for readlen/read
//extern read
func c_read(fd _C_int, buf *byte, count Size_t) Ssize_t
func readlen(fd int, p *byte, np int) (n int, err error) {
	Entersyscall()
	_r := c_read(_C_int(fd), p, Size_t(np))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Readlink/readlink
//extern readlink
func c_readlink(path *byte, buf *byte, bufsiz Size_t) Ssize_t
func Readlink(path string, buf []byte) (n int, err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	var _p2 *byte
	if len(buf) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&buf[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_readlink(_p1, _p2, Size_t(len(buf)))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Rename/rename
//extern rename
func c_rename(oldpath *byte, newpath *byte) _C_int
func Rename(oldpath string, newpath string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(oldpath)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(newpath)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_rename(_p1, _p2)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Rmdir/rmdir
//extern rmdir
func c_rmdir(path *byte) _C_int
func Rmdir(path string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_rmdir(_p1)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setdomainname/setdomainname
//extern setdomainname
func c_setdomainname(name *byte, len Size_t) _C_int
func Setdomainname(p []byte) (err error) {
	var _p1 *byte
	if len(p) > 0 {
		_p1 = (*byte)(unsafe.Pointer(&p[0]))
	} else {
		_p1 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_setdomainname(_p1, Size_t(len(p)))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Sethostname/sethostname
//extern sethostname
func c_sethostname(name *byte, len Size_t) _C_int
func Sethostname(p []byte) (err error) {
	var _p1 *byte
	if len(p) > 0 {
		_p1 = (*byte)(unsafe.Pointer(&p[0]))
	} else {
		_p1 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_sethostname(_p1, Size_t(len(p)))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setgid/setgid
//extern setgid
func c_setgid(gid Gid_t) _C_int
func Setgid(gid int) (err error) {
	_r := c_setgid(Gid_t(gid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setregid/setregid
//extern setregid
func c_setregid(rgid Gid_t, egid Gid_t) _C_int
func Setregid(rgid int, egid int) (err error) {
	_r := c_setregid(Gid_t(rgid), Gid_t(egid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setpgid/setpgid
//extern setpgid
func c_setpgid(pid Pid_t, pgid Pid_t) _C_int
func Setpgid(pid int, pgid int) (err error) {
	_r := c_setpgid(Pid_t(pid), Pid_t(pgid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setpriority/setpriority
//extern setpriority
func c_setpriority(which _C_int, who _C_int, prio _C_int) _C_int
func Setpriority(which int, who int, prio int) (err error) {
	Entersyscall()
	_r := c_setpriority(_C_int(which), _C_int(who), _C_int(prio))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setreuid/setreuid
//extern setreuid
func c_setreuid(ruid Uid_t, euid Uid_t) _C_int
func Setreuid(ruid int, euid int) (err error) {
	_r := c_setreuid(Uid_t(ruid), Uid_t(euid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setrlimit/setrlimit
//extern setrlimit
func c_setrlimit(resource int, rlim *Rlimit) _C_int
func Setrlimit(resource int, rlim *Rlimit) (err error) {
	_r := c_setrlimit(int(resource), rlim)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setsid/setsid
//extern setsid
func c_setsid() Pid_t
func Setsid() (pid int, err error) {
	_r := c_setsid()
	pid = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for settimeofday/settimeofday
//extern settimeofday
func c_settimeofday(tv *Timeval, tz *byte) _C_int
func settimeofday(tv *Timeval, tz *byte) (err error) {
	_r := c_settimeofday(tv, tz)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setuid/setuid
//extern setuid
func c_setuid(uid Uid_t) _C_int
func Setuid(uid int) (err error) {
	_r := c_setuid(Uid_t(uid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Symlink/symlink
//extern symlink
func c_symlink(oldpath *byte, newpath *byte) _C_int
func Symlink(oldpath string, newpath string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(oldpath)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(newpath)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_symlink(_p1, _p2)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Sync/sync
//extern sync
func c_sync() 
func Sync() {
	Entersyscall()
	c_sync()
	Exitsyscall()
}

// Automatically generated wrapper for Time/time
//extern time
func c_time(t *Time_t) Time_t
func Time(t *Time_t) (tt Time_t, err error) {
	_r := c_time(t)
	tt = (Time_t)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Times/times
//extern times
func c_times(tms *Tms) _clock_t
func Times(tms *Tms) (ticks uintptr, err error) {
	_r := c_times(tms)
	ticks = (uintptr)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Umask/umask
//extern umask
func c_umask(mask Mode_t) Mode_t
func Umask(mask int) (oldmask int) {
	_r := c_umask(Mode_t(mask))
	oldmask = (int)(_r)
	return
}

// Automatically generated wrapper for Unlink/unlink
//extern unlink
func c_unlink(path *byte) _C_int
func Unlink(path string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_unlink(_p1)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Utime/utime
//extern utime
func c_utime(path *byte, buf *Utimbuf) _C_int
func Utime(path string, buf *Utimbuf) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_utime(_p1, buf)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for write/write
//extern write
func c_write(fd _C_int, buf *byte, count Size_t) Ssize_t
func write(fd int, p []byte) (n int, err error) {
	var _p2 *byte
	if len(p) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&p[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_write(_C_int(fd), _p2, Size_t(len(p)))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for writelen/write
//extern write
func c_write(fd _C_int, buf *byte, count Size_t) Ssize_t
func writelen(fd int, p *byte, np int) (n int, err error) {
	Entersyscall()
	_r := c_write(_C_int(fd), p, Size_t(np))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for munmap/munmap
//extern munmap
func c_munmap(addr *byte, length Size_t) _C_int
func munmap(addr uintptr, length uintptr) (err error) {
	Entersyscall()
	_r := c_munmap((*byte)(unsafe.Pointer(addr)), Size_t(length))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Madvise/madvise
//extern madvise
func c_madvise(addr *byte, len Size_t, advice _C_int) _C_int
func Madvise(b []byte, advice int) (err error) {
	var _p1 *byte
	if len(b) > 0 {
		_p1 = (*byte)(unsafe.Pointer(&b[0]))
	} else {
		_p1 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_madvise(_p1, Size_t(len(b)), _C_int(advice))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mprotect/mprotect
//extern mprotect
func c_mprotect(addr *byte, len Size_t, prot _C_int) _C_int
func Mprotect(b []byte, prot int) (err error) {
	var _p1 *byte
	if len(b) > 0 {
		_p1 = (*byte)(unsafe.Pointer(&b[0]))
	} else {
		_p1 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_mprotect(_p1, Size_t(len(b)), _C_int(prot))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mlock/mlock
//extern mlock
func c_mlock(addr *byte, len Size_t) _C_int
func Mlock(b []byte) (err error) {
	var _p1 *byte
	if len(b) > 0 {
		_p1 = (*byte)(unsafe.Pointer(&b[0]))
	} else {
		_p1 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_mlock(_p1, Size_t(len(b)))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Munlock/munlock
//extern munlock
func c_munlock(addr *byte, len Size_t) _C_int
func Munlock(b []byte) (err error) {
	var _p1 *byte
	if len(b) > 0 {
		_p1 = (*byte)(unsafe.Pointer(&b[0]))
	} else {
		_p1 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_munlock(_p1, Size_t(len(b)))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mlockall/mlockall
//extern mlockall
func c_mlockall(flags _C_int) _C_int
func Mlockall(flags int) (err error) {
	Entersyscall()
	_r := c_mlockall(_C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Munlockall/munlockall
//extern munlockall
func c_munlockall() _C_int
func Munlockall() (err error) {
	Entersyscall()
	_r := c_munlockall()
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Tcgetattr/tcgetattr
//extern tcgetattr
func c_tcgetattr(fd _C_int, p *Termios) _C_int
func Tcgetattr(fd int, p *Termios) (err error) {
	_r := c_tcgetattr(_C_int(fd), p)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Tcsetattr/tcsetattr
//extern tcsetattr
func c_tcsetattr(fd _C_int, actions _C_int, p *Termios) _C_int
func Tcsetattr(fd int, actions int, p *Termios) (err error) {
	Entersyscall()
	_r := c_tcsetattr(_C_int(fd), _C_int(actions), p)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for accept/accept
//extern accept
func c_accept(fd _C_int, sa *RawSockaddrAny, len *Socklen_t) _C_int
func accept(fd int, sa *RawSockaddrAny, len *Socklen_t) (nfd int, err error) {
	Entersyscall()
	_r := c_accept(_C_int(fd), sa, len)
	nfd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for getsockname/getsockname
//extern getsockname
func c_getsockname(fd _C_int, sa *RawSockaddrAny, len *Socklen_t) _C_int
func getsockname(fd int, sa *RawSockaddrAny, len *Socklen_t) (err error) {
	_r := c_getsockname(_C_int(fd), sa, len)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for getpeername/getpeername
//extern getpeername
func c_getpeername(fd _C_int, sa *RawSockaddrAny, len *Socklen_t) _C_int
func getpeername(fd int, sa *RawSockaddrAny, len *Socklen_t) (err error) {
	_r := c_getpeername(_C_int(fd), sa, len)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for setsockopt/setsockopt
//extern setsockopt
func c_setsockopt(s _C_int, level _C_int, optname _C_int, val *byte, vallen Socklen_t) _C_int
func setsockopt(s int, level int, name int, val *byte, vallen Socklen_t) (err error) {
	Entersyscall()
	_r := c_setsockopt(_C_int(s), _C_int(level), _C_int(name), val, Socklen_t(vallen))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for recvfrom/recvfrom
//extern recvfrom
func c_recvfrom(fd _C_int, buf *byte, len Size_t, flags _C_int, from *RawSockaddrAny, fromlen *Socklen_t) Ssize_t
func recvfrom(fd int, p []byte, flags int, from *RawSockaddrAny, fromlen *Socklen_t) (n int, err error) {
	var _p2 *byte
	if len(p) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&p[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_recvfrom(_C_int(fd), _p2, Size_t(len(p)), _C_int(flags), from, fromlen)
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Listen/listen
//extern listen
func c_listen(fd _C_int, n _C_int) _C_int
func Listen(fd int, n int) (err error) {
	Entersyscall()
	_r := c_listen(_C_int(fd), _C_int(n))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Shutdown/shutdown
//extern shutdown
func c_shutdown(fd _C_int, how _C_int) _C_int
func Shutdown(fd int, how int) (err error) {
	Entersyscall()
	_r := c_shutdown(_C_int(fd), _C_int(how))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_fork/fork
//extern fork
func c_fork() Pid_t
func raw_fork() (pid Pid_t, err Errno) {
	_r := c_fork()
	pid = (Pid_t)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_setsid/setsid
//extern setsid
func c_setsid() Pid_t
func raw_setsid() (err Errno) {
	_r := c_setsid()
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_setpgid/setpgid
//extern setpgid
func c_setpgid(pid Pid_t, pgid Pid_t) _C_int
func raw_setpgid(pid int, pgid int) (err Errno) {
	_r := c_setpgid(Pid_t(pid), Pid_t(pgid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_chroot/chroot
//extern chroot
func c_chroot(path *byte) _C_int
func raw_chroot(path *byte) (err Errno) {
	_r := c_chroot(path)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_chdir/chdir
//extern chdir
func c_chdir(path *byte) _C_int
func raw_chdir(path *byte) (err Errno) {
	_r := c_chdir(path)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_fcntl/__go_fcntl
//extern __go_fcntl
func c___go_fcntl(fd _C_int, cmd _C_int, arg _C_int) _C_int
func raw_fcntl(fd int, cmd int, arg int) (val int, err Errno) {
	_r := c___go_fcntl(_C_int(fd), _C_int(cmd), _C_int(arg))
	val = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_close/close
//extern close
func c_close(fd _C_int) _C_int
func raw_close(fd int) (err Errno) {
	_r := c_close(_C_int(fd))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_ioctl/ioctl
//extern ioctl
func c_ioctl(fd _C_int, cmd _C_int, val _C_int) _C_int
func raw_ioctl(fd int, cmd int, val int) (rval int, err Errno) {
	_r := c_ioctl(_C_int(fd), _C_int(cmd), _C_int(val))
	rval = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_execve/execve
//extern execve
func c_execve(argv0 *byte, argv **byte, envv **byte) _C_int
func raw_execve(argv0 *byte, argv **byte, envv **byte) (err Errno) {
	_r := c_execve(argv0, argv, envv)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_write/write
//extern write
func c_write(fd _C_int, buf *byte, count Size_t) Ssize_t
func raw_write(fd int, buf *byte, count int) (err Errno) {
	_r := c_write(_C_int(fd), buf, Size_t(count))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_exit/_exit
//extern _exit
func c__exit(status _C_int) 
func raw_exit(status int) {
	c__exit(_C_int(status))
}

// Automatically generated wrapper for raw_dup2/dup2
//extern dup2
func c_dup2(oldfd _C_int, newfd _C_int) _C_int
func raw_dup2(oldfd int, newfd int) (err Errno) {
	_r := c_dup2(_C_int(oldfd), _C_int(newfd))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_prctl/prctl
//extern prctl
func c_prctl(option _C_int, arg2 _C_long, arg3 _C_long, arg4 _C_long, arg5 _C_long) _C_int
func raw_prctl(option int, arg2 int, arg3 int, arg4 int, arg5 int) (ret int, err Errno) {
	_r := c_prctl(_C_int(option), _C_long(arg2), _C_long(arg3), _C_long(arg4), _C_long(arg5))
	ret = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for wait4/wait4
//extern wait4
func c_wait4(pid Pid_t, status *_C_int, options _C_int, rusage *Rusage) Pid_t
func wait4(pid Pid_t, status *_C_int, options int, rusage *Rusage) (wpid Pid_t, err error) {
	Entersyscall()
	_r := c_wait4(Pid_t(pid), status, _C_int(options), rusage)
	wpid = (Pid_t)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for strerror_r/strerror_r
//extern strerror_r
func c_strerror_r(errnum _C_int, b *byte, len Size_t) *byte
func strerror_r(errnum int, b []byte) (errstr *byte) {
	var _p2 *byte
	if len(b) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&b[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	_r := c_strerror_r(_C_int(errnum), _p2, Size_t(len(b)))
	errstr = (*byte)(_r)
	return
}

// Automatically generated wrapper for Fstat/fstat64
//extern fstat64
func c_fstat64(fd _C_int, stat *Stat_t) _C_int
func Fstat(fd int, stat *Stat_t) (err error) {
	Entersyscall()
	_r := c_fstat64(_C_int(fd), stat)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Ftruncate/ftruncate64
//extern ftruncate64
func c_ftruncate64(fd _C_int, length Offset_t) _C_int
func Ftruncate(fd int, length int64) (err error) {
	Entersyscall()
	_r := c_ftruncate64(_C_int(fd), Offset_t(length))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Lstat/lstat64
//extern lstat64
func c_lstat64(path *byte, stat *Stat_t) _C_int
func Lstat(path string, stat *Stat_t) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_lstat64(_p1, stat)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for mmap/mmap64
//extern mmap64
func c_mmap64(addr *byte, length Size_t, prot _C_int, flags _C_int, fd _C_int, offset Offset_t) *byte
func mmap(addr uintptr, length uintptr, prot int, flags int, fd int, offset int64) (xaddr uintptr, err error) {
	Entersyscall()
	_r := c_mmap64((*byte)(unsafe.Pointer(addr)), Size_t(length), _C_int(prot), _C_int(flags), _C_int(fd), Offset_t(offset))
	xaddr = (uintptr)(unsafe.Pointer(_r))
	var errno Errno
	setErrno := false
	if _r == nil {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Open/__go_open64
//extern __go_open64
func c___go_open64(path *byte, mode _C_int, perm Mode_t) _C_int
func Open(path string, mode int, perm uint32) (fd int, err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c___go_open64(_p1, _C_int(mode), Mode_t(perm))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Pread/pread64
//extern pread64
func c_pread64(fd _C_int, buf *byte, count Size_t, offset Offset_t) Ssize_t
func Pread(fd int, p []byte, offset int64) (n int, err error) {
	var _p2 *byte
	if len(p) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&p[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_pread64(_C_int(fd), _p2, Size_t(len(p)), Offset_t(offset))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Pwrite/pwrite64
//extern pwrite64
func c_pwrite64(fd _C_int, buf *byte, count Size_t, offset Offset_t) Ssize_t
func Pwrite(fd int, p []byte, offset int64) (n int, err error) {
	var _p2 *byte
	if len(p) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&p[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_pwrite64(_C_int(fd), _p2, Size_t(len(p)), Offset_t(offset))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Seek/lseek64
//extern lseek64
func c_lseek64(fd _C_int, offset Offset_t, whence _C_int) Offset_t
func Seek(fd int, offset int64, whence int) (off int64, err error) {
	Entersyscall()
	_r := c_lseek64(_C_int(fd), Offset_t(offset), _C_int(whence))
	off = (int64)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Stat/stat64
//extern stat64
func c_stat64(path *byte, stat *Stat_t) _C_int
func Stat(path string, stat *Stat_t) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_stat64(_p1, stat)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Truncate/truncate64
//extern truncate64
func c_truncate64(path *byte, length Offset_t) _C_int
func Truncate(path string, length int64) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_truncate64(_p1, Offset_t(length))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for EpollCreate/epoll_create
//extern epoll_create
func c_epoll_create(size _C_int) _C_int
func EpollCreate(size int) (fd int, err error) {
	_r := c_epoll_create(_C_int(size))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for EpollCreate1/epoll_create1
//extern epoll_create1
func c_epoll_create1(flags _C_int) _C_int
func EpollCreate1(flags int) (fd int, err error) {
	_r := c_epoll_create1(_C_int(flags))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for EpollCtl/epoll_ctl
//extern epoll_ctl
func c_epoll_ctl(epfd _C_int, op _C_int, fd _C_int, event *EpollEvent) _C_int
func EpollCtl(epfd int, op int, fd int, event *EpollEvent) (err error) {
	_r := c_epoll_ctl(_C_int(epfd), _C_int(op), _C_int(fd), event)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for EpollWait/epoll_wait
//extern epoll_wait
func c_epoll_wait(epfd _C_int, events *EpollEvent, maxevents _C_int, timeout _C_int) _C_int
func EpollWait(epfd int, events []EpollEvent, msec int) (n int, err error) {
	var _p2 *EpollEvent
	if len(events) > 0 {
		_p2 = (*EpollEvent)(unsafe.Pointer(&events[0]))
	} else {
		_p2 = (*EpollEvent)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_epoll_wait(_C_int(epfd), _p2, _C_int(len(events)), _C_int(msec))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for bind/bind
//extern bind
func c_bind(fd _C_int, sa *RawSockaddrAny, len Socklen_t) _C_int
func bind(fd int, sa *RawSockaddrAny, len Socklen_t) (err error) {
	Entersyscall()
	_r := c_bind(_C_int(fd), sa, Socklen_t(len))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for connect/connect
//extern connect
func c_connect(s _C_int, addr *RawSockaddrAny, addrlen Socklen_t) _C_int
func connect(s int, addr *RawSockaddrAny, addrlen Socklen_t) (err error) {
	Entersyscall()
	_r := c_connect(_C_int(s), addr, Socklen_t(addrlen))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for socket/socket
//extern socket
func c_socket(domain _C_int, typ _C_int, protocol _C_int) _C_int
func socket(domain int, typ int, proto int) (fd int, err error) {
	_r := c_socket(_C_int(domain), _C_int(typ), _C_int(proto))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for socketpair/socketpair
//extern socketpair
func c_socketpair(domain _C_int, typ _C_int, protocol _C_int, fd *[2]_C_int) _C_int
func socketpair(domain int, typ int, proto int, fd *[2]_C_int) (err error) {
	_r := c_socketpair(_C_int(domain), _C_int(typ), _C_int(proto), fd)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for getsockopt/getsockopt
//extern getsockopt
func c_getsockopt(s _C_int, level _C_int, name _C_int, val *byte, vallen *Socklen_t) _C_int
func getsockopt(s int, level int, name int, val uintptr, vallen *Socklen_t) (err error) {
	Entersyscall()
	_r := c_getsockopt(_C_int(s), _C_int(level), _C_int(name), (*byte)(unsafe.Pointer(val)), vallen)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for sendto/sendto
//extern sendto
func c_sendto(s _C_int, buf *byte, len Size_t, flags _C_int, to *RawSockaddrAny, tolen Socklen_t) Ssize_t
func sendto(s int, buf []byte, flags int, to *RawSockaddrAny, tolen Socklen_t) (err error) {
	var _p2 *byte
	if len(buf) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&buf[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_sendto(_C_int(s), _p2, Size_t(len(buf)), _C_int(flags), to, Socklen_t(tolen))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for recvmsg/recvmsg
//extern recvmsg
func c_recvmsg(s _C_int, msg *Msghdr, flags _C_int) Ssize_t
func recvmsg(s int, msg *Msghdr, flags int) (n int, err error) {
	Entersyscall()
	_r := c_recvmsg(_C_int(s), msg, _C_int(flags))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for sendmsg/sendmsg
//extern sendmsg
func c_sendmsg(s _C_int, msg *Msghdr, flags _C_int) Ssize_t
func sendmsg(s int, msg *Msghdr, flags int) (err error) {
	Entersyscall()
	_r := c_sendmsg(_C_int(s), msg, _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Uname/uname
//extern uname
func c_uname(buf *Utsname) _C_int
func Uname(buf *Utsname) (err error) {
	_r := c_uname(buf)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for utimensat/utimensat
//extern utimensat
func c_utimensat(dirfd _C_int, path *byte, times *[2]Timespec, flags _C_int) _C_int
func utimensat(dirfd int, path string, times *[2]Timespec, flags int) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_utimensat(_C_int(dirfd), _p2, times, _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Openat/__go_openat
//extern __go_openat
func c___go_openat(dirfd _C_int, path *byte, flags _C_int, mode Mode_t) _C_int
func Openat(dirfd int, path string, flags int, mode uint32) (fd int, err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c___go_openat(_C_int(dirfd), _p2, _C_int(flags), Mode_t(mode))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for futimesat/futimesat
//extern futimesat
func c_futimesat(dirfd _C_int, path *byte, times *[2]Timeval) _C_int
func futimesat(dirfd int, path *byte, times *[2]Timeval) (err error) {
	Entersyscall()
	_r := c_futimesat(_C_int(dirfd), path, times)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for ptrace/ptrace
//extern ptrace
func c_ptrace(request _C_int, pid Pid_t, addr *byte, data *byte) _C_long
func ptrace(request int, pid int, addr uintptr, data uintptr) (err error) {
	Entersyscall()
	_r := c_ptrace(_C_int(request), Pid_t(pid), (*byte)(unsafe.Pointer(addr)), (*byte)(unsafe.Pointer(data)))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for raw_ptrace/ptrace
//extern ptrace
func c_ptrace(request _C_int, pid Pid_t, addr *byte, data *byte) _C_long
func raw_ptrace(request int, pid int, addr *byte, data *byte) (err Errno) {
	_r := c_ptrace(_C_int(request), Pid_t(pid), addr, data)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for reboot/reboot
//extern reboot
func c_reboot(magic1 _C_uint, magic2 _C_uint, cmd _C_int, arg *byte) _C_int
func reboot(magic1 uint, magic2 uint, cmd int, arg string) (err error) {
	var _p4 *byte
	_p4, err = BytePtrFromString(arg)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_reboot(_C_uint(magic1), _C_uint(magic2), _C_int(cmd), _p4)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for accept4/accept4
//extern accept4
func c_accept4(fd _C_int, sa *RawSockaddrAny, len *Socklen_t, flags _C_int) _C_int
func accept4(fd int, sa *RawSockaddrAny, len *Socklen_t, flags int) (nfd int, err error) {
	Entersyscall()
	_r := c_accept4(_C_int(fd), sa, len, _C_int(flags))
	nfd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Acct/acct
//extern acct
func c_acct(path *byte) _C_int
func Acct(path string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_acct(_p1)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Adjtimex/adjtimex
//extern adjtimex
func c_adjtimex(buf *Timex) _C_int
func Adjtimex(buf *Timex) (state int, err error) {
	Entersyscall()
	_r := c_adjtimex(buf)
	state = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Dup3/dup3
//extern dup3
func c_dup3(oldfd _C_int, newfd _C_int, flags _C_int) _C_int
func Dup3(oldfd int, newfd int, flags int) (err error) {
	_r := c_dup3(_C_int(oldfd), _C_int(newfd), _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Faccessat/faccessat
//extern faccessat
func c_faccessat(dirfd _C_int, pathname *byte, mode _C_int, flags _C_int) _C_int
func Faccessat(dirfd int, path string, mode uint32, flags int) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_faccessat(_C_int(dirfd), _p2, _C_int(mode), _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fallocate/fallocate
//extern fallocate
func c_fallocate(fd _C_int, mode _C_int, offset Offset_t, len Offset_t) _C_int
func Fallocate(fd int, mode uint32, off int64, len int64) (err error) {
	Entersyscall()
	_r := c_fallocate(_C_int(fd), _C_int(mode), Offset_t(off), Offset_t(len))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fchmodat/fchmodat
//extern fchmodat
func c_fchmodat(dirfd _C_int, pathname *byte, mode Mode_t, flags _C_int) _C_int
func Fchmodat(dirfd int, path string, mode uint32, flags int) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_fchmodat(_C_int(dirfd), _p2, Mode_t(mode), _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fchownat/fchownat
//extern fchownat
func c_fchownat(dirfd _C_int, path *byte, owner Uid_t, group Gid_t, flags _C_int) _C_int
func Fchownat(dirfd int, path string, uid int, gid int, flags int) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_fchownat(_C_int(dirfd), _p2, Uid_t(uid), Gid_t(gid), _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Flock/flock
//extern flock
func c_flock(fd _C_int, how _C_int) _C_int
func Flock(fd int, how int) (err error) {
	Entersyscall()
	_r := c_flock(_C_int(fd), _C_int(how))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Fstatfs/fstatfs
//extern fstatfs
func c_fstatfs(fd _C_int, buf *Statfs_t) _C_int
func Fstatfs(fd int, buf *Statfs_t) (err error) {
	Entersyscall()
	_r := c_fstatfs(_C_int(fd), buf)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Getxattr/getxattr
//extern getxattr
func c_getxattr(path *byte, attr *byte, buf *byte, count Size_t) Ssize_t
func Getxattr(path string, attr string, dest []byte) (sz int, err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(attr)
	if err != nil {
		return
	}
	var _p3 *byte
	if len(dest) > 0 {
		_p3 = (*byte)(unsafe.Pointer(&dest[0]))
	} else {
		_p3 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_getxattr(_p1, _p2, _p3, Size_t(len(dest)))
	sz = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for InotifyAddWatch/inotify_add_watch
//extern inotify_add_watch
func c_inotify_add_watch(fd _C_int, pathname *byte, mask uint32) _C_int
func InotifyAddWatch(fd int, pathname string, mask uint32) (watchdesc int, err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(pathname)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_inotify_add_watch(_C_int(fd), _p2, uint32(mask))
	watchdesc = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for InotifyInit/inotify_init
//extern inotify_init
func c_inotify_init() _C_int
func InotifyInit() (fd int, err error) {
	_r := c_inotify_init()
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for InotifyInit1/inotify_init1
//extern inotify_init1
func c_inotify_init1(flags _C_int) _C_int
func InotifyInit1(flags int) (fd int, err error) {
	_r := c_inotify_init1(_C_int(flags))
	fd = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for InotifyRmWatch/inotify_rm_watch
//extern inotify_rm_watch
func c_inotify_rm_watch(fd _C_int, wd uint32) _C_int
func InotifyRmWatch(fd int, watchdesc uint32) (success int, err error) {
	_r := c_inotify_rm_watch(_C_int(fd), uint32(watchdesc))
	success = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Klogctl/klogctl
//extern klogctl
func c_klogctl(typ _C_int, bufp *byte, len _C_int) _C_int
func Klogctl(typ int, buf []byte) (n int, err error) {
	var _p2 *byte
	if len(buf) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&buf[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_klogctl(_C_int(typ), _p2, _C_int(len(buf)))
	n = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Listxattr/listxattr
//extern listxattr
func c_listxattr(path *byte, list *byte, size Size_t) Ssize_t
func Listxattr(path string, dest []byte) (sz int, err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	var _p2 *byte
	if len(dest) > 0 {
		_p2 = (*byte)(unsafe.Pointer(&dest[0]))
	} else {
		_p2 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_listxattr(_p1, _p2, Size_t(len(dest)))
	sz = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mkdirat/mkdirat
//extern mkdirat
func c_mkdirat(dirfd _C_int, path *byte, mode Mode_t) _C_int
func Mkdirat(dirfd int, path string, mode uint32) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_mkdirat(_C_int(dirfd), _p2, Mode_t(mode))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Mknodat/mknodat
//extern mknodat
func c_mknodat(dirfd _C_int, path *byte, mode Mode_t, dev _dev_t) _C_int
func Mknodat(dirfd int, path string, mode uint32, dev int) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_mknodat(_C_int(dirfd), _p2, Mode_t(mode), _dev_t(dev))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for pipe2/pipe2
//extern pipe2
func c_pipe2(p *[2]_C_int, flags _C_int) _C_int
func pipe2(p *[2]_C_int, flags int) (err error) {
	_r := c_pipe2(p, _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for PivotRoot/pivot_root
//extern pivot_root
func c_pivot_root(newroot *byte, putold *byte) _C_int
func PivotRoot(newroot string, putold string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(newroot)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(putold)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_pivot_root(_p1, _p2)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Removexattr/removexattr
//extern removexattr
func c_removexattr(path *byte, name *byte) _C_int
func Removexattr(path string, attr string) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(attr)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_removexattr(_p1, _p2)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Renameat/renameat
//extern renameat
func c_renameat(olddirfd _C_int, oldpath *byte, newdirfd _C_int, newpath *byte) _C_int
func Renameat(olddirfd int, oldpath string, newdirfd int, newpath string) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(oldpath)
	if err != nil {
		return
	}
	var _p4 *byte
	_p4, err = BytePtrFromString(newpath)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_renameat(_C_int(olddirfd), _p2, _C_int(newdirfd), _p4)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for sendfile/sendfile64
//extern sendfile64
func c_sendfile64(outfd _C_int, infd _C_int, offset *Offset_t, count Size_t) Ssize_t
func sendfile(outfd int, infd int, offset *Offset_t, count int) (written int, err error) {
	Entersyscall()
	_r := c_sendfile64(_C_int(outfd), _C_int(infd), offset, Size_t(count))
	written = (int)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setfsgid/setfsgid
//extern setfsgid
func c_setfsgid(gid Gid_t) _C_int
func Setfsgid(gid int) (err error) {
	Entersyscall()
	_r := c_setfsgid(Gid_t(gid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setfsuid/setfsuid
//extern setfsuid
func c_setfsuid(uid Uid_t) _C_int
func Setfsuid(uid int) (err error) {
	Entersyscall()
	_r := c_setfsuid(Uid_t(uid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setresgid/setresgid
//extern setresgid
func c_setresgid(rgid Gid_t, egid Gid_t, sgid Gid_t) _C_int
func Setresgid(rgid int, egid int, sgid int) (err error) {
	_r := c_setresgid(Gid_t(rgid), Gid_t(egid), Gid_t(sgid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setresuid/setresuid
//extern setresuid
func c_setresuid(ruid Uid_t, euid Uid_t, suid Uid_t) _C_int
func Setresuid(ruid int, eguid int, suid int) (err error) {
	_r := c_setresuid(Uid_t(ruid), Uid_t(eguid), Uid_t(suid))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Setxattr/setxattr
//extern setxattr
func c_setxattr(path *byte, name *byte, value *byte, size Size_t, flags _C_int) _C_int
func Setxattr(path string, attr string, data []byte, flags int) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	var _p2 *byte
	_p2, err = BytePtrFromString(attr)
	if err != nil {
		return
	}
	var _p3 *byte
	if len(data) > 0 {
		_p3 = (*byte)(unsafe.Pointer(&data[0]))
	} else {
		_p3 = (*byte)(unsafe.Pointer(&_zero))
	}
	Entersyscall()
	_r := c_setxattr(_p1, _p2, _p3, Size_t(len(data)), _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for splice/splice
//extern splice
func c_splice(rfd _C_int, roff *_loff_t, wfd _C_int, woff *_loff_t, len Size_t, flags _C_uint) Ssize_t
func splice(rfd int, roff *_loff_t, wfd int, woff *_loff_t, len int, flags int) (n int64, err error) {
	Entersyscall()
	_r := c_splice(_C_int(rfd), roff, _C_int(wfd), woff, Size_t(len), _C_uint(flags))
	n = (int64)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Statfs/statfs
//extern statfs
func c_statfs(path *byte, buf *Statfs_t) _C_int
func Statfs(path string, buf *Statfs_t) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_statfs(_p1, buf)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for SyncFileRange/sync_file_range
//extern sync_file_range
func c_sync_file_range(fd _C_int, off Offset_t, n Offset_t, flags _C_uint) _C_int
func SyncFileRange(fd int, off int64, n int64, flags int) (err error) {
	Entersyscall()
	_r := c_sync_file_range(_C_int(fd), Offset_t(off), Offset_t(n), _C_uint(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Sysinfo/sysinfo
//extern sysinfo
func c_sysinfo(info *Sysinfo_t) _C_int
func Sysinfo(info *Sysinfo_t) (err error) {
	_r := c_sysinfo(info)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Tee/tee
//extern tee
func c_tee(rfd _C_int, wfd _C_int, len Size_t, flags _C_uint) Ssize_t
func Tee(rfd int, wfd int, len int, flags int) (n int64, err error) {
	Entersyscall()
	_r := c_tee(_C_int(rfd), _C_int(wfd), Size_t(len), _C_uint(flags))
	n = (int64)(_r)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for unlinkat/unlinkat
//extern unlinkat
func c_unlinkat(dirfd _C_int, path *byte, flags _C_int) _C_int
func unlinkat(dirfd int, path string, flags int) (err error) {
	var _p2 *byte
	_p2, err = BytePtrFromString(path)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_unlinkat(_C_int(dirfd), _p2, _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Unmount/umount2
//extern umount2
func c_umount2(target *byte, flags _C_int) _C_int
func Unmount(target string, flags int) (err error) {
	var _p1 *byte
	_p1, err = BytePtrFromString(target)
	if err != nil {
		return
	}
	Entersyscall()
	_r := c_umount2(_p1, _C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Unshare/unshare
//extern unshare
func c_unshare(flags _C_int) _C_int
func Unshare(flags int) (err error) {
	Entersyscall()
	_r := c_unshare(_C_int(flags))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Ustat/ustat
//extern ustat
func c_ustat(dev _dev_t, ubuf *Ustat_t) _C_int
func Ustat(dev int, ubuf *Ustat_t) (err error) {
	Entersyscall()
	_r := c_ustat(_dev_t(dev), ubuf)
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Ioperm/ioperm
//extern ioperm
func c_ioperm(from _C_long, num _C_long, on _C_int) _C_int
func Ioperm(from int, num int, on int) (err error) {
	Entersyscall()
	_r := c_ioperm(_C_long(from), _C_long(num), _C_int(on))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

// Automatically generated wrapper for Iopl/iopl
//extern iopl
func c_iopl(level _C_int) _C_int
func Iopl(level int) (err error) {
	Entersyscall()
	_r := c_iopl(_C_int(level))
	var errno Errno
	setErrno := false
	if _r < 0 {
		errno = GetErrno()
		setErrno = true
	}
	Exitsyscall()
	if setErrno {
		err = errno
	}
	return
}

