var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var map = {
    "id": "id",
    "author_id": "user",
    "name": "title",
    "file_url": "file.path",
    "created_at": "added",
};
function parseJsonImage(data) {
    var img = Grabber.mapFields(data, map);
    img.identity = {
        service: data["service"],
        user: data["user"],
        id: data["id"],
    };
    if (data["attachments"].length > 1) {
        img.type = "gallery";
        img.gallery_count = data["attachments"].length;
    }
    return img;
}
function completeImage(img) {
    if (img.file_url) {
        if (img.file_url.indexOf('/data/') === -1 && img.file_url.substr(0, 4) !== 'http' && img.file_url[0] === '/') {
            img.file_url = '/data' + img.file_url;
        }
        img.preview_url = img.file_url.replace('/data/', '/thumbnail/data/');
    }
    return img;
}
export var source = {
    name: "Kemono",
    auth: {
        session: {
            type: "post",
            url: "/account/login",
            fields: [
                {
                    id: "pseudo",
                    key: "username",
                },
                {
                    id: "password",
                    key: "password",
                    type: "password",
                },
            ],
            check: {
                type: "redirect",
                url: "logged_in=yes",
            },
        },
    },
    apis: {
        json: {
            name: "JSON",
            auth: [],
            maxLimit: 50,
            search: {
                url: function (query, opts) {
                    var offset = (query.page - 1) * opts.limit;
                    if (query.search) {
                        return { error: "The JSON API does not support arbitrary search." };
                    }
                    return "/api/recent?limit=" + opts.limit + "&o=" + offset; // + "&q=" + encodeURIComponent(query.search);
                },
                parse: function (src) {
                    var data = JSON.parse(src);
                    var images = data.map(function (img) { return completeImage(parseJsonImage(img)); });
                    return { images: images };
                },
            },
            gallery: {
                url: function (query) {
                    var identity = query.identity;
                    return "/api/".concat(identity["service"], "/user/").concat(identity["user"], "/post/").concat(identity["id"]);
                },
                parse: function (src) {
                    var data = JSON.parse(src)[0];
                    var image = parseJsonImage(data);
                    // Duplicate the root data for each attachment
                    var images = data["attachments"].map(function (attachment) { return completeImage(__assign(__assign({}, image), { file_url: attachment["path"], type: "image", gallery_count: undefined })); });
                    return {
                        images: images,
                        imageCount: data["attachments"].length,
                        pageCount: 1,
                    };
                },
            },
            /*details: {
                fullResults: true,
                url: (id: string, md5: string, opts: IUrlDetailsOptions, identity?: IImageIdentity): string | IError => {
                    return `/api/${identity!["service"]}/user/${identity!["user"]}/post/${identity!["id"]}`;
                },
                parse: (src: string): IImage => {
                    const data = JSON.parse(src)[0];
                    return completeImage(parseJsonImage(data));
                },
            },*/
            check: {
                url: function () {
                    return "/";
                },
                parse: function (src) {
                    return src.indexOf("https://github.com/OpenYiff") !== -1;
                },
            },
        },
        html: {
            name: "Regex",
            auth: [],
            forcedLimit: 50,
            search: {
                url: function (query, opts) {
                    var offset = (query.page - 1) * opts.limit;
                    return "/posts?o=" + offset + "&q=" + encodeURIComponent(query.search);
                },
                parse: function (src) {
                    var html = Grabber.parseHTML(src);
                    var articles = html.find("article.post-card");
                    var images = [];
                    for (var _i = 0, articles_1 = articles; _i < articles_1.length; _i++) {
                        var article = articles_1[_i];
                        // Basic attributes
                        var identity = {
                            service: article.attr("data-service"),
                            user: article.attr("data-user"),
                            id: article.attr("data-id"),
                        };
                        var image = {
                            identity: identity,
                            id: identity["id"],
                            author_id: identity["user"],
                            name: article.find("header")[0].innerText().trim(),
                            created_at: article.find("time")[0].attr("datetime"),
                        };
                        // Not all posts have an image
                        var img = article.find("img");
                        if (img.length > 0) {
                            image.preview_url = img[0].attr("src");
                        }
                        // Detect galleries with multiple files
                        var attachmentCount = parseInt(Grabber.regexToConst("count", "(?<count>\\d+) attachments?", article.innerHTML()), 10);
                        if (attachmentCount > 1) {
                            image.type = "gallery";
                            image.gallery_count = attachmentCount;
                        }
                        images.push(image);
                    }
                    return {
                        images: images,
                        imageCount: Grabber.regexToConst("count", "Showing \\d+ - \\d+ of (?<count>\\d+)", src),
                    };
                },
            },
        },
    },
};
