var map = {
    "id": "id",
    "created_at": "created_at",
    "author": "account.username",
};
function parseImage(raw, media) {
    var img = Grabber.mapFields(raw, map);
    img.rating = raw["sensitive"] ? "explicit" : "safe";
    var medias = media ? [media] : raw["media_attachments"];
    if (medias.length >= 1) {
        img.file_url = medias[0].remote_url || medias[0].url;
        img.preview_url = medias[0].preview_remote_url || medias[0].preview_url;
        if (medias[0].meta && medias[0].type !== "audio") {
            img.width = medias[0].meta.original.width;
            img.height = medias[0].meta.original.height;
            img.preview_width = medias[0].meta.small.width;
            img.preview_height = medias[0].meta.small.height;
        }
    }
    if (medias.length > 1) {
        img.type = "gallery";
        img.gallery_count = medias.length;
    }
    return img;
}
var meta = {
    user_id: {
        type: "input",
    },
};
export var source = {
    name: "Mastodon",
    modifiers: ["user:"],
    forcedTokens: [],
    meta: meta,
    auth: {
        oauth2: {
            type: "oauth2",
            authType: "authorization_code",
            authorizationUrl: "/oauth/authorize",
            tokenUrl: "/oauth/token",
            scopes: ["read"],
        },
    },
    apis: {
        json: {
            name: "JSON",
            auth: [],
            maxLimit: 40,
            search: {
                url: function (query, opts, previous) {
                    var search = Grabber.parseSearchQuery(query.search, meta);
                    var pagePart = Grabber.pageUrl(query.page, previous, 1, "", "&min_id={max}", "&max_id={min}");
                    // Search
                    if (search.query) {
                        if (!opts.loggedIn) {
                            return { error: "You must be logged in to use search" };
                        }
                        var userId = search.user_id ? "&account_id=" + search.user_id : "";
                        return "/api/v2/search?type=statuses&q=" + encodeURIComponent(search.query) + userId + "&limit=" + opts.limit + pagePart;
                    }
                    // User ID
                    if (search.user_id) {
                        return "/api/v1/accounts/" + search.user_id + "/statuses?only_media=true&limit=" + opts.limit + pagePart;
                    }
                    // Public timeline
                    return "/api/v1/timelines/public?only_media=true&limit=" + opts.limit + pagePart;
                },
                parse: function (src) {
                    var data = JSON.parse(src);
                    var images = data.map(function (raw) { return parseImage(raw); });
                    return {
                        images: images,
                    };
                },
            },
            gallery: {
                url: function (query) {
                    return "/api/v1/statuses/" + query.id;
                },
                parse: function (src) {
                    var data = JSON.parse(src);
                    if ("statuses" in data) {
                        data = data["statuses"];
                    }
                    var medias = data["media_attachments"];
                    if (medias.length <= 1) {
                        return { error: "Not a gallery" };
                    }
                    var images = medias.map(function (media) { return parseImage(data, media); });
                    return {
                        images: images,
                        imageCount: images.length,
                    };
                },
            },
            details: {
                fullResults: true,
                url: function (id, md5) {
                    return "/api/v1/statuses/" + id;
                },
                parse: function (src) {
                    var data = JSON.parse(src);
                    var img = parseImage(data);
                    // For galleries, we should trust the original information from the gallery endpoint, not the new one which is always the first page
                    if (img.type === "gallery") {
                        delete img.file_url;
                        delete img.sample_url;
                        delete img.preview_url;
                    }
                    return img;
                },
            },
            check: {
                url: function () {
                    return "/about";
                },
                parse: function (src) {
                    return src.indexOf("joinmastodon.org") !== -1;
                },
            },
        },
    },
};
