var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
function buildImage(raw) {
    var _a, _b, _c;
    var map = {
        "id": "id",
        "md5": "hash_id",
        "name": "title",
        "author": "user.username",
        "tags": "tags",
        "createdAt": "created_at",
    };
    var img = Grabber.mapFields(raw, map);
    img.rating = raw.hide_as_adult ? "explicit" : "safe";
    img.preview_url = raw.smaller_square_cover_url || ((_a = raw.cover) === null || _a === void 0 ? void 0 : _a.thumb_url);
    img.authorid = raw.user_id || ((_b = raw.user) === null || _b === void 0 ? void 0 : _b.id);
    if ((_c = raw.icons) === null || _c === void 0 ? void 0 : _c.multiple_images) {
        img.type = "gallery";
    }
    return img;
}
function buildGalleryImage(raw, base) {
    var map = {
        "id": "id",
        "width": "width",
        "height": "height",
        "sample_url": "image_url",
        "file_url": "image_url",
        "name": "title",
    };
    var asset = Grabber.mapFields(raw, map);
    if (raw.asset_type === "video" || raw.asset_type === "video_clip") {
        delete asset.file_url;
    }
    else {
        asset.file_url = asset.sample_url.replace("/large/", "/4k/");
    }
    var img = __assign(__assign({}, base), asset);
    if (!img.preview_url && img.sample_url) {
        img.preview_url = img.sample_url.replace("/large/", "/smaller_square/");
    }
    return img;
}
var meta = {
    user: {
        type: "input",
    },
};
export var source = {
    name: "ArtStation",
    modifiers: [],
    forcedTokens: [],
    meta: meta,
    apis: {
        json: {
            name: "JSON",
            auth: [],
            maxLimit: 1000,
            search: {
                url: function (query, opts) {
                    var search = Grabber.parseSearchQuery(query.search, meta);
                    if (search.query) {
                        /*const url = "/api/v2/search/projects.json";
                        const data = {
                            query: query.search,
                            page: query.page,
                            per_page: opts.limit,
                            sorting: "date", // relevance, likes, date, rank
                            filters: [],
                            additional_fields:[],
                        };
                        return {
                            method: "POST",
                            url,
                            data,
                            headers: {
                                "PUBLIC-CSRF-TOKEN": (document.querySelector('meta[name="public-csrf-token"]') as any).content,
                            },
                        };*/
                        return { error: "Search not supported" };
                    }
                    if (search.user) {
                        return "/users/" + search.user + "/projects.json?page=" + query.page + "&per_page=" + opts.limit;
                    }
                    return "/api/v2/community/explore/projects/latest.json?page=" + query.page + "&per_page=" + opts.limit;
                },
                parse: function (src) {
                    var data = JSON.parse(src);
                    if (!data.data || typeof data.data === "string") {
                        return { error: data.data || "Error" };
                    }
                    return {
                        images: data.data.map(buildImage),
                        imageCount: data.total_count,
                    };
                },
            },
            gallery: {
                url: function (query) {
                    return "/projects/" + query.md5 + ".json";
                },
                parse: function (src) {
                    var data = JSON.parse(src);
                    if (!data.assets) {
                        return { error: "Not a gallery" };
                    }
                    var images = [];
                    var base = buildImage(data);
                    for (var _i = 0, _a = data.assets; _i < _a.length; _i++) {
                        var asset = _a[_i];
                        images.push(buildGalleryImage(asset, base));
                    }
                    return {
                        images: images,
                        imageCount: images.length,
                    };
                },
            },
            details: {
                fullResults: true,
                url: function (id, md5) {
                    return "/projects/" + md5 + ".json";
                },
                parse: function (src) {
                    var data = JSON.parse(src);
                    if (!data.assets) {
                        return { error: "Error" };
                    }
                    if (data.assets.length > 1) {
                        return { error: "Not an image (gallery)" };
                    }
                    var base = buildImage(data);
                    return buildGalleryImage(data.assets[0], base);
                },
            },
        },
    },
};
