var map = {
    "identity.key": "key",
    "width": "attributes.width",
    "height": "attributes.height",
    "related": "related_tags",
};
var buildImage = function (data) {
    var img = Grabber.mapFields(data, map);
    img.tags = Object.keys(data["tags"]);
    img.medias = [];
    for (var key in data["transforms"]) {
        var match = key.match(/width=(\d+):/);
        if (match) {
            img.medias.push({
                url: "/api/legacy/data/" + data["transforms"][key],
                width: parseInt(match[1], 10),
            });
        }
    }
    return img;
};
export var source = {
    name: "Booru.io",
    modifiers: [],
    tagFormat: {
        case: "lower",
        wordSeparator: "_",
    },
    searchFormat: {
        and: " ",
    },
    apis: {
        json: {
            name: "JSON",
            auth: [],
            forcedLimit: 50,
            search: {
                url: function (query) {
                    var cursor = (query.page - 1) * 50;
                    return "/api/legacy/query/entity?cursor=" + cursor + "&query=" + encodeURIComponent(query.search);
                },
                parse: function (src) {
                    var raw = JSON.parse(src);
                    var images = raw.data.map(buildImage);
                    return { images: images };
                },
            },
            details: {
                fullResults: true,
                url: function (id, md5, opts, identity) {
                    return "/api/legacy/entity/" + identity["key"];
                },
                parse: function (src) {
                    var raw = JSON.parse(src);
                    return buildImage(raw);
                },
            },
        },
    },
};
