function parseTags(str, type) {
    var tags = Grabber.regexToTags("<span class='tag'>\"<a href=\"/tags/(?<id>\\d+)\">(?<name>[^<]+)</a>\"</span>", str);
    for (var _i = 0, tags_1 = tags; _i < tags_1.length; _i++) {
        var tag = tags_1[_i];
        tag.type = type;
    }
    return tags;
}
// Transforms a parsed query into a "ID1+ID2" format
function buildQuery(search) {
    return Grabber.visitSearch(search, function (tag) {
        if (!tag.id) {
            throw new Error("Tag ID not found for \"".concat(tag.name, "\""));
        }
        return String(tag.id);
    }, function (left, right) { return left + "+" + right; }, function () { throw new Error("OR operand not supported"); });
}
export var source = {
    name: "E-Shuushuu",
    modifiers: [],
    forcedTokens: ["*"],
    tagFormat: {
        case: "lower",
        wordSeparator: " ",
    },
    searchFormat: {
        and: "+",
    },
    apis: {
        html: {
            name: "Regex",
            auth: [],
            forcedLimit: 15,
            search: {
                parseInput: true,
                parseErrors: true,
                url: function (query) {
                    if (query.search.length === 0 || !query.parsedSearch) {
                        return "/?page=" + query.page;
                    }
                    return "/search/results/?page=" + query.page + "&tags=" + buildQuery(query.parsedSearch);
                },
                parse: function (src) {
                    var images = Grabber.regexToImages('<div class="image_block">.+?<a href="/image/(?<id>\\d+)/">.*?<a class="thumb_image" href="(?<file_url>[^"]+)"[^>]*>.*?<img src="(?<preview_url>[^"]+)"[^>]*>.*?<dl>(?<metadata>.+?)</dl>', src);
                    for (var _i = 0, images_1 = images; _i < images_1.length; _i++) {
                        var img = images_1[_i];
                        var metadata = img.metadata;
                        delete img.metadata;
                        var matches = Grabber.regexMatches("<dt>\\s*([^:<]+):\\s*</dt>\\s*<dd[^>]*>\\s*(.+?)\\s*</dd>", metadata);
                        var tags = [];
                        for (var _a = 0, matches_1 = matches; _a < matches_1.length; _a++) {
                            var match = matches_1[_a];
                            var key = match[1];
                            var val = match[2];
                            if (key === "Submitted By") {
                                img.author = val.match(/<span[^>]*>([^<]+)<\/span>/)[1];
                            }
                            else if (key === "Submitted On") {
                                img.created_at = val;
                            }
                            else if (key === "File size") {
                                img.created_at = Grabber.fileSizeToInt(val);
                            }
                            else if (key === "Dimensions") {
                                var dims = val.match(/(\d+)x(\d+)/);
                                img.width = dims[1];
                                img.height = dims[2];
                            }
                            else if (key === "Tag" || key === "Tags") {
                                tags.push.apply(tags, parseTags(val, "general"));
                            }
                            else if (key === "Source" || key === "Sources") {
                                tags.push.apply(tags, parseTags(val, "copyright"));
                            }
                            else if (key === "Character" || key === "Characters") {
                                tags.push.apply(tags, parseTags(val, "character"));
                            }
                            else if (key === "Artist" || key === "Artists") {
                                tags.push.apply(tags, parseTags(val, "artist"));
                            }
                        }
                        img.tags = tags;
                    }
                    return { images: images };
                },
            },
            tags: {
                url: function (query, opts) {
                    return "/tags/?page=" + query.page + "&type=1&show_aliases=1";
                },
                parse: function (src) {
                    return {
                        tags: Grabber.regexToTags('<li><a href="/tags/(?<id>\\d+)">(?<name>[^<]+)</a></li>', src).map(function (tag) {
                            tag.typeId = 1;
                            return tag;
                        }),
                    };
                },
            },
            check: {
                url: function () {
                    return "/";
                },
                parse: function (src) {
                    return src.indexOf("Contact Webmaster at admin at e-shuushuu.net") !== -1;
                },
            },
        },
    },
};
