/*
 * Copyright (C) 2019 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file generated by the script "utils/lexbor/encoding/single-byte.py"!
 * Do not change this file!
 */

#include "lexbor/encoding/base.h"

#include "lexbor/core/shs.h"


LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_ibm866[128] = 
{
    {(lxb_char_t *) "\xd0\x90", 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {(lxb_char_t *) "\xd0\x91", 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {(lxb_char_t *) "\xd0\x92", 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {(lxb_char_t *) "\xd0\x93", 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {(lxb_char_t *) "\xd0\x94", 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {(lxb_char_t *) "\xd0\x95", 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {(lxb_char_t *) "\xd0\x96", 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\x97", 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {(lxb_char_t *) "\xd0\x98", 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {(lxb_char_t *) "\xd0\x99", 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\x9a", 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {(lxb_char_t *) "\xd0\x9b", 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {(lxb_char_t *) "\xd0\x9c", 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {(lxb_char_t *) "\xd0\x9d", 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {(lxb_char_t *) "\xd0\x9e", 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {(lxb_char_t *) "\xd0\x9f", 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {(lxb_char_t *) "\xd0\xa0", 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {(lxb_char_t *) "\xd0\xa1", 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {(lxb_char_t *) "\xd0\xa2", 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {(lxb_char_t *) "\xd0\xa3", 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {(lxb_char_t *) "\xd0\xa4", 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {(lxb_char_t *) "\xd0\xa5", 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {(lxb_char_t *) "\xd0\xa6", 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {(lxb_char_t *) "\xd0\xa7", 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {(lxb_char_t *) "\xd0\xa8", 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {(lxb_char_t *) "\xd0\xa9", 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {(lxb_char_t *) "\xd0\xaa", 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd0\xab", 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {(lxb_char_t *) "\xd0\xac", 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd0\xad", 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {(lxb_char_t *) "\xd0\xae", 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {(lxb_char_t *) "\xd0\xaf", 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {(lxb_char_t *) "\xd0\xb0", 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {(lxb_char_t *) "\xd0\xb1", 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {(lxb_char_t *) "\xd0\xb2", 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {(lxb_char_t *) "\xd0\xb3", 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {(lxb_char_t *) "\xd0\xb4", 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {(lxb_char_t *) "\xd0\xb5", 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {(lxb_char_t *) "\xd0\xb6", 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\xb7", 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {(lxb_char_t *) "\xd0\xb8", 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {(lxb_char_t *) "\xd0\xb9", 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\xba", 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {(lxb_char_t *) "\xd0\xbb", 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {(lxb_char_t *) "\xd0\xbc", 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {(lxb_char_t *) "\xd0\xbd", 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {(lxb_char_t *) "\xd0\xbe", 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {(lxb_char_t *) "\xd0\xbf", 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {(lxb_char_t *) "\xe2\x96\x91", 3, 0x2591}, /* (LIGHT SHADE) */
    {(lxb_char_t *) "\xe2\x96\x92", 3, 0x2592}, /* (MEDIUM SHADE) */
    {(lxb_char_t *) "\xe2\x96\x93", 3, 0x2593}, /* (DARK SHADE) */
    {(lxb_char_t *) "\xe2\x94\x82", 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {(lxb_char_t *) "\xe2\x94\xa4", 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\xa1", 3, 0x2561}, /* (BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xa2", 3, 0x2562}, /* (BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x96", 3, 0x2556}, /* (BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x95", 3, 0x2555}, /* (BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xa3", 3, 0x2563}, /* (BOX DRAWINGS DOUBLE VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\x91", 3, 0x2551}, /* (BOX DRAWINGS DOUBLE VERTICAL) */
    {(lxb_char_t *) "\xe2\x95\x97", 3, 0x2557}, /* (BOX DRAWINGS DOUBLE DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\x9d", 3, 0x255D}, /* (BOX DRAWINGS DOUBLE UP AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\x9c", 3, 0x255C}, /* (BOX DRAWINGS UP DOUBLE AND LEFT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x9b", 3, 0x255B}, /* (BOX DRAWINGS UP SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xe2\x94\x90", 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x94", 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\xb4", 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xac", 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\x9c", 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x80", 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xbc", 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\x9e", 3, 0x255E}, /* (BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x9f", 3, 0x255F}, /* (BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x9a", 3, 0x255A}, /* (BOX DRAWINGS DOUBLE UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\x94", 3, 0x2554}, /* (BOX DRAWINGS DOUBLE DOWN AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\xa9", 3, 0x2569}, /* (BOX DRAWINGS DOUBLE UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xa6", 3, 0x2566}, /* (BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xa0", 3, 0x2560}, /* (BOX DRAWINGS DOUBLE VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\x90", 3, 0x2550}, /* (BOX DRAWINGS DOUBLE HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xac", 3, 0x256C}, /* (BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xa7", 3, 0x2567}, /* (BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xa8", 3, 0x2568}, /* (BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xa4", 3, 0x2564}, /* (BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xa5", 3, 0x2565}, /* (BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x99", 3, 0x2559}, /* (BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x98", 3, 0x2558}, /* (BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x92", 3, 0x2552}, /* (BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x93", 3, 0x2553}, /* (BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xab", 3, 0x256B}, /* (BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xaa", 3, 0x256A}, /* (BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xe2\x94\x98", 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x8c", 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {(lxb_char_t *) "\xe2\x96\x88", 3, 0x2588}, /* (FULL BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x84", 3, 0x2584}, /* (LOWER HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x8c", 3, 0x258C}, /* (LEFT HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x90", 3, 0x2590}, /* (RIGHT HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x80", 3, 0x2580}, /* (UPPER HALF BLOCK) */
    {(lxb_char_t *) "\xd1\x80", 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {(lxb_char_t *) "\xd1\x81", 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {(lxb_char_t *) "\xd1\x82", 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {(lxb_char_t *) "\xd1\x83", 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {(lxb_char_t *) "\xd1\x84", 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {(lxb_char_t *) "\xd1\x85", 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {(lxb_char_t *) "\xd1\x86", 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {(lxb_char_t *) "\xd1\x87", 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {(lxb_char_t *) "\xd1\x88", 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {(lxb_char_t *) "\xd1\x89", 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {(lxb_char_t *) "\xd1\x8a", 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd1\x8b", 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {(lxb_char_t *) "\xd1\x8c", 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd1\x8d", 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {(lxb_char_t *) "\xd1\x8e", 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {(lxb_char_t *) "\xd1\x8f", 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {(lxb_char_t *) "\xd0\x81", 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {(lxb_char_t *) "\xd1\x91", 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {(lxb_char_t *) "\xd0\x84", 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xd1\x94", 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xd0\x87", 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {(lxb_char_t *) "\xd1\x97", 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {(lxb_char_t *) "\xd0\x8e", 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {(lxb_char_t *) "\xd1\x9e", 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xe2\x88\x99", 3, 0x2219}, /* (BULLET OPERATOR) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xe2\x88\x9a", 3, 0x221A}, /* (SQUARE ROOT) */
    {(lxb_char_t *) "\xe2\x84\x96", 3, 0x2116}, /* (NUMERO SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xe2\x96\xa0", 3, 0x25A0}, /* (BLACK SQUARE) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_10[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc4\x84", 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x92", 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\xa2", 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xaa", 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\xa8", 2, 0x0128}, /* (LATIN CAPITAL LETTER I WITH TILDE) */
    {(lxb_char_t *) "\xc4\xb6", 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc4\xbb", 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x90", 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\xa6", 2, 0x0166}, /* (LATIN CAPITAL LETTER T WITH STROKE) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc5\xaa", 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xc5\x8a", 2, 0x014A}, /* (LATIN CAPITAL LETTER ENG) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc4\x85", 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x93", 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\xa3", 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xab", 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\xa9", 2, 0x0129}, /* (LATIN SMALL LETTER I WITH TILDE) */
    {(lxb_char_t *) "\xc4\xb7", 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc4\xbc", 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x91", 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\xa7", 2, 0x0167}, /* (LATIN SMALL LETTER T WITH STROKE) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\x95", 3, 0x2015}, /* (HORIZONTAL BAR) */
    {(lxb_char_t *) "\xc5\xab", 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xc5\x8b", 2, 0x014B}, /* (LATIN SMALL LETTER ENG) */
    {(lxb_char_t *) "\xc4\x80", 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x83", 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc4\xae", 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x8c", 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x98", 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x96", 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x90", 2, 0x00D0}, /* (LATIN CAPITAL LETTER ETH) */
    {(lxb_char_t *) "\xc5\x85", 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\x8c", 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xa8", 2, 0x0168}, /* (LATIN CAPITAL LETTER U WITH TILDE) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc5\xb2", 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x9d", 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9e", 2, 0x00DE}, /* (LATIN CAPITAL LETTER THORN) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc4\x81", 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa3", 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc4\xaf", 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x8d", 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x99", 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x97", 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb0", 2, 0x00F0}, /* (LATIN SMALL LETTER ETH) */
    {(lxb_char_t *) "\xc5\x86", 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\x8d", 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xa9", 2, 0x0169}, /* (LATIN SMALL LETTER U WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc5\xb3", 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xbd", 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbe", 2, 0x00FE}, /* (LATIN SMALL LETTER THORN) */
    {(lxb_char_t *) "\xc4\xb8", 2, 0x0138}, /* (LATIN SMALL LETTER KRA) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_13[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc5\x96", 2, 0x0156}, /* (LATIN CAPITAL LETTER R WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc5\x97", 2, 0x0157}, /* (LATIN SMALL LETTER R WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc4\x84", 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\xae", 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x80", 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc4\x86", 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc4\x98", 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x92", 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\x8c", 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb9", 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x96", 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\xa2", 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xb6", 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xaa", 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\xbb", 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\x83", 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x85", 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x8c", 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc5\xb2", 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc5\x81", 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc5\x9a", 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xaa", 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xbb", 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc4\x85", 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\xaf", 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x81", 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc4\x87", 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc4\x99", 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x93", 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\x8d", 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xba", 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x97", 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\xa3", 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xb7", 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xab", 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\xbc", 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\x84", 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x86", 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x8d", 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc5\xb3", 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc5\x82", 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc5\x9b", 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xab", 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xbc", 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_14[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xe1\xb8\x82", 3, 0x1E02}, /* (LATIN CAPITAL LETTER B WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xb8\x83", 3, 0x1E03}, /* (LATIN SMALL LETTER B WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc4\x8a", 2, 0x010A}, /* (LATIN CAPITAL LETTER C WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\x8b", 2, 0x010B}, /* (LATIN SMALL LETTER C WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xb8\x8a", 3, 0x1E0A}, /* (LATIN CAPITAL LETTER D WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xe1\xba\x80", 3, 0x1E80}, /* (LATIN CAPITAL LETTER W WITH GRAVE) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xe1\xba\x82", 3, 0x1E82}, /* (LATIN CAPITAL LETTER W WITH ACUTE) */
    {(lxb_char_t *) "\xe1\xb8\x8b", 3, 0x1E0B}, /* (LATIN SMALL LETTER D WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xbb\xb2", 3, 0x1EF2}, /* (LATIN CAPITAL LETTER Y WITH GRAVE) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc5\xb8", 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xe1\xb8\x9e", 3, 0x1E1E}, /* (LATIN CAPITAL LETTER F WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xb8\x9f", 3, 0x1E1F}, /* (LATIN SMALL LETTER F WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\xa0", 2, 0x0120}, /* (LATIN CAPITAL LETTER G WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\xa1", 2, 0x0121}, /* (LATIN SMALL LETTER G WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xb9\x80", 3, 0x1E40}, /* (LATIN CAPITAL LETTER M WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xb9\x81", 3, 0x1E41}, /* (LATIN SMALL LETTER M WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xe1\xb9\x96", 3, 0x1E56}, /* (LATIN CAPITAL LETTER P WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xba\x81", 3, 0x1E81}, /* (LATIN SMALL LETTER W WITH GRAVE) */
    {(lxb_char_t *) "\xe1\xb9\x97", 3, 0x1E57}, /* (LATIN SMALL LETTER P WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xba\x83", 3, 0x1E83}, /* (LATIN SMALL LETTER W WITH ACUTE) */
    {(lxb_char_t *) "\xe1\xb9\xa0", 3, 0x1E60}, /* (LATIN CAPITAL LETTER S WITH DOT ABOVE) */
    {(lxb_char_t *) "\xe1\xbb\xb3", 3, 0x1EF3}, /* (LATIN SMALL LETTER Y WITH GRAVE) */
    {(lxb_char_t *) "\xe1\xba\x84", 3, 0x1E84}, /* (LATIN CAPITAL LETTER W WITH DIAERESIS) */
    {(lxb_char_t *) "\xe1\xba\x85", 3, 0x1E85}, /* (LATIN SMALL LETTER W WITH DIAERESIS) */
    {(lxb_char_t *) "\xe1\xb9\xa1", 3, 0x1E61}, /* (LATIN SMALL LETTER S WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x83", 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x8c", 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xb4", 2, 0x0174}, /* (LATIN CAPITAL LETTER W WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x91", 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\x92", 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xe1\xb9\xaa", 3, 0x1E6A}, /* (LATIN CAPITAL LETTER T WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x9d", 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb6", 2, 0x0176}, /* (LATIN CAPITAL LETTER Y WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa3", 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xac", 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xb5", 2, 0x0175}, /* (LATIN SMALL LETTER W WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb1", 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb2", 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xe1\xb9\xab", 3, 0x1E6B}, /* (LATIN SMALL LETTER T WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xbd", 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb7", 2, 0x0177}, /* (LATIN SMALL LETTER Y WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbf", 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_15[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc2\xa1", 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc2\xaa", 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc2\xba", 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x92", 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {(lxb_char_t *) "\xc5\x93", 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {(lxb_char_t *) "\xc5\xb8", 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xc2\xbf", 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x83", 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x8c", 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x90", 2, 0x00D0}, /* (LATIN CAPITAL LETTER ETH) */
    {(lxb_char_t *) "\xc3\x91", 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\x92", 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x9d", 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9e", 2, 0x00DE}, /* (LATIN CAPITAL LETTER THORN) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa3", 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xac", 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb0", 2, 0x00F0}, /* (LATIN SMALL LETTER ETH) */
    {(lxb_char_t *) "\xc3\xb1", 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb2", 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xbd", 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbe", 2, 0x00FE}, /* (LATIN SMALL LETTER THORN) */
    {(lxb_char_t *) "\xc3\xbf", 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_16[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc4\x84", 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x85", 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc5\x81", 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc8\x98", 2, 0x0218}, /* (LATIN CAPITAL LETTER S WITH COMMA BELOW) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\xb9", 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc5\xba", 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xbb", 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc4\x8c", 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc5\x82", 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc4\x8d", 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc8\x99", 2, 0x0219}, /* (LATIN SMALL LETTER S WITH COMMA BELOW) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x92", 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {(lxb_char_t *) "\xc5\x93", 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {(lxb_char_t *) "\xc5\xb8", 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xbc", 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x82", 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x86", 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x8c", 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x90", 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x83", 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x92", 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc5\x90", 2, 0x0150}, /* (LATIN CAPITAL LETTER O WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\x9a", 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb0", 2, 0x0170}, /* (LATIN CAPITAL LETTER U WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x98", 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc8\x9a", 2, 0x021A}, /* (LATIN CAPITAL LETTER T WITH COMMA BELOW) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x83", 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x87", 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xac", 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x91", 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x84", 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb2", 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc5\x91", 2, 0x0151}, /* (LATIN SMALL LETTER O WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\x9b", 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb1", 2, 0x0171}, /* (LATIN SMALL LETTER U WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x99", 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc8\x9b", 2, 0x021B}, /* (LATIN SMALL LETTER T WITH COMMA BELOW) */
    {(lxb_char_t *) "\xc3\xbf", 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_2[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc4\x84", 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xcb\x98", 2, 0x02D8}, /* (BREVE) */
    {(lxb_char_t *) "\xc5\x81", 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc4\xbd", 2, 0x013D}, /* (LATIN CAPITAL LETTER L WITH CARON) */
    {(lxb_char_t *) "\xc5\x9a", 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\x9e", 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa4", 2, 0x0164}, /* (LATIN CAPITAL LETTER T WITH CARON) */
    {(lxb_char_t *) "\xc5\xb9", 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc5\xbb", 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc4\x85", 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xcb\x9b", 2, 0x02DB}, /* (OGONEK) */
    {(lxb_char_t *) "\xc5\x82", 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc4\xbe", 2, 0x013E}, /* (LATIN SMALL LETTER L WITH CARON) */
    {(lxb_char_t *) "\xc5\x9b", 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xcb\x87", 2, 0x02C7}, /* (CARON) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\x9f", 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa5", 2, 0x0165}, /* (LATIN SMALL LETTER T WITH CARON) */
    {(lxb_char_t *) "\xc5\xba", 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xcb\x9d", 2, 0x02DD}, /* (DOUBLE ACUTE ACCENT) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc5\xbc", 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\x94", 2, 0x0154}, /* (LATIN CAPITAL LETTER R WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x82", 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\xb9", 2, 0x0139}, /* (LATIN CAPITAL LETTER L WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x86", 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x8c", 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x98", 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x9a", 2, 0x011A}, /* (LATIN CAPITAL LETTER E WITH CARON) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x8e", 2, 0x010E}, /* (LATIN CAPITAL LETTER D WITH CARON) */
    {(lxb_char_t *) "\xc4\x90", 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x83", 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x87", 2, 0x0147}, /* (LATIN CAPITAL LETTER N WITH CARON) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc5\x90", 2, 0x0150}, /* (LATIN CAPITAL LETTER O WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc5\x98", 2, 0x0158}, /* (LATIN CAPITAL LETTER R WITH CARON) */
    {(lxb_char_t *) "\xc5\xae", 2, 0x016E}, /* (LATIN CAPITAL LETTER U WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb0", 2, 0x0170}, /* (LATIN CAPITAL LETTER U WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x9d", 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xa2", 2, 0x0162}, /* (LATIN CAPITAL LETTER T WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc5\x95", 2, 0x0155}, /* (LATIN SMALL LETTER R WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x83", 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\xba", 2, 0x013A}, /* (LATIN SMALL LETTER L WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x87", 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x8d", 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x99", 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x9b", 2, 0x011B}, /* (LATIN SMALL LETTER E WITH CARON) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x8f", 2, 0x010F}, /* (LATIN SMALL LETTER D WITH CARON) */
    {(lxb_char_t *) "\xc4\x91", 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x84", 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x88", 2, 0x0148}, /* (LATIN SMALL LETTER N WITH CARON) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc5\x91", 2, 0x0151}, /* (LATIN SMALL LETTER O WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc5\x99", 2, 0x0159}, /* (LATIN SMALL LETTER R WITH CARON) */
    {(lxb_char_t *) "\xc5\xaf", 2, 0x016F}, /* (LATIN SMALL LETTER U WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb1", 2, 0x0171}, /* (LATIN SMALL LETTER U WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xbd", 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xa3", 2, 0x0163}, /* (LATIN SMALL LETTER T WITH CEDILLA) */
    {(lxb_char_t *) "\xcb\x99", 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_3[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc4\xa6", 2, 0x0126}, /* (LATIN CAPITAL LETTER H WITH STROKE) */
    {(lxb_char_t *) "\xcb\x98", 2, 0x02D8}, /* (BREVE) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc4\xa4", 2, 0x0124}, /* (LATIN CAPITAL LETTER H WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc4\xb0", 2, 0x0130}, /* (LATIN CAPITAL LETTER I WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\x9e", 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x9e", 2, 0x011E}, /* (LATIN CAPITAL LETTER G WITH BREVE) */
    {(lxb_char_t *) "\xc4\xb4", 2, 0x0134}, /* (LATIN CAPITAL LETTER J WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc5\xbb", 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc4\xa7", 2, 0x0127}, /* (LATIN SMALL LETTER H WITH STROKE) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc4\xa5", 2, 0x0125}, /* (LATIN SMALL LETTER H WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc4\xb1", 2, 0x0131}, /* (LATIN SMALL LETTER DOTLESS I) */
    {(lxb_char_t *) "\xc5\x9f", 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x9f", 2, 0x011F}, /* (LATIN SMALL LETTER G WITH BREVE) */
    {(lxb_char_t *) "\xc4\xb5", 2, 0x0135}, /* (LATIN SMALL LETTER J WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc5\xbc", 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x8a", 2, 0x010A}, /* (LATIN CAPITAL LETTER C WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\x88", 2, 0x0108}, /* (LATIN CAPITAL LETTER C WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x8c", 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc3\x91", 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\x92", 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\xa0", 2, 0x0120}, /* (LATIN CAPITAL LETTER G WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc4\x9c", 2, 0x011C}, /* (LATIN CAPITAL LETTER G WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xac", 2, 0x016C}, /* (LATIN CAPITAL LETTER U WITH BREVE) */
    {(lxb_char_t *) "\xc5\x9c", 2, 0x015C}, /* (LATIN CAPITAL LETTER S WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x8b", 2, 0x010B}, /* (LATIN SMALL LETTER C WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\x89", 2, 0x0109}, /* (LATIN SMALL LETTER C WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xac", 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc3\xb1", 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb2", 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\xa1", 2, 0x0121}, /* (LATIN SMALL LETTER G WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc4\x9d", 2, 0x011D}, /* (LATIN SMALL LETTER G WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xad", 2, 0x016D}, /* (LATIN SMALL LETTER U WITH BREVE) */
    {(lxb_char_t *) "\xc5\x9d", 2, 0x015D}, /* (LATIN SMALL LETTER S WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xcb\x99", 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_4[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc4\x84", 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\xb8", 2, 0x0138}, /* (LATIN SMALL LETTER KRA) */
    {(lxb_char_t *) "\xc5\x96", 2, 0x0156}, /* (LATIN CAPITAL LETTER R WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc4\xa8", 2, 0x0128}, /* (LATIN CAPITAL LETTER I WITH TILDE) */
    {(lxb_char_t *) "\xc4\xbb", 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc4\x92", 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\xa2", 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa6", 2, 0x0166}, /* (LATIN CAPITAL LETTER T WITH STROKE) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc4\x85", 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xcb\x9b", 2, 0x02DB}, /* (OGONEK) */
    {(lxb_char_t *) "\xc5\x97", 2, 0x0157}, /* (LATIN SMALL LETTER R WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc4\xa9", 2, 0x0129}, /* (LATIN SMALL LETTER I WITH TILDE) */
    {(lxb_char_t *) "\xc4\xbc", 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xcb\x87", 2, 0x02C7}, /* (CARON) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc4\x93", 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\xa3", 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa7", 2, 0x0167}, /* (LATIN SMALL LETTER T WITH STROKE) */
    {(lxb_char_t *) "\xc5\x8a", 2, 0x014A}, /* (LATIN CAPITAL LETTER ENG) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc5\x8b", 2, 0x014B}, /* (LATIN SMALL LETTER ENG) */
    {(lxb_char_t *) "\xc4\x80", 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x83", 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc4\xae", 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x8c", 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x98", 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x96", 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\xaa", 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\x90", 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x85", 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\x8c", 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc4\xb6", 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc5\xb2", 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xa8", 2, 0x0168}, /* (LATIN CAPITAL LETTER U WITH TILDE) */
    {(lxb_char_t *) "\xc5\xaa", 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc4\x81", 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa3", 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc4\xaf", 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x8d", 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x99", 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x97", 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\xab", 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\x91", 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x86", 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\x8d", 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc4\xb7", 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc5\xb3", 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xa9", 2, 0x0169}, /* (LATIN SMALL LETTER U WITH TILDE) */
    {(lxb_char_t *) "\xc5\xab", 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xcb\x99", 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_5[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xd0\x81", 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {(lxb_char_t *) "\xd0\x82", 2, 0x0402}, /* (CYRILLIC CAPITAL LETTER DJE) */
    {(lxb_char_t *) "\xd0\x83", 2, 0x0403}, /* (CYRILLIC CAPITAL LETTER GJE) */
    {(lxb_char_t *) "\xd0\x84", 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xd0\x85", 2, 0x0405}, /* (CYRILLIC CAPITAL LETTER DZE) */
    {(lxb_char_t *) "\xd0\x86", 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xd0\x87", 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {(lxb_char_t *) "\xd0\x88", 2, 0x0408}, /* (CYRILLIC CAPITAL LETTER JE) */
    {(lxb_char_t *) "\xd0\x89", 2, 0x0409}, /* (CYRILLIC CAPITAL LETTER LJE) */
    {(lxb_char_t *) "\xd0\x8a", 2, 0x040A}, /* (CYRILLIC CAPITAL LETTER NJE) */
    {(lxb_char_t *) "\xd0\x8b", 2, 0x040B}, /* (CYRILLIC CAPITAL LETTER TSHE) */
    {(lxb_char_t *) "\xd0\x8c", 2, 0x040C}, /* (CYRILLIC CAPITAL LETTER KJE) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xd0\x8e", 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {(lxb_char_t *) "\xd0\x8f", 2, 0x040F}, /* (CYRILLIC CAPITAL LETTER DZHE) */
    {(lxb_char_t *) "\xd0\x90", 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {(lxb_char_t *) "\xd0\x91", 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {(lxb_char_t *) "\xd0\x92", 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {(lxb_char_t *) "\xd0\x93", 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {(lxb_char_t *) "\xd0\x94", 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {(lxb_char_t *) "\xd0\x95", 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {(lxb_char_t *) "\xd0\x96", 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\x97", 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {(lxb_char_t *) "\xd0\x98", 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {(lxb_char_t *) "\xd0\x99", 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\x9a", 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {(lxb_char_t *) "\xd0\x9b", 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {(lxb_char_t *) "\xd0\x9c", 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {(lxb_char_t *) "\xd0\x9d", 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {(lxb_char_t *) "\xd0\x9e", 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {(lxb_char_t *) "\xd0\x9f", 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {(lxb_char_t *) "\xd0\xa0", 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {(lxb_char_t *) "\xd0\xa1", 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {(lxb_char_t *) "\xd0\xa2", 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {(lxb_char_t *) "\xd0\xa3", 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {(lxb_char_t *) "\xd0\xa4", 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {(lxb_char_t *) "\xd0\xa5", 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {(lxb_char_t *) "\xd0\xa6", 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {(lxb_char_t *) "\xd0\xa7", 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {(lxb_char_t *) "\xd0\xa8", 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {(lxb_char_t *) "\xd0\xa9", 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {(lxb_char_t *) "\xd0\xaa", 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd0\xab", 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {(lxb_char_t *) "\xd0\xac", 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd0\xad", 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {(lxb_char_t *) "\xd0\xae", 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {(lxb_char_t *) "\xd0\xaf", 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {(lxb_char_t *) "\xd0\xb0", 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {(lxb_char_t *) "\xd0\xb1", 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {(lxb_char_t *) "\xd0\xb2", 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {(lxb_char_t *) "\xd0\xb3", 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {(lxb_char_t *) "\xd0\xb4", 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {(lxb_char_t *) "\xd0\xb5", 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {(lxb_char_t *) "\xd0\xb6", 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\xb7", 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {(lxb_char_t *) "\xd0\xb8", 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {(lxb_char_t *) "\xd0\xb9", 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\xba", 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {(lxb_char_t *) "\xd0\xbb", 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {(lxb_char_t *) "\xd0\xbc", 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {(lxb_char_t *) "\xd0\xbd", 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {(lxb_char_t *) "\xd0\xbe", 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {(lxb_char_t *) "\xd0\xbf", 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {(lxb_char_t *) "\xd1\x80", 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {(lxb_char_t *) "\xd1\x81", 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {(lxb_char_t *) "\xd1\x82", 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {(lxb_char_t *) "\xd1\x83", 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {(lxb_char_t *) "\xd1\x84", 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {(lxb_char_t *) "\xd1\x85", 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {(lxb_char_t *) "\xd1\x86", 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {(lxb_char_t *) "\xd1\x87", 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {(lxb_char_t *) "\xd1\x88", 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {(lxb_char_t *) "\xd1\x89", 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {(lxb_char_t *) "\xd1\x8a", 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd1\x8b", 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {(lxb_char_t *) "\xd1\x8c", 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd1\x8d", 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {(lxb_char_t *) "\xd1\x8e", 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {(lxb_char_t *) "\xd1\x8f", 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {(lxb_char_t *) "\xe2\x84\x96", 3, 0x2116}, /* (NUMERO SIGN) */
    {(lxb_char_t *) "\xd1\x91", 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {(lxb_char_t *) "\xd1\x92", 2, 0x0452}, /* (CYRILLIC SMALL LETTER DJE) */
    {(lxb_char_t *) "\xd1\x93", 2, 0x0453}, /* (CYRILLIC SMALL LETTER GJE) */
    {(lxb_char_t *) "\xd1\x94", 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xd1\x95", 2, 0x0455}, /* (CYRILLIC SMALL LETTER DZE) */
    {(lxb_char_t *) "\xd1\x96", 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xd1\x97", 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {(lxb_char_t *) "\xd1\x98", 2, 0x0458}, /* (CYRILLIC SMALL LETTER JE) */
    {(lxb_char_t *) "\xd1\x99", 2, 0x0459}, /* (CYRILLIC SMALL LETTER LJE) */
    {(lxb_char_t *) "\xd1\x9a", 2, 0x045A}, /* (CYRILLIC SMALL LETTER NJE) */
    {(lxb_char_t *) "\xd1\x9b", 2, 0x045B}, /* (CYRILLIC SMALL LETTER TSHE) */
    {(lxb_char_t *) "\xd1\x9c", 2, 0x045C}, /* (CYRILLIC SMALL LETTER KJE) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xd1\x9e", 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {(lxb_char_t *) "\xd1\x9f", 2, 0x045F}, /* (CYRILLIC SMALL LETTER DZHE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_6[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xd8\x8c", 2, 0x060C}, /* (ARABIC COMMA) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xd8\x9b", 2, 0x061B}, /* (ARABIC SEMICOLON) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xd8\x9f", 2, 0x061F}, /* (ARABIC QUESTION MARK) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xd8\xa1", 2, 0x0621}, /* (ARABIC LETTER HAMZA) */
    {(lxb_char_t *) "\xd8\xa2", 2, 0x0622}, /* (ARABIC LETTER ALEF WITH MADDA ABOVE) */
    {(lxb_char_t *) "\xd8\xa3", 2, 0x0623}, /* (ARABIC LETTER ALEF WITH HAMZA ABOVE) */
    {(lxb_char_t *) "\xd8\xa4", 2, 0x0624}, /* (ARABIC LETTER WAW WITH HAMZA ABOVE) */
    {(lxb_char_t *) "\xd8\xa5", 2, 0x0625}, /* (ARABIC LETTER ALEF WITH HAMZA BELOW) */
    {(lxb_char_t *) "\xd8\xa6", 2, 0x0626}, /* (ARABIC LETTER YEH WITH HAMZA ABOVE) */
    {(lxb_char_t *) "\xd8\xa7", 2, 0x0627}, /* (ARABIC LETTER ALEF) */
    {(lxb_char_t *) "\xd8\xa8", 2, 0x0628}, /* (ARABIC LETTER BEH) */
    {(lxb_char_t *) "\xd8\xa9", 2, 0x0629}, /* (ARABIC LETTER TEH MARBUTA) */
    {(lxb_char_t *) "\xd8\xaa", 2, 0x062A}, /* (ARABIC LETTER TEH) */
    {(lxb_char_t *) "\xd8\xab", 2, 0x062B}, /* (ARABIC LETTER THEH) */
    {(lxb_char_t *) "\xd8\xac", 2, 0x062C}, /* (ARABIC LETTER JEEM) */
    {(lxb_char_t *) "\xd8\xad", 2, 0x062D}, /* (ARABIC LETTER HAH) */
    {(lxb_char_t *) "\xd8\xae", 2, 0x062E}, /* (ARABIC LETTER KHAH) */
    {(lxb_char_t *) "\xd8\xaf", 2, 0x062F}, /* (ARABIC LETTER DAL) */
    {(lxb_char_t *) "\xd8\xb0", 2, 0x0630}, /* (ARABIC LETTER THAL) */
    {(lxb_char_t *) "\xd8\xb1", 2, 0x0631}, /* (ARABIC LETTER REH) */
    {(lxb_char_t *) "\xd8\xb2", 2, 0x0632}, /* (ARABIC LETTER ZAIN) */
    {(lxb_char_t *) "\xd8\xb3", 2, 0x0633}, /* (ARABIC LETTER SEEN) */
    {(lxb_char_t *) "\xd8\xb4", 2, 0x0634}, /* (ARABIC LETTER SHEEN) */
    {(lxb_char_t *) "\xd8\xb5", 2, 0x0635}, /* (ARABIC LETTER SAD) */
    {(lxb_char_t *) "\xd8\xb6", 2, 0x0636}, /* (ARABIC LETTER DAD) */
    {(lxb_char_t *) "\xd8\xb7", 2, 0x0637}, /* (ARABIC LETTER TAH) */
    {(lxb_char_t *) "\xd8\xb8", 2, 0x0638}, /* (ARABIC LETTER ZAH) */
    {(lxb_char_t *) "\xd8\xb9", 2, 0x0639}, /* (ARABIC LETTER AIN) */
    {(lxb_char_t *) "\xd8\xba", 2, 0x063A}, /* (ARABIC LETTER GHAIN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xd9\x80", 2, 0x0640}, /* (ARABIC TATWEEL) */
    {(lxb_char_t *) "\xd9\x81", 2, 0x0641}, /* (ARABIC LETTER FEH) */
    {(lxb_char_t *) "\xd9\x82", 2, 0x0642}, /* (ARABIC LETTER QAF) */
    {(lxb_char_t *) "\xd9\x83", 2, 0x0643}, /* (ARABIC LETTER KAF) */
    {(lxb_char_t *) "\xd9\x84", 2, 0x0644}, /* (ARABIC LETTER LAM) */
    {(lxb_char_t *) "\xd9\x85", 2, 0x0645}, /* (ARABIC LETTER MEEM) */
    {(lxb_char_t *) "\xd9\x86", 2, 0x0646}, /* (ARABIC LETTER NOON) */
    {(lxb_char_t *) "\xd9\x87", 2, 0x0647}, /* (ARABIC LETTER HEH) */
    {(lxb_char_t *) "\xd9\x88", 2, 0x0648}, /* (ARABIC LETTER WAW) */
    {(lxb_char_t *) "\xd9\x89", 2, 0x0649}, /* (ARABIC LETTER ALEF MAKSURA) */
    {(lxb_char_t *) "\xd9\x8a", 2, 0x064A}, /* (ARABIC LETTER YEH) */
    {(lxb_char_t *) "\xd9\x8b", 2, 0x064B}, /* (ARABIC FATHATAN) */
    {(lxb_char_t *) "\xd9\x8c", 2, 0x064C}, /* (ARABIC DAMMATAN) */
    {(lxb_char_t *) "\xd9\x8d", 2, 0x064D}, /* (ARABIC KASRATAN) */
    {(lxb_char_t *) "\xd9\x8e", 2, 0x064E}, /* (ARABIC FATHA) */
    {(lxb_char_t *) "\xd9\x8f", 2, 0x064F}, /* (ARABIC DAMMA) */
    {(lxb_char_t *) "\xd9\x90", 2, 0x0650}, /* (ARABIC KASRA) */
    {(lxb_char_t *) "\xd9\x91", 2, 0x0651}, /* (ARABIC SHADDA) */
    {(lxb_char_t *) "\xd9\x92", 2, 0x0652}, /* (ARABIC SUKUN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_7[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xe2\x82\xaf", 3, 0x20AF}, /* (DRACHMA SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xcd\xba", 2, 0x037A}, /* (GREEK YPOGEGRAMMENI) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xe2\x80\x95", 3, 0x2015}, /* (HORIZONTAL BAR) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xce\x84", 2, 0x0384}, /* (GREEK TONOS) */
    {(lxb_char_t *) "\xce\x85", 2, 0x0385}, /* (GREEK DIALYTIKA TONOS) */
    {(lxb_char_t *) "\xce\x86", 2, 0x0386}, /* (GREEK CAPITAL LETTER ALPHA WITH TONOS) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xce\x88", 2, 0x0388}, /* (GREEK CAPITAL LETTER EPSILON WITH TONOS) */
    {(lxb_char_t *) "\xce\x89", 2, 0x0389}, /* (GREEK CAPITAL LETTER ETA WITH TONOS) */
    {(lxb_char_t *) "\xce\x8a", 2, 0x038A}, /* (GREEK CAPITAL LETTER IOTA WITH TONOS) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xce\x8c", 2, 0x038C}, /* (GREEK CAPITAL LETTER OMICRON WITH TONOS) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xce\x8e", 2, 0x038E}, /* (GREEK CAPITAL LETTER UPSILON WITH TONOS) */
    {(lxb_char_t *) "\xce\x8f", 2, 0x038F}, /* (GREEK CAPITAL LETTER OMEGA WITH TONOS) */
    {(lxb_char_t *) "\xce\x90", 2, 0x0390}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS) */
    {(lxb_char_t *) "\xce\x91", 2, 0x0391}, /* (GREEK CAPITAL LETTER ALPHA) */
    {(lxb_char_t *) "\xce\x92", 2, 0x0392}, /* (GREEK CAPITAL LETTER BETA) */
    {(lxb_char_t *) "\xce\x93", 2, 0x0393}, /* (GREEK CAPITAL LETTER GAMMA) */
    {(lxb_char_t *) "\xce\x94", 2, 0x0394}, /* (GREEK CAPITAL LETTER DELTA) */
    {(lxb_char_t *) "\xce\x95", 2, 0x0395}, /* (GREEK CAPITAL LETTER EPSILON) */
    {(lxb_char_t *) "\xce\x96", 2, 0x0396}, /* (GREEK CAPITAL LETTER ZETA) */
    {(lxb_char_t *) "\xce\x97", 2, 0x0397}, /* (GREEK CAPITAL LETTER ETA) */
    {(lxb_char_t *) "\xce\x98", 2, 0x0398}, /* (GREEK CAPITAL LETTER THETA) */
    {(lxb_char_t *) "\xce\x99", 2, 0x0399}, /* (GREEK CAPITAL LETTER IOTA) */
    {(lxb_char_t *) "\xce\x9a", 2, 0x039A}, /* (GREEK CAPITAL LETTER KAPPA) */
    {(lxb_char_t *) "\xce\x9b", 2, 0x039B}, /* (GREEK CAPITAL LETTER LAMDA) */
    {(lxb_char_t *) "\xce\x9c", 2, 0x039C}, /* (GREEK CAPITAL LETTER MU) */
    {(lxb_char_t *) "\xce\x9d", 2, 0x039D}, /* (GREEK CAPITAL LETTER NU) */
    {(lxb_char_t *) "\xce\x9e", 2, 0x039E}, /* (GREEK CAPITAL LETTER XI) */
    {(lxb_char_t *) "\xce\x9f", 2, 0x039F}, /* (GREEK CAPITAL LETTER OMICRON) */
    {(lxb_char_t *) "\xce\xa0", 2, 0x03A0}, /* (GREEK CAPITAL LETTER PI) */
    {(lxb_char_t *) "\xce\xa1", 2, 0x03A1}, /* (GREEK CAPITAL LETTER RHO) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xce\xa3", 2, 0x03A3}, /* (GREEK CAPITAL LETTER SIGMA) */
    {(lxb_char_t *) "\xce\xa4", 2, 0x03A4}, /* (GREEK CAPITAL LETTER TAU) */
    {(lxb_char_t *) "\xce\xa5", 2, 0x03A5}, /* (GREEK CAPITAL LETTER UPSILON) */
    {(lxb_char_t *) "\xce\xa6", 2, 0x03A6}, /* (GREEK CAPITAL LETTER PHI) */
    {(lxb_char_t *) "\xce\xa7", 2, 0x03A7}, /* (GREEK CAPITAL LETTER CHI) */
    {(lxb_char_t *) "\xce\xa8", 2, 0x03A8}, /* (GREEK CAPITAL LETTER PSI) */
    {(lxb_char_t *) "\xce\xa9", 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {(lxb_char_t *) "\xce\xaa", 2, 0x03AA}, /* (GREEK CAPITAL LETTER IOTA WITH DIALYTIKA) */
    {(lxb_char_t *) "\xce\xab", 2, 0x03AB}, /* (GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA) */
    {(lxb_char_t *) "\xce\xac", 2, 0x03AC}, /* (GREEK SMALL LETTER ALPHA WITH TONOS) */
    {(lxb_char_t *) "\xce\xad", 2, 0x03AD}, /* (GREEK SMALL LETTER EPSILON WITH TONOS) */
    {(lxb_char_t *) "\xce\xae", 2, 0x03AE}, /* (GREEK SMALL LETTER ETA WITH TONOS) */
    {(lxb_char_t *) "\xce\xaf", 2, 0x03AF}, /* (GREEK SMALL LETTER IOTA WITH TONOS) */
    {(lxb_char_t *) "\xce\xb0", 2, 0x03B0}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS) */
    {(lxb_char_t *) "\xce\xb1", 2, 0x03B1}, /* (GREEK SMALL LETTER ALPHA) */
    {(lxb_char_t *) "\xce\xb2", 2, 0x03B2}, /* (GREEK SMALL LETTER BETA) */
    {(lxb_char_t *) "\xce\xb3", 2, 0x03B3}, /* (GREEK SMALL LETTER GAMMA) */
    {(lxb_char_t *) "\xce\xb4", 2, 0x03B4}, /* (GREEK SMALL LETTER DELTA) */
    {(lxb_char_t *) "\xce\xb5", 2, 0x03B5}, /* (GREEK SMALL LETTER EPSILON) */
    {(lxb_char_t *) "\xce\xb6", 2, 0x03B6}, /* (GREEK SMALL LETTER ZETA) */
    {(lxb_char_t *) "\xce\xb7", 2, 0x03B7}, /* (GREEK SMALL LETTER ETA) */
    {(lxb_char_t *) "\xce\xb8", 2, 0x03B8}, /* (GREEK SMALL LETTER THETA) */
    {(lxb_char_t *) "\xce\xb9", 2, 0x03B9}, /* (GREEK SMALL LETTER IOTA) */
    {(lxb_char_t *) "\xce\xba", 2, 0x03BA}, /* (GREEK SMALL LETTER KAPPA) */
    {(lxb_char_t *) "\xce\xbb", 2, 0x03BB}, /* (GREEK SMALL LETTER LAMDA) */
    {(lxb_char_t *) "\xce\xbc", 2, 0x03BC}, /* (GREEK SMALL LETTER MU) */
    {(lxb_char_t *) "\xce\xbd", 2, 0x03BD}, /* (GREEK SMALL LETTER NU) */
    {(lxb_char_t *) "\xce\xbe", 2, 0x03BE}, /* (GREEK SMALL LETTER XI) */
    {(lxb_char_t *) "\xce\xbf", 2, 0x03BF}, /* (GREEK SMALL LETTER OMICRON) */
    {(lxb_char_t *) "\xcf\x80", 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {(lxb_char_t *) "\xcf\x81", 2, 0x03C1}, /* (GREEK SMALL LETTER RHO) */
    {(lxb_char_t *) "\xcf\x82", 2, 0x03C2}, /* (GREEK SMALL LETTER FINAL SIGMA) */
    {(lxb_char_t *) "\xcf\x83", 2, 0x03C3}, /* (GREEK SMALL LETTER SIGMA) */
    {(lxb_char_t *) "\xcf\x84", 2, 0x03C4}, /* (GREEK SMALL LETTER TAU) */
    {(lxb_char_t *) "\xcf\x85", 2, 0x03C5}, /* (GREEK SMALL LETTER UPSILON) */
    {(lxb_char_t *) "\xcf\x86", 2, 0x03C6}, /* (GREEK SMALL LETTER PHI) */
    {(lxb_char_t *) "\xcf\x87", 2, 0x03C7}, /* (GREEK SMALL LETTER CHI) */
    {(lxb_char_t *) "\xcf\x88", 2, 0x03C8}, /* (GREEK SMALL LETTER PSI) */
    {(lxb_char_t *) "\xcf\x89", 2, 0x03C9}, /* (GREEK SMALL LETTER OMEGA) */
    {(lxb_char_t *) "\xcf\x8a", 2, 0x03CA}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA) */
    {(lxb_char_t *) "\xcf\x8b", 2, 0x03CB}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA) */
    {(lxb_char_t *) "\xcf\x8c", 2, 0x03CC}, /* (GREEK SMALL LETTER OMICRON WITH TONOS) */
    {(lxb_char_t *) "\xcf\x8d", 2, 0x03CD}, /* (GREEK SMALL LETTER UPSILON WITH TONOS) */
    {(lxb_char_t *) "\xcf\x8e", 2, 0x03CE}, /* (GREEK SMALL LETTER OMEGA WITH TONOS) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_8[128] = 
{
    {(lxb_char_t *) "\xc2\x80", 2, 0x0080}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x85", 2, 0x0085}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x91", 2, 0x0091}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x92", 2, 0x0092}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x93", 2, 0x0093}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x94", 2, 0x0094}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x95", 2, 0x0095}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x96", 2, 0x0096}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x97", 2, 0x0097}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xe2\x80\x97", 3, 0x2017}, /* (DOUBLE LOW LINE) */
    {(lxb_char_t *) "\xd7\x90", 2, 0x05D0}, /* (HEBREW LETTER ALEF) */
    {(lxb_char_t *) "\xd7\x91", 2, 0x05D1}, /* (HEBREW LETTER BET) */
    {(lxb_char_t *) "\xd7\x92", 2, 0x05D2}, /* (HEBREW LETTER GIMEL) */
    {(lxb_char_t *) "\xd7\x93", 2, 0x05D3}, /* (HEBREW LETTER DALET) */
    {(lxb_char_t *) "\xd7\x94", 2, 0x05D4}, /* (HEBREW LETTER HE) */
    {(lxb_char_t *) "\xd7\x95", 2, 0x05D5}, /* (HEBREW LETTER VAV) */
    {(lxb_char_t *) "\xd7\x96", 2, 0x05D6}, /* (HEBREW LETTER ZAYIN) */
    {(lxb_char_t *) "\xd7\x97", 2, 0x05D7}, /* (HEBREW LETTER HET) */
    {(lxb_char_t *) "\xd7\x98", 2, 0x05D8}, /* (HEBREW LETTER TET) */
    {(lxb_char_t *) "\xd7\x99", 2, 0x05D9}, /* (HEBREW LETTER YOD) */
    {(lxb_char_t *) "\xd7\x9a", 2, 0x05DA}, /* (HEBREW LETTER FINAL KAF) */
    {(lxb_char_t *) "\xd7\x9b", 2, 0x05DB}, /* (HEBREW LETTER KAF) */
    {(lxb_char_t *) "\xd7\x9c", 2, 0x05DC}, /* (HEBREW LETTER LAMED) */
    {(lxb_char_t *) "\xd7\x9d", 2, 0x05DD}, /* (HEBREW LETTER FINAL MEM) */
    {(lxb_char_t *) "\xd7\x9e", 2, 0x05DE}, /* (HEBREW LETTER MEM) */
    {(lxb_char_t *) "\xd7\x9f", 2, 0x05DF}, /* (HEBREW LETTER FINAL NUN) */
    {(lxb_char_t *) "\xd7\xa0", 2, 0x05E0}, /* (HEBREW LETTER NUN) */
    {(lxb_char_t *) "\xd7\xa1", 2, 0x05E1}, /* (HEBREW LETTER SAMEKH) */
    {(lxb_char_t *) "\xd7\xa2", 2, 0x05E2}, /* (HEBREW LETTER AYIN) */
    {(lxb_char_t *) "\xd7\xa3", 2, 0x05E3}, /* (HEBREW LETTER FINAL PE) */
    {(lxb_char_t *) "\xd7\xa4", 2, 0x05E4}, /* (HEBREW LETTER PE) */
    {(lxb_char_t *) "\xd7\xa5", 2, 0x05E5}, /* (HEBREW LETTER FINAL TSADI) */
    {(lxb_char_t *) "\xd7\xa6", 2, 0x05E6}, /* (HEBREW LETTER TSADI) */
    {(lxb_char_t *) "\xd7\xa7", 2, 0x05E7}, /* (HEBREW LETTER QOF) */
    {(lxb_char_t *) "\xd7\xa8", 2, 0x05E8}, /* (HEBREW LETTER RESH) */
    {(lxb_char_t *) "\xd7\xa9", 2, 0x05E9}, /* (HEBREW LETTER SHIN) */
    {(lxb_char_t *) "\xd7\xaa", 2, 0x05EA}, /* (HEBREW LETTER TAV) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xe2\x80\x8e", 3, 0x200E}, /* (LEFT-TO-RIGHT MARK) */
    {(lxb_char_t *) "\xe2\x80\x8f", 3, 0x200F}, /* (RIGHT-TO-LEFT MARK) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_koi8_r[128] = 
{
    {(lxb_char_t *) "\xe2\x94\x80", 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\x82", 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {(lxb_char_t *) "\xe2\x94\x8c", 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x90", 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x94", 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x98", 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x9c", 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\xa4", 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\xac", 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xb4", 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xbc", 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x96\x80", 3, 0x2580}, /* (UPPER HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x84", 3, 0x2584}, /* (LOWER HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x88", 3, 0x2588}, /* (FULL BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x8c", 3, 0x258C}, /* (LEFT HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x90", 3, 0x2590}, /* (RIGHT HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x91", 3, 0x2591}, /* (LIGHT SHADE) */
    {(lxb_char_t *) "\xe2\x96\x92", 3, 0x2592}, /* (MEDIUM SHADE) */
    {(lxb_char_t *) "\xe2\x96\x93", 3, 0x2593}, /* (DARK SHADE) */
    {(lxb_char_t *) "\xe2\x8c\xa0", 3, 0x2320}, /* (TOP HALF INTEGRAL) */
    {(lxb_char_t *) "\xe2\x96\xa0", 3, 0x25A0}, /* (BLACK SQUARE) */
    {(lxb_char_t *) "\xe2\x88\x99", 3, 0x2219}, /* (BULLET OPERATOR) */
    {(lxb_char_t *) "\xe2\x88\x9a", 3, 0x221A}, /* (SQUARE ROOT) */
    {(lxb_char_t *) "\xe2\x89\x88", 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {(lxb_char_t *) "\xe2\x89\xa4", 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xe2\x89\xa5", 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xe2\x8c\xa1", 3, 0x2321}, /* (BOTTOM HALF INTEGRAL) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xe2\x95\x90", 3, 0x2550}, /* (BOX DRAWINGS DOUBLE HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\x91", 3, 0x2551}, /* (BOX DRAWINGS DOUBLE VERTICAL) */
    {(lxb_char_t *) "\xe2\x95\x92", 3, 0x2552}, /* (BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xd1\x91", 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {(lxb_char_t *) "\xe2\x95\x93", 3, 0x2553}, /* (BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x94", 3, 0x2554}, /* (BOX DRAWINGS DOUBLE DOWN AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\x95", 3, 0x2555}, /* (BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x96", 3, 0x2556}, /* (BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x97", 3, 0x2557}, /* (BOX DRAWINGS DOUBLE DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\x98", 3, 0x2558}, /* (BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x99", 3, 0x2559}, /* (BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x9a", 3, 0x255A}, /* (BOX DRAWINGS DOUBLE UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\x9b", 3, 0x255B}, /* (BOX DRAWINGS UP SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x9c", 3, 0x255C}, /* (BOX DRAWINGS UP DOUBLE AND LEFT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x9d", 3, 0x255D}, /* (BOX DRAWINGS DOUBLE UP AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\x9e", 3, 0x255E}, /* (BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x9f", 3, 0x255F}, /* (BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xa0", 3, 0x2560}, /* (BOX DRAWINGS DOUBLE VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\xa1", 3, 0x2561}, /* (BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xd0\x81", 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {(lxb_char_t *) "\xe2\x95\xa2", 3, 0x2562}, /* (BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xa3", 3, 0x2563}, /* (BOX DRAWINGS DOUBLE VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\xa4", 3, 0x2564}, /* (BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xa5", 3, 0x2565}, /* (BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xa6", 3, 0x2566}, /* (BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xa7", 3, 0x2567}, /* (BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xa8", 3, 0x2568}, /* (BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xa9", 3, 0x2569}, /* (BOX DRAWINGS DOUBLE UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xaa", 3, 0x256A}, /* (BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xab", 3, 0x256B}, /* (BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xac", 3, 0x256C}, /* (BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xd1\x8e", 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {(lxb_char_t *) "\xd0\xb0", 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {(lxb_char_t *) "\xd0\xb1", 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {(lxb_char_t *) "\xd1\x86", 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {(lxb_char_t *) "\xd0\xb4", 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {(lxb_char_t *) "\xd0\xb5", 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {(lxb_char_t *) "\xd1\x84", 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {(lxb_char_t *) "\xd0\xb3", 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {(lxb_char_t *) "\xd1\x85", 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {(lxb_char_t *) "\xd0\xb8", 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {(lxb_char_t *) "\xd0\xb9", 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\xba", 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {(lxb_char_t *) "\xd0\xbb", 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {(lxb_char_t *) "\xd0\xbc", 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {(lxb_char_t *) "\xd0\xbd", 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {(lxb_char_t *) "\xd0\xbe", 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {(lxb_char_t *) "\xd0\xbf", 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {(lxb_char_t *) "\xd1\x8f", 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {(lxb_char_t *) "\xd1\x80", 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {(lxb_char_t *) "\xd1\x81", 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {(lxb_char_t *) "\xd1\x82", 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {(lxb_char_t *) "\xd1\x83", 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {(lxb_char_t *) "\xd0\xb6", 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\xb2", 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {(lxb_char_t *) "\xd1\x8c", 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd1\x8b", 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {(lxb_char_t *) "\xd0\xb7", 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {(lxb_char_t *) "\xd1\x88", 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {(lxb_char_t *) "\xd1\x8d", 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {(lxb_char_t *) "\xd1\x89", 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {(lxb_char_t *) "\xd1\x87", 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {(lxb_char_t *) "\xd1\x8a", 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd0\xae", 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {(lxb_char_t *) "\xd0\x90", 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {(lxb_char_t *) "\xd0\x91", 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {(lxb_char_t *) "\xd0\xa6", 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {(lxb_char_t *) "\xd0\x94", 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {(lxb_char_t *) "\xd0\x95", 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {(lxb_char_t *) "\xd0\xa4", 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {(lxb_char_t *) "\xd0\x93", 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {(lxb_char_t *) "\xd0\xa5", 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {(lxb_char_t *) "\xd0\x98", 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {(lxb_char_t *) "\xd0\x99", 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\x9a", 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {(lxb_char_t *) "\xd0\x9b", 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {(lxb_char_t *) "\xd0\x9c", 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {(lxb_char_t *) "\xd0\x9d", 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {(lxb_char_t *) "\xd0\x9e", 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {(lxb_char_t *) "\xd0\x9f", 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {(lxb_char_t *) "\xd0\xaf", 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {(lxb_char_t *) "\xd0\xa0", 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {(lxb_char_t *) "\xd0\xa1", 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {(lxb_char_t *) "\xd0\xa2", 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {(lxb_char_t *) "\xd0\xa3", 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {(lxb_char_t *) "\xd0\x96", 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\x92", 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {(lxb_char_t *) "\xd0\xac", 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd0\xab", 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {(lxb_char_t *) "\xd0\x97", 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {(lxb_char_t *) "\xd0\xa8", 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {(lxb_char_t *) "\xd0\xad", 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {(lxb_char_t *) "\xd0\xa9", 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {(lxb_char_t *) "\xd0\xa7", 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {(lxb_char_t *) "\xd0\xaa", 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_koi8_u[128] = 
{
    {(lxb_char_t *) "\xe2\x94\x80", 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\x82", 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {(lxb_char_t *) "\xe2\x94\x8c", 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x90", 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x94", 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\x98", 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\x9c", 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x94\xa4", 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xe2\x94\xac", 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xb4", 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x94\xbc", 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x96\x80", 3, 0x2580}, /* (UPPER HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x84", 3, 0x2584}, /* (LOWER HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x88", 3, 0x2588}, /* (FULL BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x8c", 3, 0x258C}, /* (LEFT HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x90", 3, 0x2590}, /* (RIGHT HALF BLOCK) */
    {(lxb_char_t *) "\xe2\x96\x91", 3, 0x2591}, /* (LIGHT SHADE) */
    {(lxb_char_t *) "\xe2\x96\x92", 3, 0x2592}, /* (MEDIUM SHADE) */
    {(lxb_char_t *) "\xe2\x96\x93", 3, 0x2593}, /* (DARK SHADE) */
    {(lxb_char_t *) "\xe2\x8c\xa0", 3, 0x2320}, /* (TOP HALF INTEGRAL) */
    {(lxb_char_t *) "\xe2\x96\xa0", 3, 0x25A0}, /* (BLACK SQUARE) */
    {(lxb_char_t *) "\xe2\x88\x99", 3, 0x2219}, /* (BULLET OPERATOR) */
    {(lxb_char_t *) "\xe2\x88\x9a", 3, 0x221A}, /* (SQUARE ROOT) */
    {(lxb_char_t *) "\xe2\x89\x88", 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {(lxb_char_t *) "\xe2\x89\xa4", 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xe2\x89\xa5", 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xe2\x8c\xa1", 3, 0x2321}, /* (BOTTOM HALF INTEGRAL) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xe2\x95\x90", 3, 0x2550}, /* (BOX DRAWINGS DOUBLE HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\x91", 3, 0x2551}, /* (BOX DRAWINGS DOUBLE VERTICAL) */
    {(lxb_char_t *) "\xe2\x95\x92", 3, 0x2552}, /* (BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xd1\x91", 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {(lxb_char_t *) "\xd1\x94", 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xe2\x95\x94", 3, 0x2554}, /* (BOX DRAWINGS DOUBLE DOWN AND RIGHT) */
    {(lxb_char_t *) "\xd1\x96", 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xd1\x97", 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {(lxb_char_t *) "\xe2\x95\x97", 3, 0x2557}, /* (BOX DRAWINGS DOUBLE DOWN AND LEFT) */
    {(lxb_char_t *) "\xe2\x95\x98", 3, 0x2558}, /* (BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x99", 3, 0x2559}, /* (BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\x9a", 3, 0x255A}, /* (BOX DRAWINGS DOUBLE UP AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\x9b", 3, 0x255B}, /* (BOX DRAWINGS UP SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xd2\x91", 2, 0x0491}, /* (CYRILLIC SMALL LETTER GHE WITH UPTURN) */
    {(lxb_char_t *) "\xd1\x9e", 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {(lxb_char_t *) "\xe2\x95\x9e", 3, 0x255E}, /* (BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\x9f", 3, 0x255F}, /* (BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xa0", 3, 0x2560}, /* (BOX DRAWINGS DOUBLE VERTICAL AND RIGHT) */
    {(lxb_char_t *) "\xe2\x95\xa1", 3, 0x2561}, /* (BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE) */
    {(lxb_char_t *) "\xd0\x81", 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {(lxb_char_t *) "\xd0\x84", 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xe2\x95\xa3", 3, 0x2563}, /* (BOX DRAWINGS DOUBLE VERTICAL AND LEFT) */
    {(lxb_char_t *) "\xd0\x86", 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xd0\x87", 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {(lxb_char_t *) "\xe2\x95\xa6", 3, 0x2566}, /* (BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xa7", 3, 0x2567}, /* (BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xe2\x95\xa8", 3, 0x2568}, /* (BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE) */
    {(lxb_char_t *) "\xe2\x95\xa9", 3, 0x2569}, /* (BOX DRAWINGS DOUBLE UP AND HORIZONTAL) */
    {(lxb_char_t *) "\xe2\x95\xaa", 3, 0x256A}, /* (BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE) */
    {(lxb_char_t *) "\xd2\x90", 2, 0x0490}, /* (CYRILLIC CAPITAL LETTER GHE WITH UPTURN) */
    {(lxb_char_t *) "\xd0\x8e", 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xd1\x8e", 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {(lxb_char_t *) "\xd0\xb0", 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {(lxb_char_t *) "\xd0\xb1", 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {(lxb_char_t *) "\xd1\x86", 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {(lxb_char_t *) "\xd0\xb4", 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {(lxb_char_t *) "\xd0\xb5", 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {(lxb_char_t *) "\xd1\x84", 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {(lxb_char_t *) "\xd0\xb3", 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {(lxb_char_t *) "\xd1\x85", 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {(lxb_char_t *) "\xd0\xb8", 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {(lxb_char_t *) "\xd0\xb9", 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\xba", 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {(lxb_char_t *) "\xd0\xbb", 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {(lxb_char_t *) "\xd0\xbc", 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {(lxb_char_t *) "\xd0\xbd", 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {(lxb_char_t *) "\xd0\xbe", 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {(lxb_char_t *) "\xd0\xbf", 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {(lxb_char_t *) "\xd1\x8f", 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {(lxb_char_t *) "\xd1\x80", 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {(lxb_char_t *) "\xd1\x81", 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {(lxb_char_t *) "\xd1\x82", 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {(lxb_char_t *) "\xd1\x83", 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {(lxb_char_t *) "\xd0\xb6", 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\xb2", 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {(lxb_char_t *) "\xd1\x8c", 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd1\x8b", 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {(lxb_char_t *) "\xd0\xb7", 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {(lxb_char_t *) "\xd1\x88", 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {(lxb_char_t *) "\xd1\x8d", 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {(lxb_char_t *) "\xd1\x89", 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {(lxb_char_t *) "\xd1\x87", 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {(lxb_char_t *) "\xd1\x8a", 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd0\xae", 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {(lxb_char_t *) "\xd0\x90", 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {(lxb_char_t *) "\xd0\x91", 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {(lxb_char_t *) "\xd0\xa6", 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {(lxb_char_t *) "\xd0\x94", 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {(lxb_char_t *) "\xd0\x95", 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {(lxb_char_t *) "\xd0\xa4", 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {(lxb_char_t *) "\xd0\x93", 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {(lxb_char_t *) "\xd0\xa5", 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {(lxb_char_t *) "\xd0\x98", 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {(lxb_char_t *) "\xd0\x99", 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\x9a", 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {(lxb_char_t *) "\xd0\x9b", 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {(lxb_char_t *) "\xd0\x9c", 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {(lxb_char_t *) "\xd0\x9d", 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {(lxb_char_t *) "\xd0\x9e", 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {(lxb_char_t *) "\xd0\x9f", 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {(lxb_char_t *) "\xd0\xaf", 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {(lxb_char_t *) "\xd0\xa0", 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {(lxb_char_t *) "\xd0\xa1", 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {(lxb_char_t *) "\xd0\xa2", 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {(lxb_char_t *) "\xd0\xa3", 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {(lxb_char_t *) "\xd0\x96", 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\x92", 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {(lxb_char_t *) "\xd0\xac", 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd0\xab", 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {(lxb_char_t *) "\xd0\x97", 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {(lxb_char_t *) "\xd0\xa8", 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {(lxb_char_t *) "\xd0\xad", 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {(lxb_char_t *) "\xd0\xa9", 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {(lxb_char_t *) "\xd0\xa7", 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {(lxb_char_t *) "\xd0\xaa", 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_macintosh[128] = 
{
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x91", 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa3", 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xac", 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb1", 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb2", 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xe2\x89\xa0", 3, 0x2260}, /* (NOT EQUAL TO) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xe2\x88\x9e", 3, 0x221E}, /* (INFINITY) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xe2\x89\xa4", 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xe2\x89\xa5", 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xe2\x88\x82", 3, 0x2202}, /* (PARTIAL DIFFERENTIAL) */
    {(lxb_char_t *) "\xe2\x88\x91", 3, 0x2211}, /* (N-ARY SUMMATION) */
    {(lxb_char_t *) "\xe2\x88\x8f", 3, 0x220F}, /* (N-ARY PRODUCT) */
    {(lxb_char_t *) "\xcf\x80", 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {(lxb_char_t *) "\xe2\x88\xab", 3, 0x222B}, /* (INTEGRAL) */
    {(lxb_char_t *) "\xc2\xaa", 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xba", 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xce\xa9", 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc2\xbf", 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {(lxb_char_t *) "\xc2\xa1", 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xe2\x88\x9a", 3, 0x221A}, /* (SQUARE ROOT) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x89\x88", 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {(lxb_char_t *) "\xe2\x88\x86", 3, 0x2206}, /* (INCREMENT) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x83", 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc5\x92", 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {(lxb_char_t *) "\xc5\x93", 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xe2\x97\x8a", 3, 0x25CA}, /* (LOZENGE) */
    {(lxb_char_t *) "\xc3\xbf", 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xb8", 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xe2\x81\x84", 3, 0x2044}, /* (FRACTION SLASH) */
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xef\xac\x81", 3, 0xFB01}, /* (LATIN SMALL LIGATURE FI) */
    {(lxb_char_t *) "\xef\xac\x82", 3, 0xFB02}, /* (LATIN SMALL LIGATURE FL) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x8c", 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xef\xa3\xbf", 3, 0xF8FF}, /* (<Private Use>) */
    {(lxb_char_t *) "\xc3\x92", 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc4\xb1", 2, 0x0131}, /* (LATIN SMALL LETTER DOTLESS I) */
    {(lxb_char_t *) "\xcb\x86", 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {(lxb_char_t *) "\xcb\x9c", 2, 0x02DC}, /* (SMALL TILDE) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xcb\x98", 2, 0x02D8}, /* (BREVE) */
    {(lxb_char_t *) "\xcb\x99", 2, 0x02D9}, /* (DOT ABOVE) */
    {(lxb_char_t *) "\xcb\x9a", 2, 0x02DA}, /* (RING ABOVE) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xcb\x9d", 2, 0x02DD}, /* (DOUBLE ACUTE ACCENT) */
    {(lxb_char_t *) "\xcb\x9b", 2, 0x02DB}, /* (OGONEK) */
    {(lxb_char_t *) "\xcb\x87", 2, 0x02C7}, /* (CARON) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1250[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x9a", 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xa4", 2, 0x0164}, /* (LATIN CAPITAL LETTER T WITH CARON) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc5\xb9", 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x9b", 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xa5", 2, 0x0165}, /* (LATIN SMALL LETTER T WITH CARON) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc5\xba", 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xcb\x87", 2, 0x02C7}, /* (CARON) */
    {(lxb_char_t *) "\xcb\x98", 2, 0x02D8}, /* (BREVE) */
    {(lxb_char_t *) "\xc5\x81", 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc4\x84", 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc5\x9e", 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc5\xbb", 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xcb\x9b", 2, 0x02DB}, /* (OGONEK) */
    {(lxb_char_t *) "\xc5\x82", 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc4\x85", 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc5\x9f", 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc4\xbd", 2, 0x013D}, /* (LATIN CAPITAL LETTER L WITH CARON) */
    {(lxb_char_t *) "\xcb\x9d", 2, 0x02DD}, /* (DOUBLE ACUTE ACCENT) */
    {(lxb_char_t *) "\xc4\xbe", 2, 0x013E}, /* (LATIN SMALL LETTER L WITH CARON) */
    {(lxb_char_t *) "\xc5\xbc", 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\x94", 2, 0x0154}, /* (LATIN CAPITAL LETTER R WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x82", 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\xb9", 2, 0x0139}, /* (LATIN CAPITAL LETTER L WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x86", 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x8c", 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x98", 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x9a", 2, 0x011A}, /* (LATIN CAPITAL LETTER E WITH CARON) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x8e", 2, 0x010E}, /* (LATIN CAPITAL LETTER D WITH CARON) */
    {(lxb_char_t *) "\xc4\x90", 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x83", 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x87", 2, 0x0147}, /* (LATIN CAPITAL LETTER N WITH CARON) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc5\x90", 2, 0x0150}, /* (LATIN CAPITAL LETTER O WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc5\x98", 2, 0x0158}, /* (LATIN CAPITAL LETTER R WITH CARON) */
    {(lxb_char_t *) "\xc5\xae", 2, 0x016E}, /* (LATIN CAPITAL LETTER U WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb0", 2, 0x0170}, /* (LATIN CAPITAL LETTER U WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x9d", 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xa2", 2, 0x0162}, /* (LATIN CAPITAL LETTER T WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc5\x95", 2, 0x0155}, /* (LATIN SMALL LETTER R WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x83", 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\xba", 2, 0x013A}, /* (LATIN SMALL LETTER L WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x87", 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\x8d", 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x99", 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x9b", 2, 0x011B}, /* (LATIN SMALL LETTER E WITH CARON) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x8f", 2, 0x010F}, /* (LATIN SMALL LETTER D WITH CARON) */
    {(lxb_char_t *) "\xc4\x91", 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc5\x84", 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x88", 2, 0x0148}, /* (LATIN SMALL LETTER N WITH CARON) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc5\x91", 2, 0x0151}, /* (LATIN SMALL LETTER O WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc5\x99", 2, 0x0159}, /* (LATIN SMALL LETTER R WITH CARON) */
    {(lxb_char_t *) "\xc5\xaf", 2, 0x016F}, /* (LATIN SMALL LETTER U WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb1", 2, 0x0171}, /* (LATIN SMALL LETTER U WITH DOUBLE ACUTE) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xbd", 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xa3", 2, 0x0163}, /* (LATIN SMALL LETTER T WITH CEDILLA) */
    {(lxb_char_t *) "\xcb\x99", 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1251[128] = 
{
    {(lxb_char_t *) "\xd0\x82", 2, 0x0402}, /* (CYRILLIC CAPITAL LETTER DJE) */
    {(lxb_char_t *) "\xd0\x83", 2, 0x0403}, /* (CYRILLIC CAPITAL LETTER GJE) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xd1\x93", 2, 0x0453}, /* (CYRILLIC SMALL LETTER GJE) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xd0\x89", 2, 0x0409}, /* (CYRILLIC CAPITAL LETTER LJE) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xd0\x8a", 2, 0x040A}, /* (CYRILLIC CAPITAL LETTER NJE) */
    {(lxb_char_t *) "\xd0\x8c", 2, 0x040C}, /* (CYRILLIC CAPITAL LETTER KJE) */
    {(lxb_char_t *) "\xd0\x8b", 2, 0x040B}, /* (CYRILLIC CAPITAL LETTER TSHE) */
    {(lxb_char_t *) "\xd0\x8f", 2, 0x040F}, /* (CYRILLIC CAPITAL LETTER DZHE) */
    {(lxb_char_t *) "\xd1\x92", 2, 0x0452}, /* (CYRILLIC SMALL LETTER DJE) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xd1\x99", 2, 0x0459}, /* (CYRILLIC SMALL LETTER LJE) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xd1\x9a", 2, 0x045A}, /* (CYRILLIC SMALL LETTER NJE) */
    {(lxb_char_t *) "\xd1\x9c", 2, 0x045C}, /* (CYRILLIC SMALL LETTER KJE) */
    {(lxb_char_t *) "\xd1\x9b", 2, 0x045B}, /* (CYRILLIC SMALL LETTER TSHE) */
    {(lxb_char_t *) "\xd1\x9f", 2, 0x045F}, /* (CYRILLIC SMALL LETTER DZHE) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xd0\x8e", 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {(lxb_char_t *) "\xd1\x9e", 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {(lxb_char_t *) "\xd0\x88", 2, 0x0408}, /* (CYRILLIC CAPITAL LETTER JE) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xd2\x90", 2, 0x0490}, /* (CYRILLIC CAPITAL LETTER GHE WITH UPTURN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xd0\x81", 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xd0\x84", 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xd0\x87", 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xd0\x86", 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xd1\x96", 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xd2\x91", 2, 0x0491}, /* (CYRILLIC SMALL LETTER GHE WITH UPTURN) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xd1\x91", 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {(lxb_char_t *) "\xe2\x84\x96", 3, 0x2116}, /* (NUMERO SIGN) */
    {(lxb_char_t *) "\xd1\x94", 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xd1\x98", 2, 0x0458}, /* (CYRILLIC SMALL LETTER JE) */
    {(lxb_char_t *) "\xd0\x85", 2, 0x0405}, /* (CYRILLIC CAPITAL LETTER DZE) */
    {(lxb_char_t *) "\xd1\x95", 2, 0x0455}, /* (CYRILLIC SMALL LETTER DZE) */
    {(lxb_char_t *) "\xd1\x97", 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {(lxb_char_t *) "\xd0\x90", 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {(lxb_char_t *) "\xd0\x91", 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {(lxb_char_t *) "\xd0\x92", 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {(lxb_char_t *) "\xd0\x93", 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {(lxb_char_t *) "\xd0\x94", 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {(lxb_char_t *) "\xd0\x95", 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {(lxb_char_t *) "\xd0\x96", 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\x97", 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {(lxb_char_t *) "\xd0\x98", 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {(lxb_char_t *) "\xd0\x99", 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\x9a", 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {(lxb_char_t *) "\xd0\x9b", 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {(lxb_char_t *) "\xd0\x9c", 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {(lxb_char_t *) "\xd0\x9d", 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {(lxb_char_t *) "\xd0\x9e", 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {(lxb_char_t *) "\xd0\x9f", 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {(lxb_char_t *) "\xd0\xa0", 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {(lxb_char_t *) "\xd0\xa1", 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {(lxb_char_t *) "\xd0\xa2", 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {(lxb_char_t *) "\xd0\xa3", 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {(lxb_char_t *) "\xd0\xa4", 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {(lxb_char_t *) "\xd0\xa5", 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {(lxb_char_t *) "\xd0\xa6", 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {(lxb_char_t *) "\xd0\xa7", 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {(lxb_char_t *) "\xd0\xa8", 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {(lxb_char_t *) "\xd0\xa9", 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {(lxb_char_t *) "\xd0\xaa", 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd0\xab", 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {(lxb_char_t *) "\xd0\xac", 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd0\xad", 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {(lxb_char_t *) "\xd0\xae", 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {(lxb_char_t *) "\xd0\xaf", 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {(lxb_char_t *) "\xd0\xb0", 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {(lxb_char_t *) "\xd0\xb1", 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {(lxb_char_t *) "\xd0\xb2", 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {(lxb_char_t *) "\xd0\xb3", 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {(lxb_char_t *) "\xd0\xb4", 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {(lxb_char_t *) "\xd0\xb5", 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {(lxb_char_t *) "\xd0\xb6", 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\xb7", 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {(lxb_char_t *) "\xd0\xb8", 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {(lxb_char_t *) "\xd0\xb9", 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\xba", 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {(lxb_char_t *) "\xd0\xbb", 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {(lxb_char_t *) "\xd0\xbc", 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {(lxb_char_t *) "\xd0\xbd", 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {(lxb_char_t *) "\xd0\xbe", 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {(lxb_char_t *) "\xd0\xbf", 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {(lxb_char_t *) "\xd1\x80", 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {(lxb_char_t *) "\xd1\x81", 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {(lxb_char_t *) "\xd1\x82", 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {(lxb_char_t *) "\xd1\x83", 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {(lxb_char_t *) "\xd1\x84", 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {(lxb_char_t *) "\xd1\x85", 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {(lxb_char_t *) "\xd1\x86", 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {(lxb_char_t *) "\xd1\x87", 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {(lxb_char_t *) "\xd1\x88", 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {(lxb_char_t *) "\xd1\x89", 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {(lxb_char_t *) "\xd1\x8a", 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd1\x8b", 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {(lxb_char_t *) "\xd1\x8c", 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd1\x8d", 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {(lxb_char_t *) "\xd1\x8e", 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {(lxb_char_t *) "\xd1\x8f", 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1252[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xcb\x86", 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x92", 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xcb\x9c", 2, 0x02DC}, /* (SMALL TILDE) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x93", 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc5\xb8", 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc2\xa1", 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc2\xaa", 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc2\xba", 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {(lxb_char_t *) "\xc2\xbf", 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x83", 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x8c", 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x90", 2, 0x00D0}, /* (LATIN CAPITAL LETTER ETH) */
    {(lxb_char_t *) "\xc3\x91", 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\x92", 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x9d", 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9e", 2, 0x00DE}, /* (LATIN CAPITAL LETTER THORN) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa3", 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xac", 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb0", 2, 0x00F0}, /* (LATIN SMALL LETTER ETH) */
    {(lxb_char_t *) "\xc3\xb1", 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb2", 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xbd", 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbe", 2, 0x00FE}, /* (LATIN SMALL LETTER THORN) */
    {(lxb_char_t *) "\xc3\xbf", 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1253[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xce\x85", 2, 0x0385}, /* (GREEK DIALYTIKA TONOS) */
    {(lxb_char_t *) "\xce\x86", 2, 0x0386}, /* (GREEK CAPITAL LETTER ALPHA WITH TONOS) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xe2\x80\x95", 3, 0x2015}, /* (HORIZONTAL BAR) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xce\x84", 2, 0x0384}, /* (GREEK TONOS) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xce\x88", 2, 0x0388}, /* (GREEK CAPITAL LETTER EPSILON WITH TONOS) */
    {(lxb_char_t *) "\xce\x89", 2, 0x0389}, /* (GREEK CAPITAL LETTER ETA WITH TONOS) */
    {(lxb_char_t *) "\xce\x8a", 2, 0x038A}, /* (GREEK CAPITAL LETTER IOTA WITH TONOS) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xce\x8c", 2, 0x038C}, /* (GREEK CAPITAL LETTER OMICRON WITH TONOS) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xce\x8e", 2, 0x038E}, /* (GREEK CAPITAL LETTER UPSILON WITH TONOS) */
    {(lxb_char_t *) "\xce\x8f", 2, 0x038F}, /* (GREEK CAPITAL LETTER OMEGA WITH TONOS) */
    {(lxb_char_t *) "\xce\x90", 2, 0x0390}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS) */
    {(lxb_char_t *) "\xce\x91", 2, 0x0391}, /* (GREEK CAPITAL LETTER ALPHA) */
    {(lxb_char_t *) "\xce\x92", 2, 0x0392}, /* (GREEK CAPITAL LETTER BETA) */
    {(lxb_char_t *) "\xce\x93", 2, 0x0393}, /* (GREEK CAPITAL LETTER GAMMA) */
    {(lxb_char_t *) "\xce\x94", 2, 0x0394}, /* (GREEK CAPITAL LETTER DELTA) */
    {(lxb_char_t *) "\xce\x95", 2, 0x0395}, /* (GREEK CAPITAL LETTER EPSILON) */
    {(lxb_char_t *) "\xce\x96", 2, 0x0396}, /* (GREEK CAPITAL LETTER ZETA) */
    {(lxb_char_t *) "\xce\x97", 2, 0x0397}, /* (GREEK CAPITAL LETTER ETA) */
    {(lxb_char_t *) "\xce\x98", 2, 0x0398}, /* (GREEK CAPITAL LETTER THETA) */
    {(lxb_char_t *) "\xce\x99", 2, 0x0399}, /* (GREEK CAPITAL LETTER IOTA) */
    {(lxb_char_t *) "\xce\x9a", 2, 0x039A}, /* (GREEK CAPITAL LETTER KAPPA) */
    {(lxb_char_t *) "\xce\x9b", 2, 0x039B}, /* (GREEK CAPITAL LETTER LAMDA) */
    {(lxb_char_t *) "\xce\x9c", 2, 0x039C}, /* (GREEK CAPITAL LETTER MU) */
    {(lxb_char_t *) "\xce\x9d", 2, 0x039D}, /* (GREEK CAPITAL LETTER NU) */
    {(lxb_char_t *) "\xce\x9e", 2, 0x039E}, /* (GREEK CAPITAL LETTER XI) */
    {(lxb_char_t *) "\xce\x9f", 2, 0x039F}, /* (GREEK CAPITAL LETTER OMICRON) */
    {(lxb_char_t *) "\xce\xa0", 2, 0x03A0}, /* (GREEK CAPITAL LETTER PI) */
    {(lxb_char_t *) "\xce\xa1", 2, 0x03A1}, /* (GREEK CAPITAL LETTER RHO) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xce\xa3", 2, 0x03A3}, /* (GREEK CAPITAL LETTER SIGMA) */
    {(lxb_char_t *) "\xce\xa4", 2, 0x03A4}, /* (GREEK CAPITAL LETTER TAU) */
    {(lxb_char_t *) "\xce\xa5", 2, 0x03A5}, /* (GREEK CAPITAL LETTER UPSILON) */
    {(lxb_char_t *) "\xce\xa6", 2, 0x03A6}, /* (GREEK CAPITAL LETTER PHI) */
    {(lxb_char_t *) "\xce\xa7", 2, 0x03A7}, /* (GREEK CAPITAL LETTER CHI) */
    {(lxb_char_t *) "\xce\xa8", 2, 0x03A8}, /* (GREEK CAPITAL LETTER PSI) */
    {(lxb_char_t *) "\xce\xa9", 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {(lxb_char_t *) "\xce\xaa", 2, 0x03AA}, /* (GREEK CAPITAL LETTER IOTA WITH DIALYTIKA) */
    {(lxb_char_t *) "\xce\xab", 2, 0x03AB}, /* (GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA) */
    {(lxb_char_t *) "\xce\xac", 2, 0x03AC}, /* (GREEK SMALL LETTER ALPHA WITH TONOS) */
    {(lxb_char_t *) "\xce\xad", 2, 0x03AD}, /* (GREEK SMALL LETTER EPSILON WITH TONOS) */
    {(lxb_char_t *) "\xce\xae", 2, 0x03AE}, /* (GREEK SMALL LETTER ETA WITH TONOS) */
    {(lxb_char_t *) "\xce\xaf", 2, 0x03AF}, /* (GREEK SMALL LETTER IOTA WITH TONOS) */
    {(lxb_char_t *) "\xce\xb0", 2, 0x03B0}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS) */
    {(lxb_char_t *) "\xce\xb1", 2, 0x03B1}, /* (GREEK SMALL LETTER ALPHA) */
    {(lxb_char_t *) "\xce\xb2", 2, 0x03B2}, /* (GREEK SMALL LETTER BETA) */
    {(lxb_char_t *) "\xce\xb3", 2, 0x03B3}, /* (GREEK SMALL LETTER GAMMA) */
    {(lxb_char_t *) "\xce\xb4", 2, 0x03B4}, /* (GREEK SMALL LETTER DELTA) */
    {(lxb_char_t *) "\xce\xb5", 2, 0x03B5}, /* (GREEK SMALL LETTER EPSILON) */
    {(lxb_char_t *) "\xce\xb6", 2, 0x03B6}, /* (GREEK SMALL LETTER ZETA) */
    {(lxb_char_t *) "\xce\xb7", 2, 0x03B7}, /* (GREEK SMALL LETTER ETA) */
    {(lxb_char_t *) "\xce\xb8", 2, 0x03B8}, /* (GREEK SMALL LETTER THETA) */
    {(lxb_char_t *) "\xce\xb9", 2, 0x03B9}, /* (GREEK SMALL LETTER IOTA) */
    {(lxb_char_t *) "\xce\xba", 2, 0x03BA}, /* (GREEK SMALL LETTER KAPPA) */
    {(lxb_char_t *) "\xce\xbb", 2, 0x03BB}, /* (GREEK SMALL LETTER LAMDA) */
    {(lxb_char_t *) "\xce\xbc", 2, 0x03BC}, /* (GREEK SMALL LETTER MU) */
    {(lxb_char_t *) "\xce\xbd", 2, 0x03BD}, /* (GREEK SMALL LETTER NU) */
    {(lxb_char_t *) "\xce\xbe", 2, 0x03BE}, /* (GREEK SMALL LETTER XI) */
    {(lxb_char_t *) "\xce\xbf", 2, 0x03BF}, /* (GREEK SMALL LETTER OMICRON) */
    {(lxb_char_t *) "\xcf\x80", 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {(lxb_char_t *) "\xcf\x81", 2, 0x03C1}, /* (GREEK SMALL LETTER RHO) */
    {(lxb_char_t *) "\xcf\x82", 2, 0x03C2}, /* (GREEK SMALL LETTER FINAL SIGMA) */
    {(lxb_char_t *) "\xcf\x83", 2, 0x03C3}, /* (GREEK SMALL LETTER SIGMA) */
    {(lxb_char_t *) "\xcf\x84", 2, 0x03C4}, /* (GREEK SMALL LETTER TAU) */
    {(lxb_char_t *) "\xcf\x85", 2, 0x03C5}, /* (GREEK SMALL LETTER UPSILON) */
    {(lxb_char_t *) "\xcf\x86", 2, 0x03C6}, /* (GREEK SMALL LETTER PHI) */
    {(lxb_char_t *) "\xcf\x87", 2, 0x03C7}, /* (GREEK SMALL LETTER CHI) */
    {(lxb_char_t *) "\xcf\x88", 2, 0x03C8}, /* (GREEK SMALL LETTER PSI) */
    {(lxb_char_t *) "\xcf\x89", 2, 0x03C9}, /* (GREEK SMALL LETTER OMEGA) */
    {(lxb_char_t *) "\xcf\x8a", 2, 0x03CA}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA) */
    {(lxb_char_t *) "\xcf\x8b", 2, 0x03CB}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA) */
    {(lxb_char_t *) "\xcf\x8c", 2, 0x03CC}, /* (GREEK SMALL LETTER OMICRON WITH TONOS) */
    {(lxb_char_t *) "\xcf\x8d", 2, 0x03CD}, /* (GREEK SMALL LETTER UPSILON WITH TONOS) */
    {(lxb_char_t *) "\xcf\x8e", 2, 0x03CE}, /* (GREEK SMALL LETTER OMEGA WITH TONOS) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1254[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xcb\x86", 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x92", 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xcb\x9c", 2, 0x02DC}, /* (SMALL TILDE) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x93", 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc5\xb8", 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc2\xa1", 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc2\xaa", 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc2\xba", 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {(lxb_char_t *) "\xc2\xbf", 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x83", 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x8c", 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x9e", 2, 0x011E}, /* (LATIN CAPITAL LETTER G WITH BREVE) */
    {(lxb_char_t *) "\xc3\x91", 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\x92", 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\xb0", 2, 0x0130}, /* (LATIN CAPITAL LETTER I WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\x9e", 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xa3", 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xac", 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x9f", 2, 0x011F}, /* (LATIN SMALL LETTER G WITH BREVE) */
    {(lxb_char_t *) "\xc3\xb1", 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb2", 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\xb1", 2, 0x0131}, /* (LATIN SMALL LETTER DOTLESS I) */
    {(lxb_char_t *) "\xc5\x9f", 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xbf", 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1255[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xcb\x86", 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xcb\x9c", 2, 0x02DC}, /* (SMALL TILDE) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc2\xa1", 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xe2\x82\xaa", 3, 0x20AA}, /* (NEW SHEQEL SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {(lxb_char_t *) "\xc2\xbf", 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {(lxb_char_t *) "\xd6\xb0", 2, 0x05B0}, /* (HEBREW POINT SHEVA) */
    {(lxb_char_t *) "\xd6\xb1", 2, 0x05B1}, /* (HEBREW POINT HATAF SEGOL) */
    {(lxb_char_t *) "\xd6\xb2", 2, 0x05B2}, /* (HEBREW POINT HATAF PATAH) */
    {(lxb_char_t *) "\xd6\xb3", 2, 0x05B3}, /* (HEBREW POINT HATAF QAMATS) */
    {(lxb_char_t *) "\xd6\xb4", 2, 0x05B4}, /* (HEBREW POINT HIRIQ) */
    {(lxb_char_t *) "\xd6\xb5", 2, 0x05B5}, /* (HEBREW POINT TSERE) */
    {(lxb_char_t *) "\xd6\xb6", 2, 0x05B6}, /* (HEBREW POINT SEGOL) */
    {(lxb_char_t *) "\xd6\xb7", 2, 0x05B7}, /* (HEBREW POINT PATAH) */
    {(lxb_char_t *) "\xd6\xb8", 2, 0x05B8}, /* (HEBREW POINT QAMATS) */
    {(lxb_char_t *) "\xd6\xb9", 2, 0x05B9}, /* (HEBREW POINT HOLAM) */
    {(lxb_char_t *) "\xd6\xba", 2, 0x05BA}, /* (HEBREW POINT HOLAM HASER FOR VAV) */
    {(lxb_char_t *) "\xd6\xbb", 2, 0x05BB}, /* (HEBREW POINT QUBUTS) */
    {(lxb_char_t *) "\xd6\xbc", 2, 0x05BC}, /* (HEBREW POINT DAGESH OR MAPIQ) */
    {(lxb_char_t *) "\xd6\xbd", 2, 0x05BD}, /* (HEBREW POINT METEG) */
    {(lxb_char_t *) "\xd6\xbe", 2, 0x05BE}, /* (HEBREW PUNCTUATION MAQAF) */
    {(lxb_char_t *) "\xd6\xbf", 2, 0x05BF}, /* (HEBREW POINT RAFE) */
    {(lxb_char_t *) "\xd7\x80", 2, 0x05C0}, /* (HEBREW PUNCTUATION PASEQ) */
    {(lxb_char_t *) "\xd7\x81", 2, 0x05C1}, /* (HEBREW POINT SHIN DOT) */
    {(lxb_char_t *) "\xd7\x82", 2, 0x05C2}, /* (HEBREW POINT SIN DOT) */
    {(lxb_char_t *) "\xd7\x83", 2, 0x05C3}, /* (HEBREW PUNCTUATION SOF PASUQ) */
    {(lxb_char_t *) "\xd7\xb0", 2, 0x05F0}, /* (HEBREW LIGATURE YIDDISH DOUBLE VAV) */
    {(lxb_char_t *) "\xd7\xb1", 2, 0x05F1}, /* (HEBREW LIGATURE YIDDISH VAV YOD) */
    {(lxb_char_t *) "\xd7\xb2", 2, 0x05F2}, /* (HEBREW LIGATURE YIDDISH DOUBLE YOD) */
    {(lxb_char_t *) "\xd7\xb3", 2, 0x05F3}, /* (HEBREW PUNCTUATION GERESH) */
    {(lxb_char_t *) "\xd7\xb4", 2, 0x05F4}, /* (HEBREW PUNCTUATION GERSHAYIM) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xd7\x90", 2, 0x05D0}, /* (HEBREW LETTER ALEF) */
    {(lxb_char_t *) "\xd7\x91", 2, 0x05D1}, /* (HEBREW LETTER BET) */
    {(lxb_char_t *) "\xd7\x92", 2, 0x05D2}, /* (HEBREW LETTER GIMEL) */
    {(lxb_char_t *) "\xd7\x93", 2, 0x05D3}, /* (HEBREW LETTER DALET) */
    {(lxb_char_t *) "\xd7\x94", 2, 0x05D4}, /* (HEBREW LETTER HE) */
    {(lxb_char_t *) "\xd7\x95", 2, 0x05D5}, /* (HEBREW LETTER VAV) */
    {(lxb_char_t *) "\xd7\x96", 2, 0x05D6}, /* (HEBREW LETTER ZAYIN) */
    {(lxb_char_t *) "\xd7\x97", 2, 0x05D7}, /* (HEBREW LETTER HET) */
    {(lxb_char_t *) "\xd7\x98", 2, 0x05D8}, /* (HEBREW LETTER TET) */
    {(lxb_char_t *) "\xd7\x99", 2, 0x05D9}, /* (HEBREW LETTER YOD) */
    {(lxb_char_t *) "\xd7\x9a", 2, 0x05DA}, /* (HEBREW LETTER FINAL KAF) */
    {(lxb_char_t *) "\xd7\x9b", 2, 0x05DB}, /* (HEBREW LETTER KAF) */
    {(lxb_char_t *) "\xd7\x9c", 2, 0x05DC}, /* (HEBREW LETTER LAMED) */
    {(lxb_char_t *) "\xd7\x9d", 2, 0x05DD}, /* (HEBREW LETTER FINAL MEM) */
    {(lxb_char_t *) "\xd7\x9e", 2, 0x05DE}, /* (HEBREW LETTER MEM) */
    {(lxb_char_t *) "\xd7\x9f", 2, 0x05DF}, /* (HEBREW LETTER FINAL NUN) */
    {(lxb_char_t *) "\xd7\xa0", 2, 0x05E0}, /* (HEBREW LETTER NUN) */
    {(lxb_char_t *) "\xd7\xa1", 2, 0x05E1}, /* (HEBREW LETTER SAMEKH) */
    {(lxb_char_t *) "\xd7\xa2", 2, 0x05E2}, /* (HEBREW LETTER AYIN) */
    {(lxb_char_t *) "\xd7\xa3", 2, 0x05E3}, /* (HEBREW LETTER FINAL PE) */
    {(lxb_char_t *) "\xd7\xa4", 2, 0x05E4}, /* (HEBREW LETTER PE) */
    {(lxb_char_t *) "\xd7\xa5", 2, 0x05E5}, /* (HEBREW LETTER FINAL TSADI) */
    {(lxb_char_t *) "\xd7\xa6", 2, 0x05E6}, /* (HEBREW LETTER TSADI) */
    {(lxb_char_t *) "\xd7\xa7", 2, 0x05E7}, /* (HEBREW LETTER QOF) */
    {(lxb_char_t *) "\xd7\xa8", 2, 0x05E8}, /* (HEBREW LETTER RESH) */
    {(lxb_char_t *) "\xd7\xa9", 2, 0x05E9}, /* (HEBREW LETTER SHIN) */
    {(lxb_char_t *) "\xd7\xaa", 2, 0x05EA}, /* (HEBREW LETTER TAV) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xe2\x80\x8e", 3, 0x200E}, /* (LEFT-TO-RIGHT MARK) */
    {(lxb_char_t *) "\xe2\x80\x8f", 3, 0x200F}, /* (RIGHT-TO-LEFT MARK) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1256[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xd9\xbe", 2, 0x067E}, /* (ARABIC LETTER PEH) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xcb\x86", 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xd9\xb9", 2, 0x0679}, /* (ARABIC LETTER TTEH) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x92", 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {(lxb_char_t *) "\xda\x86", 2, 0x0686}, /* (ARABIC LETTER TCHEH) */
    {(lxb_char_t *) "\xda\x98", 2, 0x0698}, /* (ARABIC LETTER JEH) */
    {(lxb_char_t *) "\xda\x88", 2, 0x0688}, /* (ARABIC LETTER DDAL) */
    {(lxb_char_t *) "\xda\xaf", 2, 0x06AF}, /* (ARABIC LETTER GAF) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xda\xa9", 2, 0x06A9}, /* (ARABIC LETTER KEHEH) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xda\x91", 2, 0x0691}, /* (ARABIC LETTER RREH) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x93", 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {(lxb_char_t *) "\xe2\x80\x8c", 3, 0x200C}, /* (ZERO WIDTH NON-JOINER) */
    {(lxb_char_t *) "\xe2\x80\x8d", 3, 0x200D}, /* (ZERO WIDTH JOINER) */
    {(lxb_char_t *) "\xda\xba", 2, 0x06BA}, /* (ARABIC LETTER NOON GHUNNA) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xd8\x8c", 2, 0x060C}, /* (ARABIC COMMA) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xda\xbe", 2, 0x06BE}, /* (ARABIC LETTER HEH DOACHASHMEE) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xd8\x9b", 2, 0x061B}, /* (ARABIC SEMICOLON) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {(lxb_char_t *) "\xd8\x9f", 2, 0x061F}, /* (ARABIC QUESTION MARK) */
    {(lxb_char_t *) "\xdb\x81", 2, 0x06C1}, /* (ARABIC LETTER HEH GOAL) */
    {(lxb_char_t *) "\xd8\xa1", 2, 0x0621}, /* (ARABIC LETTER HAMZA) */
    {(lxb_char_t *) "\xd8\xa2", 2, 0x0622}, /* (ARABIC LETTER ALEF WITH MADDA ABOVE) */
    {(lxb_char_t *) "\xd8\xa3", 2, 0x0623}, /* (ARABIC LETTER ALEF WITH HAMZA ABOVE) */
    {(lxb_char_t *) "\xd8\xa4", 2, 0x0624}, /* (ARABIC LETTER WAW WITH HAMZA ABOVE) */
    {(lxb_char_t *) "\xd8\xa5", 2, 0x0625}, /* (ARABIC LETTER ALEF WITH HAMZA BELOW) */
    {(lxb_char_t *) "\xd8\xa6", 2, 0x0626}, /* (ARABIC LETTER YEH WITH HAMZA ABOVE) */
    {(lxb_char_t *) "\xd8\xa7", 2, 0x0627}, /* (ARABIC LETTER ALEF) */
    {(lxb_char_t *) "\xd8\xa8", 2, 0x0628}, /* (ARABIC LETTER BEH) */
    {(lxb_char_t *) "\xd8\xa9", 2, 0x0629}, /* (ARABIC LETTER TEH MARBUTA) */
    {(lxb_char_t *) "\xd8\xaa", 2, 0x062A}, /* (ARABIC LETTER TEH) */
    {(lxb_char_t *) "\xd8\xab", 2, 0x062B}, /* (ARABIC LETTER THEH) */
    {(lxb_char_t *) "\xd8\xac", 2, 0x062C}, /* (ARABIC LETTER JEEM) */
    {(lxb_char_t *) "\xd8\xad", 2, 0x062D}, /* (ARABIC LETTER HAH) */
    {(lxb_char_t *) "\xd8\xae", 2, 0x062E}, /* (ARABIC LETTER KHAH) */
    {(lxb_char_t *) "\xd8\xaf", 2, 0x062F}, /* (ARABIC LETTER DAL) */
    {(lxb_char_t *) "\xd8\xb0", 2, 0x0630}, /* (ARABIC LETTER THAL) */
    {(lxb_char_t *) "\xd8\xb1", 2, 0x0631}, /* (ARABIC LETTER REH) */
    {(lxb_char_t *) "\xd8\xb2", 2, 0x0632}, /* (ARABIC LETTER ZAIN) */
    {(lxb_char_t *) "\xd8\xb3", 2, 0x0633}, /* (ARABIC LETTER SEEN) */
    {(lxb_char_t *) "\xd8\xb4", 2, 0x0634}, /* (ARABIC LETTER SHEEN) */
    {(lxb_char_t *) "\xd8\xb5", 2, 0x0635}, /* (ARABIC LETTER SAD) */
    {(lxb_char_t *) "\xd8\xb6", 2, 0x0636}, /* (ARABIC LETTER DAD) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xd8\xb7", 2, 0x0637}, /* (ARABIC LETTER TAH) */
    {(lxb_char_t *) "\xd8\xb8", 2, 0x0638}, /* (ARABIC LETTER ZAH) */
    {(lxb_char_t *) "\xd8\xb9", 2, 0x0639}, /* (ARABIC LETTER AIN) */
    {(lxb_char_t *) "\xd8\xba", 2, 0x063A}, /* (ARABIC LETTER GHAIN) */
    {(lxb_char_t *) "\xd9\x80", 2, 0x0640}, /* (ARABIC TATWEEL) */
    {(lxb_char_t *) "\xd9\x81", 2, 0x0641}, /* (ARABIC LETTER FEH) */
    {(lxb_char_t *) "\xd9\x82", 2, 0x0642}, /* (ARABIC LETTER QAF) */
    {(lxb_char_t *) "\xd9\x83", 2, 0x0643}, /* (ARABIC LETTER KAF) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xd9\x84", 2, 0x0644}, /* (ARABIC LETTER LAM) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xd9\x85", 2, 0x0645}, /* (ARABIC LETTER MEEM) */
    {(lxb_char_t *) "\xd9\x86", 2, 0x0646}, /* (ARABIC LETTER NOON) */
    {(lxb_char_t *) "\xd9\x87", 2, 0x0647}, /* (ARABIC LETTER HEH) */
    {(lxb_char_t *) "\xd9\x88", 2, 0x0648}, /* (ARABIC LETTER WAW) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xd9\x89", 2, 0x0649}, /* (ARABIC LETTER ALEF MAKSURA) */
    {(lxb_char_t *) "\xd9\x8a", 2, 0x064A}, /* (ARABIC LETTER YEH) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xd9\x8b", 2, 0x064B}, /* (ARABIC FATHATAN) */
    {(lxb_char_t *) "\xd9\x8c", 2, 0x064C}, /* (ARABIC DAMMATAN) */
    {(lxb_char_t *) "\xd9\x8d", 2, 0x064D}, /* (ARABIC KASRATAN) */
    {(lxb_char_t *) "\xd9\x8e", 2, 0x064E}, /* (ARABIC FATHA) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xd9\x8f", 2, 0x064F}, /* (ARABIC DAMMA) */
    {(lxb_char_t *) "\xd9\x90", 2, 0x0650}, /* (ARABIC KASRA) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xd9\x91", 2, 0x0651}, /* (ARABIC SHADDA) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xd9\x92", 2, 0x0652}, /* (ARABIC SUKUN) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xe2\x80\x8e", 3, 0x200E}, /* (LEFT-TO-RIGHT MARK) */
    {(lxb_char_t *) "\xe2\x80\x8f", 3, 0x200F}, /* (RIGHT-TO-LEFT MARK) */
    {(lxb_char_t *) "\xdb\x92", 2, 0x06D2}, /* (ARABIC LETTER YEH BARREE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1257[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xcb\x87", 2, 0x02C7}, /* (CARON) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xcb\x9b", 2, 0x02DB}, /* (OGONEK) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc5\x96", 2, 0x0156}, /* (LATIN CAPITAL LETTER R WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc5\x97", 2, 0x0157}, /* (LATIN SMALL LETTER R WITH CEDILLA) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc4\x84", 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\xae", 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x80", 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc4\x86", 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc4\x98", 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x92", 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\x8c", 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xb9", 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x96", 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\xa2", 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xb6", 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xaa", 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\xbb", 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa0", 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\x83", 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x85", 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x8c", 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc3\x95", 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc5\xb2", 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc5\x81", 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc5\x9a", 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xaa", 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xbb", 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\xbd", 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc4\x85", 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {(lxb_char_t *) "\xc4\xaf", 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x81", 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {(lxb_char_t *) "\xc4\x87", 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc4\x99", 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {(lxb_char_t *) "\xc4\x93", 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {(lxb_char_t *) "\xc4\x8d", 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xba", 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {(lxb_char_t *) "\xc4\x97", 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc4\xa3", 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xb7", 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {(lxb_char_t *) "\xc4\xab", 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {(lxb_char_t *) "\xc4\xbc", 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {(lxb_char_t *) "\xc5\xa1", 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {(lxb_char_t *) "\xc5\x84", 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x86", 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc5\x8d", 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {(lxb_char_t *) "\xc3\xb5", 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc5\xb3", 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {(lxb_char_t *) "\xc5\x82", 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {(lxb_char_t *) "\xc5\x9b", 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {(lxb_char_t *) "\xc5\xab", 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc5\xbc", 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {(lxb_char_t *) "\xc5\xbe", 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {(lxb_char_t *) "\xcb\x99", 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1258[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x9a", 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xe2\x80\xa1", 3, 0x2021}, /* (DOUBLE DAGGER) */
    {(lxb_char_t *) "\xcb\x86", 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {(lxb_char_t *) "\xe2\x80\xb0", 3, 0x2030}, /* (PER MILLE SIGN) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xb9", 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x92", 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xcb\x9c", 2, 0x02DC}, /* (SMALL TILDE) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xba", 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc5\x93", 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc5\xb8", 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xc2\xa1", 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {(lxb_char_t *) "\xc2\xa2", 2, 0x00A2}, /* (CENT SIGN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa4", 2, 0x00A4}, /* (CURRENCY SIGN) */
    {(lxb_char_t *) "\xc2\xa5", 2, 0x00A5}, /* (YEN SIGN) */
    {(lxb_char_t *) "\xc2\xa6", 2, 0x00A6}, /* (BROKEN BAR) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xc2\xa8", 2, 0x00A8}, /* (DIAERESIS) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xc2\xaa", 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xc2\xad", 2, 0x00AD}, /* (SOFT HYPHEN) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xaf", 2, 0x00AF}, /* (MACRON) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xc2\xb2", 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {(lxb_char_t *) "\xc2\xb3", 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {(lxb_char_t *) "\xc2\xb4", 2, 0x00B4}, /* (ACUTE ACCENT) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xc2\xb7", 2, 0x00B7}, /* (MIDDLE DOT) */
    {(lxb_char_t *) "\xc2\xb8", 2, 0x00B8}, /* (CEDILLA) */
    {(lxb_char_t *) "\xc2\xb9", 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {(lxb_char_t *) "\xc2\xba", 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbc", 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {(lxb_char_t *) "\xc2\xbd", 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {(lxb_char_t *) "\xc2\xbe", 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {(lxb_char_t *) "\xc2\xbf", 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {(lxb_char_t *) "\xc3\x80", 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x81", 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x82", 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x82", 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\x84", 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x85", 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\x86", 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {(lxb_char_t *) "\xc3\x87", 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\x88", 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x89", 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8a", 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8b", 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xcc\x80", 2, 0x0300}, /* (COMBINING GRAVE ACCENT) */
    {(lxb_char_t *) "\xc3\x8d", 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x8e", 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x8f", 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x90", 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc3\x91", 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xcc\x89", 2, 0x0309}, /* (COMBINING HOOK ABOVE) */
    {(lxb_char_t *) "\xc3\x93", 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x94", 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc6\xa0", 2, 0x01A0}, /* (LATIN CAPITAL LETTER O WITH HORN) */
    {(lxb_char_t *) "\xc3\x96", 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\x97", 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {(lxb_char_t *) "\xc3\x98", 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\x99", 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\x9a", 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\x9b", 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\x9c", 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc6\xaf", 2, 0x01AF}, /* (LATIN CAPITAL LETTER U WITH HORN) */
    {(lxb_char_t *) "\xcc\x83", 2, 0x0303}, /* (COMBINING TILDE) */
    {(lxb_char_t *) "\xc3\x9f", 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {(lxb_char_t *) "\xc3\xa0", 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa1", 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xa2", 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc4\x83", 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {(lxb_char_t *) "\xc3\xa4", 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xa5", 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {(lxb_char_t *) "\xc3\xa6", 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {(lxb_char_t *) "\xc3\xa7", 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {(lxb_char_t *) "\xc3\xa8", 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xa9", 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xaa", 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xab", 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {(lxb_char_t *) "\xcc\x81", 2, 0x0301}, /* (COMBINING ACUTE ACCENT) */
    {(lxb_char_t *) "\xc3\xad", 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xae", 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xaf", 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {(lxb_char_t *) "\xc4\x91", 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {(lxb_char_t *) "\xc3\xb1", 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {(lxb_char_t *) "\xcc\xa3", 2, 0x0323}, /* (COMBINING DOT BELOW) */
    {(lxb_char_t *) "\xc3\xb3", 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xb4", 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc6\xa1", 2, 0x01A1}, /* (LATIN SMALL LETTER O WITH HORN) */
    {(lxb_char_t *) "\xc3\xb6", 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xc3\xb8", 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {(lxb_char_t *) "\xc3\xb9", 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {(lxb_char_t *) "\xc3\xba", 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {(lxb_char_t *) "\xc3\xbb", 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {(lxb_char_t *) "\xc3\xbc", 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {(lxb_char_t *) "\xc6\xb0", 2, 0x01B0}, /* (LATIN SMALL LETTER U WITH HORN) */
    {(lxb_char_t *) "\xe2\x82\xab", 3, 0x20AB}, /* (DONG SIGN) */
    {(lxb_char_t *) "\xc3\xbf", 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_874[128] = 
{
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
    {(lxb_char_t *) "\xc2\x81", 2, 0x0081}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x82", 2, 0x0082}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x83", 2, 0x0083}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x84", 2, 0x0084}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xc2\x86", 2, 0x0086}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x87", 2, 0x0087}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x88", 2, 0x0088}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x89", 2, 0x0089}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8a", 2, 0x008A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8b", 2, 0x008B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8c", 2, 0x008C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8d", 2, 0x008D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8e", 2, 0x008E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x8f", 2, 0x008F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x90", 2, 0x0090}, /* (<control>) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xc2\x98", 2, 0x0098}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x99", 2, 0x0099}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9a", 2, 0x009A}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9b", 2, 0x009B}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9c", 2, 0x009C}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9d", 2, 0x009D}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9e", 2, 0x009E}, /* (<control>) */
    {(lxb_char_t *) "\xc2\x9f", 2, 0x009F}, /* (<control>) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xe0\xb8\x81", 3, 0x0E01}, /* (THAI CHARACTER KO KAI) */
    {(lxb_char_t *) "\xe0\xb8\x82", 3, 0x0E02}, /* (THAI CHARACTER KHO KHAI) */
    {(lxb_char_t *) "\xe0\xb8\x83", 3, 0x0E03}, /* (THAI CHARACTER KHO KHUAT) */
    {(lxb_char_t *) "\xe0\xb8\x84", 3, 0x0E04}, /* (THAI CHARACTER KHO KHWAI) */
    {(lxb_char_t *) "\xe0\xb8\x85", 3, 0x0E05}, /* (THAI CHARACTER KHO KHON) */
    {(lxb_char_t *) "\xe0\xb8\x86", 3, 0x0E06}, /* (THAI CHARACTER KHO RAKHANG) */
    {(lxb_char_t *) "\xe0\xb8\x87", 3, 0x0E07}, /* (THAI CHARACTER NGO NGU) */
    {(lxb_char_t *) "\xe0\xb8\x88", 3, 0x0E08}, /* (THAI CHARACTER CHO CHAN) */
    {(lxb_char_t *) "\xe0\xb8\x89", 3, 0x0E09}, /* (THAI CHARACTER CHO CHING) */
    {(lxb_char_t *) "\xe0\xb8\x8a", 3, 0x0E0A}, /* (THAI CHARACTER CHO CHANG) */
    {(lxb_char_t *) "\xe0\xb8\x8b", 3, 0x0E0B}, /* (THAI CHARACTER SO SO) */
    {(lxb_char_t *) "\xe0\xb8\x8c", 3, 0x0E0C}, /* (THAI CHARACTER CHO CHOE) */
    {(lxb_char_t *) "\xe0\xb8\x8d", 3, 0x0E0D}, /* (THAI CHARACTER YO YING) */
    {(lxb_char_t *) "\xe0\xb8\x8e", 3, 0x0E0E}, /* (THAI CHARACTER DO CHADA) */
    {(lxb_char_t *) "\xe0\xb8\x8f", 3, 0x0E0F}, /* (THAI CHARACTER TO PATAK) */
    {(lxb_char_t *) "\xe0\xb8\x90", 3, 0x0E10}, /* (THAI CHARACTER THO THAN) */
    {(lxb_char_t *) "\xe0\xb8\x91", 3, 0x0E11}, /* (THAI CHARACTER THO NANGMONTHO) */
    {(lxb_char_t *) "\xe0\xb8\x92", 3, 0x0E12}, /* (THAI CHARACTER THO PHUTHAO) */
    {(lxb_char_t *) "\xe0\xb8\x93", 3, 0x0E13}, /* (THAI CHARACTER NO NEN) */
    {(lxb_char_t *) "\xe0\xb8\x94", 3, 0x0E14}, /* (THAI CHARACTER DO DEK) */
    {(lxb_char_t *) "\xe0\xb8\x95", 3, 0x0E15}, /* (THAI CHARACTER TO TAO) */
    {(lxb_char_t *) "\xe0\xb8\x96", 3, 0x0E16}, /* (THAI CHARACTER THO THUNG) */
    {(lxb_char_t *) "\xe0\xb8\x97", 3, 0x0E17}, /* (THAI CHARACTER THO THAHAN) */
    {(lxb_char_t *) "\xe0\xb8\x98", 3, 0x0E18}, /* (THAI CHARACTER THO THONG) */
    {(lxb_char_t *) "\xe0\xb8\x99", 3, 0x0E19}, /* (THAI CHARACTER NO NU) */
    {(lxb_char_t *) "\xe0\xb8\x9a", 3, 0x0E1A}, /* (THAI CHARACTER BO BAIMAI) */
    {(lxb_char_t *) "\xe0\xb8\x9b", 3, 0x0E1B}, /* (THAI CHARACTER PO PLA) */
    {(lxb_char_t *) "\xe0\xb8\x9c", 3, 0x0E1C}, /* (THAI CHARACTER PHO PHUNG) */
    {(lxb_char_t *) "\xe0\xb8\x9d", 3, 0x0E1D}, /* (THAI CHARACTER FO FA) */
    {(lxb_char_t *) "\xe0\xb8\x9e", 3, 0x0E1E}, /* (THAI CHARACTER PHO PHAN) */
    {(lxb_char_t *) "\xe0\xb8\x9f", 3, 0x0E1F}, /* (THAI CHARACTER FO FAN) */
    {(lxb_char_t *) "\xe0\xb8\xa0", 3, 0x0E20}, /* (THAI CHARACTER PHO SAMPHAO) */
    {(lxb_char_t *) "\xe0\xb8\xa1", 3, 0x0E21}, /* (THAI CHARACTER MO MA) */
    {(lxb_char_t *) "\xe0\xb8\xa2", 3, 0x0E22}, /* (THAI CHARACTER YO YAK) */
    {(lxb_char_t *) "\xe0\xb8\xa3", 3, 0x0E23}, /* (THAI CHARACTER RO RUA) */
    {(lxb_char_t *) "\xe0\xb8\xa4", 3, 0x0E24}, /* (THAI CHARACTER RU) */
    {(lxb_char_t *) "\xe0\xb8\xa5", 3, 0x0E25}, /* (THAI CHARACTER LO LING) */
    {(lxb_char_t *) "\xe0\xb8\xa6", 3, 0x0E26}, /* (THAI CHARACTER LU) */
    {(lxb_char_t *) "\xe0\xb8\xa7", 3, 0x0E27}, /* (THAI CHARACTER WO WAEN) */
    {(lxb_char_t *) "\xe0\xb8\xa8", 3, 0x0E28}, /* (THAI CHARACTER SO SALA) */
    {(lxb_char_t *) "\xe0\xb8\xa9", 3, 0x0E29}, /* (THAI CHARACTER SO RUSI) */
    {(lxb_char_t *) "\xe0\xb8\xaa", 3, 0x0E2A}, /* (THAI CHARACTER SO SUA) */
    {(lxb_char_t *) "\xe0\xb8\xab", 3, 0x0E2B}, /* (THAI CHARACTER HO HIP) */
    {(lxb_char_t *) "\xe0\xb8\xac", 3, 0x0E2C}, /* (THAI CHARACTER LO CHULA) */
    {(lxb_char_t *) "\xe0\xb8\xad", 3, 0x0E2D}, /* (THAI CHARACTER O ANG) */
    {(lxb_char_t *) "\xe0\xb8\xae", 3, 0x0E2E}, /* (THAI CHARACTER HO NOKHUK) */
    {(lxb_char_t *) "\xe0\xb8\xaf", 3, 0x0E2F}, /* (THAI CHARACTER PAIYANNOI) */
    {(lxb_char_t *) "\xe0\xb8\xb0", 3, 0x0E30}, /* (THAI CHARACTER SARA A) */
    {(lxb_char_t *) "\xe0\xb8\xb1", 3, 0x0E31}, /* (THAI CHARACTER MAI HAN-AKAT) */
    {(lxb_char_t *) "\xe0\xb8\xb2", 3, 0x0E32}, /* (THAI CHARACTER SARA AA) */
    {(lxb_char_t *) "\xe0\xb8\xb3", 3, 0x0E33}, /* (THAI CHARACTER SARA AM) */
    {(lxb_char_t *) "\xe0\xb8\xb4", 3, 0x0E34}, /* (THAI CHARACTER SARA I) */
    {(lxb_char_t *) "\xe0\xb8\xb5", 3, 0x0E35}, /* (THAI CHARACTER SARA II) */
    {(lxb_char_t *) "\xe0\xb8\xb6", 3, 0x0E36}, /* (THAI CHARACTER SARA UE) */
    {(lxb_char_t *) "\xe0\xb8\xb7", 3, 0x0E37}, /* (THAI CHARACTER SARA UEE) */
    {(lxb_char_t *) "\xe0\xb8\xb8", 3, 0x0E38}, /* (THAI CHARACTER SARA U) */
    {(lxb_char_t *) "\xe0\xb8\xb9", 3, 0x0E39}, /* (THAI CHARACTER SARA UU) */
    {(lxb_char_t *) "\xe0\xb8\xba", 3, 0x0E3A}, /* (THAI CHARACTER PHINTHU) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {(lxb_char_t *) "\xe0\xb8\xbf", 3, 0x0E3F}, /* (THAI CURRENCY SYMBOL BAHT) */
    {(lxb_char_t *) "\xe0\xb9\x80", 3, 0x0E40}, /* (THAI CHARACTER SARA E) */
    {(lxb_char_t *) "\xe0\xb9\x81", 3, 0x0E41}, /* (THAI CHARACTER SARA AE) */
    {(lxb_char_t *) "\xe0\xb9\x82", 3, 0x0E42}, /* (THAI CHARACTER SARA O) */
    {(lxb_char_t *) "\xe0\xb9\x83", 3, 0x0E43}, /* (THAI CHARACTER SARA AI MAIMUAN) */
    {(lxb_char_t *) "\xe0\xb9\x84", 3, 0x0E44}, /* (THAI CHARACTER SARA AI MAIMALAI) */
    {(lxb_char_t *) "\xe0\xb9\x85", 3, 0x0E45}, /* (THAI CHARACTER LAKKHANGYAO) */
    {(lxb_char_t *) "\xe0\xb9\x86", 3, 0x0E46}, /* (THAI CHARACTER MAIYAMOK) */
    {(lxb_char_t *) "\xe0\xb9\x87", 3, 0x0E47}, /* (THAI CHARACTER MAITAIKHU) */
    {(lxb_char_t *) "\xe0\xb9\x88", 3, 0x0E48}, /* (THAI CHARACTER MAI EK) */
    {(lxb_char_t *) "\xe0\xb9\x89", 3, 0x0E49}, /* (THAI CHARACTER MAI THO) */
    {(lxb_char_t *) "\xe0\xb9\x8a", 3, 0x0E4A}, /* (THAI CHARACTER MAI TRI) */
    {(lxb_char_t *) "\xe0\xb9\x8b", 3, 0x0E4B}, /* (THAI CHARACTER MAI CHATTAWA) */
    {(lxb_char_t *) "\xe0\xb9\x8c", 3, 0x0E4C}, /* (THAI CHARACTER THANTHAKHAT) */
    {(lxb_char_t *) "\xe0\xb9\x8d", 3, 0x0E4D}, /* (THAI CHARACTER NIKHAHIT) */
    {(lxb_char_t *) "\xe0\xb9\x8e", 3, 0x0E4E}, /* (THAI CHARACTER YAMAKKAN) */
    {(lxb_char_t *) "\xe0\xb9\x8f", 3, 0x0E4F}, /* (THAI CHARACTER FONGMAN) */
    {(lxb_char_t *) "\xe0\xb9\x90", 3, 0x0E50}, /* (THAI DIGIT ZERO) */
    {(lxb_char_t *) "\xe0\xb9\x91", 3, 0x0E51}, /* (THAI DIGIT ONE) */
    {(lxb_char_t *) "\xe0\xb9\x92", 3, 0x0E52}, /* (THAI DIGIT TWO) */
    {(lxb_char_t *) "\xe0\xb9\x93", 3, 0x0E53}, /* (THAI DIGIT THREE) */
    {(lxb_char_t *) "\xe0\xb9\x94", 3, 0x0E54}, /* (THAI DIGIT FOUR) */
    {(lxb_char_t *) "\xe0\xb9\x95", 3, 0x0E55}, /* (THAI DIGIT FIVE) */
    {(lxb_char_t *) "\xe0\xb9\x96", 3, 0x0E56}, /* (THAI DIGIT SIX) */
    {(lxb_char_t *) "\xe0\xb9\x97", 3, 0x0E57}, /* (THAI DIGIT SEVEN) */
    {(lxb_char_t *) "\xe0\xb9\x98", 3, 0x0E58}, /* (THAI DIGIT EIGHT) */
    {(lxb_char_t *) "\xe0\xb9\x99", 3, 0x0E59}, /* (THAI DIGIT NINE) */
    {(lxb_char_t *) "\xe0\xb9\x9a", 3, 0x0E5A}, /* (THAI CHARACTER ANGKHANKHU) */
    {(lxb_char_t *) "\xe0\xb9\x9b", 3, 0x0E5B}, /* (THAI CHARACTER KHOMUT) */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {NULL, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_x_mac_cyrillic[128] = 
{
    {(lxb_char_t *) "\xd0\x90", 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {(lxb_char_t *) "\xd0\x91", 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {(lxb_char_t *) "\xd0\x92", 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {(lxb_char_t *) "\xd0\x93", 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {(lxb_char_t *) "\xd0\x94", 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {(lxb_char_t *) "\xd0\x95", 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {(lxb_char_t *) "\xd0\x96", 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\x97", 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {(lxb_char_t *) "\xd0\x98", 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {(lxb_char_t *) "\xd0\x99", 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\x9a", 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {(lxb_char_t *) "\xd0\x9b", 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {(lxb_char_t *) "\xd0\x9c", 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {(lxb_char_t *) "\xd0\x9d", 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {(lxb_char_t *) "\xd0\x9e", 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {(lxb_char_t *) "\xd0\x9f", 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {(lxb_char_t *) "\xd0\xa0", 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {(lxb_char_t *) "\xd0\xa1", 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {(lxb_char_t *) "\xd0\xa2", 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {(lxb_char_t *) "\xd0\xa3", 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {(lxb_char_t *) "\xd0\xa4", 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {(lxb_char_t *) "\xd0\xa5", 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {(lxb_char_t *) "\xd0\xa6", 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {(lxb_char_t *) "\xd0\xa7", 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {(lxb_char_t *) "\xd0\xa8", 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {(lxb_char_t *) "\xd0\xa9", 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {(lxb_char_t *) "\xd0\xaa", 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd0\xab", 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {(lxb_char_t *) "\xd0\xac", 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd0\xad", 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {(lxb_char_t *) "\xd0\xae", 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {(lxb_char_t *) "\xd0\xaf", 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {(lxb_char_t *) "\xe2\x80\xa0", 3, 0x2020}, /* (DAGGER) */
    {(lxb_char_t *) "\xc2\xb0", 2, 0x00B0}, /* (DEGREE SIGN) */
    {(lxb_char_t *) "\xd2\x90", 2, 0x0490}, /* (CYRILLIC CAPITAL LETTER GHE WITH UPTURN) */
    {(lxb_char_t *) "\xc2\xa3", 2, 0x00A3}, /* (POUND SIGN) */
    {(lxb_char_t *) "\xc2\xa7", 2, 0x00A7}, /* (SECTION SIGN) */
    {(lxb_char_t *) "\xe2\x80\xa2", 3, 0x2022}, /* (BULLET) */
    {(lxb_char_t *) "\xc2\xb6", 2, 0x00B6}, /* (PILCROW SIGN) */
    {(lxb_char_t *) "\xd0\x86", 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xc2\xae", 2, 0x00AE}, /* (REGISTERED SIGN) */
    {(lxb_char_t *) "\xc2\xa9", 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {(lxb_char_t *) "\xe2\x84\xa2", 3, 0x2122}, /* (TRADE MARK SIGN) */
    {(lxb_char_t *) "\xd0\x82", 2, 0x0402}, /* (CYRILLIC CAPITAL LETTER DJE) */
    {(lxb_char_t *) "\xd1\x92", 2, 0x0452}, /* (CYRILLIC SMALL LETTER DJE) */
    {(lxb_char_t *) "\xe2\x89\xa0", 3, 0x2260}, /* (NOT EQUAL TO) */
    {(lxb_char_t *) "\xd0\x83", 2, 0x0403}, /* (CYRILLIC CAPITAL LETTER GJE) */
    {(lxb_char_t *) "\xd1\x93", 2, 0x0453}, /* (CYRILLIC SMALL LETTER GJE) */
    {(lxb_char_t *) "\xe2\x88\x9e", 3, 0x221E}, /* (INFINITY) */
    {(lxb_char_t *) "\xc2\xb1", 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {(lxb_char_t *) "\xe2\x89\xa4", 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xe2\x89\xa5", 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {(lxb_char_t *) "\xd1\x96", 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {(lxb_char_t *) "\xc2\xb5", 2, 0x00B5}, /* (MICRO SIGN) */
    {(lxb_char_t *) "\xd2\x91", 2, 0x0491}, /* (CYRILLIC SMALL LETTER GHE WITH UPTURN) */
    {(lxb_char_t *) "\xd0\x88", 2, 0x0408}, /* (CYRILLIC CAPITAL LETTER JE) */
    {(lxb_char_t *) "\xd0\x84", 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xd1\x94", 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {(lxb_char_t *) "\xd0\x87", 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {(lxb_char_t *) "\xd1\x97", 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {(lxb_char_t *) "\xd0\x89", 2, 0x0409}, /* (CYRILLIC CAPITAL LETTER LJE) */
    {(lxb_char_t *) "\xd1\x99", 2, 0x0459}, /* (CYRILLIC SMALL LETTER LJE) */
    {(lxb_char_t *) "\xd0\x8a", 2, 0x040A}, /* (CYRILLIC CAPITAL LETTER NJE) */
    {(lxb_char_t *) "\xd1\x9a", 2, 0x045A}, /* (CYRILLIC SMALL LETTER NJE) */
    {(lxb_char_t *) "\xd1\x98", 2, 0x0458}, /* (CYRILLIC SMALL LETTER JE) */
    {(lxb_char_t *) "\xd0\x85", 2, 0x0405}, /* (CYRILLIC CAPITAL LETTER DZE) */
    {(lxb_char_t *) "\xc2\xac", 2, 0x00AC}, /* (NOT SIGN) */
    {(lxb_char_t *) "\xe2\x88\x9a", 3, 0x221A}, /* (SQUARE ROOT) */
    {(lxb_char_t *) "\xc6\x92", 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {(lxb_char_t *) "\xe2\x89\x88", 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {(lxb_char_t *) "\xe2\x88\x86", 3, 0x2206}, /* (INCREMENT) */
    {(lxb_char_t *) "\xc2\xab", 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc2\xbb", 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\xa6", 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {(lxb_char_t *) "\xc2\xa0", 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {(lxb_char_t *) "\xd0\x8b", 2, 0x040B}, /* (CYRILLIC CAPITAL LETTER TSHE) */
    {(lxb_char_t *) "\xd1\x9b", 2, 0x045B}, /* (CYRILLIC SMALL LETTER TSHE) */
    {(lxb_char_t *) "\xd0\x8c", 2, 0x040C}, /* (CYRILLIC CAPITAL LETTER KJE) */
    {(lxb_char_t *) "\xd1\x9c", 2, 0x045C}, /* (CYRILLIC SMALL LETTER KJE) */
    {(lxb_char_t *) "\xd1\x95", 2, 0x0455}, /* (CYRILLIC SMALL LETTER DZE) */
    {(lxb_char_t *) "\xe2\x80\x93", 3, 0x2013}, /* (EN DASH) */
    {(lxb_char_t *) "\xe2\x80\x94", 3, 0x2014}, /* (EM DASH) */
    {(lxb_char_t *) "\xe2\x80\x9c", 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x9d", 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x98", 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xe2\x80\x99", 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {(lxb_char_t *) "\xc3\xb7", 2, 0x00F7}, /* (DIVISION SIGN) */
    {(lxb_char_t *) "\xe2\x80\x9e", 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {(lxb_char_t *) "\xd0\x8e", 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {(lxb_char_t *) "\xd1\x9e", 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {(lxb_char_t *) "\xd0\x8f", 2, 0x040F}, /* (CYRILLIC CAPITAL LETTER DZHE) */
    {(lxb_char_t *) "\xd1\x9f", 2, 0x045F}, /* (CYRILLIC SMALL LETTER DZHE) */
    {(lxb_char_t *) "\xe2\x84\x96", 3, 0x2116}, /* (NUMERO SIGN) */
    {(lxb_char_t *) "\xd0\x81", 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {(lxb_char_t *) "\xd1\x91", 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {(lxb_char_t *) "\xd1\x8f", 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {(lxb_char_t *) "\xd0\xb0", 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {(lxb_char_t *) "\xd0\xb1", 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {(lxb_char_t *) "\xd0\xb2", 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {(lxb_char_t *) "\xd0\xb3", 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {(lxb_char_t *) "\xd0\xb4", 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {(lxb_char_t *) "\xd0\xb5", 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {(lxb_char_t *) "\xd0\xb6", 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {(lxb_char_t *) "\xd0\xb7", 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {(lxb_char_t *) "\xd0\xb8", 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {(lxb_char_t *) "\xd0\xb9", 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {(lxb_char_t *) "\xd0\xba", 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {(lxb_char_t *) "\xd0\xbb", 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {(lxb_char_t *) "\xd0\xbc", 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {(lxb_char_t *) "\xd0\xbd", 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {(lxb_char_t *) "\xd0\xbe", 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {(lxb_char_t *) "\xd0\xbf", 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {(lxb_char_t *) "\xd1\x80", 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {(lxb_char_t *) "\xd1\x81", 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {(lxb_char_t *) "\xd1\x82", 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {(lxb_char_t *) "\xd1\x83", 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {(lxb_char_t *) "\xd1\x84", 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {(lxb_char_t *) "\xd1\x85", 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {(lxb_char_t *) "\xd1\x86", 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {(lxb_char_t *) "\xd1\x87", 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {(lxb_char_t *) "\xd1\x88", 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {(lxb_char_t *) "\xd1\x89", 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {(lxb_char_t *) "\xd1\x8a", 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {(lxb_char_t *) "\xd1\x8b", 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {(lxb_char_t *) "\xd1\x8c", 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {(lxb_char_t *) "\xd1\x8d", 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {(lxb_char_t *) "\xd1\x8e", 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {(lxb_char_t *) "\xe2\x82\xac", 3, 0x20AC}, /* (EURO SIGN) */
};

/* Table size: 344; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_ibm866[345] = 
{
    {0, NULL, 0},{9632, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1038, (void *) 246, 0},
    {0, NULL, 0},
    {1040, (void *) 128, 0},
    {1041, (void *) 129, 0},
    {1042, (void *) 130, 0},
    {1043, (void *) 131, 0},
    {1044, (void *) 132, 0},
    {1045, (void *) 133, 0},
    {1046, (void *) 134, 0},
    {1047, (void *) 135, 0},
    {1048, (void *) 136, 0},
    {1049, (void *) 137, 0},
    {1050, (void *) 138, 0},
    {1051, (void *) 139, 0},
    {1052, (void *) 140, 0},
    {1053, (void *) 141, 0},
    {1054, (void *) 142, 0},
    {1055, (void *) 143, 0},
    {1056, (void *) 144, 0},
    {1057, (void *) 145, 0},
    {1058, (void *) 146, 0},
    {1059, (void *) 147, 0},
    {1060, (void *) 148, 0},
    {1061, (void *) 149, 0},
    {1062, (void *) 150, 0},
    {1063, (void *) 151, 0},
    {1064, (void *) 152, 0},
    {1065, (void *) 153, 0},
    {1066, (void *) 154, 0},
    {1067, (void *) 155, 0},
    {1068, (void *) 156, 0},
    {1069, (void *) 157, 0},
    {1070, (void *) 158, 0},
    {1071, (void *) 159, 0},
    {1072, (void *) 160, 0},
    {1073, (void *) 161, 0},
    {1074, (void *) 162, 0},
    {1075, (void *) 163, 0},
    {1076, (void *) 164, 0},
    {1077, (void *) 165, 0},
    {1078, (void *) 166, 0},
    {1079, (void *) 167, 0},
    {1080, (void *) 168, 0},
    {1081, (void *) 169, 0},
    {1082, (void *) 170, 0},
    {1083, (void *) 171, 0},
    {1084, (void *) 172, 0},
    {1085, (void *) 173, 0},
    {1086, (void *) 174, 0},
    {1087, (void *) 175, 0},
    {1088, (void *) 224, 0},
    {1089, (void *) 225, 0},
    {1090, (void *) 226, 0},
    {1091, (void *) 227, 0},
    {1092, (void *) 228, 0},
    {1093, (void *) 229, 0},
    {1094, (void *) 230, 0},
    {1095, (void *) 231, 0},
    {1096, (void *) 232, 0},
    {1097, (void *) 233, 0},
    {1098, (void *) 234, 0},
    {1099, (void *) 235, 0},
    {1100, (void *) 236, 0},
    {1101, (void *) 237, 0},
    {1102, (void *) 238, 0},
    {1103, (void *) 239, 0},
    {0, NULL, 0},
    {1105, (void *) 241, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1108, (void *) 243, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1111, (void *) 245, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1118, (void *) 247, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8729, (void *) 249, 0},
    {8730, (void *) 251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {160, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {164, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 248, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {183, (void *) 250, 0},
    {9472, (void *) 196, 0},
    {0, NULL, 0},
    {9474, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9484, (void *) 218, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9488, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9492, (void *) 192, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9496, (void *) 217, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9500, (void *) 195, 0},
    {0, NULL, 0},
    {8470, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9508, (void *) 180, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9516, (void *) 194, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9524, (void *) 193, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9532, (void *) 197, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9552, (void *) 205, 0},
    {9553, (void *) 186, 0},
    {9554, (void *) 213, 0},
    {9555, (void *) 214, 0},
    {9556, (void *) 201, 0},
    {9557, (void *) 184, 0},
    {9558, (void *) 183, 0},
    {9559, (void *) 187, 0},
    {9560, (void *) 212, 0},
    {9561, (void *) 211, 0},
    {9562, (void *) 200, 0},
    {9563, (void *) 190, 0},
    {9564, (void *) 189, 0},
    {9565, (void *) 188, 0},
    {9566, (void *) 198, 0},
    {9567, (void *) 199, 0},
    {9568, (void *) 204, 0},
    {9569, (void *) 181, 0},
    {9570, (void *) 182, 0},
    {9571, (void *) 185, 0},
    {9572, (void *) 209, 0},
    {9573, (void *) 210, 0},
    {9574, (void *) 203, 0},
    {9575, (void *) 207, 0},
    {9576, (void *) 208, 0},
    {9577, (void *) 202, 0},
    {9578, (void *) 216, 0},
    {9579, (void *) 215, 0},
    {9580, (void *) 206, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9600, (void *) 223, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9604, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9608, (void *) 219, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9612, (void *) 221, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9616, (void *) 222, 0},
    {9617, (void *) 176, 0},
    {9618, (void *) 177, 0},
    {9619, (void *) 178, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1025, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1028, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1031, (void *) 244, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_10[344] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {352, (void *) 170, 0},
    {353, (void *) 186, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {358, (void *) 171, 0},
    {359, (void *) 187, 0},
    {360, (void *) 215, 0},
    {361, (void *) 247, 0},
    {362, (void *) 174, 0},
    {363, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {370, (void *) 217, 0},
    {371, (void *) 249, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {381, (void *) 172, 0},
    {382, (void *) 188, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 167, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {183, (void *) 183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {195, (void *) 195, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 198, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {201, (void *) 201, 0},
    {0, NULL, 0},
    {203, (void *) 203, 0},
    {0, NULL, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {208, (void *) 208, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {0, NULL, 0},
    {216, (void *) 216, 0},
    {0, NULL, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {221, (void *) 221, 0},
    {222, (void *) 222, 0},
    {223, (void *) 223, 0},
    {0, NULL, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {227, (void *) 227, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 230, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {233, (void *) 233, 0},
    {0, NULL, 0},
    {235, (void *) 235, 0},
    {0, NULL, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {240, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {0, NULL, 0},
    {248, (void *) 248, 0},
    {0, NULL, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {253, (void *) 253, 0},
    {254, (void *) 254, 0},
    {0, NULL, 0},
    {256, (void *) 192, 0},
    {257, (void *) 224, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {260, (void *) 161, 0},
    {261, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {268, (void *) 200, 0},
    {269, (void *) 232, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {272, (void *) 169, 0},
    {273, (void *) 185, 0},
    {274, (void *) 162, 0},
    {275, (void *) 178, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {278, (void *) 204, 0},
    {279, (void *) 236, 0},
    {280, (void *) 202, 0},
    {281, (void *) 234, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {290, (void *) 163, 0},
    {291, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {296, (void *) 165, 0},
    {297, (void *) 181, 0},
    {298, (void *) 164, 0},
    {299, (void *) 180, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {302, (void *) 199, 0},
    {303, (void *) 231, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {310, (void *) 166, 0},
    {311, (void *) 182, 0},
    {312, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {315, (void *) 168, 0},
    {316, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8213, (void *) 189, 0},
    {325, (void *) 209, 0},
    {326, (void *) 241, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {330, (void *) 175, 0},
    {331, (void *) 191, 0},
    {332, (void *) 210, 0},
    {333, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 345; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_13[346] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {346, (void *) 218, 0},
    {347, (void *) 250, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {352, (void *) 208, 0},
    {353, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {362, (void *) 219, 0},
    {363, (void *) 251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {370, (void *) 216, 0},
    {371, (void *) 248, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {377, (void *) 202, 0},
    {378, (void *) 234, 0},
    {379, (void *) 221, 0},
    {380, (void *) 253, 0},
    {381, (void *) 222, 0},
    {382, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {0, NULL, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {0, NULL, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {0, NULL, 0},
    {185, (void *) 185, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 175, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {201, (void *) 201, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {211, (void *) 211, 0},
    {0, NULL, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {216, (void *) 168, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {220, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {233, (void *) 233, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {243, (void *) 243, 0},
    {0, NULL, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {248, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {256, (void *) 194, 0},
    {257, (void *) 226, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {260, (void *) 192, 0},
    {261, (void *) 224, 0},
    {262, (void *) 195, 0},
    {263, (void *) 227, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {268, (void *) 200, 0},
    {269, (void *) 232, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {274, (void *) 199, 0},
    {275, (void *) 231, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {278, (void *) 203, 0},
    {279, (void *) 235, 0},
    {280, (void *) 198, 0},
    {281, (void *) 230, 0},
    {8217, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8220, (void *) 180, 0},
    {8221, (void *) 161, 0},
    {8222, (void *) 165, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {290, (void *) 204, 0},
    {291, (void *) 236, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {298, (void *) 206, 0},
    {299, (void *) 238, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {302, (void *) 193, 0},
    {303, (void *) 225, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {310, (void *) 205, 0},
    {311, (void *) 237, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {315, (void *) 207, 0},
    {316, (void *) 239, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {321, (void *) 217, 0},
    {322, (void *) 249, 0},
    {323, (void *) 209, 0},
    {324, (void *) 241, 0},
    {325, (void *) 210, 0},
    {326, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {332, (void *) 212, 0},
    {333, (void *) 244, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {342, (void *) 170, 0},
    {343, (void *) 186, 0},
    {0, NULL, 0}
};

/* Table size: 407; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_14[408] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7744, (void *) 180, 0},
    {7745, (void *) 181, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7766, (void *) 183, 0},
    {7767, (void *) 185, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7776, (void *) 187, 0},
    {7777, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7786, (void *) 215, 0},
    {7787, (void *) 247, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7808, (void *) 168, 0},
    {7809, (void *) 184, 0},
    {7810, (void *) 170, 0},
    {7811, (void *) 186, 0},
    {7812, (void *) 189, 0},
    {7813, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {163, (void *) 163, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 167, 0},
    {0, NULL, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {182, (void *) 182, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7922, (void *) 172, 0},
    {7923, (void *) 188, 0},
    {0, NULL, 0},
    {192, (void *) 192, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {195, (void *) 195, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 198, 0},
    {199, (void *) 199, 0},
    {200, (void *) 200, 0},
    {201, (void *) 201, 0},
    {202, (void *) 202, 0},
    {203, (void *) 203, 0},
    {204, (void *) 204, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {0, NULL, 0},
    {209, (void *) 209, 0},
    {210, (void *) 210, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {0, NULL, 0},
    {216, (void *) 216, 0},
    {217, (void *) 217, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {221, (void *) 221, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {224, (void *) 224, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {227, (void *) 227, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 230, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {236, (void *) 236, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {0, NULL, 0},
    {241, (void *) 241, 0},
    {242, (void *) 242, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {0, NULL, 0},
    {248, (void *) 248, 0},
    {249, (void *) 249, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {253, (void *) 253, 0},
    {0, NULL, 0},
    {255, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {266, (void *) 164, 0},
    {267, (void *) 165, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {288, (void *) 178, 0},
    {289, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7682, (void *) 161, 0},
    {7683, (void *) 162, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7690, (void *) 166, 0},
    {7691, (void *) 171, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {372, (void *) 208, 0},
    {373, (void *) 240, 0},
    {374, (void *) 222, 0},
    {375, (void *) 254, 0},
    {376, (void *) 175, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {7710, (void *) 176, 0},
    {7711, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 344; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_15[345] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {352, (void *) 166, 0},
    {353, (void *) 168, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {376, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {381, (void *) 180, 0},
    {382, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 164, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {161, (void *) 161, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {0, NULL, 0},
    {165, (void *) 165, 0},
    {0, NULL, 0},
    {167, (void *) 167, 0},
    {0, NULL, 0},
    {169, (void *) 169, 0},
    {170, (void *) 170, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 175, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {0, NULL, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {0, NULL, 0},
    {185, (void *) 185, 0},
    {186, (void *) 186, 0},
    {187, (void *) 187, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {191, (void *) 191, 0},
    {192, (void *) 192, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {195, (void *) 195, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 198, 0},
    {199, (void *) 199, 0},
    {200, (void *) 200, 0},
    {201, (void *) 201, 0},
    {202, (void *) 202, 0},
    {203, (void *) 203, 0},
    {204, (void *) 204, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {208, (void *) 208, 0},
    {209, (void *) 209, 0},
    {210, (void *) 210, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {216, (void *) 216, 0},
    {217, (void *) 217, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {221, (void *) 221, 0},
    {222, (void *) 222, 0},
    {223, (void *) 223, 0},
    {224, (void *) 224, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {227, (void *) 227, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 230, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {236, (void *) 236, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {240, (void *) 240, 0},
    {241, (void *) 241, 0},
    {242, (void *) 242, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {248, (void *) 248, 0},
    {249, (void *) 249, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {253, (void *) 253, 0},
    {254, (void *) 254, 0},
    {255, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {338, (void *) 188, 0},
    {339, (void *) 189, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 413; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_16[414] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 164, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {536, (void *) 170, 0},
    {537, (void *) 186, 0},
    {538, (void *) 222, 0},
    {539, (void *) 254, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 167, 0},
    {0, NULL, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {192, (void *) 192, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {0, NULL, 0},
    {196, (void *) 196, 0},
    {0, NULL, 0},
    {198, (void *) 198, 0},
    {199, (void *) 199, 0},
    {200, (void *) 200, 0},
    {201, (void *) 201, 0},
    {202, (void *) 202, 0},
    {203, (void *) 203, 0},
    {204, (void *) 204, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {210, (void *) 210, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {0, NULL, 0},
    {214, (void *) 214, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {217, (void *) 217, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {224, (void *) 224, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {0, NULL, 0},
    {228, (void *) 228, 0},
    {0, NULL, 0},
    {230, (void *) 230, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {236, (void *) 236, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {242, (void *) 242, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {0, NULL, 0},
    {246, (void *) 246, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {249, (void *) 249, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {255, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {258, (void *) 195, 0},
    {259, (void *) 227, 0},
    {260, (void *) 161, 0},
    {261, (void *) 162, 0},
    {262, (void *) 197, 0},
    {263, (void *) 229, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {268, (void *) 178, 0},
    {269, (void *) 185, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {272, (void *) 208, 0},
    {273, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {280, (void *) 221, 0},
    {281, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {321, (void *) 163, 0},
    {322, (void *) 179, 0},
    {323, (void *) 209, 0},
    {324, (void *) 241, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {336, (void *) 213, 0},
    {337, (void *) 245, 0},
    {338, (void *) 188, 0},
    {339, (void *) 189, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {346, (void *) 215, 0},
    {347, (void *) 247, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {352, (void *) 166, 0},
    {353, (void *) 168, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {368, (void *) 216, 0},
    {369, (void *) 248, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8221, (void *) 181, 0},
    {8222, (void *) 165, 0},
    {376, (void *) 190, 0},
    {377, (void *) 172, 0},
    {378, (void *) 174, 0},
    {379, (void *) 175, 0},
    {380, (void *) 191, 0},
    {381, (void *) 180, 0},
    {382, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 368; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_2[369] = 
{
    {0, NULL, 0},{368, (void *) 219, 0},
    {369, (void *) 251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {377, (void *) 172, 0},
    {378, (void *) 188, 0},
    {379, (void *) 175, 0},
    {380, (void *) 191, 0},
    {381, (void *) 174, 0},
    {382, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {180, (void *) 180, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {184, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {0, NULL, 0},
    {196, (void *) 196, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {199, (void *) 199, 0},
    {0, NULL, 0},
    {201, (void *) 201, 0},
    {0, NULL, 0},
    {203, (void *) 203, 0},
    {0, NULL, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {0, NULL, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {218, (void *) 218, 0},
    {0, NULL, 0},
    {220, (void *) 220, 0},
    {221, (void *) 221, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {0, NULL, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {0, NULL, 0},
    {228, (void *) 228, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {231, (void *) 231, 0},
    {0, NULL, 0},
    {233, (void *) 233, 0},
    {0, NULL, 0},
    {235, (void *) 235, 0},
    {0, NULL, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {0, NULL, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {250, (void *) 250, 0},
    {0, NULL, 0},
    {252, (void *) 252, 0},
    {253, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {258, (void *) 195, 0},
    {259, (void *) 227, 0},
    {260, (void *) 161, 0},
    {261, (void *) 177, 0},
    {262, (void *) 198, 0},
    {263, (void *) 230, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {268, (void *) 200, 0},
    {269, (void *) 232, 0},
    {270, (void *) 207, 0},
    {271, (void *) 239, 0},
    {272, (void *) 208, 0},
    {273, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {280, (void *) 202, 0},
    {281, (void *) 234, 0},
    {282, (void *) 204, 0},
    {283, (void *) 236, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {313, (void *) 197, 0},
    {314, (void *) 229, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {317, (void *) 165, 0},
    {318, (void *) 181, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {321, (void *) 163, 0},
    {322, (void *) 179, 0},
    {323, (void *) 209, 0},
    {324, (void *) 241, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {327, (void *) 210, 0},
    {328, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {336, (void *) 213, 0},
    {337, (void *) 245, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {340, (void *) 192, 0},
    {341, (void *) 224, 0},
    {0, NULL, 0},
    {711, (void *) 183, 0},
    {344, (void *) 216, 0},
    {345, (void *) 248, 0},
    {346, (void *) 166, 0},
    {347, (void *) 182, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {350, (void *) 170, 0},
    {351, (void *) 186, 0},
    {352, (void *) 169, 0},
    {353, (void *) 185, 0},
    {354, (void *) 222, 0},
    {355, (void *) 254, 0},
    {356, (void *) 171, 0},
    {357, (void *) 187, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {728, (void *) 162, 0},
    {729, (void *) 255, 0},
    {0, NULL, 0},
    {731, (void *) 178, 0},
    {0, NULL, 0},
    {733, (void *) 189, 0},
    {366, (void *) 217, 0},
    {367, (void *) 249, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_3[344] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {348, (void *) 222, 0},
    {349, (void *) 254, 0},
    {350, (void *) 170, 0},
    {351, (void *) 186, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {364, (void *) 221, 0},
    {365, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {379, (void *) 175, 0},
    {380, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {728, (void *) 162, 0},
    {729, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {0, NULL, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {0, NULL, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {189, (void *) 189, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {192, (void *) 192, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {0, NULL, 0},
    {196, (void *) 196, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {199, (void *) 199, 0},
    {200, (void *) 200, 0},
    {201, (void *) 201, 0},
    {202, (void *) 202, 0},
    {203, (void *) 203, 0},
    {204, (void *) 204, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {0, NULL, 0},
    {209, (void *) 209, 0},
    {210, (void *) 210, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {0, NULL, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {0, NULL, 0},
    {217, (void *) 217, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {224, (void *) 224, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {0, NULL, 0},
    {228, (void *) 228, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {236, (void *) 236, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {0, NULL, 0},
    {241, (void *) 241, 0},
    {242, (void *) 242, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {0, NULL, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {0, NULL, 0},
    {249, (void *) 249, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {264, (void *) 198, 0},
    {265, (void *) 230, 0},
    {266, (void *) 197, 0},
    {267, (void *) 229, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {284, (void *) 216, 0},
    {285, (void *) 248, 0},
    {286, (void *) 171, 0},
    {287, (void *) 187, 0},
    {288, (void *) 213, 0},
    {289, (void *) 245, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {292, (void *) 166, 0},
    {293, (void *) 182, 0},
    {294, (void *) 161, 0},
    {295, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {304, (void *) 169, 0},
    {305, (void *) 185, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {308, (void *) 172, 0},
    {309, (void *) 188, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_4[344] = 
{
    {0, NULL, 0},{343, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {352, (void *) 169, 0},
    {353, (void *) 185, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {358, (void *) 172, 0},
    {359, (void *) 188, 0},
    {360, (void *) 221, 0},
    {361, (void *) 253, 0},
    {362, (void *) 222, 0},
    {363, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {711, (void *) 183, 0},
    {0, NULL, 0},
    {370, (void *) 217, 0},
    {371, (void *) 249, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {381, (void *) 174, 0},
    {382, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {729, (void *) 255, 0},
    {0, NULL, 0},
    {731, (void *) 178, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {175, (void *) 175, 0},
    {176, (void *) 176, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {180, (void *) 180, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {184, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {195, (void *) 195, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 198, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {201, (void *) 201, 0},
    {0, NULL, 0},
    {203, (void *) 203, 0},
    {0, NULL, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {212, (void *) 212, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {216, (void *) 216, 0},
    {0, NULL, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {0, NULL, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {227, (void *) 227, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 230, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {233, (void *) 233, 0},
    {0, NULL, 0},
    {235, (void *) 235, 0},
    {0, NULL, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {244, (void *) 244, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {248, (void *) 248, 0},
    {0, NULL, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {256, (void *) 192, 0},
    {257, (void *) 224, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {260, (void *) 161, 0},
    {261, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {268, (void *) 200, 0},
    {269, (void *) 232, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {272, (void *) 208, 0},
    {273, (void *) 240, 0},
    {274, (void *) 170, 0},
    {275, (void *) 186, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {278, (void *) 204, 0},
    {279, (void *) 236, 0},
    {280, (void *) 202, 0},
    {281, (void *) 234, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {290, (void *) 171, 0},
    {291, (void *) 187, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {296, (void *) 165, 0},
    {297, (void *) 181, 0},
    {298, (void *) 207, 0},
    {299, (void *) 239, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {302, (void *) 199, 0},
    {303, (void *) 231, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {310, (void *) 211, 0},
    {311, (void *) 243, 0},
    {312, (void *) 162, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {315, (void *) 166, 0},
    {316, (void *) 182, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {325, (void *) 209, 0},
    {326, (void *) 241, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {330, (void *) 189, 0},
    {331, (void *) 191, 0},
    {332, (void *) 210, 0},
    {333, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {342, (void *) 163, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_5[344] = 
{
    {0, NULL, 0},{1029, (void *) 165, 0},
    {1030, (void *) 166, 0},
    {1031, (void *) 167, 0},
    {1032, (void *) 168, 0},
    {1033, (void *) 169, 0},
    {1034, (void *) 170, 0},
    {1035, (void *) 171, 0},
    {1036, (void *) 172, 0},
    {0, NULL, 0},
    {1038, (void *) 174, 0},
    {1039, (void *) 175, 0},
    {1040, (void *) 176, 0},
    {1041, (void *) 177, 0},
    {1042, (void *) 178, 0},
    {1043, (void *) 179, 0},
    {1044, (void *) 180, 0},
    {1045, (void *) 181, 0},
    {1046, (void *) 182, 0},
    {1047, (void *) 183, 0},
    {1048, (void *) 184, 0},
    {1049, (void *) 185, 0},
    {1050, (void *) 186, 0},
    {1051, (void *) 187, 0},
    {1052, (void *) 188, 0},
    {1053, (void *) 189, 0},
    {1054, (void *) 190, 0},
    {1055, (void *) 191, 0},
    {1056, (void *) 192, 0},
    {1057, (void *) 193, 0},
    {1058, (void *) 194, 0},
    {1059, (void *) 195, 0},
    {1060, (void *) 196, 0},
    {1061, (void *) 197, 0},
    {1062, (void *) 198, 0},
    {1063, (void *) 199, 0},
    {1064, (void *) 200, 0},
    {1065, (void *) 201, 0},
    {1066, (void *) 202, 0},
    {1067, (void *) 203, 0},
    {1068, (void *) 204, 0},
    {1069, (void *) 205, 0},
    {1070, (void *) 206, 0},
    {1071, (void *) 207, 0},
    {1072, (void *) 208, 0},
    {1073, (void *) 209, 0},
    {1074, (void *) 210, 0},
    {1075, (void *) 211, 0},
    {1076, (void *) 212, 0},
    {1077, (void *) 213, 0},
    {1078, (void *) 214, 0},
    {1079, (void *) 215, 0},
    {1080, (void *) 216, 0},
    {1081, (void *) 217, 0},
    {1082, (void *) 218, 0},
    {1083, (void *) 219, 0},
    {1084, (void *) 220, 0},
    {1085, (void *) 221, 0},
    {1086, (void *) 222, 0},
    {1087, (void *) 223, 0},
    {1088, (void *) 224, 0},
    {1089, (void *) 225, 0},
    {1090, (void *) 226, 0},
    {1091, (void *) 227, 0},
    {1092, (void *) 228, 0},
    {1093, (void *) 229, 0},
    {1094, (void *) 230, 0},
    {1095, (void *) 231, 0},
    {1096, (void *) 232, 0},
    {1097, (void *) 233, 0},
    {1098, (void *) 234, 0},
    {1099, (void *) 235, 0},
    {1100, (void *) 236, 0},
    {1101, (void *) 237, 0},
    {1102, (void *) 238, 0},
    {1103, (void *) 239, 0},
    {0, NULL, 0},
    {1105, (void *) 241, 0},
    {1106, (void *) 242, 0},
    {1107, (void *) 243, 0},
    {1108, (void *) 244, 0},
    {1109, (void *) 245, 0},
    {1110, (void *) 246, 0},
    {1111, (void *) 247, 0},
    {1112, (void *) 248, 0},
    {1113, (void *) 249, 0},
    {1114, (void *) 250, 0},
    {1115, (void *) 251, 0},
    {1116, (void *) 252, 0},
    {0, NULL, 0},
    {1118, (void *) 254, 0},
    {1119, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8470, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1025, (void *) 161, 0},
    {1026, (void *) 162, 0},
    {1027, (void *) 163, 0},
    {1028, (void *) 164, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_6[344] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1548, (void *) 172, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1563, (void *) 187, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1567, (void *) 191, 0},
    {0, NULL, 0},
    {1569, (void *) 193, 0},
    {1570, (void *) 194, 0},
    {1571, (void *) 195, 0},
    {1572, (void *) 196, 0},
    {1573, (void *) 197, 0},
    {1574, (void *) 198, 0},
    {1575, (void *) 199, 0},
    {1576, (void *) 200, 0},
    {1577, (void *) 201, 0},
    {1578, (void *) 202, 0},
    {1579, (void *) 203, 0},
    {1580, (void *) 204, 0},
    {1581, (void *) 205, 0},
    {1582, (void *) 206, 0},
    {1583, (void *) 207, 0},
    {1584, (void *) 208, 0},
    {1585, (void *) 209, 0},
    {1586, (void *) 210, 0},
    {1587, (void *) 211, 0},
    {1588, (void *) 212, 0},
    {1589, (void *) 213, 0},
    {1590, (void *) 214, 0},
    {1591, (void *) 215, 0},
    {1592, (void *) 216, 0},
    {1593, (void *) 217, 0},
    {1594, (void *) 218, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1600, (void *) 224, 0},
    {1601, (void *) 225, 0},
    {1602, (void *) 226, 0},
    {1603, (void *) 227, 0},
    {1604, (void *) 228, 0},
    {1605, (void *) 229, 0},
    {1606, (void *) 230, 0},
    {1607, (void *) 231, 0},
    {1608, (void *) 232, 0},
    {1609, (void *) 233, 0},
    {1610, (void *) 234, 0},
    {1611, (void *) 235, 0},
    {1612, (void *) 236, 0},
    {1613, (void *) 237, 0},
    {1614, (void *) 238, 0},
    {1615, (void *) 239, 0},
    {1616, (void *) 240, 0},
    {1617, (void *) 241, 0},
    {1618, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 344; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_7[345] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 164, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8367, (void *) 165, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {163, (void *) 163, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {183, (void *) 183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {0, NULL, 0},
    {189, (void *) 189, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {890, (void *) 170, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {900, (void *) 180, 0},
    {901, (void *) 181, 0},
    {902, (void *) 182, 0},
    {0, NULL, 0},
    {904, (void *) 184, 0},
    {905, (void *) 185, 0},
    {906, (void *) 186, 0},
    {0, NULL, 0},
    {908, (void *) 188, 0},
    {0, NULL, 0},
    {910, (void *) 190, 0},
    {911, (void *) 191, 0},
    {912, (void *) 192, 0},
    {913, (void *) 193, 0},
    {914, (void *) 194, 0},
    {915, (void *) 195, 0},
    {916, (void *) 196, 0},
    {917, (void *) 197, 0},
    {918, (void *) 198, 0},
    {919, (void *) 199, 0},
    {920, (void *) 200, 0},
    {921, (void *) 201, 0},
    {922, (void *) 202, 0},
    {923, (void *) 203, 0},
    {924, (void *) 204, 0},
    {925, (void *) 205, 0},
    {926, (void *) 206, 0},
    {927, (void *) 207, 0},
    {928, (void *) 208, 0},
    {929, (void *) 209, 0},
    {0, NULL, 0},
    {931, (void *) 211, 0},
    {932, (void *) 212, 0},
    {933, (void *) 213, 0},
    {934, (void *) 214, 0},
    {935, (void *) 215, 0},
    {936, (void *) 216, 0},
    {937, (void *) 217, 0},
    {938, (void *) 218, 0},
    {939, (void *) 219, 0},
    {940, (void *) 220, 0},
    {941, (void *) 221, 0},
    {942, (void *) 222, 0},
    {943, (void *) 223, 0},
    {944, (void *) 224, 0},
    {945, (void *) 225, 0},
    {946, (void *) 226, 0},
    {947, (void *) 227, 0},
    {948, (void *) 228, 0},
    {949, (void *) 229, 0},
    {950, (void *) 230, 0},
    {951, (void *) 231, 0},
    {952, (void *) 232, 0},
    {953, (void *) 233, 0},
    {954, (void *) 234, 0},
    {955, (void *) 235, 0},
    {956, (void *) 236, 0},
    {957, (void *) 237, 0},
    {958, (void *) 238, 0},
    {959, (void *) 239, 0},
    {960, (void *) 240, 0},
    {961, (void *) 241, 0},
    {962, (void *) 242, 0},
    {963, (void *) 243, 0},
    {964, (void *) 244, 0},
    {965, (void *) 245, 0},
    {966, (void *) 246, 0},
    {967, (void *) 247, 0},
    {968, (void *) 248, 0},
    {969, (void *) 249, 0},
    {970, (void *) 250, 0},
    {971, (void *) 251, 0},
    {972, (void *) 252, 0},
    {973, (void *) 253, 0},
    {974, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8213, (void *) 175, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 161, 0},
    {8217, (void *) 162, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 347; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_8[348] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1488, (void *) 224, 0},
    {1489, (void *) 225, 0},
    {1490, (void *) 226, 0},
    {1491, (void *) 227, 0},
    {1492, (void *) 228, 0},
    {1493, (void *) 229, 0},
    {1494, (void *) 230, 0},
    {1495, (void *) 231, 0},
    {1496, (void *) 232, 0},
    {1497, (void *) 233, 0},
    {1498, (void *) 234, 0},
    {1499, (void *) 235, 0},
    {1500, (void *) 236, 0},
    {1501, (void *) 237, 0},
    {1502, (void *) 238, 0},
    {1503, (void *) 239, 0},
    {1504, (void *) 240, 0},
    {1505, (void *) 241, 0},
    {1506, (void *) 242, 0},
    {1507, (void *) 243, 0},
    {1508, (void *) 244, 0},
    {1509, (void *) 245, 0},
    {1510, (void *) 246, 0},
    {1511, (void *) 247, 0},
    {1512, (void *) 248, 0},
    {1513, (void *) 249, 0},
    {1514, (void *) 250, 0},
    {0, NULL, 0},
    {128, (void *) 128, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {133, (void *) 133, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {145, (void *) 145, 0},
    {146, (void *) 146, 0},
    {147, (void *) 147, 0},
    {148, (void *) 148, 0},
    {149, (void *) 149, 0},
    {150, (void *) 150, 0},
    {151, (void *) 151, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {165, (void *) 165, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 175, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {185, (void *) 185, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {215, (void *) 170, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8206, (void *) 253, 0},
    {8207, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8215, (void *) 223, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {247, (void *) 186, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 486; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_koi8_r[487] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8776, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1025, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8804, (void *) 152, 0},
    {8805, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1040, (void *) 225, 0},
    {1041, (void *) 226, 0},
    {1042, (void *) 247, 0},
    {1043, (void *) 231, 0},
    {1044, (void *) 228, 0},
    {1045, (void *) 229, 0},
    {1046, (void *) 246, 0},
    {1047, (void *) 250, 0},
    {1048, (void *) 233, 0},
    {1049, (void *) 234, 0},
    {1050, (void *) 235, 0},
    {1051, (void *) 236, 0},
    {1052, (void *) 237, 0},
    {1053, (void *) 238, 0},
    {1054, (void *) 239, 0},
    {1055, (void *) 240, 0},
    {1056, (void *) 242, 0},
    {1057, (void *) 243, 0},
    {1058, (void *) 244, 0},
    {1059, (void *) 245, 0},
    {1060, (void *) 230, 0},
    {1061, (void *) 232, 0},
    {1062, (void *) 227, 0},
    {1063, (void *) 254, 0},
    {1064, (void *) 251, 0},
    {1065, (void *) 253, 0},
    {1066, (void *) 255, 0},
    {1067, (void *) 249, 0},
    {1068, (void *) 248, 0},
    {1069, (void *) 252, 0},
    {1070, (void *) 224, 0},
    {1071, (void *) 241, 0},
    {1072, (void *) 193, 0},
    {1073, (void *) 194, 0},
    {1074, (void *) 215, 0},
    {1075, (void *) 199, 0},
    {1076, (void *) 196, 0},
    {1077, (void *) 197, 0},
    {1078, (void *) 214, 0},
    {1079, (void *) 218, 0},
    {1080, (void *) 201, 0},
    {1081, (void *) 202, 0},
    {1082, (void *) 203, 0},
    {1083, (void *) 204, 0},
    {1084, (void *) 205, 0},
    {1085, (void *) 206, 0},
    {1086, (void *) 207, 0},
    {1087, (void *) 208, 0},
    {1088, (void *) 210, 0},
    {1089, (void *) 211, 0},
    {1090, (void *) 212, 0},
    {1091, (void *) 213, 0},
    {1092, (void *) 198, 0},
    {1093, (void *) 200, 0},
    {1094, (void *) 195, 0},
    {1095, (void *) 222, 0},
    {1096, (void *) 219, 0},
    {1097, (void *) 221, 0},
    {1098, (void *) 223, 0},
    {1099, (void *) 217, 0},
    {1100, (void *) 216, 0},
    {1101, (void *) 220, 0},
    {1102, (void *) 192, 0},
    {1103, (void *) 209, 0},
    {0, NULL, 0},
    {1105, (void *) 163, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {160, (void *) 154, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {169, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 156, 0},
    {0, NULL, 0},
    {178, (void *) 157, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {183, (void *) 158, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9472, (void *) 128, 0},
    {0, NULL, 0},
    {9474, (void *) 129, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8992, (void *) 147, 0},
    {8993, (void *) 155, 0},
    {0, NULL, 0},
    {247, (void *) 159, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9484, (void *) 130, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9488, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9492, (void *) 132, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9496, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9500, (void *) 134, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9508, (void *) 135, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9516, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9524, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9532, (void *) 138, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9552, (void *) 160, 0},
    {9553, (void *) 161, 0},
    {9554, (void *) 162, 0},
    {9555, (void *) 164, 0},
    {9556, (void *) 165, 0},
    {9557, (void *) 166, 0},
    {9558, (void *) 167, 0},
    {9559, (void *) 168, 0},
    {9560, (void *) 169, 0},
    {9561, (void *) 170, 0},
    {9562, (void *) 171, 0},
    {9563, (void *) 172, 0},
    {9564, (void *) 173, 0},
    {9565, (void *) 174, 0},
    {9566, (void *) 175, 0},
    {9567, (void *) 176, 0},
    {9568, (void *) 177, 0},
    {9569, (void *) 178, 0},
    {9570, (void *) 180, 0},
    {9571, (void *) 181, 0},
    {9572, (void *) 182, 0},
    {9573, (void *) 183, 0},
    {9574, (void *) 184, 0},
    {9575, (void *) 185, 0},
    {9576, (void *) 186, 0},
    {9577, (void *) 187, 0},
    {9578, (void *) 188, 0},
    {9579, (void *) 189, 0},
    {9580, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9600, (void *) 139, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9604, (void *) 140, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9608, (void *) 141, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9612, (void *) 142, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9616, (void *) 143, 0},
    {9617, (void *) 144, 0},
    {9618, (void *) 145, 0},
    {9619, (void *) 146, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9632, (void *) 148, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8729, (void *) 149, 0},
    {8730, (void *) 150, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 380; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_koi8_u[381] = 
{
    {0, NULL, 0},{9500, (void *) 134, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9508, (void *) 135, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9516, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9524, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1168, (void *) 189, 0},
    {1169, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9532, (void *) 138, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8776, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9552, (void *) 160, 0},
    {9553, (void *) 161, 0},
    {9554, (void *) 162, 0},
    {0, NULL, 0},
    {9556, (void *) 165, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9559, (void *) 168, 0},
    {9560, (void *) 169, 0},
    {9561, (void *) 170, 0},
    {9562, (void *) 171, 0},
    {9563, (void *) 172, 0},
    {8804, (void *) 152, 0},
    {8805, (void *) 153, 0},
    {9566, (void *) 175, 0},
    {9567, (void *) 176, 0},
    {9568, (void *) 177, 0},
    {9569, (void *) 178, 0},
    {0, NULL, 0},
    {9571, (void *) 181, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9574, (void *) 184, 0},
    {9575, (void *) 185, 0},
    {9576, (void *) 186, 0},
    {9577, (void *) 187, 0},
    {9578, (void *) 188, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9600, (void *) 139, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9604, (void *) 140, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9608, (void *) 141, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9612, (void *) 142, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9616, (void *) 143, 0},
    {9617, (void *) 144, 0},
    {9618, (void *) 145, 0},
    {9619, (void *) 146, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9632, (void *) 148, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {160, (void *) 154, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {169, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {176, (void *) 156, 0},
    {0, NULL, 0},
    {178, (void *) 157, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {183, (void *) 158, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {247, (void *) 159, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8992, (void *) 147, 0},
    {8993, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1025, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1028, (void *) 180, 0},
    {0, NULL, 0},
    {1030, (void *) 182, 0},
    {1031, (void *) 183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1038, (void *) 190, 0},
    {0, NULL, 0},
    {1040, (void *) 225, 0},
    {1041, (void *) 226, 0},
    {1042, (void *) 247, 0},
    {1043, (void *) 231, 0},
    {1044, (void *) 228, 0},
    {1045, (void *) 229, 0},
    {1046, (void *) 246, 0},
    {1047, (void *) 250, 0},
    {1048, (void *) 233, 0},
    {1049, (void *) 234, 0},
    {1050, (void *) 235, 0},
    {1051, (void *) 236, 0},
    {1052, (void *) 237, 0},
    {1053, (void *) 238, 0},
    {1054, (void *) 239, 0},
    {1055, (void *) 240, 0},
    {1056, (void *) 242, 0},
    {1057, (void *) 243, 0},
    {1058, (void *) 244, 0},
    {1059, (void *) 245, 0},
    {1060, (void *) 230, 0},
    {1061, (void *) 232, 0},
    {1062, (void *) 227, 0},
    {1063, (void *) 254, 0},
    {1064, (void *) 251, 0},
    {1065, (void *) 253, 0},
    {1066, (void *) 255, 0},
    {1067, (void *) 249, 0},
    {1068, (void *) 248, 0},
    {1069, (void *) 252, 0},
    {1070, (void *) 224, 0},
    {1071, (void *) 241, 0},
    {1072, (void *) 193, 0},
    {1073, (void *) 194, 0},
    {1074, (void *) 215, 0},
    {1075, (void *) 199, 0},
    {1076, (void *) 196, 0},
    {1077, (void *) 197, 0},
    {1078, (void *) 214, 0},
    {1079, (void *) 218, 0},
    {1080, (void *) 201, 0},
    {1081, (void *) 202, 0},
    {1082, (void *) 203, 0},
    {1083, (void *) 204, 0},
    {1084, (void *) 205, 0},
    {1085, (void *) 206, 0},
    {1086, (void *) 207, 0},
    {1087, (void *) 208, 0},
    {1088, (void *) 210, 0},
    {1089, (void *) 211, 0},
    {1090, (void *) 212, 0},
    {1091, (void *) 213, 0},
    {1092, (void *) 198, 0},
    {1093, (void *) 200, 0},
    {1094, (void *) 195, 0},
    {1095, (void *) 222, 0},
    {1096, (void *) 219, 0},
    {1097, (void *) 221, 0},
    {1098, (void *) 223, 0},
    {1099, (void *) 217, 0},
    {1100, (void *) 216, 0},
    {1101, (void *) 220, 0},
    {1102, (void *) 192, 0},
    {1103, (void *) 209, 0},
    {0, NULL, 0},
    {1105, (void *) 163, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1108, (void *) 164, 0},
    {0, NULL, 0},
    {1110, (void *) 166, 0},
    {1111, (void *) 167, 0},
    {9472, (void *) 128, 0},
    {0, NULL, 0},
    {9474, (void *) 129, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1118, (void *) 174, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9484, (void *) 130, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9488, (void *) 131, 0},
    {8729, (void *) 149, 0},
    {8730, (void *) 150, 0},
    {0, NULL, 0},
    {9492, (void *) 132, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9496, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 343; Max deep: 2 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_macintosh[351] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 228, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 220, 0},
    {8250, (void *) 221, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {710, (void *) 246, 0},
    {711, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8260, (void *) 218, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {376, (void *) 217, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {728, (void *) 249, 0},
    {729, (void *) 250, 0},
    {730, (void *) 251, 0},
    {731, (void *) 254, 0},
    {732, (void *) 247, 0},
    {733, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 196, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {9674, (void *) 215, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {64257, (void *) 222, 0},
    {64258, (void *) 223, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8706, (void *) 182, 0},
    {8364, (void *) 219, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8710, (void *) 198, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8719, (void *) 184, 0},
    {0, NULL, 0},
    {8721, (void *) 183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8730, (void *) 195, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8734, (void *) 176, 0},
    {160, (void *) 202, 0},
    {161, (void *) 193, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {0, NULL, 0},
    {165, (void *) 180, 0},
    {0, NULL, 0},
    {167, (void *) 164, 0},
    {168, (void *) 172, 0},
    {169, (void *) 169, 0},
    {170, (void *) 187, 0},
    {171, (void *) 199, 0},
    {8747, (void *) 186, 349},
    {0, NULL, 0},
    {174, (void *) 168, 0},
    {175, (void *) 248, 0},
    {176, (void *) 161, 0},
    {177, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {180, (void *) 171, 0},
    {181, (void *) 181, 0},
    {182, (void *) 166, 0},
    {183, (void *) 225, 0},
    {184, (void *) 252, 0},
    {0, NULL, 0},
    {186, (void *) 188, 0},
    {187, (void *) 200, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {191, (void *) 192, 0},
    {192, (void *) 203, 0},
    {193, (void *) 231, 0},
    {194, (void *) 229, 0},
    {195, (void *) 204, 0},
    {196, (void *) 128, 0},
    {197, (void *) 129, 0},
    {198, (void *) 174, 0},
    {199, (void *) 130, 0},
    {200, (void *) 233, 0},
    {201, (void *) 131, 350},
    {202, (void *) 230, 0},
    {203, (void *) 232, 0},
    {204, (void *) 237, 0},
    {205, (void *) 234, 0},
    {206, (void *) 235, 0},
    {207, (void *) 236, 0},
    {0, NULL, 0},
    {209, (void *) 132, 0},
    {210, (void *) 241, 0},
    {211, (void *) 238, 0},
    {212, (void *) 239, 0},
    {213, (void *) 205, 0},
    {214, (void *) 133, 0},
    {0, NULL, 0},
    {216, (void *) 175, 0},
    {217, (void *) 244, 0},
    {218, (void *) 242, 0},
    {219, (void *) 243, 0},
    {220, (void *) 134, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {223, (void *) 167, 0},
    {224, (void *) 136, 0},
    {225, (void *) 135, 345},
    {226, (void *) 137, 0},
    {227, (void *) 139, 0},
    {228, (void *) 138, 0},
    {229, (void *) 140, 346},
    {8805, (void *) 179, 348},
    {231, (void *) 141, 0},
    {232, (void *) 143, 0},
    {233, (void *) 142, 0},
    {234, (void *) 144, 0},
    {235, (void *) 145, 0},
    {236, (void *) 147, 0},
    {237, (void *) 146, 0},
    {238, (void *) 148, 0},
    {239, (void *) 149, 0},
    {0, NULL, 0},
    {241, (void *) 150, 0},
    {242, (void *) 152, 0},
    {243, (void *) 151, 0},
    {244, (void *) 153, 0},
    {245, (void *) 155, 0},
    {246, (void *) 154, 0},
    {247, (void *) 214, 0},
    {248, (void *) 191, 0},
    {249, (void *) 157, 0},
    {250, (void *) 156, 344},
    {251, (void *) 158, 347},
    {252, (void *) 159, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {255, (void *) 216, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {960, (void *) 185, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {63743, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {305, (void *) 245, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 208, 0},
    {8212, (void *) 209, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 212, 0},
    {8217, (void *) 213, 0},
    {8218, (void *) 226, 0},
    {0, NULL, 0},
    {8220, (void *) 210, 0},
    {8221, (void *) 211, 0},
    {8222, (void *) 227, 0},
    {0, NULL, 0},
    {8224, (void *) 160, 0},
    {8225, (void *) 224, 0},
    {8226, (void *) 165, 0},
    {338, (void *) 206, 0},
    {339, (void *) 207, 0},
    {0, NULL, 0},
    {8230, (void *) 201, 0},
    {0, NULL, 0},
    {8482, (void *) 170, 0},
    {8800, (void *) 173, 0},
    {8804, (void *) 178, 0},
    {937, (void *) 189, 0},
    {230, (void *) 190, 0},
    {172, (void *) 194, 0},
    {8776, (void *) 197, 0}
};

/* Table size: 432; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1250[433] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {0, NULL, 0},
    {131, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {136, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {152, (void *) 152, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 128, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {0, NULL, 0},
    {196, (void *) 196, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {199, (void *) 199, 0},
    {0, NULL, 0},
    {201, (void *) 201, 0},
    {0, NULL, 0},
    {203, (void *) 203, 0},
    {0, NULL, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {0, NULL, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {218, (void *) 218, 0},
    {0, NULL, 0},
    {220, (void *) 220, 0},
    {221, (void *) 221, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {0, NULL, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {0, NULL, 0},
    {228, (void *) 228, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {231, (void *) 231, 0},
    {0, NULL, 0},
    {233, (void *) 233, 0},
    {0, NULL, 0},
    {235, (void *) 235, 0},
    {0, NULL, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {0, NULL, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {250, (void *) 250, 0},
    {0, NULL, 0},
    {252, (void *) 252, 0},
    {253, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {258, (void *) 195, 0},
    {259, (void *) 227, 0},
    {260, (void *) 165, 0},
    {261, (void *) 185, 0},
    {262, (void *) 198, 0},
    {263, (void *) 230, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {268, (void *) 200, 0},
    {269, (void *) 232, 0},
    {270, (void *) 207, 0},
    {271, (void *) 239, 0},
    {272, (void *) 208, 0},
    {273, (void *) 240, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {711, (void *) 161, 0},
    {280, (void *) 202, 0},
    {281, (void *) 234, 0},
    {282, (void *) 204, 0},
    {283, (void *) 236, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {728, (void *) 162, 0},
    {729, (void *) 255, 0},
    {0, NULL, 0},
    {731, (void *) 178, 0},
    {0, NULL, 0},
    {733, (void *) 189, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {313, (void *) 197, 0},
    {314, (void *) 229, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {317, (void *) 188, 0},
    {318, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {321, (void *) 163, 0},
    {322, (void *) 179, 0},
    {323, (void *) 209, 0},
    {324, (void *) 241, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {327, (void *) 210, 0},
    {328, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {336, (void *) 213, 0},
    {337, (void *) 245, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {340, (void *) 192, 0},
    {341, (void *) 224, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {344, (void *) 216, 0},
    {345, (void *) 248, 0},
    {346, (void *) 140, 0},
    {347, (void *) 156, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {350, (void *) 170, 0},
    {351, (void *) 186, 0},
    {352, (void *) 138, 0},
    {353, (void *) 154, 0},
    {354, (void *) 222, 0},
    {355, (void *) 254, 0},
    {356, (void *) 141, 0},
    {357, (void *) 157, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {366, (void *) 217, 0},
    {367, (void *) 249, 0},
    {368, (void *) 219, 0},
    {369, (void *) 251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {377, (void *) 143, 0},
    {378, (void *) 159, 0},
    {379, (void *) 175, 0},
    {380, (void *) 191, 0},
    {381, (void *) 142, 0},
    {382, (void *) 158, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 362; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1251[363] = 
{
    {0, NULL, 0},{1086, (void *) 238, 0},
    {1087, (void *) 239, 0},
    {1088, (void *) 240, 0},
    {1089, (void *) 241, 0},
    {1090, (void *) 242, 0},
    {1091, (void *) 243, 0},
    {1092, (void *) 244, 0},
    {1093, (void *) 245, 0},
    {1094, (void *) 246, 0},
    {1095, (void *) 247, 0},
    {1096, (void *) 248, 0},
    {1097, (void *) 249, 0},
    {1098, (void *) 250, 0},
    {1099, (void *) 251, 0},
    {1100, (void *) 252, 0},
    {1101, (void *) 253, 0},
    {1102, (void *) 254, 0},
    {1103, (void *) 255, 0},
    {0, NULL, 0},
    {1105, (void *) 184, 0},
    {1106, (void *) 144, 0},
    {1107, (void *) 131, 0},
    {1108, (void *) 186, 0},
    {1109, (void *) 190, 0},
    {1110, (void *) 179, 0},
    {1111, (void *) 191, 0},
    {1112, (void *) 188, 0},
    {1113, (void *) 154, 0},
    {1114, (void *) 156, 0},
    {1115, (void *) 158, 0},
    {1116, (void *) 157, 0},
    {0, NULL, 0},
    {1118, (void *) 162, 0},
    {1119, (void *) 159, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1168, (void *) 165, 0},
    {1169, (void *) 180, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8470, (void *) 185, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {152, (void *) 152, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {0, NULL, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1025, (void *) 168, 0},
    {1026, (void *) 128, 0},
    {1027, (void *) 129, 0},
    {1028, (void *) 170, 0},
    {1029, (void *) 189, 0},
    {1030, (void *) 178, 0},
    {1031, (void *) 175, 0},
    {1032, (void *) 163, 0},
    {1033, (void *) 138, 0},
    {1034, (void *) 140, 0},
    {1035, (void *) 142, 0},
    {1036, (void *) 141, 0},
    {0, NULL, 0},
    {1038, (void *) 161, 0},
    {1039, (void *) 143, 0},
    {1040, (void *) 192, 0},
    {1041, (void *) 193, 0},
    {1042, (void *) 194, 0},
    {1043, (void *) 195, 0},
    {1044, (void *) 196, 0},
    {1045, (void *) 197, 0},
    {1046, (void *) 198, 0},
    {1047, (void *) 199, 0},
    {1048, (void *) 200, 0},
    {1049, (void *) 201, 0},
    {1050, (void *) 202, 0},
    {1051, (void *) 203, 0},
    {1052, (void *) 204, 0},
    {1053, (void *) 205, 0},
    {1054, (void *) 206, 0},
    {1055, (void *) 207, 0},
    {1056, (void *) 208, 0},
    {1057, (void *) 209, 0},
    {1058, (void *) 210, 0},
    {1059, (void *) 211, 0},
    {1060, (void *) 212, 0},
    {1061, (void *) 213, 0},
    {1062, (void *) 214, 0},
    {1063, (void *) 215, 0},
    {1064, (void *) 216, 0},
    {1065, (void *) 217, 0},
    {1066, (void *) 218, 0},
    {1067, (void *) 219, 0},
    {1068, (void *) 220, 0},
    {1069, (void *) 221, 0},
    {1070, (void *) 222, 0},
    {1071, (void *) 223, 0},
    {1072, (void *) 224, 0},
    {1073, (void *) 225, 0},
    {1074, (void *) 226, 0},
    {1075, (void *) 227, 0},
    {1076, (void *) 228, 0},
    {1077, (void *) 229, 0},
    {1078, (void *) 230, 0},
    {1079, (void *) 231, 0},
    {1080, (void *) 232, 0},
    {1081, (void *) 233, 0},
    {1082, (void *) 234, 0},
    {1083, (void *) 235, 0},
    {1084, (void *) 236, 0},
    {1085, (void *) 237, 0}
};

/* Table size: 373; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1252[374] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {376, (void *) 159, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {381, (void *) 142, 0},
    {382, (void *) 158, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {141, (void *) 141, 0},
    {0, NULL, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {157, (void *) 157, 0},
    {8364, (void *) 128, 0},
    {0, NULL, 0},
    {160, (void *) 160, 0},
    {161, (void *) 161, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {165, (void *) 165, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {170, (void *) 170, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 175, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {185, (void *) 185, 0},
    {186, (void *) 186, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {191, (void *) 191, 0},
    {192, (void *) 192, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {195, (void *) 195, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 198, 0},
    {199, (void *) 199, 0},
    {200, (void *) 200, 0},
    {201, (void *) 201, 0},
    {202, (void *) 202, 0},
    {203, (void *) 203, 0},
    {204, (void *) 204, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {208, (void *) 208, 0},
    {209, (void *) 209, 0},
    {210, (void *) 210, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {216, (void *) 216, 0},
    {217, (void *) 217, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {221, (void *) 221, 0},
    {222, (void *) 222, 0},
    {223, (void *) 223, 0},
    {224, (void *) 224, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {227, (void *) 227, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 230, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {236, (void *) 236, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {240, (void *) 240, 0},
    {241, (void *) 241, 0},
    {242, (void *) 242, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {248, (void *) 248, 0},
    {249, (void *) 249, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {253, (void *) 253, 0},
    {254, (void *) 254, 0},
    {255, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {710, (void *) 136, 0},
    {338, (void *) 140, 0},
    {339, (void *) 156, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {352, (void *) 138, 0},
    {353, (void *) 154, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {732, (void *) 152, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 354; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1253[355] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {8213, (void *) 175, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {136, (void *) 136, 0},
    {0, NULL, 0},
    {138, (void *) 138, 0},
    {0, NULL, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {152, (void *) 152, 0},
    {0, NULL, 0},
    {154, (void *) 154, 0},
    {0, NULL, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {165, (void *) 165, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {0, NULL, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {0, NULL, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {0, NULL, 0},
    {189, (void *) 189, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {900, (void *) 180, 0},
    {901, (void *) 161, 0},
    {902, (void *) 162, 0},
    {0, NULL, 0},
    {904, (void *) 184, 0},
    {905, (void *) 185, 0},
    {906, (void *) 186, 0},
    {0, NULL, 0},
    {908, (void *) 188, 0},
    {0, NULL, 0},
    {910, (void *) 190, 0},
    {911, (void *) 191, 0},
    {912, (void *) 192, 0},
    {913, (void *) 193, 0},
    {914, (void *) 194, 0},
    {915, (void *) 195, 0},
    {916, (void *) 196, 0},
    {917, (void *) 197, 0},
    {918, (void *) 198, 0},
    {919, (void *) 199, 0},
    {920, (void *) 200, 0},
    {921, (void *) 201, 0},
    {922, (void *) 202, 0},
    {923, (void *) 203, 0},
    {924, (void *) 204, 0},
    {925, (void *) 205, 0},
    {926, (void *) 206, 0},
    {927, (void *) 207, 0},
    {928, (void *) 208, 0},
    {929, (void *) 209, 0},
    {8364, (void *) 128, 0},
    {931, (void *) 211, 0},
    {932, (void *) 212, 0},
    {933, (void *) 213, 0},
    {934, (void *) 214, 0},
    {935, (void *) 215, 0},
    {936, (void *) 216, 0},
    {937, (void *) 217, 0},
    {938, (void *) 218, 0},
    {939, (void *) 219, 0},
    {940, (void *) 220, 0},
    {941, (void *) 221, 0},
    {942, (void *) 222, 0},
    {943, (void *) 223, 0},
    {944, (void *) 224, 0},
    {945, (void *) 225, 0},
    {946, (void *) 226, 0},
    {947, (void *) 227, 0},
    {948, (void *) 228, 0},
    {949, (void *) 229, 0},
    {950, (void *) 230, 0},
    {951, (void *) 231, 0},
    {952, (void *) 232, 0},
    {953, (void *) 233, 0},
    {954, (void *) 234, 0},
    {955, (void *) 235, 0},
    {956, (void *) 236, 0},
    {957, (void *) 237, 0},
    {958, (void *) 238, 0},
    {959, (void *) 239, 0},
    {960, (void *) 240, 0},
    {961, (void *) 241, 0},
    {962, (void *) 242, 0},
    {963, (void *) 243, 0},
    {964, (void *) 244, 0},
    {965, (void *) 245, 0},
    {966, (void *) 246, 0},
    {967, (void *) 247, 0},
    {968, (void *) 248, 0},
    {969, (void *) 249, 0},
    {970, (void *) 250, 0},
    {971, (void *) 251, 0},
    {972, (void *) 252, 0},
    {973, (void *) 253, 0},
    {974, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 354; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1254[355] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {710, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {376, (void *) 159, 0},
    {0, NULL, 0},
    {732, (void *) 152, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {0, NULL, 0},
    {160, (void *) 160, 0},
    {161, (void *) 161, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {165, (void *) 165, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {170, (void *) 170, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 175, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {185, (void *) 185, 0},
    {186, (void *) 186, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {191, (void *) 191, 0},
    {192, (void *) 192, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {195, (void *) 195, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 198, 0},
    {199, (void *) 199, 0},
    {200, (void *) 200, 0},
    {201, (void *) 201, 0},
    {202, (void *) 202, 0},
    {203, (void *) 203, 0},
    {204, (void *) 204, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {0, NULL, 0},
    {209, (void *) 209, 0},
    {210, (void *) 210, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {216, (void *) 216, 0},
    {217, (void *) 217, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {0, NULL, 0},
    {8364, (void *) 128, 0},
    {223, (void *) 223, 0},
    {224, (void *) 224, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {227, (void *) 227, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 230, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {236, (void *) 236, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {0, NULL, 0},
    {241, (void *) 241, 0},
    {242, (void *) 242, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {248, (void *) 248, 0},
    {249, (void *) 249, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {255, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {286, (void *) 208, 0},
    {287, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {304, (void *) 221, 0},
    {305, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {338, (void *) 140, 0},
    {339, (void *) 156, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {350, (void *) 222, 0},
    {351, (void *) 254, 0},
    {352, (void *) 138, 0},
    {353, (void *) 154, 0}
};

/* Table size: 467; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1255[468] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1456, (void *) 192, 0},
    {1457, (void *) 193, 0},
    {1458, (void *) 194, 0},
    {1459, (void *) 195, 0},
    {1460, (void *) 196, 0},
    {1461, (void *) 197, 0},
    {1462, (void *) 198, 0},
    {1463, (void *) 199, 0},
    {1464, (void *) 200, 0},
    {1465, (void *) 201, 0},
    {1466, (void *) 202, 0},
    {1467, (void *) 203, 0},
    {1468, (void *) 204, 0},
    {1469, (void *) 205, 0},
    {1470, (void *) 206, 0},
    {1471, (void *) 207, 0},
    {1472, (void *) 208, 0},
    {1473, (void *) 209, 0},
    {1474, (void *) 210, 0},
    {1475, (void *) 211, 0},
    {0, NULL, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1488, (void *) 224, 0},
    {1489, (void *) 225, 0},
    {1490, (void *) 226, 0},
    {1491, (void *) 227, 0},
    {1492, (void *) 228, 0},
    {1493, (void *) 229, 0},
    {1494, (void *) 230, 0},
    {1495, (void *) 231, 0},
    {1496, (void *) 232, 0},
    {1497, (void *) 233, 0},
    {1498, (void *) 234, 0},
    {1499, (void *) 235, 0},
    {1500, (void *) 236, 0},
    {1501, (void *) 237, 0},
    {1502, (void *) 238, 0},
    {1503, (void *) 239, 0},
    {1504, (void *) 240, 0},
    {1505, (void *) 241, 0},
    {1506, (void *) 242, 0},
    {1507, (void *) 243, 0},
    {1508, (void *) 244, 0},
    {1509, (void *) 245, 0},
    {1510, (void *) 246, 0},
    {1511, (void *) 247, 0},
    {1512, (void *) 248, 0},
    {1513, (void *) 249, 0},
    {1514, (void *) 250, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1520, (void *) 212, 0},
    {1521, (void *) 213, 0},
    {1522, (void *) 214, 0},
    {1523, (void *) 215, 0},
    {1524, (void *) 216, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {138, (void *) 138, 0},
    {0, NULL, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {154, (void *) 154, 0},
    {0, NULL, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {161, (void *) 161, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {0, NULL, 0},
    {165, (void *) 165, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 175, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {185, (void *) 185, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {191, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {215, (void *) 170, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {710, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {247, (void *) 186, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {732, (void *) 152, 0},
    {0, NULL, 0},
    {8206, (void *) 253, 0},
    {8207, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8362, (void *) 164, 0},
    {0, NULL, 0},
    {8364, (void *) 128, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 343; Max deep: 2 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1256[357] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1722, (void *) 159, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1726, (void *) 170, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1729, (void *) 192, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {710, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1746, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 128, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {165, (void *) 165, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 175, 0},
    {1548, (void *) 161, 347},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {185, (void *) 185, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {1563, (void *) 186, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1567, (void *) 191, 0},
    {0, NULL, 0},
    {1569, (void *) 193, 0},
    {1570, (void *) 194, 0},
    {1571, (void *) 195, 0},
    {1572, (void *) 196, 0},
    {1573, (void *) 197, 0},
    {1574, (void *) 198, 0},
    {1575, (void *) 199, 0},
    {1576, (void *) 200, 0},
    {1577, (void *) 201, 0},
    {1578, (void *) 202, 0},
    {1579, (void *) 203, 0},
    {1580, (void *) 204, 0},
    {1581, (void *) 205, 0},
    {1582, (void *) 206, 0},
    {1583, (void *) 207, 0},
    {1584, (void *) 208, 0},
    {1585, (void *) 209, 0},
    {1586, (void *) 210, 0},
    {1587, (void *) 211, 348},
    {1588, (void *) 212, 0},
    {1589, (void *) 213, 0},
    {1590, (void *) 214, 0},
    {1591, (void *) 216, 0},
    {1592, (void *) 217, 0},
    {1593, (void *) 218, 0},
    {1594, (void *) 219, 0},
    {0, NULL, 0},
    {224, (void *) 224, 0},
    {0, NULL, 0},
    {226, (void *) 226, 0},
    {0, NULL, 0},
    {1600, (void *) 220, 0},
    {1601, (void *) 221, 0},
    {1602, (void *) 222, 0},
    {1603, (void *) 223, 349},
    {1604, (void *) 225, 350},
    {1605, (void *) 227, 351},
    {1606, (void *) 228, 352},
    {1607, (void *) 229, 353},
    {1608, (void *) 230, 0},
    {1609, (void *) 236, 0},
    {1610, (void *) 237, 354},
    {239, (void *) 239, 355},
    {1612, (void *) 241, 0},
    {1613, (void *) 242, 0},
    {1614, (void *) 243, 0},
    {1615, (void *) 245, 0},
    {244, (void *) 244, 356},
    {1617, (void *) 248, 0},
    {1618, (void *) 250, 0},
    {247, (void *) 247, 0},
    {0, NULL, 0},
    {249, (void *) 249, 0},
    {8482, (void *) 153, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1657, (void *) 138, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1662, (void *) 129, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1670, (void *) 141, 0},
    {0, NULL, 0},
    {1672, (void *) 143, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1681, (void *) 154, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8204, (void *) 157, 0},
    {1688, (void *) 142, 346},
    {8206, (void *) 253, 0},
    {8207, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 344},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {338, (void *) 140, 0},
    {1711, (void *) 144, 345},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {1705, (void *) 152, 0},
    {339, (void *) 156, 0},
    {8205, (void *) 158, 0},
    {176, (void *) 176, 0},
    {215, (void *) 215, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {238, (void *) 238, 0},
    {1611, (void *) 240, 0},
    {1616, (void *) 246, 0}
};

/* Table size: 355; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1257[356] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {711, (void *) 142, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {362, (void *) 219, 0},
    {363, (void *) 251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {370, (void *) 216, 0},
    {371, (void *) 248, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {729, (void *) 255, 0},
    {0, NULL, 0},
    {731, (void *) 158, 0},
    {377, (void *) 202, 0},
    {378, (void *) 234, 0},
    {379, (void *) 221, 0},
    {380, (void *) 253, 0},
    {381, (void *) 222, 0},
    {382, (void *) 254, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {0, NULL, 0},
    {131, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {136, (void *) 136, 0},
    {0, NULL, 0},
    {138, (void *) 138, 0},
    {0, NULL, 0},
    {140, (void *) 140, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {152, (void *) 152, 0},
    {0, NULL, 0},
    {154, (void *) 154, 0},
    {0, NULL, 0},
    {156, (void *) 156, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {0, NULL, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 141, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 157, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 143, 0},
    {185, (void *) 185, 0},
    {0, NULL, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 175, 0},
    {8364, (void *) 128, 0},
    {0, NULL, 0},
    {201, (void *) 201, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {211, (void *) 211, 0},
    {0, NULL, 0},
    {213, (void *) 213, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {216, (void *) 168, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {220, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 191, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {233, (void *) 233, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {243, (void *) 243, 0},
    {0, NULL, 0},
    {245, (void *) 245, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {248, (void *) 184, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {256, (void *) 194, 0},
    {257, (void *) 226, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {260, (void *) 192, 0},
    {261, (void *) 224, 0},
    {262, (void *) 195, 0},
    {263, (void *) 227, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {268, (void *) 200, 0},
    {269, (void *) 232, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {274, (void *) 199, 0},
    {275, (void *) 231, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {278, (void *) 203, 0},
    {279, (void *) 235, 0},
    {280, (void *) 198, 0},
    {281, (void *) 230, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {290, (void *) 204, 0},
    {291, (void *) 236, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {298, (void *) 206, 0},
    {299, (void *) 238, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {302, (void *) 193, 0},
    {303, (void *) 225, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {310, (void *) 205, 0},
    {311, (void *) 237, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {315, (void *) 207, 0},
    {316, (void *) 239, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {321, (void *) 217, 0},
    {322, (void *) 249, 0},
    {323, (void *) 209, 0},
    {324, (void *) 241, 0},
    {325, (void *) 210, 0},
    {326, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {332, (void *) 212, 0},
    {333, (void *) 244, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {342, (void *) 170, 0},
    {343, (void *) 186, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {346, (void *) 218, 0},
    {347, (void *) 250, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {352, (void *) 208, 0},
    {353, (void *) 240, 0},
    {0, NULL, 0}
};

/* Table size: 405; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1258[406] = 
{
    {0, NULL, 0},{0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {416, (void *) 213, 0},
    {417, (void *) 245, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {431, (void *) 221, 0},
    {432, (void *) 253, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {8218, (void *) 130, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {8222, (void *) 132, 0},
    {0, NULL, 0},
    {8224, (void *) 134, 0},
    {8225, (void *) 135, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {138, (void *) 138, 0},
    {0, NULL, 0},
    {8240, (void *) 137, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8249, (void *) 139, 0},
    {8250, (void *) 155, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {154, (void *) 154, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {0, NULL, 0},
    {160, (void *) 160, 0},
    {161, (void *) 161, 0},
    {162, (void *) 162, 0},
    {163, (void *) 163, 0},
    {164, (void *) 164, 0},
    {165, (void *) 165, 0},
    {166, (void *) 166, 0},
    {167, (void *) 167, 0},
    {168, (void *) 168, 0},
    {169, (void *) 169, 0},
    {170, (void *) 170, 0},
    {171, (void *) 171, 0},
    {172, (void *) 172, 0},
    {173, (void *) 173, 0},
    {174, (void *) 174, 0},
    {175, (void *) 175, 0},
    {176, (void *) 176, 0},
    {177, (void *) 177, 0},
    {178, (void *) 178, 0},
    {179, (void *) 179, 0},
    {180, (void *) 180, 0},
    {181, (void *) 181, 0},
    {182, (void *) 182, 0},
    {183, (void *) 183, 0},
    {184, (void *) 184, 0},
    {185, (void *) 185, 0},
    {186, (void *) 186, 0},
    {187, (void *) 187, 0},
    {188, (void *) 188, 0},
    {189, (void *) 189, 0},
    {190, (void *) 190, 0},
    {191, (void *) 191, 0},
    {192, (void *) 192, 0},
    {193, (void *) 193, 0},
    {194, (void *) 194, 0},
    {0, NULL, 0},
    {196, (void *) 196, 0},
    {197, (void *) 197, 0},
    {198, (void *) 198, 0},
    {199, (void *) 199, 0},
    {200, (void *) 200, 0},
    {201, (void *) 201, 0},
    {202, (void *) 202, 0},
    {203, (void *) 203, 0},
    {0, NULL, 0},
    {205, (void *) 205, 0},
    {206, (void *) 206, 0},
    {207, (void *) 207, 0},
    {0, NULL, 0},
    {209, (void *) 209, 0},
    {0, NULL, 0},
    {211, (void *) 211, 0},
    {212, (void *) 212, 0},
    {0, NULL, 0},
    {214, (void *) 214, 0},
    {215, (void *) 215, 0},
    {216, (void *) 216, 0},
    {217, (void *) 217, 0},
    {218, (void *) 218, 0},
    {219, (void *) 219, 0},
    {220, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {223, (void *) 223, 0},
    {224, (void *) 224, 0},
    {225, (void *) 225, 0},
    {226, (void *) 226, 0},
    {0, NULL, 0},
    {228, (void *) 228, 0},
    {229, (void *) 229, 0},
    {230, (void *) 230, 0},
    {231, (void *) 231, 0},
    {232, (void *) 232, 0},
    {233, (void *) 233, 0},
    {234, (void *) 234, 0},
    {235, (void *) 235, 0},
    {0, NULL, 0},
    {237, (void *) 237, 0},
    {238, (void *) 238, 0},
    {239, (void *) 239, 0},
    {0, NULL, 0},
    {241, (void *) 241, 0},
    {0, NULL, 0},
    {243, (void *) 243, 0},
    {244, (void *) 244, 0},
    {0, NULL, 0},
    {246, (void *) 246, 0},
    {247, (void *) 247, 0},
    {248, (void *) 248, 0},
    {249, (void *) 249, 0},
    {250, (void *) 250, 0},
    {251, (void *) 251, 0},
    {252, (void *) 252, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {255, (void *) 255, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {258, (void *) 195, 0},
    {259, (void *) 227, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8363, (void *) 254, 0},
    {8364, (void *) 128, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {272, (void *) 208, 0},
    {273, (void *) 240, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {710, (void *) 136, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {732, (void *) 152, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {338, (void *) 140, 0},
    {339, (void *) 156, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {768, (void *) 204, 0},
    {769, (void *) 236, 0},
    {0, NULL, 0},
    {771, (void *) 222, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {777, (void *) 210, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {376, (void *) 159, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8482, (void *) 153, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {803, (void *) 242, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 131, 0},
    {0, NULL, 0},
    {0, NULL, 0}
};

/* Table size: 359; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_874[360] = 
{
    {0, NULL, 0},{3590, (void *) 166, 0},
    {3591, (void *) 167, 0},
    {3592, (void *) 168, 0},
    {3593, (void *) 169, 0},
    {3594, (void *) 170, 0},
    {3595, (void *) 171, 0},
    {3596, (void *) 172, 0},
    {3597, (void *) 173, 0},
    {3598, (void *) 174, 0},
    {3599, (void *) 175, 0},
    {3600, (void *) 176, 0},
    {3601, (void *) 177, 0},
    {3602, (void *) 178, 0},
    {3603, (void *) 179, 0},
    {3604, (void *) 180, 0},
    {3605, (void *) 181, 0},
    {3606, (void *) 182, 0},
    {3607, (void *) 183, 0},
    {3608, (void *) 184, 0},
    {3609, (void *) 185, 0},
    {3610, (void *) 186, 0},
    {3611, (void *) 187, 0},
    {3612, (void *) 188, 0},
    {3613, (void *) 189, 0},
    {3614, (void *) 190, 0},
    {3615, (void *) 191, 0},
    {3616, (void *) 192, 0},
    {3617, (void *) 193, 0},
    {3618, (void *) 194, 0},
    {3619, (void *) 195, 0},
    {3620, (void *) 196, 0},
    {3621, (void *) 197, 0},
    {3622, (void *) 198, 0},
    {3623, (void *) 199, 0},
    {3624, (void *) 200, 0},
    {3625, (void *) 201, 0},
    {3626, (void *) 202, 0},
    {3627, (void *) 203, 0},
    {3628, (void *) 204, 0},
    {3629, (void *) 205, 0},
    {3630, (void *) 206, 0},
    {3631, (void *) 207, 0},
    {3632, (void *) 208, 0},
    {3633, (void *) 209, 0},
    {3634, (void *) 210, 0},
    {3635, (void *) 211, 0},
    {3636, (void *) 212, 0},
    {3637, (void *) 213, 0},
    {3638, (void *) 214, 0},
    {3639, (void *) 215, 0},
    {3640, (void *) 216, 0},
    {3641, (void *) 217, 0},
    {3642, (void *) 218, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {3647, (void *) 223, 0},
    {3648, (void *) 224, 0},
    {3649, (void *) 225, 0},
    {3650, (void *) 226, 0},
    {3651, (void *) 227, 0},
    {3652, (void *) 228, 0},
    {3653, (void *) 229, 0},
    {3654, (void *) 230, 0},
    {3655, (void *) 231, 0},
    {3656, (void *) 232, 0},
    {3657, (void *) 233, 0},
    {3658, (void *) 234, 0},
    {3659, (void *) 235, 0},
    {3660, (void *) 236, 0},
    {3661, (void *) 237, 0},
    {3662, (void *) 238, 0},
    {3663, (void *) 239, 0},
    {3664, (void *) 240, 0},
    {3665, (void *) 241, 0},
    {3666, (void *) 242, 0},
    {3667, (void *) 243, 0},
    {3668, (void *) 244, 0},
    {3669, (void *) 245, 0},
    {3670, (void *) 246, 0},
    {3671, (void *) 247, 0},
    {3672, (void *) 248, 0},
    {3673, (void *) 249, 0},
    {3674, (void *) 250, 0},
    {3675, (void *) 251, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 128, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {129, (void *) 129, 0},
    {130, (void *) 130, 0},
    {131, (void *) 131, 0},
    {132, (void *) 132, 0},
    {0, NULL, 0},
    {134, (void *) 134, 0},
    {135, (void *) 135, 0},
    {136, (void *) 136, 0},
    {137, (void *) 137, 0},
    {138, (void *) 138, 0},
    {139, (void *) 139, 0},
    {140, (void *) 140, 0},
    {141, (void *) 141, 0},
    {142, (void *) 142, 0},
    {143, (void *) 143, 0},
    {144, (void *) 144, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {152, (void *) 152, 0},
    {153, (void *) 153, 0},
    {154, (void *) 154, 0},
    {155, (void *) 155, 0},
    {156, (void *) 156, 0},
    {157, (void *) 157, 0},
    {158, (void *) 158, 0},
    {159, (void *) 159, 0},
    {160, (void *) 160, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 150, 0},
    {8212, (void *) 151, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 145, 0},
    {8217, (void *) 146, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8220, (void *) 147, 0},
    {8221, (void *) 148, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8226, (void *) 149, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 133, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {3585, (void *) 161, 0},
    {3586, (void *) 162, 0},
    {3587, (void *) 163, 0},
    {3588, (void *) 164, 0},
    {3589, (void *) 165, 0}
};

/* Table size: 373; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_x_mac_cyrillic[374] = 
{
    {0, NULL, 0},{1119, (void *) 219, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8211, (void *) 208, 0},
    {8212, (void *) 209, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8216, (void *) 212, 0},
    {8217, (void *) 213, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8220, (void *) 210, 0},
    {8221, (void *) 211, 0},
    {8222, (void *) 215, 0},
    {0, NULL, 0},
    {8224, (void *) 160, 0},
    {0, NULL, 0},
    {8226, (void *) 165, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8230, (void *) 201, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {402, (void *) 196, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1168, (void *) 162, 0},
    {1169, (void *) 182, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8710, (void *) 198, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8730, (void *) 195, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8734, (void *) 176, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8364, (void *) 255, 0},
    {0, NULL, 0},
    {160, (void *) 202, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {163, (void *) 163, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {167, (void *) 164, 0},
    {0, NULL, 0},
    {169, (void *) 169, 0},
    {0, NULL, 0},
    {171, (void *) 199, 0},
    {172, (void *) 194, 0},
    {0, NULL, 0},
    {174, (void *) 168, 0},
    {0, NULL, 0},
    {176, (void *) 161, 0},
    {177, (void *) 177, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {181, (void *) 181, 0},
    {182, (void *) 166, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {187, (void *) 200, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8776, (void *) 197, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8800, (void *) 173, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8804, (void *) 178, 0},
    {8805, (void *) 179, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {247, (void *) 214, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8470, (void *) 220, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {8482, (void *) 170, 0},
    {0, NULL, 0},
    {0, NULL, 0},
    {1025, (void *) 221, 0},
    {1026, (void *) 171, 0},
    {1027, (void *) 174, 0},
    {1028, (void *) 184, 0},
    {1029, (void *) 193, 0},
    {1030, (void *) 167, 0},
    {1031, (void *) 186, 0},
    {1032, (void *) 183, 0},
    {1033, (void *) 188, 0},
    {1034, (void *) 190, 0},
    {1035, (void *) 203, 0},
    {1036, (void *) 205, 0},
    {0, NULL, 0},
    {1038, (void *) 216, 0},
    {1039, (void *) 218, 0},
    {1040, (void *) 128, 0},
    {1041, (void *) 129, 0},
    {1042, (void *) 130, 0},
    {1043, (void *) 131, 0},
    {1044, (void *) 132, 0},
    {1045, (void *) 133, 0},
    {1046, (void *) 134, 0},
    {1047, (void *) 135, 0},
    {1048, (void *) 136, 0},
    {1049, (void *) 137, 0},
    {1050, (void *) 138, 0},
    {1051, (void *) 139, 0},
    {1052, (void *) 140, 0},
    {1053, (void *) 141, 0},
    {1054, (void *) 142, 0},
    {1055, (void *) 143, 0},
    {1056, (void *) 144, 0},
    {1057, (void *) 145, 0},
    {1058, (void *) 146, 0},
    {1059, (void *) 147, 0},
    {1060, (void *) 148, 0},
    {1061, (void *) 149, 0},
    {1062, (void *) 150, 0},
    {1063, (void *) 151, 0},
    {1064, (void *) 152, 0},
    {1065, (void *) 153, 0},
    {1066, (void *) 154, 0},
    {1067, (void *) 155, 0},
    {1068, (void *) 156, 0},
    {1069, (void *) 157, 0},
    {1070, (void *) 158, 0},
    {1071, (void *) 159, 0},
    {1072, (void *) 224, 0},
    {1073, (void *) 225, 0},
    {1074, (void *) 226, 0},
    {1075, (void *) 227, 0},
    {1076, (void *) 228, 0},
    {1077, (void *) 229, 0},
    {1078, (void *) 230, 0},
    {1079, (void *) 231, 0},
    {1080, (void *) 232, 0},
    {1081, (void *) 233, 0},
    {1082, (void *) 234, 0},
    {1083, (void *) 235, 0},
    {1084, (void *) 236, 0},
    {1085, (void *) 237, 0},
    {1086, (void *) 238, 0},
    {1087, (void *) 239, 0},
    {1088, (void *) 240, 0},
    {1089, (void *) 241, 0},
    {1090, (void *) 242, 0},
    {1091, (void *) 243, 0},
    {1092, (void *) 244, 0},
    {1093, (void *) 245, 0},
    {1094, (void *) 246, 0},
    {1095, (void *) 247, 0},
    {1096, (void *) 248, 0},
    {1097, (void *) 249, 0},
    {1098, (void *) 250, 0},
    {1099, (void *) 251, 0},
    {1100, (void *) 252, 0},
    {1101, (void *) 253, 0},
    {1102, (void *) 254, 0},
    {1103, (void *) 223, 0},
    {0, NULL, 0},
    {1105, (void *) 222, 0},
    {1106, (void *) 172, 0},
    {1107, (void *) 175, 0},
    {1108, (void *) 185, 0},
    {1109, (void *) 207, 0},
    {1110, (void *) 180, 0},
    {1111, (void *) 187, 0},
    {1112, (void *) 192, 0},
    {1113, (void *) 189, 0},
    {1114, (void *) 191, 0},
    {1115, (void *) 204, 0},
    {1116, (void *) 206, 0},
    {0, NULL, 0},
    {1118, (void *) 217, 0}
};
