/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.javascript;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.navigation.JSDeclarationEvaluator;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.service.VulnerableApiService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.packageChecker.javascript"})
public final class NpmVulnerableApiCodeInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new Visitor(holder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection$Visitor;", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "retrievePath", "", "file", "Lcom/intellij/psi/PsiFile;", "visitJSCallExpression", "", "node", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "intellij.packageChecker.javascript"})
    @SourceDebugExtension(value={"SMAP\nNpmVulnerableApiCodeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmVulnerableApiCodeInspection.kt\ncom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection$Visitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n3792#2:67\n4307#2,2:68\n1549#3:70\n1620#3,3:71\n*S KotlinDebug\n*F\n+ 1 NpmVulnerableApiCodeInspection.kt\ncom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection$Visitor\n*L\n33#1:67\n33#1:68,2\n33#1:70\n33#1:71,3\n*E\n"})
    private static final class Visitor
    extends JSElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public Visitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        /*
         * WARNING - void declaration
         */
        public void visitJSCallExpression(@NotNull JSCallExpression node) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitJSCallExpression(node);
            JSExpression jSExpression = node.getMethodExpression();
            JSReferenceExpression jSReferenceExpression = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
            if (jSReferenceExpression == null) {
                return;
            }
            JSReferenceExpression referenceExpression = jSReferenceExpression;
            ResolveResult[] resolveResultArray = referenceExpression.multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            Object[] $this$filter$iv = resolveResultArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (ResolveResult element$iv$iv : $this$filterTo$iv$iv) {
                ResolveResult it = element$iv$iv;
                boolean bl = false;
                if (!it.isValidResult()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResolveResult element$iv$iv;
                element$iv$iv = (ResolveResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getElement());
            }
            PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (psiElement == null) {
                return;
            }
            PsiElement resolve = psiElement;
            Project project = node.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Module module = (Module)ArraysKt.firstOrNull((Object[])ModuleManager.Companion.getInstance(project).getModules());
            if (module == null) {
                return;
            }
            Module module2 = module;
            if (resolve instanceof PsiNamedElement) {
                if (((PsiNamedElement)resolve).getName() == null) {
                    return;
                }
                VulnerableApiService vulnerableApiService = VulnerableApiService.Companion.getInstance(module2);
                String string = ((PsiNamedElement)resolve).getName();
                Intrinsics.checkNotNull((Object)string);
                if (!vulnerableApiService.isSuspiciousMethodName(string)) {
                    return;
                }
            }
            JSFunction jSFunction = ($i$f$map = JSDeclarationEvaluator.adjustDeclaration((PsiElement)resolve, (PsiElement)((PsiElement)referenceExpression))) instanceof JSFunction ? (JSFunction)$i$f$map : null;
            if (jSFunction == null) {
                return;
            }
            JSFunction resolved = jSFunction;
            String string = resolved.getQualifiedName();
            if (string == null) {
                return;
            }
            String qualifiedName = string;
            PsiFile psiFile = resolved.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            String string2 = this.retrievePath(psiFile);
            if (string2 == null) {
                return;
            }
            String path = string2;
            String surrogateFqn = path + "." + qualifiedName;
            VulnerableApiService.Companion.getInstance(module2).registerProblemIfVulnerable(surrogateFqn, this.holder, (PsiElement)node);
        }

        private final String retrievePath(PsiFile file2) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) {
                return null;
            }
            String string2 = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            return StringsKt.substringAfter$default((String)string2, (String)"/node_modules/", null, (int)2, null);
        }
    }
}

