/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.maven;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.java.library.LibraryWithMavenCoordinatesProperties;
import com.intellij.java.library.MavenCoordinates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.PackagesInterner;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.java.ProjectDependenciesModels;
import com.intellij.packageChecker.java.UnifiedDependencyNavigatable;
import com.intellij.packageChecker.maven.MavenBuildFileProvider;
import com.intellij.packageChecker.maven.MavenBuildFileProviderKt;
import com.intellij.packageChecker.maven.MavenFilesModificationTracker;
import com.intellij.packageChecker.maven.MavenProjectDependenciesModel;
import com.intellij.packageChecker.maven.MavenSharedDependenciesModel;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.ProjectSnapshot;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\u0006\u0010\u0003\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J$\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010#\u001a\u00020$H\u0016J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/packageChecker/maven/MavenProjectDependenciesModel;", "Lorg/jetbrains/idea/maven/project/MavenImportListener;", "Lcom/intellij/packageChecker/maven/MavenSharedDependenciesModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "()V", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "collectDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "mavenDependencies", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactNode;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "declaredDependencies", "Lorg/jetbrains/security/package/Package;", "Lcom/intellij/packageChecker/model/ProjectSnapshot;", "getAllModules", "", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "getMavenCoordinates", "Lcom/intellij/java/library/MavenCoordinates;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "psiFile", "Lcom/intellij/psi/PsiFile;", "importFinished", "", "importedProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "newModules", "", "scanProjectLibraries", "supports", "", "toPackages", "allCoordinates", "", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "intellij.packageChecker.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectDependenciesModel.kt\ncom/intellij/packageChecker/maven/MavenProjectDependenciesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,181:1\n1603#2,9:182\n1855#2:191\n1856#2:193\n1612#2:194\n1549#2:195\n1620#2,3:196\n1#3:192\n30#4,3:199\n*S KotlinDebug\n*F\n+ 1 MavenProjectDependenciesModel.kt\ncom/intellij/packageChecker/maven/MavenProjectDependenciesModel\n*L\n49#1:182,9\n49#1:191\n49#1:193\n49#1:194\n90#1:195\n90#1:196,3\n49#1:192\n127#1:199,3\n*E\n"})
public final class MavenProjectDependenciesModel
extends MavenSharedDependenciesModel
implements MavenImportListener {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @Nullable
    private final MavenProjectsManager mavenProjectsManager;

    public MavenProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.mavenProjectsManager = this.supports(this.project) ? MavenProjectsManager.getInstance((Project)this.project) : null;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
        this.init();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Dependency> collectDependencies(List<? extends MavenArtifactNode> mavenDependencies, VirtualFile file2, Module module) {
        void $this$mapNotNullTo$iv$iv;
        PackagesInterner interner = PackagesInterner.Companion.getInstance(this.project);
        Iterable $this$mapNotNull$iv = mavenDependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Dependency dependency;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifactNode it = (MavenArtifactNode)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            MavenArtifact mavenArtifact = it.getArtifact();
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"getArtifact(...)");
            if (MavenBuildFileProviderKt.createPackage(mavenArtifact) == null) {
                dependency = null;
            } else {
                Package rawPkg;
                Package pkg = interner.intern(rawPkg);
                List list = it.getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
                dependency = new Dependency(pkg, this.collectDependencies(list, file2, module), arg_0 -> MavenProjectDependenciesModel.collectDependencies$lambda$1$lambda$0(module, pkg, file2, arg_0));
            }
            if (dependency == null) continue;
            Dependency it$iv$iv = dependency;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public void importFinished(@NotNull Collection<MavenProject> importedProjects, @NotNull List<Module> newModules) {
        Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
        Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
        this.logger.info("import finished:" + CollectionsKt.joinToString$default((Iterable)importedProjects, null, null, null, (int)0, null, (Function1)importFinished.1.INSTANCE, (int)31, null));
        this.refresh(this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        void $this$mapTo$iv$iv;
        this.logger.info("Start collecting all modules");
        MavenProjectsManager mavenProjectsManager = this.mavenProjectsManager;
        if ((mavenProjectsManager != null ? mavenProjectsManager.getProjectsTree() : null) == null) {
            return CollectionsKt.emptyList();
        }
        List list = this.mavenProjectsManager.getNonIgnoredProjects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNonIgnoredProjects(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VirtualFile buildFile;
            String moduleId;
            void mavenProject;
            MavenProject mavenProject2 = (MavenProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject.getMavenId().getKey(), (String)"getKey(...)");
            Module module = (Module)ReadAction.compute(() -> MavenProjectDependenciesModel.getAllModules$lambda$3$lambda$2(this, (MavenProject)mavenProject));
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject.getFile(), (String)"getFile(...)");
            if (this.logger.isDebugEnabled()) {
                Module module2 = module;
                this.logger.debug("Module: " + moduleId + ", platform module: " + (module2 != null ? module2.getName() : null) + ", buildFile: " + buildFile);
            }
            List list2 = mavenProject.getDependencyTree();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDependencyTree(...)");
            VirtualFile virtualFile = mavenProject.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            Set<Dependency> collectDependencies2 = this.collectDependencies(list2, virtualFile, module);
            MutableModuleModel newModel = new MutableModuleModel(moduleId, module, buildFile, CollectionsKt.toSet((Iterable)collectDependencies2), this.project);
            collection.add(newModel);
        }
        List moduleModels = (List)destination$iv$iv;
        this.logger.info("Finish collecting all modules, count of found modules: " + moduleModels.size());
        return moduleModels;
    }

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectDependenciesModels.INSTANCE.isProjectOfSystem(project, ProjectDependenciesModels.INSTANCE.getMAVEN_SYSTEM_ID());
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((MavenBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(MavenBuildFileProvider.class, (AreaInstance)this.project)).supports(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((MavenBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(MavenBuildFileProvider.class, (AreaInstance)this.project)).supports(module);
    }

    @Override
    @NotNull
    protected ModificationTracker getModificationTracker(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MavenFilesModificationTracker> serviceClass$iv = MavenFilesModificationTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return (ModificationTracker)object;
    }

    @Override
    @NotNull
    public List<Package> declaredDependencies(@NotNull ProjectSnapshot project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ReadAction.compute(() -> MavenProjectDependenciesModel.declaredDependencies$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    private final List<Package> scanProjectLibraries() {
        Set allCoordinates = new LinkedHashSet();
        OrderEnumerator.orderEntries((Project)this.project).forEachLibrary(arg_0 -> MavenProjectDependenciesModel.scanProjectLibraries$lambda$5((Function1)new Function1<Library, Boolean>(this, (Set<UnifiedCoordinates>)allCoordinates){
            final /* synthetic */ MavenProjectDependenciesModel this$0;
            final /* synthetic */ Set<UnifiedCoordinates> $allCoordinates;
            {
                this.this$0 = $receiver;
                this.$allCoordinates = $allCoordinates;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library lib) {
                Intrinsics.checkNotNull((Object)lib);
                MavenCoordinates gav = MavenProjectDependenciesModel.access$getMavenCoordinates(this.this$0, lib);
                if (gav != null) {
                    this.$allCoordinates.add(new UnifiedCoordinates(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
                }
                return true;
            }
        }, arg_0));
        return this.toPackages(allCoordinates);
    }

    private final MavenCoordinates getMavenCoordinates(Library library) {
        LibraryProperties libraryProperties;
        if (library instanceof LibraryEx && (libraryProperties = ((LibraryEx)library).getProperties()) instanceof LibraryWithMavenCoordinatesProperties) {
            return ((LibraryWithMavenCoordinatesProperties)libraryProperties).getMavenCoordinates();
        }
        return null;
    }

    private final List<Package> toPackages(Collection<UnifiedCoordinates> allCoordinates) {
        PackagesInterner interner = PackagesInterner.Companion.getInstance(this.project);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allCoordinates), (Function1)toPackages.1.INSTANCE), (Function1)toPackages.2.INSTANCE), (Function1)((Function1)new Function1<Package, Package>(interner){
            final /* synthetic */ PackagesInterner $interner;
            {
                this.$interner = $interner;
                super(1);
            }

            @NotNull
            public final Package invoke(@NotNull Package it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$interner.intern(it);
            }
        })));
    }

    private static final Object collectDependencies$lambda$1$lambda$0(Module $module, Package $pkg, VirtualFile $file, String dataId) {
        Intrinsics.checkNotNullParameter((Object)$pkg, (String)"$pkg");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ProgressManager.checkCanceled();
        return CommonDataKeys.NAVIGATABLE.is(dataId) ? ($module != null ? new UnifiedDependencyNavigatable($module, $pkg, $file) : null) : (PlatformCoreDataKeys.MODULE.is(dataId) ? $module : null);
    }

    private static final Module getAllModules$lambda$3$lambda$2(MavenProjectDependenciesModel this$0, MavenProject $mavenProject) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.mavenProjectsManager.findModule($mavenProject);
    }

    private static final List declaredDependencies$lambda$4(MavenProjectDependenciesModel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.scanProjectLibraries();
    }

    private static final boolean scanProjectLibraries$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ MavenCoordinates access$getMavenCoordinates(MavenProjectDependenciesModel $this, Library library) {
        return $this.getMavenCoordinates(library);
    }
}

