/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.fix.FixUtilKt;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/fix/GradleWithTypeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "getNewParameterList", "closure", "Lcom/intellij/psi/PsiElement;", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleWithTypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleWithTypeFix.kt\norg/jetbrains/plugins/gradle/codeInspection/fix/GradleWithTypeFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,46:1\n60#2,2:47\n*S KotlinDebug\n*F\n+ 1 GradleWithTypeFix.kt\norg/jetbrains/plugins/gradle/codeInspection/fix/GradleWithTypeFix\n*L\n25#1:47,2\n*E\n"})
public final class GradleWithTypeFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message((String)"intention.family.name.replace.keywords", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getName() {
        String string = GradleInspectionBundle.message("intention.name.add.configure.each", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiElement $this$parentOfType_u24default$iv = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrMethodCall.class, (boolean)true);
        if (grMethodCall == null) {
            return;
        }
        GrMethodCall methodCall = grMethodCall;
        String template = !FixUtilKt.isReturnTypeValueUsed((PsiElement)methodCall) ? "%s.configureEach%s" : "%s.tap { configureEach%s }";
        PsiElement psiElement2 = FixUtilKt.deleteSecondArgument(methodCall);
        if (psiElement2 == null) {
            return;
        }
        PsiElement closure = psiElement2;
        String newParameterList = this.getNewParameterList(closure);
        String string = template;
        Object[] objectArray = new Object[]{methodCall.getText(), newParameterList};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        String representation = string2;
        GrExpression grExpression = GroovyPsiElementFactory.getInstance((Project)methodCall.getProject()).createExpressionFromText((CharSequence)representation);
        Intrinsics.checkNotNull((Object)grExpression, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall");
        GrMethodCall newCall = (GrMethodCall)grExpression;
        methodCall.replace((PsiElement)newCall);
    }

    private final String getNewParameterList(PsiElement closure) {
        if (closure instanceof GrClosableBlock) {
            return " " + ((GrClosableBlock)closure).getText();
        }
        return "(" + closure.getText() + ")";
    }
}

