/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalModuleBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DependencyAccessorsModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public final class BuildClasspathModuleGradleDataService
extends AbstractProjectDataService<BuildScriptClasspathData, Module> {
    private static final Logger LOG = Logger.getInstance(BuildClasspathModuleGradleDataService.class);

    @NotNull
    public Key<BuildScriptClasspathData> getTargetDataKey() {
        Key key = BuildScriptClasspathData.KEY;
        if (key == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<? extends DataNode<BuildScriptClasspathData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            BuildClasspathModuleGradleDataService.$$$reportNull$$$0(3);
        }
        if (projectData == null || toImport.isEmpty()) {
            return;
        }
        GradleInstallationManager gradleInstallationManager = GradleInstallationManager.getInstance();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemLocalSettings localSettings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        String linkedExternalProjectPath = projectData.getLinkedExternalProjectPath();
        File gradleHomeDir = ((BuildScriptClasspathData)toImport.iterator().next().getData()).getGradleHomeDir();
        GradleLocalSettings gradleLocalSettings = GradleLocalSettings.getInstance((Project)project);
        if (gradleHomeDir != null) {
            gradleLocalSettings.setGradleHome(linkedExternalProjectPath, gradleHomeDir.getPath());
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(linkedExternalProjectPath);
        HashSetInterner interner = new HashSetInterner();
        NotNullLazyValue externalProjectGradleSdkLibs = NotNullLazyValue.lazy(() -> BuildClasspathModuleGradleDataService.lambda$importData$0(gradleInstallationManager, project, linkedExternalProjectPath, (Interner)interner));
        HashMap<String, ExternalProjectBuildClasspathPojo> localProjectBuildClasspath = new HashMap<String, ExternalProjectBuildClasspathPojo>(localSettings.getProjectBuildClasspath());
        for (DataNode<BuildScriptClasspathData> dataNode : toImport) {
            DataNode dependenciesAccessorsModelNode;
            DataNode moduleDataNode;
            if (!GradleConstants.SYSTEM_ID.equals((Object)((BuildScriptClasspathData)dataNode.getData()).getOwner()) || (moduleDataNode = ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.MODULE)) == null) continue;
            String externalModulePath = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            if (settings == null || settings.getDistributionType() == null) {
                LOG.warn("Gradle SDK distribution type was not configured for the project at " + linkedExternalProjectPath);
            }
            LinkedHashSet<String> buildClasspathSources = new LinkedHashSet<String>();
            LinkedHashSet<String> buildClasspathClasses = new LinkedHashSet<String>();
            BuildScriptClasspathData buildScriptClasspathData = (BuildScriptClasspathData)dataNode.getData();
            for (BuildScriptClasspathData.ClasspathEntry classpathEntry : buildScriptClasspathData.getClasspathEntries()) {
                for (String path : classpathEntry.getSourcesFile()) {
                    buildClasspathSources.add(FileUtil.toCanonicalPath((String)path));
                }
                for (String path : classpathEntry.getClassesFile()) {
                    buildClasspathClasses.add(FileUtil.toCanonicalPath((String)path));
                }
            }
            ExternalProjectBuildClasspathPojo projectBuildClasspathPojo = (ExternalProjectBuildClasspathPojo)localProjectBuildClasspath.get(linkedExternalProjectPath);
            if (projectBuildClasspathPojo == null) {
                projectBuildClasspathPojo = new ExternalProjectBuildClasspathPojo(((ModuleData)moduleDataNode.getData()).getExternalName(), new ArrayList(), new HashMap());
                localProjectBuildClasspath.put(linkedExternalProjectPath, projectBuildClasspathPojo);
            }
            projectBuildClasspathPojo.setProjectBuildClasspath((List)externalProjectGradleSdkLibs.getValue());
            List buildClasspath = new ArrayList<String>(buildClasspathSources.size() + buildClasspathClasses.size());
            buildClasspath.addAll(buildClasspathSources);
            buildClasspath.addAll(buildClasspathClasses);
            buildClasspath = (List)interner.intern(buildClasspath);
            projectBuildClasspathPojo.getModulesBuildClasspath().put(externalModulePath, new ExternalModuleBuildClasspathPojo(externalModulePath, buildClasspath));
            DataNode projectDataNode = ExternalSystemApiUtil.findParent((DataNode)moduleDataNode, (Key)ProjectKeys.PROJECT);
            if (projectDataNode == null || (dependenciesAccessorsModelNode = ExternalSystemApiUtil.find((DataNode)projectDataNode, (Key)BuildScriptClasspathData.ACCESSORS)) == null) continue;
            DependencyAccessorsModel accessorsModel = (DependencyAccessorsModel)dependenciesAccessorsModelNode.getData();
            buildClasspath.addAll(accessorsModel.getSources());
            buildClasspath.addAll(accessorsModel.getClasses());
        }
        localSettings.setProjectBuildClasspath(localProjectBuildClasspath);
        if (!project.isDisposed()) {
            GradleBuildClasspathManager.getInstance(project).reload();
        }
    }

    private static /* synthetic */ List lambda$importData$0(GradleInstallationManager gradleInstallationManager, Project project, String linkedExternalProjectPath, Interner interner) {
        List libraries;
        LinkedHashSet<String> gradleSdkLibraries = new LinkedHashSet<String>();
        File gradleHome = gradleInstallationManager.getGradleHome(project, linkedExternalProjectPath);
        if (gradleHome != null && gradleHome.isDirectory() && (libraries = gradleInstallationManager.getClassRoots(project, linkedExternalProjectPath)) != null) {
            for (File library : libraries) {
                gradleSdkLibraries.add(FileUtil.toCanonicalPath((String)library.getPath()));
            }
        }
        return (List)interner.intern(new ArrayList(gradleSdkLibraries));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/BuildClasspathModuleGradleDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

