/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.toml;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.toml.GradleVersionCatalogTomlAwareGotoDeclarationHandler;
import org.jetbrains.plugins.gradle.toml.UtilKt;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "GroovyVersionCatalogReference", "MyProcessor", "intellij.gradle.java"})
public final class GradleGroovyVersionCatalogReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public GradleGroovyVersionCatalogReferencesSearcher() {
        super(false);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiElement psiElement = queryParameters.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
        PsiElement element = psiElement;
        if (!(element instanceof TomlKeySegment)) {
            return;
        }
        Pair pair = (Pair)ActionsKt.runReadAction((Function0)((Function0)new Function0<Pair<? extends TomlKeyValue, ? extends String>>(element){
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super(0);
            }

            @NotNull
            public final Pair<TomlKeyValue, String> invoke() {
                PsiElement $this$parentOfType_u24default$iv = this.$element;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                return TuplesKt.to((Object)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlKeyValue.class, (boolean)true), (Object)((TomlKeySegment)this.$element).getName());
            }
        }));
        TomlKeyValue keyValue = (TomlKeyValue)pair.component1();
        String name = (String)pair.component2();
        if (keyValue == null) {
            return;
        }
        Object object = name;
        if (object == null || (object = UtilKt.getVersionCatalogParts((String)object)) == null) {
            return;
        }
        Object nameParts = object;
        String string = (String)CollectionsKt.lastOrNull((List)nameParts);
        if (string == null) {
            return;
        }
        String identifier = string;
        String string2 = PropertyUtilBase.getAccessorName((String)identifier, (PropertyKind)PropertyKind.GETTER);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccessorName(...)");
        String getter = string2;
        SearchScope searchScope = GroovyScopeUtil.restrictScopeToGroovyFiles((SearchScope)queryParameters.getEffectiveSearchScope());
        short searchContext = 1;
        MyProcessor processor = new MyProcessor(keyValue, (List<String>)nameParts);
        Function1 search2 = (Function1)new Function1<String, Unit>(queryParameters, searchScope, searchContext, element, processor){
            final /* synthetic */ ReferencesSearch.SearchParameters $queryParameters;
            final /* synthetic */ SearchScope $searchScope;
            final /* synthetic */ short $searchContext;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ MyProcessor $processor;
            {
                this.$queryParameters = $queryParameters;
                this.$searchScope = $searchScope;
                this.$searchContext = $searchContext;
                this.$element = $element;
                this.$processor = $processor;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$queryParameters.getOptimizer().searchWord(it, this.$searchScope, this.$searchContext, true, this.$element, (RequestResultProcessor)this.$processor);
            }
        };
        search2.invoke((Object)identifier);
        search2.invoke((Object)getter);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$GroovyVersionCatalogReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "refExpr", "oldNameParts", "", "", "searchedElement", "Lorg/toml/lang/psi/TomlKeyValue;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Ljava/util/List;Lorg/toml/lang/psi/TomlKeyValue;)V", "getOldNameParts", "()Ljava/util/List;", "getSearchedElement", "()Lorg/toml/lang/psi/TomlKeyValue;", "getActualReferencingElement", "Lcom/intellij/psi/PsiElement;", "elem", "handleElementRename", "newElementName", "resolve", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nGradleGroovyVersionCatalogReferencesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$GroovyVersionCatalogReference\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,97:1\n14#2:98\n*S KotlinDebug\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$GroovyVersionCatalogReference\n*L\n74#1:98\n*E\n"})
    private static final class GroovyVersionCatalogReference
    extends PsiReferenceBase<GrReferenceExpression> {
        @NotNull
        private final List<String> oldNameParts;
        @NotNull
        private final TomlKeyValue searchedElement;

        public GroovyVersionCatalogReference(@NotNull GrReferenceExpression refExpr, @NotNull List<String> oldNameParts, @NotNull TomlKeyValue searchedElement) {
            Intrinsics.checkNotNullParameter((Object)refExpr, (String)"refExpr");
            Intrinsics.checkNotNullParameter(oldNameParts, (String)"oldNameParts");
            Intrinsics.checkNotNullParameter((Object)searchedElement, (String)"searchedElement");
            super((PsiElement)refExpr);
            this.oldNameParts = oldNameParts;
            this.searchedElement = searchedElement;
        }

        @NotNull
        public final List<String> getOldNameParts() {
            return this.oldNameParts;
        }

        @NotNull
        public final TomlKeyValue getSearchedElement() {
            return this.searchedElement;
        }

        @NotNull
        public PsiElement resolve() {
            return (PsiElement)this.searchedElement;
        }

        @NotNull
        public PsiElement handleElementRename(@NotNull String newElementName) {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            List<String> parts = UtilKt.getVersionCatalogParts(newElementName);
            PsiElement referencingElement = null;
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            referencingElement = psiElement;
            int n = this.oldNameParts.size();
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                GrExpression qualifier = ((GrReferenceExpression)referencingElement).getQualifierExpression();
                if (qualifier instanceof GrMethodCall) {
                    GrExpression $this$asSafely$iv = ((GrMethodCall)qualifier).getInvokedExpression();
                    boolean $i$f$asSafely = false;
                    GrExpression grExpression = $this$asSafely$iv;
                    if (!(grExpression instanceof GrReferenceExpression)) {
                        grExpression = null;
                    }
                    if ((GrReferenceExpression)grExpression != null) continue;
                    PsiElement psiElement2 = this.getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
                    return psiElement2;
                }
                if (qualifier instanceof GrReferenceExpression) {
                    referencingElement = qualifier;
                    continue;
                }
                PsiElement psiElement3 = this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getElement(...)");
                return psiElement3;
            }
            PsiElement psiElement4 = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getElement(...)");
            PsiElement elementToReplace = this.getActualReferencingElement(psiElement4);
            PsiElement rootElement = this.getActualReferencingElement(referencingElement);
            Object newElementText = rootElement.getText();
            for (String newPart : parts) {
                newElementText = (String)newElementText + "." + newPart;
            }
            GrExpression grExpression = GroovyPsiElementFactory.getInstance((Project)((GrReferenceExpression)this.getElement()).getProject()).createExpressionFromText((CharSequence)newElementText);
            Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"createExpressionFromText(...)");
            GrExpression newElement2 = grExpression;
            PsiElement psiElement5 = elementToReplace.replace((PsiElement)newElement2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"replace(...)");
            return psiElement5;
        }

        private final PsiElement getActualReferencingElement(PsiElement elem) {
            PsiElement psiElement;
            if (elem.getParent() instanceof GrMethodCall) {
                PsiElement psiElement2 = elem.getParent();
                Intrinsics.checkNotNull((Object)psiElement2);
                psiElement = psiElement2;
            } else {
                psiElement = elem;
            }
            return psiElement;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$MyProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "searchedElement", "Lorg/toml/lang/psi/TomlKeyValue;", "oldNameParts", "", "", "(Lorg/toml/lang/psi/TomlKeyValue;Ljava/util/List;)V", "processTextOccurrence", "", "element", "Lcom/intellij/psi/PsiElement;", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nGradleGroovyVersionCatalogReferencesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$MyProcessor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,97:1\n60#2,2:98\n*S KotlinDebug\n*F\n+ 1 GradleGroovyVersionCatalogReferencesSearcher.kt\norg/jetbrains/plugins/gradle/service/toml/GradleGroovyVersionCatalogReferencesSearcher$MyProcessor\n*L\n53#1:98,2\n*E\n"})
    public static final class MyProcessor
    extends RequestResultProcessor {
        @NotNull
        private final TomlKeyValue searchedElement;
        @NotNull
        private final List<String> oldNameParts;

        public MyProcessor(@NotNull TomlKeyValue searchedElement, @NotNull List<String> oldNameParts) {
            Intrinsics.checkNotNullParameter((Object)searchedElement, (String)"searchedElement");
            Intrinsics.checkNotNullParameter(oldNameParts, (String)"oldNameParts");
            super(new Object[0]);
            this.searchedElement = searchedElement;
            this.oldNameParts = oldNameParts;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            GrReferenceExpression grReferenceExpression = (GrReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrReferenceExpression.class, (boolean)true);
            if (grReferenceExpression == null) {
                return true;
            }
            GrReferenceExpression parent = grReferenceExpression;
            GradleVersionCatalogTomlAwareGotoDeclarationHandler handler = new GradleVersionCatalogTomlAwareGotoDeclarationHandler();
            Object[] gotoDeclarationTargets = handler.getGotoDeclarationTargets(element, 0, null);
            if (Intrinsics.areEqual((Object)(gotoDeclarationTargets != null ? (PsiElement)ArraysKt.singleOrNull((Object[])gotoDeclarationTargets) : null), (Object)this.searchedElement)) {
                return consumer.process((Object)new GroovyVersionCatalogReference(parent, this.oldNameParts, this.searchedElement));
            }
            return true;
        }
    }
}

