/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00012B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J \u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020\u001bH\u0016J\b\u0010*\u001a\u00020\u001bH\u0016J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0010H\u0016J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u0010H\u0016J\u0012\u00100\u001a\u00020\u001b2\b\u00101\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u00100\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$CursorListener;", "Lcom/intellij/openapi/Disposable;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "<set-?>", "Lcom/intellij/openapi/editor/LogicalPosition;", "caretPosition", "getCaretPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "", "isBlinking", "()Z", "listeners", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretListener;", "terminalModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getTerminalModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "addListener", "", "listener", "disposable", "calculateCaretPosition", "cursorX", "", "cursorY", "commandFinished", "command", "", "exitCode", "duration", "", "commandStarted", "dispose", "initialized", "onBlinkingChanged", "blinking", "onPositionChanged", "onVisibilityChanged", "visible", "updateCaretPosition", "newPosition", "CaretListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCaretModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCaretModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalCaretModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n1855#2,2:101\n*S KotlinDebug\n*F\n+ 1 TerminalCaretModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalCaretModel\n*L\n54#1:99,2\n86#1:101,2\n*E\n"})
public final class TerminalCaretModel
implements ShellCommandListener,
TerminalModel.CursorListener,
Disposable {
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<CaretListener> listeners;
    @Nullable
    private volatile LogicalPosition caretPosition;
    private volatile boolean isBlinking;

    public TerminalCaretModel(@NotNull TerminalSession session2, @NotNull TerminalOutputModel outputModel, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.session = session2;
        this.outputModel = outputModel;
        this.editor = editor;
        this.listeners = new CopyOnWriteArrayList();
        this.caretPosition = new LogicalPosition(0, 0);
        this.isBlinking = this.getTerminalModel().isCursorBlinking();
        this.session.addCommandListener(this, this);
        this.getTerminalModel().addCursorListener(this, this);
    }

    private final TerminalModel getTerminalModel() {
        return this.session.getModel();
    }

    @Nullable
    public final LogicalPosition getCaretPosition() {
        return this.caretPosition;
    }

    public final boolean isBlinking() {
        return this.isBlinking;
    }

    public final void addListener(@NotNull CaretListener listener, @Nullable Disposable disposable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.listeners.add(listener);
            Disposable disposable2 = disposable;
            if (disposable2 == null) break block0;
            Disposable it = disposable2;
            boolean bl = false;
            Disposer.register((Disposable)it, () -> TerminalCaretModel.addListener$lambda$1$lambda$0(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalCaretModel terminalCaretModel, CaretListener caretListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalCaretModel.addListener(caretListener, disposable);
    }

    @Override
    public void onPositionChanged(int cursorX, int cursorY) {
        if (this.getTerminalModel().isCommandRunning() && this.getTerminalModel().isCursorVisible()) {
            this.updateCaretPosition(cursorX, cursorY);
        } else {
            this.updateCaretPosition(null);
        }
    }

    @Override
    public void onVisibilityChanged(boolean visible) {
        if (visible) {
            this.updateCaretPosition(this.getTerminalModel().getCursorX(), this.getTerminalModel().getCursorY());
        } else {
            this.updateCaretPosition(null);
        }
    }

    @Override
    public void onBlinkingChanged(boolean blinking) {
        this.isBlinking = blinking;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CaretListener it = (CaretListener)element$iv;
            boolean bl = false;
            it.caretBlinkingChanged(blinking);
        }
    }

    @Override
    public void commandStarted(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        LogicalPosition position = this.calculateCaretPosition(0, 1);
        this.updateCaretPosition(position);
    }

    @Override
    public void commandFinished(@NotNull String command, int exitCode, long duration) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.updateCaretPosition(null);
    }

    @Override
    public void initialized() {
        this.updateCaretPosition(null);
    }

    private final LogicalPosition calculateCaretPosition(int cursorX, int cursorY) {
        CommandBlock commandBlock = this.outputModel.getLastBlock();
        if (commandBlock == null) {
            throw new IllegalStateException("No active block".toString());
        }
        CommandBlock lastBlock = commandBlock;
        int blockStartLine = this.editor.getDocument().getLineNumber(lastBlock.getStartOffset());
        int blockLine = this.getTerminalModel().getHistoryLinesCount() + cursorY - 1;
        return new LogicalPosition(blockStartLine + blockLine, cursorX);
    }

    private final void updateCaretPosition(int cursorX, int cursorY) {
        LogicalPosition position = this.calculateCaretPosition(cursorX, cursorY);
        this.updateCaretPosition(position);
    }

    private final void updateCaretPosition(LogicalPosition newPosition) {
        LogicalPosition oldPosition = this.caretPosition;
        this.caretPosition = newPosition;
        if (!Intrinsics.areEqual((Object)newPosition, (Object)oldPosition)) {
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CaretListener it = (CaretListener)element$iv;
                boolean bl = false;
                it.caretPositionChanged(oldPosition, newPosition);
            }
        }
    }

    public void dispose() {
    }

    private static final void addListener$lambda$1$lambda$0(TerminalCaretModel this$0, CaretListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001c\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel$CaretListener;", "", "caretBlinkingChanged", "", "isBlinking", "", "caretPositionChanged", "oldPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "newPosition", "intellij.terminal"})
    public static interface CaretListener {
        default public void caretPositionChanged(@Nullable LogicalPosition oldPosition, @Nullable LogicalPosition newPosition) {
        }

        default public void caretBlinkingChanged(boolean isBlinking) {
        }
    }
}

