/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalOutputView;
import org.jetbrains.plugins.terminal.exp.TerminalPromptView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007J\b\u0010\u0010\u001a\u00020\nH\u0007J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "outputView", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;", "promptView", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;)V", "addPromptFocusListener", "", "focusListener", "Ljava/awt/event/FocusListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "focusOutput", "focusPrompt", "requestFocus", "target", "Ljavax/swing/JComponent;", "intellij.terminal"})
public final class TerminalFocusModel {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalOutputView outputView;
    @NotNull
    private final TerminalPromptView promptView;

    public TerminalFocusModel(@NotNull Project project, @NotNull TerminalOutputView outputView, @NotNull TerminalPromptView promptView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)outputView, (String)"outputView");
        Intrinsics.checkNotNullParameter((Object)promptView, (String)"promptView");
        this.project = project;
        this.outputView = outputView;
        this.promptView = promptView;
    }

    @RequiresEdt
    public final void focusOutput() {
        this.requestFocus(this.outputView.getPreferredFocusableComponent());
    }

    @RequiresEdt
    public final void focusPrompt() {
        this.requestFocus(this.promptView.getPreferredFocusableComponent());
    }

    @RequiresEdt
    public final void addPromptFocusListener(@NotNull FocusListener focusListener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)focusListener, (String)"focusListener");
        RevertOnDisposeUtilKt.addFocusListener((Component)this.promptView.getPreferredFocusableComponent(), (Disposable)disposable, (FocusListener)focusListener);
    }

    public static /* synthetic */ void addPromptFocusListener$default(TerminalFocusModel terminalFocusModel, FocusListener focusListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalFocusModel.addPromptFocusListener(focusListener, disposable);
    }

    private final void requestFocus(JComponent target) {
        if (!target.hasFocus()) {
            IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)target, true);
        }
    }
}

